// third_party/blink/public/mojom/autoplay/autoplay.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/autoplay/autoplay.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/autoplay/autoplay.mojom-params-data.h"
#include "third_party/blink/public/mojom/autoplay/autoplay.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/autoplay/autoplay.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AUTOPLAY_AUTOPLAY_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AUTOPLAY_AUTOPLAY_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char AutoplayConfigurationClient::Name_[] = "blink.mojom.AutoplayConfigurationClient";

AutoplayConfigurationClientProxy::AutoplayConfigurationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutoplayConfigurationClientProxy::AddAutoplayFlags(
    const ::url::Origin& in_origin, int32_t in_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::AutoplayConfigurationClient::AddAutoplayFlags", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetInteger("flags", in_flags);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAutoplayConfigurationClient_AddAutoplayFlags_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::AutoplayConfigurationClient_AddAutoplayFlags_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in AutoplayConfigurationClient.AddAutoplayFlags request");
  params->flags = in_flags;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutoplayConfigurationClient::Name_);
  message.set_method_name("AddAutoplayFlags");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AutoplayConfigurationClientStubDispatch::Accept(
    AutoplayConfigurationClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAutoplayConfigurationClient_AddAutoplayFlags_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::AutoplayConfigurationClient::AddAutoplayFlags",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::AutoplayConfigurationClient::AddAutoplayFlags");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AutoplayConfigurationClient_AddAutoplayFlags_Params_Data* params =
          reinterpret_cast<internal::AutoplayConfigurationClient_AddAutoplayFlags_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      int32_t p_flags{};
      AutoplayConfigurationClient_AddAutoplayFlags_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_flags = input_data_view.flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutoplayConfigurationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAutoplayFlags(
std::move(p_origin), 
std::move(p_flags));
      return true;
    }
  }
  return false;
}

// static
bool AutoplayConfigurationClientStubDispatch::AcceptWithResponder(
    AutoplayConfigurationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAutoplayConfigurationClient_AddAutoplayFlags_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAutoplayConfigurationClientValidationInfo[] = {
    {&internal::AutoplayConfigurationClient_AddAutoplayFlags_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutoplayConfigurationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::AutoplayConfigurationClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAutoplayConfigurationClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif