// services/audio/public/mojom/stream_factory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace audio {
namespace mojom {
namespace internal {
class  StreamFactory_CreateInputStream_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateInputStream_Params_Data));
      new (data()) StreamFactory_CreateInputStream_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateInputStream_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateInputStream_Params_Data>(index_);
    }
    StreamFactory_CreateInputStream_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data stream;
  mojo::internal::Interface_Data client;
  mojo::internal::Interface_Data observer;
  mojo::internal::Interface_Data log;
  uint32_t shared_memory_count;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  uint8_t enable_agc : 1;
  uint8_t pad7_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> key_press_count_buffer;

 private:
  StreamFactory_CreateInputStream_Params_Data();
  ~StreamFactory_CreateInputStream_Params_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateInputStream_Params_Data) == 72,
              "Bad sizeof(StreamFactory_CreateInputStream_Params_Data)");
class  StreamFactory_CreateInputStream_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateInputStream_ResponseParams_Data));
      new (data()) StreamFactory_CreateInputStream_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateInputStream_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateInputStream_ResponseParams_Data>(index_);
    }
    StreamFactory_CreateInputStream_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadOnlyAudioDataPipe_Data> data_pipe;
  uint8_t initially_muted : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> stream_id;

 private:
  StreamFactory_CreateInputStream_ResponseParams_Data();
  ~StreamFactory_CreateInputStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateInputStream_ResponseParams_Data) == 32,
              "Bad sizeof(StreamFactory_CreateInputStream_ResponseParams_Data)");
class  StreamFactory_AssociateInputAndOutputForAec_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_AssociateInputAndOutputForAec_Params_Data));
      new (data()) StreamFactory_AssociateInputAndOutputForAec_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_AssociateInputAndOutputForAec_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_AssociateInputAndOutputForAec_Params_Data>(index_);
    }
    StreamFactory_AssociateInputAndOutputForAec_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> input_stream_id;
  mojo::internal::Pointer<mojo::internal::String_Data> output_device_id;

 private:
  StreamFactory_AssociateInputAndOutputForAec_Params_Data();
  ~StreamFactory_AssociateInputAndOutputForAec_Params_Data() = delete;
};
static_assert(sizeof(StreamFactory_AssociateInputAndOutputForAec_Params_Data) == 24,
              "Bad sizeof(StreamFactory_AssociateInputAndOutputForAec_Params_Data)");
class  StreamFactory_CreateOutputStream_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateOutputStream_Params_Data));
      new (data()) StreamFactory_CreateOutputStream_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateOutputStream_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateOutputStream_Params_Data>(index_);
    }
    StreamFactory_CreateOutputStream_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data stream;
  mojo::internal::AssociatedInterface_Data observer;
  mojo::internal::Interface_Data log;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  StreamFactory_CreateOutputStream_Params_Data();
  ~StreamFactory_CreateOutputStream_Params_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateOutputStream_Params_Data) == 56,
              "Bad sizeof(StreamFactory_CreateOutputStream_Params_Data)");
class  StreamFactory_CreateOutputStream_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateOutputStream_ResponseParams_Data));
      new (data()) StreamFactory_CreateOutputStream_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateOutputStream_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateOutputStream_ResponseParams_Data>(index_);
    }
    StreamFactory_CreateOutputStream_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadWriteAudioDataPipe_Data> data_pipe;

 private:
  StreamFactory_CreateOutputStream_ResponseParams_Data();
  ~StreamFactory_CreateOutputStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateOutputStream_ResponseParams_Data) == 16,
              "Bad sizeof(StreamFactory_CreateOutputStream_ResponseParams_Data)");
class  StreamFactory_BindMuter_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_BindMuter_Params_Data));
      new (data()) StreamFactory_BindMuter_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_BindMuter_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_BindMuter_Params_Data>(index_);
    }
    StreamFactory_BindMuter_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  StreamFactory_BindMuter_Params_Data();
  ~StreamFactory_BindMuter_Params_Data() = delete;
};
static_assert(sizeof(StreamFactory_BindMuter_Params_Data) == 24,
              "Bad sizeof(StreamFactory_BindMuter_Params_Data)");
class  StreamFactory_CreateLoopbackStream_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateLoopbackStream_Params_Data));
      new (data()) StreamFactory_CreateLoopbackStream_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateLoopbackStream_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateLoopbackStream_Params_Data>(index_);
    }
    StreamFactory_CreateLoopbackStream_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  mojo::internal::Interface_Data client;
  mojo::internal::Interface_Data observer;
  uint32_t shared_memory_count;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> group_id;

 private:
  StreamFactory_CreateLoopbackStream_Params_Data();
  ~StreamFactory_CreateLoopbackStream_Params_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateLoopbackStream_Params_Data) == 48,
              "Bad sizeof(StreamFactory_CreateLoopbackStream_Params_Data)");
class  StreamFactory_CreateLoopbackStream_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(StreamFactory_CreateLoopbackStream_ResponseParams_Data));
      new (data()) StreamFactory_CreateLoopbackStream_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    StreamFactory_CreateLoopbackStream_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<StreamFactory_CreateLoopbackStream_ResponseParams_Data>(index_);
    }
    StreamFactory_CreateLoopbackStream_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::ReadOnlyAudioDataPipe_Data> data_pipe;

 private:
  StreamFactory_CreateLoopbackStream_ResponseParams_Data();
  ~StreamFactory_CreateLoopbackStream_ResponseParams_Data() = delete;
};
static_assert(sizeof(StreamFactory_CreateLoopbackStream_ResponseParams_Data) == 16,
              "Bad sizeof(StreamFactory_CreateLoopbackStream_ResponseParams_Data)");

}  // namespace internal


class StreamFactory_CreateInputStream_ParamsDataView {
 public:
  StreamFactory_CreateInputStream_ParamsDataView() {}

  StreamFactory_CreateInputStream_ParamsDataView(
      internal::StreamFactory_CreateInputStream_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
            &data_->stream, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
            &data_->client, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
            &data_->observer, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->log, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, context_);
  }
  uint32_t shared_memory_count() const {
    return data_->shared_memory_count;
  }
  bool enable_agc() const {
    return data_->enable_agc;
  }
  inline void GetKeyPressCountBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKeyPressCountBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `key_press_count_buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyPressCountBuffer` instead "
    "of `ReadKeyPressCountBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_press_count_buffer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateInputStream_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_CreateInputStream_ResponseParamsDataView {
 public:
  StreamFactory_CreateInputStream_ResponseParamsDataView() {}

  StreamFactory_CreateInputStream_ResponseParamsDataView(
      internal::StreamFactory_CreateInputStream_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadOnlyAudioDataPipeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadOnlyAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadOnlyAudioDataPipeDataView>(
        pointer, output, context_);
  }
  bool initially_muted() const {
    return data_->initially_muted;
  }
  inline void GetStreamIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStreamId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `stream_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStreamId` instead "
    "of `ReadStreamId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stream_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateInputStream_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_AssociateInputAndOutputForAec_ParamsDataView {
 public:
  StreamFactory_AssociateInputAndOutputForAec_ParamsDataView() {}

  StreamFactory_AssociateInputAndOutputForAec_ParamsDataView(
      internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInputStreamIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputStreamId(UserType* output) {
    
    auto* pointer = data_->input_stream_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetOutputDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutputDeviceId(UserType* output) {
    
    auto* pointer = data_->output_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_CreateOutputStream_ParamsDataView {
 public:
  StreamFactory_CreateOutputStream_ParamsDataView() {}

  StreamFactory_CreateOutputStream_ParamsDataView(
      internal::StreamFactory_CreateOutputStream_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
            &data_->stream, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
            &data_->observer, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->log, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, context_);
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateOutputStream_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_CreateOutputStream_ResponseParamsDataView {
 public:
  StreamFactory_CreateOutputStream_ResponseParamsDataView() {}

  StreamFactory_CreateOutputStream_ResponseParamsDataView(
      internal::StreamFactory_CreateOutputStream_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadWriteAudioDataPipeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadWriteAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateOutputStream_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_BindMuter_ParamsDataView {
 public:
  StreamFactory_BindMuter_ParamsDataView() {}

  StreamFactory_BindMuter_ParamsDataView(
      internal::StreamFactory_BindMuter_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::audio::mojom::LocalMuterAssociatedRequestDataView>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_BindMuter_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_CreateLoopbackStream_ParamsDataView {
 public:
  StreamFactory_CreateLoopbackStream_ParamsDataView() {}

  StreamFactory_CreateLoopbackStream_ParamsDataView(
      internal::StreamFactory_CreateLoopbackStream_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
            &data_->receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
            &data_->client, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
            &data_->observer, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, context_);
  }
  uint32_t shared_memory_count() const {
    return data_->shared_memory_count;
  }
  inline void GetGroupIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateLoopbackStream_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class StreamFactory_CreateLoopbackStream_ResponseParamsDataView {
 public:
  StreamFactory_CreateLoopbackStream_ResponseParamsDataView() {}

  StreamFactory_CreateLoopbackStream_ResponseParamsDataView(
      internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataPipeDataView(
      ::media::mojom::ReadOnlyAudioDataPipeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDataPipe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ReadOnlyAudioDataPipeDataView, UserType>(),
    "Attempting to read the optional `data_pipe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDataPipe` instead "
    "of `ReadDataPipe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data_pipe.Get();
    return mojo::internal::Deserialize<::media::mojom::ReadOnlyAudioDataPipeDataView>(
        pointer, output, context_);
  }
 private:
  internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void StreamFactory_CreateInputStream_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void StreamFactory_CreateInputStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, context_);
}
inline void StreamFactory_CreateInputStream_ParamsDataView::GetKeyPressCountBufferDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->key_press_count_buffer.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, context_);
}


inline void StreamFactory_CreateInputStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadOnlyAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadOnlyAudioDataPipeDataView(pointer, context_);
}
inline void StreamFactory_CreateInputStream_ResponseParamsDataView::GetStreamIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->stream_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void StreamFactory_AssociateInputAndOutputForAec_ParamsDataView::GetInputStreamIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->input_stream_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void StreamFactory_AssociateInputAndOutputForAec_ParamsDataView::GetOutputDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->output_device_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void StreamFactory_CreateOutputStream_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void StreamFactory_CreateOutputStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, context_);
}
inline void StreamFactory_CreateOutputStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void StreamFactory_CreateOutputStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadWriteAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadWriteAudioDataPipeDataView(pointer, context_);
}


inline void StreamFactory_BindMuter_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void StreamFactory_CreateLoopbackStream_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, context_);
}
inline void StreamFactory_CreateLoopbackStream_ParamsDataView::GetGroupIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void StreamFactory_CreateLoopbackStream_ResponseParamsDataView::GetDataPipeDataView(
    ::media::mojom::ReadOnlyAudioDataPipeDataView* output) {
  auto pointer = data_->data_pipe.Get();
  *output = ::media::mojom::ReadOnlyAudioDataPipeDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace audio

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_STREAM_FACTORY_MOJOM_PARAMS_DATA_H_