// Copyright (c) 2025 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "qtwebengine/browser/extensions/api/generated_api_registration.h"

#include "build/build_config.h"
#include "build/chromeos_buildflags.h"

#include "qtwebengine/browser/extensions/api/resources_private/resources_private_api.h"
#include "qtwebengine/browser/extensions/api/webrtc_desktop_capture_private/webrtc_desktop_capture_private_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void QtWebEngineGeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<ResourcesPrivateGetStringsFunction>,
      ResourcesPrivateGetStringsFunction::function_name(),
      ResourcesPrivateGetStringsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcDesktopCapturePrivateChooseDesktopMediaFunction>,
      WebrtcDesktopCapturePrivateChooseDesktopMediaFunction::function_name(),
      WebrtcDesktopCapturePrivateChooseDesktopMediaFunction::histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
