// extensions/common/mojom/guest_view.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "extensions/common/mojom/guest_view.mojom-shared.h"
#include "extensions/common/mojom/guest_view.mojom-forward.h"
#include "extensions/common/api/mime_handler.mojom.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace extensions {
namespace mojom {

class GuestViewProxy;

template <typename ImplRefTraits>
class GuestViewStub;

class GuestViewRequestValidator;


class  GuestView
    : public GuestViewInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = GuestViewInterfaceBase;
  using Proxy_ = GuestViewProxy;

  template <typename ImplRefTraits>
  using Stub_ = GuestViewStub<ImplRefTraits>;

  using RequestValidator_ = GuestViewRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateEmbeddedMimeHandlerViewGuestMinVersion = 0,
    kCreateMimeHandlerViewGuestMinVersion = 0,
    kReadyToCreateMimeHandlerViewMinVersion = 0,
  };
  virtual ~GuestView() {}

  
  virtual void CreateEmbeddedMimeHandlerViewGuest(int32_t render_frame_id, int32_t tab_id, const ::GURL& original_url, int32_t element_instance_id, const ::gfx::Size& element_size, ::blink::mojom::TransferrableURLLoaderPtr transferrable_url_loader) = 0;

  
  virtual void CreateMimeHandlerViewGuest(int32_t render_frame_id, const std::string& view_id, int32_t element_instance_id, const ::gfx::Size& element_size, ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> before_unload_control) = 0;

  
  virtual void ReadyToCreateMimeHandlerView(int32_t routing_id, bool success) = 0;
};

class MimeHandlerViewContainerManagerProxy;

template <typename ImplRefTraits>
class MimeHandlerViewContainerManagerStub;

class MimeHandlerViewContainerManagerRequestValidator;
class MimeHandlerViewContainerManagerResponseValidator;


class  MimeHandlerViewContainerManager
    : public MimeHandlerViewContainerManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MimeHandlerViewContainerManagerInterfaceBase;
  using Proxy_ = MimeHandlerViewContainerManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MimeHandlerViewContainerManagerStub<ImplRefTraits>;

  using RequestValidator_ = MimeHandlerViewContainerManagerRequestValidator;
  using ResponseValidator_ = MimeHandlerViewContainerManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetInternalIdMinVersion = 0,
    kLoadEmptyPageMinVersion = 0,
    kCreateBeforeUnloadControlMinVersion = 0,
    kDestroyFrameContainerMinVersion = 0,
    kDidLoadMinVersion = 0,
  };
  virtual ~MimeHandlerViewContainerManager() {}

  
  virtual void SetInternalId(const std::string& token_id) = 0;

  
  virtual void LoadEmptyPage(const ::GURL& resource_url) = 0;


  using CreateBeforeUnloadControlCallback = base::OnceCallback<void(::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>)>;
  
  virtual void CreateBeforeUnloadControl(CreateBeforeUnloadControlCallback callback) = 0;

  
  virtual void DestroyFrameContainer(int32_t element_instance_id) = 0;

  
  virtual void DidLoad(int32_t mime_handler_view_guest_element_instance_id, const ::GURL& resource_url) = 0;
};



class  GuestViewProxy
    : public GuestView {
 public:
  using InterfaceType = GuestView;

  explicit GuestViewProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateEmbeddedMimeHandlerViewGuest(int32_t render_frame_id, int32_t tab_id, const ::GURL& original_url, int32_t element_instance_id, const ::gfx::Size& element_size, ::blink::mojom::TransferrableURLLoaderPtr transferrable_url_loader) final;
  
  void CreateMimeHandlerViewGuest(int32_t render_frame_id, const std::string& view_id, int32_t element_instance_id, const ::gfx::Size& element_size, ::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl> before_unload_control) final;
  
  void ReadyToCreateMimeHandlerView(int32_t routing_id, bool success) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MimeHandlerViewContainerManagerProxy
    : public MimeHandlerViewContainerManager {
 public:
  using InterfaceType = MimeHandlerViewContainerManager;

  explicit MimeHandlerViewContainerManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInternalId(const std::string& token_id) final;
  
  void LoadEmptyPage(const ::GURL& resource_url) final;
  
  void CreateBeforeUnloadControl(CreateBeforeUnloadControlCallback callback) final;
  
  void DestroyFrameContainer(int32_t element_instance_id) final;
  
  void DidLoad(int32_t mime_handler_view_guest_element_instance_id, const ::GURL& resource_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GuestViewStubDispatch {
 public:
  static bool Accept(GuestView* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GuestView* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GuestView>>
class GuestViewStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GuestViewStub() {}
  ~GuestViewStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MimeHandlerViewContainerManagerStubDispatch {
 public:
  static bool Accept(MimeHandlerViewContainerManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MimeHandlerViewContainerManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MimeHandlerViewContainerManager>>
class MimeHandlerViewContainerManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MimeHandlerViewContainerManagerStub() {}
  ~MimeHandlerViewContainerManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerViewContainerManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerViewContainerManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GuestViewRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MimeHandlerViewContainerManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MimeHandlerViewContainerManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace extensions

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_