// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A0__F24

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 64, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 128, "BLOCK_N": 128, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 64, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 128, .BLOCK_N = 128, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_32_T_F_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx950)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x5e1c5ff4u, 0xadb6fe4bu, 33, 65 }, // 5e1c5ff4adb6fe4b = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xfa1911fcu, 0x787566cfu, 99, 65 }, // fa1911fc787566cf = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x5294fe87u, 0x57ec4888u, 99, 82 }, // 5294fe8757ec4888 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x4775da82u, 0xdaa10437u, 115, 65 }, // 4775da82daa10437 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_32_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x33c550cfu, 0xf53a4d38u, 115, 82 }, // 33c550cff53a4d38 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_32_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x6c791fe1u, 0x12d894abu, 115, 16 }, // 6c791fe112d894ab = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_32_True__CO__wave4_warp2_stg1--Arch_gfx950
    { 0x3f506101u, 0xb5300057u, 130, 178 }, // 3f506101b5300057 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x839e143eu, 0x44653dd7u, 130, 195 }, // 839e143e44653dd7 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_False__CO__wave4_warp4_stg1--Arch_gfx950
    { 0x4af54083u, 0x716c0573u, 163, 65 }, // 4af54083716c0573 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xedc223ecu, 0x87e9bbe6u, 163, 178 }, // edc223ec87e9bbe6 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0xee4c73a3u, 0x1b7edc04u, 163, 82 }, // ee4c73a31b7edc04 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_True__CO__wave3_warp2_stg1--Arch_gfx950
    { 0x3851dcc6u, 0x6302ef25u, 163, 146 }, // 3851dcc66302ef25 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_True__CO__wave3_warp4_stg1--Arch_gfx950
    { 0xed07a1fcu, 0x34a17300u, 163, 195 }, // ed07a1fc34a17300 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_64_64_True__CO__wave4_warp4_stg1--Arch_gfx950
    { 0x2fbf9d16u, 0x21d084c2u, 212, 65 }, // 2fbf9d1621d084c2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_64_False__CO__wave2_warp2_stg1--Arch_gfx950
    { 0x9e93a6ffu, 0x5082d464u, 229, 65 }, // 9e93a6ff5082d464 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_64_True__CO__wave2_warp2_stg1--Arch_gfx950
    { 0xd6bacbc5u, 0x6cda71b2u, 229, 178 }, // d6bacbc56cda71b2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_64_True__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x24f79f83u, 0xa7ca7bd7u, 229, 146 }, // 24f79f83a7ca7bd7 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_64_True__CO__wave3_warp4_stg1--Arch_gfx950
    { 0x8659a961u, 0x23abe07fu, 229, 195 }, // 8659a96123abe07f = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_64_True__CO__wave4_warp4_stg1--Arch_gfx950
    { 0xed6358acu, 0x9b7330fbu, 245, 178 }, // ed6358ac9b7330fb = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_128_False__CO__wave2_warp4_stg1--Arch_gfx950
    { 0x645fbfd5u, 0xd036a1d2u, 280, 178 }, // 645fbfd5d036a1d2 = b2sum -l 64 <<< amd-gfx950/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx950__P__0_2_128_128_True__CO__wave2_warp4_stg1--Arch_gfx950
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx950_mod0
{{ 0, 4, 6, 9,18,19,18,19,19,19},
 { 3, 7,12,12,18,19,18,19,19,19},
 {11, 3,16,18,18, 8, 8,10, 8, 8},
 { 4, 9, 5, 5,16,19,19,19,19,19},
 { 4, 4, 4, 3, 5,19,19,19,19,19},
 { 1, 3, 1, 3, 3,14,17,14,14,17},
 { 2, 4, 4, 4, 5, 4,16,16,16,15},
 { 4, 3, 5, 4, 4, 5,16,13,17,15},
 { 3, 3, 3, 3, 3, 5, 4,13,17,16},
 { 3, 3, 3, 3, 3, 3, 3,17,17,15}}
// End of GPU gfx950_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A0__F24 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 6;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 6;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

