/* TerminalWidget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TerminalWidget.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2011-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3, as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib.h>
#include <vte/vte.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <poll.h>
#include <pcre2.h>
#include <glib/gstdio.h>

#define TERMINAL_TERMINAL_WIDGET_DEFAULT_LABEL _ ("Terminal")
#define TERMINAL_TERMINAL_WIDGET_ACTION_COPY "term.copy"
#define TERMINAL_TERMINAL_WIDGET_ACTION_COPY_OUTPUT "term.copy-output"
#define TERMINAL_TERMINAL_WIDGET_ACTION_CLEAR_SCREEN "term.clear-screen"
#define TERMINAL_TERMINAL_WIDGET_ACTION_RESET "term.reset"
#define TERMINAL_TERMINAL_WIDGET_ACTION_PASTE "term.paste"
#define TERMINAL_TERMINAL_WIDGET_ACTION_RELOAD "term.reload"
#define TERMINAL_TERMINAL_WIDGET_ACTION_SCROLL_TO_COMMAND "term.scroll-to-command"
#define TERMINAL_TERMINAL_WIDGET_ACTION_SELECT_ALL "term.select-all"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_DEFAULT "term.zoom::default"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_IN "term.zoom::in"
#define TERMINAL_TERMINAL_WIDGET_ACTION_ZOOM_OUT "term.zoom::out"
#define TERMINAL_TERMINAL_WIDGET_SEND_PROCESS_FINISHED_BASH "dbus-send --type=method_call " "--session --dest=io.elementary.terminal " "/io/elementary/terminal " "io.elementary.terminal.ProcessFinished " "string:$PANTHEON_TERMINAL_ID " "string:\"$(fc -nl -1 | cut -c 3-)\" " "int32:\$__bp_last_ret_value >/dev/null 2>&1"
#define TERMINAL_TERMINAL_WIDGET_USERCHARS "-[:alnum:]"
#define TERMINAL_TERMINAL_WIDGET_USERCHARS_CLASS "[" TERMINAL_TERMINAL_WIDGET_USERCHARS "]"
#define TERMINAL_TERMINAL_WIDGET_PASSCHARS_CLASS "[-[:alnum:]\\Q,?;.:/!%$^*&~\"#'\\E]"
#define TERMINAL_TERMINAL_WIDGET_HOSTCHARS_CLASS "[-[:alnum:]]"
#define TERMINAL_TERMINAL_WIDGET_HOST TERMINAL_TERMINAL_WIDGET_HOSTCHARS_CLASS "+(\\." TERMINAL_TERMINAL_WIDGET_HOSTCHARS_CLASS "+)*"
#define TERMINAL_TERMINAL_WIDGET_PORT "(?:\\:[[:digit:]]{1,5})?"
#define TERMINAL_TERMINAL_WIDGET_PATHCHARS_CLASS "[-[:alnum:]\\Q_$.+!*,;:@&=?/~#%\\E]"
#define TERMINAL_TERMINAL_WIDGET_PATHTERM_CLASS "[^\\Q]'.}>) \t\r\n,\"\\E]"
#define TERMINAL_TERMINAL_WIDGET_SCHEME "(?:news:|telnet:|nntp:|file:\\/|https?:|ftps?:|sftp:|webcal:" "|irc:|sftp:|ldaps?:|nfs:|smb:|rsync:|ssh:|rlogin:|telnet:|git:" "|git\\+ssh:|bzr:|bzr\\+ssh:|svn:|svn\\+ssh:|hg:|mailto:|magnet:)"
#define TERMINAL_TERMINAL_WIDGET_USERPASS TERMINAL_TERMINAL_WIDGET_USERCHARS_CLASS "+(?:" TERMINAL_TERMINAL_WIDGET_PASSCHARS_CLASS "+)?"
#define TERMINAL_TERMINAL_WIDGET_URLPATH "(?:(/" TERMINAL_TERMINAL_WIDGET_PATHCHARS_CLASS "+(?:[(]" TERMINAL_TERMINAL_WIDGET_PATHCHARS_CLASS "*[)])*" TERMINAL_TERMINAL_WIDGET_PATHCHARS_CLASS "*)*" TERMINAL_TERMINAL_WIDGET_PATHTERM_CLASS ")?"
#define TERMINAL_TERMINAL_WIDGET_MIN_SCALE 0.25
#define TERMINAL_TERMINAL_WIDGET_MAX_SCALE 4.0
#define TERMINAL_TERMINAL_WIDGET_SYS_PIDFD_OPEN 434
#define TERMINAL_TERMINAL_WIDGET_CONTENTS_CHANGED_DELAY_MSEC 100
#define TERMINAL_MAIN_WINDOW_ACTION_OPEN_IN_BROWSER "action-open-in-browser"
#define TERMINAL_THEMES_PALETTE_SIZE 19
#define TERMINAL_THEMES_DARK "dark"
#define TERMINAL_THEMES_LIGHT "solarized-light"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*_LocalFunc0_) (guint keyval, guint code, gpointer user_data);

#define TERMINAL_TYPE_TERMINAL_WIDGET (terminal_terminal_widget_get_type ())
#define TERMINAL_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget))
#define TERMINAL_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))
#define TERMINAL_IS_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_IS_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_TERMINAL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))

typedef struct _TerminalTerminalWidget TerminalTerminalWidget;
typedef struct _TerminalTerminalWidgetClass TerminalTerminalWidgetClass;
typedef struct _TerminalTerminalWidgetPrivate TerminalTerminalWidgetPrivate;

#define TERMINAL_TYPE_MAIN_WINDOW (terminal_main_window_get_type ())
#define TERMINAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow))
#define TERMINAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))
#define TERMINAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_MAIN_WINDOW))
#define TERMINAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindowClass))

typedef struct _TerminalMainWindow TerminalMainWindow;
typedef struct _TerminalMainWindowClass TerminalMainWindowClass;
enum  {
	TERMINAL_TERMINAL_WIDGET_0_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY,
	TERMINAL_TERMINAL_WIDGET_NUM_PROPERTIES
};
static GParamSpec* terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_NUM_PROPERTIES];
typedef enum  {
	TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_URILIST,
	TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_STRING,
	TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_TEXT
} TerminalTerminalWidgetDropTargets;

#define TERMINAL_TERMINAL_WIDGET_TYPE_DROP_TARGETS (terminal_terminal_widget_drop_targets_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG (terminal_foreground_process_dialog_get_type ())
#define TERMINAL_FOREGROUND_PROCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG, TerminalForegroundProcessDialog))
#define TERMINAL_FOREGROUND_PROCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG, TerminalForegroundProcessDialogClass))
#define TERMINAL_IS_FOREGROUND_PROCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG))
#define TERMINAL_IS_FOREGROUND_PROCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG))
#define TERMINAL_FOREGROUND_PROCESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_FOREGROUND_PROCESS_DIALOG, TerminalForegroundProcessDialogClass))

typedef struct _TerminalForegroundProcessDialog TerminalForegroundProcessDialog;
typedef struct _TerminalForegroundProcessDialogClass TerminalForegroundProcessDialogClass;
typedef struct _Block3Data Block3Data;

#define TERMINAL_TYPE_UNSAFE_PASTE_DIALOG (terminal_unsafe_paste_dialog_get_type ())
#define TERMINAL_UNSAFE_PASTE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_UNSAFE_PASTE_DIALOG, TerminalUnsafePasteDialog))
#define TERMINAL_UNSAFE_PASTE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_UNSAFE_PASTE_DIALOG, TerminalUnsafePasteDialogClass))
#define TERMINAL_IS_UNSAFE_PASTE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_UNSAFE_PASTE_DIALOG))
#define TERMINAL_IS_UNSAFE_PASTE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_UNSAFE_PASTE_DIALOG))
#define TERMINAL_UNSAFE_PASTE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_UNSAFE_PASTE_DIALOG, TerminalUnsafePasteDialogClass))

typedef struct _TerminalUnsafePasteDialog TerminalUnsafePasteDialog;
typedef struct _TerminalUnsafePasteDialogClass TerminalUnsafePasteDialogClass;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vte_regex_unref0(var) ((var == NULL) ? NULL : (var = (vte_regex_unref (var), NULL)))

#define TERMINAL_TYPE_APPLICATION (terminal_application_get_type ())
#define TERMINAL_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplication))
#define TERMINAL_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))
#define TERMINAL_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_APPLICATION))
#define TERMINAL_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_APPLICATION, TerminalApplicationClass))

typedef struct _TerminalApplication TerminalApplication;
typedef struct _TerminalApplicationClass TerminalApplicationClass;
typedef struct _Block5Data Block5Data;
enum  {
	TERMINAL_TERMINAL_WIDGET_CWD_CHANGED_SIGNAL,
	TERMINAL_TERMINAL_WIDGET_FOREGROUND_PROCESS_CHANGED_SIGNAL,
	TERMINAL_TERMINAL_WIDGET_NUM_SIGNALS
};
static guint terminal_terminal_widget_signals[TERMINAL_TERMINAL_WIDGET_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TerminalTerminalWidget {
	VteTerminal parent_instance;
	TerminalTerminalWidgetPrivate * priv;
	gchar* terminal_id;
	HdyTabPage* tab;
	gchar* link_uri;
	gint default_size;
	gboolean last_key_was_return;
};

struct _TerminalTerminalWidgetClass {
	VteTerminalClass parent_class;
};

struct _TerminalTerminalWidgetPrivate {
	gchar* _current_working_directory;
	gchar* _program_string;
	gboolean init_complete;
	gboolean _resized;
	GPid child_pid;
	GPid fg_pid;
	TerminalMainWindow* _main_window;
	gboolean _child_has_exited;
	gboolean _killed;
	GtkClipboard* clipboard;
	GSimpleAction* copy_action;
	GSimpleAction* copy_output_action;
	GSimpleAction* clear_screen_action;
	GSimpleAction* reset_action;
	GSimpleAction* paste_action;
	GSimpleAction* scroll_to_command_action;
	glong remembered_position;
	glong remembered_command_start_row;
	glong remembered_command_end_row;
	GtkEventControllerMotion* motion_controller;
	GtkEventControllerScroll* scroll_controller;
	GtkEventControllerKey* key_controller;
	GtkGestureMultiPress* primary_gesture;
	GtkGestureMultiPress* secondary_gesture;
	gboolean modifier_pressed;
	gdouble scroll_delta;
	guint contents_changed_timeout_id;
	gboolean contents_changed_continue;
};

struct _Block3Data {
	int _ref_count_;
	TerminalTerminalWidget* self;
	gchar* command;
};

struct _Block4Data {
	int _ref_count_;
	TerminalTerminalWidget* self;
	TerminalUnsafePasteDialog* dialog;
	gchar* text;
};

struct _Block5Data {
	int _ref_count_;
	TerminalTerminalWidget* self;
	gulong once;
};

static gint TerminalTerminalWidget_private_offset;
static gpointer terminal_terminal_widget_parent_class = NULL;
static gint terminal_terminal_widget_terminal_id_counter;
static gint terminal_terminal_widget_terminal_id_counter = 0;
VALA_EXTERN GSettings* terminal_application_settings;

VALA_EXTERN GType terminal_terminal_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalWidget, g_object_unref)
VALA_EXTERN GType terminal_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalMainWindow, g_object_unref)
static GType terminal_terminal_widget_drop_targets_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN TerminalTerminalWidget* terminal_terminal_widget_new (TerminalMainWindow* parent_window);
VALA_EXTERN TerminalTerminalWidget* terminal_terminal_widget_construct (GType object_type,
                                                            TerminalMainWindow* parent_window);
static void terminal_terminal_widget_pointer_focus (TerminalTerminalWidget* self);
static void terminal_terminal_widget_secondary_released (TerminalTerminalWidget* self,
                                                  GtkGestureMultiPress* gesture,
                                                  gint n_press,
                                                  gdouble x,
                                                  gdouble y);
VALA_EXTERN gboolean terminal_terminal_widget_has_foreground_process (TerminalTerminalWidget* self);
static gchar* terminal_terminal_widget_get_link (TerminalTerminalWidget* self,
                                          GdkEvent* event);
static void terminal_terminal_widget_popup_context_menu (TerminalTerminalWidget* self,
                                                  GdkRectangle* rect);
static void terminal_terminal_widget_primary_pressed (TerminalTerminalWidget* self,
                                               GtkGestureMultiPress* gesture,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y);
VALA_EXTERN TerminalMainWindow* terminal_terminal_widget_get_main_window (TerminalTerminalWidget* self);
VALA_EXTERN GSimpleAction* terminal_main_window_get_simple_action (TerminalMainWindow* self,
                                                       const gchar* action);
static void terminal_terminal_widget_scroll (TerminalTerminalWidget* self,
                                      gdouble x,
                                      gdouble y);
static gboolean terminal_terminal_widget_key_pressed (TerminalTerminalWidget* self,
                                               guint keyval,
                                               guint keycode,
                                               GdkModifierType modifiers);
VALA_EXTERN void terminal_terminal_widget_remember_position (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_remember_command_end_position (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_remember_command_start_position (TerminalTerminalWidget* self);
VALA_EXTERN gboolean terminal_terminal_widget_get_resized (TerminalTerminalWidget* self);
VALA_EXTERN gchar* terminal_terminal_widget_get_last_output (TerminalTerminalWidget* self,
                                                 gboolean include_command);
static gboolean __lambda32_ (TerminalTerminalWidget* self,
                      guint keyval,
                      guint code);
static gboolean ___lambda32___localfunc0_ (guint keyval,
                                    guint code,
                                    gpointer self);
static void terminal_terminal_widget_action_reset (TerminalTerminalWidget* self);
static void terminal_terminal_widget_action_clear_screen (TerminalTerminalWidget* self);
static void terminal_terminal_widget_setup_menu (TerminalTerminalWidget* self);
static void __lambda31_ (TerminalTerminalWidget* self,
                  GtkClipboard* clipboard,
                  GdkAtom* atoms,
                  gint atoms_length1);
static void ___lambda31__gtk_clipboard_targets_received_func (GtkClipboard* clipboard,
                                                       GdkAtom* atoms,
                                                       gint n_atoms,
                                                       gpointer self);
VALA_EXTERN void terminal_main_window_update_context_menu (TerminalMainWindow* self);
VALA_EXTERN GMenu* terminal_main_window_get_context_menu_model (TerminalMainWindow* self);
static void terminal_terminal_widget_real_copy_clipboard (VteTerminal* base);
static void terminal_terminal_widget_copy_output (TerminalTerminalWidget* self);
VALA_EXTERN gboolean terminal_terminal_widget_confirm_kill_fg_process (TerminalTerminalWidget* self,
                                                           const gchar* primary_text,
                                                           const gchar* button_label);
VALA_EXTERN GType terminal_foreground_process_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalForegroundProcessDialog, g_object_unref)
VALA_EXTERN TerminalForegroundProcessDialog* terminal_foreground_process_dialog_new (TerminalMainWindow* parent,
                                                                         const gchar* primary_text,
                                                                         const gchar* button_label);
VALA_EXTERN TerminalForegroundProcessDialog* terminal_foreground_process_dialog_construct (GType object_type,
                                                                               TerminalMainWindow* parent,
                                                                               const gchar* primary_text,
                                                                               const gchar* button_label);
VALA_EXTERN void terminal_terminal_widget_kill_fg (TerminalTerminalWidget* self);
static void terminal_terminal_widget_feed_command (TerminalTerminalWidget* self,
                                            const gchar* command);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda14_ (Block3Data* _data3_);
static gboolean ___lambda14__gsource_func (gpointer self);
VALA_EXTERN void terminal_terminal_widget_change_directory (TerminalTerminalWidget* self,
                                                const gchar* path);
static void terminal_terminal_widget_real_paste_clipboard (VteTerminal* base);
static void __lambda33_ (TerminalTerminalWidget* self,
                  GtkClipboard* clipboard,
                  const gchar* text);
static void terminal_terminal_widget_validated_paste (TerminalTerminalWidget* self,
                                               const gchar* text);
static void ___lambda33__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                    const gchar* text,
                                                    gpointer self);
VALA_EXTERN GType terminal_unsafe_paste_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalUnsafePasteDialog, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN gboolean terminal_utils_is_safe_paste (const gchar* text,
                                       gchar*** msg_array,
                                       gint* msg_array_length1);
VALA_EXTERN TerminalUnsafePasteDialog* terminal_unsafe_paste_dialog_new (TerminalMainWindow* parent,
                                                             const gchar* title_text,
                                                             const gchar* text_to_paste);
VALA_EXTERN TerminalUnsafePasteDialog* terminal_unsafe_paste_dialog_construct (GType object_type,
                                                                   TerminalMainWindow* parent,
                                                                   const gchar* title_text,
                                                                   const gchar* text_to_paste);
static void __lambda34_ (Block4Data* _data4_,
                  gint res);
static void ___lambda34__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void terminal_terminal_widget_update_current_working_directory (TerminalTerminalWidget* self,
                                                                const gchar* cwd);
static void terminal_terminal_widget_set_current_working_directory (TerminalTerminalWidget* self,
                                                             const gchar* value);
VALA_EXTERN const gchar* terminal_terminal_widget_get_current_working_directory (TerminalTerminalWidget* self);
static void terminal_terminal_widget_update_theme (TerminalTerminalWidget* self);
VALA_EXTERN GdkRGBA* terminal_themes_get_rgba_palette (const gchar* theme,
                                           gint* result_length1);
static GdkRGBA* _vala_array_dup1 (GdkRGBA* self,
                           gssize length);
static void terminal_terminal_widget_update_audible_bell (TerminalTerminalWidget* self);
static void terminal_terminal_widget_update_cursor_shape (TerminalTerminalWidget* self);
static void terminal_terminal_widget_on_child_exited (TerminalTerminalWidget* self);
static void terminal_terminal_widget_set_child_has_exited (TerminalTerminalWidget* self,
                                                    gboolean value);
VALA_EXTERN gboolean terminal_terminal_widget_try_get_foreground_pid (TerminalTerminalWidget* self,
                                                          gint* pid);
VALA_EXTERN void terminal_terminal_widget_term_ps (TerminalTerminalWidget* self);
static void terminal_terminal_widget_set_killed (TerminalTerminalWidget* self,
                                          gboolean value);
VALA_EXTERN void terminal_terminal_widget_active_shell (TerminalTerminalWidget* self,
                                            const gchar* dir);
VALA_EXTERN void terminal_terminal_widget_run_program (TerminalTerminalWidget* self,
                                           const gchar* _program_string,
                                           const gchar* working_directory);
VALA_EXTERN void terminal_terminal_widget_set_program_string (TerminalTerminalWidget* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* terminal_terminal_widget_get_program_string (TerminalTerminalWidget* self);
VALA_EXTERN gboolean terminal_terminal_widget_get_child_has_exited (TerminalTerminalWidget* self);
VALA_EXTERN gint terminal_terminal_widget_calculate_width (TerminalTerminalWidget* self,
                                               gint column_count);
VALA_EXTERN gint terminal_terminal_widget_calculate_height (TerminalTerminalWidget* self,
                                                gint row_count);
static void terminal_terminal_widget_clickable (TerminalTerminalWidget* self,
                                         gchar** str,
                                         gint str_length1);
VALA_EXTERN gchar* terminal_terminal_widget_get_shell_location (TerminalTerminalWidget* self);
VALA_EXTERN gchar* terminal_terminal_widget_get_pid_exe_name (TerminalTerminalWidget* self,
                                                  gint pid);
static void terminal_terminal_widget_real_increase_font_size (VteTerminal* base);
static void terminal_terminal_widget_real_decrease_font_size (VteTerminal* base);
VALA_EXTERN void terminal_terminal_widget_default_font_size (TerminalTerminalWidget* self);
VALA_EXTERN gboolean terminal_terminal_widget_is_init_complete (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_set_init_complete (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_drag_received (TerminalTerminalWidget* self,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* selection_data,
                                             guint target_type,
                                             guint time_);
VALA_EXTERN void terminal_terminal_widget_set_resized (TerminalTerminalWidget* self,
                                           gboolean value);
static void terminal_terminal_widget_scroll_to_command (TerminalTerminalWidget* self,
                                                 GSimpleAction* action,
                                                 GVariant* parameter);
VALA_EXTERN void terminal_terminal_widget_reload (TerminalTerminalWidget* self);
static void terminal_terminal_widget_on_contents_changed (TerminalTerminalWidget* self);
static gboolean __lambda35_ (TerminalTerminalWidget* self);
static gboolean ___lambda35__gsource_func (gpointer self);
VALA_EXTERN void terminal_terminal_widget_prepare_to_close (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_set_main_window (TerminalTerminalWidget* self,
                                               TerminalMainWindow* value);
VALA_EXTERN GType terminal_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalApplication, g_object_unref)
static TerminalApplication* terminal_terminal_widget_get_app (TerminalTerminalWidget* self);
VALA_EXTERN TerminalApplication* terminal_main_window_get_app (TerminalMainWindow* self);
VALA_EXTERN const gchar* terminal_terminal_widget_get_tab_label (TerminalTerminalWidget* self);
VALA_EXTERN void terminal_terminal_widget_set_tab_label (TerminalTerminalWidget* self,
                                             const gchar* value);
VALA_EXTERN gboolean terminal_terminal_widget_get_killed (TerminalTerminalWidget* self);
static GObject * terminal_terminal_widget_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _terminal_terminal_widget_update_theme_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void _terminal_terminal_widget_update_audible_bell_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _terminal_terminal_widget_update_theme_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void _terminal_terminal_widget_update_cursor_shape_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void _terminal_terminal_widget_pointer_focus_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self);
static void _terminal_terminal_widget_scroll_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                          gdouble dx,
                                                                          gdouble dy,
                                                                          gpointer self);
static void _terminal_terminal_widget___lambda36_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda36__gtk_event_controller_scroll_scroll_end (GtkEventControllerScroll* _sender,
                                                                                    gpointer self);
static gboolean _terminal_terminal_widget_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                     guint keyval,
                                                                                     guint keycode,
                                                                                     GdkModifierType state,
                                                                                     gpointer self);
static void _terminal_terminal_widget___lambda37_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda37__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                   guint keyval,
                                                                                   guint keycode,
                                                                                   GdkModifierType state,
                                                                                   gpointer self);
static void _terminal_terminal_widget___lambda38_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda38__gtk_event_controller_key_focus_out (GtkEventControllerKey* _sender,
                                                                                gpointer self);
static gboolean _terminal_terminal_widget___lambda39_ (TerminalTerminalWidget* self);
static gboolean __terminal_terminal_widget___lambda39__gtk_event_controller_key_modifiers (GtkEventControllerKey* _sender,
                                                                                    GdkModifierType object,
                                                                                    gpointer self);
static void _terminal_terminal_widget_primary_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self);
static void _terminal_terminal_widget_secondary_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                    gint n_press,
                                                                                    gdouble x,
                                                                                    gdouble y,
                                                                                    gpointer self);
static gboolean _gtk_event_controller_handle_event_gtk_widget_event (GtkWidget* _sender,
                                                              GdkEvent* event,
                                                              gpointer self);
static void _terminal_terminal_widget___lambda40_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda40__vte_terminal_selection_changed (VteTerminal* _sender,
                                                                            gpointer self);
static void _terminal_terminal_widget___lambda41_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda41__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                      GtkAllocation* allocation,
                                                                      gpointer self);
static void _terminal_terminal_widget_on_contents_changed_vte_terminal_contents_changed (VteTerminal* _sender,
                                                                                  gpointer self);
static void _terminal_terminal_widget_on_child_exited_vte_terminal_child_exited (VteTerminal* _sender,
                                                                          gint status,
                                                                          gpointer self);
static void _terminal_terminal_widget___lambda42_ (Block5Data* _data5_);
static void _terminal_terminal_widget_setup_menu_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                      GdkEventOwnerChange* event,
                                                                      gpointer self);
static void __terminal_terminal_widget___lambda42__gtk_widget_realize (GtkWidget* _sender,
                                                                gpointer self);
static void _vala_array_add1 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _vala_array_add2 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _vala_array_add3 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _terminal_terminal_widget_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                            GdkDragContext* context,
                                                                            gint x,
                                                                            gint y,
                                                                            GtkSelectionData* selection_data,
                                                                            guint info,
                                                                            guint time_,
                                                                            gpointer self);
static void _terminal_terminal_widget___lambda43_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda43__g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void _terminal_terminal_widget_copy_output_g_simple_action_activate (GSimpleAction* _sender,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void _terminal_terminal_widget_action_clear_screen_g_simple_action_activate (GSimpleAction* _sender,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void _terminal_terminal_widget_action_reset_g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void _terminal_terminal_widget___lambda44_ (TerminalTerminalWidget* self);
static void __terminal_terminal_widget___lambda44__g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void _terminal_terminal_widget_reload_g_simple_action_activate (GSimpleAction* _sender,
                                                                GVariant* parameter,
                                                                gpointer self);
static void _terminal_terminal_widget_scroll_to_command_g_simple_action_activate (GSimpleAction* _sender,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void _vte_terminal_select_all_g_simple_action_activate (GSimpleAction* _sender,
                                                        GVariant* parameter,
                                                        gpointer self);
static void _terminal_terminal_widget___lambda45_ (TerminalTerminalWidget* self,
                                            GVariant* p);
static gchar* _variant_get1 (GVariant* value);
static void __terminal_terminal_widget___lambda45__g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void terminal_terminal_widget_finalize (GObject * obj);
static GType terminal_terminal_widget_get_type_once (void);
static void _vala_terminal_terminal_widget_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_terminal_terminal_widget_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_COPY[2] = {"<Control><Shift>C", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_COPY_OUTPUT[2] = {"<Alt>C", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_CLEAR_SCREEN[2] = {"<Control><Shift>L", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_RESET[2] = {"<Control><Shift>K", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_PASTE[2] = {"<Control><Shift>V", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_RELOAD[3] = {"<Control><Shift>R", "<Ctrl>F5", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_SCROLL_TO_COMMAND[2] = {"<Alt>Up", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_SELECT_ALL[2] = {"<Control><Shift>A", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT[3] = {"<control>0", "<Control>KP_0", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN[4] = {"<Control>plus", "<Control>equal", "<Control>KP_Add", NULL};
const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT[3] = {"<Control>minus", "<Control>KP_Subtract", NULL};
static const gchar* TERMINAL_TERMINAL_WIDGET_REGEX_STRINGS[5] = {TERMINAL_TERMINAL_WIDGET_SCHEME "//(?:" TERMINAL_TERMINAL_WIDGET_USERPASS "\\@)?" TERMINAL_TERMINAL_WIDGET_HOST TERMINAL_TERMINAL_WIDGET_PORT TERMINAL_TERMINAL_WIDGET_URLPATH, "(?:www|ftp)" TERMINAL_TERMINAL_WIDGET_HOSTCHARS_CLASS "*\\." TERMINAL_TERMINAL_WIDGET_HOST TERMINAL_TERMINAL_WIDGET_PORT TERMINAL_TERMINAL_WIDGET_URLPATH, "(?:callto:|h323:|sip:)" TERMINAL_TERMINAL_WIDGET_USERCHARS_CLASS "[" TERMINAL_TERMINAL_WIDGET_USERCHARS ".]*(?:" TERMINAL_TERMINAL_WIDGET_PORT "/[a-z0-9]+)?\\@" TERMINAL_TERMINAL_WIDGET_HOST, "(?:mailto:)?" TERMINAL_TERMINAL_WIDGET_USERCHARS_CLASS "[" TERMINAL_TERMINAL_WIDGET_USERCHARS ".]*\\@" TERMINAL_TERMINAL_WIDGET_HOSTCHARS_CLASS "+\\." TERMINAL_TERMINAL_WIDGET_HOST, "(?:news:|man:|info:)[[:alnum:]\\Q^_{|}~!\"#$%&'()*+,./;:=?`\\E]+"};

static inline gpointer
terminal_terminal_widget_get_instance_private (TerminalTerminalWidget* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalTerminalWidget_private_offset);
}

static GType
terminal_terminal_widget_drop_targets_get_type_once (void)
{
	static const GEnumValue values[] = {{TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_URILIST, "TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_URILIST", "urilist"}, {TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_STRING, "TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_STRING", "string"}, {TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_TEXT, "TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_TEXT", "text"}, {0, NULL, NULL}};
	GType terminal_terminal_widget_drop_targets_type_id;
	terminal_terminal_widget_drop_targets_type_id = g_enum_register_static ("TerminalTerminalWidgetDropTargets", values);
	return terminal_terminal_widget_drop_targets_type_id;
}

static GType
terminal_terminal_widget_drop_targets_get_type (void)
{
	static volatile gsize terminal_terminal_widget_drop_targets_type_id__once = 0;
	if (g_once_init_enter (&terminal_terminal_widget_drop_targets_type_id__once)) {
		GType terminal_terminal_widget_drop_targets_type_id;
		terminal_terminal_widget_drop_targets_type_id = terminal_terminal_widget_drop_targets_get_type_once ();
		g_once_init_leave (&terminal_terminal_widget_drop_targets_type_id__once, terminal_terminal_widget_drop_targets_type_id);
	}
	return terminal_terminal_widget_drop_targets_type_id__once;
}

TerminalTerminalWidget*
terminal_terminal_widget_construct (GType object_type,
                                    TerminalMainWindow* parent_window)
{
	TerminalTerminalWidget * self = NULL;
	g_return_val_if_fail (parent_window != NULL, NULL);
	self = (TerminalTerminalWidget*) g_object_new (object_type, "main-window", parent_window, NULL);
	return self;
}

TerminalTerminalWidget*
terminal_terminal_widget_new (TerminalMainWindow* parent_window)
{
	return terminal_terminal_widget_construct (TERMINAL_TYPE_TERMINAL_WIDGET, parent_window);
}

static void
terminal_terminal_widget_pointer_focus (TerminalTerminalWidget* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	vte_terminal_set_allow_hyperlink ((VteTerminal*) self, _tmp1_);
}

static void
terminal_terminal_widget_secondary_released (TerminalTerminalWidget* self,
                                             GtkGestureMultiPress* gesture,
                                             gint n_press,
                                             gdouble x,
                                             gdouble y)
{
	GdkEvent* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GdkRectangle _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (terminal_terminal_widget_has_foreground_process (self)) {
		gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
		return;
	}
	_tmp0_ = gtk_gesture_get_last_event ((GtkGesture*) gesture, NULL);
	_tmp1_ = terminal_terminal_widget_get_link (self, _tmp0_);
	_g_free0 (self->link_uri);
	self->link_uri = _tmp1_;
	_tmp2_ = self->link_uri;
	if (_tmp2_ != NULL) {
		GSimpleAction* _tmp3_;
		_tmp3_ = self->priv->copy_action;
		g_simple_action_set_enabled (_tmp3_, TRUE);
	}
	_tmp4_.x = (gint) x;
	_tmp4_.y = (gint) y;
	terminal_terminal_widget_popup_context_menu (self, &_tmp4_);
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

static void
terminal_terminal_widget_primary_pressed (TerminalTerminalWidget* self,
                                          GtkGestureMultiPress* gesture,
                                          gint n_press,
                                          gdouble x,
                                          gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_g_free0 (self->link_uri);
	self->link_uri = NULL;
	_tmp0_ = vte_terminal_get_allow_hyperlink ((VteTerminal*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdkEvent* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp2_ = gtk_gesture_get_last_event ((GtkGesture*) gesture, NULL);
		_tmp3_ = terminal_terminal_widget_get_link (self, _tmp2_);
		_g_free0 (self->link_uri);
		self->link_uri = _tmp3_;
		_tmp5_ = self->link_uri;
		if (_tmp5_ != NULL) {
			_tmp4_ = !vte_terminal_get_has_selection ((VteTerminal*) self);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			TerminalMainWindow* _tmp6_;
			GSimpleAction* _tmp7_;
			GSimpleAction* _tmp8_;
			_tmp6_ = self->priv->_main_window;
			_tmp7_ = terminal_main_window_get_simple_action (_tmp6_, TERMINAL_MAIN_WINDOW_ACTION_OPEN_IN_BROWSER);
			_tmp8_ = _tmp7_;
			g_signal_emit_by_name (_tmp8_, "activate", NULL);
			_g_object_unref0 (_tmp8_);
		}
	} else {
		vte_terminal_set_allow_hyperlink ((VteTerminal*) self, TRUE);
	}
}

static void
terminal_terminal_widget_scroll (TerminalTerminalWidget* self,
                                 gdouble x,
                                 gdouble y)
{
	g_return_if_fail (self != NULL);
	self->priv->scroll_delta = self->priv->scroll_delta + y;
	if (self->priv->scroll_delta >= 0.5) {
		g_signal_emit_by_name ((VteTerminal*) self, "decrease-font-size");
		self->priv->scroll_delta = 0.0;
	} else {
		if (self->priv->scroll_delta <= (-0.5)) {
			g_signal_emit_by_name ((VteTerminal*) self, "increase-font-size");
			self->priv->scroll_delta = 0.0;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda32_ (TerminalTerminalWidget* self,
             guint keyval,
             guint code)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkKeymap* keymap = NULL;
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymap* _tmp3_;
	GdkKeymapKey* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean result;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keymap = _tmp2_;
	_tmp3_ = keymap;
	_tmp6_ = gdk_keymap_get_entries_for_keyval (_tmp3_, keyval, &_tmp4_, &_tmp5_);
	keys = (g_free (keys), NULL);
	keys = _tmp4_;
	keys_length1 = _tmp5_;
	_keys_size_ = keys_length1;
	if (_tmp6_) {
		GdkKeymapKey* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = keys;
		_tmp7__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp7_;
			key_collection_length1 = _tmp7__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp8_;
					_tmp8_ = key;
					if (code == _tmp8_.keycode) {
						result = TRUE;
						_g_object_unref0 (keymap);
						keys = (g_free (keys), NULL);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (keymap);
	keys = (g_free (keys), NULL);
	return result;
}

static gboolean
___lambda32___localfunc0_ (guint keyval,
                           guint code,
                           gpointer self)
{
	gboolean result;
	result = __lambda32_ ((TerminalTerminalWidget*) self, keyval, code);
	return result;
}

static gboolean
terminal_terminal_widget_key_pressed (TerminalTerminalWidget* self,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType modifiers)
{
	_LocalFunc0_ match_keycode = NULL;
	gpointer match_keycode_target;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (keyval) {
		case GDK_KEY_Control_R:
		case GDK_KEY_Control_L:
		{
			GtkEventControllerScroll* _tmp0_;
			_tmp0_ = self->priv->scroll_controller;
			gtk_event_controller_scroll_set_flags (_tmp0_, GTK_EVENT_CONTROLLER_SCROLL_VERTICAL);
			break;
		}
		case GDK_KEY_Return:
		{
			GSimpleAction* _tmp1_;
			GSimpleAction* _tmp2_;
			terminal_terminal_widget_remember_position (self);
			_tmp1_ = self->priv->scroll_to_command_action;
			g_simple_action_set_enabled (_tmp1_, TRUE);
			terminal_terminal_widget_remember_command_end_position (self);
			_tmp2_ = self->priv->copy_output_action;
			g_simple_action_set_enabled (_tmp2_, FALSE);
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_Down:
		{
			terminal_terminal_widget_remember_command_start_position (self);
			break;
		}
		case GDK_KEY_Menu:
		{
			glong col = 0L;
			glong row = 0L;
			glong _tmp3_ = 0L;
			glong _tmp4_ = 0L;
			glong cell_width = 0L;
			glong cell_height = 0L;
			gdouble vadj = 0.0;
			GtkAdjustment* _tmp5_;
			GtkAdjustment* _tmp6_;
			gdouble _tmp7_;
			gdouble _tmp8_;
			GdkRectangle rect = {0};
			GdkRectangle _tmp9_ = {0};
			GdkRectangle _tmp10_;
			vte_terminal_get_cursor_position ((VteTerminal*) self, &_tmp3_, &_tmp4_);
			col = _tmp3_;
			row = _tmp4_;
			cell_width = vte_terminal_get_char_width ((VteTerminal*) self);
			cell_height = vte_terminal_get_char_height ((VteTerminal*) self);
			_tmp5_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) self);
			_tmp6_ = _tmp5_;
			_tmp7_ = gtk_adjustment_get_value (_tmp6_);
			_tmp8_ = _tmp7_;
			vadj = _tmp8_;
			_tmp9_.x = (gint) (col * cell_width);
			_tmp9_.y = (gint) ((row - vadj) * cell_height);
			_tmp9_.width = (gint) cell_width;
			_tmp9_.height = (gint) cell_height;
			rect = _tmp9_;
			_tmp10_ = rect;
			terminal_terminal_widget_popup_context_menu (self, &_tmp10_);
			break;
		}
		case GDK_KEY_Alt_L:
		case GDK_KEY_Alt_R:
		{
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_;
			GSimpleAction* _tmp17_;
			_tmp12_ = self->priv->_resized;
			if (!_tmp12_) {
				gchar* _tmp13_;
				gchar* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				_tmp13_ = terminal_terminal_widget_get_last_output (self, TRUE);
				_tmp14_ = _tmp13_;
				_tmp15_ = strlen (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp11_ = _tmp16_ > 0;
				_g_free0 (_tmp14_);
			} else {
				_tmp11_ = FALSE;
			}
			_tmp17_ = self->priv->copy_output_action;
			g_simple_action_set_enabled (_tmp17_, _tmp11_);
			break;
		}
		default:
		{
			gboolean _tmp18_ = FALSE;
			if (!self->priv->modifier_pressed) {
				_tmp18_ = TRUE;
			} else {
				_tmp18_ = !((modifiers & gtk_accelerator_get_default_mod_mask ()) == gtk_accelerator_get_default_mod_mask ());
			}
			if (_tmp18_) {
				terminal_terminal_widget_remember_command_start_position (self);
			}
			break;
		}
	}
	match_keycode = ___lambda32___localfunc0_;
	match_keycode_target = self;
	if ((modifiers & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		GSettings* _tmp20_;
		_tmp20_ = terminal_application_settings;
		_tmp19_ = g_settings_get_boolean (_tmp20_, "natural-copy-paste");
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_LocalFunc0_ _tmp21_;
		gpointer _tmp21__target;
		_tmp21_ = match_keycode;
		_tmp21__target = match_keycode_target;
		if (_tmp21_ (GDK_KEY_c, keycode, _tmp21__target)) {
			if (vte_terminal_get_has_selection ((VteTerminal*) self)) {
				vte_terminal_copy_clipboard ((VteTerminal*) self);
				if (!((modifiers & GDK_SHIFT_MASK) == GDK_SHIFT_MASK)) {
					vte_terminal_unselect_all ((VteTerminal*) self);
				}
				result = TRUE;
				return result;
			} else {
				self->last_key_was_return = TRUE;
			}
		} else {
			gboolean _tmp22_ = FALSE;
			_LocalFunc0_ _tmp23_;
			gpointer _tmp23__target;
			_tmp23_ = match_keycode;
			_tmp23__target = match_keycode_target;
			if (_tmp23_ (GDK_KEY_v, keycode, _tmp23__target)) {
				GtkClipboard* _tmp24_;
				_tmp24_ = self->priv->clipboard;
				_tmp22_ = gtk_clipboard_wait_is_text_available (_tmp24_);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				vte_terminal_paste_clipboard ((VteTerminal*) self);
				result = TRUE;
				return result;
			}
		}
	}
	if ((modifiers & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		_tmp26_ = (modifiers & GDK_SHIFT_MASK) == GDK_SHIFT_MASK;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		_LocalFunc0_ _tmp27_;
		gpointer _tmp27__target;
		_tmp27_ = match_keycode;
		_tmp27__target = match_keycode_target;
		_tmp25_ = _tmp27_ (GDK_KEY_k, keycode, _tmp27__target);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		terminal_terminal_widget_action_reset (self);
		result = TRUE;
		return result;
	}
	if ((modifiers & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		_tmp29_ = (modifiers & GDK_SHIFT_MASK) == GDK_SHIFT_MASK;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		_LocalFunc0_ _tmp30_;
		gpointer _tmp30__target;
		_tmp30_ = match_keycode;
		_tmp30__target = match_keycode_target;
		_tmp28_ = _tmp30_ (GDK_KEY_l, keycode, _tmp30__target);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		terminal_terminal_widget_action_clear_screen (self);
		result = TRUE;
		return result;
	}
	if ((modifiers & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
		_tmp31_ = keyval == GDK_KEY_Up;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GSimpleAction* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp32_ = self->priv->scroll_to_command_action;
		_tmp33_ = g_action_get_enabled ((GAction*) _tmp32_);
		_tmp34_ = _tmp33_;
		result = !_tmp34_;
		return result;
	}
	result = FALSE;
	return result;
}

static void
__lambda31_ (TerminalTerminalWidget* self,
             GtkClipboard* clipboard,
             GdkAtom* atoms,
             gint atoms_length1)
{
	gboolean can_paste = FALSE;
	gboolean _tmp0_ = FALSE;
	GSimpleAction* _tmp2_;
	g_return_if_fail (clipboard != NULL);
	can_paste = FALSE;
	if (atoms != NULL) {
		_tmp0_ = atoms_length1 > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (gtk_targets_include_text (atoms, (gint) atoms_length1)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = gtk_targets_include_uri (atoms, (gint) atoms_length1);
		}
		can_paste = _tmp1_;
	}
	_tmp2_ = self->priv->paste_action;
	g_simple_action_set_enabled (_tmp2_, can_paste);
}

static void
___lambda31__gtk_clipboard_targets_received_func (GtkClipboard* clipboard,
                                                  GdkAtom* atoms,
                                                  gint n_atoms,
                                                  gpointer self)
{
	__lambda31_ ((TerminalTerminalWidget*) self, clipboard, atoms, n_atoms);
	g_object_unref (self);
}

static void
terminal_terminal_widget_setup_menu (TerminalTerminalWidget* self)
{
	GtkClipboard* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean has_output = FALSE;
	GSimpleAction* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_request_targets (_tmp0_, ___lambda31__gtk_clipboard_targets_received_func, g_object_ref (self));
	_tmp2_ = self->priv->_resized;
	if (!_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = terminal_terminal_widget_get_last_output (self, TRUE);
		_tmp4_ = _tmp3_;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ > 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	has_output = _tmp1_;
	_tmp7_ = self->priv->copy_output_action;
	g_simple_action_set_enabled (_tmp7_, has_output);
}

static void
terminal_terminal_widget_popup_context_menu (TerminalTerminalWidget* self,
                                             GdkRectangle* rect)
{
	TerminalMainWindow* _tmp0_;
	GtkMenu* context_menu = NULL;
	TerminalMainWindow* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GtkWidget* _tmp4_;
	GtkMenu* _tmp5_ = NULL;
	GdkWindow* _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = self->priv->_main_window;
	terminal_main_window_update_context_menu (_tmp0_);
	terminal_terminal_widget_setup_menu (self);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = terminal_main_window_get_context_menu_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) self);
	_tmp5_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp3_);
	g_object_set (_tmp5_, "attach-widget", _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	context_menu = _tmp5_;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp7_ = *rect;
	gtk_menu_popup_at_rect (context_menu, _tmp6_, &_tmp7_, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
	_g_object_unref0 (context_menu);
}

static void
terminal_terminal_widget_real_copy_clipboard (VteTerminal* base)
{
	TerminalTerminalWidget * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	self = (TerminalTerminalWidget*) base;
	_tmp1_ = self->link_uri;
	if (_tmp1_ != NULL) {
		_tmp0_ = !vte_terminal_get_has_selection ((VteTerminal*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkClipboard* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp2_ = self->priv->clipboard;
		_tmp3_ = self->link_uri;
		_tmp4_ = self->link_uri;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_clipboard_set_text (_tmp2_, _tmp3_, _tmp6_);
	} else {
		VTE_TERMINAL_CLASS (terminal_terminal_widget_parent_class)->copy_clipboard (G_TYPE_CHECK_INSTANCE_CAST (self, vte_terminal_get_type (), VteTerminal));
	}
}

static void
terminal_terminal_widget_copy_output (TerminalTerminalWidget* self)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	GtkClipboard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = terminal_terminal_widget_get_last_output (self, TRUE);
	output = _tmp0_;
	_tmp1_ = self->priv->clipboard;
	_tmp2_ = strlen (output);
	_tmp3_ = _tmp2_;
	gtk_clipboard_set_text (_tmp1_, output, _tmp3_);
	_g_free0 (output);
}

gboolean
terminal_terminal_widget_confirm_kill_fg_process (TerminalTerminalWidget* self,
                                                  const gchar* primary_text,
                                                  const gchar* button_label)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (primary_text != NULL, FALSE);
	g_return_val_if_fail (button_label != NULL, FALSE);
	if (terminal_terminal_widget_has_foreground_process (self)) {
		TerminalForegroundProcessDialog* dialog = NULL;
		GtkWidget* _tmp0_;
		TerminalForegroundProcessDialog* _tmp1_;
		TerminalForegroundProcessDialog* _tmp2_;
		_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp1_ = terminal_foreground_process_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow), primary_text, button_label);
		g_object_ref_sink (_tmp1_);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		if (gtk_dialog_run ((GtkDialog*) _tmp2_) == ((gint) GTK_RESPONSE_ACCEPT)) {
			TerminalForegroundProcessDialog* _tmp3_;
			_tmp3_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp3_);
			terminal_terminal_widget_kill_fg (self);
		} else {
			TerminalForegroundProcessDialog* _tmp4_;
			_tmp4_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp4_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}

static void
terminal_terminal_widget_action_clear_screen (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	if (terminal_terminal_widget_has_foreground_process (self)) {
		return;
	}
	terminal_terminal_widget_feed_command (self, "clear -x\n");
}

static void
terminal_terminal_widget_action_reset (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	if (terminal_terminal_widget_confirm_kill_fg_process (self, _ ("Are you sure you want to reset the terminal?"), _ ("Reset"))) {
		terminal_terminal_widget_feed_command (self, "reset\n");
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TerminalTerminalWidget* self;
		self = _data3_->self;
		_g_free0 (_data3_->command);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
__lambda14_ (Block3Data* _data3_)
{
	TerminalTerminalWidget* self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = string_get_data (_data3_->command, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	vte_terminal_feed_child ((VteTerminal*) self, _tmp2_, (gssize) _tmp2__length1);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ (self);
	return result;
}

static void
terminal_terminal_widget_feed_command (TerminalTerminalWidget* self,
                                       const gchar* command)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (command);
	_g_free0 (_data3_->command);
	_data3_->command = _tmp0_;
	kill ((pid_t) self->priv->child_pid, (gint) SIGINT);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ___lambda14__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
terminal_terminal_widget_change_directory (TerminalTerminalWidget* self,
                                           const gchar* path)
{
	gchar* command = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (terminal_terminal_widget_has_foreground_process (self)) {
		return;
	}
	_tmp0_ = g_strdup_printf ("cd '%s';clear\n", path);
	command = _tmp0_;
	_tmp1_ = command;
	terminal_terminal_widget_feed_command (self, _tmp1_);
	_g_free0 (command);
}

static void
__lambda33_ (TerminalTerminalWidget* self,
             GtkClipboard* clipboard,
             const gchar* text)
{
	g_return_if_fail (clipboard != NULL);
	terminal_terminal_widget_validated_paste (self, text);
}

static void
___lambda33__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                               const gchar* text,
                                               gpointer self)
{
	__lambda33_ ((TerminalTerminalWidget*) self, clipboard, text);
	g_object_unref (self);
}

static void
terminal_terminal_widget_real_paste_clipboard (VteTerminal* base)
{
	TerminalTerminalWidget * self;
	GtkClipboard* _tmp0_;
	self = (TerminalTerminalWidget*) base;
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_request_text (_tmp0_, ___lambda33__gtk_clipboard_text_received_func, g_object_ref (self));
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TerminalTerminalWidget* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_free0 (_data4_->text);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda34_ (Block4Data* _data4_,
             gint res)
{
	TerminalTerminalWidget* self;
	TerminalUnsafePasteDialog* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
		vte_terminal_paste_text ((VteTerminal*) self, _data4_->text);
	}
}

static void
___lambda34__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda34_ (self, response_id);
}

static void
terminal_terminal_widget_validated_paste (TerminalTerminalWidget* self,
                                          const gchar* text)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	gchar** warn_text_array = NULL;
	gint warn_text_array_length1 = 0;
	gint _warn_text_array_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	TerminalMainWindow* toplevel = NULL;
	GtkWidget* _tmp6_;
	gchar* warn_text = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	TerminalMainWindow* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	TerminalUnsafePasteDialog* _tmp13_;
	TerminalUnsafePasteDialog* _tmp14_;
	TerminalUnsafePasteDialog* _tmp15_;
	TerminalUnsafePasteDialog* _tmp16_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data4_->text);
	_data4_->text = _tmp0_;
	if (_data4_->text == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !g_utf8_validate (_data4_->text, (gssize) -1, NULL);
	}
	if (_tmp1_) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp2_ = terminal_application_settings;
	if (!g_settings_get_boolean (_tmp2_, "unsafe-paste-alert")) {
		vte_terminal_paste_text ((VteTerminal*) self, _data4_->text);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp5_ = terminal_utils_is_safe_paste (_data4_->text, &_tmp3_, &_tmp4_);
	warn_text_array = (_vala_array_free (warn_text_array, warn_text_array_length1, (GDestroyNotify) g_free), NULL);
	warn_text_array = _tmp3_;
	warn_text_array_length1 = _tmp4_;
	_warn_text_array_size_ = warn_text_array_length1;
	if (_tmp5_) {
		vte_terminal_paste_text ((VteTerminal*) self, _data4_->text);
		warn_text_array = (_vala_array_free (warn_text_array, warn_text_array_length1, (GDestroyNotify) g_free), NULL);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	toplevel = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TERMINAL_TYPE_MAIN_WINDOW, TerminalMainWindow);
	_tmp7_ = warn_text_array;
	_tmp7__length1 = warn_text_array_length1;
	_tmp8_ = _vala_g_strjoinv ("\n\n", _tmp7_, (gint) _tmp7__length1);
	warn_text = _tmp8_;
	_tmp9_ = toplevel;
	_tmp10_ = warn_text;
	_tmp11_ = string_strip (_data4_->text);
	_tmp12_ = _tmp11_;
	_tmp13_ = terminal_unsafe_paste_dialog_new (_tmp9_, _tmp10_, _tmp12_);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_data4_->dialog = _tmp14_;
	_tmp15_ = _data4_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp15_, "response", (GCallback) ___lambda34__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp16_ = _data4_->dialog;
	gtk_window_present ((GtkWindow*) _tmp16_);
	_g_free0 (warn_text);
	warn_text_array = (_vala_array_free (warn_text_array, warn_text_array_length1, (GDestroyNotify) g_free), NULL);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
terminal_terminal_widget_update_current_working_directory (TerminalTerminalWidget* self,
                                                           const gchar* cwd)
{
	HdyTabPage* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cwd != NULL);
	terminal_terminal_widget_set_current_working_directory (self, cwd);
	_tmp0_ = self->tab;
	_tmp1_ = self->priv->_current_working_directory;
	hdy_tab_page_set_tooltip (_tmp0_, _tmp1_);
	g_signal_emit (self, terminal_terminal_widget_signals[TERMINAL_TERMINAL_WIDGET_CWD_CHANGED_SIGNAL], 0);
}

static GdkRGBA*
_vala_array_dup1 (GdkRGBA* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (GdkRGBA));
	}
	return NULL;
}

static void
terminal_terminal_widget_update_theme (TerminalTerminalWidget* self)
{
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GdkRGBA* theme_palette = NULL;
	GdkRGBA* _tmp2_;
	gint theme_palette_length1;
	gint _theme_palette_size_;
	GSettings* _tmp3_;
	GdkRGBA background = {0};
	GdkRGBA* _tmp19_;
	gint _tmp19__length1;
	GdkRGBA _tmp20_;
	GdkRGBA foreground = {0};
	GdkRGBA* _tmp21_;
	gint _tmp21__length1;
	GdkRGBA _tmp22_;
	GdkRGBA cursor = {0};
	GdkRGBA* _tmp23_;
	gint _tmp23__length1;
	GdkRGBA _tmp24_;
	GdkRGBA* palette = NULL;
	GdkRGBA* _tmp25_;
	gint _tmp25__length1;
	GdkRGBA* _tmp26_;
	gint _tmp26__length1;
	gint palette_length1;
	gint _palette_size_;
	GdkRGBA _tmp27_;
	GdkRGBA _tmp28_;
	GdkRGBA _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gtk_settings = _tmp1_;
	_tmp2_ = g_new0 (GdkRGBA, TERMINAL_THEMES_PALETTE_SIZE);
	theme_palette = _tmp2_;
	theme_palette_length1 = TERMINAL_THEMES_PALETTE_SIZE;
	_theme_palette_size_ = theme_palette_length1;
	_tmp3_ = terminal_application_settings;
	if (g_settings_get_boolean (_tmp3_, "follow-system-style")) {
		gboolean system_prefers_dark = FALSE;
		GraniteSettings* _tmp4_;
		GraniteSettingsColorScheme _tmp5_;
		GraniteSettingsColorScheme _tmp6_;
		GtkSettings* _tmp7_;
		_tmp4_ = granite_settings_get_default ();
		_tmp5_ = granite_settings_get_prefers_color_scheme (_tmp4_);
		_tmp6_ = _tmp5_;
		system_prefers_dark = _tmp6_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK;
		_tmp7_ = gtk_settings;
		g_object_set (_tmp7_, "gtk-application-prefer-dark-theme", system_prefers_dark, NULL);
		if (system_prefers_dark) {
			gint _tmp8_ = 0;
			GdkRGBA* _tmp9_;
			_tmp9_ = terminal_themes_get_rgba_palette (TERMINAL_THEMES_DARK, &_tmp8_);
			theme_palette = (g_free (theme_palette), NULL);
			theme_palette = _tmp9_;
			theme_palette_length1 = _tmp8_;
			_theme_palette_size_ = theme_palette_length1;
		} else {
			gint _tmp10_ = 0;
			GdkRGBA* _tmp11_;
			_tmp11_ = terminal_themes_get_rgba_palette (TERMINAL_THEMES_LIGHT, &_tmp10_);
			theme_palette = (g_free (theme_palette), NULL);
			theme_palette = _tmp11_;
			theme_palette_length1 = _tmp10_;
			_theme_palette_size_ = theme_palette_length1;
		}
	} else {
		GtkSettings* _tmp12_;
		GSettings* _tmp13_;
		GSettings* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gint _tmp17_ = 0;
		GdkRGBA* _tmp18_;
		_tmp12_ = gtk_settings;
		_tmp13_ = terminal_application_settings;
		g_object_set (_tmp12_, "gtk-application-prefer-dark-theme", g_settings_get_boolean (_tmp13_, "prefer-dark-style"), NULL);
		_tmp14_ = terminal_application_settings;
		_tmp15_ = g_settings_get_string (_tmp14_, "theme");
		_tmp16_ = _tmp15_;
		_tmp18_ = terminal_themes_get_rgba_palette (_tmp16_, &_tmp17_);
		theme_palette = (g_free (theme_palette), NULL);
		theme_palette = _tmp18_;
		theme_palette_length1 = _tmp17_;
		_theme_palette_size_ = theme_palette_length1;
		_g_free0 (_tmp16_);
	}
	_tmp19_ = theme_palette;
	_tmp19__length1 = theme_palette_length1;
	_tmp20_ = _tmp19_[TERMINAL_THEMES_PALETTE_SIZE - 3];
	background = _tmp20_;
	_tmp21_ = theme_palette;
	_tmp21__length1 = theme_palette_length1;
	_tmp22_ = _tmp21_[TERMINAL_THEMES_PALETTE_SIZE - 2];
	foreground = _tmp22_;
	_tmp23_ = theme_palette;
	_tmp23__length1 = theme_palette_length1;
	_tmp24_ = _tmp23_[TERMINAL_THEMES_PALETTE_SIZE - 1];
	cursor = _tmp24_;
	_tmp25_ = theme_palette;
	_tmp25__length1 = theme_palette_length1;
	_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup1 (_tmp25_ + 0, 16 - 0) : _tmp25_;
	_tmp26__length1 = 16 - 0;
	palette = _tmp26_;
	palette_length1 = _tmp26__length1;
	_palette_size_ = palette_length1;
	_tmp27_ = foreground;
	_tmp28_ = background;
	vte_terminal_set_colors ((VteTerminal*) self, &_tmp27_, &_tmp28_, palette, (gsize) palette_length1);
	_tmp29_ = cursor;
	vte_terminal_set_color_cursor ((VteTerminal*) self, &_tmp29_);
	palette = (g_free (palette), NULL);
	theme_palette = (g_free (theme_palette), NULL);
	_g_object_unref0 (gtk_settings);
}

static void
terminal_terminal_widget_update_audible_bell (TerminalTerminalWidget* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = terminal_application_settings;
	vte_terminal_set_audible_bell ((VteTerminal*) self, g_settings_get_boolean (_tmp0_, "audible-bell"));
}

static void
terminal_terminal_widget_update_cursor_shape (TerminalTerminalWidget* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = terminal_application_settings;
	vte_terminal_set_cursor_shape ((VteTerminal*) self, (VteCursorShape) g_settings_get_enum (_tmp0_, "cursor-shape"));
}

static void
terminal_terminal_widget_on_child_exited (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	terminal_terminal_widget_set_child_has_exited (self, TRUE);
	self->last_key_was_return = TRUE;
	self->priv->fg_pid = (GPid) -1;
}

void
terminal_terminal_widget_kill_fg (TerminalTerminalWidget* self)
{
	gint pid = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = terminal_terminal_widget_try_get_foreground_pid (self, &_tmp0_);
	pid = _tmp0_;
	if (_tmp1_) {
		kill ((pid_t) pid, (gint) SIGKILL);
	}
}

void
terminal_terminal_widget_term_ps (TerminalTerminalWidget* self)
{
	gint pid_fd = 0;
	struct pollfd pid_pfd[1] = {0};
	struct pollfd _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	terminal_terminal_widget_set_killed (self, TRUE);
	pid_fd = syscall (TERMINAL_TERMINAL_WIDGET_SYS_PIDFD_OPEN, self->priv->child_pid, 0, NULL);
	kill ((pid_t) self->priv->child_pid, (gint) SIGHUP);
	kill ((pid_t) self->priv->child_pid, (gint) SIGTERM);
	if (pid_fd == -1) {
		waitpid ((pid_t) self->priv->child_pid, NULL, 0);
		return;
	}
	memset (&_tmp0_, 0, sizeof (struct pollfd));
	_tmp0_.fd = pid_fd;
	_tmp0_.events = POLLIN;
	pid_pfd[0] = _tmp0_;
	while (TRUE) {
		if (!(poll (pid_pfd, (gint) 1, -1) != 1)) {
			break;
		}
	}
	close (pid_fd);
}

void
terminal_terminal_widget_active_shell (TerminalTerminalWidget* self,
                                       const gchar* dir)
{
	gchar* shell = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar** envv = NULL;
	gint envv_length1;
	gint _envv_size_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = terminal_application_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "shell");
	shell = _tmp1_;
	envv = NULL;
	envv_length1 = 0;
	_envv_size_ = envv_length1;
	_tmp2_ = shell;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		gchar* _tmp3_;
		_tmp3_ = vte_get_user_shell ();
		_g_free0 (shell);
		shell = _tmp3_;
	}
	_tmp4_ = shell;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		g_critical ("TerminalWidget.vala:720: No user shell available");
		envv = (_vala_array_free (envv, envv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (shell);
		return;
	}
	if (g_strcmp0 (dir, "") == 0) {
		g_debug ("TerminalWidget.vala:725: Using fallback directory");
		dir = "/";
	}
	_tmp5_ = self->terminal_id;
	_tmp6_ = g_strconcat ("PANTHEON_TERMINAL_ID=", _tmp5_, NULL);
	_tmp7_ = g_getenv ("PROMPT_COMMAND");
	_tmp8_ = g_strconcat ("PROMPT_COMMAND=" TERMINAL_TERMINAL_WIDGET_SEND_PROCESS_FINISHED_BASH, _tmp7_, NULL);
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp6_;
	_tmp9_[1] = _tmp8_;
	envv = (_vala_array_free (envv, envv_length1, (GDestroyNotify) g_free), NULL);
	envv = _tmp9_;
	envv_length1 = 2;
	_envv_size_ = envv_length1;
	{
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		GPid _tmp15_ = 0;
		_tmp10_ = shell;
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		_tmp14_ = envv;
		_tmp14__length1 = envv_length1;
		vte_terminal_spawn_sync ((VteTerminal*) self, VTE_PTY_DEFAULT, dir, _tmp13_, _tmp14_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp15_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp15_;
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("TerminalWidget.vala:747: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		envv = (_vala_array_free (envv, envv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (shell);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	envv = (_vala_array_free (envv, envv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (shell);
}

void
terminal_terminal_widget_run_program (TerminalTerminalWidget* self,
                                      const gchar* _program_string,
                                      const gchar* working_directory)
{
	gint _tmp0_;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_program_string != NULL);
	_tmp0_ = strlen (_program_string);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ > 0, "_program_string.length > 0");
	{
		gchar** program_with_args = NULL;
		gchar** _tmp2_;
		gint program_with_args_length1;
		gint _program_with_args_size_;
		const gchar* _tmp3_;
		gchar** _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GPid _tmp7_ = 0;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		program_with_args = _tmp2_;
		program_with_args_length1 = 0;
		_program_with_args_size_ = program_with_args_length1;
		terminal_terminal_widget_set_program_string (self, _program_string);
		_tmp3_ = self->priv->_program_string;
		g_shell_parse_argv (_tmp3_, &_tmp5_, &_tmp4_, &_inner_error0_);
		program_with_args = (_vala_array_free (program_with_args, program_with_args_length1, (GDestroyNotify) g_free), NULL);
		program_with_args = _tmp4_;
		program_with_args_length1 = _tmp5_;
		_program_with_args_size_ = program_with_args_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			program_with_args = (_vala_array_free (program_with_args, program_with_args_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		_tmp6_ = program_with_args;
		_tmp6__length1 = program_with_args_length1;
		vte_terminal_spawn_sync ((VteTerminal*) self, VTE_PTY_DEFAULT, working_directory, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			program_with_args = (_vala_array_free (program_with_args, program_with_args_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		program_with_args = (_vala_array_free (program_with_args, program_with_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_ = 0;
		guint8* _tmp16_;
		gint _tmp16__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("TerminalWidget.vala:760: %s", _tmp9_);
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strconcat (_tmp11_, "\r\n\r\n", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_get_data (_tmp13_, &_tmp15_);
		_tmp14__length1 = _tmp15_;
		_tmp16_ = _tmp14_;
		_tmp16__length1 = _tmp14__length1;
		vte_terminal_feed ((VteTerminal*) self, _tmp16_, (gssize) _tmp16__length1);
		_g_free0 (_tmp13_);
		terminal_terminal_widget_active_shell (self, working_directory);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
terminal_terminal_widget_try_get_foreground_pid (TerminalTerminalWidget* self,
                                                 gint* pid)
{
	gint _vala_pid = 0;
	gboolean _tmp0_;
	gint pty = 0;
	VtePty* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint fgpid = 0;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_child_has_exited;
	if (_tmp0_) {
		_vala_pid = -1;
		result = FALSE;
		if (pid) {
			*pid = _vala_pid;
		}
		return result;
	}
	_tmp1_ = vte_terminal_get_pty ((VteTerminal*) self);
	_tmp2_ = vte_pty_get_fd (_tmp1_);
	_tmp3_ = _tmp2_;
	pty = _tmp3_;
	fgpid = (gint) tcgetpgrp (pty);
	if (fgpid != ((gint) self->priv->child_pid)) {
		_tmp4_ = fgpid != -1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_vala_pid = (gint) fgpid;
		result = TRUE;
		if (pid) {
			*pid = _vala_pid;
		}
		return result;
	} else {
		_vala_pid = -1;
		result = FALSE;
		if (pid) {
			*pid = _vala_pid;
		}
		return result;
	}
}

gboolean
terminal_terminal_widget_has_foreground_process (TerminalTerminalWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = terminal_terminal_widget_try_get_foreground_pid (self, NULL);
	return result;
}

gint
terminal_terminal_widget_calculate_width (TerminalTerminalWidget* self,
                                          gint column_count)
{
	gint width = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	width = ((gint) vte_terminal_get_char_width ((VteTerminal*) self)) * column_count;
	result = width;
	return result;
}

gint
terminal_terminal_widget_calculate_height (TerminalTerminalWidget* self,
                                           gint row_count)
{
	gint height = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	height = ((gint) vte_terminal_get_char_height ((VteTerminal*) self)) * row_count;
	result = height;
	return result;
}

static void
terminal_terminal_widget_clickable (TerminalTerminalWidget* self,
                                    gchar** str,
                                    gint str_length1)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar** exp_collection = NULL;
		gint exp_collection_length1 = 0;
		gint _exp_collection_size_ = 0;
		gint exp_it = 0;
		exp_collection = str;
		exp_collection_length1 = str_length1;
		for (exp_it = 0; exp_it < exp_collection_length1; exp_it = exp_it + 1) {
			const gchar* exp = NULL;
			exp = exp_collection[exp_it];
			{
				{
					VteRegex* regex = NULL;
					const gchar* _tmp0_;
					VteRegex* _tmp1_;
					gint id = 0;
					VteRegex* _tmp2_;
					_tmp0_ = exp;
					_tmp1_ = vte_regex_new_for_match (_tmp0_, (gssize) -1, (guint32) PCRE2_MULTILINE, &_inner_error0_);
					regex = _tmp1_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp2_ = regex;
					id = vte_terminal_match_add_regex ((VteTerminal*) self, _tmp2_, (guint32) 0);
					vte_terminal_match_set_cursor_name ((VteTerminal*) self, id, "pointer");
					_vte_regex_unref0 (regex);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* _error_ = NULL;
					GError* _tmp3_;
					const gchar* _tmp4_;
					_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp3_ = _error_;
					_tmp4_ = _tmp3_->message;
					g_warning ("TerminalWidget.vala:805: %s", _tmp4_);
					_g_error_free0 (_error_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static gchar*
terminal_terminal_widget_get_link (TerminalTerminalWidget* self,
                                   GdkEvent* event)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = vte_terminal_match_check_event ((VteTerminal*) self, event, NULL);
	result = _tmp0_;
	return result;
}

gchar*
terminal_terminal_widget_get_shell_location (TerminalTerminalWidget* self)
{
	gint pid = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	pid = (gint) ((GPid) self->priv->child_pid);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_strdup_printf ("/proc/%d/cwd", pid);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_read_link (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
terminal_terminal_widget_get_pid_exe_name (TerminalTerminalWidget* self,
                                           gint pid)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar* exe = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = g_strdup_printf ("/proc/%d/exe", pid);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_read_link (_tmp1_, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		exe = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = g_path_get_basename (exe);
		result = _tmp4_;
		_g_free0 (exe);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
terminal_terminal_widget_real_increase_font_size (VteTerminal* base)
{
	TerminalTerminalWidget * self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = (TerminalTerminalWidget*) base;
	_tmp0_ = vte_terminal_get_font_scale ((VteTerminal*) self);
	_tmp1_ = _tmp0_;
	vte_terminal_set_font_scale ((VteTerminal*) self, _tmp1_ + 0.1);
}

static void
terminal_terminal_widget_real_decrease_font_size (VteTerminal* base)
{
	TerminalTerminalWidget * self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = (TerminalTerminalWidget*) base;
	_tmp0_ = vte_terminal_get_font_scale ((VteTerminal*) self);
	_tmp1_ = _tmp0_;
	vte_terminal_set_font_scale ((VteTerminal*) self, _tmp1_ - 0.1);
}

void
terminal_terminal_widget_default_font_size (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	vte_terminal_set_font_scale ((VteTerminal*) self, 1.0);
}

gboolean
terminal_terminal_widget_is_init_complete (TerminalTerminalWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->init_complete;
	return result;
}

void
terminal_terminal_widget_set_init_complete (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	self->priv->init_complete = TRUE;
}

void
terminal_terminal_widget_drag_received (TerminalTerminalWidget* self,
                                        GdkDragContext* context,
                                        gint x,
                                        gint y,
                                        GtkSelectionData* selection_data,
                                        guint target_type,
                                        guint time_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	switch (target_type) {
		case TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_URILIST:
		{
			gchar** uris = NULL;
			gchar** _tmp0_;
			gchar** _tmp1_;
			gint uris_length1;
			gint _uris_size_;
			gchar* path = NULL;
			gchar* uris_s = NULL;
			gchar** _tmp29_;
			gint _tmp29__length1;
			gchar* _tmp30_;
			const gchar* _tmp31_;
			guint8* _tmp32_;
			gint _tmp32__length1;
			gint _tmp33_ = 0;
			guint8* _tmp34_;
			gint _tmp34__length1;
			_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (selection_data);
			uris = _tmp1_;
			uris_length1 = _vala_array_length (_tmp0_);
			_uris_size_ = uris_length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp2_ = FALSE;
					_tmp2_ = TRUE;
					while (TRUE) {
						gchar** _tmp4_;
						gint _tmp4__length1;
						gchar* unquoted_uri = NULL;
						const gchar* _tmp17_;
						GFile* _tmp18_;
						GFile* _tmp19_;
						gchar* _tmp20_;
						const gchar* _tmp21_;
						if (!_tmp2_) {
							gint _tmp3_;
							_tmp3_ = i;
							i = _tmp3_ + 1;
						}
						_tmp2_ = FALSE;
						_tmp4_ = uris;
						_tmp4__length1 = uris_length1;
						if (!(i < _tmp4__length1)) {
							break;
						}
						{
							gchar* _tmp5_ = NULL;
							gchar** _tmp6_;
							gint _tmp6__length1;
							const gchar* _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							_tmp6_ = uris;
							_tmp6__length1 = uris_length1;
							_tmp7_ = _tmp6_[i];
							_tmp8_ = g_shell_unquote (_tmp7_, &_inner_error0_);
							_tmp5_ = _tmp8_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							_tmp9_ = _tmp5_;
							_tmp5_ = NULL;
							_g_free0 (unquoted_uri);
							unquoted_uri = _tmp9_;
							_g_free0 (_tmp5_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							GError* e = NULL;
							gchar** _tmp10_;
							gint _tmp10__length1;
							const gchar* _tmp11_;
							GError* _tmp12_;
							const gchar* _tmp13_;
							gchar** _tmp14_;
							gint _tmp14__length1;
							const gchar* _tmp15_;
							gchar* _tmp16_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp10_ = uris;
							_tmp10__length1 = uris_length1;
							_tmp11_ = _tmp10_[i];
							_tmp12_ = e;
							_tmp13_ = _tmp12_->message;
							g_warning ("TerminalWidget.vala:868: Error unquoting %s. %s", _tmp11_, _tmp13_);
							_tmp14_ = uris;
							_tmp14__length1 = uris_length1;
							_tmp15_ = _tmp14_[i];
							_tmp16_ = g_strdup (_tmp15_);
							_g_free0 (unquoted_uri);
							unquoted_uri = _tmp16_;
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (unquoted_uri);
							_g_free0 (path);
							uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp17_ = unquoted_uri;
						_tmp18_ = g_file_new_for_uri (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_file_get_path (_tmp19_);
						_g_free0 (path);
						path = _tmp20_;
						_g_object_unref0 (_tmp19_);
						_tmp21_ = path;
						if (_tmp21_ != NULL) {
							gchar** _tmp22_;
							gint _tmp22__length1;
							const gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp22_ = uris;
							_tmp22__length1 = uris_length1;
							_tmp23_ = path;
							_tmp24_ = g_shell_quote (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_strconcat (_tmp25_, " ", NULL);
							_g_free0 (_tmp22_[i]);
							_tmp22_[i] = _tmp26_;
							_g_free0 (_tmp25_);
						} else {
							gchar** _tmp27_;
							gint _tmp27__length1;
							gchar* _tmp28_;
							_tmp27_ = uris;
							_tmp27__length1 = uris_length1;
							_tmp28_ = g_strdup ("");
							_g_free0 (_tmp27_[i]);
							_tmp27_[i] = _tmp28_;
						}
						_g_free0 (unquoted_uri);
					}
				}
			}
			_tmp29_ = uris;
			_tmp29__length1 = uris_length1;
			_tmp30_ = _vala_g_strjoinv ("", _tmp29_, (gint) _tmp29__length1);
			uris_s = _tmp30_;
			_tmp31_ = uris_s;
			_tmp32_ = string_get_data (_tmp31_, &_tmp33_);
			_tmp32__length1 = _tmp33_;
			_tmp34_ = _tmp32_;
			_tmp34__length1 = _tmp32__length1;
			vte_terminal_feed_child ((VteTerminal*) self, _tmp34_, (gssize) _tmp34__length1);
			_g_free0 (uris_s);
			_g_free0 (path);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_STRING:
		case TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_TEXT:
		{
			gchar* text = NULL;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp35_ = gtk_selection_data_get_text (selection_data);
			text = _tmp35_;
			_tmp36_ = text;
			terminal_terminal_widget_validated_paste (self, _tmp36_);
			_g_free0 (text);
			break;
		}
		default:
		break;
	}
}

void
terminal_terminal_widget_remember_position (TerminalTerminalWidget* self)
{
	glong col = 0L;
	glong row = 0L;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	g_return_if_fail (self != NULL);
	vte_terminal_get_cursor_position ((VteTerminal*) self, &_tmp0_, &_tmp1_);
	col = _tmp0_;
	row = _tmp1_;
	self->priv->remembered_position = row;
}

void
terminal_terminal_widget_remember_command_start_position (TerminalTerminalWidget* self)
{
	gboolean _tmp0_ = FALSE;
	glong col = 0L;
	glong row = 0L;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	g_return_if_fail (self != NULL);
	if (!self->last_key_was_return) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = terminal_terminal_widget_has_foreground_process (self);
	}
	if (_tmp0_) {
		return;
	}
	vte_terminal_get_cursor_position ((VteTerminal*) self, &_tmp1_, &_tmp2_);
	col = _tmp1_;
	row = _tmp2_;
	self->priv->remembered_command_start_row = row;
	self->last_key_was_return = FALSE;
	terminal_terminal_widget_set_resized (self, FALSE);
}

void
terminal_terminal_widget_remember_command_end_position (TerminalTerminalWidget* self)
{
	gboolean _tmp0_ = FALSE;
	glong col = 0L;
	glong row = 0L;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	g_return_if_fail (self != NULL);
	if (self->last_key_was_return) {
		_tmp0_ = !terminal_terminal_widget_has_foreground_process (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	vte_terminal_get_cursor_position ((VteTerminal*) self, &_tmp1_, &_tmp2_);
	col = _tmp1_;
	row = _tmp2_;
	if ((row - self->priv->remembered_command_end_row) <= ((glong) 2)) {
		self->priv->remembered_command_end_row = row;
	}
	self->last_key_was_return = TRUE;
}

gchar*
terminal_terminal_widget_get_last_output (TerminalTerminalWidget* self,
                                          gboolean include_command)
{
	glong output_end_col = 0L;
	glong output_end_row = 0L;
	glong start_row = 0L;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	glong command_lines = 0L;
	glong _tmp2_ = 0L;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	vte_terminal_get_cursor_position ((VteTerminal*) self, &_tmp0_, &_tmp1_);
	output_end_col = _tmp0_;
	output_end_row = _tmp1_;
	command_lines = self->priv->remembered_command_end_row - self->priv->remembered_command_start_row;
	if (!include_command) {
		start_row = self->priv->remembered_command_end_row + 1;
	} else {
		start_row = self->priv->remembered_command_start_row;
	}
	if (include_command) {
		_tmp2_ = command_lines + 1;
	} else {
		_tmp2_ = (glong) 1;
	}
	if ((output_end_row - start_row) < _tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	self->last_key_was_return = TRUE;
	_tmp4_ = vte_terminal_get_text_range ((VteTerminal*) self, start_row, (glong) 0, output_end_row - 1, (glong) 1000, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

static void
terminal_terminal_widget_scroll_to_command (TerminalTerminalWidget* self,
                                            GSimpleAction* action,
                                            GVariant* parameter)
{
	glong row = 0L;
	glong delta = 0L;
	glong _tmp0_ = 0L;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GdkWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	vte_terminal_get_cursor_position ((VteTerminal*) self, NULL, &_tmp0_);
	row = _tmp0_;
	delta = self->priv->remembered_position - row;
	_tmp1_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_adjustment_get_value (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
	gtk_adjustment_set_value (_tmp4_, _tmp6_ + ((((gint) delta) + (gdk_window_get_height (_tmp7_) / vte_terminal_get_char_height ((VteTerminal*) self))) - 1));
	g_simple_action_set_enabled (action, FALSE);
}

void
terminal_terminal_widget_reload (TerminalTerminalWidget* self)
{
	gchar* old_loc = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = terminal_terminal_widget_get_shell_location (self);
	old_loc = _tmp0_;
	if (terminal_terminal_widget_confirm_kill_fg_process (self, _ ("Are you sure you want to reload this tab?"), _ ("Reload Tab"))) {
		const gchar* _tmp1_;
		vte_terminal_reset ((VteTerminal*) self, TRUE, TRUE);
		_tmp1_ = old_loc;
		terminal_terminal_widget_active_shell (self, _tmp1_);
	}
	_g_free0 (old_loc);
}

static gboolean
__lambda35_ (TerminalTerminalWidget* self)
{
	gchar* cwd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint pid = 0;
	gint _tmp4_ = 0;
	gboolean result;
	if (self->priv->contents_changed_continue) {
		self->priv->contents_changed_continue = FALSE;
		result = G_SOURCE_CONTINUE;
		return result;
	}
	_tmp0_ = terminal_terminal_widget_get_shell_location (self);
	cwd = _tmp0_;
	_tmp1_ = cwd;
	_tmp2_ = self->priv->_current_working_directory;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		const gchar* _tmp3_;
		_tmp3_ = cwd;
		terminal_terminal_widget_update_current_working_directory (self, _tmp3_);
	}
	terminal_terminal_widget_try_get_foreground_pid (self, &_tmp4_);
	pid = _tmp4_;
	if (pid != ((gint) self->priv->fg_pid)) {
		gchar* name = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = terminal_terminal_widget_get_pid_exe_name (self, pid);
		name = _tmp5_;
		_tmp6_ = name;
		g_signal_emit (self, terminal_terminal_widget_signals[TERMINAL_TERMINAL_WIDGET_FOREGROUND_PROCESS_CHANGED_SIGNAL], 0, _tmp6_);
		self->priv->fg_pid = (GPid) pid;
		_g_free0 (name);
	}
	self->priv->contents_changed_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	_g_free0 (cwd);
	return result;
}

static gboolean
___lambda35__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda35_ ((TerminalTerminalWidget*) self);
	return result;
}

static void
terminal_terminal_widget_on_contents_changed (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	self->priv->contents_changed_continue = TRUE;
	if (self->priv->contents_changed_timeout_id > ((guint) 0)) {
		return;
	}
	self->priv->contents_changed_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TERMINAL_TERMINAL_WIDGET_CONTENTS_CHANGED_DELAY_MSEC, ___lambda35__gsource_func, g_object_ref (self), g_object_unref);
}

void
terminal_terminal_widget_prepare_to_close (TerminalTerminalWidget* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->contents_changed_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->contents_changed_timeout_id);
		self->priv->contents_changed_timeout_id = (guint) 0;
	}
}

const gchar*
terminal_terminal_widget_get_current_working_directory (TerminalTerminalWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_working_directory;
	result = _tmp0_;
	return result;
}

static void
terminal_terminal_widget_set_current_working_directory (TerminalTerminalWidget* self,
                                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_current_working_directory (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_current_working_directory);
		self->priv->_current_working_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY]);
	}
}

const gchar*
terminal_terminal_widget_get_program_string (TerminalTerminalWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_program_string;
	result = _tmp0_;
	return result;
}

void
terminal_terminal_widget_set_program_string (TerminalTerminalWidget* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_program_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_program_string);
		self->priv->_program_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY]);
	}
}

gboolean
terminal_terminal_widget_get_resized (TerminalTerminalWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_resized;
	return result;
}

void
terminal_terminal_widget_set_resized (TerminalTerminalWidget* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_resized (self);
	if (old_value != value) {
		self->priv->_resized = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY]);
	}
}

TerminalMainWindow*
terminal_terminal_widget_get_main_window (TerminalTerminalWidget* self)
{
	TerminalMainWindow* result;
	TerminalMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}

void
terminal_terminal_widget_set_main_window (TerminalTerminalWidget* self,
                                          TerminalMainWindow* value)
{
	TerminalMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_main_window (self);
	if (old_value != value) {
		self->priv->_main_window = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY]);
	}
}

static TerminalApplication*
terminal_terminal_widget_get_app (TerminalTerminalWidget* self)
{
	TerminalApplication* result;
	TerminalMainWindow* _tmp0_;
	TerminalApplication* _tmp1_;
	TerminalApplication* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = terminal_main_window_get_app (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

const gchar*
terminal_terminal_widget_get_tab_label (TerminalTerminalWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	HdyTabPage* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->tab;
	if (_tmp1_ != NULL) {
		HdyTabPage* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->tab;
		_tmp3_ = hdy_tab_page_get_title (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = "";
	}
	result = _tmp0_;
	return result;
}

void
terminal_terminal_widget_set_tab_label (TerminalTerminalWidget* self,
                                        const gchar* value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		HdyTabPage* _tmp1_;
		_tmp1_ = self->tab;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		HdyTabPage* _tmp2_;
		_tmp2_ = self->tab;
		hdy_tab_page_set_title (_tmp2_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY]);
}

gboolean
terminal_terminal_widget_get_child_has_exited (TerminalTerminalWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_child_has_exited;
	return result;
}

static void
terminal_terminal_widget_set_child_has_exited (TerminalTerminalWidget* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_child_has_exited (self);
	if (old_value != value) {
		self->priv->_child_has_exited = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY]);
	}
}

gboolean
terminal_terminal_widget_get_killed (TerminalTerminalWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_killed;
	return result;
}

static void
terminal_terminal_widget_set_killed (TerminalTerminalWidget* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_terminal_widget_get_killed (self);
	if (old_value != value) {
		self->priv->_killed = value;
		g_object_notify_by_pspec ((GObject *) self, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY]);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TerminalTerminalWidget* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_terminal_terminal_widget_update_theme_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	terminal_terminal_widget_update_theme ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_update_audible_bell_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	terminal_terminal_widget_update_audible_bell ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_update_theme_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	terminal_terminal_widget_update_theme ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_update_cursor_shape_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	terminal_terminal_widget_update_cursor_shape ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_pointer_focus_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                           gdouble x,
                                                                           gdouble y,
                                                                           gpointer self)
{
	terminal_terminal_widget_pointer_focus ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_scroll_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                     gdouble dx,
                                                                     gdouble dy,
                                                                     gpointer self)
{
	terminal_terminal_widget_scroll ((TerminalTerminalWidget*) self, dx, dy);
}

static void
_terminal_terminal_widget___lambda36_ (TerminalTerminalWidget* self)
{
	self->priv->scroll_delta = 0.0;
}

static void
__terminal_terminal_widget___lambda36__gtk_event_controller_scroll_scroll_end (GtkEventControllerScroll* _sender,
                                                                               gpointer self)
{
	_terminal_terminal_widget___lambda36_ ((TerminalTerminalWidget*) self);
}

static gboolean
_terminal_terminal_widget_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self)
{
	gboolean result;
	result = terminal_terminal_widget_key_pressed ((TerminalTerminalWidget*) self, keyval, keycode, state);
	return result;
}

static void
_terminal_terminal_widget___lambda37_ (TerminalTerminalWidget* self)
{
	GtkEventControllerScroll* _tmp0_;
	_tmp0_ = self->priv->scroll_controller;
	gtk_event_controller_scroll_set_flags (_tmp0_, GTK_EVENT_CONTROLLER_SCROLL_NONE);
}

static void
__terminal_terminal_widget___lambda37__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                              guint keyval,
                                                                              guint keycode,
                                                                              GdkModifierType state,
                                                                              gpointer self)
{
	_terminal_terminal_widget___lambda37_ ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget___lambda38_ (TerminalTerminalWidget* self)
{
	GtkEventControllerScroll* _tmp0_;
	_tmp0_ = self->priv->scroll_controller;
	gtk_event_controller_scroll_set_flags (_tmp0_, GTK_EVENT_CONTROLLER_SCROLL_NONE);
}

static void
__terminal_terminal_widget___lambda38__gtk_event_controller_key_focus_out (GtkEventControllerKey* _sender,
                                                                           gpointer self)
{
	_terminal_terminal_widget___lambda38_ ((TerminalTerminalWidget*) self);
}

static gboolean
_terminal_terminal_widget___lambda39_ (TerminalTerminalWidget* self)
{
	gboolean result;
	self->priv->modifier_pressed = !self->priv->modifier_pressed;
	result = TRUE;
	return result;
}

static gboolean
__terminal_terminal_widget___lambda39__gtk_event_controller_key_modifiers (GtkEventControllerKey* _sender,
                                                                           GdkModifierType object,
                                                                           gpointer self)
{
	gboolean result;
	result = _terminal_terminal_widget___lambda39_ ((TerminalTerminalWidget*) self);
	return result;
}

static void
_terminal_terminal_widget_primary_pressed_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                           gint n_press,
                                                                           gdouble x,
                                                                           gdouble y,
                                                                           gpointer self)
{
	terminal_terminal_widget_primary_pressed ((TerminalTerminalWidget*) self, _sender, n_press, x, y);
}

static void
_terminal_terminal_widget_secondary_released_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                               gint n_press,
                                                                               gdouble x,
                                                                               gdouble y,
                                                                               gpointer self)
{
	terminal_terminal_widget_secondary_released ((TerminalTerminalWidget*) self, _sender, n_press, x, y);
}

static gboolean
_gtk_event_controller_handle_event_gtk_widget_event (GtkWidget* _sender,
                                                     GdkEvent* event,
                                                     gpointer self)
{
	gboolean result;
	result = gtk_event_controller_handle_event ((GtkEventController*) self, event);
	return result;
}

static void
_terminal_terminal_widget___lambda40_ (TerminalTerminalWidget* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->copy_action;
	g_simple_action_set_enabled (_tmp0_, vte_terminal_get_has_selection ((VteTerminal*) self));
}

static void
__terminal_terminal_widget___lambda40__vte_terminal_selection_changed (VteTerminal* _sender,
                                                                       gpointer self)
{
	_terminal_terminal_widget___lambda40_ ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget___lambda41_ (TerminalTerminalWidget* self)
{
	terminal_terminal_widget_set_resized (self, TRUE);
}

static void
__terminal_terminal_widget___lambda41__gtk_widget_size_allocate (GtkWidget* _sender,
                                                                 GtkAllocation* allocation,
                                                                 gpointer self)
{
	_terminal_terminal_widget___lambda41_ ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_on_contents_changed_vte_terminal_contents_changed (VteTerminal* _sender,
                                                                             gpointer self)
{
	terminal_terminal_widget_on_contents_changed ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_on_child_exited_vte_terminal_child_exited (VteTerminal* _sender,
                                                                     gint status,
                                                                     gpointer self)
{
	terminal_terminal_widget_on_child_exited ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_setup_menu_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                 GdkEventOwnerChange* event,
                                                                 gpointer self)
{
	terminal_terminal_widget_setup_menu ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget___lambda42_ (Block5Data* _data5_)
{
	TerminalTerminalWidget* self;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	self = _data5_->self;
	_tmp0_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	self->priv->clipboard = _tmp0_;
	_tmp1_ = self->priv->clipboard;
	g_signal_connect_object (_tmp1_, "owner-change", (GCallback) _terminal_terminal_widget_setup_menu_gtk_clipboard_owner_change, self, 0);
	g_signal_handler_disconnect ((GObject*) self, _data5_->once);
}

static void
__terminal_terminal_widget___lambda42__gtk_widget_realize (GtkWidget* _sender,
                                                           gpointer self)
{
	_terminal_terminal_widget___lambda42_ (self);
}

static void
_vala_array_add1 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add2 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add3 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTargetEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_terminal_terminal_widget_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                       GdkDragContext* context,
                                                                       gint x,
                                                                       gint y,
                                                                       GtkSelectionData* selection_data,
                                                                       guint info,
                                                                       guint time_,
                                                                       gpointer self)
{
	terminal_terminal_widget_drag_received ((TerminalTerminalWidget*) self, context, x, y, selection_data, info, time_);
}

static void
_terminal_terminal_widget___lambda43_ (TerminalTerminalWidget* self)
{
	vte_terminal_copy_clipboard ((VteTerminal*) self);
}

static void
__terminal_terminal_widget___lambda43__g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	_terminal_terminal_widget___lambda43_ ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_copy_output_g_simple_action_activate (GSimpleAction* _sender,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	terminal_terminal_widget_copy_output ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_action_clear_screen_g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	terminal_terminal_widget_action_clear_screen ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_action_reset_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	terminal_terminal_widget_action_reset ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget___lambda44_ (TerminalTerminalWidget* self)
{
	vte_terminal_paste_clipboard ((VteTerminal*) self);
}

static void
__terminal_terminal_widget___lambda44__g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	_terminal_terminal_widget___lambda44_ ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_reload_g_simple_action_activate (GSimpleAction* _sender,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	terminal_terminal_widget_reload ((TerminalTerminalWidget*) self);
}

static void
_terminal_terminal_widget_scroll_to_command_g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	terminal_terminal_widget_scroll_to_command ((TerminalTerminalWidget*) self, _sender, parameter);
}

static void
_vte_terminal_select_all_g_simple_action_activate (GSimpleAction* _sender,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	vte_terminal_select_all ((VteTerminal*) self);
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static void
_terminal_terminal_widget___lambda45_ (TerminalTerminalWidget* self,
                                       GVariant* p)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	_tmp0_ = _variant_get1 (p);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("in")))) {
		switch (0) {
			default:
			{
				g_signal_emit_by_name ((VteTerminal*) self, "increase-font-size");
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("out")))) {
		switch (0) {
			default:
			{
				g_signal_emit_by_name ((VteTerminal*) self, "decrease-font-size");
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("default")))) {
		switch (0) {
			default:
			{
				terminal_terminal_widget_default_font_size (self);
				break;
			}
		}
	}
}

static void
__terminal_terminal_widget___lambda45__g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	_terminal_terminal_widget___lambda45_ ((TerminalTerminalWidget*) self, parameter);
}

static GObject *
terminal_terminal_widget_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalTerminalWidget * self;
	Block5Data* _data5_;
	gint _tmp0_;
	gchar* _tmp1_;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp2_;
	GraniteSettings* _tmp3_;
	GraniteSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GtkEventControllerMotion* _tmp14_ = NULL;
	GtkEventControllerMotion* _tmp15_;
	GtkEventControllerScroll* _tmp16_ = NULL;
	GtkEventControllerScroll* _tmp17_;
	GtkEventControllerScroll* _tmp18_;
	GtkEventControllerKey* _tmp19_ = NULL;
	GtkEventControllerKey* _tmp20_;
	GtkEventControllerKey* _tmp21_;
	GtkEventControllerKey* _tmp22_;
	GtkEventControllerKey* _tmp23_;
	GtkGestureMultiPress* _tmp24_ = NULL;
	GtkGestureMultiPress* _tmp25_;
	GtkGestureMultiPress* _tmp26_ = NULL;
	GtkGestureMultiPress* _tmp27_;
	GtkEventControllerKey* _tmp28_;
	gulong _tmp29_;
	GtkTargetEntry uri_entry = {0};
	GtkTargetEntry _tmp30_ = {0};
	GtkTargetEntry string_entry = {0};
	GtkTargetEntry _tmp31_ = {0};
	GtkTargetEntry text_entry = {0};
	GtkTargetEntry _tmp32_ = {0};
	GtkTargetEntry* targets = NULL;
	GtkTargetEntry* _tmp33_;
	gint targets_length1;
	gint _targets_size_;
	GtkTargetEntry _tmp34_;
	GtkTargetEntry _tmp35_;
	GtkTargetEntry _tmp36_;
	GtkTargetEntry* _tmp37_;
	gint _tmp37__length1;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp38_;
	GSimpleActionGroup* _tmp39_;
	GSimpleAction* _tmp40_;
	GSimpleAction* _tmp41_;
	GSimpleAction* _tmp42_;
	GSimpleActionGroup* _tmp43_;
	GSimpleAction* _tmp44_;
	GSimpleAction* _tmp45_;
	GSimpleAction* _tmp46_;
	GSimpleAction* _tmp47_;
	GSimpleActionGroup* _tmp48_;
	GSimpleAction* _tmp49_;
	GSimpleAction* _tmp50_;
	GSimpleAction* _tmp51_;
	GSimpleAction* _tmp52_;
	GSimpleActionGroup* _tmp53_;
	GSimpleAction* _tmp54_;
	GSimpleAction* _tmp55_;
	GSimpleAction* _tmp56_;
	GSimpleAction* _tmp57_;
	GSimpleActionGroup* _tmp58_;
	GSimpleAction* _tmp59_;
	GSimpleAction* _tmp60_;
	GSimpleAction* _tmp61_;
	GSimpleActionGroup* _tmp62_;
	GSimpleAction* _tmp63_;
	GSimpleAction* reload_action = NULL;
	GSimpleAction* _tmp64_;
	GSimpleAction* _tmp65_;
	GSimpleActionGroup* _tmp66_;
	GSimpleAction* _tmp67_;
	GSimpleAction* _tmp68_;
	GSimpleAction* _tmp69_;
	GSimpleAction* _tmp70_;
	GSimpleActionGroup* _tmp71_;
	GSimpleAction* _tmp72_;
	GSimpleAction* select_all_action = NULL;
	GSimpleAction* _tmp73_;
	GSimpleAction* _tmp74_;
	GSimpleActionGroup* _tmp75_;
	GSimpleAction* _tmp76_;
	GSimpleAction* zoom_action = NULL;
	const GVariantType* _tmp77_;
	GSimpleAction* _tmp78_;
	GSimpleAction* _tmp79_;
	GSimpleActionGroup* _tmp80_;
	GSimpleAction* _tmp81_;
	parent_class = G_OBJECT_CLASS (terminal_terminal_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	g_object_set ((VteTerminal*) self, "pointer-autohide", TRUE, NULL);
	_tmp0_ = terminal_terminal_widget_terminal_id_counter;
	terminal_terminal_widget_terminal_id_counter = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_g_free0 (self->terminal_id);
	self->terminal_id = _tmp1_;
	self->priv->init_complete = FALSE;
	terminal_terminal_widget_set_child_has_exited (self, FALSE);
	terminal_terminal_widget_set_killed (self, FALSE);
	terminal_terminal_widget_update_audible_bell (self);
	terminal_terminal_widget_update_cursor_shape (self);
	terminal_terminal_widget_update_theme (self);
	_tmp2_ = granite_settings_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	granite_settings = _tmp3_;
	_tmp4_ = granite_settings;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::prefers-color-scheme", (GCallback) _terminal_terminal_widget_update_theme_g_object_notify, self, 0);
	_tmp5_ = terminal_application_settings;
	g_signal_connect_object (_tmp5_, "changed::audible-bell", (GCallback) _terminal_terminal_widget_update_audible_bell_g_settings_changed, self, 0);
	_tmp6_ = terminal_application_settings;
	g_signal_connect_object (_tmp6_, "changed::background", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp7_ = terminal_application_settings;
	g_signal_connect_object (_tmp7_, "changed::cursor-color", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp8_ = terminal_application_settings;
	g_signal_connect_object (_tmp8_, "changed::cursor-shape", (GCallback) _terminal_terminal_widget_update_cursor_shape_g_settings_changed, self, 0);
	_tmp9_ = terminal_application_settings;
	g_signal_connect_object (_tmp9_, "changed::follow-system-style", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp10_ = terminal_application_settings;
	g_signal_connect_object (_tmp10_, "changed::foreground", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp11_ = terminal_application_settings;
	g_signal_connect_object (_tmp11_, "changed::palette", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp12_ = terminal_application_settings;
	g_signal_connect_object (_tmp12_, "changed::prefer-dark-style", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp13_ = terminal_application_settings;
	g_signal_connect_object (_tmp13_, "changed::theme", (GCallback) _terminal_terminal_widget_update_theme_g_settings_changed, self, 0);
	_tmp14_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp14_, GTK_PHASE_CAPTURE);
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp14_;
	_tmp15_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp15_, "enter", (GCallback) _terminal_terminal_widget_pointer_focus_gtk_event_controller_motion_enter, self, 0);
	_tmp16_ = (GtkEventControllerScroll*) gtk_event_controller_scroll_new ((GtkWidget*) self, GTK_EVENT_CONTROLLER_SCROLL_NONE);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp16_, GTK_PHASE_TARGET);
	_g_object_unref0 (self->priv->scroll_controller);
	self->priv->scroll_controller = _tmp16_;
	_tmp17_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp17_, "scroll", (GCallback) _terminal_terminal_widget_scroll_gtk_event_controller_scroll_scroll, self, 0);
	_tmp18_ = self->priv->scroll_controller;
	g_signal_connect_object (_tmp18_, "scroll-end", (GCallback) __terminal_terminal_widget___lambda36__gtk_event_controller_scroll_scroll_end, self, 0);
	_tmp19_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp19_, GTK_PHASE_NONE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp19_;
	_tmp20_ = self->priv->key_controller;
	g_signal_connect_object (_tmp20_, "key-pressed", (GCallback) _terminal_terminal_widget_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp21_ = self->priv->key_controller;
	g_signal_connect_object (_tmp21_, "key-released", (GCallback) __terminal_terminal_widget___lambda37__gtk_event_controller_key_key_released, self, 0);
	_tmp22_ = self->priv->key_controller;
	g_signal_connect_object (_tmp22_, "focus-out", (GCallback) __terminal_terminal_widget___lambda38__gtk_event_controller_key_focus_out, self, 0);
	_tmp23_ = self->priv->key_controller;
	g_signal_connect_object (_tmp23_, "modifiers", (GCallback) __terminal_terminal_widget___lambda39__gtk_event_controller_key_modifiers, self, 0);
	_tmp24_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp24_, GTK_PHASE_TARGET);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp24_, (guint) 1);
	_g_object_unref0 (self->priv->primary_gesture);
	self->priv->primary_gesture = _tmp24_;
	_tmp25_ = self->priv->primary_gesture;
	g_signal_connect_object (_tmp25_, "pressed", (GCallback) _terminal_terminal_widget_primary_pressed_gtk_gesture_multi_press_pressed, self, 0);
	_tmp26_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp26_, GTK_PHASE_TARGET);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp26_, (guint) 3);
	_g_object_unref0 (self->priv->secondary_gesture);
	self->priv->secondary_gesture = _tmp26_;
	_tmp27_ = self->priv->secondary_gesture;
	g_signal_connect_object (_tmp27_, "released", (GCallback) _terminal_terminal_widget_secondary_released_gtk_gesture_multi_press_released, self, 0);
	_tmp28_ = self->priv->key_controller;
	g_signal_connect_object ((GtkWidget*) self, "event", (GCallback) _gtk_event_controller_handle_event_gtk_widget_event, (GtkEventController*) _tmp28_, 0);
	g_signal_connect_object ((VteTerminal*) self, "selection-changed", (GCallback) __terminal_terminal_widget___lambda40__vte_terminal_selection_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __terminal_terminal_widget___lambda41__gtk_widget_size_allocate, self, 0);
	g_signal_connect_object ((VteTerminal*) self, "contents-changed", (GCallback) _terminal_terminal_widget_on_contents_changed_vte_terminal_contents_changed, self, 0);
	g_signal_connect_object ((VteTerminal*) self, "child-exited", (GCallback) _terminal_terminal_widget_on_child_exited_vte_terminal_child_exited, self, 0);
	_data5_->once = (gulong) 0;
	_tmp29_ = g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) __terminal_terminal_widget___lambda42__gtk_widget_realize, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_data5_->once = _tmp29_;
	_tmp30_.target = "text/uri-list";
	_tmp30_.flags = (guint) GTK_TARGET_OTHER_APP;
	_tmp30_.info = (guint) TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_URILIST;
	uri_entry = _tmp30_;
	_tmp31_.target = "STRING";
	_tmp31_.flags = (guint) GTK_TARGET_OTHER_APP;
	_tmp31_.info = (guint) TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_STRING;
	string_entry = _tmp31_;
	_tmp32_.target = "text/plain";
	_tmp32_.flags = (guint) GTK_TARGET_OTHER_APP;
	_tmp32_.info = (guint) TERMINAL_TERMINAL_WIDGET_DROP_TARGETS_TEXT;
	text_entry = _tmp32_;
	_tmp33_ = g_new0 (GtkTargetEntry, 0);
	targets = _tmp33_;
	targets_length1 = 0;
	_targets_size_ = targets_length1;
	_tmp34_ = uri_entry;
	_vala_array_add1 (&targets, &targets_length1, &_targets_size_, &_tmp34_);
	_tmp35_ = string_entry;
	_vala_array_add2 (&targets, &targets_length1, &_targets_size_, &_tmp35_);
	_tmp36_ = text_entry;
	_vala_array_add3 (&targets, &targets_length1, &_targets_size_, &_tmp36_);
	_tmp37_ = targets;
	_tmp37__length1 = targets_length1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp37_, (gint) _tmp37__length1, GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _terminal_terminal_widget_drag_received_gtk_widget_drag_data_received, self, 0);
	terminal_terminal_widget_clickable (self, TERMINAL_TERMINAL_WIDGET_REGEX_STRINGS, (gint) G_N_ELEMENTS (TERMINAL_TERMINAL_WIDGET_REGEX_STRINGS));
	_tmp38_ = g_simple_action_group_new ();
	action_group = _tmp38_;
	_tmp39_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "term", (GActionGroup*) _tmp39_);
	_tmp40_ = g_simple_action_new ("copy", NULL);
	_g_object_unref0 (self->priv->copy_action);
	self->priv->copy_action = _tmp40_;
	_tmp41_ = self->priv->copy_action;
	g_simple_action_set_enabled (_tmp41_, FALSE);
	_tmp42_ = self->priv->copy_action;
	g_signal_connect_object (_tmp42_, "activate", (GCallback) __terminal_terminal_widget___lambda43__g_simple_action_activate, self, 0);
	_tmp43_ = action_group;
	_tmp44_ = self->priv->copy_action;
	g_action_map_add_action ((GActionMap*) _tmp43_, (GAction*) _tmp44_);
	_tmp45_ = g_simple_action_new ("copy-output", NULL);
	_g_object_unref0 (self->priv->copy_output_action);
	self->priv->copy_output_action = _tmp45_;
	_tmp46_ = self->priv->copy_output_action;
	g_simple_action_set_enabled (_tmp46_, FALSE);
	_tmp47_ = self->priv->copy_output_action;
	g_signal_connect_object (_tmp47_, "activate", (GCallback) _terminal_terminal_widget_copy_output_g_simple_action_activate, self, 0);
	_tmp48_ = action_group;
	_tmp49_ = self->priv->copy_output_action;
	g_action_map_add_action ((GActionMap*) _tmp48_, (GAction*) _tmp49_);
	_tmp50_ = g_simple_action_new ("clear-screen", NULL);
	_g_object_unref0 (self->priv->clear_screen_action);
	self->priv->clear_screen_action = _tmp50_;
	_tmp51_ = self->priv->clear_screen_action;
	g_simple_action_set_enabled (_tmp51_, TRUE);
	_tmp52_ = self->priv->clear_screen_action;
	g_signal_connect_object (_tmp52_, "activate", (GCallback) _terminal_terminal_widget_action_clear_screen_g_simple_action_activate, self, 0);
	_tmp53_ = action_group;
	_tmp54_ = self->priv->clear_screen_action;
	g_action_map_add_action ((GActionMap*) _tmp53_, (GAction*) _tmp54_);
	_tmp55_ = g_simple_action_new ("reset", NULL);
	_g_object_unref0 (self->priv->reset_action);
	self->priv->reset_action = _tmp55_;
	_tmp56_ = self->priv->reset_action;
	g_simple_action_set_enabled (_tmp56_, TRUE);
	_tmp57_ = self->priv->reset_action;
	g_signal_connect_object (_tmp57_, "activate", (GCallback) _terminal_terminal_widget_action_reset_g_simple_action_activate, self, 0);
	_tmp58_ = action_group;
	_tmp59_ = self->priv->reset_action;
	g_action_map_add_action ((GActionMap*) _tmp58_, (GAction*) _tmp59_);
	_tmp60_ = g_simple_action_new ("paste", NULL);
	_g_object_unref0 (self->priv->paste_action);
	self->priv->paste_action = _tmp60_;
	_tmp61_ = self->priv->paste_action;
	g_signal_connect_object (_tmp61_, "activate", (GCallback) __terminal_terminal_widget___lambda44__g_simple_action_activate, self, 0);
	_tmp62_ = action_group;
	_tmp63_ = self->priv->paste_action;
	g_action_map_add_action ((GActionMap*) _tmp62_, (GAction*) _tmp63_);
	_tmp64_ = g_simple_action_new ("reload", NULL);
	reload_action = _tmp64_;
	_tmp65_ = reload_action;
	g_signal_connect_object (_tmp65_, "activate", (GCallback) _terminal_terminal_widget_reload_g_simple_action_activate, self, 0);
	_tmp66_ = action_group;
	_tmp67_ = reload_action;
	g_action_map_add_action ((GActionMap*) _tmp66_, (GAction*) _tmp67_);
	_tmp68_ = g_simple_action_new ("scroll-to-command", NULL);
	_g_object_unref0 (self->priv->scroll_to_command_action);
	self->priv->scroll_to_command_action = _tmp68_;
	_tmp69_ = self->priv->scroll_to_command_action;
	g_simple_action_set_enabled (_tmp69_, FALSE);
	_tmp70_ = self->priv->scroll_to_command_action;
	g_signal_connect_object (_tmp70_, "activate", (GCallback) _terminal_terminal_widget_scroll_to_command_g_simple_action_activate, self, 0);
	_tmp71_ = action_group;
	_tmp72_ = self->priv->scroll_to_command_action;
	g_action_map_add_action ((GActionMap*) _tmp71_, (GAction*) _tmp72_);
	_tmp73_ = g_simple_action_new ("select-all", NULL);
	select_all_action = _tmp73_;
	_tmp74_ = select_all_action;
	g_signal_connect_object (_tmp74_, "activate", (GCallback) _vte_terminal_select_all_g_simple_action_activate, (VteTerminal*) self, 0);
	_tmp75_ = action_group;
	_tmp76_ = select_all_action;
	g_action_map_add_action ((GActionMap*) _tmp75_, (GAction*) _tmp76_);
	_tmp77_ = G_VARIANT_TYPE_STRING;
	_tmp78_ = g_simple_action_new ("zoom", _tmp77_);
	zoom_action = _tmp78_;
	_tmp79_ = zoom_action;
	g_signal_connect_object (_tmp79_, "activate", (GCallback) __terminal_terminal_widget___lambda45__g_simple_action_activate, self, 0);
	_tmp80_ = action_group;
	_tmp81_ = zoom_action;
	g_action_map_add_action ((GActionMap*) _tmp80_, (GAction*) _tmp81_);
	_g_object_unref0 (zoom_action);
	_g_object_unref0 (select_all_action);
	_g_object_unref0 (reload_action);
	_g_object_unref0 (action_group);
	targets = (g_free (targets), NULL);
	_g_object_unref0 (granite_settings);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
terminal_terminal_widget_class_init (TerminalTerminalWidgetClass * klass,
                                     gpointer klass_data)
{
	terminal_terminal_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalTerminalWidget_private_offset);
	((VteTerminalClass *) klass)->copy_clipboard = (void (*) (VteTerminal*)) terminal_terminal_widget_real_copy_clipboard;
	((VteTerminalClass *) klass)->paste_clipboard = (void (*) (VteTerminal*)) terminal_terminal_widget_real_paste_clipboard;
	((VteTerminalClass *) klass)->increase_font_size = (void (*) (VteTerminal*)) terminal_terminal_widget_real_increase_font_size;
	((VteTerminalClass *) klass)->decrease_font_size = (void (*) (VteTerminal*)) terminal_terminal_widget_real_decrease_font_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_terminal_terminal_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_terminal_terminal_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = terminal_terminal_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_terminal_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY] = g_param_spec_string ("current-working-directory", "current-working-directory", "current-working-directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY] = g_param_spec_string ("program-string", "program-string", "program-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY] = g_param_spec_boolean ("resized", "resized", "resized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY] = g_param_spec_object ("main-window", "main-window", "main-window", TERMINAL_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY] = g_param_spec_string ("tab-label", "tab-label", "tab-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY] = g_param_spec_boolean ("child-has-exited", "child-has-exited", "child-has-exited", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY, terminal_terminal_widget_properties[TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY] = g_param_spec_boolean ("killed", "killed", "killed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	terminal_terminal_widget_signals[TERMINAL_TERMINAL_WIDGET_CWD_CHANGED_SIGNAL] = g_signal_new ("cwd-changed", TERMINAL_TYPE_TERMINAL_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	terminal_terminal_widget_signals[TERMINAL_TERMINAL_WIDGET_FOREGROUND_PROCESS_CHANGED_SIGNAL] = g_signal_new ("foreground-process-changed", TERMINAL_TYPE_TERMINAL_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
terminal_terminal_widget_instance_init (TerminalTerminalWidget * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = terminal_terminal_widget_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_current_working_directory = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_program_string = _tmp1_;
	self->priv->remembered_command_start_row = (glong) 0;
	self->priv->remembered_command_end_row = (glong) 0;
	self->last_key_was_return = TRUE;
	self->priv->modifier_pressed = FALSE;
	self->priv->scroll_delta = 0.0;
	self->priv->contents_changed_timeout_id = (guint) 0;
	self->priv->contents_changed_continue = TRUE;
}

static void
terminal_terminal_widget_finalize (GObject * obj)
{
	TerminalTerminalWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget);
	_g_free0 (self->terminal_id);
	_g_free0 (self->priv->_current_working_directory);
	_g_free0 (self->priv->_program_string);
	_g_free0 (self->link_uri);
	_g_object_unref0 (self->priv->copy_action);
	_g_object_unref0 (self->priv->copy_output_action);
	_g_object_unref0 (self->priv->clear_screen_action);
	_g_object_unref0 (self->priv->reset_action);
	_g_object_unref0 (self->priv->paste_action);
	_g_object_unref0 (self->priv->scroll_to_command_action);
	_g_object_unref0 (self->priv->motion_controller);
	_g_object_unref0 (self->priv->scroll_controller);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->primary_gesture);
	_g_object_unref0 (self->priv->secondary_gesture);
	G_OBJECT_CLASS (terminal_terminal_widget_parent_class)->finalize (obj);
}

static GType
terminal_terminal_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalTerminalWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_terminal_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalTerminalWidget), 0, (GInstanceInitFunc) terminal_terminal_widget_instance_init, NULL };
	GType terminal_terminal_widget_type_id;
	terminal_terminal_widget_type_id = g_type_register_static (vte_terminal_get_type (), "TerminalTerminalWidget", &g_define_type_info, 0);
	TerminalTerminalWidget_private_offset = g_type_add_instance_private (terminal_terminal_widget_type_id, sizeof (TerminalTerminalWidgetPrivate));
	return terminal_terminal_widget_type_id;
}

GType
terminal_terminal_widget_get_type (void)
{
	static volatile gsize terminal_terminal_widget_type_id__once = 0;
	if (g_once_init_enter (&terminal_terminal_widget_type_id__once)) {
		GType terminal_terminal_widget_type_id;
		terminal_terminal_widget_type_id = terminal_terminal_widget_get_type_once ();
		g_once_init_leave (&terminal_terminal_widget_type_id__once, terminal_terminal_widget_type_id);
	}
	return terminal_terminal_widget_type_id__once;
}

static void
_vala_terminal_terminal_widget_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	TerminalTerminalWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget);
	switch (property_id) {
		case TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY:
		g_value_set_string (value, terminal_terminal_widget_get_current_working_directory (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY:
		g_value_set_string (value, terminal_terminal_widget_get_program_string (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY:
		g_value_set_boolean (value, terminal_terminal_widget_get_resized (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY:
		g_value_set_object (value, terminal_terminal_widget_get_main_window (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY:
		g_value_set_string (value, terminal_terminal_widget_get_tab_label (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY:
		g_value_set_boolean (value, terminal_terminal_widget_get_child_has_exited (self));
		break;
		case TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY:
		g_value_set_boolean (value, terminal_terminal_widget_get_killed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_terminal_terminal_widget_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	TerminalTerminalWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget);
	switch (property_id) {
		case TERMINAL_TERMINAL_WIDGET_CURRENT_WORKING_DIRECTORY_PROPERTY:
		terminal_terminal_widget_set_current_working_directory (self, g_value_get_string (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_PROGRAM_STRING_PROPERTY:
		terminal_terminal_widget_set_program_string (self, g_value_get_string (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_RESIZED_PROPERTY:
		terminal_terminal_widget_set_resized (self, g_value_get_boolean (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_MAIN_WINDOW_PROPERTY:
		terminal_terminal_widget_set_main_window (self, g_value_get_object (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_TAB_LABEL_PROPERTY:
		terminal_terminal_widget_set_tab_label (self, g_value_get_string (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_CHILD_HAS_EXITED_PROPERTY:
		terminal_terminal_widget_set_child_has_exited (self, g_value_get_boolean (value));
		break;
		case TERMINAL_TERMINAL_WIDGET_KILLED_PROPERTY:
		terminal_terminal_widget_set_killed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

