/* Main.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Main.vala, do not modify */

/*-
 * Copyright 2020-2023 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
 * Boston, MA 02110-1335 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "pantheon-files-core.h"
#include <granite.h>
#include <locale.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_FILE_CHOOSER_PORTAL (files_file_chooser_portal_get_type ())
#define FILES_FILE_CHOOSER_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CHOOSER_PORTAL, FilesFileChooserPortal))
#define FILES_FILE_CHOOSER_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CHOOSER_PORTAL, FilesFileChooserPortalClass))
#define FILES_IS_FILE_CHOOSER_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CHOOSER_PORTAL))
#define FILES_IS_FILE_CHOOSER_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CHOOSER_PORTAL))
#define FILES_FILE_CHOOSER_PORTAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CHOOSER_PORTAL, FilesFileChooserPortalClass))

typedef struct _FilesFileChooserPortal FilesFileChooserPortal;
typedef struct _FilesFileChooserPortalClass FilesFileChooserPortalClass;
typedef struct _FilesFileChooserPortalPrivate FilesFileChooserPortalPrivate;

#define FILES_TYPE_FILE_CHOOSER_DIALOG (files_file_chooser_dialog_get_type ())
#define FILES_FILE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialog))
#define FILES_FILE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialogClass))
#define FILES_IS_FILE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG))
#define FILES_IS_FILE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CHOOSER_DIALOG))
#define FILES_FILE_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CHOOSER_DIALOG, FilesFileChooserDialogClass))

typedef struct _FilesFileChooserDialog FilesFileChooserDialog;
typedef struct _FilesFileChooserDialogClass FilesFileChooserDialogClass;
enum  {
	FILES_FILE_CHOOSER_PORTAL_0_PROPERTY,
	FILES_FILE_CHOOSER_PORTAL_NUM_PROPERTIES
};
static GParamSpec* files_file_chooser_portal_properties[FILES_FILE_CHOOSER_PORTAL_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block7Data Block7Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define FILES_TYPE_FILE_CHOOSER_CHOICE (files_file_chooser_choice_get_type ())
#define FILES_FILE_CHOOSER_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoice))
#define FILES_FILE_CHOOSER_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoiceClass))
#define FILES_IS_FILE_CHOOSER_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE))
#define FILES_IS_FILE_CHOOSER_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_FILE_CHOOSER_CHOICE))
#define FILES_FILE_CHOOSER_CHOICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_FILE_CHOOSER_CHOICE, FilesFileChooserChoiceClass))

typedef struct _FilesFileChooserChoice FilesFileChooserChoice;
typedef struct _FilesFileChooserChoiceClass FilesFileChooserChoiceClass;
typedef struct _FilesFileChooserPortalOpenFileData FilesFileChooserPortalOpenFileData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _FilesFileChooserPortalSaveFileData FilesFileChooserPortalSaveFileData;
typedef struct _Block10Data Block10Data;
typedef struct _FilesFileChooserPortalSaveFilesData FilesFileChooserPortalSaveFilesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _FilesFileChooserPortalOpenFileReadyData FilesFileChooserPortalOpenFileReadyData;
typedef struct _FilesFileChooserPortalSaveFileReadyData FilesFileChooserPortalSaveFileReadyData;
typedef struct _FilesFileChooserPortalSaveFilesReadyData FilesFileChooserPortalSaveFilesReadyData;

struct _FilesFileChooserPortal {
	GObject parent_instance;
	FilesFileChooserPortalPrivate * priv;
};

struct _FilesFileChooserPortalClass {
	GObjectClass parent_class;
};

struct _FilesFileChooserPortalPrivate {
	GHashTable* dialogs;
	GDBusConnection* connection;
};

struct _Block7Data {
	int _ref_count_;
	FilesFileChooserPortal* self;
	FilesFileChooserDialog* dialog;
	GHashTable* _results;
	guint _response;
	gpointer _async_data_;
};

struct _FilesFileChooserPortalOpenFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesFileChooserPortal* self;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
	guint response;
	GHashTable* results;
	Block7Data* _data7_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gboolean _tmp2_;
	gconstpointer _tmp3_;
	gboolean directory;
	GtkFileChooserAction _tmp4_;
	FilesFileChooserDialog* _tmp5_;
	FilesFileChooserDialog* _tmp6_;
	gconstpointer _tmp7_;
	FilesFileChooserDialog* _tmp8_;
	gconstpointer _tmp9_;
	FilesFileChooserDialog* _tmp10_;
	gconstpointer _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FilesFileChooserDialog* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	FilesFileChooserDialog* _tmp17_;
	GVariantIter* filters;
	gconstpointer _tmp18_;
	GVariantIter* _tmp19_;
	GVariant* filter_variant;
	GVariantIter* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GtkFileFilter* filter;
	GVariant* _tmp23_;
	GtkFileFilter* _tmp24_;
	FilesFileChooserDialog* _tmp25_;
	GtkFileFilter* _tmp26_;
	FilesFileChooserDialog* _tmp27_;
	gconstpointer _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* _tmp30_;
	GVariantIter* choices;
	gconstpointer _tmp31_;
	GVariantIter* _tmp32_;
	GVariant* choice_variant;
	GVariantIter* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	FilesFileChooserChoice* choice;
	GVariant* _tmp36_;
	FilesFileChooserChoice* _tmp37_;
	FilesFileChooserDialog* _tmp38_;
	FilesFileChooserChoice* _tmp39_;
	FilesFileChooserDialog* _tmp40_;
	GDBusConnection* _tmp41_;
	GHashFunc _tmp42_;
	GEqualFunc _tmp43_;
	GHashTable* _tmp44_;
	FilesFileChooserDialog* _tmp45_;
	GHashTable* _tmp46_;
	gchar* _tmp47_;
	FilesFileChooserDialog* _tmp48_;
	FilesFileChooserDialog* _tmp49_;
	FilesFileChooserDialog* _tmp50_;
	GHashTable* _tmp51_;
	FilesFileChooserDialog* _tmp52_;
	GHashTable* _tmp53_;
	GHashTable* _tmp54_;
};

struct _Block8Data {
	int _ref_count_;
	FilesFileChooserPortal* self;
	FilesFileChooserDialog* dialog;
	gchar* supplied_uri;
	GHashTable* _results;
	guint _response;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	GtkDialog* overwrite_dialog;
};

struct _FilesFileChooserPortalSaveFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesFileChooserPortal* self;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
	guint response;
	GHashTable* results;
	Block8Data* _data8_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	FilesFileChooserDialog* _tmp6_;
	FilesFileChooserDialog* _tmp7_;
	gconstpointer _tmp8_;
	FilesFileChooserDialog* _tmp9_;
	gconstpointer _tmp10_;
	const gchar* _tmp11_;
	FilesFileChooserDialog* _tmp12_;
	gconstpointer _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gconstpointer _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	FilesFileChooserDialog* _tmp23_;
	const gchar* _tmp24_;
	GVariantIter* filters;
	gconstpointer _tmp25_;
	GVariantIter* _tmp26_;
	GVariant* filter_variant;
	GVariantIter* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GtkFileFilter* filter;
	GVariant* _tmp30_;
	GtkFileFilter* _tmp31_;
	FilesFileChooserDialog* _tmp32_;
	GtkFileFilter* _tmp33_;
	FilesFileChooserDialog* _tmp34_;
	gconstpointer _tmp35_;
	GtkFileFilter* _tmp36_;
	GtkFileFilter* _tmp37_;
	GVariantIter* choices;
	gconstpointer _tmp38_;
	GVariantIter* _tmp39_;
	GVariant* choice_variant;
	GVariantIter* _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	FilesFileChooserChoice* choice;
	GVariant* _tmp43_;
	FilesFileChooserChoice* _tmp44_;
	FilesFileChooserDialog* _tmp45_;
	FilesFileChooserChoice* _tmp46_;
	FilesFileChooserDialog* _tmp47_;
	GDBusConnection* _tmp48_;
	GHashFunc _tmp49_;
	GEqualFunc _tmp50_;
	GHashTable* _tmp51_;
	FilesFileChooserDialog* _tmp52_;
	GHashTable* _tmp53_;
	gchar* _tmp54_;
	FilesFileChooserDialog* _tmp55_;
	FilesFileChooserDialog* _tmp56_;
	FilesFileChooserDialog* _tmp57_;
	GHashTable* _tmp58_;
	FilesFileChooserDialog* _tmp59_;
	GHashTable* _tmp60_;
	GHashTable* _tmp61_;
};

struct _Block10Data {
	int _ref_count_;
	FilesFileChooserPortal* self;
	FilesFileChooserDialog* dialog;
	GHashTable* _results;
	guint _response;
	GHashTable* options;
	gpointer _async_data_;
};

struct _FilesFileChooserPortalSaveFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesFileChooserPortal* self;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
	guint response;
	GHashTable* results;
	Block10Data* _data10_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	FilesFileChooserDialog* _tmp6_;
	FilesFileChooserDialog* _tmp7_;
	gconstpointer _tmp8_;
	FilesFileChooserDialog* _tmp9_;
	gconstpointer _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GVariantIter* choices;
	gconstpointer _tmp14_;
	GVariantIter* _tmp15_;
	GVariant* choice_variant;
	GVariantIter* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	FilesFileChooserChoice* choice;
	GVariant* _tmp19_;
	FilesFileChooserChoice* _tmp20_;
	FilesFileChooserDialog* _tmp21_;
	FilesFileChooserChoice* _tmp22_;
	FilesFileChooserDialog* _tmp23_;
	GDBusConnection* _tmp24_;
	GHashFunc _tmp25_;
	GEqualFunc _tmp26_;
	GHashTable* _tmp27_;
	FilesFileChooserDialog* _tmp28_;
	GHashTable* _tmp29_;
	gchar* _tmp30_;
	FilesFileChooserDialog* _tmp31_;
	FilesFileChooserDialog* _tmp32_;
	FilesFileChooserDialog* _tmp33_;
	GHashTable* _tmp34_;
	FilesFileChooserDialog* _tmp35_;
	GHashTable* _tmp36_;
	GHashTable* _tmp37_;
};

struct _Block11Data {
	int _ref_count_;
	GMainLoop* loop;
};

struct _FilesFileChooserPortalOpenFileReadyData {
	GDBusMethodInvocation* _invocation_;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
};

struct _FilesFileChooserPortalSaveFileReadyData {
	GDBusMethodInvocation* _invocation_;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
};

struct _FilesFileChooserPortalSaveFilesReadyData {
	GDBusMethodInvocation* _invocation_;
	char* handle;
	gchar* app_id;
	gchar* parent_window;
	gchar* title;
	GHashTable* options;
};

static gint FilesFileChooserPortal_private_offset;
static gpointer files_file_chooser_portal_parent_class = NULL;
static gboolean files_file_chooser_portal_opt_replace;
static gboolean files_file_chooser_portal_show_version;
static gboolean files_file_chooser_portal_opt_replace = FALSE;
static gboolean files_file_chooser_portal_show_version = FALSE;

VALA_EXTERN GType files_file_chooser_portal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChooserPortal, g_object_unref)
VALA_EXTERN guint files_file_chooser_portal_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType files_file_chooser_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChooserDialog, g_object_unref)
VALA_EXTERN FilesFileChooserPortal* files_file_chooser_portal_new (GDBusConnection* connection);
VALA_EXTERN FilesFileChooserPortal* files_file_chooser_portal_construct (GType object_type,
                                                             GDBusConnection* connection);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void files_file_chooser_portal_open_file_data_free (gpointer _data);
VALA_EXTERN void files_file_chooser_portal_open_file (FilesFileChooserPortal* self,
                                          const char* handle,
                                          const gchar* app_id,
                                          const gchar* parent_window,
                                          const gchar* title,
                                          GHashTable* options,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void files_file_chooser_portal_open_file_finish (FilesFileChooserPortal* self,
                                                 GAsyncResult* _res_,
                                                 guint* response,
                                                 GHashTable** results,
                                                 GError** error);
static gboolean files_file_chooser_portal_open_file_co (FilesFileChooserPortalOpenFileData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN FilesFileChooserDialog* files_file_chooser_dialog_new (GtkFileChooserAction action,
                                                       const gchar* parent_window,
                                                       const gchar* title);
VALA_EXTERN FilesFileChooserDialog* files_file_chooser_dialog_construct (GType object_type,
                                                             GtkFileChooserAction action,
                                                             const gchar* parent_window,
                                                             const gchar* title);
VALA_EXTERN void files_file_chooser_dialog_set_select_multiple (FilesFileChooserDialog* self,
                                                    gboolean value);
VALA_EXTERN void files_file_chooser_dialog_set_accept_label (FilesFileChooserDialog* self,
                                                 const gchar* value);
VALA_EXTERN gboolean files_file_chooser_dialog_get_select_multiple (FilesFileChooserDialog* self);
VALA_EXTERN void files_file_chooser_dialog_add_filter (FilesFileChooserDialog* self,
                                           GtkFileFilter* filter);
VALA_EXTERN void files_file_chooser_dialog_set_filter (FilesFileChooserDialog* self,
                                           GtkFileFilter* value);
VALA_EXTERN GType files_file_chooser_choice_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesFileChooserChoice, g_object_unref)
VALA_EXTERN FilesFileChooserChoice* files_file_chooser_choice_new_from_variant (GVariant* variant);
VALA_EXTERN FilesFileChooserChoice* files_file_chooser_choice_construct_from_variant (GType object_type,
                                                                          GVariant* variant);
VALA_EXTERN void files_file_chooser_dialog_add_choice (FilesFileChooserDialog* self,
                                           FilesFileChooserChoice* choice);
VALA_EXTERN gboolean files_file_chooser_dialog_register_object (FilesFileChooserDialog* self,
                                                    GDBusConnection* connection,
                                                    const char* handle);
static void __lambda27_ (Block7Data* _data7_,
                  GtkResponseType id);
VALA_EXTERN gchar** files_file_chooser_dialog_get_uris (FilesFileChooserDialog* self,
                                            gint* result_length1);
static GVariant* _variant_new1 (gchar** value,
                         gint value_length1);
VALA_EXTERN GVariant** files_file_chooser_dialog_get_choices (FilesFileChooserDialog* self,
                                                  gint* result_length1);
static GVariant* _variant_new2 (GVariant** value,
                         gint value_length1);
VALA_EXTERN gboolean files_file_chooser_dialog_get_read_only (FilesFileChooserDialog* self);
static GVariant* _variant_new3 (gboolean value);
VALA_EXTERN GtkFileFilter* files_file_chooser_dialog_get_filter (FilesFileChooserDialog* self);
static void ___lambda27__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                      GtkResponseType response,
                                                      gpointer self);
static void files_file_chooser_portal_save_file_data_free (gpointer _data);
VALA_EXTERN void files_file_chooser_portal_save_file (FilesFileChooserPortal* self,
                                          const char* handle,
                                          const gchar* app_id,
                                          const gchar* parent_window,
                                          const gchar* title,
                                          GHashTable* options,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void files_file_chooser_portal_save_file_finish (FilesFileChooserPortal* self,
                                                 GAsyncResult* _res_,
                                                 guint* response,
                                                 GHashTable** results,
                                                 GError** error);
static gboolean files_file_chooser_portal_save_file_co (FilesFileChooserPortalSaveFileData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN void files_file_chooser_dialog_set_current_name (FilesFileChooserDialog* self,
                                                 const gchar* text);
VALA_EXTERN void files_file_chooser_dialog_set_current_folder (FilesFileChooserDialog* self,
                                                   const gchar* uri);
VALA_EXTERN void files_file_chooser_dialog_set_uri (FilesFileChooserDialog* self,
                                        const gchar* uri);
static void __lambda28_ (Block8Data* _data8_,
                  GtkResponseType id);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static GVariant* _variant_new4 (gchar** value,
                         gint value_length1);
static GVariant* _variant_new5 (GVariant** value,
                         gint value_length1);
VALA_EXTERN GFile* files_file_chooser_dialog_get_file (FilesFileChooserDialog* self);
static GtkDialog* files_file_chooser_portal_create_overwrite_dialog (FilesFileChooserPortal* self,
                                                              GtkWindow* parent,
                                                              GFile* file);
static void ___lambda29_ (Block9Data* _data9_,
                   gint response);
static void ____lambda29__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void ___lambda28__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                      GtkResponseType response,
                                                      gpointer self);
static void files_file_chooser_portal_save_files_data_free (gpointer _data);
VALA_EXTERN void files_file_chooser_portal_save_files (FilesFileChooserPortal* self,
                                           const char* handle,
                                           const gchar* app_id,
                                           const gchar* parent_window,
                                           const gchar* title,
                                           GHashTable* options,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void files_file_chooser_portal_save_files_finish (FilesFileChooserPortal* self,
                                                  GAsyncResult* _res_,
                                                  guint* response,
                                                  GHashTable** results,
                                                  GError** error);
static gboolean files_file_chooser_portal_save_files_co (FilesFileChooserPortalSaveFilesData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda30_ (Block10Data* _data10_,
                  GtkResponseType id);
VALA_EXTERN gchar* files_file_chooser_dialog_get_uri (FilesFileChooserDialog* self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GVariant* _variant_new6 (gchar** value,
                         gint value_length1);
static GVariant* _variant_new7 (GVariant** value,
                         gint value_length1);
static void ___lambda30__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                      GtkResponseType response,
                                                      gpointer self);
static void files_file_chooser_portal_on_bus_acquired (GDBusConnection* connection,
                                                const gchar* name);
static gint files_file_chooser_portal_main (gchar** args,
                                     gint args_length1);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void _files_file_chooser_portal_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self);
static void __lambda31_ (void);
static void ___lambda31__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda32_ (Block11Data* _data11_);
static void ___lambda32__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void files_file_chooser_portal_finalize (GObject * obj);
static GType files_file_chooser_portal_get_type_once (void);
static void _dbus_files_file_chooser_portal_open_file (FilesFileChooserPortal* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_files_file_chooser_portal_open_file_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_);
static void _dbus_files_file_chooser_portal_save_file (FilesFileChooserPortal* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_files_file_chooser_portal_save_file_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_);
static void _dbus_files_file_chooser_portal_save_files (FilesFileChooserPortal* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_files_file_chooser_portal_save_files_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void files_file_chooser_portal_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* files_file_chooser_portal_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean files_file_chooser_portal_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _files_file_chooser_portal_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry FILES_FILE_CHOOSER_PORTAL_ENTRIES[3] = {{"replace", 'r', (gint) 0, G_OPTION_ARG_NONE, &files_file_chooser_portal_opt_replace, "Replace a running instance", NULL}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &files_file_chooser_portal_show_version, "Show program version.", NULL}, {NULL}};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_handle = {-1, "handle", "o", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_parent_window = {-1, "parent_window", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_title = {-1, "title", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_options = {-1, "options", "a{sv}", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_response = {-1, "response", "u", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_open_file_results = {-1, "results", "a{sv}", NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_open_file_in[] = {&_files_file_chooser_portal_dbus_arg_info_open_file_handle, &_files_file_chooser_portal_dbus_arg_info_open_file_app_id, &_files_file_chooser_portal_dbus_arg_info_open_file_parent_window, &_files_file_chooser_portal_dbus_arg_info_open_file_title, &_files_file_chooser_portal_dbus_arg_info_open_file_options, NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_open_file_out[] = {&_files_file_chooser_portal_dbus_arg_info_open_file_response, &_files_file_chooser_portal_dbus_arg_info_open_file_results, NULL};
static const GDBusMethodInfo _files_file_chooser_portal_dbus_method_info_open_file = {-1, "OpenFile", (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_open_file_in), (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_open_file_out), NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_handle = {-1, "handle", "o", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_parent_window = {-1, "parent_window", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_title = {-1, "title", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_options = {-1, "options", "a{sv}", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_response = {-1, "response", "u", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_file_results = {-1, "results", "a{sv}", NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_save_file_in[] = {&_files_file_chooser_portal_dbus_arg_info_save_file_handle, &_files_file_chooser_portal_dbus_arg_info_save_file_app_id, &_files_file_chooser_portal_dbus_arg_info_save_file_parent_window, &_files_file_chooser_portal_dbus_arg_info_save_file_title, &_files_file_chooser_portal_dbus_arg_info_save_file_options, NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_save_file_out[] = {&_files_file_chooser_portal_dbus_arg_info_save_file_response, &_files_file_chooser_portal_dbus_arg_info_save_file_results, NULL};
static const GDBusMethodInfo _files_file_chooser_portal_dbus_method_info_save_file = {-1, "SaveFile", (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_save_file_in), (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_save_file_out), NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_handle = {-1, "handle", "o", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_parent_window = {-1, "parent_window", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_title = {-1, "title", "s", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_options = {-1, "options", "a{sv}", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_response = {-1, "response", "u", NULL};
static const GDBusArgInfo _files_file_chooser_portal_dbus_arg_info_save_files_results = {-1, "results", "a{sv}", NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_save_files_in[] = {&_files_file_chooser_portal_dbus_arg_info_save_files_handle, &_files_file_chooser_portal_dbus_arg_info_save_files_app_id, &_files_file_chooser_portal_dbus_arg_info_save_files_parent_window, &_files_file_chooser_portal_dbus_arg_info_save_files_title, &_files_file_chooser_portal_dbus_arg_info_save_files_options, NULL};
static const GDBusArgInfo * const _files_file_chooser_portal_dbus_arg_info_save_files_out[] = {&_files_file_chooser_portal_dbus_arg_info_save_files_response, &_files_file_chooser_portal_dbus_arg_info_save_files_results, NULL};
static const GDBusMethodInfo _files_file_chooser_portal_dbus_method_info_save_files = {-1, "SaveFiles", (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_save_files_in), (GDBusArgInfo **) (&_files_file_chooser_portal_dbus_arg_info_save_files_out), NULL};
static const GDBusMethodInfo * const _files_file_chooser_portal_dbus_method_info[] = {&_files_file_chooser_portal_dbus_method_info_open_file, &_files_file_chooser_portal_dbus_method_info_save_file, &_files_file_chooser_portal_dbus_method_info_save_files, NULL};
static const GDBusSignalInfo * const _files_file_chooser_portal_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _files_file_chooser_portal_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _files_file_chooser_portal_dbus_interface_info = {-1, "org.freedesktop.impl.portal.FileChooser", (GDBusMethodInfo **) (&_files_file_chooser_portal_dbus_method_info), (GDBusSignalInfo **) (&_files_file_chooser_portal_dbus_signal_info), (GDBusPropertyInfo **) (&_files_file_chooser_portal_dbus_property_info), NULL};
static const GDBusInterfaceVTable _files_file_chooser_portal_dbus_interface_vtable = {files_file_chooser_portal_dbus_interface_method_call, files_file_chooser_portal_dbus_interface_get_property, files_file_chooser_portal_dbus_interface_set_property};

static inline gpointer
files_file_chooser_portal_get_instance_private (FilesFileChooserPortal* self)
{
	return G_STRUCT_MEMBER_P (self, FilesFileChooserPortal_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

FilesFileChooserPortal*
files_file_chooser_portal_construct (GType object_type,
                                     GDBusConnection* connection)
{
	FilesFileChooserPortal * self = NULL;
	GDBusConnection* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (FilesFileChooserPortal*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->dialogs);
	self->priv->dialogs = _tmp3_;
	return self;
}

FilesFileChooserPortal*
files_file_chooser_portal_new (GDBusConnection* connection)
{
	return files_file_chooser_portal_construct (FILES_TYPE_FILE_CHOOSER_PORTAL, connection);
}

static void
files_file_chooser_portal_open_file_data_free (gpointer _data)
{
	FilesFileChooserPortalOpenFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->handle);
	_g_free0 (_data_->app_id);
	_g_free0 (_data_->parent_window);
	_g_free0 (_data_->title);
	_g_hash_table_unref0 (_data_->options);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesFileChooserPortalOpenFileData, _data_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
files_file_chooser_portal_open_file (FilesFileChooserPortal* self,
                                     const char* handle,
                                     const gchar* app_id,
                                     const gchar* parent_window,
                                     const gchar* title,
                                     GHashTable* options,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FilesFileChooserPortalOpenFileData* _data_;
	FilesFileChooserPortal* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (parent_window != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (options != NULL);
	_data_ = g_slice_new0 (FilesFileChooserPortalOpenFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_file_chooser_portal_open_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (handle);
	_g_free0 (_data_->handle);
	_data_->handle = _tmp1_;
	_tmp2_ = g_strdup (app_id);
	_g_free0 (_data_->app_id);
	_data_->app_id = _tmp2_;
	_tmp3_ = g_strdup (parent_window);
	_g_free0 (_data_->parent_window);
	_data_->parent_window = _tmp3_;
	_tmp4_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp4_;
	_tmp5_ = _g_hash_table_ref0 (options);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp5_;
	files_file_chooser_portal_open_file_co (_data_);
}

void
files_file_chooser_portal_open_file_finish (FilesFileChooserPortal* self,
                                            GAsyncResult* _res_,
                                            guint* response,
                                            GHashTable** results,
                                            GError** error)
{
	FilesFileChooserPortalOpenFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (response) {
		*response = _data_->response;
	}
	if (results) {
		*results = _data_->results;
	} else {
		_g_hash_table_unref0 (_data_->results);
	}
	_data_->results = NULL;
}

/**
     * Requests the user for a URI.
     *
     * The URI should point to a file, if "multiple" is true, more than one URI
     * can be chosen by the user. If "directory" is true, the URI should point
     * to a folder instead.
     *
     * A filter can be specified with "current_filter", or "filters", if more
     * than one filter could be used. Application specific options can be added
     * to the dialog with "choices" and a label to the select button set with
     * "accept_label".
     *
     * @param handle
     *    Object path where the request should be exported
     * @param app_id
     *    Application originating the call (not used)
     * @param parent_window
     *    Transient parent handle, in format "type:handle". if type is "x11",
     *    handle should be a XID in hexadecimal format, if type is "wayland",
     *    handle should be a xdg_foreign handle. Other types aren't supported.
     * @param title
     *    title for the file chooser dialog
     * @param options
     *    Dictionary of extra options. valid keys are: "accept_label",
     *    "choices", "current_filter", "directory", "filters", "multiple"
     *    and "modal".
     * @param response
     *    User response, 0 on success, 1 if cancelled, 2 on fail.
     * @param results
     *    Dictionary with the user choices, possible keys are: "uris",
     *    "choices", "writable" and "current_filter".
     */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		FilesFileChooserPortal* self;
		self = _data7_->self;
		_g_hash_table_unref0 (_data7_->_results);
		_g_object_unref0 (_data7_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (gchar** value,
               gint value_length1)
{
	gchar** _tmp6_;
	GVariantBuilder _tmp7_;
	gint _tmp8_;
	_tmp6_ = value;
	g_variant_builder_init (&_tmp7_, G_VARIANT_TYPE ("as"));
	for (_tmp8_ = 0; _tmp8_ < value_length1; _tmp8_++) {
		g_variant_builder_add_value (&_tmp7_, g_variant_new_string (*_tmp6_));
		_tmp6_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp7_));
}

static GVariant*
_variant_new2 (GVariant** value,
               gint value_length1)
{
	GVariant** _tmp16_;
	GVariantBuilder _tmp17_;
	gint _tmp18_;
	_tmp16_ = value;
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("av"));
	for (_tmp18_ = 0; _tmp18_ < value_length1; _tmp18_++) {
		g_variant_builder_add_value (&_tmp17_, g_variant_new_variant (*_tmp16_));
		_tmp16_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp17_));
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
__lambda27_ (Block7Data* _data7_,
             GtkResponseType id)
{
	FilesFileChooserPortal* self;
	self = _data7_->self;
	switch (id) {
		case GTK_RESPONSE_OK:
		{
			GHashTable* _tmp0_;
			gchar* _tmp1_;
			FilesFileChooserDialog* _tmp2_;
			gint _tmp3_ = 0;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			GVariant* _tmp9_;
			GHashTable* _tmp10_;
			gchar* _tmp11_;
			FilesFileChooserDialog* _tmp12_;
			gint _tmp13_ = 0;
			GVariant** _tmp14_;
			GVariant** _tmp15_;
			gint _tmp15__length1;
			GVariant* _tmp19_;
			GHashTable* _tmp20_;
			gchar* _tmp21_;
			FilesFileChooserDialog* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			GVariant* _tmp25_;
			FilesFileChooserDialog* _tmp26_;
			GtkFileFilter* _tmp27_;
			GtkFileFilter* _tmp28_;
			_tmp0_ = _data7_->_results;
			_tmp1_ = g_strdup ("uris");
			_tmp2_ = _data7_->dialog;
			_tmp4_ = files_file_chooser_dialog_get_uris (_tmp2_, &_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp5__length1 = _tmp3_;
			_tmp9_ = _variant_new1 (_tmp5_, _tmp3_);
			g_hash_table_insert (_tmp0_, _tmp1_, _tmp9_);
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
			_tmp10_ = _data7_->_results;
			_tmp11_ = g_strdup ("choices");
			_tmp12_ = _data7_->dialog;
			_tmp14_ = files_file_chooser_dialog_get_choices (_tmp12_, &_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp15__length1 = _tmp13_;
			_tmp19_ = _variant_new2 (_tmp15_, _tmp13_);
			g_hash_table_insert (_tmp10_, _tmp11_, _tmp19_);
			_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
			_tmp20_ = _data7_->_results;
			_tmp21_ = g_strdup ("writable");
			_tmp22_ = _data7_->dialog;
			_tmp23_ = files_file_chooser_dialog_get_read_only (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _variant_new3 (!_tmp24_);
			g_hash_table_insert (_tmp20_, _tmp21_, _tmp25_);
			_tmp26_ = _data7_->dialog;
			_tmp27_ = files_file_chooser_dialog_get_filter (_tmp26_);
			_tmp28_ = _tmp27_;
			if (_tmp28_ != NULL) {
				GHashTable* _tmp29_;
				gchar* _tmp30_;
				FilesFileChooserDialog* _tmp31_;
				GtkFileFilter* _tmp32_;
				GtkFileFilter* _tmp33_;
				GVariant* _tmp34_;
				_tmp29_ = _data7_->_results;
				_tmp30_ = g_strdup ("current_filter");
				_tmp31_ = _data7_->dialog;
				_tmp32_ = files_file_chooser_dialog_get_filter (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = gtk_file_filter_to_gvariant (_tmp33_);
				g_variant_ref_sink (_tmp34_);
				g_hash_table_insert (_tmp29_, _tmp30_, _tmp34_);
			}
			_data7_->_response = (guint) 0;
			break;
		}
		case GTK_RESPONSE_CANCEL:
		{
			_data7_->_response = (guint) 1;
			break;
		}
		default:
		case GTK_RESPONSE_DELETE_EVENT:
		{
			_data7_->_response = (guint) 2;
			break;
		}
	}
	files_file_chooser_portal_open_file_co (_data7_->_async_data_);
}

static void
___lambda27__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                 GtkResponseType response,
                                                 gpointer self)
{
	__lambda27_ (self, response);
}

static gboolean
files_file_chooser_portal_open_file_co (FilesFileChooserPortalOpenFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->dialogs;
	if (g_hash_table_contains (_data_->_tmp0_, _data_->parent_window)) {
		_data_->_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
		_g_hash_table_unref0 (_data_->results);
		_data_->results = _data_->_tmp1_;
		_data_->response = (guint) 2;
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_hash_table_contains (_data_->options, "directory")) {
		_data_->_tmp3_ = g_hash_table_lookup (_data_->options, "directory");
		_data_->_tmp2_ = g_variant_get_boolean ((GVariant*) _data_->_tmp3_);
	} else {
		_data_->_tmp2_ = FALSE;
	}
	_data_->directory = _data_->_tmp2_;
	if (_data_->directory) {
		_data_->_tmp4_ = GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER;
	} else {
		_data_->_tmp4_ = GTK_FILE_CHOOSER_ACTION_OPEN;
	}
	_data_->_tmp5_ = files_file_chooser_dialog_new (_data_->_tmp4_, _data_->parent_window, _data_->title);
	g_object_ref_sink (_data_->_tmp5_);
	_data_->_data7_->dialog = _data_->_tmp5_;
	if (g_hash_table_contains (_data_->options, "modal")) {
		_data_->_tmp6_ = _data_->_data7_->dialog;
		_data_->_tmp7_ = g_hash_table_lookup (_data_->options, "modal");
		gtk_window_set_modal ((GtkWindow*) _data_->_tmp6_, g_variant_get_boolean ((GVariant*) _data_->_tmp7_));
	}
	if (g_hash_table_contains (_data_->options, "multiple")) {
		_data_->_tmp8_ = _data_->_data7_->dialog;
		_data_->_tmp9_ = g_hash_table_lookup (_data_->options, "multiple");
		files_file_chooser_dialog_set_select_multiple (_data_->_tmp8_, g_variant_get_boolean ((GVariant*) _data_->_tmp9_));
	}
	if (g_hash_table_contains (_data_->options, "accept_label")) {
		_data_->_tmp10_ = _data_->_data7_->dialog;
		_data_->_tmp11_ = g_hash_table_lookup (_data_->options, "accept_label");
		_data_->_tmp12_ = g_variant_get_string ((GVariant*) _data_->_tmp11_, NULL);
		files_file_chooser_dialog_set_accept_label (_data_->_tmp10_, _data_->_tmp12_);
	} else {
		_data_->_tmp14_ = _data_->_data7_->dialog;
		_data_->_tmp15_ = files_file_chooser_dialog_get_select_multiple (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		if (_data_->_tmp16_) {
			_data_->_tmp13_ = _ ("Select");
		} else {
			_data_->_tmp13_ = _ ("Open");
		}
		_data_->_tmp17_ = _data_->_data7_->dialog;
		files_file_chooser_dialog_set_accept_label (_data_->_tmp17_, _data_->_tmp13_);
	}
	if (g_hash_table_contains (_data_->options, "filters")) {
		_data_->_tmp18_ = g_hash_table_lookup (_data_->options, "filters");
		_data_->_tmp19_ = g_variant_iter_new ((GVariant*) _data_->_tmp18_);
		_data_->filters = _data_->_tmp19_;
		while (TRUE) {
			_data_->_tmp20_ = _data_->filters;
			_data_->_tmp21_ = g_variant_iter_next_value (_data_->_tmp20_);
			_g_variant_unref0 (_data_->filter_variant);
			_data_->filter_variant = _data_->_tmp21_;
			_data_->_tmp22_ = _data_->filter_variant;
			if (!(_data_->_tmp22_ != NULL)) {
				break;
			}
			_data_->_tmp23_ = _data_->filter_variant;
			_data_->_tmp24_ = gtk_file_filter_new_from_gvariant (_data_->_tmp23_);
			g_object_ref_sink (_data_->_tmp24_);
			_data_->filter = _data_->_tmp24_;
			_data_->_tmp25_ = _data_->_data7_->dialog;
			_data_->_tmp26_ = _data_->filter;
			files_file_chooser_dialog_add_filter (_data_->_tmp25_, _data_->_tmp26_);
			_g_object_unref0 (_data_->filter);
		}
		_g_variant_unref0 (_data_->filter_variant);
		_g_variant_iter_free0 (_data_->filters);
	}
	if (g_hash_table_contains (_data_->options, "current_filter")) {
		_data_->_tmp27_ = _data_->_data7_->dialog;
		_data_->_tmp28_ = g_hash_table_lookup (_data_->options, "current_filter");
		_data_->_tmp29_ = gtk_file_filter_new_from_gvariant ((GVariant*) _data_->_tmp28_);
		g_object_ref_sink (_data_->_tmp29_);
		_data_->_tmp30_ = _data_->_tmp29_;
		files_file_chooser_dialog_set_filter (_data_->_tmp27_, _data_->_tmp30_);
		_g_object_unref0 (_data_->_tmp30_);
	}
	if (g_hash_table_contains (_data_->options, "choices")) {
		_data_->_tmp31_ = g_hash_table_lookup (_data_->options, "choices");
		_data_->_tmp32_ = g_variant_iter_new ((GVariant*) _data_->_tmp31_);
		_data_->choices = _data_->_tmp32_;
		while (TRUE) {
			_data_->_tmp33_ = _data_->choices;
			_data_->_tmp34_ = g_variant_iter_next_value (_data_->_tmp33_);
			_g_variant_unref0 (_data_->choice_variant);
			_data_->choice_variant = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->choice_variant;
			if (!(_data_->_tmp35_ != NULL)) {
				break;
			}
			_data_->_tmp36_ = _data_->choice_variant;
			_data_->_tmp37_ = files_file_chooser_choice_new_from_variant (_data_->_tmp36_);
			g_object_ref_sink (_data_->_tmp37_);
			_data_->choice = _data_->_tmp37_;
			_data_->_tmp38_ = _data_->_data7_->dialog;
			_data_->_tmp39_ = _data_->choice;
			files_file_chooser_dialog_add_choice (_data_->_tmp38_, _data_->_tmp39_);
			_g_object_unref0 (_data_->choice);
		}
		_g_variant_unref0 (_data_->choice_variant);
		_g_variant_iter_free0 (_data_->choices);
	}
	_data_->_tmp40_ = _data_->_data7_->dialog;
	_data_->_tmp41_ = _data_->self->priv->connection;
	files_file_chooser_dialog_register_object (_data_->_tmp40_, _data_->_tmp41_, _data_->handle);
	_data_->_tmp42_ = g_str_hash;
	_data_->_tmp43_ = g_str_equal;
	_data_->_tmp44_ = g_hash_table_new_full (_data_->_tmp42_, _data_->_tmp43_, _g_free0_, _g_variant_unref0_);
	_data_->_data7_->_results = _data_->_tmp44_;
	_data_->_data7_->_response = (guint) 2;
	_data_->_tmp45_ = _data_->_data7_->dialog;
	g_signal_connect_data (_data_->_tmp45_, "response", (GCallback) ___lambda27__files_file_chooser_dialog_response, block7_data_ref (_data_->_data7_), (GClosureNotify) block7_data_unref, 0);
	_data_->_tmp46_ = _data_->self->priv->dialogs;
	_data_->_tmp47_ = g_strdup (_data_->parent_window);
	_data_->_tmp48_ = _data_->_data7_->dialog;
	_data_->_tmp49_ = _g_object_ref0 (_data_->_tmp48_);
	g_hash_table_insert (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp49_);
	_data_->_tmp50_ = _data_->_data7_->dialog;
	gtk_window_present ((GtkWindow*) _data_->_tmp50_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp51_ = _data_->self->priv->dialogs;
	g_hash_table_remove (_data_->_tmp51_, _data_->parent_window);
	_data_->_tmp52_ = _data_->_data7_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp52_);
	_data_->response = _data_->_data7_->_response;
	_data_->_tmp53_ = _data_->_data7_->_results;
	_data_->_tmp54_ = _g_hash_table_ref0 (_data_->_tmp53_);
	_g_hash_table_unref0 (_data_->results);
	_data_->results = _data_->_tmp54_;
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_file_chooser_portal_save_file_data_free (gpointer _data)
{
	FilesFileChooserPortalSaveFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->handle);
	_g_free0 (_data_->app_id);
	_g_free0 (_data_->parent_window);
	_g_free0 (_data_->title);
	_g_hash_table_unref0 (_data_->options);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesFileChooserPortalSaveFileData, _data_);
}

void
files_file_chooser_portal_save_file (FilesFileChooserPortal* self,
                                     const char* handle,
                                     const gchar* app_id,
                                     const gchar* parent_window,
                                     const gchar* title,
                                     GHashTable* options,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FilesFileChooserPortalSaveFileData* _data_;
	FilesFileChooserPortal* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (parent_window != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (options != NULL);
	_data_ = g_slice_new0 (FilesFileChooserPortalSaveFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_file_chooser_portal_save_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (handle);
	_g_free0 (_data_->handle);
	_data_->handle = _tmp1_;
	_tmp2_ = g_strdup (app_id);
	_g_free0 (_data_->app_id);
	_data_->app_id = _tmp2_;
	_tmp3_ = g_strdup (parent_window);
	_g_free0 (_data_->parent_window);
	_data_->parent_window = _tmp3_;
	_tmp4_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp4_;
	_tmp5_ = _g_hash_table_ref0 (options);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp5_;
	files_file_chooser_portal_save_file_co (_data_);
}

void
files_file_chooser_portal_save_file_finish (FilesFileChooserPortal* self,
                                            GAsyncResult* _res_,
                                            guint* response,
                                            GHashTable** results,
                                            GError** error)
{
	FilesFileChooserPortalSaveFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (response) {
		*response = _data_->response;
	}
	if (results) {
		*results = _data_->results;
	} else {
		_g_hash_table_unref0 (_data_->results);
	}
	_data_->results = NULL;
}

/**
     * Requests the user for a URI, with intent to write to it.
     *
     * The URI should point to a file, if the URI is already existent,
     * permission is asked for it usage. "current_folder", "current_name" and
     * "current_file" can be used to pre-select a file.
     *
     * A filter can be specified with "current_filter" option, or "filters",
     * if more than one filter could be used. Application specific options
     * can be added to the dialog with "choices" and a label to the select
     * button set with "accept_label".
     *
     * @param handle
     *     Object path where the request should be exported
     * @param app_id
     *     Application originating the call (not used)
     * @param parent_window
     *     Transient parent handle, in format "type:handle". if type is "x11",
     *     handle should be a XID in hexadecimal format, if type is "wayland",
     *     handle should be a xdg_foreign handle. Other types aren't supported.
     * @param title
     *     title for the file chooser dialog
     * @param options
     *     Dictionary of extra options. valid keys are: "accept_label",
     *     "choices", "current_file", "current_filter", "current_folder",
     *     "current_name", "filters" and "modal".
     * @param response
     *     User response, 0 on success, 1 if cancelled, 2 on fail.
     * @param results
     *     Dictionary with the user choices, possible keys are: "uris",
     *     "choices", and "current_filter".
     */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		FilesFileChooserPortal* self;
		self = _data8_->self;
		_g_hash_table_unref0 (_data8_->_results);
		_g_free0 (_data8_->supplied_uri);
		_g_object_unref0 (_data8_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		FilesFileChooserPortal* self;
		self = _data9_->_data8_->self;
		_g_object_unref0 (_data9_->overwrite_dialog);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static GVariant*
_variant_new4 (gchar** value,
               gint value_length1)
{
	gchar** _tmp6_;
	GVariantBuilder _tmp7_;
	gint _tmp8_;
	_tmp6_ = value;
	g_variant_builder_init (&_tmp7_, G_VARIANT_TYPE ("as"));
	for (_tmp8_ = 0; _tmp8_ < value_length1; _tmp8_++) {
		g_variant_builder_add_value (&_tmp7_, g_variant_new_string (*_tmp6_));
		_tmp6_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp7_));
}

static GVariant*
_variant_new5 (GVariant** value,
               gint value_length1)
{
	GVariant** _tmp16_;
	GVariantBuilder _tmp17_;
	gint _tmp18_;
	_tmp16_ = value;
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("av"));
	for (_tmp18_ = 0; _tmp18_ < value_length1; _tmp18_++) {
		g_variant_builder_add_value (&_tmp17_, g_variant_new_variant (*_tmp16_));
		_tmp16_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp17_));
}

static void
___lambda29_ (Block9Data* _data9_,
              gint response)
{
	Block8Data* _data8_;
	FilesFileChooserPortal* self;
	GtkDialog* _tmp0_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	_tmp0_ = _data9_->overwrite_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	if (response == ((gint) GTK_RESPONSE_YES)) {
		files_file_chooser_portal_save_file_co (_data8_->_async_data_);
	} else {
		GHashTable* _tmp1_;
		_tmp1_ = _data8_->_results;
		g_hash_table_remove_all (_tmp1_);
		_data8_->_response = (guint) 2;
	}
}

static void
____lambda29__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda29_ (self, response_id);
}

static void
__lambda28_ (Block8Data* _data8_,
             GtkResponseType id)
{
	FilesFileChooserPortal* self;
	self = _data8_->self;
	switch (id) {
		case GTK_RESPONSE_OK:
		{
			Block9Data* _data9_;
			GHashTable* _tmp0_;
			gchar* _tmp1_;
			FilesFileChooserDialog* _tmp2_;
			gint _tmp3_ = 0;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			GVariant* _tmp9_;
			GHashTable* _tmp10_;
			gchar* _tmp11_;
			FilesFileChooserDialog* _tmp12_;
			gint _tmp13_ = 0;
			GVariant** _tmp14_;
			GVariant** _tmp15_;
			gint _tmp15__length1;
			GVariant* _tmp19_;
			FilesFileChooserDialog* _tmp20_;
			GtkFileFilter* _tmp21_;
			GtkFileFilter* _tmp22_;
			GFile* chosen_file = NULL;
			FilesFileChooserDialog* _tmp29_;
			GFile* _tmp30_;
			gboolean _tmp31_ = FALSE;
			GFile* _tmp32_;
			FilesFileChooserDialog* _tmp37_;
			GFile* _tmp38_;
			GtkDialog* _tmp39_;
			GtkDialog* _tmp40_;
			GtkDialog* _tmp41_;
			_data9_ = g_slice_new0 (Block9Data);
			_data9_->_ref_count_ = 1;
			_data9_->_data8_ = block8_data_ref (_data8_);
			_tmp0_ = _data8_->_results;
			_tmp1_ = g_strdup ("uris");
			_tmp2_ = _data8_->dialog;
			_tmp4_ = files_file_chooser_dialog_get_uris (_tmp2_, &_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp5__length1 = _tmp3_;
			_tmp9_ = _variant_new4 (_tmp5_, _tmp3_);
			g_hash_table_insert (_tmp0_, _tmp1_, _tmp9_);
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
			_tmp10_ = _data8_->_results;
			_tmp11_ = g_strdup ("choices");
			_tmp12_ = _data8_->dialog;
			_tmp14_ = files_file_chooser_dialog_get_choices (_tmp12_, &_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp15__length1 = _tmp13_;
			_tmp19_ = _variant_new5 (_tmp15_, _tmp13_);
			g_hash_table_insert (_tmp10_, _tmp11_, _tmp19_);
			_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
			_tmp20_ = _data8_->dialog;
			_tmp21_ = files_file_chooser_dialog_get_filter (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ != NULL) {
				GHashTable* _tmp23_;
				gchar* _tmp24_;
				FilesFileChooserDialog* _tmp25_;
				GtkFileFilter* _tmp26_;
				GtkFileFilter* _tmp27_;
				GVariant* _tmp28_;
				_tmp23_ = _data8_->_results;
				_tmp24_ = g_strdup ("current_filter");
				_tmp25_ = _data8_->dialog;
				_tmp26_ = files_file_chooser_dialog_get_filter (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = gtk_file_filter_to_gvariant (_tmp27_);
				g_variant_ref_sink (_tmp28_);
				g_hash_table_insert (_tmp23_, _tmp24_, _tmp28_);
			}
			_data8_->_response = (guint) 0;
			_tmp29_ = _data8_->dialog;
			_tmp30_ = files_file_chooser_dialog_get_file (_tmp29_);
			chosen_file = _tmp30_;
			_tmp32_ = chosen_file;
			if (!g_file_query_exists (_tmp32_, NULL)) {
				_tmp31_ = TRUE;
			} else {
				GFile* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = chosen_file;
				_tmp34_ = g_file_get_uri (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _data8_->supplied_uri;
				_tmp31_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
				_g_free0 (_tmp35_);
			}
			if (_tmp31_) {
				_g_object_unref0 (chosen_file);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				break;
			}
			_tmp37_ = _data8_->dialog;
			_tmp38_ = chosen_file;
			_tmp39_ = files_file_chooser_portal_create_overwrite_dialog (self, (GtkWindow*) _tmp37_, _tmp38_);
			_data9_->overwrite_dialog = _tmp39_;
			_tmp40_ = _data9_->overwrite_dialog;
			g_signal_connect_data (_tmp40_, "response", (GCallback) ____lambda29__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
			_tmp41_ = _data9_->overwrite_dialog;
			gtk_window_present ((GtkWindow*) _tmp41_);
			_g_object_unref0 (chosen_file);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return;
		}
		case GTK_RESPONSE_CANCEL:
		{
			_data8_->_response = (guint) 1;
			break;
		}
		default:
		case GTK_RESPONSE_DELETE_EVENT:
		{
			_data8_->_response = (guint) 2;
			break;
		}
	}
	files_file_chooser_portal_save_file_co (_data8_->_async_data_);
}

static void
___lambda28__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                 GtkResponseType response,
                                                 gpointer self)
{
	__lambda28_ (self, response);
}

static gboolean
files_file_chooser_portal_save_file_co (FilesFileChooserPortalSaveFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->dialogs;
	if (g_hash_table_contains (_data_->_tmp0_, _data_->parent_window)) {
		_data_->_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
		_g_hash_table_unref0 (_data_->results);
		_data_->results = _data_->_tmp1_;
		_data_->response = (guint) 2;
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_hash_table_contains (_data_->options, "accept_label")) {
		_data_->_tmp3_ = g_hash_table_lookup (_data_->options, "accept_label");
		_data_->_tmp4_ = g_variant_get_string ((GVariant*) _data_->_tmp3_, NULL);
		_data_->_tmp2_ = _data_->_tmp4_;
	} else {
		_data_->_tmp2_ = _ ("Save");
	}
	_data_->_tmp5_ = g_strdup (_data_->_tmp2_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = files_file_chooser_dialog_new (GTK_FILE_CHOOSER_ACTION_SAVE, _data_->parent_window, _data_->title);
	files_file_chooser_dialog_set_accept_label (_data_->_tmp6_, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	g_object_ref_sink (_data_->_tmp6_);
	_data_->_data8_->dialog = _data_->_tmp6_;
	if (g_hash_table_contains (_data_->options, "modal")) {
		_data_->_tmp7_ = _data_->_data8_->dialog;
		_data_->_tmp8_ = g_hash_table_lookup (_data_->options, "modal");
		gtk_window_set_modal ((GtkWindow*) _data_->_tmp7_, g_variant_get_boolean ((GVariant*) _data_->_tmp8_));
	}
	if (g_hash_table_contains (_data_->options, "current_name")) {
		_data_->_tmp9_ = _data_->_data8_->dialog;
		_data_->_tmp10_ = g_hash_table_lookup (_data_->options, "current_name");
		_data_->_tmp11_ = g_variant_get_string ((GVariant*) _data_->_tmp10_, NULL);
		files_file_chooser_dialog_set_current_name (_data_->_tmp9_, _data_->_tmp11_);
	}
	if (g_hash_table_contains (_data_->options, "current_folder")) {
		_data_->_tmp12_ = _data_->_data8_->dialog;
		_data_->_tmp13_ = g_hash_table_lookup (_data_->options, "current_folder");
		_data_->_tmp14_ = g_variant_get_bytestring ((GVariant*) _data_->_tmp13_);
		_data_->_tmp15_ = files_file_utils_sanitize_path (_data_->_tmp14_, NULL, TRUE);
		_data_->_tmp16_ = _data_->_tmp15_;
		files_file_chooser_dialog_set_current_folder (_data_->_tmp12_, _data_->_tmp16_);
		_g_free0 (_data_->_tmp16_);
	}
	_data_->_tmp17_ = g_strdup ("");
	_data_->_data8_->supplied_uri = _data_->_tmp17_;
	if (g_hash_table_contains (_data_->options, "current_file")) {
		_data_->_tmp18_ = g_hash_table_lookup (_data_->options, "current_file");
		_data_->_tmp19_ = g_variant_get_bytestring ((GVariant*) _data_->_tmp18_);
		_data_->_tmp20_ = g_get_home_dir ();
		_data_->_tmp21_ = files_file_utils_sanitize_path (_data_->_tmp19_, _data_->_tmp20_, TRUE);
		_g_free0 (_data_->_data8_->supplied_uri);
		_data_->_data8_->supplied_uri = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->_data8_->supplied_uri;
		if (g_strcmp0 (_data_->_tmp22_, "") != 0) {
			_data_->_tmp23_ = _data_->_data8_->dialog;
			_data_->_tmp24_ = _data_->_data8_->supplied_uri;
			files_file_chooser_dialog_set_uri (_data_->_tmp23_, _data_->_tmp24_);
		}
	}
	if (g_hash_table_contains (_data_->options, "filters")) {
		_data_->_tmp25_ = g_hash_table_lookup (_data_->options, "filters");
		_data_->_tmp26_ = g_variant_iter_new ((GVariant*) _data_->_tmp25_);
		_data_->filters = _data_->_tmp26_;
		while (TRUE) {
			_data_->_tmp27_ = _data_->filters;
			_data_->_tmp28_ = g_variant_iter_next_value (_data_->_tmp27_);
			_g_variant_unref0 (_data_->filter_variant);
			_data_->filter_variant = _data_->_tmp28_;
			_data_->_tmp29_ = _data_->filter_variant;
			if (!(_data_->_tmp29_ != NULL)) {
				break;
			}
			_data_->_tmp30_ = _data_->filter_variant;
			_data_->_tmp31_ = gtk_file_filter_new_from_gvariant (_data_->_tmp30_);
			g_object_ref_sink (_data_->_tmp31_);
			_data_->filter = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->_data8_->dialog;
			_data_->_tmp33_ = _data_->filter;
			files_file_chooser_dialog_add_filter (_data_->_tmp32_, _data_->_tmp33_);
			_g_object_unref0 (_data_->filter);
		}
		_g_variant_unref0 (_data_->filter_variant);
		_g_variant_iter_free0 (_data_->filters);
	}
	if (g_hash_table_contains (_data_->options, "current_filter")) {
		_data_->_tmp34_ = _data_->_data8_->dialog;
		_data_->_tmp35_ = g_hash_table_lookup (_data_->options, "current_filter");
		_data_->_tmp36_ = gtk_file_filter_new_from_gvariant ((GVariant*) _data_->_tmp35_);
		g_object_ref_sink (_data_->_tmp36_);
		_data_->_tmp37_ = _data_->_tmp36_;
		files_file_chooser_dialog_set_filter (_data_->_tmp34_, _data_->_tmp37_);
		_g_object_unref0 (_data_->_tmp37_);
	}
	if (g_hash_table_contains (_data_->options, "choices")) {
		_data_->_tmp38_ = g_hash_table_lookup (_data_->options, "choices");
		_data_->_tmp39_ = g_variant_iter_new ((GVariant*) _data_->_tmp38_);
		_data_->choices = _data_->_tmp39_;
		while (TRUE) {
			_data_->_tmp40_ = _data_->choices;
			_data_->_tmp41_ = g_variant_iter_next_value (_data_->_tmp40_);
			_g_variant_unref0 (_data_->choice_variant);
			_data_->choice_variant = _data_->_tmp41_;
			_data_->_tmp42_ = _data_->choice_variant;
			if (!(_data_->_tmp42_ != NULL)) {
				break;
			}
			_data_->_tmp43_ = _data_->choice_variant;
			_data_->_tmp44_ = files_file_chooser_choice_new_from_variant (_data_->_tmp43_);
			g_object_ref_sink (_data_->_tmp44_);
			_data_->choice = _data_->_tmp44_;
			_data_->_tmp45_ = _data_->_data8_->dialog;
			_data_->_tmp46_ = _data_->choice;
			files_file_chooser_dialog_add_choice (_data_->_tmp45_, _data_->_tmp46_);
			_g_object_unref0 (_data_->choice);
		}
		_g_variant_unref0 (_data_->choice_variant);
		_g_variant_iter_free0 (_data_->choices);
	}
	_data_->_tmp47_ = _data_->_data8_->dialog;
	_data_->_tmp48_ = _data_->self->priv->connection;
	files_file_chooser_dialog_register_object (_data_->_tmp47_, _data_->_tmp48_, _data_->handle);
	_data_->_tmp49_ = g_str_hash;
	_data_->_tmp50_ = g_str_equal;
	_data_->_tmp51_ = g_hash_table_new_full (_data_->_tmp49_, _data_->_tmp50_, _g_free0_, _g_variant_unref0_);
	_data_->_data8_->_results = _data_->_tmp51_;
	_data_->_data8_->_response = (guint) 2;
	_data_->_tmp52_ = _data_->_data8_->dialog;
	g_signal_connect_data (_data_->_tmp52_, "response", (GCallback) ___lambda28__files_file_chooser_dialog_response, block8_data_ref (_data_->_data8_), (GClosureNotify) block8_data_unref, 0);
	_data_->_tmp53_ = _data_->self->priv->dialogs;
	_data_->_tmp54_ = g_strdup (_data_->parent_window);
	_data_->_tmp55_ = _data_->_data8_->dialog;
	_data_->_tmp56_ = _g_object_ref0 (_data_->_tmp55_);
	g_hash_table_insert (_data_->_tmp53_, _data_->_tmp54_, _data_->_tmp56_);
	_data_->_tmp57_ = _data_->_data8_->dialog;
	gtk_window_present ((GtkWindow*) _data_->_tmp57_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp58_ = _data_->self->priv->dialogs;
	g_hash_table_remove (_data_->_tmp58_, _data_->parent_window);
	_data_->_tmp59_ = _data_->_data8_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp59_);
	_data_->response = _data_->_data8_->_response;
	_data_->_tmp60_ = _data_->_data8_->_results;
	_data_->_tmp61_ = _g_hash_table_ref0 (_data_->_tmp60_);
	_g_hash_table_unref0 (_data_->results);
	_data_->results = _data_->_tmp61_;
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_file_chooser_portal_save_files_data_free (gpointer _data)
{
	FilesFileChooserPortalSaveFilesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->handle);
	_g_free0 (_data_->app_id);
	_g_free0 (_data_->parent_window);
	_g_free0 (_data_->title);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesFileChooserPortalSaveFilesData, _data_);
}

void
files_file_chooser_portal_save_files (FilesFileChooserPortal* self,
                                      const char* handle,
                                      const gchar* app_id,
                                      const gchar* parent_window,
                                      const gchar* title,
                                      GHashTable* options,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FilesFileChooserPortalSaveFilesData* _data_;
	FilesFileChooserPortal* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (parent_window != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (options != NULL);
	_data_ = g_slice_new0 (FilesFileChooserPortalSaveFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_file_chooser_portal_save_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (handle);
	_g_free0 (_data_->handle);
	_data_->handle = _tmp1_;
	_tmp2_ = g_strdup (app_id);
	_g_free0 (_data_->app_id);
	_data_->app_id = _tmp2_;
	_tmp3_ = g_strdup (parent_window);
	_g_free0 (_data_->parent_window);
	_data_->parent_window = _tmp3_;
	_tmp4_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp4_;
	_tmp5_ = _g_hash_table_ref0 (options);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp5_;
	files_file_chooser_portal_save_files_co (_data_);
}

void
files_file_chooser_portal_save_files_finish (FilesFileChooserPortal* self,
                                             GAsyncResult* _res_,
                                             guint* response,
                                             GHashTable** results,
                                             GError** error)
{
	FilesFileChooserPortalSaveFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (response) {
		*response = _data_->response;
	}
	if (results) {
		*results = _data_->results;
	} else {
		_g_hash_table_unref0 (_data_->results);
	}
	_data_->results = NULL;
}

/**
     * Requests the user for a URI, with the intent to write files inside it.
     *
     * Filenames are specified via the "files" option, a folder can be
     * pre-selected with "current_folder". If a file with the same name as one
     * in the "files" list exists, it's replaced.
     *
     * Application specific options can be added to the dialog with "choices"
     * and a label to the select button set with "accept_label".
     *
     * @param handle
     *     Object path where the request should be exported
     * @param app_id
     *     Application originating the call (not used)
     * @param parent_window
     *     Transient parent handle, in format "type:handle". if type is "x11",
     *     handle should be a XID in hexadecimal format. if type is "wayland",
     *     handle should be a xdg_foreign handle. Other types aren't supported.
     * @param title
     *     title for the file chooser dialog
     * @param options
     *     Dictionary of extra options. valid keys are: "accept_label",
     *     "choices", "current_folder", "files" and "modal".
     * @param response
     *     User response, 0 on success, 1 if cancelled, 2 on fail.
     * @param results
     *     Dictionary with the user choices, possible keys are: "uris" and
     *     "choices".
     */
static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		FilesFileChooserPortal* self;
		self = _data10_->self;
		_g_hash_table_unref0 (_data10_->_results);
		_g_object_unref0 (_data10_->dialog);
		_g_hash_table_unref0 (_data10_->options);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GVariant*
_variant_new6 (gchar** value,
               gint value_length1)
{
	gchar** _tmp20_;
	GVariantBuilder _tmp21_;
	gint _tmp22_;
	_tmp20_ = value;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("as"));
	for (_tmp22_ = 0; _tmp22_ < value_length1; _tmp22_++) {
		g_variant_builder_add_value (&_tmp21_, g_variant_new_string (*_tmp20_));
		_tmp20_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp21_));
}

static GVariant*
_variant_new7 (GVariant** value,
               gint value_length1)
{
	GVariant** _tmp30_;
	GVariantBuilder _tmp31_;
	gint _tmp32_;
	_tmp30_ = value;
	g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("av"));
	for (_tmp32_ = 0; _tmp32_ < value_length1; _tmp32_++) {
		g_variant_builder_add_value (&_tmp31_, g_variant_new_variant (*_tmp30_));
		_tmp30_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp31_));
}

static void
__lambda30_ (Block10Data* _data10_,
             GtkResponseType id)
{
	FilesFileChooserPortal* self;
	self = _data10_->self;
	switch (id) {
		case GTK_RESPONSE_OK:
		{
			gchar** uris = NULL;
			gchar** _tmp0_;
			gint uris_length1;
			gint _uris_size_;
			GHashTable* _tmp17_;
			gchar* _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			GVariant* _tmp23_;
			GHashTable* _tmp24_;
			gchar* _tmp25_;
			FilesFileChooserDialog* _tmp26_;
			gint _tmp27_ = 0;
			GVariant** _tmp28_;
			GVariant** _tmp29_;
			gint _tmp29__length1;
			GVariant* _tmp33_;
			_tmp0_ = g_new0 (gchar*, 0 + 1);
			uris = _tmp0_;
			uris_length1 = 0;
			_uris_size_ = uris_length1;
			if (g_hash_table_contains (_data10_->options, "files")) {
				const gchar** files = NULL;
				gconstpointer _tmp1_;
				gsize _tmp2_ = 0;
				const gchar** _tmp3_;
				gint files_length1;
				gint _files_size_;
				GFile* folder = NULL;
				FilesFileChooserDialog* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				const gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp1_ = g_hash_table_lookup (_data10_->options, "files");
				_tmp3_ = g_variant_get_bytestring_array ((GVariant*) _tmp1_, &_tmp2_);
				files = _tmp3_;
				files_length1 = _tmp2_;
				_files_size_ = files_length1;
				_tmp4_ = _data10_->dialog;
				_tmp5_ = files_file_chooser_dialog_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_file_new_for_uri (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				folder = _tmp8_;
				_tmp9_ = files;
				_tmp9__length1 = files_length1;
				{
					const gchar** file_collection = NULL;
					gint file_collection_length1 = 0;
					gint _file_collection_size_ = 0;
					gint file_it = 0;
					file_collection = _tmp9_;
					file_collection_length1 = _tmp9__length1;
					for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
						const gchar* file = NULL;
						file = file_collection[file_it];
						{
							GFile* _tmp10_;
							const gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							GFile* _tmp14_;
							GFile* _tmp15_;
							gchar* _tmp16_;
							_tmp10_ = folder;
							_tmp11_ = file;
							_tmp12_ = g_path_get_basename (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_file_get_child (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_tmp16_ = g_file_get_uri (_tmp15_);
							_vala_array_add3 (&uris, &uris_length1, &_uris_size_, _tmp16_);
							_g_object_unref0 (_tmp15_);
							_g_free0 (_tmp13_);
						}
					}
				}
				_g_object_unref0 (folder);
				files = (g_free (files), NULL);
			}
			_tmp17_ = _data10_->_results;
			_tmp18_ = g_strdup ("uris");
			_tmp19_ = uris;
			_tmp19__length1 = uris_length1;
			_tmp23_ = _variant_new6 (_tmp19_, _tmp19__length1);
			g_hash_table_insert (_tmp17_, _tmp18_, _tmp23_);
			_tmp24_ = _data10_->_results;
			_tmp25_ = g_strdup ("choices");
			_tmp26_ = _data10_->dialog;
			_tmp28_ = files_file_chooser_dialog_get_choices (_tmp26_, &_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp29__length1 = _tmp27_;
			_tmp33_ = _variant_new7 (_tmp29_, _tmp27_);
			g_hash_table_insert (_tmp24_, _tmp25_, _tmp33_);
			_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_variant_unref), NULL);
			_data10_->_response = (guint) 0;
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case GTK_RESPONSE_CANCEL:
		{
			_data10_->_response = (guint) 1;
			break;
		}
		default:
		case GTK_RESPONSE_DELETE_EVENT:
		{
			_data10_->_response = (guint) 2;
			break;
		}
	}
	files_file_chooser_portal_save_files_co (_data10_->_async_data_);
}

static void
___lambda30__files_file_chooser_dialog_response (FilesFileChooserDialog* _sender,
                                                 GtkResponseType response,
                                                 gpointer self)
{
	__lambda30_ (self, response);
}

static gboolean
files_file_chooser_portal_save_files_co (FilesFileChooserPortalSaveFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data10_ = g_slice_new0 (Block10Data);
	_data_->_data10_->_ref_count_ = 1;
	_data_->_data10_->self = g_object_ref (_data_->self);
	_g_hash_table_unref0 (_data_->_data10_->options);
	_data_->_data10_->options = _data_->options;
	_data_->_data10_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->dialogs;
	if (g_hash_table_contains (_data_->_tmp0_, _data_->parent_window)) {
		_data_->_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
		_g_hash_table_unref0 (_data_->results);
		_data_->results = _data_->_tmp1_;
		_data_->response = (guint) 2;
		block10_data_unref (_data_->_data10_);
		_data_->_data10_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (g_hash_table_contains (_data_->_data10_->options, "accept_label")) {
		_data_->_tmp3_ = g_hash_table_lookup (_data_->_data10_->options, "accept_label");
		_data_->_tmp4_ = g_variant_get_string ((GVariant*) _data_->_tmp3_, NULL);
		_data_->_tmp2_ = _data_->_tmp4_;
	} else {
		_data_->_tmp2_ = _ ("Save");
	}
	_data_->_tmp5_ = g_strdup (_data_->_tmp2_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = files_file_chooser_dialog_new (GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _data_->parent_window, _data_->title);
	files_file_chooser_dialog_set_accept_label (_data_->_tmp6_, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	g_object_ref_sink (_data_->_tmp6_);
	_data_->_data10_->dialog = _data_->_tmp6_;
	if (g_hash_table_contains (_data_->_data10_->options, "modal")) {
		_data_->_tmp7_ = _data_->_data10_->dialog;
		_data_->_tmp8_ = g_hash_table_lookup (_data_->_data10_->options, "modal");
		gtk_window_set_modal ((GtkWindow*) _data_->_tmp7_, g_variant_get_boolean ((GVariant*) _data_->_tmp8_));
	}
	if (g_hash_table_contains (_data_->_data10_->options, "current_folder")) {
		_data_->_tmp9_ = _data_->_data10_->dialog;
		_data_->_tmp10_ = g_hash_table_lookup (_data_->_data10_->options, "current_folder");
		_data_->_tmp11_ = g_variant_get_bytestring ((GVariant*) _data_->_tmp10_);
		_data_->_tmp12_ = files_file_utils_sanitize_path (_data_->_tmp11_, NULL, TRUE);
		_data_->_tmp13_ = _data_->_tmp12_;
		files_file_chooser_dialog_set_current_folder (_data_->_tmp9_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
	}
	if (g_hash_table_contains (_data_->_data10_->options, "choices")) {
		_data_->_tmp14_ = g_hash_table_lookup (_data_->_data10_->options, "choices");
		_data_->_tmp15_ = g_variant_iter_new ((GVariant*) _data_->_tmp14_);
		_data_->choices = _data_->_tmp15_;
		while (TRUE) {
			_data_->_tmp16_ = _data_->choices;
			_data_->_tmp17_ = g_variant_iter_next_value (_data_->_tmp16_);
			_g_variant_unref0 (_data_->choice_variant);
			_data_->choice_variant = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->choice_variant;
			if (!(_data_->_tmp18_ != NULL)) {
				break;
			}
			_data_->_tmp19_ = _data_->choice_variant;
			_data_->_tmp20_ = files_file_chooser_choice_new_from_variant (_data_->_tmp19_);
			g_object_ref_sink (_data_->_tmp20_);
			_data_->choice = _data_->_tmp20_;
			_data_->_tmp21_ = _data_->_data10_->dialog;
			_data_->_tmp22_ = _data_->choice;
			files_file_chooser_dialog_add_choice (_data_->_tmp21_, _data_->_tmp22_);
			_g_object_unref0 (_data_->choice);
		}
		_g_variant_unref0 (_data_->choice_variant);
		_g_variant_iter_free0 (_data_->choices);
	}
	_data_->_tmp23_ = _data_->_data10_->dialog;
	_data_->_tmp24_ = _data_->self->priv->connection;
	files_file_chooser_dialog_register_object (_data_->_tmp23_, _data_->_tmp24_, _data_->handle);
	_data_->_tmp25_ = g_str_hash;
	_data_->_tmp26_ = g_str_equal;
	_data_->_tmp27_ = g_hash_table_new_full (_data_->_tmp25_, _data_->_tmp26_, _g_free0_, _g_variant_unref0_);
	_data_->_data10_->_results = _data_->_tmp27_;
	_data_->_data10_->_response = (guint) 2;
	_data_->_tmp28_ = _data_->_data10_->dialog;
	g_signal_connect_data (_data_->_tmp28_, "response", (GCallback) ___lambda30__files_file_chooser_dialog_response, block10_data_ref (_data_->_data10_), (GClosureNotify) block10_data_unref, 0);
	_data_->_tmp29_ = _data_->self->priv->dialogs;
	_data_->_tmp30_ = g_strdup (_data_->parent_window);
	_data_->_tmp31_ = _data_->_data10_->dialog;
	_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
	g_hash_table_insert (_data_->_tmp29_, _data_->_tmp30_, _data_->_tmp32_);
	_data_->_tmp33_ = _data_->_data10_->dialog;
	gtk_window_present ((GtkWindow*) _data_->_tmp33_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp34_ = _data_->self->priv->dialogs;
	g_hash_table_remove (_data_->_tmp34_, _data_->parent_window);
	_data_->_tmp35_ = _data_->_data10_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp35_);
	_data_->response = _data_->_data10_->_response;
	_data_->_tmp36_ = _data_->_data10_->_results;
	_data_->_tmp37_ = _g_hash_table_ref0 (_data_->_tmp36_);
	_g_hash_table_unref0 (_data_->results);
	_data_->results = _data_->_tmp37_;
	block10_data_unref (_data_->_data10_);
	_data_->_data10_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GtkDialog*
files_file_chooser_portal_create_overwrite_dialog (FilesFileChooserPortal* self,
                                                   GtkWindow* parent,
                                                   GFile* file)
{
	gchar* primary = NULL;
	gchar* secondary = NULL;
	GraniteMessageDialog* replace_dialog = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkWindow* _tmp14_;
	GraniteMessageDialog* _tmp15_ = NULL;
	GtkWidget* replace_button = NULL;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkStyleContext* _tmp18_;
	GError* _inner_error0_ = NULL;
	GtkDialog* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	if (g_file_query_file_type (file, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL) == G_FILE_TYPE_SYMBOLIC_LINK) {
		gchar* _tmp7_;
		{
			GFileInfo* info = NULL;
			GFileInfo* _tmp0_;
			GFileInfo* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = info;
			_tmp2_ = g_file_info_get_attribute_byte_string (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
			_tmp3_ = g_strdup_printf (_ ("This file is a link to “%s”"), _tmp2_);
			_g_free0 (primary);
			primary = _tmp3_;
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			g_clear_error (&_inner_error0_);
			_tmp4_ = g_file_get_uri (file);
			_tmp5_ = _tmp4_;
			g_warning ("Main.vala:456: Could not get info for %s", _tmp5_);
			_g_free0 (_tmp5_);
			_tmp6_ = g_strdup (_ ("This file is a link."));
			_g_free0 (primary);
			primary = _tmp6_;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (secondary);
			_g_free0 (primary);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = g_strdup (_ ("Replacing a link will overwrite the target's contents. The link will r" \
"emain"));
		_g_free0 (secondary);
		secondary = _tmp7_;
	} else {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = g_file_get_basename (file);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_ ("Replace “%s”?"), _tmp9_);
		_g_free0 (primary);
		primary = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = g_strdup (_ ("Replacing this file will overwrite its current contents"));
		_g_free0 (secondary);
		secondary = _tmp11_;
	}
	_tmp12_ = primary;
	_tmp13_ = secondary;
	_tmp14_ = _g_object_ref0 (parent);
	_tmp15_ = granite_message_dialog_new_with_image_from_icon_name (_tmp12_, _tmp13_, "dialog-warning", GTK_BUTTONS_CANCEL);
	gtk_window_set_modal ((GtkWindow*) _tmp15_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	replace_dialog = _tmp15_;
	_tmp16_ = gtk_dialog_add_button ((GtkDialog*) replace_dialog, _ ("Replace"), (gint) GTK_RESPONSE_YES);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	replace_button = _tmp17_;
	_tmp18_ = gtk_widget_get_style_context (replace_button);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	result = (GtkDialog*) replace_dialog;
	_g_object_unref0 (replace_button);
	_g_free0 (secondary);
	_g_free0 (primary);
	return result;
}

static void
files_file_chooser_portal_on_bus_acquired (GDBusConnection* connection,
                                           const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	{
		FilesFileChooserPortal* _tmp0_;
		FilesFileChooserPortal* _tmp1_;
		_tmp0_ = files_file_chooser_portal_new (connection);
		_tmp1_ = _tmp0_;
		files_file_chooser_portal_register_object (_tmp1_, connection, "/org/freedesktop/portal/desktop", &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("Main.vala:486: Unable to register the object: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_main_loop_unref0 (_data11_->loop);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
_files_file_chooser_portal_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self)
{
	files_file_chooser_portal_on_bus_acquired (connection, name);
}

static void
__lambda31_ (void)
{
	g_debug ("Main.vala:525: org.freedesktop.impl.portal.desktop.elementary.files ac" \
"quired");
}

static void
___lambda31__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda31_ ();
}

static void
__lambda32_ (Block11Data* _data11_)
{
	GMainLoop* _tmp0_;
	_tmp0_ = _data11_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
___lambda32__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda32_ (self);
}

static gint
files_file_chooser_portal_main (gchar** args,
                                gint args_length1)
{
	Block11Data* _data11_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GMainLoop* _tmp8_;
	GBusNameOwnerFlags _tmp9_ = 0U;
	guint owner_id = 0U;
	GMainLoop* _tmp10_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	setlocale (LC_ALL, "");
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	g_unsetenv ("GTK_USE_PORTAL");
	gtk_init ((gint*) (&args_length1), &args);
	_tmp0_ = g_option_context_new ("- FileChooser portal");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, FILES_FILE_CHOOSER_PORTAL_ENTRIES, NULL);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_get_application_name ();
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_printerr ("%s: %s", _tmp3_, _tmp5_);
		g_printerr ("\n");
		_tmp6_ = g_get_prgname ();
		g_printerr ("Try \"%s --help\" for more information.", _tmp6_);
		g_printerr ("\n");
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (context);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	if (files_file_chooser_portal_show_version) {
		g_print ("0.0 \n");
		result = 0;
		_g_option_context_free0 (context);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return result;
	}
	_tmp8_ = g_main_loop_new (NULL, FALSE);
	_data11_->loop = _tmp8_;
	if (files_file_chooser_portal_opt_replace) {
		_tmp9_ = G_BUS_NAME_OWNER_FLAGS_REPLACE;
	} else {
		_tmp9_ = 0;
	}
	owner_id = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.impl.portal.desktop.elementary.files", G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | _tmp9_, (GClosure*) g_cclosure_new ((GCallback) _files_file_chooser_portal_on_bus_acquired_gbus_acquired_callback, NULL, (GClosureNotify) NULL), (GClosure*) ((___lambda31__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda31__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda32__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda32__gbus_name_lost_callback, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref)));
	_tmp10_ = _data11_->loop;
	g_main_loop_run (_tmp10_);
	g_bus_unown_name (owner_id);
	result = 0;
	_g_option_context_free0 (context);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return files_file_chooser_portal_main (argv, argc);
}

static void
files_file_chooser_portal_class_init (FilesFileChooserPortalClass * klass,
                                      gpointer klass_data)
{
	files_file_chooser_portal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesFileChooserPortal_private_offset);
	G_OBJECT_CLASS (klass)->finalize = files_file_chooser_portal_finalize;
}

static void
files_file_chooser_portal_instance_init (FilesFileChooserPortal * self,
                                         gpointer klass)
{
	self->priv = files_file_chooser_portal_get_instance_private (self);
}

static void
files_file_chooser_portal_finalize (GObject * obj)
{
	FilesFileChooserPortal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE_CHOOSER_PORTAL, FilesFileChooserPortal);
	_g_hash_table_unref0 (self->priv->dialogs);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (files_file_chooser_portal_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_file_chooser_portal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileChooserPortalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_file_chooser_portal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileChooserPortal), 0, (GInstanceInitFunc) files_file_chooser_portal_instance_init, NULL };
	GType files_file_chooser_portal_type_id;
	files_file_chooser_portal_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesFileChooserPortal", &g_define_type_info, 0);
	g_type_set_qdata (files_file_chooser_portal_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) files_file_chooser_portal_register_object);
	FilesFileChooserPortal_private_offset = g_type_add_instance_private (files_file_chooser_portal_type_id, sizeof (FilesFileChooserPortalPrivate));
	return files_file_chooser_portal_type_id;
}

GType
files_file_chooser_portal_get_type (void)
{
	static volatile gsize files_file_chooser_portal_type_id__once = 0;
	if (g_once_init_enter (&files_file_chooser_portal_type_id__once)) {
		GType files_file_chooser_portal_type_id;
		files_file_chooser_portal_type_id = files_file_chooser_portal_get_type_once ();
		g_once_init_leave (&files_file_chooser_portal_type_id__once, files_file_chooser_portal_type_id);
	}
	return files_file_chooser_portal_type_id__once;
}

static void
_dbus_files_file_chooser_portal_open_file (FilesFileChooserPortal* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FilesFileChooserPortalOpenFileReadyData* _ready_data;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GHashTable* _tmp5_;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FilesFileChooserPortalOpenFileReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->handle = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->parent_window = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->title = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp6_, _tmp4_);
	while (g_variant_iter_loop (&_tmp6_, "{?*}", &_tmp7_, &_tmp8_)) {
		g_hash_table_insert (_tmp5_, g_variant_dup_string (_tmp7_, NULL), g_variant_get_variant (_tmp8_));
	}
	_ready_data->options = _tmp5_;
	g_variant_unref (_tmp4_);
	files_file_chooser_portal_open_file (self, _ready_data->handle, _ready_data->app_id, _ready_data->parent_window, _ready_data->title, _ready_data->options, (GAsyncReadyCallback) _dbus_files_file_chooser_portal_open_file_ready, _ready_data);
	_error:
	;
}

static void
_dbus_files_file_chooser_portal_open_file_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_)
{
	FilesFileChooserPortalOpenFileReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint response = 0U;
	GHashTable* results = NULL;
	GVariantBuilder _tmp9_;
	GHashTableIter _tmp10_;
	gpointer _tmp11_;
	gpointer _tmp12_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	files_file_chooser_portal_open_file_finish ((FilesFileChooserPortal*) source_object, _res_, &response, &results, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (response));
	g_hash_table_iter_init (&_tmp10_, results);
	g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp10_, &_tmp11_, &_tmp12_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp11_;
		_value = (GVariant*) _tmp12_;
		g_variant_builder_add (&_tmp9_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp9_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->handle);
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->parent_window);
	_g_free0 (_ready_data->title);
	_g_hash_table_unref0 (_ready_data->options);
	_g_hash_table_unref0 (results);
	g_slice_free (FilesFileChooserPortalOpenFileReadyData, _ready_data);
}

static void
_dbus_files_file_chooser_portal_save_file (FilesFileChooserPortal* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FilesFileChooserPortalSaveFileReadyData* _ready_data;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GHashTable* _tmp18_;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FilesFileChooserPortalSaveFileReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->handle = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->parent_window = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->title = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp18_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp19_, _tmp17_);
	while (g_variant_iter_loop (&_tmp19_, "{?*}", &_tmp20_, &_tmp21_)) {
		g_hash_table_insert (_tmp18_, g_variant_dup_string (_tmp20_, NULL), g_variant_get_variant (_tmp21_));
	}
	_ready_data->options = _tmp18_;
	g_variant_unref (_tmp17_);
	files_file_chooser_portal_save_file (self, _ready_data->handle, _ready_data->app_id, _ready_data->parent_window, _ready_data->title, _ready_data->options, (GAsyncReadyCallback) _dbus_files_file_chooser_portal_save_file_ready, _ready_data);
	_error:
	;
}

static void
_dbus_files_file_chooser_portal_save_file_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_)
{
	FilesFileChooserPortalSaveFileReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint response = 0U;
	GHashTable* results = NULL;
	GVariantBuilder _tmp22_;
	GHashTableIter _tmp23_;
	gpointer _tmp24_;
	gpointer _tmp25_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	files_file_chooser_portal_save_file_finish ((FilesFileChooserPortal*) source_object, _res_, &response, &results, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (response));
	g_hash_table_iter_init (&_tmp23_, results);
	g_variant_builder_init (&_tmp22_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp23_, &_tmp24_, &_tmp25_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp24_;
		_value = (GVariant*) _tmp25_;
		g_variant_builder_add (&_tmp22_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp22_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->handle);
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->parent_window);
	_g_free0 (_ready_data->title);
	_g_hash_table_unref0 (_ready_data->options);
	_g_hash_table_unref0 (results);
	g_slice_free (FilesFileChooserPortalSaveFileReadyData, _ready_data);
}

static void
_dbus_files_file_chooser_portal_save_files (FilesFileChooserPortal* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FilesFileChooserPortalSaveFilesReadyData* _ready_data;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GHashTable* _tmp31_;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FilesFileChooserPortalSaveFilesReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->handle = g_variant_dup_string (_tmp26_, NULL);
	g_variant_unref (_tmp26_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->parent_window = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->title = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp32_, _tmp30_);
	while (g_variant_iter_loop (&_tmp32_, "{?*}", &_tmp33_, &_tmp34_)) {
		g_hash_table_insert (_tmp31_, g_variant_dup_string (_tmp33_, NULL), g_variant_get_variant (_tmp34_));
	}
	_ready_data->options = _tmp31_;
	g_variant_unref (_tmp30_);
	files_file_chooser_portal_save_files (self, _ready_data->handle, _ready_data->app_id, _ready_data->parent_window, _ready_data->title, _ready_data->options, (GAsyncReadyCallback) _dbus_files_file_chooser_portal_save_files_ready, _ready_data);
	_error:
	;
}

static void
_dbus_files_file_chooser_portal_save_files_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	FilesFileChooserPortalSaveFilesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint response = 0U;
	GHashTable* results = NULL;
	GVariantBuilder _tmp35_;
	GHashTableIter _tmp36_;
	gpointer _tmp37_;
	gpointer _tmp38_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	files_file_chooser_portal_save_files_finish ((FilesFileChooserPortal*) source_object, _res_, &response, &results, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (response));
	g_hash_table_iter_init (&_tmp36_, results);
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp36_, &_tmp37_, &_tmp38_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp37_;
		_value = (GVariant*) _tmp38_;
		g_variant_builder_add (&_tmp35_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp35_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->handle);
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->parent_window);
	_g_free0 (_ready_data->title);
	_g_hash_table_unref0 (_ready_data->options);
	_g_hash_table_unref0 (results);
	g_slice_free (FilesFileChooserPortalSaveFilesReadyData, _ready_data);
}

static void
files_file_chooser_portal_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "OpenFile") == 0) {
		_dbus_files_file_chooser_portal_open_file (object, parameters, invocation);
	} else if (strcmp (method_name, "SaveFile") == 0) {
		_dbus_files_file_chooser_portal_save_file (object, parameters, invocation);
	} else if (strcmp (method_name, "SaveFiles") == 0) {
		_dbus_files_file_chooser_portal_save_files (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
files_file_chooser_portal_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
files_file_chooser_portal_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
files_file_chooser_portal_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_files_file_chooser_portal_dbus_interface_info), &_files_file_chooser_portal_dbus_interface_vtable, data, _files_file_chooser_portal_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_files_file_chooser_portal_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

