/* SourceList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceList.vala, do not modify */

/*
 *  Copyright (C) 2012-2014 Victor Martinez <victoreduardm@gmail.com>
 *
 *  This program or library is free software; you can redistribute it
 *  and/or modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General
 *  Public License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301 USA.
 */
/**
         * = WORKING INTERNALS =
         *
         * In order to offer a transparent Item-based API, and avoid the need of providing methods
         * to deal with items directly on the SourceListPatch widget, it was decided to follow a monitor-like
         * implementation, where the source list permanently monitors its root item and any other
         * child item added to it. The task of monitoring the properties of the items has been
         * divided among different objects, as shown below:
         *
         * Monitored by: Object::method that receives the signals indicating the property change.
         * Applied by: Object::method that actually updates the tree to reflect the property changes
         *             (directly or indirectly, as in the case of the tree data model).
         *
         * ---------------------------------------------------------------------------------------------
         *   PROPERTY        |  MONITORED BY                     |  APPLIED BY
         * ---------------------------------------------------------------------------------------------
         * + Item            |                                   |
         *   - parent        | Not monitored                     | N/A
         *   - name          | DataModel::on_item_prop_changed   | Tree::name_cell_data_func
         *   - editable      | DataModel::on_item_prop_changed   | Queried when needed (See Tree::start_editing_item)
         *   - visible       | DataModel::on_item_prop_changed   | DataModel::filter_visible_func
         *   - icon          | DataModel::on_item_prop_changed   | Tree::icon_cell_data_func
         *   - activatable   | Same as @icon                     | Same as @icon
         * + ExpandableItem  |                                   |
         *   - collapsible   | DataModel::on_item_prop_changed   | Tree::update_expansion
         *                   |                                   | Tree::expander_cell_data_func
         *   - expanded      | Same as @collapsible              | Same as @collapsible
         * ---------------------------------------------------------------------------------------------
         * * Only automatic properties are monitored. ExpandableItem's additions/removals are handled by
         *   DataModel::add_item() and DataModel::remove_item()
         *
         * Other features:
         * - Sorting: this happens on the tree-model level (DataModel).
         */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <cairo-gobject.h>
#include <granite.h>

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE "item-parent-needs-update"
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_ICON_SIZE GTK_ICON_SIZE_MENU
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DEFAULT_STYLESHEET "\n" \
"                .source-list.badge {\n" \
"                    border-radius: 10px;\n" \
"                    border-width: 0;\n" \
"                    padding: 1px 2px 1px 2px;\n" \
"                    font-weight: bold;\n" \
"                }\n" \
"            "
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEVEL_INDENTATION "level-indentation"
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEFT_PADDING "left-padding"
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_EXPANDER_SPACING "expander-spacing"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_SORTABLE (granite_widgets_source_list_patch_sortable_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_SORTABLE, GraniteWidgetsSourceListPatchSortable))
#define GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_SORTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_SORTABLE))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_SORTABLE, GraniteWidgetsSourceListPatchSortableIface))

typedef struct _GraniteWidgetsSourceListPatchSortable GraniteWidgetsSourceListPatchSortable;
typedef struct _GraniteWidgetsSourceListPatchSortableIface GraniteWidgetsSourceListPatchSortableIface;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM (granite_widgets_source_list_patch_item_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItem))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItemClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItemClass))

typedef struct _GraniteWidgetsSourceListPatchItem GraniteWidgetsSourceListPatchItem;
typedef struct _GraniteWidgetsSourceListPatchItemClass GraniteWidgetsSourceListPatchItemClass;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM (granite_widgets_source_list_patch_expandable_item_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItem))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItemClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItemClass))

typedef struct _GraniteWidgetsSourceListPatchExpandableItem GraniteWidgetsSourceListPatchExpandableItem;
typedef struct _GraniteWidgetsSourceListPatchExpandableItemClass GraniteWidgetsSourceListPatchExpandableItemClass;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_USER_MOVED_ITEM_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_SOURCE (granite_widgets_source_list_patch_drag_source_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_SOURCE, GraniteWidgetsSourceListPatchDragSource))
#define GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_SOURCE))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_SOURCE, GraniteWidgetsSourceListPatchDragSourceIface))

typedef struct _GraniteWidgetsSourceListPatchDragSource GraniteWidgetsSourceListPatchDragSource;
typedef struct _GraniteWidgetsSourceListPatchDragSourceIface GraniteWidgetsSourceListPatchDragSourceIface;

#define GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_DEST (granite_widgets_source_list_patch_drag_dest_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_DEST, GraniteWidgetsSourceListPatchDragDest))
#define GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_DEST))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_DEST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_DRAG_DEST, GraniteWidgetsSourceListPatchDragDestIface))

typedef struct _GraniteWidgetsSourceListPatchDragDest GraniteWidgetsSourceListPatchDragDest;
typedef struct _GraniteWidgetsSourceListPatchDragDestIface GraniteWidgetsSourceListPatchDragDestIface;

#define GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH (granite_widgets_source_list_patch_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatch))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatchClass))
#define GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH))
#define GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatchClass))

typedef struct _GraniteWidgetsSourceListPatch GraniteWidgetsSourceListPatch;
typedef struct _GraniteWidgetsSourceListPatchClass GraniteWidgetsSourceListPatchClass;
typedef struct _GraniteWidgetsSourceListPatchPrivate GraniteWidgetsSourceListPatchPrivate;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE (granite_widgets_source_list_patch_tree_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTree))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTreeClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTreeClass))

typedef struct _GraniteWidgetsSourceListPatchTree GraniteWidgetsSourceListPatchTree;
typedef struct _GraniteWidgetsSourceListPatchTreeClass GraniteWidgetsSourceListPatchTreeClass;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL (granite_widgets_source_list_patch_data_model_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModel))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModelClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_DATA_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_DATA_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModelClass))

typedef struct _GraniteWidgetsSourceListPatchDataModel GraniteWidgetsSourceListPatchDataModel;
typedef struct _GraniteWidgetsSourceListPatchDataModelClass GraniteWidgetsSourceListPatchDataModelClass;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EDITING_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gboolean (*GraniteWidgetsSourceListPatchVisibleFunc) (GraniteWidgetsSourceListPatchItem* item, gpointer user_data);
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _GraniteWidgetsSourceListPatchItemPrivate GraniteWidgetsSourceListPatchItemPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTION_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NUM_SIGNALS] = {0};
typedef struct _GraniteWidgetsSourceListPatchExpandableItemPrivate GraniteWidgetsSourceListPatchExpandableItemPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILDREN_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_TOGGLED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_NUM_SIGNALS] = {0};
typedef struct _GraniteWidgetsSourceListPatchDataModelPrivate GraniteWidgetsSourceListPatchDataModelPrivate;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER (granite_widgets_source_list_patch_data_model_node_wrapper_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListPatchDataModelNodeWrapper))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListPatchDataModelNodeWrapperClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_IS_NODE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_IS_NODE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NODE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListPatchDataModelNodeWrapperClass))

typedef struct _GraniteWidgetsSourceListPatchDataModelNodeWrapper GraniteWidgetsSourceListPatchDataModelNodeWrapper;
typedef struct _GraniteWidgetsSourceListPatchDataModelNodeWrapperClass GraniteWidgetsSourceListPatchDataModelNodeWrapperClass;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR (granite_widgets_source_list_patch_data_model_item_monitor_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListPatchDataModelItemMonitor))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListPatchDataModelItemMonitorClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_IS_ITEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_IS_ITEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListPatchDataModelItemMonitorClass))

typedef struct _GraniteWidgetsSourceListPatchDataModelItemMonitor GraniteWidgetsSourceListPatchDataModelItemMonitor;
typedef struct _GraniteWidgetsSourceListPatchDataModelItemMonitorClass GraniteWidgetsSourceListPatchDataModelItemMonitorClass;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NUM_PROPERTIES];
typedef enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_N_COLUMNS
} GraniteWidgetsSourceListPatchDataModelColumn;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_COLUMN (granite_widgets_source_list_patch_data_model_column_get_type ())
#define _granite_widgets_source_list_patch_data_model_node_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (granite_widgets_source_list_patch_data_model_node_wrapper_unref (var), NULL)))
#define _granite_widgets_source_list_patch_data_model_item_monitor_unref0(var) ((var == NULL) ? NULL : (var = (granite_widgets_source_list_patch_data_model_item_monitor_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _GraniteWidgetsSourceListPatchDataModelNodeWrapperPrivate GraniteWidgetsSourceListPatchDataModelNodeWrapperPrivate;
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
typedef struct _GraniteWidgetsSourceListPatchDataModelParamSpecNodeWrapper GraniteWidgetsSourceListPatchDataModelParamSpecNodeWrapper;
typedef struct _GraniteWidgetsSourceListPatchDataModelItemMonitorPrivate GraniteWidgetsSourceListPatchDataModelItemMonitorPrivate;
typedef struct _GraniteWidgetsSourceListPatchDataModelParamSpecItemMonitor GraniteWidgetsSourceListPatchDataModelParamSpecItemMonitor;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_NUM_SIGNALS] = {0};
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_UPDATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON (granite_widgets_source_list_patch_cell_renderer_icon_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListPatchCellRendererIcon))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListPatchCellRendererIconClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListPatchCellRendererIconClass))

typedef struct _GraniteWidgetsSourceListPatchCellRendererIcon GraniteWidgetsSourceListPatchCellRendererIcon;
typedef struct _GraniteWidgetsSourceListPatchCellRendererIconClass GraniteWidgetsSourceListPatchCellRendererIconClass;
typedef struct _GraniteWidgetsSourceListPatchCellRendererIconPrivate GraniteWidgetsSourceListPatchCellRendererIconPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_cell_renderer_icon_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_NUM_PROPERTIES];
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_NUM_SIGNALS] = {0};

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER (granite_widgets_source_list_patch_cell_renderer_spacer_get_type ())
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacer))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacerClass))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_SPACER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_SPACER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER))
#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacerClass))

typedef struct _GraniteWidgetsSourceListPatchCellRendererSpacer GraniteWidgetsSourceListPatchCellRendererSpacer;
typedef struct _GraniteWidgetsSourceListPatchCellRendererSpacerClass GraniteWidgetsSourceListPatchCellRendererSpacerClass;
typedef struct _GraniteWidgetsSourceListPatchCellRendererSpacerPrivate GraniteWidgetsSourceListPatchCellRendererSpacerPrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_NUM_PROPERTIES];
typedef struct _GraniteWidgetsSourceListPatchTreePrivate GraniteWidgetsSourceListPatchTreePrivate;
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_0_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_EDITING_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_NUM_PROPERTIES];
typedef enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_N_COLS
} GraniteWidgetsSourceListPatchTreeColumn;

#define GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_TYPE_COLUMN (granite_widgets_source_list_patch_tree_column_get_type ())
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ITEM_SELECTED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_NUM_SIGNALS] = {0};
enum  {
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTED_SIGNAL,
	GRANITE_WIDGETS_SOURCE_LIST_PATCH_NUM_SIGNALS
};
static guint granite_widgets_source_list_patch_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GraniteWidgetsSourceListPatchSortableIface {
	GTypeInterface parent_iface;
	gboolean (*allow_dnd_sorting) (GraniteWidgetsSourceListPatchSortable* self);
	gint (*compare) (GraniteWidgetsSourceListPatchSortable* self, GraniteWidgetsSourceListPatchItem* a, GraniteWidgetsSourceListPatchItem* b);
};

struct _GraniteWidgetsSourceListPatchDragSourceIface {
	GTypeInterface parent_iface;
	gboolean (*draggable) (GraniteWidgetsSourceListPatchDragSource* self);
	void (*prepare_selection_data) (GraniteWidgetsSourceListPatchDragSource* self, GtkSelectionData* selection_data);
};

struct _GraniteWidgetsSourceListPatchDragDestIface {
	GTypeInterface parent_iface;
	gboolean (*data_drop_possible) (GraniteWidgetsSourceListPatchDragDest* self, GdkDragContext* context, GtkSelectionData* data);
	GdkDragAction (*data_received) (GraniteWidgetsSourceListPatchDragDest* self, GdkDragContext* context, GtkSelectionData* data);
};

struct _GraniteWidgetsSourceListPatch {
	GtkScrolledWindow parent_instance;
	GraniteWidgetsSourceListPatchPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchClass {
	GtkScrolledWindowClass parent_class;
	void (*item_selected) (GraniteWidgetsSourceListPatch* self, GraniteWidgetsSourceListPatchItem* item);
};

struct _GraniteWidgetsSourceListPatchPrivate {
	GraniteWidgetsSourceListPatchTree* tree;
	GraniteWidgetsSourceListPatchDataModel* data_model;
};

struct _GraniteWidgetsSourceListPatchItem {
	GObject parent_instance;
	GraniteWidgetsSourceListPatchItemPrivate * priv;
	gboolean use_pango_style;
	gboolean force_visible;
};

struct _GraniteWidgetsSourceListPatchItemClass {
	GObjectClass parent_class;
	GtkMenu* (*get_context_menu) (GraniteWidgetsSourceListPatchItem* self);
	void (*edited) (GraniteWidgetsSourceListPatchItem* self, const gchar* new_name);
	void (*action_activated) (GraniteWidgetsSourceListPatchItem* self);
	void (*activated) (GraniteWidgetsSourceListPatchItem* self);
};

struct _GraniteWidgetsSourceListPatchItemPrivate {
	GraniteWidgetsSourceListPatchExpandableItem* _parent;
	gchar* _name;
	gchar* _markup;
	gchar* _badge;
	gboolean _editable;
	gboolean _visible;
	gboolean _selectable;
	GIcon* _icon;
	GIcon* _activatable;
};

struct _GraniteWidgetsSourceListPatchExpandableItem {
	GraniteWidgetsSourceListPatchItem parent_instance;
	GraniteWidgetsSourceListPatchExpandableItemPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchExpandableItemClass {
	GraniteWidgetsSourceListPatchItemClass parent_class;
	void (*toggled) (GraniteWidgetsSourceListPatchExpandableItem* self);
};

struct _GraniteWidgetsSourceListPatchExpandableItemPrivate {
	gboolean _collapsible;
	gboolean _expanded;
	GeeCollection* children_list;
};

struct _GraniteWidgetsSourceListPatchDataModel {
	GtkTreeModelFilter parent_instance;
	GraniteWidgetsSourceListPatchDataModelPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchDataModelClass {
	GtkTreeModelFilterClass parent_class;
};

struct _GraniteWidgetsSourceListPatchDataModelPrivate {
	GraniteWidgetsSourceListPatchExpandableItem* _root;
	GeeHashMap* items;
	GeeHashMap* monitors;
	GtkTreeStore* child_tree;
	GraniteWidgetsSourceListPatchVisibleFunc filter_func;
	gpointer filter_func_target;
};

struct _Block1Data {
	int _ref_count_;
	GraniteWidgetsSourceListPatchDataModel* self;
	GraniteWidgetsSourceListPatchExpandableItem* parent;
};

struct _GraniteWidgetsSourceListPatchDataModelNodeWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GraniteWidgetsSourceListPatchDataModelNodeWrapperPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchDataModelNodeWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GraniteWidgetsSourceListPatchDataModelNodeWrapper *self);
};

struct _GraniteWidgetsSourceListPatchDataModelNodeWrapperPrivate {
	GtkTreeRowReference* row_reference;
};

struct _GraniteWidgetsSourceListPatchDataModelParamSpecNodeWrapper {
	GParamSpec parent_instance;
};

struct _GraniteWidgetsSourceListPatchDataModelItemMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GraniteWidgetsSourceListPatchDataModelItemMonitorPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchDataModelItemMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (GraniteWidgetsSourceListPatchDataModelItemMonitor *self);
};

struct _GraniteWidgetsSourceListPatchDataModelItemMonitorPrivate {
	GraniteWidgetsSourceListPatchItem* item;
};

struct _GraniteWidgetsSourceListPatchDataModelParamSpecItemMonitor {
	GParamSpec parent_instance;
};

struct _GraniteWidgetsSourceListPatchCellRendererIcon {
	GtkCellRendererPixbuf parent_instance;
	GraniteWidgetsSourceListPatchCellRendererIconPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchCellRendererIconClass {
	GtkCellRendererPixbufClass parent_class;
};

struct _GraniteWidgetsSourceListPatchCellRendererSpacer {
	GtkCellRenderer parent_instance;
	GraniteWidgetsSourceListPatchCellRendererSpacerPrivate * priv;
};

struct _GraniteWidgetsSourceListPatchCellRendererSpacerClass {
	GtkCellRendererClass parent_class;
};

struct _GraniteWidgetsSourceListPatchCellRendererSpacerPrivate {
	gint _level;
};

struct _GraniteWidgetsSourceListPatchTree {
	GtkTreeView parent_instance;
	GraniteWidgetsSourceListPatchTreePrivate * priv;
};

struct _GraniteWidgetsSourceListPatchTreeClass {
	GtkTreeViewClass parent_class;
};

struct _GraniteWidgetsSourceListPatchTreePrivate {
	GraniteWidgetsSourceListPatchDataModel* _data_model;
	GraniteWidgetsSourceListPatchItem* selected;
	GraniteWidgetsSourceListPatchItem* edited;
	GtkEntry* editable_entry;
	GtkCellRendererText* text_cell;
	GraniteWidgetsSourceListPatchCellRendererIcon* icon_cell;
	GraniteWidgetsSourceListPatchCellRendererIcon* activatable_cell;
	GraniteWidgetsCellRendererBadge* badge_cell;
	GraniteWidgetsCellRendererExpander* primary_expander_cell;
	GraniteWidgetsCellRendererExpander* secondary_expander_cell;
	GeeHashMap* spacer_cells;
	gboolean unselectable_item_clicked;
};

static gint GraniteWidgetsSourceListPatch_private_offset;
static gpointer granite_widgets_source_list_patch_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchItem_private_offset;
static gpointer granite_widgets_source_list_patch_item_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchExpandableItem_private_offset;
static gpointer granite_widgets_source_list_patch_expandable_item_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchDataModel_private_offset;
static gpointer granite_widgets_source_list_patch_data_model_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchDataModelNodeWrapper_private_offset;
static gpointer granite_widgets_source_list_patch_data_model_node_wrapper_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchDataModelItemMonitor_private_offset;
static gpointer granite_widgets_source_list_patch_data_model_item_monitor_parent_class = NULL;
static GtkTreeDragSourceIface * granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_parent_iface = NULL;
static GtkTreeDragDestIface * granite_widgets_source_list_patch_data_model_gtk_tree_drag_dest_parent_iface = NULL;
static gpointer granite_widgets_source_list_patch_cell_renderer_icon_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchCellRendererSpacer_private_offset;
static gpointer granite_widgets_source_list_patch_cell_renderer_spacer_parent_class = NULL;
static gint GraniteWidgetsSourceListPatchTree_private_offset;
static gpointer granite_widgets_source_list_patch_tree_parent_class = NULL;

VALA_EXTERN GType granite_widgets_source_list_patch_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchItem, g_object_unref)
VALA_EXTERN GType granite_widgets_source_list_patch_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchExpandableItem, g_object_unref)
VALA_EXTERN GType granite_widgets_source_list_patch_sortable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchSortable, g_object_unref)
VALA_EXTERN gboolean granite_widgets_source_list_patch_sortable_allow_dnd_sorting (GraniteWidgetsSourceListPatchSortable* self);
VALA_EXTERN gint granite_widgets_source_list_patch_sortable_compare (GraniteWidgetsSourceListPatchSortable* self,
                                                         GraniteWidgetsSourceListPatchItem* a,
                                                         GraniteWidgetsSourceListPatchItem* b);
static GType granite_widgets_source_list_patch_sortable_get_type_once (void);
VALA_EXTERN GType granite_widgets_source_list_patch_drag_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchDragSource, g_object_unref)
VALA_EXTERN gboolean granite_widgets_source_list_patch_drag_source_draggable (GraniteWidgetsSourceListPatchDragSource* self);
VALA_EXTERN void granite_widgets_source_list_patch_drag_source_prepare_selection_data (GraniteWidgetsSourceListPatchDragSource* self,
                                                                           GtkSelectionData* selection_data);
static GType granite_widgets_source_list_patch_drag_source_get_type_once (void);
VALA_EXTERN GType granite_widgets_source_list_patch_drag_dest_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchDragDest, g_object_unref)
VALA_EXTERN gboolean granite_widgets_source_list_patch_drag_dest_data_drop_possible (GraniteWidgetsSourceListPatchDragDest* self,
                                                                         GdkDragContext* context,
                                                                         GtkSelectionData* data);
VALA_EXTERN GdkDragAction granite_widgets_source_list_patch_drag_dest_data_received (GraniteWidgetsSourceListPatchDragDest* self,
                                                                         GdkDragContext* context,
                                                                         GtkSelectionData* data);
static GType granite_widgets_source_list_patch_drag_dest_get_type_once (void);
VALA_EXTERN GType granite_widgets_source_list_patch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatch, g_object_unref)
static GType granite_widgets_source_list_patch_tree_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchTree, g_object_unref)
static GType granite_widgets_source_list_patch_data_model_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchDataModel, g_object_unref)
static GraniteWidgetsSourceListPatchDataModel* granite_widgets_source_list_patch_data_model_new (void);
static GraniteWidgetsSourceListPatchDataModel* granite_widgets_source_list_patch_data_model_construct (GType object_type);
VALA_EXTERN GraniteWidgetsSourceListPatch* granite_widgets_source_list_patch_new (GraniteWidgetsSourceListPatchExpandableItem* root);
VALA_EXTERN GraniteWidgetsSourceListPatch* granite_widgets_source_list_patch_construct (GType object_type,
                                                                            GraniteWidgetsSourceListPatchExpandableItem* root);
VALA_EXTERN void granite_widgets_source_list_patch_set_root (GraniteWidgetsSourceListPatch* self,
                                                 GraniteWidgetsSourceListPatchExpandableItem* value);
VALA_EXTERN gboolean granite_widgets_source_list_patch_has_item (GraniteWidgetsSourceListPatch* self,
                                                     GraniteWidgetsSourceListPatchItem* item);
static gboolean granite_widgets_source_list_patch_data_model_has_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                                GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN void granite_widgets_source_list_patch_set_filter_func (GraniteWidgetsSourceListPatch* self,
                                                        GraniteWidgetsSourceListPatchVisibleFunc visible_func,
                                                        gpointer visible_func_target,
                                                        gboolean refilter);
static void granite_widgets_source_list_patch_data_model_set_filter_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                                   GraniteWidgetsSourceListPatchVisibleFunc visible_func,
                                                                   gpointer visible_func_target);
VALA_EXTERN void granite_widgets_source_list_patch_refilter (GraniteWidgetsSourceListPatch* self);
VALA_EXTERN gboolean granite_widgets_source_list_patch_is_item_expanded (GraniteWidgetsSourceListPatch* self,
                                                             GraniteWidgetsSourceListPatchItem* item);
static GtkTreePath* granite_widgets_source_list_patch_data_model_get_item_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                                         GraniteWidgetsSourceListPatchItem* item);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN gboolean granite_widgets_source_list_patch_start_editing_item (GraniteWidgetsSourceListPatch* self,
                                                               GraniteWidgetsSourceListPatchItem* item);
static gboolean granite_widgets_source_list_patch_tree_start_editing_item (GraniteWidgetsSourceListPatchTree* self,
                                                                    GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN void granite_widgets_source_list_patch_stop_editing (GraniteWidgetsSourceListPatch* self);
VALA_EXTERN gboolean granite_widgets_source_list_patch_get_editing (GraniteWidgetsSourceListPatch* self);
static void granite_widgets_source_list_patch_tree_stop_editing (GraniteWidgetsSourceListPatchTree* self);
VALA_EXTERN void granite_widgets_source_list_patch_enable_drag_source (GraniteWidgetsSourceListPatch* self,
                                                           GtkTargetEntry* src_entries,
                                                           gint src_entries_length1);
static void granite_widgets_source_list_patch_tree_configure_drag_source (GraniteWidgetsSourceListPatchTree* self,
                                                                   GtkTargetEntry* src_entries,
                                                                   gint src_entries_length1);
VALA_EXTERN void granite_widgets_source_list_patch_disable_drag_source (GraniteWidgetsSourceListPatch* self);
VALA_EXTERN void granite_widgets_source_list_patch_enable_drag_dest (GraniteWidgetsSourceListPatch* self,
                                                         GtkTargetEntry* dest_entries,
                                                         gint dest_entries_length1,
                                                         GdkDragAction actions);
static void granite_widgets_source_list_patch_tree_configure_drag_dest (GraniteWidgetsSourceListPatchTree* self,
                                                                 GtkTargetEntry* dest_entries,
                                                                 gint dest_entries_length1,
                                                                 GdkDragAction actions);
VALA_EXTERN void granite_widgets_source_list_patch_disable_drag_dest (GraniteWidgetsSourceListPatch* self);
VALA_EXTERN gboolean granite_widgets_source_list_patch_scroll_to_item (GraniteWidgetsSourceListPatch* self,
                                                           GraniteWidgetsSourceListPatchItem* item,
                                                           gboolean expand_parents,
                                                           gboolean use_align,
                                                           gfloat row_align);
VALA_EXTERN GraniteWidgetsSourceListPatchExpandableItem* granite_widgets_source_list_patch_item_get_parent (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_expand_with_parents (GraniteWidgetsSourceListPatchExpandableItem* self);
static gboolean granite_widgets_source_list_patch_tree_scroll_to_item (GraniteWidgetsSourceListPatchTree* self,
                                                                GraniteWidgetsSourceListPatchItem* item,
                                                                gboolean use_align,
                                                                gfloat row_align);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_previous_item (GraniteWidgetsSourceListPatch* self,
                                                                                        GraniteWidgetsSourceListPatchItem* reference);
static GtkTreeIter* granite_widgets_source_list_patch_data_model_get_item_iter (GraniteWidgetsSourceListPatchDataModel* self,
                                                                         GraniteWidgetsSourceListPatchItem* item);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_data_model_get_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                                                          GtkTreeIter* iter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_next_item (GraniteWidgetsSourceListPatch* self,
                                                                                    GraniteWidgetsSourceListPatchItem* reference);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_first_child (GraniteWidgetsSourceListPatch* self,
                                                                                      GraniteWidgetsSourceListPatchExpandableItem* parent);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_nth_child (GraniteWidgetsSourceListPatch* self,
                                                                                    GraniteWidgetsSourceListPatchExpandableItem* parent,
                                                                                    gint index);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_last_child (GraniteWidgetsSourceListPatch* self,
                                                                                     GraniteWidgetsSourceListPatchExpandableItem* parent);
VALA_EXTERN guint granite_widgets_source_list_patch_get_n_visible_children (GraniteWidgetsSourceListPatch* self,
                                                                GraniteWidgetsSourceListPatchExpandableItem* parent);
VALA_EXTERN GraniteWidgetsSourceListPatchExpandableItem* granite_widgets_source_list_patch_get_root (GraniteWidgetsSourceListPatch* self);
static GraniteWidgetsSourceListPatchExpandableItem* granite_widgets_source_list_patch_data_model_get_root (GraniteWidgetsSourceListPatchDataModel* self);
static void granite_widgets_source_list_patch_data_model_set_root (GraniteWidgetsSourceListPatchDataModel* self,
                                                            GraniteWidgetsSourceListPatchExpandableItem* value);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_get_selected (GraniteWidgetsSourceListPatch* self);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_tree_get_selected_item (GraniteWidgetsSourceListPatchTree* self);
VALA_EXTERN void granite_widgets_source_list_patch_set_selected (GraniteWidgetsSourceListPatch* self,
                                                     GraniteWidgetsSourceListPatchItem* value);
static void granite_widgets_source_list_patch_tree_set_selected_item (GraniteWidgetsSourceListPatchTree* self,
                                                               GraniteWidgetsSourceListPatchItem* value);
VALA_EXTERN PangoEllipsizeMode granite_widgets_source_list_patch_get_ellipsize_mode (GraniteWidgetsSourceListPatch* self);
static PangoEllipsizeMode granite_widgets_source_list_patch_tree_get_ellipsize_mode (GraniteWidgetsSourceListPatchTree* self);
VALA_EXTERN void granite_widgets_source_list_patch_set_ellipsize_mode (GraniteWidgetsSourceListPatch* self,
                                                           PangoEllipsizeMode value);
static void granite_widgets_source_list_patch_tree_set_ellipsize_mode (GraniteWidgetsSourceListPatchTree* self,
                                                                PangoEllipsizeMode value);
static gboolean granite_widgets_source_list_patch_tree_get_editing (GraniteWidgetsSourceListPatchTree* self);
static void granite_widgets_source_list_patch_real_item_selected (GraniteWidgetsSourceListPatch* self,
                                                           GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN GtkMenu* granite_widgets_source_list_patch_item_get_context_menu (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_item_new (const gchar* name);
VALA_EXTERN GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_item_construct (GType object_type,
                                                                                     const gchar* name);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_name (GraniteWidgetsSourceListPatchItem* self,
                                                      const gchar* value);
static GtkMenu* granite_widgets_source_list_patch_item_real_get_context_menu (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_parent (GraniteWidgetsSourceListPatchItem* self,
                                                        GraniteWidgetsSourceListPatchExpandableItem* value);
VALA_EXTERN const gchar* granite_widgets_source_list_patch_item_get_name (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN const gchar* granite_widgets_source_list_patch_item_get_markup (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_markup (GraniteWidgetsSourceListPatchItem* self,
                                                        const gchar* value);
VALA_EXTERN const gchar* granite_widgets_source_list_patch_item_get_badge (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_badge (GraniteWidgetsSourceListPatchItem* self,
                                                       const gchar* value);
VALA_EXTERN gboolean granite_widgets_source_list_patch_item_get_editable (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_editable (GraniteWidgetsSourceListPatchItem* self,
                                                          gboolean value);
VALA_EXTERN gboolean granite_widgets_source_list_patch_item_get_visible (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_visible (GraniteWidgetsSourceListPatchItem* self,
                                                         gboolean value);
VALA_EXTERN gboolean granite_widgets_source_list_patch_item_get_selectable (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_selectable (GraniteWidgetsSourceListPatchItem* self,
                                                            gboolean value);
VALA_EXTERN GIcon* granite_widgets_source_list_patch_item_get_icon (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_icon (GraniteWidgetsSourceListPatchItem* self,
                                                      GIcon* value);
VALA_EXTERN GIcon* granite_widgets_source_list_patch_item_get_activatable (GraniteWidgetsSourceListPatchItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_item_set_activatable (GraniteWidgetsSourceListPatchItem* self,
                                                             GIcon* value);
static void granite_widgets_source_list_patch_item_real_edited (GraniteWidgetsSourceListPatchItem* self,
                                                         const gchar* new_name);
static void granite_widgets_source_list_patch_item_real_action_activated (GraniteWidgetsSourceListPatchItem* self);
static void granite_widgets_source_list_patch_item_real_activated (GraniteWidgetsSourceListPatchItem* self);
static void granite_widgets_source_list_patch_item_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_item_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_item_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_item_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
VALA_EXTERN GraniteWidgetsSourceListPatchExpandableItem* granite_widgets_source_list_patch_expandable_item_new (const gchar* name);
VALA_EXTERN GraniteWidgetsSourceListPatchExpandableItem* granite_widgets_source_list_patch_expandable_item_construct (GType object_type,
                                                                                                          const gchar* name);
VALA_EXTERN gboolean granite_widgets_source_list_patch_expandable_item_contains (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                     GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_add (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                            GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_remove (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                               GraniteWidgetsSourceListPatchItem* item);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_clear (GraniteWidgetsSourceListPatchExpandableItem* self);
VALA_EXTERN GeeCollection* granite_widgets_source_list_patch_expandable_item_get_children (GraniteWidgetsSourceListPatchExpandableItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_expand_all (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                   gboolean inclusive,
                                                                   gboolean recursive);
static void granite_widgets_source_list_patch_expandable_item_set_expansion (GraniteWidgetsSourceListPatchExpandableItem* item,
                                                                      gboolean inclusive,
                                                                      gboolean recursive,
                                                                      gboolean expanded);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_collapse_all (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                     gboolean inclusive,
                                                                     gboolean recursive);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_set_expanded (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                     gboolean value);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_collapse_with_parents (GraniteWidgetsSourceListPatchExpandableItem* self);
VALA_EXTERN gboolean granite_widgets_source_list_patch_expandable_item_get_collapsible (GraniteWidgetsSourceListPatchExpandableItem* self);
VALA_EXTERN void granite_widgets_source_list_patch_expandable_item_set_collapsible (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                        gboolean value);
VALA_EXTERN gboolean granite_widgets_source_list_patch_expandable_item_get_expanded (GraniteWidgetsSourceListPatchExpandableItem* self);
VALA_EXTERN guint granite_widgets_source_list_patch_expandable_item_get_n_children (GraniteWidgetsSourceListPatchExpandableItem* self);
static void granite_widgets_source_list_patch_expandable_item_real_toggled (GraniteWidgetsSourceListPatchExpandableItem* self);
static GObject * granite_widgets_source_list_patch_expandable_item_constructor (GType type,
                                                                         guint n_construct_properties,
                                                                         GObjectConstructParam * construct_properties);
static void granite_widgets_source_list_patch_expandable_item_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_expandable_item_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_expandable_item_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_expandable_item_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec);
static gpointer granite_widgets_source_list_patch_data_model_node_wrapper_ref (gpointer instance);
static void granite_widgets_source_list_patch_data_model_node_wrapper_unref (gpointer instance);
static GParamSpec* granite_widgets_source_list_patch_data_model_param_spec_node_wrapper (const gchar* name,
                                                                                  const gchar* nick,
                                                                                  const gchar* blurb,
                                                                                  GType object_type,
                                                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void granite_widgets_source_list_patch_data_model_value_set_node_wrapper (GValue* value,
                                                                          gpointer v_object) G_GNUC_UNUSED ;
static void granite_widgets_source_list_patch_data_model_value_take_node_wrapper (GValue* value,
                                                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer granite_widgets_source_list_patch_data_model_value_get_node_wrapper (const GValue* value) G_GNUC_UNUSED ;
static GType granite_widgets_source_list_patch_data_model_node_wrapper_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchDataModelNodeWrapper, granite_widgets_source_list_patch_data_model_node_wrapper_unref)
static gpointer granite_widgets_source_list_patch_data_model_item_monitor_ref (gpointer instance);
static void granite_widgets_source_list_patch_data_model_item_monitor_unref (gpointer instance);
static GParamSpec* granite_widgets_source_list_patch_data_model_param_spec_item_monitor (const gchar* name,
                                                                                  const gchar* nick,
                                                                                  const gchar* blurb,
                                                                                  GType object_type,
                                                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void granite_widgets_source_list_patch_data_model_value_set_item_monitor (GValue* value,
                                                                          gpointer v_object) G_GNUC_UNUSED ;
static void granite_widgets_source_list_patch_data_model_value_take_item_monitor (GValue* value,
                                                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer granite_widgets_source_list_patch_data_model_value_get_item_monitor (const GValue* value) G_GNUC_UNUSED ;
static GType granite_widgets_source_list_patch_data_model_item_monitor_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchDataModelItemMonitor, granite_widgets_source_list_patch_data_model_item_monitor_unref)
static GType granite_widgets_source_list_patch_data_model_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType granite_widgets_source_list_patch_data_model_column_type (GraniteWidgetsSourceListPatchDataModelColumn self);
static void granite_widgets_source_list_patch_data_model_update_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                               GraniteWidgetsSourceListPatchItem* item);
static GtkTreePath* granite_widgets_source_list_patch_data_model_node_wrapper_get_path (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self);
static GtkTreeIter* granite_widgets_source_list_patch_data_model_node_wrapper_get_iter (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self);
static void granite_widgets_source_list_patch_data_model_add_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                            GraniteWidgetsSourceListPatchItem* item);
static GtkTreeIter* granite_widgets_source_list_patch_data_model_get_item_child_iter (GraniteWidgetsSourceListPatchDataModel* self,
                                                                               GraniteWidgetsSourceListPatchItem* item);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static GraniteWidgetsSourceListPatchDataModelNodeWrapper* granite_widgets_source_list_patch_data_model_node_wrapper_new (GtkTreeModel* model,
                                                                                                                  GtkTreeIter* iter);
static GraniteWidgetsSourceListPatchDataModelNodeWrapper* granite_widgets_source_list_patch_data_model_node_wrapper_construct (GType object_type,
                                                                                                                        GtkTreeModel* model,
                                                                                                                        GtkTreeIter* iter);
static void granite_widgets_source_list_patch_data_model_add_property_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                        GraniteWidgetsSourceListPatchItem* item);
static void granite_widgets_source_list_patch_data_model_push_parent_update (GraniteWidgetsSourceListPatchDataModel* self,
                                                                      GraniteWidgetsSourceListPatchExpandableItem* parent);
static void granite_widgets_source_list_patch_data_model_add_children_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                        GraniteWidgetsSourceListPatchExpandableItem* item);
static void granite_widgets_source_list_patch_data_model_remove_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                               GraniteWidgetsSourceListPatchItem* item);
static void granite_widgets_source_list_patch_data_model_remove_property_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                           GraniteWidgetsSourceListPatchItem* item);
static void granite_widgets_source_list_patch_data_model_remove_children_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                           GraniteWidgetsSourceListPatchExpandableItem* item);
static GraniteWidgetsSourceListPatchDataModelItemMonitor* granite_widgets_source_list_patch_data_model_item_monitor_new (GraniteWidgetsSourceListPatchItem* item);
static GraniteWidgetsSourceListPatchDataModelItemMonitor* granite_widgets_source_list_patch_data_model_item_monitor_construct (GType object_type,
                                                                                                                        GraniteWidgetsSourceListPatchItem* item);
static void granite_widgets_source_list_patch_data_model_on_item_prop_changed (GraniteWidgetsSourceListPatchDataModel* self,
                                                                        GraniteWidgetsSourceListPatchItem* item,
                                                                        const gchar* prop_name);
static void _granite_widgets_source_list_patch_data_model_on_item_prop_changed_granite_widgets_source_list_patch_data_model_item_monitor_changed (GraniteWidgetsSourceListPatchDataModelItemMonitor* _sender,
                                                                                                                                           GraniteWidgetsSourceListPatchItem* _self_,
                                                                                                                                           const gchar* prop_name,
                                                                                                                                           gpointer self);
static void granite_widgets_source_list_patch_data_model_on_item_child_added (GraniteWidgetsSourceListPatchDataModel* self,
                                                                       GraniteWidgetsSourceListPatchItem* item);
static void _granite_widgets_source_list_patch_data_model_on_item_child_added_granite_widgets_source_list_patch_expandable_item_child_added (GraniteWidgetsSourceListPatchExpandableItem* _sender,
                                                                                                                                      GraniteWidgetsSourceListPatchItem* item,
                                                                                                                                      gpointer self);
static void granite_widgets_source_list_patch_data_model_on_item_child_removed (GraniteWidgetsSourceListPatchDataModel* self,
                                                                         GraniteWidgetsSourceListPatchItem* item);
static void _granite_widgets_source_list_patch_data_model_on_item_child_removed_granite_widgets_source_list_patch_expandable_item_child_removed (GraniteWidgetsSourceListPatchExpandableItem* _sender,
                                                                                                                                          GraniteWidgetsSourceListPatchItem* item,
                                                                                                                                          gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda54_ (Block1Data* _data1_);
static gboolean ____lambda54__gsource_func (gpointer self);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_data_model_get_item_from_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                                                                    GtkTreePath* path);
static GtkTreePath* granite_widgets_source_list_patch_data_model_get_item_child_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                                               GraniteWidgetsSourceListPatchItem* item);
static gboolean granite_widgets_source_list_patch_data_model_is_category (GraniteWidgetsSourceListPatchDataModel* self,
                                                                   GraniteWidgetsSourceListPatchItem* item,
                                                                   GtkTreeIter* iter,
                                                                   GtkTreePath* path);
static gboolean granite_widgets_source_list_patch_data_model_is_iter_at_root_level (GraniteWidgetsSourceListPatchDataModel* self,
                                                                             GtkTreeIter* iter);
static gboolean granite_widgets_source_list_patch_data_model_is_path_at_root_level (GraniteWidgetsSourceListPatchDataModel* self,
                                                                             GtkTreePath* path);
static void granite_widgets_source_list_patch_data_model_resort (GraniteWidgetsSourceListPatchDataModel* self);
static gint granite_widgets_source_list_patch_data_model_child_model_sort_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                                         GtkTreeModel* model,
                                                                         GtkTreeIter* a,
                                                                         GtkTreeIter* b);
static gboolean granite_widgets_source_list_patch_data_model_filter_visible_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                                           GtkTreeModel* child_model,
                                                                           GtkTreeIter* iter);
static gboolean granite_widgets_source_list_patch_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                                               GtkTreePath* dest,
                                                                               GtkSelectionData* selection_data);
static gboolean granite_widgets_source_list_patch_data_model_child_tree_drag_data_received (GraniteWidgetsSourceListPatchDataModel* self,
                                                                                     GtkTreePath* dest,
                                                                                     GtkTreePath* src_path);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void granite_widgets_source_list_patch_data_model_recursive_node_copy (GraniteWidgetsSourceListPatchDataModel* self,
                                                                       GtkTreeIter* src_iter,
                                                                       GtkTreeIter* dest_iter);
static void granite_widgets_source_list_patch_data_model_move_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                             GtkTreeIter* src_iter,
                                                             GtkTreeIter* dest_iter);
static gboolean granite_widgets_source_list_patch_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                                              GtkTreePath* dest,
                                                                              GtkSelectionData* selection_data);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static gint* _vala_array_dup2 (gint* self,
                        gssize length);
static gboolean granite_widgets_source_list_patch_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                                          GtkTreePath* path,
                                                                          GtkSelectionData* selection_data);
static gboolean granite_widgets_source_list_patch_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                                          GtkTreePath* path);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static gboolean granite_widgets_source_list_patch_data_model_node_wrapper_get_valid (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self);
static void granite_widgets_source_list_patch_data_model_node_wrapper_finalize (GraniteWidgetsSourceListPatchDataModelNodeWrapper * obj);
static GType granite_widgets_source_list_patch_data_model_node_wrapper_get_type_once (void);
static void granite_widgets_source_list_patch_data_model_item_monitor_on_notify (GraniteWidgetsSourceListPatchDataModelItemMonitor* self,
                                                                          GParamSpec* prop);
static void _granite_widgets_source_list_patch_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                                           GParamSpec* pspec,
                                                                                           gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void granite_widgets_source_list_patch_data_model_item_monitor_finalize (GraniteWidgetsSourceListPatchDataModelItemMonitor * obj);
static GType granite_widgets_source_list_patch_data_model_item_monitor_get_type_once (void);
static GObject * granite_widgets_source_list_patch_data_model_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static gint _granite_widgets_source_list_patch_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                                     GtkTreeIter* a,
                                                                                                     GtkTreeIter* b,
                                                                                                     gpointer self);
static gboolean _granite_widgets_source_list_patch_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                                               GtkTreeIter* iter,
                                                                                                               gpointer self);
static void granite_widgets_source_list_patch_data_model_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_data_model_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_data_model_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_data_model_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GType granite_widgets_source_list_patch_cell_renderer_icon_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchCellRendererIcon, g_object_unref)
static GraniteWidgetsSourceListPatchCellRendererIcon* granite_widgets_source_list_patch_cell_renderer_icon_new (void);
static GraniteWidgetsSourceListPatchCellRendererIcon* granite_widgets_source_list_patch_cell_renderer_icon_construct (GType object_type);
static gboolean granite_widgets_source_list_patch_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                                             GdkEvent* event,
                                                                             GtkWidget* widget,
                                                                             const gchar* path,
                                                                             GdkRectangle* background_area,
                                                                             GdkRectangle* cell_area,
                                                                             GtkCellRendererState flags);
static GObject * granite_widgets_source_list_patch_cell_renderer_icon_constructor (GType type,
                                                                            guint n_construct_properties,
                                                                            GObjectConstructParam * construct_properties);
static GType granite_widgets_source_list_patch_cell_renderer_icon_get_type_once (void);
static GType granite_widgets_source_list_patch_cell_renderer_spacer_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GraniteWidgetsSourceListPatchCellRendererSpacer, g_object_unref)
static GtkSizeRequestMode granite_widgets_source_list_patch_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base);
static void granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                                      GtkWidget* widget,
                                                                                      gint* min_size,
                                                                                      gint* natural_size);
static void granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                                 GtkWidget* widget,
                                                                                                 gint width,
                                                                                                 gint* min_height,
                                                                                                 gint* natural_height);
static void granite_widgets_source_list_patch_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                                         cairo_t* context,
                                                                         GtkWidget* widget,
                                                                         GdkRectangle* bg_area,
                                                                         GdkRectangle* cell_area,
                                                                         GtkCellRendererState flags);
static void granite_widgets_source_list_patch_cell_renderer_spacer_real_get_size (GtkCellRenderer* base,
                                                                           GtkWidget* widget,
                                                                           GdkRectangle* cell_area,
                                                                           gint* x_offset,
                                                                           gint* y_offset,
                                                                           gint* width,
                                                                           gint* height) G_GNUC_DEPRECATED ;
static GraniteWidgetsSourceListPatchCellRendererSpacer* granite_widgets_source_list_patch_cell_renderer_spacer_new (void);
static GraniteWidgetsSourceListPatchCellRendererSpacer* granite_widgets_source_list_patch_cell_renderer_spacer_construct (GType object_type);
static gint granite_widgets_source_list_patch_cell_renderer_spacer_get_level (GraniteWidgetsSourceListPatchCellRendererSpacer* self);
static void granite_widgets_source_list_patch_cell_renderer_spacer_set_level (GraniteWidgetsSourceListPatchCellRendererSpacer* self,
                                                                       gint value);
static void granite_widgets_source_list_patch_cell_renderer_spacer_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_cell_renderer_spacer_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_cell_renderer_spacer_get_property (GObject * object,
                                                                                guint property_id,
                                                                                GValue * value,
                                                                                GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_cell_renderer_spacer_set_property (GObject * object,
                                                                                guint property_id,
                                                                                const GValue * value,
                                                                                GParamSpec * pspec);
static void granite_widgets_source_list_patch_tree_disable_item_property_monitor (GraniteWidgetsSourceListPatchTree* self);
static GType granite_widgets_source_list_patch_tree_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GraniteWidgetsSourceListPatchTree* granite_widgets_source_list_patch_tree_new (GraniteWidgetsSourceListPatchDataModel* data_model);
static GraniteWidgetsSourceListPatchTree* granite_widgets_source_list_patch_tree_construct (GType object_type,
                                                                                     GraniteWidgetsSourceListPatchDataModel* data_model);
static gboolean granite_widgets_source_list_patch_tree_real_drag_motion (GtkWidget* base,
                                                                  GdkDragContext* context,
                                                                  gint x,
                                                                  gint y,
                                                                  guint time);
static GraniteWidgetsSourceListPatchDataModel* granite_widgets_source_list_patch_tree_get_data_model (GraniteWidgetsSourceListPatchTree* self);
static void granite_widgets_source_list_patch_tree_real_drag_data_received (GtkWidget* base,
                                                                     GdkDragContext* context,
                                                                     gint x,
                                                                     gint y,
                                                                     GtkSelectionData* selection_data,
                                                                     guint info,
                                                                     guint time);
static GtkTargetEntry* granite_widgets_source_list_patch_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                                                gint orig_length1,
                                                                                gint* result_length1);
static void _vala_array_add1 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void _vala_array_add2 (GtkTargetEntry* * array,
                       gint* length,
                       gint* size,
                       const GtkTargetEntry* value);
static void granite_widgets_source_list_patch_tree_enable_item_property_monitor (GraniteWidgetsSourceListPatchTree* self);
static void granite_widgets_source_list_patch_tree_on_model_item_updated (GraniteWidgetsSourceListPatchTree* self,
                                                                   GraniteWidgetsSourceListPatchItem* item);
static void _granite_widgets_source_list_patch_tree_on_model_item_updated_granite_widgets_source_list_patch_data_model_item_updated (GraniteWidgetsSourceListPatchDataModel* _sender,
                                                                                                                              GraniteWidgetsSourceListPatchItem* item,
                                                                                                                              gpointer self);
static void granite_widgets_source_list_patch_tree_update_expansion (GraniteWidgetsSourceListPatchTree* self,
                                                              GraniteWidgetsSourceListPatchExpandableItem* expandable_item);
static void granite_widgets_source_list_patch_tree_add_spacer_cell_for_level (GraniteWidgetsSourceListPatchTree* self,
                                                                       gint level,
                                                                       gboolean check_previous);
static void granite_widgets_source_list_patch_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                                   GtkCellRenderer* renderer,
                                                                   GtkTreeModel* model,
                                                                   GtkTreeIter* iter);
static void _granite_widgets_source_list_patch_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                              GtkCellRenderer* cell,
                                                                                              GtkTreeModel* tree_model,
                                                                                              GtkTreeIter* iter,
                                                                                              gpointer self);
static gboolean granite_widgets_source_list_patch_tree_select_func (GraniteWidgetsSourceListPatchTree* self,
                                                             GtkTreeSelection* selection,
                                                             GtkTreeModel* model,
                                                             GtkTreePath* path,
                                                             gboolean path_currently_selected);
static GtkTreePath* granite_widgets_source_list_patch_tree_get_selected_path (GraniteWidgetsSourceListPatchTree* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void granite_widgets_source_list_patch_tree_set_selected (GraniteWidgetsSourceListPatchTree* self,
                                                          GraniteWidgetsSourceListPatchItem* item,
                                                          gboolean scroll_to_item);
static void granite_widgets_source_list_patch_tree_real_cursor_changed (GtkTreeView* base);
static void granite_widgets_source_list_patch_tree_on_editing_started (GraniteWidgetsSourceListPatchTree* self,
                                                                GtkCellEditable* editable,
                                                                const gchar* path);
static void granite_widgets_source_list_patch_tree_on_editing_done (GraniteWidgetsSourceListPatchTree* self);
static void _granite_widgets_source_list_patch_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                             gpointer self);
static void granite_widgets_source_list_patch_tree_on_editing_canceled (GraniteWidgetsSourceListPatchTree* self);
static void granite_widgets_source_list_patch_tree_on_activatable_activated (GraniteWidgetsSourceListPatchTree* self,
                                                                      const gchar* item_path_str);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_tree_get_item_from_path_string (GraniteWidgetsSourceListPatchTree* self,
                                                                                                     const gchar* item_path_str);
static gboolean granite_widgets_source_list_patch_tree_toggle_expansion (GraniteWidgetsSourceListPatchTree* self,
                                                                  GraniteWidgetsSourceListPatchExpandableItem* item);
static void granite_widgets_source_list_patch_tree_real_row_expanded (GtkTreeView* base,
                                                               GtkTreeIter* iter,
                                                               GtkTreePath* path);
static void granite_widgets_source_list_patch_tree_real_row_collapsed (GtkTreeView* base,
                                                                GtkTreeIter* iter,
                                                                GtkTreePath* path);
static void granite_widgets_source_list_patch_tree_real_row_activated (GtkTreeView* base,
                                                                GtkTreePath* path,
                                                                GtkTreeViewColumn* column);
static gboolean granite_widgets_source_list_patch_tree_real_key_release_event (GtkWidget* base,
                                                                        GdkEventKey* event);
static gboolean granite_widgets_source_list_patch_tree_real_button_release_event (GtkWidget* base,
                                                                           GdkEventButton* event);
static gboolean granite_widgets_source_list_patch_tree_real_button_press_event (GtkWidget* base,
                                                                         GdkEventButton* event);
static gboolean granite_widgets_source_list_patch_tree_popup_context_menu (GraniteWidgetsSourceListPatchTree* self,
                                                                    GraniteWidgetsSourceListPatchItem* item,
                                                                    GdkEventButton* event);
static gboolean granite_widgets_source_list_patch_tree_over_cell (GraniteWidgetsSourceListPatchTree* self,
                                                           GtkTreeViewColumn* col,
                                                           GtkTreePath* path,
                                                           GtkCellRenderer* cell,
                                                           gint x);
static gboolean granite_widgets_source_list_patch_tree_over_primary_expander (GraniteWidgetsSourceListPatchTree* self,
                                                                       GtkTreeViewColumn* col,
                                                                       GtkTreePath* path,
                                                                       gint x);
static void granite_widgets_source_list_patch_tree_expander_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                                     GtkCellLayout* layout,
                                                                     GtkCellRenderer* renderer,
                                                                     GtkTreeModel* model,
                                                                     GtkTreeIter* iter);
static gint granite_widgets_source_list_patch_tree_get_cell_width (GraniteWidgetsSourceListPatchTree* self,
                                                            GtkCellRenderer* cell_renderer);
static gboolean granite_widgets_source_list_patch_tree_real_popup_menu (GtkWidget* base);
static GraniteWidgetsSourceListPatchItem* granite_widgets_source_list_patch_tree_get_item_from_model (GtkTreeModel* model,
                                                                                               GtkTreeIter* iter);
static void granite_widgets_source_list_patch_tree_name_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                                 GtkCellLayout* layout,
                                                                 GtkCellRenderer* renderer,
                                                                 GtkTreeModel* model,
                                                                 GtkTreeIter* iter);
static void granite_widgets_source_list_patch_tree_badge_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                                  GtkCellLayout* layout,
                                                                  GtkCellRenderer* renderer,
                                                                  GtkTreeModel* model,
                                                                  GtkTreeIter* iter);
static void granite_widgets_source_list_patch_tree_icon_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                                 GtkCellLayout* layout,
                                                                 GtkCellRenderer* renderer,
                                                                 GtkTreeModel* model,
                                                                 GtkTreeIter* iter);
static void granite_widgets_source_list_patch_tree_set_data_model (GraniteWidgetsSourceListPatchTree* self,
                                                            GraniteWidgetsSourceListPatchDataModel* value);
static GObject * granite_widgets_source_list_patch_tree_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static void _granite_widgets_source_list_patch_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                                GtkCellRenderer* cell,
                                                                                                GtkTreeModel* tree_model,
                                                                                                GtkTreeIter* iter,
                                                                                                gpointer self);
static void _granite_widgets_source_list_patch_tree_on_activatable_activated_granite_widgets_source_list_patch_cell_renderer_icon_activated (GraniteWidgetsSourceListPatchCellRendererIcon* _sender,
                                                                                                                                      const gchar* path,
                                                                                                                                      gpointer self);
static void _granite_widgets_source_list_patch_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                            GtkCellRenderer* cell,
                                                                                            GtkTreeModel* tree_model,
                                                                                            GtkTreeIter* iter,
                                                                                            gpointer self);
static void _granite_widgets_source_list_patch_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                             GtkCellRenderer* cell,
                                                                                             GtkTreeModel* tree_model,
                                                                                             GtkTreeIter* iter,
                                                                                             gpointer self);
static void _granite_widgets_source_list_patch_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                                   GtkCellEditable* editable,
                                                                                                   const gchar* path,
                                                                                                   gpointer self);
static void _granite_widgets_source_list_patch_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                                     gpointer self);
static void _granite_widgets_source_list_patch_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                            GtkCellRenderer* cell,
                                                                                            GtkTreeModel* tree_model,
                                                                                            GtkTreeIter* iter,
                                                                                            gpointer self);
static gboolean _granite_widgets_source_list_patch_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                                      GtkTreeModel* model,
                                                                                      GtkTreePath* path,
                                                                                      gboolean path_currently_selected,
                                                                                      gpointer self);
static void granite_widgets_source_list_patch_tree_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_tree_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_tree_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_tree_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * granite_widgets_source_list_patch_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _granite_widgets_source_list_patch___lambda55_ (GraniteWidgetsSourceListPatch* self,
                                                     GraniteWidgetsSourceListPatchItem* item);
static void __granite_widgets_source_list_patch___lambda55__granite_widgets_source_list_patch_tree_item_selected (GraniteWidgetsSourceListPatchTree* _sender,
                                                                                                           GraniteWidgetsSourceListPatchItem* item,
                                                                                                           gpointer self);
static void granite_widgets_source_list_patch_finalize (GObject * obj);
static GType granite_widgets_source_list_patch_get_type_once (void);
static void _vala_granite_widgets_source_list_patch_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_granite_widgets_source_list_patch_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Whether this item will allow users to re-arrange its children via DnD.
     *
     * This feature can co-exist with a sort algorithm (implemented
     * by {@link Granite.Widgets.SourceListPatchSortable.compare}), but
     * the actual order of the items in the list will always
     * honor that method. The sort function has to be compatible with
     * the kind of DnD reordering the item wants to allow, since the user can
     * only reorder those items for which //compare// returns 0.
     *
     * @return Whether the item's children can be re-arranged by users.
     * @since 0.3
     */
gboolean
granite_widgets_source_list_patch_sortable_allow_dnd_sorting (GraniteWidgetsSourceListPatchSortable* self)
{
	GraniteWidgetsSourceListPatchSortableIface* _iface_;
#line 43 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_GET_INTERFACE (self);
#line 43 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->allow_dnd_sorting) {
#line 43 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _iface_->allow_dnd_sorting (self);
#line 1209 "SourceList.c"
	}
#line 43 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return FALSE;
#line 1213 "SourceList.c"
}

/**
     * Should return a negative integer, zero, or a positive integer if ''a''
     * sorts //before// ''b'', ''a'' sorts //with// ''b'', or ''a'' sorts
     * //after// ''b'' respectively. If two items compare as equal, their
     * order in the sorted source list is undefined.
     *
     * In order to ensure that the source list behaves as expected, this
     * method must define a partial order on the source list tree; i.e. it
     * must be reflexive, antisymmetric and transitive. Not complying with
     * those requirements could make the program fall into an infinite loop
     * and freeze the user interface.
     *
     * Should return //0// to allow any pair of items to be sortable via DnD.
     *
     * @param a First item.
     * @param b Second item.
     * @return A //negative// integer if //a// sorts before //b//,
     *         //zero// if //a// equals //b//, or a //positive//
     *         integer if //a// sorts after //b//.
     * @since 0.3
     */
gint
granite_widgets_source_list_patch_sortable_compare (GraniteWidgetsSourceListPatchSortable* self,
                                                    GraniteWidgetsSourceListPatchItem* a,
                                                    GraniteWidgetsSourceListPatchItem* b)
{
	GraniteWidgetsSourceListPatchSortableIface* _iface_;
#line 66 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_GET_INTERFACE (self);
#line 66 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->compare) {
#line 66 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _iface_->compare (self, a, b);
#line 1251 "SourceList.c"
	}
#line 66 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return -1;
#line 1255 "SourceList.c"
}

static void
granite_widgets_source_list_patch_sortable_default_init (GraniteWidgetsSourceListPatchSortableIface * iface,
                                                         gpointer iface_data)
{
	/**
	     * Emitted after a user has re-ordered an item via DnD.
	     *
	     * @param moved The item that was moved to a different position by the user.
	     * @since 0.3
	     */
#line 21 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_USER_MOVED_ITEM_SIGNAL] = g_signal_new ("user-moved-item", GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH_SORTABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 1270 "SourceList.c"
}

static GType
granite_widgets_source_list_patch_sortable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchSortableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_sortable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_patch_sortable_type_id;
	granite_widgets_source_list_patch_sortable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListPatchSortable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_patch_sortable_type_id, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM);
	return granite_widgets_source_list_patch_sortable_type_id;
}

GType
granite_widgets_source_list_patch_sortable_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_sortable_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_sortable_type_id__once)) {
		GType granite_widgets_source_list_patch_sortable_type_id;
		granite_widgets_source_list_patch_sortable_type_id = granite_widgets_source_list_patch_sortable_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_sortable_type_id__once, granite_widgets_source_list_patch_sortable_type_id);
	}
	return granite_widgets_source_list_patch_sortable_type_id__once;
}

/**
     * Determines whether this item can be dragged outside the source list widget.
     *
     * Even if this method returns //false//, the item could still be dragged around
     * within the source list if its parent allows DnD reordering. This only happens
     * when the parent implements {@link Granite.Widgets.SourceListPatchSortable}.
     *
     * @return //true// if the item can be dragged; //false// otherwise.
     * @since 0.3
     * @see Granite.Widgets.SourceListPatchSortable
     */
gboolean
granite_widgets_source_list_patch_drag_source_draggable (GraniteWidgetsSourceListPatchDragSource* self)
{
	GraniteWidgetsSourceListPatchDragSourceIface* _iface_;
#line 86 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_SOURCE_GET_INTERFACE (self);
#line 86 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->draggable) {
#line 86 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _iface_->draggable (self);
#line 1318 "SourceList.c"
	}
#line 86 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return FALSE;
#line 1322 "SourceList.c"
}

/**
     * This method is called when the drop site requests the data which is dragged.
     *
     * It is the responsibility of this method to fill //selection_data// with the
     * data in the format which is indicated by {@link Gtk.SelectionData.get_target}.
     *
     * @param selection_data {@link Gtk.SelectionData} containing source data.
     * @since 0.3
     * @see Gtk.SelectionData.set
     * @see Gtk.SelectionData.set_uris
     * @see Gtk.SelectionData.set_text
     */
void
granite_widgets_source_list_patch_drag_source_prepare_selection_data (GraniteWidgetsSourceListPatchDragSource* self,
                                                                      GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListPatchDragSourceIface* _iface_;
#line 100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_SOURCE_GET_INTERFACE (self);
#line 100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->prepare_selection_data) {
#line 100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_iface_->prepare_selection_data (self, selection_data);
#line 1350 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_drag_source_default_init (GraniteWidgetsSourceListPatchDragSourceIface * iface,
                                                            gpointer iface_data)
{
}

/**
 * An interface for dragging items out of the source list widget.
 *
 * @since 0.3
 */
static GType
granite_widgets_source_list_patch_drag_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchDragSourceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_drag_source_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_patch_drag_source_type_id;
	granite_widgets_source_list_patch_drag_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListPatchDragSource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_patch_drag_source_type_id, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
	return granite_widgets_source_list_patch_drag_source_type_id;
}

GType
granite_widgets_source_list_patch_drag_source_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_drag_source_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_drag_source_type_id__once)) {
		GType granite_widgets_source_list_patch_drag_source_type_id;
		granite_widgets_source_list_patch_drag_source_type_id = granite_widgets_source_list_patch_drag_source_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_drag_source_type_id__once, granite_widgets_source_list_patch_drag_source_type_id);
	}
	return granite_widgets_source_list_patch_drag_source_type_id__once;
}

/**
     * Determines whether //data// can be dropped into this item.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return //true// if the drop is possible; //false// otherwise.
     * @since 0.3
     */
gboolean
granite_widgets_source_list_patch_drag_dest_data_drop_possible (GraniteWidgetsSourceListPatchDragDest* self,
                                                                GdkDragContext* context,
                                                                GtkSelectionData* data)
{
	GraniteWidgetsSourceListPatchDragDestIface* _iface_;
#line 117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_DEST_GET_INTERFACE (self);
#line 117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->data_drop_possible) {
#line 117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _iface_->data_drop_possible (self, context, data);
#line 1409 "SourceList.c"
	}
#line 117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return FALSE;
#line 1413 "SourceList.c"
}

/**
     * If a data drop is deemed possible, then this method is called
     * when the data is actually dropped into this item. Any actions
     * consequence of the data received should be handled here.
     *
     * @param context The drag context.
     * @param data {@link Gtk.SelectionData} containing source data.
     * @return The action taken, or //0// to indicate that the dropped data was not accepted.
     * @since 0.3
     */
GdkDragAction
granite_widgets_source_list_patch_drag_dest_data_received (GraniteWidgetsSourceListPatchDragDest* self,
                                                           GdkDragContext* context,
                                                           GtkSelectionData* data)
{
	GraniteWidgetsSourceListPatchDragDestIface* _iface_;
#line 129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_iface_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_DRAG_DEST_GET_INTERFACE (self);
#line 129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_iface_->data_received) {
#line 129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _iface_->data_received (self, context, data);
#line 1440 "SourceList.c"
	}
#line 129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return 0U;
#line 1444 "SourceList.c"
}

static void
granite_widgets_source_list_patch_drag_dest_default_init (GraniteWidgetsSourceListPatchDragDestIface * iface,
                                                          gpointer iface_data)
{
}

/**
 * An interface for receiving data from other widgets via drag-and-drop.
 *
 * @since 0.3
 */
static GType
granite_widgets_source_list_patch_drag_dest_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchDragDestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_drag_dest_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_widgets_source_list_patch_drag_dest_type_id;
	granite_widgets_source_list_patch_drag_dest_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteWidgetsSourceListPatchDragDest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_widgets_source_list_patch_drag_dest_type_id, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
	return granite_widgets_source_list_patch_drag_dest_type_id;
}

GType
granite_widgets_source_list_patch_drag_dest_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_drag_dest_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_drag_dest_type_id__once)) {
		GType granite_widgets_source_list_patch_drag_dest_type_id;
		granite_widgets_source_list_patch_drag_dest_type_id = granite_widgets_source_list_patch_drag_dest_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_drag_dest_type_id__once, granite_widgets_source_list_patch_drag_dest_type_id);
	}
	return granite_widgets_source_list_patch_drag_dest_type_id__once;
}

static inline gpointer
granite_widgets_source_list_patch_get_instance_private (GraniteWidgetsSourceListPatch* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatch_private_offset);
}

/**
         * Creates a new {@link Granite.Widgets.SourceListPatch}.
         *
         * @return A new {@link Granite.Widgets.SourceListPatch}.
         * @since 0.2
         */
GraniteWidgetsSourceListPatch*
granite_widgets_source_list_patch_construct (GType object_type,
                                             GraniteWidgetsSourceListPatchExpandableItem* root)
{
	GraniteWidgetsSourceListPatch * self = NULL;
#line 2450 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (root != NULL, NULL);
#line 2450 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatch*) g_object_new (object_type, NULL);
#line 2451 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_set_root (self, root);
#line 2450 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 1505 "SourceList.c"
}

GraniteWidgetsSourceListPatch*
granite_widgets_source_list_patch_new (GraniteWidgetsSourceListPatchExpandableItem* root)
{
#line 2450 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_construct (GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, root);
#line 1513 "SourceList.c"
}

/**
         * Checks whether //item// is part of the source list.
         *
         * @param item The item to query.
         * @return //true// if the item belongs to the source list; //false// otherwise.
         * @since 0.2
         */
gboolean
granite_widgets_source_list_patch_has_item (GraniteWidgetsSourceListPatch* self,
                                            GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	gboolean result;
#line 2471 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2471 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 2472 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2472 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = granite_widgets_source_list_patch_data_model_has_item (_tmp0_, item);
#line 2472 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 1539 "SourceList.c"
}

/**
         * Sets the method used for filtering out items.
         *
         * @param visible_func The method to use for filtering items.
         * @param refilter Whether to call {@link Granite.Widgets.SourceListPatch.refilter} using the new function.
         * @see Granite.Widgets.SourceListPatch.VisibleFunc
         * @see Granite.Widgets.SourceListPatch.refilter
         * @since 0.2
         */
void
granite_widgets_source_list_patch_set_filter_func (GraniteWidgetsSourceListPatch* self,
                                                   GraniteWidgetsSourceListPatchVisibleFunc visible_func,
                                                   gpointer visible_func_target,
                                                   gboolean refilter)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 2484 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2485 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2485 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_set_filter_func (_tmp0_, visible_func, visible_func_target);
#line 2486 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (refilter) {
#line 2487 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_refilter (self);
#line 1568 "SourceList.c"
	}
}

/**
         * Applies the filter method set by {@link Granite.Widgets.SourceListPatch.set_filter_func}
         * to all the items that are part of the current tree.
         *
         * @see Granite.Widgets.SourceListPatch.VisibleFunc
         * @see Granite.Widgets.SourceListPatch.set_filter_func
         * @since 0.2
         */
void
granite_widgets_source_list_patch_refilter (GraniteWidgetsSourceListPatch* self)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 2498 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2499 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2499 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_filter_refilter ((GtkTreeModelFilter*) _tmp0_);
#line 1590 "SourceList.c"
}

/**
         * Queries the actual expansion state of //item//.
         *
         * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
         * @return Whether //item// is expanded or not.
         * @since 0.2
         */
static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1605 "SourceList.c"
}

gboolean
granite_widgets_source_list_patch_is_item_expanded (GraniteWidgetsSourceListPatch* self,
                                                    GraniteWidgetsSourceListPatchItem* item)
{
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	gboolean result;
#line 2509 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2509 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 2509 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (granite_widgets_source_list_patch_has_item (self, item), "has_item (item)", FALSE);
#line 2510 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2510 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp0_, item);
#line 2510 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp1_;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = path;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ != NULL) {
#line 1634 "SourceList.c"
		GraniteWidgetsSourceListPatchTree* _tmp4_;
		GtkTreePath* _tmp5_;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = self->priv->tree;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = path;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = gtk_tree_view_row_expanded ((GtkTreeView*) _tmp4_, _tmp5_);
#line 1643 "SourceList.c"
	} else {
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = FALSE;
#line 1647 "SourceList.c"
	}
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 2511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 1655 "SourceList.c"
}

/**
         * If //item// is editable, this activates the editor; otherwise, it does nothing.
         * If an item was already being edited, this will fail.
         *
         * @param item Item to edit.
         * @see Granite.Widgets.SourceListPatch.Item.editable
         * @see Granite.Widgets.SourceListPatch.editing
         * @see Granite.Widgets.SourceListPatch.stop_editing
         * @return true if the editing started successfully; false otherwise.
         * @since 0.2
         */
gboolean
granite_widgets_source_list_patch_start_editing_item (GraniteWidgetsSourceListPatch* self,
                                                      GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
	gboolean result;
#line 2525 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2525 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 2525 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (granite_widgets_source_list_patch_has_item (self, item), "has_item (item)", FALSE);
#line 2526 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2526 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = granite_widgets_source_list_patch_tree_start_editing_item (_tmp0_, item);
#line 2526 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 1687 "SourceList.c"
}

/**
         * Cancels any editing operation going on.
         *
         * @see Granite.Widgets.SourceListPatch.editing
         * @see Granite.Widgets.SourceListPatch.start_editing_item
         * @since 0.2
         */
void
granite_widgets_source_list_patch_stop_editing (GraniteWidgetsSourceListPatch* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 2536 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2537 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_get_editing (self);
#line 2537 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 2537 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 1710 "SourceList.c"
		GraniteWidgetsSourceListPatchTree* _tmp2_;
#line 2538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = self->priv->tree;
#line 2538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_stop_editing (_tmp2_);
#line 1716 "SourceList.c"
	}
}

/**
         * Turns Source List into a //drag source//.
         *
         * This enables items that implement {@link Granite.Widgets.SourceListPatchDragSource}
         * to be dragged outside the Source List and drop data into external widgets.
         *
         * @param src_entries an array of {@link Gtk.TargetEntry}s indicating the targets
         * that the drag will support.
         * @see Granite.Widgets.SourceListPatchDragSource
         * @see Granite.Widgets.SourceListPatch.disable_drag_source
         * @since 0.3
         */
void
granite_widgets_source_list_patch_enable_drag_source (GraniteWidgetsSourceListPatch* self,
                                                      GtkTargetEntry* src_entries,
                                                      gint src_entries_length1)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
#line 2553 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2554 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2554 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_source (_tmp0_, src_entries, (gint) src_entries_length1);
#line 1744 "SourceList.c"
}

/**
         * Undoes the effect of {@link Granite.Widgets.SourceListPatch.enable_drag_source}
         *
         * @see Granite.Widgets.SourceListPatch.enable_drag_source
         * @since 0.3
         */
void
granite_widgets_source_list_patch_disable_drag_source (GraniteWidgetsSourceListPatch* self)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
#line 2563 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_source (_tmp0_, NULL, (gint) 0);
#line 1763 "SourceList.c"
}

/**
         * Turns Source List into a //drop destination//.
         *
         * This enables items that implement {@link Granite.Widgets.SourceListPatchDragDest}
         * to receive data from external widgets via drag-and-drop.
         *
         * @param dest_entries an array of {@link Gtk.TargetEntry}s indicating the drop
         * types that Source List items will accept.
         * @param actions a bitmask of possible actions for a drop onto Source List items.
         * @see Granite.Widgets.SourceListPatchDragDest
         * @see Granite.Widgets.SourceListPatch.disable_drag_dest
         * @since 0.3
         */
void
granite_widgets_source_list_patch_enable_drag_dest (GraniteWidgetsSourceListPatch* self,
                                                    GtkTargetEntry* dest_entries,
                                                    gint dest_entries_length1,
                                                    GdkDragAction actions)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
#line 2580 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2581 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2581 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_dest (_tmp0_, dest_entries, (gint) dest_entries_length1, actions);
#line 1792 "SourceList.c"
}

/**
         * Undoes the effect of {@link Granite.Widgets.SourceListPatch.enable_drag_dest}
         *
         * @see Granite.Widgets.SourceListPatch.enable_drag_dest
         * @since 0.3
         */
void
granite_widgets_source_list_patch_disable_drag_dest (GraniteWidgetsSourceListPatch* self)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
#line 2590 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2591 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2591 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_dest (_tmp0_, NULL, (gint) 0, 0);
#line 1811 "SourceList.c"
}

/**
         * Scrolls the source list tree to make //item// visible.
         *
         * {@link Granite.Widgets.SourceListPatch.ExpandableItem.expand_with_parents} is called
         * for the item's parent if //expand_parents// is //true//, to make sure it's not
         * hidden behind a collapsed row.
         *
         * If use_align is //false//, then the row_align argument is ignored, and the tree
         * does the minimum amount of work to scroll the item onto the screen. This means that
         * the item will be scrolled to the edge closest to its current position. If the item
         * is currently visible on the screen, nothing is done.
         *
         * @param item Item to scroll to.
         * @param expand_parents Whether to recursively expand item's parent in case they are collapsed.
         * @param use_align Whether to use the //row_align// argument.
         * @param row_align The vertical alignment of //item//. 0.0 means top, 0.5 center, and 1.0 bottom.
         * @return //true// if successful; //false// otherwise.
         * @since 0.2
         */
gboolean
granite_widgets_source_list_patch_scroll_to_item (GraniteWidgetsSourceListPatch* self,
                                                  GraniteWidgetsSourceListPatchItem* item,
                                                  gboolean expand_parents,
                                                  gboolean use_align,
                                                  gfloat row_align)
{
	gboolean _tmp0_ = FALSE;
	GraniteWidgetsSourceListPatchTree* _tmp5_;
	gboolean result;
#line 2613 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2613 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 2613 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (granite_widgets_source_list_patch_has_item (self, item), "has_item (item)", FALSE);
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (expand_parents) {
#line 1851 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = _tmp1_;
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 1860 "SourceList.c"
	} else {
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 1864 "SourceList.c"
	}
#line 2616 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 1868 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp4_;
#line 2617 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 2617 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _tmp3_;
#line 2617 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_expand_with_parents (_tmp4_);
#line 1877 "SourceList.c"
	}
#line 2619 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = self->priv->tree;
#line 2619 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = granite_widgets_source_list_patch_tree_scroll_to_item (_tmp5_, item, use_align, row_align);
#line 2619 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 1885 "SourceList.c"
}

/**
         * Gets the previous item with respect to //reference//.
         *
         * @param reference Item to use as reference.
         * @return The item that appears before //reference//, or //null// if there's none.
         * @since 0.2
         */
static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_boxed_free (gtk_tree_iter_get_type (), self);
#line 1900 "SourceList.c"
}

GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_previous_item (GraniteWidgetsSourceListPatch* self,
                                                     GraniteWidgetsSourceListPatchItem* reference)
{
	GtkTreeIter* iter = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2629 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2629 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (reference != NULL, NULL);
#line 2629 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (granite_widgets_source_list_patch_has_item (self, reference), "has_item (reference)", NULL);
#line 2631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_iter (_tmp0_, reference);
#line 2631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iter = _tmp1_;
#line 2632 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = iter;
#line 2632 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 1928 "SourceList.c"
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		GraniteWidgetsSourceListPatchDataModel* _tmp4_;
		gboolean _tmp5_;
#line 2633 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = iter;
#line 2633 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		new_iter = *_tmp3_;
#line 2634 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = self->priv->data_model;
#line 2634 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
#line 2634 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 1943 "SourceList.c"
			GraniteWidgetsSourceListPatchDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = self->priv->data_model;
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = new_iter;
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = granite_widgets_source_list_patch_data_model_get_item (_tmp6_, &_tmp7_);
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = _tmp8_;
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreeIter_free0 (iter);
#line 2635 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 1959 "SourceList.c"
		}
	}
#line 2638 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 2638 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (iter);
#line 2638 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 1968 "SourceList.c"
}

/**
         * Gets the next item with respect to //reference//.
         *
         * @param reference Item to use as reference.
         * @return The item that appears after //reference//, or //null// if there's none.
         * @since 0.2
         */
GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_next_item (GraniteWidgetsSourceListPatch* self,
                                                 GraniteWidgetsSourceListPatchItem* reference)
{
	GtkTreeIter* iter = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* _tmp2_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (reference != NULL, NULL);
#line 2648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (granite_widgets_source_list_patch_has_item (self, reference), "has_item (reference)", NULL);
#line 2650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_iter (_tmp0_, reference);
#line 2650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iter = _tmp1_;
#line 2651 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = iter;
#line 2651 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 2003 "SourceList.c"
		GtkTreeIter new_iter = {0};
		GtkTreeIter* _tmp3_;
		GraniteWidgetsSourceListPatchDataModel* _tmp4_;
		gboolean _tmp5_;
#line 2652 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = iter;
#line 2652 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		new_iter = *_tmp3_;
#line 2653 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = self->priv->data_model;
#line 2653 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &new_iter);
#line 2653 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 2018 "SourceList.c"
			GraniteWidgetsSourceListPatchDataModel* _tmp6_;
			GtkTreeIter _tmp7_;
			GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = self->priv->data_model;
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = new_iter;
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = granite_widgets_source_list_patch_data_model_get_item (_tmp6_, &_tmp7_);
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = _tmp8_;
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreeIter_free0 (iter);
#line 2654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 2034 "SourceList.c"
		}
	}
#line 2657 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 2657 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (iter);
#line 2657 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2043 "SourceList.c"
}

/**
         * Gets the first visible child of an expandable item.
         *
         * @param parent Parent of the child to look up.
         * @return The first visible child of //parent//, or null if it was not found.
         * @since 0.2
         */
GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_first_child (GraniteWidgetsSourceListPatch* self,
                                                   GraniteWidgetsSourceListPatchExpandableItem* parent)
{
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 2668 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_get_nth_child (self, parent, 0);
#line 2668 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 2668 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2069 "SourceList.c"
}

/**
         * Gets the last visible child of an expandable item.
         *
         * @param parent Parent of the child to look up.
         * @return The last visible child of //parent//, or null if it was not found.
         * @since 0.2
         */
GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_last_child (GraniteWidgetsSourceListPatch* self,
                                                  GraniteWidgetsSourceListPatchExpandableItem* parent)
{
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2678 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2678 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 2679 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_get_nth_child (self, parent, ((gint) granite_widgets_source_list_patch_get_n_visible_children (self, parent)) - 1);
#line 2679 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 2679 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2095 "SourceList.c"
}

/**
         * Gets the number of visible children of an expandable item.
         *
         * @param parent Item to query.
         * @return Number of visible children of //parent//.
         * @since 0.2
         */
guint
granite_widgets_source_list_patch_get_n_visible_children (GraniteWidgetsSourceListPatch* self,
                                                          GraniteWidgetsSourceListPatchExpandableItem* parent)
{
	GtkTreeIter* parent_iter = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GraniteWidgetsSourceListPatchDataModel* _tmp2_;
	guint result;
#line 2689 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 2689 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (parent != NULL, 0U);
#line 2691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_iter (_tmp0_, (GraniteWidgetsSourceListPatchItem*) parent);
#line 2691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_iter = _tmp1_;
#line 2692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->data_model;
#line 2692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = (guint) gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp2_, parent_iter);
#line 2692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (parent_iter);
#line 2692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2132 "SourceList.c"
}

static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_nth_child (GraniteWidgetsSourceListPatch* self,
                                                 GraniteWidgetsSourceListPatchExpandableItem* parent,
                                                 gint index)
{
	GtkTreeIter* parent_iter = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter child_iter = {0};
	GraniteWidgetsSourceListPatchDataModel* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2695 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2695 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 2696 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (index < 0) {
#line 2697 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = NULL;
#line 2697 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 2159 "SourceList.c"
	}
#line 2700 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2700 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_iter (_tmp0_, (GraniteWidgetsSourceListPatchItem*) parent);
#line 2700 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_iter = _tmp1_;
#line 2703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->data_model;
#line 2703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = parent_iter;
#line 2703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_, index);
#line 2703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_iter = _tmp4_;
#line 2703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp5_) {
#line 2177 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = self->priv->data_model;
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = child_iter;
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = granite_widgets_source_list_patch_data_model_get_item (_tmp6_, &_tmp7_);
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = _tmp8_;
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreeIter_free0 (parent_iter);
#line 2704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 2193 "SourceList.c"
	}
#line 2706 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 2706 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (parent_iter);
#line 2706 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2201 "SourceList.c"
}

GraniteWidgetsSourceListPatchExpandableItem*
granite_widgets_source_list_patch_get_root (GraniteWidgetsSourceListPatch* self)
{
	GraniteWidgetsSourceListPatchExpandableItem* result;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_root (_tmp0_);
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2399 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2223 "SourceList.c"
}

void
granite_widgets_source_list_patch_set_root (GraniteWidgetsSourceListPatch* self,
                                            GraniteWidgetsSourceListPatchExpandableItem* value)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 2400 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2400 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2400 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_set_root (_tmp0_, value);
#line 2400 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY]);
#line 2239 "SourceList.c"
}

GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_get_selected (GraniteWidgetsSourceListPatch* self)
{
	GraniteWidgetsSourceListPatchItem* result;
	GraniteWidgetsSourceListPatchTree* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_get_selected_item (_tmp0_);
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2413 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2261 "SourceList.c"
}

void
granite_widgets_source_list_patch_set_selected (GraniteWidgetsSourceListPatch* self,
                                                GraniteWidgetsSourceListPatchItem* value)
{
	gboolean _tmp0_ = FALSE;
	GraniteWidgetsSourceListPatchTree* _tmp5_;
#line 2414 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (value != NULL) {
#line 2274 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = granite_widgets_source_list_patch_item_get_parent (value);
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = _tmp1_;
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 2283 "SourceList.c"
	} else {
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 2287 "SourceList.c"
	}
#line 2415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 2291 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp4_;
#line 2416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = granite_widgets_source_list_patch_item_get_parent (value);
#line 2416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _tmp3_;
#line 2416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_expand_with_parents (_tmp4_);
#line 2300 "SourceList.c"
	}
#line 2417 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = self->priv->tree;
#line 2417 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_set_selected_item (_tmp5_, value);
#line 2414 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY]);
#line 2308 "SourceList.c"
}

PangoEllipsizeMode
granite_widgets_source_list_patch_get_ellipsize_mode (GraniteWidgetsSourceListPatch* self)
{
	PangoEllipsizeMode result;
	GraniteWidgetsSourceListPatchTree* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_get_ellipsize_mode (_tmp0_);
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2427 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2330 "SourceList.c"
}

void
granite_widgets_source_list_patch_set_ellipsize_mode (GraniteWidgetsSourceListPatch* self,
                                                      PangoEllipsizeMode value)
{
	GraniteWidgetsSourceListPatchTree* _tmp0_;
#line 2428 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2428 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2428 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_set_ellipsize_mode (_tmp0_, value);
#line 2428 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY]);
#line 2346 "SourceList.c"
}

gboolean
granite_widgets_source_list_patch_get_editing (GraniteWidgetsSourceListPatch* self)
{
	gboolean result;
	GraniteWidgetsSourceListPatchTree* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->tree;
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_get_editing (_tmp0_);
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2438 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2368 "SourceList.c"
}

static void
granite_widgets_source_list_patch_real_item_selected (GraniteWidgetsSourceListPatch* self,
                                                      GraniteWidgetsSourceListPatchItem* item)
{
}

static inline gpointer
granite_widgets_source_list_patch_item_get_instance_private (GraniteWidgetsSourceListPatchItem* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchItem_private_offset);
}

/**
             * Creates a new {@link Granite.Widgets.SourceListPatch.Item}.
             *
             * @param name Name of the item.
             * @return (transfer full) A new {@link Granite.Widgets.SourceListPatch.Item}.
             * @since 0.2
             */
GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_item_construct (GType object_type,
                                                  const gchar* name)
{
	GraniteWidgetsSourceListPatchItem * self = NULL;
#line 316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchItem*) g_object_new (object_type, NULL);
#line 317 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_set_name (self, name);
#line 316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 2403 "SourceList.c"
}

GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_item_new (const gchar* name)
{
#line 316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_item_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, name);
#line 2411 "SourceList.c"
}

/**
             * Invoked when the item is secondary-clicked or when the usual menu keys are pressed.
             *
             * Note that since Granite 5.0, right clicking on an item no longer selects/activates it, so
             * any context menu items should be actioned on the item instance rather than the selected item
             * in the SourceListPatch
             *
             * @return A {@link Gtk.Menu} or //null// if nothing should be displayed.
             * @since 0.2
             */
static GtkMenu*
granite_widgets_source_list_patch_item_real_get_context_menu (GraniteWidgetsSourceListPatchItem* self)
{
	GtkMenu* result;
#line 331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2432 "SourceList.c"
}

GtkMenu*
granite_widgets_source_list_patch_item_get_context_menu (GraniteWidgetsSourceListPatchItem* self)
{
	GraniteWidgetsSourceListPatchItemClass* _klass_;
#line 330 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 330 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_klass_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_GET_CLASS (self);
#line 330 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_klass_->get_context_menu) {
#line 330 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _klass_->get_context_menu (self);
#line 2447 "SourceList.c"
	}
#line 330 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 2451 "SourceList.c"
}

GraniteWidgetsSourceListPatchExpandableItem*
granite_widgets_source_list_patch_item_get_parent (GraniteWidgetsSourceListPatchItem* self)
{
	GraniteWidgetsSourceListPatchExpandableItem* result;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_parent;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2467 "SourceList.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self ? g_object_ref (self) : NULL;
#line 2475 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_parent (GraniteWidgetsSourceListPatchItem* self,
                                                   GraniteWidgetsSourceListPatchExpandableItem* value)
{
	GraniteWidgetsSourceListPatchExpandableItem* old_value;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_parent (self);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 2489 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->_parent);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_parent = _tmp0_;
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY]);
#line 2499 "SourceList.c"
	}
}

const gchar*
granite_widgets_source_list_patch_item_get_name (GraniteWidgetsSourceListPatchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_name;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2516 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_name (GraniteWidgetsSourceListPatchItem* self,
                                                 const gchar* value)
{
	gchar* old_value;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_name (self);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2530 "SourceList.c"
		gchar* _tmp0_;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = g_strdup (value);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_free0 (self->priv->_name);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_name = _tmp0_;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY]);
#line 2540 "SourceList.c"
	}
}

const gchar*
granite_widgets_source_list_patch_item_get_markup (GraniteWidgetsSourceListPatchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_markup;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2557 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_markup (GraniteWidgetsSourceListPatchItem* self,
                                                   const gchar* value)
{
	gchar* old_value;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_markup (self);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2571 "SourceList.c"
		gchar* _tmp0_;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = g_strdup (value);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_free0 (self->priv->_markup);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_markup = _tmp0_;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY]);
#line 2581 "SourceList.c"
	}
}

const gchar*
granite_widgets_source_list_patch_item_get_badge (GraniteWidgetsSourceListPatchItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_badge;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2598 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_badge (GraniteWidgetsSourceListPatchItem* self,
                                                  const gchar* value)
{
	gchar* old_value;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_badge (self);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2612 "SourceList.c"
		gchar* _tmp0_;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = g_strdup (value);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_free0 (self->priv->_badge);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_badge = _tmp0_;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY]);
#line 2622 "SourceList.c"
	}
}

gboolean
granite_widgets_source_list_patch_item_get_editable (GraniteWidgetsSourceListPatchItem* self)
{
	gboolean result;
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = self->priv->_editable;
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2636 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_editable (GraniteWidgetsSourceListPatchItem* self,
                                                     gboolean value)
{
	gboolean old_value;
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_editable (self);
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_editable = value;
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY]);
#line 2654 "SourceList.c"
	}
}

gboolean
granite_widgets_source_list_patch_item_get_visible (GraniteWidgetsSourceListPatchItem* self)
{
	gboolean result;
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = self->priv->_visible;
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2668 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_visible (GraniteWidgetsSourceListPatchItem* self,
                                                    gboolean value)
{
	gboolean old_value;
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_visible (self);
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_visible = value;
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY]);
#line 2686 "SourceList.c"
	}
}

gboolean
granite_widgets_source_list_patch_item_get_selectable (GraniteWidgetsSourceListPatchItem* self)
{
	gboolean result;
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = self->priv->_selectable;
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2700 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_selectable (GraniteWidgetsSourceListPatchItem* self,
                                                       gboolean value)
{
	gboolean old_value;
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_selectable (self);
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_selectable = value;
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY]);
#line 2718 "SourceList.c"
	}
}

GIcon*
granite_widgets_source_list_patch_item_get_icon (GraniteWidgetsSourceListPatchItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_icon;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2735 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_icon (GraniteWidgetsSourceListPatchItem* self,
                                                 GIcon* value)
{
	GIcon* old_value;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_icon (self);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 2749 "SourceList.c"
		GIcon* _tmp0_;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->_icon);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_icon = _tmp0_;
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY]);
#line 2759 "SourceList.c"
	}
}

GIcon*
granite_widgets_source_list_patch_item_get_activatable (GraniteWidgetsSourceListPatchItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_activatable;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 2776 "SourceList.c"
}

void
granite_widgets_source_list_patch_item_set_activatable (GraniteWidgetsSourceListPatchItem* self,
                                                        GIcon* value)
{
	GIcon* old_value;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_item_get_activatable (self);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 2790 "SourceList.c"
		GIcon* _tmp0_;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->_activatable);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_activatable = _tmp0_;
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY]);
#line 2800 "SourceList.c"
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 2822 "SourceList.c"
}

static void
granite_widgets_source_list_patch_item_real_edited (GraniteWidgetsSourceListPatchItem* self,
                                                    const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 195 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (new_name != NULL);
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->_editable;
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 2837 "SourceList.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = string_strip (new_name);
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = _tmp2_;
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = g_strcmp0 (_tmp3_, "") != 0;
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_free0 (_tmp3_);
#line 2848 "SourceList.c"
	} else {
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 2852 "SourceList.c"
	}
#line 196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 197 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_name (self, new_name);
#line 2858 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_item_real_action_activated (GraniteWidgetsSourceListPatchItem* self)
{
}

static void
granite_widgets_source_list_patch_item_real_activated (GraniteWidgetsSourceListPatchItem* self)
{
}

static void
granite_widgets_source_list_patch_item_class_init (GraniteWidgetsSourceListPatchItemClass * klass,
                                                   gpointer klass_data)
{
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_parent_class = g_type_class_peek_parent (klass);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchItem_private_offset);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchItemClass *) klass)->get_context_menu = (GtkMenu* (*) (GraniteWidgetsSourceListPatchItem*)) granite_widgets_source_list_patch_item_real_get_context_menu;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchItemClass *) klass)->edited = granite_widgets_source_list_patch_item_real_edited;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchItemClass *) klass)->action_activated = granite_widgets_source_list_patch_item_real_action_activated;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchItemClass *) klass)->activated = granite_widgets_source_list_patch_item_real_activated;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_item_get_property;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_item_set_property;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_item_finalize;
#line 2894 "SourceList.c"
	/**
	             * Parent {@link Granite.Widgets.SourceListPatch.ExpandableItem} of the item.
	             * ''Must not'' be modified.
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2903 "SourceList.c"
	/**
	             * The item's name. Primary and most important information.
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2911 "SourceList.c"
	/**
	             * Markup to be used instead of {@link Granite.Widgets.SourceListPatch.ExpandableItem.name}
	             * This would mean that &, <, etc have to be escaped in the text, but basic formatting
	             * can be done on the item with HTML style tags.
	             *
	             * Note: Only the {@link Granite.Widgets.SourceListPatch.ExpandableItem.name} property
	             * is modified for editable items. So this property will be need to updated and
	             * reformatted with editable items.
	             *
	             * @since 5.0
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY] = g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2925 "SourceList.c"
	/**
	             * A badge shown next to the item's name.
	             *
	             * It can be used for displaying the number of unread messages in the "Inbox" item,
	             * for instance.
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY] = g_param_spec_string ("badge", "badge", "badge", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2936 "SourceList.c"
	/**
	             * Whether the item's name can be edited from within the source list.
	             *
	             * When this property is set to //true//, users can edit the item by pressing
	             * the F2 key, or by double-clicking its name.
	             *
	             * ''This property only works for selectable items''.
	             *
	             * @see Granite.Widgets.SourceListPatch.Item.selectable
	             * @see Granite.Widgets.SourceListPatch.start_editing_item
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY] = g_param_spec_boolean ("editable", "editable", "editable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2951 "SourceList.c"
	/**
	             * Whether the item should appear in the source list's tree or not.
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2959 "SourceList.c"
	/**
	             * Whether the item can be selected or not.
	             *
	             * Setting this property to true doesn't guarantee that the item will actually be
	             * selectable, since there are other external factors to take into account, like the
	             * item's {@link Granite.Widgets.SourceListPatch.Item.visible} property; whether the item is
	             * a category; the parent item is collapsed, etc.
	             *
	             * @see Granite.Widgets.SourceListPatch.Item.visible
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY] = g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2973 "SourceList.c"
	/**
	             * Primary icon.
	             *
	             * This property should be used to give the user an idea of what the item represents
	             * (i.e. content type.)
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2984 "SourceList.c"
	/**
	             * An activatable icon that works like a button.
	             *
	             * It can be used for e.g. showing an //"eject"// icon on a device's item.
	             *
	             * @see Granite.Widgets.SourceListPatch.Item.action_activated
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY, granite_widgets_source_list_patch_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY] = g_param_spec_object ("activatable", "activatable", "activatable", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2995 "SourceList.c"
	/**
	             * Emitted when the user has finished editing the item's name.
	             *
	             * By default, if the name doesn't consist of white space, it is automatically assigned
	             * to the {@link Granite.Widgets.SourceListPatch.Item.name} property. The default behavior can
	             * be changed by overriding this signal.
	             * @param new_name The item's new name (result of editing.)
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITED_SIGNAL] = g_signal_new ("edited", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListPatchItemClass, edited), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 3007 "SourceList.c"
	/**
	             * The {@link Granite.Widgets.SourceListPatch.Item.activatable} icon was activated.
	             *
	             * @see Granite.Widgets.SourceListPatch.Item.activatable
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTION_ACTIVATED_SIGNAL] = g_signal_new ("action-activated", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListPatchItemClass, action_activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3016 "SourceList.c"
	/**
	             * Emitted when the item is double-clicked or when it is selected and one of the keys:
	             * Space, Shift+Space, Return or Enter is pressed. This signal is //also// for
	             * editable items.
	             *
	             * @since 0.2
	             */
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATED_SIGNAL] = g_signal_new ("activated", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListPatchItemClass, activated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3026 "SourceList.c"
}

static void
granite_widgets_source_list_patch_item_instance_init (GraniteWidgetsSourceListPatchItem * self,
                                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_item_get_instance_private (self);
#line 182 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->use_pango_style = TRUE;
#line 183 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->force_visible = FALSE;
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = g_strdup ("");
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_name = _tmp0_;
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_markup = NULL;
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = g_strdup ("");
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_badge = _tmp1_;
#line 267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_editable = FALSE;
#line 274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_visible = TRUE;
#line 287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_selectable = TRUE;
#line 3057 "SourceList.c"
}

static void
granite_widgets_source_list_patch_item_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatchItem * self;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItem);
#line 223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_parent);
#line 230 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_free0 (self->priv->_name);
#line 243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_free0 (self->priv->_markup);
#line 253 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_free0 (self->priv->_badge);
#line 297 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_icon);
#line 307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_activatable);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_item_parent_class)->finalize (obj);
#line 3080 "SourceList.c"
}

/**
         * A source list entry.
         *
         * Any change made to any of its properties will be ''automatically'' reflected
         * by the {@link Granite.Widgets.SourceListPatch} widget.
         *
         * @since 0.2
         */
static GType
granite_widgets_source_list_patch_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchItem), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_item_instance_init, NULL };
	GType granite_widgets_source_list_patch_item_type_id;
	granite_widgets_source_list_patch_item_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteWidgetsSourceListPatchItem", &g_define_type_info, 0);
	GraniteWidgetsSourceListPatchItem_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_item_type_id, sizeof (GraniteWidgetsSourceListPatchItemPrivate));
	return granite_widgets_source_list_patch_item_type_id;
}

GType
granite_widgets_source_list_patch_item_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_item_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_item_type_id__once)) {
		GType granite_widgets_source_list_patch_item_type_id;
		granite_widgets_source_list_patch_item_type_id = granite_widgets_source_list_patch_item_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_item_type_id__once, granite_widgets_source_list_patch_item_type_id);
	}
	return granite_widgets_source_list_patch_item_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_item_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItem);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_item_get_parent (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_string (value, granite_widgets_source_list_patch_item_get_name (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_string (value, granite_widgets_source_list_patch_item_get_markup (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_string (value, granite_widgets_source_list_patch_item_get_badge (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_item_get_editable (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_item_get_visible (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_item_get_selectable (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_item_get_icon (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_item_get_activatable (self));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 3177 "SourceList.c"
		default:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 3183 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_item_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, GraniteWidgetsSourceListPatchItem);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_PARENT_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_parent (self, g_value_get_object (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_NAME_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_name (self, g_value_get_string (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_MARKUP_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_markup (self, g_value_get_string (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_BADGE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_badge (self, g_value_get_string (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_editable (self, g_value_get_boolean (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_VISIBLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_visible (self, g_value_get_boolean (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_selectable (self, g_value_get_boolean (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ICON_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_icon (self, g_value_get_object (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATABLE_PROPERTY:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_item_set_activatable (self, g_value_get_object (value));
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 3251 "SourceList.c"
		default:
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 3257 "SourceList.c"
	}
}

static inline gpointer
granite_widgets_source_list_patch_expandable_item_get_instance_private (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchExpandableItem_private_offset);
}

/**
             * Creates a new {@link Granite.Widgets.SourceListPatch.ExpandableItem}
             *
             * @param name Title of the item.
             * @return (transfer full) A new {@link Granite.Widgets.SourceListPatch.ExpandableItem}.
             * @since 0.2
             */
GraniteWidgetsSourceListPatchExpandableItem*
granite_widgets_source_list_patch_expandable_item_construct (GType object_type,
                                                             const gchar* name)
{
	GraniteWidgetsSourceListPatchExpandableItem * self = NULL;
#line 462 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 463 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchExpandableItem*) granite_widgets_source_list_patch_item_construct (object_type, name);
#line 462 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 3285 "SourceList.c"
}

GraniteWidgetsSourceListPatchExpandableItem*
granite_widgets_source_list_patch_expandable_item_new (const gchar* name)
{
#line 462 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_expandable_item_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, name);
#line 3293 "SourceList.c"
}

/**
             * Checks whether the item contains the specified child.
             *
             * This method only considers the item's immediate children.
             *
             * @param item Item to search.
             * @return Whether the item was found or not.
             * @since 0.2
             */
gboolean
granite_widgets_source_list_patch_expandable_item_contains (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                            GraniteWidgetsSourceListPatchItem* item)
{
	GeeCollection* _tmp0_;
	gboolean result;
#line 479 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 479 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 480 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->children_list;
#line 480 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = gee_collection_contains (_tmp0_, item);
#line 480 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 3321 "SourceList.c"
}

/**
             * Adds an item.
             *
             * {@link Granite.Widgets.SourceListPatch.ExpandableItem.child_added} is fired after the item is added.
             *
             * While adding a child item, //the item it's being added to will set itself as the parent//.
             * Please note that items are required to have their //parent// property set to //null// before
             * being added, so make sure the item is removed from its previous parent before attempting
             * to add it to another item. For instance:
             * {{{
             * if (item.parent != null)
             *     item.parent.remove (item); // this will set item's parent to null
             * new_parent.add (item);
             * }}}
             *
             * @param item The item to add. Its parent __must__ be //null//.
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.child_added
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.remove
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_add (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                       GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
#line 503 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 503 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 503 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 503 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 503 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (_tmp1_ == NULL, "item.parent == null");
#line 504 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_set_parent (item, self);
#line 505 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->children_list;
#line 505 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_collection_add (_tmp2_, item);
#line 506 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL], 0, item);
#line 3369 "SourceList.c"
}

/**
             * Removes an item.
             *
             * The {@link Granite.Widgets.SourceListPatch.ExpandableItem.child_removed} signal is fired
             * //after removing the item//. Finally (i.e. after all the handlers have been invoked),
             * the item's {@link Granite.Widgets.SourceListPatch.Item.parent} property is set to //null//.
             * This has the advantage of letting signal handlers know the parent from which //item//
             * is being removed.
             *
             * @param item The item to remove. This will fail if item has a different parent.
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.child_removed
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.clear
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_remove (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                          GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GeeCollection* _tmp2_;
#line 523 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 523 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 523 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 523 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 523 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (_tmp1_ == self, "item.parent == this");
#line 524 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->children_list;
#line 524 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_collection_remove (_tmp2_, item);
#line 525 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL], 0, item);
#line 526 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_set_parent (item, NULL);
#line 3411 "SourceList.c"
}

/**
             * Removes all the items contained by the item. It works similarly to
             * {@link Granite.Widgets.SourceListPatch.ExpandableItem.remove}.
             *
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.remove
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.child_removed
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_clear (GraniteWidgetsSourceListPatchExpandableItem* self)
{
#line 537 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 3427 "SourceList.c"
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = granite_widgets_source_list_patch_expandable_item_get_children (self);
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _tmp0_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = _tmp1_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _tmp3_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp2_);
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_item_it = _tmp4_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		while (TRUE) {
#line 3451 "SourceList.c"
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListPatchItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = _item_it;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 3463 "SourceList.c"
			}
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = _item_it;
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			item = (GraniteWidgetsSourceListPatchItem*) _tmp7_;
#line 539 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = item;
#line 539 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			granite_widgets_source_list_patch_expandable_item_remove (self, _tmp8_);
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (item);
#line 3477 "SourceList.c"
		}
#line 538 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_item_it);
#line 3481 "SourceList.c"
	}
}

/**
             * Expands the item and/or its children.
             *
             * @param inclusive Whether to also expand this item (true), or only its children (false).
             * @param recursive Whether to recursively expand all the children (true), or only
             * immediate children (false).
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_expand_all (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                              gboolean inclusive,
                                                              gboolean recursive)
{
#line 551 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 552 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expansion (self, inclusive, recursive, TRUE);
#line 3503 "SourceList.c"
}

/**
             * Collapses the item and/or its children.
             *
             * @param inclusive Whether to also collapse this item (true), or only its children (false).
             * @param recursive Whether to recursively collapse all the children (true), or only
             * immediate children (false).
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_collapse_all (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                gboolean inclusive,
                                                                gboolean recursive)
{
#line 564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 565 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expansion (self, inclusive, recursive, FALSE);
#line 3524 "SourceList.c"
}

static void
granite_widgets_source_list_patch_expandable_item_set_expansion (GraniteWidgetsSourceListPatchExpandableItem* item,
                                                                 gboolean inclusive,
                                                                 gboolean recursive,
                                                                 gboolean expanded)
{
#line 568 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 569 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (inclusive) {
#line 570 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_set_expanded (item, expanded);
#line 3539 "SourceList.c"
	}
	{
		GeeIterator* _child_item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = granite_widgets_source_list_patch_expandable_item_get_children (item);
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _tmp0_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = _tmp1_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _tmp3_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp2_);
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_child_item_it = _tmp4_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		while (TRUE) {
#line 3564 "SourceList.c"
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListPatchItem* child_item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListPatchExpandableItem* child_expandable_item = NULL;
			GraniteWidgetsSourceListPatchItem* _tmp8_;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp9_;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp10_;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = _child_item_it;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 3579 "SourceList.c"
			}
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = _child_item_it;
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			child_item = (GraniteWidgetsSourceListPatchItem*) _tmp7_;
#line 573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = child_item;
#line 573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp8_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp8_) : NULL);
#line 573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			child_expandable_item = _tmp9_;
#line 574 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = child_expandable_item;
#line 574 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp10_ != NULL) {
#line 575 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (recursive) {
#line 3599 "SourceList.c"
					GraniteWidgetsSourceListPatchExpandableItem* _tmp11_;
#line 576 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp11_ = child_expandable_item;
#line 576 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					granite_widgets_source_list_patch_expandable_item_set_expansion (_tmp11_, TRUE, TRUE, expanded);
#line 3605 "SourceList.c"
				} else {
					GraniteWidgetsSourceListPatchExpandableItem* _tmp12_;
#line 578 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp12_ = child_expandable_item;
#line 578 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					granite_widgets_source_list_patch_expandable_item_set_expanded (_tmp12_, expanded);
#line 3612 "SourceList.c"
				}
			}
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (child_expandable_item);
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (child_item);
#line 3619 "SourceList.c"
		}
#line 572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_child_item_it);
#line 3623 "SourceList.c"
	}
}

/**
             * Recursively expands the item along with its parent(s).
             *
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_expand_with_parents (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
#line 589 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 594 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_item_get_parent ((GraniteWidgetsSourceListPatchItem*) self);
#line 594 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 594 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 3646 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
#line 595 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_item_get_parent ((GraniteWidgetsSourceListPatchItem*) self);
#line 595 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = _tmp2_;
#line 595 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_expand_with_parents (_tmp3_);
#line 3655 "SourceList.c"
	}
#line 596 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expanded (self, TRUE);
#line 3659 "SourceList.c"
}

/**
             * Recursively collapses the item along with its parent(s).
             *
             * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
             * @since 0.2
             */
void
granite_widgets_source_list_patch_expandable_item_collapse_with_parents (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
#line 605 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 606 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_item_get_parent ((GraniteWidgetsSourceListPatchItem*) self);
#line 606 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 606 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 3681 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
#line 607 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_item_get_parent ((GraniteWidgetsSourceListPatchItem*) self);
#line 607 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = _tmp2_;
#line 607 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_collapse_with_parents (_tmp3_);
#line 3690 "SourceList.c"
	}
#line 608 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expanded (self, FALSE);
#line 3694 "SourceList.c"
}

gboolean
granite_widgets_source_list_patch_expandable_item_get_collapsible (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	gboolean result;
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = self->priv->_collapsible;
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 3707 "SourceList.c"
}

void
granite_widgets_source_list_patch_expandable_item_set_collapsible (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                   gboolean value)
{
	gboolean old_value;
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_expandable_item_get_collapsible (self);
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_collapsible = value;
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY]);
#line 3725 "SourceList.c"
	}
}

gboolean
granite_widgets_source_list_patch_expandable_item_get_expanded (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (self->priv->_expanded) {
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = TRUE;
#line 3740 "SourceList.c"
	} else {
		gboolean _tmp1_;
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = self->priv->_collapsible;
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = !_tmp1_;
#line 3747 "SourceList.c"
	}
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 416 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 3753 "SourceList.c"
}

void
granite_widgets_source_list_patch_expandable_item_set_expanded (GraniteWidgetsSourceListPatchExpandableItem* self,
                                                                gboolean value)
{
#line 417 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (value != self->priv->_expanded) {
#line 419 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_expanded = value;
#line 420 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (self, granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_TOGGLED_SIGNAL], 0);
#line 3768 "SourceList.c"
	}
#line 417 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY]);
#line 3772 "SourceList.c"
}

guint
granite_widgets_source_list_patch_expandable_item_get_n_children (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	guint result;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->children_list;
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = (guint) _tmp2_;
#line 431 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 3794 "SourceList.c"
}

GeeCollection*
granite_widgets_source_list_patch_expandable_item_get_children (GraniteWidgetsSourceListPatchExpandableItem* self)
{
	GeeCollection* result;
	GeeArrayList* children_list_copy = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
#line 444 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gee_array_list_new (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	children_list_copy = _tmp0_;
#line 448 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->children_list;
#line 448 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_array_list_add_all (children_list_copy, _tmp1_);
#line 449 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = (GeeCollection*) children_list_copy;
#line 449 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 3818 "SourceList.c"
}

static void
granite_widgets_source_list_patch_expandable_item_real_toggled (GraniteWidgetsSourceListPatchExpandableItem* self)
{
}

static GObject *
granite_widgets_source_list_patch_expandable_item_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListPatchExpandableItem * self;
#line 466 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_patch_expandable_item_parent_class);
#line 466 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 466 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItem);
#line 467 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_item_set_editable ((GraniteWidgetsSourceListPatchItem*) self, FALSE);
#line 466 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return obj;
#line 3844 "SourceList.c"
}

static void
granite_widgets_source_list_patch_expandable_item_class_init (GraniteWidgetsSourceListPatchExpandableItemClass * klass,
                                                              gpointer klass_data)
{
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_parent_class = g_type_class_peek_parent (klass);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchExpandableItem_private_offset);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchExpandableItemClass *) klass)->toggled = granite_widgets_source_list_patch_expandable_item_real_toggled;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_expandable_item_get_property;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_expandable_item_set_property;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_patch_expandable_item_constructor;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_expandable_item_finalize;
#line 3865 "SourceList.c"
	/**
	             * Whether the item is collapsible or not.
	             *
	             * When set to //false//, the item is //always// expanded and the expander is
	             * not shown. Please note that this will also affect the value returned by the
	             * {@link Granite.Widgets.SourceListPatch.ExpandableItem.expanded} property.
	             *
	             * @see Granite.Widgets.SourceListPatch.ExpandableItem.expanded
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY] = g_param_spec_boolean ("collapsible", "collapsible", "collapsible", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3880 "SourceList.c"
	/**
	             * Number of children contained by the item.
	             *
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY] = g_param_spec_uint ("n-children", "n-children", "n-children", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 3888 "SourceList.c"
	/**
	             * The item's children.
	             *
	             * This returns a newly-created list containing the children.
	             * It's safe to iterate it while removing items with
	             * {@link Granite.Widgets.SourceListPatch.ExpandableItem.remove}
	             *
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILDREN_PROPERTY, granite_widgets_source_list_patch_expandable_item_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILDREN_PROPERTY] = g_param_spec_object ("children", "children", "children", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 3900 "SourceList.c"
	/**
	             * Emitted when an item is added.
	             *
	             * @param item Item added.
	             * @see Granite.Widgets.SourceListPatch.ExpandableItem.add
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_ADDED_SIGNAL] = g_signal_new ("child-added", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 3910 "SourceList.c"
	/**
	             * Emitted when an item is removed.
	             *
	             * @param item Item removed.
	             * @see Granite.Widgets.SourceListPatch.ExpandableItem.remove
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILD_REMOVED_SIGNAL] = g_signal_new ("child-removed", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 3920 "SourceList.c"
	/**
	             * Emitted when the item is expanded or collapsed.
	             *
	             * @since 0.2
	             */
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_TOGGLED_SIGNAL] = g_signal_new ("toggled", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListPatchExpandableItemClass, toggled), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3928 "SourceList.c"
}

static void
granite_widgets_source_list_patch_expandable_item_instance_init (GraniteWidgetsSourceListPatchExpandableItem * self,
                                                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_expandable_item_get_instance_private (self);
#line 392 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_collapsible = TRUE;
#line 414 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_expanded = FALSE;
#line 453 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gee_array_list_new (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 453 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->children_list = (GeeCollection*) _tmp0_;
#line 3946 "SourceList.c"
}

static void
granite_widgets_source_list_patch_expandable_item_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatchExpandableItem * self;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItem);
#line 453 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->children_list);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_expandable_item_parent_class)->finalize (obj);
#line 3959 "SourceList.c"
}

/**
         * An item that can contain more items.
         *
         * It supports all the properties inherited from {@link Granite.Widgets.SourceListPatch.Item},
         * and behaves like a normal item, except when it is located at the root level; in that case,
         * the following properties are ignored by the widget:
         *
         * * {@link Granite.Widgets.SourceListPatch.Item.selectable}
         * * {@link Granite.Widgets.SourceListPatch.Item.editable}
         * * {@link Granite.Widgets.SourceListPatch.Item.icon}
         * * {@link Granite.Widgets.SourceListPatch.Item.activatable}
         * * {@link Granite.Widgets.SourceListPatch.Item.badge}
         *
         * Root-level expandable items (i.e. Main Categories) are ''not'' displayed when they contain
         * zero visible children.
         *
         * @since 0.2
         */
static GType
granite_widgets_source_list_patch_expandable_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchExpandableItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_expandable_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchExpandableItem), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_expandable_item_instance_init, NULL };
	GType granite_widgets_source_list_patch_expandable_item_type_id;
	granite_widgets_source_list_patch_expandable_item_type_id = g_type_register_static (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, "GraniteWidgetsSourceListPatchExpandableItem", &g_define_type_info, 0);
	GraniteWidgetsSourceListPatchExpandableItem_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_expandable_item_type_id, sizeof (GraniteWidgetsSourceListPatchExpandableItemPrivate));
	return granite_widgets_source_list_patch_expandable_item_type_id;
}

GType
granite_widgets_source_list_patch_expandable_item_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_expandable_item_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_expandable_item_type_id__once)) {
		GType granite_widgets_source_list_patch_expandable_item_type_id;
		granite_widgets_source_list_patch_expandable_item_type_id = granite_widgets_source_list_patch_expandable_item_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_expandable_item_type_id__once, granite_widgets_source_list_patch_expandable_item_type_id);
	}
	return granite_widgets_source_list_patch_expandable_item_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_expandable_item_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItem);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_expandable_item_get_collapsible (self));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_expandable_item_get_expanded (self));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_N_CHILDREN_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_uint (value, granite_widgets_source_list_patch_expandable_item_get_n_children (self));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_CHILDREN_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_take_object (value, granite_widgets_source_list_patch_expandable_item_get_children (self));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 4036 "SourceList.c"
		default:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 4042 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_expandable_item_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchExpandableItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListPatchExpandableItem);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_COLLAPSIBLE_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_set_collapsible (self, g_value_get_boolean (value));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EXPANDABLE_ITEM_EXPANDED_PROPERTY:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_set_expanded (self, g_value_get_boolean (value));
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 4068 "SourceList.c"
		default:
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 4074 "SourceList.c"
	}
}

static inline gpointer
granite_widgets_source_list_patch_data_model_get_instance_private (GraniteWidgetsSourceListPatchDataModel* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchDataModel_private_offset);
}

static GType
granite_widgets_source_list_patch_data_model_column_type (GraniteWidgetsSourceListPatchDataModelColumn self)
{
	GType result;
#line 704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (self) {
#line 704 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM:
#line 4092 "SourceList.c"
		{
#line 706 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM;
#line 706 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 4098 "SourceList.c"
		}
		default:
		{
#line 709 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_assert_not_reached ();
#line 4104 "SourceList.c"
		}
	}
}

static GType
granite_widgets_source_list_patch_data_model_column_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, "GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM", "item"}, {GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_N_COLUMNS, "GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType granite_widgets_source_list_patch_data_model_column_type_id;
	granite_widgets_source_list_patch_data_model_column_type_id = g_enum_register_static ("GraniteWidgetsSourceListPatchDataModelColumn", values);
	return granite_widgets_source_list_patch_data_model_column_type_id;
}

static GType
granite_widgets_source_list_patch_data_model_column_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_data_model_column_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_data_model_column_type_id__once)) {
		GType granite_widgets_source_list_patch_data_model_column_type_id;
		granite_widgets_source_list_patch_data_model_column_type_id = granite_widgets_source_list_patch_data_model_column_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_data_model_column_type_id__once, granite_widgets_source_list_patch_data_model_column_type_id);
	}
	return granite_widgets_source_list_patch_data_model_column_type_id__once;
}

static GraniteWidgetsSourceListPatchDataModel*
granite_widgets_source_list_patch_data_model_construct (GType object_type)
{
	GraniteWidgetsSourceListPatchDataModel * self = NULL;
#line 756 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModel*) g_object_new (object_type, NULL);
#line 756 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 4138 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModel*
granite_widgets_source_list_patch_data_model_new (void)
{
#line 756 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_data_model_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL);
#line 4146 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_has_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                       GraniteWidgetsSourceListPatchItem* item)
{
	GeeHashMap* _tmp0_;
	gboolean result;
#line 771 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 771 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 772 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->items;
#line 772 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, item);
#line 772 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 4165 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_update_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                          GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* node_reference = NULL;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp4_;
#line 775 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 775 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 775 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (granite_widgets_source_list_patch_data_model_has_item (self, item), "has_item (item)");
#line 776 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_root (self);
#line 776 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 776 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "root != null");
#line 781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->items;
#line 781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, item);
#line 781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	node_reference = (GraniteWidgetsSourceListPatchDataModelNodeWrapper*) _tmp3_;
#line 782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = node_reference;
#line 782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp4_ != NULL) {
#line 4200 "SourceList.c"
		GtkTreePath* path = NULL;
		GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreeIter* iter = NULL;
		GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp8_;
		GtkTreeIter* _tmp9_;
		GtkTreeIter* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GtkTreePath* _tmp12_;
#line 783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = node_reference;
#line 783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_path (_tmp5_);
#line 783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = _tmp6_;
#line 783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp7_;
#line 784 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = node_reference;
#line 784 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_iter (_tmp8_);
#line 784 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = _tmp9_;
#line 784 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		iter = _tmp10_;
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = path;
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp12_ != NULL) {
#line 4231 "SourceList.c"
			GtkTreeIter* _tmp13_;
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = iter;
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = _tmp13_ != NULL;
#line 4237 "SourceList.c"
		} else {
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = FALSE;
#line 4241 "SourceList.c"
		}
#line 785 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp11_) {
#line 4245 "SourceList.c"
			GtkTreeStore* _tmp14_;
			GtkTreePath* _tmp15_;
			GtkTreeIter* _tmp16_;
			GtkTreeIter _tmp17_;
#line 786 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp14_ = self->priv->child_tree;
#line 786 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = path;
#line 786 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp16_ = iter;
#line 786 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = *_tmp16_;
#line 786 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_model_row_changed ((GtkTreeModel*) _tmp14_, _tmp15_, &_tmp17_);
#line 787 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_signal_emit (self, granite_widgets_source_list_patch_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
#line 4262 "SourceList.c"
		}
#line 782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreeIter_free0 (iter);
#line 782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 4268 "SourceList.c"
	}
#line 775 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_node_wrapper_unref0 (node_reference);
#line 4272 "SourceList.c"
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
#line 4280 "SourceList.c"
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
#line 4288 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_add_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                       GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GtkTreeIter* parent_child_iter = NULL;
	GtkTreeIter* child_iter = NULL;
	GraniteWidgetsSourceListPatchExpandableItem* parent = NULL;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp6_;
	GtkTreeStore* _tmp15_;
	GtkTreeIter* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkTreeIter _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeStore* _tmp20_;
	GtkTreeIter* _tmp21_;
	GtkTreeIter _tmp22_;
	GeeHashMap* _tmp23_;
	GtkTreeStore* _tmp24_;
	GtkTreeIter* _tmp25_;
	GtkTreeIter _tmp26_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp27_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp28_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp29_;
	GraniteWidgetsSourceListPatchExpandableItem* expandable = NULL;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp30_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp31_;
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (!granite_widgets_source_list_patch_data_model_has_item (self, item), "!has_item (item)");
#line 793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_root (self);
#line 793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "root != null");
#line 796 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_child_iter = NULL;
#line 797 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 797 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = _tmp2_;
#line 797 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 797 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent = _tmp4_;
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = parent;
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp6_ != NULL) {
#line 4349 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp7_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp8_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp9_;
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = parent;
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = granite_widgets_source_list_patch_data_model_get_root (self);
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = _tmp8_;
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp7_ != _tmp9_;
#line 4361 "SourceList.c"
	} else {
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = FALSE;
#line 4365 "SourceList.c"
	}
#line 799 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp5_) {
#line 4369 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp10_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp12_;
		GtkTreeIter* _tmp13_;
		GtkTreeIter* _tmp14_;
#line 801 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = parent;
#line 801 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (!granite_widgets_source_list_patch_data_model_has_item (self, (GraniteWidgetsSourceListPatchItem*) _tmp10_)) {
#line 4378 "SourceList.c"
			GraniteWidgetsSourceListPatchExpandableItem* _tmp11_;
#line 802 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = parent;
#line 802 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			granite_widgets_source_list_patch_data_model_add_item (self, (GraniteWidgetsSourceListPatchItem*) _tmp11_);
#line 4384 "SourceList.c"
		}
#line 805 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = parent;
#line 805 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp13_ = granite_widgets_source_list_patch_data_model_get_item_child_iter (self, (GraniteWidgetsSourceListPatchItem*) _tmp12_);
#line 805 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreeIter_free0 (parent_child_iter);
#line 805 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		parent_child_iter = _tmp13_;
#line 808 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = parent_child_iter;
#line 808 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_vala_assert (_tmp14_ != NULL, "parent_child_iter != null");
#line 4398 "SourceList.c"
	}
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp15_ = self->priv->child_tree;
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp16_ = parent_child_iter;
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_store_append (_tmp15_, &_tmp17_, _tmp16_);
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (child_iter);
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp18_ = _tmp17_;
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp19_ = __vala_GtkTreeIter_copy0 (&_tmp18_);
#line 811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_iter = _tmp19_;
#line 812 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp20_ = self->priv->child_tree;
#line 812 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp21_ = child_iter;
#line 812 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp22_ = *_tmp21_;
#line 812 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_store_set (_tmp20_, &_tmp22_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp23_ = self->priv->items;
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp24_ = self->priv->child_tree;
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp25_ = child_iter;
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp26_ = *_tmp25_;
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp27_ = granite_widgets_source_list_patch_data_model_node_wrapper_new ((GtkTreeModel*) _tmp24_, &_tmp26_);
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp28_ = _tmp27_;
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, item, _tmp28_);
#line 814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_node_wrapper_unref0 (_tmp28_);
#line 818 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_UPDATED_SIGNAL], 0, item);
#line 820 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_add_property_monitor (self, item);
#line 822 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp29_ = parent;
#line 822 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_push_parent_update (self, _tmp29_);
#line 825 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp30_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListPatchExpandableItem*) item) : NULL);
#line 825 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	expandable = _tmp30_;
#line 826 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp31_ = expandable;
#line 826 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp31_ != NULL) {
#line 4454 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp42_;
		{
			GeeIterator* _child_item_it = NULL;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp32_;
			GeeCollection* _tmp33_;
			GeeCollection* _tmp34_;
			GeeCollection* _tmp35_;
			GeeIterator* _tmp36_;
			GeeIterator* _tmp37_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp32_ = expandable;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp33_ = granite_widgets_source_list_patch_expandable_item_get_children (_tmp32_);
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp34_ = _tmp33_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp35_ = _tmp34_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp37_ = _tmp36_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_tmp35_);
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_child_item_it = _tmp37_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			while (TRUE) {
#line 4482 "SourceList.c"
				GeeIterator* _tmp38_;
				GraniteWidgetsSourceListPatchItem* child_item = NULL;
				GeeIterator* _tmp39_;
				gpointer _tmp40_;
				GraniteWidgetsSourceListPatchItem* _tmp41_;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp38_ = _child_item_it;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (!gee_iterator_next (_tmp38_)) {
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					break;
#line 4494 "SourceList.c"
				}
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp39_ = _child_item_it;
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp40_ = gee_iterator_get (_tmp39_);
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				child_item = (GraniteWidgetsSourceListPatchItem*) _tmp40_;
#line 828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp41_ = child_item;
#line 828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_data_model_add_item (self, _tmp41_);
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (child_item);
#line 4508 "SourceList.c"
			}
#line 827 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_child_item_it);
#line 4512 "SourceList.c"
		}
#line 831 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp42_ = expandable;
#line 831 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_add_children_monitor (self, _tmp42_);
#line 4518 "SourceList.c"
	}
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (expandable);
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (parent);
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (child_iter);
#line 792 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (parent_child_iter);
#line 4528 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_remove_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                          GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp2_;
	GeeHashMap* _tmp3_;
	GtkTreeIter* _tmp4_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp6_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp7_;
	GraniteWidgetsSourceListPatchExpandableItem* expandable = NULL;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp8_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp9_;
#line 835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (granite_widgets_source_list_patch_data_model_has_item (self, item), "has_item (item)");
#line 836 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_root (self);
#line 836 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 836 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "root != null");
#line 838 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_remove_property_monitor (self, item);
#line 843 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item_child_iter (self, item);
#line 843 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_iter = _tmp2_;
#line 849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = self->priv->items;
#line 849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, item, NULL);
#line 851 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = child_iter;
#line 851 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp4_ != NULL) {
#line 4572 "SourceList.c"
		GtkTreeStore* _tmp5_;
#line 852 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = self->priv->child_tree;
#line 852 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_store_remove (_tmp5_, child_iter);
#line 4578 "SourceList.c"
	}
#line 854 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = granite_widgets_source_list_patch_item_get_parent (item);
#line 854 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = _tmp6_;
#line 854 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_push_parent_update (self, _tmp7_);
#line 857 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListPatchExpandableItem*) item) : NULL);
#line 857 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	expandable = _tmp8_;
#line 858 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = expandable;
#line 858 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp9_ != NULL) {
#line 4594 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp10_;
#line 860 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = expandable;
#line 860 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_remove_children_monitor (self, _tmp10_);
#line 4600 "SourceList.c"
		{
			GeeIterator* _child_item_it = NULL;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp11_;
			GeeCollection* _tmp12_;
			GeeCollection* _tmp13_;
			GeeCollection* _tmp14_;
			GeeIterator* _tmp15_;
			GeeIterator* _tmp16_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = expandable;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = granite_widgets_source_list_patch_expandable_item_get_children (_tmp11_);
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = _tmp12_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp14_ = _tmp13_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp16_ = _tmp15_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_tmp14_);
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_child_item_it = _tmp16_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			while (TRUE) {
#line 4627 "SourceList.c"
				GeeIterator* _tmp17_;
				GraniteWidgetsSourceListPatchItem* child_item = NULL;
				GeeIterator* _tmp18_;
				gpointer _tmp19_;
				GraniteWidgetsSourceListPatchItem* _tmp20_;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp17_ = _child_item_it;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (!gee_iterator_next (_tmp17_)) {
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					break;
#line 4639 "SourceList.c"
				}
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp18_ = _child_item_it;
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp19_ = gee_iterator_get (_tmp18_);
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				child_item = (GraniteWidgetsSourceListPatchItem*) _tmp19_;
#line 863 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp20_ = child_item;
#line 863 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_data_model_remove_item (self, _tmp20_);
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (child_item);
#line 4653 "SourceList.c"
			}
#line 862 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_child_item_it);
#line 4657 "SourceList.c"
		}
	}
#line 835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (expandable);
#line 835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (child_iter);
#line 4664 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_data_model_on_item_prop_changed_granite_widgets_source_list_patch_data_model_item_monitor_changed (GraniteWidgetsSourceListPatchDataModelItemMonitor* _sender,
                                                                                                                                      GraniteWidgetsSourceListPatchItem* _self_,
                                                                                                                                      const gchar* prop_name,
                                                                                                                                      gpointer self)
{
#line 870 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_on_item_prop_changed ((GraniteWidgetsSourceListPatchDataModel*) self, _self_, prop_name);
#line 4675 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_add_property_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                   GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor* wrapper = NULL;
	GraniteWidgetsSourceListPatchDataModelItemMonitor* _tmp0_;
	GeeHashMap* _tmp1_;
#line 867 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 867 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 868 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_item_monitor_new (item);
#line 868 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	wrapper = _tmp0_;
#line 869 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->monitors;
#line 869 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, item, wrapper);
#line 870 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (wrapper, "changed", (GCallback) _granite_widgets_source_list_patch_data_model_on_item_prop_changed_granite_widgets_source_list_patch_data_model_item_monitor_changed, self, 0);
#line 867 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_item_monitor_unref0 (wrapper);
#line 4701 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_remove_property_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                      GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor* wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListPatchDataModelItemMonitor* _tmp2_;
	GeeHashMap* _tmp5_;
#line 873 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 873 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 874 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->monitors;
#line 874 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
#line 874 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	wrapper = (GraniteWidgetsSourceListPatchDataModelItemMonitor*) _tmp1_;
#line 875 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = wrapper;
#line 875 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 4727 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModelItemMonitor* _tmp3_;
		guint _tmp4_;
#line 876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = wrapper;
#line 876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_parse_name ("changed", GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, &_tmp4_, NULL, FALSE);
#line 876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_data_model_on_item_prop_changed_granite_widgets_source_list_patch_data_model_item_monitor_changed, self);
#line 4736 "SourceList.c"
	}
#line 877 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = self->priv->monitors;
#line 877 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, item, NULL);
#line 873 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_item_monitor_unref0 (wrapper);
#line 4744 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_data_model_on_item_child_added_granite_widgets_source_list_patch_expandable_item_child_added (GraniteWidgetsSourceListPatchExpandableItem* _sender,
                                                                                                                                 GraniteWidgetsSourceListPatchItem* item,
                                                                                                                                 gpointer self)
{
#line 881 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_on_item_child_added ((GraniteWidgetsSourceListPatchDataModel*) self, item);
#line 4754 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_data_model_on_item_child_removed_granite_widgets_source_list_patch_expandable_item_child_removed (GraniteWidgetsSourceListPatchExpandableItem* _sender,
                                                                                                                                     GraniteWidgetsSourceListPatchItem* item,
                                                                                                                                     gpointer self)
{
#line 882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_on_item_child_removed ((GraniteWidgetsSourceListPatchDataModel*) self, item);
#line 4764 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_add_children_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                   GraniteWidgetsSourceListPatchExpandableItem* item)
{
#line 880 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 880 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 881 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (item, "child-added", (GCallback) _granite_widgets_source_list_patch_data_model_on_item_child_added_granite_widgets_source_list_patch_expandable_item_child_added, self, G_CONNECT_AFTER);
#line 882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (item, "child-removed", (GCallback) _granite_widgets_source_list_patch_data_model_on_item_child_removed_granite_widgets_source_list_patch_expandable_item_child_removed, self, G_CONNECT_AFTER);
#line 4779 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_remove_children_monitor (GraniteWidgetsSourceListPatchDataModel* self,
                                                                      GraniteWidgetsSourceListPatchExpandableItem* item)
{
	guint _tmp0_;
	guint _tmp1_;
#line 885 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 885 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 886 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_parse_name ("child-added", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, &_tmp0_, NULL, FALSE);
#line 886 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_data_model_on_item_child_added_granite_widgets_source_list_patch_expandable_item_child_added, self);
#line 887 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_parse_name ("child-removed", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, &_tmp1_, NULL, FALSE);
#line 887 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_disconnect_matched (item, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_data_model_on_item_child_removed_granite_widgets_source_list_patch_expandable_item_child_removed, self);
#line 4800 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_on_item_child_added (GraniteWidgetsSourceListPatchDataModel* self,
                                                                  GraniteWidgetsSourceListPatchItem* item)
{
#line 890 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 890 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 891 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_add_item (self, item);
#line 4813 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_on_item_child_removed (GraniteWidgetsSourceListPatchDataModel* self,
                                                                    GraniteWidgetsSourceListPatchItem* item)
{
#line 894 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 894 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 895 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_remove_item (self, item);
#line 4826 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_on_item_prop_changed (GraniteWidgetsSourceListPatchDataModel* self,
                                                                   GraniteWidgetsSourceListPatchItem* item,
                                                                   const gchar* prop_name)
{
#line 898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (prop_name != NULL);
#line 899 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_strcmp0 (prop_name, "parent") != 0) {
#line 900 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_update_item (self, item);
#line 4844 "SourceList.c"
	}
}

/**
             * Pushes a call to update_item() if //parent// is not //null//.
             *
             * This is needed because the visibility of categories depends on their n_children property,
             * and also because item expansion should be updated after adding or removing items.
             * If many updates are pushed, and the item has still not been updated, only one is processed.
             * This guarantees efficiency as updating a category item could trigger expensive actions.
             */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return _data1_;
#line 4863 "SourceList.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 4873 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModel* self;
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self = _data1_->self;
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_data1_->parent);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_slice_free (Block1Data, _data1_);
#line 4883 "SourceList.c"
	}
}

static gboolean
___lambda54_ (Block1Data* _data1_)
{
	GraniteWidgetsSourceListPatchDataModel* self;
	gboolean result;
#line 928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = _data1_->self;
#line 929 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_data1_->parent != NULL) {
#line 930 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_update_item (self, (GraniteWidgetsSourceListPatchItem*) _data1_->parent);
#line 933 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set_data_full ((GObject*) _data1_->parent, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) FALSE), NULL);
#line 4900 "SourceList.c"
	}
#line 936 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 936 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 4906 "SourceList.c"
}

static gboolean
____lambda54__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda54_ (self);
#line 928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 4916 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_push_parent_update (GraniteWidgetsSourceListPatchDataModel* self,
                                                                 GraniteWidgetsSourceListPatchExpandableItem* parent)
{
	Block1Data* _data1_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	gboolean needs_update = FALSE;
	gconstpointer _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp2_;
	GtkTreePath* _tmp3_;
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_data1_->_ref_count_ = 1;
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_data1_->self = g_object_ref (self);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (parent);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (_data1_->parent);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_data1_->parent = _tmp0_;
#line 912 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_data1_->parent == NULL) {
#line 913 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		block1_data_unref (_data1_);
#line 913 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_data1_ = NULL;
#line 913 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return;
#line 4952 "SourceList.c"
	}
#line 915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = g_object_get_data ((GObject*) _data1_->parent, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE);
#line 915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	needs_update = (gboolean) ((gintptr) _tmp1_);
#line 919 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (needs_update) {
#line 920 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		block1_data_unref (_data1_);
#line 920 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_data1_ = NULL;
#line 920 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return;
#line 4966 "SourceList.c"
	}
#line 922 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item_path (self, (GraniteWidgetsSourceListPatchItem*) _data1_->parent);
#line 922 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp2_;
#line 924 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = path;
#line 924 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ != NULL) {
#line 926 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set_data_full ((GObject*) _data1_->parent, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_PARENT_NEEDS_UPDATE, (gpointer) ((gintptr) TRUE), NULL);
#line 928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda54__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 4980 "SourceList.c"
	}
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	block1_data_unref (_data1_);
#line 911 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_data1_ = NULL;
#line 4988 "SourceList.c"
}

/**
             * Returns the Item pointed by iter, or null if the iter doesn't refer to a valid item.
             */
static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_data_model_get_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                       GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeIter _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_ = NULL;
	GraniteWidgetsSourceListPatchItem* result;
#line 944 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 944 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = *iter;
#line 946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp1_, -1, -1);
#line 946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp1_;
#line 947 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = item;
#line 947 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5018 "SourceList.c"
}

/**
             * Returns the Item pointed by path, or null if the path doesn't refer to a valid item.
             */
static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_data_model_get_item_from_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                                 GtkTreePath* path)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GraniteWidgetsSourceListPatchItem* result;
#line 953 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 953 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 955 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
#line 955 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iter = _tmp0_;
#line 955 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 5042 "SourceList.c"
		GtkTreeIter _tmp2_;
		GraniteWidgetsSourceListPatchItem* _tmp3_;
#line 956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = iter;
#line 956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = granite_widgets_source_list_patch_data_model_get_item (self, &_tmp2_);
#line 956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = _tmp3_;
#line 956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 5053 "SourceList.c"
	}
#line 958 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 958 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5059 "SourceList.c"
}

/**
             * Returns a newly-created path pointing to the item, or null in case a valid path
             * is not found.
             */
static GtkTreePath*
granite_widgets_source_list_patch_data_model_get_item_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                            GraniteWidgetsSourceListPatchItem* item)
{
	GtkTreePath* path = NULL;
	GtkTreePath* child_path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* result;
#line 965 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 965 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 966 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = NULL;
#line 966 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_item_child_path (self, item);
#line 966 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_path = _tmp0_;
#line 969 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = child_path;
#line 969 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 5089 "SourceList.c"
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
#line 970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = child_path;
#line 970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp2_);
#line 970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp3_;
#line 5100 "SourceList.c"
	}
#line 972 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = path;
#line 972 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (child_path);
#line 972 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5108 "SourceList.c"
}

/**
             * Returns a newly-created iterator pointing to the item, or null in case a valid iter
             * was not found.
             */
static GtkTreeIter*
granite_widgets_source_list_patch_data_model_get_item_iter (GraniteWidgetsSourceListPatchDataModel* self,
                                                            GraniteWidgetsSourceListPatchItem* item)
{
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter* result;
#line 979 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 979 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 980 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_item_child_iter (self, item);
#line 980 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_iter = _tmp0_;
#line 982 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = child_iter;
#line 982 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 5135 "SourceList.c"
		GtkTreeIter iter = {0};
		GtkTreeIter* _tmp2_;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter _tmp4_;
		gboolean _tmp5_;
#line 984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = child_iter;
#line 984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = *_tmp2_;
#line 984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = gtk_tree_model_filter_convert_child_iter_to_iter ((GtkTreeModelFilter*) self, &_tmp3_, &_tmp4_);
#line 984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		iter = _tmp3_;
#line 984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 5151 "SourceList.c"
			GtkTreeIter* _tmp6_;
#line 985 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = __vala_GtkTreeIter_copy0 (&iter);
#line 985 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = _tmp6_;
#line 985 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreeIter_free0 (child_iter);
#line 985 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 5161 "SourceList.c"
		}
	}
#line 988 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = NULL;
#line 988 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeIter_free0 (child_iter);
#line 988 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5170 "SourceList.c"
}

/**
             * External "extra" filter method.
             */
static void
granite_widgets_source_list_patch_data_model_set_filter_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                              GraniteWidgetsSourceListPatchVisibleFunc visible_func,
                                                              gpointer visible_func_target)
{
#line 994 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 995 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->filter_func = visible_func;
#line 995 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->filter_func_target = visible_func_target;
#line 5187 "SourceList.c"
}

/**
             * Checks whether an item is a category (i.e. a root-level expandable item).
             * The caller must pass an iter or path pointing to the item, but not both
             * (one of them must be null.)
             *
             * TODO: instead of checking the position of the iter or path, we should simply
             * check whether the item's parent is the root item and whether the item is
             * expandable. We don't do so right now because vala still allows client code
             * to access the Item.parent property, even though its setter is defined as internal.
             */
static gboolean
granite_widgets_source_list_patch_data_model_is_category (GraniteWidgetsSourceListPatchDataModel* self,
                                                          GraniteWidgetsSourceListPatchItem* item,
                                                          GtkTreeIter* iter,
                                                          GtkTreePath* path)
{
	gboolean is_category = FALSE;
	gboolean result;
#line 1008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 1009 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	is_category = FALSE;
#line 1012 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (iter != NULL) {
#line 5216 "SourceList.c"
		GtkTreeIter _tmp0_;
#line 1013 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_vala_assert (path == NULL, "path == null");
#line 1014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = *iter;
#line 1014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		is_category = granite_widgets_source_list_patch_data_model_is_iter_at_root_level (self, &_tmp0_);
#line 5224 "SourceList.c"
	} else {
#line 1016 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_vala_assert (iter == NULL, "iter == null");
#line 1017 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		is_category = granite_widgets_source_list_patch_data_model_is_path_at_root_level (self, path);
#line 5230 "SourceList.c"
	}
#line 1020 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = is_category;
#line 1020 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5236 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_is_iter_at_root_level (GraniteWidgetsSourceListPatchDataModel* self,
                                                                    GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
#line 1023 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1023 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = *iter;
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp0_);
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = granite_widgets_source_list_patch_data_model_is_path_at_root_level (self, _tmp2_);
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (_tmp2_);
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp3_;
#line 1024 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5266 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_is_path_at_root_level (GraniteWidgetsSourceListPatchDataModel* self,
                                                                    GtkTreePath* path)
{
	gboolean result;
#line 1027 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1027 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 1028 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = gtk_tree_path_get_depth (path) == 1;
#line 1028 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5282 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_resort (GraniteWidgetsSourceListPatchDataModel* self)
{
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
#line 1031 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1032 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->child_tree;
#line 1032 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp0_, GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
#line 1033 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->child_tree;
#line 1033 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
#line 5300 "SourceList.c"
}

static gint
granite_widgets_source_list_patch_data_model_child_model_sort_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                                    GtkTreeModel* model,
                                                                    GtkTreeIter* a,
                                                                    GtkTreeIter* b)
{
	gint order = 0;
	GraniteWidgetsSourceListPatchItem* item_a = NULL;
	GraniteWidgetsSourceListPatchItem* item_b = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GraniteWidgetsSourceListPatchItem* _tmp5_ = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp6_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp7_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp8_;
	GraniteWidgetsSourceListPatchItem* _tmp9_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp10_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp11_;
	GraniteWidgetsSourceListPatchSortable* parent = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp12_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp13_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp14_;
	GraniteWidgetsSourceListPatchSortable* _tmp15_;
	GraniteWidgetsSourceListPatchSortable* _tmp16_;
	gint result;
#line 1036 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1036 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (model != NULL, 0);
#line 1036 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 1036 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 1037 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	order = 0;
#line 1040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->child_tree;
#line 1040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *a;
#line 1040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
#line 1040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item_a);
#line 1040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item_a = _tmp2_;
#line 1041 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = self->priv->child_tree;
#line 1041 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = *b;
#line 1041 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp5_, -1, -1);
#line 1041 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item_b);
#line 1041 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item_b = _tmp5_;
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = item_a;
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = granite_widgets_source_list_patch_item_get_parent (_tmp6_);
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = _tmp7_;
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = item_b;
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp10_ = granite_widgets_source_list_patch_item_get_parent (_tmp9_);
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp11_ = _tmp10_;
#line 1044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp8_ == _tmp11_, "item_a.parent == item_b.parent");
#line 1046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = item_a;
#line 1046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp13_ = granite_widgets_source_list_patch_item_get_parent (_tmp12_);
#line 1046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp14_ = _tmp13_;
#line 1046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp15_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_SORTABLE (_tmp14_) ? ((GraniteWidgetsSourceListPatchSortable*) _tmp14_) : NULL);
#line 1046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent = _tmp15_;
#line 1047 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp16_ = parent;
#line 1047 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp16_ != NULL) {
#line 5389 "SourceList.c"
		GraniteWidgetsSourceListPatchSortable* _tmp17_;
		GraniteWidgetsSourceListPatchItem* _tmp18_;
		GraniteWidgetsSourceListPatchItem* _tmp19_;
#line 1048 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = parent;
#line 1048 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp18_ = item_a;
#line 1048 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp19_ = item_b;
#line 1048 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		order = granite_widgets_source_list_patch_sortable_compare (_tmp17_, _tmp18_, _tmp19_);
#line 5401 "SourceList.c"
	}
#line 1050 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = order;
#line 1050 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (parent);
#line 1050 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item_b);
#line 1050 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item_a);
#line 1050 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5413 "SourceList.c"
}

static GtkTreeIter*
granite_widgets_source_list_patch_data_model_get_item_child_iter (GraniteWidgetsSourceListPatchDataModel* self,
                                                                  GraniteWidgetsSourceListPatchItem* item)
{
	GtkTreeIter* child_iter = NULL;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp2_;
	GtkTreeIter* result;
#line 1053 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1053 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 1054 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_iter = NULL;
#line 1056 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->items;
#line 1056 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
#line 1056 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_node_wrapper = (GraniteWidgetsSourceListPatchDataModelNodeWrapper*) _tmp1_;
#line 1057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = child_node_wrapper;
#line 1057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 5442 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp3_;
		GtkTreeIter* _tmp4_;
		GtkTreeIter* _tmp5_;
#line 1058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = child_node_wrapper;
#line 1058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_iter (_tmp3_);
#line 1058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreeIter_free0 (child_iter);
#line 1058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		child_iter = _tmp5_;
#line 5456 "SourceList.c"
	}
#line 1060 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = child_iter;
#line 1060 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_node_wrapper_unref0 (child_node_wrapper);
#line 1060 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5464 "SourceList.c"
}

static GtkTreePath*
granite_widgets_source_list_patch_data_model_get_item_child_path (GraniteWidgetsSourceListPatchDataModel* self,
                                                                  GraniteWidgetsSourceListPatchItem* item)
{
	GtkTreePath* child_path = NULL;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* child_node_wrapper = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp2_;
	GtkTreePath* result;
#line 1063 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1063 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 1064 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_path = NULL;
#line 1066 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->items;
#line 1066 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, item);
#line 1066 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_node_wrapper = (GraniteWidgetsSourceListPatchDataModelNodeWrapper*) _tmp1_;
#line 1067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = child_node_wrapper;
#line 1067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 5493 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp3_;
		GtkTreePath* _tmp4_;
		GtkTreePath* _tmp5_;
#line 1068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = child_node_wrapper;
#line 1068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_path (_tmp3_);
#line 1068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_path);
#line 1068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		child_path = _tmp5_;
#line 5507 "SourceList.c"
	}
#line 1070 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = child_path;
#line 1070 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_node_wrapper_unref0 (child_node_wrapper);
#line 1070 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5515 "SourceList.c"
}

/**
             * Filters the child-tree items based on their "visible" property.
             */
static gboolean
granite_widgets_source_list_patch_data_model_filter_visible_func (GraniteWidgetsSourceListPatchDataModel* self,
                                                                  GtkTreeModel* child_model,
                                                                  GtkTreeIter* iter)
{
	gboolean item_visible = FALSE;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_ = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp3_;
	GraniteWidgetsSourceListPatchVisibleFunc _tmp27_;
	gpointer _tmp27__target;
	gboolean result;
#line 1076 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1076 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (child_model != NULL, FALSE);
#line 1076 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 1077 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item_visible = FALSE;
#line 1080 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->child_tree;
#line 1080 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *iter;
#line 1080 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
#line 1080 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 1080 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp2_;
#line 1082 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = item;
#line 1082 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ != NULL) {
#line 5557 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GraniteWidgetsSourceListPatchExpandableItem* expandable = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp7_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GraniteWidgetsSourceListPatchItem* _tmp11_;
#line 1083 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = item;
#line 1083 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = granite_widgets_source_list_patch_item_get_visible (_tmp4_);
#line 1083 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = _tmp5_;
#line 1083 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item_visible = _tmp6_;
#line 1087 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = item;
#line 1087 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp7_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp7_) : NULL);
#line 1087 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		expandable = _tmp8_;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = item;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (!_tmp11_->force_visible) {
#line 5585 "SourceList.c"
			GraniteWidgetsSourceListPatchExpandableItem* _tmp12_;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = expandable;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = _tmp12_ != NULL;
#line 5591 "SourceList.c"
		} else {
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = FALSE;
#line 5595 "SourceList.c"
		}
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp10_) {
#line 5599 "SourceList.c"
			GtkTreeStore* _tmp13_;
			GtkTreeIter _tmp14_;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = self->priv->child_tree;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp14_ = *iter;
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = gtk_tree_store_iter_depth (_tmp13_, &_tmp14_) == 0;
#line 5608 "SourceList.c"
		} else {
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = FALSE;
#line 5612 "SourceList.c"
		}
#line 1088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp9_) {
#line 1089 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			item_visible = FALSE;
#line 5618 "SourceList.c"
			{
				GeeIterator* _child_item_it = NULL;
				GraniteWidgetsSourceListPatchExpandableItem* _tmp15_;
				GeeCollection* _tmp16_;
				GeeCollection* _tmp17_;
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				GeeIterator* _tmp20_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp15_ = expandable;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp16_ = granite_widgets_source_list_patch_expandable_item_get_children (_tmp15_);
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp17_ = _tmp16_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp18_ = _tmp17_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp20_ = _tmp19_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_tmp18_);
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_child_item_it = _tmp20_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				while (TRUE) {
#line 5645 "SourceList.c"
					GeeIterator* _tmp21_;
					GraniteWidgetsSourceListPatchItem* child_item = NULL;
					GeeIterator* _tmp22_;
					gpointer _tmp23_;
					GraniteWidgetsSourceListPatchItem* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp21_ = _child_item_it;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (!gee_iterator_next (_tmp21_)) {
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						break;
#line 5659 "SourceList.c"
					}
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp22_ = _child_item_it;
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp23_ = gee_iterator_get (_tmp22_);
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					child_item = (GraniteWidgetsSourceListPatchItem*) _tmp23_;
#line 1091 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp24_ = child_item;
#line 1091 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp25_ = granite_widgets_source_list_patch_item_get_visible (_tmp24_);
#line 1091 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp26_ = _tmp25_;
#line 1091 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (_tmp26_) {
#line 1092 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						item_visible = TRUE;
#line 1093 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_g_object_unref0 (child_item);
#line 1093 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						break;
#line 5681 "SourceList.c"
					}
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_g_object_unref0 (child_item);
#line 5685 "SourceList.c"
				}
#line 1090 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_child_item_it);
#line 5689 "SourceList.c"
			}
		}
#line 1082 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (expandable);
#line 5694 "SourceList.c"
	}
#line 1099 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp27_ = self->priv->filter_func;
#line 1099 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp27__target = self->priv->filter_func_target;
#line 1099 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp27_ != NULL) {
#line 5702 "SourceList.c"
		gboolean _tmp28_ = FALSE;
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (item_visible) {
#line 5706 "SourceList.c"
			GraniteWidgetsSourceListPatchVisibleFunc _tmp29_;
			gpointer _tmp29__target;
			GraniteWidgetsSourceListPatchItem* _tmp30_;
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp29_ = self->priv->filter_func;
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp29__target = self->priv->filter_func_target;
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp30_ = item;
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp28_ = _tmp29_ (_tmp30_, _tmp29__target);
#line 5718 "SourceList.c"
		} else {
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp28_ = FALSE;
#line 5722 "SourceList.c"
		}
#line 1100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item_visible = _tmp28_;
#line 5726 "SourceList.c"
	}
#line 1102 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = item_visible;
#line 1102 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 1102 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5734 "SourceList.c"
}

/**
             * TreeDragDest implementation
             */
static gboolean
granite_widgets_source_list_patch_data_model_real_drag_data_received (GtkTreeDragDest* base,
                                                                      GtkTreePath* dest,
                                                                      GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	gboolean result;
#line 1109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModel*) base;
#line 1109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (dest != NULL, FALSE);
#line 1109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (selection_data != NULL, FALSE);
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (model);
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = _g_object_ref0 (_tmp1_);
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	model = _tmp4_;
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (src_path);
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	src_path = _tmp2_;
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_) {
#line 5774 "SourceList.c"
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = model;
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = self->priv->child_tree;
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
#line 5783 "SourceList.c"
	} else {
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 5787 "SourceList.c"
	}
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 5791 "SourceList.c"
		GtkTreePath* child_dest = NULL;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
#line 1119 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
#line 1119 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		child_dest = _tmp7_;
#line 1121 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = child_dest;
#line 1121 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp8_ != NULL) {
#line 5803 "SourceList.c"
			GtkTreePath* _tmp9_;
			GtkTreePath* _tmp10_;
#line 1123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = child_dest;
#line 1123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = src_path;
#line 1123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (granite_widgets_source_list_patch_data_model_child_tree_drag_data_received (self, _tmp9_, _tmp10_)) {
#line 1124 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				result = TRUE;
#line 1124 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreePath_free0 (child_dest);
#line 1124 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreePath_free0 (src_path);
#line 1124 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (model);
#line 1124 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				return result;
#line 5822 "SourceList.c"
			}
		}
#line 1117 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 5827 "SourceList.c"
	}
#line 1129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 1129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (src_path);
#line 1129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (model);
#line 1129 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 5837 "SourceList.c"
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 1139 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 5845 "SourceList.c"
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 1139 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 5853 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_child_tree_drag_data_received (GraniteWidgetsSourceListPatchDataModel* self,
                                                                            GtkTreePath* dest,
                                                                            GtkTreePath* src_path)
{
	gboolean retval = FALSE;
	GtkTreeIter src_iter = {0};
	GtkTreeIter dest_iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTreePath* prev = NULL;
	GtkTreePath* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean result;
#line 1132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (dest != NULL, FALSE);
#line 1132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (src_path != NULL, FALSE);
#line 1133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	retval = FALSE;
#line 1136 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->child_tree;
#line 1136 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp1_, src_path);
#line 1136 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	src_iter = _tmp1_;
#line 1136 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!_tmp2_) {
#line 1137 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1137 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 5891 "SourceList.c"
	}
#line 1139 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = __vala_GtkTreePath_copy0 (dest);
#line 1139 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	prev = _tmp3_;
#line 1142 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = prev;
#line 1142 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!gtk_tree_path_prev (_tmp4_)) {
#line 5901 "SourceList.c"
		GtkTreePath* parent = NULL;
		GtkTreePath* _tmp5_;
		GtkTreeIter* dest_parent = NULL;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_;
		GtkTreeStore* _tmp14_;
		GtkTreeIter* _tmp15_;
		GtkTreeIter _tmp16_ = {0};
#line 1146 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = __vala_GtkTreePath_copy0 (dest);
#line 1146 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		parent = _tmp5_;
#line 1147 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_parent = NULL;
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = parent;
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (gtk_tree_path_up (_tmp7_)) {
#line 5920 "SourceList.c"
			GtkTreePath* _tmp8_;
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = parent;
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = gtk_tree_path_get_depth (_tmp8_) > 0;
#line 5926 "SourceList.c"
		} else {
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = FALSE;
#line 5930 "SourceList.c"
		}
#line 1149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp6_) {
#line 5934 "SourceList.c"
			GtkTreeStore* _tmp9_;
			GtkTreePath* _tmp10_;
			GtkTreeIter _tmp11_ = {0};
			GtkTreeIter _tmp12_;
			GtkTreeIter* _tmp13_;
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = self->priv->child_tree;
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = parent;
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreeIter_free0 (dest_parent);
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = _tmp11_;
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = __vala_GtkTreeIter_copy0 (&_tmp12_);
#line 1150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dest_parent = _tmp13_;
#line 5954 "SourceList.c"
		}
#line 1152 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = self->priv->child_tree;
#line 1152 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = dest_parent;
#line 1152 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_store_prepend (_tmp14_, &_tmp16_, _tmp15_);
#line 1152 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_iter = _tmp16_;
#line 1153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		retval = TRUE;
#line 1142 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreeIter_free0 (dest_parent);
#line 1142 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (parent);
#line 5970 "SourceList.c"
	} else {
		GtkTreeStore* _tmp17_;
		GtkTreePath* _tmp18_;
		GtkTreeIter _tmp19_ = {0};
		gboolean _tmp20_;
#line 1154 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = self->priv->child_tree;
#line 1154 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp18_ = prev;
#line 1154 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp17_, &_tmp19_, _tmp18_);
#line 1154 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_iter = _tmp19_;
#line 1154 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp20_) {
#line 5986 "SourceList.c"
			GtkTreeIter tmp_iter = {0};
			GtkTreeIter _tmp21_;
			GtkTreeStore* _tmp22_;
			GtkTreeIter _tmp23_;
			GtkTreeIter _tmp24_ = {0};
#line 1155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp21_ = dest_iter;
#line 1155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			tmp_iter = _tmp21_;
#line 1156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp22_ = self->priv->child_tree;
#line 1156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp23_ = tmp_iter;
#line 1156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_store_insert_after (_tmp22_, &_tmp24_, NULL, &_tmp23_);
#line 1156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dest_iter = _tmp24_;
#line 1157 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			retval = TRUE;
#line 6006 "SourceList.c"
		}
	}
#line 1162 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (retval) {
#line 6011 "SourceList.c"
		GtkTreeIter _tmp25_;
		GtkTreeIter _tmp26_;
		GraniteWidgetsSourceListPatchItem* item = NULL;
		GtkTreeStore* _tmp27_;
		GtkTreeIter _tmp28_;
		GraniteWidgetsSourceListPatchItem* _tmp29_ = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp30_;
		GraniteWidgetsSourceListPatchItem* _tmp31_;
		GraniteWidgetsSourceListPatchSortable* parent = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp32_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp33_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp34_;
		GraniteWidgetsSourceListPatchSortable* _tmp35_;
		GraniteWidgetsSourceListPatchSortable* _tmp36_;
		GraniteWidgetsSourceListPatchSortable* _tmp37_;
		GraniteWidgetsSourceListPatchItem* _tmp38_;
#line 1163 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp25_ = src_iter;
#line 1163 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp26_ = dest_iter;
#line 1163 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_recursive_node_copy (self, &_tmp25_, &_tmp26_);
#line 1167 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp27_ = self->priv->child_tree;
#line 1167 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp28_ = src_iter;
#line 1167 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp27_, &_tmp28_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp29_, -1, -1);
#line 1167 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (item);
#line 1167 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item = _tmp29_;
#line 1168 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp30_ = item;
#line 1168 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_val_if_fail (_tmp30_ != NULL, retval);
#line 1177 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp31_ = item;
#line 1177 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_update_item (self, _tmp31_);
#line 1179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp32_ = item;
#line 1179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp33_ = granite_widgets_source_list_patch_item_get_parent (_tmp32_);
#line 1179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp34_ = _tmp33_;
#line 1179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp35_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_SORTABLE (_tmp34_) ? ((GraniteWidgetsSourceListPatchSortable*) _tmp34_) : NULL);
#line 1179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		parent = _tmp35_;
#line 1180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp36_ = parent;
#line 1180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_val_if_fail (_tmp36_ != NULL, retval);
#line 1182 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp37_ = parent;
#line 1182 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp38_ = item;
#line 1182 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (_tmp37_, granite_widgets_source_list_patch_sortable_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_SORTABLE_USER_MOVED_ITEM_SIGNAL], 0, _tmp38_);
#line 1162 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1162 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (item);
#line 6076 "SourceList.c"
	}
#line 1185 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = retval;
#line 1185 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (prev);
#line 1185 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 6084 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_recursive_node_copy (GraniteWidgetsSourceListPatchDataModel* self,
                                                                  GtkTreeIter* src_iter,
                                                                  GtkTreeIter* dest_iter)
{
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter child = {0};
	GtkTreeStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
#line 1188 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1188 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (src_iter != NULL);
#line 1188 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (dest_iter != NULL);
#line 1189 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = *src_iter;
#line 1189 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *dest_iter;
#line 1189 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_move_item (self, &_tmp0_, &_tmp1_);
#line 1192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->child_tree;
#line 1192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = *src_iter;
#line 1192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = gtk_tree_model_iter_children ((GtkTreeModel*) _tmp2_, &_tmp4_, &_tmp3_);
#line 1192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child = _tmp4_;
#line 1192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp5_) {
#line 6121 "SourceList.c"
		{
			gboolean _tmp6_ = FALSE;
#line 1195 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = TRUE;
#line 1195 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			while (TRUE) {
#line 6128 "SourceList.c"
				GtkTreeIter copy = {0};
				GtkTreeStore* _tmp9_;
				GtkTreeIter _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				GtkTreeIter _tmp12_;
				GtkTreeIter _tmp13_;
#line 1195 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (!_tmp6_) {
#line 6137 "SourceList.c"
					GtkTreeStore* _tmp7_;
					gboolean _tmp8_;
#line 1199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp7_ = self->priv->child_tree;
#line 1199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &child);
#line 1199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (!_tmp8_) {
#line 1199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						break;
#line 6148 "SourceList.c"
					}
				}
#line 1195 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp6_ = FALSE;
#line 1197 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp9_ = self->priv->child_tree;
#line 1197 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = *dest_iter;
#line 1197 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_tree_store_append (_tmp9_, &_tmp11_, &_tmp10_);
#line 1197 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				copy = _tmp11_;
#line 1198 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp12_ = child;
#line 1198 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp13_ = copy;
#line 1198 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_data_model_recursive_node_copy (self, &_tmp12_, &_tmp13_);
#line 6167 "SourceList.c"
			}
		}
	}
}

static void
granite_widgets_source_list_patch_data_model_move_item (GraniteWidgetsSourceListPatchDataModel* self,
                                                        GtkTreeIter* src_iter,
                                                        GtkTreeIter* dest_iter)
{
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_ = NULL;
	GtkTreeStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GeeHashMap* _tmp5_;
	GtkTreeStore* _tmp6_;
	GtkTreeIter _tmp7_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp8_;
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* _tmp9_;
#line 1203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (src_iter != NULL);
#line 1203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (dest_iter != NULL);
#line 1205 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->child_tree;
#line 1205 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *src_iter;
#line 1205 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, &_tmp2_, -1, -1);
#line 1205 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 1205 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp2_;
#line 1206 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 1209 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = self->priv->child_tree;
#line 1209 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = *dest_iter;
#line 1209 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_store_set (_tmp3_, &_tmp4_, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM, item, -1, -1);
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = self->priv->items;
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = self->priv->child_tree;
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = *dest_iter;
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = granite_widgets_source_list_patch_data_model_node_wrapper_new ((GtkTreeModel*) _tmp6_, &_tmp7_);
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = _tmp8_;
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, item, _tmp9_);
#line 1210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch_data_model_node_wrapper_unref0 (_tmp9_);
#line 1203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 6229 "SourceList.c"
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (length > 0) {
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _vala_memdup2 (self, length * sizeof (gint));
#line 6240 "SourceList.c"
	}
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 6244 "SourceList.c"
}

static gint*
_vala_array_dup2 (gint* self,
                  gssize length)
{
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (length > 0) {
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return _vala_memdup2 (self, length * sizeof (gint));
#line 6255 "SourceList.c"
	}
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 6259 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_real_row_drop_possible (GtkTreeDragDest* base,
                                                                     GtkTreePath* dest,
                                                                     GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	GtkTreeModel* model = NULL;
	GtkTreePath* src_path = NULL;
	gboolean _tmp0_ = FALSE;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	gboolean _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreePath* child_dest = NULL;
	GtkTreePath* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GtkTreePath* _tmp9_;
	gint src_depth = 0;
	GtkTreePath* _tmp12_;
	gint dest_depth = 0;
	GtkTreePath* _tmp13_;
	GraniteWidgetsSourceListPatchItem* parent = NULL;
	GraniteWidgetsSourceListPatchSortable* sortable = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp35_;
	GraniteWidgetsSourceListPatchSortable* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GraniteWidgetsSourceListPatchSortable* _tmp38_;
	GraniteWidgetsSourceListPatchItem* dest_item = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp40_;
	GraniteWidgetsSourceListPatchItem* _tmp41_;
	GraniteWidgetsSourceListPatchItem* source_item = NULL;
	GtkTreePath* filter_src_path = NULL;
	GtkTreePath* _tmp42_;
	GtkTreePath* _tmp43_;
	GtkTreePath* _tmp44_;
	GraniteWidgetsSourceListPatchItem* _tmp47_;
	GraniteWidgetsSourceListPatchSortable* _tmp48_;
	GraniteWidgetsSourceListPatchItem* _tmp49_;
	GraniteWidgetsSourceListPatchItem* _tmp50_;
	gboolean result;
#line 1213 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModel*) base;
#line 1213 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (dest != NULL, FALSE);
#line 1213 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (selection_data != NULL, FALSE);
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gtk_tree_get_row_drag_data (selection_data, &_tmp1_, &_tmp2_);
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (model);
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = _g_object_ref0 (_tmp1_);
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	model = _tmp4_;
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (src_path);
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	src_path = _tmp2_;
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!_tmp3_) {
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = TRUE;
#line 6324 "SourceList.c"
	} else {
		GtkTreeModel* _tmp5_;
		GtkTreeStore* _tmp6_;
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = model;
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = self->priv->child_tree;
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_tree_model_get_type (), GtkTreeModel);
#line 6334 "SourceList.c"
	}
#line 1220 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 1221 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1221 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1221 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1221 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6346 "SourceList.c"
	}
#line 1224 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = gtk_tree_model_filter_convert_path_to_child_path ((GtkTreeModelFilter*) self, dest);
#line 1224 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	child_dest = _tmp7_;
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = child_dest;
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp9_ == NULL) {
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = TRUE;
#line 6358 "SourceList.c"
	} else {
		GtkTreePath* _tmp10_;
		GtkTreePath* _tmp11_;
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = src_path;
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = child_dest;
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = gtk_tree_path_compare (_tmp10_, _tmp11_) == 0;
#line 6368 "SourceList.c"
	}
#line 1227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp8_) {
#line 1228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6382 "SourceList.c"
	}
#line 1232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = src_path;
#line 1232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	src_depth = gtk_tree_path_get_depth (_tmp12_);
#line 1233 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp13_ = child_dest;
#line 1233 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	dest_depth = gtk_tree_path_get_depth (_tmp13_);
#line 1235 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (src_depth != dest_depth) {
#line 1236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6404 "SourceList.c"
	}
#line 1239 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (src_depth < 1) {
#line 1240 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1240 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1240 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1240 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1240 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6418 "SourceList.c"
	}
#line 1242 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent = NULL;
#line 1247 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (src_depth == 1) {
#line 6424 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp14_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp15_;
		GraniteWidgetsSourceListPatchItem* _tmp16_;
#line 1248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = granite_widgets_source_list_patch_data_model_get_root (self);
#line 1248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = _tmp14_;
#line 1248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp16_ = _g_object_ref0 ((GraniteWidgetsSourceListPatchItem*) _tmp15_);
#line 1248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		parent = _tmp16_;
#line 6438 "SourceList.c"
	} else {
		gint* src_indices = NULL;
		GtkTreePath* _tmp17_;
		gint _tmp18_ = 0;
		gint* _tmp19_;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint src_indices_length1;
		gint _src_indices_size_;
		gint* dest_indices = NULL;
		GtkTreePath* _tmp21_;
		gint _tmp22_ = 0;
		gint* _tmp23_;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint dest_indices_length1;
		gint _dest_indices_size_;
		gint src_parent_index = 0;
		gint* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint dest_parent_index = 0;
		gint* _tmp27_;
		gint _tmp27__length1;
		gint _tmp28_;
		GtkTreePath* dest_parent = NULL;
		GtkTreePath* _tmp29_;
		gboolean _tmp30_ = FALSE;
		GtkTreePath* _tmp31_;
		GtkTreePath* _tmp33_;
		GraniteWidgetsSourceListPatchItem* _tmp34_;
#line 1251 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_vala_assert (dest_depth > 1, "dest_depth > 1");
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = src_path;
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp19_ = gtk_tree_path_get_indices_with_depth (_tmp17_, &_tmp18_);
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup1 (_tmp19_, _tmp18_) : _tmp19_;
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20__length1 = _tmp18_;
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		src_indices = _tmp20_;
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		src_indices_length1 = _tmp20__length1;
#line 1257 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_src_indices_size_ = src_indices_length1;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp21_ = child_dest;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp23_ = gtk_tree_path_get_indices_with_depth (_tmp21_, &_tmp22_);
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup2 (_tmp23_, _tmp22_) : _tmp23_;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp24__length1 = _tmp22_;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_indices = _tmp24_;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_indices_length1 = _tmp24__length1;
#line 1258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_dest_indices_size_ = dest_indices_length1;
#line 1261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp25_ = src_indices;
#line 1261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp25__length1 = src_indices_length1;
#line 1261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp26_ = _tmp25_[src_depth - 2];
#line 1261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		src_parent_index = _tmp26_;
#line 1262 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp27_ = dest_indices;
#line 1262 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp27__length1 = dest_indices_length1;
#line 1262 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp28_ = _tmp27_[dest_depth - 2];
#line 1262 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_parent_index = _tmp28_;
#line 1264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (src_parent_index != dest_parent_index) {
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = FALSE;
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dest_indices = (g_free (dest_indices), NULL);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			src_indices = (g_free (src_indices), NULL);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (parent);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (child_dest);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (src_path);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (model);
#line 1265 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 6534 "SourceList.c"
		}
#line 1268 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp29_ = __vala_GtkTreePath_copy0 (dest);
#line 1268 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_parent = _tmp29_;
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp31_ = dest_parent;
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (!gtk_tree_path_up (_tmp31_)) {
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp30_ = TRUE;
#line 6546 "SourceList.c"
		} else {
			GtkTreePath* _tmp32_;
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp32_ = dest_parent;
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp30_ = gtk_tree_path_get_depth (_tmp32_) < 1;
#line 6553 "SourceList.c"
		}
#line 1270 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp30_) {
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = FALSE;
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (dest_parent);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dest_indices = (g_free (dest_indices), NULL);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			src_indices = (g_free (src_indices), NULL);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (parent);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (child_dest);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (src_path);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (model);
#line 1271 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 6575 "SourceList.c"
		}
#line 1273 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp33_ = dest_parent;
#line 1273 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp34_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, _tmp33_);
#line 1273 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1273 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		parent = _tmp34_;
#line 1247 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (dest_parent);
#line 1247 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_indices = (g_free (dest_indices), NULL);
#line 1247 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		src_indices = (g_free (src_indices), NULL);
#line 6591 "SourceList.c"
	}
#line 1276 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp35_ = parent;
#line 1276 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp36_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_SORTABLE (_tmp35_) ? ((GraniteWidgetsSourceListPatchSortable*) _tmp35_) : NULL);
#line 1276 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	sortable = _tmp36_;
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp38_ = sortable;
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp38_ == NULL) {
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp37_ = TRUE;
#line 6605 "SourceList.c"
	} else {
		GraniteWidgetsSourceListPatchSortable* _tmp39_;
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp39_ = sortable;
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp37_ = !granite_widgets_source_list_patch_sortable_allow_dnd_sorting (_tmp39_);
#line 6612 "SourceList.c"
	}
#line 1278 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp37_) {
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (sortable);
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1279 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6630 "SourceList.c"
	}
#line 1281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp40_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, dest);
#line 1281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	dest_item = _tmp40_;
#line 1283 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp41_ = dest_item;
#line 1283 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp41_ == NULL) {
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = TRUE;
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (dest_item);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (sortable);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6656 "SourceList.c"
	}
#line 1286 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	source_item = NULL;
#line 1287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp42_ = src_path;
#line 1287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp43_ = gtk_tree_model_filter_convert_child_path_to_path ((GtkTreeModelFilter*) self, _tmp42_);
#line 1287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	filter_src_path = _tmp43_;
#line 1289 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp44_ = filter_src_path;
#line 1289 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp44_ != NULL) {
#line 6670 "SourceList.c"
		GtkTreePath* _tmp45_;
		GraniteWidgetsSourceListPatchItem* _tmp46_;
#line 1290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp45_ = filter_src_path;
#line 1290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp46_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, _tmp45_);
#line 1290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (source_item);
#line 1290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		source_item = _tmp46_;
#line 6681 "SourceList.c"
	}
#line 1292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp47_ = source_item;
#line 1292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp47_ == NULL) {
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (filter_src_path);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (source_item);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (dest_item);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (sortable);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6707 "SourceList.c"
	}
#line 1301 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp48_ = sortable;
#line 1301 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp49_ = dest_item;
#line 1301 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp50_ = source_item;
#line 1301 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (granite_widgets_source_list_patch_sortable_compare (_tmp48_, _tmp49_, _tmp50_) >= 0) {
#line 6717 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* dest_item_prev = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp51_;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		GraniteWidgetsSourceListPatchItem* _tmp54_;
#line 1302 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (!gtk_tree_path_prev (dest)) {
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = TRUE;
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (filter_src_path);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (source_item);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (dest_item);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (sortable);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (parent);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (child_dest);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (src_path);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (model);
#line 1303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 6745 "SourceList.c"
		}
#line 1307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp51_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, dest);
#line 1307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_item_prev = _tmp51_;
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp54_ = dest_item_prev;
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp54_ != NULL) {
#line 6755 "SourceList.c"
			GraniteWidgetsSourceListPatchItem* _tmp55_;
			GraniteWidgetsSourceListPatchItem* _tmp56_;
#line 1310 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp55_ = dest_item_prev;
#line 1310 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp56_ = source_item;
#line 1310 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp53_ = _tmp55_ != _tmp56_;
#line 6764 "SourceList.c"
		} else {
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp53_ = FALSE;
#line 6768 "SourceList.c"
		}
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp53_) {
#line 6772 "SourceList.c"
			GraniteWidgetsSourceListPatchSortable* _tmp57_;
			GraniteWidgetsSourceListPatchItem* _tmp58_;
			GraniteWidgetsSourceListPatchItem* _tmp59_;
#line 1311 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp57_ = sortable;
#line 1311 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp58_ = dest_item_prev;
#line 1311 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp59_ = source_item;
#line 1311 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp52_ = granite_widgets_source_list_patch_sortable_compare (_tmp57_, _tmp58_, _tmp59_) <= 0;
#line 6784 "SourceList.c"
		} else {
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp52_ = FALSE;
#line 6788 "SourceList.c"
		}
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = _tmp52_;
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (dest_item_prev);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (filter_src_path);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (source_item);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (dest_item);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (sortable);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (parent);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (child_dest);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (src_path);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6812 "SourceList.c"
	}
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (filter_src_path);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (source_item);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (dest_item);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (sortable);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (parent);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (child_dest);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (src_path);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (model);
#line 1314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 6834 "SourceList.c"
}

/**
             * Override default implementation of TreeDragSource
             *
             * drag_data_delete is not overriden because the default implementation
             * does exactly what we need.
             */
static gboolean
granite_widgets_source_list_patch_data_model_real_drag_data_get (GtkTreeDragSource* base,
                                                                 GtkTreePath* path,
                                                                 GtkSelectionData* selection_data)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	GraniteWidgetsSourceListPatchDragSource* drag_source_item = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchDragSource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GraniteWidgetsSourceListPatchDragSource* _tmp3_;
	gboolean result;
#line 1324 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModel*) base;
#line 1324 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 1324 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (selection_data != NULL, FALSE);
#line 1327 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (gtk_selection_data_get_target (selection_data) == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
#line 1328 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_parent_iface->drag_data_get ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path, selection_data);
#line 1328 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6867 "SourceList.c"
	}
#line 1331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, path);
#line 1331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_SOURCE (_tmp0_) ? ((GraniteWidgetsSourceListPatchDragSource*) _tmp0_) : NULL;
#line 1331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ == NULL) {
#line 1331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp0_);
#line 6877 "SourceList.c"
	}
#line 1331 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	drag_source_item = _tmp1_;
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = drag_source_item;
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ != NULL) {
#line 6885 "SourceList.c"
		GraniteWidgetsSourceListPatchDragSource* _tmp4_;
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = drag_source_item;
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_drag_source_draggable (_tmp4_);
#line 6891 "SourceList.c"
	} else {
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = FALSE;
#line 6895 "SourceList.c"
	}
#line 1332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_) {
#line 6899 "SourceList.c"
		GraniteWidgetsSourceListPatchDragSource* _tmp5_;
#line 1333 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = drag_source_item;
#line 1333 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_drag_source_prepare_selection_data (_tmp5_, selection_data);
#line 1334 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = TRUE;
#line 1334 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (drag_source_item);
#line 1334 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6911 "SourceList.c"
	}
#line 1337 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 1337 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (drag_source_item);
#line 1337 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 6919 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_real_row_draggable (GtkTreeDragSource* base,
                                                                 GtkTreePath* path)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
	gboolean result;
#line 1340 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModel*) base;
#line 1340 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 1341 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_parent_iface->row_draggable ((GtkTreeDragSource*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_model_filter_get_type (), GtkTreeModelFilter), path)) {
#line 1342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 6941 "SourceList.c"
	}
#line 1344 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_get_item_from_path (self, path);
#line 1344 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp0_;
#line 1346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = item;
#line 1346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 6951 "SourceList.c"
		GraniteWidgetsSourceListPatchSortable* sortable_item = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp2_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp4_;
		GraniteWidgetsSourceListPatchSortable* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GraniteWidgetsSourceListPatchSortable* _tmp7_;
		GraniteWidgetsSourceListPatchDragSource* drag_source_item = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp9_;
		GraniteWidgetsSourceListPatchDragSource* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GraniteWidgetsSourceListPatchDragSource* _tmp12_;
#line 1348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = item;
#line 1348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = granite_widgets_source_list_patch_item_get_parent (_tmp2_);
#line 1348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _tmp3_;
#line 1348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_SORTABLE (_tmp4_) ? ((GraniteWidgetsSourceListPatchSortable*) _tmp4_) : NULL);
#line 1348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		sortable_item = _tmp5_;
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = sortable_item;
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp7_ != NULL) {
#line 6978 "SourceList.c"
			GraniteWidgetsSourceListPatchSortable* _tmp8_;
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = sortable_item;
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = granite_widgets_source_list_patch_sortable_allow_dnd_sorting (_tmp8_);
#line 6984 "SourceList.c"
		} else {
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = FALSE;
#line 6988 "SourceList.c"
		}
#line 1350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp6_) {
#line 1351 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = TRUE;
#line 1351 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (sortable_item);
#line 1351 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (item);
#line 1351 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 7000 "SourceList.c"
		}
#line 1355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = item;
#line 1355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = _g_object_ref0 (GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_SOURCE (_tmp9_) ? ((GraniteWidgetsSourceListPatchDragSource*) _tmp9_) : NULL);
#line 1355 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		drag_source_item = _tmp10_;
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = drag_source_item;
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp12_ != NULL) {
#line 7012 "SourceList.c"
			GraniteWidgetsSourceListPatchDragSource* _tmp13_;
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = drag_source_item;
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = granite_widgets_source_list_patch_drag_source_draggable (_tmp13_);
#line 7018 "SourceList.c"
		} else {
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = FALSE;
#line 7022 "SourceList.c"
		}
#line 1357 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp11_) {
#line 1358 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = TRUE;
#line 1358 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (drag_source_item);
#line 1358 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (sortable_item);
#line 1358 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (item);
#line 1358 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 7036 "SourceList.c"
		}
#line 1346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (drag_source_item);
#line 1346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (sortable_item);
#line 7042 "SourceList.c"
	}
#line 1361 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 1361 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 1361 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 7050 "SourceList.c"
}

static GraniteWidgetsSourceListPatchExpandableItem*
granite_widgets_source_list_patch_data_model_get_root (GraniteWidgetsSourceListPatchDataModel* self)
{
	GraniteWidgetsSourceListPatchExpandableItem* result;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
#line 730 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 730 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_root;
#line 730 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 730 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 7066 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_set_root (GraniteWidgetsSourceListPatchDataModel* self,
                                                       GraniteWidgetsSourceListPatchExpandableItem* value)
{
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp12_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp13_;
#line 731 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 732 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_root;
#line 732 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_ != NULL) {
#line 7082 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
#line 733 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = self->priv->_root;
#line 733 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_remove_children_monitor (self, _tmp1_);
#line 7088 "SourceList.c"
		{
			GeeIterator* _item_it = NULL;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp2_ = self->priv->_root;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp3_ = granite_widgets_source_list_patch_expandable_item_get_children (_tmp2_);
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp4_ = _tmp3_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = _tmp4_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = _tmp6_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_tmp5_);
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_item_it = _tmp7_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			while (TRUE) {
#line 7115 "SourceList.c"
				GeeIterator* _tmp8_;
				GraniteWidgetsSourceListPatchItem* item = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GraniteWidgetsSourceListPatchItem* _tmp11_;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp8_ = _item_it;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (!gee_iterator_next (_tmp8_)) {
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					break;
#line 7127 "SourceList.c"
				}
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp9_ = _item_it;
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = gee_iterator_get (_tmp9_);
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				item = (GraniteWidgetsSourceListPatchItem*) _tmp10_;
#line 735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = item;
#line 735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_data_model_remove_item (self, _tmp11_);
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (item);
#line 7141 "SourceList.c"
			}
#line 734 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (_item_it);
#line 7145 "SourceList.c"
		}
	}
#line 738 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = _g_object_ref0 (value);
#line 738 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_root);
#line 738 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_root = _tmp12_;
#line 740 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp13_ = self->priv->_root;
#line 740 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_add_children_monitor (self, _tmp13_);
#line 7158 "SourceList.c"
	{
		GeeIterator* _item_it = NULL;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		GeeIterator* _tmp18_;
		GeeIterator* _tmp19_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = self->priv->_root;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = granite_widgets_source_list_patch_expandable_item_get_children (_tmp14_);
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp16_ = _tmp15_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = _tmp16_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp19_ = _tmp18_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp17_);
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_item_it = _tmp19_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		while (TRUE) {
#line 7185 "SourceList.c"
			GeeIterator* _tmp20_;
			GraniteWidgetsSourceListPatchItem* item = NULL;
			GeeIterator* _tmp21_;
			gpointer _tmp22_;
			GraniteWidgetsSourceListPatchItem* _tmp23_;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp20_ = _item_it;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (!gee_iterator_next (_tmp20_)) {
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 7197 "SourceList.c"
			}
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp21_ = _item_it;
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp22_ = gee_iterator_get (_tmp21_);
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			item = (GraniteWidgetsSourceListPatchItem*) _tmp22_;
#line 742 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp23_ = item;
#line 742 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			granite_widgets_source_list_patch_data_model_add_item (self, _tmp23_);
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (item);
#line 7211 "SourceList.c"
		}
#line 741 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_item_it);
#line 7215 "SourceList.c"
	}
#line 731 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY]);
#line 7219 "SourceList.c"
}

static inline gpointer
granite_widgets_source_list_patch_data_model_node_wrapper_get_instance_private (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchDataModelNodeWrapper_private_offset);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
#line 636 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
#line 7233 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModelNodeWrapper*
granite_widgets_source_list_patch_data_model_node_wrapper_construct (GType object_type,
                                                                     GtkTreeModel* model,
                                                                     GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper* self = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeRowReference* _tmp3_;
#line 673 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 673 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 673 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModelNodeWrapper*) g_type_create_instance (object_type);
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = *iter;
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gtk_tree_row_reference_new (model, _tmp2_);
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->row_reference = _tmp3_;
#line 674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (_tmp2_);
#line 673 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 7268 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModelNodeWrapper*
granite_widgets_source_list_patch_data_model_node_wrapper_new (GtkTreeModel* model,
                                                               GtkTreeIter* iter)
{
#line 673 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_data_model_node_wrapper_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, model, iter);
#line 7277 "SourceList.c"
}

static GtkTreeIter*
granite_widgets_source_list_patch_data_model_node_wrapper_get_iter (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self)
{
	GtkTreeIter* result;
	GtkTreeIter* rv = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 642 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 643 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	rv = NULL;
#line 645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_valid (self);
#line 645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 7297 "SourceList.c"
		GtkTreePath* _path = NULL;
		GtkTreePath* _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreePath* _tmp4_;
#line 646 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_path (self);
#line 646 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = _tmp2_;
#line 646 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_path = _tmp3_;
#line 647 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _path;
#line 647 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp4_ != NULL) {
#line 7312 "SourceList.c"
			GtkTreeIter _iter = {0};
			GtkTreeRowReference* _tmp5_;
			GtkTreeModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_;
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = self->priv->row_reference;
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = gtk_tree_row_reference_get_model (_tmp5_);
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = _path;
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = gtk_tree_model_get_iter (_tmp6_, &_tmp8_, _tmp7_);
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_iter = _tmp8_;
#line 649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp9_) {
#line 7331 "SourceList.c"
				GtkTreeIter _tmp10_;
				GtkTreeIter* _tmp11_;
#line 650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = _iter;
#line 650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
#line 650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreeIter_free0 (rv);
#line 650 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				rv = _tmp11_;
#line 7342 "SourceList.c"
			}
		}
#line 645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (_path);
#line 7347 "SourceList.c"
	}
#line 654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = rv;
#line 654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 7353 "SourceList.c"
}

static GtkTreePath*
granite_widgets_source_list_patch_data_model_node_wrapper_get_path (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self)
{
	GtkTreePath* result;
	GtkTreePath* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_node_wrapper_get_valid (self);
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_) {
#line 7371 "SourceList.c"
		GtkTreeRowReference* _tmp3_;
		GtkTreePath* _tmp4_;
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = self->priv->row_reference;
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (_tmp0_);
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp4_;
#line 7382 "SourceList.c"
	} else {
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (_tmp0_);
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = NULL;
#line 7388 "SourceList.c"
	}
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 662 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 7394 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_data_model_node_wrapper_get_valid (GraniteWidgetsSourceListPatchDataModelNodeWrapper* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GtkTreeRowReference* _tmp1_;
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->row_reference;
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 7409 "SourceList.c"
		GtkTreeRowReference* _tmp2_;
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = self->priv->row_reference;
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = gtk_tree_row_reference_valid (_tmp2_);
#line 7415 "SourceList.c"
	} else {
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 7419 "SourceList.c"
	}
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 7425 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_node_wrapper_init (GValue* value)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	value->data[0].v_pointer = NULL;
#line 7433 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_node_wrapper_free_value (GValue* value)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (value->data[0].v_pointer) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_node_wrapper_unref (value->data[0].v_pointer);
#line 7443 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_value_node_wrapper_copy_value (const GValue* src_value,
                                                                            GValue* dest_value)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (src_value->data[0].v_pointer) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_value->data[0].v_pointer = granite_widgets_source_list_patch_data_model_node_wrapper_ref (src_value->data[0].v_pointer);
#line 7455 "SourceList.c"
	} else {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7459 "SourceList.c"
	}
}

static gpointer
granite_widgets_source_list_patch_data_model_value_node_wrapper_peek_pointer (const GValue* value)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return value->data[0].v_pointer;
#line 7468 "SourceList.c"
}

static gchar*
granite_widgets_source_list_patch_data_model_value_node_wrapper_collect_value (GValue* value,
                                                                               guint n_collect_values,
                                                                               GTypeCValue* collect_values,
                                                                               guint collect_flags)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (collect_values[0].v_pointer) {
#line 7479 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModelNodeWrapper * object;
		object = collect_values[0].v_pointer;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (object->parent_instance.g_class == NULL) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7486 "SourceList.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7490 "SourceList.c"
		}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = granite_widgets_source_list_patch_data_model_node_wrapper_ref (object);
#line 7494 "SourceList.c"
	} else {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 7498 "SourceList.c"
	}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 7502 "SourceList.c"
}

static gchar*
granite_widgets_source_list_patch_data_model_value_node_wrapper_lcopy_value (const GValue* value,
                                                                             guint n_collect_values,
                                                                             GTypeCValue* collect_values,
                                                                             guint collect_flags)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!object_p) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7517 "SourceList.c"
	}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!value->data[0].v_pointer) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = NULL;
#line 7523 "SourceList.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = value->data[0].v_pointer;
#line 7527 "SourceList.c"
	} else {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = granite_widgets_source_list_patch_data_model_node_wrapper_ref (value->data[0].v_pointer);
#line 7531 "SourceList.c"
	}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 7535 "SourceList.c"
}

static GParamSpec*
granite_widgets_source_list_patch_data_model_param_spec_node_wrapper (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags)
{
	GraniteWidgetsSourceListPatchDataModelParamSpecNodeWrapper* spec;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return G_PARAM_SPEC (spec);
#line 7554 "SourceList.c"
}

static gpointer
granite_widgets_source_list_patch_data_model_value_get_node_wrapper (const GValue* value)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER), NULL);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return value->data[0].v_pointer;
#line 7564 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_set_node_wrapper (GValue* value,
                                                                     gpointer v_object)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper * old;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old = value->data[0].v_pointer;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (v_object) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = v_object;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_node_wrapper_ref (value->data[0].v_pointer);
#line 7586 "SourceList.c"
	} else {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 7590 "SourceList.c"
	}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_node_wrapper_unref (old);
#line 7596 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_value_take_node_wrapper (GValue* value,
                                                                      gpointer v_object)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper * old;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old = value->data[0].v_pointer;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (v_object) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = v_object;
#line 7617 "SourceList.c"
	} else {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 7621 "SourceList.c"
	}
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_node_wrapper_unref (old);
#line 7627 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_node_wrapper_class_init (GraniteWidgetsSourceListPatchDataModelNodeWrapperClass * klass,
                                                                      gpointer klass_data)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_node_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchDataModelNodeWrapperClass *) klass)->finalize = granite_widgets_source_list_patch_data_model_node_wrapper_finalize;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchDataModelNodeWrapper_private_offset);
#line 7641 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_node_wrapper_instance_init (GraniteWidgetsSourceListPatchDataModelNodeWrapper * self,
                                                                         gpointer klass)
{
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_data_model_node_wrapper_get_instance_private (self);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->ref_count = 1;
#line 7652 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_node_wrapper_finalize (GraniteWidgetsSourceListPatchDataModelNodeWrapper * obj)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper * self;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, GraniteWidgetsSourceListPatchDataModelNodeWrapper);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_destroy (self);
#line 636 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreeRowReference_free0 (self->priv->row_reference);
#line 7665 "SourceList.c"
}

/**
             * An object that references a particular row in a model. This class is a wrapper built around
             * Gtk.TreeRowReference, and exists with the purpose of ensuring we never use invalid tree paths
             * or iters in the model, since most of these errors provoke failures due to GTK+ assertions
             * or, even worse, unexpected behavior.
             */
static GType
granite_widgets_source_list_patch_data_model_node_wrapper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { granite_widgets_source_list_patch_data_model_value_node_wrapper_init, granite_widgets_source_list_patch_data_model_value_node_wrapper_free_value, granite_widgets_source_list_patch_data_model_value_node_wrapper_copy_value, granite_widgets_source_list_patch_data_model_value_node_wrapper_peek_pointer, "p", granite_widgets_source_list_patch_data_model_value_node_wrapper_collect_value, "p", granite_widgets_source_list_patch_data_model_value_node_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchDataModelNodeWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_data_model_node_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchDataModelNodeWrapper), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_data_model_node_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType granite_widgets_source_list_patch_data_model_node_wrapper_type_id;
	granite_widgets_source_list_patch_data_model_node_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GraniteWidgetsSourceListPatchDataModelNodeWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GraniteWidgetsSourceListPatchDataModelNodeWrapper_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_data_model_node_wrapper_type_id, sizeof (GraniteWidgetsSourceListPatchDataModelNodeWrapperPrivate));
	return granite_widgets_source_list_patch_data_model_node_wrapper_type_id;
}

static GType
granite_widgets_source_list_patch_data_model_node_wrapper_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_data_model_node_wrapper_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_data_model_node_wrapper_type_id__once)) {
		GType granite_widgets_source_list_patch_data_model_node_wrapper_type_id;
		granite_widgets_source_list_patch_data_model_node_wrapper_type_id = granite_widgets_source_list_patch_data_model_node_wrapper_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_data_model_node_wrapper_type_id__once, granite_widgets_source_list_patch_data_model_node_wrapper_type_id);
	}
	return granite_widgets_source_list_patch_data_model_node_wrapper_type_id__once;
}

static gpointer
granite_widgets_source_list_patch_data_model_node_wrapper_ref (gpointer instance)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper * self;
	self = instance;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_atomic_int_inc (&self->ref_count);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return instance;
#line 7707 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_node_wrapper_unref (gpointer instance)
{
	GraniteWidgetsSourceListPatchDataModelNodeWrapper * self;
	self = instance;
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_NODE_WRAPPER_GET_CLASS (self)->finalize (self);
#line 631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7721 "SourceList.c"
	}
}

static inline gpointer
granite_widgets_source_list_patch_data_model_item_monitor_get_instance_private (GraniteWidgetsSourceListPatchDataModelItemMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchDataModelItemMonitor_private_offset);
}

static void
_granite_widgets_source_list_patch_data_model_item_monitor_on_notify_g_object_notify (GObject* _sender,
                                                                                      GParamSpec* pspec,
                                                                                      gpointer self)
{
#line 691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_item_monitor_on_notify ((GraniteWidgetsSourceListPatchDataModelItemMonitor*) self, pspec);
#line 7738 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModelItemMonitor*
granite_widgets_source_list_patch_data_model_item_monitor_construct (GType object_type,
                                                                     GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor* self = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
#line 685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchDataModelItemMonitor*) g_type_create_instance (object_type);
#line 686 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (item);
#line 686 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->item);
#line 686 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->item = _tmp0_;
#line 687 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_after ((GObject*) item, "notify", (GCallback) _granite_widgets_source_list_patch_data_model_item_monitor_on_notify_g_object_notify, self);
#line 685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 7761 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModelItemMonitor*
granite_widgets_source_list_patch_data_model_item_monitor_new (GraniteWidgetsSourceListPatchItem* item)
{
#line 685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_data_model_item_monitor_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, item);
#line 7769 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_item_monitor_on_notify (GraniteWidgetsSourceListPatchDataModelItemMonitor* self,
                                                                     GParamSpec* prop)
{
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	const gchar* _tmp1_;
#line 694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (prop != NULL);
#line 695 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->item;
#line 695 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = prop->name;
#line 695 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL], 0, _tmp0_, _tmp1_);
#line 7788 "SourceList.c"
}

static void
g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (n_param_values == 3);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		data1 = closure->data;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		data2 = param_values->data[0].v_pointer;
#line 7813 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		data1 = param_values->data[0].v_pointer;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		data2 = closure->data;
#line 7819 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 7825 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_item_monitor_init (GValue* value)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	value->data[0].v_pointer = NULL;
#line 7833 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_item_monitor_free_value (GValue* value)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (value->data[0].v_pointer) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_item_monitor_unref (value->data[0].v_pointer);
#line 7843 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_value_item_monitor_copy_value (const GValue* src_value,
                                                                            GValue* dest_value)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (src_value->data[0].v_pointer) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_value->data[0].v_pointer = granite_widgets_source_list_patch_data_model_item_monitor_ref (src_value->data[0].v_pointer);
#line 7855 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7859 "SourceList.c"
	}
}

static gpointer
granite_widgets_source_list_patch_data_model_value_item_monitor_peek_pointer (const GValue* value)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return value->data[0].v_pointer;
#line 7868 "SourceList.c"
}

static gchar*
granite_widgets_source_list_patch_data_model_value_item_monitor_collect_value (GValue* value,
                                                                               guint n_collect_values,
                                                                               GTypeCValue* collect_values,
                                                                               guint collect_flags)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (collect_values[0].v_pointer) {
#line 7879 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModelItemMonitor * object;
		object = collect_values[0].v_pointer;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (object->parent_instance.g_class == NULL) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7886 "SourceList.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7890 "SourceList.c"
		}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = granite_widgets_source_list_patch_data_model_item_monitor_ref (object);
#line 7894 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 7898 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 7902 "SourceList.c"
}

static gchar*
granite_widgets_source_list_patch_data_model_value_item_monitor_lcopy_value (const GValue* value,
                                                                             guint n_collect_values,
                                                                             GTypeCValue* collect_values,
                                                                             guint collect_flags)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!object_p) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7917 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!value->data[0].v_pointer) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = NULL;
#line 7923 "SourceList.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = value->data[0].v_pointer;
#line 7927 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*object_p = granite_widgets_source_list_patch_data_model_item_monitor_ref (value->data[0].v_pointer);
#line 7931 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return NULL;
#line 7935 "SourceList.c"
}

static GParamSpec*
granite_widgets_source_list_patch_data_model_param_spec_item_monitor (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags)
{
	GraniteWidgetsSourceListPatchDataModelParamSpecItemMonitor* spec;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return G_PARAM_SPEC (spec);
#line 7954 "SourceList.c"
}

static gpointer
granite_widgets_source_list_patch_data_model_value_get_item_monitor (const GValue* value)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR), NULL);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return value->data[0].v_pointer;
#line 7964 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_value_set_item_monitor (GValue* value,
                                                                     gpointer v_object)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor * old;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old = value->data[0].v_pointer;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (v_object) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = v_object;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_item_monitor_ref (value->data[0].v_pointer);
#line 7986 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 7990 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_item_monitor_unref (old);
#line 7996 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_value_take_item_monitor (GValue* value,
                                                                      gpointer v_object)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor * old;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old = value->data[0].v_pointer;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (v_object) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = v_object;
#line 8017 "SourceList.c"
	} else {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		value->data[0].v_pointer = NULL;
#line 8021 "SourceList.c"
	}
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_item_monitor_unref (old);
#line 8027 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_data_model_item_monitor_class_init (GraniteWidgetsSourceListPatchDataModelItemMonitorClass * klass,
                                                                      gpointer klass_data)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_item_monitor_parent_class = g_type_class_peek_parent (klass);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchDataModelItemMonitorClass *) klass)->finalize = granite_widgets_source_list_patch_data_model_item_monitor_finalize;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchDataModelItemMonitor_private_offset);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_item_monitor_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_CHANGED_SIGNAL] = g_signal_new ("changed", GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_TYPE_STRING);
#line 8043 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_item_monitor_instance_init (GraniteWidgetsSourceListPatchDataModelItemMonitor * self,
                                                                         gpointer klass)
{
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_data_model_item_monitor_get_instance_private (self);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->ref_count = 1;
#line 8054 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_item_monitor_finalize (GraniteWidgetsSourceListPatchDataModelItemMonitor * obj)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor * self;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	guint _tmp1_;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, GraniteWidgetsSourceListPatchDataModelItemMonitor);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_destroy (self);
#line 691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->item;
#line 691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp1_, NULL, FALSE);
#line 691 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_data_model_item_monitor_on_notify_g_object_notify, self);
#line 683 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->item);
#line 8075 "SourceList.c"
}

/**
             * Helper object used to monitor item property changes.
             */
static GType
granite_widgets_source_list_patch_data_model_item_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { granite_widgets_source_list_patch_data_model_value_item_monitor_init, granite_widgets_source_list_patch_data_model_value_item_monitor_free_value, granite_widgets_source_list_patch_data_model_value_item_monitor_copy_value, granite_widgets_source_list_patch_data_model_value_item_monitor_peek_pointer, "p", granite_widgets_source_list_patch_data_model_value_item_monitor_collect_value, "p", granite_widgets_source_list_patch_data_model_value_item_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchDataModelItemMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_data_model_item_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchDataModelItemMonitor), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_data_model_item_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType granite_widgets_source_list_patch_data_model_item_monitor_type_id;
	granite_widgets_source_list_patch_data_model_item_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GraniteWidgetsSourceListPatchDataModelItemMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GraniteWidgetsSourceListPatchDataModelItemMonitor_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_data_model_item_monitor_type_id, sizeof (GraniteWidgetsSourceListPatchDataModelItemMonitorPrivate));
	return granite_widgets_source_list_patch_data_model_item_monitor_type_id;
}

static GType
granite_widgets_source_list_patch_data_model_item_monitor_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_data_model_item_monitor_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_data_model_item_monitor_type_id__once)) {
		GType granite_widgets_source_list_patch_data_model_item_monitor_type_id;
		granite_widgets_source_list_patch_data_model_item_monitor_type_id = granite_widgets_source_list_patch_data_model_item_monitor_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_data_model_item_monitor_type_id__once, granite_widgets_source_list_patch_data_model_item_monitor_type_id);
	}
	return granite_widgets_source_list_patch_data_model_item_monitor_type_id__once;
}

static gpointer
granite_widgets_source_list_patch_data_model_item_monitor_ref (gpointer instance)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor * self;
	self = instance;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_atomic_int_inc (&self->ref_count);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return instance;
#line 8114 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_item_monitor_unref (gpointer instance)
{
	GraniteWidgetsSourceListPatchDataModelItemMonitor * self;
	self = instance;
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_MONITOR_GET_CLASS (self)->finalize (self);
#line 681 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8128 "SourceList.c"
	}
}

static gint
_granite_widgets_source_list_patch_data_model_child_model_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                                                GtkTreeIter* a,
                                                                                                GtkTreeIter* b,
                                                                                                gpointer self)
{
	gint result;
	result = granite_widgets_source_list_patch_data_model_child_model_sort_func ((GraniteWidgetsSourceListPatchDataModel*) self, model, a, b);
#line 765 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 8142 "SourceList.c"
}

static gboolean
_granite_widgets_source_list_patch_data_model_filter_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                                      GtkTreeIter* iter,
                                                                                                      gpointer self)
{
	gboolean result;
	result = granite_widgets_source_list_patch_data_model_filter_visible_func ((GraniteWidgetsSourceListPatchDataModel*) self, model, iter);
#line 768 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 8154 "SourceList.c"
}

static GObject *
granite_widgets_source_list_patch_data_model_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListPatchDataModel * self;
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	GtkTreeStore* _tmp2_;
#line 760 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_patch_data_model_parent_class);
#line 760 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 760 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModel);
#line 761 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_tree_store_new ((gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_N_COLUMNS, granite_widgets_source_list_patch_data_model_column_type (GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_COLUMN_ITEM));
#line 761 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->child_tree);
#line 761 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->child_tree = _tmp0_;
#line 762 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->child_tree;
#line 762 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkTreeModelFilter*) self, "child-model", (GtkTreeModel*) _tmp1_, NULL);
#line 763 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkTreeModelFilter*) self, "virtual-root", NULL, NULL);
#line 765 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->child_tree;
#line 765 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) _tmp2_, _granite_widgets_source_list_patch_data_model_child_model_sort_func_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
#line 766 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_resort (self);
#line 768 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_model_filter_set_visible_func ((GtkTreeModelFilter*) self, _granite_widgets_source_list_patch_data_model_filter_visible_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
#line 760 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return obj;
#line 8196 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_class_init (GraniteWidgetsSourceListPatchDataModelClass * klass,
                                                         gpointer klass_data)
{
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_parent_class = g_type_class_peek_parent (klass);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchDataModel_private_offset);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_data_model_get_property;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_data_model_set_property;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_patch_data_model_constructor;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_data_model_finalize;
#line 8215 "SourceList.c"
	/**
	             * Root item.
	             *
	             * This item is not actually part of the model. It's only used as a proxy
	             * for adding and removing items.
	             */
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY, granite_widgets_source_list_patch_data_model_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ITEM_UPDATED_SIGNAL] = g_signal_new ("item-updated", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 8226 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_interface_init (GtkTreeDragSourceIface * iface,
                                                                                  gpointer iface_data)
{
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_parent_iface = g_type_interface_peek_parent (iface);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iface->drag_data_get = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_patch_data_model_real_drag_data_get;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iface->row_draggable = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*)) granite_widgets_source_list_patch_data_model_real_row_draggable;
#line 8239 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_gtk_tree_drag_dest_interface_init (GtkTreeDragDestIface * iface,
                                                                                gpointer iface_data)
{
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_data_model_gtk_tree_drag_dest_parent_iface = g_type_interface_peek_parent (iface);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iface->drag_data_received = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_patch_data_model_real_drag_data_received;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iface->row_drop_possible = (gboolean (*) (GtkTreeDragDest*, GtkTreePath*, GtkSelectionData*)) granite_widgets_source_list_patch_data_model_real_row_drop_possible;
#line 8252 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_instance_init (GraniteWidgetsSourceListPatchDataModel * self,
                                                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_data_model_get_instance_private (self);
#line 749 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gee_hash_map_new (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_NODE_WRAPPER, (GBoxedCopyFunc) granite_widgets_source_list_patch_data_model_node_wrapper_ref, (GDestroyNotify) granite_widgets_source_list_patch_data_model_node_wrapper_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 749 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->items = _tmp0_;
#line 751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gee_hash_map_new (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_TYPE_ITEM_MONITOR, (GBoxedCopyFunc) granite_widgets_source_list_patch_data_model_item_monitor_ref, (GDestroyNotify) granite_widgets_source_list_patch_data_model_item_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->monitors = _tmp1_;
#line 8271 "SourceList.c"
}

static void
granite_widgets_source_list_patch_data_model_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatchDataModel * self;
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModel);
#line 721 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_root);
#line 749 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->items);
#line 751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->monitors);
#line 753 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->child_tree);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_data_model_parent_class)->finalize (obj);
#line 8290 "SourceList.c"
}

/**
         * The model backing the SourceListPatch tree.
         *
         * It monitors item property changes, and handles children additions and removals. It also controls
         * the visibility of the items based on their "visible" property, and on their number of children,
         * if they happen to be categories. Its main purpose is to provide an easy and practical interface
         * for sorting, adding, removing and updating items, eliminating the need of repeatedly dealing with
         * the Gtk.TreeModel API directly.
         */
static GType
granite_widgets_source_list_patch_data_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchDataModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_data_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchDataModel), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_data_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_drag_source_info = { (GInterfaceInitFunc) granite_widgets_source_list_patch_data_model_gtk_tree_drag_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_tree_drag_dest_info = { (GInterfaceInitFunc) granite_widgets_source_list_patch_data_model_gtk_tree_drag_dest_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType granite_widgets_source_list_patch_data_model_type_id;
	granite_widgets_source_list_patch_data_model_type_id = g_type_register_static (gtk_tree_model_filter_get_type (), "GraniteWidgetsSourceListPatchDataModel", &g_define_type_info, 0);
	g_type_add_interface_static (granite_widgets_source_list_patch_data_model_type_id, gtk_tree_drag_source_get_type (), &gtk_tree_drag_source_info);
	g_type_add_interface_static (granite_widgets_source_list_patch_data_model_type_id, gtk_tree_drag_dest_get_type (), &gtk_tree_drag_dest_info);
	GraniteWidgetsSourceListPatchDataModel_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_data_model_type_id, sizeof (GraniteWidgetsSourceListPatchDataModelPrivate));
	return granite_widgets_source_list_patch_data_model_type_id;
}

static GType
granite_widgets_source_list_patch_data_model_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_data_model_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_data_model_type_id__once)) {
		GType granite_widgets_source_list_patch_data_model_type_id;
		granite_widgets_source_list_patch_data_model_type_id = granite_widgets_source_list_patch_data_model_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_data_model_type_id__once, granite_widgets_source_list_patch_data_model_type_id);
	}
	return granite_widgets_source_list_patch_data_model_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_data_model_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModel);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY:
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_data_model_get_root (self));
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8344 "SourceList.c"
		default:
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8350 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_data_model_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchDataModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, GraniteWidgetsSourceListPatchDataModel);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_DATA_MODEL_ROOT_PROPERTY:
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_data_model_set_root (self, g_value_get_object (value));
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8370 "SourceList.c"
		default:
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 623 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8376 "SourceList.c"
	}
}

static GraniteWidgetsSourceListPatchCellRendererIcon*
granite_widgets_source_list_patch_cell_renderer_icon_construct (GType object_type)
{
	GraniteWidgetsSourceListPatchCellRendererIcon * self = NULL;
#line 1375 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererIcon*) g_object_new (object_type, NULL);
#line 1375 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 8388 "SourceList.c"
}

static GraniteWidgetsSourceListPatchCellRendererIcon*
granite_widgets_source_list_patch_cell_renderer_icon_new (void)
{
#line 1375 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_cell_renderer_icon_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON);
#line 8396 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_cell_renderer_icon_real_activate (GtkCellRenderer* base,
                                                                    GdkEvent* event,
                                                                    GtkWidget* widget,
                                                                    const gchar* path,
                                                                    GdkRectangle* background_area,
                                                                    GdkRectangle* cell_area,
                                                                    GtkCellRendererState flags)
{
	GraniteWidgetsSourceListPatchCellRendererIcon * self;
	gboolean result;
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererIcon*) base;
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (background_area != NULL, FALSE);
#line 1384 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (cell_area != NULL, FALSE);
#line 1388 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_ACTIVATED_SIGNAL], 0, path);
#line 1389 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = TRUE;
#line 1389 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 8428 "SourceList.c"
}

static GObject *
granite_widgets_source_list_patch_cell_renderer_icon_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListPatchCellRendererIcon * self;
#line 1379 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_patch_cell_renderer_icon_parent_class);
#line 1379 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 1379 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON, GraniteWidgetsSourceListPatchCellRendererIcon);
#line 1380 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) self, "mode", GTK_CELL_RENDERER_MODE_ACTIVATABLE, NULL);
#line 1381 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRendererPixbuf*) self, "stock-size", (guint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_ICON_SIZE, NULL);
#line 1379 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return obj;
#line 8451 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_icon_class_init (GraniteWidgetsSourceListPatchCellRendererIconClass * klass,
                                                                 gpointer klass_data)
{
#line 1370 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_cell_renderer_icon_parent_class = g_type_class_peek_parent (klass);
#line 1370 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->activate = (gboolean (*) (GtkCellRenderer*, GdkEvent*, GtkWidget*, const gchar*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) granite_widgets_source_list_patch_cell_renderer_icon_real_activate;
#line 1370 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_patch_cell_renderer_icon_constructor;
#line 1370 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_cell_renderer_icon_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_ICON_ACTIVATED_SIGNAL] = g_signal_new ("activated", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 8466 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_icon_instance_init (GraniteWidgetsSourceListPatchCellRendererIcon * self,
                                                                    gpointer klass)
{
}

/**
         * Class responsible for rendering Item.icon and Item.activatable. It also
         * notifies about clicks through the activated() signal.
         */
static GType
granite_widgets_source_list_patch_cell_renderer_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchCellRendererIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_cell_renderer_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchCellRendererIcon), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_cell_renderer_icon_instance_init, NULL };
	GType granite_widgets_source_list_patch_cell_renderer_icon_type_id;
	granite_widgets_source_list_patch_cell_renderer_icon_type_id = g_type_register_static (gtk_cell_renderer_pixbuf_get_type (), "GraniteWidgetsSourceListPatchCellRendererIcon", &g_define_type_info, 0);
	return granite_widgets_source_list_patch_cell_renderer_icon_type_id;
}

static GType
granite_widgets_source_list_patch_cell_renderer_icon_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_cell_renderer_icon_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_cell_renderer_icon_type_id__once)) {
		GType granite_widgets_source_list_patch_cell_renderer_icon_type_id;
		granite_widgets_source_list_patch_cell_renderer_icon_type_id = granite_widgets_source_list_patch_cell_renderer_icon_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_cell_renderer_icon_type_id__once, granite_widgets_source_list_patch_cell_renderer_icon_type_id);
	}
	return granite_widgets_source_list_patch_cell_renderer_icon_type_id__once;
}

static inline gpointer
granite_widgets_source_list_patch_cell_renderer_spacer_get_instance_private (GraniteWidgetsSourceListPatchCellRendererSpacer* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchCellRendererSpacer_private_offset);
}

static GtkSizeRequestMode
granite_widgets_source_list_patch_cell_renderer_spacer_real_get_request_mode (GtkCellRenderer* base)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	GtkSizeRequestMode result;
#line 1404 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) base;
#line 1405 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
#line 1405 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 8517 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_width (GtkCellRenderer* base,
                                                                                 GtkWidget* widget,
                                                                                 gint* min_size,
                                                                                 gint* natural_size)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	gint _vala_min_size = 0;
	gint _vala_natural_size = 0;
	guint _tmp0_;
	guint _tmp1_;
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) base;
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (widget != NULL);
#line 1409 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_get ((GtkCellRenderer*) self, "xpad", &_tmp0_, NULL);
#line 1409 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1409 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_natural_size = 2 * ((gint) _tmp1_);
#line 1409 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_min_size = _vala_natural_size;
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (min_size) {
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*min_size = _vala_min_size;
#line 8547 "SourceList.c"
	}
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (natural_size) {
#line 1408 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*natural_size = _vala_natural_size;
#line 8553 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                                            GtkWidget* widget,
                                                                                            gint width,
                                                                                            gint* min_height,
                                                                                            gint* natural_height)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	gint _vala_min_height = 0;
	gint _vala_natural_height = 0;
	guint _tmp0_;
	guint _tmp1_;
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) base;
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (widget != NULL);
#line 1415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_get ((GtkCellRenderer*) self, "ypad", &_tmp0_, NULL);
#line 1415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_natural_height = 2 * ((gint) _tmp1_);
#line 1415 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_min_height = _vala_natural_height;
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (min_height) {
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*min_height = _vala_min_height;
#line 8585 "SourceList.c"
	}
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (natural_height) {
#line 1412 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*natural_height = _vala_natural_height;
#line 8591 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_real_render (GtkCellRenderer* base,
                                                                    cairo_t* context,
                                                                    GtkWidget* widget,
                                                                    GdkRectangle* bg_area,
                                                                    GdkRectangle* cell_area,
                                                                    GtkCellRendererState flags)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
#line 1418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) base;
#line 1418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (context != NULL);
#line 1418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (widget != NULL);
#line 1418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (bg_area != NULL);
#line 1418 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (cell_area != NULL);
#line 8614 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_real_get_size (GtkCellRenderer* base,
                                                                      GtkWidget* widget,
                                                                      GdkRectangle* cell_area,
                                                                      gint* x_offset,
                                                                      gint* y_offset,
                                                                      gint* width,
                                                                      gint* height)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
#line 1425 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) base;
#line 1425 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (widget != NULL);
#line 1429 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_assert_not_reached ();
#line 8637 "SourceList.c"
}

static GraniteWidgetsSourceListPatchCellRendererSpacer*
granite_widgets_source_list_patch_cell_renderer_spacer_construct (GType object_type)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self = NULL;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchCellRendererSpacer*) g_object_new (object_type, NULL);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 8648 "SourceList.c"
}

static GraniteWidgetsSourceListPatchCellRendererSpacer*
granite_widgets_source_list_patch_cell_renderer_spacer_new (void)
{
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_cell_renderer_spacer_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER);
#line 8656 "SourceList.c"
}

static gint
granite_widgets_source_list_patch_cell_renderer_spacer_get_level (GraniteWidgetsSourceListPatchCellRendererSpacer* self)
{
	gint result;
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = self->priv->_level;
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 8669 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_set_level (GraniteWidgetsSourceListPatchCellRendererSpacer* self,
                                                                  gint value)
{
	gint old_value;
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_cell_renderer_spacer_get_level (self);
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_level = value;
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY]);
#line 8687 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_class_init (GraniteWidgetsSourceListPatchCellRendererSpacerClass * klass,
                                                                   gpointer klass_data)
{
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_cell_renderer_spacer_parent_class = g_type_class_peek_parent (klass);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchCellRendererSpacer_private_offset);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkCellRenderer*)) granite_widgets_source_list_patch_cell_renderer_spacer_real_get_request_mode;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_width;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) granite_widgets_source_list_patch_cell_renderer_spacer_real_get_preferred_height_for_width;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) granite_widgets_source_list_patch_cell_renderer_spacer_real_render;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) granite_widgets_source_list_patch_cell_renderer_spacer_real_get_size;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_cell_renderer_spacer_get_property;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_cell_renderer_spacer_set_property;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_cell_renderer_spacer_finalize;
#line 8715 "SourceList.c"
	/**
	             * Indentation level represented by this cell renderer
	             */
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY, granite_widgets_source_list_patch_cell_renderer_spacer_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY] = g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 8721 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_instance_init (GraniteWidgetsSourceListPatchCellRendererSpacer * self,
                                                                      gpointer klass)
{
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_cell_renderer_spacer_get_instance_private (self);
#line 1402 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->_level = -1;
#line 8732 "SourceList.c"
}

static void
granite_widgets_source_list_patch_cell_renderer_spacer_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacer);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_cell_renderer_spacer_parent_class)->finalize (obj);
#line 8743 "SourceList.c"
}

/**
         * A cell renderer that only adds space.
         */
static GType
granite_widgets_source_list_patch_cell_renderer_spacer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchCellRendererSpacerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_cell_renderer_spacer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchCellRendererSpacer), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_cell_renderer_spacer_instance_init, NULL };
	GType granite_widgets_source_list_patch_cell_renderer_spacer_type_id;
	granite_widgets_source_list_patch_cell_renderer_spacer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "GraniteWidgetsSourceListPatchCellRendererSpacer", &g_define_type_info, 0);
	GraniteWidgetsSourceListPatchCellRendererSpacer_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_cell_renderer_spacer_type_id, sizeof (GraniteWidgetsSourceListPatchCellRendererSpacerPrivate));
	return granite_widgets_source_list_patch_cell_renderer_spacer_type_id;
}

static GType
granite_widgets_source_list_patch_cell_renderer_spacer_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_cell_renderer_spacer_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_cell_renderer_spacer_type_id__once)) {
		GType granite_widgets_source_list_patch_cell_renderer_spacer_type_id;
		granite_widgets_source_list_patch_cell_renderer_spacer_type_id = granite_widgets_source_list_patch_cell_renderer_spacer_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_cell_renderer_spacer_type_id__once, granite_widgets_source_list_patch_cell_renderer_spacer_type_id);
	}
	return granite_widgets_source_list_patch_cell_renderer_spacer_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_cell_renderer_spacer_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacer);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_int (value, granite_widgets_source_list_patch_cell_renderer_spacer_get_level (self));
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8787 "SourceList.c"
		default:
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8793 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_cell_renderer_spacer_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, GraniteWidgetsSourceListPatchCellRendererSpacer);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_CELL_RENDERER_SPACER_LEVEL_PROPERTY:
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_cell_renderer_spacer_set_level (self, g_value_get_int (value));
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8813 "SourceList.c"
		default:
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1398 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 8819 "SourceList.c"
	}
}

static inline gpointer
granite_widgets_source_list_patch_tree_get_instance_private (GraniteWidgetsSourceListPatchTree* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsSourceListPatchTree_private_offset);
}

static GType
granite_widgets_source_list_patch_tree_column_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM, "GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM", "item"}, {GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_N_COLS, "GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_N_COLS", "n-cols"}, {0, NULL, NULL}};
	GType granite_widgets_source_list_patch_tree_column_type_id;
	granite_widgets_source_list_patch_tree_column_type_id = g_enum_register_static ("GraniteWidgetsSourceListPatchTreeColumn", values);
	return granite_widgets_source_list_patch_tree_column_type_id;
}

static GType
granite_widgets_source_list_patch_tree_column_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_tree_column_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_tree_column_type_id__once)) {
		GType granite_widgets_source_list_patch_tree_column_type_id;
		granite_widgets_source_list_patch_tree_column_type_id = granite_widgets_source_list_patch_tree_column_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_tree_column_type_id__once, granite_widgets_source_list_patch_tree_column_type_id);
	}
	return granite_widgets_source_list_patch_tree_column_type_id__once;
}

static GraniteWidgetsSourceListPatchTree*
granite_widgets_source_list_patch_tree_construct (GType object_type,
                                                  GraniteWidgetsSourceListPatchDataModel* data_model)
{
	GraniteWidgetsSourceListPatchTree * self = NULL;
#line 1511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (data_model != NULL, NULL);
#line 1512 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) g_object_new (object_type, "data-model", data_model, NULL);
#line 1511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self;
#line 8861 "SourceList.c"
}

static GraniteWidgetsSourceListPatchTree*
granite_widgets_source_list_patch_tree_new (GraniteWidgetsSourceListPatchDataModel* data_model)
{
#line 1511 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return granite_widgets_source_list_patch_tree_construct (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, data_model);
#line 8869 "SourceList.c"
}

static gpointer
_gtk_target_list_ref0 (gpointer self)
{
#line 1648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return self ? gtk_target_list_ref (self) : NULL;
#line 8877 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_real_drag_motion (GtkWidget* base,
                                                         GdkDragContext* context,
                                                         gint x,
                                                         gint y,
                                                         guint time)
{
	GraniteWidgetsSourceListPatchTree * self;
	GtkTreePath* suggested_path = NULL;
	GtkTreePath* current_path = NULL;
	GtkTreeViewDropPosition suggested_pos = 0;
	GtkTreeViewDropPosition current_pos = 0;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeViewDropPosition _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean result;
#line 1606 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 1606 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 1608 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->drag_motion ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, time)) {
#line 1609 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1609 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 8906 "SourceList.c"
	}
#line 1614 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp0_, &_tmp1_);
#line 1614 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (suggested_path);
#line 1614 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	suggested_path = _tmp0_;
#line 1614 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	suggested_pos = _tmp1_;
#line 1614 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_) {
#line 8918 "SourceList.c"
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewDropPosition _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		GtkTreePath* _tmp6_;
#line 1618 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp3_, &_tmp4_);
#line 1618 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (current_path);
#line 1618 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		current_path = _tmp3_;
#line 1618 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		current_pos = _tmp4_;
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = current_path;
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp6_ != NULL) {
#line 8935 "SourceList.c"
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = suggested_path;
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = current_path;
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = gtk_tree_path_compare (_tmp7_, _tmp8_) == 0;
#line 8944 "SourceList.c"
		} else {
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = FALSE;
#line 8948 "SourceList.c"
		}
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 8952 "SourceList.c"
			GtkWidget* source_widget = NULL;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			gboolean dragging_treemodel_row = FALSE;
			GtkWidget* _tmp11_;
#line 1624 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = gtk_drag_get_source_widget (context);
#line 1624 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = _g_object_ref0 (_tmp9_);
#line 1624 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			source_widget = _tmp10_;
#line 1625 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = source_widget;
#line 1625 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dragging_treemodel_row = _tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget);
#line 1627 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (dragging_treemodel_row) {
#line 1630 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (current_pos != GTK_TREE_VIEW_DROP_BEFORE) {
#line 1631 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (current_pos == GTK_TREE_VIEW_DROP_INTO_OR_BEFORE) {
#line 8974 "SourceList.c"
						GtkTreePath* _tmp12_;
#line 1632 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp12_ = current_path;
#line 1632 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp12_, GTK_TREE_VIEW_DROP_BEFORE);
#line 8980 "SourceList.c"
					} else {
#line 1634 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
#line 8984 "SourceList.c"
					}
				}
			} else {
				GraniteWidgetsSourceListPatchDragDest* dest = NULL;
				GraniteWidgetsSourceListPatchDataModel* _tmp15_;
				GtkTreePath* _tmp16_;
				GraniteWidgetsSourceListPatchItem* _tmp17_;
				GraniteWidgetsSourceListPatchDragDest* _tmp18_;
				GraniteWidgetsSourceListPatchDragDest* _tmp19_;
#line 1639 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (current_pos == GTK_TREE_VIEW_DROP_BEFORE) {
#line 8996 "SourceList.c"
					GtkTreePath* _tmp13_;
#line 1640 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp13_ = current_path;
#line 1640 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp13_, GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
#line 9002 "SourceList.c"
				} else {
#line 1641 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (current_pos == GTK_TREE_VIEW_DROP_AFTER) {
#line 9006 "SourceList.c"
						GtkTreePath* _tmp14_;
#line 1642 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp14_ = current_path;
#line 1642 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, _tmp14_, GTK_TREE_VIEW_DROP_INTO_OR_AFTER);
#line 9012 "SourceList.c"
					}
				}
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp15_ = self->priv->_data_model;
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp16_ = current_path;
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp17_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp15_, _tmp16_);
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp18_ = GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_DEST (_tmp17_) ? ((GraniteWidgetsSourceListPatchDragDest*) _tmp17_) : NULL;
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (_tmp18_ == NULL) {
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_g_object_unref0 (_tmp17_);
#line 9027 "SourceList.c"
				}
#line 1645 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				dest = _tmp18_;
#line 1647 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp19_ = dest;
#line 1647 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (_tmp19_ != NULL) {
#line 9035 "SourceList.c"
					GtkTargetList* target_list = NULL;
					GtkTargetList* _tmp20_;
					GtkTargetList* _tmp21_;
					GdkAtom target = (GdkAtom) 0U;
					GtkTargetList* _tmp22_;
#line 1648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp20_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
#line 1648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp21_ = _gtk_target_list_ref0 (_tmp20_);
#line 1648 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					target_list = _tmp21_;
#line 1649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp22_ = target_list;
#line 1649 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp22_);
#line 1653 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) gdk_drag_context_get_suggested_action (context)), NULL);
#line 1654 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					gtk_drag_get_data ((GtkWidget*) self, context, target, (guint32) time);
#line 1647 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_gtk_target_list_unref0 (target_list);
#line 9057 "SourceList.c"
				} else {
#line 1657 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
#line 9061 "SourceList.c"
				}
#line 1627 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (dest);
#line 9065 "SourceList.c"
			}
#line 1620 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (source_widget);
#line 9069 "SourceList.c"
		}
	} else {
#line 1663 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_AFTER);
#line 1664 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1664 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (current_path);
#line 1664 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (suggested_path);
#line 1664 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 9082 "SourceList.c"
	}
#line 1667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = TRUE;
#line 1667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (current_path);
#line 1667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (suggested_path);
#line 1667 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 9092 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_real_drag_data_received (GtkWidget* base,
                                                                GdkDragContext* context,
                                                                gint x,
                                                                gint y,
                                                                GtkSelectionData* selection_data,
                                                                guint info,
                                                                guint time)
{
	GraniteWidgetsSourceListPatchTree * self;
	GtkTargetList* target_list = NULL;
	GtkTargetList* _tmp0_;
	GtkTargetList* _tmp1_;
	GdkAtom target = (GdkAtom) 0U;
	GtkTargetList* _tmp2_;
	GtkTreePath* path = NULL;
	GtkTreeViewDropPosition pos = 0;
	gconstpointer _tmp3_;
#line 1670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 1670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (context != NULL);
#line 1670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (selection_data != NULL);
#line 1674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
#line 1674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _gtk_target_list_ref0 (_tmp0_);
#line 1674 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	target_list = _tmp1_;
#line 1675 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = target_list;
#line 1675 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp2_);
#line 1677 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (target == gdk_atom_intern_static_string ("GTK_TREE_MODEL_ROW")) {
#line 1678 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->drag_data_received ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), context, x, y, selection_data, info, time);
#line 1679 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_gtk_target_list_unref0 (target_list);
#line 1679 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return;
#line 9137 "SourceList.c"
	}
#line 1685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = g_object_get_data ((GObject*) context, "suggested-dnd-action");
#line 1685 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (((gint) ((gintptr) _tmp3_)) != 0) {
#line 9143 "SourceList.c"
		GtkTreePath* _tmp4_ = NULL;
		GtkTreeViewDropPosition _tmp5_ = 0;
		GtkTreePath* _tmp6_;
#line 1686 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set_data_full ((GObject*) context, "suggested-dnd-action", (gpointer) ((gintptr) 0), NULL);
#line 1688 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_get_drag_dest_row ((GtkTreeView*) self, &_tmp4_, &_tmp5_);
#line 1688 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 1688 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp4_;
#line 1688 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		pos = _tmp5_;
#line 1690 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = path;
#line 1690 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp6_ != NULL) {
#line 9161 "SourceList.c"
			GraniteWidgetsSourceListPatchDragDest* dest = NULL;
			GraniteWidgetsSourceListPatchDataModel* _tmp7_;
			GtkTreePath* _tmp8_;
			GraniteWidgetsSourceListPatchItem* _tmp9_;
			GraniteWidgetsSourceListPatchDragDest* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GraniteWidgetsSourceListPatchDragDest* _tmp12_;
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = self->priv->_data_model;
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = path;
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp7_, _tmp8_);
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_DEST (_tmp9_) ? ((GraniteWidgetsSourceListPatchDragDest*) _tmp9_) : NULL;
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp10_ == NULL) {
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_tmp9_);
#line 9181 "SourceList.c"
			}
#line 1692 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			dest = _tmp10_;
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = dest;
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp12_ == NULL) {
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = TRUE;
#line 9191 "SourceList.c"
			} else {
				GraniteWidgetsSourceListPatchDragDest* _tmp13_;
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp13_ = dest;
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = !granite_widgets_source_list_patch_drag_dest_data_drop_possible (_tmp13_, context, selection_data);
#line 9198 "SourceList.c"
			}
#line 1694 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp11_) {
#line 1697 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_tree_view_set_drag_dest_row ((GtkTreeView*) self, NULL, GTK_TREE_VIEW_DROP_BEFORE);
#line 1698 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gdk_drag_status (context, 0, (guint32) time);
#line 1699 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (dest);
#line 1699 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreePath_free0 (path);
#line 1699 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_gtk_target_list_unref0 (target_list);
#line 1699 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				return;
#line 9214 "SourceList.c"
			}
#line 1690 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (dest);
#line 9218 "SourceList.c"
		}
#line 1703 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gdk_drag_status (context, gdk_drag_context_get_suggested_action (context), (guint32) time);
#line 9222 "SourceList.c"
	} else {
		GtkTreePath* _tmp14_ = NULL;
		GtkTreeViewDropPosition _tmp15_ = 0;
		gboolean _tmp16_;
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp16_ = gtk_tree_view_get_dest_row_at_pos ((GtkTreeView*) self, x, y, &_tmp14_, &_tmp15_);
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp14_;
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		pos = _tmp15_;
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp16_) {
#line 9237 "SourceList.c"
			GraniteWidgetsSourceListPatchDragDest* drag_dest = NULL;
			GraniteWidgetsSourceListPatchDataModel* _tmp17_;
			GtkTreePath* _tmp18_;
			GraniteWidgetsSourceListPatchItem* _tmp19_;
			GraniteWidgetsSourceListPatchDragDest* _tmp20_;
			GraniteWidgetsSourceListPatchDragDest* _tmp21_;
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = self->priv->_data_model;
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp18_ = path;
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp19_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp17_, _tmp18_);
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp20_ = GRANITE_WIDGETS_IS_SOURCE_LIST_PATCH_DRAG_DEST (_tmp19_) ? ((GraniteWidgetsSourceListPatchDragDest*) _tmp19_) : NULL;
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp20_ == NULL) {
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_tmp19_);
#line 9256 "SourceList.c"
			}
#line 1711 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			drag_dest = _tmp20_;
#line 1713 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp21_ = drag_dest;
#line 1713 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp21_ != NULL) {
#line 9264 "SourceList.c"
				GdkDragAction action = 0U;
				GraniteWidgetsSourceListPatchDragDest* _tmp22_;
#line 1714 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp22_ = drag_dest;
#line 1714 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				action = granite_widgets_source_list_patch_drag_dest_data_received (_tmp22_, context, selection_data);
#line 1715 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_drag_finish (context, action != 0, action == GDK_ACTION_MOVE, (guint32) time);
#line 1716 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (drag_dest);
#line 1716 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreePath_free0 (path);
#line 1716 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_gtk_target_list_unref0 (target_list);
#line 1716 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				return;
#line 9281 "SourceList.c"
			}
#line 1705 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (drag_dest);
#line 9285 "SourceList.c"
		}
#line 1721 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
#line 9289 "SourceList.c"
	}
#line 1670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 1670 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_gtk_target_list_unref0 (target_list);
#line 9295 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_configure_drag_source (GraniteWidgetsSourceListPatchTree* self,
                                                              GtkTargetEntry* src_entries,
                                                              gint src_entries_length1)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
#line 1725 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1727 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_append_row_target_entry (src_entries, (gint) src_entries_length1, &_tmp0_);
#line 1727 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries = _tmp1_;
#line 1727 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries_length1 = _tmp0_;
#line 1727 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_entries_size_ = entries_length1;
#line 1729 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_unset_rows_drag_source ((GtkTreeView*) self);
#line 1730 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_enable_model_drag_source ((GtkTreeView*) self, GDK_BUTTON1_MASK, entries, (gint) entries_length1, GDK_ACTION_MOVE);
#line 1725 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries = (g_free (entries), NULL);
#line 9324 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_configure_drag_dest (GraniteWidgetsSourceListPatchTree* self,
                                                            GtkTargetEntry* dest_entries,
                                                            gint dest_entries_length1,
                                                            GdkDragAction actions)
{
	GtkTargetEntry* entries = NULL;
	gint _tmp0_ = 0;
	GtkTargetEntry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
#line 1733 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_append_row_target_entry (dest_entries, (gint) dest_entries_length1, &_tmp0_);
#line 1735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries = _tmp1_;
#line 1735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries_length1 = _tmp0_;
#line 1735 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_entries_size_ = entries_length1;
#line 1737 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_unset_rows_drag_dest ((GtkTreeView*) self);
#line 1740 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_enable_model_drag_dest ((GtkTreeView*) self, entries, (gint) entries_length1, GDK_ACTION_MOVE | actions);
#line 1733 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries = (g_free (entries), NULL);
#line 9354 "SourceList.c"
}

static void
_vala_array_add1 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
#line 1748 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if ((*length) == (*size)) {
#line 1748 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1748 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*array = g_renew (GtkTargetEntry, *array, *size);
#line 9369 "SourceList.c"
	}
#line 1748 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	(*array)[(*length)++] = *value;
#line 9373 "SourceList.c"
}

static void
_vala_array_add2 (GtkTargetEntry* * array,
                  gint* length,
                  gint* size,
                  const GtkTargetEntry* value)
{
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if ((*length) == (*size)) {
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*array = g_renew (GtkTargetEntry, *array, *size);
#line 9388 "SourceList.c"
	}
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	(*array)[(*length)++] = *value;
#line 9392 "SourceList.c"
}

static GtkTargetEntry*
granite_widgets_source_list_patch_tree_append_row_target_entry (GtkTargetEntry* orig,
                                                                gint orig_length1,
                                                                gint* result_length1)
{
#line 1744 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	static const GtkTargetEntry row_target_entry = {"GTK_TREE_MODEL_ROW", (guint) GTK_TARGET_SAME_WIDGET, (guint) 0};
#line 9402 "SourceList.c"
	GtkTargetEntry* entries = NULL;
	GtkTargetEntry* _tmp0_;
	gint entries_length1;
	gint _entries_size_;
	GtkTargetEntry* _tmp2_;
	gint _tmp2__length1;
	GtkTargetEntry* result;
#line 1747 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
#line 1747 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries = _tmp0_;
#line 1747 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	entries_length1 = 0;
#line 1747 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_entries_size_ = entries_length1;
#line 1748 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_array_add1 (&entries, &entries_length1, &_entries_size_, &row_target_entry);
#line 1750 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (orig != NULL) {
#line 9422 "SourceList.c"
		{
			GtkTargetEntry* target_entry_collection = NULL;
			gint target_entry_collection_length1 = 0;
			gint _target_entry_collection_size_ = 0;
			gint target_entry_it = 0;
#line 1751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			target_entry_collection = orig;
#line 1751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			target_entry_collection_length1 = orig_length1;
#line 1751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			for (target_entry_it = 0; target_entry_it < target_entry_collection_length1; target_entry_it = target_entry_it + 1) {
#line 9434 "SourceList.c"
				GtkTargetEntry target_entry = {0};
#line 1751 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				target_entry = target_entry_collection[target_entry_it];
#line 9438 "SourceList.c"
				{
					GtkTargetEntry _tmp1_;
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp1_ = target_entry;
#line 1752 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_vala_array_add2 (&entries, &entries_length1, &_entries_size_, &_tmp1_);
#line 9445 "SourceList.c"
				}
			}
		}
	}
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = entries;
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2__length1 = entries_length1;
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (result_length1) {
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		*result_length1 = _tmp2__length1;
#line 9458 "SourceList.c"
	}
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 1755 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 9464 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_on_model_item_updated_granite_widgets_source_list_patch_data_model_item_updated (GraniteWidgetsSourceListPatchDataModel* _sender,
                                                                                                                         GraniteWidgetsSourceListPatchItem* item,
                                                                                                                         gpointer self)
{
#line 1759 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_model_item_updated ((GraniteWidgetsSourceListPatchTree*) self, item);
#line 9474 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_enable_item_property_monitor (GraniteWidgetsSourceListPatchTree* self)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 1758 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1759 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1759 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (_tmp0_, "item-updated", (GCallback) _granite_widgets_source_list_patch_tree_on_model_item_updated_granite_widgets_source_list_patch_data_model_item_updated, self, G_CONNECT_AFTER);
#line 9487 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_disable_item_property_monitor (GraniteWidgetsSourceListPatchTree* self)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	guint _tmp1_;
#line 1762 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1763 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1763 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_parse_name ("item-updated", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, &_tmp1_, NULL, FALSE);
#line 1763 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_tree_on_model_item_updated_granite_widgets_source_list_patch_data_model_item_updated, self);
#line 9503 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_on_model_item_updated (GraniteWidgetsSourceListPatchTree* self,
                                                              GraniteWidgetsSourceListPatchItem* item)
{
	GraniteWidgetsSourceListPatchExpandableItem* expandable_item = NULL;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp0_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp1_;
#line 1766 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1766 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 1769 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (item) ? ((GraniteWidgetsSourceListPatchExpandableItem*) item) : NULL);
#line 1769 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	expandable_item = _tmp0_;
#line 1770 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = expandable_item;
#line 1770 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 9525 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* _tmp2_;
#line 1771 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = expandable_item;
#line 1771 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_update_expansion (self, _tmp2_);
#line 9531 "SourceList.c"
	}
#line 1766 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (expandable_item);
#line 9535 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_spacer_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                         GtkCellRenderer* cell,
                                                                                         GtkTreeModel* tree_model,
                                                                                         GtkTreeIter* iter,
                                                                                         gpointer self)
{
#line 1815 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_spacer_cell_data_func (cell_layout, cell, tree_model, iter);
#line 9547 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_add_spacer_cell_for_level (GraniteWidgetsSourceListPatchTree* self,
                                                                  gint level,
                                                                  gboolean check_previous)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
#line 1774 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1774 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_if_fail (level > 0, "level > 0");
#line 1777 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->spacer_cells;
#line 1777 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_ == NULL) {
#line 9565 "SourceList.c"
		GeeHashMap* _tmp1_;
#line 1778 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_CELL_RENDERER_SPACER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1778 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->spacer_cells);
#line 1778 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->spacer_cells = _tmp1_;
#line 9573 "SourceList.c"
	}
#line 1780 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->spacer_cells;
#line 1780 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) level))) {
#line 9579 "SourceList.c"
		GraniteWidgetsSourceListPatchCellRendererSpacer* spacer_cell = NULL;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp3_;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp4_;
		GeeHashMap* _tmp5_;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp6_;
		guint cell_xpadding = 0U;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp9_;
		GtkTreeViewColumn* item_column = NULL;
		GtkTreeViewColumn* _tmp10_;
		GtkTreeViewColumn* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp13_;
		GtkTreeViewColumn* _tmp14_;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp15_;
#line 1781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = granite_widgets_source_list_patch_cell_renderer_spacer_new ();
#line 1781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_ref_sink (_tmp3_);
#line 1781 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		spacer_cell = _tmp3_;
#line 1782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = spacer_cell;
#line 1782 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_cell_renderer_spacer_set_level (_tmp4_, level);
#line 1783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = self->priv->spacer_cells;
#line 1783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = spacer_cell;
#line 1783 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, (gpointer) ((gintptr) level), _tmp6_);
#line 1793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		switch (level) {
#line 1793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			case 1:
#line 9614 "SourceList.c"
			{
				gint left_padding = 0;
				gint _tmp7_ = 0;
#line 1796 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEFT_PADDING, &_tmp7_, NULL);
#line 1796 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				left_padding = _tmp7_;
#line 1797 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				cell_xpadding = (guint) (left_padding / 2);
#line 1798 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 9626 "SourceList.c"
			}
#line 1793 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			case 2:
#line 9630 "SourceList.c"
			{
#line 1801 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				cell_xpadding = (guint) 0;
#line 1802 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 9636 "SourceList.c"
			}
			default:
			{
				gint level_indentation = 0;
				gint _tmp8_ = 0;
#line 1806 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEVEL_INDENTATION, &_tmp8_, NULL);
#line 1806 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				level_indentation = _tmp8_;
#line 1807 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				cell_xpadding = (guint) (level_indentation / 2);
#line 1808 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 9650 "SourceList.c"
			}
		}
#line 1811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = spacer_cell;
#line 1811 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set ((GtkCellRenderer*) _tmp9_, "xpad", cell_xpadding, NULL);
#line 1813 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 1813 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 1813 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item_column = _tmp11_;
#line 1814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = item_column;
#line 1814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp13_ = spacer_cell;
#line 1814 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
#line 1815 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = item_column;
#line 1815 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = spacer_cell;
#line 1815 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, _granite_widgets_source_list_patch_tree_spacer_cell_data_func_gtk_cell_layout_data_func, NULL, NULL);
#line 1818 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (check_previous) {
#line 9677 "SourceList.c"
			{
				gint i = 0;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				i = level - 1;
#line 9682 "SourceList.c"
				{
					gboolean _tmp16_ = FALSE;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp16_ = TRUE;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					while (TRUE) {
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (!_tmp16_) {
#line 9691 "SourceList.c"
							gint _tmp17_;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp17_ = i;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							i = _tmp17_ - 1;
#line 9697 "SourceList.c"
						}
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp16_ = FALSE;
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (!(i > 0)) {
#line 1819 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							break;
#line 9705 "SourceList.c"
						}
#line 1820 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						granite_widgets_source_list_patch_tree_add_spacer_cell_for_level (self, i, FALSE);
#line 9709 "SourceList.c"
					}
				}
			}
		}
#line 1780 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (item_column);
#line 1780 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (spacer_cell);
#line 9718 "SourceList.c"
	}
}

/**
             * Evaluates whether the item at the specified path can be selected or not.
             */
static gboolean
granite_widgets_source_list_patch_tree_select_func (GraniteWidgetsSourceListPatchTree* self,
                                                    GtkTreeSelection* selection,
                                                    GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    gboolean path_currently_selected)
{
	gboolean selectable = FALSE;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	gboolean result;
#line 1828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (selection != NULL, FALSE);
#line 1828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 1828 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 1831 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	selectable = FALSE;
#line 1832 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1832 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp0_, path);
#line 1832 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp1_;
#line 1834 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = item;
#line 1834 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 9758 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 1835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = item;
#line 1835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_item_get_selectable (_tmp3_);
#line 1835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1835 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		selectable = _tmp5_;
#line 9770 "SourceList.c"
	}
#line 1838 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = selectable;
#line 1838 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 1838 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 9778 "SourceList.c"
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
#line 9786 "SourceList.c"
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
#line 9794 "SourceList.c"
}

static GtkTreePath*
granite_widgets_source_list_patch_tree_get_selected_path (GraniteWidgetsSourceListPatchTree* self)
{
	GtkTreePath* selected_path = NULL;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreePath* result;
#line 1841 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1842 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	selected_path = NULL;
#line 1843 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
#line 1843 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1843 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	selection = _tmp1_;
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = selection;
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 9820 "SourceList.c"
		GtkTreeModel* model = NULL;
		GList* selected_rows = NULL;
		GtkTreeSelection* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GList* _tmp5_;
		GtkTreeModel* _tmp6_;
		GList* _tmp7_;
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = selection;
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = _g_object_ref0 (_tmp4_);
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		model = _tmp6_;
#line 1847 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		selected_rows = _tmp5_;
#line 1848 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = selected_rows;
#line 1848 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (g_list_length (_tmp7_) == ((guint) 1)) {
#line 9844 "SourceList.c"
			GList* _tmp8_;
			gconstpointer _tmp9_;
			GtkTreePath* _tmp10_;
#line 1849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = selected_rows;
#line 1849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
#line 1849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp9_);
#line 1849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (selected_path);
#line 1849 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			selected_path = _tmp10_;
#line 9858 "SourceList.c"
		}
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 1845 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (model);
#line 9864 "SourceList.c"
	}
#line 1852 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = selected_path;
#line 1852 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (selection);
#line 1852 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 9872 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_set_selected (GraniteWidgetsSourceListPatchTree* self,
                                                     GraniteWidgetsSourceListPatchItem* item,
                                                     gboolean scroll_to_item)
{
#line 1855 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1856 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (item == NULL) {
#line 9884 "SourceList.c"
		GtkTreeSelection* selection = NULL;
		GtkTreeSelection* _tmp0_;
		GtkTreeSelection* _tmp1_;
		GtkTreeSelection* _tmp2_;
#line 1857 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
#line 1857 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1857 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		selection = _tmp1_;
#line 1858 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = selection;
#line 1858 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp2_ != NULL) {
#line 9899 "SourceList.c"
			GtkTreeSelection* _tmp3_;
#line 1859 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp3_ = selection;
#line 1859 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_selection_unselect_all (_tmp3_);
#line 9905 "SourceList.c"
		}
#line 1870 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->selected);
#line 1870 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->selected = NULL;
#line 1871 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (self, granite_widgets_source_list_patch_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ITEM_SELECTED_SIGNAL], 0, NULL);
#line 1856 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (selection);
#line 9915 "SourceList.c"
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 1872 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_item_get_selectable (item);
#line 1872 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1872 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 9925 "SourceList.c"
			GtkTreePath* to_select = NULL;
			GraniteWidgetsSourceListPatchDataModel* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
#line 1873 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (scroll_to_item) {
#line 1874 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_tree_scroll_to_item (self, item, FALSE, (gfloat) 0);
#line 9934 "SourceList.c"
			}
#line 1876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = self->priv->_data_model;
#line 1876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp6_, item);
#line 1876 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			to_select = _tmp7_;
#line 1877 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = to_select;
#line 1877 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp8_ != NULL) {
#line 9946 "SourceList.c"
				GtkTreePath* _tmp9_;
				GtkTreeViewColumn* _tmp10_;
				GtkCellRendererText* _tmp11_;
#line 1878 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp9_ = to_select;
#line 1878 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 1878 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = self->priv->text_cell;
#line 1878 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp9_, _tmp10_, (GtkCellRenderer*) _tmp11_, FALSE);
#line 9958 "SourceList.c"
			}
#line 1872 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			__vala_GtkTreePath_free0 (to_select);
#line 9962 "SourceList.c"
		}
	}
}

static void
granite_widgets_source_list_patch_tree_real_cursor_changed (GtkTreeView* base)
{
	GraniteWidgetsSourceListPatchTree * self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_ = NULL;
	GtkTreePath* _tmp2_;
	GraniteWidgetsSourceListPatchItem* new_item = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 1882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 1883 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_tree_get_selected_path (self);
#line 1883 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp0_;
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = path;
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 9989 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModel* _tmp3_;
		GtkTreePath* _tmp4_;
		GraniteWidgetsSourceListPatchItem* _tmp5_;
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = self->priv->_data_model;
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = path;
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp3_, _tmp4_);
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp1_);
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _tmp5_;
#line 10003 "SourceList.c"
	} else {
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp1_);
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = NULL;
#line 10009 "SourceList.c"
	}
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = _g_object_ref0 (_tmp1_);
#line 1884 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	new_item = _tmp6_;
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = new_item;
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp8_ != NULL) {
#line 10019 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp9_;
		GraniteWidgetsSourceListPatchItem* _tmp10_;
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = new_item;
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = self->priv->selected;
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = _tmp9_ != _tmp10_;
#line 10028 "SourceList.c"
	} else {
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = FALSE;
#line 10032 "SourceList.c"
	}
#line 1897 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp7_) {
#line 10036 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp11_;
		GraniteWidgetsSourceListPatchItem* _tmp12_;
		GraniteWidgetsSourceListPatchItem* _tmp13_;
#line 1898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = new_item;
#line 1898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 1898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->selected);
#line 1898 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->selected = _tmp12_;
#line 1899 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp13_ = new_item;
#line 1899 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (self, granite_widgets_source_list_patch_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ITEM_SELECTED_SIGNAL], 0, _tmp13_);
#line 10052 "SourceList.c"
	}
#line 1882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (new_item);
#line 1882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (_tmp1_);
#line 1882 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 10060 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_scroll_to_item (GraniteWidgetsSourceListPatchTree* self,
                                                       GraniteWidgetsSourceListPatchItem* item,
                                                       gboolean use_align,
                                                       gfloat row_align)
{
	gboolean scrolled = FALSE;
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result;
#line 1903 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1903 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 1904 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	scrolled = FALSE;
#line 1906 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1906 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp0_, item);
#line 1906 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp1_;
#line 1907 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = path;
#line 1907 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 10091 "SourceList.c"
		GtkTreePath* _tmp3_;
#line 1908 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = path;
#line 1908 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_scroll_to_cell ((GtkTreeView*) self, _tmp3_, NULL, use_align, row_align, (gfloat) 0);
#line 1909 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		scrolled = TRUE;
#line 10099 "SourceList.c"
	}
#line 1912 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = scrolled;
#line 1912 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 1912 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 10107 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_start_editing_item (GraniteWidgetsSourceListPatchTree* self,
                                                           GraniteWidgetsSourceListPatchItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreePath* _tmp10_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean result;
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_item_get_editable (item);
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (_tmp1_, "item.editable", FALSE);
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_item_get_selectable (item);
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = _tmp2_;
#line 1915 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_return_val_if_fail (_tmp3_, "item.selectable", FALSE);
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = granite_widgets_source_list_patch_tree_get_editing (self);
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = _tmp5_;
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp6_) {
#line 10150 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp7_;
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = self->priv->edited;
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = item == _tmp7_;
#line 10156 "SourceList.c"
	} else {
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = FALSE;
#line 10160 "SourceList.c"
	}
#line 1916 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp4_) {
#line 1917 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 1917 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 10168 "SourceList.c"
	}
#line 1919 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = self->priv->_data_model;
#line 1919 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp8_, item);
#line 1919 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp9_;
#line 1920 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp10_ = path;
#line 1920 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp10_ != NULL) {
#line 10180 "SourceList.c"
		GtkCellRendererText* _tmp11_;
		GtkTreePath* _tmp12_;
		GtkTreeViewColumn* _tmp13_;
		GtkCellRendererText* _tmp14_;
#line 1921 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->edited = item;
#line 1922 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = self->priv->text_cell;
#line 1922 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set (_tmp11_, "editable", TRUE, NULL);
#line 1923 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = path;
#line 1923 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp13_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 1923 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = self->priv->text_cell;
#line 1923 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp12_, _tmp13_, (GtkCellRenderer*) _tmp14_, TRUE);
#line 10199 "SourceList.c"
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 1925 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = granite_widgets_source_list_patch_item_get_name (item);
#line 1925 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp16_ = _tmp15_;
#line 1925 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_warning ("SourceList.vala:1925: Could not edit \"%s\": path not found", _tmp16_);
#line 10209 "SourceList.c"
	}
#line 1928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp17_ = granite_widgets_source_list_patch_tree_get_editing (self);
#line 1928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp18_ = _tmp17_;
#line 1928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp18_;
#line 1928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 1928 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 10221 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_stop_editing (GraniteWidgetsSourceListPatchTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 1931 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_get_editing (self);
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_) {
#line 10238 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp3_;
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = self->priv->edited;
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 10244 "SourceList.c"
	} else {
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 10248 "SourceList.c"
	}
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 10252 "SourceList.c"
		GtkTreePath* path = NULL;
		GraniteWidgetsSourceListPatchDataModel* _tmp4_;
		GraniteWidgetsSourceListPatchItem* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreePath* _tmp7_;
#line 1933 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = self->priv->_data_model;
#line 1933 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = self->priv->edited;
#line 1933 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp4_, _tmp5_);
#line 1933 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp6_;
#line 1937 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = path;
#line 1937 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp7_ != NULL) {
#line 10270 "SourceList.c"
			GtkTreePath* _tmp8_;
			GtkTreeViewColumn* _tmp9_;
			GtkCellRendererText* _tmp10_;
#line 1938 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = path;
#line 1938 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 1938 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = self->priv->text_cell;
#line 1938 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_view_set_cursor_on_cell ((GtkTreeView*) self, _tmp8_, _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
#line 10282 "SourceList.c"
		}
#line 1932 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 10286 "SourceList.c"
	}
}

static void
_granite_widgets_source_list_patch_tree_on_editing_done_gtk_cell_editable_editing_done (GtkCellEditable* _sender,
                                                                                        gpointer self)
{
#line 1945 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_editing_done ((GraniteWidgetsSourceListPatchTree*) self);
#line 10296 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_on_editing_started (GraniteWidgetsSourceListPatchTree* self,
                                                           GtkCellEditable* editable,
                                                           const gchar* path)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
#line 1942 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1942 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (editable != NULL);
#line 1942 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (path != NULL);
#line 1943 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (editable, gtk_entry_get_type ()) ? ((GtkEntry*) editable) : NULL);
#line 1943 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->editable_entry);
#line 1943 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->editable_entry = _tmp0_;
#line 1944 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->editable_entry;
#line 1944 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 10322 "SourceList.c"
		GtkEntry* _tmp2_;
		GtkEntry* _tmp3_;
#line 1945 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = self->priv->editable_entry;
#line 1945 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_connect_object ((GtkCellEditable*) _tmp2_, "editing-done", (GCallback) _granite_widgets_source_list_patch_tree_on_editing_done_gtk_cell_editable_editing_done, self, 0);
#line 1946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = self->priv->editable_entry;
#line 1946 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set (_tmp3_, "editable", TRUE, NULL);
#line 10333 "SourceList.c"
	}
}

static void
granite_widgets_source_list_patch_tree_on_editing_canceled (GraniteWidgetsSourceListPatchTree* self)
{
	GtkEntry* _tmp0_;
	GtkCellRendererText* _tmp4_;
#line 1950 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1951 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->editable_entry;
#line 1951 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_ != NULL) {
#line 10348 "SourceList.c"
		GtkEntry* _tmp1_;
		GtkEntry* _tmp2_;
		guint _tmp3_;
#line 1952 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = self->priv->editable_entry;
#line 1952 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set (_tmp1_, "editable", FALSE, NULL);
#line 1953 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = self->priv->editable_entry;
#line 1953 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_parse_name ("editing-done", gtk_cell_editable_get_type (), &_tmp3_, NULL, FALSE);
#line 1953 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_handlers_disconnect_matched ((GtkCellEditable*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _granite_widgets_source_list_patch_tree_on_editing_done_gtk_cell_editable_editing_done, self);
#line 10362 "SourceList.c"
	}
#line 1956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = self->priv->text_cell;
#line 1956 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp4_, "editable", FALSE, NULL);
#line 1957 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->edited = NULL;
#line 10370 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_on_editing_done (GraniteWidgetsSourceListPatchTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
#line 1960 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->edited;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 10385 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = self->priv->edited;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_item_get_editable (_tmp3_);
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _tmp5_;
#line 10397 "SourceList.c"
	} else {
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = FALSE;
#line 10401 "SourceList.c"
	}
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 10405 "SourceList.c"
		GtkEntry* _tmp6_;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = self->priv->editable_entry;
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp6_ != NULL;
#line 10411 "SourceList.c"
	} else {
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 10415 "SourceList.c"
	}
#line 1961 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 10419 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
#line 1962 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = self->priv->edited;
#line 1962 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = self->priv->editable_entry;
#line 1962 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = gtk_entry_get_text (_tmp8_);
#line 1962 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (_tmp7_, granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_EDITED_SIGNAL], 0, _tmp9_);
#line 10431 "SourceList.c"
	}
#line 1965 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_editing_canceled (self);
#line 10435 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_on_activatable_activated (GraniteWidgetsSourceListPatchTree* self,
                                                                 const gchar* item_path_str)
{
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
#line 1968 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1968 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item_path_str != NULL);
#line 1969 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_tree_get_item_from_path_string (self, item_path_str);
#line 1969 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp0_;
#line 1970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = item;
#line 1970 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 10457 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp2_;
#line 1971 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = item;
#line 1971 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_signal_emit (_tmp2_, granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTION_ACTIVATED_SIGNAL], 0);
#line 10463 "SourceList.c"
	}
#line 1968 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 10467 "SourceList.c"
}

static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_tree_get_item_from_path_string (GraniteWidgetsSourceListPatchTree* self,
                                                                  const gchar* item_path_str)
{
	GtkTreePath* item_path = NULL;
	GtkTreePath* _tmp0_;
	GraniteWidgetsSourceListPatchDataModel* _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	GraniteWidgetsSourceListPatchItem* result;
#line 1974 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1974 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item_path_str != NULL, NULL);
#line 1975 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_tree_path_new_from_string (item_path_str);
#line 1975 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item_path = _tmp0_;
#line 1976 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = self->priv->_data_model;
#line 1976 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp1_, item_path);
#line 1976 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 1976 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (item_path);
#line 1976 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 10497 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_toggle_expansion (GraniteWidgetsSourceListPatchTree* self,
                                                         GraniteWidgetsSourceListPatchExpandableItem* item)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
#line 1979 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1979 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 1980 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_expandable_item_get_collapsible (item);
#line 1980 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1980 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_) {
#line 10517 "SourceList.c"
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 1981 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_expandable_item_get_expanded (item);
#line 1981 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = _tmp2_;
#line 1981 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_expandable_item_set_expanded (item, !_tmp3_);
#line 1982 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = TRUE;
#line 1982 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 10530 "SourceList.c"
	}
#line 1984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 1984 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 10536 "SourceList.c"
}

/**
             * Updates the tree to reflect the ''expanded'' property of expandable_item.
             */
static void
granite_widgets_source_list_patch_tree_update_expansion (GraniteWidgetsSourceListPatchTree* self,
                                                         GraniteWidgetsSourceListPatchExpandableItem* expandable_item)
{
	GtkTreePath* path = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
#line 1990 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1990 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (expandable_item != NULL);
#line 1991 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1991 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_data_model_get_item_path (_tmp0_, (GraniteWidgetsSourceListPatchItem*) expandable_item);
#line 1991 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp1_;
#line 1993 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = path;
#line 1993 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 10564 "SourceList.c"
		GtkTreePath* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
#line 1997 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = path;
#line 1997 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_add_spacer_cell_for_level (self, gtk_tree_path_get_depth (_tmp3_) + 1, TRUE);
#line 1999 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = granite_widgets_source_list_patch_expandable_item_get_expanded (expandable_item);
#line 1999 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = _tmp4_;
#line 1999 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_) {
#line 10578 "SourceList.c"
			GtkTreePath* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 2000 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = path;
#line 2000 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_view_expand_row ((GtkTreeView*) self, _tmp6_, FALSE);
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = self->priv->selected;
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp8_ != NULL) {
#line 10590 "SourceList.c"
				GraniteWidgetsSourceListPatchItem* _tmp9_;
				GraniteWidgetsSourceListPatchExpandableItem* _tmp10_;
				GraniteWidgetsSourceListPatchExpandableItem* _tmp11_;
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp9_ = self->priv->selected;
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = granite_widgets_source_list_patch_item_get_parent (_tmp9_);
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = _tmp10_;
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp7_ = _tmp11_ == expandable_item;
#line 10602 "SourceList.c"
			} else {
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp7_ = FALSE;
#line 10606 "SourceList.c"
			}
#line 2008 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp7_) {
#line 10610 "SourceList.c"
				GraniteWidgetsSourceListPatchItem* _tmp12_;
#line 2009 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp12_ = self->priv->selected;
#line 2009 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_tree_set_selected (self, _tmp12_, TRUE);
#line 10616 "SourceList.c"
			}
			{
				GeeIterator* _child_item_it = NULL;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeIterator* _tmp16_;
				GeeIterator* _tmp17_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp13_ = granite_widgets_source_list_patch_expandable_item_get_children (expandable_item);
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp14_ = _tmp13_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp15_ = _tmp14_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp17_ = _tmp16_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_tmp15_);
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_child_item_it = _tmp17_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				while (TRUE) {
#line 10641 "SourceList.c"
					GeeIterator* _tmp18_;
					GraniteWidgetsSourceListPatchItem* child_item = NULL;
					GeeIterator* _tmp19_;
					gpointer _tmp20_;
					GraniteWidgetsSourceListPatchExpandableItem* child_expandable_item = NULL;
					GraniteWidgetsSourceListPatchItem* _tmp21_;
					GraniteWidgetsSourceListPatchExpandableItem* _tmp22_;
					GraniteWidgetsSourceListPatchExpandableItem* _tmp23_;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp18_ = _child_item_it;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (!gee_iterator_next (_tmp18_)) {
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						break;
#line 10656 "SourceList.c"
					}
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp19_ = _child_item_it;
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp20_ = gee_iterator_get (_tmp19_);
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					child_item = (GraniteWidgetsSourceListPatchItem*) _tmp20_;
#line 2015 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp21_ = child_item;
#line 2015 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp22_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp21_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp21_) : NULL);
#line 2015 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					child_expandable_item = _tmp22_;
#line 2016 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp23_ = child_expandable_item;
#line 2016 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (_tmp23_ != NULL) {
#line 10674 "SourceList.c"
						GraniteWidgetsSourceListPatchExpandableItem* _tmp24_;
#line 2017 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp24_ = child_expandable_item;
#line 2017 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						granite_widgets_source_list_patch_tree_update_expansion (self, _tmp24_);
#line 10680 "SourceList.c"
					}
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_g_object_unref0 (child_expandable_item);
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_g_object_unref0 (child_item);
#line 10686 "SourceList.c"
				}
#line 2014 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_child_item_it);
#line 10690 "SourceList.c"
			}
		} else {
			GtkTreePath* _tmp25_;
#line 2020 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp25_ = path;
#line 2020 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_tree_view_collapse_row ((GtkTreeView*) self, _tmp25_);
#line 10698 "SourceList.c"
		}
	}
#line 1990 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 10703 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_real_row_expanded (GtkTreeView* base,
                                                          GtkTreeIter* iter,
                                                          GtkTreePath* path)
{
	GraniteWidgetsSourceListPatchTree * self;
	GraniteWidgetsSourceListPatchExpandableItem* item = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
#line 2025 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2025 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2025 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (path != NULL);
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *iter;
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item (_tmp0_, &_tmp1_);
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp2_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp2_) : NULL;
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ == NULL) {
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp2_);
#line 10735 "SourceList.c"
	}
#line 2026 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp3_;
#line 2027 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 2029 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_disable_item_property_monitor (self);
#line 2030 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expanded (item, TRUE);
#line 2031 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_enable_item_property_monitor (self);
#line 2025 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 10749 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_real_row_collapsed (GtkTreeView* base,
                                                           GtkTreeIter* iter,
                                                           GtkTreePath* path)
{
	GraniteWidgetsSourceListPatchTree * self;
	GraniteWidgetsSourceListPatchExpandableItem* item = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	GraniteWidgetsSourceListPatchExpandableItem* _tmp3_;
#line 2034 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2034 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2034 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (path != NULL);
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *iter;
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item (_tmp0_, &_tmp1_);
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp2_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp2_) : NULL;
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp3_ == NULL) {
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (_tmp2_);
#line 10781 "SourceList.c"
	}
#line 2035 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp3_;
#line 2036 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (item != NULL);
#line 2038 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_disable_item_property_monitor (self);
#line 2039 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_expandable_item_set_expanded (item, FALSE);
#line 2040 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_enable_item_property_monitor (self);
#line 2034 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 10795 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_real_row_activated (GtkTreeView* base,
                                                           GtkTreePath* path,
                                                           GtkTreeViewColumn* column)
{
	GraniteWidgetsSourceListPatchTree * self;
	GtkTreeViewColumn* _tmp0_;
#line 2043 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2043 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (path != NULL);
#line 2043 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (column != NULL);
#line 2044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 2044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (column == _tmp0_) {
#line 10815 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* item = NULL;
		GraniteWidgetsSourceListPatchDataModel* _tmp1_;
		GraniteWidgetsSourceListPatchItem* _tmp2_;
		GraniteWidgetsSourceListPatchItem* _tmp3_;
#line 2045 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = self->priv->_data_model;
#line 2045 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp1_, path);
#line 2045 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item = _tmp2_;
#line 2046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = item;
#line 2046 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp3_ != NULL) {
#line 10830 "SourceList.c"
			GraniteWidgetsSourceListPatchItem* _tmp4_;
#line 2047 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp4_ = item;
#line 2047 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_signal_emit (_tmp4_, granite_widgets_source_list_patch_item_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_ACTIVATED_SIGNAL], 0);
#line 10836 "SourceList.c"
		}
#line 2044 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (item);
#line 10840 "SourceList.c"
	}
}

static gboolean
granite_widgets_source_list_patch_tree_real_key_release_event (GtkWidget* base,
                                                               GdkEventKey* event)
{
	GraniteWidgetsSourceListPatchTree * self;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
	gboolean result;
#line 2051 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2051 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2052 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_tree_get_selected_item (self);
#line 2052 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 2052 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp1_ != NULL) {
#line 2053 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		switch (event->keyval) {
#line 2053 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			case GDK_KEY_F2:
#line 10866 "SourceList.c"
			{
				GdkModifierType modifiers = 0U;
				gboolean _tmp2_ = FALSE;
#line 2055 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				modifiers = gtk_accelerator_get_default_mod_mask ();
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if ((event->state & modifiers) == 0) {
#line 10874 "SourceList.c"
					GraniteWidgetsSourceListPatchItem* _tmp3_;
					GraniteWidgetsSourceListPatchItem* _tmp4_;
					gboolean _tmp5_;
					gboolean _tmp6_;
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp3_ = granite_widgets_source_list_patch_tree_get_selected_item (self);
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp4_ = _tmp3_;
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp5_ = granite_widgets_source_list_patch_item_get_editable (_tmp4_);
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp6_ = _tmp5_;
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp2_ = _tmp6_;
#line 10889 "SourceList.c"
				} else {
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp2_ = FALSE;
#line 10893 "SourceList.c"
				}
#line 2057 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (_tmp2_) {
#line 10897 "SourceList.c"
					GraniteWidgetsSourceListPatchItem* _tmp7_;
					GraniteWidgetsSourceListPatchItem* _tmp8_;
#line 2058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp7_ = granite_widgets_source_list_patch_tree_get_selected_item (self);
#line 2058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp8_ = _tmp7_;
#line 2058 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					granite_widgets_source_list_patch_tree_start_editing_item (self, _tmp8_);
#line 10906 "SourceList.c"
				}
#line 2059 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				break;
#line 10910 "SourceList.c"
			}
			default:
#line 2053 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			break;
#line 10915 "SourceList.c"
		}
	}
#line 2063 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->key_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
#line 2063 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 10922 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_real_button_release_event (GtkWidget* base,
                                                                  GdkEventButton* event)
{
	GraniteWidgetsSourceListPatchTree * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 2066 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2066 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (self->priv->unselectable_item_clicked) {
#line 10938 "SourceList.c"
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = event->window;
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _tmp1_ == _tmp2_;
#line 10947 "SourceList.c"
	} else {
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = FALSE;
#line 10951 "SourceList.c"
	}
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_) {
#line 10955 "SourceList.c"
		GtkTreePath* path = NULL;
		GtkTreeViewColumn* column = NULL;
		gint x = 0;
		gint y = 0;
		gint cell_x = 0;
		gint cell_y = 0;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeViewColumn* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gboolean _tmp7_;
		GtkTreeViewColumn* _tmp8_;
#line 2068 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->unselectable_item_clicked = FALSE;
#line 2072 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		x = (gint) event->x;
#line 2072 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		y = (gint) event->y;
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		path = _tmp3_;
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (column);
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = _g_object_ref0 (_tmp4_);
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		column = _tmp8_;
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		cell_x = _tmp5_;
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		cell_y = _tmp6_;
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp7_) {
#line 10992 "SourceList.c"
			GraniteWidgetsSourceListPatchExpandableItem* item = NULL;
			GraniteWidgetsSourceListPatchDataModel* _tmp9_;
			GtkTreePath* _tmp10_;
			GraniteWidgetsSourceListPatchItem* _tmp11_;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp12_;
			GraniteWidgetsSourceListPatchExpandableItem* _tmp13_;
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = self->priv->_data_model;
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = path;
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp9_, _tmp10_);
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp11_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp11_) : NULL;
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp12_ == NULL) {
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (_tmp11_);
#line 11011 "SourceList.c"
			}
#line 2075 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			item = _tmp12_;
#line 2077 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = item;
#line 2077 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp13_ != NULL) {
#line 11019 "SourceList.c"
				gboolean _tmp14_ = FALSE;
				GraniteWidgetsSourceListPatchExpandableItem* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp15_ = item;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp16_ = granite_widgets_source_list_patch_item_get_selectable ((GraniteWidgetsSourceListPatchItem*) _tmp15_);
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp17_ = _tmp16_;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (!_tmp17_) {
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp14_ = TRUE;
#line 11034 "SourceList.c"
				} else {
					GraniteWidgetsSourceListPatchDataModel* _tmp18_;
					GraniteWidgetsSourceListPatchExpandableItem* _tmp19_;
					GtkTreePath* _tmp20_;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp18_ = self->priv->_data_model;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp19_ = item;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp20_ = path;
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp14_ = granite_widgets_source_list_patch_data_model_is_category (_tmp18_, (GraniteWidgetsSourceListPatchItem*) _tmp19_, NULL, _tmp20_);
#line 11047 "SourceList.c"
				}
#line 2078 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (_tmp14_) {
#line 11051 "SourceList.c"
					GraniteWidgetsSourceListPatchExpandableItem* _tmp21_;
#line 2079 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp21_ = item;
#line 2079 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					granite_widgets_source_list_patch_tree_toggle_expansion (self, _tmp21_);
#line 11057 "SourceList.c"
				}
			}
#line 2074 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (item);
#line 11062 "SourceList.c"
		}
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (column);
#line 2067 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		__vala_GtkTreePath_free0 (path);
#line 11068 "SourceList.c"
	}
#line 2084 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
#line 2084 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11074 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_real_button_press_event (GtkWidget* base,
                                                                GdkEventButton* event)
{
	GraniteWidgetsSourceListPatchTree * self;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	gint x = 0;
	gint y = 0;
	gint cell_x = 0;
	gint cell_y = 0;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	gboolean result;
#line 2087 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2087 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = event->window;
#line 2088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = gtk_tree_view_get_bin_window ((GtkTreeView*) self);
#line 2088 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp0_ != _tmp1_) {
#line 2089 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
#line 2089 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 11111 "SourceList.c"
	}
#line 2093 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	x = (gint) event->x;
#line 2093 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	y = (gint) event->y;
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = gtk_tree_view_get_path_at_pos ((GtkTreeView*) self, x, y, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp2_;
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (column);
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = _g_object_ref0 (_tmp3_);
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	column = _tmp7_;
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	cell_x = _tmp4_;
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	cell_y = _tmp5_;
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp6_) {
#line 11135 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* item = NULL;
		GraniteWidgetsSourceListPatchDataModel* _tmp8_;
		GtkTreePath* _tmp9_;
		GraniteWidgetsSourceListPatchItem* _tmp10_;
		GdkRectangle start_cell_area = {0};
		GtkTreePath* _tmp11_;
		GtkTreeViewColumn* _tmp12_;
		GdkRectangle _tmp13_ = {0};
		GdkRectangle _tmp14_;
		gboolean _tmp15_ = FALSE;
		GraniteWidgetsSourceListPatchItem* _tmp16_;
#line 2096 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = self->priv->_data_model;
#line 2096 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = path;
#line 2096 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp10_ = granite_widgets_source_list_patch_data_model_get_item_from_path (_tmp8_, _tmp9_);
#line 2096 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item = _tmp10_;
#line 2100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp11_ = path;
#line 2100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp12_ = gtk_tree_view_get_column ((GtkTreeView*) self, 0);
#line 2100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_tree_view_get_cell_area ((GtkTreeView*) self, _tmp11_, _tmp12_, &_tmp13_);
#line 2100 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		start_cell_area = _tmp13_;
#line 2101 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = start_cell_area;
#line 2101 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		cell_x -= _tmp14_.x;
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp16_ = item;
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp16_ != NULL) {
#line 11171 "SourceList.c"
			GtkTreeViewColumn* _tmp17_;
			GtkTreeViewColumn* _tmp18_;
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = column;
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp18_ = gtk_tree_view_get_column ((GtkTreeView*) self, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = _tmp17_ == _tmp18_;
#line 11180 "SourceList.c"
		} else {
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = FALSE;
#line 11184 "SourceList.c"
		}
#line 2103 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp15_) {
#line 2105 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			granite_widgets_source_list_patch_tree_stop_editing (self);
#line 2107 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
#line 11192 "SourceList.c"
				GraniteWidgetsSourceListPatchItem* _tmp19_;
#line 2108 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp19_ = item;
#line 2108 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				granite_widgets_source_list_patch_tree_popup_context_menu (self, _tmp19_, event);
#line 2109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				result = TRUE;
#line 2109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (item);
#line 2109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (column);
#line 2109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				__vala_GtkTreePath_free0 (path);
#line 2109 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				return result;
#line 11208 "SourceList.c"
			} else {
#line 2110 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
#line 11212 "SourceList.c"
					gboolean is_expandable = FALSE;
					GraniteWidgetsSourceListPatchItem* _tmp20_;
					gboolean _tmp21_ = FALSE;
					gboolean is_category = FALSE;
#line 2112 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					_tmp20_ = item;
#line 2112 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					is_expandable = GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp20_);
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (is_expandable) {
#line 11223 "SourceList.c"
						GraniteWidgetsSourceListPatchDataModel* _tmp22_;
						GraniteWidgetsSourceListPatchItem* _tmp23_;
						GtkTreePath* _tmp24_;
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp22_ = self->priv->_data_model;
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp23_ = item;
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp24_ = path;
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp21_ = granite_widgets_source_list_patch_data_model_is_category (_tmp22_, _tmp23_, NULL, _tmp24_);
#line 11235 "SourceList.c"
					} else {
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						_tmp21_ = FALSE;
#line 11239 "SourceList.c"
					}
#line 2113 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					is_category = _tmp21_;
#line 2115 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
					if (event->type == GDK_BUTTON_PRESS) {
#line 2116 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (is_expandable) {
#line 11247 "SourceList.c"
							gboolean _tmp25_ = FALSE;
							gboolean _tmp33_ = FALSE;
							gboolean _tmp34_ = FALSE;
#line 2122 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							if (is_category) {
#line 2122 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp25_ = TRUE;
#line 11255 "SourceList.c"
							} else {
								gboolean _tmp26_ = FALSE;
								GraniteWidgetsSourceListPatchItem* _tmp27_;
								gboolean _tmp28_;
								gboolean _tmp29_;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp27_ = item;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp28_ = granite_widgets_source_list_patch_item_get_selectable (_tmp27_);
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp29_ = _tmp28_;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								if (!_tmp29_) {
#line 11269 "SourceList.c"
									GtkTreeViewColumn* _tmp30_;
									GtkTreePath* _tmp31_;
									GraniteWidgetsSourceListPatchCellRendererIcon* _tmp32_;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
									_tmp30_ = column;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
									_tmp31_ = path;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
									_tmp32_ = self->priv->activatable_cell;
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
									_tmp26_ = !granite_widgets_source_list_patch_tree_over_cell (self, _tmp30_, _tmp31_, (GtkCellRenderer*) _tmp32_, cell_x);
#line 11281 "SourceList.c"
								} else {
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
									_tmp26_ = FALSE;
#line 11285 "SourceList.c"
								}
#line 2123 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp25_ = _tmp26_;
#line 11289 "SourceList.c"
							}
#line 2122 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							self->priv->unselectable_item_clicked = _tmp25_;
#line 2125 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							if (!self->priv->unselectable_item_clicked) {
#line 11295 "SourceList.c"
								GtkTreeViewColumn* _tmp35_;
								GtkTreePath* _tmp36_;
#line 2126 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp35_ = column;
#line 2126 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp36_ = path;
#line 2126 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp34_ = granite_widgets_source_list_patch_tree_over_primary_expander (self, _tmp35_, _tmp36_, cell_x);
#line 11304 "SourceList.c"
							} else {
#line 2125 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp34_ = FALSE;
#line 11308 "SourceList.c"
							}
#line 2125 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							if (_tmp34_) {
#line 11312 "SourceList.c"
								GraniteWidgetsSourceListPatchItem* _tmp37_;
#line 2127 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp37_ = item;
#line 2127 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp33_ = granite_widgets_source_list_patch_tree_toggle_expansion (self, GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp37_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp37_) : NULL);
#line 11318 "SourceList.c"
							} else {
#line 2125 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_tmp33_ = FALSE;
#line 11322 "SourceList.c"
							}
#line 2125 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							if (_tmp33_) {
#line 2128 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								result = TRUE;
#line 2128 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_g_object_unref0 (item);
#line 2128 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								_g_object_unref0 (column);
#line 2128 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								__vala_GtkTreePath_free0 (path);
#line 2128 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
								return result;
#line 11336 "SourceList.c"
							}
						}
					} else {
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_ = FALSE;
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						gboolean _tmp42_ = FALSE;
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (event->type == GDK_2BUTTON_PRESS) {
#line 2131 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp42_ = !is_category;
#line 11349 "SourceList.c"
						} else {
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp42_ = FALSE;
#line 11353 "SourceList.c"
						}
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (_tmp42_) {
#line 11357 "SourceList.c"
							GraniteWidgetsSourceListPatchItem* _tmp43_;
							gboolean _tmp44_;
							gboolean _tmp45_;
#line 2132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp43_ = item;
#line 2132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp44_ = granite_widgets_source_list_patch_item_get_editable (_tmp43_);
#line 2132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp45_ = _tmp44_;
#line 2132 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp41_ = _tmp45_;
#line 11369 "SourceList.c"
						} else {
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp41_ = FALSE;
#line 11373 "SourceList.c"
						}
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (_tmp41_) {
#line 11377 "SourceList.c"
							GraniteWidgetsSourceListPatchItem* _tmp46_;
							gboolean _tmp47_;
							gboolean _tmp48_;
#line 2133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp46_ = item;
#line 2133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp47_ = granite_widgets_source_list_patch_item_get_selectable (_tmp46_);
#line 2133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp48_ = _tmp47_;
#line 2133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp40_ = _tmp48_;
#line 11389 "SourceList.c"
						} else {
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp40_ = FALSE;
#line 11393 "SourceList.c"
						}
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (_tmp40_) {
#line 11397 "SourceList.c"
							GtkTreeViewColumn* _tmp49_;
							GtkTreePath* _tmp50_;
							GtkCellRendererText* _tmp51_;
#line 2134 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp49_ = column;
#line 2134 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp50_ = path;
#line 2134 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp51_ = self->priv->text_cell;
#line 2134 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp39_ = granite_widgets_source_list_patch_tree_over_cell (self, _tmp49_, _tmp50_, (GtkCellRenderer*) _tmp51_, cell_x);
#line 11409 "SourceList.c"
						} else {
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp39_ = FALSE;
#line 11413 "SourceList.c"
						}
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (_tmp39_) {
#line 11417 "SourceList.c"
							GraniteWidgetsSourceListPatchItem* _tmp52_;
#line 2135 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp52_ = item;
#line 2135 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp38_ = granite_widgets_source_list_patch_tree_start_editing_item (self, _tmp52_);
#line 11423 "SourceList.c"
						} else {
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_tmp38_ = FALSE;
#line 11427 "SourceList.c"
						}
#line 2130 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
						if (_tmp38_) {
#line 2138 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							result = TRUE;
#line 2138 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_g_object_unref0 (item);
#line 2138 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							_g_object_unref0 (column);
#line 2138 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							__vala_GtkTreePath_free0 (path);
#line 2138 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
							return result;
#line 11441 "SourceList.c"
						}
					}
				}
			}
		}
#line 2095 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (item);
#line 11449 "SourceList.c"
	}
#line 2144 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = GTK_WIDGET_CLASS (granite_widgets_source_list_patch_tree_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), event);
#line 2144 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (column);
#line 2144 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 2144 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11459 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_over_primary_expander (GraniteWidgetsSourceListPatchTree* self,
                                                              GtkTreeViewColumn* col,
                                                              GtkTreePath* path,
                                                              gint x)
{
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GraniteWidgetsCellRendererExpander* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GraniteWidgetsCellRendererExpander* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter _tmp13_;
	gint indentation_level = 0;
	GraniteWidgetsSourceListPatchCellRendererSpacer* last_spacer_cell = NULL;
	GeeHashMap* _tmp14_;
	gpointer _tmp15_;
	GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp16_;
	gboolean result;
#line 2147 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2147 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (col != NULL, FALSE);
#line 2147 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 2149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = gtk_tree_view_get_model ((GtkTreeView*) self);
#line 2149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 2149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gtk_tree_model_get_iter (_tmp1_, &_tmp2_, path);
#line 2149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	iter = _tmp2_;
#line 2149 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!_tmp3_) {
#line 2150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 2150 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 11509 "SourceList.c"
	}
#line 2153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = self->priv->primary_expander_cell;
#line 2153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = gtk_tree_view_get_model ((GtkTreeView*) self);
#line 2153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = _tmp5_;
#line 2153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = iter;
#line 2153 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_expander_cell_data_func (self, (GtkCellLayout*) col, (GtkCellRenderer*) _tmp4_, _tmp6_, &_tmp7_);
#line 2155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = self->priv->primary_expander_cell;
#line 2155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = gtk_cell_renderer_get_visible ((GtkCellRenderer*) _tmp8_);
#line 2155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp10_ = _tmp9_;
#line 2155 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (!_tmp10_) {
#line 2156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 2156 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 11533 "SourceList.c"
	}
#line 2159 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp11_ = gtk_tree_view_get_model ((GtkTreeView*) self);
#line 2159 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = _tmp11_;
#line 2159 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp13_ = iter;
#line 2159 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (gtk_tree_model_iter_n_children (_tmp12_, &_tmp13_) < 1) {
#line 2160 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		result = FALSE;
#line 2160 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		return result;
#line 11547 "SourceList.c"
	}
#line 2168 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	indentation_level = gtk_tree_path_get_depth (path);
#line 2169 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp14_ = self->priv->spacer_cells;
#line 2169 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, (gpointer) ((gintptr) indentation_level));
#line 2169 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	last_spacer_cell = (GraniteWidgetsSourceListPatchCellRendererSpacer*) _tmp15_;
#line 2171 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp16_ = last_spacer_cell;
#line 2171 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp16_ != NULL) {
#line 11561 "SourceList.c"
		gint cell_x = 0;
		gint cell_width = 0;
		GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp20_;
#line 2174 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = last_spacer_cell;
#line 2174 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20_ = gtk_tree_view_column_cell_get_position (col, (GtkCellRenderer*) _tmp17_, &_tmp18_, &_tmp19_);
#line 2174 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		cell_x = _tmp18_;
#line 2174 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		cell_width = _tmp19_;
#line 2174 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp20_) {
#line 11578 "SourceList.c"
			gint expander_width = 0;
			GraniteWidgetsCellRendererExpander* _tmp21_;
			gint indentation_offset = 0;
			gboolean _tmp22_ = FALSE;
#line 2176 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp21_ = self->priv->primary_expander_cell;
#line 2176 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			expander_width = granite_widgets_source_list_patch_tree_get_cell_width (self, (GtkCellRenderer*) _tmp21_) + 1;
#line 2179 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			indentation_offset = cell_x + cell_width;
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (x >= indentation_offset) {
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp22_ = x <= (indentation_offset + expander_width);
#line 11593 "SourceList.c"
			} else {
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp22_ = FALSE;
#line 11597 "SourceList.c"
			}
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = _tmp22_;
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (last_spacer_cell);
#line 2180 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 11605 "SourceList.c"
		}
	}
#line 2187 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 2187 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (last_spacer_cell);
#line 2187 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11614 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_over_cell (GraniteWidgetsSourceListPatchTree* self,
                                                  GtkTreeViewColumn* col,
                                                  GtkTreePath* path,
                                                  GtkCellRenderer* cell,
                                                  gint x)
{
	gint cell_x = 0;
	gint cell_width = 0;
	gboolean found = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
#line 2190 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2190 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (col != NULL, FALSE);
#line 2190 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 2190 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (cell != NULL, FALSE);
#line 2192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = gtk_tree_view_column_cell_get_position (col, cell, &_tmp0_, &_tmp1_);
#line 2192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	cell_x = _tmp0_;
#line 2192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	cell_width = _tmp1_;
#line 2192 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	found = _tmp2_;
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (found) {
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = x > cell_x;
#line 11653 "SourceList.c"
	} else {
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = FALSE;
#line 11657 "SourceList.c"
	}
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp4_) {
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = x < (cell_x + cell_width);
#line 11663 "SourceList.c"
	} else {
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = FALSE;
#line 11667 "SourceList.c"
	}
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp3_;
#line 2193 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11673 "SourceList.c"
}

static gint
granite_widgets_source_list_patch_tree_get_cell_width (GraniteWidgetsSourceListPatchTree* self,
                                                       GtkCellRenderer* cell_renderer)
{
	GtkRequisition min_req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition _tmp1_;
	gint result;
#line 2196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 2196 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (cell_renderer != NULL, 0);
#line 2198 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_renderer_get_preferred_size (cell_renderer, (GtkWidget*) self, &_tmp0_, NULL);
#line 2198 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	min_req = _tmp0_;
#line 2199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = min_req;
#line 2199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp1_.width;
#line 2199 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11698 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_real_popup_menu (GtkWidget* base)
{
	GraniteWidgetsSourceListPatchTree * self;
	gboolean result;
#line 2202 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = (GraniteWidgetsSourceListPatchTree*) base;
#line 2203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = granite_widgets_source_list_patch_tree_popup_context_menu (self, NULL, NULL);
#line 2203 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11712 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_popup_context_menu (GraniteWidgetsSourceListPatchTree* self,
                                                           GraniteWidgetsSourceListPatchItem* item,
                                                           GdkEventButton* event)
{
	gboolean result;
#line 2206 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2207 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (item == NULL) {
#line 11725 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp0_;
		GraniteWidgetsSourceListPatchItem* _tmp1_;
#line 2208 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = granite_widgets_source_list_patch_tree_get_selected_item (self);
#line 2208 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp1_ = _tmp0_;
#line 2208 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		item = _tmp1_;
#line 11734 "SourceList.c"
	}
#line 2210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (item != NULL) {
#line 11738 "SourceList.c"
		GtkMenu* menu = NULL;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
#line 2211 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp2_ = granite_widgets_source_list_patch_item_get_context_menu (item);
#line 2211 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		menu = _tmp2_;
#line 2212 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = menu;
#line 2212 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp3_ != NULL) {
#line 11750 "SourceList.c"
			GtkMenu* _tmp4_;
			GtkMenu* _tmp5_;
#line 2213 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp4_ = menu;
#line 2213 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_object_set (_tmp4_, "attach-widget", (GtkWidget*) self, NULL);
#line 2214 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp5_ = menu;
#line 2214 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_menu_popup_at_pointer (_tmp5_, (GdkEvent*) event);
#line 2215 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (event == NULL) {
#line 11763 "SourceList.c"
				GtkMenu* _tmp6_;
#line 2216 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp6_ = menu;
#line 2216 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				gtk_menu_shell_select_first ((GtkMenuShell*) _tmp6_, FALSE);
#line 11769 "SourceList.c"
			}
#line 2219 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			result = TRUE;
#line 2219 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (menu);
#line 2219 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			return result;
#line 11777 "SourceList.c"
		}
#line 2210 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (menu);
#line 11781 "SourceList.c"
	}
#line 2223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = FALSE;
#line 2223 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11787 "SourceList.c"
}

static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_tree_get_item_from_model (GtkTreeModel* model,
                                                            GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchDataModel* data_model = NULL;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	GraniteWidgetsSourceListPatchItem* result;
#line 2226 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 2226 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 2227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_DATA_MODEL (model) ? ((GraniteWidgetsSourceListPatchDataModel*) model) : NULL);
#line 2227 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	data_model = _tmp0_;
#line 2228 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (data_model != NULL, "data_model != null");
#line 2229 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = *iter;
#line 2229 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = granite_widgets_source_list_patch_data_model_get_item (data_model, &_tmp1_);
#line 2229 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 2229 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (data_model);
#line 2229 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 11819 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_spacer_cell_data_func (GtkCellLayout* layout,
                                                              GtkCellRenderer* renderer,
                                                              GtkTreeModel* model,
                                                              GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchCellRendererSpacer* spacer = NULL;
	GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp0_;
	GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp1_;
	GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	gint level = 0;
	GtkTreePath* _tmp7_;
	GraniteWidgetsSourceListPatchCellRendererSpacer* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (layout != NULL);
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (renderer != NULL);
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (model != NULL);
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2235 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_SPACER (renderer) ? ((GraniteWidgetsSourceListPatchCellRendererSpacer*) renderer) : NULL);
#line 2235 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	spacer = _tmp0_;
#line 2236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = spacer;
#line 2236 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "spacer != null");
#line 2237 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = spacer;
#line 2237 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = granite_widgets_source_list_patch_cell_renderer_spacer_get_level (_tmp2_);
#line 2237 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = _tmp3_;
#line 2237 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp4_ > 0, "spacer.level > 0");
#line 2239 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = *iter;
#line 2239 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = gtk_tree_model_get_path (model, &_tmp5_);
#line 2239 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	path = _tmp6_;
#line 2241 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	level = -1;
#line 2242 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = path;
#line 2242 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp7_ != NULL) {
#line 11878 "SourceList.c"
		GtkTreePath* _tmp8_;
#line 2243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = path;
#line 2243 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		level = gtk_tree_path_get_depth (_tmp8_);
#line 11884 "SourceList.c"
	}
#line 2245 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = spacer;
#line 2245 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp10_ = granite_widgets_source_list_patch_cell_renderer_spacer_get_level (_tmp9_);
#line 2245 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp11_ = _tmp10_;
#line 2245 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_renderer_set_visible (renderer, _tmp11_ <= level);
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	__vala_GtkTreePath_free0 (path);
#line 2232 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (spacer);
#line 11898 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_name_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                            GtkCellLayout* layout,
                                                            GtkCellRenderer* renderer,
                                                            GtkTreeModel* model,
                                                            GtkTreeIter* iter)
{
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GString* text = NULL;
	GString* _tmp2_;
	PangoWeight weight = 0;
	gboolean use_markup = FALSE;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeIter _tmp3_;
	GraniteWidgetsSourceListPatchItem* _tmp4_;
	GraniteWidgetsSourceListPatchItem* _tmp5_;
	GtkCellRendererText* _tmp22_;
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (layout != NULL);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (renderer != NULL);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (model != NULL);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2251 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (renderer, gtk_cell_renderer_text_get_type ()) ? ((GtkCellRendererText*) renderer) : NULL);
#line 2251 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	text_renderer = _tmp0_;
#line 2252 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = text_renderer;
#line 2252 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "text_renderer != null");
#line 2254 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = g_string_new ("");
#line 2254 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	text = _tmp2_;
#line 2255 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	weight = PANGO_WEIGHT_NORMAL;
#line 2256 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	use_markup = FALSE;
#line 2258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = *iter;
#line 2258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = granite_widgets_source_list_patch_tree_get_item_from_model (model, &_tmp3_);
#line 2258 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp4_;
#line 2259 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = item;
#line 2259 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp5_ != NULL) {
#line 11956 "SourceList.c"
		GraniteWidgetsSourceListPatchItem* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp17_ = FALSE;
		GraniteWidgetsSourceListPatchItem* _tmp18_;
#line 2260 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = item;
#line 2260 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = granite_widgets_source_list_patch_item_get_markup (_tmp6_);
#line 2260 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = _tmp7_;
#line 2260 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp8_ != NULL) {
#line 11970 "SourceList.c"
			GString* _tmp9_;
			GraniteWidgetsSourceListPatchItem* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
#line 2261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = text;
#line 2261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = item;
#line 2261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = granite_widgets_source_list_patch_item_get_markup (_tmp10_);
#line 2261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = _tmp11_;
#line 2261 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_string_append (_tmp9_, _tmp12_);
#line 2262 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			use_markup = TRUE;
#line 11987 "SourceList.c"
		} else {
			GString* _tmp13_;
			GraniteWidgetsSourceListPatchItem* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
#line 2264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = text;
#line 2264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp14_ = item;
#line 2264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = granite_widgets_source_list_patch_item_get_name (_tmp14_);
#line 2264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp16_ = _tmp15_;
#line 2264 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_string_append (_tmp13_, _tmp16_);
#line 12003 "SourceList.c"
		}
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp18_ = item;
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp18_->use_pango_style) {
#line 12009 "SourceList.c"
			GraniteWidgetsSourceListPatchDataModel* _tmp19_;
			GraniteWidgetsSourceListPatchItem* _tmp20_;
			GtkTreeIter _tmp21_;
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp19_ = self->priv->_data_model;
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp20_ = item;
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp21_ = *iter;
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = granite_widgets_source_list_patch_data_model_is_category (_tmp19_, _tmp20_, &_tmp21_, NULL);
#line 12021 "SourceList.c"
		} else {
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = FALSE;
#line 12025 "SourceList.c"
		}
#line 2267 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp17_) {
#line 2268 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			weight = PANGO_WEIGHT_BOLD;
#line 12031 "SourceList.c"
		}
	}
#line 2272 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp22_ = text_renderer;
#line 2272 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp22_, "weight", (gint) weight, NULL);
#line 2274 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (use_markup) {
#line 12040 "SourceList.c"
		GtkCellRendererText* _tmp23_;
		GString* _tmp24_;
		const gchar* _tmp25_;
#line 2275 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp23_ = text_renderer;
#line 2275 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp24_ = text;
#line 2275 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp25_ = _tmp24_->str;
#line 2275 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set (_tmp23_, "markup", _tmp25_, NULL);
#line 12052 "SourceList.c"
	} else {
		GtkCellRendererText* _tmp26_;
		GString* _tmp27_;
		const gchar* _tmp28_;
#line 2277 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp26_ = text_renderer;
#line 2277 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp27_ = text;
#line 2277 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp28_ = _tmp27_->str;
#line 2277 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_set (_tmp26_, "text", _tmp28_, NULL);
#line 12065 "SourceList.c"
	}
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_string_free0 (text);
#line 2248 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (text_renderer);
#line 12073 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_badge_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                             GtkCellLayout* layout,
                                                             GtkCellRenderer* renderer,
                                                             GtkTreeModel* model,
                                                             GtkTreeIter* iter)
{
	GraniteWidgetsCellRendererBadge* badge_renderer = NULL;
	GraniteWidgetsCellRendererBadge* _tmp0_;
	GraniteWidgetsCellRendererBadge* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_;
	gboolean visible = FALSE;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeIter _tmp3_;
	GraniteWidgetsSourceListPatchItem* _tmp4_;
	GraniteWidgetsSourceListPatchItem* _tmp5_;
	GraniteWidgetsCellRendererBadge* _tmp19_;
	GraniteWidgetsCellRendererBadge* _tmp20_;
	const gchar* _tmp21_;
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (layout != NULL);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (renderer != NULL);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (model != NULL);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (renderer, GRANITE_WIDGETS_TYPE_CELL_RENDERER_BADGE) ? ((GraniteWidgetsCellRendererBadge*) renderer) : NULL);
#line 2284 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	badge_renderer = _tmp0_;
#line 2285 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = badge_renderer;
#line 2285 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "badge_renderer != null");
#line 2287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = g_strdup ("");
#line 2287 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	text = _tmp2_;
#line 2288 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	visible = FALSE;
#line 2290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = *iter;
#line 2290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = granite_widgets_source_list_patch_tree_get_item_from_model (model, &_tmp3_);
#line 2290 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp4_;
#line 2291 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = item;
#line 2291 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp5_ != NULL) {
#line 12130 "SourceList.c"
		gboolean _tmp6_ = FALSE;
		GraniteWidgetsSourceListPatchItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp7_ = item;
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp8_ = granite_widgets_source_list_patch_item_get_badge (_tmp7_);
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp9_ = _tmp8_;
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp9_ != NULL) {
#line 12143 "SourceList.c"
			GraniteWidgetsSourceListPatchItem* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = item;
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = granite_widgets_source_list_patch_item_get_badge (_tmp10_);
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = _tmp11_;
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp13_ = string_strip (_tmp12_);
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp14_ = _tmp13_;
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = g_strcmp0 (_tmp14_, "") != 0;
#line 2293 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_free0 (_tmp14_);
#line 12163 "SourceList.c"
		} else {
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp6_ = FALSE;
#line 12167 "SourceList.c"
		}
#line 2292 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		visible = _tmp6_;
#line 2295 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (visible) {
#line 12173 "SourceList.c"
			GraniteWidgetsSourceListPatchItem* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp15_ = item;
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp16_ = granite_widgets_source_list_patch_item_get_badge (_tmp15_);
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = _tmp16_;
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_free0 (text);
#line 2296 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			text = _tmp18_;
#line 12190 "SourceList.c"
		}
	}
#line 2299 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp19_ = badge_renderer;
#line 2299 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp19_, visible);
#line 2300 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp20_ = badge_renderer;
#line 2300 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp21_ = text;
#line 2300 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_cell_renderer_badge_set_text (_tmp20_, _tmp21_);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_free0 (text);
#line 2281 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (badge_renderer);
#line 12209 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_icon_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                            GtkCellLayout* layout,
                                                            GtkCellRenderer* renderer,
                                                            GtkTreeModel* model,
                                                            GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchCellRendererIcon* icon_renderer = NULL;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp0_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp1_;
	GIcon* icon = NULL;
	gboolean visible = FALSE;
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeIter _tmp2_;
	GraniteWidgetsSourceListPatchItem* _tmp3_;
	GraniteWidgetsSourceListPatchItem* _tmp4_;
	gboolean _tmp17_ = FALSE;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp19_;
	GIcon* _tmp20_ = NULL;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp22_;
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (layout != NULL);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (renderer != NULL);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (model != NULL);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2306 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_CELL_RENDERER_ICON (renderer) ? ((GraniteWidgetsSourceListPatchCellRendererIcon*) renderer) : NULL);
#line 2306 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	icon_renderer = _tmp0_;
#line 2307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = icon_renderer;
#line 2307 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_vala_assert (_tmp1_ != NULL, "icon_renderer != null");
#line 2309 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	icon = NULL;
#line 2311 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	visible = TRUE;
#line 2313 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = *iter;
#line 2313 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = granite_widgets_source_list_patch_tree_get_item_from_model (model, &_tmp2_);
#line 2313 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp3_;
#line 2314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = item;
#line 2314 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp4_ != NULL) {
#line 12264 "SourceList.c"
		GraniteWidgetsSourceListPatchCellRendererIcon* _tmp5_;
		GraniteWidgetsSourceListPatchCellRendererIcon* _tmp6_;
#line 2315 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = icon_renderer;
#line 2315 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp6_ = self->priv->icon_cell;
#line 2315 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_ == _tmp6_) {
#line 12273 "SourceList.c"
			GraniteWidgetsSourceListPatchItem* _tmp7_;
			GIcon* _tmp8_;
			GIcon* _tmp9_;
			GIcon* _tmp10_;
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp7_ = item;
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = granite_widgets_source_list_patch_item_get_icon (_tmp7_);
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp9_ = _tmp8_;
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp10_ = _g_object_ref0 (_tmp9_);
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_g_object_unref0 (icon);
#line 2316 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			icon = _tmp10_;
#line 12290 "SourceList.c"
		} else {
			GraniteWidgetsSourceListPatchCellRendererIcon* _tmp11_;
			GraniteWidgetsSourceListPatchCellRendererIcon* _tmp12_;
#line 2317 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp11_ = icon_renderer;
#line 2317 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp12_ = self->priv->activatable_cell;
#line 2317 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp11_ == _tmp12_) {
#line 12300 "SourceList.c"
				GraniteWidgetsSourceListPatchItem* _tmp13_;
				GIcon* _tmp14_;
				GIcon* _tmp15_;
				GIcon* _tmp16_;
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp13_ = item;
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp14_ = granite_widgets_source_list_patch_item_get_activatable (_tmp13_);
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp15_ = _tmp14_;
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_g_object_unref0 (icon);
#line 2318 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				icon = _tmp16_;
#line 12317 "SourceList.c"
			} else {
#line 2320 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				g_assert_not_reached ();
#line 12321 "SourceList.c"
			}
		}
	}
#line 2323 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (visible) {
#line 12327 "SourceList.c"
		GIcon* _tmp18_;
#line 2323 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp18_ = icon;
#line 2323 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = _tmp18_ != NULL;
#line 12333 "SourceList.c"
	} else {
#line 2323 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp17_ = FALSE;
#line 12337 "SourceList.c"
	}
#line 2323 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	visible = _tmp17_;
#line 2325 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp19_ = icon_renderer;
#line 2325 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) _tmp19_, visible);
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (visible) {
#line 12347 "SourceList.c"
		GIcon* _tmp21_;
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp21_ = icon;
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20_ = _tmp21_;
#line 12353 "SourceList.c"
	} else {
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp20_ = NULL;
#line 12357 "SourceList.c"
	}
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp22_ = icon_renderer;
#line 2326 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRendererPixbuf*) _tmp22_, "gicon", _tmp20_, NULL);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (icon);
#line 2303 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (icon_renderer);
#line 12369 "SourceList.c"
}

/**
             * Controls expander visibility.
             */
static void
granite_widgets_source_list_patch_tree_expander_cell_data_func (GraniteWidgetsSourceListPatchTree* self,
                                                                GtkCellLayout* layout,
                                                                GtkCellRenderer* renderer,
                                                                GtkTreeModel* model,
                                                                GtkTreeIter* iter)
{
	GraniteWidgetsSourceListPatchItem* item = NULL;
	GtkTreeIter _tmp0_;
	GraniteWidgetsSourceListPatchItem* _tmp1_;
	GraniteWidgetsSourceListPatchItem* _tmp2_;
	GraniteWidgetsCellRendererExpander* _tmp12_;
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (layout != NULL);
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (renderer != NULL);
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (model != NULL);
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (iter != NULL);
#line 2335 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = *iter;
#line 2335 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_get_item_from_model (model, &_tmp0_);
#line 2335 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item = _tmp1_;
#line 2336 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = item;
#line 2336 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (_tmp2_ != NULL) {
#line 12407 "SourceList.c"
		GraniteWidgetsSourceListPatchExpandableItem* expandable_item = NULL;
		GraniteWidgetsSourceListPatchItem* _tmp3_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp4_;
		GraniteWidgetsSourceListPatchExpandableItem* _tmp5_;
#line 2340 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp3_ = item;
#line 2340 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp4_ = _g_object_ref0 (GRANITE_WIDGETS_SOURCE_LIST_PATCH_IS_EXPANDABLE_ITEM (_tmp3_) ? ((GraniteWidgetsSourceListPatchExpandableItem*) _tmp3_) : NULL);
#line 2340 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		expandable_item = _tmp4_;
#line 2341 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp5_ = expandable_item;
#line 2341 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (_tmp5_ != NULL) {
#line 12422 "SourceList.c"
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			gboolean _tmp8_;
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_object_get (renderer, "is-expander", &_tmp7_, NULL);
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp8_ = _tmp7_;
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			if (_tmp8_) {
#line 12432 "SourceList.c"
				GraniteWidgetsSourceListPatchExpandableItem* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp9_ = expandable_item;
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp10_ = granite_widgets_source_list_patch_expandable_item_get_collapsible (_tmp9_);
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp11_ = _tmp10_;
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp6_ = _tmp11_;
#line 12444 "SourceList.c"
			} else {
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
				_tmp6_ = FALSE;
#line 12448 "SourceList.c"
			}
#line 2342 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_object_set (renderer, "is-expander", _tmp6_, NULL);
#line 12452 "SourceList.c"
		}
#line 2336 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (expandable_item);
#line 12456 "SourceList.c"
	}
#line 2345 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = self->priv->primary_expander_cell;
#line 2345 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
#line 12462 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModel* _tmp13_;
		GtkTreeIter _tmp14_;
#line 2346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp13_ = self->priv->_data_model;
#line 2346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp14_ = *iter;
#line 2346 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		gtk_cell_renderer_set_visible (renderer, !granite_widgets_source_list_patch_data_model_is_iter_at_root_level (_tmp13_, &_tmp14_));
#line 12471 "SourceList.c"
	} else {
		GraniteWidgetsCellRendererExpander* _tmp15_;
#line 2347 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp15_ = self->priv->secondary_expander_cell;
#line 2347 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		if (renderer == G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_cell_renderer_get_type (), GtkCellRenderer)) {
#line 12478 "SourceList.c"
			GraniteWidgetsSourceListPatchDataModel* _tmp16_;
			GraniteWidgetsSourceListPatchItem* _tmp17_;
			GtkTreeIter _tmp18_;
#line 2348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp16_ = self->priv->_data_model;
#line 2348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp17_ = item;
#line 2348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			_tmp18_ = *iter;
#line 2348 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			gtk_cell_renderer_set_visible (renderer, granite_widgets_source_list_patch_data_model_is_category (_tmp16_, _tmp17_, &_tmp18_, NULL));
#line 12490 "SourceList.c"
		} else {
#line 2350 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
			g_assert_not_reached ();
#line 12494 "SourceList.c"
		}
	}
#line 2332 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item);
#line 12499 "SourceList.c"
}

static GraniteWidgetsSourceListPatchDataModel*
granite_widgets_source_list_patch_tree_get_data_model (GraniteWidgetsSourceListPatchTree* self)
{
	GraniteWidgetsSourceListPatchDataModel* result;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->_data_model;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 12515 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_set_data_model (GraniteWidgetsSourceListPatchTree* self,
                                                       GraniteWidgetsSourceListPatchDataModel* value)
{
	GraniteWidgetsSourceListPatchDataModel* old_value;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	old_value = granite_widgets_source_list_patch_tree_get_data_model (self);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	if (old_value != value) {
#line 12529 "SourceList.c"
		GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		_g_object_unref0 (self->priv->_data_model);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		self->priv->_data_model = _tmp0_;
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY]);
#line 12539 "SourceList.c"
	}
}

static GraniteWidgetsSourceListPatchItem*
granite_widgets_source_list_patch_tree_get_selected_item (GraniteWidgetsSourceListPatchTree* self)
{
	GraniteWidgetsSourceListPatchItem* result;
	GraniteWidgetsSourceListPatchItem* _tmp0_;
#line 1447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->selected;
#line 1447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp0_;
#line 1447 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 12556 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_set_selected_item (GraniteWidgetsSourceListPatchTree* self,
                                                          GraniteWidgetsSourceListPatchItem* value)
{
#line 1448 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1448 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_set_selected (self, value, TRUE);
#line 1448 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY]);
#line 12569 "SourceList.c"
}

static gboolean
granite_widgets_source_list_patch_tree_get_editing (GraniteWidgetsSourceListPatchTree* self)
{
	gboolean result;
	GtkCellRendererText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->text_cell;
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_get ((GtkCellRenderer*) _tmp0_, "editing", &_tmp1_, NULL);
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 1452 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 12591 "SourceList.c"
}

static PangoEllipsizeMode
granite_widgets_source_list_patch_tree_get_ellipsize_mode (GraniteWidgetsSourceListPatchTree* self)
{
	PangoEllipsizeMode result;
	GtkCellRendererText* _tmp0_;
	PangoEllipsizeMode _tmp1_;
	PangoEllipsizeMode _tmp2_;
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->text_cell;
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_get (_tmp0_, "ellipsize", &_tmp1_, NULL);
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = _tmp1_;
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	result = _tmp2_;
#line 1456 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 12613 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_set_ellipsize_mode (GraniteWidgetsSourceListPatchTree* self,
                                                           PangoEllipsizeMode value)
{
	GtkCellRendererText* _tmp0_;
#line 1457 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_return_if_fail (self != NULL);
#line 1457 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->text_cell;
#line 1457 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp0_, "ellipsize", value, NULL);
#line 1457 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY]);
#line 12629 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_expander_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                           GtkCellRenderer* cell,
                                                                                           GtkTreeModel* tree_model,
                                                                                           GtkTreeIter* iter,
                                                                                           gpointer self)
{
#line 1547 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_expander_cell_data_func ((GraniteWidgetsSourceListPatchTree*) self, cell_layout, cell, tree_model, iter);
#line 12641 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_on_activatable_activated_granite_widgets_source_list_patch_cell_renderer_icon_activated (GraniteWidgetsSourceListPatchCellRendererIcon* _sender,
                                                                                                                                 const gchar* path,
                                                                                                                                 gpointer self)
{
#line 1551 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_activatable_activated ((GraniteWidgetsSourceListPatchTree*) self, path);
#line 12651 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                       GtkCellRenderer* cell,
                                                                                       GtkTreeModel* tree_model,
                                                                                       GtkTreeIter* iter,
                                                                                       gpointer self)
{
#line 1553 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_icon_cell_data_func ((GraniteWidgetsSourceListPatchTree*) self, cell_layout, cell, tree_model, iter);
#line 12663 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_badge_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                        GtkCellRenderer* cell,
                                                                                        GtkTreeModel* tree_model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self)
{
#line 1559 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_badge_cell_data_func ((GraniteWidgetsSourceListPatchTree*) self, cell_layout, cell, tree_model, iter);
#line 12675 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_on_editing_started_gtk_cell_renderer_editing_started (GtkCellRenderer* _sender,
                                                                                              GtkCellEditable* editable,
                                                                                              const gchar* path,
                                                                                              gpointer self)
{
#line 1564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_editing_started ((GraniteWidgetsSourceListPatchTree*) self, editable, path);
#line 12686 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled (GtkCellRenderer* _sender,
                                                                                                gpointer self)
{
#line 1565 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_on_editing_canceled ((GraniteWidgetsSourceListPatchTree*) self);
#line 12695 "SourceList.c"
}

static void
_granite_widgets_source_list_patch_tree_name_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                                       GtkCellRenderer* cell,
                                                                                       GtkTreeModel* tree_model,
                                                                                       GtkTreeIter* iter,
                                                                                       gpointer self)
{
#line 1569 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_name_cell_data_func ((GraniteWidgetsSourceListPatchTree*) self, cell_layout, cell, tree_model, iter);
#line 12707 "SourceList.c"
}

static gboolean
_granite_widgets_source_list_patch_tree_select_func_gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                             GtkTreeModel* model,
                                                                             GtkTreePath* path,
                                                                             gboolean path_currently_selected,
                                                                             gpointer self)
{
	gboolean result;
	result = granite_widgets_source_list_patch_tree_select_func ((GraniteWidgetsSourceListPatchTree*) self, selection, model, path, path_currently_selected);
#line 1589 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return result;
#line 12721 "SourceList.c"
}

static GObject *
granite_widgets_source_list_patch_tree_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListPatchTree * self;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GraniteWidgetsSourceListPatchDataModel* _tmp2_;
	GtkTreeViewColumn* item_column = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GraniteWidgetsCellRendererExpander* _tmp6_;
	GraniteWidgetsCellRendererExpander* _tmp7_;
	GraniteWidgetsCellRendererExpander* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GraniteWidgetsCellRendererExpander* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GraniteWidgetsCellRendererExpander* _tmp12_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp13_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp14_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp19_;
	GraniteWidgetsCellRendererBadge* _tmp20_;
	GraniteWidgetsCellRendererBadge* _tmp21_;
	GraniteWidgetsCellRendererBadge* _tmp22_;
	GtkTreeViewColumn* _tmp23_;
	GraniteWidgetsCellRendererBadge* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GraniteWidgetsCellRendererBadge* _tmp26_;
	GtkCellRendererText* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkCellRendererText* _tmp31_;
	GtkCellRendererText* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkTreeViewColumn* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeViewColumn* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp38_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp39_;
	GtkTreeViewColumn* _tmp40_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp41_;
	GtkTreeViewColumn* _tmp42_;
	GraniteWidgetsSourceListPatchCellRendererIcon* _tmp43_;
	GraniteWidgetsCellRendererExpander* _tmp44_;
	gint expander_spacing = 0;
	gint _tmp45_ = 0;
	GraniteWidgetsCellRendererExpander* _tmp46_;
	GtkTreeViewColumn* _tmp47_;
	GraniteWidgetsCellRendererExpander* _tmp48_;
	GtkTreeViewColumn* _tmp49_;
	GraniteWidgetsCellRendererExpander* _tmp50_;
	GtkTreeSelection* selection = NULL;
	GtkTreeSelection* _tmp51_;
	GtkTreeSelection* _tmp52_;
	GtkTreeSelection* _tmp53_;
	GtkTreeSelection* _tmp54_;
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_patch_tree_parent_class);
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTree);
#line 1516 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_utils_set_theming ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DEFAULT_STYLESHEET, GRANITE_STYLE_CLASS_SOURCE_LIST, GTK_STYLE_PROVIDER_PRIORITY_FALLBACK);
#line 1516 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1516 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (_tmp1_);
#line 1519 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->_data_model;
#line 1519 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) _tmp2_);
#line 1521 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
#line 1521 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
#line 1522 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
#line 1524 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_set_enable_search ((GtkTreeView*) self, FALSE);
#line 1525 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_set_headers_visible ((GtkTreeView*) self, FALSE);
#line 1526 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkTreeView*) self, "enable-grid-lines", GTK_TREE_VIEW_GRID_LINES_NONE, NULL);
#line 1529 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_set_expander_column ((GtkTreeView*) self, NULL);
#line 1530 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_set_show_expanders ((GtkTreeView*) self, FALSE);
#line 1532 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = gtk_tree_view_column_new ();
#line 1532 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp3_);
#line 1532 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	item_column = _tmp3_;
#line 1533 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = item_column;
#line 1533 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_column_set_expand (_tmp4_, TRUE);
#line 1535 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = item_column;
#line 1535 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_view_insert_column ((GtkTreeView*) self, _tmp5_, (gint) GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_COLUMN_ITEM);
#line 1543 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp6_ = granite_widgets_cell_renderer_expander_new ();
#line 1543 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp6_);
#line 1543 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->secondary_expander_cell);
#line 1543 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->secondary_expander_cell = _tmp6_;
#line 1544 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp7_ = self->priv->secondary_expander_cell;
#line 1544 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_cell_renderer_expander_set_is_category_expander (_tmp7_, TRUE);
#line 1545 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp8_ = self->priv->secondary_expander_cell;
#line 1545 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp8_, "xpad", (guint) 10, NULL);
#line 1546 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp9_ = item_column;
#line 1546 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp10_ = self->priv->secondary_expander_cell;
#line 1546 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, FALSE);
#line 1547 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp11_ = item_column;
#line 1547 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp12_ = self->priv->secondary_expander_cell;
#line 1547 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) _tmp12_, _granite_widgets_source_list_patch_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1549 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp13_ = granite_widgets_source_list_patch_cell_renderer_icon_new ();
#line 1549 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp13_);
#line 1549 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->activatable_cell);
#line 1549 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->activatable_cell = _tmp13_;
#line 1550 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp14_ = self->priv->activatable_cell;
#line 1550 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp14_, "xpad", (guint) 6, NULL);
#line 1551 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp15_ = self->priv->activatable_cell;
#line 1551 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (_tmp15_, "activated", (GCallback) _granite_widgets_source_list_patch_tree_on_activatable_activated_granite_widgets_source_list_patch_cell_renderer_icon_activated, self, 0);
#line 1552 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp16_ = item_column;
#line 1552 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp17_ = self->priv->activatable_cell;
#line 1552 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) _tmp17_, FALSE);
#line 1553 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp18_ = item_column;
#line 1553 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp19_ = self->priv->activatable_cell;
#line 1553 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, _granite_widgets_source_list_patch_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1555 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp20_ = granite_widgets_cell_renderer_badge_new ();
#line 1555 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp20_);
#line 1555 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->badge_cell);
#line 1555 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->badge_cell = _tmp20_;
#line 1556 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp21_ = self->priv->badge_cell;
#line 1556 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp21_, "xpad", (guint) 1, NULL);
#line 1557 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp22_ = self->priv->badge_cell;
#line 1557 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp22_, "xalign", (gfloat) 1, NULL);
#line 1558 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp23_ = item_column;
#line 1558 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp24_ = self->priv->badge_cell;
#line 1558 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp23_, (GtkCellRenderer*) _tmp24_, FALSE);
#line 1559 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp25_ = item_column;
#line 1559 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp26_ = self->priv->badge_cell;
#line 1559 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp25_, (GtkCellRenderer*) _tmp26_, _granite_widgets_source_list_patch_tree_badge_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1561 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1561 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp27_);
#line 1561 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->text_cell);
#line 1561 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->text_cell = _tmp27_;
#line 1562 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp28_ = self->priv->text_cell;
#line 1562 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp28_, "editable-set", TRUE, NULL);
#line 1563 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp29_ = self->priv->text_cell;
#line 1563 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp29_, "editable", FALSE, NULL);
#line 1564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp30_ = self->priv->text_cell;
#line 1564 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object ((GtkCellRenderer*) _tmp30_, "editing-started", (GCallback) _granite_widgets_source_list_patch_tree_on_editing_started_gtk_cell_renderer_editing_started, self, 0);
#line 1565 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp31_ = self->priv->text_cell;
#line 1565 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object ((GtkCellRenderer*) _tmp31_, "editing-canceled", (GCallback) _granite_widgets_source_list_patch_tree_on_editing_canceled_gtk_cell_renderer_editing_canceled, self, 0);
#line 1566 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp32_ = self->priv->text_cell;
#line 1566 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set (_tmp32_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
#line 1567 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp33_ = self->priv->text_cell;
#line 1567 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp33_, "xalign", (gfloat) 0, NULL);
#line 1568 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp34_ = item_column;
#line 1568 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp35_ = self->priv->text_cell;
#line 1568 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp34_, (GtkCellRenderer*) _tmp35_, TRUE);
#line 1569 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp36_ = item_column;
#line 1569 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp37_ = self->priv->text_cell;
#line 1569 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp36_, (GtkCellRenderer*) _tmp37_, _granite_widgets_source_list_patch_tree_name_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1571 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp38_ = granite_widgets_source_list_patch_cell_renderer_icon_new ();
#line 1571 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp38_);
#line 1571 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->icon_cell);
#line 1571 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->icon_cell = _tmp38_;
#line 1572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp39_ = self->priv->icon_cell;
#line 1572 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp39_, "xpad", (guint) 2, NULL);
#line 1573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp40_ = item_column;
#line 1573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp41_ = self->priv->icon_cell;
#line 1573 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp40_, (GtkCellRenderer*) _tmp41_, FALSE);
#line 1574 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp42_ = item_column;
#line 1574 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp43_ = self->priv->icon_cell;
#line 1574 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) _tmp43_, _granite_widgets_source_list_patch_tree_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1577 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp44_ = granite_widgets_cell_renderer_expander_new ();
#line 1577 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp44_);
#line 1577 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->primary_expander_cell);
#line 1577 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->primary_expander_cell = _tmp44_;
#line 1580 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_style_get ((GtkWidget*) self, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_EXPANDER_SPACING, &_tmp45_, NULL);
#line 1580 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	expander_spacing = _tmp45_;
#line 1581 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp46_ = self->priv->primary_expander_cell;
#line 1581 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_set ((GtkCellRenderer*) _tmp46_, "xpad", (guint) (expander_spacing / 2), NULL);
#line 1583 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp47_ = item_column;
#line 1583 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp48_ = self->priv->primary_expander_cell;
#line 1583 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp47_, (GtkCellRenderer*) _tmp48_, FALSE);
#line 1584 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp49_ = item_column;
#line 1584 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp50_ = self->priv->primary_expander_cell;
#line 1584 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp49_, (GtkCellRenderer*) _tmp50_, _granite_widgets_source_list_patch_tree_expander_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
#line 1587 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp51_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
#line 1587 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1587 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	selection = _tmp52_;
#line 1588 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp53_ = selection;
#line 1588 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_selection_set_mode (_tmp53_, GTK_SELECTION_BROWSE);
#line 1589 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp54_ = selection;
#line 1589 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_tree_selection_set_select_function (_tmp54_, _granite_widgets_source_list_patch_tree_select_func_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
#line 1592 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_enable_item_property_monitor (self);
#line 1595 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_add_spacer_cell_for_level (self, 1, TRUE);
#line 1598 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_source (self, NULL, (gint) 0);
#line 1599 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_configure_drag_dest (self, NULL, (gint) 0, 0);
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (selection);
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (item_column);
#line 1515 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return obj;
#line 13044 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_class_init (GraniteWidgetsSourceListPatchTreeClass * klass,
                                                   gpointer klass_data)
{
	GParamSpecInt* _tmp0_;
	GParamSpecInt* _tmp1_;
	GParamSpecInt* _tmp2_;
	GParamSpecInt* _tmp3_;
	GParamSpecInt* _tmp4_;
	GParamSpecInt* _tmp5_;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_parent_class = g_type_class_peek_parent (klass);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatchTree_private_offset);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) granite_widgets_source_list_patch_tree_real_drag_motion;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) granite_widgets_source_list_patch_tree_real_drag_data_received;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkTreeViewClass *) klass)->cursor_changed = (void (*) (GtkTreeView*)) granite_widgets_source_list_patch_tree_real_cursor_changed;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkTreeViewClass *) klass)->row_expanded = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) granite_widgets_source_list_patch_tree_real_row_expanded;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkTreeViewClass *) klass)->row_collapsed = (void (*) (GtkTreeView*, GtkTreeIter*, GtkTreePath*)) granite_widgets_source_list_patch_tree_real_row_collapsed;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkTreeViewClass *) klass)->row_activated = (void (*) (GtkTreeView*, GtkTreePath*, GtkTreeViewColumn*)) granite_widgets_source_list_patch_tree_real_row_activated;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->key_release_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) granite_widgets_source_list_patch_tree_real_key_release_event;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) granite_widgets_source_list_patch_tree_real_button_release_event;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) granite_widgets_source_list_patch_tree_real_button_press_event;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GtkWidgetClass *) klass)->popup_menu = (gboolean (*) (GtkWidget*)) granite_widgets_source_list_patch_tree_real_popup_menu;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_tree_get_property;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_tree_set_property;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_patch_tree_constructor;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_tree_finalize;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY] = g_param_spec_object ("data-model", "data-model", "data-model", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_DATA_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_EDITING_PROPERTY, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY, granite_widgets_source_list_patch_tree_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 1492 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEVEL_INDENTATION, "Level Indentation", "Space to add at the beginning of every indentation level. Must be an e" \
"ven number.", 1, 50, 6, G_PARAM_READABLE);
#line 1492 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = _tmp0_;
#line 1492 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp1_);
#line 1492 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_param_spec_unref0 (_tmp1_);
#line 1498 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_LEFT_PADDING, "Left Padding", "Padding added to the left side of the tree. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
#line 1498 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = _tmp2_;
#line 1498 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp3_);
#line 1498 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_param_spec_unref0 (_tmp3_);
#line 1504 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp4_ = (GParamSpecInt*) g_param_spec_int (GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_STYLE_PROP_EXPANDER_SPACING, "Expander Spacing", "Space added between an item and its expander. Must be an even number.", 1, 50, 4, G_PARAM_READABLE);
#line 1504 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp5_ = _tmp4_;
#line 1504 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_class_install_style_property (GTK_WIDGET_CLASS (klass), (GParamSpec*) _tmp5_);
#line 1504 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_param_spec_unref0 (_tmp5_);
#line 13123 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_instance_init (GraniteWidgetsSourceListPatchTree * self,
                                                      gpointer klass)
{
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_tree_get_instance_private (self);
#line 1476 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->unselectable_item_clicked = FALSE;
#line 13134 "SourceList.c"
}

static void
granite_widgets_source_list_patch_tree_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatchTree * self;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTree);
#line 1603 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_tree_disable_item_property_monitor (self);
#line 1442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->_data_model);
#line 1465 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->selected);
#line 1468 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->editable_entry);
#line 1469 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->text_cell);
#line 1470 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->icon_cell);
#line 1471 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->activatable_cell);
#line 1472 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->badge_cell);
#line 1473 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->primary_expander_cell);
#line 1474 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->secondary_expander_cell);
#line 1475 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->spacer_cells);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_tree_parent_class)->finalize (obj);
#line 13167 "SourceList.c"
}

/**
         * The tree that actually displays the items.
         *
         * All the user interaction happens here.
         */
static GType
granite_widgets_source_list_patch_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatchTree), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_tree_instance_init, NULL };
	GType granite_widgets_source_list_patch_tree_type_id;
	granite_widgets_source_list_patch_tree_type_id = g_type_register_static (gtk_tree_view_get_type (), "GraniteWidgetsSourceListPatchTree", &g_define_type_info, 0);
	GraniteWidgetsSourceListPatchTree_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_tree_type_id, sizeof (GraniteWidgetsSourceListPatchTreePrivate));
	return granite_widgets_source_list_patch_tree_type_id;
}

static GType
granite_widgets_source_list_patch_tree_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_tree_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_tree_type_id__once)) {
		GType granite_widgets_source_list_patch_tree_type_id;
		granite_widgets_source_list_patch_tree_type_id = granite_widgets_source_list_patch_tree_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_tree_type_id__once, granite_widgets_source_list_patch_tree_type_id);
	}
	return granite_widgets_source_list_patch_tree_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_tree_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTree);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_tree_get_data_model (self));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_tree_get_selected_item (self));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_EDITING_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_tree_get_editing (self));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_enum (value, granite_widgets_source_list_patch_tree_get_ellipsize_mode (self));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13231 "SourceList.c"
		default:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13237 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_tree_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatchTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_TREE, GraniteWidgetsSourceListPatchTree);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_DATA_MODEL_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_set_data_model (self, g_value_get_object (value));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_SELECTED_ITEM_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_set_selected_item (self, g_value_get_object (value));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_TREE_ELLIPSIZE_MODE_PROPERTY:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_tree_set_ellipsize_mode (self, g_value_get_enum (value));
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13269 "SourceList.c"
		default:
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 1440 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13275 "SourceList.c"
	}
}

static void
_granite_widgets_source_list_patch___lambda55_ (GraniteWidgetsSourceListPatch* self,
                                                GraniteWidgetsSourceListPatchItem* item)
{
#line 2461 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_emit (self, granite_widgets_source_list_patch_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTED_SIGNAL], 0, item);
#line 13285 "SourceList.c"
}

static void
__granite_widgets_source_list_patch___lambda55__granite_widgets_source_list_patch_tree_item_selected (GraniteWidgetsSourceListPatchTree* _sender,
                                                                                                      GraniteWidgetsSourceListPatchItem* item,
                                                                                                      gpointer self)
{
#line 2461 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_granite_widgets_source_list_patch___lambda55_ ((GraniteWidgetsSourceListPatch*) self, item);
#line 13295 "SourceList.c"
}

static GObject *
granite_widgets_source_list_patch_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsSourceListPatch * self;
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
	GraniteWidgetsSourceListPatchTree* _tmp1_;
	GraniteWidgetsSourceListPatchTree* _tmp2_;
	GraniteWidgetsSourceListPatchTree* _tmp3_;
#line 2454 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	parent_class = G_OBJECT_CLASS (granite_widgets_source_list_patch_parent_class);
#line 2454 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 2454 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatch);
#line 2455 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = self->priv->data_model;
#line 2455 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp1_ = granite_widgets_source_list_patch_tree_new (_tmp0_);
#line 2455 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_ref_sink (_tmp1_);
#line 2455 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->tree);
#line 2455 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->tree = _tmp1_;
#line 2457 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 2458 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp2_ = self->priv->tree;
#line 2458 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
#line 2459 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 2461 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp3_ = self->priv->tree;
#line 2461 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_signal_connect_object (_tmp3_, "item-selected", (GCallback) __granite_widgets_source_list_patch___lambda55__granite_widgets_source_list_patch_tree_item_selected, self, 0);
#line 2454 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	return obj;
#line 13340 "SourceList.c"
}

static void
granite_widgets_source_list_patch_class_init (GraniteWidgetsSourceListPatchClass * klass,
                                              gpointer klass_data)
{
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_parent_class = g_type_class_peek_parent (klass);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsSourceListPatch_private_offset);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	((GraniteWidgetsSourceListPatchClass *) klass)->item_selected = granite_widgets_source_list_patch_real_item_selected;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_source_list_patch_get_property;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_source_list_patch_set_property;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_source_list_patch_constructor;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_source_list_patch_finalize;
#line 13361 "SourceList.c"
	/**
	         * Root-level expandable item.
	         *
	         * This item contains the first-level source list items. It //only serves as an item container//.
	         * It is used to add and remove items to/from the widget.
	         *
	         * Internally, it allows the source list to connect to its {@link Granite.Widgets.SourceListPatch.ExpandableItem.child_added}
	         * and {@link Granite.Widgets.SourceListPatch.ExpandableItem.child_removed} signals in order to monitor
	         * new children additions/removals.
	         *
	         * @since 0.2
	         */
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY] = g_param_spec_object ("root", "root", "root", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_EXPANDABLE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 13376 "SourceList.c"
	/**
	         * The current selected item.
	         *
	         * Setting it to //null// un-selects the previously selected item, if there was any.
	         * {@link Granite.Widgets.SourceListPatch.ExpandableItem.expand_with_parents} is called on the
	         * item's parent to make sure it's possible to select it.
	         *
	         * @since 0.2
	         */
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY] = g_param_spec_object ("selected", "selected", "selected", GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 13388 "SourceList.c"
	/**
	         * Text ellipsize mode.
	         *
	         * @since 0.2
	         */
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY] = g_param_spec_enum ("ellipsize-mode", "ellipsize-mode", "ellipsize-mode", pango_ellipsize_mode_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 13396 "SourceList.c"
	/**
	         * Whether an item is being edited.
	         *
	         * @see Granite.Widgets.SourceListPatch.start_editing_item
	         * @since 0.2
	         */
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_SOURCE_LIST_PATCH_EDITING_PROPERTY, granite_widgets_source_list_patch_properties[GRANITE_WIDGETS_SOURCE_LIST_PATCH_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 13405 "SourceList.c"
	/**
	         * Emitted when the source list selection changes.
	         *
	         * @param item Selected item; //null// if nothing is selected.
	         * @since 0.2
	         */
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	granite_widgets_source_list_patch_signals[GRANITE_WIDGETS_SOURCE_LIST_PATCH_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GraniteWidgetsSourceListPatchClass, item_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GRANITE_WIDGETS_SOURCE_LIST_PATCH_TYPE_ITEM);
#line 13414 "SourceList.c"
}

static void
granite_widgets_source_list_patch_instance_init (GraniteWidgetsSourceListPatch * self,
                                                 gpointer klass)
{
	GraniteWidgetsSourceListPatchDataModel* _tmp0_;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv = granite_widgets_source_list_patch_get_instance_private (self);
#line 2442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_tmp0_ = granite_widgets_source_list_patch_data_model_new ();
#line 2442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self->priv->data_model = _tmp0_;
#line 13428 "SourceList.c"
}

static void
granite_widgets_source_list_patch_finalize (GObject * obj)
{
	GraniteWidgetsSourceListPatch * self;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatch);
#line 2441 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->tree);
#line 2442 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	_g_object_unref0 (self->priv->data_model);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	G_OBJECT_CLASS (granite_widgets_source_list_patch_parent_class)->finalize (obj);
#line 13443 "SourceList.c"
}

static GType
granite_widgets_source_list_patch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsSourceListPatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_source_list_patch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsSourceListPatch), 0, (GInstanceInitFunc) granite_widgets_source_list_patch_instance_init, NULL };
	GType granite_widgets_source_list_patch_type_id;
	granite_widgets_source_list_patch_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "GraniteWidgetsSourceListPatch", &g_define_type_info, 0);
	GraniteWidgetsSourceListPatch_private_offset = g_type_add_instance_private (granite_widgets_source_list_patch_type_id, sizeof (GraniteWidgetsSourceListPatchPrivate));
	return granite_widgets_source_list_patch_type_id;
}

GType
granite_widgets_source_list_patch_get_type (void)
{
	static volatile gsize granite_widgets_source_list_patch_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_source_list_patch_type_id__once)) {
		GType granite_widgets_source_list_patch_type_id;
		granite_widgets_source_list_patch_type_id = granite_widgets_source_list_patch_get_type_once ();
		g_once_init_leave (&granite_widgets_source_list_patch_type_id__once, granite_widgets_source_list_patch_type_id);
	}
	return granite_widgets_source_list_patch_type_id__once;
}

static void
_vala_granite_widgets_source_list_patch_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatch);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_get_root (self));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_object (value, granite_widgets_source_list_patch_get_selected (self));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_enum (value, granite_widgets_source_list_patch_get_ellipsize_mode (self));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_EDITING_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		g_value_set_boolean (value, granite_widgets_source_list_patch_get_editing (self));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13502 "SourceList.c"
		default:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13508 "SourceList.c"
	}
}

static void
_vala_granite_widgets_source_list_patch_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GraniteWidgetsSourceListPatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_SOURCE_LIST_PATCH, GraniteWidgetsSourceListPatch);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
	switch (property_id) {
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ROOT_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_set_root (self, g_value_get_object (value));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_SELECTED_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_set_selected (self, g_value_get_object (value));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		case GRANITE_WIDGETS_SOURCE_LIST_PATCH_ELLIPSIZE_MODE_PROPERTY:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		granite_widgets_source_list_patch_set_ellipsize_mode (self, g_value_get_enum (value));
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13540 "SourceList.c"
		default:
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 133 "../Notes-up-2.0.6/src/GranitePatches/SourceList.vala"
		break;
#line 13546 "SourceList.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

