// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// ArtworkGetArtistUrlRequest is the request type for Artwork.GetArtistUrl.
type ArtworkGetArtistUrlRequest struct {
	Id   string `json:"id"`
	Size int32  `json:"size"`
}

// ArtworkGetArtistUrlResponse is the response type for Artwork.GetArtistUrl.
type ArtworkGetArtistUrlResponse struct {
	Url   string `json:"url,omitempty"`
	Error string `json:"error,omitempty"`
}

// ArtworkGetAlbumUrlRequest is the request type for Artwork.GetAlbumUrl.
type ArtworkGetAlbumUrlRequest struct {
	Id   string `json:"id"`
	Size int32  `json:"size"`
}

// ArtworkGetAlbumUrlResponse is the response type for Artwork.GetAlbumUrl.
type ArtworkGetAlbumUrlResponse struct {
	Url   string `json:"url,omitempty"`
	Error string `json:"error,omitempty"`
}

// ArtworkGetTrackUrlRequest is the request type for Artwork.GetTrackUrl.
type ArtworkGetTrackUrlRequest struct {
	Id   string `json:"id"`
	Size int32  `json:"size"`
}

// ArtworkGetTrackUrlResponse is the response type for Artwork.GetTrackUrl.
type ArtworkGetTrackUrlResponse struct {
	Url   string `json:"url,omitempty"`
	Error string `json:"error,omitempty"`
}

// ArtworkGetPlaylistUrlRequest is the request type for Artwork.GetPlaylistUrl.
type ArtworkGetPlaylistUrlRequest struct {
	Id   string `json:"id"`
	Size int32  `json:"size"`
}

// ArtworkGetPlaylistUrlResponse is the response type for Artwork.GetPlaylistUrl.
type ArtworkGetPlaylistUrlResponse struct {
	Url   string `json:"url,omitempty"`
	Error string `json:"error,omitempty"`
}

// RegisterArtworkHostFunctions registers Artwork service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterArtworkHostFunctions(service ArtworkService) []extism.HostFunction {
	return []extism.HostFunction{
		newArtworkGetArtistUrlHostFunction(service),
		newArtworkGetAlbumUrlHostFunction(service),
		newArtworkGetTrackUrlHostFunction(service),
		newArtworkGetPlaylistUrlHostFunction(service),
	}
}

func newArtworkGetArtistUrlHostFunction(service ArtworkService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"artwork_getartisturl",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				artworkWriteError(p, stack, err)
				return
			}
			var req ArtworkGetArtistUrlRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				artworkWriteError(p, stack, err)
				return
			}

			// Call the service method
			url, svcErr := service.GetArtistUrl(ctx, req.Id, req.Size)
			if svcErr != nil {
				artworkWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := ArtworkGetArtistUrlResponse{
				Url: url,
			}
			artworkWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newArtworkGetAlbumUrlHostFunction(service ArtworkService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"artwork_getalbumurl",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				artworkWriteError(p, stack, err)
				return
			}
			var req ArtworkGetAlbumUrlRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				artworkWriteError(p, stack, err)
				return
			}

			// Call the service method
			url, svcErr := service.GetAlbumUrl(ctx, req.Id, req.Size)
			if svcErr != nil {
				artworkWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := ArtworkGetAlbumUrlResponse{
				Url: url,
			}
			artworkWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newArtworkGetTrackUrlHostFunction(service ArtworkService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"artwork_gettrackurl",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				artworkWriteError(p, stack, err)
				return
			}
			var req ArtworkGetTrackUrlRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				artworkWriteError(p, stack, err)
				return
			}

			// Call the service method
			url, svcErr := service.GetTrackUrl(ctx, req.Id, req.Size)
			if svcErr != nil {
				artworkWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := ArtworkGetTrackUrlResponse{
				Url: url,
			}
			artworkWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newArtworkGetPlaylistUrlHostFunction(service ArtworkService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"artwork_getplaylisturl",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				artworkWriteError(p, stack, err)
				return
			}
			var req ArtworkGetPlaylistUrlRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				artworkWriteError(p, stack, err)
				return
			}

			// Call the service method
			url, svcErr := service.GetPlaylistUrl(ctx, req.Id, req.Size)
			if svcErr != nil {
				artworkWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := ArtworkGetPlaylistUrlResponse{
				Url: url,
			}
			artworkWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// artworkWriteResponse writes a JSON response to plugin memory.
func artworkWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		artworkWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// artworkWriteError writes an error response to plugin memory.
func artworkWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
