/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Register Bank Source Fragments                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_REGBANK_DECLARATIONS
#undef GET_REGBANK_DECLARATIONS
namespace llvm {
namespace SPIRV {
enum : unsigned {
  InvalidRegBankID = ~0u,
  IDRegBankID = 0,
  TYPERegBankID = 1,
  NumRegisterBanks,
};
} // end namespace SPIRV
} // end namespace llvm
#endif // GET_REGBANK_DECLARATIONS

#ifdef GET_TARGET_REGBANK_CLASS
#undef GET_TARGET_REGBANK_CLASS
private:
  static const RegisterBank *RegBanks[];
  static const unsigned Sizes[];

public:
  const RegisterBank &getRegBankFromRegClass(const TargetRegisterClass &RC, LLT Ty) const override;
protected:
  SPIRVGenRegisterBankInfo(unsigned HwMode = 0);

#endif // GET_TARGET_REGBANK_CLASS

#ifdef GET_TARGET_REGBANK_IMPL
#undef GET_TARGET_REGBANK_IMPL
namespace llvm {
namespace SPIRV {
const uint32_t IDRegBankCoverageData[] = {
    // 0-31
    (1u << (SPIRV::IDRegClassID - 0)) |
    (1u << (SPIRV::fIDRegClassID - 0)) |
    (1u << (SPIRV::iIDRegClassID - 0)) |
    (1u << (SPIRV::pIDRegClassID - 0)) |
    (1u << (SPIRV::vpIDRegClassID - 0)) |
    (1u << (SPIRV::vIDRegClassID - 0)) |
    (1u << (SPIRV::vfIDRegClassID - 0)) |
    0,
};
const uint32_t TYPERegBankCoverageData[] = {
    // 0-31
    (1u << (SPIRV::TYPERegClassID - 0)) |
    0,
};

constexpr RegisterBank IDRegBank(/* ID */ SPIRV::IDRegBankID, /* Name */ "IDBank", /* CoveredRegClasses */ IDRegBankCoverageData, /* NumRegClasses */ 9);
constexpr RegisterBank TYPERegBank(/* ID */ SPIRV::TYPERegBankID, /* Name */ "TYPEBank", /* CoveredRegClasses */ TYPERegBankCoverageData, /* NumRegClasses */ 9);
} // end namespace SPIRV

const RegisterBank *SPIRVGenRegisterBankInfo::RegBanks[] = {
    &SPIRV::IDRegBank,
    &SPIRV::TYPERegBank,
};

const unsigned SPIRVGenRegisterBankInfo::Sizes[] = {
    // Mode = 0 (Default)
    128,
    64,
};

SPIRVGenRegisterBankInfo::SPIRVGenRegisterBankInfo(unsigned HwMode)
    : RegisterBankInfo(RegBanks, SPIRV::NumRegisterBanks, Sizes, HwMode) {
  // Assert that RegBank indices match their ID's
#ifndef NDEBUG
  for (auto RB : enumerate(RegBanks))
    assert(RB.index() == RB.value()->getID() && "Index != ID");
#endif // NDEBUG
}
const RegisterBank &
SPIRVGenRegisterBankInfo::getRegBankFromRegClass(const TargetRegisterClass &RC, LLT) const {
  constexpr uint32_t InvalidRegBankID = uint32_t(SPIRV::InvalidRegBankID) & 3;
  static const uint32_t RegClass2RegBank[1] = {
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(SPIRV::IDRegBankID) << 2) | // IDRegClassID
    (uint32_t(SPIRV::TYPERegBankID) << 4) | // TYPERegClassID
    (uint32_t(SPIRV::IDRegBankID) << 6) | // fIDRegClassID
    (uint32_t(SPIRV::IDRegBankID) << 8) | // iIDRegClassID
    (uint32_t(SPIRV::IDRegBankID) << 10) | // pIDRegClassID
    (uint32_t(SPIRV::IDRegBankID) << 12) | // vpIDRegClassID
    (uint32_t(SPIRV::IDRegBankID) << 14) | // vIDRegClassID
    (uint32_t(SPIRV::IDRegBankID) << 16) // vfIDRegClassID
  };
  const unsigned RegClassID = RC.getID();
  if (LLVM_LIKELY(RegClassID < 9)) {
    unsigned RegBankID = (RegClass2RegBank[RegClassID / 16] >> ((RegClassID % 16) * 2)) & 3;
    if (RegBankID != InvalidRegBankID)
      return getRegBank(RegBankID);
  }
  llvm_unreachable(llvm::Twine("Target needs to handle register class ID 0x").concat(llvm::Twine::utohexstr(RegClassID)).str().c_str());
}
} // end namespace llvm
#endif // GET_TARGET_REGBANK_IMPL
