/* BackgroundBlurEffect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundBlurEffect.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cogl/cogl.h>
#include <mtk/mtk.h>
#include <graphene-gobject.h>

#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MIN_DOWNSCALE_SIZE 256.0f
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MAX_RADIUS 12.0f
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_FORCE_REFRESH_FRAMES 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT (greeter_compositor_background_blur_effect_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect))
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffectClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT))
#define GREETER_COMPOSITOR_IS_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT))
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffectClass))

typedef struct _GreeterCompositorBackgroundBlurEffect GreeterCompositorBackgroundBlurEffect;
typedef struct _GreeterCompositorBackgroundBlurEffectClass GreeterCompositorBackgroundBlurEffectClass;
typedef struct _GreeterCompositorBackgroundBlurEffectPrivate GreeterCompositorBackgroundBlurEffectPrivate;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _clutter_paint_node_unref0(var) ((var == NULL) ? NULL : (var = (clutter_paint_node_unref (var), NULL)))

struct _GreeterCompositorBackgroundBlurEffect {
	ClutterEffect parent_instance;
	GreeterCompositorBackgroundBlurEffectPrivate * priv;
};

struct _GreeterCompositorBackgroundBlurEffectClass {
	ClutterEffectClass parent_class;
};

struct _GreeterCompositorBackgroundBlurEffectPrivate {
	gfloat _blur_radius;
	gfloat _clip_radius;
	gfloat _monitor_scale;
	gfloat real_blur_radius;
	gfloat downscale_factor;
	gint texture_width;
	gint texture_height;
	CoglFramebuffer* actor_framebuffer;
	CoglPipeline* actor_pipeline;
	CoglTexture* actor_texture;
	CoglFramebuffer* background_framebuffer;
	CoglPipeline* background_pipeline;
	CoglTexture* background_texture;
	CoglFramebuffer* round_framebuffer;
	CoglPipeline* round_pipeline;
	CoglTexture* round_texture;
	gint round_clip_radius_location;
	gint round_actor_size_location;
	gint frame_counter;
};

static gint GreeterCompositorBackgroundBlurEffect_private_offset;
static gpointer greeter_compositor_background_blur_effect_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_background_blur_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundBlurEffect, g_object_unref)
VALA_EXTERN GreeterCompositorBackgroundBlurEffect* greeter_compositor_background_blur_effect_new (gfloat blur_radius,
                                                                                      gfloat clip_radius,
                                                                                      gfloat monitor_scale);
VALA_EXTERN GreeterCompositorBackgroundBlurEffect* greeter_compositor_background_blur_effect_construct (GType object_type,
                                                                                            gfloat blur_radius,
                                                                                            gfloat clip_radius,
                                                                                            gfloat monitor_scale);
static void greeter_compositor_background_blur_effect_real_set_actor (ClutterActorMeta* base,
                                                               ClutterActor* new_actor);
static void greeter_compositor_background_blur_effect_update_actor_size (GreeterCompositorBackgroundBlurEffect* self);
static void _greeter_compositor_background_blur_effect_update_actor_size_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static void greeter_compositor_background_blur_effect_update_clip_radius (GreeterCompositorBackgroundBlurEffect* self);
VALA_EXTERN gfloat greeter_compositor_background_blur_effect_get_clip_radius (GreeterCompositorBackgroundBlurEffect* self);
VALA_EXTERN gfloat greeter_compositor_background_blur_effect_get_monitor_scale (GreeterCompositorBackgroundBlurEffect* self);
static void greeter_compositor_background_blur_effect_update_actor_box (GreeterCompositorBackgroundBlurEffect* self,
                                                                 ClutterPaintContext* paint_context,
                                                                 ClutterActorBox* source_actor_box);
static gfloat greeter_compositor_background_blur_effect_calculate_downscale_factor (GreeterCompositorBackgroundBlurEffect* self,
                                                                             gfloat width,
                                                                             gfloat height,
                                                                             gfloat radius);
static void greeter_compositor_background_blur_effect_setup_projection_matrix (GreeterCompositorBackgroundBlurEffect* self,
                                                                        CoglFramebuffer* framebuffer,
                                                                        gfloat width,
                                                                        gfloat height);
static gboolean greeter_compositor_background_blur_effect_update_actor_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                                     gint width,
                                                                     gint height,
                                                                     gfloat downscale_factor);
static gboolean greeter_compositor_background_blur_effect_update_rounded_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                                       gint width,
                                                                       gint height,
                                                                       gfloat downscale_factor);
static gboolean greeter_compositor_background_blur_effect_update_background_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                                          gint width,
                                                                          gint height);
static gboolean greeter_compositor_background_blur_effect_update_framebuffers (GreeterCompositorBackgroundBlurEffect* self,
                                                                        ClutterPaintContext* paint_context,
                                                                        ClutterActorBox* actor_box);
static ClutterPaintNode* greeter_compositor_background_blur_effect_create_blur_nodes (GreeterCompositorBackgroundBlurEffect* self,
                                                                               ClutterPaintNode* node);
static void greeter_compositor_background_blur_effect_add_actor_node (GreeterCompositorBackgroundBlurEffect* self,
                                                               ClutterPaintNode* node);
static void greeter_compositor_background_blur_effect_paint_background (GreeterCompositorBackgroundBlurEffect* self,
                                                                 ClutterPaintNode* node,
                                                                 ClutterPaintContext* paint_context,
                                                                 ClutterActorBox* source_actor_box);
static void greeter_compositor_background_blur_effect_real_paint_node (ClutterEffect* base,
                                                                ClutterPaintNode* node,
                                                                ClutterPaintContext* paint_context,
                                                                ClutterEffectPaintFlags flags);
VALA_EXTERN gfloat greeter_compositor_background_blur_effect_get_blur_radius (GreeterCompositorBackgroundBlurEffect* self);
static void greeter_compositor_background_blur_effect_real_paint (ClutterEffect* base,
                                                           ClutterPaintNode* node,
                                                           ClutterPaintContext* paint_context,
                                                           ClutterEffectPaintFlags flags);
static void greeter_compositor_background_blur_effect_set_blur_radius (GreeterCompositorBackgroundBlurEffect* self,
                                                                gfloat value);
static void greeter_compositor_background_blur_effect_set_clip_radius (GreeterCompositorBackgroundBlurEffect* self,
                                                                gfloat value);
VALA_EXTERN void greeter_compositor_background_blur_effect_set_monitor_scale (GreeterCompositorBackgroundBlurEffect* self,
                                                                  gfloat value);
static GObject * greeter_compositor_background_blur_effect_constructor (GType type,
                                                                 guint n_construct_properties,
                                                                 GObjectConstructParam * construct_properties);
static void _greeter_compositor_background_blur_effect_update_clip_radius_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self);
static void greeter_compositor_background_blur_effect_finalize (GObject * obj);
static GType greeter_compositor_background_blur_effect_get_type_once (void);
static void _vala_greeter_compositor_background_blur_effect_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_greeter_compositor_background_blur_effect_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);

static inline gpointer
greeter_compositor_background_blur_effect_get_instance_private (GreeterCompositorBackgroundBlurEffect* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBackgroundBlurEffect_private_offset);
}

GreeterCompositorBackgroundBlurEffect*
greeter_compositor_background_blur_effect_construct (GType object_type,
                                                     gfloat blur_radius,
                                                     gfloat clip_radius,
                                                     gfloat monitor_scale)
{
	GreeterCompositorBackgroundBlurEffect * self = NULL;
	self = (GreeterCompositorBackgroundBlurEffect*) g_object_new (object_type, "blur-radius", blur_radius, "clip-radius", clip_radius, "monitor-scale", monitor_scale, NULL);
	return self;
}

GreeterCompositorBackgroundBlurEffect*
greeter_compositor_background_blur_effect_new (gfloat blur_radius,
                                               gfloat clip_radius,
                                               gfloat monitor_scale)
{
	return greeter_compositor_background_blur_effect_construct (GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, blur_radius, clip_radius, monitor_scale);
}

static void
_greeter_compositor_background_blur_effect_update_actor_size_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	greeter_compositor_background_blur_effect_update_actor_size ((GreeterCompositorBackgroundBlurEffect*) self);
}

static void
greeter_compositor_background_blur_effect_real_set_actor (ClutterActorMeta* base,
                                                          ClutterActor* new_actor)
{
	GreeterCompositorBackgroundBlurEffect * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	self = (GreeterCompositorBackgroundBlurEffect*) base;
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		guint _tmp8_;
		GQuark _tmp9_;
		_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp3_ = _tmp2_;
		g_signal_parse_name ("notify::width", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _greeter_compositor_background_blur_effect_update_actor_size_g_object_notify, self);
		_tmp6_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp7_ = _tmp6_;
		g_signal_parse_name ("notify::height", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _greeter_compositor_background_blur_effect_update_actor_size_g_object_notify, self);
	}
	CLUTTER_ACTOR_META_CLASS (greeter_compositor_background_blur_effect_parent_class)->set_actor ((ClutterActorMeta*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_effect_get_type (), ClutterEffect), new_actor);
	_tmp10_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ClutterActor* _tmp12_;
		ClutterActor* _tmp13_;
		ClutterActor* _tmp14_;
		ClutterActor* _tmp15_;
		_tmp12_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp13_ = _tmp12_;
		g_signal_connect_object ((GObject*) _tmp13_, "notify::width", (GCallback) _greeter_compositor_background_blur_effect_update_actor_size_g_object_notify, self, 0);
		_tmp14_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp15_ = _tmp14_;
		g_signal_connect_object ((GObject*) _tmp15_, "notify::height", (GCallback) _greeter_compositor_background_blur_effect_update_actor_size_g_object_notify, self, 0);
		greeter_compositor_background_blur_effect_update_actor_size (self);
	}
}

static void
greeter_compositor_background_blur_effect_update_clip_radius (GreeterCompositorBackgroundBlurEffect* self)
{
	gfloat* _clip_radius = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat* _tmp2_;
	gint _clip_radius_length1;
	gint __clip_radius_size_;
	CoglPipeline* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_clip_radius;
	_tmp1_ = self->priv->_monitor_scale;
	_tmp2_ = g_new0 (gfloat, 1);
	_tmp2_[0] = _tmp0_ * _tmp1_;
	_clip_radius = _tmp2_;
	_clip_radius_length1 = 1;
	__clip_radius_size_ = _clip_radius_length1;
	_tmp3_ = self->priv->round_pipeline;
	cogl_pipeline_set_uniform_float (_tmp3_, self->priv->round_clip_radius_location, 1, 1, _clip_radius);
	_clip_radius = (g_free (_clip_radius), NULL);
}

static void
greeter_compositor_background_blur_effect_update_actor_size (GreeterCompositorBackgroundBlurEffect* self)
{
	gfloat* actor_size = NULL;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gfloat* _tmp8_;
	gint actor_size_length1;
	gint _actor_size_size_;
	CoglPipeline* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clutter_actor_get_width (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_get_height (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (gfloat, 2);
	_tmp8_[0] = _tmp3_;
	_tmp8_[1] = _tmp7_;
	actor_size = _tmp8_;
	actor_size_length1 = 2;
	_actor_size_size_ = actor_size_length1;
	_tmp9_ = self->priv->round_pipeline;
	cogl_pipeline_set_uniform_float (_tmp9_, self->priv->round_actor_size_location, 2, 1, actor_size);
	actor_size = (g_free (actor_size), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_background_blur_effect_update_actor_box (GreeterCompositorBackgroundBlurEffect* self,
                                                            ClutterPaintContext* paint_context,
                                                            ClutterActorBox* source_actor_box)
{
	gfloat box_scale_factor = 0.0F;
	gfloat origin_x = 0.0F;
	gfloat origin_y = 0.0F;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	ClutterStageView* stage_view = NULL;
	ClutterStageView* _tmp0_;
	ClutterStageView* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gfloat _tmp8_ = 0.0F;
	gfloat _tmp9_ = 0.0F;
	ClutterStageView* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (paint_context != NULL);
	g_return_if_fail (source_actor_box != NULL);
	box_scale_factor = 1.0f;
	_tmp0_ = clutter_paint_context_get_stage_view (paint_context);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	stage_view = _tmp1_;
	_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp3_ = _tmp2_;
	clutter_actor_get_transformed_position (_tmp3_, &_tmp4_, &_tmp5_);
	origin_x = _tmp4_;
	origin_y = _tmp5_;
	_tmp6_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp7_ = _tmp6_;
	clutter_actor_get_transformed_size (_tmp7_, &_tmp8_, &_tmp9_);
	width = _tmp8_;
	height = _tmp9_;
	_tmp10_ = stage_view;
	if (_tmp10_ != NULL) {
		MtkRectangle stage_view_layout = {0};
		MtkRectangle _tmp11_ = {0};
		ClutterStageView* _tmp12_;
		ClutterStageView* _tmp13_;
		MtkRectangle _tmp14_;
		MtkRectangle _tmp15_;
		stage_view_layout = _tmp11_;
		_tmp12_ = stage_view;
		box_scale_factor = clutter_stage_view_get_scale (_tmp12_);
		_tmp13_ = stage_view;
		clutter_stage_view_get_layout (_tmp13_, &stage_view_layout);
		_tmp14_ = stage_view_layout;
		origin_x -= (gfloat) _tmp14_.x;
		_tmp15_ = stage_view_layout;
		origin_y -= (gfloat) _tmp15_.y;
	} else {
	}
	clutter_actor_box_set_origin (source_actor_box, origin_x, origin_y);
	clutter_actor_box_set_size (source_actor_box, width, height);
	clutter_actor_box_scale (source_actor_box, box_scale_factor);
	clutter_actor_box_clamp_to_pixel (source_actor_box);
	_g_object_unref0 (stage_view);
}

static gfloat
greeter_compositor_background_blur_effect_calculate_downscale_factor (GreeterCompositorBackgroundBlurEffect* self,
                                                                      gfloat width,
                                                                      gfloat height,
                                                                      gfloat radius)
{
	gfloat downscale_factor = 0.0F;
	gfloat scaled_width = 0.0F;
	gfloat scaled_height = 0.0F;
	gfloat scaled_radius = 0.0F;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	downscale_factor = 1.0f;
	scaled_width = width;
	scaled_height = height;
	scaled_radius = radius;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (scaled_radius > GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MAX_RADIUS) {
			_tmp1_ = scaled_width > GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MIN_DOWNSCALE_SIZE;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = scaled_height > GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MIN_DOWNSCALE_SIZE;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		downscale_factor *= 2.0f;
		scaled_width = width / downscale_factor;
		scaled_height = height / downscale_factor;
		scaled_radius = radius / downscale_factor;
	}
	result = downscale_factor;
	return result;
}

static void
greeter_compositor_background_blur_effect_setup_projection_matrix (GreeterCompositorBackgroundBlurEffect* self,
                                                                   CoglFramebuffer* framebuffer,
                                                                   gfloat width,
                                                                   gfloat height)
{
	graphene_matrix_t projection = {0};
	graphene_matrix_t _tmp0_ = {0};
	graphene_point3d_t _tmp1_ = {0};
	graphene_matrix_t _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (framebuffer != NULL);
	projection = _tmp0_;
	_tmp1_.x = (-width) / 2.0f;
	_tmp1_.y = (-height) / 2.0f;
	_tmp1_.z = 0.0f;
	graphene_matrix_init_translate (&projection, &_tmp1_);
	graphene_matrix_scale (&projection, 2.0f / width, (-2.0f) / height, 1.0f);
	_tmp2_ = projection;
	cogl_framebuffer_set_projection_matrix (framebuffer, &_tmp2_);
}

static gboolean
greeter_compositor_background_blur_effect_update_actor_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                            gint width,
                                                            gint height,
                                                            gfloat downscale_factor)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp5_;
	CoglContext* _tmp6_;
	gint new_width = 0;
	gint new_height = 0;
	CoglContext* _tmp7_;
	CoglTexture2D* _tmp8_;
	CoglPipeline* _tmp9_;
	CoglTexture* _tmp10_;
	CoglTexture* _tmp11_;
	CoglOffscreen* _tmp12_;
	CoglFramebuffer* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (width <= 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height <= 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->texture_width == width) {
		_tmp3_ = self->priv->texture_height == height;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = self->priv->downscale_factor == downscale_factor;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		CoglFramebuffer* _tmp4_;
		_tmp4_ = self->priv->actor_framebuffer;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = clutter_get_default_backend ();
	_tmp6_ = clutter_backend_get_cogl_context (_tmp5_);
	ctx = _tmp6_;
	new_width = (gint) floorf (width / downscale_factor);
	new_height = (gint) floorf (height / downscale_factor);
	_tmp7_ = ctx;
	_tmp8_ = (CoglTexture2D*) cogl_texture_2d_new_with_size (_tmp7_, new_width, new_height);
	_g_object_unref0 (self->priv->actor_texture);
	self->priv->actor_texture = (CoglTexture*) _tmp8_;
	_tmp9_ = self->priv->actor_pipeline;
	_tmp10_ = self->priv->actor_texture;
	cogl_pipeline_set_layer_texture (_tmp9_, 0, _tmp10_);
	_tmp11_ = self->priv->actor_texture;
	_tmp12_ = cogl_offscreen_new_with_texture (_tmp11_);
	_g_object_unref0 (self->priv->actor_framebuffer);
	self->priv->actor_framebuffer = (CoglFramebuffer*) _tmp12_;
	_tmp13_ = self->priv->actor_framebuffer;
	greeter_compositor_background_blur_effect_setup_projection_matrix (self, _tmp13_, (gfloat) new_width, (gfloat) new_height);
	result = TRUE;
	return result;
}

static gboolean
greeter_compositor_background_blur_effect_update_rounded_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                              gint width,
                                                              gint height,
                                                              gfloat downscale_factor)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp4_;
	CoglContext* _tmp5_;
	gint new_width = 0;
	gint new_height = 0;
	CoglContext* _tmp6_;
	CoglTexture2D* _tmp7_;
	CoglPipeline* _tmp8_;
	CoglTexture* _tmp9_;
	CoglTexture* _tmp10_;
	CoglOffscreen* _tmp11_;
	CoglFramebuffer* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->texture_width == width) {
		_tmp2_ = self->priv->texture_height == height;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->downscale_factor == downscale_factor;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		CoglFramebuffer* _tmp3_;
		_tmp3_ = self->priv->round_framebuffer;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = clutter_get_default_backend ();
	_tmp5_ = clutter_backend_get_cogl_context (_tmp4_);
	ctx = _tmp5_;
	new_width = (gint) floorf (width / downscale_factor);
	new_height = (gint) floorf (height / downscale_factor);
	_tmp6_ = ctx;
	_tmp7_ = (CoglTexture2D*) cogl_texture_2d_new_with_size (_tmp6_, new_width, new_height);
	_g_object_unref0 (self->priv->round_texture);
	self->priv->round_texture = (CoglTexture*) _tmp7_;
	_tmp8_ = self->priv->round_pipeline;
	_tmp9_ = self->priv->round_texture;
	cogl_pipeline_set_layer_texture (_tmp8_, 0, _tmp9_);
	_tmp10_ = self->priv->round_texture;
	_tmp11_ = cogl_offscreen_new_with_texture (_tmp10_);
	_g_object_unref0 (self->priv->round_framebuffer);
	self->priv->round_framebuffer = (CoglFramebuffer*) _tmp11_;
	_tmp12_ = self->priv->round_framebuffer;
	greeter_compositor_background_blur_effect_setup_projection_matrix (self, _tmp12_, (gfloat) new_width, (gfloat) new_height);
	result = TRUE;
	return result;
}

static gboolean
greeter_compositor_background_blur_effect_update_background_fbo (GreeterCompositorBackgroundBlurEffect* self,
                                                                 gint width,
                                                                 gint height)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp3_;
	CoglContext* _tmp4_;
	CoglContext* _tmp5_;
	CoglTexture2D* _tmp6_;
	CoglPipeline* _tmp7_;
	CoglTexture* _tmp8_;
	CoglTexture* _tmp9_;
	CoglOffscreen* _tmp10_;
	CoglFramebuffer* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->texture_width == width) {
		_tmp1_ = self->priv->texture_height == height;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		CoglFramebuffer* _tmp2_;
		_tmp2_ = self->priv->background_framebuffer;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = clutter_get_default_backend ();
	_tmp4_ = clutter_backend_get_cogl_context (_tmp3_);
	ctx = _tmp4_;
	_tmp5_ = ctx;
	_tmp6_ = (CoglTexture2D*) cogl_texture_2d_new_with_size (_tmp5_, width, height);
	_g_object_unref0 (self->priv->background_texture);
	self->priv->background_texture = (CoglTexture*) _tmp6_;
	_tmp7_ = self->priv->background_pipeline;
	_tmp8_ = self->priv->background_texture;
	cogl_pipeline_set_layer_texture (_tmp7_, 0, _tmp8_);
	_tmp9_ = self->priv->background_texture;
	_tmp10_ = cogl_offscreen_new_with_texture (_tmp9_);
	_g_object_unref0 (self->priv->background_framebuffer);
	self->priv->background_framebuffer = (CoglFramebuffer*) _tmp10_;
	_tmp11_ = self->priv->background_framebuffer;
	greeter_compositor_background_blur_effect_setup_projection_matrix (self, _tmp11_, (gfloat) width, (gfloat) height);
	result = TRUE;
	return result;
}

static gboolean
greeter_compositor_background_blur_effect_update_framebuffers (GreeterCompositorBackgroundBlurEffect* self,
                                                               ClutterPaintContext* paint_context,
                                                               ClutterActorBox* actor_box)
{
	gint width = 0;
	gint height = 0;
	gboolean _tmp0_ = FALSE;
	gfloat downscale_factor = 0.0F;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean updated = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (paint_context != NULL, FALSE);
	g_return_val_if_fail (actor_box != NULL, FALSE);
	width = (gint) clutter_actor_box_get_width (actor_box);
	height = (gint) clutter_actor_box_get_height (actor_box);
	if (width < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height < 0;
	}
	if (_tmp0_) {
		g_warning ("BackgroundBlurEffect.vala:348: BackgroundBlurEffect: Couldn't update f" \
"ramebuffers, incorrect size");
		result = FALSE;
		return result;
	}
	downscale_factor = greeter_compositor_background_blur_effect_calculate_downscale_factor (self, (gfloat) width, (gfloat) height, self->priv->real_blur_radius);
	if (greeter_compositor_background_blur_effect_update_actor_fbo (self, width, height, downscale_factor)) {
		_tmp2_ = greeter_compositor_background_blur_effect_update_rounded_fbo (self, width, height, downscale_factor);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = greeter_compositor_background_blur_effect_update_background_fbo (self, width, height);
	} else {
		_tmp1_ = FALSE;
	}
	updated = _tmp1_;
	self->priv->texture_width = width;
	self->priv->texture_height = height;
	self->priv->downscale_factor = downscale_factor;
	result = updated;
	return result;
}

static ClutterPaintNode*
greeter_compositor_background_blur_effect_create_blur_nodes (GreeterCompositorBackgroundBlurEffect* self,
                                                             ClutterPaintNode* node)
{
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	ClutterBlurNode* blur_node = NULL;
	ClutterBlurNode* _tmp4_;
	CoglTexture* _tmp5_;
	CoglTexture* _tmp6_;
	ClutterActorBox _tmp7_ = {0};
	ClutterLayerNode* round_node = NULL;
	CoglFramebuffer* _tmp8_;
	CoglPipeline* _tmp9_;
	ClutterLayerNode* _tmp10_;
	ClutterActorBox _tmp11_ = {0};
	ClutterPaintNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	clutter_actor_get_size (_tmp1_, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = (ClutterBlurNode*) clutter_blur_node_new ((guint) (self->priv->texture_width / self->priv->downscale_factor), (guint) (self->priv->texture_height / self->priv->downscale_factor), self->priv->real_blur_radius / self->priv->downscale_factor);
	blur_node = _tmp4_;
	_tmp5_ = self->priv->round_texture;
	_tmp6_ = self->priv->round_texture;
	_tmp7_.x1 = 0.0f;
	_tmp7_.y1 = 0.0f;
	_tmp7_.x2 = (gfloat) cogl_texture_get_width (_tmp5_);
	_tmp7_.y2 = (gfloat) cogl_texture_get_height (_tmp6_);
	clutter_paint_node_add_rectangle ((ClutterPaintNode*) blur_node, &_tmp7_);
	_tmp8_ = self->priv->round_framebuffer;
	_tmp9_ = self->priv->round_pipeline;
	_tmp10_ = (ClutterLayerNode*) clutter_layer_node_new_to_framebuffer (_tmp8_, _tmp9_);
	round_node = _tmp10_;
	clutter_paint_node_add_child ((ClutterPaintNode*) round_node, (ClutterPaintNode*) blur_node);
	_tmp11_.x1 = 0.0f;
	_tmp11_.y1 = 0.0f;
	_tmp11_.x2 = width;
	_tmp11_.y2 = height;
	clutter_paint_node_add_rectangle ((ClutterPaintNode*) round_node, &_tmp11_);
	clutter_paint_node_add_child (node, (ClutterPaintNode*) round_node);
	result = (ClutterPaintNode*) blur_node;
	_clutter_paint_node_unref0 (round_node);
	return result;
}

static void
greeter_compositor_background_blur_effect_add_actor_node (GreeterCompositorBackgroundBlurEffect* self,
                                                          ClutterPaintNode* node)
{
	ClutterActorNode* actor_node = NULL;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActorNode* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = (ClutterActorNode*) clutter_actor_node_new (_tmp1_, -1);
	actor_node = _tmp2_;
	clutter_paint_node_add_child (node, (ClutterPaintNode*) actor_node);
	_clutter_paint_node_unref0 (actor_node);
}

static void
greeter_compositor_background_blur_effect_paint_background (GreeterCompositorBackgroundBlurEffect* self,
                                                            ClutterPaintNode* node,
                                                            ClutterPaintContext* paint_context,
                                                            ClutterActorBox* source_actor_box)
{
	gfloat transformed_x = 0.0F;
	gfloat transformed_y = 0.0F;
	gfloat transformed_width = 0.0F;
	gfloat transformed_height = 0.0F;
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	ClutterLayerNode* background_node = NULL;
	CoglFramebuffer* _tmp4_;
	CoglPipeline* _tmp5_;
	ClutterLayerNode* _tmp6_;
	ClutterActorBox _tmp7_ = {0};
	ClutterBlitNode* blit_node = NULL;
	CoglFramebuffer* _tmp8_;
	ClutterBlitNode* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (paint_context != NULL);
	g_return_if_fail (source_actor_box != NULL);
	clutter_actor_box_get_origin (source_actor_box, &_tmp0_, &_tmp1_);
	transformed_x = _tmp0_;
	transformed_y = _tmp1_;
	clutter_actor_box_get_size (source_actor_box, &_tmp2_, &_tmp3_);
	transformed_width = _tmp2_;
	transformed_height = _tmp3_;
	_tmp4_ = self->priv->background_framebuffer;
	_tmp5_ = self->priv->background_pipeline;
	_tmp6_ = (ClutterLayerNode*) clutter_layer_node_new_to_framebuffer (_tmp4_, _tmp5_);
	background_node = _tmp6_;
	clutter_paint_node_add_child (node, (ClutterPaintNode*) background_node);
	_tmp7_.x1 = 0.0f;
	_tmp7_.y1 = 0.0f;
	_tmp7_.x2 = self->priv->texture_width / self->priv->downscale_factor;
	_tmp7_.y2 = self->priv->texture_height / self->priv->downscale_factor;
	clutter_paint_node_add_rectangle ((ClutterPaintNode*) background_node, &_tmp7_);
	_tmp8_ = clutter_paint_context_get_framebuffer (paint_context);
	_tmp9_ = (ClutterBlitNode*) clutter_blit_node_new (_tmp8_);
	blit_node = _tmp9_;
	clutter_paint_node_add_child ((ClutterPaintNode*) background_node, (ClutterPaintNode*) blit_node);
	clutter_blit_node_add_blit_rectangle (blit_node, (gint) transformed_x, (gint) transformed_y, 0, 0, (gint) transformed_width, (gint) transformed_height);
	_clutter_paint_node_unref0 (blit_node);
	_clutter_paint_node_unref0 (background_node);
}

static void
greeter_compositor_background_blur_effect_real_paint_node (ClutterEffect* base,
                                                           ClutterPaintNode* node,
                                                           ClutterPaintContext* paint_context,
                                                           ClutterEffectPaintFlags flags)
{
	GreeterCompositorBackgroundBlurEffect * self;
	gfloat _tmp0_;
	gdouble total_scale = 0.0;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	ClutterActor* parent = NULL;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	gfloat relative_opacity = 0.0F;
	ClutterActor* _tmp22_;
	ClutterActor* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	gfloat _tmp26_;
	gfloat _tmp27_;
	ClutterActorBox source_actor_box = {0};
	ClutterActorBox _tmp28_ = {0};
	ClutterActorBox _tmp29_;
	ClutterPaintNode* blur_node = NULL;
	ClutterPaintNode* _tmp30_;
	ClutterPaintNode* _tmp31_;
	ClutterActorBox _tmp32_;
	self = (GreeterCompositorBackgroundBlurEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (paint_context != NULL);
	_tmp0_ = self->priv->_blur_radius;
	if (_tmp0_ <= ((gfloat) 0)) {
		greeter_compositor_background_blur_effect_add_actor_node (self, node);
		return;
	}
	_tmp1_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "scale-x", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp6_ = _tmp5_;
	g_object_get (_tmp6_, "scale-y", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	total_scale = MIN (_tmp4_, _tmp8_);
	_tmp9_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	parent = _tmp11_;
	while (TRUE) {
		ClutterActor* _tmp12_;
		ClutterActor* _tmp13_;
		ClutterActor* _tmp14_;
		ClutterActor* _tmp15_;
		ClutterActor* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		ClutterActor* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp12_ = parent;
		_tmp13_ = clutter_actor_get_parent (_tmp12_);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (parent);
		parent = _tmp14_;
		_tmp15_ = parent;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp16_ = parent;
		g_object_get (_tmp16_, "scale-x", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = parent;
		g_object_get (_tmp19_, "scale-y", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		total_scale *= MIN (_tmp18_, _tmp21_);
	}
	_tmp22_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = clutter_actor_get_opacity (_tmp23_);
	_tmp25_ = _tmp24_;
	relative_opacity = ((gfloat) _tmp25_) / 255.0f;
	_tmp26_ = self->priv->_blur_radius;
	_tmp27_ = self->priv->_monitor_scale;
	self->priv->real_blur_radius = ((_tmp26_ * ((gfloat) pow ((gdouble) relative_opacity, (gdouble) 2))) * _tmp27_) * ((gfloat) total_scale);
	source_actor_box = _tmp28_;
	greeter_compositor_background_blur_effect_update_actor_box (self, paint_context, &source_actor_box);
	_tmp29_ = source_actor_box;
	if (!greeter_compositor_background_blur_effect_update_framebuffers (self, paint_context, &_tmp29_)) {
		greeter_compositor_background_blur_effect_add_actor_node (self, node);
		_g_object_unref0 (parent);
		return;
	}
	_tmp30_ = greeter_compositor_background_blur_effect_create_blur_nodes (self, node);
	blur_node = _tmp30_;
	_tmp31_ = blur_node;
	_tmp32_ = source_actor_box;
	greeter_compositor_background_blur_effect_paint_background (self, _tmp31_, paint_context, &_tmp32_);
	greeter_compositor_background_blur_effect_add_actor_node (self, node);
	_clutter_paint_node_unref0 (blur_node);
	_g_object_unref0 (parent);
}

static void
greeter_compositor_background_blur_effect_real_paint (ClutterEffect* base,
                                                      ClutterPaintNode* node,
                                                      ClutterPaintContext* paint_context,
                                                      ClutterEffectPaintFlags flags)
{
	GreeterCompositorBackgroundBlurEffect * self;
	self = (GreeterCompositorBackgroundBlurEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (paint_context != NULL);
	if (self->priv->frame_counter == 0) {
		self->priv->frame_counter = GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_FORCE_REFRESH_FRAMES;
		clutter_effect_queue_repaint ((ClutterEffect*) self);
	} else {
		gint _tmp0_;
		_tmp0_ = self->priv->frame_counter;
		self->priv->frame_counter = _tmp0_ - 1;
	}
	CLUTTER_EFFECT_CLASS (greeter_compositor_background_blur_effect_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_effect_get_type (), ClutterEffect), node, paint_context, flags);
}

gfloat
greeter_compositor_background_blur_effect_get_blur_radius (GreeterCompositorBackgroundBlurEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_blur_radius;
	return result;
}

static void
greeter_compositor_background_blur_effect_set_blur_radius (GreeterCompositorBackgroundBlurEffect* self,
                                                           gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_blur_effect_get_blur_radius (self);
	if (old_value != value) {
		self->priv->_blur_radius = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY]);
	}
}

gfloat
greeter_compositor_background_blur_effect_get_clip_radius (GreeterCompositorBackgroundBlurEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_clip_radius;
	return result;
}

static void
greeter_compositor_background_blur_effect_set_clip_radius (GreeterCompositorBackgroundBlurEffect* self,
                                                           gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_blur_effect_get_clip_radius (self);
	if (old_value != value) {
		self->priv->_clip_radius = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY]);
	}
}

gfloat
greeter_compositor_background_blur_effect_get_monitor_scale (GreeterCompositorBackgroundBlurEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
greeter_compositor_background_blur_effect_set_monitor_scale (GreeterCompositorBackgroundBlurEffect* self,
                                                             gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_blur_effect_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY]);
	}
}

static void
_greeter_compositor_background_blur_effect_update_clip_radius_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self)
{
	greeter_compositor_background_blur_effect_update_clip_radius ((GreeterCompositorBackgroundBlurEffect*) self);
}

static GObject *
greeter_compositor_background_blur_effect_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorBackgroundBlurEffect * self;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglContext* _tmp2_;
	CoglPipeline* _tmp3_;
	CoglPipeline* _tmp4_;
	CoglPipeline* _tmp5_;
	CoglPipeline* _tmp6_;
	CoglContext* _tmp7_;
	CoglPipeline* _tmp8_;
	CoglPipeline* _tmp9_;
	CoglPipeline* _tmp10_;
	CoglPipeline* _tmp11_;
	CoglContext* _tmp12_;
	CoglPipeline* _tmp13_;
	CoglPipeline* _tmp14_;
	CoglPipeline* _tmp15_;
	CoglPipeline* _tmp16_;
	CoglPipeline* _tmp17_;
	CoglSnippet* _tmp18_;
	CoglSnippet* _tmp19_;
	CoglPipeline* _tmp20_;
	CoglPipeline* _tmp21_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_background_blur_effect_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = cogl_pipeline_new (_tmp2_);
	_g_object_unref0 (self->priv->actor_pipeline);
	self->priv->actor_pipeline = _tmp3_;
	_tmp4_ = self->priv->actor_pipeline;
	cogl_pipeline_set_layer_null_texture (_tmp4_, 0);
	_tmp5_ = self->priv->actor_pipeline;
	cogl_pipeline_set_layer_filters (_tmp5_, 0, COGL_PIPELINE_FILTER_LINEAR, COGL_PIPELINE_FILTER_LINEAR);
	_tmp6_ = self->priv->actor_pipeline;
	cogl_pipeline_set_layer_wrap_mode (_tmp6_, 0, COGL_PIPELINE_WRAP_MODE_CLAMP_TO_EDGE);
	_tmp7_ = ctx;
	_tmp8_ = cogl_pipeline_new (_tmp7_);
	_g_object_unref0 (self->priv->background_pipeline);
	self->priv->background_pipeline = _tmp8_;
	_tmp9_ = self->priv->background_pipeline;
	cogl_pipeline_set_layer_null_texture (_tmp9_, 0);
	_tmp10_ = self->priv->background_pipeline;
	cogl_pipeline_set_layer_filters (_tmp10_, 0, COGL_PIPELINE_FILTER_LINEAR, COGL_PIPELINE_FILTER_LINEAR);
	_tmp11_ = self->priv->background_pipeline;
	cogl_pipeline_set_layer_wrap_mode (_tmp11_, 0, COGL_PIPELINE_WRAP_MODE_CLAMP_TO_EDGE);
	_tmp12_ = ctx;
	_tmp13_ = cogl_pipeline_new (_tmp12_);
	_g_object_unref0 (self->priv->round_pipeline);
	self->priv->round_pipeline = _tmp13_;
	_tmp14_ = self->priv->round_pipeline;
	cogl_pipeline_set_layer_null_texture (_tmp14_, 0);
	_tmp15_ = self->priv->round_pipeline;
	cogl_pipeline_set_layer_filters (_tmp15_, 0, COGL_PIPELINE_FILTER_LINEAR, COGL_PIPELINE_FILTER_LINEAR);
	_tmp16_ = self->priv->round_pipeline;
	cogl_pipeline_set_layer_wrap_mode (_tmp16_, 0, COGL_PIPELINE_WRAP_MODE_CLAMP_TO_EDGE);
	_tmp17_ = self->priv->round_pipeline;
	_tmp18_ = cogl_snippet_new (COGL_SNIPPET_HOOK_FRAGMENT, "\n" \
"                uniform sampler2D tex;\n" \
"                uniform vec2 actor_size;\n" \
"                uniform float clip_radius;\n" \
"\n" \
"                float rounded_rect_coverage (vec2 p) {\n" \
"                    float center_left = clip_radius;\n" \
"                    float center_right = actor_size.x - clip_radius;\n" \
"\n" \
"                    float center_x;\n" \
"                    if (p.x < center_left) {\n" \
"                        center_x = center_left;\n" \
"                    } else if (p.x > center_right) {\n" \
"                        center_x = center_right;\n" \
"                    } else {\n" \
"                        return 1.0;\n" \
"                    }\n" \
"\n" \
"                    float center_top = clip_radius;\n" \
"                    float center_bottom = actor_size.y - clip_radius;\n" \
"\n" \
"                    float center_y;\n" \
"                    if (p.y < center_top) {\n" \
"                        center_y = center_top;\n" \
"                    } else if (p.y > center_bottom) {\n" \
"                        center_y = center_bottom;\n" \
"                    } else {\n" \
"                        return 1.0;\n" \
"                    }\n" \
"\n" \
"                    vec2 delta = p - vec2 (center_x, center_y);\n" \
"                    float dist_squared = dot (delta, delta);\n" \
"\n" \
"                    // Fully outside the circle\n" \
"                    float outer_radius = clip_radius + 0.5;\n" \
"                    if (dist_squared >= (outer_radius * outer_radius))" \
" {\n" \
"                        return 0.0;\n" \
"                    }\n" \
"\n" \
"                    // Fully inside the circle\n" \
"                    float inner_radius = clip_radius - 0.5;\n" \
"                    if (dist_squared <= (inner_radius * inner_radius))" \
" {\n" \
"                        return 1.0;\n" \
"                    }\n" \
"                    // Only pixels on the edge of the curve need expen" \
"sive antialiasing\n" \
"                    return smoothstep (outer_radius, inner_radius, sqr" \
"t (dist_squared));\n" \
"                }\n" \
"                ", "\n" \
"                vec4 sample = texture2D (tex, cogl_tex_coord0_in.xy);\n" \
"                vec2 texture_coord = cogl_tex_coord0_in.xy * actor_siz" \
"e;\n" \
"                float res = rounded_rect_coverage (texture_coord);\n" \
"                cogl_color_out = sample * cogl_color_in * res;\n" \
"                ");
	_tmp19_ = _tmp18_;
	cogl_pipeline_add_snippet (_tmp17_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->round_pipeline;
	self->priv->round_clip_radius_location = cogl_pipeline_get_uniform_location (_tmp20_, "clip_radius");
	_tmp21_ = self->priv->round_pipeline;
	self->priv->round_actor_size_location = cogl_pipeline_get_uniform_location (_tmp21_, "actor_size");
	greeter_compositor_background_blur_effect_update_clip_radius (self);
	greeter_compositor_background_blur_effect_update_actor_size (self);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _greeter_compositor_background_blur_effect_update_clip_radius_g_object_notify, self, 0);
	return obj;
}

static void
greeter_compositor_background_blur_effect_class_init (GreeterCompositorBackgroundBlurEffectClass * klass,
                                                      gpointer klass_data)
{
	greeter_compositor_background_blur_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBackgroundBlurEffect_private_offset);
	((ClutterActorMetaClass *) klass)->set_actor = (void (*) (ClutterActorMeta*, ClutterActor*)) greeter_compositor_background_blur_effect_real_set_actor;
	((ClutterEffectClass *) klass)->paint_node = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*, ClutterEffectPaintFlags)) greeter_compositor_background_blur_effect_real_paint_node;
	((ClutterEffectClass *) klass)->paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*, ClutterEffectPaintFlags)) greeter_compositor_background_blur_effect_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_background_blur_effect_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_background_blur_effect_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_background_blur_effect_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_background_blur_effect_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY] = g_param_spec_float ("blur-radius", "blur-radius", "blur-radius", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY] = g_param_spec_float ("clip-radius", "clip-radius", "clip-radius", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY, greeter_compositor_background_blur_effect_properties[GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
greeter_compositor_background_blur_effect_instance_init (GreeterCompositorBackgroundBlurEffect * self,
                                                         gpointer klass)
{
	self->priv = greeter_compositor_background_blur_effect_get_instance_private (self);
	self->priv->frame_counter = 0;
}

static void
greeter_compositor_background_blur_effect_finalize (GObject * obj)
{
	GreeterCompositorBackgroundBlurEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect);
	_g_object_unref0 (self->priv->actor_framebuffer);
	_g_object_unref0 (self->priv->actor_pipeline);
	_g_object_unref0 (self->priv->actor_texture);
	_g_object_unref0 (self->priv->background_framebuffer);
	_g_object_unref0 (self->priv->background_pipeline);
	_g_object_unref0 (self->priv->background_texture);
	_g_object_unref0 (self->priv->round_framebuffer);
	_g_object_unref0 (self->priv->round_pipeline);
	_g_object_unref0 (self->priv->round_texture);
	G_OBJECT_CLASS (greeter_compositor_background_blur_effect_parent_class)->finalize (obj);
}

static GType
greeter_compositor_background_blur_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundBlurEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_blur_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackgroundBlurEffect), 0, (GInstanceInitFunc) greeter_compositor_background_blur_effect_instance_init, NULL };
	GType greeter_compositor_background_blur_effect_type_id;
	greeter_compositor_background_blur_effect_type_id = g_type_register_static (clutter_effect_get_type (), "GreeterCompositorBackgroundBlurEffect", &g_define_type_info, 0);
	GreeterCompositorBackgroundBlurEffect_private_offset = g_type_add_instance_private (greeter_compositor_background_blur_effect_type_id, sizeof (GreeterCompositorBackgroundBlurEffectPrivate));
	return greeter_compositor_background_blur_effect_type_id;
}

GType
greeter_compositor_background_blur_effect_get_type (void)
{
	static volatile gsize greeter_compositor_background_blur_effect_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_blur_effect_type_id__once)) {
		GType greeter_compositor_background_blur_effect_type_id;
		greeter_compositor_background_blur_effect_type_id = greeter_compositor_background_blur_effect_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_blur_effect_type_id__once, greeter_compositor_background_blur_effect_type_id);
	}
	return greeter_compositor_background_blur_effect_type_id__once;
}

static void
_vala_greeter_compositor_background_blur_effect_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	GreeterCompositorBackgroundBlurEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY:
		g_value_set_float (value, greeter_compositor_background_blur_effect_get_blur_radius (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY:
		g_value_set_float (value, greeter_compositor_background_blur_effect_get_clip_radius (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, greeter_compositor_background_blur_effect_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_background_blur_effect_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	GreeterCompositorBackgroundBlurEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_BLUR_RADIUS_PROPERTY:
		greeter_compositor_background_blur_effect_set_blur_radius (self, g_value_get_float (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLIP_RADIUS_PROPERTY:
		greeter_compositor_background_blur_effect_set_clip_radius (self, g_value_get_float (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_MONITOR_SCALE_PROPERTY:
		greeter_compositor_background_blur_effect_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

