/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_lmx2572_regs.py on Wed Dec 17 09:05:05 2025
 **********************************************************************/

#ifndef INCLUDED_LMX2572_REGS_HPP
#define INCLUDED_LMX2572_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class lmx2572_regs_t{
public:
    enum powerdown_t{
        POWERDOWN_NORMAL_OPERATION = 0,
        POWERDOWN_POWER_DOWN = 1
    };
    powerdown_t powerdown;
    enum reset_t{
        RESET_NORMAL_OPERATION = 0,
        RESET_RESET = 1
    };
    reset_t reset;
    enum muxout_ld_sel_t{
        MUXOUT_LD_SEL_REGISTER_READBACK = 0,
        MUXOUT_LD_SEL_LOCK_DETECT = 1
    };
    muxout_ld_sel_t muxout_ld_sel;
    enum fcal_en_t{
        FCAL_EN_INVALID = 0,
        FCAL_EN_ENABLE = 1
    };
    fcal_en_t fcal_en;
    uint8_t reg0_reserved0;
    uint8_t fcal_lpfd_adj;
    uint8_t fcal_hpfd_adj;
    enum out_mute_t{
        OUT_MUTE_DISABLED = 0,
        OUT_MUTE_MUTED = 1
    };
    out_mute_t out_mute;
    uint8_t reg0_reserved1;
    uint8_t add_hold;
    uint8_t reg0_reserved2;
    enum vco_phase_sync_en_t{
        VCO_PHASE_SYNC_EN_NORMAL_OPERATION = 0,
        VCO_PHASE_SYNC_EN_PHASE_SYNC_MODE = 1
    };
    vco_phase_sync_en_t vco_phase_sync_en;
    enum ramp_en_t{
        RAMP_EN_NORMAL_OPERATION = 0,
        RAMP_EN_FREQUENCY_RAMPING = 1
    };
    ramp_en_t ramp_en;
    uint8_t cal_clk_div;
    uint16_t reg1_reserved0;
    uint16_t reg2_reserved0;
    uint16_t reg3_reserved0;
    uint16_t reg4_reserved0;
    uint16_t reg5_reserved0;
    enum ipbuf_term_t{
        IPBUF_TERM_NORMAL_OPERATION = 0,
        IPBUF_TERM_INTERNALLY_TERMINATED = 1
    };
    ipbuf_term_t ipbuf_term;
    enum ipbuf_type_t{
        IPBUF_TYPE_DIFFERENTIAL = 0,
        IPBUF_TYPE_SINGLE_ENDED = 1
    };
    ipbuf_type_t ipbuf_type;
    uint8_t reg5_reserved1;
    uint16_t reg6_reserved0;
    uint8_t ldo_dly;
    uint16_t reg7_reserved0;
    enum out_force_t{
        OUT_FORCE_USE_OUT_MUTE = 0,
        OUT_FORCE_NO_MUTE = 1
    };
    out_force_t out_force;
    uint8_t reg7_reserved1;
    uint16_t reg8_reserved0;
    enum vco_capctrl_force_t{
        VCO_CAPCTRL_FORCE_NORMAL_OPERATION = 0,
        VCO_CAPCTRL_FORCE_USE_VCO_CAPCTRL = 1
    };
    vco_capctrl_force_t vco_capctrl_force;
    uint8_t reg8_reserved1;
    enum vco_daciset_force_t{
        VCO_DACISET_FORCE_NORMAL_OPERATION = 0,
        VCO_DACISET_FORCE_USE_VCO_DACISET = 1
    };
    vco_daciset_force_t vco_daciset_force;
    uint8_t reg8_reserved2;
    uint16_t reg9_reserved0;
    enum osc_2x_t{
        OSC_2X_DISABLED = 0,
        OSC_2X_ENABLED = 1
    };
    osc_2x_t osc_2x;
    uint8_t reg9_reserved1;
    enum mult_hi_t{
        MULT_HI_LESS_THAN_EQUAL_TO_100M = 0,
        MULT_HI_GREATER_THAN_100M = 1
    };
    mult_hi_t mult_hi;
    uint8_t reg9_reserved2;
    uint8_t reg10_reserved0;
    uint8_t mult;
    uint8_t reg10_reserved1;
    uint8_t reg11_reserved0;
    uint8_t pll_r;
    uint8_t reg11_reserved1;
    uint16_t pll_r_pre;
    uint8_t reg12_reserved0;
    uint16_t reg13_reserved0;
    uint8_t reg14_reserved0;
    uint8_t cpg;
    uint16_t reg14_reserved1;
    uint16_t reg15_reserved0;
    uint16_t vco_daciset;
    uint8_t reg16_reserved0;
    uint16_t vco_daciset_strt;
    uint8_t reg17_reserved0;
    uint16_t reg18_reserved0;
    uint8_t vco_capctrl;
    uint8_t reg19_reserved0;
    uint16_t reg20_reserved0;
    enum vco_sel_force_t{
        VCO_SEL_FORCE_DISABLED = 0,
        VCO_SEL_FORCE_ENABLED = 1
    };
    vco_sel_force_t vco_sel_force;
    uint8_t vco_sel;
    uint8_t reg20_reserved1;
    uint16_t reg21_reserved0;
    uint16_t reg22_reserved0;
    uint16_t reg23_reserved0;
    uint16_t reg24_reserved0;
    uint16_t reg25_reserved0;
    uint16_t reg26_reserved0;
    uint16_t reg27_reserved0;
    uint16_t reg28_reserved0;
    uint16_t reg29_reserved0;
    uint16_t reg30_reserved0;
    uint16_t reg31_reserved0;
    uint16_t reg32_reserved0;
    uint16_t reg33_reserved0;
    uint8_t pll_n_upper_3_bits;
    uint16_t reg34_reserved0;
    uint16_t reg35_reserved0;
    uint16_t pll_n_lower_16_bits;
    uint8_t reg37_reserved0;
    uint8_t pfd_dly_sel;
    uint8_t reg37_reserved1;
    enum mash_seed_en_t{
        MASH_SEED_EN_DISABLED = 0,
        MASH_SEED_EN_ENABLED = 1
    };
    mash_seed_en_t mash_seed_en;
    uint16_t pll_den_upper;
    uint16_t pll_den_lower;
    uint16_t mash_seed_upper;
    uint16_t mash_seed_lower;
    uint16_t pll_num_upper;
    uint16_t pll_num_lower;
    enum mash_order_t{
        MASH_ORDER_INTERGER_MODE = 0,
        MASH_ORDER_FIRST_ORDER = 1,
        MASH_ORDER_SECOND_ORDER = 2,
        MASH_ORDER_THIRD_ORDER = 3,
        MASH_ORDER_FOURTH_ORDER = 4
    };
    mash_order_t mash_order;
    uint8_t reg44_reserved0;
    enum mash_reset_n_t{
        MASH_RESET_N_RESET = 0,
        MASH_RESET_N_NORMAL_OPERATION = 1
    };
    mash_reset_n_t mash_reset_n;
    enum outa_pd_t{
        OUTA_PD_NORMAL_OPERATION = 0,
        OUTA_PD_POWER_DOWN = 1
    };
    outa_pd_t outa_pd;
    enum outb_pd_t{
        OUTB_PD_NORMAL_OPERATION = 0,
        OUTB_PD_POWER_DOWN = 1
    };
    outb_pd_t outb_pd;
    uint8_t outa_pwr;
    uint8_t reg44_reserved1;
    uint8_t outb_pwr;
    uint8_t register45_reserved0;
    enum outa_mux_t{
        OUTA_MUX_CHANNEL_DIVIDER = 0,
        OUTA_MUX_VCO = 1,
        OUTA_MUX_NOT_USED = 2,
        OUTA_MUX_HIGH_IMPEDANCE = 3
    };
    outa_mux_t outa_mux;
    uint8_t register45_reserved1;
    enum outb_mux_t{
        OUTB_MUX_CHANNEL_DIVIDER = 0,
        OUTB_MUX_VCO = 1,
        OUTB_MUX_SYSREF = 2,
        OUTB_MUX_HIGH_IMPEDANCE = 3
    };
    outb_mux_t outb_mux;
    uint16_t register46_reserved0;
    uint16_t reg47_reserved0;
    uint16_t reg48_reserved0;
    uint16_t reg49_reserved0;
    uint16_t reg50_reserved0;
    uint16_t reg51_reserved0;
    uint16_t reg52_reserved0;
    uint16_t reg53_reserved0;
    uint16_t reg54_reserved0;
    uint16_t reg55_reserved0;
    uint16_t reg56_reserved0;
    uint16_t reg57_reserved0;
    uint16_t reg58_reserved0;
    enum inpin_fmt_t{
        INPIN_FMT_SYNC_EQUALS_SYSREFREQ_EQUALS_CMOS = 0,
        INPIN_FMT_SYNC_EQUALS_LVDS_SYSREFREQ_EQUAL_CMOS = 1,
        INPIN_FMT_SYNC_EQUALS_CMOS_SYSREFREQ_EQUAL_LVDS = 2,
        INPIN_FMT_SYNC_EQUALS_SYSREFREQ_EQUALS_LVDS = 3,
        INPIN_FMT_SYNC_EQUALS_SYSREFREQ_EQUALS_CMOS2 = 4,
        INPIN_FMT_SYNC_EQUALS_LVDSFILTERED_SYSREFREQ_EQUALS_CMOS = 5,
        INPIN_FMT_SYNC_EQUALS_CMOS_SYSREFREQ_EQUALS_LVDSFILTERED = 6,
        INPIN_FMT_SYNC_EQUALS_SYSREFREQ_EQUALS_LVDSFILTERED = 7
    };
    inpin_fmt_t inpin_fmt;
    enum inpin_lvl_t{
        INPIN_LVL_VIN_DIVIDE_BY_4 = 0,
        INPIN_LVL_VIN = 1,
        INPIN_LVL_VIN_DIVIDE_BY_2 = 2,
        INPIN_LVL_INVALID = 3
    };
    inpin_lvl_t inpin_lvl;
    enum inpin_hyst_t{
        INPIN_HYST_DISABLED = 0,
        INPIN_HYST_ENABLED = 1
    };
    inpin_hyst_t inpin_hyst;
    uint8_t inpin_ignore;
    enum ld_type_t{
        LD_TYPE_VCOCAL = 0,
        LD_TYPE_VTUNE_AND_VCOCAL = 1
    };
    ld_type_t ld_type;
    uint16_t reg59_reserved0;
    uint16_t ld_dly;
    uint16_t reg61_reserved0;
    uint16_t reg62_reserved0;
    enum dblbuf_en_0_t{
        DBLBUF_EN_0_DISABLED = 0,
        DBLBUF_EN_0_ENABLED = 1
    };
    dblbuf_en_0_t dblbuf_en_0;
    enum dblbuf_en_1_t{
        DBLBUF_EN_1_DISABLED = 0,
        DBLBUF_EN_1_ENABLED = 1
    };
    dblbuf_en_1_t dblbuf_en_1;
    enum dblbuf_en_2_t{
        DBLBUF_EN_2_DISABLED = 0,
        DBLBUF_EN_2_ENABLED = 1
    };
    dblbuf_en_2_t dblbuf_en_2;
    enum dblbuf_en_3_t{
        DBLBUF_EN_3_DISABLED = 0,
        DBLBUF_EN_3_ENABLED = 1
    };
    dblbuf_en_3_t dblbuf_en_3;
    enum dblbuf_en_4_t{
        DBLBUF_EN_4_DISABLED = 0,
        DBLBUF_EN_4_ENABLED = 1
    };
    dblbuf_en_4_t dblbuf_en_4;
    enum dblbuf_en_5_t{
        DBLBUF_EN_5_DISABLED = 0,
        DBLBUF_EN_5_ENABLED = 1
    };
    dblbuf_en_5_t dblbuf_en_5;
    uint16_t reg63_reserved0;
    uint16_t reg64_reserved0;
    uint16_t reg65_reserved0;
    uint16_t reg66_reserved0;
    uint16_t reg67_reserved0;
    uint16_t reg68_reserved0;
    uint16_t mash_rst_count_upper;
    uint16_t mash_rst_count_lower;
    uint8_t reg71_reserved0;
    enum sysref_repeat_t{
        SYSREF_REPEAT_MASTER_MODE = 0,
        SYSREF_REPEAT_REPEATER_MODE = 1
    };
    sysref_repeat_t sysref_repeat;
    enum sysref_en_t{
        SYSREF_EN_DISABLED = 0,
        SYSREF_EN_ENABLED = 1
    };
    sysref_en_t sysref_en;
    enum sysref_pulse_t{
        SYSREF_PULSE_DISABLED = 0,
        SYSREF_PULSE_ENABLED = 1
    };
    sysref_pulse_t sysref_pulse;
    enum sysref_div_pre_t{
        SYSREF_DIV_PRE_DIVIDE_BY_2 = 2,
        SYSREF_DIV_PRE_DIVIDE_BY_4 = 4
    };
    sysref_div_pre_t sysref_div_pre;
    uint8_t reg71_reserved1;
    uint16_t sysref_div;
    uint8_t reg72_reserved0;
    uint8_t jesd_dac1_ctrl;
    uint8_t jesd_dac2_ctrl;
    uint8_t reg73_reserved0;
    uint8_t jesd_dac3_ctrl;
    uint8_t jesd_dac4_ctrl;
    uint8_t sysref_pulse_cnt;
    uint8_t reg75_reserved0;
    enum chdiv_t{
        CHDIV_DIVIDE_BY_2 = 0,
        CHDIV_DIVIDE_BY_4 = 1,
        CHDIV_DIVIDE_BY_8 = 3,
        CHDIV_DIVIDE_BY_16 = 5,
        CHDIV_DIVIDE_BY_32 = 7,
        CHDIV_DIVIDE_BY_64 = 9,
        CHDIV_DIVIDE_BY_128 = 12,
        CHDIV_DIVIDE_BY_256 = 14
    };
    chdiv_t chdiv;
    uint8_t reg75_reserved1;
    uint16_t reg76_reserved0;
    uint16_t reg77_reserved0;
    uint8_t reg78_reserved0;
    uint8_t vco_capctrl_strt;
    uint8_t quick_recal_en;
    uint8_t reg78_reserved1;
    uint8_t ramp_thresh_33rd;
    uint8_t reg78_reserved2;
    uint16_t ramp_thresh_upper;
    uint16_t ramp_thresh_lower;
    uint8_t ramp_limit_high_33rd;
    uint16_t reg81_reserved0;
    uint16_t ramp_limit_high_upper;
    uint16_t ramp_limit_high_lower;
    uint8_t ramp_limit_low_33rd;
    uint16_t reg84_reserved0;
    uint16_t ramp_limit_low_upper;
    uint16_t ramp_limit_low_lower;
    uint16_t reg87_reserved0;
    uint16_t reg88_reserved0;
    uint16_t reg89_reserved0;
    uint16_t reg90_reserved0;
    uint16_t reg91_reserved0;
    uint16_t reg92_reserved0;
    uint16_t reg93_reserved0;
    uint16_t reg94_reserved0;
    uint16_t reg95_reserved0;
    uint8_t reg96_reserved0;
    uint16_t ramp_burst_count;
    enum ramp_burst_en_t{
        RAMP_BURST_EN_DISABLED = 0,
        RAMP_BURST_EN_ENABLED = 1
    };
    ramp_burst_en_t ramp_burst_en;
    enum ramp_burst_trig_t{
        RAMP_BURST_TRIG_RAMP_TRANSISTION = 0,
        RAMP_BURST_TRIG_TRIGGER_A = 1,
        RAMP_BURST_TRIG_TRIGGER_B = 2
    };
    ramp_burst_trig_t ramp_burst_trig;
    uint8_t reg97_reserved0;
    enum ramp_triga_t{
        RAMP_TRIGA_DISABLED = 0,
        RAMP_TRIGA_RAMPCLK_RISING_EDGE = 1,
        RAMP_TRIGA_RAMPDIR_RISING_EDGE = 2,
        RAMP_TRIGA_ALWAYS_TRIGGERED = 4,
        RAMP_TRIGA_RAMPCLK_FALLING_EDGE = 9,
        RAMP_TRIGA_RAMPDIR_FALLING_EDGE = 10
    };
    ramp_triga_t ramp_triga;
    enum ramp_trgb_t{
        RAMP_TRGB_DISABLED = 0,
        RAMP_TRGB_RAMPCLK_RISING_EDGE = 1,
        RAMP_TRGB_RAMPDIR_RISING_EDGE = 2,
        RAMP_TRGB_ALWAYS_TRIGGERED = 4,
        RAMP_TRGB_RAMPCLK_FALLING_EDGE = 9,
        RAMP_TRGB_RAMPDIR_FALLING_EDGE = 10
    };
    ramp_trgb_t ramp_trgb;
    uint8_t reg97_reserved1;
    enum ramp0_rst_t{
        RAMP0_RST_DISABLED = 0,
        RAMP0_RST_RESET = 1
    };
    ramp0_rst_t ramp0_rst;
    uint8_t ramp0_dly;
    uint8_t reg98_reserved0;
    uint16_t ramp0_inc_upper_14;
    uint16_t ramp0_inc_lower;
    uint16_t ramp0_len;
    enum ramp0_next_trig_t{
        RAMP0_NEXT_TRIG_TIMEOUT_COUNTER = 0,
        RAMP0_NEXT_TRIG_TRIGGER_A = 1,
        RAMP0_NEXT_TRIG_TRIGGER_B = 2
    };
    ramp0_next_trig_t ramp0_next_trig;
    uint8_t reg101_reserved0;
    enum ramp0_next_t{
        RAMP0_NEXT_RAMP0 = 0,
        RAMP0_NEXT_RAMP1 = 1
    };
    ramp0_next_t ramp0_next;
    enum ramp1_rst_t{
        RAMP1_RST_DISABLED = 0,
        RAMP1_RST_RESET = 1
    };
    ramp1_rst_t ramp1_rst;
    uint8_t ramp1_dly;
    uint16_t reg101_reserved1;
    uint16_t ramp1_inc_upper_14;
    uint8_t reg102_reserved0;
    uint16_t ramp1_inc_lower;
    uint16_t ramp1_len;
    enum ramp1_next_trig_t{
        RAMP1_NEXT_TRIG_TIMEOUT_COUNTER = 0,
        RAMP1_NEXT_TRIG_TRIGGER_A = 1,
        RAMP1_NEXT_TRIG_TRIGGER_B = 2
    };
    ramp1_next_trig_t ramp1_next_trig;
    uint8_t reg105_reserved0;
    enum ramp1_next_t{
        RAMP1_NEXT_RAMP0 = 0,
        RAMP1_NEXT_RAMP1 = 1
    };
    ramp1_next_t ramp1_next;
    enum ramp_manual_t{
        RAMP_MANUAL_AUTOMATIC_RAMPING = 0,
        RAMP_MANUAL_MANUAL_RAMPING = 1
    };
    ramp_manual_t ramp_manual;
    uint16_t ramp_dly_cnt;
    uint8_t ramp_scale_count;
    uint8_t reg106_reserved0;
    enum ramp_trig_cal_t{
        RAMP_TRIG_CAL_DISABLED = 0,
        RAMP_TRIG_CAL_ENABLED = 1
    };
    ramp_trig_cal_t ramp_trig_cal;
    uint16_t reg106_reserved1;
    enum fsk_mode_sel_t{
        FSK_MODE_SEL_UNUSED = 0,
        FSK_MODE_SEL_FSK_SPI = 2,
        FSK_MODE_SEL_FSK_SPI_FAST = 3
    };
    fsk_mode_sel_t fsk_mode_sel;
    uint8_t fsk_spi_dev_sel;
    enum fsk_spi_level_t{
        FSK_SPI_LEVEL_DISABLED = 0,
        FSK_SPI_LEVEL_2FSK = 1,
        FSK_SPI_LEVEL_4FSK = 2,
        FSK_SPI_LEVEL_8FSK = 3
    };
    fsk_spi_level_t fsk_spi_level;
    uint8_t reg114_reserved0;
    enum fsk_en_t{
        FSK_EN_DISABLED = 0,
        FSK_EN_ENABLED = 1
    };
    fsk_en_t fsk_en;
    uint8_t reg114_reserved1;
    uint8_t reg115_reserved0;
    uint8_t fsk_dev_scale;
    uint8_t reg115_reserved1;
    uint16_t fsk_dev0;
    uint16_t fsk_dev1;
    uint16_t fsk_dev2;
    uint16_t fsk_dev3;
    uint16_t fsk_dev4;
    uint16_t fsk_dev5;
    uint16_t fsk_dev6;
    uint16_t fsk_dev7;
    uint16_t fsk_spi_dev;
    uint16_t reg125;

    lmx2572_regs_t(void){
        _state = NULL;
        powerdown = POWERDOWN_NORMAL_OPERATION;
        reset = RESET_NORMAL_OPERATION;
        muxout_ld_sel = MUXOUT_LD_SEL_LOCK_DETECT;
        fcal_en = FCAL_EN_ENABLE;
        reg0_reserved0 = 1;
        fcal_lpfd_adj = 0;
        fcal_hpfd_adj = 0;
        out_mute = OUT_MUTE_MUTED;
        reg0_reserved1 = 0;
        add_hold = 0;
        reg0_reserved2 = 2;
        vco_phase_sync_en = VCO_PHASE_SYNC_EN_NORMAL_OPERATION;
        ramp_en = RAMP_EN_NORMAL_OPERATION;
        cal_clk_div = 0;
        reg1_reserved0 = 257;
        reg2_reserved0 = 1280;
        reg3_reserved0 = 1922;
        reg4_reserved0 = 2627;
        reg5_reserved0 = 200;
        ipbuf_term = IPBUF_TERM_NORMAL_OPERATION;
        ipbuf_type = IPBUF_TYPE_SINGLE_ENDED;
        reg5_reserved1 = 1;
        reg6_reserved0 = 2;
        ldo_dly = 25;
        reg7_reserved0 = 178;
        out_force = OUT_FORCE_USE_OUT_MUTE;
        reg7_reserved1 = 0;
        reg8_reserved0 = 0;
        vco_capctrl_force = VCO_CAPCTRL_FORCE_NORMAL_OPERATION;
        reg8_reserved1 = 2;
        vco_daciset_force = VCO_DACISET_FORCE_NORMAL_OPERATION;
        reg8_reserved2 = 0;
        reg9_reserved0 = 4;
        osc_2x = OSC_2X_DISABLED;
        reg9_reserved1 = 0;
        mult_hi = MULT_HI_LESS_THAN_EQUAL_TO_100M;
        reg9_reserved2 = 0;
        reg10_reserved0 = 120;
        mult = 1;
        reg10_reserved1 = 1;
        reg11_reserved0 = 8;
        pll_r = 1;
        reg11_reserved1 = 11;
        pll_r_pre = 1;
        reg12_reserved0 = 5;
        reg13_reserved0 = 16384;
        reg14_reserved0 = 0;
        cpg = 8;
        reg14_reserved1 = 48;
        reg15_reserved0 = 1550;
        vco_daciset = 128;
        reg16_reserved0 = 0;
        vco_daciset_strt = 150;
        reg17_reserved0 = 0;
        reg18_reserved0 = 100;
        vco_capctrl = 183;
        reg19_reserved0 = 39;
        reg20_reserved0 = 72;
        vco_sel_force = VCO_SEL_FORCE_DISABLED;
        vco_sel = 6;
        reg20_reserved1 = 1;
        reg21_reserved0 = 1033;
        reg22_reserved0 = 1;
        reg23_reserved0 = 124;
        reg24_reserved0 = 1818;
        reg25_reserved0 = 1572;
        reg26_reserved0 = 2056;
        reg27_reserved0 = 2;
        reg28_reserved0 = 1160;
        reg29_reserved0 = 6342;
        reg30_reserved0 = 6342;
        reg31_reserved0 = 50150;
        reg32_reserved0 = 1471;
        reg33_reserved0 = 7681;
        pll_n_upper_3_bits = 0;
        reg34_reserved0 = 2;
        reg35_reserved0 = 4;
        pll_n_lower_16_bits = 40;
        reg37_reserved0 = 5;
        pfd_dly_sel = 2;
        reg37_reserved1 = 0;
        mash_seed_en = MASH_SEED_EN_DISABLED;
        pll_den_upper = 65535;
        pll_den_lower = 65535;
        mash_seed_upper = 0;
        mash_seed_lower = 0;
        pll_num_upper = 0;
        pll_num_lower = 0;
        mash_order = MASH_ORDER_SECOND_ORDER;
        reg44_reserved0 = 0;
        mash_reset_n = MASH_RESET_N_NORMAL_OPERATION;
        outa_pd = OUTA_PD_NORMAL_OPERATION;
        outb_pd = OUTB_PD_POWER_DOWN;
        outa_pwr = 34;
        reg44_reserved1 = 0;
        outb_pwr = 34;
        register45_reserved0 = 24;
        outa_mux = OUTA_MUX_CHANNEL_DIVIDER;
        register45_reserved1 = 6;
        outb_mux = OUTB_MUX_CHANNEL_DIVIDER;
        register46_reserved0 = 508;
        reg47_reserved0 = 768;
        reg48_reserved0 = 992;
        reg49_reserved0 = 16768;
        reg50_reserved0 = 128;
        reg51_reserved0 = 128;
        reg52_reserved0 = 1056;
        reg53_reserved0 = 0;
        reg54_reserved0 = 0;
        reg55_reserved0 = 0;
        reg56_reserved0 = 0;
        reg57_reserved0 = 0;
        reg58_reserved0 = 1;
        inpin_fmt = INPIN_FMT_SYNC_EQUALS_SYSREFREQ_EQUALS_CMOS;
        inpin_lvl = INPIN_LVL_VIN_DIVIDE_BY_4;
        inpin_hyst = INPIN_HYST_DISABLED;
        inpin_ignore = 1;
        ld_type = LD_TYPE_VTUNE_AND_VCOCAL;
        reg59_reserved0 = 0;
        ld_dly = 1000;
        reg61_reserved0 = 168;
        reg62_reserved0 = 175;
        dblbuf_en_0 = DBLBUF_EN_0_DISABLED;
        dblbuf_en_1 = DBLBUF_EN_1_DISABLED;
        dblbuf_en_2 = DBLBUF_EN_2_DISABLED;
        dblbuf_en_3 = DBLBUF_EN_3_DISABLED;
        dblbuf_en_4 = DBLBUF_EN_4_DISABLED;
        dblbuf_en_5 = DBLBUF_EN_5_DISABLED;
        reg63_reserved0 = 0;
        reg64_reserved0 = 5000;
        reg65_reserved0 = 0;
        reg66_reserved0 = 500;
        reg67_reserved0 = 0;
        reg68_reserved0 = 1000;
        mash_rst_count_upper = 0;
        mash_rst_count_lower = 50000;
        reg71_reserved0 = 1;
        sysref_repeat = SYSREF_REPEAT_MASTER_MODE;
        sysref_en = SYSREF_EN_DISABLED;
        sysref_pulse = SYSREF_PULSE_DISABLED;
        sysref_div_pre = SYSREF_DIV_PRE_DIVIDE_BY_4;
        reg71_reserved1 = 0;
        sysref_div = 1;
        reg72_reserved0 = 0;
        jesd_dac1_ctrl = 63;
        jesd_dac2_ctrl = 0;
        reg73_reserved0 = 0;
        jesd_dac3_ctrl = 0;
        jesd_dac4_ctrl = 0;
        sysref_pulse_cnt = 0;
        reg75_reserved0 = 0;
        chdiv = CHDIV_DIVIDE_BY_2;
        reg75_reserved1 = 1;
        reg76_reserved0 = 12;
        reg77_reserved0 = 0;
        reg78_reserved0 = 0;
        vco_capctrl_strt = 50;
        quick_recal_en = 0;
        reg78_reserved1 = 0;
        ramp_thresh_33rd = 0;
        reg78_reserved2 = 0;
        ramp_thresh_upper = 0;
        ramp_thresh_lower = 0;
        ramp_limit_high_33rd = 0;
        reg81_reserved0 = 0;
        ramp_limit_high_upper = 0;
        ramp_limit_high_lower = 0;
        ramp_limit_low_33rd = 0;
        reg84_reserved0 = 0;
        ramp_limit_low_upper = 0;
        ramp_limit_low_lower = 0;
        reg87_reserved0 = 0;
        reg88_reserved0 = 0;
        reg89_reserved0 = 0;
        reg90_reserved0 = 0;
        reg91_reserved0 = 0;
        reg92_reserved0 = 0;
        reg93_reserved0 = 0;
        reg94_reserved0 = 0;
        reg95_reserved0 = 0;
        reg96_reserved0 = 0;
        ramp_burst_count = 0;
        ramp_burst_en = RAMP_BURST_EN_DISABLED;
        ramp_burst_trig = RAMP_BURST_TRIG_RAMP_TRANSISTION;
        reg97_reserved0 = 0;
        ramp_triga = RAMP_TRIGA_DISABLED;
        ramp_trgb = RAMP_TRGB_DISABLED;
        reg97_reserved1 = 0;
        ramp0_rst = RAMP0_RST_DISABLED;
        ramp0_dly = 0;
        reg98_reserved0 = 0;
        ramp0_inc_upper_14 = 0;
        ramp0_inc_lower = 0;
        ramp0_len = 0;
        ramp0_next_trig = RAMP0_NEXT_TRIG_TIMEOUT_COUNTER;
        reg101_reserved0 = 0;
        ramp0_next = RAMP0_NEXT_RAMP0;
        ramp1_rst = RAMP1_RST_DISABLED;
        ramp1_dly = 0;
        reg101_reserved1 = 0;
        ramp1_inc_upper_14 = 0;
        reg102_reserved0 = 0;
        ramp1_inc_lower = 0;
        ramp1_len = 0;
        ramp1_next_trig = RAMP1_NEXT_TRIG_TIMEOUT_COUNTER;
        reg105_reserved0 = 0;
        ramp1_next = RAMP1_NEXT_RAMP0;
        ramp_manual = RAMP_MANUAL_AUTOMATIC_RAMPING;
        ramp_dly_cnt = 273;
        ramp_scale_count = 7;
        reg106_reserved0 = 0;
        ramp_trig_cal = RAMP_TRIG_CAL_DISABLED;
        reg106_reserved1 = 0;
        fsk_mode_sel = FSK_MODE_SEL_UNUSED;
        fsk_spi_dev_sel = 0;
        fsk_spi_level = FSK_SPI_LEVEL_DISABLED;
        reg114_reserved0 = 0;
        fsk_en = FSK_EN_DISABLED;
        reg114_reserved1 = 15;
        reg115_reserved0 = 0;
        fsk_dev_scale = 0;
        reg115_reserved1 = 0;
        fsk_dev0 = 0;
        fsk_dev1 = 0;
        fsk_dev2 = 0;
        fsk_dev3 = 0;
        fsk_dev4 = 0;
        fsk_dev5 = 0;
        fsk_dev6 = 0;
        fsk_dev7 = 0;
        fsk_spi_dev = 0;
        reg125 = 8840;
    }

    ~lmx2572_regs_t(void){
        delete _state;
    }

    uint16_t get_reg(int addr){
        uint16_t reg = 0;
        switch(addr){
        case 0:
            reg |= (uint16_t(powerdown) & 0x1) << 0;
            reg |= (uint16_t(reset) & 0x1) << 1;
            reg |= (uint16_t(muxout_ld_sel) & 0x1) << 2;
            reg |= (uint16_t(fcal_en) & 0x1) << 3;
            reg |= (uint16_t(reg0_reserved0) & 0x1) << 4;
            reg |= (uint16_t(fcal_lpfd_adj) & 0x3) << 5;
            reg |= (uint16_t(fcal_hpfd_adj) & 0x3) << 7;
            reg |= (uint16_t(out_mute) & 0x1) << 9;
            reg |= (uint16_t(reg0_reserved1) & 0x1) << 10;
            reg |= (uint16_t(add_hold) & 0x1) << 11;
            reg |= (uint16_t(reg0_reserved2) & 0x3) << 12;
            reg |= (uint16_t(vco_phase_sync_en) & 0x1) << 14;
            reg |= (uint16_t(ramp_en) & 0x1) << 15;
            break;
        case 1:
            reg |= (uint16_t(cal_clk_div) & 0x7) << 0;
            reg |= (uint16_t(reg1_reserved0) & 0x1fff) << 3;
            break;
        case 2:
            reg |= (uint16_t(reg2_reserved0) & 0xffff) << 0;
            break;
        case 3:
            reg |= (uint16_t(reg3_reserved0) & 0xffff) << 0;
            break;
        case 4:
            reg |= (uint16_t(reg4_reserved0) & 0xffff) << 0;
            break;
        case 5:
            reg |= (uint16_t(reg5_reserved0) & 0x7ff) << 0;
            reg |= (uint16_t(ipbuf_term) & 0x1) << 11;
            reg |= (uint16_t(ipbuf_type) & 0x1) << 12;
            reg |= (uint16_t(reg5_reserved1) & 0x7) << 13;
            break;
        case 6:
            reg |= (uint16_t(reg6_reserved0) & 0x7ff) << 0;
            reg |= (uint16_t(ldo_dly) & 0x1f) << 11;
            reg |= (uint16_t(reg66_reserved0) & 0xffff) << 0;
            break;
        case 7:
            reg |= (uint16_t(reg7_reserved0) & 0x3fff) << 0;
            reg |= (uint16_t(out_force) & 0x1) << 14;
            reg |= (uint16_t(reg7_reserved1) & 0x1) << 15;
            break;
        case 8:
            reg |= (uint16_t(reg8_reserved0) & 0x7ff) << 0;
            reg |= (uint16_t(vco_capctrl_force) & 0x1) << 11;
            reg |= (uint16_t(reg8_reserved1) & 0x3) << 12;
            reg |= (uint16_t(vco_daciset_force) & 0x1) << 14;
            reg |= (uint16_t(reg8_reserved2) & 0x1) << 15;
            break;
        case 9:
            reg |= (uint16_t(reg9_reserved0) & 0xfff) << 0;
            reg |= (uint16_t(osc_2x) & 0x1) << 12;
            reg |= (uint16_t(reg9_reserved1) & 0x1) << 13;
            reg |= (uint16_t(mult_hi) & 0x1) << 14;
            reg |= (uint16_t(reg9_reserved2) & 0x1) << 15;
            break;
        case 10:
            reg |= (uint16_t(reg10_reserved0) & 0x7f) << 0;
            reg |= (uint16_t(mult) & 0x1f) << 7;
            reg |= (uint16_t(reg10_reserved1) & 0xf) << 12;
            break;
        case 11:
            reg |= (uint16_t(reg11_reserved0) & 0xf) << 0;
            reg |= (uint16_t(pll_r) & 0xff) << 4;
            reg |= (uint16_t(reg11_reserved1) & 0xf) << 12;
            break;
        case 12:
            reg |= (uint16_t(pll_r_pre) & 0xfff) << 0;
            reg |= (uint16_t(reg12_reserved0) & 0xf) << 12;
            break;
        case 13:
            reg |= (uint16_t(reg13_reserved0) & 0xffff) << 0;
            break;
        case 14:
            reg |= (uint16_t(reg14_reserved0) & 0x7) << 0;
            reg |= (uint16_t(cpg) & 0xf) << 3;
            reg |= (uint16_t(reg14_reserved1) & 0x1ff) << 7;
            break;
        case 15:
            reg |= (uint16_t(reg15_reserved0) & 0xffff) << 0;
            break;
        case 16:
            reg |= (uint16_t(vco_daciset) & 0x1ff) << 0;
            reg |= (uint16_t(reg16_reserved0) & 0x7f) << 9;
            break;
        case 17:
            reg |= (uint16_t(vco_daciset_strt) & 0x1ff) << 0;
            reg |= (uint16_t(reg17_reserved0) & 0x7f) << 9;
            break;
        case 18:
            reg |= (uint16_t(reg18_reserved0) & 0xffff) << 0;
            break;
        case 19:
            reg |= (uint16_t(vco_capctrl) & 0xff) << 0;
            reg |= (uint16_t(reg19_reserved0) & 0xff) << 8;
            break;
        case 20:
            reg |= (uint16_t(reg20_reserved0) & 0x3ff) << 0;
            reg |= (uint16_t(vco_sel_force) & 0x1) << 10;
            reg |= (uint16_t(vco_sel) & 0x7) << 11;
            reg |= (uint16_t(reg20_reserved1) & 0x3) << 14;
            break;
        case 21:
            reg |= (uint16_t(reg21_reserved0) & 0xffff) << 0;
            break;
        case 22:
            reg |= (uint16_t(reg22_reserved0) & 0xffff) << 0;
            break;
        case 23:
            reg |= (uint16_t(reg23_reserved0) & 0xffff) << 0;
            break;
        case 24:
            reg |= (uint16_t(reg24_reserved0) & 0xffff) << 0;
            break;
        case 25:
            reg |= (uint16_t(reg25_reserved0) & 0xffff) << 0;
            break;
        case 26:
            reg |= (uint16_t(reg26_reserved0) & 0xffff) << 0;
            break;
        case 27:
            reg |= (uint16_t(reg27_reserved0) & 0xffff) << 0;
            break;
        case 28:
            reg |= (uint16_t(reg28_reserved0) & 0xffff) << 0;
            break;
        case 29:
            reg |= (uint16_t(reg29_reserved0) & 0xffff) << 0;
            break;
        case 30:
            reg |= (uint16_t(reg30_reserved0) & 0xffff) << 0;
            break;
        case 31:
            reg |= (uint16_t(reg31_reserved0) & 0xffff) << 0;
            break;
        case 32:
            reg |= (uint16_t(reg32_reserved0) & 0xffff) << 0;
            break;
        case 33:
            reg |= (uint16_t(reg33_reserved0) & 0xffff) << 0;
            break;
        case 34:
            reg |= (uint16_t(pll_n_upper_3_bits) & 0x7) << 0;
            reg |= (uint16_t(reg34_reserved0) & 0x1fff) << 3;
            break;
        case 35:
            reg |= (uint16_t(reg35_reserved0) & 0xffff) << 0;
            break;
        case 36:
            reg |= (uint16_t(pll_n_lower_16_bits) & 0xffff) << 0;
            break;
        case 37:
            reg |= (uint16_t(reg37_reserved0) & 0xff) << 0;
            reg |= (uint16_t(pfd_dly_sel) & 0x3f) << 8;
            reg |= (uint16_t(reg37_reserved1) & 0x1) << 14;
            reg |= (uint16_t(mash_seed_en) & 0x1) << 15;
            break;
        case 38:
            reg |= (uint16_t(pll_den_upper) & 0xffff) << 0;
            break;
        case 39:
            reg |= (uint16_t(pll_den_lower) & 0xffff) << 0;
            break;
        case 40:
            reg |= (uint16_t(mash_seed_upper) & 0xffff) << 0;
            break;
        case 41:
            reg |= (uint16_t(mash_seed_lower) & 0xffff) << 0;
            break;
        case 42:
            reg |= (uint16_t(pll_num_upper) & 0xffff) << 0;
            break;
        case 43:
            reg |= (uint16_t(pll_num_lower) & 0xffff) << 0;
            break;
        case 44:
            reg |= (uint16_t(mash_order) & 0x7) << 0;
            reg |= (uint16_t(reg44_reserved0) & 0x3) << 3;
            reg |= (uint16_t(mash_reset_n) & 0x1) << 5;
            reg |= (uint16_t(outa_pd) & 0x1) << 6;
            reg |= (uint16_t(outb_pd) & 0x1) << 7;
            reg |= (uint16_t(outa_pwr) & 0x3f) << 8;
            reg |= (uint16_t(reg44_reserved1) & 0x3) << 14;
            break;
        case 45:
            reg |= (uint16_t(outb_pwr) & 0x3f) << 0;
            reg |= (uint16_t(register45_reserved0) & 0x1f) << 6;
            reg |= (uint16_t(outa_mux) & 0x3) << 11;
            reg |= (uint16_t(register45_reserved1) & 0x7) << 13;
            break;
        case 46:
            reg |= (uint16_t(outb_mux) & 0x3) << 0;
            reg |= (uint16_t(register46_reserved0) & 0x3fff) << 2;
            break;
        case 47:
            reg |= (uint16_t(reg47_reserved0) & 0xffff) << 0;
            break;
        case 48:
            reg |= (uint16_t(reg48_reserved0) & 0xffff) << 0;
            break;
        case 49:
            reg |= (uint16_t(reg49_reserved0) & 0xffff) << 0;
            break;
        case 50:
            reg |= (uint16_t(reg50_reserved0) & 0xffff) << 0;
            break;
        case 51:
            reg |= (uint16_t(reg51_reserved0) & 0xffff) << 0;
            break;
        case 52:
            reg |= (uint16_t(reg52_reserved0) & 0xffff) << 0;
            break;
        case 53:
            reg |= (uint16_t(reg53_reserved0) & 0xffff) << 0;
            break;
        case 54:
            reg |= (uint16_t(reg54_reserved0) & 0xffff) << 0;
            break;
        case 55:
            reg |= (uint16_t(reg55_reserved0) & 0xffff) << 0;
            break;
        case 56:
            reg |= (uint16_t(reg56_reserved0) & 0xffff) << 0;
            break;
        case 57:
            reg |= (uint16_t(reg57_reserved0) & 0xffff) << 0;
            break;
        case 58:
            reg |= (uint16_t(reg58_reserved0) & 0x1ff) << 0;
            reg |= (uint16_t(inpin_fmt) & 0x7) << 9;
            reg |= (uint16_t(inpin_lvl) & 0x3) << 12;
            reg |= (uint16_t(inpin_hyst) & 0x1) << 14;
            reg |= (uint16_t(inpin_ignore) & 0x1) << 15;
            break;
        case 59:
            reg |= (uint16_t(ld_type) & 0x1) << 0;
            reg |= (uint16_t(reg59_reserved0) & 0x7fff) << 1;
            break;
        case 60:
            reg |= (uint16_t(ld_dly) & 0xffff) << 0;
            break;
        case 61:
            reg |= (uint16_t(reg61_reserved0) & 0xffff) << 0;
            break;
        case 62:
            reg |= (uint16_t(reg62_reserved0) & 0x3ff) << 0;
            reg |= (uint16_t(dblbuf_en_0) & 0x1) << 10;
            reg |= (uint16_t(dblbuf_en_1) & 0x1) << 11;
            reg |= (uint16_t(dblbuf_en_2) & 0x1) << 12;
            reg |= (uint16_t(dblbuf_en_3) & 0x1) << 13;
            reg |= (uint16_t(dblbuf_en_4) & 0x1) << 14;
            reg |= (uint16_t(dblbuf_en_5) & 0x1) << 15;
            break;
        case 63:
            reg |= (uint16_t(reg63_reserved0) & 0xffff) << 0;
            break;
        case 64:
            reg |= (uint16_t(reg64_reserved0) & 0xffff) << 0;
            break;
        case 65:
            reg |= (uint16_t(reg65_reserved0) & 0xffff) << 0;
            break;
        case 67:
            reg |= (uint16_t(reg67_reserved0) & 0xffff) << 0;
            break;
        case 68:
            reg |= (uint16_t(reg68_reserved0) & 0xffff) << 0;
            break;
        case 69:
            reg |= (uint16_t(mash_rst_count_upper) & 0xffff) << 0;
            break;
        case 70:
            reg |= (uint16_t(mash_rst_count_lower) & 0xffff) << 0;
            break;
        case 71:
            reg |= (uint16_t(reg71_reserved0) & 0x3) << 0;
            reg |= (uint16_t(sysref_repeat) & 0x1) << 2;
            reg |= (uint16_t(sysref_en) & 0x1) << 3;
            reg |= (uint16_t(sysref_pulse) & 0x1) << 4;
            reg |= (uint16_t(sysref_div_pre) & 0x7) << 5;
            reg |= (uint16_t(reg71_reserved1) & 0xff) << 8;
            break;
        case 72:
            reg |= (uint16_t(sysref_div) & 0x7ff) << 0;
            reg |= (uint16_t(reg72_reserved0) & 0x1f) << 11;
            break;
        case 73:
            reg |= (uint16_t(jesd_dac1_ctrl) & 0x3f) << 0;
            reg |= (uint16_t(jesd_dac2_ctrl) & 0x3f) << 6;
            reg |= (uint16_t(reg73_reserved0) & 0xf) << 12;
            break;
        case 74:
            reg |= (uint16_t(jesd_dac3_ctrl) & 0x3f) << 0;
            reg |= (uint16_t(jesd_dac4_ctrl) & 0x3f) << 6;
            reg |= (uint16_t(sysref_pulse_cnt) & 0xf) << 12;
            break;
        case 75:
            reg |= (uint16_t(reg75_reserved0) & 0x3f) << 0;
            reg |= (uint16_t(chdiv) & 0x1f) << 6;
            reg |= (uint16_t(reg75_reserved1) & 0x1f) << 11;
            break;
        case 76:
            reg |= (uint16_t(reg76_reserved0) & 0xffff) << 0;
            break;
        case 77:
            reg |= (uint16_t(reg77_reserved0) & 0xffff) << 0;
            break;
        case 78:
            reg |= (uint16_t(reg78_reserved0) & 0x1) << 0;
            reg |= (uint16_t(vco_capctrl_strt) & 0xff) << 1;
            reg |= (uint16_t(quick_recal_en) & 0x1) << 9;
            reg |= (uint16_t(reg78_reserved1) & 0x1) << 10;
            reg |= (uint16_t(ramp_thresh_33rd) & 0x1) << 11;
            reg |= (uint16_t(reg78_reserved2) & 0xf) << 12;
            break;
        case 79:
            reg |= (uint16_t(ramp_thresh_upper) & 0xffff) << 0;
            break;
        case 80:
            reg |= (uint16_t(ramp_thresh_lower) & 0xffff) << 0;
            break;
        case 81:
            reg |= (uint16_t(ramp_limit_high_33rd) & 0x1) << 0;
            reg |= (uint16_t(reg81_reserved0) & 0x7fff) << 1;
            break;
        case 82:
            reg |= (uint16_t(ramp_limit_high_upper) & 0xffff) << 0;
            break;
        case 83:
            reg |= (uint16_t(ramp_limit_high_lower) & 0xffff) << 0;
            break;
        case 84:
            reg |= (uint16_t(ramp_limit_low_33rd) & 0x1) << 0;
            reg |= (uint16_t(reg84_reserved0) & 0x7fff) << 1;
            break;
        case 85:
            reg |= (uint16_t(ramp_limit_low_upper) & 0xffff) << 0;
            break;
        case 86:
            reg |= (uint16_t(ramp_limit_low_lower) & 0xffff) << 0;
            break;
        case 87:
            reg |= (uint16_t(reg87_reserved0) & 0xffff) << 0;
            break;
        case 88:
            reg |= (uint16_t(reg88_reserved0) & 0xffff) << 0;
            break;
        case 89:
            reg |= (uint16_t(reg89_reserved0) & 0xffff) << 0;
            break;
        case 90:
            reg |= (uint16_t(reg90_reserved0) & 0xffff) << 0;
            break;
        case 91:
            reg |= (uint16_t(reg91_reserved0) & 0xffff) << 0;
            break;
        case 92:
            reg |= (uint16_t(reg92_reserved0) & 0xffff) << 0;
            break;
        case 93:
            reg |= (uint16_t(reg93_reserved0) & 0xffff) << 0;
            break;
        case 94:
            reg |= (uint16_t(reg94_reserved0) & 0xffff) << 0;
            break;
        case 95:
            reg |= (uint16_t(reg95_reserved0) & 0xffff) << 0;
            break;
        case 96:
            reg |= (uint16_t(reg96_reserved0) & 0x3) << 0;
            reg |= (uint16_t(ramp_burst_count) & 0x1fff) << 2;
            reg |= (uint16_t(ramp_burst_en) & 0x1) << 15;
            break;
        case 97:
            reg |= (uint16_t(ramp_burst_trig) & 0x3) << 0;
            reg |= (uint16_t(reg97_reserved0) & 0x1) << 2;
            reg |= (uint16_t(ramp_triga) & 0xf) << 3;
            reg |= (uint16_t(ramp_trgb) & 0xf) << 7;
            reg |= (uint16_t(reg97_reserved1) & 0xf) << 11;
            reg |= (uint16_t(ramp0_rst) & 0x1) << 15;
            break;
        case 98:
            reg |= (uint16_t(ramp0_dly) & 0x1) << 0;
            reg |= (uint16_t(reg98_reserved0) & 0x1) << 1;
            reg |= (uint16_t(ramp0_inc_upper_14) & 0x3fff) << 2;
            break;
        case 99:
            reg |= (uint16_t(ramp0_inc_lower) & 0xffff) << 0;
            break;
        case 100:
            reg |= (uint16_t(ramp0_len) & 0xffff) << 0;
            break;
        case 101:
            reg |= (uint16_t(ramp0_next_trig) & 0x3) << 0;
            reg |= (uint16_t(reg101_reserved0) & 0x3) << 2;
            reg |= (uint16_t(ramp0_next) & 0x1) << 4;
            reg |= (uint16_t(ramp1_rst) & 0x1) << 5;
            reg |= (uint16_t(ramp1_dly) & 0x1) << 6;
            reg |= (uint16_t(reg101_reserved1) & 0x1ff) << 7;
            break;
        case 102:
            reg |= (uint16_t(ramp1_inc_upper_14) & 0x3fff) << 0;
            reg |= (uint16_t(reg102_reserved0) & 0x3) << 14;
            break;
        case 103:
            reg |= (uint16_t(ramp1_inc_lower) & 0xffff) << 0;
            break;
        case 104:
            reg |= (uint16_t(ramp1_len) & 0xffff) << 0;
            break;
        case 105:
            reg |= (uint16_t(ramp1_next_trig) & 0x3) << 0;
            reg |= (uint16_t(reg105_reserved0) & 0x3) << 2;
            reg |= (uint16_t(ramp1_next) & 0x1) << 4;
            reg |= (uint16_t(ramp_manual) & 0x1) << 5;
            reg |= (uint16_t(ramp_dly_cnt) & 0x3ff) << 6;
            break;
        case 106:
            reg |= (uint16_t(ramp_scale_count) & 0x7) << 0;
            reg |= (uint16_t(reg106_reserved0) & 0x1) << 3;
            reg |= (uint16_t(ramp_trig_cal) & 0x1) << 4;
            reg |= (uint16_t(reg106_reserved1) & 0x7ff) << 5;
            break;
        case 114:
            reg |= (uint16_t(fsk_mode_sel) & 0x3) << 0;
            reg |= (uint16_t(fsk_spi_dev_sel) & 0x7) << 2;
            reg |= (uint16_t(fsk_spi_level) & 0x3) << 5;
            reg |= (uint16_t(reg114_reserved0) & 0x7) << 7;
            reg |= (uint16_t(fsk_en) & 0x1) << 10;
            reg |= (uint16_t(reg114_reserved1) & 0x1f) << 11;
            break;
        case 115:
            reg |= (uint16_t(reg115_reserved0) & 0x7) << 0;
            reg |= (uint16_t(fsk_dev_scale) & 0x1f) << 3;
            reg |= (uint16_t(reg115_reserved1) & 0xff) << 8;
            break;
        case 116:
            reg |= (uint16_t(fsk_dev0) & 0xffff) << 0;
            break;
        case 117:
            reg |= (uint16_t(fsk_dev1) & 0xffff) << 0;
            break;
        case 118:
            reg |= (uint16_t(fsk_dev2) & 0xffff) << 0;
            break;
        case 119:
            reg |= (uint16_t(fsk_dev3) & 0xffff) << 0;
            break;
        case 120:
            reg |= (uint16_t(fsk_dev4) & 0xffff) << 0;
            break;
        case 121:
            reg |= (uint16_t(fsk_dev5) & 0xffff) << 0;
            break;
        case 122:
            reg |= (uint16_t(fsk_dev6) & 0xffff) << 0;
            break;
        case 123:
            reg |= (uint16_t(fsk_dev7) & 0xffff) << 0;
            break;
        case 124:
            reg |= (uint16_t(fsk_spi_dev) & 0xffff) << 0;
            break;
        case 125:
            reg |= (uint16_t(reg125) & 0xffff) << 0;
            break;
        }
        return reg;
    }
    
    std::set<uint8_t> get_ro_regs()
    {
        return {107, 108, 109, 110, 111, 112, 113};
    }
    
    int get_num_regs()
    {
        return 126;
    }

    void save_state(void){
        if (_state == NULL) _state = new lmx2572_regs_t();
        _state->powerdown = this->powerdown;
        _state->reset = this->reset;
        _state->muxout_ld_sel = this->muxout_ld_sel;
        _state->fcal_en = this->fcal_en;
        _state->reg0_reserved0 = this->reg0_reserved0;
        _state->fcal_lpfd_adj = this->fcal_lpfd_adj;
        _state->fcal_hpfd_adj = this->fcal_hpfd_adj;
        _state->out_mute = this->out_mute;
        _state->reg0_reserved1 = this->reg0_reserved1;
        _state->add_hold = this->add_hold;
        _state->reg0_reserved2 = this->reg0_reserved2;
        _state->vco_phase_sync_en = this->vco_phase_sync_en;
        _state->ramp_en = this->ramp_en;
        _state->cal_clk_div = this->cal_clk_div;
        _state->reg1_reserved0 = this->reg1_reserved0;
        _state->reg2_reserved0 = this->reg2_reserved0;
        _state->reg3_reserved0 = this->reg3_reserved0;
        _state->reg4_reserved0 = this->reg4_reserved0;
        _state->reg5_reserved0 = this->reg5_reserved0;
        _state->ipbuf_term = this->ipbuf_term;
        _state->ipbuf_type = this->ipbuf_type;
        _state->reg5_reserved1 = this->reg5_reserved1;
        _state->reg6_reserved0 = this->reg6_reserved0;
        _state->ldo_dly = this->ldo_dly;
        _state->reg7_reserved0 = this->reg7_reserved0;
        _state->out_force = this->out_force;
        _state->reg7_reserved1 = this->reg7_reserved1;
        _state->reg8_reserved0 = this->reg8_reserved0;
        _state->vco_capctrl_force = this->vco_capctrl_force;
        _state->reg8_reserved1 = this->reg8_reserved1;
        _state->vco_daciset_force = this->vco_daciset_force;
        _state->reg8_reserved2 = this->reg8_reserved2;
        _state->reg9_reserved0 = this->reg9_reserved0;
        _state->osc_2x = this->osc_2x;
        _state->reg9_reserved1 = this->reg9_reserved1;
        _state->mult_hi = this->mult_hi;
        _state->reg9_reserved2 = this->reg9_reserved2;
        _state->reg10_reserved0 = this->reg10_reserved0;
        _state->mult = this->mult;
        _state->reg10_reserved1 = this->reg10_reserved1;
        _state->reg11_reserved0 = this->reg11_reserved0;
        _state->pll_r = this->pll_r;
        _state->reg11_reserved1 = this->reg11_reserved1;
        _state->pll_r_pre = this->pll_r_pre;
        _state->reg12_reserved0 = this->reg12_reserved0;
        _state->reg13_reserved0 = this->reg13_reserved0;
        _state->reg14_reserved0 = this->reg14_reserved0;
        _state->cpg = this->cpg;
        _state->reg14_reserved1 = this->reg14_reserved1;
        _state->reg15_reserved0 = this->reg15_reserved0;
        _state->vco_daciset = this->vco_daciset;
        _state->reg16_reserved0 = this->reg16_reserved0;
        _state->vco_daciset_strt = this->vco_daciset_strt;
        _state->reg17_reserved0 = this->reg17_reserved0;
        _state->reg18_reserved0 = this->reg18_reserved0;
        _state->vco_capctrl = this->vco_capctrl;
        _state->reg19_reserved0 = this->reg19_reserved0;
        _state->reg20_reserved0 = this->reg20_reserved0;
        _state->vco_sel_force = this->vco_sel_force;
        _state->vco_sel = this->vco_sel;
        _state->reg20_reserved1 = this->reg20_reserved1;
        _state->reg21_reserved0 = this->reg21_reserved0;
        _state->reg22_reserved0 = this->reg22_reserved0;
        _state->reg23_reserved0 = this->reg23_reserved0;
        _state->reg24_reserved0 = this->reg24_reserved0;
        _state->reg25_reserved0 = this->reg25_reserved0;
        _state->reg26_reserved0 = this->reg26_reserved0;
        _state->reg27_reserved0 = this->reg27_reserved0;
        _state->reg28_reserved0 = this->reg28_reserved0;
        _state->reg29_reserved0 = this->reg29_reserved0;
        _state->reg30_reserved0 = this->reg30_reserved0;
        _state->reg31_reserved0 = this->reg31_reserved0;
        _state->reg32_reserved0 = this->reg32_reserved0;
        _state->reg33_reserved0 = this->reg33_reserved0;
        _state->pll_n_upper_3_bits = this->pll_n_upper_3_bits;
        _state->reg34_reserved0 = this->reg34_reserved0;
        _state->reg35_reserved0 = this->reg35_reserved0;
        _state->pll_n_lower_16_bits = this->pll_n_lower_16_bits;
        _state->reg37_reserved0 = this->reg37_reserved0;
        _state->pfd_dly_sel = this->pfd_dly_sel;
        _state->reg37_reserved1 = this->reg37_reserved1;
        _state->mash_seed_en = this->mash_seed_en;
        _state->pll_den_upper = this->pll_den_upper;
        _state->pll_den_lower = this->pll_den_lower;
        _state->mash_seed_upper = this->mash_seed_upper;
        _state->mash_seed_lower = this->mash_seed_lower;
        _state->pll_num_upper = this->pll_num_upper;
        _state->pll_num_lower = this->pll_num_lower;
        _state->mash_order = this->mash_order;
        _state->reg44_reserved0 = this->reg44_reserved0;
        _state->mash_reset_n = this->mash_reset_n;
        _state->outa_pd = this->outa_pd;
        _state->outb_pd = this->outb_pd;
        _state->outa_pwr = this->outa_pwr;
        _state->reg44_reserved1 = this->reg44_reserved1;
        _state->outb_pwr = this->outb_pwr;
        _state->register45_reserved0 = this->register45_reserved0;
        _state->outa_mux = this->outa_mux;
        _state->register45_reserved1 = this->register45_reserved1;
        _state->outb_mux = this->outb_mux;
        _state->register46_reserved0 = this->register46_reserved0;
        _state->reg47_reserved0 = this->reg47_reserved0;
        _state->reg48_reserved0 = this->reg48_reserved0;
        _state->reg49_reserved0 = this->reg49_reserved0;
        _state->reg50_reserved0 = this->reg50_reserved0;
        _state->reg51_reserved0 = this->reg51_reserved0;
        _state->reg52_reserved0 = this->reg52_reserved0;
        _state->reg53_reserved0 = this->reg53_reserved0;
        _state->reg54_reserved0 = this->reg54_reserved0;
        _state->reg55_reserved0 = this->reg55_reserved0;
        _state->reg56_reserved0 = this->reg56_reserved0;
        _state->reg57_reserved0 = this->reg57_reserved0;
        _state->reg58_reserved0 = this->reg58_reserved0;
        _state->inpin_fmt = this->inpin_fmt;
        _state->inpin_lvl = this->inpin_lvl;
        _state->inpin_hyst = this->inpin_hyst;
        _state->inpin_ignore = this->inpin_ignore;
        _state->ld_type = this->ld_type;
        _state->reg59_reserved0 = this->reg59_reserved0;
        _state->ld_dly = this->ld_dly;
        _state->reg61_reserved0 = this->reg61_reserved0;
        _state->reg62_reserved0 = this->reg62_reserved0;
        _state->dblbuf_en_0 = this->dblbuf_en_0;
        _state->dblbuf_en_1 = this->dblbuf_en_1;
        _state->dblbuf_en_2 = this->dblbuf_en_2;
        _state->dblbuf_en_3 = this->dblbuf_en_3;
        _state->dblbuf_en_4 = this->dblbuf_en_4;
        _state->dblbuf_en_5 = this->dblbuf_en_5;
        _state->reg63_reserved0 = this->reg63_reserved0;
        _state->reg64_reserved0 = this->reg64_reserved0;
        _state->reg65_reserved0 = this->reg65_reserved0;
        _state->reg66_reserved0 = this->reg66_reserved0;
        _state->reg67_reserved0 = this->reg67_reserved0;
        _state->reg68_reserved0 = this->reg68_reserved0;
        _state->mash_rst_count_upper = this->mash_rst_count_upper;
        _state->mash_rst_count_lower = this->mash_rst_count_lower;
        _state->reg71_reserved0 = this->reg71_reserved0;
        _state->sysref_repeat = this->sysref_repeat;
        _state->sysref_en = this->sysref_en;
        _state->sysref_pulse = this->sysref_pulse;
        _state->sysref_div_pre = this->sysref_div_pre;
        _state->reg71_reserved1 = this->reg71_reserved1;
        _state->sysref_div = this->sysref_div;
        _state->reg72_reserved0 = this->reg72_reserved0;
        _state->jesd_dac1_ctrl = this->jesd_dac1_ctrl;
        _state->jesd_dac2_ctrl = this->jesd_dac2_ctrl;
        _state->reg73_reserved0 = this->reg73_reserved0;
        _state->jesd_dac3_ctrl = this->jesd_dac3_ctrl;
        _state->jesd_dac4_ctrl = this->jesd_dac4_ctrl;
        _state->sysref_pulse_cnt = this->sysref_pulse_cnt;
        _state->reg75_reserved0 = this->reg75_reserved0;
        _state->chdiv = this->chdiv;
        _state->reg75_reserved1 = this->reg75_reserved1;
        _state->reg76_reserved0 = this->reg76_reserved0;
        _state->reg77_reserved0 = this->reg77_reserved0;
        _state->reg78_reserved0 = this->reg78_reserved0;
        _state->vco_capctrl_strt = this->vco_capctrl_strt;
        _state->quick_recal_en = this->quick_recal_en;
        _state->reg78_reserved1 = this->reg78_reserved1;
        _state->ramp_thresh_33rd = this->ramp_thresh_33rd;
        _state->reg78_reserved2 = this->reg78_reserved2;
        _state->ramp_thresh_upper = this->ramp_thresh_upper;
        _state->ramp_thresh_lower = this->ramp_thresh_lower;
        _state->ramp_limit_high_33rd = this->ramp_limit_high_33rd;
        _state->reg81_reserved0 = this->reg81_reserved0;
        _state->ramp_limit_high_upper = this->ramp_limit_high_upper;
        _state->ramp_limit_high_lower = this->ramp_limit_high_lower;
        _state->ramp_limit_low_33rd = this->ramp_limit_low_33rd;
        _state->reg84_reserved0 = this->reg84_reserved0;
        _state->ramp_limit_low_upper = this->ramp_limit_low_upper;
        _state->ramp_limit_low_lower = this->ramp_limit_low_lower;
        _state->reg87_reserved0 = this->reg87_reserved0;
        _state->reg88_reserved0 = this->reg88_reserved0;
        _state->reg89_reserved0 = this->reg89_reserved0;
        _state->reg90_reserved0 = this->reg90_reserved0;
        _state->reg91_reserved0 = this->reg91_reserved0;
        _state->reg92_reserved0 = this->reg92_reserved0;
        _state->reg93_reserved0 = this->reg93_reserved0;
        _state->reg94_reserved0 = this->reg94_reserved0;
        _state->reg95_reserved0 = this->reg95_reserved0;
        _state->reg96_reserved0 = this->reg96_reserved0;
        _state->ramp_burst_count = this->ramp_burst_count;
        _state->ramp_burst_en = this->ramp_burst_en;
        _state->ramp_burst_trig = this->ramp_burst_trig;
        _state->reg97_reserved0 = this->reg97_reserved0;
        _state->ramp_triga = this->ramp_triga;
        _state->ramp_trgb = this->ramp_trgb;
        _state->reg97_reserved1 = this->reg97_reserved1;
        _state->ramp0_rst = this->ramp0_rst;
        _state->ramp0_dly = this->ramp0_dly;
        _state->reg98_reserved0 = this->reg98_reserved0;
        _state->ramp0_inc_upper_14 = this->ramp0_inc_upper_14;
        _state->ramp0_inc_lower = this->ramp0_inc_lower;
        _state->ramp0_len = this->ramp0_len;
        _state->ramp0_next_trig = this->ramp0_next_trig;
        _state->reg101_reserved0 = this->reg101_reserved0;
        _state->ramp0_next = this->ramp0_next;
        _state->ramp1_rst = this->ramp1_rst;
        _state->ramp1_dly = this->ramp1_dly;
        _state->reg101_reserved1 = this->reg101_reserved1;
        _state->ramp1_inc_upper_14 = this->ramp1_inc_upper_14;
        _state->reg102_reserved0 = this->reg102_reserved0;
        _state->ramp1_inc_lower = this->ramp1_inc_lower;
        _state->ramp1_len = this->ramp1_len;
        _state->ramp1_next_trig = this->ramp1_next_trig;
        _state->reg105_reserved0 = this->reg105_reserved0;
        _state->ramp1_next = this->ramp1_next;
        _state->ramp_manual = this->ramp_manual;
        _state->ramp_dly_cnt = this->ramp_dly_cnt;
        _state->ramp_scale_count = this->ramp_scale_count;
        _state->reg106_reserved0 = this->reg106_reserved0;
        _state->ramp_trig_cal = this->ramp_trig_cal;
        _state->reg106_reserved1 = this->reg106_reserved1;
        _state->fsk_mode_sel = this->fsk_mode_sel;
        _state->fsk_spi_dev_sel = this->fsk_spi_dev_sel;
        _state->fsk_spi_level = this->fsk_spi_level;
        _state->reg114_reserved0 = this->reg114_reserved0;
        _state->fsk_en = this->fsk_en;
        _state->reg114_reserved1 = this->reg114_reserved1;
        _state->reg115_reserved0 = this->reg115_reserved0;
        _state->fsk_dev_scale = this->fsk_dev_scale;
        _state->reg115_reserved1 = this->reg115_reserved1;
        _state->fsk_dev0 = this->fsk_dev0;
        _state->fsk_dev1 = this->fsk_dev1;
        _state->fsk_dev2 = this->fsk_dev2;
        _state->fsk_dev3 = this->fsk_dev3;
        _state->fsk_dev4 = this->fsk_dev4;
        _state->fsk_dev5 = this->fsk_dev5;
        _state->fsk_dev6 = this->fsk_dev6;
        _state->fsk_dev7 = this->fsk_dev7;
        _state->fsk_spi_dev = this->fsk_spi_dev;
        _state->reg125 = this->reg125;
    }

    powerdown_t get_state_powerdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->powerdown;
    }

    reset_t get_state_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reset;
    }

    muxout_ld_sel_t get_state_muxout_ld_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->muxout_ld_sel;
    }

    fcal_en_t get_state_fcal_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_en;
    }

    uint8_t get_state_reg0_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved0;
    }

    uint8_t get_state_fcal_lpfd_adj(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_lpfd_adj;
    }

    uint8_t get_state_fcal_hpfd_adj(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fcal_hpfd_adj;
    }

    out_mute_t get_state_out_mute(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->out_mute;
    }

    uint8_t get_state_reg0_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved1;
    }

    uint8_t get_state_add_hold(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->add_hold;
    }

    uint8_t get_state_reg0_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg0_reserved2;
    }

    vco_phase_sync_en_t get_state_vco_phase_sync_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_phase_sync_en;
    }

    ramp_en_t get_state_ramp_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_en;
    }

    uint8_t get_state_cal_clk_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cal_clk_div;
    }

    uint16_t get_state_reg1_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg1_reserved0;
    }

    uint16_t get_state_reg2_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg2_reserved0;
    }

    uint16_t get_state_reg3_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg3_reserved0;
    }

    uint16_t get_state_reg4_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg4_reserved0;
    }

    uint16_t get_state_reg5_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg5_reserved0;
    }

    ipbuf_term_t get_state_ipbuf_term(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ipbuf_term;
    }

    ipbuf_type_t get_state_ipbuf_type(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ipbuf_type;
    }

    uint8_t get_state_reg5_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg5_reserved1;
    }

    uint16_t get_state_reg6_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg6_reserved0;
    }

    uint8_t get_state_ldo_dly(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ldo_dly;
    }

    uint16_t get_state_reg7_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg7_reserved0;
    }

    out_force_t get_state_out_force(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->out_force;
    }

    uint8_t get_state_reg7_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg7_reserved1;
    }

    uint16_t get_state_reg8_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved0;
    }

    vco_capctrl_force_t get_state_vco_capctrl_force(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_capctrl_force;
    }

    uint8_t get_state_reg8_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved1;
    }

    vco_daciset_force_t get_state_vco_daciset_force(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_daciset_force;
    }

    uint8_t get_state_reg8_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg8_reserved2;
    }

    uint16_t get_state_reg9_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved0;
    }

    osc_2x_t get_state_osc_2x(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->osc_2x;
    }

    uint8_t get_state_reg9_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved1;
    }

    mult_hi_t get_state_mult_hi(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mult_hi;
    }

    uint8_t get_state_reg9_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg9_reserved2;
    }

    uint8_t get_state_reg10_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg10_reserved0;
    }

    uint8_t get_state_mult(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mult;
    }

    uint8_t get_state_reg10_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg10_reserved1;
    }

    uint8_t get_state_reg11_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg11_reserved0;
    }

    uint8_t get_state_pll_r(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_r;
    }

    uint8_t get_state_reg11_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg11_reserved1;
    }

    uint16_t get_state_pll_r_pre(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_r_pre;
    }

    uint8_t get_state_reg12_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg12_reserved0;
    }

    uint16_t get_state_reg13_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg13_reserved0;
    }

    uint8_t get_state_reg14_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg14_reserved0;
    }

    uint8_t get_state_cpg(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cpg;
    }

    uint16_t get_state_reg14_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg14_reserved1;
    }

    uint16_t get_state_reg15_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg15_reserved0;
    }

    uint16_t get_state_vco_daciset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_daciset;
    }

    uint8_t get_state_reg16_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg16_reserved0;
    }

    uint16_t get_state_vco_daciset_strt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_daciset_strt;
    }

    uint8_t get_state_reg17_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg17_reserved0;
    }

    uint16_t get_state_reg18_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg18_reserved0;
    }

    uint8_t get_state_vco_capctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_capctrl;
    }

    uint8_t get_state_reg19_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg19_reserved0;
    }

    uint16_t get_state_reg20_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg20_reserved0;
    }

    vco_sel_force_t get_state_vco_sel_force(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_sel_force;
    }

    uint8_t get_state_vco_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_sel;
    }

    uint8_t get_state_reg20_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg20_reserved1;
    }

    uint16_t get_state_reg21_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg21_reserved0;
    }

    uint16_t get_state_reg22_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg22_reserved0;
    }

    uint16_t get_state_reg23_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg23_reserved0;
    }

    uint16_t get_state_reg24_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg24_reserved0;
    }

    uint16_t get_state_reg25_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg25_reserved0;
    }

    uint16_t get_state_reg26_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg26_reserved0;
    }

    uint16_t get_state_reg27_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg27_reserved0;
    }

    uint16_t get_state_reg28_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg28_reserved0;
    }

    uint16_t get_state_reg29_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg29_reserved0;
    }

    uint16_t get_state_reg30_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg30_reserved0;
    }

    uint16_t get_state_reg31_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg31_reserved0;
    }

    uint16_t get_state_reg32_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg32_reserved0;
    }

    uint16_t get_state_reg33_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg33_reserved0;
    }

    uint8_t get_state_pll_n_upper_3_bits(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_n_upper_3_bits;
    }

    uint16_t get_state_reg34_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg34_reserved0;
    }

    uint16_t get_state_reg35_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg35_reserved0;
    }

    uint16_t get_state_pll_n_lower_16_bits(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_n_lower_16_bits;
    }

    uint8_t get_state_reg37_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg37_reserved0;
    }

    uint8_t get_state_pfd_dly_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pfd_dly_sel;
    }

    uint8_t get_state_reg37_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg37_reserved1;
    }

    mash_seed_en_t get_state_mash_seed_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_seed_en;
    }

    uint16_t get_state_pll_den_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_den_upper;
    }

    uint16_t get_state_pll_den_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_den_lower;
    }

    uint16_t get_state_mash_seed_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_seed_upper;
    }

    uint16_t get_state_mash_seed_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_seed_lower;
    }

    uint16_t get_state_pll_num_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_num_upper;
    }

    uint16_t get_state_pll_num_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_num_lower;
    }

    mash_order_t get_state_mash_order(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_order;
    }

    uint8_t get_state_reg44_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg44_reserved0;
    }

    mash_reset_n_t get_state_mash_reset_n(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_reset_n;
    }

    outa_pd_t get_state_outa_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_pd;
    }

    outb_pd_t get_state_outb_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_pd;
    }

    uint8_t get_state_outa_pwr(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_pwr;
    }

    uint8_t get_state_reg44_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg44_reserved1;
    }

    uint8_t get_state_outb_pwr(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_pwr;
    }

    uint8_t get_state_register45_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->register45_reserved0;
    }

    outa_mux_t get_state_outa_mux(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outa_mux;
    }

    uint8_t get_state_register45_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->register45_reserved1;
    }

    outb_mux_t get_state_outb_mux(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->outb_mux;
    }

    uint16_t get_state_register46_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->register46_reserved0;
    }

    uint16_t get_state_reg47_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg47_reserved0;
    }

    uint16_t get_state_reg48_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg48_reserved0;
    }

    uint16_t get_state_reg49_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg49_reserved0;
    }

    uint16_t get_state_reg50_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg50_reserved0;
    }

    uint16_t get_state_reg51_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg51_reserved0;
    }

    uint16_t get_state_reg52_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg52_reserved0;
    }

    uint16_t get_state_reg53_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg53_reserved0;
    }

    uint16_t get_state_reg54_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg54_reserved0;
    }

    uint16_t get_state_reg55_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg55_reserved0;
    }

    uint16_t get_state_reg56_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg56_reserved0;
    }

    uint16_t get_state_reg57_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg57_reserved0;
    }

    uint16_t get_state_reg58_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg58_reserved0;
    }

    inpin_fmt_t get_state_inpin_fmt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inpin_fmt;
    }

    inpin_lvl_t get_state_inpin_lvl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inpin_lvl;
    }

    inpin_hyst_t get_state_inpin_hyst(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inpin_hyst;
    }

    uint8_t get_state_inpin_ignore(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inpin_ignore;
    }

    ld_type_t get_state_ld_type(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_type;
    }

    uint16_t get_state_reg59_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg59_reserved0;
    }

    uint16_t get_state_ld_dly(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_dly;
    }

    uint16_t get_state_reg61_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg61_reserved0;
    }

    uint16_t get_state_reg62_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg62_reserved0;
    }

    dblbuf_en_0_t get_state_dblbuf_en_0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_0;
    }

    dblbuf_en_1_t get_state_dblbuf_en_1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_1;
    }

    dblbuf_en_2_t get_state_dblbuf_en_2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_2;
    }

    dblbuf_en_3_t get_state_dblbuf_en_3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_3;
    }

    dblbuf_en_4_t get_state_dblbuf_en_4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_4;
    }

    dblbuf_en_5_t get_state_dblbuf_en_5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dblbuf_en_5;
    }

    uint16_t get_state_reg63_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg63_reserved0;
    }

    uint16_t get_state_reg64_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg64_reserved0;
    }

    uint16_t get_state_reg65_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg65_reserved0;
    }

    uint16_t get_state_reg66_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg66_reserved0;
    }

    uint16_t get_state_reg67_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg67_reserved0;
    }

    uint16_t get_state_reg68_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg68_reserved0;
    }

    uint16_t get_state_mash_rst_count_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_rst_count_upper;
    }

    uint16_t get_state_mash_rst_count_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->mash_rst_count_lower;
    }

    uint8_t get_state_reg71_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg71_reserved0;
    }

    sysref_repeat_t get_state_sysref_repeat(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_repeat;
    }

    sysref_en_t get_state_sysref_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_en;
    }

    sysref_pulse_t get_state_sysref_pulse(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_pulse;
    }

    sysref_div_pre_t get_state_sysref_div_pre(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_div_pre;
    }

    uint8_t get_state_reg71_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg71_reserved1;
    }

    uint16_t get_state_sysref_div(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_div;
    }

    uint8_t get_state_reg72_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg72_reserved0;
    }

    uint8_t get_state_jesd_dac1_ctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->jesd_dac1_ctrl;
    }

    uint8_t get_state_jesd_dac2_ctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->jesd_dac2_ctrl;
    }

    uint8_t get_state_reg73_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg73_reserved0;
    }

    uint8_t get_state_jesd_dac3_ctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->jesd_dac3_ctrl;
    }

    uint8_t get_state_jesd_dac4_ctrl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->jesd_dac4_ctrl;
    }

    uint8_t get_state_sysref_pulse_cnt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sysref_pulse_cnt;
    }

    uint8_t get_state_reg75_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg75_reserved0;
    }

    chdiv_t get_state_chdiv(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->chdiv;
    }

    uint8_t get_state_reg75_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg75_reserved1;
    }

    uint16_t get_state_reg76_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg76_reserved0;
    }

    uint16_t get_state_reg77_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg77_reserved0;
    }

    uint8_t get_state_reg78_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg78_reserved0;
    }

    uint8_t get_state_vco_capctrl_strt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_capctrl_strt;
    }

    uint8_t get_state_quick_recal_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->quick_recal_en;
    }

    uint8_t get_state_reg78_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg78_reserved1;
    }

    uint8_t get_state_ramp_thresh_33rd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_thresh_33rd;
    }

    uint8_t get_state_reg78_reserved2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg78_reserved2;
    }

    uint16_t get_state_ramp_thresh_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_thresh_upper;
    }

    uint16_t get_state_ramp_thresh_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_thresh_lower;
    }

    uint8_t get_state_ramp_limit_high_33rd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_high_33rd;
    }

    uint16_t get_state_reg81_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg81_reserved0;
    }

    uint16_t get_state_ramp_limit_high_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_high_upper;
    }

    uint16_t get_state_ramp_limit_high_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_high_lower;
    }

    uint8_t get_state_ramp_limit_low_33rd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_low_33rd;
    }

    uint16_t get_state_reg84_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg84_reserved0;
    }

    uint16_t get_state_ramp_limit_low_upper(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_low_upper;
    }

    uint16_t get_state_ramp_limit_low_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_limit_low_lower;
    }

    uint16_t get_state_reg87_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg87_reserved0;
    }

    uint16_t get_state_reg88_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg88_reserved0;
    }

    uint16_t get_state_reg89_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg89_reserved0;
    }

    uint16_t get_state_reg90_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg90_reserved0;
    }

    uint16_t get_state_reg91_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg91_reserved0;
    }

    uint16_t get_state_reg92_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg92_reserved0;
    }

    uint16_t get_state_reg93_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg93_reserved0;
    }

    uint16_t get_state_reg94_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg94_reserved0;
    }

    uint16_t get_state_reg95_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg95_reserved0;
    }

    uint8_t get_state_reg96_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg96_reserved0;
    }

    uint16_t get_state_ramp_burst_count(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_burst_count;
    }

    ramp_burst_en_t get_state_ramp_burst_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_burst_en;
    }

    ramp_burst_trig_t get_state_ramp_burst_trig(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_burst_trig;
    }

    uint8_t get_state_reg97_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg97_reserved0;
    }

    ramp_triga_t get_state_ramp_triga(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_triga;
    }

    ramp_trgb_t get_state_ramp_trgb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_trgb;
    }

    uint8_t get_state_reg97_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg97_reserved1;
    }

    ramp0_rst_t get_state_ramp0_rst(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_rst;
    }

    uint8_t get_state_ramp0_dly(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_dly;
    }

    uint8_t get_state_reg98_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg98_reserved0;
    }

    uint16_t get_state_ramp0_inc_upper_14(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_inc_upper_14;
    }

    uint16_t get_state_ramp0_inc_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_inc_lower;
    }

    uint16_t get_state_ramp0_len(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_len;
    }

    ramp0_next_trig_t get_state_ramp0_next_trig(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_next_trig;
    }

    uint8_t get_state_reg101_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg101_reserved0;
    }

    ramp0_next_t get_state_ramp0_next(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp0_next;
    }

    ramp1_rst_t get_state_ramp1_rst(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_rst;
    }

    uint8_t get_state_ramp1_dly(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_dly;
    }

    uint16_t get_state_reg101_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg101_reserved1;
    }

    uint16_t get_state_ramp1_inc_upper_14(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_inc_upper_14;
    }

    uint8_t get_state_reg102_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg102_reserved0;
    }

    uint16_t get_state_ramp1_inc_lower(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_inc_lower;
    }

    uint16_t get_state_ramp1_len(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_len;
    }

    ramp1_next_trig_t get_state_ramp1_next_trig(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_next_trig;
    }

    uint8_t get_state_reg105_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg105_reserved0;
    }

    ramp1_next_t get_state_ramp1_next(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp1_next;
    }

    ramp_manual_t get_state_ramp_manual(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_manual;
    }

    uint16_t get_state_ramp_dly_cnt(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_dly_cnt;
    }

    uint8_t get_state_ramp_scale_count(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_scale_count;
    }

    uint8_t get_state_reg106_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg106_reserved0;
    }

    ramp_trig_cal_t get_state_ramp_trig_cal(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_trig_cal;
    }

    uint16_t get_state_reg106_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg106_reserved1;
    }

    fsk_mode_sel_t get_state_fsk_mode_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_mode_sel;
    }

    uint8_t get_state_fsk_spi_dev_sel(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_spi_dev_sel;
    }

    fsk_spi_level_t get_state_fsk_spi_level(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_spi_level;
    }

    uint8_t get_state_reg114_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg114_reserved0;
    }

    fsk_en_t get_state_fsk_en(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_en;
    }

    uint8_t get_state_reg114_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg114_reserved1;
    }

    uint8_t get_state_reg115_reserved0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg115_reserved0;
    }

    uint8_t get_state_fsk_dev_scale(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev_scale;
    }

    uint8_t get_state_reg115_reserved1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg115_reserved1;
    }

    uint16_t get_state_fsk_dev0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev0;
    }

    uint16_t get_state_fsk_dev1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev1;
    }

    uint16_t get_state_fsk_dev2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev2;
    }

    uint16_t get_state_fsk_dev3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev3;
    }

    uint16_t get_state_fsk_dev4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev4;
    }

    uint16_t get_state_fsk_dev5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev5;
    }

    uint16_t get_state_fsk_dev6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev6;
    }

    uint16_t get_state_fsk_dev7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_dev7;
    }

    uint16_t get_state_fsk_spi_dev(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fsk_spi_dev;
    }

    uint16_t get_state_reg125(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reg125;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->powerdown != this->powerdown) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reset != this->reset) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->muxout_ld_sel != this->muxout_ld_sel) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_en != this->fcal_en) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved0 != this->reg0_reserved0) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_lpfd_adj != this->fcal_lpfd_adj) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->fcal_hpfd_adj != this->fcal_hpfd_adj) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->out_mute != this->out_mute) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved1 != this->reg0_reserved1) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->add_hold != this->add_hold) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->reg0_reserved2 != this->reg0_reserved2) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_phase_sync_en != this->vco_phase_sync_en) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_en != this->ramp_en) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->cal_clk_div != this->cal_clk_div) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->reg1_reserved0 != this->reg1_reserved0) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->reg2_reserved0 != this->reg2_reserved0) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->reg3_reserved0 != this->reg3_reserved0) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->reg4_reserved0 != this->reg4_reserved0) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->reg5_reserved0 != this->reg5_reserved0) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->ipbuf_term != this->ipbuf_term) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->ipbuf_type != this->ipbuf_type) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->reg5_reserved1 != this->reg5_reserved1) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->reg6_reserved0 != this->reg6_reserved0) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->ldo_dly != this->ldo_dly) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg7_reserved0 != this->reg7_reserved0) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->out_force != this->out_force) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg7_reserved1 != this->reg7_reserved1) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved0 != this->reg8_reserved0) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_capctrl_force != this->vco_capctrl_force) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved1 != this->reg8_reserved1) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_daciset_force != this->vco_daciset_force) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg8_reserved2 != this->reg8_reserved2) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved0 != this->reg9_reserved0) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->osc_2x != this->osc_2x) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved1 != this->reg9_reserved1) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->mult_hi != this->mult_hi) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg9_reserved2 != this->reg9_reserved2) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->reg10_reserved0 != this->reg10_reserved0) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->mult != this->mult) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg10_reserved1 != this->reg10_reserved1) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->reg11_reserved0 != this->reg11_reserved0) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_r != this->pll_r) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->reg11_reserved1 != this->reg11_reserved1) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_r_pre != this->pll_r_pre) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->reg12_reserved0 != this->reg12_reserved0) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->reg13_reserved0 != this->reg13_reserved0) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->reg14_reserved0 != this->reg14_reserved0) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->cpg != this->cpg) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->reg14_reserved1 != this->reg14_reserved1) {
                addrs.insert(14);
            }
        }
        if (include_ro || !false) {
            if(_state->reg15_reserved0 != this->reg15_reserved0) {
                addrs.insert(15);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_daciset != this->vco_daciset) {
                addrs.insert(16);
            }
        }
        if (include_ro || !false) {
            if(_state->reg16_reserved0 != this->reg16_reserved0) {
                addrs.insert(16);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_daciset_strt != this->vco_daciset_strt) {
                addrs.insert(17);
            }
        }
        if (include_ro || !false) {
            if(_state->reg17_reserved0 != this->reg17_reserved0) {
                addrs.insert(17);
            }
        }
        if (include_ro || !false) {
            if(_state->reg18_reserved0 != this->reg18_reserved0) {
                addrs.insert(18);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_capctrl != this->vco_capctrl) {
                addrs.insert(19);
            }
        }
        if (include_ro || !false) {
            if(_state->reg19_reserved0 != this->reg19_reserved0) {
                addrs.insert(19);
            }
        }
        if (include_ro || !false) {
            if(_state->reg20_reserved0 != this->reg20_reserved0) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_sel_force != this->vco_sel_force) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_sel != this->vco_sel) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->reg20_reserved1 != this->reg20_reserved1) {
                addrs.insert(20);
            }
        }
        if (include_ro || !false) {
            if(_state->reg21_reserved0 != this->reg21_reserved0) {
                addrs.insert(21);
            }
        }
        if (include_ro || !false) {
            if(_state->reg22_reserved0 != this->reg22_reserved0) {
                addrs.insert(22);
            }
        }
        if (include_ro || !false) {
            if(_state->reg23_reserved0 != this->reg23_reserved0) {
                addrs.insert(23);
            }
        }
        if (include_ro || !false) {
            if(_state->reg24_reserved0 != this->reg24_reserved0) {
                addrs.insert(24);
            }
        }
        if (include_ro || !false) {
            if(_state->reg25_reserved0 != this->reg25_reserved0) {
                addrs.insert(25);
            }
        }
        if (include_ro || !false) {
            if(_state->reg26_reserved0 != this->reg26_reserved0) {
                addrs.insert(26);
            }
        }
        if (include_ro || !false) {
            if(_state->reg27_reserved0 != this->reg27_reserved0) {
                addrs.insert(27);
            }
        }
        if (include_ro || !false) {
            if(_state->reg28_reserved0 != this->reg28_reserved0) {
                addrs.insert(28);
            }
        }
        if (include_ro || !false) {
            if(_state->reg29_reserved0 != this->reg29_reserved0) {
                addrs.insert(29);
            }
        }
        if (include_ro || !false) {
            if(_state->reg30_reserved0 != this->reg30_reserved0) {
                addrs.insert(30);
            }
        }
        if (include_ro || !false) {
            if(_state->reg31_reserved0 != this->reg31_reserved0) {
                addrs.insert(31);
            }
        }
        if (include_ro || !false) {
            if(_state->reg32_reserved0 != this->reg32_reserved0) {
                addrs.insert(32);
            }
        }
        if (include_ro || !false) {
            if(_state->reg33_reserved0 != this->reg33_reserved0) {
                addrs.insert(33);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_n_upper_3_bits != this->pll_n_upper_3_bits) {
                addrs.insert(34);
            }
        }
        if (include_ro || !false) {
            if(_state->reg34_reserved0 != this->reg34_reserved0) {
                addrs.insert(34);
            }
        }
        if (include_ro || !false) {
            if(_state->reg35_reserved0 != this->reg35_reserved0) {
                addrs.insert(35);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_n_lower_16_bits != this->pll_n_lower_16_bits) {
                addrs.insert(36);
            }
        }
        if (include_ro || !false) {
            if(_state->reg37_reserved0 != this->reg37_reserved0) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->pfd_dly_sel != this->pfd_dly_sel) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->reg37_reserved1 != this->reg37_reserved1) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_seed_en != this->mash_seed_en) {
                addrs.insert(37);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_den_upper != this->pll_den_upper) {
                addrs.insert(38);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_den_lower != this->pll_den_lower) {
                addrs.insert(39);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_seed_upper != this->mash_seed_upper) {
                addrs.insert(40);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_seed_lower != this->mash_seed_lower) {
                addrs.insert(41);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_num_upper != this->pll_num_upper) {
                addrs.insert(42);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_num_lower != this->pll_num_lower) {
                addrs.insert(43);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_order != this->mash_order) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->reg44_reserved0 != this->reg44_reserved0) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_reset_n != this->mash_reset_n) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_pd != this->outa_pd) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_pd != this->outb_pd) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_pwr != this->outa_pwr) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->reg44_reserved1 != this->reg44_reserved1) {
                addrs.insert(44);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_pwr != this->outb_pwr) {
                addrs.insert(45);
            }
        }
        if (include_ro || !false) {
            if(_state->register45_reserved0 != this->register45_reserved0) {
                addrs.insert(45);
            }
        }
        if (include_ro || !false) {
            if(_state->outa_mux != this->outa_mux) {
                addrs.insert(45);
            }
        }
        if (include_ro || !false) {
            if(_state->register45_reserved1 != this->register45_reserved1) {
                addrs.insert(45);
            }
        }
        if (include_ro || !false) {
            if(_state->outb_mux != this->outb_mux) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->register46_reserved0 != this->register46_reserved0) {
                addrs.insert(46);
            }
        }
        if (include_ro || !false) {
            if(_state->reg47_reserved0 != this->reg47_reserved0) {
                addrs.insert(47);
            }
        }
        if (include_ro || !false) {
            if(_state->reg48_reserved0 != this->reg48_reserved0) {
                addrs.insert(48);
            }
        }
        if (include_ro || !false) {
            if(_state->reg49_reserved0 != this->reg49_reserved0) {
                addrs.insert(49);
            }
        }
        if (include_ro || !false) {
            if(_state->reg50_reserved0 != this->reg50_reserved0) {
                addrs.insert(50);
            }
        }
        if (include_ro || !false) {
            if(_state->reg51_reserved0 != this->reg51_reserved0) {
                addrs.insert(51);
            }
        }
        if (include_ro || !false) {
            if(_state->reg52_reserved0 != this->reg52_reserved0) {
                addrs.insert(52);
            }
        }
        if (include_ro || !false) {
            if(_state->reg53_reserved0 != this->reg53_reserved0) {
                addrs.insert(53);
            }
        }
        if (include_ro || !false) {
            if(_state->reg54_reserved0 != this->reg54_reserved0) {
                addrs.insert(54);
            }
        }
        if (include_ro || !false) {
            if(_state->reg55_reserved0 != this->reg55_reserved0) {
                addrs.insert(55);
            }
        }
        if (include_ro || !false) {
            if(_state->reg56_reserved0 != this->reg56_reserved0) {
                addrs.insert(56);
            }
        }
        if (include_ro || !false) {
            if(_state->reg57_reserved0 != this->reg57_reserved0) {
                addrs.insert(57);
            }
        }
        if (include_ro || !false) {
            if(_state->reg58_reserved0 != this->reg58_reserved0) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->inpin_fmt != this->inpin_fmt) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->inpin_lvl != this->inpin_lvl) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->inpin_hyst != this->inpin_hyst) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->inpin_ignore != this->inpin_ignore) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_type != this->ld_type) {
                addrs.insert(59);
            }
        }
        if (include_ro || !false) {
            if(_state->reg59_reserved0 != this->reg59_reserved0) {
                addrs.insert(59);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_dly != this->ld_dly) {
                addrs.insert(60);
            }
        }
        if (include_ro || !false) {
            if(_state->reg61_reserved0 != this->reg61_reserved0) {
                addrs.insert(61);
            }
        }
        if (include_ro || !false) {
            if(_state->reg62_reserved0 != this->reg62_reserved0) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_0 != this->dblbuf_en_0) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_1 != this->dblbuf_en_1) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_2 != this->dblbuf_en_2) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_3 != this->dblbuf_en_3) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_4 != this->dblbuf_en_4) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->dblbuf_en_5 != this->dblbuf_en_5) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->reg63_reserved0 != this->reg63_reserved0) {
                addrs.insert(63);
            }
        }
        if (include_ro || !false) {
            if(_state->reg64_reserved0 != this->reg64_reserved0) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->reg65_reserved0 != this->reg65_reserved0) {
                addrs.insert(65);
            }
        }
        if (include_ro || !false) {
            if(_state->reg66_reserved0 != this->reg66_reserved0) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->reg67_reserved0 != this->reg67_reserved0) {
                addrs.insert(67);
            }
        }
        if (include_ro || !false) {
            if(_state->reg68_reserved0 != this->reg68_reserved0) {
                addrs.insert(68);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_rst_count_upper != this->mash_rst_count_upper) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->mash_rst_count_lower != this->mash_rst_count_lower) {
                addrs.insert(70);
            }
        }
        if (include_ro || !false) {
            if(_state->reg71_reserved0 != this->reg71_reserved0) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_repeat != this->sysref_repeat) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_en != this->sysref_en) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_pulse != this->sysref_pulse) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_div_pre != this->sysref_div_pre) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->reg71_reserved1 != this->reg71_reserved1) {
                addrs.insert(71);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_div != this->sysref_div) {
                addrs.insert(72);
            }
        }
        if (include_ro || !false) {
            if(_state->reg72_reserved0 != this->reg72_reserved0) {
                addrs.insert(72);
            }
        }
        if (include_ro || !false) {
            if(_state->jesd_dac1_ctrl != this->jesd_dac1_ctrl) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->jesd_dac2_ctrl != this->jesd_dac2_ctrl) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->reg73_reserved0 != this->reg73_reserved0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->jesd_dac3_ctrl != this->jesd_dac3_ctrl) {
                addrs.insert(74);
            }
        }
        if (include_ro || !false) {
            if(_state->jesd_dac4_ctrl != this->jesd_dac4_ctrl) {
                addrs.insert(74);
            }
        }
        if (include_ro || !false) {
            if(_state->sysref_pulse_cnt != this->sysref_pulse_cnt) {
                addrs.insert(74);
            }
        }
        if (include_ro || !false) {
            if(_state->reg75_reserved0 != this->reg75_reserved0) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->chdiv != this->chdiv) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->reg75_reserved1 != this->reg75_reserved1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->reg76_reserved0 != this->reg76_reserved0) {
                addrs.insert(76);
            }
        }
        if (include_ro || !false) {
            if(_state->reg77_reserved0 != this->reg77_reserved0) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->reg78_reserved0 != this->reg78_reserved0) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_capctrl_strt != this->vco_capctrl_strt) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->quick_recal_en != this->quick_recal_en) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->reg78_reserved1 != this->reg78_reserved1) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_thresh_33rd != this->ramp_thresh_33rd) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->reg78_reserved2 != this->reg78_reserved2) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_thresh_upper != this->ramp_thresh_upper) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_thresh_lower != this->ramp_thresh_lower) {
                addrs.insert(80);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_high_33rd != this->ramp_limit_high_33rd) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->reg81_reserved0 != this->reg81_reserved0) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_high_upper != this->ramp_limit_high_upper) {
                addrs.insert(82);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_high_lower != this->ramp_limit_high_lower) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_low_33rd != this->ramp_limit_low_33rd) {
                addrs.insert(84);
            }
        }
        if (include_ro || !false) {
            if(_state->reg84_reserved0 != this->reg84_reserved0) {
                addrs.insert(84);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_low_upper != this->ramp_limit_low_upper) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_limit_low_lower != this->ramp_limit_low_lower) {
                addrs.insert(86);
            }
        }
        if (include_ro || !false) {
            if(_state->reg87_reserved0 != this->reg87_reserved0) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->reg88_reserved0 != this->reg88_reserved0) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->reg89_reserved0 != this->reg89_reserved0) {
                addrs.insert(89);
            }
        }
        if (include_ro || !false) {
            if(_state->reg90_reserved0 != this->reg90_reserved0) {
                addrs.insert(90);
            }
        }
        if (include_ro || !false) {
            if(_state->reg91_reserved0 != this->reg91_reserved0) {
                addrs.insert(91);
            }
        }
        if (include_ro || !false) {
            if(_state->reg92_reserved0 != this->reg92_reserved0) {
                addrs.insert(92);
            }
        }
        if (include_ro || !false) {
            if(_state->reg93_reserved0 != this->reg93_reserved0) {
                addrs.insert(93);
            }
        }
        if (include_ro || !false) {
            if(_state->reg94_reserved0 != this->reg94_reserved0) {
                addrs.insert(94);
            }
        }
        if (include_ro || !false) {
            if(_state->reg95_reserved0 != this->reg95_reserved0) {
                addrs.insert(95);
            }
        }
        if (include_ro || !false) {
            if(_state->reg96_reserved0 != this->reg96_reserved0) {
                addrs.insert(96);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_burst_count != this->ramp_burst_count) {
                addrs.insert(96);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_burst_en != this->ramp_burst_en) {
                addrs.insert(96);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_burst_trig != this->ramp_burst_trig) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->reg97_reserved0 != this->reg97_reserved0) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_triga != this->ramp_triga) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_trgb != this->ramp_trgb) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->reg97_reserved1 != this->reg97_reserved1) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_rst != this->ramp0_rst) {
                addrs.insert(97);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_dly != this->ramp0_dly) {
                addrs.insert(98);
            }
        }
        if (include_ro || !false) {
            if(_state->reg98_reserved0 != this->reg98_reserved0) {
                addrs.insert(98);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_inc_upper_14 != this->ramp0_inc_upper_14) {
                addrs.insert(98);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_inc_lower != this->ramp0_inc_lower) {
                addrs.insert(99);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_len != this->ramp0_len) {
                addrs.insert(100);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_next_trig != this->ramp0_next_trig) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->reg101_reserved0 != this->reg101_reserved0) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp0_next != this->ramp0_next) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_rst != this->ramp1_rst) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_dly != this->ramp1_dly) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->reg101_reserved1 != this->reg101_reserved1) {
                addrs.insert(101);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_inc_upper_14 != this->ramp1_inc_upper_14) {
                addrs.insert(102);
            }
        }
        if (include_ro || !false) {
            if(_state->reg102_reserved0 != this->reg102_reserved0) {
                addrs.insert(102);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_inc_lower != this->ramp1_inc_lower) {
                addrs.insert(103);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_len != this->ramp1_len) {
                addrs.insert(104);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_next_trig != this->ramp1_next_trig) {
                addrs.insert(105);
            }
        }
        if (include_ro || !false) {
            if(_state->reg105_reserved0 != this->reg105_reserved0) {
                addrs.insert(105);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp1_next != this->ramp1_next) {
                addrs.insert(105);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_manual != this->ramp_manual) {
                addrs.insert(105);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_dly_cnt != this->ramp_dly_cnt) {
                addrs.insert(105);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_scale_count != this->ramp_scale_count) {
                addrs.insert(106);
            }
        }
        if (include_ro || !false) {
            if(_state->reg106_reserved0 != this->reg106_reserved0) {
                addrs.insert(106);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_trig_cal != this->ramp_trig_cal) {
                addrs.insert(106);
            }
        }
        if (include_ro || !false) {
            if(_state->reg106_reserved1 != this->reg106_reserved1) {
                addrs.insert(106);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_mode_sel != this->fsk_mode_sel) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_spi_dev_sel != this->fsk_spi_dev_sel) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_spi_level != this->fsk_spi_level) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->reg114_reserved0 != this->reg114_reserved0) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_en != this->fsk_en) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->reg114_reserved1 != this->reg114_reserved1) {
                addrs.insert(114);
            }
        }
        if (include_ro || !false) {
            if(_state->reg115_reserved0 != this->reg115_reserved0) {
                addrs.insert(115);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev_scale != this->fsk_dev_scale) {
                addrs.insert(115);
            }
        }
        if (include_ro || !false) {
            if(_state->reg115_reserved1 != this->reg115_reserved1) {
                addrs.insert(115);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev0 != this->fsk_dev0) {
                addrs.insert(116);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev1 != this->fsk_dev1) {
                addrs.insert(117);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev2 != this->fsk_dev2) {
                addrs.insert(118);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev3 != this->fsk_dev3) {
                addrs.insert(119);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev4 != this->fsk_dev4) {
                addrs.insert(120);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev5 != this->fsk_dev5) {
                addrs.insert(121);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev6 != this->fsk_dev6) {
                addrs.insert(122);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_dev7 != this->fsk_dev7) {
                addrs.insert(123);
            }
        }
        if (include_ro || !false) {
            if(_state->fsk_spi_dev != this->fsk_spi_dev) {
                addrs.insert(124);
            }
        }
        if (include_ro || !false) {
            if(_state->reg125 != this->reg125) {
                addrs.insert(125);
            }
        }
        return addrs;
    }

private:
    lmx2572_regs_t *_state;
};

#endif /* INCLUDED_LMX2572_REGS_HPP */
