#ifndef INCLUDED_OFFICECFG_VCL_HXX
#define INCLUDED_OFFICECFG_VCL_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace VCL {

struct ExtraLanguages: public comphelper::ConfigurationSet< ExtraLanguages> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/ExtraLanguages"_ustr); return PATH; }
private:
    ExtraLanguages(); // not defined
    ~ExtraLanguages(); // not defined
};

struct DefaultFonts: public comphelper::ConfigurationSet< DefaultFonts> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/DefaultFonts"_ustr); return PATH; }
private:
    DefaultFonts(); // not defined
    ~DefaultFonts(); // not defined
};

struct FontSubstitutions: public comphelper::ConfigurationSet< FontSubstitutions> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/FontSubstitutions"_ustr); return PATH; }
private:
    FontSubstitutions(); // not defined
    ~FontSubstitutions(); // not defined
};

struct VCLSettings: public comphelper::ConfigurationGroup< VCLSettings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings"_ustr); return PATH; }

struct Transfer: public comphelper::ConfigurationGroup< Transfer> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/Transfer"_ustr); return PATH; }

struct SelectionTimeout: public comphelper::ConfigurationProperty<SelectionTimeout, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/Transfer/SelectionTimeout"_ustr); return PATH; }
private:
    SelectionTimeout(); // not defined
    ~SelectionTimeout(); // not defined
};

private:
    Transfer(); // not defined
    ~Transfer(); // not defined
};

struct DesktopManagement: public comphelper::ConfigurationGroup< DesktopManagement> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/DesktopManagement"_ustr); return PATH; }

struct DisablePrinting: public comphelper::ConfigurationProperty<DisablePrinting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/DesktopManagement/DisablePrinting"_ustr); return PATH; }
private:
    DisablePrinting(); // not defined
    ~DisablePrinting(); // not defined
};

private:
    DesktopManagement(); // not defined
    ~DesktopManagement(); // not defined
};

struct Menu: public comphelper::ConfigurationGroup< Menu> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/Menu"_ustr); return PATH; }

struct SuppressAccelerators: public comphelper::ConfigurationProperty<SuppressAccelerators, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/Menu/SuppressAccelerators"_ustr); return PATH; }
private:
    SuppressAccelerators(); // not defined
    ~SuppressAccelerators(); // not defined
};

private:
    Menu(); // not defined
    ~Menu(); // not defined
};

struct PrintDialog: public comphelper::ConfigurationGroup< PrintDialog> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog"_ustr); return PATH; }

struct Collate: public comphelper::ConfigurationProperty<Collate, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/Collate"_ustr); return PATH; }
private:
    Collate(); // not defined
    ~Collate(); // not defined
};

struct CollateSingleJobs: public comphelper::ConfigurationProperty<CollateSingleJobs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/CollateSingleJobs"_ustr); return PATH; }
private:
    CollateSingleJobs(); // not defined
    ~CollateSingleJobs(); // not defined
};

struct HasPreview: public comphelper::ConfigurationProperty<HasPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/HasPreview"_ustr); return PATH; }
private:
    HasPreview(); // not defined
    ~HasPreview(); // not defined
};

struct LastPage: public comphelper::ConfigurationProperty<LastPage, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/LastPage"_ustr); return PATH; }
private:
    LastPage(); // not defined
    ~LastPage(); // not defined
};

struct LastPrinter: public comphelper::ConfigurationProperty<LastPrinter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/LastPrinter"_ustr); return PATH; }
private:
    LastPrinter(); // not defined
    ~LastPrinter(); // not defined
};

struct WindowState: public comphelper::ConfigurationProperty<WindowState, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/PrintDialog/WindowState"_ustr); return PATH; }
private:
    WindowState(); // not defined
    ~WindowState(); // not defined
};

private:
    PrintDialog(); // not defined
    ~PrintDialog(); // not defined
};

struct WM: public comphelper::ConfigurationGroup< WM> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/WM"_ustr); return PATH; }

struct ShouldSwitchWorkspace: public comphelper::ConfigurationProperty<ShouldSwitchWorkspace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.VCL/VCLSettings/WM/ShouldSwitchWorkspace"_ustr); return PATH; }
private:
    ShouldSwitchWorkspace(); // not defined
    ~ShouldSwitchWorkspace(); // not defined
};

private:
    WM(); // not defined
    ~WM(); // not defined
};

private:
    VCLSettings(); // not defined
    ~VCLSettings(); // not defined
};

} }

#endif
