/* automatically generated by rust-bindgen 0.72.1 */

#![allow(clippy::all)]
#![allow(improper_ctypes)]
#![allow(unused_unsafe)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(unsafe_op_in_unsafe_fn)]
#![allow(unnecessary_transmutes)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
pub const PIPE_FORMAT_NONE: pipe_format = 0;
pub const PIPE_FORMAT_VERTEX_START: pipe_format = 1;
pub const PIPE_FORMAT_R64_UINT: pipe_format = 1;
pub const PIPE_FORMAT_R64G64_UINT: pipe_format = 2;
pub const PIPE_FORMAT_R64G64B64_UINT: pipe_format = 3;
pub const PIPE_FORMAT_R64G64B64A64_UINT: pipe_format = 4;
pub const PIPE_FORMAT_R64_SINT: pipe_format = 5;
pub const PIPE_FORMAT_R64G64_SINT: pipe_format = 6;
pub const PIPE_FORMAT_R64G64B64_SINT: pipe_format = 7;
pub const PIPE_FORMAT_R64G64B64A64_SINT: pipe_format = 8;
pub const PIPE_FORMAT_R64_FLOAT: pipe_format = 9;
pub const PIPE_FORMAT_R64G64_FLOAT: pipe_format = 10;
pub const PIPE_FORMAT_R64G64B64_FLOAT: pipe_format = 11;
pub const PIPE_FORMAT_R64G64B64A64_FLOAT: pipe_format = 12;
pub const PIPE_FORMAT_R32_UINT: pipe_format = 13;
pub const PIPE_FORMAT_R32G32_UINT: pipe_format = 14;
pub const PIPE_FORMAT_R32G32B32_UINT: pipe_format = 15;
pub const PIPE_FORMAT_R32G32B32A32_UINT: pipe_format = 16;
pub const PIPE_FORMAT_R32_SINT: pipe_format = 17;
pub const PIPE_FORMAT_R32G32_SINT: pipe_format = 18;
pub const PIPE_FORMAT_R32G32B32_SINT: pipe_format = 19;
pub const PIPE_FORMAT_R32G32B32A32_SINT: pipe_format = 20;
pub const PIPE_FORMAT_R32_FLOAT: pipe_format = 21;
pub const PIPE_FORMAT_R32G32_FLOAT: pipe_format = 22;
pub const PIPE_FORMAT_R32G32B32_FLOAT: pipe_format = 23;
pub const PIPE_FORMAT_R32G32B32A32_FLOAT: pipe_format = 24;
pub const PIPE_FORMAT_R32_UNORM: pipe_format = 25;
pub const PIPE_FORMAT_R32G32_UNORM: pipe_format = 26;
pub const PIPE_FORMAT_R32G32B32_UNORM: pipe_format = 27;
pub const PIPE_FORMAT_R32G32B32A32_UNORM: pipe_format = 28;
pub const PIPE_FORMAT_R32_SNORM: pipe_format = 29;
pub const PIPE_FORMAT_R32G32_SNORM: pipe_format = 30;
pub const PIPE_FORMAT_R32G32B32_SNORM: pipe_format = 31;
pub const PIPE_FORMAT_R32G32B32A32_SNORM: pipe_format = 32;
pub const PIPE_FORMAT_R32_USCALED: pipe_format = 33;
pub const PIPE_FORMAT_R32G32_USCALED: pipe_format = 34;
pub const PIPE_FORMAT_R32G32B32_USCALED: pipe_format = 35;
pub const PIPE_FORMAT_R32G32B32A32_USCALED: pipe_format = 36;
pub const PIPE_FORMAT_R32_SSCALED: pipe_format = 37;
pub const PIPE_FORMAT_R32G32_SSCALED: pipe_format = 38;
pub const PIPE_FORMAT_R32G32B32_SSCALED: pipe_format = 39;
pub const PIPE_FORMAT_R32G32B32A32_SSCALED: pipe_format = 40;
pub const PIPE_FORMAT_R32_FIXED: pipe_format = 41;
pub const PIPE_FORMAT_R32G32_FIXED: pipe_format = 42;
pub const PIPE_FORMAT_R32G32B32_FIXED: pipe_format = 43;
pub const PIPE_FORMAT_R32G32B32A32_FIXED: pipe_format = 44;
pub const PIPE_FORMAT_R16_UINT: pipe_format = 45;
pub const PIPE_FORMAT_R16G16_UINT: pipe_format = 46;
pub const PIPE_FORMAT_R16G16B16_UINT: pipe_format = 47;
pub const PIPE_FORMAT_R16G16B16A16_UINT: pipe_format = 48;
pub const PIPE_FORMAT_R16_SINT: pipe_format = 49;
pub const PIPE_FORMAT_R16G16_SINT: pipe_format = 50;
pub const PIPE_FORMAT_R16G16B16_SINT: pipe_format = 51;
pub const PIPE_FORMAT_R16G16B16A16_SINT: pipe_format = 52;
pub const PIPE_FORMAT_R16_FLOAT: pipe_format = 53;
pub const PIPE_FORMAT_R16G16_FLOAT: pipe_format = 54;
pub const PIPE_FORMAT_R16G16B16_FLOAT: pipe_format = 55;
pub const PIPE_FORMAT_R16G16B16A16_FLOAT: pipe_format = 56;
pub const PIPE_FORMAT_R16_UNORM: pipe_format = 57;
pub const PIPE_FORMAT_R16G16_UNORM: pipe_format = 58;
pub const PIPE_FORMAT_R16G16B16_UNORM: pipe_format = 59;
pub const PIPE_FORMAT_R16G16B16A16_UNORM: pipe_format = 60;
pub const PIPE_FORMAT_R16_SNORM: pipe_format = 61;
pub const PIPE_FORMAT_R16G16_SNORM: pipe_format = 62;
pub const PIPE_FORMAT_R16G16B16_SNORM: pipe_format = 63;
pub const PIPE_FORMAT_R16G16B16A16_SNORM: pipe_format = 64;
pub const PIPE_FORMAT_R16_USCALED: pipe_format = 65;
pub const PIPE_FORMAT_R16G16_USCALED: pipe_format = 66;
pub const PIPE_FORMAT_R16G16B16_USCALED: pipe_format = 67;
pub const PIPE_FORMAT_R16G16B16A16_USCALED: pipe_format = 68;
pub const PIPE_FORMAT_R16_SSCALED: pipe_format = 69;
pub const PIPE_FORMAT_R16G16_SSCALED: pipe_format = 70;
pub const PIPE_FORMAT_R16G16B16_SSCALED: pipe_format = 71;
pub const PIPE_FORMAT_R16G16B16A16_SSCALED: pipe_format = 72;
pub const PIPE_FORMAT_R8_UINT: pipe_format = 73;
pub const PIPE_FORMAT_R8G8_UINT: pipe_format = 74;
pub const PIPE_FORMAT_R8G8B8_UINT: pipe_format = 75;
pub const PIPE_FORMAT_R8G8B8A8_UINT: pipe_format = 76;
pub const PIPE_FORMAT_R8_SINT: pipe_format = 77;
pub const PIPE_FORMAT_R8G8_SINT: pipe_format = 78;
pub const PIPE_FORMAT_R8G8B8_SINT: pipe_format = 79;
pub const PIPE_FORMAT_R8G8B8A8_SINT: pipe_format = 80;
pub const PIPE_FORMAT_R8_UNORM: pipe_format = 81;
pub const PIPE_FORMAT_R8G8_UNORM: pipe_format = 82;
pub const PIPE_FORMAT_R8G8B8_UNORM: pipe_format = 83;
pub const PIPE_FORMAT_R8G8B8A8_UNORM: pipe_format = 84;
pub const PIPE_FORMAT_R8_SNORM: pipe_format = 85;
pub const PIPE_FORMAT_R8G8_SNORM: pipe_format = 86;
pub const PIPE_FORMAT_R8G8B8_SNORM: pipe_format = 87;
pub const PIPE_FORMAT_R8G8B8A8_SNORM: pipe_format = 88;
pub const PIPE_FORMAT_R8_USCALED: pipe_format = 89;
pub const PIPE_FORMAT_R8G8_USCALED: pipe_format = 90;
pub const PIPE_FORMAT_R8G8B8_USCALED: pipe_format = 91;
pub const PIPE_FORMAT_R8G8B8A8_USCALED: pipe_format = 92;
pub const PIPE_FORMAT_R8_SSCALED: pipe_format = 93;
pub const PIPE_FORMAT_R8G8_SSCALED: pipe_format = 94;
pub const PIPE_FORMAT_R8G8B8_SSCALED: pipe_format = 95;
pub const PIPE_FORMAT_R8G8B8A8_SSCALED: pipe_format = 96;
pub const PIPE_FORMAT_B8G8R8_UINT: pipe_format = 97;
pub const PIPE_FORMAT_B8G8R8_SINT: pipe_format = 98;
pub const PIPE_FORMAT_B8G8R8_UNORM: pipe_format = 99;
pub const PIPE_FORMAT_B8G8R8_SNORM: pipe_format = 100;
pub const PIPE_FORMAT_B8G8R8_USCALED: pipe_format = 101;
pub const PIPE_FORMAT_B8G8R8_SSCALED: pipe_format = 102;
pub const PIPE_FORMAT_B8G8R8A8_UINT: pipe_format = 103;
pub const PIPE_FORMAT_B8G8R8A8_SINT: pipe_format = 104;
pub const PIPE_FORMAT_B8G8R8A8_UNORM: pipe_format = 105;
pub const PIPE_FORMAT_B8G8R8A8_SNORM: pipe_format = 106;
pub const PIPE_FORMAT_B8G8R8A8_USCALED: pipe_format = 107;
pub const PIPE_FORMAT_B8G8R8A8_SSCALED: pipe_format = 108;
pub const PIPE_FORMAT_A8B8G8R8_USCALED: pipe_format = 109;
pub const PIPE_FORMAT_A8B8G8R8_SSCALED: pipe_format = 110;
pub const PIPE_FORMAT_A8R8G8B8_UNORM: pipe_format = 111;
pub const PIPE_FORMAT_R10G10B10A2_UINT: pipe_format = 112;
pub const PIPE_FORMAT_R10G10B10A2_SINT: pipe_format = 113;
pub const PIPE_FORMAT_R10G10B10A2_UNORM: pipe_format = 114;
pub const PIPE_FORMAT_R10G10B10A2_SNORM: pipe_format = 115;
pub const PIPE_FORMAT_R10G10B10A2_USCALED: pipe_format = 116;
pub const PIPE_FORMAT_R10G10B10A2_SSCALED: pipe_format = 117;
pub const PIPE_FORMAT_B10G10R10A2_UINT: pipe_format = 118;
pub const PIPE_FORMAT_B10G10R10A2_SINT: pipe_format = 119;
pub const PIPE_FORMAT_B10G10R10A2_UNORM: pipe_format = 120;
pub const PIPE_FORMAT_B10G10R10A2_SNORM: pipe_format = 121;
pub const PIPE_FORMAT_B10G10R10A2_USCALED: pipe_format = 122;
pub const PIPE_FORMAT_B10G10R10A2_SSCALED: pipe_format = 123;
pub const PIPE_FORMAT_R11G11B10_FLOAT: pipe_format = 124;
pub const PIPE_FORMAT_VERTEX_END: pipe_format = 124;
pub const PIPE_FORMAT_YUV_START: pipe_format = 125;
pub const PIPE_FORMAT_U8Y8V8Y8_422_UNORM: pipe_format = 125;
pub const PIPE_FORMAT_V8Y8U8Y8_422_UNORM: pipe_format = 126;
pub const PIPE_FORMAT_Y8U8Y8V8_422_UNORM: pipe_format = 127;
pub const PIPE_FORMAT_Y8V8Y8U8_422_UNORM: pipe_format = 128;
pub const PIPE_FORMAT_A8Y8U8V8_444_UNORM: pipe_format = 129;
pub const PIPE_FORMAT_X8Y8U8V8_444_UNORM: pipe_format = 130;
pub const PIPE_FORMAT_Y8_V8_U8_420_UNORM: pipe_format = 131;
pub const PIPE_FORMAT_Y8_V8_U8_422_UNORM: pipe_format = 132;
pub const PIPE_FORMAT_Y8_U8_V8_420_UNORM: pipe_format = 133;
pub const PIPE_FORMAT_Y8_U8V8_420_UNORM: pipe_format = 134;
pub const PIPE_FORMAT_Y8_V8U8_420_UNORM: pipe_format = 135;
pub const PIPE_FORMAT_Y8_400_UNORM: pipe_format = 136;
pub const PIPE_FORMAT_Y10_U10V10_420_UNORM: pipe_format = 137;
pub const PIPE_FORMAT_Y10_U10V10_422_UNORM: pipe_format = 138;
pub const PIPE_FORMAT_Y16_U16V16_444_UNORM: pipe_format = 139;
pub const PIPE_FORMAT_Y8_UNORM: pipe_format = 140;
pub const PIPE_FORMAT_Y8_U8_V8_422_UNORM: pipe_format = 141;
pub const PIPE_FORMAT_Y8_U8V8_422_UNORM: pipe_format = 142;
pub const PIPE_FORMAT_Y8_V8U8_422_UNORM: pipe_format = 143;
pub const PIPE_FORMAT_Y8_U8V8_444_UNORM: pipe_format = 144;
pub const PIPE_FORMAT_Y8_V8U8_444_UNORM: pipe_format = 145;
pub const PIPE_FORMAT_Y8_U8_V8_444_UNORM: pipe_format = 146;
pub const PIPE_FORMAT_Y8_U8_V8_440_UNORM: pipe_format = 147;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_420_UNORM: pipe_format = 148;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_420_UNORM: pipe_format = 149;
pub const PIPE_FORMAT_Y16_U16_V16_420_UNORM: pipe_format = 150;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_422_UNORM: pipe_format = 151;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_422_UNORM: pipe_format = 152;
pub const PIPE_FORMAT_Y16_U16_V16_422_UNORM: pipe_format = 153;
pub const PIPE_FORMAT_Y10X6_U10X6_V10X6_444_UNORM: pipe_format = 154;
pub const PIPE_FORMAT_Y12X4_U12X4_V12X4_444_UNORM: pipe_format = 155;
pub const PIPE_FORMAT_Y16_U16_V16_444_UNORM: pipe_format = 156;
pub const PIPE_FORMAT_Y16_U16V16_422_UNORM: pipe_format = 157;
pub const PIPE_FORMAT_X6Y10_X6U10X6V10_420_UNORM: pipe_format = 158;
pub const PIPE_FORMAT_X4Y12_X4U12X4V12_420_UNORM: pipe_format = 159;
pub const PIPE_FORMAT_Y16_U16V16_420_UNORM: pipe_format = 160;
pub const PIPE_FORMAT_Y10Y10Y10X2_U10V10U10X2V10U10V10X2_420_UNORM: pipe_format = 161;
pub const PIPE_FORMAT_X6Y10X6U10X6Y10X6V10_422_UNORM: pipe_format = 162;
pub const PIPE_FORMAT_X4Y12X4U12X4Y12X4V12_422_UNORM: pipe_format = 163;
pub const PIPE_FORMAT_Y16U16Y16V16_422_UNORM: pipe_format = 164;
pub const PIPE_FORMAT_U10Y10V10A2_444_UNORM: pipe_format = 165;
pub const PIPE_FORMAT_X4U12X4Y12X4V12X4A12_444_UNORM: pipe_format = 166;
pub const PIPE_FORMAT_U16Y16V16A16_444_UNORM: pipe_format = 167;
pub const PIPE_FORMAT_Y8U8V8_420_UNORM_PACKED: pipe_format = 168;
pub const PIPE_FORMAT_Y10U10V10_420_UNORM_PACKED: pipe_format = 169;
pub const PIPE_FORMAT_YUV_END: pipe_format = 169;
pub const PIPE_FORMAT_COMPR_START: pipe_format = 170;
pub const PIPE_FORMAT_DXT1_RGB: pipe_format = 170;
pub const PIPE_FORMAT_DXT1_RGBA: pipe_format = 171;
pub const PIPE_FORMAT_DXT3_RGBA: pipe_format = 172;
pub const PIPE_FORMAT_DXT5_RGBA: pipe_format = 173;
pub const PIPE_FORMAT_DXT1_SRGB: pipe_format = 174;
pub const PIPE_FORMAT_DXT1_SRGBA: pipe_format = 175;
pub const PIPE_FORMAT_DXT3_SRGBA: pipe_format = 176;
pub const PIPE_FORMAT_DXT5_SRGBA: pipe_format = 177;
pub const PIPE_FORMAT_RGTC1_UNORM: pipe_format = 178;
pub const PIPE_FORMAT_RGTC1_SNORM: pipe_format = 179;
pub const PIPE_FORMAT_RGTC2_UNORM: pipe_format = 180;
pub const PIPE_FORMAT_RGTC2_SNORM: pipe_format = 181;
pub const PIPE_FORMAT_LATC1_UNORM: pipe_format = 182;
pub const PIPE_FORMAT_LATC1_SNORM: pipe_format = 183;
pub const PIPE_FORMAT_LATC2_UNORM: pipe_format = 184;
pub const PIPE_FORMAT_LATC2_SNORM: pipe_format = 185;
pub const PIPE_FORMAT_ETC1_RGB8: pipe_format = 186;
pub const PIPE_FORMAT_ETC2_RGB8: pipe_format = 187;
pub const PIPE_FORMAT_ETC2_RGB8A1: pipe_format = 188;
pub const PIPE_FORMAT_ETC2_RGBA8: pipe_format = 189;
pub const PIPE_FORMAT_ETC2_R11_UNORM: pipe_format = 190;
pub const PIPE_FORMAT_ETC2_R11_SNORM: pipe_format = 191;
pub const PIPE_FORMAT_ETC2_RG11_UNORM: pipe_format = 192;
pub const PIPE_FORMAT_ETC2_RG11_SNORM: pipe_format = 193;
pub const PIPE_FORMAT_ETC2_SRGB8: pipe_format = 194;
pub const PIPE_FORMAT_ETC2_SRGB8A1: pipe_format = 195;
pub const PIPE_FORMAT_ETC2_SRGBA8: pipe_format = 196;
pub const PIPE_FORMAT_BPTC_RGBA_UNORM: pipe_format = 197;
pub const PIPE_FORMAT_BPTC_RGB_FLOAT: pipe_format = 198;
pub const PIPE_FORMAT_BPTC_RGB_UFLOAT: pipe_format = 199;
pub const PIPE_FORMAT_BPTC_SRGBA: pipe_format = 200;
pub const PIPE_FORMAT_ASTC_4x4: pipe_format = 201;
pub const PIPE_FORMAT_ASTC_5x4: pipe_format = 202;
pub const PIPE_FORMAT_ASTC_5x5: pipe_format = 203;
pub const PIPE_FORMAT_ASTC_6x5: pipe_format = 204;
pub const PIPE_FORMAT_ASTC_6x6: pipe_format = 205;
pub const PIPE_FORMAT_ASTC_8x5: pipe_format = 206;
pub const PIPE_FORMAT_ASTC_8x6: pipe_format = 207;
pub const PIPE_FORMAT_ASTC_8x8: pipe_format = 208;
pub const PIPE_FORMAT_ASTC_10x5: pipe_format = 209;
pub const PIPE_FORMAT_ASTC_10x6: pipe_format = 210;
pub const PIPE_FORMAT_ASTC_10x8: pipe_format = 211;
pub const PIPE_FORMAT_ASTC_10x10: pipe_format = 212;
pub const PIPE_FORMAT_ASTC_12x10: pipe_format = 213;
pub const PIPE_FORMAT_ASTC_12x12: pipe_format = 214;
pub const PIPE_FORMAT_ASTC_3x3x3: pipe_format = 215;
pub const PIPE_FORMAT_ASTC_4x3x3: pipe_format = 216;
pub const PIPE_FORMAT_ASTC_4x4x3: pipe_format = 217;
pub const PIPE_FORMAT_ASTC_4x4x4: pipe_format = 218;
pub const PIPE_FORMAT_ASTC_5x4x4: pipe_format = 219;
pub const PIPE_FORMAT_ASTC_5x5x4: pipe_format = 220;
pub const PIPE_FORMAT_ASTC_5x5x5: pipe_format = 221;
pub const PIPE_FORMAT_ASTC_6x5x5: pipe_format = 222;
pub const PIPE_FORMAT_ASTC_6x6x5: pipe_format = 223;
pub const PIPE_FORMAT_ASTC_6x6x6: pipe_format = 224;
pub const PIPE_FORMAT_ASTC_4x4_FLOAT: pipe_format = 225;
pub const PIPE_FORMAT_ASTC_5x4_FLOAT: pipe_format = 226;
pub const PIPE_FORMAT_ASTC_5x5_FLOAT: pipe_format = 227;
pub const PIPE_FORMAT_ASTC_6x5_FLOAT: pipe_format = 228;
pub const PIPE_FORMAT_ASTC_6x6_FLOAT: pipe_format = 229;
pub const PIPE_FORMAT_ASTC_8x5_FLOAT: pipe_format = 230;
pub const PIPE_FORMAT_ASTC_8x6_FLOAT: pipe_format = 231;
pub const PIPE_FORMAT_ASTC_8x8_FLOAT: pipe_format = 232;
pub const PIPE_FORMAT_ASTC_10x5_FLOAT: pipe_format = 233;
pub const PIPE_FORMAT_ASTC_10x6_FLOAT: pipe_format = 234;
pub const PIPE_FORMAT_ASTC_10x8_FLOAT: pipe_format = 235;
pub const PIPE_FORMAT_ASTC_10x10_FLOAT: pipe_format = 236;
pub const PIPE_FORMAT_ASTC_12x10_FLOAT: pipe_format = 237;
pub const PIPE_FORMAT_ASTC_12x12_FLOAT: pipe_format = 238;
pub const PIPE_FORMAT_ASTC_4x4_SRGB: pipe_format = 239;
pub const PIPE_FORMAT_ASTC_5x4_SRGB: pipe_format = 240;
pub const PIPE_FORMAT_ASTC_5x5_SRGB: pipe_format = 241;
pub const PIPE_FORMAT_ASTC_6x5_SRGB: pipe_format = 242;
pub const PIPE_FORMAT_ASTC_6x6_SRGB: pipe_format = 243;
pub const PIPE_FORMAT_ASTC_8x5_SRGB: pipe_format = 244;
pub const PIPE_FORMAT_ASTC_8x6_SRGB: pipe_format = 245;
pub const PIPE_FORMAT_ASTC_8x8_SRGB: pipe_format = 246;
pub const PIPE_FORMAT_ASTC_10x5_SRGB: pipe_format = 247;
pub const PIPE_FORMAT_ASTC_10x6_SRGB: pipe_format = 248;
pub const PIPE_FORMAT_ASTC_10x8_SRGB: pipe_format = 249;
pub const PIPE_FORMAT_ASTC_10x10_SRGB: pipe_format = 250;
pub const PIPE_FORMAT_ASTC_12x10_SRGB: pipe_format = 251;
pub const PIPE_FORMAT_ASTC_12x12_SRGB: pipe_format = 252;
pub const PIPE_FORMAT_ASTC_3x3x3_SRGB: pipe_format = 253;
pub const PIPE_FORMAT_ASTC_4x3x3_SRGB: pipe_format = 254;
pub const PIPE_FORMAT_ASTC_4x4x3_SRGB: pipe_format = 255;
pub const PIPE_FORMAT_ASTC_4x4x4_SRGB: pipe_format = 256;
pub const PIPE_FORMAT_ASTC_5x4x4_SRGB: pipe_format = 257;
pub const PIPE_FORMAT_ASTC_5x5x4_SRGB: pipe_format = 258;
pub const PIPE_FORMAT_ASTC_5x5x5_SRGB: pipe_format = 259;
pub const PIPE_FORMAT_ASTC_6x5x5_SRGB: pipe_format = 260;
pub const PIPE_FORMAT_ASTC_6x6x5_SRGB: pipe_format = 261;
pub const PIPE_FORMAT_ASTC_6x6x6_SRGB: pipe_format = 262;
pub const PIPE_FORMAT_ATC_RGB: pipe_format = 263;
pub const PIPE_FORMAT_ATC_RGBA_EXPLICIT: pipe_format = 264;
pub const PIPE_FORMAT_ATC_RGBA_INTERPOLATED: pipe_format = 265;
pub const PIPE_FORMAT_FXT1_RGB: pipe_format = 266;
pub const PIPE_FORMAT_FXT1_RGBA: pipe_format = 267;
pub const PIPE_FORMAT_COMPR_END: pipe_format = 267;
pub const PIPE_FORMAT_ZS_START: pipe_format = 268;
pub const PIPE_FORMAT_S8_UINT: pipe_format = 268;
pub const PIPE_FORMAT_Z16_UNORM: pipe_format = 269;
pub const PIPE_FORMAT_Z16_UNORM_S8_UINT: pipe_format = 270;
pub const PIPE_FORMAT_Z32_UNORM: pipe_format = 271;
pub const PIPE_FORMAT_Z32_FLOAT: pipe_format = 272;
pub const PIPE_FORMAT_Z24_UNORM_S8_UINT: pipe_format = 273;
pub const PIPE_FORMAT_S8_UINT_Z24_UNORM: pipe_format = 274;
pub const PIPE_FORMAT_X24S8_UINT: pipe_format = 275;
pub const PIPE_FORMAT_S8X24_UINT: pipe_format = 276;
pub const PIPE_FORMAT_Z24X8_UNORM: pipe_format = 277;
pub const PIPE_FORMAT_X8Z24_UNORM: pipe_format = 278;
pub const PIPE_FORMAT_Z24_UNORM_PACKED: pipe_format = 279;
pub const PIPE_FORMAT_Z32_FLOAT_S8X24_UINT: pipe_format = 280;
pub const PIPE_FORMAT_X32_S8X24_UINT: pipe_format = 281;
pub const PIPE_FORMAT_ZS_END: pipe_format = 281;
pub const PIPE_FORMAT_B8G8R8X8_UNORM: pipe_format = 282;
pub const PIPE_FORMAT_B8G8R8X8_SNORM: pipe_format = 283;
pub const PIPE_FORMAT_B8G8R8X8_UINT: pipe_format = 284;
pub const PIPE_FORMAT_B8G8R8X8_SINT: pipe_format = 285;
pub const PIPE_FORMAT_A8R8G8B8_SNORM: pipe_format = 286;
pub const PIPE_FORMAT_A8R8G8B8_SINT: pipe_format = 287;
pub const PIPE_FORMAT_X8R8G8B8_UNORM: pipe_format = 288;
pub const PIPE_FORMAT_X8R8G8B8_SNORM: pipe_format = 289;
pub const PIPE_FORMAT_X8R8G8B8_SINT: pipe_format = 290;
pub const PIPE_FORMAT_A8B8G8R8_UNORM: pipe_format = 291;
pub const PIPE_FORMAT_X8B8G8R8_UNORM: pipe_format = 292;
pub const PIPE_FORMAT_R8G8B8X8_UNORM: pipe_format = 293;
pub const PIPE_FORMAT_R5G5B5A1_UNORM: pipe_format = 294;
pub const PIPE_FORMAT_R5G5B5X1_UNORM: pipe_format = 295;
pub const PIPE_FORMAT_B5G5R5X1_UNORM: pipe_format = 296;
pub const PIPE_FORMAT_B5G5R5A1_UNORM: pipe_format = 297;
pub const PIPE_FORMAT_X1B5G5R5_UNORM: pipe_format = 298;
pub const PIPE_FORMAT_A1R5G5B5_UNORM: pipe_format = 299;
pub const PIPE_FORMAT_X1R5G5B5_UNORM: pipe_format = 300;
pub const PIPE_FORMAT_A1B5G5R5_UNORM: pipe_format = 301;
pub const PIPE_FORMAT_R4G4B4A4_UNORM: pipe_format = 302;
pub const PIPE_FORMAT_R4G4B4X4_UNORM: pipe_format = 303;
pub const PIPE_FORMAT_B4G4R4A4_UNORM: pipe_format = 304;
pub const PIPE_FORMAT_B4G4R4X4_UNORM: pipe_format = 305;
pub const PIPE_FORMAT_A4R4G4B4_UNORM: pipe_format = 306;
pub const PIPE_FORMAT_A4B4G4R4_UNORM: pipe_format = 307;
pub const PIPE_FORMAT_R5G6B5_UNORM: pipe_format = 308;
pub const PIPE_FORMAT_B5G6R5_UNORM: pipe_format = 309;
pub const PIPE_FORMAT_R10G10B10X2_UNORM: pipe_format = 310;
pub const PIPE_FORMAT_A2R10G10B10_UNORM: pipe_format = 311;
pub const PIPE_FORMAT_A2B10G10R10_UNORM: pipe_format = 312;
pub const PIPE_FORMAT_R3G3B2_UNORM: pipe_format = 313;
pub const PIPE_FORMAT_B2G3R3_UNORM: pipe_format = 314;
pub const PIPE_FORMAT_L8_UNORM: pipe_format = 315;
pub const PIPE_FORMAT_A8_UNORM: pipe_format = 316;
pub const PIPE_FORMAT_I8_UNORM: pipe_format = 317;
pub const PIPE_FORMAT_L4A4_UNORM: pipe_format = 318;
pub const PIPE_FORMAT_L8A8_UNORM: pipe_format = 319;
pub const PIPE_FORMAT_L16_UNORM: pipe_format = 320;
pub const PIPE_FORMAT_A16_UNORM: pipe_format = 321;
pub const PIPE_FORMAT_I16_UNORM: pipe_format = 322;
pub const PIPE_FORMAT_L16A16_UNORM: pipe_format = 323;
pub const PIPE_FORMAT_A8_SNORM: pipe_format = 324;
pub const PIPE_FORMAT_L8_SNORM: pipe_format = 325;
pub const PIPE_FORMAT_L8A8_SNORM: pipe_format = 326;
pub const PIPE_FORMAT_I8_SNORM: pipe_format = 327;
pub const PIPE_FORMAT_A16_SNORM: pipe_format = 328;
pub const PIPE_FORMAT_L16_SNORM: pipe_format = 329;
pub const PIPE_FORMAT_L16A16_SNORM: pipe_format = 330;
pub const PIPE_FORMAT_I16_SNORM: pipe_format = 331;
pub const PIPE_FORMAT_A16_FLOAT: pipe_format = 332;
pub const PIPE_FORMAT_L16_FLOAT: pipe_format = 333;
pub const PIPE_FORMAT_L16A16_FLOAT: pipe_format = 334;
pub const PIPE_FORMAT_I16_FLOAT: pipe_format = 335;
pub const PIPE_FORMAT_A32_FLOAT: pipe_format = 336;
pub const PIPE_FORMAT_L32_FLOAT: pipe_format = 337;
pub const PIPE_FORMAT_L32A32_FLOAT: pipe_format = 338;
pub const PIPE_FORMAT_I32_FLOAT: pipe_format = 339;
pub const PIPE_FORMAT_L8_SRGB: pipe_format = 340;
pub const PIPE_FORMAT_R8_SRGB: pipe_format = 341;
pub const PIPE_FORMAT_L8A8_SRGB: pipe_format = 342;
pub const PIPE_FORMAT_R8G8_SRGB: pipe_format = 343;
pub const PIPE_FORMAT_R8G8B8_SRGB: pipe_format = 344;
pub const PIPE_FORMAT_B8G8R8_SRGB: pipe_format = 345;
pub const PIPE_FORMAT_R8G8B8A8_SRGB: pipe_format = 346;
pub const PIPE_FORMAT_A8B8G8R8_SRGB: pipe_format = 347;
pub const PIPE_FORMAT_X8B8G8R8_SRGB: pipe_format = 348;
pub const PIPE_FORMAT_B8G8R8A8_SRGB: pipe_format = 349;
pub const PIPE_FORMAT_B8G8R8X8_SRGB: pipe_format = 350;
pub const PIPE_FORMAT_A8R8G8B8_SRGB: pipe_format = 351;
pub const PIPE_FORMAT_X8R8G8B8_SRGB: pipe_format = 352;
pub const PIPE_FORMAT_R8SG8SB8UX8U_NORM: pipe_format = 353;
pub const PIPE_FORMAT_R10SG10SB10SA2U_NORM: pipe_format = 354;
pub const PIPE_FORMAT_R5SG5SB6U_NORM: pipe_format = 355;
pub const PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8: pipe_format = 356;
pub const PIPE_FORMAT_R8G8_B8G8_422_UNORM: pipe_format = 357;
pub const PIPE_FORMAT_G8R8_G8B8_422_UNORM: pipe_format = 358;
pub const PIPE_FORMAT_G8R8_B8R8_422_UNORM: pipe_format = 359;
pub const PIPE_FORMAT_R8G8_R8B8_422_UNORM: pipe_format = 360;
pub const PIPE_FORMAT_B8R8_G8R8_422_UNORM: pipe_format = 361;
pub const PIPE_FORMAT_R8B8_R8G8_422_UNORM: pipe_format = 362;
pub const PIPE_FORMAT_G8B8_G8R8_422_UNORM: pipe_format = 363;
pub const PIPE_FORMAT_B8G8_R8G8_422_UNORM: pipe_format = 364;
pub const PIPE_FORMAT_R16G16_R16B16_422_UNORM: pipe_format = 365;
pub const PIPE_FORMAT_X6R10X6G10_X6R10X6B10_422_UNORM: pipe_format = 366;
pub const PIPE_FORMAT_R9G9B9E5_FLOAT: pipe_format = 367;
pub const PIPE_FORMAT_R1_UNORM: pipe_format = 368;
pub const PIPE_FORMAT_R8G8Bx_SNORM: pipe_format = 369;
pub const PIPE_FORMAT_R10G10B10X2_USCALED: pipe_format = 370;
pub const PIPE_FORMAT_R10G10B10X2_SNORM: pipe_format = 371;
pub const PIPE_FORMAT_R10G10B10X2_SINT: pipe_format = 372;
pub const PIPE_FORMAT_R8_G8B8_420_UNORM: pipe_format = 373;
pub const PIPE_FORMAT_R8_B8G8_420_UNORM: pipe_format = 374;
pub const PIPE_FORMAT_G8_B8R8_420_UNORM: pipe_format = 375;
pub const PIPE_FORMAT_R8_G8B8_422_UNORM: pipe_format = 376;
pub const PIPE_FORMAT_R8_B8G8_422_UNORM: pipe_format = 377;
pub const PIPE_FORMAT_G8_B8R8_422_UNORM: pipe_format = 378;
pub const PIPE_FORMAT_R10_G10B10_420_UNORM: pipe_format = 379;
pub const PIPE_FORMAT_R10_G10B10_422_UNORM: pipe_format = 380;
pub const PIPE_FORMAT_R8_G8_B8_420_UNORM: pipe_format = 381;
pub const PIPE_FORMAT_R8_B8_G8_420_UNORM: pipe_format = 382;
pub const PIPE_FORMAT_G8_B8_R8_420_UNORM: pipe_format = 383;
pub const PIPE_FORMAT_R8_G8_B8_444_UNORM: pipe_format = 384;
pub const PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM: pipe_format = 385;
pub const PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM: pipe_format = 386;
pub const PIPE_FORMAT_G8_B8R8_444_UNORM: pipe_format = 387;
pub const PIPE_FORMAT_X6G10_X6B10X6R10_444_UNORM: pipe_format = 388;
pub const PIPE_FORMAT_X4G12_X4B12X4R12_444_UNORM: pipe_format = 389;
pub const PIPE_FORMAT_R8G8B8_420_UNORM_PACKED: pipe_format = 390;
pub const PIPE_FORMAT_R10G10B10_420_UNORM_PACKED: pipe_format = 391;
pub const PIPE_FORMAT_X6R10_UNORM: pipe_format = 392;
pub const PIPE_FORMAT_X6R10X6G10_UNORM: pipe_format = 393;
pub const PIPE_FORMAT_X4R12_UNORM: pipe_format = 394;
pub const PIPE_FORMAT_X4R12X4G12_UNORM: pipe_format = 395;
pub const PIPE_FORMAT_A4R4_UNORM: pipe_format = 396;
pub const PIPE_FORMAT_R4A4_UNORM: pipe_format = 397;
pub const PIPE_FORMAT_R8A8_UNORM: pipe_format = 398;
pub const PIPE_FORMAT_A8R8_UNORM: pipe_format = 399;
pub const PIPE_FORMAT_A8_UINT: pipe_format = 400;
pub const PIPE_FORMAT_I8_UINT: pipe_format = 401;
pub const PIPE_FORMAT_L8_UINT: pipe_format = 402;
pub const PIPE_FORMAT_L8A8_UINT: pipe_format = 403;
pub const PIPE_FORMAT_A8_SINT: pipe_format = 404;
pub const PIPE_FORMAT_I8_SINT: pipe_format = 405;
pub const PIPE_FORMAT_L8_SINT: pipe_format = 406;
pub const PIPE_FORMAT_L8A8_SINT: pipe_format = 407;
pub const PIPE_FORMAT_A16_UINT: pipe_format = 408;
pub const PIPE_FORMAT_I16_UINT: pipe_format = 409;
pub const PIPE_FORMAT_L16_UINT: pipe_format = 410;
pub const PIPE_FORMAT_L16A16_UINT: pipe_format = 411;
pub const PIPE_FORMAT_A16_SINT: pipe_format = 412;
pub const PIPE_FORMAT_I16_SINT: pipe_format = 413;
pub const PIPE_FORMAT_L16_SINT: pipe_format = 414;
pub const PIPE_FORMAT_L16A16_SINT: pipe_format = 415;
pub const PIPE_FORMAT_A32_UINT: pipe_format = 416;
pub const PIPE_FORMAT_I32_UINT: pipe_format = 417;
pub const PIPE_FORMAT_L32_UINT: pipe_format = 418;
pub const PIPE_FORMAT_L32A32_UINT: pipe_format = 419;
pub const PIPE_FORMAT_A32_SINT: pipe_format = 420;
pub const PIPE_FORMAT_I32_SINT: pipe_format = 421;
pub const PIPE_FORMAT_L32_SINT: pipe_format = 422;
pub const PIPE_FORMAT_L32A32_SINT: pipe_format = 423;
pub const PIPE_FORMAT_A8R8G8B8_UINT: pipe_format = 424;
pub const PIPE_FORMAT_A8B8G8R8_UINT: pipe_format = 425;
pub const PIPE_FORMAT_A2R10G10B10_UINT: pipe_format = 426;
pub const PIPE_FORMAT_A2B10G10R10_UINT: pipe_format = 427;
pub const PIPE_FORMAT_R5G6B5_UINT: pipe_format = 428;
pub const PIPE_FORMAT_B5G6R5_UINT: pipe_format = 429;
pub const PIPE_FORMAT_R3G3B2_UINT: pipe_format = 430;
pub const PIPE_FORMAT_B2G3R3_UINT: pipe_format = 431;
pub const PIPE_FORMAT_R4G4B4A4_UINT: pipe_format = 432;
pub const PIPE_FORMAT_B4G4R4A4_UINT: pipe_format = 433;
pub const PIPE_FORMAT_A4R4G4B4_UINT: pipe_format = 434;
pub const PIPE_FORMAT_A4B4G4R4_UINT: pipe_format = 435;
pub const PIPE_FORMAT_A1R5G5B5_UINT: pipe_format = 436;
pub const PIPE_FORMAT_A1B5G5R5_UINT: pipe_format = 437;
pub const PIPE_FORMAT_R5G5B5A1_UINT: pipe_format = 438;
pub const PIPE_FORMAT_B5G5R5A1_UINT: pipe_format = 439;
pub const PIPE_FORMAT_R8G8B8X8_SNORM: pipe_format = 440;
pub const PIPE_FORMAT_R8G8B8X8_SRGB: pipe_format = 441;
pub const PIPE_FORMAT_R8G8B8X8_UINT: pipe_format = 442;
pub const PIPE_FORMAT_R8G8B8X8_SINT: pipe_format = 443;
pub const PIPE_FORMAT_B10G10R10X2_UNORM: pipe_format = 444;
pub const PIPE_FORMAT_B10G10R10X2_SNORM: pipe_format = 445;
pub const PIPE_FORMAT_B10G10R10X2_SINT: pipe_format = 446;
pub const PIPE_FORMAT_R16G16B16X16_UNORM: pipe_format = 447;
pub const PIPE_FORMAT_R16G16B16X16_SNORM: pipe_format = 448;
pub const PIPE_FORMAT_R16G16B16X16_FLOAT: pipe_format = 449;
pub const PIPE_FORMAT_R16G16B16X16_UINT: pipe_format = 450;
pub const PIPE_FORMAT_R16G16B16X16_SINT: pipe_format = 451;
pub const PIPE_FORMAT_R32G32B32X32_FLOAT: pipe_format = 452;
pub const PIPE_FORMAT_R32G32B32X32_UINT: pipe_format = 453;
pub const PIPE_FORMAT_R32G32B32X32_SINT: pipe_format = 454;
pub const PIPE_FORMAT_R8A8_SNORM: pipe_format = 455;
pub const PIPE_FORMAT_R16A16_UNORM: pipe_format = 456;
pub const PIPE_FORMAT_R16A16_SNORM: pipe_format = 457;
pub const PIPE_FORMAT_R16A16_FLOAT: pipe_format = 458;
pub const PIPE_FORMAT_R32A32_FLOAT: pipe_format = 459;
pub const PIPE_FORMAT_R8A8_UINT: pipe_format = 460;
pub const PIPE_FORMAT_R8A8_SINT: pipe_format = 461;
pub const PIPE_FORMAT_R16A16_UINT: pipe_format = 462;
pub const PIPE_FORMAT_R16A16_SINT: pipe_format = 463;
pub const PIPE_FORMAT_R32A32_UINT: pipe_format = 464;
pub const PIPE_FORMAT_R32A32_SINT: pipe_format = 465;
pub const PIPE_FORMAT_B5G6R5_SRGB: pipe_format = 466;
pub const PIPE_FORMAT_R5G6B5_SRGB: pipe_format = 467;
pub const PIPE_FORMAT_G8R8_UNORM: pipe_format = 468;
pub const PIPE_FORMAT_G8R8_SNORM: pipe_format = 469;
pub const PIPE_FORMAT_G8R8_SINT: pipe_format = 470;
pub const PIPE_FORMAT_G16R16_UNORM: pipe_format = 471;
pub const PIPE_FORMAT_G16R16_SNORM: pipe_format = 472;
pub const PIPE_FORMAT_G16R16_SINT: pipe_format = 473;
pub const PIPE_FORMAT_A8B8G8R8_SNORM: pipe_format = 474;
pub const PIPE_FORMAT_A8B8G8R8_SINT: pipe_format = 475;
pub const PIPE_FORMAT_X8B8G8R8_SNORM: pipe_format = 476;
pub const PIPE_FORMAT_X8B8G8R8_SINT: pipe_format = 477;
pub const PIPE_FORMAT_COUNT: pipe_format = 478;
#[doc = " Formats for textures, surfaces and vertex data"]
pub type pipe_format = ::std::os::raw::c_uint;
pub const PIPE_SWIZZLE_X: pipe_swizzle = 0;
pub const PIPE_SWIZZLE_Y: pipe_swizzle = 1;
pub const PIPE_SWIZZLE_Z: pipe_swizzle = 2;
pub const PIPE_SWIZZLE_W: pipe_swizzle = 3;
pub const PIPE_SWIZZLE_0: pipe_swizzle = 4;
pub const PIPE_SWIZZLE_1: pipe_swizzle = 5;
pub const PIPE_SWIZZLE_NONE: pipe_swizzle = 6;
#[doc = "< Number of enums counter (must be last)"]
pub const PIPE_SWIZZLE_MAX: pipe_swizzle = 7;
#[doc = " Texture & format swizzles"]
pub type pipe_swizzle = ::std::os::raw::c_uint;
#[doc = " Formats with util_format_block::width == util_format_block::height == 1\n that can be described as an ordinary data structure."]
pub const UTIL_FORMAT_LAYOUT_PLAIN: util_format_layout = 0;
#[doc = " Formats with sub-sampled channels.\n\n This is for formats like YVYU where there is less than one sample per\n pixel."]
pub const UTIL_FORMAT_LAYOUT_SUBSAMPLED: util_format_layout = 1;
#[doc = " S3 Texture Compression formats."]
pub const UTIL_FORMAT_LAYOUT_S3TC: util_format_layout = 2;
#[doc = " Red-Green Texture Compression formats."]
pub const UTIL_FORMAT_LAYOUT_RGTC: util_format_layout = 3;
#[doc = " Ericsson Texture Compression"]
pub const UTIL_FORMAT_LAYOUT_ETC: util_format_layout = 4;
#[doc = " BC6/7 Texture Compression"]
pub const UTIL_FORMAT_LAYOUT_BPTC: util_format_layout = 5;
#[doc = " BC6/7 Texture Compression"]
pub const UTIL_FORMAT_LAYOUT_ASTC: util_format_layout = 6;
#[doc = " BC6/7 Texture Compression"]
pub const UTIL_FORMAT_LAYOUT_ATC: util_format_layout = 7;
#[doc = " Formats with 2 or more planes."]
pub const UTIL_FORMAT_LAYOUT_PLANAR2: util_format_layout = 8;
#[doc = " Formats with 2 or more planes."]
pub const UTIL_FORMAT_LAYOUT_PLANAR3: util_format_layout = 9;
#[doc = " Formats with 2 or more planes."]
pub const UTIL_FORMAT_LAYOUT_FXT1: util_format_layout = 10;
#[doc = " Everything else that doesn't fit in any of the above layouts."]
pub const UTIL_FORMAT_LAYOUT_OTHER: util_format_layout = 11;
#[doc = " Describe how to pack/unpack pixels into/from the prescribed format.\n\n XXX: This could be renamed to something like util_format_pack, or broke down\n in flags inside util_format_block that said exactly what we want."]
pub type util_format_layout = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct util_format_block {
    #[doc = " Block width in pixels"]
    pub width: ::std::os::raw::c_uint,
    #[doc = " Block height in pixels"]
    pub height: ::std::os::raw::c_uint,
    #[doc = " Block depth in pixels"]
    pub depth: ::std::os::raw::c_uint,
    #[doc = " Block size in bits"]
    pub bits: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_block"][::std::mem::size_of::<util_format_block>() - 16usize];
    ["Alignment of util_format_block"][::std::mem::align_of::<util_format_block>() - 4usize];
    ["Offset of field: util_format_block::width"]
        [::std::mem::offset_of!(util_format_block, width) - 0usize];
    ["Offset of field: util_format_block::height"]
        [::std::mem::offset_of!(util_format_block, height) - 4usize];
    ["Offset of field: util_format_block::depth"]
        [::std::mem::offset_of!(util_format_block, depth) - 8usize];
    ["Offset of field: util_format_block::bits"]
        [::std::mem::offset_of!(util_format_block, bits) - 12usize];
};
pub const UTIL_FORMAT_COLORSPACE_RGB: util_format_colorspace = 0;
pub const UTIL_FORMAT_COLORSPACE_SRGB: util_format_colorspace = 1;
pub const UTIL_FORMAT_COLORSPACE_YUV: util_format_colorspace = 2;
pub const UTIL_FORMAT_COLORSPACE_ZS: util_format_colorspace = 3;
pub type util_format_colorspace = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct util_format_channel_description {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_channel_description"]
        [::std::mem::size_of::<util_format_channel_description>() - 4usize];
    ["Alignment of util_format_channel_description"]
        [::std::mem::align_of::<util_format_channel_description>() - 4usize];
};
impl util_format_channel_description {
    #[inline]
    pub fn type_(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type__raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn normalized(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn normalized_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_normalized_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pure_integer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pure_integer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pure_integer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pure_integer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn size(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn size_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_size_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shift(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_shift(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shift_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                16u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_shift_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                16u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: ::std::os::raw::c_uint,
        normalized: ::std::os::raw::c_uint,
        pure_integer: ::std::os::raw::c_uint,
        size: ::std::os::raw::c_uint,
        shift: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let normalized: u32 = unsafe { ::std::mem::transmute(normalized) };
            normalized as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pure_integer: u32 = unsafe { ::std::mem::transmute(pure_integer) };
            pure_integer as u64
        });
        __bindgen_bitfield_unit.set(7usize, 9u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let shift: u32 = unsafe { ::std::mem::transmute(shift) };
            shift as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct util_format_description {
    pub format: pipe_format,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Short name, striped of the prefix, lower case."]
    pub short_name: *const ::std::os::raw::c_char,
    #[doc = " Pixel block dimensions."]
    pub block: util_format_block,
    pub layout: util_format_layout,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Input channel description, in the order XYZW.\n\n Only valid for UTIL_FORMAT_LAYOUT_PLAIN formats.\n\n If each channel is accessed as an individual N-byte value, X is always\n at the lowest address in memory, Y is always next, and so on.  For all\n currently-defined formats, the N-byte value has native endianness.\n\n If instead a group of channels is accessed as a single N-byte value,\n the order of the channels within that value depends on endianness.\n For big-endian targets, X is the most significant subvalue,\n otherwise it is the least significant one.\n\n For example, if X is 8 bits and Y is 24 bits, the memory order is:\n\n                 0  1  2  3\n  little-endian: X  Yl Ym Yu    (l = lower, m = middle, u = upper)\n  big-endian:    X  Yu Ym Yl\n\n If X is 5 bits, Y is 5 bits, Z is 5 bits and W is 1 bit, the layout is:\n\n                        0        1\n                 msb  lsb msb  lsb\n  little-endian: YYYXXXXX WZZZZZYY\n  big-endian:    XXXXXYYY YYZZZZZW"]
    pub channel: [util_format_channel_description; 4usize],
    #[doc = " Output channel swizzle.\n\n The order is either:\n - RGBA\n - YUV(A)\n - ZS\n depending on the colorspace."]
    pub swizzle: [::std::os::raw::c_uchar; 4usize],
    #[doc = " Colorspace transformation."]
    pub colorspace: util_format_colorspace,
    pub __bindgen_anon_1: util_format_description__bindgen_ty_1,
}
#[doc = " For sRGB formats, equivalent linear format; for linear formats,\n equivalent sRGB format"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union util_format_description__bindgen_ty_1 {
    pub srgb_equivalent: pipe_format,
    pub linear_equivalent: pipe_format,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_description__bindgen_ty_1"]
        [::std::mem::size_of::<util_format_description__bindgen_ty_1>() - 4usize];
    ["Alignment of util_format_description__bindgen_ty_1"]
        [::std::mem::align_of::<util_format_description__bindgen_ty_1>() - 4usize];
    ["Offset of field: util_format_description__bindgen_ty_1::srgb_equivalent"]
        [::std::mem::offset_of!(util_format_description__bindgen_ty_1, srgb_equivalent) - 0usize];
    ["Offset of field: util_format_description__bindgen_ty_1::linear_equivalent"]
        [::std::mem::offset_of!(util_format_description__bindgen_ty_1, linear_equivalent) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_description"][::std::mem::size_of::<util_format_description>() - 64usize];
    ["Alignment of util_format_description"]
        [::std::mem::align_of::<util_format_description>() - 4usize];
    ["Offset of field: util_format_description::format"]
        [::std::mem::offset_of!(util_format_description, format) - 0usize];
    ["Offset of field: util_format_description::name"]
        [::std::mem::offset_of!(util_format_description, name) - 4usize];
    ["Offset of field: util_format_description::short_name"]
        [::std::mem::offset_of!(util_format_description, short_name) - 8usize];
    ["Offset of field: util_format_description::block"]
        [::std::mem::offset_of!(util_format_description, block) - 12usize];
    ["Offset of field: util_format_description::layout"]
        [::std::mem::offset_of!(util_format_description, layout) - 28usize];
    ["Offset of field: util_format_description::channel"]
        [::std::mem::offset_of!(util_format_description, channel) - 36usize];
    ["Offset of field: util_format_description::swizzle"]
        [::std::mem::offset_of!(util_format_description, swizzle) - 52usize];
    ["Offset of field: util_format_description::colorspace"]
        [::std::mem::offset_of!(util_format_description, colorspace) - 56usize];
};
impl util_format_description {
    #[inline]
    pub fn nr_channels(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_nr_channels(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn nr_channels_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_nr_channels_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_bitmask(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bitmask(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_bitmask_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_bitmask_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_mixed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_mixed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_mixed_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_mixed_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_unorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_unorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_unorm_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_unorm_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_snorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_snorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_snorm_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_snorm_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nr_channels: ::std::os::raw::c_uint,
        is_array: ::std::os::raw::c_uint,
        is_bitmask: ::std::os::raw::c_uint,
        is_mixed: ::std::os::raw::c_uint,
        is_unorm: ::std::os::raw::c_uint,
        is_snorm: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let nr_channels: u32 = unsafe { ::std::mem::transmute(nr_channels) };
            nr_channels as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_array: u32 = unsafe { ::std::mem::transmute(is_array) };
            is_array as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bitmask: u32 = unsafe { ::std::mem::transmute(is_bitmask) };
            is_bitmask as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_mixed: u32 = unsafe { ::std::mem::transmute(is_mixed) };
            is_mixed as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let is_unorm: u32 = unsafe { ::std::mem::transmute(is_unorm) };
            is_unorm as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let is_snorm: u32 = unsafe { ::std::mem::transmute(is_snorm) };
            is_snorm as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn util_format_description(format: pipe_format) -> *const util_format_description;
}
unsafe extern "C" {
    pub fn util_format_is_pure_integer(format: pipe_format) -> bool;
}
pub const NIL_FORMAT_SUPPORTS_TEXTURE_BIT: nil_format_support_flags = 1;
pub const NIL_FORMAT_SUPPORTS_BUFFER_BIT: nil_format_support_flags = 2;
pub const NIL_FORMAT_SUPPORTS_STORAGE_BIT: nil_format_support_flags = 4;
pub const NIL_FORMAT_SUPPORTS_RENDER_BIT: nil_format_support_flags = 8;
pub const NIL_FORMAT_SUPPORTS_ALPHA_BLEND_BIT: nil_format_support_flags = 16;
pub const NIL_FORMAT_SUPPORTS_DEPTH_STENCIL_BIT: nil_format_support_flags = 32;
pub const NIL_FORMAT_SUPPORTS_SCANOUT_BIT: nil_format_support_flags = 64;
pub type nil_format_support_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct nil_tic_format {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nil_tic_format"][::std::mem::size_of::<nil_tic_format>() - 4usize];
    ["Alignment of nil_tic_format"][::std::mem::align_of::<nil_tic_format>() - 4usize];
};
impl nil_tic_format {
    #[inline]
    pub fn comp_sizes(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_comp_sizes(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn comp_sizes_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_comp_sizes_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn type_r(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_type_r(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type_r_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_r_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn type_g(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_type_g(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type_g_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_g_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn type_b(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_type_b(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type_b_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_b_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn type_a(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_type_a(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type_a_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_a_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src_x(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src_x(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src_x_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src_x_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src_y(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src_y(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src_y_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src_y_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src_z(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src_z(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src_z_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src_z_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn src_w(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_src_w(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn src_w_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                29usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_src_w_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                29usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        comp_sizes: ::std::os::raw::c_uint,
        type_r: ::std::os::raw::c_uint,
        type_g: ::std::os::raw::c_uint,
        type_b: ::std::os::raw::c_uint,
        type_a: ::std::os::raw::c_uint,
        src_x: ::std::os::raw::c_uint,
        src_y: ::std::os::raw::c_uint,
        src_z: ::std::os::raw::c_uint,
        src_w: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let comp_sizes: u32 = unsafe { ::std::mem::transmute(comp_sizes) };
            comp_sizes as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let type_r: u32 = unsafe { ::std::mem::transmute(type_r) };
            type_r as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let type_g: u32 = unsafe { ::std::mem::transmute(type_g) };
            type_g as u64
        });
        __bindgen_bitfield_unit.set(14usize, 3u8, {
            let type_b: u32 = unsafe { ::std::mem::transmute(type_b) };
            type_b as u64
        });
        __bindgen_bitfield_unit.set(17usize, 3u8, {
            let type_a: u32 = unsafe { ::std::mem::transmute(type_a) };
            type_a as u64
        });
        __bindgen_bitfield_unit.set(20usize, 3u8, {
            let src_x: u32 = unsafe { ::std::mem::transmute(src_x) };
            src_x as u64
        });
        __bindgen_bitfield_unit.set(23usize, 3u8, {
            let src_y: u32 = unsafe { ::std::mem::transmute(src_y) };
            src_y as u64
        });
        __bindgen_bitfield_unit.set(26usize, 3u8, {
            let src_z: u32 = unsafe { ::std::mem::transmute(src_z) };
            src_z as u64
        });
        __bindgen_bitfield_unit.set(29usize, 3u8, {
            let src_w: u32 = unsafe { ::std::mem::transmute(src_w) };
            src_w as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nil_format_info {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub tic: nil_tic_format,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nil_format_info"][::std::mem::size_of::<nil_format_info>() - 8usize];
    ["Alignment of nil_format_info"][::std::mem::align_of::<nil_format_info>() - 4usize];
    ["Offset of field: nil_format_info::tic"]
        [::std::mem::offset_of!(nil_format_info, tic) - 4usize];
};
impl nil_format_info {
    #[inline]
    pub fn czt(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_czt(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn czt_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_czt_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn support(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_support(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn support_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                20u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_support_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                20u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn tic_v2_data_type(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_tic_v2_data_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn tic_v2_data_type_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                4u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_tic_v2_data_type_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        czt: ::std::os::raw::c_uint,
        support: ::std::os::raw::c_uint,
        tic_v2_data_type: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let czt: u32 = unsafe { ::std::mem::transmute(czt) };
            czt as u64
        });
        __bindgen_bitfield_unit.set(8usize, 20u8, {
            let support: u32 = unsafe { ::std::mem::transmute(support) };
            support as u64
        });
        __bindgen_bitfield_unit.set(28usize, 4u8, {
            let tic_v2_data_type: u32 = unsafe { ::std::mem::transmute(tic_v2_data_type) };
            tic_v2_data_type as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub static nil_format_table: [nil_format_info; 478usize];
}
pub const NV_DEVICE_TYPE_IGP: nv_device_type = 0;
pub const NV_DEVICE_TYPE_DIS: nv_device_type = 1;
pub const NV_DEVICE_TYPE_SOC: nv_device_type = 2;
pub type nv_device_type = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nv_device_info {
    pub type_: nv_device_type,
    pub device_id: u16,
    pub chipset: u16,
    pub device_name: [::std::os::raw::c_char; 64usize],
    pub chipset_name: [::std::os::raw::c_char; 16usize],
    pub pci: nv_device_info__bindgen_ty_1,
    #[doc = "< Shader model"]
    pub sm: u8,
    pub gpc_count: u8,
    pub tpc_count: u16,
    pub mp_per_tpc: u8,
    pub max_warps_per_mp: u8,
    pub has_transfer_queue: bool,
    #[doc = " Non-coherent memory map atom size"]
    pub nc_atom_size_B: u16,
    pub cls_copy: u16,
    pub cls_eng2d: u16,
    pub cls_eng3d: u16,
    pub cls_m2mf: u16,
    pub cls_compute: u16,
    pub cls_gpfifo: u16,
    pub vram_size_B: u64,
    pub bar_size_B: u64,
    pub max_smem_per_wg_kB: u16,
    pub sm_smem_sizes_kB: [u16; 10usize],
    pub sm_smem_size_count: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nv_device_info__bindgen_ty_1 {
    pub domain: u16,
    pub bus: u8,
    pub dev: u8,
    pub func: u8,
    pub revision_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nv_device_info__bindgen_ty_1"]
        [::std::mem::size_of::<nv_device_info__bindgen_ty_1>() - 6usize];
    ["Alignment of nv_device_info__bindgen_ty_1"]
        [::std::mem::align_of::<nv_device_info__bindgen_ty_1>() - 2usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::domain"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, domain) - 0usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::bus"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, bus) - 2usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::dev"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, dev) - 3usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::func"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, func) - 4usize];
    ["Offset of field: nv_device_info__bindgen_ty_1::revision_id"]
        [::std::mem::offset_of!(nv_device_info__bindgen_ty_1, revision_id) - 5usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nv_device_info"][::std::mem::size_of::<nv_device_info>() - 156usize];
    ["Alignment of nv_device_info"][::std::mem::align_of::<nv_device_info>() - 4usize];
    ["Offset of field: nv_device_info::type_"]
        [::std::mem::offset_of!(nv_device_info, type_) - 0usize];
    ["Offset of field: nv_device_info::device_id"]
        [::std::mem::offset_of!(nv_device_info, device_id) - 2usize];
    ["Offset of field: nv_device_info::chipset"]
        [::std::mem::offset_of!(nv_device_info, chipset) - 4usize];
    ["Offset of field: nv_device_info::device_name"]
        [::std::mem::offset_of!(nv_device_info, device_name) - 6usize];
    ["Offset of field: nv_device_info::chipset_name"]
        [::std::mem::offset_of!(nv_device_info, chipset_name) - 70usize];
    ["Offset of field: nv_device_info::pci"][::std::mem::offset_of!(nv_device_info, pci) - 86usize];
    ["Offset of field: nv_device_info::sm"][::std::mem::offset_of!(nv_device_info, sm) - 92usize];
    ["Offset of field: nv_device_info::gpc_count"]
        [::std::mem::offset_of!(nv_device_info, gpc_count) - 93usize];
    ["Offset of field: nv_device_info::tpc_count"]
        [::std::mem::offset_of!(nv_device_info, tpc_count) - 94usize];
    ["Offset of field: nv_device_info::mp_per_tpc"]
        [::std::mem::offset_of!(nv_device_info, mp_per_tpc) - 96usize];
    ["Offset of field: nv_device_info::max_warps_per_mp"]
        [::std::mem::offset_of!(nv_device_info, max_warps_per_mp) - 97usize];
    ["Offset of field: nv_device_info::has_transfer_queue"]
        [::std::mem::offset_of!(nv_device_info, has_transfer_queue) - 98usize];
    ["Offset of field: nv_device_info::nc_atom_size_B"]
        [::std::mem::offset_of!(nv_device_info, nc_atom_size_B) - 100usize];
    ["Offset of field: nv_device_info::cls_copy"]
        [::std::mem::offset_of!(nv_device_info, cls_copy) - 102usize];
    ["Offset of field: nv_device_info::cls_eng2d"]
        [::std::mem::offset_of!(nv_device_info, cls_eng2d) - 104usize];
    ["Offset of field: nv_device_info::cls_eng3d"]
        [::std::mem::offset_of!(nv_device_info, cls_eng3d) - 106usize];
    ["Offset of field: nv_device_info::cls_m2mf"]
        [::std::mem::offset_of!(nv_device_info, cls_m2mf) - 108usize];
    ["Offset of field: nv_device_info::cls_compute"]
        [::std::mem::offset_of!(nv_device_info, cls_compute) - 110usize];
    ["Offset of field: nv_device_info::cls_gpfifo"]
        [::std::mem::offset_of!(nv_device_info, cls_gpfifo) - 112usize];
    ["Offset of field: nv_device_info::vram_size_B"]
        [::std::mem::offset_of!(nv_device_info, vram_size_B) - 116usize];
    ["Offset of field: nv_device_info::bar_size_B"]
        [::std::mem::offset_of!(nv_device_info, bar_size_B) - 124usize];
    ["Offset of field: nv_device_info::max_smem_per_wg_kB"]
        [::std::mem::offset_of!(nv_device_info, max_smem_per_wg_kB) - 132usize];
    ["Offset of field: nv_device_info::sm_smem_sizes_kB"]
        [::std::mem::offset_of!(nv_device_info, sm_smem_sizes_kB) - 134usize];
    ["Offset of field: nv_device_info::sm_smem_size_count"]
        [::std::mem::offset_of!(nv_device_info, sm_smem_size_count) - 154usize];
};
