/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/podresources/v1/api.proto

package v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	PodResourcesLister_List_FullMethodName                    = "/v1.PodResourcesLister/List"
	PodResourcesLister_GetAllocatableResources_FullMethodName = "/v1.PodResourcesLister/GetAllocatableResources"
	PodResourcesLister_Get_FullMethodName                     = "/v1.PodResourcesLister/Get"
)

// PodResourcesListerClient is the client API for PodResourcesLister service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// PodResourcesLister is a service provided by the kubelet that provides information about the
// node resources consumed by pods and containers on the node
type PodResourcesListerClient interface {
	List(ctx context.Context, in *ListPodResourcesRequest, opts ...grpc.CallOption) (*ListPodResourcesResponse, error)
	GetAllocatableResources(ctx context.Context, in *AllocatableResourcesRequest, opts ...grpc.CallOption) (*AllocatableResourcesResponse, error)
	Get(ctx context.Context, in *GetPodResourcesRequest, opts ...grpc.CallOption) (*GetPodResourcesResponse, error)
}

type podResourcesListerClient struct {
	cc grpc.ClientConnInterface
}

func NewPodResourcesListerClient(cc grpc.ClientConnInterface) PodResourcesListerClient {
	return &podResourcesListerClient{cc}
}

func (c *podResourcesListerClient) List(ctx context.Context, in *ListPodResourcesRequest, opts ...grpc.CallOption) (*ListPodResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListPodResourcesResponse)
	err := c.cc.Invoke(ctx, PodResourcesLister_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *podResourcesListerClient) GetAllocatableResources(ctx context.Context, in *AllocatableResourcesRequest, opts ...grpc.CallOption) (*AllocatableResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AllocatableResourcesResponse)
	err := c.cc.Invoke(ctx, PodResourcesLister_GetAllocatableResources_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *podResourcesListerClient) Get(ctx context.Context, in *GetPodResourcesRequest, opts ...grpc.CallOption) (*GetPodResourcesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetPodResourcesResponse)
	err := c.cc.Invoke(ctx, PodResourcesLister_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PodResourcesListerServer is the server API for PodResourcesLister service.
// All implementations must embed UnimplementedPodResourcesListerServer
// for forward compatibility.
//
// PodResourcesLister is a service provided by the kubelet that provides information about the
// node resources consumed by pods and containers on the node
type PodResourcesListerServer interface {
	List(context.Context, *ListPodResourcesRequest) (*ListPodResourcesResponse, error)
	GetAllocatableResources(context.Context, *AllocatableResourcesRequest) (*AllocatableResourcesResponse, error)
	Get(context.Context, *GetPodResourcesRequest) (*GetPodResourcesResponse, error)
	mustEmbedUnimplementedPodResourcesListerServer()
}

// UnimplementedPodResourcesListerServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPodResourcesListerServer struct{}

func (UnimplementedPodResourcesListerServer) List(context.Context, *ListPodResourcesRequest) (*ListPodResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedPodResourcesListerServer) GetAllocatableResources(context.Context, *AllocatableResourcesRequest) (*AllocatableResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllocatableResources not implemented")
}
func (UnimplementedPodResourcesListerServer) Get(context.Context, *GetPodResourcesRequest) (*GetPodResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedPodResourcesListerServer) mustEmbedUnimplementedPodResourcesListerServer() {}
func (UnimplementedPodResourcesListerServer) testEmbeddedByValue()                            {}

// UnsafePodResourcesListerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PodResourcesListerServer will
// result in compilation errors.
type UnsafePodResourcesListerServer interface {
	mustEmbedUnimplementedPodResourcesListerServer()
}

func RegisterPodResourcesListerServer(s grpc.ServiceRegistrar, srv PodResourcesListerServer) {
	// If the following call pancis, it indicates UnimplementedPodResourcesListerServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&PodResourcesLister_ServiceDesc, srv)
}

func _PodResourcesLister_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PodResourcesListerServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PodResourcesLister_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PodResourcesListerServer).List(ctx, req.(*ListPodResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PodResourcesLister_GetAllocatableResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocatableResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PodResourcesListerServer).GetAllocatableResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PodResourcesLister_GetAllocatableResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PodResourcesListerServer).GetAllocatableResources(ctx, req.(*AllocatableResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PodResourcesLister_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPodResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PodResourcesListerServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PodResourcesLister_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PodResourcesListerServer).Get(ctx, req.(*GetPodResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PodResourcesLister_ServiceDesc is the grpc.ServiceDesc for PodResourcesLister service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PodResourcesLister_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "v1.PodResourcesLister",
	HandlerType: (*PodResourcesListerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _PodResourcesLister_List_Handler,
		},
		{
			MethodName: "GetAllocatableResources",
			Handler:    _PodResourcesLister_GetAllocatableResources_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _PodResourcesLister_Get_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "staging/src/k8s.io/kubelet/pkg/apis/podresources/v1/api.proto",
}
