#include "WelcomeManager.hpp"
#include "../Compositor.hpp"
#include "../debug/log/Logger.hpp"
#include "../config/ConfigValue.hpp"
#include "../helpers/fs/FsUtils.hpp"

#include <hyprutils/os/Process.hpp>

using namespace Hyprutils::OS;

CWelcomeManager::CWelcomeManager() {
    static auto PAUTOGEN = CConfigValue<Hyprlang::INT>("autogenerated");

    if (!*PAUTOGEN) {
        Log::logger->log(Log::DEBUG, "[welcome] skipping, not autogen");
        return;
    }

    if (g_pCompositor->m_safeMode) {
        Log::logger->log(Log::DEBUG, "[welcome] skipping, safe mode");
        return;
    }

    if (!NFsUtils::executableExistsInPath("hyprland-welcome")) {
        Log::logger->log(Log::DEBUG, "[welcome] skipping, no welcome app");
        return;
    }

    m_fired = true;

    CProcess welcome("hyprland-welcome", {});
    welcome.runAsync();
}

bool CWelcomeManager::fired() {
    return m_fired;
}
