{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAnalysis@ structure stores information about
-- the properties of a segment of text.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.Analysis
    ( 

-- * Exported types
    Analysis(..)                            ,
    newZeroAnalysis                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAnalysisMethod                   ,
#endif



 -- * Properties


-- ** extraAttrs #attr:extraAttrs#
-- | extra attributes for this segment.

#if defined(ENABLE_OVERLOADING)
    analysis_extraAttrs                     ,
#endif
    clearAnalysisExtraAttrs                 ,
    getAnalysisExtraAttrs                   ,
    setAnalysisExtraAttrs                   ,


-- ** flags #attr:flags#
-- | boolean flags for this segment (Since: 1.16).

#if defined(ENABLE_OVERLOADING)
    analysis_flags                          ,
#endif
    getAnalysisFlags                        ,
    setAnalysisFlags                        ,


-- ** font #attr:font#
-- | the font for this segment.

#if defined(ENABLE_OVERLOADING)
    analysis_font                           ,
#endif
    clearAnalysisFont                       ,
    getAnalysisFont                         ,
    setAnalysisFont                         ,


-- ** gravity #attr:gravity#
-- | the glyph orientation for this segment (A @PangoGravity@).

#if defined(ENABLE_OVERLOADING)
    analysis_gravity                        ,
#endif
    getAnalysisGravity                      ,
    setAnalysisGravity                      ,


-- ** langEngine #attr:langEngine#
-- | unused, reserved

#if defined(ENABLE_OVERLOADING)
    analysis_langEngine                     ,
#endif
    clearAnalysisLangEngine                 ,
    getAnalysisLangEngine                   ,
    setAnalysisLangEngine                   ,


-- ** language #attr:language#
-- | the detected language for this segment.

#if defined(ENABLE_OVERLOADING)
    analysis_language                       ,
#endif
    clearAnalysisLanguage                   ,
    getAnalysisLanguage                     ,
    setAnalysisLanguage                     ,


-- ** level #attr:level#
-- | the bidirectional level for this segment.

#if defined(ENABLE_OVERLOADING)
    analysis_level                          ,
#endif
    getAnalysisLevel                        ,
    setAnalysisLevel                        ,


-- ** script #attr:script#
-- | the detected script for this segment (A @PangoScript@) (Since: 1.18).

#if defined(ENABLE_OVERLOADING)
    analysis_script                         ,
#endif
    getAnalysisScript                       ,
    setAnalysisScript                       ,


-- ** shapeEngine #attr:shapeEngine#
-- | unused, reserved

#if defined(ENABLE_OVERLOADING)
    analysis_shapeEngine                    ,
#endif
    clearAnalysisShapeEngine                ,
    getAnalysisShapeEngine                  ,
    setAnalysisShapeEngine                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype Analysis = Analysis (SP.ManagedPtr Analysis)
    deriving (Eq)

instance SP.ManagedPtrNewtype Analysis where
    toManagedPtr (Analysis p) = p

instance BoxedPtr Analysis where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr Analysis)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Analysis where
    boxedPtrCalloc = callocBytes 48


-- | Construct a t'Analysis' struct initialized to zero.
newZeroAnalysis :: MonadIO m => m Analysis
newZeroAnalysis = liftIO $ boxedPtrCalloc >>= wrapPtr Analysis

instance tag ~ 'AttrSet => Constructible Analysis tag where
    new _ attrs = do
        o <- newZeroAnalysis
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@shape_engine@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #shapeEngine
-- @
getAnalysisShapeEngine :: MonadIO m => Analysis -> m (Ptr ())
getAnalysisShapeEngine s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@shape_engine@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #shapeEngine 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisShapeEngine :: MonadIO m => Analysis -> Ptr () -> m ()
setAnalysisShapeEngine s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@shape_engine@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #shapeEngine
-- @
clearAnalysisShapeEngine :: MonadIO m => Analysis -> m ()
clearAnalysisShapeEngine s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data AnalysisShapeEngineFieldInfo
instance AttrInfo AnalysisShapeEngineFieldInfo where
    type AttrBaseTypeConstraint AnalysisShapeEngineFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisShapeEngineFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AnalysisShapeEngineFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint AnalysisShapeEngineFieldInfo = (~)(Ptr ())
    type AttrTransferType AnalysisShapeEngineFieldInfo = (Ptr ())
    type AttrGetType AnalysisShapeEngineFieldInfo = Ptr ()
    type AttrLabel AnalysisShapeEngineFieldInfo = "shape_engine"
    type AttrOrigin AnalysisShapeEngineFieldInfo = Analysis
    attrGet = getAnalysisShapeEngine
    attrSet = setAnalysisShapeEngine
    attrConstruct = undefined
    attrClear = clearAnalysisShapeEngine
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.shapeEngine"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:shapeEngine"
        })

analysis_shapeEngine :: AttrLabelProxy "shapeEngine"
analysis_shapeEngine = AttrLabelProxy

#endif


-- | Get the value of the “@lang_engine@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #langEngine
-- @
getAnalysisLangEngine :: MonadIO m => Analysis -> m (Ptr ())
getAnalysisLangEngine s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr ())
    return val

-- | Set the value of the “@lang_engine@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #langEngine 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisLangEngine :: MonadIO m => Analysis -> Ptr () -> m ()
setAnalysisLangEngine s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr ())

-- | Set the value of the “@lang_engine@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #langEngine
-- @
clearAnalysisLangEngine :: MonadIO m => Analysis -> m ()
clearAnalysisLangEngine s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data AnalysisLangEngineFieldInfo
instance AttrInfo AnalysisLangEngineFieldInfo where
    type AttrBaseTypeConstraint AnalysisLangEngineFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisLangEngineFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AnalysisLangEngineFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint AnalysisLangEngineFieldInfo = (~)(Ptr ())
    type AttrTransferType AnalysisLangEngineFieldInfo = (Ptr ())
    type AttrGetType AnalysisLangEngineFieldInfo = Ptr ()
    type AttrLabel AnalysisLangEngineFieldInfo = "lang_engine"
    type AttrOrigin AnalysisLangEngineFieldInfo = Analysis
    attrGet = getAnalysisLangEngine
    attrSet = setAnalysisLangEngine
    attrConstruct = undefined
    attrClear = clearAnalysisLangEngine
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.langEngine"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:langEngine"
        })

analysis_langEngine :: AttrLabelProxy "langEngine"
analysis_langEngine = AttrLabelProxy

#endif


-- | Get the value of the “@font@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #font
-- @
getAnalysisFont :: MonadIO m => Analysis -> m (Maybe Pango.Font.Font)
getAnalysisFont s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr Pango.Font.Font)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Pango.Font.Font) val'
        return val''
    return result

-- | Set the value of the “@font@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #font 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisFont :: MonadIO m => Analysis -> Ptr Pango.Font.Font -> m ()
setAnalysisFont s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr Pango.Font.Font)

-- | Set the value of the “@font@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #font
-- @
clearAnalysisFont :: MonadIO m => Analysis -> m ()
clearAnalysisFont s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr Pango.Font.Font)

#if defined(ENABLE_OVERLOADING)
data AnalysisFontFieldInfo
instance AttrInfo AnalysisFontFieldInfo where
    type AttrBaseTypeConstraint AnalysisFontFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisFontFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AnalysisFontFieldInfo = (~) (Ptr Pango.Font.Font)
    type AttrTransferTypeConstraint AnalysisFontFieldInfo = (~)(Ptr Pango.Font.Font)
    type AttrTransferType AnalysisFontFieldInfo = (Ptr Pango.Font.Font)
    type AttrGetType AnalysisFontFieldInfo = Maybe Pango.Font.Font
    type AttrLabel AnalysisFontFieldInfo = "font"
    type AttrOrigin AnalysisFontFieldInfo = Analysis
    attrGet = getAnalysisFont
    attrSet = setAnalysisFont
    attrConstruct = undefined
    attrClear = clearAnalysisFont
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.font"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:font"
        })

analysis_font :: AttrLabelProxy "font"
analysis_font = AttrLabelProxy

#endif


-- | Get the value of the “@level@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #level
-- @
getAnalysisLevel :: MonadIO m => Analysis -> m Word8
getAnalysisLevel s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word8
    return val

-- | Set the value of the “@level@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #level 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisLevel :: MonadIO m => Analysis -> Word8 -> m ()
setAnalysisLevel s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data AnalysisLevelFieldInfo
instance AttrInfo AnalysisLevelFieldInfo where
    type AttrBaseTypeConstraint AnalysisLevelFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisLevelFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AnalysisLevelFieldInfo = (~) Word8
    type AttrTransferTypeConstraint AnalysisLevelFieldInfo = (~)Word8
    type AttrTransferType AnalysisLevelFieldInfo = Word8
    type AttrGetType AnalysisLevelFieldInfo = Word8
    type AttrLabel AnalysisLevelFieldInfo = "level"
    type AttrOrigin AnalysisLevelFieldInfo = Analysis
    attrGet = getAnalysisLevel
    attrSet = setAnalysisLevel
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.level"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:level"
        })

analysis_level :: AttrLabelProxy "level"
analysis_level = AttrLabelProxy

#endif


-- | Get the value of the “@gravity@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #gravity
-- @
getAnalysisGravity :: MonadIO m => Analysis -> m Word8
getAnalysisGravity s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 25) :: IO Word8
    return val

-- | Set the value of the “@gravity@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #gravity 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisGravity :: MonadIO m => Analysis -> Word8 -> m ()
setAnalysisGravity s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 25) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data AnalysisGravityFieldInfo
instance AttrInfo AnalysisGravityFieldInfo where
    type AttrBaseTypeConstraint AnalysisGravityFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisGravityFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AnalysisGravityFieldInfo = (~) Word8
    type AttrTransferTypeConstraint AnalysisGravityFieldInfo = (~)Word8
    type AttrTransferType AnalysisGravityFieldInfo = Word8
    type AttrGetType AnalysisGravityFieldInfo = Word8
    type AttrLabel AnalysisGravityFieldInfo = "gravity"
    type AttrOrigin AnalysisGravityFieldInfo = Analysis
    attrGet = getAnalysisGravity
    attrSet = setAnalysisGravity
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.gravity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:gravity"
        })

analysis_gravity :: AttrLabelProxy "gravity"
analysis_gravity = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #flags
-- @
getAnalysisFlags :: MonadIO m => Analysis -> m Word8
getAnalysisFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 26) :: IO Word8
    return val

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisFlags :: MonadIO m => Analysis -> Word8 -> m ()
setAnalysisFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 26) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data AnalysisFlagsFieldInfo
instance AttrInfo AnalysisFlagsFieldInfo where
    type AttrBaseTypeConstraint AnalysisFlagsFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AnalysisFlagsFieldInfo = (~) Word8
    type AttrTransferTypeConstraint AnalysisFlagsFieldInfo = (~)Word8
    type AttrTransferType AnalysisFlagsFieldInfo = Word8
    type AttrGetType AnalysisFlagsFieldInfo = Word8
    type AttrLabel AnalysisFlagsFieldInfo = "flags"
    type AttrOrigin AnalysisFlagsFieldInfo = Analysis
    attrGet = getAnalysisFlags
    attrSet = setAnalysisFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:flags"
        })

analysis_flags :: AttrLabelProxy "flags"
analysis_flags = AttrLabelProxy

#endif


-- | Get the value of the “@script@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #script
-- @
getAnalysisScript :: MonadIO m => Analysis -> m Word8
getAnalysisScript s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 27) :: IO Word8
    return val

-- | Set the value of the “@script@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #script 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisScript :: MonadIO m => Analysis -> Word8 -> m ()
setAnalysisScript s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 27) (val :: Word8)

#if defined(ENABLE_OVERLOADING)
data AnalysisScriptFieldInfo
instance AttrInfo AnalysisScriptFieldInfo where
    type AttrBaseTypeConstraint AnalysisScriptFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisScriptFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AnalysisScriptFieldInfo = (~) Word8
    type AttrTransferTypeConstraint AnalysisScriptFieldInfo = (~)Word8
    type AttrTransferType AnalysisScriptFieldInfo = Word8
    type AttrGetType AnalysisScriptFieldInfo = Word8
    type AttrLabel AnalysisScriptFieldInfo = "script"
    type AttrOrigin AnalysisScriptFieldInfo = Analysis
    attrGet = getAnalysisScript
    attrSet = setAnalysisScript
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.script"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:script"
        })

analysis_script :: AttrLabelProxy "script"
analysis_script = AttrLabelProxy

#endif


-- | Get the value of the “@language@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #language
-- @
getAnalysisLanguage :: MonadIO m => Analysis -> m (Maybe Pango.Language.Language)
getAnalysisLanguage s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr Pango.Language.Language)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Pango.Language.Language) val'
        return val''
    return result

-- | Set the value of the “@language@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #language 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisLanguage :: MonadIO m => Analysis -> Ptr Pango.Language.Language -> m ()
setAnalysisLanguage s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr Pango.Language.Language)

-- | Set the value of the “@language@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #language
-- @
clearAnalysisLanguage :: MonadIO m => Analysis -> m ()
clearAnalysisLanguage s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr Pango.Language.Language)

#if defined(ENABLE_OVERLOADING)
data AnalysisLanguageFieldInfo
instance AttrInfo AnalysisLanguageFieldInfo where
    type AttrBaseTypeConstraint AnalysisLanguageFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisLanguageFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AnalysisLanguageFieldInfo = (~) (Ptr Pango.Language.Language)
    type AttrTransferTypeConstraint AnalysisLanguageFieldInfo = (~)(Ptr Pango.Language.Language)
    type AttrTransferType AnalysisLanguageFieldInfo = (Ptr Pango.Language.Language)
    type AttrGetType AnalysisLanguageFieldInfo = Maybe Pango.Language.Language
    type AttrLabel AnalysisLanguageFieldInfo = "language"
    type AttrOrigin AnalysisLanguageFieldInfo = Analysis
    attrGet = getAnalysisLanguage
    attrSet = setAnalysisLanguage
    attrConstruct = undefined
    attrClear = clearAnalysisLanguage
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.language"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:language"
        })

analysis_language :: AttrLabelProxy "language"
analysis_language = AttrLabelProxy

#endif


-- | Get the value of the “@extra_attrs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' analysis #extraAttrs
-- @
getAnalysisExtraAttrs :: MonadIO m => Analysis -> m ([Ptr ()])
getAnalysisExtraAttrs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (Ptr (GSList (Ptr ())))
    val' <- unpackGSList val
    return val'

-- | Set the value of the “@extra_attrs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' analysis [ #extraAttrs 'Data.GI.Base.Attributes.:=' value ]
-- @
setAnalysisExtraAttrs :: MonadIO m => Analysis -> Ptr (GSList (Ptr ())) -> m ()
setAnalysisExtraAttrs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Ptr (GSList (Ptr ())))

-- | Set the value of the “@extra_attrs@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #extraAttrs
-- @
clearAnalysisExtraAttrs :: MonadIO m => Analysis -> m ()
clearAnalysisExtraAttrs s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: Ptr (GSList (Ptr ())))

#if defined(ENABLE_OVERLOADING)
data AnalysisExtraAttrsFieldInfo
instance AttrInfo AnalysisExtraAttrsFieldInfo where
    type AttrBaseTypeConstraint AnalysisExtraAttrsFieldInfo = (~) Analysis
    type AttrAllowedOps AnalysisExtraAttrsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AnalysisExtraAttrsFieldInfo = (~) (Ptr (GSList (Ptr ())))
    type AttrTransferTypeConstraint AnalysisExtraAttrsFieldInfo = (~)(Ptr (GSList (Ptr ())))
    type AttrTransferType AnalysisExtraAttrsFieldInfo = (Ptr (GSList (Ptr ())))
    type AttrGetType AnalysisExtraAttrsFieldInfo = [Ptr ()]
    type AttrLabel AnalysisExtraAttrsFieldInfo = "extra_attrs"
    type AttrOrigin AnalysisExtraAttrsFieldInfo = Analysis
    attrGet = getAnalysisExtraAttrs
    attrSet = setAnalysisExtraAttrs
    attrConstruct = undefined
    attrClear = clearAnalysisExtraAttrs
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Analysis.extraAttrs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Analysis.html#g:attr:extraAttrs"
        })

analysis_extraAttrs :: AttrLabelProxy "extraAttrs"
analysis_extraAttrs = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Analysis
type instance O.AttributeList Analysis = AnalysisAttributeList
type AnalysisAttributeList = ('[ '("shapeEngine", AnalysisShapeEngineFieldInfo), '("langEngine", AnalysisLangEngineFieldInfo), '("font", AnalysisFontFieldInfo), '("level", AnalysisLevelFieldInfo), '("gravity", AnalysisGravityFieldInfo), '("flags", AnalysisFlagsFieldInfo), '("script", AnalysisScriptFieldInfo), '("language", AnalysisLanguageFieldInfo), '("extraAttrs", AnalysisExtraAttrsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAnalysisMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAnalysisMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAnalysisMethod t Analysis, O.OverloadedMethod info Analysis p) => OL.IsLabel t (Analysis -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAnalysisMethod t Analysis, O.OverloadedMethod info Analysis p, R.HasField t Analysis p) => R.HasField t Analysis p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAnalysisMethod t Analysis, O.OverloadedMethodInfo info Analysis) => OL.IsLabel t (O.MethodProxy info Analysis) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


