{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Applies a gives sorter to the levels in a tree.
-- 
-- Here is an example for setting up a column view with a tree model and
-- a @GtkTreeListSorter@:
-- 
-- 
-- === /c code/
-- >column_sorter = gtk_column_view_get_sorter (view);
-- >sorter = gtk_tree_list_row_sorter_new (g_object_ref (column_sorter));
-- >sort_model = gtk_sort_list_model_new (tree_model, sorter);
-- >selection = gtk_single_selection_new (sort_model);
-- >gtk_column_view_set_model (view, G_LIST_MODEL (selection));
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.TreeListRowSorter
    ( 

-- * Exported types
    TreeListRowSorter(..)                   ,
    IsTreeListRowSorter                     ,
    toTreeListRowSorter                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSorter]("GI.Gtk.Objects.TreeListRowSorter#g:method:getSorter").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSorter]("GI.Gtk.Objects.TreeListRowSorter#g:method:setSorter").

#if defined(ENABLE_OVERLOADING)
    ResolveTreeListRowSorterMethod          ,
#endif

-- ** getSorter #method:getSorter#

#if defined(ENABLE_OVERLOADING)
    TreeListRowSorterGetSorterMethodInfo    ,
#endif
    treeListRowSorterGetSorter              ,


-- ** new #method:new#

    treeListRowSorterNew                    ,


-- ** setSorter #method:setSorter#

#if defined(ENABLE_OVERLOADING)
    TreeListRowSorterSetSorterMethodInfo    ,
#endif
    treeListRowSorterSetSorter              ,




 -- * Properties


-- ** sorter #attr:sorter#
-- | The underlying sorter

#if defined(ENABLE_OVERLOADING)
    TreeListRowSorterSorterPropertyInfo     ,
#endif
    clearTreeListRowSorterSorter            ,
    constructTreeListRowSorterSorter        ,
    getTreeListRowSorterSorter              ,
    setTreeListRowSorterSorter              ,
#if defined(ENABLE_OVERLOADING)
    treeListRowSorterSorter                 ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype TreeListRowSorter = TreeListRowSorter (SP.ManagedPtr TreeListRowSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype TreeListRowSorter where
    toManagedPtr (TreeListRowSorter p) = p

foreign import ccall "gtk_tree_list_row_sorter_get_type"
    c_gtk_tree_list_row_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject TreeListRowSorter where
    glibType = c_gtk_tree_list_row_sorter_get_type

instance B.Types.GObject TreeListRowSorter

-- | Type class for types which can be safely cast to t'TreeListRowSorter', for instance with `toTreeListRowSorter`.
class (SP.GObject o, O.IsDescendantOf TreeListRowSorter o) => IsTreeListRowSorter o
instance (SP.GObject o, O.IsDescendantOf TreeListRowSorter o) => IsTreeListRowSorter o

instance O.HasParentTypes TreeListRowSorter
type instance O.ParentTypes TreeListRowSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object]

-- | Cast to t'TreeListRowSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTreeListRowSorter :: (MIO.MonadIO m, IsTreeListRowSorter o) => o -> m TreeListRowSorter
toTreeListRowSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo TreeListRowSorter

-- | Convert t'TreeListRowSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TreeListRowSorter) where
    gvalueGType_ = c_gtk_tree_list_row_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TreeListRowSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TreeListRowSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TreeListRowSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTreeListRowSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTreeListRowSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTreeListRowSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTreeListRowSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveTreeListRowSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveTreeListRowSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTreeListRowSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTreeListRowSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTreeListRowSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTreeListRowSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTreeListRowSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTreeListRowSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTreeListRowSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTreeListRowSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTreeListRowSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTreeListRowSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTreeListRowSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTreeListRowSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTreeListRowSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTreeListRowSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTreeListRowSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveTreeListRowSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTreeListRowSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTreeListRowSorterMethod "getSorter" o = TreeListRowSorterGetSorterMethodInfo
    ResolveTreeListRowSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTreeListRowSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTreeListRowSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTreeListRowSorterMethod "setSorter" o = TreeListRowSorterSetSorterMethodInfo
    ResolveTreeListRowSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTreeListRowSorterMethod t TreeListRowSorter, O.OverloadedMethod info TreeListRowSorter p) => OL.IsLabel t (TreeListRowSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTreeListRowSorterMethod t TreeListRowSorter, O.OverloadedMethod info TreeListRowSorter p, R.HasField t TreeListRowSorter p) => R.HasField t TreeListRowSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTreeListRowSorterMethod t TreeListRowSorter, O.OverloadedMethodInfo info TreeListRowSorter) => OL.IsLabel t (O.MethodProxy info TreeListRowSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "sorter"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Sorter"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@sorter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeListRowSorter #sorter
-- @
getTreeListRowSorterSorter :: (MonadIO m, IsTreeListRowSorter o) => o -> m (Maybe Gtk.Sorter.Sorter)
getTreeListRowSorterSorter obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "sorter" Gtk.Sorter.Sorter

-- | Set the value of the “@sorter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeListRowSorter [ #sorter 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeListRowSorterSorter :: (MonadIO m, IsTreeListRowSorter o, Gtk.Sorter.IsSorter a) => o -> a -> m ()
setTreeListRowSorterSorter obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "sorter" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@sorter@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeListRowSorterSorter :: (IsTreeListRowSorter o, MIO.MonadIO m, Gtk.Sorter.IsSorter a) => a -> m (GValueConstruct o)
constructTreeListRowSorterSorter val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "sorter" (P.Just val)

-- | Set the value of the “@sorter@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #sorter
-- @
clearTreeListRowSorterSorter :: (MonadIO m, IsTreeListRowSorter o) => o -> m ()
clearTreeListRowSorterSorter obj = liftIO $ B.Properties.setObjectPropertyObject obj "sorter" (Nothing :: Maybe Gtk.Sorter.Sorter)

#if defined(ENABLE_OVERLOADING)
data TreeListRowSorterSorterPropertyInfo
instance AttrInfo TreeListRowSorterSorterPropertyInfo where
    type AttrAllowedOps TreeListRowSorterSorterPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeListRowSorterSorterPropertyInfo = IsTreeListRowSorter
    type AttrSetTypeConstraint TreeListRowSorterSorterPropertyInfo = Gtk.Sorter.IsSorter
    type AttrTransferTypeConstraint TreeListRowSorterSorterPropertyInfo = Gtk.Sorter.IsSorter
    type AttrTransferType TreeListRowSorterSorterPropertyInfo = Gtk.Sorter.Sorter
    type AttrGetType TreeListRowSorterSorterPropertyInfo = (Maybe Gtk.Sorter.Sorter)
    type AttrLabel TreeListRowSorterSorterPropertyInfo = "sorter"
    type AttrOrigin TreeListRowSorterSorterPropertyInfo = TreeListRowSorter
    attrGet = getTreeListRowSorterSorter
    attrSet = setTreeListRowSorterSorter
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Sorter.Sorter v
    attrConstruct = constructTreeListRowSorterSorter
    attrClear = clearTreeListRowSorterSorter
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRowSorter.sorter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRowSorter.html#g:attr:sorter"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TreeListRowSorter
type instance O.AttributeList TreeListRowSorter = TreeListRowSorterAttributeList
type TreeListRowSorterAttributeList = ('[ '("sorter", TreeListRowSorterSorterPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
treeListRowSorterSorter :: AttrLabelProxy "sorter"
treeListRowSorterSorter = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TreeListRowSorter = TreeListRowSorterSignalList
type TreeListRowSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TreeListRowSorter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "sorter"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "TreeListRowSorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_sorter_new" gtk_tree_list_row_sorter_new :: 
    Ptr Gtk.Sorter.Sorter ->                -- sorter : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    IO (Ptr TreeListRowSorter)

-- | Create a special-purpose sorter that applies the sorting
-- of /@sorter@/ to the levels of a @GtkTreeListModel@.
-- 
-- Note that this sorter relies on [TreeListModel:passthrough]("GI.Gtk.Objects.TreeListModel#g:attr:passthrough")
-- being 'P.False' as it can only sort t'GI.Gtk.Objects.TreeListRow.TreeListRow's.
treeListRowSorterNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Sorter.IsSorter a) =>
    Maybe (a)
    -- ^ /@sorter@/: a @GtkSorter@
    -> m TreeListRowSorter
    -- ^ __Returns:__ a new @GtkTreeListRowSorter@
treeListRowSorterNew sorter = liftIO $ do
    maybeSorter <- case sorter of
        Nothing -> return FP.nullPtr
        Just jSorter -> do
            jSorter' <- B.ManagedPtr.disownObject jSorter
            return jSorter'
    result <- gtk_tree_list_row_sorter_new maybeSorter
    checkUnexpectedReturnNULL "treeListRowSorterNew" result
    result' <- (wrapObject TreeListRowSorter) result
    whenJust sorter touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TreeListRowSorter::get_sorter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRowSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRowSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Sorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_sorter_get_sorter" gtk_tree_list_row_sorter_get_sorter :: 
    Ptr TreeListRowSorter ->                -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRowSorter"})
    IO (Ptr Gtk.Sorter.Sorter)

-- | Returns the sorter used by /@self@/.
treeListRowSorterGetSorter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRowSorter a) =>
    a
    -- ^ /@self@/: a @GtkTreeListRowSorter@
    -> m (Maybe Gtk.Sorter.Sorter)
    -- ^ __Returns:__ the sorter used
treeListRowSorterGetSorter self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_list_row_sorter_get_sorter self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Sorter.Sorter) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeListRowSorterGetSorterMethodInfo
instance (signature ~ (m (Maybe Gtk.Sorter.Sorter)), MonadIO m, IsTreeListRowSorter a) => O.OverloadedMethod TreeListRowSorterGetSorterMethodInfo a signature where
    overloadedMethod = treeListRowSorterGetSorter

instance O.OverloadedMethodInfo TreeListRowSorterGetSorterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRowSorter.treeListRowSorterGetSorter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRowSorter.html#v:treeListRowSorterGetSorter"
        })


#endif

-- method TreeListRowSorter::set_sorter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRowSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRowSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sorter"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The sorter to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_list_row_sorter_set_sorter" gtk_tree_list_row_sorter_set_sorter :: 
    Ptr TreeListRowSorter ->                -- self : TInterface (Name {namespace = "Gtk", name = "TreeListRowSorter"})
    Ptr Gtk.Sorter.Sorter ->                -- sorter : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    IO ()

-- | Sets the sorter to use for items with the same parent.
-- 
-- This sorter will be passed the [TreeListRow:item]("GI.Gtk.Objects.TreeListRow#g:attr:item") of
-- the tree list rows passed to /@self@/.
treeListRowSorterSetSorter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeListRowSorter a, Gtk.Sorter.IsSorter b) =>
    a
    -- ^ /@self@/: a @GtkTreeListRowSorter@
    -> Maybe (b)
    -- ^ /@sorter@/: The sorter to use
    -> m ()
treeListRowSorterSetSorter self sorter = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeSorter <- case sorter of
        Nothing -> return FP.nullPtr
        Just jSorter -> do
            jSorter' <- unsafeManagedPtrCastPtr jSorter
            return jSorter'
    gtk_tree_list_row_sorter_set_sorter self' maybeSorter
    touchManagedPtr self
    whenJust sorter touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeListRowSorterSetSorterMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTreeListRowSorter a, Gtk.Sorter.IsSorter b) => O.OverloadedMethod TreeListRowSorterSetSorterMethodInfo a signature where
    overloadedMethod = treeListRowSorterSetSorter

instance O.OverloadedMethodInfo TreeListRowSorterSetSorterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeListRowSorter.treeListRowSorterSetSorter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-TreeListRowSorter.html#v:treeListRowSorterSetSorter"
        })


#endif


