{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An auxiliary object used by @GtkNotebook@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.NotebookPage
    ( 

-- * Exported types
    NotebookPage(..)                        ,
    IsNotebookPage                          ,
    toNotebookPage                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChild]("GI.Gtk.Objects.NotebookPage#g:method:getChild"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNotebookPageMethod               ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    NotebookPageGetChildMethodInfo          ,
#endif
    notebookPageGetChild                    ,




 -- * Properties


-- ** child #attr:child#
-- | The child for this page.

#if defined(ENABLE_OVERLOADING)
    NotebookPageChildPropertyInfo           ,
#endif
    constructNotebookPageChild              ,
    getNotebookPageChild                    ,
#if defined(ENABLE_OVERLOADING)
    notebookPageChild                       ,
#endif


-- ** detachable #attr:detachable#
-- | Whether the tab is detachable.

#if defined(ENABLE_OVERLOADING)
    NotebookPageDetachablePropertyInfo      ,
#endif
    constructNotebookPageDetachable         ,
    getNotebookPageDetachable               ,
#if defined(ENABLE_OVERLOADING)
    notebookPageDetachable                  ,
#endif
    setNotebookPageDetachable               ,


-- ** menu #attr:menu#
-- | The label widget displayed in the child\'s menu entry.

#if defined(ENABLE_OVERLOADING)
    NotebookPageMenuPropertyInfo            ,
#endif
    constructNotebookPageMenu               ,
    getNotebookPageMenu                     ,
#if defined(ENABLE_OVERLOADING)
    notebookPageMenu                        ,
#endif


-- ** menuLabel #attr:menuLabel#
-- | The text of the menu widget.

#if defined(ENABLE_OVERLOADING)
    NotebookPageMenuLabelPropertyInfo       ,
#endif
    clearNotebookPageMenuLabel              ,
    constructNotebookPageMenuLabel          ,
    getNotebookPageMenuLabel                ,
#if defined(ENABLE_OVERLOADING)
    notebookPageMenuLabel                   ,
#endif
    setNotebookPageMenuLabel                ,


-- ** position #attr:position#
-- | The index of the child in the parent.

#if defined(ENABLE_OVERLOADING)
    NotebookPagePositionPropertyInfo        ,
#endif
    constructNotebookPagePosition           ,
    getNotebookPagePosition                 ,
#if defined(ENABLE_OVERLOADING)
    notebookPagePosition                    ,
#endif
    setNotebookPagePosition                 ,


-- ** reorderable #attr:reorderable#
-- | Whether the tab is reorderable by user action.

#if defined(ENABLE_OVERLOADING)
    NotebookPageReorderablePropertyInfo     ,
#endif
    constructNotebookPageReorderable        ,
    getNotebookPageReorderable              ,
#if defined(ENABLE_OVERLOADING)
    notebookPageReorderable                 ,
#endif
    setNotebookPageReorderable              ,


-- ** tab #attr:tab#
-- | The tab widget for this page.

#if defined(ENABLE_OVERLOADING)
    NotebookPageTabPropertyInfo             ,
#endif
    constructNotebookPageTab                ,
    getNotebookPageTab                      ,
#if defined(ENABLE_OVERLOADING)
    notebookPageTab                         ,
#endif


-- ** tabExpand #attr:tabExpand#
-- | Whether to expand the child\'s tab.

#if defined(ENABLE_OVERLOADING)
    NotebookPageTabExpandPropertyInfo       ,
#endif
    constructNotebookPageTabExpand          ,
    getNotebookPageTabExpand                ,
#if defined(ENABLE_OVERLOADING)
    notebookPageTabExpand                   ,
#endif
    setNotebookPageTabExpand                ,


-- ** tabFill #attr:tabFill#
-- | Whether the child\'s tab should fill the allocated area.

#if defined(ENABLE_OVERLOADING)
    NotebookPageTabFillPropertyInfo         ,
#endif
    constructNotebookPageTabFill            ,
    getNotebookPageTabFill                  ,
#if defined(ENABLE_OVERLOADING)
    notebookPageTabFill                     ,
#endif
    setNotebookPageTabFill                  ,


-- ** tabLabel #attr:tabLabel#
-- | The text of the tab widget.

#if defined(ENABLE_OVERLOADING)
    NotebookPageTabLabelPropertyInfo        ,
#endif
    clearNotebookPageTabLabel               ,
    constructNotebookPageTabLabel           ,
    getNotebookPageTabLabel                 ,
#if defined(ENABLE_OVERLOADING)
    notebookPageTabLabel                    ,
#endif
    setNotebookPageTabLabel                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype NotebookPage = NotebookPage (SP.ManagedPtr NotebookPage)
    deriving (Eq)

instance SP.ManagedPtrNewtype NotebookPage where
    toManagedPtr (NotebookPage p) = p

foreign import ccall "gtk_notebook_page_get_type"
    c_gtk_notebook_page_get_type :: IO B.Types.GType

instance B.Types.TypedObject NotebookPage where
    glibType = c_gtk_notebook_page_get_type

instance B.Types.GObject NotebookPage

-- | Type class for types which can be safely cast to t'NotebookPage', for instance with `toNotebookPage`.
class (SP.GObject o, O.IsDescendantOf NotebookPage o) => IsNotebookPage o
instance (SP.GObject o, O.IsDescendantOf NotebookPage o) => IsNotebookPage o

instance O.HasParentTypes NotebookPage
type instance O.ParentTypes NotebookPage = '[GObject.Object.Object]

-- | Cast to t'NotebookPage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNotebookPage :: (MIO.MonadIO m, IsNotebookPage o) => o -> m NotebookPage
toNotebookPage = MIO.liftIO . B.ManagedPtr.unsafeCastTo NotebookPage

-- | Convert t'NotebookPage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NotebookPage) where
    gvalueGType_ = c_gtk_notebook_page_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NotebookPage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NotebookPage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NotebookPage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNotebookPageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNotebookPageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNotebookPageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNotebookPageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNotebookPageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNotebookPageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNotebookPageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNotebookPageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNotebookPageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNotebookPageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNotebookPageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNotebookPageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNotebookPageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNotebookPageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNotebookPageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNotebookPageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNotebookPageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNotebookPageMethod "getChild" o = NotebookPageGetChildMethodInfo
    ResolveNotebookPageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNotebookPageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNotebookPageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNotebookPageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNotebookPageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNotebookPageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNotebookPageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNotebookPageMethod t NotebookPage, O.OverloadedMethod info NotebookPage p) => OL.IsLabel t (NotebookPage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNotebookPageMethod t NotebookPage, O.OverloadedMethod info NotebookPage p, R.HasField t NotebookPage p) => R.HasField t NotebookPage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNotebookPageMethod t NotebookPage, O.OverloadedMethodInfo info NotebookPage) => OL.IsLabel t (O.MethodProxy info NotebookPage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #child
-- @
getNotebookPageChild :: (MonadIO m, IsNotebookPage o) => o -> m Gtk.Widget.Widget
getNotebookPageChild obj = MIO.liftIO $ checkUnexpectedNothing "getNotebookPageChild" $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageChild :: (IsNotebookPage o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructNotebookPageChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data NotebookPageChildPropertyInfo
instance AttrInfo NotebookPageChildPropertyInfo where
    type AttrAllowedOps NotebookPageChildPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPageChildPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint NotebookPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType NotebookPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType NotebookPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrLabel NotebookPageChildPropertyInfo = "child"
    type AttrOrigin NotebookPageChildPropertyInfo = NotebookPage
    attrGet = getNotebookPageChild
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructNotebookPageChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:child"
        })
#endif

-- VVV Prop "detachable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@detachable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #detachable
-- @
getNotebookPageDetachable :: (MonadIO m, IsNotebookPage o) => o -> m Bool
getNotebookPageDetachable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "detachable"

-- | Set the value of the “@detachable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #detachable 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageDetachable :: (MonadIO m, IsNotebookPage o) => o -> Bool -> m ()
setNotebookPageDetachable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "detachable" val

-- | Construct a t'GValueConstruct' with valid value for the “@detachable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageDetachable :: (IsNotebookPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookPageDetachable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "detachable" val

#if defined(ENABLE_OVERLOADING)
data NotebookPageDetachablePropertyInfo
instance AttrInfo NotebookPageDetachablePropertyInfo where
    type AttrAllowedOps NotebookPageDetachablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NotebookPageDetachablePropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageDetachablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookPageDetachablePropertyInfo = (~) Bool
    type AttrTransferType NotebookPageDetachablePropertyInfo = Bool
    type AttrGetType NotebookPageDetachablePropertyInfo = Bool
    type AttrLabel NotebookPageDetachablePropertyInfo = "detachable"
    type AttrOrigin NotebookPageDetachablePropertyInfo = NotebookPage
    attrGet = getNotebookPageDetachable
    attrSet = setNotebookPageDetachable
    attrPut = setNotebookPageDetachable
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageDetachable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.detachable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:detachable"
        })
#endif

-- VVV Prop "menu"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@menu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #menu
-- @
getNotebookPageMenu :: (MonadIO m, IsNotebookPage o) => o -> m (Maybe Gtk.Widget.Widget)
getNotebookPageMenu obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "menu" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@menu@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageMenu :: (IsNotebookPage o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructNotebookPageMenu val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "menu" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data NotebookPageMenuPropertyInfo
instance AttrInfo NotebookPageMenuPropertyInfo where
    type AttrAllowedOps NotebookPageMenuPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPageMenuPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageMenuPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint NotebookPageMenuPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType NotebookPageMenuPropertyInfo = Gtk.Widget.Widget
    type AttrGetType NotebookPageMenuPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel NotebookPageMenuPropertyInfo = "menu"
    type AttrOrigin NotebookPageMenuPropertyInfo = NotebookPage
    attrGet = getNotebookPageMenu
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructNotebookPageMenu
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.menu"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:menu"
        })
#endif

-- VVV Prop "menu-label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@menu-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #menuLabel
-- @
getNotebookPageMenuLabel :: (MonadIO m, IsNotebookPage o) => o -> m (Maybe T.Text)
getNotebookPageMenuLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "menu-label"

-- | Set the value of the “@menu-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #menuLabel 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageMenuLabel :: (MonadIO m, IsNotebookPage o) => o -> T.Text -> m ()
setNotebookPageMenuLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "menu-label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@menu-label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageMenuLabel :: (IsNotebookPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructNotebookPageMenuLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "menu-label" (P.Just val)

-- | Set the value of the “@menu-label@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #menuLabel
-- @
clearNotebookPageMenuLabel :: (MonadIO m, IsNotebookPage o) => o -> m ()
clearNotebookPageMenuLabel obj = liftIO $ B.Properties.setObjectPropertyString obj "menu-label" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data NotebookPageMenuLabelPropertyInfo
instance AttrInfo NotebookPageMenuLabelPropertyInfo where
    type AttrAllowedOps NotebookPageMenuLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPageMenuLabelPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageMenuLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint NotebookPageMenuLabelPropertyInfo = (~) T.Text
    type AttrTransferType NotebookPageMenuLabelPropertyInfo = T.Text
    type AttrGetType NotebookPageMenuLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel NotebookPageMenuLabelPropertyInfo = "menu-label"
    type AttrOrigin NotebookPageMenuLabelPropertyInfo = NotebookPage
    attrGet = getNotebookPageMenuLabel
    attrSet = setNotebookPageMenuLabel
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageMenuLabel
    attrClear = clearNotebookPageMenuLabel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.menuLabel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:menuLabel"
        })
#endif

-- VVV Prop "position"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #position
-- @
getNotebookPagePosition :: (MonadIO m, IsNotebookPage o) => o -> m Int32
getNotebookPagePosition obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "position"

-- | Set the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #position 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPagePosition :: (MonadIO m, IsNotebookPage o) => o -> Int32 -> m ()
setNotebookPagePosition obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "position" val

-- | Construct a t'GValueConstruct' with valid value for the “@position@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPagePosition :: (IsNotebookPage o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructNotebookPagePosition val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "position" val

#if defined(ENABLE_OVERLOADING)
data NotebookPagePositionPropertyInfo
instance AttrInfo NotebookPagePositionPropertyInfo where
    type AttrAllowedOps NotebookPagePositionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NotebookPagePositionPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPagePositionPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint NotebookPagePositionPropertyInfo = (~) Int32
    type AttrTransferType NotebookPagePositionPropertyInfo = Int32
    type AttrGetType NotebookPagePositionPropertyInfo = Int32
    type AttrLabel NotebookPagePositionPropertyInfo = "position"
    type AttrOrigin NotebookPagePositionPropertyInfo = NotebookPage
    attrGet = getNotebookPagePosition
    attrSet = setNotebookPagePosition
    attrPut = setNotebookPagePosition
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPagePosition
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:position"
        })
#endif

-- VVV Prop "reorderable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #reorderable
-- @
getNotebookPageReorderable :: (MonadIO m, IsNotebookPage o) => o -> m Bool
getNotebookPageReorderable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "reorderable"

-- | Set the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #reorderable 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageReorderable :: (MonadIO m, IsNotebookPage o) => o -> Bool -> m ()
setNotebookPageReorderable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "reorderable" val

-- | Construct a t'GValueConstruct' with valid value for the “@reorderable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageReorderable :: (IsNotebookPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookPageReorderable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "reorderable" val

#if defined(ENABLE_OVERLOADING)
data NotebookPageReorderablePropertyInfo
instance AttrInfo NotebookPageReorderablePropertyInfo where
    type AttrAllowedOps NotebookPageReorderablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NotebookPageReorderablePropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageReorderablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookPageReorderablePropertyInfo = (~) Bool
    type AttrTransferType NotebookPageReorderablePropertyInfo = Bool
    type AttrGetType NotebookPageReorderablePropertyInfo = Bool
    type AttrLabel NotebookPageReorderablePropertyInfo = "reorderable"
    type AttrOrigin NotebookPageReorderablePropertyInfo = NotebookPage
    attrGet = getNotebookPageReorderable
    attrSet = setNotebookPageReorderable
    attrPut = setNotebookPageReorderable
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageReorderable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.reorderable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:reorderable"
        })
#endif

-- VVV Prop "tab"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@tab@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #tab
-- @
getNotebookPageTab :: (MonadIO m, IsNotebookPage o) => o -> m (Maybe Gtk.Widget.Widget)
getNotebookPageTab obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "tab" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@tab@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageTab :: (IsNotebookPage o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructNotebookPageTab val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "tab" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data NotebookPageTabPropertyInfo
instance AttrInfo NotebookPageTabPropertyInfo where
    type AttrAllowedOps NotebookPageTabPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPageTabPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageTabPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint NotebookPageTabPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType NotebookPageTabPropertyInfo = Gtk.Widget.Widget
    type AttrGetType NotebookPageTabPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel NotebookPageTabPropertyInfo = "tab"
    type AttrOrigin NotebookPageTabPropertyInfo = NotebookPage
    attrGet = getNotebookPageTab
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructNotebookPageTab
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.tab"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:tab"
        })
#endif

-- VVV Prop "tab-expand"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@tab-expand@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #tabExpand
-- @
getNotebookPageTabExpand :: (MonadIO m, IsNotebookPage o) => o -> m Bool
getNotebookPageTabExpand obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "tab-expand"

-- | Set the value of the “@tab-expand@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #tabExpand 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageTabExpand :: (MonadIO m, IsNotebookPage o) => o -> Bool -> m ()
setNotebookPageTabExpand obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "tab-expand" val

-- | Construct a t'GValueConstruct' with valid value for the “@tab-expand@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageTabExpand :: (IsNotebookPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookPageTabExpand val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "tab-expand" val

#if defined(ENABLE_OVERLOADING)
data NotebookPageTabExpandPropertyInfo
instance AttrInfo NotebookPageTabExpandPropertyInfo where
    type AttrAllowedOps NotebookPageTabExpandPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NotebookPageTabExpandPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageTabExpandPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookPageTabExpandPropertyInfo = (~) Bool
    type AttrTransferType NotebookPageTabExpandPropertyInfo = Bool
    type AttrGetType NotebookPageTabExpandPropertyInfo = Bool
    type AttrLabel NotebookPageTabExpandPropertyInfo = "tab-expand"
    type AttrOrigin NotebookPageTabExpandPropertyInfo = NotebookPage
    attrGet = getNotebookPageTabExpand
    attrSet = setNotebookPageTabExpand
    attrPut = setNotebookPageTabExpand
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageTabExpand
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.tabExpand"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:tabExpand"
        })
#endif

-- VVV Prop "tab-fill"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@tab-fill@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #tabFill
-- @
getNotebookPageTabFill :: (MonadIO m, IsNotebookPage o) => o -> m Bool
getNotebookPageTabFill obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "tab-fill"

-- | Set the value of the “@tab-fill@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #tabFill 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageTabFill :: (MonadIO m, IsNotebookPage o) => o -> Bool -> m ()
setNotebookPageTabFill obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "tab-fill" val

-- | Construct a t'GValueConstruct' with valid value for the “@tab-fill@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageTabFill :: (IsNotebookPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructNotebookPageTabFill val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "tab-fill" val

#if defined(ENABLE_OVERLOADING)
data NotebookPageTabFillPropertyInfo
instance AttrInfo NotebookPageTabFillPropertyInfo where
    type AttrAllowedOps NotebookPageTabFillPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint NotebookPageTabFillPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageTabFillPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint NotebookPageTabFillPropertyInfo = (~) Bool
    type AttrTransferType NotebookPageTabFillPropertyInfo = Bool
    type AttrGetType NotebookPageTabFillPropertyInfo = Bool
    type AttrLabel NotebookPageTabFillPropertyInfo = "tab-fill"
    type AttrOrigin NotebookPageTabFillPropertyInfo = NotebookPage
    attrGet = getNotebookPageTabFill
    attrSet = setNotebookPageTabFill
    attrPut = setNotebookPageTabFill
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageTabFill
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.tabFill"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:tabFill"
        })
#endif

-- VVV Prop "tab-label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@tab-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' notebookPage #tabLabel
-- @
getNotebookPageTabLabel :: (MonadIO m, IsNotebookPage o) => o -> m (Maybe T.Text)
getNotebookPageTabLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "tab-label"

-- | Set the value of the “@tab-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' notebookPage [ #tabLabel 'Data.GI.Base.Attributes.:=' value ]
-- @
setNotebookPageTabLabel :: (MonadIO m, IsNotebookPage o) => o -> T.Text -> m ()
setNotebookPageTabLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "tab-label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@tab-label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNotebookPageTabLabel :: (IsNotebookPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructNotebookPageTabLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "tab-label" (P.Just val)

-- | Set the value of the “@tab-label@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #tabLabel
-- @
clearNotebookPageTabLabel :: (MonadIO m, IsNotebookPage o) => o -> m ()
clearNotebookPageTabLabel obj = liftIO $ B.Properties.setObjectPropertyString obj "tab-label" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data NotebookPageTabLabelPropertyInfo
instance AttrInfo NotebookPageTabLabelPropertyInfo where
    type AttrAllowedOps NotebookPageTabLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NotebookPageTabLabelPropertyInfo = IsNotebookPage
    type AttrSetTypeConstraint NotebookPageTabLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint NotebookPageTabLabelPropertyInfo = (~) T.Text
    type AttrTransferType NotebookPageTabLabelPropertyInfo = T.Text
    type AttrGetType NotebookPageTabLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel NotebookPageTabLabelPropertyInfo = "tab-label"
    type AttrOrigin NotebookPageTabLabelPropertyInfo = NotebookPage
    attrGet = getNotebookPageTabLabel
    attrSet = setNotebookPageTabLabel
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructNotebookPageTabLabel
    attrClear = clearNotebookPageTabLabel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.tabLabel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#g:attr:tabLabel"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NotebookPage
type instance O.AttributeList NotebookPage = NotebookPageAttributeList
type NotebookPageAttributeList = ('[ '("child", NotebookPageChildPropertyInfo), '("detachable", NotebookPageDetachablePropertyInfo), '("menu", NotebookPageMenuPropertyInfo), '("menuLabel", NotebookPageMenuLabelPropertyInfo), '("position", NotebookPagePositionPropertyInfo), '("reorderable", NotebookPageReorderablePropertyInfo), '("tab", NotebookPageTabPropertyInfo), '("tabExpand", NotebookPageTabExpandPropertyInfo), '("tabFill", NotebookPageTabFillPropertyInfo), '("tabLabel", NotebookPageTabLabelPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
notebookPageChild :: AttrLabelProxy "child"
notebookPageChild = AttrLabelProxy

notebookPageDetachable :: AttrLabelProxy "detachable"
notebookPageDetachable = AttrLabelProxy

notebookPageMenu :: AttrLabelProxy "menu"
notebookPageMenu = AttrLabelProxy

notebookPageMenuLabel :: AttrLabelProxy "menuLabel"
notebookPageMenuLabel = AttrLabelProxy

notebookPagePosition :: AttrLabelProxy "position"
notebookPagePosition = AttrLabelProxy

notebookPageReorderable :: AttrLabelProxy "reorderable"
notebookPageReorderable = AttrLabelProxy

notebookPageTab :: AttrLabelProxy "tab"
notebookPageTab = AttrLabelProxy

notebookPageTabExpand :: AttrLabelProxy "tabExpand"
notebookPageTabExpand = AttrLabelProxy

notebookPageTabFill :: AttrLabelProxy "tabFill"
notebookPageTabFill = AttrLabelProxy

notebookPageTabLabel :: AttrLabelProxy "tabLabel"
notebookPageTabLabel = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NotebookPage = NotebookPageSignalList
type NotebookPageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NotebookPage::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "page"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NotebookPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkNotebookPage`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_notebook_page_get_child" gtk_notebook_page_get_child :: 
    Ptr NotebookPage ->                     -- page : TInterface (Name {namespace = "Gtk", name = "NotebookPage"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the notebook child to which /@page@/ belongs.
notebookPageGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsNotebookPage a) =>
    a
    -- ^ /@page@/: a @GtkNotebookPage@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the child to which /@page@/ belongs
notebookPageGetChild page = liftIO $ do
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_notebook_page_get_child page'
    checkUnexpectedReturnNULL "notebookPageGetChild" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr page
    return result'

#if defined(ENABLE_OVERLOADING)
data NotebookPageGetChildMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsNotebookPage a) => O.OverloadedMethod NotebookPageGetChildMethodInfo a signature where
    overloadedMethod = notebookPageGetChild

instance O.OverloadedMethodInfo NotebookPageGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NotebookPage.notebookPageGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NotebookPage.html#v:notebookPageGetChild"
        })


#endif


