{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Display
    ( 

-- * Exported types
    X11Display(..)                          ,
    IsX11Display                            ,
    toX11Display                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Display#g:method:beep"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gdk.Objects.Display#g:method:close"), [createGlContext]("GI.Gdk.Objects.Display#g:method:createGlContext"), [deviceIsGrabbed]("GI.Gdk.Objects.Display#g:method:deviceIsGrabbed"), [errorTrapPop]("GI.GdkX11.Objects.X11Display#g:method:errorTrapPop"), [errorTrapPopIgnored]("GI.GdkX11.Objects.X11Display#g:method:errorTrapPopIgnored"), [errorTrapPush]("GI.GdkX11.Objects.X11Display#g:method:errorTrapPush"), [flush]("GI.Gdk.Objects.Display#g:method:flush"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grab]("GI.GdkX11.Objects.X11Display#g:method:grab"), [isClosed]("GI.Gdk.Objects.Display#g:method:isClosed"), [isComposited]("GI.Gdk.Objects.Display#g:method:isComposited"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRgba]("GI.Gdk.Objects.Display#g:method:isRgba"), [listSeats]("GI.Gdk.Objects.Display#g:method:listSeats"), [mapKeycode]("GI.Gdk.Objects.Display#g:method:mapKeycode"), [mapKeyval]("GI.Gdk.Objects.Display#g:method:mapKeyval"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStartupComplete]("GI.Gdk.Objects.Display#g:method:notifyStartupComplete"), [prepareGl]("GI.Gdk.Objects.Display#g:method:prepareGl"), [putEvent]("GI.Gdk.Objects.Display#g:method:putEvent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stringToCompoundText]("GI.GdkX11.Objects.X11Display#g:method:stringToCompoundText"), [supportsInputShapes]("GI.Gdk.Objects.Display#g:method:supportsInputShapes"), [supportsShadowWidth]("GI.Gdk.Objects.Display#g:method:supportsShadowWidth"), [sync]("GI.Gdk.Objects.Display#g:method:sync"), [textPropertyToTextList]("GI.GdkX11.Objects.X11Display#g:method:textPropertyToTextList"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateKey]("GI.Gdk.Objects.Display#g:method:translateKey"), [ungrab]("GI.GdkX11.Objects.X11Display#g:method:ungrab"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [utf8ToCompoundText]("GI.GdkX11.Objects.X11Display#g:method:utf8ToCompoundText"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAppLaunchContext]("GI.Gdk.Objects.Display#g:method:getAppLaunchContext"), [getClipboard]("GI.Gdk.Objects.Display#g:method:getClipboard"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultGroup]("GI.GdkX11.Objects.X11Display#g:method:getDefaultGroup"), [getDefaultSeat]("GI.Gdk.Objects.Display#g:method:getDefaultSeat"), [getDmabufFormats]("GI.Gdk.Objects.Display#g:method:getDmabufFormats"), [getEglDisplay]("GI.GdkX11.Objects.X11Display#g:method:getEglDisplay"), [getEglVersion]("GI.GdkX11.Objects.X11Display#g:method:getEglVersion"), [getGlxVersion]("GI.GdkX11.Objects.X11Display#g:method:getGlxVersion"), [getMonitorAtSurface]("GI.Gdk.Objects.Display#g:method:getMonitorAtSurface"), [getMonitors]("GI.Gdk.Objects.Display#g:method:getMonitors"), [getName]("GI.Gdk.Objects.Display#g:method:getName"), [getPrimaryClipboard]("GI.Gdk.Objects.Display#g:method:getPrimaryClipboard"), [getPrimaryMonitor]("GI.GdkX11.Objects.X11Display#g:method:getPrimaryMonitor"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScreen]("GI.GdkX11.Objects.X11Display#g:method:getScreen"), [getSetting]("GI.Gdk.Objects.Display#g:method:getSetting"), [getStartupNotificationId]("GI.GdkX11.Objects.X11Display#g:method:getStartupNotificationId"), [getUserTime]("GI.GdkX11.Objects.X11Display#g:method:getUserTime"), [getXcursor]("GI.GdkX11.Objects.X11Display#g:method:getXcursor"), [getXdisplay]("GI.GdkX11.Objects.X11Display#g:method:getXdisplay"), [getXrootwindow]("GI.GdkX11.Objects.X11Display#g:method:getXrootwindow"), [getXscreen]("GI.GdkX11.Objects.X11Display#g:method:getXscreen").
-- 
-- ==== Setters
-- [setCursorTheme]("GI.GdkX11.Objects.X11Display#g:method:setCursorTheme"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStartupNotificationId]("GI.GdkX11.Objects.X11Display#g:method:setStartupNotificationId"), [setSurfaceScale]("GI.GdkX11.Objects.X11Display#g:method:setSurfaceScale").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DisplayMethod                 ,
#endif

-- ** errorTrapPop #method:errorTrapPop#

#if defined(ENABLE_OVERLOADING)
    X11DisplayErrorTrapPopMethodInfo        ,
#endif
    x11DisplayErrorTrapPop                  ,


-- ** errorTrapPopIgnored #method:errorTrapPopIgnored#

#if defined(ENABLE_OVERLOADING)
    X11DisplayErrorTrapPopIgnoredMethodInfo ,
#endif
    x11DisplayErrorTrapPopIgnored           ,


-- ** errorTrapPush #method:errorTrapPush#

#if defined(ENABLE_OVERLOADING)
    X11DisplayErrorTrapPushMethodInfo       ,
#endif
    x11DisplayErrorTrapPush                 ,


-- ** getDefaultGroup #method:getDefaultGroup#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetDefaultGroupMethodInfo     ,
#endif
    x11DisplayGetDefaultGroup               ,


-- ** getEglDisplay #method:getEglDisplay#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetEglDisplayMethodInfo       ,
#endif
    x11DisplayGetEglDisplay                 ,


-- ** getEglVersion #method:getEglVersion#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetEglVersionMethodInfo       ,
#endif
    x11DisplayGetEglVersion                 ,


-- ** getGlxVersion #method:getGlxVersion#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetGlxVersionMethodInfo       ,
#endif
    x11DisplayGetGlxVersion                 ,


-- ** getPrimaryMonitor #method:getPrimaryMonitor#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetPrimaryMonitorMethodInfo   ,
#endif
    x11DisplayGetPrimaryMonitor             ,


-- ** getScreen #method:getScreen#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetScreenMethodInfo           ,
#endif
    x11DisplayGetScreen                     ,


-- ** getStartupNotificationId #method:getStartupNotificationId#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetStartupNotificationIdMethodInfo,
#endif
    x11DisplayGetStartupNotificationId      ,


-- ** getUserTime #method:getUserTime#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetUserTimeMethodInfo         ,
#endif
    x11DisplayGetUserTime                   ,


-- ** getXcursor #method:getXcursor#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetXcursorMethodInfo          ,
#endif
    x11DisplayGetXcursor                    ,


-- ** getXdisplay #method:getXdisplay#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetXdisplayMethodInfo         ,
#endif
    x11DisplayGetXdisplay                   ,


-- ** getXrootwindow #method:getXrootwindow#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetXrootwindowMethodInfo      ,
#endif
    x11DisplayGetXrootwindow                ,


-- ** getXscreen #method:getXscreen#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGetXscreenMethodInfo          ,
#endif
    x11DisplayGetXscreen                    ,


-- ** grab #method:grab#

#if defined(ENABLE_OVERLOADING)
    X11DisplayGrabMethodInfo                ,
#endif
    x11DisplayGrab                          ,


-- ** open #method:open#

    x11DisplayOpen                          ,


-- ** setCursorTheme #method:setCursorTheme#

#if defined(ENABLE_OVERLOADING)
    X11DisplaySetCursorThemeMethodInfo      ,
#endif
    x11DisplaySetCursorTheme                ,


-- ** setProgramClass #method:setProgramClass#

    x11DisplaySetProgramClass               ,


-- ** setStartupNotificationId #method:setStartupNotificationId#

#if defined(ENABLE_OVERLOADING)
    X11DisplaySetStartupNotificationIdMethodInfo,
#endif
    x11DisplaySetStartupNotificationId      ,


-- ** setSurfaceScale #method:setSurfaceScale#

#if defined(ENABLE_OVERLOADING)
    X11DisplaySetSurfaceScaleMethodInfo     ,
#endif
    x11DisplaySetSurfaceScale               ,


-- ** stringToCompoundText #method:stringToCompoundText#

#if defined(ENABLE_OVERLOADING)
    X11DisplayStringToCompoundTextMethodInfo,
#endif
    x11DisplayStringToCompoundText          ,


-- ** textPropertyToTextList #method:textPropertyToTextList#

#if defined(ENABLE_OVERLOADING)
    X11DisplayTextPropertyToTextListMethodInfo,
#endif
    x11DisplayTextPropertyToTextList        ,


-- ** ungrab #method:ungrab#

#if defined(ENABLE_OVERLOADING)
    X11DisplayUngrabMethodInfo              ,
#endif
    x11DisplayUngrab                        ,


-- ** utf8ToCompoundText #method:utf8ToCompoundText#

#if defined(ENABLE_OVERLOADING)
    X11DisplayUtf8ToCompoundTextMethodInfo  ,
#endif
    x11DisplayUtf8ToCompoundText            ,




 -- * Signals


-- ** xevent #signal:xevent#

    X11DisplayXeventCallback                ,
#if defined(ENABLE_OVERLOADING)
    X11DisplayXeventSignalInfo              ,
#endif
    afterX11DisplayXevent                   ,
    onX11DisplayXevent                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Screen as GdkX11.X11Screen
import qualified GI.Xlib.Structs.Display as Xlib.Display
import qualified GI.Xlib.Structs.Screen as Xlib.Screen

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Screen as GdkX11.X11Screen
import qualified GI.Xlib.Structs.Display as Xlib.Display
import qualified GI.Xlib.Structs.Screen as Xlib.Screen

#endif

-- | Memory-managed wrapper type.
newtype X11Display = X11Display (SP.ManagedPtr X11Display)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Display where
    toManagedPtr (X11Display p) = p

foreign import ccall "gdk_x11_display_get_type"
    c_gdk_x11_display_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Display where
    glibType = c_gdk_x11_display_get_type

instance B.Types.GObject X11Display

-- | Type class for types which can be safely cast to t'X11Display', for instance with `toX11Display`.
class (SP.GObject o, O.IsDescendantOf X11Display o) => IsX11Display o
instance (SP.GObject o, O.IsDescendantOf X11Display o) => IsX11Display o

instance O.HasParentTypes X11Display
type instance O.ParentTypes X11Display = '[Gdk.Display.Display, GObject.Object.Object]

-- | Cast to t'X11Display', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11Display :: (MIO.MonadIO m, IsX11Display o) => o -> m X11Display
toX11Display = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Display

-- | Convert t'X11Display' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Display) where
    gvalueGType_ = c_gdk_x11_display_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Display)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Display)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Display ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DisplayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DisplayMethod "beep" o = Gdk.Display.DisplayBeepMethodInfo
    ResolveX11DisplayMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DisplayMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DisplayMethod "close" o = Gdk.Display.DisplayCloseMethodInfo
    ResolveX11DisplayMethod "createGlContext" o = Gdk.Display.DisplayCreateGlContextMethodInfo
    ResolveX11DisplayMethod "deviceIsGrabbed" o = Gdk.Display.DisplayDeviceIsGrabbedMethodInfo
    ResolveX11DisplayMethod "errorTrapPop" o = X11DisplayErrorTrapPopMethodInfo
    ResolveX11DisplayMethod "errorTrapPopIgnored" o = X11DisplayErrorTrapPopIgnoredMethodInfo
    ResolveX11DisplayMethod "errorTrapPush" o = X11DisplayErrorTrapPushMethodInfo
    ResolveX11DisplayMethod "flush" o = Gdk.Display.DisplayFlushMethodInfo
    ResolveX11DisplayMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DisplayMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DisplayMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DisplayMethod "grab" o = X11DisplayGrabMethodInfo
    ResolveX11DisplayMethod "isClosed" o = Gdk.Display.DisplayIsClosedMethodInfo
    ResolveX11DisplayMethod "isComposited" o = Gdk.Display.DisplayIsCompositedMethodInfo
    ResolveX11DisplayMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DisplayMethod "isRgba" o = Gdk.Display.DisplayIsRgbaMethodInfo
    ResolveX11DisplayMethod "listSeats" o = Gdk.Display.DisplayListSeatsMethodInfo
    ResolveX11DisplayMethod "mapKeycode" o = Gdk.Display.DisplayMapKeycodeMethodInfo
    ResolveX11DisplayMethod "mapKeyval" o = Gdk.Display.DisplayMapKeyvalMethodInfo
    ResolveX11DisplayMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DisplayMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DisplayMethod "notifyStartupComplete" o = Gdk.Display.DisplayNotifyStartupCompleteMethodInfo
    ResolveX11DisplayMethod "prepareGl" o = Gdk.Display.DisplayPrepareGlMethodInfo
    ResolveX11DisplayMethod "putEvent" o = Gdk.Display.DisplayPutEventMethodInfo
    ResolveX11DisplayMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DisplayMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DisplayMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DisplayMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DisplayMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DisplayMethod "stringToCompoundText" o = X11DisplayStringToCompoundTextMethodInfo
    ResolveX11DisplayMethod "supportsInputShapes" o = Gdk.Display.DisplaySupportsInputShapesMethodInfo
    ResolveX11DisplayMethod "supportsShadowWidth" o = Gdk.Display.DisplaySupportsShadowWidthMethodInfo
    ResolveX11DisplayMethod "sync" o = Gdk.Display.DisplaySyncMethodInfo
    ResolveX11DisplayMethod "textPropertyToTextList" o = X11DisplayTextPropertyToTextListMethodInfo
    ResolveX11DisplayMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DisplayMethod "translateKey" o = Gdk.Display.DisplayTranslateKeyMethodInfo
    ResolveX11DisplayMethod "ungrab" o = X11DisplayUngrabMethodInfo
    ResolveX11DisplayMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DisplayMethod "utf8ToCompoundText" o = X11DisplayUtf8ToCompoundTextMethodInfo
    ResolveX11DisplayMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DisplayMethod "getAppLaunchContext" o = Gdk.Display.DisplayGetAppLaunchContextMethodInfo
    ResolveX11DisplayMethod "getClipboard" o = Gdk.Display.DisplayGetClipboardMethodInfo
    ResolveX11DisplayMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DisplayMethod "getDefaultGroup" o = X11DisplayGetDefaultGroupMethodInfo
    ResolveX11DisplayMethod "getDefaultSeat" o = Gdk.Display.DisplayGetDefaultSeatMethodInfo
    ResolveX11DisplayMethod "getDmabufFormats" o = Gdk.Display.DisplayGetDmabufFormatsMethodInfo
    ResolveX11DisplayMethod "getEglDisplay" o = X11DisplayGetEglDisplayMethodInfo
    ResolveX11DisplayMethod "getEglVersion" o = X11DisplayGetEglVersionMethodInfo
    ResolveX11DisplayMethod "getGlxVersion" o = X11DisplayGetGlxVersionMethodInfo
    ResolveX11DisplayMethod "getMonitorAtSurface" o = Gdk.Display.DisplayGetMonitorAtSurfaceMethodInfo
    ResolveX11DisplayMethod "getMonitors" o = Gdk.Display.DisplayGetMonitorsMethodInfo
    ResolveX11DisplayMethod "getName" o = Gdk.Display.DisplayGetNameMethodInfo
    ResolveX11DisplayMethod "getPrimaryClipboard" o = Gdk.Display.DisplayGetPrimaryClipboardMethodInfo
    ResolveX11DisplayMethod "getPrimaryMonitor" o = X11DisplayGetPrimaryMonitorMethodInfo
    ResolveX11DisplayMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DisplayMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DisplayMethod "getScreen" o = X11DisplayGetScreenMethodInfo
    ResolveX11DisplayMethod "getSetting" o = Gdk.Display.DisplayGetSettingMethodInfo
    ResolveX11DisplayMethod "getStartupNotificationId" o = X11DisplayGetStartupNotificationIdMethodInfo
    ResolveX11DisplayMethod "getUserTime" o = X11DisplayGetUserTimeMethodInfo
    ResolveX11DisplayMethod "getXcursor" o = X11DisplayGetXcursorMethodInfo
    ResolveX11DisplayMethod "getXdisplay" o = X11DisplayGetXdisplayMethodInfo
    ResolveX11DisplayMethod "getXrootwindow" o = X11DisplayGetXrootwindowMethodInfo
    ResolveX11DisplayMethod "getXscreen" o = X11DisplayGetXscreenMethodInfo
    ResolveX11DisplayMethod "setCursorTheme" o = X11DisplaySetCursorThemeMethodInfo
    ResolveX11DisplayMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DisplayMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DisplayMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DisplayMethod "setStartupNotificationId" o = X11DisplaySetStartupNotificationIdMethodInfo
    ResolveX11DisplayMethod "setSurfaceScale" o = X11DisplaySetSurfaceScaleMethodInfo
    ResolveX11DisplayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DisplayMethod t X11Display, O.OverloadedMethod info X11Display p) => OL.IsLabel t (X11Display -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DisplayMethod t X11Display, O.OverloadedMethod info X11Display p, R.HasField t X11Display p) => R.HasField t X11Display p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DisplayMethod t X11Display, O.OverloadedMethodInfo info X11Display) => OL.IsLabel t (O.MethodProxy info X11Display) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal X11Display::xevent
-- | The [xevent](#g:signal:xevent) signal is a low level signal that is emitted
-- whenever an XEvent has been received.
-- 
-- When handlers to this signal return 'P.True', no other handlers will be
-- invoked. In particular, the default handler for this function is
-- GDK\'s own event handling mechanism, so by returning 'P.True' for an event
-- that GDK expects to translate, you may break GDK and\/or GTK+ in
-- interesting ways. You have been warned.
-- 
-- If you want this signal handler to queue a @GdkEvent@, you can use
-- 'GI.Gdk.Objects.Display.displayPutEvent'.
-- 
-- If you are interested in X GenericEvents, bear in mind that
-- @/XGetEventData()/@ has been already called on the event, and
-- @/XFreeEventData()/@ will be called afterwards.
type X11DisplayXeventCallback =
    Ptr ()
    -- ^ /@xevent@/: a pointer to the XEvent to process
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop other handlers from being invoked for the event.
    --   'P.False' to propagate the event further.

type C_X11DisplayXeventCallback =
    Ptr X11Display ->                       -- object
    Ptr () ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_X11DisplayXeventCallback`.
foreign import ccall "wrapper"
    mk_X11DisplayXeventCallback :: C_X11DisplayXeventCallback -> IO (FunPtr C_X11DisplayXeventCallback)

wrap_X11DisplayXeventCallback :: 
    GObject a => (a -> X11DisplayXeventCallback) ->
    C_X11DisplayXeventCallback
wrap_X11DisplayXeventCallback gi'cb gi'selfPtr xevent _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  xevent
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [xevent](#signal:xevent) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' x11Display #xevent callback
-- @
-- 
-- 
onX11DisplayXevent :: (IsX11Display a, MonadIO m) => a -> ((?self :: a) => X11DisplayXeventCallback) -> m SignalHandlerId
onX11DisplayXevent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_X11DisplayXeventCallback wrapped
    wrapped'' <- mk_X11DisplayXeventCallback wrapped'
    connectSignalFunPtr obj "xevent" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [xevent](#signal:xevent) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' x11Display #xevent callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterX11DisplayXevent :: (IsX11Display a, MonadIO m) => a -> ((?self :: a) => X11DisplayXeventCallback) -> m SignalHandlerId
afterX11DisplayXevent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_X11DisplayXeventCallback wrapped
    wrapped'' <- mk_X11DisplayXeventCallback wrapped'
    connectSignalFunPtr obj "xevent" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data X11DisplayXeventSignalInfo
instance SignalInfo X11DisplayXeventSignalInfo where
    type HaskellCallbackType X11DisplayXeventSignalInfo = X11DisplayXeventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_X11DisplayXeventCallback cb
        cb'' <- mk_X11DisplayXeventCallback cb'
        connectSignalFunPtr obj "xevent" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display::xevent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#g:signal:xevent"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Display
type instance O.AttributeList X11Display = X11DisplayAttributeList
type X11DisplayAttributeList = ('[ '("composited", Gdk.Display.DisplayCompositedPropertyInfo), '("dmabufFormats", Gdk.Display.DisplayDmabufFormatsPropertyInfo), '("inputShapes", Gdk.Display.DisplayInputShapesPropertyInfo), '("rgba", Gdk.Display.DisplayRgbaPropertyInfo), '("shadowWidth", Gdk.Display.DisplayShadowWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Display = X11DisplaySignalList
type X11DisplaySignalList = ('[ '("closed", Gdk.Display.DisplayClosedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("opened", Gdk.Display.DisplayOpenedSignalInfo), '("seatAdded", Gdk.Display.DisplaySeatAddedSignalInfo), '("seatRemoved", Gdk.Display.DisplaySeatRemovedSignalInfo), '("settingChanged", Gdk.Display.DisplaySettingChangedSignalInfo), '("xevent", X11DisplayXeventSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Display::error_trap_pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the display" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_error_trap_pop" gdk_x11_display_error_trap_pop :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO Int32

-- | Pops the error trap pushed by 'GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPush'.
-- Will @/XSync()/@ if necessary and will always block until
-- the error is known to have occurred or not occurred,
-- so the error code can be returned.
-- 
-- If you don’t need to use the return value,
-- 'GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPopIgnored' would be more efficient.
x11DisplayErrorTrapPop ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: the display
    -> m Int32
    -- ^ __Returns:__ X error code or 0 on success
x11DisplayErrorTrapPop display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_error_trap_pop display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayErrorTrapPopMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayErrorTrapPopMethodInfo a signature where
    overloadedMethod = x11DisplayErrorTrapPop

instance O.OverloadedMethodInfo X11DisplayErrorTrapPopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayErrorTrapPop"
        })


#endif

-- method X11Display::error_trap_pop_ignored
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the display" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_error_trap_pop_ignored" gdk_x11_display_error_trap_pop_ignored :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO ()

-- | Pops the error trap pushed by 'GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPush'.
-- Does not block to see if an error occurred; merely records the
-- range of requests to ignore errors for, and ignores those errors
-- if they arrive asynchronously.
x11DisplayErrorTrapPopIgnored ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: the display
    -> m ()
x11DisplayErrorTrapPopIgnored display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_display_error_trap_pop_ignored display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplayErrorTrapPopIgnoredMethodInfo
instance (signature ~ (m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayErrorTrapPopIgnoredMethodInfo a signature where
    overloadedMethod = x11DisplayErrorTrapPopIgnored

instance O.OverloadedMethodInfo X11DisplayErrorTrapPopIgnoredMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPopIgnored",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayErrorTrapPopIgnored"
        })


#endif

-- method X11Display::error_trap_push
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_error_trap_push" gdk_x11_display_error_trap_push :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO ()

-- | Begins a range of X requests on /@display@/ for which X error events
-- will be ignored. Unignored errors (when no trap is pushed) will abort
-- the application. Use 'GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPop' or
-- 'GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPopIgnored'to lift a trap pushed
-- with this function.
x11DisplayErrorTrapPush ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
x11DisplayErrorTrapPush display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_display_error_trap_push display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplayErrorTrapPushMethodInfo
instance (signature ~ (m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayErrorTrapPushMethodInfo a signature where
    overloadedMethod = x11DisplayErrorTrapPush

instance O.OverloadedMethodInfo X11DisplayErrorTrapPushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayErrorTrapPush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayErrorTrapPush"
        })


#endif

-- method X11Display::get_default_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_default_group" gdk_x11_display_get_default_group :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr Gdk.Surface.Surface)

-- | Returns the default group leader surface for all toplevel surfaces
-- on /@display@/. This surface is implicitly created by GDK.
-- See 'GI.GdkX11.Objects.X11Surface.x11SurfaceSetGroup'.
x11DisplayGetDefaultGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.Surface.Surface
    -- ^ __Returns:__ The default group leader surface
    -- for /@display@/
x11DisplayGetDefaultGroup display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_default_group display'
    checkUnexpectedReturnNULL "x11DisplayGetDefaultGroup" result
    result' <- (newObject Gdk.Surface.Surface) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetDefaultGroupMethodInfo
instance (signature ~ (m Gdk.Surface.Surface), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetDefaultGroupMethodInfo a signature where
    overloadedMethod = x11DisplayGetDefaultGroup

instance O.OverloadedMethodInfo X11DisplayGetDefaultGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetDefaultGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetDefaultGroup"
        })


#endif

-- method X11Display::get_egl_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X11 display" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_egl_display" gdk_x11_display_get_egl_display :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr ())

{-# DEPRECATED x11DisplayGetEglDisplay ["(Since version 4.18)"] #-}
-- | Retrieves the EGL display connection object for the given GDK display.
-- 
-- This function returns @NULL@ if GDK is using GLX.
-- 
-- /Since: 4.4/
x11DisplayGetEglDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: an X11 display
    -> m (Ptr ())
    -- ^ __Returns:__ the EGL display object
x11DisplayGetEglDisplay display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_egl_display display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetEglDisplayMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetEglDisplayMethodInfo a signature where
    overloadedMethod = x11DisplayGetEglDisplay

instance O.OverloadedMethodInfo X11DisplayGetEglDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetEglDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetEglDisplay"
        })


#endif

-- method X11Display::get_egl_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "major"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the EGL major version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minor"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the EGL minor version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_egl_version" gdk_x11_display_get_egl_version :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Ptr Int32 ->                            -- major : TBasicType TInt
    Ptr Int32 ->                            -- minor : TBasicType TInt
    IO CInt

{-# DEPRECATED x11DisplayGetEglVersion ["(Since version 4.18)"] #-}
-- | Retrieves the version of the EGL implementation.
-- 
-- /Since: 4.4/
x11DisplayGetEglVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ 'P.True' if EGL is available
x11DisplayGetEglVersion display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    major <- allocMem :: IO (Ptr Int32)
    minor <- allocMem :: IO (Ptr Int32)
    result <- gdk_x11_display_get_egl_version display' major minor
    let result' = (/= 0) result
    major' <- peek major
    minor' <- peek minor
    touchManagedPtr display
    freeMem major
    freeMem minor
    return (result', major', minor')

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetEglVersionMethodInfo
instance (signature ~ (m ((Bool, Int32, Int32))), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetEglVersionMethodInfo a signature where
    overloadedMethod = x11DisplayGetEglVersion

instance O.OverloadedMethodInfo X11DisplayGetEglVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetEglVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetEglVersion"
        })


#endif

-- method X11Display::get_glx_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "major"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the GLX major version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minor"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the GLX minor version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_glx_version" gdk_x11_display_get_glx_version :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Ptr Int32 ->                            -- major : TBasicType TInt
    Ptr Int32 ->                            -- minor : TBasicType TInt
    IO CInt

{-# DEPRECATED x11DisplayGetGlxVersion ["(Since version 4.18)"] #-}
-- | Retrieves the version of the GLX implementation.
x11DisplayGetGlxVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ 'P.True' if GLX is available
x11DisplayGetGlxVersion display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    major <- allocMem :: IO (Ptr Int32)
    minor <- allocMem :: IO (Ptr Int32)
    result <- gdk_x11_display_get_glx_version display' major minor
    let result' = (/= 0) result
    major' <- peek major
    minor' <- peek minor
    touchManagedPtr display
    freeMem major
    freeMem minor
    return (result', major', minor')

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetGlxVersionMethodInfo
instance (signature ~ (m ((Bool, Int32, Int32))), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetGlxVersionMethodInfo a signature where
    overloadedMethod = x11DisplayGetGlxVersion

instance O.OverloadedMethodInfo X11DisplayGetGlxVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetGlxVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetGlxVersion"
        })


#endif

-- method X11Display::get_primary_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_primary_monitor" gdk_x11_display_get_primary_monitor :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets the primary monitor for the display.
-- 
-- The primary monitor is considered the monitor where the “main desktop”
-- lives. While normal application surfaces typically allow the window
-- manager to place the surfaces, specialized desktop applications
-- such as panels should place themselves on the primary monitor.
-- 
-- If no monitor is the designated primary monitor, any monitor
-- (usually the first) may be returned.
x11DisplayGetPrimaryMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.Monitor.Monitor
    -- ^ __Returns:__ the primary monitor, or any monitor if no
    --   primary monitor is configured by the user
x11DisplayGetPrimaryMonitor display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_primary_monitor display'
    checkUnexpectedReturnNULL "x11DisplayGetPrimaryMonitor" result
    result' <- (newObject Gdk.Monitor.Monitor) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetPrimaryMonitorMethodInfo
instance (signature ~ (m Gdk.Monitor.Monitor), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetPrimaryMonitorMethodInfo a signature where
    overloadedMethod = x11DisplayGetPrimaryMonitor

instance O.OverloadedMethodInfo X11DisplayGetPrimaryMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetPrimaryMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetPrimaryMonitor"
        })


#endif

-- method X11Display::get_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkX11Display`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_screen" gdk_x11_display_get_screen :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr GdkX11.X11Screen.X11Screen)

-- | Retrieves the @GdkX11Screen@ of the /@display@/.
x11DisplayGetScreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkX11Display@
    -> m GdkX11.X11Screen.X11Screen
    -- ^ __Returns:__ the @GdkX11Screen@
x11DisplayGetScreen display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_screen display'
    checkUnexpectedReturnNULL "x11DisplayGetScreen" result
    result' <- (newObject GdkX11.X11Screen.X11Screen) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetScreenMethodInfo
instance (signature ~ (m GdkX11.X11Screen.X11Screen), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetScreenMethodInfo a signature where
    overloadedMethod = x11DisplayGetScreen

instance O.OverloadedMethodInfo X11DisplayGetScreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetScreen"
        })


#endif

-- method X11Display::get_startup_notification_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_startup_notification_id" gdk_x11_display_get_startup_notification_id :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO CString

{-# DEPRECATED x11DisplayGetStartupNotificationId ["(Since version 4.10)"] #-}
-- | Gets the startup notification ID for a display.
x11DisplayGetStartupNotificationId ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m T.Text
    -- ^ __Returns:__ the startup notification ID for /@display@/
x11DisplayGetStartupNotificationId display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_startup_notification_id display'
    checkUnexpectedReturnNULL "x11DisplayGetStartupNotificationId" result
    result' <- cstringToText result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetStartupNotificationIdMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetStartupNotificationIdMethodInfo a signature where
    overloadedMethod = x11DisplayGetStartupNotificationId

instance O.OverloadedMethodInfo X11DisplayGetStartupNotificationIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetStartupNotificationId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetStartupNotificationId"
        })


#endif

-- method X11Display::get_user_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_user_time" gdk_x11_display_get_user_time :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO Word32

-- | Returns the timestamp of the last user interaction on
-- /@display@/. The timestamp is taken from events caused
-- by user interaction such as key presses or pointer
-- movements. See 'GI.GdkX11.Objects.X11Surface.x11SurfaceSetUserTime'.
x11DisplayGetUserTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Word32
    -- ^ __Returns:__ the timestamp of the last user interaction
x11DisplayGetUserTime display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_user_time display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetUserTimeMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetUserTimeMethodInfo a signature where
    overloadedMethod = x11DisplayGetUserTime

instance O.OverloadedMethodInfo X11DisplayGetUserTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetUserTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetUserTime"
        })


#endif

-- method X11Display::get_xcursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkCursor`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_xcursor" gdk_x11_display_get_xcursor :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    IO FCT.CULong

{-# DEPRECATED x11DisplayGetXcursor ["(Since version 4.18)"] #-}
-- | Returns the X cursor belonging to a @GdkCursor@, potentially
-- creating the cursor.
-- 
-- Be aware that the returned cursor may not be unique to /@cursor@/.
-- It may for example be shared with its fallback cursor. On old
-- X servers that don\'t support the XCursor extension, all cursors
-- may even fall back to a few default cursors.
x11DisplayGetXcursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a, Gdk.Cursor.IsCursor b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@cursor@/: a @GdkCursor@
    -> m FCT.CULong
    -- ^ __Returns:__ an Xlib Cursor.
x11DisplayGetXcursor display cursor = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    cursor' <- unsafeManagedPtrCastPtr cursor
    result <- gdk_x11_display_get_xcursor display' cursor'
    touchManagedPtr display
    touchManagedPtr cursor
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetXcursorMethodInfo
instance (signature ~ (b -> m FCT.CULong), MonadIO m, IsX11Display a, Gdk.Cursor.IsCursor b) => O.OverloadedMethod X11DisplayGetXcursorMethodInfo a signature where
    overloadedMethod = x11DisplayGetXcursor

instance O.OverloadedMethodInfo X11DisplayGetXcursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetXcursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetXcursor"
        })


#endif

-- method X11Display::get_xdisplay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_xdisplay" gdk_x11_display_get_xdisplay :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr Xlib.Display.Display)

-- | Returns the X display of a @GdkDisplay@.
x11DisplayGetXdisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Xlib.Display.Display
    -- ^ __Returns:__ an X display
x11DisplayGetXdisplay display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_xdisplay display'
    checkUnexpectedReturnNULL "x11DisplayGetXdisplay" result
    result' <- (newPtr Xlib.Display.Display) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetXdisplayMethodInfo
instance (signature ~ (m Xlib.Display.Display), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetXdisplayMethodInfo a signature where
    overloadedMethod = x11DisplayGetXdisplay

instance O.OverloadedMethodInfo X11DisplayGetXdisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetXdisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetXdisplay"
        })


#endif

-- method X11Display::get_xrootwindow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_xrootwindow" gdk_x11_display_get_xrootwindow :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO FCT.CULong

-- | Returns the root X window used by @GdkDisplay@.
x11DisplayGetXrootwindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m FCT.CULong
    -- ^ __Returns:__ an X Window
x11DisplayGetXrootwindow display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_xrootwindow display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetXrootwindowMethodInfo
instance (signature ~ (m FCT.CULong), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetXrootwindowMethodInfo a signature where
    overloadedMethod = x11DisplayGetXrootwindow

instance O.OverloadedMethodInfo X11DisplayGetXrootwindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetXrootwindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetXrootwindow"
        })


#endif

-- method X11Display::get_xscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_get_xscreen" gdk_x11_display_get_xscreen :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO (Ptr Xlib.Screen.Screen)

-- | Returns the X Screen used by @GdkDisplay@.
x11DisplayGetXscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Xlib.Screen.Screen
    -- ^ __Returns:__ an X Screen
x11DisplayGetXscreen display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_display_get_xscreen display'
    checkUnexpectedReturnNULL "x11DisplayGetXscreen" result
    result' <- (newPtr Xlib.Screen.Screen) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data X11DisplayGetXscreenMethodInfo
instance (signature ~ (m Xlib.Screen.Screen), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGetXscreenMethodInfo a signature where
    overloadedMethod = x11DisplayGetXscreen

instance O.OverloadedMethodInfo X11DisplayGetXscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGetXscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGetXscreen"
        })


#endif

-- method X11Display::grab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_grab" gdk_x11_display_grab :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO ()

-- | Call @/XGrabServer()/@ on /@display@/.
-- To ungrab the display again, use 'GI.GdkX11.Objects.X11Display.x11DisplayUngrab'.
-- 
-- 'GI.GdkX11.Objects.X11Display.x11DisplayGrab'\/'GI.GdkX11.Objects.X11Display.x11DisplayUngrab' calls can be nested.
x11DisplayGrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
x11DisplayGrab display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_display_grab display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplayGrabMethodInfo
instance (signature ~ (m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayGrabMethodInfo a signature where
    overloadedMethod = x11DisplayGrab

instance O.OverloadedMethodInfo X11DisplayGrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayGrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayGrab"
        })


#endif

-- method X11Display::set_cursor_theme
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "theme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the name of the cursor theme to use, or %NULL\n  to unset a previously set value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the cursor size to use, or 0 to keep the previous size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_set_cursor_theme" gdk_x11_display_set_cursor_theme :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- theme : TBasicType TUTF8
    Int32 ->                                -- size : TBasicType TInt
    IO ()

{-# DEPRECATED x11DisplaySetCursorTheme ["(Since version 4.16)","Use the cursor-related properties of","  <http://developer.gnome.org/gdkx11/stable/../gtk4/class.Settings.html GtkSettings> to set the cursor theme"] #-}
-- | Sets the cursor theme from which the images for cursor
-- should be taken.
-- 
-- If the windowing system supports it, existing cursors created
-- with 'GI.Gdk.Objects.Cursor.cursorNewFromName' are updated to reflect the theme
-- change. Custom cursors constructed with 'GI.Gdk.Objects.Cursor.cursorNewFromTexture'
-- will have to be handled by the application (GTK applications can learn
-- about cursor theme changes by listening for change notification
-- for the corresponding @GtkSetting@).
x11DisplaySetCursorTheme ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> Maybe (T.Text)
    -- ^ /@theme@/: the name of the cursor theme to use, or 'P.Nothing'
    --   to unset a previously set value
    -> Int32
    -- ^ /@size@/: the cursor size to use, or 0 to keep the previous size
    -> m ()
x11DisplaySetCursorTheme display theme size = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    maybeTheme <- case theme of
        Nothing -> return FP.nullPtr
        Just jTheme -> do
            jTheme' <- textToCString jTheme
            return jTheme'
    gdk_x11_display_set_cursor_theme display' maybeTheme size
    touchManagedPtr display
    freeMem maybeTheme
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplaySetCursorThemeMethodInfo
instance (signature ~ (Maybe (T.Text) -> Int32 -> m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplaySetCursorThemeMethodInfo a signature where
    overloadedMethod = x11DisplaySetCursorTheme

instance O.OverloadedMethodInfo X11DisplaySetCursorThemeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplaySetCursorTheme",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplaySetCursorTheme"
        })


#endif

-- method X11Display::set_startup_notification_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the startup notification ID (must be valid utf8)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_set_startup_notification_id" gdk_x11_display_set_startup_notification_id :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

{-# DEPRECATED x11DisplaySetStartupNotificationId ["(Since version 4.10)","Using 'GI.Gdk.Interfaces.Toplevel.toplevelSetStartupId' is sufficient"] #-}
-- | Sets the startup notification ID for a display.
-- 
-- This is usually taken from the value of the DESKTOP_STARTUP_ID
-- environment variable, but in some cases (such as the application not
-- being launched using @/exec()/@) it can come from other sources.
-- 
-- If the ID contains the string \"_TIME\" then the portion following that
-- string is taken to be the X11 timestamp of the event that triggered
-- the application to be launched and the GDK current event time is set
-- accordingly.
-- 
-- The startup ID is also what is used to signal that the startup is
-- complete (for example, when opening a window or when calling
-- 'GI.Gdk.Objects.Display.displayNotifyStartupComplete').
x11DisplaySetStartupNotificationId ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@startupId@/: the startup notification ID (must be valid utf8)
    -> m ()
x11DisplaySetStartupNotificationId display startupId = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    startupId' <- textToCString startupId
    gdk_x11_display_set_startup_notification_id display' startupId'
    touchManagedPtr display
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplaySetStartupNotificationIdMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplaySetStartupNotificationIdMethodInfo a signature where
    overloadedMethod = x11DisplaySetStartupNotificationId

instance O.OverloadedMethodInfo X11DisplaySetStartupNotificationIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplaySetStartupNotificationId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplaySetStartupNotificationId"
        })


#endif

-- method X11Display::set_surface_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the display" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new scale value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_set_surface_scale" gdk_x11_display_set_surface_scale :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    Int32 ->                                -- scale : TBasicType TInt
    IO ()

-- | Forces a specific window scale for all windows on this display,
-- instead of using the default or user configured scale. This
-- is can be used to disable scaling support by setting /@scale@/ to
-- 1, or to programmatically set the window scale.
-- 
-- Once the scale is set by this call it will not change in response
-- to later user configuration changes.
x11DisplaySetSurfaceScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: the display
    -> Int32
    -- ^ /@scale@/: The new scale value
    -> m ()
x11DisplaySetSurfaceScale display scale = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_display_set_surface_scale display' scale
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplaySetSurfaceScaleMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplaySetSurfaceScaleMethodInfo a signature where
    overloadedMethod = x11DisplaySetSurfaceScale

instance O.OverloadedMethodInfo X11DisplaySetSurfaceScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplaySetSurfaceScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplaySetSurfaceScale"
        })


#endif

-- method X11Display::string_to_compound_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GdkDisplay` where the encoding is defined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "encoding"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the encoding\n  (to be used as the type for the property)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the format of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "ctext"
--           , argType = TCArray False (-1) 5 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store newly\n  allocated data for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of @ctext, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of @ctext, in bytes"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_string_to_compound_text" gdk_x11_display_string_to_compound_text :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- str : TBasicType TUTF8
    Ptr CString ->                          -- encoding : TBasicType TUTF8
    Ptr Int32 ->                            -- format : TBasicType TInt
    Ptr (Ptr Word8) ->                      -- ctext : TCArray False (-1) 5 (TBasicType TUInt8)
    Ptr Int32 ->                            -- length : TBasicType TInt
    IO Int32

{-# DEPRECATED x11DisplayStringToCompoundText ["(Since version 4.18)"] #-}
-- | Convert a string from the encoding of the current
-- locale into a form suitable for storing in a window property.
x11DisplayStringToCompoundText ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: the @GdkDisplay@ where the encoding is defined
    -> T.Text
    -- ^ /@str@/: a nul-terminated string
    -> m ((Int32, T.Text, Int32, ByteString))
    -- ^ __Returns:__ 0 upon success, non-zero upon failure
x11DisplayStringToCompoundText display str = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    str' <- textToCString str
    encoding <- callocMem :: IO (Ptr CString)
    format <- allocMem :: IO (Ptr Int32)
    ctext <- callocMem :: IO (Ptr (Ptr Word8))
    length_ <- allocMem :: IO (Ptr Int32)
    result <- gdk_x11_display_string_to_compound_text display' str' encoding format ctext length_
    length_' <- peek length_
    encoding' <- peek encoding
    encoding'' <- cstringToText encoding'
    format' <- peek format
    ctext' <- peek ctext
    ctext'' <- (unpackByteStringWithLength length_') ctext'
    freeMem ctext'
    touchManagedPtr display
    freeMem str'
    freeMem encoding
    freeMem format
    freeMem ctext
    freeMem length_
    return (result, encoding'', format', ctext'')

#if defined(ENABLE_OVERLOADING)
data X11DisplayStringToCompoundTextMethodInfo
instance (signature ~ (T.Text -> m ((Int32, T.Text, Int32, ByteString))), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayStringToCompoundTextMethodInfo a signature where
    overloadedMethod = x11DisplayStringToCompoundText

instance O.OverloadedMethodInfo X11DisplayStringToCompoundTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayStringToCompoundText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayStringToCompoundText"
        })


#endif

-- method X11Display::text_property_to_text_list
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The `GdkDisplay` where the encoding is defined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "encoding"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string representing the encoding. The most\n  common values for this are \"STRING\", or \"COMPOUND_TEXT\".\n  This is value used as the type for the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the format of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The text data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The number of items to transform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "list"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store an  array of strings in\n  the encoding of the current locale. This array should be\n  freed using gdk_x11_free_text_list()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_text_property_to_text_list" gdk_x11_display_text_property_to_text_list :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- encoding : TBasicType TUTF8
    Int32 ->                                -- format : TBasicType TInt
    Word8 ->                                -- text : TBasicType TUInt8
    Int32 ->                                -- length : TBasicType TInt
    CString ->                              -- list : TBasicType TUTF8
    IO Int32

{-# DEPRECATED x11DisplayTextPropertyToTextList ["(Since version 4.18)"] #-}
-- | Convert a text string from the encoding as it is stored
-- in a property into an array of strings in the encoding of
-- the current locale. (The elements of the array represent the
-- nul-separated elements of the original text string.)
x11DisplayTextPropertyToTextList ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: The @GdkDisplay@ where the encoding is defined
    -> T.Text
    -- ^ /@encoding@/: a string representing the encoding. The most
    --   common values for this are \"STRING\", or \"COMPOUND_TEXT\".
    --   This is value used as the type for the property
    -> Int32
    -- ^ /@format@/: the format of the property
    -> Word8
    -- ^ /@text@/: The text data
    -> Int32
    -- ^ /@length@/: The number of items to transform
    -> T.Text
    -- ^ /@list@/: location to store an  array of strings in
    --   the encoding of the current locale. This array should be
    --   freed using 'GI.GdkX11.Functions.x11FreeTextList'.
    -> m Int32
    -- ^ __Returns:__ the number of strings stored in list, or 0,
    --   if the conversion failed
x11DisplayTextPropertyToTextList display encoding format text length_ list = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    encoding' <- textToCString encoding
    list' <- textToCString list
    result <- gdk_x11_display_text_property_to_text_list display' encoding' format text length_ list'
    touchManagedPtr display
    freeMem encoding'
    freeMem list'
    return result

#if defined(ENABLE_OVERLOADING)
data X11DisplayTextPropertyToTextListMethodInfo
instance (signature ~ (T.Text -> Int32 -> Word8 -> Int32 -> T.Text -> m Int32), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayTextPropertyToTextListMethodInfo a signature where
    overloadedMethod = x11DisplayTextPropertyToTextList

instance O.OverloadedMethodInfo X11DisplayTextPropertyToTextListMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayTextPropertyToTextList",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayTextPropertyToTextList"
        })


#endif

-- method X11Display::ungrab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_ungrab" gdk_x11_display_ungrab :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    IO ()

-- | Ungrab /@display@/ after it has been grabbed with
-- 'GI.GdkX11.Objects.X11Display.x11DisplayGrab'.
x11DisplayUngrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
x11DisplayUngrab display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_x11_display_ungrab display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data X11DisplayUngrabMethodInfo
instance (signature ~ (m ()), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayUngrabMethodInfo a signature where
    overloadedMethod = x11DisplayUngrab

instance O.OverloadedMethodInfo X11DisplayUngrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayUngrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayUngrab"
        })


#endif

-- method X11Display::utf8_to_compound_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "encoding"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store resulting encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store format of the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "ctext"
--           , argType = TCArray False (-1) 5 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the data of the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the length of the data stored in @ctext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "location to store the length of the data stored in @ctext"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_utf8_to_compound_text" gdk_x11_display_utf8_to_compound_text :: 
    Ptr X11Display ->                       -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    CString ->                              -- str : TBasicType TUTF8
    Ptr CString ->                          -- encoding : TBasicType TUTF8
    Ptr Int32 ->                            -- format : TBasicType TInt
    Ptr (Ptr Word8) ->                      -- ctext : TCArray False (-1) 5 (TBasicType TUInt8)
    Ptr Int32 ->                            -- length : TBasicType TInt
    IO CInt

{-# DEPRECATED x11DisplayUtf8ToCompoundText ["(Since version 4.18)"] #-}
-- | Converts from UTF-8 to compound text.
x11DisplayUtf8ToCompoundText ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Display a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@str@/: a UTF-8 string
    -> m ((Bool, T.Text, Int32, ByteString))
    -- ^ __Returns:__ 'P.True' if the conversion succeeded, otherwise 'P.False'
x11DisplayUtf8ToCompoundText display str = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    str' <- textToCString str
    encoding <- callocMem :: IO (Ptr CString)
    format <- allocMem :: IO (Ptr Int32)
    ctext <- callocMem :: IO (Ptr (Ptr Word8))
    length_ <- allocMem :: IO (Ptr Int32)
    result <- gdk_x11_display_utf8_to_compound_text display' str' encoding format ctext length_
    length_' <- peek length_
    let result' = (/= 0) result
    encoding' <- peek encoding
    encoding'' <- cstringToText encoding'
    format' <- peek format
    ctext' <- peek ctext
    ctext'' <- (unpackByteStringWithLength length_') ctext'
    freeMem ctext'
    touchManagedPtr display
    freeMem str'
    freeMem encoding
    freeMem format
    freeMem ctext
    freeMem length_
    return (result', encoding'', format', ctext'')

#if defined(ENABLE_OVERLOADING)
data X11DisplayUtf8ToCompoundTextMethodInfo
instance (signature ~ (T.Text -> m ((Bool, T.Text, Int32, ByteString))), MonadIO m, IsX11Display a) => O.OverloadedMethod X11DisplayUtf8ToCompoundTextMethodInfo a signature where
    overloadedMethod = x11DisplayUtf8ToCompoundText

instance O.OverloadedMethodInfo X11DisplayUtf8ToCompoundTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Display.x11DisplayUtf8ToCompoundText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-4.0.8/docs/GI-GdkX11-Objects-X11Display.html#v:x11DisplayUtf8ToCompoundText"
        })


#endif

-- method X11Display::open
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of the X display.\n  See the XOpenDisplay() for details."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_open" gdk_x11_display_open :: 
    CString ->                              -- display_name : TBasicType TUTF8
    IO (Ptr Gdk.Display.Display)

{-# DEPRECATED x11DisplayOpen ["(Since version 4.18)"] #-}
-- | Tries to open a new display to the X server given by
-- /@displayName@/. If opening the display fails, 'P.Nothing' is
-- returned.
x11DisplayOpen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@displayName@/: name of the X display.
    --   See the 'GI.Xlib.Functions.openDisplay' for details.
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ The new display
x11DisplayOpen displayName = liftIO $ do
    maybeDisplayName <- case displayName of
        Nothing -> return FP.nullPtr
        Just jDisplayName -> do
            jDisplayName' <- textToCString jDisplayName
            return jDisplayName'
    result <- gdk_x11_display_open maybeDisplayName
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gdk.Display.Display) result'
        return result''
    freeMem maybeDisplayName
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method X11Display::set_program_class
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "program_class"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_display_set_program_class" gdk_x11_display_set_program_class :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CString ->                              -- program_class : TBasicType TUTF8
    IO ()

-- | Sets the program class.
-- 
-- The X11 backend uses the program class to set the class name part
-- of the @WM_CLASS@ property on toplevel windows; see the ICCCM.
x11DisplaySetProgramClass ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@programClass@/: a string
    -> m ()
x11DisplaySetProgramClass display programClass = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    programClass' <- textToCString programClass
    gdk_x11_display_set_program_class display' programClass'
    touchManagedPtr display
    freeMem programClass'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif


