{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gdk.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "# In most APIs these are used as guint, but they are declared as gint."
 , "# See https://github.com/haskell-gi/haskell-gi/issues/58"
 , "set-attr Gdk/~KEY_.*@constant/@type name guint"
 , ""
 , "# The introspection annotation marks the parameter as"
 , "# (out caller-allocates), but it is just a pointer to a GValue."
 , "set-attr Gdk/ContentProvider/get_value/@parameters/value direction in"
 , "set-attr Gdk/ContentProvider/get_value/@parameters/value caller-allocates 0"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Gdk.Config"
 , "GI.Gdk"
 , "GI.Gdk.Callbacks"
 , "GI.Gdk.Constants"
 , "GI.Gdk.Enums"
 , "GI.Gdk.Flags"
 , "GI.Gdk.Functions"
 , "GI.Gdk.Interfaces"
 , "GI.Gdk.Interfaces.DevicePad"
 , "GI.Gdk.Interfaces.DragSurface"
 , "GI.Gdk.Interfaces.Paintable"
 , "GI.Gdk.Interfaces.Popup"
 , "GI.Gdk.Interfaces.Toplevel"
 , "GI.Gdk.Objects"
 , "GI.Gdk.Objects.AppLaunchContext"
 , "GI.Gdk.Objects.ButtonEvent"
 , "GI.Gdk.Objects.CairoContext"
 , "GI.Gdk.Objects.CicpParams"
 , "GI.Gdk.Objects.Clipboard"
 , "GI.Gdk.Objects.ContentDeserializer"
 , "GI.Gdk.Objects.ContentProvider"
 , "GI.Gdk.Objects.ContentSerializer"
 , "GI.Gdk.Objects.CrossingEvent"
 , "GI.Gdk.Objects.Cursor"
 , "GI.Gdk.Objects.DNDEvent"
 , "GI.Gdk.Objects.DeleteEvent"
 , "GI.Gdk.Objects.Device"
 , "GI.Gdk.Objects.DeviceTool"
 , "GI.Gdk.Objects.Display"
 , "GI.Gdk.Objects.DisplayManager"
 , "GI.Gdk.Objects.DmabufTexture"
 , "GI.Gdk.Objects.DmabufTextureBuilder"
 , "GI.Gdk.Objects.Drag"
 , "GI.Gdk.Objects.DrawContext"
 , "GI.Gdk.Objects.Drop"
 , "GI.Gdk.Objects.Event"
 , "GI.Gdk.Objects.FocusEvent"
 , "GI.Gdk.Objects.FrameClock"
 , "GI.Gdk.Objects.GLContext"
 , "GI.Gdk.Objects.GLTexture"
 , "GI.Gdk.Objects.GLTextureBuilder"
 , "GI.Gdk.Objects.GrabBrokenEvent"
 , "GI.Gdk.Objects.KeyEvent"
 , "GI.Gdk.Objects.MemoryTexture"
 , "GI.Gdk.Objects.MemoryTextureBuilder"
 , "GI.Gdk.Objects.Monitor"
 , "GI.Gdk.Objects.MotionEvent"
 , "GI.Gdk.Objects.PadEvent"
 , "GI.Gdk.Objects.ProximityEvent"
 , "GI.Gdk.Objects.ScrollEvent"
 , "GI.Gdk.Objects.Seat"
 , "GI.Gdk.Objects.Snapshot"
 , "GI.Gdk.Objects.Surface"
 , "GI.Gdk.Objects.Texture"
 , "GI.Gdk.Objects.TouchEvent"
 , "GI.Gdk.Objects.TouchpadEvent"
 , "GI.Gdk.Objects.VulkanContext"
 , "GI.Gdk.Structs"
 , "GI.Gdk.Structs.ColorState"
 , "GI.Gdk.Structs.ContentFormats"
 , "GI.Gdk.Structs.ContentFormatsBuilder"
 , "GI.Gdk.Structs.DmabufFormats"
 , "GI.Gdk.Structs.DragSurfaceSize"
 , "GI.Gdk.Structs.EventSequence"
 , "GI.Gdk.Structs.FileList"
 , "GI.Gdk.Structs.FrameTimings"
 , "GI.Gdk.Structs.KeymapKey"
 , "GI.Gdk.Structs.PopupLayout"
 , "GI.Gdk.Structs.RGBA"
 , "GI.Gdk.Structs.Rectangle"
 , "GI.Gdk.Structs.TextureDownloader"
 , "GI.Gdk.Structs.TimeCoord"
 , "GI.Gdk.Structs.ToplevelLayout"
 , "GI.Gdk.Structs.ToplevelSize"]
