{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Holds timing information for a single frame of the application’s displays.
-- 
-- To retrieve @GdkFrameTimings@ objects, use 'GI.Gdk.Objects.FrameClock.frameClockGetTimings'
-- or 'GI.Gdk.Objects.FrameClock.frameClockGetCurrentTimings'. The information in
-- @GdkFrameTimings@ is useful for precise synchronization of video with
-- the event or audio streams, and for measuring quality metrics for the
-- application’s display, such as latency and jitter.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.FrameTimings
    ( 

-- * Exported types
    FrameTimings(..)                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Structs.FrameTimings#g:method:ref"), [unref]("GI.Gdk.Structs.FrameTimings#g:method:unref").
-- 
-- ==== Getters
-- [getComplete]("GI.Gdk.Structs.FrameTimings#g:method:getComplete"), [getFrameCounter]("GI.Gdk.Structs.FrameTimings#g:method:getFrameCounter"), [getFrameTime]("GI.Gdk.Structs.FrameTimings#g:method:getFrameTime"), [getPredictedPresentationTime]("GI.Gdk.Structs.FrameTimings#g:method:getPredictedPresentationTime"), [getPresentationTime]("GI.Gdk.Structs.FrameTimings#g:method:getPresentationTime"), [getRefreshInterval]("GI.Gdk.Structs.FrameTimings#g:method:getRefreshInterval").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveFrameTimingsMethod               ,
#endif

-- ** getComplete #method:getComplete#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetCompleteMethodInfo       ,
#endif
    frameTimingsGetComplete                 ,


-- ** getFrameCounter #method:getFrameCounter#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetFrameCounterMethodInfo   ,
#endif
    frameTimingsGetFrameCounter             ,


-- ** getFrameTime #method:getFrameTime#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetFrameTimeMethodInfo      ,
#endif
    frameTimingsGetFrameTime                ,


-- ** getPredictedPresentationTime #method:getPredictedPresentationTime#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetPredictedPresentationTimeMethodInfo,
#endif
    frameTimingsGetPredictedPresentationTime,


-- ** getPresentationTime #method:getPresentationTime#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetPresentationTimeMethodInfo,
#endif
    frameTimingsGetPresentationTime         ,


-- ** getRefreshInterval #method:getRefreshInterval#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsGetRefreshIntervalMethodInfo,
#endif
    frameTimingsGetRefreshInterval          ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsRefMethodInfo               ,
#endif
    frameTimingsRef                         ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    FrameTimingsUnrefMethodInfo             ,
#endif
    frameTimingsUnref                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype FrameTimings = FrameTimings (SP.ManagedPtr FrameTimings)
    deriving (Eq)

instance SP.ManagedPtrNewtype FrameTimings where
    toManagedPtr (FrameTimings p) = p

foreign import ccall "gdk_frame_timings_get_type" c_gdk_frame_timings_get_type :: 
    IO GType

type instance O.ParentTypes FrameTimings = '[]
instance O.HasParentTypes FrameTimings

instance B.Types.TypedObject FrameTimings where
    glibType = c_gdk_frame_timings_get_type

instance B.Types.GBoxed FrameTimings

-- | Convert t'FrameTimings' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FrameTimings) where
    gvalueGType_ = c_gdk_frame_timings_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr FrameTimings)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr FrameTimings)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed FrameTimings ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FrameTimings
type instance O.AttributeList FrameTimings = FrameTimingsAttributeList
type FrameTimingsAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method FrameTimings::get_complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_complete" gdk_frame_timings_get_complete :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO CInt

-- | Returns whether /@timings@/ are complete.
-- 
-- The timing information in a @GdkFrameTimings@ is filled in
-- incrementally as the frame as drawn and passed off to the
-- window system for processing and display to the user. The
-- accessor functions for @GdkFrameTimings@ can return 0 to
-- indicate an unavailable value for two reasons: either because
-- the information is not yet available, or because it isn\'t
-- available at all.
-- 
-- Once this function returns 'P.True' for a frame, you can be
-- certain that no further values will become available and be
-- stored in the @GdkFrameTimings@.
frameTimingsGetComplete ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if all information that will be available
    --   for the frame has been filled in.
frameTimingsGetComplete timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_complete timings'
    let result' = (/= 0) result
    touchManagedPtr timings
    return result'

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetCompleteMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod FrameTimingsGetCompleteMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetComplete

instance O.OverloadedMethodInfo FrameTimingsGetCompleteMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetComplete"
        })


#endif

-- method FrameTimings::get_frame_counter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_frame_counter" gdk_frame_timings_get_frame_counter :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO Int64

-- | Gets the frame counter value of the @GdkFrameClock@ when
-- this frame was drawn.
frameTimingsGetFrameCounter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m Int64
    -- ^ __Returns:__ the frame counter value for this frame
frameTimingsGetFrameCounter timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_frame_counter timings'
    touchManagedPtr timings
    return result

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetFrameCounterMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod FrameTimingsGetFrameCounterMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetFrameCounter

instance O.OverloadedMethodInfo FrameTimingsGetFrameCounterMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetFrameCounter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetFrameCounter"
        })


#endif

-- method FrameTimings::get_frame_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_frame_time" gdk_frame_timings_get_frame_time :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO Int64

-- | Returns the frame time for the frame.
-- 
-- This is the time value that is typically used to time
-- animations for the frame. See 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime'.
frameTimingsGetFrameTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: A @GdkFrameTimings@
    -> m Int64
    -- ^ __Returns:__ the frame time for the frame, in the timescale
    --  of 'GI.GLib.Functions.getMonotonicTime'
frameTimingsGetFrameTime timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_frame_time timings'
    touchManagedPtr timings
    return result

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetFrameTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod FrameTimingsGetFrameTimeMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetFrameTime

instance O.OverloadedMethodInfo FrameTimingsGetFrameTimeMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetFrameTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetFrameTime"
        })


#endif

-- method FrameTimings::get_predicted_presentation_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_predicted_presentation_time" gdk_frame_timings_get_predicted_presentation_time :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO Int64

-- | Gets the predicted time at which this frame will be displayed.
-- 
-- Although no predicted time may be available, if one is available,
-- it will be available while the frame is being generated, in contrast
-- to 'GI.Gdk.Structs.FrameTimings.frameTimingsGetPresentationTime', which is only
-- available after the frame has been presented.
-- 
-- In general, if you are simply animating, you should use
-- 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime' rather than this function,
-- but this function is useful for applications that want exact control
-- over latency. For example, a movie player may want this information
-- for Audio\/Video synchronization.
frameTimingsGetPredictedPresentationTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m Int64
    -- ^ __Returns:__ The predicted time at which the frame will be presented,
    --   in the timescale of 'GI.GLib.Functions.getMonotonicTime', or 0 if no predicted
    --   presentation time is available.
frameTimingsGetPredictedPresentationTime timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_predicted_presentation_time timings'
    touchManagedPtr timings
    return result

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetPredictedPresentationTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod FrameTimingsGetPredictedPresentationTimeMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetPredictedPresentationTime

instance O.OverloadedMethodInfo FrameTimingsGetPredictedPresentationTimeMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetPredictedPresentationTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetPredictedPresentationTime"
        })


#endif

-- method FrameTimings::get_presentation_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_presentation_time" gdk_frame_timings_get_presentation_time :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO Int64

-- | Reurns the presentation time.
-- 
-- This is the time at which the frame became visible to the user.
frameTimingsGetPresentationTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m Int64
    -- ^ __Returns:__ the time the frame was displayed to the user, in the
    --   timescale of 'GI.GLib.Functions.getMonotonicTime', or 0 if no presentation
    --   time is available. See 'GI.Gdk.Structs.FrameTimings.frameTimingsGetComplete'
frameTimingsGetPresentationTime timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_presentation_time timings'
    touchManagedPtr timings
    return result

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetPresentationTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod FrameTimingsGetPresentationTimeMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetPresentationTime

instance O.OverloadedMethodInfo FrameTimingsGetPresentationTimeMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetPresentationTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetPresentationTime"
        })


#endif

-- method FrameTimings::get_refresh_interval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_get_refresh_interval" gdk_frame_timings_get_refresh_interval :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO Int64

-- | Gets the natural interval between presentation times for
-- the display that this frame was displayed on.
-- 
-- Frame presentation usually happens during the “vertical
-- blanking interval”.
frameTimingsGetRefreshInterval ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m Int64
    -- ^ __Returns:__ the refresh interval of the display, in microseconds,
    --   or 0 if the refresh interval is not available.
    --   See 'GI.Gdk.Structs.FrameTimings.frameTimingsGetComplete'.
frameTimingsGetRefreshInterval timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_get_refresh_interval timings'
    touchManagedPtr timings
    return result

#if defined(ENABLE_OVERLOADING)
data FrameTimingsGetRefreshIntervalMethodInfo
instance (signature ~ (m Int64), MonadIO m) => O.OverloadedMethod FrameTimingsGetRefreshIntervalMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsGetRefreshInterval

instance O.OverloadedMethodInfo FrameTimingsGetRefreshIntervalMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsGetRefreshInterval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsGetRefreshInterval"
        })


#endif

-- method FrameTimings::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "FrameTimings" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_ref" gdk_frame_timings_ref :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO (Ptr FrameTimings)

-- | Increases the reference count of /@timings@/.
frameTimingsRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m FrameTimings
    -- ^ __Returns:__ /@timings@/
frameTimingsRef timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    result <- gdk_frame_timings_ref timings'
    checkUnexpectedReturnNULL "frameTimingsRef" result
    result' <- (wrapBoxed FrameTimings) result
    touchManagedPtr timings
    return result'

#if defined(ENABLE_OVERLOADING)
data FrameTimingsRefMethodInfo
instance (signature ~ (m FrameTimings), MonadIO m) => O.OverloadedMethod FrameTimingsRefMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsRef

instance O.OverloadedMethodInfo FrameTimingsRefMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsRef"
        })


#endif

-- method FrameTimings::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "timings"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameTimings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkFrameTimings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_timings_unref" gdk_frame_timings_unref :: 
    Ptr FrameTimings ->                     -- timings : TInterface (Name {namespace = "Gdk", name = "FrameTimings"})
    IO ()

-- | Decreases the reference count of /@timings@/.
-- 
-- If /@timings@/ is no longer referenced, it will be freed.
frameTimingsUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FrameTimings
    -- ^ /@timings@/: a @GdkFrameTimings@
    -> m ()
frameTimingsUnref timings = liftIO $ do
    timings' <- unsafeManagedPtrGetPtr timings
    gdk_frame_timings_unref timings'
    touchManagedPtr timings
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameTimingsUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod FrameTimingsUnrefMethodInfo FrameTimings signature where
    overloadedMethod = frameTimingsUnref

instance O.OverloadedMethodInfo FrameTimingsUnrefMethodInfo FrameTimings where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.FrameTimings.frameTimingsUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-FrameTimings.html#v:frameTimingsUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFrameTimingsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFrameTimingsMethod "ref" o = FrameTimingsRefMethodInfo
    ResolveFrameTimingsMethod "unref" o = FrameTimingsUnrefMethodInfo
    ResolveFrameTimingsMethod "getComplete" o = FrameTimingsGetCompleteMethodInfo
    ResolveFrameTimingsMethod "getFrameCounter" o = FrameTimingsGetFrameCounterMethodInfo
    ResolveFrameTimingsMethod "getFrameTime" o = FrameTimingsGetFrameTimeMethodInfo
    ResolveFrameTimingsMethod "getPredictedPresentationTime" o = FrameTimingsGetPredictedPresentationTimeMethodInfo
    ResolveFrameTimingsMethod "getPresentationTime" o = FrameTimingsGetPresentationTimeMethodInfo
    ResolveFrameTimingsMethod "getRefreshInterval" o = FrameTimingsGetRefreshIntervalMethodInfo
    ResolveFrameTimingsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFrameTimingsMethod t FrameTimings, O.OverloadedMethod info FrameTimings p) => OL.IsLabel t (FrameTimings -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFrameTimingsMethod t FrameTimings, O.OverloadedMethod info FrameTimings p, R.HasField t FrameTimings p) => R.HasField t FrameTimings p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFrameTimingsMethod t FrameTimings, O.OverloadedMethodInfo info FrameTimings) => OL.IsLabel t (O.MethodProxy info FrameTimings) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


