// GoToSocial
// Copyright (C) GoToSocial Authors admin@gotosocial.org
// SPDX-License-Identifier: AGPL-3.0-or-later
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package gtsmodel

// MediaErrorDetails stores basic error details about
// why a piece of media may not have been downloaded.
// It contains a 16bit MediaErrorType, and the remaining
// 16bits may contain optional extra error details.
type MediaErrorDetails uint32

// MediaErrorType describes a broad error type for why
// one or more media files may not have been downloaded.
type MediaErrorType uint16
