/* minefield-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from minefield-view.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_POS (pos_get_type ())
#define POS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POS, Pos))
#define POS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POS, PosClass))
#define IS_POS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POS))
#define IS_POS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POS))
#define POS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POS, PosClass))

typedef struct _Pos Pos;
typedef struct _PosClass PosClass;
typedef struct _PosPrivate PosPrivate;
enum  {
	POS_0_PROPERTY,
	POS_X_PROPERTY,
	POS_Y_PROPERTY,
	POS_NUM_PROPERTIES
};
static GParamSpec* pos_properties[POS_NUM_PROPERTIES];

#define TYPE_POSITION (position_get_type ())
#define POSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITION, Position))
#define POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSITION, PositionClass))
#define IS_POSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITION))
#define IS_POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSITION))
#define POSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSITION, PositionClass))

typedef struct _Position Position;
typedef struct _PositionClass PositionClass;
typedef struct _PositionPrivate PositionPrivate;
enum  {
	POSITION_0_PROPERTY,
	POSITION_IS_SET_PROPERTY,
	POSITION_IS_VALID_PROPERTY,
	POSITION_X_PROPERTY,
	POSITION_Y_PROPERTY,
	POSITION_POSITION_PROPERTY,
	POSITION_NUM_PROPERTIES
};
static GParamSpec* position_properties[POSITION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	POSITION_REDRAW_SIGNAL,
	POSITION_VALIDATE_SIGNAL,
	POSITION_SET_X_SIGNAL,
	POSITION_SET_Y_SIGNAL,
	POSITION_NUM_SIGNALS
};
static guint position_signals[POSITION_NUM_SIGNALS] = {0};

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
enum  {
	MINEFIELD_VIEW_0_PROPERTY,
	MINEFIELD_VIEW_MINE_SIZE_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD_PROPERTY,
	MINEFIELD_VIEW_NUM_PROPERTIES
};
static GParamSpec* minefield_view_properties[MINEFIELD_VIEW_NUM_PROPERTIES];
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Pos {
	GObject parent_instance;
	PosPrivate * priv;
};

struct _PosClass {
	GObjectClass parent_class;
};

struct _PosPrivate {
	gint _x;
	gint _y;
};

struct _Position {
	GObject parent_instance;
	PositionPrivate * priv;
};

struct _PositionClass {
	GObjectClass parent_class;
};

struct _PositionPrivate {
	gboolean _is_set;
	Pos* _pos;
};

struct _MinefieldView {
	GtkWidget parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkWidgetClass parent_class;
};

struct _MinefieldViewPrivate {
	GSettings* settings;
	gboolean force_nolongpress;
	Position* keyboard_cursor;
	Position* selected;
	Tile** mines;
	gint mines_length1;
	gint mines_length2;
	GtkEventControllerKey* key_controller;
	GtkAspectFrame* frame;
	GtkGrid* grid;
	GtkBinLayout* layout;
	gboolean first_init_done;
	Minefield* _minefield;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _Neighbour {
	gint x;
	gint y;
};

static gint Pos_private_offset;
static gpointer pos_parent_class = NULL;
static gint Position_private_offset;
static gpointer position_parent_class = NULL;
static gint MinefieldView_private_offset;
static gpointer minefield_view_parent_class = NULL;

VALA_EXTERN GType pos_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Pos, g_object_unref)
VALA_EXTERN Pos* pos_new (gint x,
              gint y);
VALA_EXTERN Pos* pos_construct (GType object_type,
                    gint x,
                    gint y);
VALA_EXTERN gint pos_get_x (Pos* self);
VALA_EXTERN void pos_set_x (Pos* self,
                gint value);
VALA_EXTERN gint pos_get_y (Pos* self);
VALA_EXTERN void pos_set_y (Pos* self,
                gint value);
static void pos_finalize (GObject * obj);
static GType pos_get_type_once (void);
static void _vala_pos_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec);
static void _vala_pos_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Position, g_object_unref)
VALA_EXTERN Position* position_new (void);
VALA_EXTERN Position* position_construct (GType object_type);
VALA_EXTERN gboolean position_get_is_set (Position* self);
VALA_EXTERN void position_set_is_set (Position* self,
                          gboolean value);
VALA_EXTERN gboolean position_get_is_valid (Position* self);
VALA_EXTERN gint position_get_x (Position* self);
VALA_EXTERN gint position_get_y (Position* self);
VALA_EXTERN Pos* position_get_position (Position* self);
VALA_EXTERN void position_set_position (Position* self,
                            Pos* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void g_cclosure_user_marshal_INT__INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data);
static void position_finalize (GObject * obj);
static GType position_get_type_once (void);
static void _vala_position_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_position_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
VALA_EXTERN GType minefield_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MinefieldView, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType minefield_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Minefield, g_object_unref)
static void minefield_view_init_grid (MinefieldView* self);
VALA_EXTERN MinefieldView* minefield_view_new (GSettings* settings);
VALA_EXTERN MinefieldView* minefield_view_construct (GType object_type,
                                         GSettings* settings);
static inline void minefield_view_tile_pressed_cb (MinefieldView* self,
                                     gint x,
                                     gint y,
                                     guint button,
                                     gint n_press,
                                     gboolean ctrl);
VALA_EXTERN Minefield* minefield_view_get_minefield (MinefieldView* self);
VALA_EXTERN GType location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Location, g_object_unref)
VALA_EXTERN gboolean minefield_get_is_complete (Minefield* self);
VALA_EXTERN gboolean minefield_get_paused (Minefield* self);
VALA_EXTERN void minefield_view_toggle_mark (MinefieldView* self,
                                 guint x,
                                 guint y);
static inline void minefield_view_tile_released_cb (MinefieldView* self,
                                      gint x,
                                      gint y,
                                      guint button);
VALA_EXTERN gboolean minefield_is_location (Minefield* self,
                                gint x,
                                gint y);
VALA_EXTERN gboolean minefield_is_cleared (Minefield* self,
                               guint x,
                               guint y);
VALA_EXTERN void minefield_multi_release (Minefield* self,
                              guint x,
                              guint y);
VALA_EXTERN GType flag_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FlagType minefield_get_flag (Minefield* self,
                             guint x,
                             guint y);
VALA_EXTERN void minefield_clear_mine (Minefield* self,
                           guint x,
                           guint y);
static inline void minefield_view_tile_long_pressed_cb (MinefieldView* self,
                                          gint x,
                                          gint y);
static void minefield_view_explode_cb (MinefieldView* self,
                                Minefield* minefield);
VALA_EXTERN gboolean minefield_has_mine (Minefield* self,
                             guint x,
                             guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self,
                                      guint x,
                                      guint y);
static void minefield_view_complete_cb (MinefieldView* self,
                                 Minefield* minefield);
VALA_EXTERN void minefield_view_add_tile (MinefieldView* self,
                              GtkWidget* child,
                              gint i,
                              gint j);
VALA_EXTERN GType neighbour_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Neighbour* neighbour_dup (const Neighbour* self);
VALA_EXTERN void neighbour_free (Neighbour* self);
VALA_EXTERN guint minefield_get_n_adjacent_mines (Minefield* self,
                                      guint x,
                                      guint y);
VALA_EXTERN guint minefield_get_n_flags (Minefield* self);
static gboolean minefield_view_get_use_question_marks (MinefieldView* self);
VALA_EXTERN void minefield_set_flag (Minefield* self,
                         guint x,
                         guint y,
                         FlagType flag);
static inline void minefield_view_init_keyboard (MinefieldView* self);
static inline gboolean minefield_view_on_key_pressed (MinefieldView* self,
                                        GtkEventControllerKey* _key_controller,
                                        guint keyval,
                                        guint keycode,
                                        GdkModifierType state);
static gboolean _minefield_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                              guint keyval,
                                                                              guint keycode,
                                                                              GdkModifierType state,
                                                                              gpointer self);
static inline void minefield_view_on_key_released (MinefieldView* self,
                                     GtkEventControllerKey* _key_controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType state);
static void _minefield_view_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self);
static inline gint minefield_view_mod (MinefieldView* self,
                         gint a,
                         gint b);
static gboolean minefield_view_get_use_autoflag (MinefieldView* self);
VALA_EXTERN guint minefield_view_get_mine_size (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
VALA_EXTERN void minefield_view_set_minefield (MinefieldView* self,
                                   Minefield* value);
VALA_EXTERN Tile* tile_new (gint prow,
                gint pcol);
VALA_EXTERN Tile* tile_construct (GType object_type,
                      gint prow,
                      gint pcol);
static void _minefield_view_tile_pressed_cb_tile_tile_pressed (Tile* _sender,
                                                        gint x,
                                                        gint y,
                                                        guint button,
                                                        gint n_press,
                                                        gboolean ctrl,
                                                        gpointer self);
static void _minefield_view_tile_released_cb_tile_tile_released (Tile* _sender,
                                                          gint x,
                                                          gint y,
                                                          guint button,
                                                          gpointer self);
static void _minefield_view_tile_long_pressed_cb_tile_tile_long_pressed (Tile* _sender,
                                                                  gint x,
                                                                  gint y,
                                                                  gpointer self);
static gboolean _minefield_is_location_position_validate (Position* _sender,
                                                   gint x,
                                                   gint y,
                                                   gpointer self);
static gint _minefield_view_minefield___lambda8_ (MinefieldView* self,
                                           gint x);
static gint __minefield_view_minefield___lambda8__position_set_x (Position* _sender,
                                                           gint x,
                                                           gpointer self);
static gint _minefield_view_minefield___lambda9_ (MinefieldView* self,
                                           gint y);
static gint __minefield_view_minefield___lambda9__position_set_y (Position* _sender,
                                                           gint y,
                                                           gpointer self);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender,
                                                               guint x,
                                                               guint y,
                                                               gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender,
                                                   gpointer self);
static void _minefield_view_complete_cb_minefield_cleared (Minefield* _sender,
                                                    gpointer self);
VALA_EXTERN void minefield_set_use_autoflag (Minefield* self,
                                 gboolean value);
static GObject * minefield_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static gint _minefield_view___lambda10_ (MinefieldView* self,
                                  gint x);
static gint __minefield_view___lambda10__position_set_x (Position* _sender,
                                                  gint x,
                                                  gpointer self);
static gint _minefield_view___lambda11_ (MinefieldView* self,
                                  gint y);
static gint __minefield_view___lambda11__position_set_y (Position* _sender,
                                                  gint y,
                                                  gpointer self);
static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender,
                                                       guint x,
                                                       guint y,
                                                       gpointer self);
static gboolean _minefield_view___lambda12_ (MinefieldView* self,
                                      gint x,
                                      gint y);
static gboolean __minefield_view___lambda12__position_validate (Position* _sender,
                                                         gint x,
                                                         gint y,
                                                         gpointer self);
static void minefield_view_finalize (GObject * obj);
static GType minefield_view_get_type_once (void);
static void _vala_minefield_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const Neighbour neighbour_map[8];

static inline gpointer
pos_get_instance_private (Pos* self)
{
	return G_STRUCT_MEMBER_P (self, Pos_private_offset);
}

Pos*
pos_construct (GType object_type,
               gint x,
               gint y)
{
	Pos * self = NULL;
	self = (Pos*) g_object_new (object_type, "x", x, "y", y, NULL);
	return self;
}

Pos*
pos_new (gint x,
         gint y)
{
	return pos_construct (TYPE_POS, x, y);
}

gint
pos_get_x (Pos* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_x;
	return result;
}

void
pos_set_x (Pos* self,
           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pos_get_x (self);
	if (old_value != value) {
		self->priv->_x = value;
		g_object_notify_by_pspec ((GObject *) self, pos_properties[POS_X_PROPERTY]);
	}
}

gint
pos_get_y (Pos* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_y;
	return result;
}

void
pos_set_y (Pos* self,
           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pos_get_y (self);
	if (old_value != value) {
		self->priv->_y = value;
		g_object_notify_by_pspec ((GObject *) self, pos_properties[POS_Y_PROPERTY]);
	}
}

static void
pos_class_init (PosClass * klass,
                gpointer klass_data)
{
	pos_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Pos_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pos_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pos_set_property;
	G_OBJECT_CLASS (klass)->finalize = pos_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POS_X_PROPERTY, pos_properties[POS_X_PROPERTY] = g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POS_Y_PROPERTY, pos_properties[POS_Y_PROPERTY] = g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pos_instance_init (Pos * self,
                   gpointer klass)
{
	self->priv = pos_get_instance_private (self);
}

static void
pos_finalize (GObject * obj)
{
	Pos * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POS, Pos);
	G_OBJECT_CLASS (pos_parent_class)->finalize (obj);
}

static GType
pos_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Pos), 0, (GInstanceInitFunc) pos_instance_init, NULL };
	GType pos_type_id;
	pos_type_id = g_type_register_static (G_TYPE_OBJECT, "Pos", &g_define_type_info, 0);
	Pos_private_offset = g_type_add_instance_private (pos_type_id, sizeof (PosPrivate));
	return pos_type_id;
}

GType
pos_get_type (void)
{
	static volatile gsize pos_type_id__once = 0;
	if (g_once_init_enter (&pos_type_id__once)) {
		GType pos_type_id;
		pos_type_id = pos_get_type_once ();
		g_once_init_leave (&pos_type_id__once, pos_type_id);
	}
	return pos_type_id__once;
}

static void
_vala_pos_get_property (GObject * object,
                        guint property_id,
                        GValue * value,
                        GParamSpec * pspec)
{
	Pos * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POS, Pos);
	switch (property_id) {
		case POS_X_PROPERTY:
		g_value_set_int (value, pos_get_x (self));
		break;
		case POS_Y_PROPERTY:
		g_value_set_int (value, pos_get_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pos_set_property (GObject * object,
                        guint property_id,
                        const GValue * value,
                        GParamSpec * pspec)
{
	Pos * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POS, Pos);
	switch (property_id) {
		case POS_X_PROPERTY:
		pos_set_x (self, g_value_get_int (value));
		break;
		case POS_Y_PROPERTY:
		pos_set_y (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
position_get_instance_private (Position* self)
{
	return G_STRUCT_MEMBER_P (self, Position_private_offset);
}

Position*
position_construct (GType object_type)
{
	Position * self = NULL;
	self = (Position*) g_object_new (object_type, NULL);
	return self;
}

Position*
position_new (void)
{
	return position_construct (TYPE_POSITION);
}

gboolean
position_get_is_set (Position* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_set;
	return result;
}

void
position_set_is_set (Position* self,
                     gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_is_set != value) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = position_get_is_valid (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = position_get_x (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = position_get_y (self);
		_tmp6_ = _tmp5_;
		g_signal_emit (self, position_signals[POSITION_REDRAW_SIGNAL], 0, (guint) _tmp4_, (guint) _tmp6_);
	}
	self->priv->_is_set = value;
	g_object_notify_by_pspec ((GObject *) self, position_properties[POSITION_IS_SET_PROPERTY]);
}

gboolean
position_get_is_valid (Position* self)
{
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = position_get_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = position_get_y (self);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, position_signals[POSITION_VALIDATE_SIGNAL], 0, _tmp1_, _tmp3_, &_tmp4_);
	result = _tmp4_;
	return result;
}

gint
position_get_x (Position* self)
{
	gint result;
	Pos* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_pos;
	_tmp1_ = pos_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
position_get_y (Position* self)
{
	gint result;
	Pos* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_pos;
	_tmp1_ = pos_get_y (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

Pos*
position_get_position (Position* self)
{
	Pos* result;
	Pos* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pos;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
position_set_position (Position* self,
                       Pos* value)
{
	Pos* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Pos* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pos;
	if (_tmp0_ == value) {
		return;
	}
	_tmp2_ = position_get_is_set (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = position_get_is_valid (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = position_get_x (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = position_get_y (self);
		_tmp9_ = _tmp8_;
		g_signal_emit (self, position_signals[POSITION_REDRAW_SIGNAL], 0, (guint) _tmp7_, (guint) _tmp9_);
	}
	_tmp10_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_pos);
	self->priv->_pos = _tmp10_;
	_tmp11_ = pos_get_x (value);
	_tmp12_ = _tmp11_;
	g_signal_emit (self, position_signals[POSITION_SET_X_SIGNAL], 0, _tmp12_, &_tmp13_);
	_tmp14_ = pos_get_y (value);
	_tmp15_ = _tmp14_;
	g_signal_emit (self, position_signals[POSITION_SET_Y_SIGNAL], 0, _tmp15_, &_tmp16_);
	_tmp18_ = position_get_is_set (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = position_get_is_valid (self);
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp22_ = position_get_x (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = position_get_y (self);
		_tmp25_ = _tmp24_;
		g_signal_emit (self, position_signals[POSITION_REDRAW_SIGNAL], 0, (guint) _tmp23_, (guint) _tmp25_);
	}
	g_object_notify_by_pspec ((GObject *) self, position_properties[POSITION_POSITION_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_INT__INT (GClosure * closure,
                                  GValue * return_value,
                                  guint n_param_values,
                                  const GValue * param_values,
                                  gpointer invocation_hint,
                                  gpointer marshal_data)
{
	typedef gint (*GMarshalFunc_INT__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_INT__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_int (return_value, v_return);
}

static void
position_class_init (PositionClass * klass,
                     gpointer klass_data)
{
	position_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Position_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_position_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_position_set_property;
	G_OBJECT_CLASS (klass)->finalize = position_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_SET_PROPERTY, position_properties[POSITION_IS_SET_PROPERTY] = g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_VALID_PROPERTY, position_properties[POSITION_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_X_PROPERTY, position_properties[POSITION_X_PROPERTY] = g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_Y_PROPERTY, position_properties[POSITION_Y_PROPERTY] = g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_POSITION_PROPERTY, position_properties[POSITION_POSITION_PROPERTY] = g_param_spec_object ("position", "position", "position", TYPE_POS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	position_signals[POSITION_REDRAW_SIGNAL] = g_signal_new ("redraw", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	position_signals[POSITION_VALIDATE_SIGNAL] = g_signal_new ("validate", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_INT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_INT);
	position_signals[POSITION_SET_X_SIGNAL] = g_signal_new ("set-x", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
	position_signals[POSITION_SET_Y_SIGNAL] = g_signal_new ("set-y", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
}

static void
position_instance_init (Position * self,
                        gpointer klass)
{
	Pos* _tmp0_;
	self->priv = position_get_instance_private (self);
	self->priv->_is_set = FALSE;
	_tmp0_ = pos_new (0, 0);
	self->priv->_pos = _tmp0_;
}

static void
position_finalize (GObject * obj)
{
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSITION, Position);
	_g_object_unref0 (self->priv->_pos);
	G_OBJECT_CLASS (position_parent_class)->finalize (obj);
}

static GType
position_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) position_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Position), 0, (GInstanceInitFunc) position_instance_init, NULL };
	GType position_type_id;
	position_type_id = g_type_register_static (G_TYPE_OBJECT, "Position", &g_define_type_info, 0);
	Position_private_offset = g_type_add_instance_private (position_type_id, sizeof (PositionPrivate));
	return position_type_id;
}

GType
position_get_type (void)
{
	static volatile gsize position_type_id__once = 0;
	if (g_once_init_enter (&position_type_id__once)) {
		GType position_type_id;
		position_type_id = position_get_type_once ();
		g_once_init_leave (&position_type_id__once, position_type_id);
	}
	return position_type_id__once;
}

static void
_vala_position_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET_PROPERTY:
		g_value_set_boolean (value, position_get_is_set (self));
		break;
		case POSITION_IS_VALID_PROPERTY:
		g_value_set_boolean (value, position_get_is_valid (self));
		break;
		case POSITION_X_PROPERTY:
		g_value_set_int (value, position_get_x (self));
		break;
		case POSITION_Y_PROPERTY:
		g_value_set_int (value, position_get_y (self));
		break;
		case POSITION_POSITION_PROPERTY:
		g_value_set_object (value, position_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_position_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET_PROPERTY:
		position_set_is_set (self, g_value_get_boolean (value));
		break;
		case POSITION_POSITION_PROPERTY:
		position_set_position (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
minefield_view_get_instance_private (MinefieldView* self)
{
	return G_STRUCT_MEMBER_P (self, MinefieldView_private_offset);
}

static void
minefield_view_init_grid (MinefieldView* self)
{
	GtkGrid* _tmp2_;
	GtkAspectFrame* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	g_return_if_fail (self != NULL);
	if (self->priv->first_init_done) {
		GtkAspectFrame* _tmp0_;
		GtkGrid* _tmp1_;
		_tmp0_ = self->priv->frame;
		gtk_aspect_frame_set_child (_tmp0_, NULL);
		_tmp1_ = self->priv->grid;
		g_signal_emit_by_name ((GtkWidget*) _tmp1_, "destroy");
	} else {
		self->priv->first_init_done = TRUE;
	}
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp2_;
	_tmp3_ = self->priv->frame;
	_tmp4_ = self->priv->grid;
	gtk_aspect_frame_set_child (_tmp3_, (GtkWidget*) _tmp4_);
	self->priv->force_nolongpress = FALSE;
	_tmp5_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp5_, TRUE);
	_tmp6_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp6_, 0);
	_tmp7_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp7_, TRUE);
	_tmp8_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp8_, 0);
	_tmp9_ = self->priv->grid;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->priv->grid;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->grid;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "minefield");
}

MinefieldView*
minefield_view_construct (GType object_type,
                          GSettings* settings)
{
	MinefieldView * self = NULL;
	GSettings* _tmp0_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (MinefieldView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	return self;
}

MinefieldView*
minefield_view_new (GSettings* settings)
{
	return minefield_view_construct (TYPE_MINEFIELD_VIEW, settings);
}

static inline void
minefield_view_tile_pressed_cb (MinefieldView* self,
                                gint x,
                                gint y,
                                guint button,
                                gint n_press,
                                gboolean ctrl)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp12_ = FALSE;
	Position* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	Position* _tmp19_;
	Position* _tmp20_;
	Pos* _tmp21_;
	Pos* _tmp22_;
	Position* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_ = FALSE;
	Position* _tmp35_;
	Tile** _tmp36_;
	gint _tmp36__length1;
	gint _tmp36__length2;
	Position* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	Position* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	Tile* _tmp43_;
	Position* _tmp44_;
	Position* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	Position* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	Pos* _tmp51_;
	Pos* _tmp52_;
	g_return_if_fail (self != NULL);
	if (n_press > 1) {
		return;
	}
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_->exploded) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp8_;
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = minefield_view_get_minefield (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp13_ = self->priv->selected;
	_tmp14_ = position_get_is_set (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		Position* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = self->priv->keyboard_cursor;
		_tmp17_ = position_get_is_set (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		return;
	}
	_tmp19_ = self->priv->selected;
	position_set_is_set (_tmp19_, FALSE);
	_tmp20_ = self->priv->selected;
	_tmp21_ = pos_new (x, y);
	_tmp22_ = _tmp21_;
	position_set_position (_tmp20_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->selected;
	_tmp24_ = position_get_is_valid (_tmp23_);
	_tmp25_ = _tmp24_;
	if (!_tmp25_) {
		return;
	}
	if (button == ((guint) GDK_BUTTON_SECONDARY)) {
		_tmp26_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		if (button == ((guint) GDK_BUTTON_PRIMARY)) {
			_tmp27_ = ctrl;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp26_ = _tmp27_;
	}
	if (_tmp26_) {
		Position* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		Position* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp28_ = self->priv->selected;
		_tmp29_ = position_get_x (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->selected;
		_tmp32_ = position_get_y (_tmp31_);
		_tmp33_ = _tmp32_;
		minefield_view_toggle_mark (self, (guint) _tmp30_, (guint) _tmp33_);
		self->priv->force_nolongpress = TRUE;
	} else {
		Position* _tmp34_;
		_tmp34_ = self->priv->selected;
		position_set_is_set (_tmp34_, TRUE);
	}
	_tmp35_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp35_, FALSE);
	_tmp36_ = self->priv->mines;
	_tmp36__length1 = self->priv->mines_length1;
	_tmp36__length2 = self->priv->mines_length2;
	_tmp37_ = self->priv->keyboard_cursor;
	_tmp38_ = position_get_x (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->keyboard_cursor;
	_tmp41_ = position_get_y (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp36_[(_tmp39_ * _tmp36__length2) + _tmp42_];
	gtk_widget_remove_css_class ((GtkWidget*) _tmp43_, "cursor");
	_tmp44_ = self->priv->keyboard_cursor;
	_tmp45_ = self->priv->selected;
	_tmp46_ = position_get_x (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = self->priv->selected;
	_tmp49_ = position_get_y (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = pos_new (_tmp47_, _tmp50_);
	_tmp52_ = _tmp51_;
	position_set_position (_tmp44_, _tmp52_);
	_g_object_unref0 (_tmp52_);
}

static inline void
minefield_view_tile_released_cb (MinefieldView* self,
                                 gint x,
                                 gint y,
                                 guint button)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp12_ = FALSE;
	Position* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp19_ = FALSE;
	Position* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	Minefield* _tmp26_;
	Minefield* _tmp27_;
	Position* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	Position* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	Minefield* _tmp34_;
	Minefield* _tmp35_;
	Position* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	Position* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	Position* _tmp66_;
	Position* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	Position* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	Pos* _tmp73_;
	Pos* _tmp74_;
	Position* _tmp75_;
	g_return_if_fail (self != NULL);
	if (button != ((guint) GDK_BUTTON_PRIMARY)) {
		return;
	}
	self->priv->force_nolongpress = FALSE;
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_->exploded) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp8_;
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = minefield_view_get_minefield (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp13_ = self->priv->selected;
	_tmp14_ = position_get_is_set (_tmp13_);
	_tmp15_ = _tmp14_;
	if (!_tmp15_) {
		_tmp12_ = TRUE;
	} else {
		Position* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = self->priv->keyboard_cursor;
		_tmp17_ = position_get_is_set (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_;
	}
	if (_tmp12_) {
		return;
	}
	_tmp20_ = self->priv->selected;
	_tmp21_ = position_get_x (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != x) {
		_tmp19_ = TRUE;
	} else {
		Position* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp23_ = self->priv->selected;
		_tmp24_ = position_get_y (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp19_ = _tmp25_ != y;
	}
	if (_tmp19_) {
		return;
	}
	_tmp26_ = minefield_view_get_minefield (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->selected;
	_tmp29_ = position_get_x (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->selected;
	_tmp32_ = position_get_y (_tmp31_);
	_tmp33_ = _tmp32_;
	if (!minefield_is_location (_tmp27_, _tmp30_, _tmp33_)) {
		return;
	}
	_tmp34_ = minefield_view_get_minefield (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->selected;
	_tmp37_ = position_get_x (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->selected;
	_tmp40_ = position_get_y (_tmp39_);
	_tmp41_ = _tmp40_;
	if (minefield_is_cleared (_tmp35_, (guint) _tmp38_, (guint) _tmp41_)) {
		Minefield* _tmp42_;
		Minefield* _tmp43_;
		Position* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		Position* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		_tmp42_ = minefield_view_get_minefield (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = self->priv->selected;
		_tmp45_ = position_get_x (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->selected;
		_tmp48_ = position_get_y (_tmp47_);
		_tmp49_ = _tmp48_;
		minefield_multi_release (_tmp43_, (guint) _tmp46_, (guint) _tmp49_);
	} else {
		Minefield* _tmp50_;
		Minefield* _tmp51_;
		Position* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		Position* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		_tmp50_ = minefield_view_get_minefield (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = self->priv->selected;
		_tmp53_ = position_get_x (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = self->priv->selected;
		_tmp56_ = position_get_y (_tmp55_);
		_tmp57_ = _tmp56_;
		if (minefield_get_flag (_tmp51_, (guint) _tmp54_, (guint) _tmp57_) != FLAG_TYPE_FLAG) {
			Minefield* _tmp58_;
			Minefield* _tmp59_;
			Position* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			Position* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp58_ = minefield_view_get_minefield (self);
			_tmp59_ = _tmp58_;
			_tmp60_ = self->priv->selected;
			_tmp61_ = position_get_x (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = self->priv->selected;
			_tmp64_ = position_get_y (_tmp63_);
			_tmp65_ = _tmp64_;
			minefield_clear_mine (_tmp59_, (guint) _tmp62_, (guint) _tmp65_);
		}
	}
	_tmp66_ = self->priv->keyboard_cursor;
	_tmp67_ = self->priv->selected;
	_tmp68_ = position_get_x (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = self->priv->selected;
	_tmp71_ = position_get_y (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = pos_new (_tmp69_, _tmp72_);
	_tmp74_ = _tmp73_;
	position_set_position (_tmp66_, _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = self->priv->selected;
	position_set_is_set (_tmp75_, FALSE);
}

static inline void
minefield_view_tile_long_pressed_cb (MinefieldView* self,
                                     gint x,
                                     gint y)
{
	Position* _tmp0_;
	Position* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Position* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->force_nolongpress == TRUE) {
		return;
	}
	_tmp0_ = self->priv->selected;
	position_set_is_set (_tmp0_, FALSE);
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->selected;
	_tmp5_ = position_get_y (_tmp4_);
	_tmp6_ = _tmp5_;
	minefield_view_toggle_mark (self, (guint) _tmp3_, (guint) _tmp6_);
}

static void
minefield_view_explode_cb (MinefieldView* self,
                           Minefield* minefield)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	gtk_widget_add_css_class ((GtkWidget*) self, "explodedField");
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) x) < minefield->width)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							gboolean _tmp4_ = FALSE;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = y;
								y = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(((guint) y) < minefield->height)) {
								break;
							}
							if (minefield_has_mine (minefield, (guint) x, (guint) y)) {
								_tmp4_ = TRUE;
							} else {
								gboolean _tmp5_ = FALSE;
								if (!minefield_has_mine (minefield, (guint) x, (guint) y)) {
									_tmp5_ = minefield_get_flag (minefield, (guint) x, (guint) y) == FLAG_TYPE_FLAG;
								} else {
									_tmp5_ = FALSE;
								}
								_tmp4_ = _tmp5_;
							}
							if (_tmp4_) {
								minefield_view_redraw_sector_cb (self, (guint) x, (guint) y);
							}
						}
					}
				}
			}
		}
	}
}

static void
minefield_view_complete_cb (MinefieldView* self,
                            Minefield* minefield)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	gtk_widget_add_css_class ((GtkWidget*) self, "completedField");
}

void
minefield_view_add_tile (MinefieldView* self,
                         GtkWidget* child,
                         gint i,
                         gint j)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->grid;
	gtk_grid_attach (_tmp0_, child, i - 1, j - 1, 1, 1);
	gtk_widget_set_hexpand (child, TRUE);
	gtk_widget_set_vexpand (child, TRUE);
}

static void
minefield_view_redraw_sector_cb (MinefieldView* self,
                                 guint x,
                                 guint y)
{
	gboolean is_down = FALSE;
	gboolean _tmp0_ = FALSE;
	Position* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Minefield* _tmp40_;
	Minefield* _tmp41_;
	g_return_if_fail (self != NULL);
	is_down = FALSE;
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Position* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->selected;
		_tmp5_ = position_get_is_set (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		Position* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp17_ = FALSE;
		_tmp9_ = self->priv->selected;
		_tmp10_ = position_get_x (_tmp9_);
		_tmp11_ = _tmp10_;
		if (x == ((guint) _tmp11_)) {
			Position* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp12_ = self->priv->selected;
			_tmp13_ = position_get_y (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = y == ((guint) _tmp14_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Minefield* _tmp15_;
			Minefield* _tmp16_;
			_tmp15_ = minefield_view_get_minefield (self);
			_tmp16_ = _tmp15_;
			_tmp7_ = minefield_get_flag (_tmp16_, x, y) != FLAG_TYPE_FLAG;
		} else {
			_tmp7_ = FALSE;
		}
		is_down = _tmp7_;
		if (!is_down) {
			Minefield* _tmp18_;
			Minefield* _tmp19_;
			Position* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			Position* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp18_ = minefield_view_get_minefield (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->selected;
			_tmp21_ = position_get_x (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->selected;
			_tmp24_ = position_get_y (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp17_ = minefield_is_cleared (_tmp19_, (guint) _tmp22_, (guint) _tmp25_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			{
				Neighbour* neighbour_collection = NULL;
				gint neighbour_collection_length1 = 0;
				gint _neighbour_collection_size_ = 0;
				gint neighbour_it = 0;
				neighbour_collection = neighbour_map;
				neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
				for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
					Neighbour neighbour = {0};
					neighbour = neighbour_collection[neighbour_it];
					{
						gint nx = 0;
						Position* _tmp26_;
						gint _tmp27_;
						gint _tmp28_;
						Neighbour _tmp29_;
						gint ny = 0;
						Position* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						Neighbour _tmp33_;
						Minefield* _tmp34_;
						Minefield* _tmp35_;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
						_tmp26_ = self->priv->selected;
						_tmp27_ = position_get_x (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = neighbour;
						nx = ((gint) _tmp28_) + _tmp29_.x;
						_tmp30_ = self->priv->selected;
						_tmp31_ = position_get_y (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = neighbour;
						ny = ((gint) _tmp32_) + _tmp33_.y;
						_tmp34_ = minefield_view_get_minefield (self);
						_tmp35_ = _tmp34_;
						if (!minefield_is_location (_tmp35_, nx, ny)) {
							continue;
						}
						if (x == ((guint) nx)) {
							_tmp37_ = y == ((guint) ny);
						} else {
							_tmp37_ = FALSE;
						}
						if (_tmp37_) {
							Minefield* _tmp38_;
							Minefield* _tmp39_;
							_tmp38_ = minefield_view_get_minefield (self);
							_tmp39_ = _tmp38_;
							_tmp36_ = minefield_get_flag (_tmp39_, (guint) nx, (guint) ny) != FLAG_TYPE_FLAG;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							is_down = TRUE;
						}
					}
				}
			}
		}
	}
	_tmp40_ = minefield_view_get_minefield (self);
	_tmp41_ = _tmp40_;
	if (minefield_is_cleared (_tmp41_, x, y)) {
		Minefield* _tmp42_;
		Minefield* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		Minefield* _tmp46_;
		Minefield* _tmp47_;
		_tmp42_ = minefield_view_get_minefield (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = minefield_get_paused (_tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_) {
			return;
		}
		_tmp46_ = minefield_view_get_minefield (self);
		_tmp47_ = _tmp46_;
		if (minefield_has_mine (_tmp47_, x, y)) {
			Tile** _tmp48_;
			gint _tmp48__length1;
			gint _tmp48__length2;
			Tile* _tmp49_;
			_tmp48_ = self->priv->mines;
			_tmp48__length1 = self->priv->mines_length1;
			_tmp48__length2 = self->priv->mines_length2;
			_tmp49_ = _tmp48_[(x * _tmp48__length2) + y];
			gtk_widget_add_css_class ((GtkWidget*) _tmp49_, "exploded");
		} else {
			guint n = 0U;
			Minefield* _tmp50_;
			Minefield* _tmp51_;
			Tile** _tmp52_;
			gint _tmp52__length1;
			gint _tmp52__length2;
			Tile* _tmp53_;
			Tile** _tmp54_;
			gint _tmp54__length1;
			gint _tmp54__length2;
			Tile* _tmp55_;
			Tile** _tmp56_;
			gint _tmp56__length1;
			gint _tmp56__length2;
			Tile* _tmp57_;
			_tmp50_ = minefield_view_get_minefield (self);
			_tmp51_ = _tmp50_;
			n = minefield_get_n_adjacent_mines (_tmp51_, x, y);
			_tmp52_ = self->priv->mines;
			_tmp52__length1 = self->priv->mines_length1;
			_tmp52__length2 = self->priv->mines_length2;
			_tmp53_ = _tmp52_[(x * _tmp52__length2) + y];
			gtk_widget_remove_css_class ((GtkWidget*) _tmp53_, "maybe");
			_tmp54_ = self->priv->mines;
			_tmp54__length1 = self->priv->mines_length1;
			_tmp54__length2 = self->priv->mines_length2;
			_tmp55_ = _tmp54_[(x * _tmp54__length2) + y];
			gtk_widget_remove_css_class ((GtkWidget*) _tmp55_, "flag");
			_tmp56_ = self->priv->mines;
			_tmp56__length1 = self->priv->mines_length1;
			_tmp56__length2 = self->priv->mines_length2;
			_tmp57_ = _tmp56_[(x * _tmp56__length2) + y];
			gtk_widget_add_css_class ((GtkWidget*) _tmp57_, "count");
			if (n > ((guint) 0)) {
				Tile** _tmp58_;
				gint _tmp58__length1;
				gint _tmp58__length2;
				Tile* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp58_ = self->priv->mines;
				_tmp58__length1 = self->priv->mines_length1;
				_tmp58__length2 = self->priv->mines_length2;
				_tmp59_ = _tmp58_[(x * _tmp58__length2) + y];
				_tmp60_ = g_strdup_printf ("%u", n);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strconcat ("surrounded-by-", _tmp61_, "-mines", NULL);
				_tmp63_ = _tmp62_;
				gtk_widget_add_css_class ((GtkWidget*) _tmp59_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		Minefield* _tmp64_;
		Minefield* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		Minefield* _tmp68_;
		Minefield* _tmp69_;
		_tmp64_ = minefield_view_get_minefield (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = minefield_get_paused (_tmp65_);
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			return;
		}
		_tmp68_ = minefield_view_get_minefield (self);
		_tmp69_ = _tmp68_;
		if (minefield_get_flag (_tmp69_, x, y) == FLAG_TYPE_FLAG) {
			Tile** _tmp70_;
			gint _tmp70__length1;
			gint _tmp70__length2;
			Tile* _tmp71_;
			gboolean _tmp72_ = FALSE;
			Minefield* _tmp73_;
			Minefield* _tmp74_;
			_tmp70_ = self->priv->mines;
			_tmp70__length1 = self->priv->mines_length1;
			_tmp70__length2 = self->priv->mines_length2;
			_tmp71_ = _tmp70_[(x * _tmp70__length2) + y];
			gtk_widget_add_css_class ((GtkWidget*) _tmp71_, "flag");
			_tmp73_ = minefield_view_get_minefield (self);
			_tmp74_ = _tmp73_;
			if (_tmp74_->exploded) {
				Minefield* _tmp75_;
				Minefield* _tmp76_;
				_tmp75_ = minefield_view_get_minefield (self);
				_tmp76_ = _tmp75_;
				_tmp72_ = !minefield_has_mine (_tmp76_, x, y);
			} else {
				_tmp72_ = FALSE;
			}
			if (_tmp72_) {
				Tile** _tmp77_;
				gint _tmp77__length1;
				gint _tmp77__length2;
				Tile* _tmp78_;
				_tmp77_ = self->priv->mines;
				_tmp77__length1 = self->priv->mines_length1;
				_tmp77__length2 = self->priv->mines_length2;
				_tmp78_ = _tmp77_[(x * _tmp77__length2) + y];
				gtk_widget_add_css_class ((GtkWidget*) _tmp78_, "incorrect");
			}
		} else {
			gboolean _tmp79_ = FALSE;
			Minefield* _tmp80_;
			Minefield* _tmp81_;
			_tmp80_ = minefield_view_get_minefield (self);
			_tmp81_ = _tmp80_;
			if (_tmp81_->exploded) {
				Minefield* _tmp82_;
				Minefield* _tmp83_;
				_tmp82_ = minefield_view_get_minefield (self);
				_tmp83_ = _tmp82_;
				_tmp79_ = minefield_has_mine (_tmp83_, x, y);
			} else {
				_tmp79_ = FALSE;
			}
			if (_tmp79_) {
				Tile** _tmp84_;
				gint _tmp84__length1;
				gint _tmp84__length2;
				Tile* _tmp85_;
				_tmp84_ = self->priv->mines;
				_tmp84__length1 = self->priv->mines_length1;
				_tmp84__length2 = self->priv->mines_length2;
				_tmp85_ = _tmp84_[(x * _tmp84__length2) + y];
				gtk_widget_add_css_class ((GtkWidget*) _tmp85_, "mine");
			}
		}
	}
}

void
minefield_view_toggle_mark (MinefieldView* self,
                            guint x,
                            guint y)
{
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	if (minefield_is_cleared (_tmp1_, x, y)) {
		return;
	}
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	switch (minefield_get_flag (_tmp3_, x, y)) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp4_ = FALSE;
			Minefield* _tmp5_;
			Minefield* _tmp6_;
			guint _tmp7_;
			guint _tmp8_;
			Minefield* _tmp9_;
			Minefield* _tmp10_;
			_tmp5_ = minefield_view_get_minefield (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = minefield_get_n_flags (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = minefield_view_get_minefield (self);
			_tmp10_ = _tmp9_;
			if (_tmp8_ >= _tmp10_->n_mines) {
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp11_ = minefield_view_get_use_question_marks (self);
				_tmp12_ = _tmp11_;
				_tmp4_ = _tmp12_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				Minefield* _tmp13_;
				Minefield* _tmp14_;
				Tile** _tmp15_;
				gint _tmp15__length1;
				gint _tmp15__length2;
				Tile* _tmp16_;
				_tmp13_ = minefield_view_get_minefield (self);
				_tmp14_ = _tmp13_;
				minefield_set_flag (_tmp14_, x, y, FLAG_TYPE_MAYBE);
				_tmp15_ = self->priv->mines;
				_tmp15__length1 = self->priv->mines_length1;
				_tmp15__length2 = self->priv->mines_length2;
				_tmp16_ = _tmp15_[(x * _tmp15__length2) + y];
				gtk_widget_add_css_class ((GtkWidget*) _tmp16_, "maybe");
			} else {
				Minefield* _tmp17_;
				Minefield* _tmp18_;
				Tile** _tmp19_;
				gint _tmp19__length1;
				gint _tmp19__length2;
				Tile* _tmp20_;
				_tmp17_ = minefield_view_get_minefield (self);
				_tmp18_ = _tmp17_;
				minefield_set_flag (_tmp18_, x, y, FLAG_TYPE_FLAG);
				_tmp19_ = self->priv->mines;
				_tmp19__length1 = self->priv->mines_length1;
				_tmp19__length2 = self->priv->mines_length2;
				_tmp20_ = _tmp19_[(x * _tmp19__length2) + y];
				gtk_widget_add_css_class ((GtkWidget*) _tmp20_, "flag");
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Tile** _tmp21_;
			gint _tmp21__length1;
			gint _tmp21__length2;
			Tile* _tmp22_;
			Minefield* _tmp23_;
			Minefield* _tmp24_;
			_tmp21_ = self->priv->mines;
			_tmp21__length1 = self->priv->mines_length1;
			_tmp21__length2 = self->priv->mines_length2;
			_tmp22_ = _tmp21_[(x * _tmp21__length2) + y];
			gtk_widget_remove_css_class ((GtkWidget*) _tmp22_, "maybe");
			_tmp23_ = minefield_view_get_minefield (self);
			_tmp24_ = _tmp23_;
			minefield_set_flag (_tmp24_, x, y, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			Tile** _tmp25_;
			gint _tmp25__length1;
			gint _tmp25__length2;
			Tile* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp25_ = self->priv->mines;
			_tmp25__length1 = self->priv->mines_length1;
			_tmp25__length2 = self->priv->mines_length2;
			_tmp26_ = _tmp25_[(x * _tmp25__length2) + y];
			gtk_widget_remove_css_class ((GtkWidget*) _tmp26_, "flag");
			_tmp27_ = minefield_view_get_use_question_marks (self);
			_tmp28_ = _tmp27_;
			if (_tmp28_) {
				Minefield* _tmp29_;
				Minefield* _tmp30_;
				Tile** _tmp31_;
				gint _tmp31__length1;
				gint _tmp31__length2;
				Tile* _tmp32_;
				_tmp29_ = minefield_view_get_minefield (self);
				_tmp30_ = _tmp29_;
				minefield_set_flag (_tmp30_, x, y, FLAG_TYPE_MAYBE);
				_tmp31_ = self->priv->mines;
				_tmp31__length1 = self->priv->mines_length1;
				_tmp31__length2 = self->priv->mines_length2;
				_tmp32_ = _tmp31_[(x * _tmp31__length2) + y];
				gtk_widget_add_css_class ((GtkWidget*) _tmp32_, "maybe");
			} else {
				Minefield* _tmp33_;
				Minefield* _tmp34_;
				_tmp33_ = minefield_view_get_minefield (self);
				_tmp34_ = _tmp33_;
				minefield_set_flag (_tmp34_, x, y, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}

static gboolean
_minefield_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                     guint keyval,
                                                                     guint keycode,
                                                                     GdkModifierType state,
                                                                     gpointer self)
{
	gboolean result;
	result = minefield_view_on_key_pressed ((MinefieldView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_minefield_view_on_key_released_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self)
{
	minefield_view_on_key_released ((MinefieldView*) self, _sender, keyval, keycode, state);
}

static inline void
minefield_view_init_keyboard (MinefieldView* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	GtkEventControllerKey* _tmp2_;
	GtkEventControllerKey* _tmp3_;
	GtkEventController* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _minefield_view_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
	_tmp2_ = self->priv->key_controller;
	g_signal_connect_object (_tmp2_, "key-released", (GCallback) _minefield_view_on_key_released_gtk_event_controller_key_key_released, self, 0);
	_tmp3_ = self->priv->key_controller;
	_tmp4_ = _g_object_ref0 ((GtkEventController*) _tmp3_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp4_);
}

static inline gint
minefield_view_mod (MinefieldView* self,
                    gint a,
                    gint b)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((a % b) + b) % b;
	return result;
}

static inline gboolean
minefield_view_on_key_pressed (MinefieldView* self,
                               GtkEventControllerKey* _key_controller,
                               guint keyval,
                               guint keycode,
                               GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp12_ = FALSE;
	Position* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint x = 0;
	Position* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint y = 0;
	Position* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	Tile** _tmp25_;
	gint _tmp25__length1;
	gint _tmp25__length2;
	Position* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	Position* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	Tile* _tmp32_;
	gboolean _tmp54_ = FALSE;
	Position* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	Position* _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	Position* _tmp82_;
	Minefield* _tmp83_;
	Minefield* _tmp84_;
	Pos* _tmp85_;
	Pos* _tmp86_;
	Tile** _tmp87_;
	gint _tmp87__length1;
	gint _tmp87__length2;
	Position* _tmp88_;
	gint _tmp89_;
	gint _tmp90_;
	Position* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	Tile* _tmp94_;
	Position* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_->exploded) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp8_;
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = minefield_view_get_minefield (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->selected;
	_tmp14_ = position_get_is_set (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		Position* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = self->priv->keyboard_cursor;
		_tmp17_ = position_get_is_set (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = !_tmp18_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		result = FALSE;
		return result;
	}
	_tmp19_ = self->priv->keyboard_cursor;
	_tmp20_ = position_get_x (_tmp19_);
	_tmp21_ = _tmp20_;
	x = _tmp21_;
	_tmp22_ = self->priv->keyboard_cursor;
	_tmp23_ = position_get_y (_tmp22_);
	_tmp24_ = _tmp23_;
	y = _tmp24_;
	_tmp25_ = self->priv->mines;
	_tmp25__length1 = self->priv->mines_length1;
	_tmp25__length2 = self->priv->mines_length2;
	_tmp26_ = self->priv->keyboard_cursor;
	_tmp27_ = position_get_x (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = self->priv->keyboard_cursor;
	_tmp30_ = position_get_y (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp25_[(_tmp28_ * _tmp25__length2) + _tmp31_];
	gtk_widget_remove_css_class ((GtkWidget*) _tmp32_, "cursor");
	switch (keyval) {
		case GDK_KEY_Left:
		case GDK_KEY_h:
		{
			gint _tmp33_;
			_tmp33_ = x;
			x = _tmp33_ - 1;
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_k:
		{
			gint _tmp34_;
			_tmp34_ = x;
			x = _tmp34_ + 1;
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_u:
		{
			gint _tmp35_;
			_tmp35_ = y;
			y = _tmp35_ - 1;
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_j:
		{
			gint _tmp36_;
			_tmp36_ = y;
			y = _tmp36_ + 1;
			break;
		}
		case GDK_KEY_space:
		{
			Position* _tmp37_;
			gboolean _tmp38_;
			gboolean _tmp39_;
			_tmp37_ = self->priv->keyboard_cursor;
			_tmp38_ = position_get_is_set (_tmp37_);
			_tmp39_ = _tmp38_;
			if (_tmp39_) {
				Position* _tmp40_;
				_tmp40_ = self->priv->selected;
				position_set_is_set (_tmp40_, FALSE);
				if ((state & GDK_CONTROL_MASK) != 0) {
					Position* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					Position* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					_tmp41_ = self->priv->keyboard_cursor;
					_tmp42_ = position_get_x (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = self->priv->keyboard_cursor;
					_tmp45_ = position_get_y (_tmp44_);
					_tmp46_ = _tmp45_;
					minefield_view_toggle_mark (self, (guint) _tmp43_, (guint) _tmp46_);
				} else {
					Position* _tmp47_;
					Pos* _tmp48_;
					Pos* _tmp49_;
					Position* _tmp50_;
					_tmp47_ = self->priv->selected;
					_tmp48_ = pos_new (x, y);
					_tmp49_ = _tmp48_;
					position_set_position (_tmp47_, _tmp49_);
					_g_object_unref0 (_tmp49_);
					_tmp50_ = self->priv->selected;
					position_set_is_set (_tmp50_, TRUE);
				}
			}
			break;
		}
		case GDK_KEY_Escape:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			Position* _tmp51_;
			gboolean _tmp52_;
			gboolean _tmp53_;
			_tmp51_ = self->priv->keyboard_cursor;
			_tmp52_ = position_get_is_set (_tmp51_);
			_tmp53_ = _tmp52_;
			if (_tmp53_) {
				break;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
	_tmp55_ = self->priv->keyboard_cursor;
	_tmp56_ = position_get_x (_tmp55_);
	_tmp57_ = _tmp56_;
	if (x == _tmp57_) {
		Position* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		_tmp58_ = self->priv->keyboard_cursor;
		_tmp59_ = position_get_y (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp54_ = y == _tmp60_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		Position* _tmp61_;
		Tile** _tmp62_;
		gint _tmp62__length1;
		gint _tmp62__length2;
		Position* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		Position* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		Tile* _tmp69_;
		_tmp61_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp61_, TRUE);
		_tmp62_ = self->priv->mines;
		_tmp62__length1 = self->priv->mines_length1;
		_tmp62__length2 = self->priv->mines_length2;
		_tmp63_ = self->priv->keyboard_cursor;
		_tmp64_ = position_get_x (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = self->priv->keyboard_cursor;
		_tmp67_ = position_get_y (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = _tmp62_[(_tmp65_ * _tmp62__length2) + _tmp68_];
		gtk_widget_add_css_class ((GtkWidget*) _tmp69_, "cursor");
		result = TRUE;
		return result;
	}
	_tmp70_ = self->priv->keyboard_cursor;
	_tmp71_ = position_get_is_set (_tmp70_);
	_tmp72_ = _tmp71_;
	if (!_tmp72_) {
		Position* _tmp73_;
		Tile** _tmp74_;
		gint _tmp74__length1;
		gint _tmp74__length2;
		Position* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		Position* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		Tile* _tmp81_;
		_tmp73_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp73_, TRUE);
		_tmp74_ = self->priv->mines;
		_tmp74__length1 = self->priv->mines_length1;
		_tmp74__length2 = self->priv->mines_length2;
		_tmp75_ = self->priv->keyboard_cursor;
		_tmp76_ = position_get_x (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = self->priv->keyboard_cursor;
		_tmp79_ = position_get_y (_tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = _tmp74_[(_tmp77_ * _tmp74__length2) + _tmp80_];
		gtk_widget_add_css_class ((GtkWidget*) _tmp81_, "cursor");
		result = TRUE;
		return result;
	}
	_tmp82_ = self->priv->keyboard_cursor;
	_tmp83_ = self->priv->_minefield;
	_tmp84_ = self->priv->_minefield;
	_tmp85_ = pos_new (minefield_view_mod (self, x, (gint) _tmp83_->width), minefield_view_mod (self, y, (gint) _tmp84_->height));
	_tmp86_ = _tmp85_;
	position_set_position (_tmp82_, _tmp86_);
	_g_object_unref0 (_tmp86_);
	_tmp87_ = self->priv->mines;
	_tmp87__length1 = self->priv->mines_length1;
	_tmp87__length2 = self->priv->mines_length2;
	_tmp88_ = self->priv->keyboard_cursor;
	_tmp89_ = position_get_x (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = self->priv->keyboard_cursor;
	_tmp92_ = position_get_y (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = _tmp87_[(_tmp90_ * _tmp87__length2) + _tmp93_];
	gtk_widget_add_css_class ((GtkWidget*) _tmp94_, "cursor");
	_tmp95_ = self->priv->selected;
	_tmp96_ = position_get_is_set (_tmp95_);
	_tmp97_ = _tmp96_;
	if (_tmp97_) {
		Position* _tmp98_;
		Position* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		Position* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		Pos* _tmp105_;
		Pos* _tmp106_;
		_tmp98_ = self->priv->selected;
		_tmp99_ = self->priv->keyboard_cursor;
		_tmp100_ = position_get_x (_tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = self->priv->keyboard_cursor;
		_tmp103_ = position_get_y (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = pos_new (_tmp101_, _tmp104_);
		_tmp106_ = _tmp105_;
		position_set_position (_tmp98_, _tmp106_);
		_g_object_unref0 (_tmp106_);
	}
	result = TRUE;
	return result;
}

static inline void
minefield_view_on_key_released (MinefieldView* self,
                                GtkEventControllerKey* _key_controller,
                                guint keyval,
                                guint keycode,
                                GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	gboolean _tmp12_ = FALSE;
	Position* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	Minefield* _tmp19_;
	Minefield* _tmp20_;
	Position* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	Position* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	Position* _tmp51_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_key_controller != NULL);
	if (keyval != GDK_KEY_space) {
		return;
	}
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_->exploded) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp8_;
		Minefield* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = minefield_view_get_minefield (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp13_ = self->priv->selected;
	_tmp14_ = position_get_is_set (_tmp13_);
	_tmp15_ = _tmp14_;
	if (!_tmp15_) {
		_tmp12_ = TRUE;
	} else {
		Position* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = self->priv->keyboard_cursor;
		_tmp17_ = position_get_is_set (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = !_tmp18_;
	}
	if (_tmp12_) {
		return;
	}
	_tmp19_ = minefield_view_get_minefield (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->selected;
	_tmp22_ = position_get_x (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected;
	_tmp25_ = position_get_y (_tmp24_);
	_tmp26_ = _tmp25_;
	if (minefield_is_cleared (_tmp20_, (guint) _tmp23_, (guint) _tmp26_)) {
		Minefield* _tmp27_;
		Minefield* _tmp28_;
		Position* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		Position* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp27_ = minefield_view_get_minefield (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->selected;
		_tmp30_ = position_get_x (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = self->priv->selected;
		_tmp33_ = position_get_y (_tmp32_);
		_tmp34_ = _tmp33_;
		minefield_multi_release (_tmp28_, (guint) _tmp31_, (guint) _tmp34_);
	} else {
		Minefield* _tmp35_;
		Minefield* _tmp36_;
		Position* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		Position* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp35_ = minefield_view_get_minefield (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_x (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_y (_tmp40_);
		_tmp42_ = _tmp41_;
		if (minefield_get_flag (_tmp36_, (guint) _tmp39_, (guint) _tmp42_) != FLAG_TYPE_FLAG) {
			Minefield* _tmp43_;
			Minefield* _tmp44_;
			Position* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			Position* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			_tmp43_ = minefield_view_get_minefield (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = self->priv->selected;
			_tmp46_ = position_get_x (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = self->priv->selected;
			_tmp49_ = position_get_y (_tmp48_);
			_tmp50_ = _tmp49_;
			minefield_clear_mine (_tmp44_, (guint) _tmp47_, (guint) _tmp50_);
		}
	}
	_tmp51_ = self->priv->selected;
	position_set_is_set (_tmp51_, FALSE);
}

static gboolean
minefield_view_get_use_question_marks (MinefieldView* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	result = g_settings_get_boolean (_tmp0_, MINES_KEY_USE_QUESTION_MARKS);
	return result;
}

static gboolean
minefield_view_get_use_autoflag (MinefieldView* self)
{
	gboolean result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	result = g_settings_get_boolean (_tmp0_, MINES_KEY_USE_AUTOFLAG);
	return result;
}

guint
minefield_view_get_mine_size (MinefieldView* self)
{
	guint result;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	result = (guint) MIN (gtk_widget_get_width ((GtkWidget*) self) / ((gint) _tmp1_->width), gtk_widget_get_height ((GtkWidget*) self) / ((gint) _tmp3_->height));
	return result;
}

static guint
minefield_view_get_minimum_size (MinefieldView* self)
{
	guint result;
	guint w = 0U;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint h = 0U;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	guint s = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	w = 320 / _tmp1_->width;
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	h = 200 / _tmp3_->height;
	s = MIN (w, h);
	s = MAX ((guint) 30, s);
	result = s;
	return result;
}

Minefield*
minefield_view_get_minefield (MinefieldView* self)
{
	Minefield* result;
	Minefield* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}

static void
_minefield_view_tile_pressed_cb_tile_tile_pressed (Tile* _sender,
                                                   gint x,
                                                   gint y,
                                                   guint button,
                                                   gint n_press,
                                                   gboolean ctrl,
                                                   gpointer self)
{
	minefield_view_tile_pressed_cb ((MinefieldView*) self, x, y, button, n_press, ctrl);
}

static void
_minefield_view_tile_released_cb_tile_tile_released (Tile* _sender,
                                                     gint x,
                                                     gint y,
                                                     guint button,
                                                     gpointer self)
{
	minefield_view_tile_released_cb ((MinefieldView*) self, x, y, button);
}

static void
_minefield_view_tile_long_pressed_cb_tile_tile_long_pressed (Tile* _sender,
                                                             gint x,
                                                             gint y,
                                                             gpointer self)
{
	minefield_view_tile_long_pressed_cb ((MinefieldView*) self, x, y);
}

static gboolean
_minefield_is_location_position_validate (Position* _sender,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	gboolean result;
	result = minefield_is_location ((Minefield*) self, x, y);
	return result;
}

static gint
_minefield_view_minefield___lambda8_ (MinefieldView* self,
                                      gint x)
{
	gint result;
	result = x;
	return result;
}

static gint
__minefield_view_minefield___lambda8__position_set_x (Position* _sender,
                                                      gint x,
                                                      gpointer self)
{
	gint result;
	result = _minefield_view_minefield___lambda8_ ((MinefieldView*) self, x);
	return result;
}

static gint
_minefield_view_minefield___lambda9_ (MinefieldView* self,
                                      gint y)
{
	gint result;
	result = y;
	return result;
}

static gint
__minefield_view_minefield___lambda9__position_set_y (Position* _sender,
                                                      gint y,
                                                      gpointer self)
{
	gint result;
	result = _minefield_view_minefield___lambda9_ ((MinefieldView*) self, y);
	return result;
}

static void
_minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender,
                                                          guint x,
                                                          guint y,
                                                          gpointer self)
{
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}

static void
_minefield_view_explode_cb_minefield_explode (Minefield* _sender,
                                              gpointer self)
{
	minefield_view_explode_cb ((MinefieldView*) self, _sender);
}

static void
_minefield_view_complete_cb_minefield_cleared (Minefield* _sender,
                                               gpointer self)
{
	minefield_view_complete_cb ((MinefieldView*) self, _sender);
}

void
minefield_view_set_minefield (MinefieldView* self,
                              Minefield* value)
{
	Minefield* _tmp0_;
	Minefield* _tmp2_;
	GtkAspectFrame* _tmp3_;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	Minefield* _tmp7_;
	Minefield* _tmp8_;
	Minefield* _tmp9_;
	Tile** _tmp10_;
	Position* _tmp27_;
	Position* _tmp28_;
	Minefield* _tmp29_;
	Position* _tmp30_;
	Position* _tmp31_;
	Pos* _tmp32_;
	Pos* _tmp33_;
	Position* _tmp34_;
	Position* _tmp35_;
	Minefield* _tmp36_;
	Minefield* _tmp37_;
	Minefield* _tmp38_;
	Minefield* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp2_;
	_tmp3_ = self->priv->frame;
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = minefield_view_get_minefield (self);
	_tmp7_ = _tmp6_;
	gtk_aspect_frame_set_ratio (_tmp3_, ((gfloat) _tmp5_->width) / ((gfloat) _tmp7_->height));
	gtk_widget_remove_css_class ((GtkWidget*) self, "explodedField");
	gtk_widget_remove_css_class ((GtkWidget*) self, "completedField");
	_tmp8_ = self->priv->_minefield;
	_tmp9_ = self->priv->_minefield;
	_tmp10_ = g_new0 (Tile*, (_tmp8_->width * _tmp9_->height) + 1);
	self->priv->mines = (_vala_array_free (self->priv->mines, self->priv->mines_length1 * self->priv->mines_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->mines = _tmp10_;
	self->priv->mines_length1 = _tmp8_->width;
	self->priv->mines_length2 = _tmp9_->height;
	minefield_view_init_grid (self);
	gtk_widget_set_receives_default ((GtkWidget*) self, TRUE);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				Minefield* _tmp13_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = self->priv->_minefield;
				if (!(((guint) i) < _tmp13_->width)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							Minefield* _tmp16_;
							Tile** _tmp17_;
							gint _tmp17__length1;
							gint _tmp17__length2;
							Tile* _tmp18_;
							Tile** _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							Tile* _tmp20_;
							Tile** _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							Tile* _tmp22_;
							Tile** _tmp23_;
							gint _tmp23__length1;
							gint _tmp23__length2;
							Tile* _tmp24_;
							Tile** _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							Tile* _tmp26_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = self->priv->_minefield;
							if (!(((guint) j) < _tmp16_->height)) {
								break;
							}
							_tmp17_ = self->priv->mines;
							_tmp17__length1 = self->priv->mines_length1;
							_tmp17__length2 = self->priv->mines_length2;
							_tmp18_ = tile_new (i, j);
							g_object_ref_sink (_tmp18_);
							_g_object_unref0 (_tmp17_[(i * _tmp17__length2) + j]);
							_tmp17_[(i * _tmp17__length2) + j] = _tmp18_;
							_tmp19_ = self->priv->mines;
							_tmp19__length1 = self->priv->mines_length1;
							_tmp19__length2 = self->priv->mines_length2;
							_tmp20_ = _tmp19_[(i * _tmp19__length2) + j];
							g_signal_connect_object (_tmp20_, "tile-pressed", (GCallback) _minefield_view_tile_pressed_cb_tile_tile_pressed, self, 0);
							_tmp21_ = self->priv->mines;
							_tmp21__length1 = self->priv->mines_length1;
							_tmp21__length2 = self->priv->mines_length2;
							_tmp22_ = _tmp21_[(i * _tmp21__length2) + j];
							g_signal_connect_object (_tmp22_, "tile-released", (GCallback) _minefield_view_tile_released_cb_tile_tile_released, self, 0);
							_tmp23_ = self->priv->mines;
							_tmp23__length1 = self->priv->mines_length1;
							_tmp23__length2 = self->priv->mines_length2;
							_tmp24_ = _tmp23_[(i * _tmp23__length2) + j];
							g_signal_connect_object (_tmp24_, "tile-long-pressed", (GCallback) _minefield_view_tile_long_pressed_cb_tile_tile_long_pressed, self, 0);
							_tmp25_ = self->priv->mines;
							_tmp25__length1 = self->priv->mines_length1;
							_tmp25__length2 = self->priv->mines_length2;
							_tmp26_ = _tmp25_[(i * _tmp25__length2) + j];
							minefield_view_add_tile (self, (GtkWidget*) _tmp26_, i, j);
						}
					}
				}
			}
		}
	}
	_tmp27_ = self->priv->selected;
	position_set_is_set (_tmp27_, FALSE);
	_tmp28_ = self->priv->selected;
	_tmp29_ = self->priv->_minefield;
	g_signal_connect_object (_tmp28_, "validate", (GCallback) _minefield_is_location_position_validate, _tmp29_, 0);
	_tmp30_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp30_, FALSE);
	_tmp31_ = self->priv->keyboard_cursor;
	_tmp32_ = pos_new (0, 0);
	_tmp33_ = _tmp32_;
	position_set_position (_tmp31_, _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp34_, "set-x", (GCallback) __minefield_view_minefield___lambda8__position_set_x, self, 0);
	_tmp35_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp35_, "set-y", (GCallback) __minefield_view_minefield___lambda9__position_set_y, self, 0);
	_tmp36_ = self->priv->_minefield;
	g_signal_connect_object (_tmp36_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp37_ = self->priv->_minefield;
	g_signal_connect_object (_tmp37_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp38_ = self->priv->_minefield;
	g_signal_connect_object (_tmp38_, "cleared", (GCallback) _minefield_view_complete_cb_minefield_cleared, self, 0);
	_tmp39_ = self->priv->_minefield;
	_tmp40_ = minefield_view_get_use_autoflag (self);
	_tmp41_ = _tmp40_;
	minefield_set_use_autoflag (_tmp39_, _tmp41_);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, minefield_view_properties[MINEFIELD_VIEW_MINEFIELD_PROPERTY]);
}

static gint
_minefield_view___lambda10_ (MinefieldView* self,
                             gint x)
{
	gint result;
	result = x;
	return result;
}

static gint
__minefield_view___lambda10__position_set_x (Position* _sender,
                                             gint x,
                                             gpointer self)
{
	gint result;
	result = _minefield_view___lambda10_ ((MinefieldView*) self, x);
	return result;
}

static gint
_minefield_view___lambda11_ (MinefieldView* self,
                             gint y)
{
	gint result;
	result = y;
	return result;
}

static gint
__minefield_view___lambda11__position_set_y (Position* _sender,
                                             gint y,
                                             gpointer self)
{
	gint result;
	result = _minefield_view___lambda11_ ((MinefieldView*) self, y);
	return result;
}

static void
_minefield_view_redraw_sector_cb_position_redraw (Position* _sender,
                                                  guint x,
                                                  guint y,
                                                  gpointer self)
{
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}

static gboolean
_minefield_view___lambda12_ (MinefieldView* self,
                             gint x,
                             gint y)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__minefield_view___lambda12__position_validate (Position* _sender,
                                                gint x,
                                                gint y,
                                                gpointer self)
{
	gboolean result;
	result = _minefield_view___lambda12_ ((MinefieldView*) self, x, y);
	return result;
}

static GObject *
minefield_view_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MinefieldView * self;
	GtkBinLayout* _tmp0_;
	GtkBinLayout* _tmp1_;
	GtkLayoutManager* _tmp2_;
	GtkAspectFrame* _tmp3_;
	GtkAspectFrame* _tmp4_;
	Position* _tmp5_;
	Position* _tmp6_;
	Position* _tmp7_;
	Position* _tmp8_;
	Position* _tmp9_;
	Position* _tmp10_;
	Position* _tmp11_;
	parent_class = G_OBJECT_CLASS (minefield_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	minefield_view_init_keyboard (self);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	_tmp0_ = (GtkBinLayout*) gtk_bin_layout_new ();
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp0_;
	_tmp1_ = self->priv->layout;
	_tmp2_ = _g_object_ref0 ((GtkLayoutManager*) _tmp1_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp2_);
	_tmp3_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, 1.0f, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp3_;
	_tmp4_ = self->priv->frame;
	gtk_widget_insert_after ((GtkWidget*) _tmp4_, (GtkWidget*) self, NULL);
	minefield_view_init_grid (self);
	_tmp5_ = position_new ();
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp5_;
	_tmp6_ = self->priv->selected;
	g_signal_connect_object (_tmp6_, "set-x", (GCallback) __minefield_view___lambda10__position_set_x, self, 0);
	_tmp7_ = self->priv->selected;
	g_signal_connect_object (_tmp7_, "set-y", (GCallback) __minefield_view___lambda11__position_set_y, self, 0);
	_tmp8_ = self->priv->selected;
	g_signal_connect_object (_tmp8_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp9_ = position_new ();
	_g_object_unref0 (self->priv->keyboard_cursor);
	self->priv->keyboard_cursor = _tmp9_;
	_tmp10_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp10_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp11_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp11_, "validate", (GCallback) __minefield_view___lambda12__position_validate, self, 0);
	return obj;
}

static void
minefield_view_class_init (MinefieldViewClass * klass,
                           gpointer klass_data)
{
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MinefieldView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = minefield_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINE_SIZE_PROPERTY, minefield_view_properties[MINEFIELD_VIEW_MINE_SIZE_PROPERTY] = g_param_spec_uint ("mine-size", "mine-size", "mine-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD_PROPERTY, minefield_view_properties[MINEFIELD_VIEW_MINEFIELD_PROPERTY] = g_param_spec_object ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
minefield_view_instance_init (MinefieldView * self,
                              gpointer klass)
{
	self->priv = minefield_view_get_instance_private (self);
	self->priv->first_init_done = FALSE;
}

static void
minefield_view_finalize (GObject * obj)
{
	MinefieldView * self;
	GtkAspectFrame* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	_tmp0_ = self->priv->frame;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->keyboard_cursor);
	_g_object_unref0 (self->priv->selected);
	self->priv->mines = (_vala_array_free (self->priv->mines, self->priv->mines_length1 * self->priv->mines_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}

static GType
minefield_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
	GType minefield_view_type_id;
	minefield_view_type_id = g_type_register_static (gtk_widget_get_type (), "MinefieldView", &g_define_type_info, 0);
	MinefieldView_private_offset = g_type_add_instance_private (minefield_view_type_id, sizeof (MinefieldViewPrivate));
	return minefield_view_type_id;
}

GType
minefield_view_get_type (void)
{
	static volatile gsize minefield_view_type_id__once = 0;
	if (g_once_init_enter (&minefield_view_type_id__once)) {
		GType minefield_view_type_id;
		minefield_view_type_id = minefield_view_get_type_once ();
		g_once_init_leave (&minefield_view_type_id__once, minefield_view_type_id);
	}
	return minefield_view_type_id__once;
}

static void
_vala_minefield_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINE_SIZE_PROPERTY:
		g_value_set_uint (value, minefield_view_get_mine_size (self));
		break;
		case MINEFIELD_VIEW_MINEFIELD_PROPERTY:
		g_value_set_object (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_minefield_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD_PROPERTY:
		minefield_view_set_minefield (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

