/* dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2014-2026 libgnome-games-support Contributors
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include "libgnome-games-support.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define GAMES_SCORES_DIALOG_STYLE "\n" \
"dialog.scores columnview {\n" \
"    background: transparent;\n" \
"}\n" \
"\n" \
"dialog.scores columnview header button,\n" \
"dialog.scores columnview row cell {\n" \
"    padding-left: 12px;\n" \
"    padding-right: 12px;\n" \
"}\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_ACTION_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesScoresDialogShowClearScoresDialogData GamesScoresDialogShowClearScoresDialogData;

struct _GamesScoresDialog {
	AdwDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	AdwDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	GListStore* score_model;
	AdwToolbarView* toolbar;
	AdwHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkDropDown* drop_down;
	GtkColumnView* score_view;
	GtkColumnViewColumn* rank_column;
	GtkColumnViewColumn* score_column;
	GtkColumnViewColumn* player_column;
	GtkEntry* player_entry;
	GamesScoresCategory** categories;
	gint categories_length1;
	gint _categories_size_;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	gchar* score_type;
	gchar* category_type;
	GamesScoresAddScoreAction _action;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _GamesScoresDialogShowClearScoresDialogData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesScoresDialog* self;
	AdwAlertDialog* dialog;
	AdwAlertDialog* _tmp0_;
	AdwAlertDialog* _tmp1_;
	AdwAlertDialog* _tmp2_;
	AdwAlertDialog* _tmp3_;
	AdwAlertDialog* _tmp4_;
	gchar* response;
	AdwAlertDialog* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GamesScoresContext* _tmp9_;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

VALA_EXTERN GType games_scores_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            const gchar* icon_name,
                                            const gchar* score_type);
VALA_EXTERN GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  const gchar* icon_name,
                                                  const gchar* score_type);
static void games_scores_dialog_show_clear_scores_dialog (GamesScoresDialog* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void games_scores_dialog_show_clear_scores_dialog_finish (GamesScoresDialog* self,
                                                          GAsyncResult* _res_);
static void _games_scores_dialog_show_clear_scores_dialog_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static gchar** games_scores_dialog_category_names (GamesScoresDialog* self,
                                            GamesScoresCategory** categories,
                                            gint categories_length1,
                                            gint* result_length1);
static void ____lambda10_ (GamesScoresDialog* self,
                    GtkSignalListItemFactory* factory,
                    GObject* object);
static void _____lambda10__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                        GObject* object,
                                                        gpointer self);
static void games_scores_dialog_drop_down_button_cb (GamesScoresDialog* self,
                                              GtkSignalListItemFactory* factory,
                                              GObject* object);
static void _games_scores_dialog_drop_down_button_cb_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self);
static void games_scores_dialog_drop_down_selected_cb (GamesScoresDialog* self);
static void _games_scores_dialog_drop_down_selected_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void games_scores_dialog_setup_columns (GamesScoresDialog* self);
static void games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                                   GamesScoresCategory* category);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void games_scores_dialog_set_up_rank_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_score_column (GamesScoresDialog* self);
static void games_scores_dialog_set_up_player_column (GamesScoresDialog* self);
static void __lambda21_ (GamesScoresDialog* self);
static void ___lambda21__gtk_sorter_changed (GtkSorter* _sender,
                                      GtkSorterChange change,
                                      gpointer self);
static void __lambda22_ (GamesScoresDialog* self);
static gboolean __lambda23_ (GamesScoresDialog* self);
static gboolean ___lambda23__gsource_func (gpointer self);
static void ___lambda22__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                    gpointer self);
static void __lambda11_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda11__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda12_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda12__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
VALA_EXTERN gint games_scores_score_score_greater_sorter (GamesScoresScore* a,
                                              GamesScoresScore* b);
VALA_EXTERN gint games_scores_score_score_less_sorter (GamesScoresScore* a,
                                           GamesScoresScore* b);
static void __lambda13_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static void ___lambda13__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda14_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda14__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void ___lambda15_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda15__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                      GObject* object,
                                                      gpointer self);
static void __lambda16_ (GamesScoresDialog* self,
                  GtkSignalListItemFactory* factory,
                  GObject* object);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda17_ (Block3Data* _data3_);
VALA_EXTERN void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
static void ____lambda17__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void ___lambda18_ (GamesScoresDialog* self);
static void ____lambda18__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static gboolean ___lambda19_ (Block3Data* _data3_,
                       gint x,
                       gint y,
                       gboolean keyboard_tooltip,
                       GtkTooltip* tooltip);
static gboolean ____lambda19__gtk_widget_query_tooltip (GtkWidget* _sender,
                                                 gint x,
                                                 gint y,
                                                 gboolean keyboard_tooltip,
                                                 GtkTooltip* tooltip,
                                                 gpointer self);
static void ___lambda16__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void ___lambda20_ (GamesScoresDialog* self,
                   GtkSignalListItemFactory* factory,
                   GObject* object);
static void ____lambda20__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                        GObject* object,
                                                        gpointer self);
VALA_EXTERN void games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self);
static void __lambda24_ (GamesScoresDialog* self);
VALA_EXTERN void games_scores_dialog_set_action (GamesScoresDialog* self,
                                     GamesScoresAddScoreAction value);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda25_ (GamesScoresDialog* self);
static void ___lambda25__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void games_scores_dialog_show_clear_scores_dialog_data_free (gpointer _data);
static gboolean games_scores_dialog_show_clear_scores_dialog_co (GamesScoresDialogShowClearScoresDialogData* _data_);
static void games_scores_dialog_show_clear_scores_dialog_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void ___lambda9_ (GamesScoresDialog* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda9__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN GamesScoresAddScoreAction games_scores_dialog_get_action (GamesScoresDialog* self);
static void games_scores_dialog_finalize (GObject * obj);
static GType games_scores_dialog_get_type_once (void);
static void _vala_games_scores_dialog_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_games_scores_dialog_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_scores_dialog_show_clear_scores_dialog_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	games_scores_dialog_show_clear_scores_dialog ((GamesScoresDialog*) self, NULL, NULL);
}

static void
____lambda10_ (GamesScoresDialog* self,
               GtkSignalListItemFactory* factory,
               GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp0_, (gfloat) 0);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_list_item_set_child (list_item, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
_____lambda10__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                   GObject* object,
                                                   gpointer self)
{
	____lambda10_ ((GamesScoresDialog*) self, _sender, object);
}

static void
_games_scores_dialog_drop_down_button_cb_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self)
{
	games_scores_dialog_drop_down_button_cb ((GamesScoresDialog*) self, _sender, object);
}

static void
_games_scores_dialog_drop_down_selected_cb_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	games_scores_dialog_drop_down_selected_cb ((GamesScoresDialog*) self);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               const gchar* icon_name,
                               const gchar* score_type)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	gchar* _tmp2_;
	AdwToolbarView* _tmp3_;
	AdwHeaderBar* _tmp4_;
	AdwToolbarView* _tmp5_;
	AdwToolbarView* _tmp6_;
	AdwHeaderBar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint _tmp22_ = 0;
	GamesScoresCategory** _tmp23_;
	GamesScoresCategory* _tmp24_;
	GamesScoresCategory* _tmp25_;
	gchar* _tmp35_;
	gchar* new_score_or_time = NULL;
	gchar* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp99_;
	GtkColumnView* _tmp100_;
	GtkColumnView* _tmp101_;
	GtkColumnView* _tmp102_;
	GamesScoresCategory* _tmp103_;
	GtkScrolledWindow* _tmp104_;
	GtkColumnView* _tmp105_;
	AdwToolbarView* _tmp106_;
	GtkScrolledWindow* _tmp107_;
	GtkColumnView* _tmp108_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	_tmp2_ = g_strdup (category_type);
	_g_free0 (self->priv->category_type);
	self->priv->category_type = _tmp2_;
	_tmp3_ = (AdwToolbarView*) adw_toolbar_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp3_;
	_tmp4_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp4_;
	_tmp5_ = self->priv->toolbar;
	adw_dialog_set_child ((AdwDialog*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->toolbar;
	_tmp7_ = self->priv->headerbar;
	adw_toolbar_view_add_top_bar (_tmp6_, (GtkWidget*) _tmp7_);
	adw_dialog_set_content_width ((AdwDialog*) self, 400);
	adw_dialog_set_content_height ((AdwDialog*) self, 500);
	if (!games_scores_context_has_scores (context)) {
		_tmp8_ = new_high_score == NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		AdwStatusPage* status_page = NULL;
		AdwStatusPage* _tmp9_;
		AdwToolbarView* _tmp10_;
		AdwStatusPage* _tmp11_;
		AdwStatusPage* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		AdwStatusPage* _tmp15_;
		AdwStatusPage* _tmp16_;
		adw_dialog_set_title ((AdwDialog*) self, _ ("No scores yet"));
		_tmp9_ = (AdwStatusPage*) adw_status_page_new ();
		g_object_ref_sink (_tmp9_);
		status_page = _tmp9_;
		_tmp10_ = self->priv->toolbar;
		_tmp11_ = status_page;
		adw_toolbar_view_set_content (_tmp10_, (GtkWidget*) _tmp11_);
		_tmp12_ = status_page;
		_tmp13_ = g_strconcat (icon_name, "-symbolic", NULL);
		_tmp14_ = _tmp13_;
		adw_status_page_set_icon_name (_tmp12_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = status_page;
		adw_status_page_set_description (_tmp15_, _ ("Play some games and your scores will show up here."));
		_tmp16_ = status_page;
		gtk_widget_add_css_class ((GtkWidget*) _tmp16_, "dim-label");
		_g_object_unref0 (status_page);
		return self;
	}
	if (new_high_score == NULL) {
		GtkButton* delete_button = NULL;
		GtkButton* _tmp17_;
		GtkButton* _tmp18_;
		GtkButton* _tmp19_;
		AdwHeaderBar* _tmp20_;
		GtkButton* _tmp21_;
		_tmp17_ = (GtkButton*) gtk_button_new_from_icon_name ("user-trash-symbolic");
		g_object_ref_sink (_tmp17_);
		delete_button = _tmp17_;
		_tmp18_ = delete_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Clear Scores…"));
		_tmp19_ = delete_button;
		g_signal_connect_object (_tmp19_, "clicked", (GCallback) _games_scores_dialog_show_clear_scores_dialog_gtk_button_clicked, self, 0);
		_tmp20_ = self->priv->headerbar;
		_tmp21_ = delete_button;
		adw_header_bar_pack_start (_tmp20_, (GtkWidget*) _tmp21_);
		_g_object_unref0 (delete_button);
	}
	self->priv->scores_style = style;
	_tmp23_ = games_scores_context_get_categories (context, &_tmp22_);
	self->priv->categories = (_vala_array_free (self->priv->categories, self->priv->categories_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->categories = _tmp23_;
	self->priv->categories_length1 = _tmp22_;
	self->priv->_categories_size_ = self->priv->categories_length1;
	_tmp24_ = _g_object_ref0 (current_cat);
	_g_object_unref0 (self->priv->active_category);
	self->priv->active_category = _tmp24_;
	gtk_widget_add_css_class ((GtkWidget*) self, "scores");
	_tmp25_ = self->priv->active_category;
	if (_tmp25_ == NULL) {
		GamesScoresCategory** _tmp26_;
		gint _tmp26__length1;
		GamesScoresCategory* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		GamesScoresCategory** _tmp30_;
		gint _tmp30__length1;
		GamesScoresCategory* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		GamesScoresCategory* _tmp34_;
		_tmp26_ = self->priv->categories;
		_tmp26__length1 = self->priv->categories_length1;
		_tmp27_ = _tmp26_[0];
		_tmp28_ = games_scores_category_get_key (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->categories;
		_tmp30__length1 = self->priv->categories_length1;
		_tmp31_ = _tmp30_[0];
		_tmp32_ = games_scores_category_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = games_scores_category_new (_tmp29_, _tmp33_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp34_;
	}
	_tmp35_ = g_strdup ("");
	_g_free0 (self->priv->score_type);
	self->priv->score_type = _tmp35_;
	_tmp36_ = g_strdup ("");
	new_score_or_time = _tmp36_;
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp37_) {
		GamesScoresCategory* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp38_ = self->priv->active_category;
		_tmp39_ = games_scores_category_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf (_ ("New Score for %1$s: %2$s"), category_type, _tmp40_);
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp41_;
		_tmp42_ = g_strdup (_ ("Score"));
		_g_free0 (self->priv->score_type);
		self->priv->score_type = _tmp42_;
	} else {
		GamesScoresCategory* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp43_ = self->priv->active_category;
		_tmp44_ = games_scores_category_get_name (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup_printf (_ ("New Time for %1$s: %2$s"), category_type, _tmp45_);
		_g_free0 (new_score_or_time);
		new_score_or_time = _tmp46_;
		_tmp47_ = g_strdup (_ ("Time"));
		_g_free0 (self->priv->score_type);
		self->priv->score_type = _tmp47_;
	}
	if (score_type != NULL) {
		gchar* _tmp48_;
		_tmp48_ = g_strdup (score_type);
		_g_free0 (self->priv->score_type);
		self->priv->score_type = _tmp48_;
	}
	if (new_high_score != NULL) {
		AdwWindowTitle* title_widget = NULL;
		const gchar* _tmp49_;
		AdwWindowTitle* _tmp50_;
		AdwHeaderBar* _tmp51_;
		AdwWindowTitle* _tmp52_;
		_tmp49_ = new_score_or_time;
		_tmp50_ = (AdwWindowTitle*) adw_window_title_new (_ ("Congratulations!"), _tmp49_);
		g_object_ref_sink (_tmp50_);
		title_widget = _tmp50_;
		_tmp51_ = self->priv->headerbar;
		_tmp52_ = title_widget;
		adw_header_bar_set_title_widget (_tmp51_, (GtkWidget*) _tmp52_);
		_g_object_unref0 (title_widget);
	} else {
		GamesScoresCategory** _tmp53_;
		gint _tmp53__length1;
		_tmp53_ = self->priv->categories;
		_tmp53__length1 = self->priv->categories_length1;
		if (_tmp53__length1 == 1) {
			GamesScoresCategory** _tmp54_;
			gint _tmp54__length1;
			GamesScoresCategory* _tmp55_;
			GamesScoresCategory* _tmp56_;
			GamesScoresCategory* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp54_ = self->priv->categories;
			_tmp54__length1 = self->priv->categories_length1;
			_tmp55_ = _tmp54_[0];
			_tmp56_ = _g_object_ref0 (_tmp55_);
			_g_object_unref0 (self->priv->active_category);
			self->priv->active_category = _tmp56_;
			_tmp57_ = self->priv->active_category;
			_tmp58_ = games_scores_category_get_name (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strdup_printf (_ ("%1$s: %2$s"), category_type, _tmp59_);
			_tmp61_ = _tmp60_;
			adw_dialog_set_title ((AdwDialog*) self, _tmp61_);
			_g_free0 (_tmp61_);
		} else {
			GamesScoresCategory** _tmp62_;
			gint _tmp62__length1;
			gint _tmp63_ = 0;
			gchar** _tmp64_;
			gchar** _tmp65_;
			gint _tmp65__length1;
			GtkDropDown* _tmp66_;
			GtkListItemFactory* list_factory = NULL;
			GtkDropDown* _tmp67_;
			GtkListItemFactory* _tmp68_;
			GtkListItemFactory* _tmp69_;
			GtkSignalListItemFactory* button_factory = NULL;
			GtkSignalListItemFactory* _tmp70_;
			GtkSignalListItemFactory* _tmp71_;
			GtkSignalListItemFactory* _tmp72_;
			GtkDropDown* _tmp73_;
			GtkSignalListItemFactory* _tmp74_;
			GtkDropDown* _tmp75_;
			GtkListItemFactory* _tmp76_;
			GtkDropDown* _tmp90_;
			GtkButton* button = NULL;
			GtkDropDown* _tmp91_;
			GtkWidget* _tmp92_;
			GtkButton* _tmp93_;
			GtkPopover* popover = NULL;
			GtkDropDown* _tmp94_;
			GtkWidget* _tmp95_;
			GtkPopover* _tmp96_;
			AdwHeaderBar* _tmp97_;
			GtkDropDown* _tmp98_;
			_tmp62_ = self->priv->categories;
			_tmp62__length1 = self->priv->categories_length1;
			_tmp64_ = games_scores_dialog_category_names (self, _tmp62_, (gint) _tmp62__length1, &_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp65__length1 = _tmp63_;
			_tmp66_ = (GtkDropDown*) gtk_drop_down_new_from_strings (_tmp65_);
			g_object_ref_sink (_tmp66_);
			_g_object_unref0 (self->priv->drop_down);
			self->priv->drop_down = _tmp66_;
			_tmp65_ = (_vala_array_free (_tmp65_, _tmp65__length1, (GDestroyNotify) g_free), NULL);
			_tmp67_ = self->priv->drop_down;
			_tmp68_ = gtk_drop_down_get_factory (_tmp67_);
			_tmp69_ = _g_object_ref0 (_tmp68_);
			list_factory = _tmp69_;
			_tmp70_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
			button_factory = _tmp70_;
			_tmp71_ = button_factory;
			g_signal_connect_object (_tmp71_, "setup", (GCallback) _____lambda10__gtk_signal_list_item_factory_setup, self, 0);
			_tmp72_ = button_factory;
			g_signal_connect_object (_tmp72_, "bind", (GCallback) _games_scores_dialog_drop_down_button_cb_gtk_signal_list_item_factory_bind, self, 0);
			_tmp73_ = self->priv->drop_down;
			_tmp74_ = button_factory;
			gtk_drop_down_set_factory (_tmp73_, (GtkListItemFactory*) _tmp74_);
			_tmp75_ = self->priv->drop_down;
			_tmp76_ = list_factory;
			gtk_drop_down_set_list_factory (_tmp75_, _tmp76_);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp77_ = FALSE;
					_tmp77_ = TRUE;
					while (TRUE) {
						GamesScoresCategory** _tmp79_;
						gint _tmp79__length1;
						GamesScoresCategory* category = NULL;
						GamesScoresCategory** _tmp80_;
						gint _tmp80__length1;
						GamesScoresCategory* _tmp81_;
						GamesScoresCategory* _tmp82_;
						GamesScoresCategory* _tmp83_;
						const gchar* _tmp84_;
						const gchar* _tmp85_;
						GamesScoresCategory* _tmp86_;
						const gchar* _tmp87_;
						const gchar* _tmp88_;
						if (!_tmp77_) {
							gint _tmp78_;
							_tmp78_ = i;
							i = _tmp78_ + 1;
						}
						_tmp77_ = FALSE;
						_tmp79_ = self->priv->categories;
						_tmp79__length1 = self->priv->categories_length1;
						if (!(i != _tmp79__length1)) {
							break;
						}
						_tmp80_ = self->priv->categories;
						_tmp80__length1 = self->priv->categories_length1;
						_tmp81_ = _tmp80_[i];
						_tmp82_ = _g_object_ref0 (_tmp81_);
						category = _tmp82_;
						_tmp83_ = category;
						_tmp84_ = games_scores_category_get_key (_tmp83_);
						_tmp85_ = _tmp84_;
						_tmp86_ = self->priv->active_category;
						_tmp87_ = games_scores_category_get_key (_tmp86_);
						_tmp88_ = _tmp87_;
						if (g_strcmp0 (_tmp85_, _tmp88_) == 0) {
							GtkDropDown* _tmp89_;
							_tmp89_ = self->priv->drop_down;
							gtk_drop_down_set_selected (_tmp89_, (guint) i);
						}
						_g_object_unref0 (category);
					}
				}
			}
			_tmp90_ = self->priv->drop_down;
			g_signal_connect_object ((GObject*) _tmp90_, "notify::selected", (GCallback) _games_scores_dialog_drop_down_selected_cb_g_object_notify, self, 0);
			_tmp91_ = self->priv->drop_down;
			_tmp92_ = gtk_widget_get_first_child ((GtkWidget*) _tmp91_);
			button = G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, gtk_button_get_type ()) ? ((GtkButton*) _tmp92_) : NULL;
			_tmp93_ = button;
			gtk_button_set_has_frame (_tmp93_, FALSE);
			_tmp94_ = self->priv->drop_down;
			_tmp95_ = gtk_widget_get_last_child ((GtkWidget*) _tmp94_);
			popover = G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, gtk_popover_get_type ()) ? ((GtkPopover*) _tmp95_) : NULL;
			_tmp96_ = popover;
			gtk_widget_set_halign ((GtkWidget*) _tmp96_, GTK_ALIGN_CENTER);
			_tmp97_ = self->priv->headerbar;
			_tmp98_ = self->priv->drop_down;
			adw_header_bar_set_title_widget (_tmp97_, (GtkWidget*) _tmp98_);
			_g_object_unref0 (button_factory);
			_g_object_unref0 (list_factory);
		}
	}
	_tmp99_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp99_);
	scroll = _tmp99_;
	_tmp100_ = (GtkColumnView*) gtk_column_view_new (NULL);
	g_object_ref_sink (_tmp100_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp100_;
	_tmp101_ = self->priv->score_view;
	gtk_column_view_set_reorderable (_tmp101_, FALSE);
	_tmp102_ = self->priv->score_view;
	gtk_column_view_set_tab_behavior (_tmp102_, GTK_LIST_TAB_ITEM);
	games_scores_dialog_setup_columns (self);
	_tmp103_ = self->priv->active_category;
	games_scores_dialog_load_scores_for_category (self, _tmp103_);
	_tmp104_ = scroll;
	_tmp105_ = self->priv->score_view;
	gtk_scrolled_window_set_child (_tmp104_, (GtkWidget*) _tmp105_);
	_tmp106_ = self->priv->toolbar;
	_tmp107_ = scroll;
	adw_toolbar_view_set_content (_tmp106_, (GtkWidget*) _tmp107_);
	_tmp108_ = self->priv->score_view;
	g_object_set ((AdwDialog*) self, "focus-widget", (GtkWidget*) _tmp108_, NULL);
	_g_object_unref0 (scroll);
	_g_free0 (new_score_or_time);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         const gchar* icon_name,
                         const gchar* score_type)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, icon_name, score_type);
}

static void
games_scores_dialog_drop_down_selected_cb (GamesScoresDialog* self)
{
	guint selected_index = 0U;
	GtkDropDown* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drop_down;
	selected_index = gtk_drop_down_get_selected (_tmp0_);
	if (selected_index != ((guint) -1)) {
		GamesScoresCategory** _tmp1_;
		gint _tmp1__length1;
		GamesScoresCategory* _tmp2_;
		_tmp1_ = self->priv->categories;
		_tmp1__length1 = self->priv->categories_length1;
		_tmp2_ = _tmp1_[selected_index];
		games_scores_dialog_load_scores_for_category (self, _tmp2_);
	}
}

static void
games_scores_dialog_drop_down_button_cb (GamesScoresDialog* self,
                                         GtkSignalListItemFactory* factory,
                                         GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkStringObject* string_object = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkLabel* label = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_item (list_item);
	_tmp1_ = _tmp0_;
	string_object = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_string_object_get_type ()) ? ((GtkStringObject*) _tmp1_) : NULL;
	_tmp2_ = gtk_list_item_get_child (list_item);
	_tmp3_ = _tmp2_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp3_) : NULL;
	_tmp4_ = self->priv->category_type;
	_tmp5_ = gtk_string_object_get_string (string_object);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (_ ("%1$s: %2$s"), _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (label, _tmp8_);
	_g_free0 (_tmp8_);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_scores_dialog_category_names (GamesScoresDialog* self,
                                    GamesScoresCategory** categories,
                                    gint categories_length1,
                                    gint* result_length1)
{
	gchar** categories_array = NULL;
	gchar** _tmp0_;
	gint categories_array_length1;
	gint _categories_array_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	categories_array = _tmp0_;
	categories_array_length1 = 0;
	_categories_array_size_ = categories_array_length1;
	{
		GamesScoresCategory** cat_collection = NULL;
		gint cat_collection_length1 = 0;
		gint _cat_collection_size_ = 0;
		gint cat_it = 0;
		cat_collection = categories;
		cat_collection_length1 = categories_length1;
		for (cat_it = 0; cat_it < cat_collection_length1; cat_it = cat_it + 1) {
			GamesScoresCategory* _tmp1_;
			GamesScoresCategory* cat = NULL;
			_tmp1_ = _g_object_ref0 (cat_collection[cat_it]);
			cat = _tmp1_;
			{
				GamesScoresCategory* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp2_ = cat;
				_tmp3_ = games_scores_category_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strdup (_tmp4_);
				_vala_array_add3 (&categories_array, &categories_array_length1, &_categories_array_size_, _tmp5_);
				_g_object_unref0 (cat);
			}
		}
	}
	_tmp6_ = categories_array;
	_tmp6__length1 = categories_array_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static void
games_scores_dialog_load_scores_for_category (GamesScoresDialog* self,
                                              GamesScoresCategory* category)
{
	GListStore* _tmp0_;
	GamesScoresScore** best_n_scores = NULL;
	GamesScoresContext* _tmp1_;
	gint _tmp2_ = 0;
	GamesScoresScore** _tmp3_;
	gint best_n_scores_length1;
	gint _best_n_scores_size_;
	GamesScoresScore** _tmp4_;
	gint _tmp4__length1;
	GtkColumnView* _tmp8_;
	GamesScoresCategory* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->score_model;
	g_list_store_remove_all (_tmp0_);
	_tmp1_ = self->priv->context;
	_tmp3_ = games_scores_context_get_high_scores (_tmp1_, category, -1, &_tmp2_);
	best_n_scores = _tmp3_;
	best_n_scores_length1 = _tmp2_;
	_best_n_scores_size_ = best_n_scores_length1;
	_tmp4_ = best_n_scores;
	_tmp4__length1 = best_n_scores_length1;
	{
		GamesScoresScore** score_collection = NULL;
		gint score_collection_length1 = 0;
		gint _score_collection_size_ = 0;
		gint score_it = 0;
		score_collection = _tmp4_;
		score_collection_length1 = _tmp4__length1;
		for (score_it = 0; score_it < score_collection_length1; score_it = score_it + 1) {
			GamesScoresScore* _tmp5_;
			GamesScoresScore* score = NULL;
			_tmp5_ = _g_object_ref0 (score_collection[score_it]);
			score = _tmp5_;
			{
				GListStore* _tmp6_;
				GamesScoresScore* _tmp7_;
				_tmp6_ = self->priv->score_model;
				_tmp7_ = score;
				g_list_store_append (_tmp6_, (GObject*) _tmp7_);
				_g_object_unref0 (score);
			}
		}
	}
	_tmp8_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp8_, (guint) 0, NULL, GTK_LIST_SCROLL_NONE, NULL);
	_tmp9_ = _g_object_ref0 (category);
	_g_object_unref0 (self->priv->active_category);
	self->priv->active_category = _tmp9_;
	best_n_scores = (_vala_array_free (best_n_scores, best_n_scores_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
__lambda21_ (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	_tmp0_ = self->priv->score_view;
	gtk_column_view_scroll_to (_tmp0_, (guint) 0, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
}

static void
___lambda21__gtk_sorter_changed (GtkSorter* _sender,
                                 GtkSorterChange change,
                                 gpointer self)
{
	__lambda21_ ((GamesScoresDialog*) self);
}

static gboolean
__lambda23_ (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	GamesScoresScore* _tmp1_;
	GtkEntry* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->score_view;
	_tmp1_ = self->priv->new_high_score;
	gtk_column_view_scroll_to (_tmp0_, _tmp1_->rank - 1, NULL, GTK_LIST_SCROLL_FOCUS, NULL);
	_tmp2_ = self->priv->player_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	result = FALSE;
	return result;
}

static gboolean
___lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda23_ ((GamesScoresDialog*) self);
	return result;
}

static void
__lambda22_ (GamesScoresDialog* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda23__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda22__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                               gpointer self)
{
	__lambda22_ ((GamesScoresDialog*) self);
}

static void
games_scores_dialog_setup_columns (GamesScoresDialog* self)
{
	GtkColumnView* _tmp0_;
	GtkColumnViewColumn* _tmp1_;
	GtkColumnView* _tmp2_;
	GtkColumnViewColumn* _tmp3_;
	GtkColumnView* _tmp4_;
	GtkColumnViewColumn* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	GtkColumnViewColumn* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GListStore* _tmp10_;
	GtkSortListModel* sort_model = NULL;
	GListStore* _tmp11_;
	GListModel* _tmp12_;
	GtkColumnView* _tmp13_;
	GtkSorter* _tmp14_;
	GtkSorter* _tmp15_;
	GtkSorter* _tmp16_;
	GtkSortListModel* _tmp17_;
	GtkColumnView* _tmp18_;
	GtkSortListModel* _tmp19_;
	GListModel* _tmp20_;
	GtkNoSelection* _tmp21_;
	GtkNoSelection* _tmp22_;
	GtkColumnView* _tmp23_;
	GtkColumnViewColumn* _tmp24_;
	GtkColumnView* _tmp25_;
	GtkSorter* _tmp26_;
	GtkSorter* _tmp27_;
	GamesScoresScore* _tmp28_;
	GtkEventControllerFocus* controller = NULL;
	GtkEventControllerFocus* _tmp29_;
	GtkEventControllerFocus* _tmp30_;
	GtkColumnView* _tmp31_;
	GtkEventControllerFocus* _tmp32_;
	GtkEventController* _tmp33_;
	g_return_if_fail (self != NULL);
	games_scores_dialog_set_up_rank_column (self);
	games_scores_dialog_set_up_score_column (self);
	games_scores_dialog_set_up_player_column (self);
	_tmp0_ = self->priv->score_view;
	_tmp1_ = self->priv->rank_column;
	gtk_column_view_append_column (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->score_view;
	_tmp3_ = self->priv->score_column;
	gtk_column_view_append_column (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->score_view;
	_tmp5_ = self->priv->player_column;
	gtk_column_view_append_column (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->score_column;
	gtk_column_view_column_set_expand (_tmp6_, TRUE);
	_tmp7_ = self->priv->score_column;
	gtk_column_view_column_set_fixed_width (_tmp7_, 0);
	_tmp8_ = self->priv->player_column;
	gtk_column_view_column_set_expand (_tmp8_, TRUE);
	_tmp9_ = self->priv->player_column;
	gtk_column_view_column_set_fixed_width (_tmp9_, 0);
	_tmp10_ = g_list_store_new (GAMES_SCORES_TYPE_SCORE);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp10_;
	_tmp11_ = self->priv->score_model;
	_tmp12_ = _g_object_ref0 ((GListModel*) _tmp11_);
	_tmp13_ = self->priv->score_view;
	_tmp14_ = gtk_column_view_get_sorter (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = gtk_sort_list_model_new (_tmp12_, _tmp16_);
	sort_model = _tmp17_;
	_tmp18_ = self->priv->score_view;
	_tmp19_ = sort_model;
	_tmp20_ = _g_object_ref0 ((GListModel*) _tmp19_);
	_tmp21_ = gtk_no_selection_new (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_column_view_set_model (_tmp18_, (GtkSelectionModel*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->score_view;
	_tmp24_ = self->priv->rank_column;
	gtk_column_view_sort_by_column (_tmp23_, _tmp24_, GTK_SORT_ASCENDING);
	_tmp25_ = self->priv->score_view;
	_tmp26_ = gtk_column_view_get_sorter (_tmp25_);
	_tmp27_ = _tmp26_;
	g_signal_connect_object (_tmp27_, "changed", (GCallback) ___lambda21__gtk_sorter_changed, self, 0);
	_tmp28_ = self->priv->new_high_score;
	if (_tmp28_ == NULL) {
		_g_object_unref0 (sort_model);
		return;
	}
	_tmp29_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
	controller = _tmp29_;
	_tmp30_ = controller;
	g_signal_connect_object (_tmp30_, "enter", (GCallback) ___lambda22__gtk_event_controller_focus_enter, self, 0);
	_tmp31_ = self->priv->score_view;
	_tmp32_ = controller;
	_tmp33_ = _g_object_ref0 ((GtkEventController*) _tmp32_);
	gtk_widget_add_controller ((GtkWidget*) _tmp31_, _tmp33_);
	_g_object_unref0 (controller);
	_g_object_unref0 (sort_model);
}

static void
__lambda11_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "caption");
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_inscription_set_xalign (label, 0.5f);
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda11__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda11_ ((GamesScoresDialog*) self, _sender, object);
}

static void
__lambda12_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GamesScoresScore* score = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_child (list_item);
	_tmp1_ = _tmp0_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp1_) : NULL;
	_tmp2_ = gtk_list_item_get_item (list_item);
	_tmp3_ = _tmp2_;
	score = GAMES_SCORES_IS_SCORE (_tmp3_) ? ((GamesScoresScore*) _tmp3_) : NULL;
	_tmp4_ = g_strdup_printf ("%u", score->rank);
	_tmp5_ = _tmp4_;
	gtk_inscription_set_text (label, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
___lambda12__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda12_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_rank_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkMultiSorter* sorter = NULL;
	GtkMultiSorter* _tmp1_;
	GtkSignalListItemFactory* _tmp2_;
	GtkSignalListItemFactory* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkSignalListItemFactory* _tmp9_;
	GtkListItemFactory* _tmp10_;
	GtkColumnViewColumn* _tmp11_;
	GtkColumnViewColumn* _tmp12_;
	GtkMultiSorter* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = gtk_multi_sorter_new ();
	sorter = _tmp1_;
	_tmp2_ = factory;
	g_signal_connect_object (_tmp2_, "setup", (GCallback) ___lambda11__gtk_signal_list_item_factory_setup, self, 0);
	_tmp3_ = factory;
	g_signal_connect_object (_tmp3_, "bind", (GCallback) ___lambda12__gtk_signal_list_item_factory_bind, self, 0);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->priv->scores_style == GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER;
	}
	if (_tmp4_) {
		GtkMultiSorter* _tmp5_;
		GtkCustomSorter* _tmp6_;
		_tmp5_ = sorter;
		_tmp6_ = gtk_custom_sorter_new ((GCompareDataFunc) games_scores_score_score_greater_sorter, NULL, NULL);
		gtk_multi_sorter_append (_tmp5_, (GtkSorter*) _tmp6_);
	} else {
		GtkMultiSorter* _tmp7_;
		GtkCustomSorter* _tmp8_;
		_tmp7_ = sorter;
		_tmp8_ = gtk_custom_sorter_new ((GCompareDataFunc) games_scores_score_score_less_sorter, NULL, NULL);
		gtk_multi_sorter_append (_tmp7_, (GtkSorter*) _tmp8_);
	}
	_tmp9_ = factory;
	_tmp10_ = _g_object_ref0 ((GtkListItemFactory*) _tmp9_);
	_tmp11_ = gtk_column_view_column_new ("Rank", _tmp10_);
	_g_object_unref0 (self->priv->rank_column);
	self->priv->rank_column = _tmp11_;
	_tmp12_ = self->priv->rank_column;
	_tmp13_ = sorter;
	gtk_column_view_column_set_sorter (_tmp12_, (GtkSorter*) _tmp13_);
	_g_object_unref0 (sorter);
	_g_object_unref0 (factory);
}

static void
__lambda13_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkInscription* _tmp0_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = (GtkInscription*) gtk_inscription_new (NULL);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "numeric");
	gtk_list_item_set_child (list_item, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
___lambda13__gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	__lambda13_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda14_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GamesScoresScore* score = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = gtk_list_item_get_child (list_item);
	_tmp1_ = _tmp0_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp1_) : NULL;
	_tmp2_ = gtk_list_item_get_item (list_item);
	_tmp3_ = _tmp2_;
	score = GAMES_SCORES_IS_SCORE (_tmp3_) ? ((GamesScoresScore*) _tmp3_) : NULL;
	_tmp4_ = games_scores_score_get_score (score);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%'ld", _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_inscription_set_text (label, _tmp7_);
	_g_free0 (_tmp7_);
}

static void
____lambda14__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda14_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda15_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GtkInscription* label = NULL;
	GtkListItem* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GamesScoresScore* _tmp6_;
	glong _tmp7_;
	glong _tmp8_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_inscription_get_type ()) ? ((GtkInscription*) _tmp2_) : NULL;
	_tmp3_ = list_item;
	_tmp4_ = gtk_list_item_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	score = GAMES_SCORES_IS_SCORE (_tmp5_) ? ((GamesScoresScore*) _tmp5_) : NULL;
	_tmp6_ = score;
	_tmp7_ = games_scores_score_get_score (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ >= ((glong) 60)) {
		GtkInscription* _tmp9_;
		GamesScoresScore* _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		GamesScoresScore* _tmp13_;
		glong _tmp14_;
		glong _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp9_ = label;
		_tmp10_ = score;
		_tmp11_ = games_scores_score_get_score (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = score;
		_tmp14_ = games_scores_score_get_score (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%ldm %lds", _tmp12_ / 60, _tmp15_ % 60);
		_tmp17_ = _tmp16_;
		gtk_inscription_set_text (_tmp9_, _tmp17_);
		_g_free0 (_tmp17_);
	} else {
		GtkInscription* _tmp18_;
		GamesScoresScore* _tmp19_;
		glong _tmp20_;
		glong _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp18_ = label;
		_tmp19_ = score;
		_tmp20_ = games_scores_score_get_score (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("%lds", _tmp21_);
		_tmp23_ = _tmp22_;
		gtk_inscription_set_text (_tmp18_, _tmp23_);
		_g_free0 (_tmp23_);
	}
}

static void
____lambda15__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                 GObject* object,
                                                 gpointer self)
{
	___lambda15_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_score_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_;
	GtkSignalListItemFactory* _tmp6_;
	GtkListItemFactory* _tmp7_;
	GtkColumnViewColumn* _tmp8_;
	GtkColumnViewColumn* _tmp9_;
	GtkColumnViewColumn* _tmp10_;
	GtkSorter* _tmp11_;
	GtkSorter* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = factory;
	g_signal_connect_object (_tmp1_, "setup", (GCallback) ___lambda13__gtk_signal_list_item_factory_setup, self, 0);
	if (self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->scores_style == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp2_) {
		GtkSignalListItemFactory* _tmp3_;
		_tmp3_ = factory;
		g_signal_connect_object (_tmp3_, "bind", (GCallback) ____lambda14__gtk_signal_list_item_factory_bind, self, 0);
	} else {
		GtkSignalListItemFactory* _tmp4_;
		_tmp4_ = factory;
		g_signal_connect_object (_tmp4_, "bind", (GCallback) ____lambda15__gtk_signal_list_item_factory_bind, self, 0);
	}
	_tmp5_ = self->priv->score_type;
	_tmp6_ = factory;
	_tmp7_ = _g_object_ref0 ((GtkListItemFactory*) _tmp6_);
	_tmp8_ = gtk_column_view_column_new (_tmp5_, _tmp7_);
	_g_object_unref0 (self->priv->score_column);
	self->priv->score_column = _tmp8_;
	_tmp9_ = self->priv->score_column;
	_tmp10_ = self->priv->rank_column;
	_tmp11_ = gtk_column_view_column_get_sorter (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_column_view_column_set_sorter (_tmp9_, _tmp12_);
	_g_object_unref0 (factory);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda17_ (Block3Data* _data3_)
{
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	GamesScoresScore* _tmp5_;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	self = _data3_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = _data3_->score;
	_tmp2_ = self->priv->active_category;
	_tmp3_ = self->priv->player_entry;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	games_scores_context_update_score_name (_tmp0_, _tmp1_, _tmp2_, _tmp4_);
	_tmp5_ = _data3_->score;
	_tmp6_ = self->priv->player_entry;
	_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
	games_scores_score_set_user (_tmp5_, _tmp7_);
}

static void
____lambda17__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda17_ (self);
}

static void
___lambda18_ (GamesScoresDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->new_game_button;
	if (_tmp0_ != NULL) {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->new_game_button;
		g_signal_emit_by_name (_tmp1_, "activate");
	} else {
		adw_dialog_close ((AdwDialog*) self);
	}
}

static void
____lambda18__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda18_ ((GamesScoresDialog*) self);
}

static gboolean
___lambda19_ (Block3Data* _data3_,
              gint x,
              gint y,
              gboolean keyboard_tooltip,
              GtkTooltip* tooltip)
{
	GamesScoresDialog* self;
	GamesScoresScore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GamesScoresScore* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GamesScoresScore* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = _data3_->score;
	_tmp1_ = games_scores_score_get_user (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data3_->score;
	_tmp4_ = games_scores_score_get_user_extra_info (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data3_->score;
	_tmp7_ = games_scores_score_get_time (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_date_time_new_from_unix_utc (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_date_time_format (_tmp10_, "%x");
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s\n%s\n%s", _tmp2_, _tmp5_, _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_tooltip_set_text (tooltip, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_date_time_unref0 (_tmp10_);
	_g_free0 (_tmp5_);
	result = TRUE;
	return result;
}

static gboolean
____lambda19__gtk_widget_query_tooltip (GtkWidget* _sender,
                                        gint x,
                                        gint y,
                                        gboolean keyboard_tooltip,
                                        GtkTooltip* tooltip,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda19_ (self, x, y, keyboard_tooltip, tooltip);
	return result;
}

static void
__lambda16_ (GamesScoresDialog* self,
             GtkSignalListItemFactory* factory,
             GObject* object)
{
	Block3Data* _data3_;
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GamesScoresScore* _tmp3_;
	GamesScoresScore* _tmp4_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_data3_->score = GAMES_SCORES_IS_SCORE (_tmp2_) ? ((GamesScoresScore*) _tmp2_) : NULL;
	_tmp3_ = _data3_->score;
	_tmp4_ = self->priv->new_high_score;
	if (_tmp3_ == _tmp4_) {
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		GamesScoresScore* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkEntry* _tmp10_;
		GtkEntry* _tmp11_;
		GtkEntry* _tmp12_;
		GtkEntry* _tmp13_;
		GtkListItem* _tmp14_;
		GtkEntry* _tmp15_;
		_tmp5_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->player_entry);
		self->priv->player_entry = _tmp5_;
		_tmp6_ = self->priv->player_entry;
		_tmp7_ = _data3_->score;
		_tmp8_ = games_scores_score_get_user (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_editable_set_text ((GtkEditable*) _tmp6_, _tmp9_);
		_tmp10_ = self->priv->player_entry;
		gtk_entry_set_has_frame (_tmp10_, FALSE);
		_tmp11_ = self->priv->player_entry;
		gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "heading");
		_tmp12_ = self->priv->player_entry;
		g_signal_connect_data ((GObject*) _tmp12_, "notify::text", (GCallback) ____lambda17__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp13_ = self->priv->player_entry;
		g_signal_connect_object (_tmp13_, "activate", (GCallback) ____lambda18__gtk_entry_activate, self, 0);
		_tmp14_ = list_item;
		_tmp15_ = self->priv->player_entry;
		gtk_list_item_set_child (_tmp14_, (GtkWidget*) _tmp15_);
	} else {
		GtkInscription* label = NULL;
		GamesScoresScore* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GtkInscription* _tmp19_;
		GtkInscription* _tmp20_;
		GtkInscription* _tmp21_;
		GtkListItem* _tmp22_;
		GtkInscription* _tmp23_;
		_tmp16_ = _data3_->score;
		_tmp17_ = games_scores_score_get_user (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = (GtkInscription*) gtk_inscription_new (_tmp18_);
		g_object_ref_sink (_tmp19_);
		label = _tmp19_;
		_tmp20_ = label;
		gtk_widget_set_has_tooltip ((GtkWidget*) _tmp20_, TRUE);
		_tmp21_ = label;
		g_signal_connect_data ((GtkWidget*) _tmp21_, "query-tooltip", (GCallback) ____lambda19__gtk_widget_query_tooltip, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp22_ = list_item;
		_tmp23_ = label;
		gtk_list_item_set_child (_tmp22_, (GtkWidget*) _tmp23_);
		_g_object_unref0 (label);
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
___lambda16__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda16_ ((GamesScoresDialog*) self, _sender, object);
}

static void
___lambda20_ (GamesScoresDialog* self,
              GtkSignalListItemFactory* factory,
              GObject* object)
{
	GtkListItem* list_item = NULL;
	GamesScoresScore* score = NULL;
	GtkListItem* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GamesScoresScore* _tmp3_;
	GamesScoresScore* _tmp4_;
	g_return_if_fail (factory != NULL);
	g_return_if_fail (object != NULL);
	list_item = G_TYPE_CHECK_INSTANCE_TYPE (object, gtk_list_item_get_type ()) ? ((GtkListItem*) object) : NULL;
	_tmp0_ = list_item;
	_tmp1_ = gtk_list_item_get_item (_tmp0_);
	_tmp2_ = _tmp1_;
	score = GAMES_SCORES_IS_SCORE (_tmp2_) ? ((GamesScoresScore*) _tmp2_) : NULL;
	_tmp3_ = score;
	_tmp4_ = self->priv->new_high_score;
	if (_tmp3_ == _tmp4_) {
		_g_object_unref0 (self->priv->player_entry);
		self->priv->player_entry = NULL;
	}
}

static void
____lambda20__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                   GObject* object,
                                                   gpointer self)
{
	___lambda20_ ((GamesScoresDialog*) self, _sender, object);
}

static void
games_scores_dialog_set_up_player_column (GamesScoresDialog* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	GamesScoresScore* _tmp2_;
	GtkSignalListItemFactory* _tmp4_;
	GtkListItemFactory* _tmp5_;
	GtkColumnViewColumn* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = factory;
	g_signal_connect_object (_tmp1_, "bind", (GCallback) ___lambda16__gtk_signal_list_item_factory_bind, self, 0);
	_tmp2_ = self->priv->new_high_score;
	if (_tmp2_ != NULL) {
		GtkSignalListItemFactory* _tmp3_;
		_tmp3_ = factory;
		g_signal_connect_object (_tmp3_, "unbind", (GCallback) ____lambda20__gtk_signal_list_item_factory_unbind, self, 0);
	}
	_tmp4_ = factory;
	_tmp5_ = _g_object_ref0 ((GtkListItemFactory*) _tmp4_);
	_tmp6_ = gtk_column_view_column_new (_ ("Player"), _tmp5_);
	_g_object_unref0 (self->priv->player_column);
	self->priv->player_column = _tmp6_;
	_g_object_unref0 (factory);
}

static void
__lambda24_ (GamesScoresDialog* self)
{
	games_scores_dialog_set_action (self, GAMES_SCORES_ADD_SCORE_ACTION_NEW_GAME);
	adw_dialog_close ((AdwDialog*) self);
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda24_ ((GamesScoresDialog*) self);
}

static void
__lambda25_ (GamesScoresDialog* self)
{
	games_scores_dialog_set_action (self, GAMES_SCORES_ADD_SCORE_ACTION_QUIT);
	adw_dialog_close ((AdwDialog*) self);
}

static void
___lambda25__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda25_ ((GamesScoresDialog*) self);
}

void
games_scores_dialog_add_bottom_buttons (GamesScoresDialog* self)
{
	AdwHeaderBar* _tmp0_;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	AdwButtonContent* quit_button_content = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	AdwButtonContent* _tmp5_ = NULL;
	GtkButton* quit_button = NULL;
	GtkWidget* _tmp6_;
	GtkButton* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkCenterBox* bottom_bar = NULL;
	GtkButton* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkCenterBox* _tmp12_ = NULL;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	AdwToolbarView* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	adw_header_bar_set_show_end_title_buttons (_tmp0_, TRUE);
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("_New Game"));
	gtk_button_set_can_shrink (_tmp1_, TRUE);
	gtk_button_set_use_underline (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp1_;
	_tmp2_ = self->priv->new_game_button;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda24__gtk_button_clicked, self, 0);
	_tmp3_ = g_strdup ("application-exit-symbolic");
	_tmp4_ = g_strdup (_ ("_Quit"));
	_tmp5_ = (AdwButtonContent*) adw_button_content_new ();
	adw_button_content_set_icon_name (_tmp5_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_button_content_set_label (_tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_button_content_set_use_underline (_tmp5_, TRUE);
	adw_button_content_set_can_shrink (_tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	quit_button_content = _tmp5_;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) quit_button_content);
	_tmp7_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp7_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_button_set_can_shrink (_tmp7_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp7_);
	quit_button = _tmp7_;
	g_signal_connect_object (quit_button, "clicked", (GCallback) ___lambda25__gtk_button_clicked, self, 0);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = self->priv->new_game_button;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 ((GtkWidget*) quit_button);
	_tmp12_ = (GtkCenterBox*) gtk_center_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_center_box_set_center_widget (_tmp12_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_center_box_set_end_widget (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	bottom_bar = _tmp12_;
	gtk_box_append (box, (GtkWidget*) bottom_bar);
	_tmp13_ = self->priv->new_game_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, "pill");
	_tmp14_ = self->priv->new_game_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "suggested-action");
	gtk_widget_add_css_class ((GtkWidget*) box, "toolbar");
	gtk_widget_add_css_class ((GtkWidget*) bottom_bar, "toolbar");
	_tmp15_ = self->priv->toolbar;
	adw_toolbar_view_add_bottom_bar (_tmp15_, (GtkWidget*) box);
	_g_object_unref0 (bottom_bar);
	_g_object_unref0 (box);
	_g_object_unref0 (quit_button);
	_g_object_unref0 (quit_button_content);
}

static void
games_scores_dialog_show_clear_scores_dialog_data_free (gpointer _data)
{
	GamesScoresDialogShowClearScoresDialogData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresDialogShowClearScoresDialogData, _data_);
}

static void
games_scores_dialog_show_clear_scores_dialog (GamesScoresDialog* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GamesScoresDialogShowClearScoresDialogData* _data_;
	GamesScoresDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesScoresDialogShowClearScoresDialogData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_dialog_show_clear_scores_dialog_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_scores_dialog_show_clear_scores_dialog_co (_data_);
}

static void
games_scores_dialog_show_clear_scores_dialog_finish (GamesScoresDialog* self,
                                                     GAsyncResult* _res_)
{
	GamesScoresDialogShowClearScoresDialogData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_scores_dialog_show_clear_scores_dialog_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GamesScoresDialogShowClearScoresDialogData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_scores_dialog_show_clear_scores_dialog_co (_data_);
}

static void
___lambda9_ (GamesScoresDialog* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->context;
		games_scores_context_delete_scores_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("dialog.vala:452: Failed to delete scores: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda9__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda9_ ((GamesScoresDialog*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
games_scores_dialog_show_clear_scores_dialog_co (GamesScoresDialogShowClearScoresDialogData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Clear All Scores?"), _ ("This will clear every score for every layout."));
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	adw_alert_dialog_set_default_response (_data_->_tmp1_, "cancel");
	_data_->_tmp2_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp2_, "cancel", _ ("_Cancel"));
	_data_->_tmp3_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp3_, "clear", _ ("Clear All"));
	_data_->_tmp4_ = _data_->dialog;
	adw_alert_dialog_set_response_appearance (_data_->_tmp4_, "clear", ADW_RESPONSE_DESTRUCTIVE);
	_data_->_tmp5_ = _data_->dialog;
	_data_->_state_ = 1;
	adw_alert_dialog_choose (_data_->_tmp5_, (GtkWidget*) _data_->self, NULL, games_scores_dialog_show_clear_scores_dialog_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = adw_alert_dialog_choose_finish (_data_->_tmp5_, _data_->_res_);
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->response = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->response;
	if (g_strcmp0 (_data_->_tmp8_, "clear") == 0) {
		adw_dialog_close ((AdwDialog*) _data_->self);
		_data_->_tmp9_ = _data_->self->priv->context;
		games_scores_context_delete_scores (_data_->_tmp9_, ____lambda9__gasync_ready_callback, g_object_ref (_data_->self));
	}
	_g_free0 (_data_->response);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GamesScoresAddScoreAction
games_scores_dialog_get_action (GamesScoresDialog* self)
{
	GamesScoresAddScoreAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_action;
	return result;
}

void
games_scores_dialog_set_action (GamesScoresDialog* self,
                                GamesScoresAddScoreAction value)
{
	GamesScoresAddScoreAction old_value;
	g_return_if_fail (self != NULL);
	old_value = games_scores_dialog_get_action (self);
	if (old_value != value) {
		self->priv->_action = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_dialog_properties[GAMES_SCORES_DIALOG_ACTION_PROPERTY]);
	}
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_DIALOG_ACTION_PROPERTY, games_scores_dialog_properties[GAMES_SCORES_DIALOG_ACTION_PROPERTY] = g_param_spec_enum ("action", "action", "action", GAMES_SCORES_TYPE_ADD_SCORE_ACTION, GAMES_SCORES_ADD_SCORE_ACTION_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->active_category = NULL;
	self->priv->score_model = NULL;
	self->priv->new_game_button = NULL;
	self->priv->drop_down = NULL;
	self->priv->_action = GAMES_SCORES_ADD_SCORE_ACTION_NONE;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->active_category);
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->drop_down);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->rank_column);
	_g_object_unref0 (self->priv->score_column);
	_g_object_unref0 (self->priv->player_column);
	_g_object_unref0 (self->priv->player_entry);
	self->priv->categories = (_vala_array_free (self->priv->categories, self->priv->categories_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->new_high_score);
	_g_free0 (self->priv->score_type);
	_g_free0 (self->priv->category_type);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
games_scores_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
	GType games_scores_dialog_type_id;
	games_scores_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
	GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
	return games_scores_dialog_type_id;
}

GType
games_scores_dialog_get_type (void)
{
	static gsize games_scores_dialog_type_id__once = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__once)) {
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = games_scores_dialog_get_type_once ();
		g_once_init_leave (&games_scores_dialog_type_id__once, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__once;
}

static void
_vala_games_scores_dialog_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	switch (property_id) {
		case GAMES_SCORES_DIALOG_ACTION_PROPERTY:
		g_value_set_enum (value, games_scores_dialog_get_action (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_scores_dialog_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	switch (property_id) {
		case GAMES_SCORES_DIALOG_ACTION_PROPERTY:
		games_scores_dialog_set_action (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

