/* gitg-history-command-line.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-history-command-line.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include "libgitg.h"
#include <stdio.h>

#define GITG_HISTORY_COMMAND_LINE_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_HISTORY_TYPE_COMMAND_LINE (gitg_history_command_line_get_type ())
#define GITG_HISTORY_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLine))
#define GITG_HISTORY_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))
#define GITG_HISTORY_IS_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_IS_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_COMMAND_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))

typedef struct _GitgHistoryCommandLine GitgHistoryCommandLine;
typedef struct _GitgHistoryCommandLineClass GitgHistoryCommandLineClass;
typedef struct _GitgHistoryCommandLinePrivate GitgHistoryCommandLinePrivate;
enum  {
	GITG_HISTORY_COMMAND_LINE_0_PROPERTY,
	GITG_HISTORY_COMMAND_LINE_NUM_PROPERTIES
};
static GParamSpec* gitg_history_command_line_properties[GITG_HISTORY_COMMAND_LINE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_HISTORY_TYPE_ACTIVITY (gitg_history_activity_get_type ())
#define GITG_HISTORY_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_ACTIVITY, GitgHistoryActivity))
#define GITG_HISTORY_ACTIVITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_ACTIVITY, GitgHistoryActivityClass))
#define GITG_HISTORY_IS_ACTIVITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_ACTIVITY))
#define GITG_HISTORY_IS_ACTIVITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_ACTIVITY))
#define GITG_HISTORY_ACTIVITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_ACTIVITY, GitgHistoryActivityClass))

typedef struct _GitgHistoryActivity GitgHistoryActivity;
typedef struct _GitgHistoryActivityClass GitgHistoryActivityClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_HISTORY_TYPE_REFS_LIST (gitg_history_refs_list_get_type ())
#define GITG_HISTORY_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList))
#define GITG_HISTORY_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))
#define GITG_HISTORY_IS_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_IS_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_REFS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))

typedef struct _GitgHistoryRefsList GitgHistoryRefsList;
typedef struct _GitgHistoryRefsListClass GitgHistoryRefsListClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgHistoryCommandLine {
	GObject parent_instance;
	GitgHistoryCommandLinePrivate * priv;
};

struct _GitgHistoryCommandLineClass {
	GObjectClass parent_class;
};

struct _GitgHistoryCommandLinePrivate {
	gchar* d_select_reference;
	gboolean d_all_commits;
	gboolean d_all_branches;
	gboolean d_all_remotes;
	gboolean d_all_tags;
};

static gint GitgHistoryCommandLine_private_offset;
static gpointer gitg_history_command_line_parent_class = NULL;
static gboolean gitg_history_command_line_s_all_commits;
static gboolean gitg_history_command_line_s_all_branches;
static gboolean gitg_history_command_line_s_all_remotes;
static gboolean gitg_history_command_line_s_all_tags;
static gchar* gitg_history_command_line_s_select_reference;
static gchar* gitg_history_command_line_s_select_reference = NULL;
static gboolean gitg_history_command_line_s_all_commits = FALSE;
static gboolean gitg_history_command_line_s_all_branches = FALSE;
static gboolean gitg_history_command_line_s_all_remotes = FALSE;
static gboolean gitg_history_command_line_s_all_tags = FALSE;
static GitgExtCommandLineIface * gitg_history_command_line_gitg_ext_command_line_parent_iface = NULL;

VALA_EXTERN GType gitg_history_command_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryCommandLine, g_object_unref)
static GOptionGroup* gitg_history_command_line_real_get_option_group (GitgExtCommandLine* base);
static void gitg_history_command_line_real_parse_finished (GitgExtCommandLine* base);
static void gitg_history_command_line_real_apply (GitgExtCommandLine* base,
                                           GitgExtApplication* application);
VALA_EXTERN GType gitg_history_activity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryActivity, g_object_unref)
VALA_EXTERN GType gitg_history_refs_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryRefsList, g_object_unref)
VALA_EXTERN GitgHistoryRefsList* gitg_history_activity_get_refs_list (GitgHistoryActivity* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_commits (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_branches (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_remotes (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_all_tags (GitgHistoryRefsList* self);
VALA_EXTERN gboolean gitg_history_refs_list_select_ref (GitgHistoryRefsList* self,
                                            GitgRef* reference);
VALA_EXTERN GitgHistoryCommandLine* gitg_history_command_line_new (void);
VALA_EXTERN GitgHistoryCommandLine* gitg_history_command_line_construct (GType object_type);
static void gitg_history_command_line_finalize (GObject * obj);
static GType gitg_history_command_line_get_type_once (void);

static const GOptionEntry GITG_HISTORY_COMMAND_LINE_s_entries[6] = {{"all", 'a', (gint) G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, &gitg_history_command_line_s_all_commits, N_ ("Select all commits by default in the history activity"), NULL}, {"branches", 'b', (gint) G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, &gitg_history_command_line_s_all_branches, N_ ("Select all branches by default in the history activity"), NULL}, {"remotes", 'r', (gint) G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, &gitg_history_command_line_s_all_remotes, N_ ("Select all remotes by default in the history activity"), NULL}, {"tags", 't', (gint) G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_NONE, &gitg_history_command_line_s_all_tags, N_ ("Select all tags by default in the history activity"), NULL}, {"select-reference", 's', (gint) G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_STRING, &gitg_history_command_line_s_select_reference, N_ ("Select the specified reference by default in the history activity"), N_ ("REFERENCE")}, {NULL}};

static inline gpointer
gitg_history_command_line_get_instance_private (GitgHistoryCommandLine* self)
{
	return G_STRUCT_MEMBER_P (self, GitgHistoryCommandLine_private_offset);
}

static GOptionGroup*
gitg_history_command_line_real_get_option_group (GitgExtCommandLine* base)
{
	GitgHistoryCommandLine * self;
	GOptionGroup* group = NULL;
	GOptionGroup* _tmp0_;
	GOptionGroup* result;
	self = (GitgHistoryCommandLine*) base;
	_tmp0_ = g_option_group_new ("", "", "", NULL, NULL);
	group = _tmp0_;
	g_option_group_add_entries (group, GITG_HISTORY_COMMAND_LINE_s_entries);
	result = group;
	return result;
}

static void
gitg_history_command_line_real_parse_finished (GitgExtCommandLine* base)
{
	GitgHistoryCommandLine * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GitgHistoryCommandLine*) base;
	_tmp0_ = gitg_history_command_line_s_select_reference;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->d_select_reference);
	self->priv->d_select_reference = _tmp1_;
	self->priv->d_all_commits = gitg_history_command_line_s_all_commits;
	self->priv->d_all_branches = gitg_history_command_line_s_all_branches;
	self->priv->d_all_remotes = gitg_history_command_line_s_all_remotes;
	self->priv->d_all_tags = gitg_history_command_line_s_all_tags;
}

static void
gitg_history_command_line_real_apply (GitgExtCommandLine* base,
                                      GitgExtApplication* application)
{
	GitgHistoryCommandLine * self;
	GitgHistoryActivity* history = NULL;
	GitgExtActivity* _tmp0_;
	GitgHistoryActivity* _tmp1_;
	GitgHistoryActivity* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (GitgHistoryCommandLine*) base;
	g_return_if_fail (application != NULL);
	_tmp0_ = gitg_ext_application_get_activity_by_id (application, "/org/gnome/gitg/Activities/History");
	_tmp1_ = GITG_HISTORY_IS_ACTIVITY (_tmp0_) ? ((GitgHistoryActivity*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	history = _tmp1_;
	_tmp2_ = history;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (history);
		return;
	}
	if (self->priv->d_all_commits) {
		GitgHistoryActivity* _tmp3_;
		GitgHistoryRefsList* _tmp4_;
		GitgHistoryRefsList* _tmp5_;
		_tmp3_ = history;
		_tmp4_ = gitg_history_activity_get_refs_list (_tmp3_);
		_tmp5_ = _tmp4_;
		gitg_history_refs_list_select_all_commits (_tmp5_);
	} else {
		if (self->priv->d_all_branches) {
			GitgHistoryActivity* _tmp6_;
			GitgHistoryRefsList* _tmp7_;
			GitgHistoryRefsList* _tmp8_;
			_tmp6_ = history;
			_tmp7_ = gitg_history_activity_get_refs_list (_tmp6_);
			_tmp8_ = _tmp7_;
			gitg_history_refs_list_select_all_branches (_tmp8_);
		} else {
			if (self->priv->d_all_remotes) {
				GitgHistoryActivity* _tmp9_;
				GitgHistoryRefsList* _tmp10_;
				GitgHistoryRefsList* _tmp11_;
				_tmp9_ = history;
				_tmp10_ = gitg_history_activity_get_refs_list (_tmp9_);
				_tmp11_ = _tmp10_;
				gitg_history_refs_list_select_all_remotes (_tmp11_);
			} else {
				if (self->priv->d_all_tags) {
					GitgHistoryActivity* _tmp12_;
					GitgHistoryRefsList* _tmp13_;
					GitgHistoryRefsList* _tmp14_;
					_tmp12_ = history;
					_tmp13_ = gitg_history_activity_get_refs_list (_tmp12_);
					_tmp14_ = _tmp13_;
					gitg_history_refs_list_select_all_tags (_tmp14_);
				} else {
					const gchar* _tmp15_;
					_tmp15_ = self->priv->d_select_reference;
					if (_tmp15_ != NULL) {
						{
							GitgRef* _tmp16_ = NULL;
							GitgRepository* _tmp17_;
							GitgRepository* _tmp18_;
							GitgRepository* _tmp19_;
							const gchar* _tmp20_;
							GitgRef* _tmp21_;
							GitgRef* _tmp22_;
							GitgHistoryActivity* _tmp23_;
							GitgHistoryRefsList* _tmp24_;
							GitgHistoryRefsList* _tmp25_;
							_tmp17_ = gitg_ext_application_get_repository (application);
							_tmp18_ = _tmp17_;
							_tmp19_ = _tmp18_;
							_tmp20_ = self->priv->d_select_reference;
							_tmp21_ = gitg_repository_lookup_reference_dwim (_tmp19_, _tmp20_, &_inner_error0_);
							_tmp22_ = _tmp21_;
							_g_object_unref0 (_tmp19_);
							_tmp16_ = _tmp22_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
							_tmp23_ = history;
							_tmp24_ = gitg_history_activity_get_refs_list (_tmp23_);
							_tmp25_ = _tmp24_;
							gitg_history_refs_list_select_ref (_tmp25_, _tmp16_);
							_g_object_unref0 (_tmp16_);
						}
						goto __finally0;
						__catch0_g_error:
						{
							GError* e = NULL;
							FILE* _tmp26_;
							const gchar* _tmp27_;
							GError* _tmp28_;
							const gchar* _tmp29_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp26_ = stderr;
							_tmp27_ = self->priv->d_select_reference;
							_tmp28_ = e;
							_tmp29_ = _tmp28_->message;
							fprintf (_tmp26_, "Failed to lookup reference %s: %s\n", _tmp27_, _tmp29_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (history);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (history);
}

GitgHistoryCommandLine*
gitg_history_command_line_construct (GType object_type)
{
	GitgHistoryCommandLine * self = NULL;
	self = (GitgHistoryCommandLine*) g_object_new (object_type, NULL);
	return self;
}

GitgHistoryCommandLine*
gitg_history_command_line_new (void)
{
	return gitg_history_command_line_construct (GITG_HISTORY_TYPE_COMMAND_LINE);
}

static void
gitg_history_command_line_class_init (GitgHistoryCommandLineClass * klass,
                                      gpointer klass_data)
{
	gitg_history_command_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgHistoryCommandLine_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gitg_history_command_line_finalize;
}

static void
gitg_history_command_line_gitg_ext_command_line_interface_init (GitgExtCommandLineIface * iface,
                                                                gpointer iface_data)
{
	gitg_history_command_line_gitg_ext_command_line_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_option_group = (GOptionGroup* (*) (GitgExtCommandLine*)) gitg_history_command_line_real_get_option_group;
	iface->parse_finished = (void (*) (GitgExtCommandLine*)) gitg_history_command_line_real_parse_finished;
	iface->apply = (void (*) (GitgExtCommandLine*, GitgExtApplication*)) gitg_history_command_line_real_apply;
}

static void
gitg_history_command_line_instance_init (GitgHistoryCommandLine * self,
                                         gpointer klass)
{
	self->priv = gitg_history_command_line_get_instance_private (self);
}

static void
gitg_history_command_line_finalize (GObject * obj)
{
	GitgHistoryCommandLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLine);
	_g_free0 (self->priv->d_select_reference);
	G_OBJECT_CLASS (gitg_history_command_line_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_history_command_line_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryCommandLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_command_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryCommandLine), 0, (GInstanceInitFunc) gitg_history_command_line_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_command_line_info = { (GInterfaceInitFunc) gitg_history_command_line_gitg_ext_command_line_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_history_command_line_type_id;
	gitg_history_command_line_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgHistoryCommandLine", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_history_command_line_type_id, GITG_EXT_TYPE_COMMAND_LINE, &gitg_ext_command_line_info);
	GitgHistoryCommandLine_private_offset = g_type_add_instance_private (gitg_history_command_line_type_id, sizeof (GitgHistoryCommandLinePrivate));
	return gitg_history_command_line_type_id;
}

GType
gitg_history_command_line_get_type (void)
{
	static gsize gitg_history_command_line_type_id__once = 0;
	if (g_once_init_enter (&gitg_history_command_line_type_id__once)) {
		GType gitg_history_command_line_type_id;
		gitg_history_command_line_type_id = gitg_history_command_line_get_type_once ();
		g_once_init_leave (&gitg_history_command_line_type_id__once, gitg_history_command_line_type_id);
	}
	return gitg_history_command_line_type_id__once;
}

