/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_PRIVATE_SERVER_PROTOCOL_H
#define GAMESCOPE_PRIVATE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_gamescope_private The gamescope_private protocol
 * gamescope-specific protocol
 *
 * @section page_desc_gamescope_private Description
 *
 * This is a private Gamescope protocol, mainly for debugging.
 * No stable ABI is guaranteed for this protocol, it is versioned with gamescope.
 *
 * @section page_ifaces_gamescope_private Interfaces
 * - @subpage page_iface_gamescope_private - 
 * @section page_copyright_gamescope_private Copyright
 * <pre>
 *
 * Copyright © 2023 Valve Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_private;

#ifndef GAMESCOPE_PRIVATE_INTERFACE
#define GAMESCOPE_PRIVATE_INTERFACE
/**
 * @page page_iface_gamescope_private gamescope_private
 * @section page_iface_gamescope_private_api API
 * See @ref iface_gamescope_private.
 */
/**
 * @defgroup iface_gamescope_private The gamescope_private interface
 */
extern const struct wl_interface gamescope_private_interface;
#endif

/**
 * @ingroup iface_gamescope_private
 * @struct gamescope_private_interface
 */
struct gamescope_private_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * @param cvar_name Convar name
	 * @param value Convar value (as a string)
	 */
	void (*execute)(struct wl_client *client,
			struct wl_resource *resource,
			const char *cvar_name,
			const char *value);
};

#define GAMESCOPE_PRIVATE_LOG 0
#define GAMESCOPE_PRIVATE_COMMAND_EXECUTED 1

/**
 * @ingroup iface_gamescope_private
 */
#define GAMESCOPE_PRIVATE_LOG_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_private
 */
#define GAMESCOPE_PRIVATE_COMMAND_EXECUTED_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_private
 */
#define GAMESCOPE_PRIVATE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_private
 */
#define GAMESCOPE_PRIVATE_EXECUTE_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_private
 * Sends an log event to the client owning the resource.
 * @param resource_ The client's resource
 * @param text Log string
 */
static inline void
gamescope_private_send_log(struct wl_resource *resource_, const char *text)
{
	wl_resource_post_event(resource_, GAMESCOPE_PRIVATE_LOG, text);
}

/**
 * @ingroup iface_gamescope_private
 * Sends an command_executed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
gamescope_private_send_command_executed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, GAMESCOPE_PRIVATE_COMMAND_EXECUTED);
}

#ifdef  __cplusplus
}
#endif

#endif
