/* TouchpadBackend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TouchpadBackend.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <clutter/clutter.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>

#define GALA_TOUCHPAD_BACKEND_TOUCHPAD_BASE_HEIGHT 300
#define GALA_TOUCHPAD_BACKEND_TOUCHPAD_BASE_WIDTH 400
#define GALA_TOUCHPAD_BACKEND_DRAG_THRESHOLD_DISTANCE 16
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GALA_TYPE_GESTURE_BACKEND (gala_gesture_backend_get_type ())
#define GALA_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackend))
#define GALA_IS_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_BACKEND))
#define GALA_GESTURE_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackendIface))

typedef struct _GalaGestureBackend GalaGestureBackend;
typedef struct _GalaGestureBackendIface GalaGestureBackendIface;

#define GALA_TYPE_TOUCHPAD_BACKEND (gala_touchpad_backend_get_type ())
#define GALA_TOUCHPAD_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackend))
#define GALA_TOUCHPAD_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackendClass))
#define GALA_IS_TOUCHPAD_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOUCHPAD_BACKEND))
#define GALA_IS_TOUCHPAD_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOUCHPAD_BACKEND))
#define GALA_TOUCHPAD_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackendClass))

typedef struct _GalaTouchpadBackend GalaTouchpadBackend;
typedef struct _GalaTouchpadBackendClass GalaTouchpadBackendClass;
typedef struct _GalaTouchpadBackendPrivate GalaTouchpadBackendPrivate;
typedef enum  {
	GALA_TOUCHPAD_BACKEND_STATE_NONE,
	GALA_TOUCHPAD_BACKEND_STATE_IGNORED,
	GALA_TOUCHPAD_BACKEND_STATE_IGNORED_HORIZONTAL,
	GALA_TOUCHPAD_BACKEND_STATE_IGNORED_VERTICAL,
	GALA_TOUCHPAD_BACKEND_STATE_ONGOING
} GalaTouchpadBackendState;

#define GALA_TOUCHPAD_BACKEND_TYPE_STATE (gala_touchpad_backend_state_get_type ())
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
enum  {
	GALA_TOUCHPAD_BACKEND_0_PROPERTY,
	GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY,
	GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY,
	GALA_TOUCHPAD_BACKEND_NUM_PROPERTIES
};
static GParamSpec* gala_touchpad_backend_properties[GALA_TOUCHPAD_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;
#define _gala_gesture_unref0(var) ((var == NULL) ? NULL : (var = (gala_gesture_unref (var), NULL)))
typedef struct _GalaGesturePrivate GalaGesturePrivate;

struct _GalaGestureBackendIface {
	GTypeInterface parent_iface;
	void (*prepare_gesture_handling) (GalaGestureBackend* self);
	void (*cancel_gesture) (GalaGestureBackend* self);
};

struct _GalaTouchpadBackend {
	GObject parent_instance;
	GalaTouchpadBackendPrivate * priv;
};

struct _GalaTouchpadBackendClass {
	GObjectClass parent_class;
};

struct _GalaTouchpadBackendPrivate {
	ClutterActor* _actor;
	GalaGestureControllerGroup _group;
	GalaTouchpadBackendState state;
	GalaGestureDirection direction;
	gdouble distance_x;
	gdouble distance_y;
	gdouble distance;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
	gfloat origin_x;
	gfloat origin_y;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

static gint GalaTouchpadBackend_private_offset;
static gpointer gala_touchpad_backend_parent_class = NULL;
static GList* gala_touchpad_backend_instances;
static GList* gala_touchpad_backend_instances = NULL;
static GalaGestureBackendIface * gala_touchpad_backend_gala_gesture_backend_parent_iface = NULL;

 G_GNUC_INTERNAL GType gala_gesture_backend_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gala_touchpad_backend_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType gala_touchpad_backend_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
 G_GNUC_INTERNAL GalaTouchpadBackend* gala_touchpad_backend_new (ClutterActor* actor,
                                                GalaGestureControllerGroup group);
 G_GNUC_INTERNAL GalaTouchpadBackend* gala_touchpad_backend_construct (GType object_type,
                                                      ClutterActor* actor,
                                                      GalaGestureControllerGroup group);
static void gala_touchpad_backend_real_cancel_gesture (GalaGestureBackend* base);
static gboolean gala_touchpad_backend_on_captured_event (GalaTouchpadBackend* self,
                                                  ClutterEvent* event);
static gboolean gala_touchpad_backend_handle_event (GalaTouchpadBackend* self,
                                             ClutterEvent* event,
                                             gboolean main_handler);
static void gala_touchpad_backend_reset (GalaTouchpadBackend* self);
 G_GNUC_INTERNAL gpointer gala_gesture_ref (gpointer instance);
 G_GNUC_INTERNAL void gala_gesture_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
 G_GNUC_INTERNAL void gala_value_set_gesture (GValue* value,
                             gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
 G_GNUC_INTERNAL gpointer gala_value_get_gesture (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gala_gesture_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GalaGesture* gala_gesture_new (void);
 G_GNUC_INTERNAL GalaGesture* gala_gesture_construct (GType object_type);
 G_GNUC_INTERNAL GalaGestureControllerGroup gala_touchpad_backend_get_group (GalaTouchpadBackend* self);
static gdouble gala_touchpad_backend_get_value_for_direction (GalaTouchpadBackend* self,
                                                       gdouble delta_x,
                                                       gdouble delta_y);
static gdouble gala_touchpad_backend_get_percentage (GalaTouchpadBackend* self,
                                              gdouble value);
 G_GNUC_INTERNAL ClutterActor* gala_touchpad_backend_get_actor (GalaTouchpadBackend* self);
static void gala_touchpad_backend_set_actor (GalaTouchpadBackend* self,
                                      ClutterActor* value);
static void gala_touchpad_backend_set_group (GalaTouchpadBackend* self,
                                      GalaGestureControllerGroup value);
static GObject * gala_touchpad_backend_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static gboolean _gala_touchpad_backend_on_captured_event_clutter_actor_captured_event (ClutterActor* _sender,
                                                                                ClutterEvent* event,
                                                                                gpointer self);
 G_GNUC_INTERNAL void gala_gesture_backend_cancel_gesture (GalaGestureBackend* self);
static void gala_touchpad_backend_finalize (GObject * obj);
static GType gala_touchpad_backend_get_type_once (void);
static void _vala_gala_touchpad_backend_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gala_touchpad_backend_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
gala_touchpad_backend_get_instance_private (GalaTouchpadBackend* self)
{
	return G_STRUCT_MEMBER_P (self, GalaTouchpadBackend_private_offset);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

 G_GNUC_NO_INLINE static GType
gala_touchpad_backend_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_TOUCHPAD_BACKEND_STATE_NONE, "GALA_TOUCHPAD_BACKEND_STATE_NONE", "none"}, {GALA_TOUCHPAD_BACKEND_STATE_IGNORED, "GALA_TOUCHPAD_BACKEND_STATE_IGNORED", "ignored"}, {GALA_TOUCHPAD_BACKEND_STATE_IGNORED_HORIZONTAL, "GALA_TOUCHPAD_BACKEND_STATE_IGNORED_HORIZONTAL", "ignored-horizontal"}, {GALA_TOUCHPAD_BACKEND_STATE_IGNORED_VERTICAL, "GALA_TOUCHPAD_BACKEND_STATE_IGNORED_VERTICAL", "ignored-vertical"}, {GALA_TOUCHPAD_BACKEND_STATE_ONGOING, "GALA_TOUCHPAD_BACKEND_STATE_ONGOING", "ongoing"}, {0, NULL, NULL}};
	GType gala_touchpad_backend_state_type_id;
	gala_touchpad_backend_state_type_id = g_enum_register_static ("GalaTouchpadBackendState", values);
	return gala_touchpad_backend_state_type_id;
}

static GType
gala_touchpad_backend_state_get_type (void)
{
	static gsize gala_touchpad_backend_state_type_id__once = 0;
	if (g_once_init_enter (&gala_touchpad_backend_state_type_id__once)) {
		GType gala_touchpad_backend_state_type_id;
		gala_touchpad_backend_state_type_id = gala_touchpad_backend_state_get_type_once ();
		g_once_init_leave (&gala_touchpad_backend_state_type_id__once, gala_touchpad_backend_state_type_id);
	}
	return gala_touchpad_backend_state_type_id__once;
}

 G_GNUC_INTERNAL GalaTouchpadBackend*
gala_touchpad_backend_construct (GType object_type,
                                 ClutterActor* actor,
                                 GalaGestureControllerGroup group)
{
	GalaTouchpadBackend * self = NULL;
	g_return_val_if_fail (actor != NULL, NULL);
	self = (GalaTouchpadBackend*) g_object_new (object_type, "actor", actor, "group", group, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaTouchpadBackend*
gala_touchpad_backend_new (ClutterActor* actor,
                           GalaGestureControllerGroup group)
{
	return gala_touchpad_backend_construct (GALA_TYPE_TOUCHPAD_BACKEND, actor, group);
}

static void
gala_touchpad_backend_real_cancel_gesture (GalaGestureBackend* base)
{
	GalaTouchpadBackend * self;
	self = (GalaTouchpadBackend*) base;
	self->priv->state = GALA_TOUCHPAD_BACKEND_STATE_IGNORED;
}

static gboolean
gala_touchpad_backend_on_captured_event (GalaTouchpadBackend* self,
                                         ClutterEvent* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	result = gala_touchpad_backend_handle_event (self, event, TRUE);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gala_touchpad_backend_handle_event (GalaTouchpadBackend* self,
                                    ClutterEvent* event,
                                    gboolean main_handler)
{
	gdouble delta_x = 0.0;
	gdouble delta_y = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble percentage = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (clutter_event_type (event) != CLUTTER_TOUCHPAD_SWIPE) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	if (self->priv->state == GALA_TOUCHPAD_BACKEND_STATE_IGNORED) {
		gboolean _tmp0_ = FALSE;
		if (clutter_event_get_gesture_phase (event) == CLUTTER_TOUCHPAD_GESTURE_PHASE_END) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = clutter_event_get_gesture_phase (event) == CLUTTER_TOUCHPAD_GESTURE_PHASE_CANCEL;
		}
		if (_tmp0_) {
			gala_touchpad_backend_reset (self);
		}
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	clutter_event_get_gesture_motion_delta_unaccelerated (event, &_tmp1_, &_tmp2_);
	delta_x = _tmp1_;
	delta_y = _tmp2_;
	if (self->priv->state != GALA_TOUCHPAD_BACKEND_STATE_ONGOING) {
		GalaGesture* gesture = NULL;
		GalaTouchpadBackendState state_if_ignored = 0;
		gint _tmp3_ = 0;
		gint threshold = 0;
		gboolean _tmp4_ = FALSE;
		GalaGesture* _tmp12_;
		GalaGesture* _tmp13_;
		GalaGesture* _tmp14_;
		ClutterInputDevice* _tmp15_;
		GalaGesture* _tmp16_;
		gboolean _tmp17_ = FALSE;
		self->priv->distance_x = self->priv->distance_x + delta_x;
		self->priv->distance_y = self->priv->distance_y + delta_y;
		gesture = NULL;
		state_if_ignored = GALA_TOUCHPAD_BACKEND_STATE_NONE;
		if (main_handler) {
			_tmp3_ = GALA_TOUCHPAD_BACKEND_DRAG_THRESHOLD_DISTANCE;
		} else {
			_tmp3_ = GALA_TOUCHPAD_BACKEND_DRAG_THRESHOLD_DISTANCE * 4;
		}
		threshold = _tmp3_;
		if (self->priv->state != GALA_TOUCHPAD_BACKEND_STATE_IGNORED_HORIZONTAL) {
			_tmp4_ = fabs (self->priv->distance_x) >= ((gdouble) threshold);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GalaGesture* _tmp5_;
			GalaGestureDirection _tmp6_ = 0;
			GalaGesture* _tmp7_;
			_tmp5_ = gala_gesture_new ();
			_gala_gesture_unref0 (gesture);
			gesture = _tmp5_;
			if (self->priv->distance_x > ((gdouble) 0)) {
				_tmp6_ = GALA_GESTURE_DIRECTION_RIGHT;
			} else {
				_tmp6_ = GALA_GESTURE_DIRECTION_LEFT;
			}
			_tmp7_ = gesture;
			self->priv->direction = _tmp6_;
			_tmp7_->direction = self->priv->direction;
			state_if_ignored = GALA_TOUCHPAD_BACKEND_STATE_IGNORED_HORIZONTAL;
		} else {
			gboolean _tmp8_ = FALSE;
			if (self->priv->state != GALA_TOUCHPAD_BACKEND_STATE_IGNORED_VERTICAL) {
				_tmp8_ = fabs (self->priv->distance_y) >= ((gdouble) threshold);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GalaGesture* _tmp9_;
				GalaGestureDirection _tmp10_ = 0;
				GalaGesture* _tmp11_;
				_tmp9_ = gala_gesture_new ();
				_gala_gesture_unref0 (gesture);
				gesture = _tmp9_;
				if (self->priv->distance_y > ((gdouble) 0)) {
					_tmp10_ = GALA_GESTURE_DIRECTION_DOWN;
				} else {
					_tmp10_ = GALA_GESTURE_DIRECTION_UP;
				}
				_tmp11_ = gesture;
				self->priv->direction = _tmp10_;
				_tmp11_->direction = self->priv->direction;
				state_if_ignored = GALA_TOUCHPAD_BACKEND_STATE_IGNORED_VERTICAL;
			} else {
				result = CLUTTER_EVENT_PROPAGATE;
				_gala_gesture_unref0 (gesture);
				return result;
			}
		}
		_tmp12_ = gesture;
		_tmp12_->type = clutter_event_type (event);
		_tmp13_ = gesture;
		_tmp13_->fingers = (gint) clutter_event_get_touchpad_gesture_finger_count (event);
		_tmp14_ = gesture;
		_tmp15_ = clutter_event_get_device (event);
		_tmp14_->performed_on_device_type = clutter_input_device_get_device_type (_tmp15_);
		_tmp16_ = gesture;
		g_signal_emit_by_name ((GalaGestureBackend*) self, "on-gesture-detected", _tmp16_, clutter_event_get_time (event), &_tmp17_);
		if (!_tmp17_) {
			if (self->priv->state == GALA_TOUCHPAD_BACKEND_STATE_NONE) {
				self->priv->state = state_if_ignored;
			} else {
				self->priv->state = GALA_TOUCHPAD_BACKEND_STATE_IGNORED;
			}
			result = CLUTTER_EVENT_PROPAGATE;
			_gala_gesture_unref0 (gesture);
			return result;
		}
		self->priv->state = GALA_TOUCHPAD_BACKEND_STATE_ONGOING;
		g_signal_emit_by_name ((GalaGestureBackend*) self, "on-begin", (gdouble) 0, (guint64) clutter_event_get_time (event));
		_gala_gesture_unref0 (gesture);
	} else {
		gboolean _tmp18_ = FALSE;
		if (main_handler) {
			GalaGestureControllerGroup _tmp19_;
			_tmp19_ = self->priv->_group;
			_tmp18_ = _tmp19_ != GALA_GESTURE_CONTROLLER_GROUP_NONE;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GList* _tmp20_;
			_tmp20_ = gala_touchpad_backend_instances;
			{
				GList* instance_collection = NULL;
				GList* instance_it = NULL;
				instance_collection = _tmp20_;
				for (instance_it = instance_collection; instance_it != NULL; instance_it = instance_it->next) {
					GalaTouchpadBackend* _tmp21_;
					GalaTouchpadBackend* instance = NULL;
					_tmp21_ = _g_object_ref0 ((GalaTouchpadBackend*) instance_it->data);
					instance = _tmp21_;
					{
						gboolean _tmp22_ = FALSE;
						GalaTouchpadBackend* _tmp23_;
						_tmp23_ = instance;
						if (_tmp23_ != self) {
							GalaTouchpadBackend* _tmp24_;
							GalaGestureControllerGroup _tmp25_;
							GalaGestureControllerGroup _tmp26_;
							_tmp24_ = instance;
							_tmp25_ = _tmp24_->priv->_group;
							_tmp26_ = self->priv->_group;
							_tmp22_ = _tmp25_ == _tmp26_;
						} else {
							_tmp22_ = FALSE;
						}
						if (_tmp22_) {
							GalaTouchpadBackend* _tmp27_;
							_tmp27_ = instance;
							gala_touchpad_backend_handle_event (_tmp27_, event, FALSE);
						}
						_g_object_unref0 (instance);
					}
				}
			}
		}
	}
	self->priv->distance = self->priv->distance + gala_touchpad_backend_get_value_for_direction (self, delta_x, delta_y);
	percentage = gala_touchpad_backend_get_percentage (self, self->priv->distance);
	switch (clutter_event_get_gesture_phase (event)) {
		case CLUTTER_TOUCHPAD_GESTURE_PHASE_BEGIN:
		{
			break;
		}
		case CLUTTER_TOUCHPAD_GESTURE_PHASE_UPDATE:
		{
			g_signal_emit_by_name ((GalaGestureBackend*) self, "on-update", percentage, (guint64) clutter_event_get_time (event));
			break;
		}
		case CLUTTER_TOUCHPAD_GESTURE_PHASE_END:
		case CLUTTER_TOUCHPAD_GESTURE_PHASE_CANCEL:
		{
			g_signal_emit_by_name ((GalaGestureBackend*) self, "on-end", percentage, (guint64) clutter_event_get_time (event));
			gala_touchpad_backend_reset (self);
			break;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_touchpad_backend_reset (GalaTouchpadBackend* self)
{
	g_return_if_fail (self != NULL);
	self->priv->state = GALA_TOUCHPAD_BACKEND_STATE_NONE;
	self->priv->distance = (gdouble) 0;
	self->priv->direction = GALA_GESTURE_DIRECTION_UNKNOWN;
	self->priv->distance_x = (gdouble) 0;
	self->priv->distance_y = (gdouble) 0;
}

static gdouble
gala_touchpad_backend_get_percentage (GalaTouchpadBackend* self,
                                      gdouble value)
{
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->direction == GALA_GESTURE_DIRECTION_LEFT) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->direction == GALA_GESTURE_DIRECTION_RIGHT;
	}
	if (_tmp1_) {
		_tmp0_ = GALA_TOUCHPAD_BACKEND_TOUCHPAD_BASE_WIDTH;
	} else {
		_tmp0_ = GALA_TOUCHPAD_BACKEND_TOUCHPAD_BASE_HEIGHT;
	}
	result = value / _tmp0_;
	return result;
}

static gdouble
gala_touchpad_backend_get_value_for_direction (GalaTouchpadBackend* self,
                                               gdouble delta_x,
                                               gdouble delta_y)
{
	gboolean _tmp0_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->direction == GALA_GESTURE_DIRECTION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->direction == GALA_GESTURE_DIRECTION_RIGHT;
	}
	if (_tmp0_) {
		gdouble _tmp1_ = 0.0;
		if (self->priv->direction == GALA_GESTURE_DIRECTION_LEFT) {
			_tmp1_ = -delta_x;
		} else {
			_tmp1_ = delta_x;
		}
		result = _tmp1_;
		return result;
	} else {
		gdouble _tmp2_ = 0.0;
		if (self->priv->direction == GALA_GESTURE_DIRECTION_UP) {
			_tmp2_ = -delta_y;
		} else {
			_tmp2_ = delta_y;
		}
		result = _tmp2_;
		return result;
	}
}

 G_GNUC_INTERNAL ClutterActor*
gala_touchpad_backend_get_actor (GalaTouchpadBackend* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}

static void
gala_touchpad_backend_set_actor (GalaTouchpadBackend* self,
                                 ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_touchpad_backend_get_actor (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actor);
		self->priv->_actor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_touchpad_backend_properties[GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY]);
	}
}

 G_GNUC_INTERNAL GalaGestureControllerGroup
gala_touchpad_backend_get_group (GalaTouchpadBackend* self)
{
	GalaGestureControllerGroup result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_group;
	return result;
}

static void
gala_touchpad_backend_set_group (GalaTouchpadBackend* self,
                                 GalaGestureControllerGroup value)
{
	GalaGestureControllerGroup old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_touchpad_backend_get_group (self);
	if (old_value != value) {
		self->priv->_group = value;
		g_object_notify_by_pspec ((GObject *) self, gala_touchpad_backend_properties[GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY]);
	}
}

static gboolean
_gala_touchpad_backend_on_captured_event_clutter_actor_captured_event (ClutterActor* _sender,
                                                                       ClutterEvent* event,
                                                                       gpointer self)
{
	gboolean result;
	result = gala_touchpad_backend_on_captured_event ((GalaTouchpadBackend*) self, event);
	return result;
}

static GObject *
gala_touchpad_backend_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaTouchpadBackend * self;
	ClutterActor* _tmp0_;
	GalaTouchpadBackend* _tmp1_;
	parent_class = G_OBJECT_CLASS (gala_touchpad_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackend);
	_tmp0_ = self->priv->_actor;
	g_signal_connect_object (_tmp0_, "captured-event", (GCallback) _gala_touchpad_backend_on_captured_event_clutter_actor_captured_event, self, 0);
	_tmp1_ = _g_object_ref0 (self);
	gala_touchpad_backend_instances = g_list_append (gala_touchpad_backend_instances, _tmp1_);
	return obj;
}

static void
gala_touchpad_backend_class_init (GalaTouchpadBackendClass * klass,
                                  gpointer klass_data)
{
	gala_touchpad_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaTouchpadBackend_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_touchpad_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_touchpad_backend_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_touchpad_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_touchpad_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY, gala_touchpad_backend_properties[GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY, gala_touchpad_backend_properties[GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY] = g_param_spec_enum ("group", "group", "group", GALA_GESTURE_CONTROLLER_TYPE_GROUP, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_touchpad_backend_gala_gesture_backend_interface_init (GalaGestureBackendIface * iface,
                                                           gpointer iface_data)
{
	gala_touchpad_backend_gala_gesture_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->cancel_gesture = (void (*) (GalaGestureBackend*)) gala_touchpad_backend_real_cancel_gesture;
}

static void
gala_touchpad_backend_instance_init (GalaTouchpadBackend * self,
                                     gpointer klass)
{
	self->priv = gala_touchpad_backend_get_instance_private (self);
	self->priv->state = GALA_TOUCHPAD_BACKEND_STATE_NONE;
	self->priv->direction = GALA_GESTURE_DIRECTION_UNKNOWN;
	self->priv->distance_x = (gdouble) 0;
	self->priv->distance_y = (gdouble) 0;
	self->priv->distance = (gdouble) 0;
}

static void
gala_touchpad_backend_finalize (GObject * obj)
{
	GalaTouchpadBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackend);
	gala_touchpad_backend_instances = vala_g_list_remove_full (gala_touchpad_backend_instances, self, _g_object_unref0_);
	_g_object_unref0 (self->priv->_actor);
	G_OBJECT_CLASS (gala_touchpad_backend_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_touchpad_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaTouchpadBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_touchpad_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaTouchpadBackend), 0, (GInstanceInitFunc) gala_touchpad_backend_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_backend_info = { (GInterfaceInitFunc) gala_touchpad_backend_gala_gesture_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_touchpad_backend_type_id;
	gala_touchpad_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaTouchpadBackend", &g_define_type_info, 0);
	g_type_add_interface_static (gala_touchpad_backend_type_id, GALA_TYPE_GESTURE_BACKEND, &gala_gesture_backend_info);
	GalaTouchpadBackend_private_offset = g_type_add_instance_private (gala_touchpad_backend_type_id, sizeof (GalaTouchpadBackendPrivate));
	return gala_touchpad_backend_type_id;
}

 G_GNUC_INTERNAL GType
gala_touchpad_backend_get_type (void)
{
	static gsize gala_touchpad_backend_type_id__once = 0;
	if (g_once_init_enter (&gala_touchpad_backend_type_id__once)) {
		GType gala_touchpad_backend_type_id;
		gala_touchpad_backend_type_id = gala_touchpad_backend_get_type_once ();
		g_once_init_leave (&gala_touchpad_backend_type_id__once, gala_touchpad_backend_type_id);
	}
	return gala_touchpad_backend_type_id__once;
}

static void
_vala_gala_touchpad_backend_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GalaTouchpadBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackend);
	switch (property_id) {
		case GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY:
		g_value_set_object (value, gala_touchpad_backend_get_actor (self));
		break;
		case GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY:
		g_value_set_enum (value, gala_touchpad_backend_get_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_touchpad_backend_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GalaTouchpadBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_TOUCHPAD_BACKEND, GalaTouchpadBackend);
	switch (property_id) {
		case GALA_TOUCHPAD_BACKEND_ACTOR_PROPERTY:
		gala_touchpad_backend_set_actor (self, g_value_get_object (value));
		break;
		case GALA_TOUCHPAD_BACKEND_GROUP_PROPERTY:
		gala_touchpad_backend_set_group (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

