
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "qzsettings_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_QzSettings_Type = nullptr;
static PyTypeObject *Sbk_QzSettings_TypeF(void)
{
    return _Sbk_QzSettings_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QzSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QzSettings >()))
        return -1;

    ::QzSettings *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // QzSettings()
        cptr = new ::QzSettings();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QzSettings >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QzSettingsFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzSettingsFunc_saveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveSettings()
        cppSelf->saveSettings();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_QzSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QzSettings_methods[] = {
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_QzSettingsFunc_loadSettings), METH_NOARGS, nullptr},
    {"saveSettings", reinterpret_cast<PyCFunction>(Sbk_QzSettingsFunc_saveSettings), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_QzSettings_get_selectAllOnDoubleClick(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->selectAllOnDoubleClick;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_selectAllOnDoubleClick(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("selectAllOnDoubleClick");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("selectAllOnDoubleClick", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->selectAllOnDoubleClick;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectAllOnDoubleClick = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_selectAllOnClick(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->selectAllOnClick;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_selectAllOnClick(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("selectAllOnClick");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("selectAllOnClick", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->selectAllOnClick;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectAllOnClick = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showLoadingProgress(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showLoadingProgress;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showLoadingProgress(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showLoadingProgress");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showLoadingProgress", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->showLoadingProgress;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showLoadingProgress = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showLocationSuggestions(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->showLocationSuggestions;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showLocationSuggestions(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showLocationSuggestions");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showLocationSuggestions", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->showLocationSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showLocationSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showSwitchTab(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showSwitchTab;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showSwitchTab(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showSwitchTab");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showSwitchTab", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->showSwitchTab;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showSwitchTab = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_alwaysShowGoIcon(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->alwaysShowGoIcon;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_alwaysShowGoIcon(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("alwaysShowGoIcon");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("alwaysShowGoIcon", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->alwaysShowGoIcon;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->alwaysShowGoIcon = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_useInlineCompletion(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->useInlineCompletion;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_useInlineCompletion(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("useInlineCompletion");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("useInlineCompletion", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->useInlineCompletion;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->useInlineCompletion = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showZoomLabel(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showZoomLabel;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showZoomLabel(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showZoomLabel");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showZoomLabel", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->showZoomLabel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showZoomLabel = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_completionPopupExpandToWindow(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->completionPopupExpandToWindow;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_completionPopupExpandToWindow(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("completionPopupExpandToWindow");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("completionPopupExpandToWindow", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->completionPopupExpandToWindow;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->completionPopupExpandToWindow = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchOnEngineChange(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchOnEngineChange;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_searchOnEngineChange(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("searchOnEngineChange");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("searchOnEngineChange", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->searchOnEngineChange;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchOnEngineChange = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchFromAddressBar(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchFromAddressBar;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_searchFromAddressBar(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("searchFromAddressBar");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("searchFromAddressBar", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->searchFromAddressBar;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchFromAddressBar = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchWithDefaultEngine(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchWithDefaultEngine;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_searchWithDefaultEngine(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("searchWithDefaultEngine");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("searchWithDefaultEngine", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->searchWithDefaultEngine;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchWithDefaultEngine = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showABSearchSuggestions(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showABSearchSuggestions;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showABSearchSuggestions(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showABSearchSuggestions");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showABSearchSuggestions", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->showABSearchSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showABSearchSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showWSBSearchSuggestions(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showWSBSearchSuggestions;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_showWSBSearchSuggestions(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("showWSBSearchSuggestions");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("showWSBSearchSuggestions", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->showWSBSearchSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showWSBSearchSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_defaultZoomLevel(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->defaultZoomLevel;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_QzSettings_set_defaultZoomLevel(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("defaultZoomLevel");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("defaultZoomLevel", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->defaultZoomLevel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->defaultZoomLevel = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_loadTabsOnActivation(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->loadTabsOnActivation;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_loadTabsOnActivation(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("loadTabsOnActivation");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("loadTabsOnActivation", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->loadTabsOnActivation;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->loadTabsOnActivation = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_autoOpenProtocols(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppSelf->autoOpenProtocols);
}
static int Sbk_QzSettings_set_autoOpenProtocols(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("autoOpenProtocols");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("autoOpenProtocols", "QStringList");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->autoOpenProtocols;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_blockedProtocols(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppSelf->blockedProtocols);
}
static int Sbk_QzSettings_set_blockedProtocols(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("blockedProtocols");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("blockedProtocols", "QStringList");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->blockedProtocols;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_allowedSchemes(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppSelf->allowedSchemes);
}
static int Sbk_QzSettings_set_allowedSchemes(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("allowedSchemes");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("allowedSchemes", "QStringList");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->allowedSchemes;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_blockedSchemes(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppSelf->blockedSchemes);
}
static int Sbk_QzSettings_set_blockedSchemes(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("blockedSchemes");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("blockedSchemes", "QStringList");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->blockedSchemes;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_newTabPosition(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, &cppSelf->newTabPosition);
}
static int Sbk_QzSettings_set_newTabPosition(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("newTabPosition");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("newTabPosition", "NewTabPositionFlags");
        return -1;
    }

    auto cppOut_local = cppSelf->newTabPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->newTabPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_tabsOnTop(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->tabsOnTop;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_tabsOnTop(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("tabsOnTop");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("tabsOnTop", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->tabsOnTop;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->tabsOnTop = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_openPopupsInTabs(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->openPopupsInTabs;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_openPopupsInTabs(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("openPopupsInTabs");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("openPopupsInTabs", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->openPopupsInTabs;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->openPopupsInTabs = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_blockAutomaticPopups(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->blockAutomaticPopups;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_blockAutomaticPopups(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("blockAutomaticPopups");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("blockAutomaticPopups", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->blockAutomaticPopups;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->blockAutomaticPopups = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_alwaysSwitchTabsWithWheel(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->alwaysSwitchTabsWithWheel;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_QzSettings_set_alwaysSwitchTabsWithWheel(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("alwaysSwitchTabsWithWheel");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("alwaysSwitchTabsWithWheel", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->alwaysSwitchTabsWithWheel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->alwaysSwitchTabsWithWheel = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_backgroundColorLoading(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->backgroundColorLoading), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->backgroundColorLoading), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_QzSettings_set_backgroundColorLoading(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("backgroundColorLoading");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("backgroundColorLoading", "QColor");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->backgroundColorLoading;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_backgroundColorLoaded(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->backgroundColorLoaded), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->backgroundColorLoaded), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_QzSettings_set_backgroundColorLoaded(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("backgroundColorLoaded");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("backgroundColorLoaded", "QColor");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->backgroundColorLoaded;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_loadedSwitchDelay(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->loadedSwitchDelay;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_QzSettings_set_loadedSwitchDelay(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("loadedSwitchDelay");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("loadedSwitchDelay", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->loadedSwitchDelay;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->loadedSwitchDelay = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_defaultSideBarWidth(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->defaultSideBarWidth;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_QzSettings_set_defaultSideBarWidth(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QzSettings_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("defaultSideBarWidth");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("defaultSideBarWidth", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->defaultSideBarWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->defaultSideBarWidth = cppOut_local;

    return 0;
}

// Getters and Setters for QzSettings
static PyGetSetDef Sbk_QzSettings_getsetlist[] = {
    {"selectAllOnDoubleClick", Sbk_QzSettings_get_selectAllOnDoubleClick, Sbk_QzSettings_set_selectAllOnDoubleClick, "bool", nullptr},
    {"selectAllOnClick", Sbk_QzSettings_get_selectAllOnClick, Sbk_QzSettings_set_selectAllOnClick, "bool", nullptr},
    {"showLoadingProgress", Sbk_QzSettings_get_showLoadingProgress, Sbk_QzSettings_set_showLoadingProgress, "bool", nullptr},
    {"showLocationSuggestions", Sbk_QzSettings_get_showLocationSuggestions, Sbk_QzSettings_set_showLocationSuggestions, "int", nullptr},
    {"showSwitchTab", Sbk_QzSettings_get_showSwitchTab, Sbk_QzSettings_set_showSwitchTab, "bool", nullptr},
    {"alwaysShowGoIcon", Sbk_QzSettings_get_alwaysShowGoIcon, Sbk_QzSettings_set_alwaysShowGoIcon, "bool", nullptr},
    {"useInlineCompletion", Sbk_QzSettings_get_useInlineCompletion, Sbk_QzSettings_set_useInlineCompletion, "bool", nullptr},
    {"showZoomLabel", Sbk_QzSettings_get_showZoomLabel, Sbk_QzSettings_set_showZoomLabel, "bool", nullptr},
    {"completionPopupExpandToWindow", Sbk_QzSettings_get_completionPopupExpandToWindow, Sbk_QzSettings_set_completionPopupExpandToWindow, "bool", nullptr},
    {"searchOnEngineChange", Sbk_QzSettings_get_searchOnEngineChange, Sbk_QzSettings_set_searchOnEngineChange, "bool", nullptr},
    {"searchFromAddressBar", Sbk_QzSettings_get_searchFromAddressBar, Sbk_QzSettings_set_searchFromAddressBar, "bool", nullptr},
    {"searchWithDefaultEngine", Sbk_QzSettings_get_searchWithDefaultEngine, Sbk_QzSettings_set_searchWithDefaultEngine, "bool", nullptr},
    {"showABSearchSuggestions", Sbk_QzSettings_get_showABSearchSuggestions, Sbk_QzSettings_set_showABSearchSuggestions, "bool", nullptr},
    {"showWSBSearchSuggestions", Sbk_QzSettings_get_showWSBSearchSuggestions, Sbk_QzSettings_set_showWSBSearchSuggestions, "bool", nullptr},
    {"defaultZoomLevel", Sbk_QzSettings_get_defaultZoomLevel, Sbk_QzSettings_set_defaultZoomLevel, "int", nullptr},
    {"loadTabsOnActivation", Sbk_QzSettings_get_loadTabsOnActivation, Sbk_QzSettings_set_loadTabsOnActivation, "bool", nullptr},
    {"autoOpenProtocols", Sbk_QzSettings_get_autoOpenProtocols, Sbk_QzSettings_set_autoOpenProtocols, "QStringList", nullptr},
    {"blockedProtocols", Sbk_QzSettings_get_blockedProtocols, Sbk_QzSettings_set_blockedProtocols, "QStringList", nullptr},
    {"allowedSchemes", Sbk_QzSettings_get_allowedSchemes, Sbk_QzSettings_set_allowedSchemes, "QStringList", nullptr},
    {"blockedSchemes", Sbk_QzSettings_get_blockedSchemes, Sbk_QzSettings_set_blockedSchemes, "QStringList", nullptr},
    {"newTabPosition", Sbk_QzSettings_get_newTabPosition, Sbk_QzSettings_set_newTabPosition, "PyFalkon.Qz.NewTabPositionFlag", nullptr},
    {"tabsOnTop", Sbk_QzSettings_get_tabsOnTop, Sbk_QzSettings_set_tabsOnTop, "bool", nullptr},
    {"openPopupsInTabs", Sbk_QzSettings_get_openPopupsInTabs, Sbk_QzSettings_set_openPopupsInTabs, "bool", nullptr},
    {"blockAutomaticPopups", Sbk_QzSettings_get_blockAutomaticPopups, Sbk_QzSettings_set_blockAutomaticPopups, "bool", nullptr},
    {"alwaysSwitchTabsWithWheel", Sbk_QzSettings_get_alwaysSwitchTabsWithWheel, Sbk_QzSettings_set_alwaysSwitchTabsWithWheel, "bool", nullptr},
    {"backgroundColorLoading", Sbk_QzSettings_get_backgroundColorLoading, Sbk_QzSettings_set_backgroundColorLoading, "PySide6.QtGui.QColor", nullptr},
    {"backgroundColorLoaded", Sbk_QzSettings_get_backgroundColorLoaded, Sbk_QzSettings_set_backgroundColorLoaded, "PySide6.QtGui.QColor", nullptr},
    {"loadedSwitchDelay", Sbk_QzSettings_get_loadedSwitchDelay, Sbk_QzSettings_set_loadedSwitchDelay, "int", nullptr},
    {"defaultSideBarWidth", Sbk_QzSettings_get_defaultSideBarWidth, Sbk_QzSettings_set_defaultSideBarWidth, "int", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QzSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_QzSettings_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_QzSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QzSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QzSettings_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QzSettings_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QzSettings_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QzSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_QzSettings_spec = {
    "1:PyFalkon.QzSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_QzSettings_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QzSettings_PythonToCpp_QzSettings_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_QzSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QzSettings_PythonToCpp_QzSettings_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_QzSettings_TypeF()))
        return QzSettings_PythonToCpp_QzSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QzSettings_PTR_CppToPython_QzSettings(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_QzSettings_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_QzSettings_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *QzSettings_SignatureStrings[] = {
    "PyFalkon.QzSettings(self)",
    "PyFalkon.QzSettings.loadSettings(self)",
    "PyFalkon.QzSettings.saveSettings(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t QzSettings_SignatureByteSize = 50;
static constexpr uint8_t QzSettings_SignatureBytes[50] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0xac, 0x0a, 0x4e, 0x2d,
    0x29, 0xc9, 0xcc, 0x4b, 0x2f, 0xd6, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x0a, 0xc0, 0x94, 0xd1,
    0xcb, 0xc9, 0x4f, 0x4c, 0x21, 0x42, 0x59, 0x71, 0x62, 0x59, 0x2a, 0x9a, 0x32, 0x00, 0xf7, 0x3b,
    0x26, 0xa7
};
#endif

PyTypeObject *init_QzSettings(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_QzSettings_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_QzSettings_IDX].type;

    Shiboken::AutoDecRef Sbk_QzSettings_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_QzSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QzSettings",
        "QzSettings*",
        &Sbk_QzSettings_spec,
        &Shiboken::callCppDestructor< ::QzSettings >,
        Sbk_QzSettings_Type_bases.object(),
        0);
    auto *pyType = _Sbk_QzSettings_Type; // references _Sbk_QzSettings_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, QzSettings_SignatureStrings);
#else
    InitSignatureBytes(pyType, QzSettings_SignatureBytes, QzSettings_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_QzSettings_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_QzSettings_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        QzSettings_PythonToCpp_QzSettings_PTR,
        is_QzSettings_PythonToCpp_QzSettings_PTR_Convertible,
        QzSettings_PTR_CppToPython_QzSettings);

    Shiboken::Conversions::registerConverterName(converter, "QzSettings");
    Shiboken::Conversions::registerConverterName(converter, "QzSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QzSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QzSettings).name());

    qRegisterMetaType< ::QzSettings *>();

    return pyType;
}
