
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "history_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "history_historyentry_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_History_Type = nullptr;
static PyTypeObject *Sbk_History_TypeF(void)
{
    return _Sbk_History_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void HistoryWrapper::pysideInitQtMetaTypes()
{
}

void HistoryWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

HistoryWrapper::HistoryWrapper(::QObject * parent) : History(parent)
{
}

void HistoryWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("History", funcName, gil, pyOverride, event);
}

void HistoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("History", funcName, gil, pyOverride, signal);
}

void HistoryWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("History", funcName, gil, pyOverride, event);
}

void HistoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("History", funcName, gil, pyOverride, signal);
}

bool HistoryWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("History", funcName, gil, pyOverride, event);
}

bool HistoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("History", funcName, gil, pyOverride, watched, event);
}

void HistoryWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_History_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("History", funcName, gil, pyOverride, event);
}

const QMetaObject *HistoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return History::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int HistoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = History::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *HistoryWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< HistoryWrapper *>(this));
    }
    return History::qt_metacast(_clname);
}

HistoryWrapper::~HistoryWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_History_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_History_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::History >()))
        return -1;

    HistoryWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "History", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: History::History(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // History(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_History_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // History(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) HistoryWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new HistoryWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< History >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);
    };


    return 1;
}

static PyObject *Sbk_HistoryFunc_addHistoryEntry(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addHistoryEntry", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: History::addHistoryEntry(WebView*)
    // 1: History::addHistoryEntry(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // addHistoryEntry(QUrl,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addHistoryEntry(WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addHistoryEntry", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addHistoryEntry(WebView *view)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::WebView *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addHistoryEntry(WebView*)
                cppSelf->addHistoryEntry(cppArg0);
            }
            break;
        }
        case 1: // addHistoryEntry(const QUrl &url, QString title)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addHistoryEntry(QUrl,QString)
                cppSelf->addHistoryEntry(*cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryFunc_clearHistory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearHistory()
        cppSelf->clearHistory();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryFunc_deleteHistoryEntry(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "deleteHistoryEntry", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: History::deleteHistoryEntry(QList<int>)
    // 1: History::deleteHistoryEntry(QString)
    // 2: History::deleteHistoryEntry(QString,QString)
    // 3: History::deleteHistoryEntry(int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // deleteHistoryEntry(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 2; // deleteHistoryEntry(QString,QString)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 3; // deleteHistoryEntry(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX], (pyArgs[0])))) {
        overloadId = 0; // deleteHistoryEntry(QList<int>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "deleteHistoryEntry", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // deleteHistoryEntry(const QList<int> &list)
        {
            ::QList<int> cppArg0_local;
            ::QList<int> *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // deleteHistoryEntry(QList<int>)
                cppSelf->deleteHistoryEntry(*cppArg0);
            }
            break;
        }
        case 1: // deleteHistoryEntry(const QString &url)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // deleteHistoryEntry(QString)
                cppSelf->deleteHistoryEntry(cppArg0);
            }
            break;
        }
        case 2: // deleteHistoryEntry(const QString &url, const QString &title)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // deleteHistoryEntry(QString,QString)
                cppSelf->deleteHistoryEntry(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // deleteHistoryEntry(int index)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // deleteHistoryEntry(int)
                cppSelf->deleteHistoryEntry(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryFunc_getHistoryEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: History::getHistoryEntry(QString)->History::HistoryEntry
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getHistoryEntry(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getHistoryEntry", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getHistoryEntry(QString)
            History::HistoryEntry cppResult = cppSelf->getHistoryEntry(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_indexesFromTimeRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "indexesFromTimeRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: History::indexesFromTimeRange(qint64,qint64)->QList<int>
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // indexesFromTimeRange(qint64,qint64)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "indexesFromTimeRange", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // indexesFromTimeRange(qint64,qint64)
            QList<int> cppResult = cppSelf->indexesFromTimeRange(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_int_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_isSaving(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isSaving()
        bool cppResult = cppSelf->isSaving();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // model()
        HistoryModel * cppResult = cppSelf->model();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_mostVisited(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: History::mostVisited(int)->QList<History::HistoryEntry>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // mostVisited(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mostVisited", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mostVisited(int)
            QList<History::HistoryEntry> cppResult = cppSelf->mostVisited(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_History_HistoryEntry_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_searchHistoryEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: History::searchHistoryEntry(QString)->QList<History::HistoryEntry>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // searchHistoryEntry(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "searchHistoryEntry", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // searchHistoryEntry(QString)
            QList<History::HistoryEntry> cppResult = cppSelf->searchHistoryEntry(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_History_HistoryEntry_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryFunc_setSaving(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryWrapper *>(reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: History::setSaving(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSaving(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSaving", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSaving(bool)
            cppSelf->setSaving(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryFunc_titleCaseLocalizedMonth(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static History::titleCaseLocalizedMonth(int)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // titleCaseLocalizedMonth(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "titleCaseLocalizedMonth", errInfo, SbkPyFalkonTypeStructs[SBK_History_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // titleCaseLocalizedMonth(int)
            QString cppResult = ::History::titleCaseLocalizedMonth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_History_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_History_methods[] = {
    {"addHistoryEntry", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_addHistoryEntry), METH_VARARGS, nullptr},
    {"clearHistory", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_clearHistory), METH_NOARGS, nullptr},
    {"deleteHistoryEntry", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_deleteHistoryEntry), METH_VARARGS, nullptr},
    {"getHistoryEntry", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_getHistoryEntry), METH_O, nullptr},
    {"indexesFromTimeRange", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_indexesFromTimeRange), METH_VARARGS, nullptr},
    {"isSaving", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_isSaving), METH_NOARGS, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_loadSettings), METH_NOARGS, nullptr},
    {"model", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_model), METH_NOARGS, nullptr},
    {"mostVisited", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_mostVisited), METH_O, nullptr},
    {"searchHistoryEntry", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_searchHistoryEntry), METH_O, nullptr},
    {"setSaving", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_setSaving), METH_O, nullptr},
    {"titleCaseLocalizedMonth", reinterpret_cast<PyCFunction>(Sbk_HistoryFunc_titleCaseLocalizedMonth), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_History_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::History *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<HistoryWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_History_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_History_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_History_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_History_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_History_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_History_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_History_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_History_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_History_spec = {
    "1:PyFalkon.History",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_History_slots
};

} //extern "C"

static void *Sbk_History_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::History *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void History_PythonToCpp_History_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_History_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_History_PythonToCpp_History_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_History_TypeF()))
        return History_PythonToCpp_History_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *History_PTR_CppToPython_History(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::History *>(const_cast<void *>(cppIn)), Sbk_History_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *History_SignatureStrings[] = {
    "PyFalkon.History(self,parent:PySide6.QtCore.QObject)",
    "1:PyFalkon.History.addHistoryEntry(self,view:PyFalkon.WebView)",
    "0:PyFalkon.History.addHistoryEntry(self,url:typing.Union[PySide6.QtCore.QUrl, QString],title:QString)",
    "PyFalkon.History.clearHistory(self)",
    "3:PyFalkon.History.deleteHistoryEntry(self,list:QList[int])",
    "2:PyFalkon.History.deleteHistoryEntry(self,url:QString)",
    "1:PyFalkon.History.deleteHistoryEntry(self,url:QString,title:QString)",
    "0:PyFalkon.History.deleteHistoryEntry(self,index:int)",
    "PyFalkon.History.getHistoryEntry(self,text:QString)->PyFalkon.History.HistoryEntry",
    "PyFalkon.History.indexesFromTimeRange(self,start:qint64,end:qint64)->QList[int]",
    "PyFalkon.History.isSaving(self)->bool",
    "PyFalkon.History.loadSettings(self)",
    "PyFalkon.History.model(self)->PyFalkon.HistoryModel",
    "PyFalkon.History.mostVisited(self,count:int)->QList[PyFalkon.History.HistoryEntry]",
    "PyFalkon.History.searchHistoryEntry(self,text:QString)->QList[PyFalkon.History.HistoryEntry]",
    "PyFalkon.History.setSaving(self,state:bool)",
    "PyFalkon.History.titleCaseLocalizedMonth(month:int)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t History_SignatureByteSize = 352;
static constexpr uint8_t History_SignatureBytes[352] = {
    0x78, 0xda, 0x9d, 0x53, 0xb1, 0x6e, 0xc2, 0x30, 0x14, 0xdc, 0xf3, 0x15, 0x1d, 0x89, 0x14, 0x22,
    0x68, 0x2b, 0x06, 0x0f, 0x2c, 0xa8, 0xa8, 0x03, 0xa8, 0xa4, 0x29, 0x74, 0x40, 0x0c, 0x26, 0x7e,
    0x05, 0xb7, 0x8e, 0x4d, 0xed, 0x07, 0x25, 0xfd, 0xfa, 0x3a, 0x24, 0x81, 0x14, 0x47, 0x2d, 0x62,
    0xb1, 0x1c, 0xbf, 0x77, 0xf7, 0xee, 0xce, 0xce, 0x24, 0x1b, 0x52, 0xf1, 0xa1, 0x64, 0xf8, 0xc8,
    0x0d, 0x2a, 0x9d, 0xb5, 0x0c, 0x88, 0xb7, 0x60, 0x43, 0x35, 0x48, 0x24, 0x93, 0x2c, 0xe6, 0x0c,
    0x7a, 0x61, 0x84, 0x03, 0xa5, 0x21, 0x8c, 0x9e, 0x96, 0xef, 0x90, 0xa0, 0xef, 0x75, 0x6d, 0xe5,
    0x37, 0x2c, 0xa4, 0x8c, 0x95, 0xdb, 0x07, 0x89, 0x15, 0xcd, 0x8e, 0xc3, 0xd7, 0xa9, 0xf5, 0x15,
    0x96, 0x33, 0x7b, 0xe0, 0x7b, 0x9d, 0x0b, 0xe1, 0x5b, 0x2d, 0x08, 0x66, 0x1b, 0x2e, 0x57, 0xe1,
    0x54, 0x72, 0x25, 0xe7, 0xe7, 0x7a, 0xa6, 0x5a, 0x04, 0x37, 0x51, 0x8c, 0xda, 0xb6, 0x2c, 0x02,
    0xe4, 0x28, 0x80, 0x94, 0x9f, 0xbe, 0xe7, 0xcc, 0x48, 0x04, 0x50, 0x5d, 0xb7, 0xe9, 0x7b, 0x77,
    0xae, 0x12, 0x06, 0x02, 0x10, 0x5c, 0x31, 0xc2, 0x9e, 0x90, 0x68, 0x64, 0xd7, 0x39, 0x97, 0xb8,
    0xf0, 0xbd, 0xdb, 0xcb, 0xb1, 0xb9, 0x91, 0xa3, 0xae, 0xee, 0x55, 0xb8, 0x73, 0x77, 0x9d, 0xcb,
    0x59, 0xb8, 0x64, 0xb0, 0x27, 0x56, 0x74, 0x43, 0x26, 0x2b, 0x40, 0x17, 0x80, 0xb0, 0xc7, 0xe3,
    0xa4, 0x76, 0xdf, 0x01, 0xd5, 0x11, 0x2e, 0xe5, 0x61, 0x1c, 0x98, 0xa1, 0x56, 0xe9, 0x0b, 0x4f,
    0xe1, 0x99, 0xca, 0x15, 0x14, 0xbc, 0x06, 0xa9, 0x46, 0xf2, 0x69, 0x95, 0xf4, 0xee, 0x03, 0x90,
    0xac, 0xdc, 0xda, 0x11, 0xa7, 0x5c, 0x1b, 0xf8, 0x4c, 0x4c, 0x77, 0x56, 0x49, 0x71, 0x65, 0xed,
    0xfe, 0x52, 0x29, 0xe1, 0x76, 0x09, 0x45, 0x59, 0x0c, 0x88, 0xb6, 0xd1, 0x94, 0x97, 0xeb, 0xf4,
    0xa4, 0xca, 0x46, 0x54, 0xd1, 0x9c, 0x57, 0xc7, 0x79, 0xb1, 0x09, 0x63, 0x70, 0xc6, 0x0d, 0x47,
    0x60, 0x85, 0x89, 0x44, 0x6d, 0xed, 0x9f, 0x91, 0xa7, 0x59, 0xc9, 0xfe, 0x33, 0x9f, 0x06, 0x43,
    0xc6, 0x3e, 0xc3, 0x64, 0xfd, 0x6f, 0xec, 0xd7, 0x92, 0x63, 0x2d, 0xae, 0x3c, 0x72, 0x04, 0x92,
    0x47, 0xd6, 0x90, 0xc7, 0xe1, 0x49, 0x0d, 0xa8, 0x81, 0x91, 0x4a, 0xa8, 0xe0, 0xdf, 0xc0, 0xc6,
    0x4a, 0xe2, 0xba, 0x95, 0xe6, 0x6b, 0x65, 0xb1, 0xd0, 0xe3, 0xfd, 0x00, 0xe1, 0xe5, 0x8c, 0x24
};
#endif

PyTypeObject *init_History(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_History_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_History_IDX].type;

    Shiboken::AutoDecRef Sbk_History_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_History_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "History",
        "History*",
        &Sbk_History_spec,
        &Shiboken::callCppDestructor< History >,
        Sbk_History_Type_bases.object(),
        0);
    auto *pyType = _Sbk_History_Type; // references _Sbk_History_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, History_SignatureStrings);
#else
    InitSignatureBytes(pyType, History_SignatureBytes, History_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_History_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_History_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        History_PythonToCpp_History_PTR,
        is_History_PythonToCpp_History_PTR_Convertible,
        History_PTR_CppToPython_History);

    Shiboken::Conversions::registerConverterName(converter, "History");
    Shiboken::Conversions::registerConverterName(converter, "History*");
    Shiboken::Conversions::registerConverterName(converter, "History&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::History).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(HistoryWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_History_TypeF(), &Sbk_History_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::History::staticMetaObject);
    HistoryWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::History::staticMetaObject, sizeof(HistoryWrapper));

    return pyType;
}
