// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkF3DRandomFS.h"

const char *vtkF3DRandomFS =
"//VTK::Color::Dec\n"
"\n"
"// A single iteration of Bob Jenkins' One-At-A-Time hashing algorithm.\n"
"uint hash( uint x ) {\n"
"    x += ( x << 10u );\n"
"    x ^= ( x >>  6u );\n"
"    x += ( x <<  3u );\n"
"    x ^= ( x >> 11u );\n"
"    x += ( x << 15u );\n"
"    return x;\n"
"}\n"
"\n"
"uint hash( uvec3 v ) { return hash( v.x ^ hash(v.y ^ hash(v.z))); }\n"
"\n"
"float random_ign(vec2 coord, uint index)\n"
"{\n"
"    coord = floor(coord) + 5.588238 * vec2(index % 4096u);\n"
"    return fract(fract(dot(coord, vec2(0.06711056, 0.00583715))) * 52.9829189);\n"
"}\n"
"";
