/* jid.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from jid.vala, do not modify */

#include "xmpp-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <unicode/utypes.h>
#include <unicode/uidna.h>
#include <unicode/parseerr.h>
#include <unicode/usprep.h>
#include <unicode/ustring.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmpp_jid_unref0(var) ((var == NULL) ? NULL : (var = (xmpp_jid_unref (var), NULL)))
#define _uidna_close0(var) ((var == NULL) ? NULL : (var = (uidna_close (var), NULL)))
#define _usprep_close0(var) ((var == NULL) ? NULL : (var = (usprep_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _XmppParamSpecJid XmppParamSpecJid;

struct _XmppJidPrivate {
	gchar* jid;
};

struct _XmppParamSpecJid {
	GParamSpec parent_instance;
};

static gint XmppJid_private_offset;
static gpointer xmpp_jid_parent_class = NULL;

static XmppJid* xmpp_jid_new_intern (gchar* jid,
                              gchar* localpart,
                              gchar* domainpart,
                              gchar* resourcepart);
static XmppJid* xmpp_jid_construct_intern (GType object_type,
                                    gchar* jid,
                                    gchar* localpart,
                                    gchar* domainpart,
                                    gchar* resourcepart);
static gchar* xmpp_jid_idna_decode (const gchar* src,
                             GError** error);
static gchar* xmpp_jid_prepare (const gchar* src,
                         UStringPrepProfileType type,
                         gboolean strict,
                         GError** error);
static void xmpp_jid_idna_verify (const gchar* src,
                           GError** error);
static void xmpp_jid_finalize (XmppJid * obj);
static GType xmpp_jid_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
xmpp_jid_get_instance_private (XmppJid* self)
{
	return G_STRUCT_MEMBER_P (self, XmppJid_private_offset);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

XmppJid*
xmpp_jid_construct (GType object_type,
                    const gchar* jid,
                    GError** error)
{
	XmppJid* self = NULL;
	gint slash_index = 0;
	gint at_index = 0;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* resourcepart = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* localpart = NULL;
	gchar* _tmp8_;
	gchar* domainpart = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (jid != NULL, NULL);
	slash_index = string_index_of (jid, "/", 0);
	at_index = string_index_of (jid, "@", 0);
	if (at_index > slash_index) {
		_tmp0_ = slash_index != -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		at_index = -1;
	}
	if (slash_index < 0) {
		_g_free0 (_tmp1_);
		_tmp1_ = NULL;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = strlen (jid);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_slice (jid, (glong) (slash_index + 1), (glong) _tmp3_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp1_);
	resourcepart = _tmp5_;
	if (at_index < 0) {
		_g_free0 (_tmp6_);
		_tmp6_ = NULL;
	} else {
		gchar* _tmp7_;
		_tmp7_ = string_slice (jid, (glong) 0, (glong) at_index);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp7_;
	}
	_tmp8_ = g_strdup (_tmp6_);
	localpart = _tmp8_;
	if (at_index < 0) {
		if (slash_index < 0) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (jid);
			_g_free0 (domainpart);
			domainpart = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = string_slice (jid, (glong) 0, (glong) slash_index);
			_g_free0 (domainpart);
			domainpart = _tmp10_;
		}
	} else {
		if (slash_index < 0) {
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = strlen (jid);
			_tmp12_ = _tmp11_;
			_tmp13_ = string_slice (jid, (glong) (at_index + 1), (glong) _tmp12_);
			_g_free0 (domainpart);
			domainpart = _tmp13_;
		} else {
			gchar* _tmp14_;
			_tmp14_ = string_slice (jid, (glong) (at_index + 1), (glong) slash_index);
			_g_free0 (domainpart);
			domainpart = _tmp14_;
		}
	}
	_tmp15_ = localpart;
	_tmp16_ = domainpart;
	_tmp17_ = resourcepart;
	self = (XmppJid*) xmpp_jid_construct_components (object_type, _tmp15_, _tmp16_, _tmp17_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (domainpart);
			_g_free0 (localpart);
			_g_free0 (_tmp6_);
			_g_free0 (resourcepart);
			_g_free0 (_tmp1_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			_g_free0 (domainpart);
			_g_free0 (localpart);
			_g_free0 (_tmp6_);
			_g_free0 (resourcepart);
			_g_free0 (_tmp1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_free0 (domainpart);
	_g_free0 (localpart);
	_g_free0 (_tmp6_);
	_g_free0 (resourcepart);
	_g_free0 (_tmp1_);
	return self;
}

XmppJid*
xmpp_jid_new (const gchar* jid,
              GError** error)
{
	return xmpp_jid_construct (XMPP_TYPE_JID, jid, error);
}

static XmppJid*
xmpp_jid_construct_intern (GType object_type,
                           gchar* jid,
                           gchar* localpart,
                           gchar* domainpart,
                           gchar* resourcepart)
{
	XmppJid* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (domainpart != NULL, NULL);
	self = (XmppJid*) g_type_create_instance (object_type);
	_tmp0_ = jid;
	jid = NULL;
	_g_free0 (self->priv->jid);
	self->priv->jid = _tmp0_;
	_tmp1_ = localpart;
	localpart = NULL;
	_g_free0 (self->localpart);
	self->localpart = _tmp1_;
	_tmp2_ = domainpart;
	domainpart = NULL;
	_g_free0 (self->domainpart);
	self->domainpart = _tmp2_;
	_tmp3_ = resourcepart;
	resourcepart = NULL;
	_g_free0 (self->resourcepart);
	self->resourcepart = _tmp3_;
	_g_free0 (jid);
	_g_free0 (localpart);
	_g_free0 (domainpart);
	_g_free0 (resourcepart);
	return self;
}

static XmppJid*
xmpp_jid_new_intern (gchar* jid,
                     gchar* localpart,
                     gchar* domainpart,
                     gchar* resourcepart)
{
	return xmpp_jid_construct_intern (XMPP_TYPE_JID, jid, localpart, domainpart, resourcepart);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

XmppJid*
xmpp_jid_construct_components (GType object_type,
                               const gchar* localpart,
                               const gchar* domainpart,
                               const gchar* resourcepart,
                               GError** error)
{
	XmppJid* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gint _tmp13_;
	gchar* domain = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (domainpart != NULL, NULL);
	self = (XmppJid*) g_type_create_instance (object_type);
	_tmp0_ = strlen (domainpart);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_EMPTY_DOMAIN, "Domain is empty");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (localpart != NULL) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen (localpart);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_EMPTY_LOCAL, "Localpart is empty but non-null");
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (resourcepart != NULL) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = strlen (resourcepart);
		_tmp9_ = _tmp8_;
		_tmp7_ = _tmp9_ == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_EMPTY_RESOURCE, "Resource is empty but non-null");
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = strlen (domainpart);
	_tmp13_ = _tmp12_;
	if (string_get (domainpart, (glong) (_tmp13_ - 1)) == '.') {
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = strlen (domainpart);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_substring (domainpart, (glong) 0, (glong) (_tmp15_ - 1));
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp16_;
	} else {
		gchar* _tmp17_;
		_tmp17_ = g_strdup (domainpart);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp17_;
	}
	_tmp18_ = g_strdup (_tmp11_);
	domain = _tmp18_;
	_tmp19_ = domain;
	if (string_contains (_tmp19_, "xn--")) {
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = domain;
		_tmp22_ = xmpp_jid_idna_decode (_tmp21_, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (domain);
				_g_free0 (_tmp11_);
				_xmpp_jid_unref0 (self);
				return NULL;
			} else {
				_g_free0 (domain);
				_g_free0 (_tmp11_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp23_ = _tmp20_;
		_tmp20_ = NULL;
		_g_free0 (domain);
		domain = _tmp23_;
		_g_free0 (_tmp20_);
	}
	_tmp25_ = xmpp_jid_prepare (localpart, USPREP_RFC3920_NODEPREP, FALSE, &_inner_error0_);
	_tmp24_ = _tmp25_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp26_ = _tmp24_;
	_tmp24_ = NULL;
	_g_free0 (self->localpart);
	self->localpart = _tmp26_;
	_tmp28_ = domain;
	_tmp29_ = xmpp_jid_prepare (_tmp28_, USPREP_RFC3491_NAMEPREP, FALSE, &_inner_error0_);
	_tmp27_ = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp30_ = _tmp27_;
	_tmp27_ = NULL;
	_g_free0 (self->domainpart);
	self->domainpart = _tmp30_;
	_tmp32_ = xmpp_jid_prepare (resourcepart, USPREP_RFC3920_RESOURCEPREP, FALSE, &_inner_error0_);
	_tmp31_ = _tmp32_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp27_);
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp33_ = _tmp31_;
	_tmp31_ = NULL;
	_g_free0 (self->resourcepart);
	self->resourcepart = _tmp33_;
	_tmp34_ = self->domainpart;
	xmpp_jid_idna_verify (_tmp34_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			_xmpp_jid_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp31_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp24_);
			_g_free0 (domain);
			_g_free0 (_tmp11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_free0 (_tmp31_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (domain);
	_g_free0 (_tmp11_);
	return self;
}

XmppJid*
xmpp_jid_new_components (const gchar* localpart,
                         const gchar* domainpart,
                         const gchar* resourcepart,
                         GError** error)
{
	return xmpp_jid_construct_components (XMPP_TYPE_JID, localpart, domainpart, resourcepart, error);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
xmpp_jid_idna_decode (const gchar* src,
                      GError** error)
{
	UErrorCode status = 0;
	UIDNAInfo info = (UIDNAInfo) UIDNA_INFO_INITIALIZER;
	gchar* dest = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint dest_length1;
	gint _dest_size_;
	UIDNA* _tmp3_;
	UIDNA* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	UIDNAInfo _tmp6_ = (UIDNAInfo) UIDNA_INFO_INITIALIZER;
	gchar* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (src != NULL, NULL);
	status = U_ZERO_ERROR;
	_tmp0_ = strlen (src);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ * 2);
	dest = _tmp2_;
	dest_length1 = _tmp1_ * 2;
	_dest_size_ = dest_length1;
	_tmp3_ = uidna_openUTS46 (UIDNA_DEFAULT, &status);
	_tmp4_ = _tmp3_;
	_tmp5_ = dest;
	_tmp5__length1 = dest_length1;
	uidna_nameToUnicodeUTF8 (_tmp4_, src, (gint32) -1, _tmp5_, (gint) _tmp5__length1, &_tmp6_, &status);
	info = _tmp6_;
	_uidna_close0 (_tmp4_);
	if (status == U_INVALID_CHAR_FOUND) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_INVALID_CHAR, "Found invalid character");
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			dest = (g_free (dest), NULL);
			return NULL;
		} else {
			dest = (g_free (dest), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		gboolean _tmp8_ = FALSE;
		if (U_FAILURE (status)) {
			_tmp8_ = TRUE;
		} else {
			UIDNAInfo _tmp9_;
			_tmp9_ = info;
			_tmp8_ = _tmp9_.errors > ((guint32) 0);
		}
		if (_tmp8_) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GError* _tmp14_;
			GError* _tmp15_;
			_tmp10_ = u_errorName (status);
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strconcat ("Unknown error: ", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_UNKNOWN, _tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			_inner_error0_ = _tmp15_;
			if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
				g_propagate_error (error, _inner_error0_);
				dest = (g_free (dest), NULL);
				return NULL;
			} else {
				dest = (g_free (dest), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp16_ = dest;
	_tmp16__length1 = dest_length1;
	_tmp17_ = g_strdup ((const gchar*) _tmp16_);
	result = _tmp17_;
	dest = (g_free (dest), NULL);
	return result;
}

static void
xmpp_jid_idna_verify (const gchar* src,
                      GError** error)
{
	UErrorCode status = 0;
	UIDNAInfo info = (UIDNAInfo) UIDNA_INFO_INITIALIZER;
	gchar* dest = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint dest_length1;
	gint _dest_size_;
	UIDNA* _tmp3_;
	UIDNA* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	UIDNAInfo _tmp6_ = (UIDNAInfo) UIDNA_INFO_INITIALIZER;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	status = U_ZERO_ERROR;
	_tmp0_ = strlen (src);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ * 2);
	dest = _tmp2_;
	dest_length1 = _tmp1_ * 2;
	_dest_size_ = dest_length1;
	_tmp3_ = uidna_openUTS46 (UIDNA_DEFAULT, &status);
	_tmp4_ = _tmp3_;
	_tmp5_ = dest;
	_tmp5__length1 = dest_length1;
	uidna_nameToASCII_UTF8 (_tmp4_, src, (gint32) -1, _tmp5_, (gint) _tmp5__length1, &_tmp6_, &status);
	info = _tmp6_;
	_uidna_close0 (_tmp4_);
	if (status == U_INVALID_CHAR_FOUND) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_INVALID_CHAR, "Found invalid character");
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			dest = (g_free (dest), NULL);
			return;
		} else {
			dest = (g_free (dest), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		gboolean _tmp8_ = FALSE;
		if (U_FAILURE (status)) {
			_tmp8_ = TRUE;
		} else {
			UIDNAInfo _tmp9_;
			_tmp9_ = info;
			_tmp8_ = _tmp9_.errors > ((guint32) 0);
		}
		if (_tmp8_) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GError* _tmp14_;
			GError* _tmp15_;
			_tmp10_ = u_errorName (status);
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strconcat ("Unknown error: ", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_UNKNOWN, _tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			_inner_error0_ = _tmp15_;
			if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
				g_propagate_error (error, _inner_error0_);
				dest = (g_free (dest), NULL);
				return;
			} else {
				dest = (g_free (dest), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	dest = (g_free (dest), NULL);
}

static UChar*
icu_string_alloc (gint32 length)
{
	UChar* _tmp0_;
	UChar* result;
	_tmp0_ = g_new0 (UChar, length);
	result = (UChar*) ((UChar*) _tmp0_);
	return result;
}

static UChar*
icu_string_from_string (const gchar* src,
                        GError** error)
{
	UErrorCode status = 0;
	gint32 dest_capacity = 0;
	gint _tmp0_;
	gint _tmp1_;
	UChar* dest = {0};
	UChar* _tmp2_;
	gint32 dest_length = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint32 _tmp5_ = 0;
	GError* _inner_error0_ = NULL;
	UChar* result;
	status = U_ZERO_ERROR;
	_tmp0_ = strlen (src);
	_tmp1_ = _tmp0_;
	dest_capacity = (gint32) ((_tmp1_ * 2) + 1);
	_tmp2_ = icu_string_alloc (dest_capacity);
	dest = _tmp2_;
	_tmp3_ = strlen (src);
	_tmp4_ = _tmp3_;
	u_strFromUTF8 (dest, dest_capacity, &_tmp5_, src, (gint32) _tmp4_, &status);
	dest_length = _tmp5_;
	if (U_FAILURE (status)) {
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp6_ = u_errorName (status);
		_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp6_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == G_CONVERT_ERROR) {
			UChar* _tmp8_ = {0};
			g_propagate_error (error, _inner_error0_);
			g_free (dest);
			return _tmp8_;
		} else {
			UChar* _tmp9_ = {0};
			g_free (dest);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	result = dest;
	return result;
}

static gchar*
icu_string_to_string (UChar* self,
                      GError** error)
{
	UErrorCode status = 0;
	gchar* dest = NULL;
	gchar* _tmp0_;
	gint dest_length1;
	gint _dest_size_;
	gint32 dest_length = 0;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint32 _tmp2_ = 0;
	gchar* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	status = U_ZERO_ERROR;
	_tmp0_ = g_new0 (gchar, (u_strlen (self) * 4) + 1);
	dest = _tmp0_;
	dest_length1 = (u_strlen (self) * 4) + 1;
	_dest_size_ = dest_length1;
	_tmp1_ = dest;
	_tmp1__length1 = dest_length1;
	u_strToUTF8 (_tmp1_, (gint) _tmp1__length1, &_tmp2_, self, (gint32) -1, &status);
	dest_length = _tmp2_;
	if (U_FAILURE (status)) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = u_errorName (status);
		_tmp4_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp3_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == G_CONVERT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			dest = (g_free (dest), NULL);
			return NULL;
		} else {
			dest = (g_free (dest), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = dest;
	_tmp5__length1 = dest_length1;
	_tmp5_[dest_length] = (gchar) 0;
	_tmp6_ = dest;
	_tmp6__length1 = dest_length1;
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	result = _tmp7_;
	dest = (g_free (dest), NULL);
	return result;
}

static gchar*
xmpp_jid_prepare (const gchar* src,
                  UStringPrepProfileType type,
                  gboolean strict,
                  GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	if (src == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (src);
		result = _tmp0_;
		return result;
	}
	{
		UParseError _error_ = {0};
		UErrorCode status = 0;
		UStringPrepProfile* profile = NULL;
		UStringPrepProfile* _tmp1_;
		UChar* src16 = {0};
		UChar* _tmp2_;
		gint32 dest16_capacity = 0;
		UChar* dest16 = {0};
		UChar* _tmp3_;
		int32_t _tmp4_ = 0;
		glong dest16_length = 0L;
		UStringPrepProfile* _tmp5_;
		UParseError _tmp6_ = {0};
		gint32 _tmp7_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		status = U_ZERO_ERROR;
		_tmp1_ = usprep_openByType (type, &status);
		profile = _tmp1_;
		_tmp2_ = icu_string_from_string (src, &_inner_error0_);
		src16 = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_usprep_close0 (profile);
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		dest16_capacity = (u_strlen (src16) * 2) + 1;
		_tmp3_ = icu_string_alloc (dest16_capacity);
		dest16 = _tmp3_;
		if (strict) {
			_tmp4_ = USPREP_DEFAULT;
		} else {
			_tmp4_ = USPREP_ALLOW_UNASSIGNED;
		}
		_tmp5_ = profile;
		_tmp7_ = usprep_prepare (_tmp5_, src16, u_strlen (src16), dest16, dest16_capacity, _tmp4_, &_tmp6_, &status);
		_error_ = _tmp6_;
		dest16_length = (glong) _tmp7_;
		if (status == U_INVALID_CHAR_FOUND) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_INVALID_CHAR, "Found invalid character");
			_inner_error0_ = _tmp8_;
			g_free (dest16);
			g_free (src16);
			_usprep_close0 (profile);
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			goto __finally0;
		} else {
			if (status == U_STRINGPREP_PROHIBITED_ERROR) {
				GError* _tmp9_;
				_tmp9_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_INVALID_CHAR, "Found prohibited character");
				_inner_error0_ = _tmp9_;
				g_free (dest16);
				g_free (src16);
				_usprep_close0 (profile);
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				goto __finally0;
			} else {
				if (status != U_ZERO_ERROR) {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					GError* _tmp14_;
					GError* _tmp15_;
					_tmp10_ = u_errorName (status);
					_tmp11_ = string_to_string (_tmp10_);
					_tmp12_ = g_strconcat ("Unknown error: ", _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_UNKNOWN, _tmp13_);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					_inner_error0_ = _tmp15_;
					g_free (dest16);
					g_free (src16);
					_usprep_close0 (profile);
					if (_inner_error0_->domain == G_CONVERT_ERROR) {
						goto __catch0_g_convert_error;
					}
					goto __finally0;
				} else {
					if (dest16_length < ((glong) 0)) {
						GError* _tmp16_;
						_tmp16_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_UNKNOWN, "Unknown error");
						_inner_error0_ = _tmp16_;
						g_free (dest16);
						g_free (src16);
						_usprep_close0 (profile);
						if (_inner_error0_->domain == G_CONVERT_ERROR) {
							goto __catch0_g_convert_error;
						}
						goto __finally0;
					}
				}
			}
		}
		_tmp18_ = icu_string_to_string (dest16, &_inner_error0_);
		_tmp17_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_free (dest16);
			g_free (src16);
			_usprep_close0 (profile);
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp19_ = _tmp17_;
		_tmp17_ = NULL;
		result = _tmp19_;
		_g_free0 (_tmp17_);
		g_free (dest16);
		g_free (src16);
		_usprep_close0 (profile);
		return result;
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GError* _tmp25_;
		GError* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("Conversion error: ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_error_new_literal (XMPP_INVALID_JID_ERROR, XMPP_INVALID_JID_ERROR_INVALID_CHAR, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_inner_error0_ = _tmp26_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

XmppJid*
xmpp_jid_with_resource (XmppJid* self,
                        const gchar* resourcepart,
                        GError** error)
{
	XmppJid* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	XmppJid* _tmp3_;
	XmppJid* _tmp4_;
	GError* _inner_error0_ = NULL;
	XmppJid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->localpart;
	_tmp2_ = self->domainpart;
	_tmp3_ = xmpp_jid_new_components (_tmp1_, _tmp2_, resourcepart, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_xmpp_jid_unref0 (_tmp0_);
	return result;
}

gboolean
xmpp_jid_is_domain (XmppJid* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->localpart;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->resourcepart;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
xmpp_jid_is_bare (XmppJid* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->resourcepart;
	result = _tmp0_ == NULL;
	return result;
}

gboolean
xmpp_jid_is_full (XmppJid* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->localpart;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->resourcepart;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
xmpp_jid_to_string (XmppJid* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->jid;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		_tmp2_ = self->localpart;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			_tmp3_ = self->resourcepart;
			_tmp1_ = _tmp3_ != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = self->localpart;
			_tmp5_ = string_to_string (_tmp4_);
			_tmp6_ = self->domainpart;
			_tmp7_ = string_to_string (_tmp6_);
			_tmp8_ = self->resourcepart;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = g_strconcat (_tmp5_, "@", _tmp7_, "/", _tmp9_, NULL);
			_g_free0 (self->priv->jid);
			self->priv->jid = _tmp10_;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = self->localpart;
			if (_tmp11_ != NULL) {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp12_ = self->localpart;
				_tmp13_ = string_to_string (_tmp12_);
				_tmp14_ = self->domainpart;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = g_strconcat (_tmp13_, "@", _tmp15_, NULL);
				_g_free0 (self->priv->jid);
				self->priv->jid = _tmp16_;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = self->resourcepart;
				if (_tmp17_ != NULL) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp18_ = self->domainpart;
					_tmp19_ = string_to_string (_tmp18_);
					_tmp20_ = self->resourcepart;
					_tmp21_ = string_to_string (_tmp20_);
					_tmp22_ = g_strconcat (_tmp19_, "/", _tmp21_, NULL);
					_g_free0 (self->priv->jid);
					self->priv->jid = _tmp22_;
				} else {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = self->domainpart;
					_tmp24_ = g_strdup (_tmp23_);
					_g_free0 (self->priv->jid);
					self->priv->jid = _tmp24_;
				}
			}
		}
	}
	_tmp25_ = self->priv->jid;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	return result;
}

gboolean
xmpp_jid_equals_bare (XmppJid* self,
                      XmppJid* jid)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (jid != NULL) {
		_tmp0_ = xmpp_jid_equals_bare_func (self, jid);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
xmpp_jid_equals (XmppJid* self,
                 XmppJid* jid)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (jid != NULL) {
		_tmp0_ = xmpp_jid_equals_func (self, jid);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
xmpp_jid_equals_bare_func (XmppJid* jid1,
                           XmppJid* jid2)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (jid1 != NULL, FALSE);
	g_return_val_if_fail (jid2 != NULL, FALSE);
	_tmp1_ = jid1->localpart;
	_tmp2_ = jid2->localpart;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = jid1->domainpart;
		_tmp4_ = jid2->domainpart;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
xmpp_jid_equals_func (XmppJid* jid1,
                      XmppJid* jid2)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (jid1 != NULL, FALSE);
	g_return_val_if_fail (jid2 != NULL, FALSE);
	if (xmpp_jid_equals_bare_func (jid1, jid2)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = jid1->resourcepart;
		_tmp2_ = jid2->resourcepart;
		_tmp0_ = g_strcmp0 (_tmp1_, _tmp2_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
xmpp_jid_hash_bare_func (XmppJid* jid)
{
	XmppJid* _tmp0_;
	XmppJid* _tmp1_;
	XmppJid* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint result;
	g_return_val_if_fail (jid != NULL, 0U);
	_tmp0_ = xmpp_jid_get_bare_jid (jid);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = xmpp_jid_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_str_hash (_tmp4_);
	_g_free0 (_tmp4_);
	_xmpp_jid_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

guint
xmpp_jid_hash_func (XmppJid* jid)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (jid != NULL, 0U);
	_tmp0_ = xmpp_jid_to_string (jid);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_hash (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gpointer
_xmpp_jid_ref0 (gpointer self)
{
	return self ? xmpp_jid_ref (self) : NULL;
}

XmppJid*
xmpp_jid_get_bare_jid (XmppJid* self)
{
	XmppJid* result;
	XmppJid* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (xmpp_jid_is_bare (self)) {
		XmppJid* _tmp1_;
		_tmp1_ = _xmpp_jid_ref0 (self);
		_xmpp_jid_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		XmppJid* _tmp6_;
		_tmp2_ = self->localpart;
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = self->domainpart;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = xmpp_jid_new_intern (NULL, _tmp3_, _tmp5_, NULL);
		_xmpp_jid_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

XmppJid*
xmpp_jid_get_domain_jid (XmppJid* self)
{
	XmppJid* result;
	XmppJid* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (xmpp_jid_is_domain (self)) {
		XmppJid* _tmp1_;
		_tmp1_ = _xmpp_jid_ref0 (self);
		_xmpp_jid_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		XmppJid* _tmp6_;
		_tmp2_ = self->domainpart;
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = self->domainpart;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = xmpp_jid_new_intern (_tmp3_, NULL, _tmp5_, NULL);
		_xmpp_jid_unref0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

static void
xmpp_value_jid_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
xmpp_value_jid_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		xmpp_jid_unref (value->data[0].v_pointer);
	}
}

static void
xmpp_value_jid_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xmpp_jid_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
xmpp_value_jid_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
xmpp_value_jid_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		XmppJid * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xmpp_jid_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
xmpp_value_jid_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	XmppJid ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xmpp_jid_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
xmpp_param_spec_jid (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	XmppParamSpecJid* spec;
	g_return_val_if_fail (g_type_is_a (object_type, XMPP_TYPE_JID), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
xmpp_value_get_jid (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_JID), NULL);
	return value->data[0].v_pointer;
}

void
xmpp_value_set_jid (GValue* value,
                    gpointer v_object)
{
	XmppJid * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_JID));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, XMPP_TYPE_JID));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xmpp_jid_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xmpp_jid_unref (old);
	}
}

void
xmpp_value_take_jid (GValue* value,
                     gpointer v_object)
{
	XmppJid * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, XMPP_TYPE_JID));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, XMPP_TYPE_JID));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xmpp_jid_unref (old);
	}
}

static void
xmpp_jid_class_init (XmppJidClass * klass,
                     gpointer klass_data)
{
	xmpp_jid_parent_class = g_type_class_peek_parent (klass);
	((XmppJidClass *) klass)->finalize = xmpp_jid_finalize;
	g_type_class_adjust_private_offset (klass, &XmppJid_private_offset);
}

static void
xmpp_jid_instance_init (XmppJid * self,
                        gpointer klass)
{
	self->priv = xmpp_jid_get_instance_private (self);
	self->ref_count = 1;
}

static void
xmpp_jid_finalize (XmppJid * obj)
{
	XmppJid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XMPP_TYPE_JID, XmppJid);
	g_signal_handlers_destroy (self);
	_g_free0 (self->localpart);
	_g_free0 (self->domainpart);
	_g_free0 (self->resourcepart);
	_g_free0 (self->priv->jid);
}

static GType
xmpp_jid_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { xmpp_value_jid_init, xmpp_value_jid_free_value, xmpp_value_jid_copy_value, xmpp_value_jid_peek_pointer, "p", xmpp_value_jid_collect_value, "p", xmpp_value_jid_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (XmppJidClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xmpp_jid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XmppJid), 0, (GInstanceInitFunc) xmpp_jid_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType xmpp_jid_type_id;
	xmpp_jid_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XmppJid", &g_define_type_info, &g_define_type_fundamental_info, 0);
	XmppJid_private_offset = g_type_add_instance_private (xmpp_jid_type_id, sizeof (XmppJidPrivate));
	return xmpp_jid_type_id;
}

GType
xmpp_jid_get_type (void)
{
	static volatile gsize xmpp_jid_type_id__once = 0;
	if (g_once_init_enter (&xmpp_jid_type_id__once)) {
		GType xmpp_jid_type_id;
		xmpp_jid_type_id = xmpp_jid_get_type_once ();
		g_once_init_leave (&xmpp_jid_type_id__once, xmpp_jid_type_id);
	}
	return xmpp_jid_type_id__once;
}

gpointer
xmpp_jid_ref (gpointer instance)
{
	XmppJid * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
xmpp_jid_unref (gpointer instance)
{
	XmppJid * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XMPP_JID_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GQuark
xmpp_invalid_jid_error_quark (void)
{
	return g_quark_from_static_string ("xmpp-invalid-jid-error-quark");
}

static GType
xmpp_invalid_jid_error_get_type_once (void)
{
	static const GEnumValue values[] = {{XMPP_INVALID_JID_ERROR_EMPTY_DOMAIN, "XMPP_INVALID_JID_ERROR_EMPTY_DOMAIN", "empty-domain"}, {XMPP_INVALID_JID_ERROR_EMPTY_RESOURCE, "XMPP_INVALID_JID_ERROR_EMPTY_RESOURCE", "empty-resource"}, {XMPP_INVALID_JID_ERROR_EMPTY_LOCAL, "XMPP_INVALID_JID_ERROR_EMPTY_LOCAL", "empty-local"}, {XMPP_INVALID_JID_ERROR_INVALID_CHAR, "XMPP_INVALID_JID_ERROR_INVALID_CHAR", "invalid-char"}, {XMPP_INVALID_JID_ERROR_UNKNOWN, "XMPP_INVALID_JID_ERROR_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType xmpp_invalid_jid_error_type_id;
	xmpp_invalid_jid_error_type_id = g_enum_register_static ("XmppInvalidJidError", values);
	return xmpp_invalid_jid_error_type_id;
}

GType
xmpp_invalid_jid_error_get_type (void)
{
	static volatile gsize xmpp_invalid_jid_error_type_id__once = 0;
	if (g_once_init_enter (&xmpp_invalid_jid_error_type_id__once)) {
		GType xmpp_invalid_jid_error_type_id;
		xmpp_invalid_jid_error_type_id = xmpp_invalid_jid_error_get_type_once ();
		g_once_init_leave (&xmpp_invalid_jid_error_type_id__once, xmpp_invalid_jid_error_type_id);
	}
	return xmpp_invalid_jid_error_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

