/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	apisv1alpha2 "sigs.k8s.io/network-policy-api/apis/v1alpha2"
)

// ClusterNetworkPolicyEgressRuleApplyConfiguration represents a declarative configuration of the ClusterNetworkPolicyEgressRule type for use
// with apply.
type ClusterNetworkPolicyEgressRuleApplyConfiguration struct {
	Name      *string                                            `json:"name,omitempty"`
	Action    *apisv1alpha2.ClusterNetworkPolicyRuleAction       `json:"action,omitempty"`
	To        []ClusterNetworkPolicyEgressPeerApplyConfiguration `json:"to,omitempty"`
	Protocols []ClusterNetworkPolicyProtocolApplyConfiguration   `json:"protocols,omitempty"`
}

// ClusterNetworkPolicyEgressRuleApplyConfiguration constructs a declarative configuration of the ClusterNetworkPolicyEgressRule type for use with
// apply.
func ClusterNetworkPolicyEgressRule() *ClusterNetworkPolicyEgressRuleApplyConfiguration {
	return &ClusterNetworkPolicyEgressRuleApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ClusterNetworkPolicyEgressRuleApplyConfiguration) WithName(value string) *ClusterNetworkPolicyEgressRuleApplyConfiguration {
	b.Name = &value
	return b
}

// WithAction sets the Action field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Action field is set to the value of the last call.
func (b *ClusterNetworkPolicyEgressRuleApplyConfiguration) WithAction(value apisv1alpha2.ClusterNetworkPolicyRuleAction) *ClusterNetworkPolicyEgressRuleApplyConfiguration {
	b.Action = &value
	return b
}

// WithTo adds the given value to the To field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the To field.
func (b *ClusterNetworkPolicyEgressRuleApplyConfiguration) WithTo(values ...*ClusterNetworkPolicyEgressPeerApplyConfiguration) *ClusterNetworkPolicyEgressRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTo")
		}
		b.To = append(b.To, *values[i])
	}
	return b
}

// WithProtocols adds the given value to the Protocols field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Protocols field.
func (b *ClusterNetworkPolicyEgressRuleApplyConfiguration) WithProtocols(values ...*ClusterNetworkPolicyProtocolApplyConfiguration) *ClusterNetworkPolicyEgressRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithProtocols")
		}
		b.Protocols = append(b.Protocols, *values[i])
	}
	return b
}
