
#ifndef __RNA_BLENDER_H__
#define __RNA_BLENDER_H__

/* Automatically generated function declarations for the Data API.
 * Do not edit manually, changes will be overwritten.              */

#include "RNA_types.hh"

#include "DNA_node_types.h"

#define FOREACH_BEGIN(property, sptr, itemptr) \
    { \
        CollectionPropertyIterator rna_macro_iter; \
        for (property##_begin(&rna_macro_iter, sptr); rna_macro_iter.valid; property##_next(&rna_macro_iter)) { \
            itemptr = rna_macro_iter.ptr;

#define FOREACH_END(property) \
        } \
        property##_end(&rna_macro_iter); \
    }

/**************** Shader AOV ****************/

extern StructRNA RNA_AOV;

PointerRNA AOV_rna_type_get(PointerRNA *ptr);

#define AOV_name_MAX 64

void AOV_name_get(PointerRNA *ptr, char *value);
int AOV_name_length(PointerRNA *ptr);
void AOV_name_set(PointerRNA *ptr, const char *value);

enum {
	AOV_type_COLOR = 1,
	AOV_type_VALUE = 0,
};

int AOV_type_get(PointerRNA *ptr);
void AOV_type_set(PointerRNA *ptr, int value);

bool AOV_is_valid_get(PointerRNA *ptr);
void AOV_is_valid_set(PointerRNA *ptr, bool value);

/**************** List of AOVs ****************/

extern StructRNA RNA_AOVs;

PointerRNA AOVs_rna_type_get(PointerRNA *ptr);

struct ViewLayerAOV *AOVs_add_func(struct ViewLayer *_self);
void AOVs_remove_func(struct ViewLayer *_self, ReportList *reports, struct ViewLayerAOV *aov);
/**************** Action ****************/

extern StructRNA RNA_Action;
extern StructRNA RNA_ID;

void Action_curve_frame_range_get(PointerRNA *ptr, float values[2]);
void Action_curve_frame_range_set(PointerRNA *ptr, const float values[2]);

bool Action_use_cyclic_get(PointerRNA *ptr);
void Action_use_cyclic_set(PointerRNA *ptr, bool value);

float Action_frame_end_get(PointerRNA *ptr);
void Action_frame_end_set(PointerRNA *ptr, float value);

void Action_frame_range_get(PointerRNA *ptr, float values[2]);
void Action_frame_range_set(PointerRNA *ptr, const float values[2]);

bool Action_is_empty_get(PointerRNA *ptr);
void Action_is_empty_set(PointerRNA *ptr, bool value);

bool Action_is_action_layered_get(PointerRNA *ptr);
void Action_is_action_layered_set(PointerRNA *ptr, bool value);

bool Action_is_action_legacy_get(PointerRNA *ptr);
void Action_is_action_legacy_set(PointerRNA *ptr, bool value);

void Action_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_layers_next(CollectionPropertyIterator *iter);
void Action_layers_end(CollectionPropertyIterator *iter);
int Action_layers_length(PointerRNA *ptr);

bool Action_use_frame_range_get(PointerRNA *ptr);
void Action_use_frame_range_set(PointerRNA *ptr, bool value);

void Action_pose_markers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_pose_markers_next(CollectionPropertyIterator *iter);
void Action_pose_markers_end(CollectionPropertyIterator *iter);
bool Action_pose_markers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Action_pose_markers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Action_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Action_slots_next(CollectionPropertyIterator *iter);
void Action_slots_end(CollectionPropertyIterator *iter);
int Action_slots_length(PointerRNA *ptr);

float Action_frame_start_get(PointerRNA *ptr);
void Action_frame_start_set(PointerRNA *ptr, float value);

void Action_deselect_keys_func(struct bAction *_self);
struct FCurve *Action_fcurve_ensure_for_datablock_func(struct bAction *_self, Main *bmain, ReportList *reports, struct ID *datablock, const char * data_path, int index, const char * group_name);
void Action_flip_with_pose_func(struct bAction *_self, ReportList *reports, struct Object *object);
/**************** Animation Channel Bag ****************/

extern StructRNA RNA_ActionChannelbag;

PointerRNA ActionChannelbag_rna_type_get(PointerRNA *ptr);

void ActionChannelbag_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionChannelbag_groups_next(CollectionPropertyIterator *iter);
void ActionChannelbag_groups_end(CollectionPropertyIterator *iter);
int ActionChannelbag_groups_length(PointerRNA *ptr);

void ActionChannelbag_fcurves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionChannelbag_fcurves_next(CollectionPropertyIterator *iter);
void ActionChannelbag_fcurves_end(CollectionPropertyIterator *iter);
int ActionChannelbag_fcurves_length(PointerRNA *ptr);

PointerRNA ActionChannelbag_slot_get(PointerRNA *ptr);

int ActionChannelbag_slot_handle_get(PointerRNA *ptr);
void ActionChannelbag_slot_handle_set(PointerRNA *ptr, int value);

/**************** F-Curves ****************/

extern StructRNA RNA_ActionChannelbagFCurves;

PointerRNA ActionChannelbagFCurves_rna_type_get(PointerRNA *ptr);

struct FCurve *ActionChannelbagFCurves_new_func(struct ActionChannelbag *_self, Main *bmain, ReportList *reports, const char * data_path, int index, const char * group_name);
struct FCurve *ActionChannelbagFCurves_new_from_fcurve_func(struct ID *_selfid, struct ActionChannelbag *_self, ReportList *reports, struct FCurve *source, const char * data_path);
struct FCurve *ActionChannelbagFCurves_ensure_func(struct ActionChannelbag *_self, Main *bmain, ReportList *reports, const char * data_path, int index, const char * group_name);
struct FCurve *ActionChannelbagFCurves_find_func(struct ActionChannelbag *_self, ReportList *reports, const char * data_path, int index);
void ActionChannelbagFCurves_remove_func(struct ID *_selfid, struct ActionChannelbag *_self, bContext *C, ReportList *reports, struct PointerRNA *fcurve);
void ActionChannelbagFCurves_clear_func(struct ID *_selfid, struct ActionChannelbag *_self, bContext *C);
/**************** F-Curve Groups ****************/

extern StructRNA RNA_ActionChannelbagGroups;

PointerRNA ActionChannelbagGroups_rna_type_get(PointerRNA *ptr);

struct bActionGroup *ActionChannelbagGroups_new_func(struct ActionChannelbag *_self, const char * name);
void ActionChannelbagGroups_remove_func(struct ActionChannelbag *_self, ReportList *reports, struct PointerRNA *action_group);
/**************** Animation Channels for Slots ****************/

extern StructRNA RNA_ActionChannelbags;

PointerRNA ActionChannelbags_rna_type_get(PointerRNA *ptr);

struct ActionChannelbag *ActionChannelbags_new_func(struct ID *_selfid, struct ActionStrip *_self, bContext *C, ReportList *reports, struct ActionSlot *slot);
void ActionChannelbags_remove_func(struct ID *_selfid, struct ActionStrip *_self, bContext *C, ReportList *reports, struct PointerRNA *channelbag);
/**************** Action Constraint ****************/

extern StructRNA RNA_ActionConstraint;
extern StructRNA RNA_Constraint;

PointerRNA ActionConstraint_action_get(PointerRNA *ptr);

PointerRNA ActionConstraint_action_slot_get(PointerRNA *ptr);

int ActionConstraint_action_slot_handle_get(PointerRNA *ptr);
void ActionConstraint_action_slot_handle_set(PointerRNA *ptr, int value);

void ActionConstraint_action_suitable_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionConstraint_action_suitable_slots_next(CollectionPropertyIterator *iter);
void ActionConstraint_action_suitable_slots_end(CollectionPropertyIterator *iter);

int ActionConstraint_frame_end_get(PointerRNA *ptr);
void ActionConstraint_frame_end_set(PointerRNA *ptr, int value);

float ActionConstraint_eval_time_get(PointerRNA *ptr);
void ActionConstraint_eval_time_set(PointerRNA *ptr, float value);

#define ActionConstraint_last_slot_identifier_MAX 258

void ActionConstraint_last_slot_identifier_get(PointerRNA *ptr, char *value);
int ActionConstraint_last_slot_identifier_length(PointerRNA *ptr);
void ActionConstraint_last_slot_identifier_set(PointerRNA *ptr, const char *value);

float ActionConstraint_max_get(PointerRNA *ptr);
void ActionConstraint_max_set(PointerRNA *ptr, float value);

float ActionConstraint_min_get(PointerRNA *ptr);
void ActionConstraint_min_set(PointerRNA *ptr, float value);

enum {
	ActionConstraint_mix_mode_REPLACE = 6,
	ActionConstraint_mix_mode_BEFORE_FULL = 3,
	ActionConstraint_mix_mode_BEFORE = 2,
	ActionConstraint_mix_mode_BEFORE_SPLIT = 5,
	ActionConstraint_mix_mode_AFTER_FULL = 0,
	ActionConstraint_mix_mode_AFTER = 1,
	ActionConstraint_mix_mode_AFTER_SPLIT = 4,
};

int ActionConstraint_mix_mode_get(PointerRNA *ptr);
void ActionConstraint_mix_mode_set(PointerRNA *ptr, int value);

bool ActionConstraint_use_bone_object_action_get(PointerRNA *ptr);
void ActionConstraint_use_bone_object_action_set(PointerRNA *ptr, bool value);

int ActionConstraint_frame_start_get(PointerRNA *ptr);
void ActionConstraint_frame_start_set(PointerRNA *ptr, int value);

#define ActionConstraint_subtarget_MAX 64

void ActionConstraint_subtarget_get(PointerRNA *ptr, char *value);
int ActionConstraint_subtarget_length(PointerRNA *ptr);
void ActionConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ActionConstraint_target_get(PointerRNA *ptr);

enum {
	ActionConstraint_transform_channel_LOCATION_X = 20,
	ActionConstraint_transform_channel_LOCATION_Y = 21,
	ActionConstraint_transform_channel_LOCATION_Z = 22,
	ActionConstraint_transform_channel_ROTATION_X = 0,
	ActionConstraint_transform_channel_ROTATION_Y = 1,
	ActionConstraint_transform_channel_ROTATION_Z = 2,
	ActionConstraint_transform_channel_SCALE_X = 10,
	ActionConstraint_transform_channel_SCALE_Y = 11,
	ActionConstraint_transform_channel_SCALE_Z = 12,
};

int ActionConstraint_transform_channel_get(PointerRNA *ptr);
void ActionConstraint_transform_channel_set(PointerRNA *ptr, int value);

bool ActionConstraint_use_eval_time_get(PointerRNA *ptr);
void ActionConstraint_use_eval_time_set(PointerRNA *ptr, bool value);

/**************** Action Group ****************/

extern StructRNA RNA_ActionGroup;

PointerRNA ActionGroup_rna_type_get(PointerRNA *ptr);

#define ActionGroup_name_MAX 64

void ActionGroup_name_get(PointerRNA *ptr, char *value);
int ActionGroup_name_length(PointerRNA *ptr);
void ActionGroup_name_set(PointerRNA *ptr, const char *value);

void ActionGroup_channels_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionGroup_channels_next(CollectionPropertyIterator *iter);
void ActionGroup_channels_end(CollectionPropertyIterator *iter);

enum {
	ActionGroup_color_set_DEFAULT = 0,
	ActionGroup_color_set_THEME01 = 1,
	ActionGroup_color_set_THEME02 = 2,
	ActionGroup_color_set_THEME03 = 3,
	ActionGroup_color_set_THEME04 = 4,
	ActionGroup_color_set_THEME05 = 5,
	ActionGroup_color_set_THEME06 = 6,
	ActionGroup_color_set_THEME07 = 7,
	ActionGroup_color_set_THEME08 = 8,
	ActionGroup_color_set_THEME09 = 9,
	ActionGroup_color_set_THEME10 = 10,
	ActionGroup_color_set_THEME11 = 11,
	ActionGroup_color_set_THEME12 = 12,
	ActionGroup_color_set_THEME13 = 13,
	ActionGroup_color_set_THEME14 = 14,
	ActionGroup_color_set_THEME15 = 15,
	ActionGroup_color_set_THEME16 = 16,
	ActionGroup_color_set_THEME17 = 17,
	ActionGroup_color_set_THEME18 = 18,
	ActionGroup_color_set_THEME19 = 19,
	ActionGroup_color_set_THEME20 = 20,
	ActionGroup_color_set_CUSTOM = -1,
};

int ActionGroup_color_set_get(PointerRNA *ptr);
void ActionGroup_color_set_set(PointerRNA *ptr, int value);

PointerRNA ActionGroup_colors_get(PointerRNA *ptr);

bool ActionGroup_is_custom_color_set_get(PointerRNA *ptr);
void ActionGroup_is_custom_color_set_set(PointerRNA *ptr, bool value);

bool ActionGroup_show_expanded_get(PointerRNA *ptr);
void ActionGroup_show_expanded_set(PointerRNA *ptr, bool value);

bool ActionGroup_show_expanded_graph_get(PointerRNA *ptr);
void ActionGroup_show_expanded_graph_set(PointerRNA *ptr, bool value);

bool ActionGroup_lock_get(PointerRNA *ptr);
void ActionGroup_lock_set(PointerRNA *ptr, bool value);

bool ActionGroup_mute_get(PointerRNA *ptr);
void ActionGroup_mute_set(PointerRNA *ptr, bool value);

bool ActionGroup_use_pin_get(PointerRNA *ptr);
void ActionGroup_use_pin_set(PointerRNA *ptr, bool value);

bool ActionGroup_select_get(PointerRNA *ptr);
void ActionGroup_select_set(PointerRNA *ptr, bool value);

/**************** Keyframe Animation Strip ****************/

extern StructRNA RNA_ActionKeyframeStrip;
extern StructRNA RNA_ActionStrip;

void ActionKeyframeStrip_channelbags_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionKeyframeStrip_channelbags_next(CollectionPropertyIterator *iter);
void ActionKeyframeStrip_channelbags_end(CollectionPropertyIterator *iter);
int ActionKeyframeStrip_channelbags_length(PointerRNA *ptr);

struct ActionChannelbag *ActionKeyframeStrip_channelbag_func(struct ID *_selfid, struct ActionStrip *_self, ReportList *reports, struct ActionSlot *slot, bool ensure);
bool ActionKeyframeStrip_key_insert_func(struct ID *_selfid, struct ActionStrip *_self, Main *bmain, ReportList *reports, struct ActionSlot *slot, const char * data_path, int array_index, float value, float time);
/**************** Action Layer ****************/

extern StructRNA RNA_ActionLayer;

PointerRNA ActionLayer_rna_type_get(PointerRNA *ptr);

#define ActionLayer_name_MAX 64

void ActionLayer_name_get(PointerRNA *ptr, char *value);
int ActionLayer_name_length(PointerRNA *ptr);
void ActionLayer_name_set(PointerRNA *ptr, const char *value);

void ActionLayer_strips_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ActionLayer_strips_next(CollectionPropertyIterator *iter);
void ActionLayer_strips_end(CollectionPropertyIterator *iter);
int ActionLayer_strips_length(PointerRNA *ptr);

/**************** Action Layers ****************/

extern StructRNA RNA_ActionLayers;

PointerRNA ActionLayers_rna_type_get(PointerRNA *ptr);

struct ActionLayer *ActionLayers_new_func(struct bAction *_self, bContext *C, ReportList *reports, const char * name);
void ActionLayers_remove_func(struct bAction *_self, bContext *C, ReportList *reports, struct PointerRNA *anim_layer);
/**************** Action Pose Markers ****************/

extern StructRNA RNA_ActionPoseMarkers;

PointerRNA ActionPoseMarkers_rna_type_get(PointerRNA *ptr);

PointerRNA ActionPoseMarkers_active_get(PointerRNA *ptr);

int ActionPoseMarkers_active_index_get(PointerRNA *ptr);
void ActionPoseMarkers_active_index_set(PointerRNA *ptr, int value);

struct TimeMarker *ActionPoseMarkers_new_func(struct bAction *_self, const char * name);
void ActionPoseMarkers_remove_func(struct bAction *_self, ReportList *reports, struct PointerRNA *marker);
/**************** Action slot ****************/

extern StructRNA RNA_ActionSlot;

PointerRNA ActionSlot_rna_type_get(PointerRNA *ptr);

bool ActionSlot_active_get(PointerRNA *ptr);
void ActionSlot_active_set(PointerRNA *ptr, bool value);

bool ActionSlot_select_get(PointerRNA *ptr);
void ActionSlot_select_set(PointerRNA *ptr, bool value);

bool ActionSlot_show_expanded_get(PointerRNA *ptr);
void ActionSlot_show_expanded_set(PointerRNA *ptr, bool value);

#define ActionSlot_name_display_MAX 256

void ActionSlot_name_display_get(PointerRNA *ptr, char *value);
int ActionSlot_name_display_length(PointerRNA *ptr);
void ActionSlot_name_display_set(PointerRNA *ptr, const char *value);

int ActionSlot_handle_get(PointerRNA *ptr);
void ActionSlot_handle_set(PointerRNA *ptr, int value);

#define ActionSlot_identifier_MAX 258

void ActionSlot_identifier_get(PointerRNA *ptr, char *value);
int ActionSlot_identifier_length(PointerRNA *ptr);
void ActionSlot_identifier_set(PointerRNA *ptr, const char *value);

enum {
	ActionSlot_target_id_type_UNSPECIFIED = 0,
};

int ActionSlot_target_id_type_get(PointerRNA *ptr);
void ActionSlot_target_id_type_set(PointerRNA *ptr, int value);

int ActionSlot_target_id_type_icon_get(PointerRNA *ptr);
void ActionSlot_target_id_type_icon_set(PointerRNA *ptr, int value);

struct CollectionVector ActionSlot_users_func(struct ActionSlot *_self, Main *bmain);
struct ActionSlot *ActionSlot_duplicate_func(struct ID *_selfid, struct ActionSlot *_self);
/**************** Action Slots ****************/

extern StructRNA RNA_ActionSlots;

PointerRNA ActionSlots_rna_type_get(PointerRNA *ptr);

PointerRNA ActionSlots_active_get(PointerRNA *ptr);

struct ActionSlot *ActionSlots_new_func(struct bAction *_self, Main *bmain, bContext *C, ReportList *reports, int id_type, const char * name);
void ActionSlots_remove_func(struct bAction *_self, bContext *C, ReportList *reports, struct PointerRNA *action_slot);
/**************** Action Strip ****************/

extern StructRNA RNA_ActionStrip;

PointerRNA ActionStrip_rna_type_get(PointerRNA *ptr);

enum {
	ActionStrip_type_KEYFRAME = 0,
};

int ActionStrip_type_get(PointerRNA *ptr);
void ActionStrip_type_set(PointerRNA *ptr, int value);

/**************** Action Strips ****************/

extern StructRNA RNA_ActionStrips;

PointerRNA ActionStrips_rna_type_get(PointerRNA *ptr);

struct ActionStrip *ActionStrips_new_func(struct ID *_selfid, struct ActionLayer *_self, bContext *C, ReportList *reports, int type);
void ActionStrips_remove_func(struct ID *_selfid, struct ActionLayer *_self, bContext *C, ReportList *reports, struct PointerRNA *anim_strip);
/**************** Add Strip ****************/

extern StructRNA RNA_AddStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA AddStrip_input_1_get(PointerRNA *ptr);

PointerRNA AddStrip_input_2_get(PointerRNA *ptr);

int AddStrip_input_count_get(PointerRNA *ptr);
void AddStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Add-on ****************/

extern StructRNA RNA_Addon;

PointerRNA Addon_rna_type_get(PointerRNA *ptr);

#define Addon_module_MAX 128

void Addon_module_get(PointerRNA *ptr, char *value);
int Addon_module_length(PointerRNA *ptr);
void Addon_module_set(PointerRNA *ptr, const char *value);

PointerRNA Addon_preferences_get(PointerRNA *ptr);

/**************** Add-on Preferences ****************/

extern StructRNA RNA_AddonPreferences;

PointerRNA AddonPreferences_rna_type_get(PointerRNA *ptr);

#define AddonPreferences_bl_idname_MAX 128

void AddonPreferences_bl_idname_get(PointerRNA *ptr, char *value);
int AddonPreferences_bl_idname_length(PointerRNA *ptr);
void AddonPreferences_bl_idname_set(PointerRNA *ptr, const char *value);

struct IDPropertyGroup *AddonPreferences_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
/**************** User Add-ons ****************/

extern StructRNA RNA_Addons;

PointerRNA Addons_rna_type_get(PointerRNA *ptr);

struct bAddon *Addons_new_func(void);
void Addons_remove_func(ReportList *reports, struct PointerRNA *addon);
/**************** Adjustment Layer Strip ****************/

extern StructRNA RNA_AdjustmentStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

int AdjustmentStrip_animation_offset_end_get(PointerRNA *ptr);
void AdjustmentStrip_animation_offset_end_set(PointerRNA *ptr, int value);

int AdjustmentStrip_animation_offset_start_get(PointerRNA *ptr);
void AdjustmentStrip_animation_offset_start_set(PointerRNA *ptr, int value);

int AdjustmentStrip_input_count_get(PointerRNA *ptr);
void AdjustmentStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Alpha Over Strip ****************/

extern StructRNA RNA_AlphaOverStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA AlphaOverStrip_input_1_get(PointerRNA *ptr);

PointerRNA AlphaOverStrip_input_2_get(PointerRNA *ptr);

int AlphaOverStrip_input_count_get(PointerRNA *ptr);
void AlphaOverStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Alpha Under Strip ****************/

extern StructRNA RNA_AlphaUnderStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA AlphaUnderStrip_input_1_get(PointerRNA *ptr);

PointerRNA AlphaUnderStrip_input_2_get(PointerRNA *ptr);

int AlphaUnderStrip_input_count_get(PointerRNA *ptr);
void AlphaUnderStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Animation Data ****************/

extern StructRNA RNA_AnimData;

PointerRNA AnimData_rna_type_get(PointerRNA *ptr);

PointerRNA AnimData_action_get(PointerRNA *ptr);

enum {
	AnimData_action_blend_type_REPLACE = 0,
	AnimData_action_blend_type_COMBINE = 4,
	AnimData_action_blend_type_ADD = 1,
	AnimData_action_blend_type_SUBTRACT = 2,
	AnimData_action_blend_type_MULTIPLY = 3,
};

int AnimData_action_blend_type_get(PointerRNA *ptr);
void AnimData_action_blend_type_set(PointerRNA *ptr, int value);

enum {
	AnimData_action_extrapolation_NOTHING = 2,
	AnimData_action_extrapolation_HOLD = 0,
	AnimData_action_extrapolation_HOLD_FORWARD = 1,
};

int AnimData_action_extrapolation_get(PointerRNA *ptr);
void AnimData_action_extrapolation_set(PointerRNA *ptr, int value);

float AnimData_action_influence_get(PointerRNA *ptr);
void AnimData_action_influence_set(PointerRNA *ptr, float value);

PointerRNA AnimData_action_slot_get(PointerRNA *ptr);

int AnimData_action_slot_handle_get(PointerRNA *ptr);
void AnimData_action_slot_handle_set(PointerRNA *ptr, int value);

void AnimData_drivers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnimData_drivers_next(CollectionPropertyIterator *iter);
void AnimData_drivers_end(CollectionPropertyIterator *iter);
bool AnimData_drivers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

#define AnimData_last_slot_identifier_MAX 258

void AnimData_last_slot_identifier_get(PointerRNA *ptr, char *value);
int AnimData_last_slot_identifier_length(PointerRNA *ptr);
void AnimData_last_slot_identifier_set(PointerRNA *ptr, const char *value);

bool AnimData_use_nla_get(PointerRNA *ptr);
void AnimData_use_nla_set(PointerRNA *ptr, bool value);

void AnimData_nla_tracks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnimData_nla_tracks_next(CollectionPropertyIterator *iter);
void AnimData_nla_tracks_end(CollectionPropertyIterator *iter);
bool AnimData_nla_tracks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool AnimData_nla_tracks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool AnimData_use_pin_get(PointerRNA *ptr);
void AnimData_use_pin_set(PointerRNA *ptr, bool value);

void AnimData_action_suitable_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnimData_action_suitable_slots_next(CollectionPropertyIterator *iter);
void AnimData_action_suitable_slots_end(CollectionPropertyIterator *iter);

int AnimData_action_slot_handle_tweak_storage_get(PointerRNA *ptr);
void AnimData_action_slot_handle_tweak_storage_set(PointerRNA *ptr, int value);

PointerRNA AnimData_action_tweak_storage_get(PointerRNA *ptr);

bool AnimData_use_tweak_mode_get(PointerRNA *ptr);
void AnimData_use_tweak_mode_set(PointerRNA *ptr, bool value);

float AnimData_nla_tweak_strip_time_to_scene_func(struct AnimData *_self, float frame, bool invert);
void AnimData_fix_paths_rename_all_func(struct ID *_selfid, struct AnimData *_self, Main *bmain, const char * prefix, const char * old_name, const char * new_name);
/**************** Drivers ****************/

extern StructRNA RNA_AnimDataDrivers;

PointerRNA AnimDataDrivers_rna_type_get(PointerRNA *ptr);

struct FCurve *AnimDataDrivers_new_func(struct ID *_selfid, struct AnimData *_self, Main *bmain, ReportList *reports, const char * data_path, int index);
void AnimDataDrivers_remove_func(struct AnimData *_self, Main *bmain, ReportList *reports, struct FCurve *driver);
struct FCurve *AnimDataDrivers_from_existing_func(struct AnimData *_self, bContext *C, struct FCurve *src_driver);
struct FCurve *AnimDataDrivers_find_func(struct AnimData *_self, ReportList *reports, const char * data_path, int index);
/**************** Animation Visualization ****************/

extern StructRNA RNA_AnimViz;

PointerRNA AnimViz_rna_type_get(PointerRNA *ptr);

PointerRNA AnimViz_motion_path_get(PointerRNA *ptr);

/**************** Motion Path Settings ****************/

extern StructRNA RNA_AnimVizMotionPaths;

PointerRNA AnimVizMotionPaths_rna_type_get(PointerRNA *ptr);

int AnimVizMotionPaths_frame_after_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_after_set(PointerRNA *ptr, int value);

bool AnimVizMotionPaths_show_keyframe_action_all_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_action_all_set(PointerRNA *ptr, bool value);

enum {
	AnimVizMotionPaths_bake_location_HEADS = 2,
	AnimVizMotionPaths_bake_location_TAILS = 0,
};

int AnimVizMotionPaths_bake_location_get(PointerRNA *ptr);
void AnimVizMotionPaths_bake_location_set(PointerRNA *ptr, int value);

bool AnimVizMotionPaths_use_camera_space_bake_get(PointerRNA *ptr);
void AnimVizMotionPaths_use_camera_space_bake_set(PointerRNA *ptr, bool value);

int AnimVizMotionPaths_frame_before_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_before_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_end_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_end_set(PointerRNA *ptr, int value);

int AnimVizMotionPaths_frame_step_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_step_set(PointerRNA *ptr, int value);

bool AnimVizMotionPaths_has_motion_paths_get(PointerRNA *ptr);
void AnimVizMotionPaths_has_motion_paths_set(PointerRNA *ptr, bool value);

bool AnimVizMotionPaths_show_keyframe_highlight_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_highlight_set(PointerRNA *ptr, bool value);

enum {
	AnimVizMotionPaths_range_KEYS_ALL = 2,
	AnimVizMotionPaths_range_KEYS_SELECTED = 1,
	AnimVizMotionPaths_range_SCENE = 0,
	AnimVizMotionPaths_range_MANUAL = 3,
};

int AnimVizMotionPaths_range_get(PointerRNA *ptr);
void AnimVizMotionPaths_range_set(PointerRNA *ptr, int value);

enum {
	AnimVizMotionPaths_type_CURRENT_FRAME = 1,
	AnimVizMotionPaths_type_RANGE = 0,
};

int AnimVizMotionPaths_type_get(PointerRNA *ptr);
void AnimVizMotionPaths_type_set(PointerRNA *ptr, int value);

bool AnimVizMotionPaths_show_frame_numbers_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_frame_numbers_set(PointerRNA *ptr, bool value);

bool AnimVizMotionPaths_show_keyframe_numbers_get(PointerRNA *ptr);
void AnimVizMotionPaths_show_keyframe_numbers_set(PointerRNA *ptr, bool value);

int AnimVizMotionPaths_frame_start_get(PointerRNA *ptr);
void AnimVizMotionPaths_frame_start_set(PointerRNA *ptr, int value);

/**************** Annotation ****************/

extern StructRNA RNA_Annotation;
extern StructRNA RNA_ID;

PointerRNA Annotation_animation_data_get(PointerRNA *ptr);

void Annotation_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Annotation_layers_next(CollectionPropertyIterator *iter);
void Annotation_layers_end(CollectionPropertyIterator *iter);
bool Annotation_layers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Annotation_layers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Annotation Frame ****************/

extern StructRNA RNA_AnnotationFrame;

PointerRNA AnnotationFrame_rna_type_get(PointerRNA *ptr);

int AnnotationFrame_frame_number_get(PointerRNA *ptr);
void AnnotationFrame_frame_number_set(PointerRNA *ptr, int value);

bool AnnotationFrame_select_get(PointerRNA *ptr);
void AnnotationFrame_select_set(PointerRNA *ptr, bool value);

void AnnotationFrame_strokes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnnotationFrame_strokes_next(CollectionPropertyIterator *iter);
void AnnotationFrame_strokes_end(CollectionPropertyIterator *iter);
bool AnnotationFrame_strokes_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Annotation Frames ****************/

extern StructRNA RNA_AnnotationFrames;

PointerRNA AnnotationFrames_rna_type_get(PointerRNA *ptr);

struct bGPDframe *AnnotationFrames_new_func(struct bGPDlayer *_self, ReportList *reports, int frame_number, bool active);
void AnnotationFrames_remove_func(struct bGPDlayer *_self, ReportList *reports, struct PointerRNA *frame);
struct bGPDframe *AnnotationFrames_copy_func(struct bGPDlayer *_self, struct bGPDframe *source);
/**************** Annotation Layer ****************/

extern StructRNA RNA_AnnotationLayer;

PointerRNA AnnotationLayer_rna_type_get(PointerRNA *ptr);

PointerRNA AnnotationLayer_active_frame_get(PointerRNA *ptr);

void AnnotationLayer_annotation_onion_after_color_get(PointerRNA *ptr, float values[3]);
void AnnotationLayer_annotation_onion_after_color_set(PointerRNA *ptr, const float values[3]);

void AnnotationLayer_annotation_onion_before_color_get(PointerRNA *ptr, float values[3]);
void AnnotationLayer_annotation_onion_before_color_set(PointerRNA *ptr, const float values[3]);

void AnnotationLayer_color_get(PointerRNA *ptr, float values[3]);
void AnnotationLayer_color_set(PointerRNA *ptr, const float values[3]);

bool AnnotationLayer_annotation_onion_use_custom_color_get(PointerRNA *ptr);
void AnnotationLayer_annotation_onion_use_custom_color_set(PointerRNA *ptr, bool value);

bool AnnotationLayer_lock_frame_get(PointerRNA *ptr);
void AnnotationLayer_lock_frame_set(PointerRNA *ptr, bool value);

void AnnotationLayer_frames_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnnotationLayer_frames_next(CollectionPropertyIterator *iter);
void AnnotationLayer_frames_end(CollectionPropertyIterator *iter);
bool AnnotationLayer_frames_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int AnnotationLayer_annotation_onion_after_range_get(PointerRNA *ptr);
void AnnotationLayer_annotation_onion_after_range_set(PointerRNA *ptr, int value);

int AnnotationLayer_annotation_onion_before_range_get(PointerRNA *ptr);
void AnnotationLayer_annotation_onion_before_range_set(PointerRNA *ptr, int value);

bool AnnotationLayer_annotation_hide_get(PointerRNA *ptr);
void AnnotationLayer_annotation_hide_set(PointerRNA *ptr, bool value);

bool AnnotationLayer_show_in_front_get(PointerRNA *ptr);
void AnnotationLayer_show_in_front_set(PointerRNA *ptr, bool value);

#define AnnotationLayer_info_MAX 128

void AnnotationLayer_info_get(PointerRNA *ptr, char *value);
int AnnotationLayer_info_length(PointerRNA *ptr);
void AnnotationLayer_info_set(PointerRNA *ptr, const char *value);

bool AnnotationLayer_lock_get(PointerRNA *ptr);
void AnnotationLayer_lock_set(PointerRNA *ptr, bool value);

bool AnnotationLayer_use_annotation_onion_skinning_get(PointerRNA *ptr);
void AnnotationLayer_use_annotation_onion_skinning_set(PointerRNA *ptr, bool value);

float AnnotationLayer_annotation_opacity_get(PointerRNA *ptr);
void AnnotationLayer_annotation_opacity_set(PointerRNA *ptr, float value);

bool AnnotationLayer_is_ruler_get(PointerRNA *ptr);
void AnnotationLayer_is_ruler_set(PointerRNA *ptr, bool value);

bool AnnotationLayer_select_get(PointerRNA *ptr);
void AnnotationLayer_select_set(PointerRNA *ptr, bool value);

int AnnotationLayer_thickness_get(PointerRNA *ptr);
void AnnotationLayer_thickness_set(PointerRNA *ptr, int value);

/**************** Annotation Layers ****************/

extern StructRNA RNA_AnnotationLayers;

PointerRNA AnnotationLayers_rna_type_get(PointerRNA *ptr);

int AnnotationLayers_active_index_get(PointerRNA *ptr);
void AnnotationLayers_active_index_set(PointerRNA *ptr, int value);

enum {
	AnnotationLayers_active_note_DEFAULT = 0,
};

int AnnotationLayers_active_note_get(PointerRNA *ptr);
void AnnotationLayers_active_note_set(PointerRNA *ptr, int value);

struct bGPDlayer *AnnotationLayers_new_func(struct bGPdata *_self, const char * name, bool set_active);
void AnnotationLayers_remove_func(struct bGPdata *_self, ReportList *reports, struct PointerRNA *layer);
/**************** Annotation Stroke ****************/

extern StructRNA RNA_AnnotationStroke;

PointerRNA AnnotationStroke_rna_type_get(PointerRNA *ptr);

void AnnotationStroke_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AnnotationStroke_points_next(CollectionPropertyIterator *iter);
void AnnotationStroke_points_end(CollectionPropertyIterator *iter);
int AnnotationStroke_points_length(PointerRNA *ptr);
bool AnnotationStroke_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Annotation Stroke Point ****************/

extern StructRNA RNA_AnnotationStrokePoint;

PointerRNA AnnotationStrokePoint_rna_type_get(PointerRNA *ptr);

void AnnotationStrokePoint_co_get(PointerRNA *ptr, float values[3]);
void AnnotationStrokePoint_co_set(PointerRNA *ptr, const float values[3]);

/**************** Any Type ****************/

extern StructRNA RNA_AnyType;

PointerRNA AnyType_rna_type_get(PointerRNA *ptr);

/**************** Area ****************/

extern StructRNA RNA_Area;

PointerRNA Area_rna_type_get(PointerRNA *ptr);

enum {
	Area_type_EMPTY = 0,
	Area_type_VIEW_3D = 1,
	Area_type_IMAGE_EDITOR = 6,
	Area_type_NODE_EDITOR = 16,
	Area_type_SEQUENCE_EDITOR = 8,
	Area_type_CLIP_EDITOR = 20,
	Area_type_DOPESHEET_EDITOR = 12,
	Area_type_GRAPH_EDITOR = 2,
	Area_type_NLA_EDITOR = 13,
	Area_type_TEXT_EDITOR = 9,
	Area_type_CONSOLE = 18,
	Area_type_INFO = 7,
	Area_type_TOPBAR = 21,
	Area_type_STATUSBAR = 22,
	Area_type_OUTLINER = 3,
	Area_type_PROPERTIES = 4,
	Area_type_FILE_BROWSER = 5,
	Area_type_SPREADSHEET = 23,
	Area_type_PREFERENCES = 19,
};

int Area_type_get(PointerRNA *ptr);
void Area_type_set(PointerRNA *ptr, int value);

int Area_ui_type_get(PointerRNA *ptr);
void Area_ui_type_set(PointerRNA *ptr, int value);

int Area_height_get(PointerRNA *ptr);
void Area_height_set(PointerRNA *ptr, int value);

void Area_regions_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Area_regions_next(CollectionPropertyIterator *iter);
void Area_regions_end(CollectionPropertyIterator *iter);
bool Area_regions_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool Area_show_menus_get(PointerRNA *ptr);
void Area_show_menus_set(PointerRNA *ptr, bool value);

void Area_spaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Area_spaces_next(CollectionPropertyIterator *iter);
void Area_spaces_end(CollectionPropertyIterator *iter);
bool Area_spaces_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

int Area_width_get(PointerRNA *ptr);
void Area_width_set(PointerRNA *ptr, int value);

int Area_x_get(PointerRNA *ptr);
void Area_x_set(PointerRNA *ptr, int value);

int Area_y_get(PointerRNA *ptr);
void Area_y_set(PointerRNA *ptr, int value);

void Area_tag_redraw_func(struct ScrArea *_self);
void Area_header_text_set_func(struct ScrArea *_self, const char * text);
/**************** Area Light ****************/

extern StructRNA RNA_AreaLight;
extern StructRNA RNA_Light;
extern StructRNA RNA_ID;

bool AreaLight_use_absolute_resolution_get(PointerRNA *ptr);
void AreaLight_use_absolute_resolution_set(PointerRNA *ptr, bool value);

float AreaLight_energy_get(PointerRNA *ptr);
void AreaLight_energy_set(PointerRNA *ptr, float value);

float AreaLight_shadow_buffer_clip_start_get(PointerRNA *ptr);
void AreaLight_shadow_buffer_clip_start_set(PointerRNA *ptr, float value);

float AreaLight_shadow_filter_radius_get(PointerRNA *ptr);
void AreaLight_shadow_filter_radius_set(PointerRNA *ptr, float value);

bool AreaLight_use_shadow_jitter_get(PointerRNA *ptr);
void AreaLight_use_shadow_jitter_set(PointerRNA *ptr, bool value);

float AreaLight_shadow_jitter_overblur_get(PointerRNA *ptr);
void AreaLight_shadow_jitter_overblur_set(PointerRNA *ptr, float value);

float AreaLight_shadow_soft_size_get(PointerRNA *ptr);
void AreaLight_shadow_soft_size_set(PointerRNA *ptr, float value);

float AreaLight_shadow_maximum_resolution_get(PointerRNA *ptr);
void AreaLight_shadow_maximum_resolution_set(PointerRNA *ptr, float value);

enum {
	AreaLight_shape_SQUARE = 0,
	AreaLight_shape_RECTANGLE = 1,
	AreaLight_shape_DISK = 4,
	AreaLight_shape_ELLIPSE = 5,
};

int AreaLight_shape_get(PointerRNA *ptr);
void AreaLight_shape_set(PointerRNA *ptr, int value);

float AreaLight_size_get(PointerRNA *ptr);
void AreaLight_size_set(PointerRNA *ptr, float value);

float AreaLight_size_y_get(PointerRNA *ptr);
void AreaLight_size_y_set(PointerRNA *ptr, float value);

float AreaLight_spread_get(PointerRNA *ptr);
void AreaLight_spread_set(PointerRNA *ptr, float value);

/**************** Area Spaces ****************/

extern StructRNA RNA_AreaSpaces;

PointerRNA AreaSpaces_rna_type_get(PointerRNA *ptr);

PointerRNA AreaSpaces_active_get(PointerRNA *ptr);

/**************** Armature ****************/

extern StructRNA RNA_Armature;
extern StructRNA RNA_ID;

PointerRNA Armature_animation_data_get(PointerRNA *ptr);

float Armature_axes_position_get(PointerRNA *ptr);
void Armature_axes_position_set(PointerRNA *ptr, float value);

void Armature_collections_all_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_collections_all_next(CollectionPropertyIterator *iter);
void Armature_collections_all_end(CollectionPropertyIterator *iter);
int Armature_collections_all_length(PointerRNA *ptr);

void Armature_collections_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_collections_next(CollectionPropertyIterator *iter);
void Armature_collections_end(CollectionPropertyIterator *iter);
int Armature_collections_length(PointerRNA *ptr);

void Armature_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_bones_next(CollectionPropertyIterator *iter);
void Armature_bones_end(CollectionPropertyIterator *iter);
bool Armature_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool Armature_show_axes_get(PointerRNA *ptr);
void Armature_show_axes_set(PointerRNA *ptr, bool value);

bool Armature_show_bone_colors_get(PointerRNA *ptr);
void Armature_show_bone_colors_set(PointerRNA *ptr, bool value);

bool Armature_show_bone_custom_shapes_get(PointerRNA *ptr);
void Armature_show_bone_custom_shapes_set(PointerRNA *ptr, bool value);

bool Armature_show_names_get(PointerRNA *ptr);
void Armature_show_names_set(PointerRNA *ptr, bool value);

enum {
	Armature_display_type_OCTAHEDRAL = 0,
	Armature_display_type_STICK = 1,
	Armature_display_type_BBONE = 2,
	Armature_display_type_ENVELOPE = 3,
	Armature_display_type_WIRE = 4,
};

int Armature_display_type_get(PointerRNA *ptr);
void Armature_display_type_set(PointerRNA *ptr, int value);

void Armature_edit_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Armature_edit_bones_next(CollectionPropertyIterator *iter);
void Armature_edit_bones_end(CollectionPropertyIterator *iter);
bool Armature_edit_bones_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Armature_edit_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool Armature_is_editmode_get(PointerRNA *ptr);
void Armature_is_editmode_set(PointerRNA *ptr, bool value);

enum {
	Armature_pose_position_POSE = 0,
	Armature_pose_position_REST = 1,
};

int Armature_pose_position_get(PointerRNA *ptr);
void Armature_pose_position_set(PointerRNA *ptr, int value);

enum {
	Armature_relation_line_position_TAIL = 0,
	Armature_relation_line_position_HEAD = 1,
};

int Armature_relation_line_position_get(PointerRNA *ptr);
void Armature_relation_line_position_set(PointerRNA *ptr, int value);

bool Armature_use_mirror_x_get(PointerRNA *ptr);
void Armature_use_mirror_x_set(PointerRNA *ptr, bool value);

void Armature_transform_func(struct bArmature *_self, float matrix[16]);
/**************** Armature Bones ****************/

extern StructRNA RNA_ArmatureBones;

PointerRNA ArmatureBones_rna_type_get(PointerRNA *ptr);

PointerRNA ArmatureBones_active_get(PointerRNA *ptr);

/**************** Armature Constraint ****************/

extern StructRNA RNA_ArmatureConstraint;
extern StructRNA RNA_Constraint;

bool ArmatureConstraint_use_deform_preserve_volume_get(PointerRNA *ptr);
void ArmatureConstraint_use_deform_preserve_volume_set(PointerRNA *ptr, bool value);

void ArmatureConstraint_targets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ArmatureConstraint_targets_next(CollectionPropertyIterator *iter);
void ArmatureConstraint_targets_end(CollectionPropertyIterator *iter);
bool ArmatureConstraint_targets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool ArmatureConstraint_use_current_location_get(PointerRNA *ptr);
void ArmatureConstraint_use_current_location_set(PointerRNA *ptr, bool value);

bool ArmatureConstraint_use_bone_envelopes_get(PointerRNA *ptr);
void ArmatureConstraint_use_bone_envelopes_set(PointerRNA *ptr, bool value);

/**************** Armature Deform Constraint Targets ****************/

extern StructRNA RNA_ArmatureConstraintTargets;

PointerRNA ArmatureConstraintTargets_rna_type_get(PointerRNA *ptr);

struct bConstraintTarget *ArmatureConstraintTargets_new_func(struct ID *_selfid, struct bConstraint *_self, Main *bmain);
void ArmatureConstraintTargets_remove_func(struct ID *_selfid, struct bConstraint *_self, Main *bmain, ReportList *reports, struct PointerRNA *target);
void ArmatureConstraintTargets_clear_func(struct ID *_selfid, struct bConstraint *_self, Main *bmain);
/**************** Armature EditBones ****************/

extern StructRNA RNA_ArmatureEditBones;

PointerRNA ArmatureEditBones_rna_type_get(PointerRNA *ptr);

PointerRNA ArmatureEditBones_active_get(PointerRNA *ptr);

struct EditBone *ArmatureEditBones_new_func(struct bArmature *_self, ReportList *reports, const char * name);
void ArmatureEditBones_remove_func(struct bArmature *_self, ReportList *reports, struct PointerRNA *bone);
/**************** Armature Modifier ****************/

extern StructRNA RNA_ArmatureModifier;
extern StructRNA RNA_Modifier;

bool ArmatureModifier_invert_vertex_group_get(PointerRNA *ptr);
void ArmatureModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

bool ArmatureModifier_use_multi_modifier_get(PointerRNA *ptr);
void ArmatureModifier_use_multi_modifier_set(PointerRNA *ptr, bool value);

PointerRNA ArmatureModifier_object_get(PointerRNA *ptr);

bool ArmatureModifier_use_deform_preserve_volume_get(PointerRNA *ptr);
void ArmatureModifier_use_deform_preserve_volume_set(PointerRNA *ptr, bool value);

bool ArmatureModifier_use_bone_envelopes_get(PointerRNA *ptr);
void ArmatureModifier_use_bone_envelopes_set(PointerRNA *ptr, bool value);

bool ArmatureModifier_use_vertex_groups_get(PointerRNA *ptr);
void ArmatureModifier_use_vertex_groups_set(PointerRNA *ptr, bool value);

#define ArmatureModifier_vertex_group_MAX 64

void ArmatureModifier_vertex_group_get(PointerRNA *ptr, char *value);
int ArmatureModifier_vertex_group_length(PointerRNA *ptr);
void ArmatureModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Array Modifier ****************/

extern StructRNA RNA_ArrayModifier;
extern StructRNA RNA_Modifier;

bool ArrayModifier_use_constant_offset_get(PointerRNA *ptr);
void ArrayModifier_use_constant_offset_set(PointerRNA *ptr, bool value);

void ArrayModifier_constant_offset_displace_get(PointerRNA *ptr, float values[3]);
void ArrayModifier_constant_offset_displace_set(PointerRNA *ptr, const float values[3]);

int ArrayModifier_count_get(PointerRNA *ptr);
void ArrayModifier_count_set(PointerRNA *ptr, int value);

PointerRNA ArrayModifier_curve_get(PointerRNA *ptr);

PointerRNA ArrayModifier_end_cap_get(PointerRNA *ptr);

enum {
	ArrayModifier_fit_type_FIXED_COUNT = 0,
	ArrayModifier_fit_type_FIT_LENGTH = 1,
	ArrayModifier_fit_type_FIT_CURVE = 2,
};

int ArrayModifier_fit_type_get(PointerRNA *ptr);
void ArrayModifier_fit_type_set(PointerRNA *ptr, int value);

float ArrayModifier_fit_length_get(PointerRNA *ptr);
void ArrayModifier_fit_length_set(PointerRNA *ptr, float value);

float ArrayModifier_merge_threshold_get(PointerRNA *ptr);
void ArrayModifier_merge_threshold_set(PointerRNA *ptr, float value);

bool ArrayModifier_use_merge_vertices_cap_get(PointerRNA *ptr);
void ArrayModifier_use_merge_vertices_cap_set(PointerRNA *ptr, bool value);

bool ArrayModifier_use_merge_vertices_get(PointerRNA *ptr);
void ArrayModifier_use_merge_vertices_set(PointerRNA *ptr, bool value);

bool ArrayModifier_use_object_offset_get(PointerRNA *ptr);
void ArrayModifier_use_object_offset_set(PointerRNA *ptr, bool value);

PointerRNA ArrayModifier_offset_object_get(PointerRNA *ptr);

bool ArrayModifier_use_relative_offset_get(PointerRNA *ptr);
void ArrayModifier_use_relative_offset_set(PointerRNA *ptr, bool value);

void ArrayModifier_relative_offset_displace_get(PointerRNA *ptr, float values[3]);
void ArrayModifier_relative_offset_displace_set(PointerRNA *ptr, const float values[3]);

PointerRNA ArrayModifier_start_cap_get(PointerRNA *ptr);

float ArrayModifier_offset_u_get(PointerRNA *ptr);
void ArrayModifier_offset_u_set(PointerRNA *ptr, float value);

float ArrayModifier_offset_v_get(PointerRNA *ptr);
void ArrayModifier_offset_v_set(PointerRNA *ptr, float value);

/**************** User Asset Libraries ****************/

extern StructRNA RNA_AssetLibraryCollection;

PointerRNA AssetLibraryCollection_rna_type_get(PointerRNA *ptr);

struct bUserAssetLibrary *AssetLibraryCollection_new_func(bContext *C, const char * name, const char * directory);
void AssetLibraryCollection_remove_func(bContext *C, ReportList *reports, struct PointerRNA *library);
/**************** Asset Library Reference ****************/

extern StructRNA RNA_AssetLibraryReference;

PointerRNA AssetLibraryReference_rna_type_get(PointerRNA *ptr);

/**************** Asset Data ****************/

extern StructRNA RNA_AssetMetaData;

PointerRNA AssetMetaData_rna_type_get(PointerRNA *ptr);

int AssetMetaData_active_tag_get(PointerRNA *ptr);
void AssetMetaData_active_tag_set(PointerRNA *ptr, int value);

void AssetMetaData_author_get(PointerRNA *ptr, char *value);
int AssetMetaData_author_length(PointerRNA *ptr);
void AssetMetaData_author_set(PointerRNA *ptr, const char *value);

#define AssetMetaData_catalog_simple_name_MAX 64

void AssetMetaData_catalog_simple_name_get(PointerRNA *ptr, char *value);
int AssetMetaData_catalog_simple_name_length(PointerRNA *ptr);
void AssetMetaData_catalog_simple_name_set(PointerRNA *ptr, const char *value);

void AssetMetaData_catalog_id_get(PointerRNA *ptr, char *value);
int AssetMetaData_catalog_id_length(PointerRNA *ptr);
void AssetMetaData_catalog_id_set(PointerRNA *ptr, const char *value);

void AssetMetaData_copyright_get(PointerRNA *ptr, char *value);
int AssetMetaData_copyright_length(PointerRNA *ptr);
void AssetMetaData_copyright_set(PointerRNA *ptr, const char *value);

void AssetMetaData_description_get(PointerRNA *ptr, char *value);
int AssetMetaData_description_length(PointerRNA *ptr);
void AssetMetaData_description_set(PointerRNA *ptr, const char *value);

void AssetMetaData_license_get(PointerRNA *ptr, char *value);
int AssetMetaData_license_length(PointerRNA *ptr);
void AssetMetaData_license_set(PointerRNA *ptr, const char *value);

void AssetMetaData_tags_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void AssetMetaData_tags_next(CollectionPropertyIterator *iter);
void AssetMetaData_tags_end(CollectionPropertyIterator *iter);
bool AssetMetaData_tags_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool AssetMetaData_tags_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Asset Representation ****************/

extern StructRNA RNA_AssetRepresentation;

PointerRNA AssetRepresentation_rna_type_get(PointerRNA *ptr);

void AssetRepresentation_name_get(PointerRNA *ptr, char *value);
int AssetRepresentation_name_length(PointerRNA *ptr);
void AssetRepresentation_name_set(PointerRNA *ptr, const char *value);

PointerRNA AssetRepresentation_local_id_get(PointerRNA *ptr);

PointerRNA AssetRepresentation_metadata_get(PointerRNA *ptr);

enum {
	AssetRepresentation_id_type_ACTION = 17217,
	AssetRepresentation_id_type_ARMATURE = 21057,
	AssetRepresentation_id_type_BRUSH = 21058,
	AssetRepresentation_id_type_CACHEFILE = 17987,
	AssetRepresentation_id_type_CAMERA = 16707,
	AssetRepresentation_id_type_COLLECTION = 21063,
	AssetRepresentation_id_type_CURVE = 21827,
	AssetRepresentation_id_type_CURVES = 22083,
	AssetRepresentation_id_type_FONT = 18006,
	AssetRepresentation_id_type_GREASEPENCIL = 17479,
	AssetRepresentation_id_type_GREASEPENCIL_V3 = 20551,
	AssetRepresentation_id_type_IMAGE = 19785,
	AssetRepresentation_id_type_KEY = 17739,
	AssetRepresentation_id_type_LATTICE = 21580,
	AssetRepresentation_id_type_LIBRARY = 18764,
	AssetRepresentation_id_type_LIGHT = 16716,
	AssetRepresentation_id_type_LIGHT_PROBE = 20556,
	AssetRepresentation_id_type_LINESTYLE = 21324,
	AssetRepresentation_id_type_MASK = 21325,
	AssetRepresentation_id_type_MATERIAL = 16717,
	AssetRepresentation_id_type_MESH = 17741,
	AssetRepresentation_id_type_META = 16973,
	AssetRepresentation_id_type_MOVIECLIP = 17229,
	AssetRepresentation_id_type_NODETREE = 21582,
	AssetRepresentation_id_type_OBJECT = 16975,
	AssetRepresentation_id_type_PAINTCURVE = 17232,
	AssetRepresentation_id_type_PALETTE = 19536,
	AssetRepresentation_id_type_PARTICLE = 16720,
	AssetRepresentation_id_type_POINTCLOUD = 21584,
	AssetRepresentation_id_type_SCENE = 17235,
	AssetRepresentation_id_type_SCREEN = 21075,
	AssetRepresentation_id_type_SOUND = 20307,
	AssetRepresentation_id_type_SPEAKER = 19283,
	AssetRepresentation_id_type_TEXT = 22612,
	AssetRepresentation_id_type_TEXTURE = 17748,
	AssetRepresentation_id_type_VOLUME = 20310,
	AssetRepresentation_id_type_WINDOWMANAGER = 19799,
	AssetRepresentation_id_type_WORKSPACE = 21335,
	AssetRepresentation_id_type_WORLD = 20311,
};

int AssetRepresentation_id_type_get(PointerRNA *ptr);
void AssetRepresentation_id_type_set(PointerRNA *ptr, int value);

void AssetRepresentation_full_library_path_get(PointerRNA *ptr, char *value);
int AssetRepresentation_full_library_path_length(PointerRNA *ptr);
void AssetRepresentation_full_library_path_set(PointerRNA *ptr, const char *value);

void AssetRepresentation_full_path_get(PointerRNA *ptr, char *value);
int AssetRepresentation_full_path_length(PointerRNA *ptr);
void AssetRepresentation_full_path_set(PointerRNA *ptr, const char *value);

/**************** Asset Shelf ****************/

extern StructRNA RNA_AssetShelf;

PointerRNA AssetShelf_rna_type_get(PointerRNA *ptr);

bool AssetShelf_filter_action_get(PointerRNA *ptr);
void AssetShelf_filter_action_set(PointerRNA *ptr, bool value);

void AssetShelf_bl_activate_operator_get(PointerRNA *ptr, char *value);
int AssetShelf_bl_activate_operator_length(PointerRNA *ptr);
void AssetShelf_bl_activate_operator_set(PointerRNA *ptr, const char *value);

bool AssetShelf_filter_annotations_get(PointerRNA *ptr);
void AssetShelf_filter_annotations_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_armature_get(PointerRNA *ptr);
void AssetShelf_filter_armature_set(PointerRNA *ptr, bool value);

enum {
	AssetShelf_asset_library_reference_ALL = 2,
	AssetShelf_asset_library_reference_LOCAL = 1,
	AssetShelf_asset_library_reference_ESSENTIALS = 3,
	AssetShelf_asset_library_reference_CUSTOM = 100,
};

int AssetShelf_asset_library_reference_get(PointerRNA *ptr);
void AssetShelf_asset_library_reference_set(PointerRNA *ptr, int value);

bool AssetShelf_filter_brush_get(PointerRNA *ptr);
void AssetShelf_filter_brush_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_cachefile_get(PointerRNA *ptr);
void AssetShelf_filter_cachefile_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_camera_get(PointerRNA *ptr);
void AssetShelf_filter_camera_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_group_get(PointerRNA *ptr);
void AssetShelf_filter_group_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_curve_get(PointerRNA *ptr);
void AssetShelf_filter_curve_set(PointerRNA *ptr, bool value);

int AssetShelf_bl_default_preview_size_get(PointerRNA *ptr);
void AssetShelf_bl_default_preview_size_set(PointerRNA *ptr, int value);

#define AssetShelf_search_filter_MAX 64

void AssetShelf_search_filter_get(PointerRNA *ptr, char *value);
int AssetShelf_search_filter_length(PointerRNA *ptr);
void AssetShelf_search_filter_set(PointerRNA *ptr, const char *value);

void AssetShelf_bl_drag_operator_get(PointerRNA *ptr, char *value);
int AssetShelf_bl_drag_operator_length(PointerRNA *ptr);
void AssetShelf_bl_drag_operator_set(PointerRNA *ptr, const char *value);

bool AssetShelf_filter_font_get(PointerRNA *ptr);
void AssetShelf_filter_font_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_linestyle_get(PointerRNA *ptr);
void AssetShelf_filter_linestyle_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_grease_pencil_get(PointerRNA *ptr);
void AssetShelf_filter_grease_pencil_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_curves_get(PointerRNA *ptr);
void AssetShelf_filter_curves_set(PointerRNA *ptr, bool value);

void AssetShelf_bl_idname_get(PointerRNA *ptr, char *value);
int AssetShelf_bl_idname_length(PointerRNA *ptr);
void AssetShelf_bl_idname_set(PointerRNA *ptr, const char *value);

bool AssetShelf_filter_image_get(PointerRNA *ptr);
void AssetShelf_filter_image_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_lattice_get(PointerRNA *ptr);
void AssetShelf_filter_lattice_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_light_probe_get(PointerRNA *ptr);
void AssetShelf_filter_light_probe_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_light_get(PointerRNA *ptr);
void AssetShelf_filter_light_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_mask_get(PointerRNA *ptr);
void AssetShelf_filter_mask_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_material_get(PointerRNA *ptr);
void AssetShelf_filter_material_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_mesh_get(PointerRNA *ptr);
void AssetShelf_filter_mesh_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_metaball_get(PointerRNA *ptr);
void AssetShelf_filter_metaball_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_movie_clip_get(PointerRNA *ptr);
void AssetShelf_filter_movie_clip_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_node_tree_get(PointerRNA *ptr);
void AssetShelf_filter_node_tree_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_object_get(PointerRNA *ptr);
void AssetShelf_filter_object_set(PointerRNA *ptr, bool value);

enum {
	AssetShelf_bl_options_NO_ASSET_DRAG = 1,
	AssetShelf_bl_options_DEFAULT_VISIBLE = 2,
	AssetShelf_bl_options_STORE_ENABLED_CATALOGS_IN_PREFERENCES = 4,
	AssetShelf_bl_options_ACTIVATE_FOR_CONTEXT_MENU = 8,
};

int AssetShelf_bl_options_get(PointerRNA *ptr);
void AssetShelf_bl_options_set(PointerRNA *ptr, int value);

bool AssetShelf_filter_paint_curve_get(PointerRNA *ptr);
void AssetShelf_filter_paint_curve_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_palette_get(PointerRNA *ptr);
void AssetShelf_filter_palette_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_particle_settings_get(PointerRNA *ptr);
void AssetShelf_filter_particle_settings_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_pointcloud_get(PointerRNA *ptr);
void AssetShelf_filter_pointcloud_set(PointerRNA *ptr, bool value);

int AssetShelf_preview_size_get(PointerRNA *ptr);
void AssetShelf_preview_size_set(PointerRNA *ptr, int value);

bool AssetShelf_filter_scene_get(PointerRNA *ptr);
void AssetShelf_filter_scene_set(PointerRNA *ptr, bool value);

bool AssetShelf_show_names_get(PointerRNA *ptr);
void AssetShelf_show_names_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_sound_get(PointerRNA *ptr);
void AssetShelf_filter_sound_set(PointerRNA *ptr, bool value);

enum {
	AssetShelf_bl_space_type_EMPTY = 0,
	AssetShelf_bl_space_type_VIEW_3D = 1,
	AssetShelf_bl_space_type_IMAGE_EDITOR = 6,
	AssetShelf_bl_space_type_NODE_EDITOR = 16,
	AssetShelf_bl_space_type_SEQUENCE_EDITOR = 8,
	AssetShelf_bl_space_type_CLIP_EDITOR = 20,
	AssetShelf_bl_space_type_DOPESHEET_EDITOR = 12,
	AssetShelf_bl_space_type_GRAPH_EDITOR = 2,
	AssetShelf_bl_space_type_NLA_EDITOR = 13,
	AssetShelf_bl_space_type_TEXT_EDITOR = 9,
	AssetShelf_bl_space_type_CONSOLE = 18,
	AssetShelf_bl_space_type_INFO = 7,
	AssetShelf_bl_space_type_TOPBAR = 21,
	AssetShelf_bl_space_type_STATUSBAR = 22,
	AssetShelf_bl_space_type_OUTLINER = 3,
	AssetShelf_bl_space_type_PROPERTIES = 4,
	AssetShelf_bl_space_type_FILE_BROWSER = 5,
	AssetShelf_bl_space_type_SPREADSHEET = 23,
	AssetShelf_bl_space_type_PREFERENCES = 19,
};

int AssetShelf_bl_space_type_get(PointerRNA *ptr);
void AssetShelf_bl_space_type_set(PointerRNA *ptr, int value);

bool AssetShelf_filter_speaker_get(PointerRNA *ptr);
void AssetShelf_filter_speaker_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_text_get(PointerRNA *ptr);
void AssetShelf_filter_text_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_texture_get(PointerRNA *ptr);
void AssetShelf_filter_texture_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_volume_get(PointerRNA *ptr);
void AssetShelf_filter_volume_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_work_space_get(PointerRNA *ptr);
void AssetShelf_filter_work_space_set(PointerRNA *ptr, bool value);

bool AssetShelf_filter_world_get(PointerRNA *ptr);
void AssetShelf_filter_world_set(PointerRNA *ptr, bool value);

bool AssetShelf_poll_func(struct bContext *context);
bool AssetShelf_asset_poll_func(struct AssetRepresentation *asset);
struct AssetWeakReference *AssetShelf_get_active_asset_func(void);
void AssetShelf_draw_context_menu_func(struct bContext *context, struct AssetRepresentation *asset, struct uiLayout *layout);
/**************** Asset Tag ****************/

extern StructRNA RNA_AssetTag;

PointerRNA AssetTag_rna_type_get(PointerRNA *ptr);

#define AssetTag_name_MAX 64

void AssetTag_name_get(PointerRNA *ptr, char *value);
int AssetTag_name_length(PointerRNA *ptr);
void AssetTag_name_set(PointerRNA *ptr, const char *value);

/**************** Asset Tags ****************/

extern StructRNA RNA_AssetTags;

PointerRNA AssetTags_rna_type_get(PointerRNA *ptr);

struct AssetTag *AssetTags_new_func(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, const char * name, bool skip_if_exists);
void AssetTags_remove_func(struct ID *_selfid, struct AssetMetaData *_self, ReportList *reports, struct PointerRNA *tag);
/**************** Asset Weak Reference ****************/

extern StructRNA RNA_AssetWeakReference;

PointerRNA AssetWeakReference_rna_type_get(PointerRNA *ptr);

void AssetWeakReference_asset_library_identifier_get(PointerRNA *ptr, char *value);
int AssetWeakReference_asset_library_identifier_length(PointerRNA *ptr);
void AssetWeakReference_asset_library_identifier_set(PointerRNA *ptr, const char *value);

enum {
	AssetWeakReference_asset_library_type_ALL = 2,
	AssetWeakReference_asset_library_type_LOCAL = 1,
	AssetWeakReference_asset_library_type_ESSENTIALS = 3,
	AssetWeakReference_asset_library_type_CUSTOM = 100,
};

int AssetWeakReference_asset_library_type_get(PointerRNA *ptr);
void AssetWeakReference_asset_library_type_set(PointerRNA *ptr, int value);

void AssetWeakReference_relative_asset_identifier_get(PointerRNA *ptr, char *value);
int AssetWeakReference_relative_asset_identifier_length(PointerRNA *ptr);
void AssetWeakReference_relative_asset_identifier_set(PointerRNA *ptr, const char *value);

/**************** Attribute ****************/

extern StructRNA RNA_Attribute;

PointerRNA Attribute_rna_type_get(PointerRNA *ptr);

void Attribute_name_get(PointerRNA *ptr, char *value);
int Attribute_name_length(PointerRNA *ptr);
void Attribute_name_set(PointerRNA *ptr, const char *value);

enum {
	Attribute_data_type_FLOAT = 10,
	Attribute_data_type_INT = 11,
	Attribute_data_type_BOOLEAN = 50,
	Attribute_data_type_FLOAT_VECTOR = 48,
	Attribute_data_type_FLOAT_COLOR = 47,
	Attribute_data_type_QUATERNION = 52,
	Attribute_data_type_FLOAT4X4 = 20,
	Attribute_data_type_STRING = 12,
	Attribute_data_type_INT8 = 45,
	Attribute_data_type_INT16_2D = 22,
	Attribute_data_type_INT32_2D = 46,
	Attribute_data_type_FLOAT2 = 49,
	Attribute_data_type_BYTE_COLOR = 17,
};

int Attribute_data_type_get(PointerRNA *ptr);
void Attribute_data_type_set(PointerRNA *ptr, int value);

enum {
	Attribute_domain_POINT = 0,
	Attribute_domain_EDGE = 1,
	Attribute_domain_FACE = 2,
	Attribute_domain_CORNER = 3,
	Attribute_domain_CURVE = 4,
	Attribute_domain_INSTANCE = 5,
	Attribute_domain_LAYER = 6,
};

int Attribute_domain_get(PointerRNA *ptr);
void Attribute_domain_set(PointerRNA *ptr, int value);

bool Attribute_is_internal_get(PointerRNA *ptr);
void Attribute_is_internal_set(PointerRNA *ptr, bool value);

bool Attribute_is_required_get(PointerRNA *ptr);
void Attribute_is_required_set(PointerRNA *ptr, bool value);

enum {
	Attribute_storage_type_ARRAY = 0,
	Attribute_storage_type_SINGLE = 1,
};

int Attribute_storage_type_get(PointerRNA *ptr);
void Attribute_storage_type_set(PointerRNA *ptr, int value);

/**************** Attribute Group ****************/

extern StructRNA RNA_AttributeGroupCurves;

PointerRNA AttributeGroupCurves_rna_type_get(PointerRNA *ptr);

PointerRNA AttributeGroupCurves_active_get(PointerRNA *ptr);

int AttributeGroupCurves_active_index_get(PointerRNA *ptr);
void AttributeGroupCurves_active_index_set(PointerRNA *ptr, int value);

struct PointerRNA AttributeGroupCurves_new_func(struct ID *_self, ReportList *reports, const char * name, int type, int domain);
void AttributeGroupCurves_remove_func(struct ID *_self, ReportList *reports, struct PointerRNA *attribute);
int AttributeGroupCurves_domain_size_func(struct ID *_self, int domain);
/**************** Attribute Group ****************/

extern StructRNA RNA_AttributeGroupGreasePencil;

PointerRNA AttributeGroupGreasePencil_rna_type_get(PointerRNA *ptr);

PointerRNA AttributeGroupGreasePencil_active_get(PointerRNA *ptr);

int AttributeGroupGreasePencil_active_index_get(PointerRNA *ptr);
void AttributeGroupGreasePencil_active_index_set(PointerRNA *ptr, int value);

struct PointerRNA AttributeGroupGreasePencil_new_func(struct ID *_self, ReportList *reports, const char * name, int type, int domain);
void AttributeGroupGreasePencil_remove_func(struct ID *_self, ReportList *reports, struct PointerRNA *attribute);
int AttributeGroupGreasePencil_domain_size_func(struct ID *_self, int domain);
/**************** Attribute Group ****************/

extern StructRNA RNA_AttributeGroupGreasePencilDrawing;

PointerRNA AttributeGroupGreasePencilDrawing_rna_type_get(PointerRNA *ptr);

PointerRNA AttributeGroupGreasePencilDrawing_active_get(PointerRNA *ptr);

int AttributeGroupGreasePencilDrawing_active_index_get(PointerRNA *ptr);
void AttributeGroupGreasePencilDrawing_active_index_set(PointerRNA *ptr, int value);

struct PointerRNA AttributeGroupGreasePencilDrawing_new_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, const char * name, int type, int domain);
void AttributeGroupGreasePencilDrawing_remove_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, struct PointerRNA *attribute);
int AttributeGroupGreasePencilDrawing_domain_size_func(struct GreasePencilDrawing *_self, int domain);
/**************** Attribute Group ****************/

extern StructRNA RNA_AttributeGroupMesh;

PointerRNA AttributeGroupMesh_rna_type_get(PointerRNA *ptr);

PointerRNA AttributeGroupMesh_active_get(PointerRNA *ptr);

int AttributeGroupMesh_active_index_get(PointerRNA *ptr);
void AttributeGroupMesh_active_index_set(PointerRNA *ptr, int value);

PointerRNA AttributeGroupMesh_active_color_get(PointerRNA *ptr);

#define AttributeGroupMesh_active_color_name_MAX 64

void AttributeGroupMesh_active_color_name_get(PointerRNA *ptr, char *value);
int AttributeGroupMesh_active_color_name_length(PointerRNA *ptr);
void AttributeGroupMesh_active_color_name_set(PointerRNA *ptr, const char *value);

int AttributeGroupMesh_active_color_index_get(PointerRNA *ptr);
void AttributeGroupMesh_active_color_index_set(PointerRNA *ptr, int value);

int AttributeGroupMesh_render_color_index_get(PointerRNA *ptr);
void AttributeGroupMesh_render_color_index_set(PointerRNA *ptr, int value);

#define AttributeGroupMesh_default_color_name_MAX 64

void AttributeGroupMesh_default_color_name_get(PointerRNA *ptr, char *value);
int AttributeGroupMesh_default_color_name_length(PointerRNA *ptr);
void AttributeGroupMesh_default_color_name_set(PointerRNA *ptr, const char *value);

struct PointerRNA AttributeGroupMesh_new_func(struct ID *_self, ReportList *reports, const char * name, int type, int domain);
void AttributeGroupMesh_remove_func(struct ID *_self, ReportList *reports, struct PointerRNA *attribute);
int AttributeGroupMesh_domain_size_func(struct ID *_self, int domain);
/**************** Attribute Group ****************/

extern StructRNA RNA_AttributeGroupPointCloud;

PointerRNA AttributeGroupPointCloud_rna_type_get(PointerRNA *ptr);

PointerRNA AttributeGroupPointCloud_active_get(PointerRNA *ptr);

int AttributeGroupPointCloud_active_index_get(PointerRNA *ptr);
void AttributeGroupPointCloud_active_index_set(PointerRNA *ptr, int value);

struct PointerRNA AttributeGroupPointCloud_new_func(struct ID *_self, ReportList *reports, const char * name, int type, int domain);
void AttributeGroupPointCloud_remove_func(struct ID *_self, ReportList *reports, struct PointerRNA *attribute);
int AttributeGroupPointCloud_domain_size_func(struct ID *_self, int domain);
/**************** Bake Data ****************/

extern StructRNA RNA_BakeSettings;

PointerRNA BakeSettings_rna_type_get(PointerRNA *ptr);

bool BakeSettings_use_automatic_name_get(PointerRNA *ptr);
void BakeSettings_use_automatic_name_set(PointerRNA *ptr, bool value);

enum {
	BakeSettings_type_NORMALS = 0,
	BakeSettings_type_DISPLACEMENT = 1,
	BakeSettings_type_VECTOR_DISPLACEMENT = 3,
};

int BakeSettings_type_get(PointerRNA *ptr);
void BakeSettings_type_set(PointerRNA *ptr, int value);

bool BakeSettings_use_multires_get(PointerRNA *ptr);
void BakeSettings_use_multires_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_cage_get(PointerRNA *ptr);
void BakeSettings_use_cage_set(PointerRNA *ptr, bool value);

float BakeSettings_cage_extrusion_get(PointerRNA *ptr);
void BakeSettings_cage_extrusion_set(PointerRNA *ptr, float value);

PointerRNA BakeSettings_cage_object_get(PointerRNA *ptr);

bool BakeSettings_use_clear_get(PointerRNA *ptr);
void BakeSettings_use_clear_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_pass_color_get(PointerRNA *ptr);
void BakeSettings_use_pass_color_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_pass_diffuse_get(PointerRNA *ptr);
void BakeSettings_use_pass_diffuse_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_pass_direct_get(PointerRNA *ptr);
void BakeSettings_use_pass_direct_set(PointerRNA *ptr, bool value);

enum {
	BakeSettings_displacement_space_OBJECT = 2,
	BakeSettings_displacement_space_TANGENT = 3,
};

int BakeSettings_displacement_space_get(PointerRNA *ptr);
void BakeSettings_displacement_space_set(PointerRNA *ptr, int value);

bool BakeSettings_use_pass_emit_get(PointerRNA *ptr);
void BakeSettings_use_pass_emit_set(PointerRNA *ptr, bool value);

#define BakeSettings_filepath_MAX 1024

void BakeSettings_filepath_get(PointerRNA *ptr, char *value);
int BakeSettings_filepath_length(PointerRNA *ptr);
void BakeSettings_filepath_set(PointerRNA *ptr, const char *value);

bool BakeSettings_use_pass_glossy_get(PointerRNA *ptr);
void BakeSettings_use_pass_glossy_set(PointerRNA *ptr, bool value);

int BakeSettings_height_get(PointerRNA *ptr);
void BakeSettings_height_set(PointerRNA *ptr, int value);

PointerRNA BakeSettings_image_settings_get(PointerRNA *ptr);

bool BakeSettings_use_pass_indirect_get(PointerRNA *ptr);
void BakeSettings_use_pass_indirect_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_lores_mesh_get(PointerRNA *ptr);
void BakeSettings_use_lores_mesh_set(PointerRNA *ptr, bool value);

int BakeSettings_margin_get(PointerRNA *ptr);
void BakeSettings_margin_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_margin_type_ADJACENT_FACES = 0,
	BakeSettings_margin_type_EXTEND = 1,
};

int BakeSettings_margin_type_get(PointerRNA *ptr);
void BakeSettings_margin_type_set(PointerRNA *ptr, int value);

float BakeSettings_max_ray_distance_get(PointerRNA *ptr);
void BakeSettings_max_ray_distance_set(PointerRNA *ptr, float value);

enum {
	BakeSettings_normal_space_OBJECT = 2,
	BakeSettings_normal_space_TANGENT = 3,
};

int BakeSettings_normal_space_get(PointerRNA *ptr);
void BakeSettings_normal_space_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_r_POS_X = 0,
	BakeSettings_normal_r_POS_Y = 1,
	BakeSettings_normal_r_POS_Z = 2,
	BakeSettings_normal_r_NEG_X = 3,
	BakeSettings_normal_r_NEG_Y = 4,
	BakeSettings_normal_r_NEG_Z = 5,
};

int BakeSettings_normal_r_get(PointerRNA *ptr);
void BakeSettings_normal_r_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_g_POS_X = 0,
	BakeSettings_normal_g_POS_Y = 1,
	BakeSettings_normal_g_POS_Z = 2,
	BakeSettings_normal_g_NEG_X = 3,
	BakeSettings_normal_g_NEG_Y = 4,
	BakeSettings_normal_g_NEG_Z = 5,
};

int BakeSettings_normal_g_get(PointerRNA *ptr);
void BakeSettings_normal_g_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_normal_b_POS_X = 0,
	BakeSettings_normal_b_POS_Y = 1,
	BakeSettings_normal_b_POS_Z = 2,
	BakeSettings_normal_b_NEG_X = 3,
	BakeSettings_normal_b_NEG_Y = 4,
	BakeSettings_normal_b_NEG_Z = 5,
};

int BakeSettings_normal_b_get(PointerRNA *ptr);
void BakeSettings_normal_b_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_pass_filter_NONE = 0,
	BakeSettings_pass_filter_EMIT = 2,
	BakeSettings_pass_filter_DIRECT = 64,
	BakeSettings_pass_filter_INDIRECT = 128,
	BakeSettings_pass_filter_COLOR = 256,
	BakeSettings_pass_filter_DIFFUSE = 4,
	BakeSettings_pass_filter_GLOSSY = 8,
	BakeSettings_pass_filter_TRANSMISSION = 16,
};

int BakeSettings_pass_filter_get(PointerRNA *ptr);
void BakeSettings_pass_filter_set(PointerRNA *ptr, int value);

enum {
	BakeSettings_save_mode_INTERNAL = 0,
	BakeSettings_save_mode_EXTERNAL = 1,
};

int BakeSettings_save_mode_get(PointerRNA *ptr);
void BakeSettings_save_mode_set(PointerRNA *ptr, int value);

bool BakeSettings_use_selected_to_active_get(PointerRNA *ptr);
void BakeSettings_use_selected_to_active_set(PointerRNA *ptr, bool value);

bool BakeSettings_use_split_materials_get(PointerRNA *ptr);
void BakeSettings_use_split_materials_set(PointerRNA *ptr, bool value);

enum {
	BakeSettings_target_IMAGE_TEXTURES = 0,
	BakeSettings_target_VERTEX_COLORS = 1,
};

int BakeSettings_target_get(PointerRNA *ptr);
void BakeSettings_target_set(PointerRNA *ptr, int value);

bool BakeSettings_use_pass_transmission_get(PointerRNA *ptr);
void BakeSettings_use_pass_transmission_set(PointerRNA *ptr, bool value);

enum {
	BakeSettings_view_from_ABOVE_SURFACE = 0,
	BakeSettings_view_from_ACTIVE_CAMERA = 1,
};

int BakeSettings_view_from_get(PointerRNA *ptr);
void BakeSettings_view_from_set(PointerRNA *ptr, int value);

int BakeSettings_width_get(PointerRNA *ptr);
void BakeSettings_width_set(PointerRNA *ptr, int value);

/**************** Bevel Modifier ****************/

extern StructRNA RNA_BevelModifier;
extern StructRNA RNA_Modifier;

enum {
	BevelModifier_affect_VERTICES = 0,
	BevelModifier_affect_EDGES = 1,
};

int BevelModifier_affect_get(PointerRNA *ptr);
void BevelModifier_affect_set(PointerRNA *ptr, int value);

float BevelModifier_angle_limit_get(PointerRNA *ptr);
void BevelModifier_angle_limit_set(PointerRNA *ptr, float value);

bool BevelModifier_use_clamp_overlap_get(PointerRNA *ptr);
void BevelModifier_use_clamp_overlap_set(PointerRNA *ptr, bool value);

PointerRNA BevelModifier_custom_profile_get(PointerRNA *ptr);

#define BevelModifier_edge_weight_MAX 64

void BevelModifier_edge_weight_get(PointerRNA *ptr, char *value);
int BevelModifier_edge_weight_length(PointerRNA *ptr);
void BevelModifier_edge_weight_set(PointerRNA *ptr, const char *value);

enum {
	BevelModifier_face_strength_mode_FSTR_NONE = 0,
	BevelModifier_face_strength_mode_FSTR_NEW = 1,
	BevelModifier_face_strength_mode_FSTR_AFFECTED = 2,
	BevelModifier_face_strength_mode_FSTR_ALL = 3,
};

int BevelModifier_face_strength_mode_get(PointerRNA *ptr);
void BevelModifier_face_strength_mode_set(PointerRNA *ptr, int value);

bool BevelModifier_harden_normals_get(PointerRNA *ptr);
void BevelModifier_harden_normals_set(PointerRNA *ptr, bool value);

enum {
	BevelModifier_miter_inner_MITER_SHARP = 0,
	BevelModifier_miter_inner_MITER_ARC = 2,
};

int BevelModifier_miter_inner_get(PointerRNA *ptr);
void BevelModifier_miter_inner_set(PointerRNA *ptr, int value);

bool BevelModifier_invert_vertex_group_get(PointerRNA *ptr);
void BevelModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

enum {
	BevelModifier_limit_method_NONE = 0,
	BevelModifier_limit_method_ANGLE = 8,
	BevelModifier_limit_method_WEIGHT = 16,
	BevelModifier_limit_method_VGROUP = 32,
};

int BevelModifier_limit_method_get(PointerRNA *ptr);
void BevelModifier_limit_method_set(PointerRNA *ptr, int value);

bool BevelModifier_loop_slide_get(PointerRNA *ptr);
void BevelModifier_loop_slide_set(PointerRNA *ptr, bool value);

bool BevelModifier_mark_seam_get(PointerRNA *ptr);
void BevelModifier_mark_seam_set(PointerRNA *ptr, bool value);

bool BevelModifier_mark_sharp_get(PointerRNA *ptr);
void BevelModifier_mark_sharp_set(PointerRNA *ptr, bool value);

int BevelModifier_material_get(PointerRNA *ptr);
void BevelModifier_material_set(PointerRNA *ptr, int value);

enum {
	BevelModifier_miter_outer_MITER_SHARP = 0,
	BevelModifier_miter_outer_MITER_PATCH = 1,
	BevelModifier_miter_outer_MITER_ARC = 2,
};

int BevelModifier_miter_outer_get(PointerRNA *ptr);
void BevelModifier_miter_outer_set(PointerRNA *ptr, int value);

float BevelModifier_profile_get(PointerRNA *ptr);
void BevelModifier_profile_set(PointerRNA *ptr, float value);

enum {
	BevelModifier_profile_type_SUPERELLIPSE = 0,
	BevelModifier_profile_type_CUSTOM = 1,
};

int BevelModifier_profile_type_get(PointerRNA *ptr);
void BevelModifier_profile_type_set(PointerRNA *ptr, int value);

int BevelModifier_segments_get(PointerRNA *ptr);
void BevelModifier_segments_set(PointerRNA *ptr, int value);

float BevelModifier_spread_get(PointerRNA *ptr);
void BevelModifier_spread_set(PointerRNA *ptr, float value);

#define BevelModifier_vertex_group_MAX 64

void BevelModifier_vertex_group_get(PointerRNA *ptr, char *value);
int BevelModifier_vertex_group_length(PointerRNA *ptr);
void BevelModifier_vertex_group_set(PointerRNA *ptr, const char *value);

enum {
	BevelModifier_vmesh_method_ADJ = 0,
	BevelModifier_vmesh_method_CUTOFF = 1,
};

int BevelModifier_vmesh_method_get(PointerRNA *ptr);
void BevelModifier_vmesh_method_set(PointerRNA *ptr, int value);

#define BevelModifier_vertex_weight_MAX 64

void BevelModifier_vertex_weight_get(PointerRNA *ptr, char *value);
int BevelModifier_vertex_weight_length(PointerRNA *ptr);
void BevelModifier_vertex_weight_set(PointerRNA *ptr, const char *value);

float BevelModifier_width_get(PointerRNA *ptr);
void BevelModifier_width_set(PointerRNA *ptr, float value);

float BevelModifier_width_pct_get(PointerRNA *ptr);
void BevelModifier_width_pct_set(PointerRNA *ptr, float value);

enum {
	BevelModifier_offset_type_OFFSET = 0,
	BevelModifier_offset_type_WIDTH = 1,
	BevelModifier_offset_type_DEPTH = 2,
	BevelModifier_offset_type_PERCENT = 3,
	BevelModifier_offset_type_ABSOLUTE = 4,
};

int BevelModifier_offset_type_get(PointerRNA *ptr);
void BevelModifier_offset_type_set(PointerRNA *ptr, int value);

/**************** Bézier Curve Point ****************/

extern StructRNA RNA_BezierSplinePoint;

PointerRNA BezierSplinePoint_rna_type_get(PointerRNA *ptr);

float BezierSplinePoint_radius_get(PointerRNA *ptr);
void BezierSplinePoint_radius_set(PointerRNA *ptr, float value);

void BezierSplinePoint_co_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_co_set(PointerRNA *ptr, const float values[3]);

bool BezierSplinePoint_select_control_point_get(PointerRNA *ptr);
void BezierSplinePoint_select_control_point_set(PointerRNA *ptr, bool value);

void BezierSplinePoint_handle_left_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_handle_left_set(PointerRNA *ptr, const float values[3]);

enum {
	BezierSplinePoint_handle_left_type_FREE = 0,
	BezierSplinePoint_handle_left_type_VECTOR = 2,
	BezierSplinePoint_handle_left_type_ALIGNED = 3,
	BezierSplinePoint_handle_left_type_AUTO = 1,
};

int BezierSplinePoint_handle_left_type_get(PointerRNA *ptr);
void BezierSplinePoint_handle_left_type_set(PointerRNA *ptr, int value);

bool BezierSplinePoint_select_left_handle_get(PointerRNA *ptr);
void BezierSplinePoint_select_left_handle_set(PointerRNA *ptr, bool value);

void BezierSplinePoint_handle_right_get(PointerRNA *ptr, float values[3]);
void BezierSplinePoint_handle_right_set(PointerRNA *ptr, const float values[3]);

enum {
	BezierSplinePoint_handle_right_type_FREE = 0,
	BezierSplinePoint_handle_right_type_VECTOR = 2,
	BezierSplinePoint_handle_right_type_ALIGNED = 3,
	BezierSplinePoint_handle_right_type_AUTO = 1,
};

int BezierSplinePoint_handle_right_type_get(PointerRNA *ptr);
void BezierSplinePoint_handle_right_type_set(PointerRNA *ptr, int value);

bool BezierSplinePoint_select_right_handle_get(PointerRNA *ptr);
void BezierSplinePoint_select_right_handle_set(PointerRNA *ptr, bool value);

bool BezierSplinePoint_hide_get(PointerRNA *ptr);
void BezierSplinePoint_hide_set(PointerRNA *ptr, bool value);

float BezierSplinePoint_tilt_get(PointerRNA *ptr);
void BezierSplinePoint_tilt_set(PointerRNA *ptr, float value);

float BezierSplinePoint_weight_softbody_get(PointerRNA *ptr);
void BezierSplinePoint_weight_softbody_set(PointerRNA *ptr, float value);

/**************** Blend-File Data ****************/

extern StructRNA RNA_BlendData;

PointerRNA BlendData_rna_type_get(PointerRNA *ptr);

void BlendData_actions_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_actions_next(CollectionPropertyIterator *iter);
void BlendData_actions_end(CollectionPropertyIterator *iter);

void BlendData_annotations_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_annotations_next(CollectionPropertyIterator *iter);
void BlendData_annotations_end(CollectionPropertyIterator *iter);

void BlendData_armatures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_armatures_next(CollectionPropertyIterator *iter);
void BlendData_armatures_end(CollectionPropertyIterator *iter);

void BlendData_brushes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_brushes_next(CollectionPropertyIterator *iter);
void BlendData_brushes_end(CollectionPropertyIterator *iter);

void BlendData_cache_files_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_cache_files_next(CollectionPropertyIterator *iter);
void BlendData_cache_files_end(CollectionPropertyIterator *iter);

void BlendData_cameras_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_cameras_next(CollectionPropertyIterator *iter);
void BlendData_cameras_end(CollectionPropertyIterator *iter);

void BlendData_collections_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_collections_next(CollectionPropertyIterator *iter);
void BlendData_collections_end(CollectionPropertyIterator *iter);

PointerRNA BlendData_colorspace_get(PointerRNA *ptr);

void BlendData_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_curves_next(CollectionPropertyIterator *iter);
void BlendData_curves_end(CollectionPropertyIterator *iter);

bool BlendData_is_dirty_get(PointerRNA *ptr);
void BlendData_is_dirty_set(PointerRNA *ptr, bool value);

bool BlendData_is_saved_get(PointerRNA *ptr);
void BlendData_is_saved_set(PointerRNA *ptr, bool value);

#define BlendData_filepath_MAX 1024

void BlendData_filepath_get(PointerRNA *ptr, char *value);
int BlendData_filepath_length(PointerRNA *ptr);
void BlendData_filepath_set(PointerRNA *ptr, const char *value);

void BlendData_grease_pencils_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_grease_pencils_next(CollectionPropertyIterator *iter);
void BlendData_grease_pencils_end(CollectionPropertyIterator *iter);

void BlendData_hair_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_hair_curves_next(CollectionPropertyIterator *iter);
void BlendData_hair_curves_end(CollectionPropertyIterator *iter);

void BlendData_images_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_images_next(CollectionPropertyIterator *iter);
void BlendData_images_end(CollectionPropertyIterator *iter);

void BlendData_lattices_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_lattices_next(CollectionPropertyIterator *iter);
void BlendData_lattices_end(CollectionPropertyIterator *iter);

void BlendData_libraries_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_libraries_next(CollectionPropertyIterator *iter);
void BlendData_libraries_end(CollectionPropertyIterator *iter);

void BlendData_lightprobes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_lightprobes_next(CollectionPropertyIterator *iter);
void BlendData_lightprobes_end(CollectionPropertyIterator *iter);

void BlendData_lights_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_lights_next(CollectionPropertyIterator *iter);
void BlendData_lights_end(CollectionPropertyIterator *iter);

void BlendData_linestyles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_linestyles_next(CollectionPropertyIterator *iter);
void BlendData_linestyles_end(CollectionPropertyIterator *iter);

void BlendData_masks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_masks_next(CollectionPropertyIterator *iter);
void BlendData_masks_end(CollectionPropertyIterator *iter);

void BlendData_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_materials_next(CollectionPropertyIterator *iter);
void BlendData_materials_end(CollectionPropertyIterator *iter);

void BlendData_meshes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_meshes_next(CollectionPropertyIterator *iter);
void BlendData_meshes_end(CollectionPropertyIterator *iter);

void BlendData_metaballs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_metaballs_next(CollectionPropertyIterator *iter);
void BlendData_metaballs_end(CollectionPropertyIterator *iter);

void BlendData_movieclips_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_movieclips_next(CollectionPropertyIterator *iter);
void BlendData_movieclips_end(CollectionPropertyIterator *iter);

void BlendData_node_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_node_groups_next(CollectionPropertyIterator *iter);
void BlendData_node_groups_end(CollectionPropertyIterator *iter);

void BlendData_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_objects_next(CollectionPropertyIterator *iter);
void BlendData_objects_end(CollectionPropertyIterator *iter);

void BlendData_paint_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_paint_curves_next(CollectionPropertyIterator *iter);
void BlendData_paint_curves_end(CollectionPropertyIterator *iter);

void BlendData_palettes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_palettes_next(CollectionPropertyIterator *iter);
void BlendData_palettes_end(CollectionPropertyIterator *iter);

void BlendData_particles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_particles_next(CollectionPropertyIterator *iter);
void BlendData_particles_end(CollectionPropertyIterator *iter);

void BlendData_pointclouds_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_pointclouds_next(CollectionPropertyIterator *iter);
void BlendData_pointclouds_end(CollectionPropertyIterator *iter);

void BlendData_scenes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_scenes_next(CollectionPropertyIterator *iter);
void BlendData_scenes_end(CollectionPropertyIterator *iter);

void BlendData_screens_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_screens_next(CollectionPropertyIterator *iter);
void BlendData_screens_end(CollectionPropertyIterator *iter);

void BlendData_shape_keys_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_shape_keys_next(CollectionPropertyIterator *iter);
void BlendData_shape_keys_end(CollectionPropertyIterator *iter);

void BlendData_sounds_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_sounds_next(CollectionPropertyIterator *iter);
void BlendData_sounds_end(CollectionPropertyIterator *iter);

void BlendData_speakers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_speakers_next(CollectionPropertyIterator *iter);
void BlendData_speakers_end(CollectionPropertyIterator *iter);

void BlendData_texts_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_texts_next(CollectionPropertyIterator *iter);
void BlendData_texts_end(CollectionPropertyIterator *iter);

void BlendData_textures_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_textures_next(CollectionPropertyIterator *iter);
void BlendData_textures_end(CollectionPropertyIterator *iter);

bool BlendData_use_autopack_get(PointerRNA *ptr);
void BlendData_use_autopack_set(PointerRNA *ptr, bool value);

void BlendData_fonts_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_fonts_next(CollectionPropertyIterator *iter);
void BlendData_fonts_end(CollectionPropertyIterator *iter);

void BlendData_version_get(PointerRNA *ptr, int values[3]);
void BlendData_version_set(PointerRNA *ptr, const int values[3]);

void BlendData_volumes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_volumes_next(CollectionPropertyIterator *iter);
void BlendData_volumes_end(CollectionPropertyIterator *iter);

void BlendData_window_managers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_window_managers_next(CollectionPropertyIterator *iter);
void BlendData_window_managers_end(CollectionPropertyIterator *iter);

void BlendData_workspaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_workspaces_next(CollectionPropertyIterator *iter);
void BlendData_workspaces_end(CollectionPropertyIterator *iter);

void BlendData_worlds_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendData_worlds_next(CollectionPropertyIterator *iter);
void BlendData_worlds_end(CollectionPropertyIterator *iter);

struct ID *BlendData_pack_linked_ids_hierarchy_func(struct BlendData *_self, ReportList *reports, struct ID *root_id);
/**************** Main Actions ****************/

extern StructRNA RNA_BlendDataActions;

PointerRNA BlendDataActions_rna_type_get(PointerRNA *ptr);

struct bAction *BlendDataActions_new_func(struct Main *_self, const char * name);
void BlendDataActions_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *action, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataActions_tag_func(struct Main *_self, bool value);
/**************** Main Annotations ****************/

extern StructRNA RNA_BlendDataAnnotations;

PointerRNA BlendDataAnnotations_rna_type_get(PointerRNA *ptr);

void BlendDataAnnotations_tag_func(struct Main *_self, bool value);
struct bGPdata *BlendDataAnnotations_new_func(struct Main *_self, const char * name);
void BlendDataAnnotations_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *annotation, bool do_unlink, bool do_id_user, bool do_ui_user);
/**************** Main Armatures ****************/

extern StructRNA RNA_BlendDataArmatures;

PointerRNA BlendDataArmatures_rna_type_get(PointerRNA *ptr);

struct bArmature *BlendDataArmatures_new_func(struct Main *_self, const char * name);
void BlendDataArmatures_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *armature, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataArmatures_tag_func(struct Main *_self, bool value);
/**************** Main Brushes ****************/

extern StructRNA RNA_BlendDataBrushes;

PointerRNA BlendDataBrushes_rna_type_get(PointerRNA *ptr);

struct Brush *BlendDataBrushes_new_func(struct Main *_self, const char * name, int mode);
void BlendDataBrushes_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *brush, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataBrushes_tag_func(struct Main *_self, bool value);
void BlendDataBrushes_create_gpencil_data_func(struct Main *_self, struct PointerRNA *brush);
/**************** Main Cache Files ****************/

extern StructRNA RNA_BlendDataCacheFiles;

PointerRNA BlendDataCacheFiles_rna_type_get(PointerRNA *ptr);

void BlendDataCacheFiles_tag_func(struct Main *_self, bool value);
/**************** Main Cameras ****************/

extern StructRNA RNA_BlendDataCameras;

PointerRNA BlendDataCameras_rna_type_get(PointerRNA *ptr);

struct Camera *BlendDataCameras_new_func(struct Main *_self, const char * name);
void BlendDataCameras_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *camera, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataCameras_tag_func(struct Main *_self, bool value);
/**************** Main Collections ****************/

extern StructRNA RNA_BlendDataCollections;

PointerRNA BlendDataCollections_rna_type_get(PointerRNA *ptr);

struct Collection *BlendDataCollections_new_func(struct Main *_self, const char * name);
void BlendDataCollections_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *collection, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataCollections_tag_func(struct Main *_self, bool value);
/**************** Main Curves ****************/

extern StructRNA RNA_BlendDataCurves;

PointerRNA BlendDataCurves_rna_type_get(PointerRNA *ptr);

struct Curve *BlendDataCurves_new_func(struct Main *_self, const char * name, int type);
void BlendDataCurves_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *curve, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataCurves_tag_func(struct Main *_self, bool value);
/**************** Main Fonts ****************/

extern StructRNA RNA_BlendDataFonts;

PointerRNA BlendDataFonts_rna_type_get(PointerRNA *ptr);

struct VFont *BlendDataFonts_load_func(struct Main *_self, ReportList *reports, const char * filepath, bool check_existing);
void BlendDataFonts_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *vfont, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataFonts_tag_func(struct Main *_self, bool value);
/**************** Main Grease Pencils ****************/

extern StructRNA RNA_BlendDataGreasePencilsV3;

PointerRNA BlendDataGreasePencilsV3_rna_type_get(PointerRNA *ptr);

void BlendDataGreasePencilsV3_tag_func(struct Main *_self, bool value);
struct GreasePencil *BlendDataGreasePencilsV3_new_func(struct Main *_self, const char * name);
void BlendDataGreasePencilsV3_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *grease_pencil, bool do_unlink, bool do_id_user, bool do_ui_user);
/**************** Main Hair Curves ****************/

extern StructRNA RNA_BlendDataHairCurves;

PointerRNA BlendDataHairCurves_rna_type_get(PointerRNA *ptr);

struct Curves *BlendDataHairCurves_new_func(struct Main *_self, const char * name);
void BlendDataHairCurves_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *curves, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataHairCurves_tag_func(struct Main *_self, bool value);
/**************** Main Images ****************/

extern StructRNA RNA_BlendDataImages;

PointerRNA BlendDataImages_rna_type_get(PointerRNA *ptr);

struct Image *BlendDataImages_new_func(struct Main *_self, const char * name, int width, int height, bool alpha, bool float_buffer, bool stereo3d, bool is_data, bool tiled);
struct Image *BlendDataImages_load_func(struct Main *_self, ReportList *reports, const char * filepath, bool check_existing);
void BlendDataImages_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *image, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataImages_tag_func(struct Main *_self, bool value);
/**************** Main Lattices ****************/

extern StructRNA RNA_BlendDataLattices;

PointerRNA BlendDataLattices_rna_type_get(PointerRNA *ptr);

struct Lattice *BlendDataLattices_new_func(struct Main *_self, const char * name);
void BlendDataLattices_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *lattice, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataLattices_tag_func(struct Main *_self, bool value);
/**************** Main Libraries ****************/

extern StructRNA RNA_BlendDataLibraries;

PointerRNA BlendDataLibraries_rna_type_get(PointerRNA *ptr);

void BlendDataLibraries_tag_func(struct Main *_self, bool value);
void BlendDataLibraries_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *library, bool do_unlink, bool do_id_user, bool do_ui_user);
/**************** Main Lights ****************/

extern StructRNA RNA_BlendDataLights;

PointerRNA BlendDataLights_rna_type_get(PointerRNA *ptr);

struct Light *BlendDataLights_new_func(struct Main *_self, const char * name, int type);
void BlendDataLights_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *light, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataLights_tag_func(struct Main *_self, bool value);
/**************** Main Line Styles ****************/

extern StructRNA RNA_BlendDataLineStyles;

PointerRNA BlendDataLineStyles_rna_type_get(PointerRNA *ptr);

void BlendDataLineStyles_tag_func(struct Main *_self, bool value);
struct FreestyleLineStyle *BlendDataLineStyles_new_func(struct Main *_self, const char * name);
void BlendDataLineStyles_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *linestyle, bool do_unlink, bool do_id_user, bool do_ui_user);
/**************** Main Masks ****************/

extern StructRNA RNA_BlendDataMasks;

PointerRNA BlendDataMasks_rna_type_get(PointerRNA *ptr);

void BlendDataMasks_tag_func(struct Main *_self, bool value);
struct Mask *BlendDataMasks_new_func(struct Main *_self, const char * name);
void BlendDataMasks_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *mask, bool do_unlink, bool do_id_user, bool do_ui_user);
/**************** Main Materials ****************/

extern StructRNA RNA_BlendDataMaterials;

PointerRNA BlendDataMaterials_rna_type_get(PointerRNA *ptr);

struct Material *BlendDataMaterials_new_func(struct Main *_self, const char * name);
void BlendDataMaterials_create_gpencil_data_func(struct Main *_self, struct PointerRNA *material);
void BlendDataMaterials_remove_gpencil_data_func(struct Main *_self, struct PointerRNA *material);
void BlendDataMaterials_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *material, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataMaterials_tag_func(struct Main *_self, bool value);
/**************** Main Meshes ****************/

extern StructRNA RNA_BlendDataMeshes;

PointerRNA BlendDataMeshes_rna_type_get(PointerRNA *ptr);

struct Mesh *BlendDataMeshes_new_func(struct Main *_self, const char * name);
struct Mesh *BlendDataMeshes_new_from_object_func(struct Main *_self, ReportList *reports, struct Object *object, bool preserve_all_data_layers, struct Depsgraph *depsgraph);
void BlendDataMeshes_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *mesh, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataMeshes_tag_func(struct Main *_self, bool value);
/**************** Main Metaballs ****************/

extern StructRNA RNA_BlendDataMetaBalls;

PointerRNA BlendDataMetaBalls_rna_type_get(PointerRNA *ptr);

struct MetaBall *BlendDataMetaBalls_new_func(struct Main *_self, const char * name);
void BlendDataMetaBalls_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *metaball, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataMetaBalls_tag_func(struct Main *_self, bool value);
/**************** Main Movie Clips ****************/

extern StructRNA RNA_BlendDataMovieClips;

PointerRNA BlendDataMovieClips_rna_type_get(PointerRNA *ptr);

void BlendDataMovieClips_tag_func(struct Main *_self, bool value);
void BlendDataMovieClips_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *clip, bool do_unlink, bool do_id_user, bool do_ui_user);
struct MovieClip *BlendDataMovieClips_load_func(struct Main *_self, ReportList *reports, const char * filepath, bool check_existing);
/**************** Main Node Trees ****************/

extern StructRNA RNA_BlendDataNodeTrees;

PointerRNA BlendDataNodeTrees_rna_type_get(PointerRNA *ptr);

struct bNodeTree *BlendDataNodeTrees_new_func(struct Main *_self, const char * name, int type);
void BlendDataNodeTrees_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *tree, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataNodeTrees_tag_func(struct Main *_self, bool value);
/**************** Main Objects ****************/

extern StructRNA RNA_BlendDataObjects;

PointerRNA BlendDataObjects_rna_type_get(PointerRNA *ptr);

struct Object *BlendDataObjects_new_func(struct Main *_self, ReportList *reports, const char * name, struct ID *object_data);
void BlendDataObjects_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *object, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataObjects_tag_func(struct Main *_self, bool value);
/**************** Main Paint Curves ****************/

extern StructRNA RNA_BlendDataPaintCurves;

PointerRNA BlendDataPaintCurves_rna_type_get(PointerRNA *ptr);

void BlendDataPaintCurves_tag_func(struct Main *_self, bool value);
/**************** Main Palettes ****************/

extern StructRNA RNA_BlendDataPalettes;

PointerRNA BlendDataPalettes_rna_type_get(PointerRNA *ptr);

struct Palette *BlendDataPalettes_new_func(struct Main *_self, const char * name);
void BlendDataPalettes_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *palette, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataPalettes_tag_func(struct Main *_self, bool value);
/**************** Main Particle Settings ****************/

extern StructRNA RNA_BlendDataParticles;

PointerRNA BlendDataParticles_rna_type_get(PointerRNA *ptr);

struct ParticleSettings *BlendDataParticles_new_func(struct Main *_self, const char * name);
void BlendDataParticles_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *particle, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataParticles_tag_func(struct Main *_self, bool value);
/**************** Main Point Clouds ****************/

extern StructRNA RNA_BlendDataPointClouds;

PointerRNA BlendDataPointClouds_rna_type_get(PointerRNA *ptr);

struct PointCloud *BlendDataPointClouds_new_func(struct Main *_self, const char * name);
void BlendDataPointClouds_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *pointcloud, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataPointClouds_tag_func(struct Main *_self, bool value);
/**************** Main Light Probes ****************/

extern StructRNA RNA_BlendDataProbes;

PointerRNA BlendDataProbes_rna_type_get(PointerRNA *ptr);

struct LightProbe *BlendDataProbes_new_func(struct Main *_self, const char * name, int type);
void BlendDataProbes_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *lightprobe, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataProbes_tag_func(struct Main *_self, bool value);
/**************** Main Scenes ****************/

extern StructRNA RNA_BlendDataScenes;

PointerRNA BlendDataScenes_rna_type_get(PointerRNA *ptr);

struct Scene *BlendDataScenes_new_func(struct Main *_self, const char * name);
void BlendDataScenes_remove_func(struct Main *_self, bContext *C, ReportList *reports, struct PointerRNA *scene, bool do_unlink);
void BlendDataScenes_tag_func(struct Main *_self, bool value);
/**************** Main Screens ****************/

extern StructRNA RNA_BlendDataScreens;

PointerRNA BlendDataScreens_rna_type_get(PointerRNA *ptr);

void BlendDataScreens_tag_func(struct Main *_self, bool value);
/**************** Main Sounds ****************/

extern StructRNA RNA_BlendDataSounds;

PointerRNA BlendDataSounds_rna_type_get(PointerRNA *ptr);

struct bSound *BlendDataSounds_load_func(struct Main *_self, const char * filepath, bool check_existing);
void BlendDataSounds_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *sound, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataSounds_tag_func(struct Main *_self, bool value);
/**************** Main Speakers ****************/

extern StructRNA RNA_BlendDataSpeakers;

PointerRNA BlendDataSpeakers_rna_type_get(PointerRNA *ptr);

struct Speaker *BlendDataSpeakers_new_func(struct Main *_self, const char * name);
void BlendDataSpeakers_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *speaker, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataSpeakers_tag_func(struct Main *_self, bool value);
/**************** Main Texts ****************/

extern StructRNA RNA_BlendDataTexts;

PointerRNA BlendDataTexts_rna_type_get(PointerRNA *ptr);

struct Text *BlendDataTexts_new_func(struct Main *_self, const char * name);
void BlendDataTexts_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *text, bool do_unlink, bool do_id_user, bool do_ui_user);
struct Text *BlendDataTexts_load_func(struct Main *_self, ReportList *reports, const char * filepath, bool internal);
void BlendDataTexts_tag_func(struct Main *_self, bool value);
/**************** Main Textures ****************/

extern StructRNA RNA_BlendDataTextures;

PointerRNA BlendDataTextures_rna_type_get(PointerRNA *ptr);

struct Tex *BlendDataTextures_new_func(struct Main *_self, const char * name, int type);
void BlendDataTextures_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *texture, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataTextures_tag_func(struct Main *_self, bool value);
/**************** Main Volumes ****************/

extern StructRNA RNA_BlendDataVolumes;

PointerRNA BlendDataVolumes_rna_type_get(PointerRNA *ptr);

struct Volume *BlendDataVolumes_new_func(struct Main *_self, const char * name);
void BlendDataVolumes_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *volume, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataVolumes_tag_func(struct Main *_self, bool value);
/**************** Main Window Managers ****************/

extern StructRNA RNA_BlendDataWindowManagers;

PointerRNA BlendDataWindowManagers_rna_type_get(PointerRNA *ptr);

void BlendDataWindowManagers_tag_func(struct Main *_self, bool value);
/**************** Main Workspaces ****************/

extern StructRNA RNA_BlendDataWorkSpaces;

PointerRNA BlendDataWorkSpaces_rna_type_get(PointerRNA *ptr);

void BlendDataWorkSpaces_tag_func(struct Main *_self, bool value);
/**************** Main Worlds ****************/

extern StructRNA RNA_BlendDataWorlds;

PointerRNA BlendDataWorlds_rna_type_get(PointerRNA *ptr);

struct World *BlendDataWorlds_new_func(struct Main *_self, const char * name);
void BlendDataWorlds_remove_func(struct Main *_self, ReportList *reports, struct PointerRNA *world, bool do_unlink, bool do_id_user, bool do_ui_user);
void BlendDataWorlds_tag_func(struct Main *_self, bool value);
/**************** Blend-File Color Space ****************/

extern StructRNA RNA_BlendFileColorspace;

PointerRNA BlendFileColorspace_rna_type_get(PointerRNA *ptr);

bool BlendFileColorspace_is_missing_opencolorio_config_get(PointerRNA *ptr);
void BlendFileColorspace_is_missing_opencolorio_config_set(PointerRNA *ptr, bool value);

int BlendFileColorspace_working_space_get(PointerRNA *ptr);
void BlendFileColorspace_working_space_set(PointerRNA *ptr, int value);

void BlendFileColorspace_working_space_interop_id_get(PointerRNA *ptr, char *value);
int BlendFileColorspace_working_space_interop_id_length(PointerRNA *ptr);
void BlendFileColorspace_working_space_interop_id_set(PointerRNA *ptr, const char *value);

/**************** Blendfile Import Context ****************/

extern StructRNA RNA_BlendImportContext;

PointerRNA BlendImportContext_rna_type_get(PointerRNA *ptr);

enum {
	BlendImportContext_options_LINK = 4,
	BlendImportContext_options_MAKE_PATHS_RELATIVE = 2,
	BlendImportContext_options_USE_PLACEHOLDERS = 65536,
	BlendImportContext_options_FORCE_INDIRECT = 131072,
	BlendImportContext_options_APPEND_SET_FAKEUSER = 524288,
	BlendImportContext_options_APPEND_RECURSIVE = 1048576,
	BlendImportContext_options_APPEND_LOCAL_ID_REUSE = 2097152,
	BlendImportContext_options_APPEND_ASSET_DATA_CLEAR = 4194304,
	BlendImportContext_options_SELECT_OBJECTS = 16,
	BlendImportContext_options_USE_ACTIVE_COLLECTION = 32,
	BlendImportContext_options_OBDATA_INSTANCE = 16777216,
	BlendImportContext_options_COLLECTION_INSTANCE = 33554432,
};

int BlendImportContext_options_get(PointerRNA *ptr);
void BlendImportContext_options_set(PointerRNA *ptr, int value);

enum {
	BlendImportContext_process_stage_INIT = 0,
	BlendImportContext_process_stage_DONE = 4,
};

int BlendImportContext_process_stage_get(PointerRNA *ptr);
void BlendImportContext_process_stage_set(PointerRNA *ptr, int value);

void BlendImportContext_import_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendImportContext_import_items_next(CollectionPropertyIterator *iter);
void BlendImportContext_import_items_end(CollectionPropertyIterator *iter);
int BlendImportContext_import_items_length(PointerRNA *ptr);

/**************** Blendfile Import Context Item ****************/

extern StructRNA RNA_BlendImportContextItem;

PointerRNA BlendImportContextItem_rna_type_get(PointerRNA *ptr);

void BlendImportContextItem_name_get(PointerRNA *ptr, char *value);
int BlendImportContextItem_name_length(PointerRNA *ptr);
void BlendImportContextItem_name_set(PointerRNA *ptr, const char *value);

enum {
	BlendImportContextItem_append_action_UNSET = 0,
	BlendImportContextItem_append_action_KEEP_LINKED = 1,
	BlendImportContextItem_append_action_REUSE_LOCAL = 2,
	BlendImportContextItem_append_action_MAKE_LOCAL = 3,
	BlendImportContextItem_append_action_COPY_LOCAL = 4,
};

int BlendImportContextItem_append_action_get(PointerRNA *ptr);
void BlendImportContextItem_append_action_set(PointerRNA *ptr, int value);

enum {
	BlendImportContextItem_id_type_ACTION = 17217,
	BlendImportContextItem_id_type_ARMATURE = 21057,
	BlendImportContextItem_id_type_BRUSH = 21058,
	BlendImportContextItem_id_type_CACHEFILE = 17987,
	BlendImportContextItem_id_type_CAMERA = 16707,
	BlendImportContextItem_id_type_COLLECTION = 21063,
	BlendImportContextItem_id_type_CURVE = 21827,
	BlendImportContextItem_id_type_CURVES = 22083,
	BlendImportContextItem_id_type_FONT = 18006,
	BlendImportContextItem_id_type_GREASEPENCIL = 17479,
	BlendImportContextItem_id_type_GREASEPENCIL_V3 = 20551,
	BlendImportContextItem_id_type_IMAGE = 19785,
	BlendImportContextItem_id_type_KEY = 17739,
	BlendImportContextItem_id_type_LATTICE = 21580,
	BlendImportContextItem_id_type_LIBRARY = 18764,
	BlendImportContextItem_id_type_LIGHT = 16716,
	BlendImportContextItem_id_type_LIGHT_PROBE = 20556,
	BlendImportContextItem_id_type_LINESTYLE = 21324,
	BlendImportContextItem_id_type_MASK = 21325,
	BlendImportContextItem_id_type_MATERIAL = 16717,
	BlendImportContextItem_id_type_MESH = 17741,
	BlendImportContextItem_id_type_META = 16973,
	BlendImportContextItem_id_type_MOVIECLIP = 17229,
	BlendImportContextItem_id_type_NODETREE = 21582,
	BlendImportContextItem_id_type_OBJECT = 16975,
	BlendImportContextItem_id_type_PAINTCURVE = 17232,
	BlendImportContextItem_id_type_PALETTE = 19536,
	BlendImportContextItem_id_type_PARTICLE = 16720,
	BlendImportContextItem_id_type_POINTCLOUD = 21584,
	BlendImportContextItem_id_type_SCENE = 17235,
	BlendImportContextItem_id_type_SCREEN = 21075,
	BlendImportContextItem_id_type_SOUND = 20307,
	BlendImportContextItem_id_type_SPEAKER = 19283,
	BlendImportContextItem_id_type_TEXT = 22612,
	BlendImportContextItem_id_type_TEXTURE = 17748,
	BlendImportContextItem_id_type_VOLUME = 20310,
	BlendImportContextItem_id_type_WINDOWMANAGER = 19799,
	BlendImportContextItem_id_type_WORKSPACE = 21335,
	BlendImportContextItem_id_type_WORLD = 20311,
};

int BlendImportContextItem_id_type_get(PointerRNA *ptr);
void BlendImportContextItem_id_type_set(PointerRNA *ptr, int value);

enum {
	BlendImportContextItem_import_info_INDIRECT_USAGE = 1,
	BlendImportContextItem_import_info_LIBOVERRIDE_DEPENDENCY = 2,
	BlendImportContextItem_import_info_LIBOVERRIDE_DEPENDENCY_ONLY = 4,
};

int BlendImportContextItem_import_info_get(PointerRNA *ptr);
void BlendImportContextItem_import_info_set(PointerRNA *ptr, int value);

PointerRNA BlendImportContextItem_id_get(PointerRNA *ptr);

PointerRNA BlendImportContextItem_library_override_id_get(PointerRNA *ptr);

PointerRNA BlendImportContextItem_reusable_local_id_get(PointerRNA *ptr);

void BlendImportContextItem_source_libraries_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlendImportContextItem_source_libraries_next(CollectionPropertyIterator *iter);
void BlendImportContextItem_source_libraries_end(CollectionPropertyIterator *iter);
int BlendImportContextItem_source_libraries_length(PointerRNA *ptr);

PointerRNA BlendImportContextItem_source_library_get(PointerRNA *ptr);

/**************** Blendfile Import Context Items ****************/

extern StructRNA RNA_BlendImportContextItems;

PointerRNA BlendImportContextItems_rna_type_get(PointerRNA *ptr);

/**************** Blendfile Import Context Libraries ****************/

extern StructRNA RNA_BlendImportContextLibraries;

PointerRNA BlendImportContextLibraries_rna_type_get(PointerRNA *ptr);

/**************** Blendfile Import Context Library ****************/

extern StructRNA RNA_BlendImportContextLibrary;

PointerRNA BlendImportContextLibrary_rna_type_get(PointerRNA *ptr);

void BlendImportContextLibrary_filepath_get(PointerRNA *ptr, char *value);
int BlendImportContextLibrary_filepath_length(PointerRNA *ptr);
void BlendImportContextLibrary_filepath_set(PointerRNA *ptr, const char *value);

/**************** Blend Texture ****************/

extern StructRNA RNA_BlendTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

enum {
	BlendTexture_use_flip_axis_HORIZONTAL = 0,
	BlendTexture_use_flip_axis_VERTICAL = 2,
};

int BlendTexture_use_flip_axis_get(PointerRNA *ptr);
void BlendTexture_use_flip_axis_set(PointerRNA *ptr, int value);

enum {
	BlendTexture_progression_LINEAR = 0,
	BlendTexture_progression_QUADRATIC = 1,
	BlendTexture_progression_EASING = 2,
	BlendTexture_progression_DIAGONAL = 3,
	BlendTexture_progression_SPHERICAL = 4,
	BlendTexture_progression_QUADRATIC_SPHERE = 5,
	BlendTexture_progression_RADIAL = 6,
};

int BlendTexture_progression_get(PointerRNA *ptr);
void BlendTexture_progression_set(PointerRNA *ptr, int value);

/**************** Blender RNA ****************/

extern StructRNA RNA_BlenderRNA;

PointerRNA BlenderRNA_rna_type_get(PointerRNA *ptr);

void BlenderRNA_structs_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BlenderRNA_structs_next(CollectionPropertyIterator *iter);
void BlenderRNA_structs_end(CollectionPropertyIterator *iter);
int BlenderRNA_structs_length(PointerRNA *ptr);
bool BlenderRNA_structs_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool BlenderRNA_structs_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Boid Rule ****************/

extern StructRNA RNA_BoidRule;

PointerRNA BoidRule_rna_type_get(PointerRNA *ptr);

#define BoidRule_name_MAX 32

void BoidRule_name_get(PointerRNA *ptr, char *value);
int BoidRule_name_length(PointerRNA *ptr);
void BoidRule_name_set(PointerRNA *ptr, const char *value);

bool BoidRule_use_in_air_get(PointerRNA *ptr);
void BoidRule_use_in_air_set(PointerRNA *ptr, bool value);

bool BoidRule_use_on_land_get(PointerRNA *ptr);
void BoidRule_use_on_land_set(PointerRNA *ptr, bool value);

enum {
	BoidRule_type_GOAL = 1,
	BoidRule_type_AVOID = 2,
	BoidRule_type_AVOID_COLLISION = 3,
	BoidRule_type_SEPARATE = 4,
	BoidRule_type_FLOCK = 5,
	BoidRule_type_FOLLOW_LEADER = 6,
	BoidRule_type_AVERAGE_SPEED = 7,
	BoidRule_type_FIGHT = 8,
};

int BoidRule_type_get(PointerRNA *ptr);
void BoidRule_type_set(PointerRNA *ptr, int value);

/**************** Average Speed ****************/

extern StructRNA RNA_BoidRuleAverageSpeed;
extern StructRNA RNA_BoidRule;

float BoidRuleAverageSpeed_level_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_level_set(PointerRNA *ptr, float value);

float BoidRuleAverageSpeed_speed_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_speed_set(PointerRNA *ptr, float value);

float BoidRuleAverageSpeed_wander_get(PointerRNA *ptr);
void BoidRuleAverageSpeed_wander_set(PointerRNA *ptr, float value);

/**************** Avoid ****************/

extern StructRNA RNA_BoidRuleAvoid;
extern StructRNA RNA_BoidRule;

float BoidRuleAvoid_fear_factor_get(PointerRNA *ptr);
void BoidRuleAvoid_fear_factor_set(PointerRNA *ptr, float value);

PointerRNA BoidRuleAvoid_object_get(PointerRNA *ptr);

bool BoidRuleAvoid_use_predict_get(PointerRNA *ptr);
void BoidRuleAvoid_use_predict_set(PointerRNA *ptr, bool value);

/**************** Avoid Collision ****************/

extern StructRNA RNA_BoidRuleAvoidCollision;
extern StructRNA RNA_BoidRule;

bool BoidRuleAvoidCollision_use_avoid_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_use_avoid_set(PointerRNA *ptr, bool value);

bool BoidRuleAvoidCollision_use_avoid_collision_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_use_avoid_collision_set(PointerRNA *ptr, bool value);

float BoidRuleAvoidCollision_look_ahead_get(PointerRNA *ptr);
void BoidRuleAvoidCollision_look_ahead_set(PointerRNA *ptr, float value);

/**************** Fight ****************/

extern StructRNA RNA_BoidRuleFight;
extern StructRNA RNA_BoidRule;

float BoidRuleFight_distance_get(PointerRNA *ptr);
void BoidRuleFight_distance_set(PointerRNA *ptr, float value);

float BoidRuleFight_flee_distance_get(PointerRNA *ptr);
void BoidRuleFight_flee_distance_set(PointerRNA *ptr, float value);

/**************** Follow Leader ****************/

extern StructRNA RNA_BoidRuleFollowLeader;
extern StructRNA RNA_BoidRule;

float BoidRuleFollowLeader_distance_get(PointerRNA *ptr);
void BoidRuleFollowLeader_distance_set(PointerRNA *ptr, float value);

bool BoidRuleFollowLeader_use_line_get(PointerRNA *ptr);
void BoidRuleFollowLeader_use_line_set(PointerRNA *ptr, bool value);

PointerRNA BoidRuleFollowLeader_object_get(PointerRNA *ptr);

int BoidRuleFollowLeader_queue_count_get(PointerRNA *ptr);
void BoidRuleFollowLeader_queue_count_set(PointerRNA *ptr, int value);

/**************** Goal ****************/

extern StructRNA RNA_BoidRuleGoal;
extern StructRNA RNA_BoidRule;

PointerRNA BoidRuleGoal_object_get(PointerRNA *ptr);

bool BoidRuleGoal_use_predict_get(PointerRNA *ptr);
void BoidRuleGoal_use_predict_set(PointerRNA *ptr, bool value);

/**************** Boid Settings ****************/

extern StructRNA RNA_BoidSettings;

PointerRNA BoidSettings_rna_type_get(PointerRNA *ptr);

float BoidSettings_accuracy_get(PointerRNA *ptr);
void BoidSettings_accuracy_set(PointerRNA *ptr, float value);

PointerRNA BoidSettings_active_boid_state_get(PointerRNA *ptr);

int BoidSettings_active_boid_state_index_get(PointerRNA *ptr);
void BoidSettings_active_boid_state_index_set(PointerRNA *ptr, int value);

float BoidSettings_aggression_get(PointerRNA *ptr);
void BoidSettings_aggression_set(PointerRNA *ptr, float value);

float BoidSettings_air_personal_space_get(PointerRNA *ptr);
void BoidSettings_air_personal_space_set(PointerRNA *ptr, float value);

bool BoidSettings_use_climb_get(PointerRNA *ptr);
void BoidSettings_use_climb_set(PointerRNA *ptr, bool value);

bool BoidSettings_use_flight_get(PointerRNA *ptr);
void BoidSettings_use_flight_set(PointerRNA *ptr, bool value);

bool BoidSettings_use_land_get(PointerRNA *ptr);
void BoidSettings_use_land_set(PointerRNA *ptr, bool value);

float BoidSettings_bank_get(PointerRNA *ptr);
void BoidSettings_bank_set(PointerRNA *ptr, float value);

void BoidSettings_states_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoidSettings_states_next(CollectionPropertyIterator *iter);
void BoidSettings_states_end(CollectionPropertyIterator *iter);
bool BoidSettings_states_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool BoidSettings_states_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float BoidSettings_health_get(PointerRNA *ptr);
void BoidSettings_health_set(PointerRNA *ptr, float value);

float BoidSettings_height_get(PointerRNA *ptr);
void BoidSettings_height_set(PointerRNA *ptr, float value);

float BoidSettings_land_jump_speed_get(PointerRNA *ptr);
void BoidSettings_land_jump_speed_set(PointerRNA *ptr, float value);

float BoidSettings_land_personal_space_get(PointerRNA *ptr);
void BoidSettings_land_personal_space_set(PointerRNA *ptr, float value);

float BoidSettings_land_stick_force_get(PointerRNA *ptr);
void BoidSettings_land_stick_force_set(PointerRNA *ptr, float value);

float BoidSettings_land_smooth_get(PointerRNA *ptr);
void BoidSettings_land_smooth_set(PointerRNA *ptr, float value);

float BoidSettings_air_acc_max_get(PointerRNA *ptr);
void BoidSettings_air_acc_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_ave_max_get(PointerRNA *ptr);
void BoidSettings_air_ave_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_speed_max_get(PointerRNA *ptr);
void BoidSettings_air_speed_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_acc_max_get(PointerRNA *ptr);
void BoidSettings_land_acc_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_ave_max_get(PointerRNA *ptr);
void BoidSettings_land_ave_max_set(PointerRNA *ptr, float value);

float BoidSettings_land_speed_max_get(PointerRNA *ptr);
void BoidSettings_land_speed_max_set(PointerRNA *ptr, float value);

float BoidSettings_air_speed_min_get(PointerRNA *ptr);
void BoidSettings_air_speed_min_set(PointerRNA *ptr, float value);

float BoidSettings_pitch_get(PointerRNA *ptr);
void BoidSettings_pitch_set(PointerRNA *ptr, float value);

float BoidSettings_range_get(PointerRNA *ptr);
void BoidSettings_range_set(PointerRNA *ptr, float value);

float BoidSettings_strength_get(PointerRNA *ptr);
void BoidSettings_strength_set(PointerRNA *ptr, float value);

/**************** Boid State ****************/

extern StructRNA RNA_BoidState;

PointerRNA BoidState_rna_type_get(PointerRNA *ptr);

#define BoidState_name_MAX 32

void BoidState_name_get(PointerRNA *ptr, char *value);
int BoidState_name_length(PointerRNA *ptr);
void BoidState_name_set(PointerRNA *ptr, const char *value);

PointerRNA BoidState_active_boid_rule_get(PointerRNA *ptr);

int BoidState_active_boid_rule_index_get(PointerRNA *ptr);
void BoidState_active_boid_rule_index_set(PointerRNA *ptr, int value);

void BoidState_rules_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoidState_rules_next(CollectionPropertyIterator *iter);
void BoidState_rules_end(CollectionPropertyIterator *iter);
bool BoidState_rules_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool BoidState_rules_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float BoidState_falloff_get(PointerRNA *ptr);
void BoidState_falloff_set(PointerRNA *ptr, float value);

enum {
	BoidState_ruleset_type_FUZZY = 0,
	BoidState_ruleset_type_RANDOM = 1,
	BoidState_ruleset_type_AVERAGE = 2,
};

int BoidState_ruleset_type_get(PointerRNA *ptr);
void BoidState_ruleset_type_set(PointerRNA *ptr, int value);

float BoidState_rule_fuzzy_get(PointerRNA *ptr);
void BoidState_rule_fuzzy_set(PointerRNA *ptr, float value);

float BoidState_volume_get(PointerRNA *ptr);
void BoidState_volume_set(PointerRNA *ptr, float value);

/**************** Bone ****************/

extern StructRNA RNA_Bone;

PointerRNA Bone_rna_type_get(PointerRNA *ptr);

#define Bone_name_MAX 64

void Bone_name_get(PointerRNA *ptr, char *value);
int Bone_name_length(PointerRNA *ptr);
void Bone_name_set(PointerRNA *ptr, const char *value);

void Bone_head_local_get(PointerRNA *ptr, float values[3]);
void Bone_head_local_set(PointerRNA *ptr, const float values[3]);

void Bone_tail_local_get(PointerRNA *ptr, float values[3]);
void Bone_tail_local_set(PointerRNA *ptr, const float values[3]);

float Bone_bbone_x_get(PointerRNA *ptr);
void Bone_bbone_x_set(PointerRNA *ptr, float value);

float Bone_bbone_z_get(PointerRNA *ptr);
void Bone_bbone_z_set(PointerRNA *ptr, float value);

PointerRNA Bone_bbone_custom_handle_end_get(PointerRNA *ptr);

enum {
	Bone_bbone_handle_type_end_AUTO = 0,
	Bone_bbone_handle_type_end_ABSOLUTE = 1,
	Bone_bbone_handle_type_end_RELATIVE = 2,
	Bone_bbone_handle_type_end_TANGENT = 3,
};

int Bone_bbone_handle_type_end_get(PointerRNA *ptr);
void Bone_bbone_handle_type_end_set(PointerRNA *ptr, int value);

int Bone_bbone_segments_get(PointerRNA *ptr);
void Bone_bbone_segments_set(PointerRNA *ptr, int value);

PointerRNA Bone_bbone_custom_handle_start_get(PointerRNA *ptr);

enum {
	Bone_bbone_handle_type_start_AUTO = 0,
	Bone_bbone_handle_type_start_ABSOLUTE = 1,
	Bone_bbone_handle_type_start_RELATIVE = 2,
	Bone_bbone_handle_type_start_TANGENT = 3,
};

int Bone_bbone_handle_type_start_get(PointerRNA *ptr);
void Bone_bbone_handle_type_start_set(PointerRNA *ptr, int value);

enum {
	Bone_bbone_mapping_mode_STRAIGHT = 0,
	Bone_bbone_mapping_mode_CURVED = 1,
};

int Bone_bbone_mapping_mode_get(PointerRNA *ptr);
void Bone_bbone_mapping_mode_set(PointerRNA *ptr, int value);

void Bone_matrix_local_get(PointerRNA *ptr, float values[16]);
void Bone_matrix_local_set(PointerRNA *ptr, const float values[16]);

void Bone_matrix_get(PointerRNA *ptr, float values[9]);
void Bone_matrix_set(PointerRNA *ptr, const float values[9]);

void Bone_children_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Bone_children_next(CollectionPropertyIterator *iter);
void Bone_children_end(CollectionPropertyIterator *iter);
bool Bone_children_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Bone_children_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Bone_collections_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Bone_collections_next(CollectionPropertyIterator *iter);
void Bone_collections_end(CollectionPropertyIterator *iter);

bool Bone_use_connect_get(PointerRNA *ptr);
void Bone_use_connect_set(PointerRNA *ptr, bool value);

bool Bone_use_cyclic_offset_get(PointerRNA *ptr);
void Bone_use_cyclic_offset_set(PointerRNA *ptr, bool value);

bool Bone_use_deform_get(PointerRNA *ptr);
void Bone_use_deform_set(PointerRNA *ptr, bool value);

enum {
	Bone_display_type_ARMATURE_DEFINED = -1,
	Bone_display_type_OCTAHEDRAL = 0,
	Bone_display_type_STICK = 1,
	Bone_display_type_BBONE = 2,
	Bone_display_type_ENVELOPE = 3,
	Bone_display_type_WIRE = 4,
};

int Bone_display_type_get(PointerRNA *ptr);
void Bone_display_type_set(PointerRNA *ptr, int value);

bool Bone_show_wire_get(PointerRNA *ptr);
void Bone_show_wire_set(PointerRNA *ptr, bool value);

float Bone_bbone_easein_get(PointerRNA *ptr);
void Bone_bbone_easein_set(PointerRNA *ptr, float value);

float Bone_bbone_easeout_get(PointerRNA *ptr);
void Bone_bbone_easeout_set(PointerRNA *ptr, float value);

bool Bone_bbone_handle_use_ease_end_get(PointerRNA *ptr);
void Bone_bbone_handle_use_ease_end_set(PointerRNA *ptr, bool value);

void Bone_bbone_handle_use_scale_end_get(PointerRNA *ptr, bool values[3]);
void Bone_bbone_handle_use_scale_end_set(PointerRNA *ptr, const bool values[3]);

float Bone_envelope_distance_get(PointerRNA *ptr);
void Bone_envelope_distance_set(PointerRNA *ptr, float value);

float Bone_envelope_weight_get(PointerRNA *ptr);
void Bone_envelope_weight_set(PointerRNA *ptr, float value);

float Bone_head_radius_get(PointerRNA *ptr);
void Bone_head_radius_set(PointerRNA *ptr, float value);

float Bone_tail_radius_get(PointerRNA *ptr);
void Bone_tail_radius_set(PointerRNA *ptr, float value);

void Bone_head_get(PointerRNA *ptr, float values[3]);
void Bone_head_set(PointerRNA *ptr, const float values[3]);

bool Bone_hide_get(PointerRNA *ptr);
void Bone_hide_set(PointerRNA *ptr, bool value);

float Bone_bbone_curveinx_get(PointerRNA *ptr);
void Bone_bbone_curveinx_set(PointerRNA *ptr, float value);

float Bone_bbone_curveinz_get(PointerRNA *ptr);
void Bone_bbone_curveinz_set(PointerRNA *ptr, float value);

bool Bone_use_endroll_as_inroll_get(PointerRNA *ptr);
void Bone_use_endroll_as_inroll_set(PointerRNA *ptr, bool value);

bool Bone_use_inherit_rotation_get(PointerRNA *ptr);
void Bone_use_inherit_rotation_set(PointerRNA *ptr, bool value);

enum {
	Bone_inherit_scale_FULL = 0,
	Bone_inherit_scale_FIX_SHEAR = 1,
	Bone_inherit_scale_ALIGNED = 5,
	Bone_inherit_scale_AVERAGE = 2,
	Bone_inherit_scale_NONE = 3,
	Bone_inherit_scale_NONE_LEGACY = 4,
};

int Bone_inherit_scale_get(PointerRNA *ptr);
void Bone_inherit_scale_set(PointerRNA *ptr, int value);

float Bone_length_get(PointerRNA *ptr);
void Bone_length_set(PointerRNA *ptr, float value);

bool Bone_use_local_location_get(PointerRNA *ptr);
void Bone_use_local_location_set(PointerRNA *ptr, bool value);

bool Bone_use_envelope_multiply_get(PointerRNA *ptr);
void Bone_use_envelope_multiply_set(PointerRNA *ptr, bool value);

float Bone_bbone_curveoutx_get(PointerRNA *ptr);
void Bone_bbone_curveoutx_set(PointerRNA *ptr, float value);

float Bone_bbone_curveoutz_get(PointerRNA *ptr);
void Bone_bbone_curveoutz_set(PointerRNA *ptr, float value);

PointerRNA Bone_parent_get(PointerRNA *ptr);

bool Bone_use_relative_parent_get(PointerRNA *ptr);
void Bone_use_relative_parent_set(PointerRNA *ptr, bool value);

float Bone_bbone_rollin_get(PointerRNA *ptr);
void Bone_bbone_rollin_set(PointerRNA *ptr, float value);

float Bone_bbone_rollout_get(PointerRNA *ptr);
void Bone_bbone_rollout_set(PointerRNA *ptr, float value);

bool Bone_use_scale_easing_get(PointerRNA *ptr);
void Bone_use_scale_easing_set(PointerRNA *ptr, bool value);

void Bone_bbone_scalein_get(PointerRNA *ptr, float values[3]);
void Bone_bbone_scalein_set(PointerRNA *ptr, const float values[3]);

void Bone_bbone_scaleout_get(PointerRNA *ptr, float values[3]);
void Bone_bbone_scaleout_set(PointerRNA *ptr, const float values[3]);

bool Bone_hide_select_get(PointerRNA *ptr);
void Bone_hide_select_set(PointerRNA *ptr, bool value);

bool Bone_bbone_handle_use_ease_start_get(PointerRNA *ptr);
void Bone_bbone_handle_use_ease_start_set(PointerRNA *ptr, bool value);

void Bone_bbone_handle_use_scale_start_get(PointerRNA *ptr, bool values[3]);
void Bone_bbone_handle_use_scale_start_set(PointerRNA *ptr, const bool values[3]);

void Bone_tail_get(PointerRNA *ptr, float values[3]);
void Bone_tail_set(PointerRNA *ptr, const float values[3]);

PointerRNA Bone_color_get(PointerRNA *ptr);

struct IDPropertyGroup *Bone_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
float Bone_evaluate_envelope_func(struct Bone *_self, float point[3]);
void Bone_convert_local_to_pose_func(struct Bone *_self, float matrix_return[16], float matrix[16], float matrix_local[16], float parent_matrix[16], float parent_matrix_local[16], bool invert);
void Bone_MatrixFromAxisRoll_func(float axis[3], float roll, float result_matrix[9]);
void Bone_AxisRollFromMatrix_func(float matrix[9], float axis[3], float result_axis[3], float *result_roll);
/**************** BoneCollection ****************/

extern StructRNA RNA_BoneCollection;

PointerRNA BoneCollection_rna_type_get(PointerRNA *ptr);

#define BoneCollection_name_MAX 64

void BoneCollection_name_get(PointerRNA *ptr, char *value);
int BoneCollection_name_length(PointerRNA *ptr);
void BoneCollection_name_set(PointerRNA *ptr, const char *value);

bool BoneCollection_is_visible_ancestors_get(PointerRNA *ptr);
void BoneCollection_is_visible_ancestors_set(PointerRNA *ptr, bool value);

void BoneCollection_bones_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoneCollection_bones_next(CollectionPropertyIterator *iter);
void BoneCollection_bones_end(CollectionPropertyIterator *iter);
bool BoneCollection_bones_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool BoneCollection_bones_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int BoneCollection_child_number_get(PointerRNA *ptr);
void BoneCollection_child_number_set(PointerRNA *ptr, int value);

bool BoneCollection_is_visible_effectively_get(PointerRNA *ptr);
void BoneCollection_is_visible_effectively_set(PointerRNA *ptr, bool value);

bool BoneCollection_is_expanded_get(PointerRNA *ptr);
void BoneCollection_is_expanded_set(PointerRNA *ptr, bool value);

int BoneCollection_index_get(PointerRNA *ptr);
void BoneCollection_index_set(PointerRNA *ptr, int value);

bool BoneCollection_is_editable_get(PointerRNA *ptr);
void BoneCollection_is_editable_set(PointerRNA *ptr, bool value);

bool BoneCollection_is_local_override_get(PointerRNA *ptr);
void BoneCollection_is_local_override_set(PointerRNA *ptr, bool value);

PointerRNA BoneCollection_parent_get(PointerRNA *ptr);

bool BoneCollection_is_solo_get(PointerRNA *ptr);
void BoneCollection_is_solo_set(PointerRNA *ptr, bool value);

bool BoneCollection_is_visible_get(PointerRNA *ptr);
void BoneCollection_is_visible_set(PointerRNA *ptr, bool value);

void BoneCollection_children_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoneCollection_children_next(CollectionPropertyIterator *iter);
void BoneCollection_children_end(CollectionPropertyIterator *iter);
int BoneCollection_children_length(PointerRNA *ptr);

struct IDPropertyGroup *BoneCollection_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
bool BoneCollection_assign_func(struct BoneCollection *_self, bContext *C, ReportList *reports, struct PointerRNA *bone);
bool BoneCollection_unassign_func(struct BoneCollection *_self, bContext *C, ReportList *reports, struct PointerRNA *bone);
/**************** Bone Collection Memberships ****************/

extern StructRNA RNA_BoneCollectionMemberships;

PointerRNA BoneCollectionMemberships_rna_type_get(PointerRNA *ptr);

void BoneCollectionMemberships_clear_func(struct Bone *_self);
/**************** Armature Bone Collections ****************/

extern StructRNA RNA_BoneCollections;

PointerRNA BoneCollections_rna_type_get(PointerRNA *ptr);

PointerRNA BoneCollections_active_get(PointerRNA *ptr);

int BoneCollections_active_index_get(PointerRNA *ptr);
void BoneCollections_active_index_set(PointerRNA *ptr, int value);

#define BoneCollections_active_name_MAX 64

void BoneCollections_active_name_get(PointerRNA *ptr, char *value);
int BoneCollections_active_name_length(PointerRNA *ptr);
void BoneCollections_active_name_set(PointerRNA *ptr, const char *value);

bool BoneCollections_is_solo_active_get(PointerRNA *ptr);
void BoneCollections_is_solo_active_set(PointerRNA *ptr, bool value);

struct BoneCollection *BoneCollections_new_func(struct bArmature *_self, ReportList *reports, const char * name, struct BoneCollection *parent);
void BoneCollections_remove_func(struct bArmature *_self, struct BoneCollection *bone_collection);
void BoneCollections_move_func(struct bArmature *_self, ReportList *reports, int from_index, int to_index);
/**************** BoneColor ****************/

extern StructRNA RNA_BoneColor;

PointerRNA BoneColor_rna_type_get(PointerRNA *ptr);

enum {
	BoneColor_palette_DEFAULT = 0,
	BoneColor_palette_THEME01 = 1,
	BoneColor_palette_THEME02 = 2,
	BoneColor_palette_THEME03 = 3,
	BoneColor_palette_THEME04 = 4,
	BoneColor_palette_THEME05 = 5,
	BoneColor_palette_THEME06 = 6,
	BoneColor_palette_THEME07 = 7,
	BoneColor_palette_THEME08 = 8,
	BoneColor_palette_THEME09 = 9,
	BoneColor_palette_THEME10 = 10,
	BoneColor_palette_THEME11 = 11,
	BoneColor_palette_THEME12 = 12,
	BoneColor_palette_THEME13 = 13,
	BoneColor_palette_THEME14 = 14,
	BoneColor_palette_THEME15 = 15,
	BoneColor_palette_THEME16 = 16,
	BoneColor_palette_THEME17 = 17,
	BoneColor_palette_THEME18 = 18,
	BoneColor_palette_THEME19 = 19,
	BoneColor_palette_THEME20 = 20,
	BoneColor_palette_CUSTOM = -1,
};

int BoneColor_palette_get(PointerRNA *ptr);
void BoneColor_palette_set(PointerRNA *ptr, int value);

PointerRNA BoneColor_custom_get(PointerRNA *ptr);

bool BoneColor_is_custom_get(PointerRNA *ptr);
void BoneColor_is_custom_set(PointerRNA *ptr, bool value);

/**************** Bool Attribute ****************/

extern StructRNA RNA_BoolAttribute;
extern StructRNA RNA_Attribute;

void BoolAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void BoolAttribute_data_next(CollectionPropertyIterator *iter);
void BoolAttribute_data_end(CollectionPropertyIterator *iter);
int BoolAttribute_data_length(PointerRNA *ptr);
bool BoolAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Bool Attribute Value ****************/

extern StructRNA RNA_BoolAttributeValue;

PointerRNA BoolAttributeValue_rna_type_get(PointerRNA *ptr);

bool BoolAttributeValue_value_get(PointerRNA *ptr);
void BoolAttributeValue_value_set(PointerRNA *ptr, bool value);

/**************** Boolean Definition ****************/

extern StructRNA RNA_BoolProperty;
extern StructRNA RNA_Property;

void BoolProperty_array_dimensions_get(PointerRNA *ptr, int values[3]);
void BoolProperty_array_dimensions_set(PointerRNA *ptr, const int values[3]);

int BoolProperty_array_length_get(PointerRNA *ptr);
void BoolProperty_array_length_set(PointerRNA *ptr, int value);

bool BoolProperty_default_value_get(PointerRNA *ptr);
void BoolProperty_default_value_set(PointerRNA *ptr, bool value);

void BoolProperty_default_array_get(PointerRNA *ptr, bool values[]);
void BoolProperty_default_array_set(PointerRNA *ptr, const bool values[]);
int BoolProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

bool BoolProperty_is_array_get(PointerRNA *ptr);
void BoolProperty_is_array_set(PointerRNA *ptr, bool value);

/**************** Boolean Modifier ****************/

extern StructRNA RNA_BooleanModifier;
extern StructRNA RNA_Modifier;

PointerRNA BooleanModifier_collection_get(PointerRNA *ptr);

enum {
	BooleanModifier_debug_options_SEPARATE = 1,
	BooleanModifier_debug_options_NO_DISSOLVE = 2,
	BooleanModifier_debug_options_NO_CONNECT_REGIONS = 4,
};

int BooleanModifier_debug_options_get(PointerRNA *ptr);
void BooleanModifier_debug_options_set(PointerRNA *ptr, int value);

bool BooleanModifier_use_hole_tolerant_get(PointerRNA *ptr);
void BooleanModifier_use_hole_tolerant_set(PointerRNA *ptr, bool value);

enum {
	BooleanModifier_material_mode_INDEX = 0,
	BooleanModifier_material_mode_TRANSFER = 1,
};

int BooleanModifier_material_mode_get(PointerRNA *ptr);
void BooleanModifier_material_mode_set(PointerRNA *ptr, int value);

PointerRNA BooleanModifier_object_get(PointerRNA *ptr);

enum {
	BooleanModifier_operand_type_OBJECT = 2,
	BooleanModifier_operand_type_COLLECTION = 4,
};

int BooleanModifier_operand_type_get(PointerRNA *ptr);
void BooleanModifier_operand_type_set(PointerRNA *ptr, int value);

enum {
	BooleanModifier_operation_INTERSECT = 0,
	BooleanModifier_operation_UNION = 1,
	BooleanModifier_operation_DIFFERENCE = 2,
};

int BooleanModifier_operation_get(PointerRNA *ptr);
void BooleanModifier_operation_set(PointerRNA *ptr, int value);

float BooleanModifier_double_threshold_get(PointerRNA *ptr);
void BooleanModifier_double_threshold_set(PointerRNA *ptr, float value);

bool BooleanModifier_use_self_get(PointerRNA *ptr);
void BooleanModifier_use_self_set(PointerRNA *ptr, bool value);

enum {
	BooleanModifier_solver_FLOAT = 0,
	BooleanModifier_solver_EXACT = 1,
	BooleanModifier_solver_MANIFOLD = 2,
};

int BooleanModifier_solver_get(PointerRNA *ptr);
void BooleanModifier_solver_set(PointerRNA *ptr, int value);

/**************** BrightContrastModifier ****************/

extern StructRNA RNA_BrightContrastModifier;
extern StructRNA RNA_StripModifier;

float BrightContrastModifier_bright_get(PointerRNA *ptr);
void BrightContrastModifier_bright_set(PointerRNA *ptr, float value);

float BrightContrastModifier_contrast_get(PointerRNA *ptr);
void BrightContrastModifier_contrast_set(PointerRNA *ptr, float value);

bool BrightContrastModifier_open_mask_input_panel_get(PointerRNA *ptr);
void BrightContrastModifier_open_mask_input_panel_set(PointerRNA *ptr, bool value);

/**************** Brush ****************/

extern StructRNA RNA_Brush;
extern StructRNA RNA_ID;

bool Brush_use_accumulate_get(PointerRNA *ptr);
void Brush_use_accumulate_set(PointerRNA *ptr, bool value);

bool Brush_use_adaptive_space_get(PointerRNA *ptr);
void Brush_use_adaptive_space_set(PointerRNA *ptr, bool value);

void Brush_cursor_color_add_get(PointerRNA *ptr, float values[4]);
void Brush_cursor_color_add_set(PointerRNA *ptr, const float values[4]);

bool Brush_use_space_attenuation_get(PointerRNA *ptr);
void Brush_use_space_attenuation_set(PointerRNA *ptr, bool value);

bool Brush_use_alpha_get(PointerRNA *ptr);
void Brush_use_alpha_set(PointerRNA *ptr, bool value);

bool Brush_use_airbrush_get(PointerRNA *ptr);
void Brush_use_airbrush_set(PointerRNA *ptr, bool value);

bool Brush_use_anchor_get(PointerRNA *ptr);
void Brush_use_anchor_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_antialiasing_get(PointerRNA *ptr);
void Brush_use_paint_antialiasing_set(PointerRNA *ptr, bool value);

bool Brush_use_automasking_start_normal_get(PointerRNA *ptr);
void Brush_use_automasking_start_normal_set(PointerRNA *ptr, bool value);

float Brush_automasking_start_normal_falloff_get(PointerRNA *ptr);
void Brush_automasking_start_normal_falloff_set(PointerRNA *ptr, float value);

float Brush_automasking_start_normal_limit_get(PointerRNA *ptr);
void Brush_automasking_start_normal_limit_set(PointerRNA *ptr, float value);

float Brush_area_radius_factor_get(PointerRNA *ptr);
void Brush_area_radius_factor_set(PointerRNA *ptr, float value);

bool Brush_use_pressure_area_radius_get(PointerRNA *ptr);
void Brush_use_pressure_area_radius_set(PointerRNA *ptr, bool value);

float Brush_auto_smooth_factor_get(PointerRNA *ptr);
void Brush_auto_smooth_factor_set(PointerRNA *ptr, float value);

enum {
	Brush_blend_MIX = 0,
	Brush_blend_DARKEN = 5,
	Brush_blend_MUL = 3,
	Brush_blend_COLORBURN = 10,
	Brush_blend_LINEARBURN = 11,
	Brush_blend_LIGHTEN = 4,
	Brush_blend_SCREEN = 13,
	Brush_blend_COLORDODGE = 12,
	Brush_blend_ADD = 1,
	Brush_blend_OVERLAY = 8,
	Brush_blend_SOFTLIGHT = 14,
	Brush_blend_HARDLIGHT = 9,
	Brush_blend_VIVIDLIGHT = 16,
	Brush_blend_LINEARLIGHT = 17,
	Brush_blend_PINLIGHT = 15,
	Brush_blend_DIFFERENCE = 18,
	Brush_blend_EXCLUSION = 19,
	Brush_blend_SUB = 2,
	Brush_blend_HUE = 20,
	Brush_blend_SATURATION = 21,
	Brush_blend_COLOR = 23,
	Brush_blend_LUMINOSITY = 22,
	Brush_blend_ERASE_ALPHA = 6,
	Brush_blend_ADD_ALPHA = 7,
};

int Brush_blend_get(PointerRNA *ptr);
void Brush_blend_set(PointerRNA *ptr, int value);

enum {
	Brush_blur_mode_BOX = 1,
	Brush_blur_mode_GAUSSIAN = 0,
};

int Brush_blur_mode_get(PointerRNA *ptr);
void Brush_blur_mode_set(PointerRNA *ptr, int value);

int Brush_automasking_cavity_blur_steps_get(PointerRNA *ptr);
void Brush_automasking_cavity_blur_steps_set(PointerRNA *ptr, int value);

enum {
	Brush_boundary_falloff_type_CONSTANT = 0,
	Brush_boundary_falloff_type_RADIUS = 1,
	Brush_boundary_falloff_type_LOOP = 2,
	Brush_boundary_falloff_type_LOOP_INVERT = 3,
};

int Brush_boundary_falloff_type_get(PointerRNA *ptr);
void Brush_boundary_falloff_type_set(PointerRNA *ptr, int value);

float Brush_boundary_offset_get(PointerRNA *ptr);
void Brush_boundary_offset_set(PointerRNA *ptr, float value);

PointerRNA Brush_brush_capabilities_get(PointerRNA *ptr);

float Brush_height_get(PointerRNA *ptr);
void Brush_height_set(PointerRNA *ptr, float value);

enum {
	Brush_sculpt_brush_type_DRAW = 1,
	Brush_sculpt_brush_type_DRAW_SHARP = 20,
	Brush_sculpt_brush_type_CLAY = 8,
	Brush_sculpt_brush_type_CLAY_STRIPS = 18,
	Brush_sculpt_brush_type_CLAY_THUMB = 25,
	Brush_sculpt_brush_type_LAYER = 6,
	Brush_sculpt_brush_type_INFLATE = 4,
	Brush_sculpt_brush_type_BLOB = 17,
	Brush_sculpt_brush_type_CREASE = 16,
	Brush_sculpt_brush_type_SMOOTH = 2,
	Brush_sculpt_brush_type_PLANE = 33,
	Brush_sculpt_brush_type_MULTIPLANE_SCRAPE = 23,
	Brush_sculpt_brush_type_PINCH = 3,
	Brush_sculpt_brush_type_GRAB = 5,
	Brush_sculpt_brush_type_ELASTIC_DEFORM = 21,
	Brush_sculpt_brush_type_SNAKE_HOOK = 13,
	Brush_sculpt_brush_type_THUMB = 12,
	Brush_sculpt_brush_type_POSE = 22,
	Brush_sculpt_brush_type_NUDGE = 11,
	Brush_sculpt_brush_type_ROTATE = 14,
	Brush_sculpt_brush_type_TOPOLOGY = 24,
	Brush_sculpt_brush_type_BOUNDARY = 30,
	Brush_sculpt_brush_type_CLOTH = 26,
	Brush_sculpt_brush_type_SIMPLIFY = 15,
	Brush_sculpt_brush_type_MASK = 19,
	Brush_sculpt_brush_type_DRAW_FACE_SETS = 27,
	Brush_sculpt_brush_type_DISPLACEMENT_ERASER = 31,
	Brush_sculpt_brush_type_DISPLACEMENT_SMEAR = 32,
	Brush_sculpt_brush_type_PAINT = 28,
	Brush_sculpt_brush_type_SMEAR = 29,
};

int Brush_sculpt_brush_type_get(PointerRNA *ptr);
void Brush_sculpt_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_vertex_brush_type_DRAW = 0,
	Brush_vertex_brush_type_BLUR = 1,
	Brush_vertex_brush_type_AVERAGE = 2,
	Brush_vertex_brush_type_SMEAR = 3,
};

int Brush_vertex_brush_type_get(PointerRNA *ptr);
void Brush_vertex_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_weight_brush_type_DRAW = 0,
	Brush_weight_brush_type_BLUR = 1,
	Brush_weight_brush_type_AVERAGE = 2,
	Brush_weight_brush_type_SMEAR = 3,
};

int Brush_weight_brush_type_get(PointerRNA *ptr);
void Brush_weight_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_image_brush_type_DRAW = 0,
	Brush_image_brush_type_SOFTEN = 1,
	Brush_image_brush_type_SMEAR = 2,
	Brush_image_brush_type_CLONE = 3,
	Brush_image_brush_type_FILL = 4,
	Brush_image_brush_type_MASK = 5,
};

int Brush_image_brush_type_get(PointerRNA *ptr);
void Brush_image_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_gpencil_brush_type_DRAW = 0,
	Brush_gpencil_brush_type_FILL = 1,
	Brush_gpencil_brush_type_ERASE = 2,
	Brush_gpencil_brush_type_TINT = 3,
};

int Brush_gpencil_brush_type_get(PointerRNA *ptr);
void Brush_gpencil_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_gpencil_vertex_brush_type_DRAW = 0,
	Brush_gpencil_vertex_brush_type_BLUR = 1,
	Brush_gpencil_vertex_brush_type_AVERAGE = 2,
	Brush_gpencil_vertex_brush_type_SMEAR = 4,
	Brush_gpencil_vertex_brush_type_REPLACE = 5,
};

int Brush_gpencil_vertex_brush_type_get(PointerRNA *ptr);
void Brush_gpencil_vertex_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_gpencil_sculpt_brush_type_SMOOTH = 0,
	Brush_gpencil_sculpt_brush_type_THICKNESS = 1,
	Brush_gpencil_sculpt_brush_type_STRENGTH = 2,
	Brush_gpencil_sculpt_brush_type_RANDOMIZE = 7,
	Brush_gpencil_sculpt_brush_type_GRAB = 3,
	Brush_gpencil_sculpt_brush_type_PUSH = 4,
	Brush_gpencil_sculpt_brush_type_TWIST = 5,
	Brush_gpencil_sculpt_brush_type_PINCH = 6,
	Brush_gpencil_sculpt_brush_type_CLONE = 8,
};

int Brush_gpencil_sculpt_brush_type_get(PointerRNA *ptr);
void Brush_gpencil_sculpt_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_gpencil_weight_brush_type_WEIGHT = 0,
	Brush_gpencil_weight_brush_type_BLUR = 1,
	Brush_gpencil_weight_brush_type_AVERAGE = 2,
	Brush_gpencil_weight_brush_type_SMEAR = 3,
};

int Brush_gpencil_weight_brush_type_get(PointerRNA *ptr);
void Brush_gpencil_weight_brush_type_set(PointerRNA *ptr, int value);

enum {
	Brush_curves_sculpt_brush_type_SELECTION_PAINT = 5,
	Brush_curves_sculpt_brush_type_ADD = 3,
	Brush_curves_sculpt_brush_type_DELETE = 1,
	Brush_curves_sculpt_brush_type_DENSITY = 9,
	Brush_curves_sculpt_brush_type_COMB = 0,
	Brush_curves_sculpt_brush_type_SNAKE_HOOK = 2,
	Brush_curves_sculpt_brush_type_GROW_SHRINK = 4,
	Brush_curves_sculpt_brush_type_PINCH = 6,
	Brush_curves_sculpt_brush_type_PUFF = 8,
	Brush_curves_sculpt_brush_type_SMOOTH = 7,
	Brush_curves_sculpt_brush_type_SLIDE = 10,
};

int Brush_curves_sculpt_brush_type_get(PointerRNA *ptr);
void Brush_curves_sculpt_brush_type_set(PointerRNA *ptr, int value);

PointerRNA Brush_automasking_cavity_curve_get(PointerRNA *ptr);

float Brush_automasking_cavity_factor_get(PointerRNA *ptr);
void Brush_automasking_cavity_factor_set(PointerRNA *ptr, float value);

bool Brush_use_automasking_cavity_get(PointerRNA *ptr);
void Brush_use_automasking_cavity_set(PointerRNA *ptr, bool value);

float Brush_cloth_damping_get(PointerRNA *ptr);
void Brush_cloth_damping_set(PointerRNA *ptr, float value);

float Brush_cloth_mass_get(PointerRNA *ptr);
void Brush_cloth_mass_set(PointerRNA *ptr, float value);

void Brush_color_get(PointerRNA *ptr, float values[3]);
void Brush_color_set(PointerRNA *ptr, const float values[3]);

enum {
	Brush_color_type_COLOR = 0,
	Brush_color_type_GRADIENT = 2097152,
};

int Brush_color_type_get(PointerRNA *ptr);
void Brush_color_type_set(PointerRNA *ptr, int value);

bool Brush_use_connected_only_get(PointerRNA *ptr);
void Brush_use_connected_only_set(PointerRNA *ptr, bool value);

float Brush_crease_pinch_factor_get(PointerRNA *ptr);
void Brush_crease_pinch_factor_set(PointerRNA *ptr, float value);

bool Brush_use_curve_get(PointerRNA *ptr);
void Brush_use_curve_set(PointerRNA *ptr, bool value);

PointerRNA Brush_curves_sculpt_settings_get(PointerRNA *ptr);

bool Brush_use_automasking_custom_cavity_curve_get(PointerRNA *ptr);
void Brush_use_automasking_custom_cavity_curve_set(PointerRNA *ptr, bool value);

int Brush_dash_samples_get(PointerRNA *ptr);
void Brush_dash_samples_set(PointerRNA *ptr, int value);

float Brush_dash_ratio_get(PointerRNA *ptr);
void Brush_dash_ratio_set(PointerRNA *ptr, float value);

enum {
	Brush_elastic_deform_type_GRAB = 0,
	Brush_elastic_deform_type_GRAB_BISCALE = 1,
	Brush_elastic_deform_type_GRAB_TRISCALE = 2,
	Brush_elastic_deform_type_SCALE = 3,
	Brush_elastic_deform_type_TWIST = 4,
};

int Brush_elastic_deform_type_get(PointerRNA *ptr);
void Brush_elastic_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_snake_hook_deform_type_FALLOFF = 0,
	Brush_snake_hook_deform_type_ELASTIC = 1,
};

int Brush_snake_hook_deform_type_get(PointerRNA *ptr);
void Brush_snake_hook_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_cloth_deform_type_DRAG = 0,
	Brush_cloth_deform_type_PUSH = 1,
	Brush_cloth_deform_type_PINCH_POINT = 3,
	Brush_cloth_deform_type_PINCH_PERPENDICULAR = 4,
	Brush_cloth_deform_type_INFLATE = 5,
	Brush_cloth_deform_type_GRAB = 2,
	Brush_cloth_deform_type_EXPAND = 6,
	Brush_cloth_deform_type_SNAKE_HOOK = 7,
};

int Brush_cloth_deform_type_get(PointerRNA *ptr);
void Brush_cloth_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_smooth_deform_type_LAPLACIAN = 0,
	Brush_smooth_deform_type_SURFACE = 1,
};

int Brush_smooth_deform_type_get(PointerRNA *ptr);
void Brush_smooth_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_smear_deform_type_DRAG = 0,
	Brush_smear_deform_type_PINCH = 1,
	Brush_smear_deform_type_EXPAND = 2,
};

int Brush_smear_deform_type_get(PointerRNA *ptr);
void Brush_smear_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_slide_deform_type_DRAG = 0,
	Brush_slide_deform_type_PINCH = 1,
	Brush_slide_deform_type_EXPAND = 2,
};

int Brush_slide_deform_type_get(PointerRNA *ptr);
void Brush_slide_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_boundary_deform_type_BEND = 0,
	Brush_boundary_deform_type_EXPAND = 1,
	Brush_boundary_deform_type_INFLATE = 2,
	Brush_boundary_deform_type_GRAB = 3,
	Brush_boundary_deform_type_TWIST = 4,
	Brush_boundary_deform_type_SMOOTH = 5,
};

int Brush_boundary_deform_type_get(PointerRNA *ptr);
void Brush_boundary_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_pose_deform_type_ROTATE_TWIST = 0,
	Brush_pose_deform_type_SCALE_TRANSLATE = 1,
	Brush_pose_deform_type_SQUASH_STRETCH = 2,
};

int Brush_pose_deform_type_get(PointerRNA *ptr);
void Brush_pose_deform_type_set(PointerRNA *ptr, int value);

enum {
	Brush_deform_target_GEOMETRY = 0,
	Brush_deform_target_CLOTH_SIM = 1,
};

int Brush_deform_target_get(PointerRNA *ptr);
void Brush_deform_target_set(PointerRNA *ptr, int value);

float Brush_density_get(PointerRNA *ptr);
void Brush_density_set(PointerRNA *ptr, float value);

float Brush_plane_depth_get(PointerRNA *ptr);
void Brush_plane_depth_set(PointerRNA *ptr, float value);

enum {
	Brush_direction_ADD = 0,
	Brush_direction_SUBTRACT = 512,
};

int Brush_direction_get(PointerRNA *ptr);
void Brush_direction_set(PointerRNA *ptr, int value);

bool Brush_use_multiplane_scrape_dynamic_get(PointerRNA *ptr);
void Brush_use_multiplane_scrape_dynamic_set(PointerRNA *ptr, bool value);

bool Brush_use_edge_to_edge_get(PointerRNA *ptr);
void Brush_use_edge_to_edge_set(PointerRNA *ptr, bool value);

bool Brush_use_cloth_collision_get(PointerRNA *ptr);
void Brush_use_cloth_collision_set(PointerRNA *ptr, bool value);

bool Brush_use_automasking_face_sets_get(PointerRNA *ptr);
void Brush_use_automasking_face_sets_set(PointerRNA *ptr, bool value);

bool Brush_use_automasking_boundary_face_sets_get(PointerRNA *ptr);
void Brush_use_automasking_boundary_face_sets_set(PointerRNA *ptr, bool value);

float Brush_falloff_angle_get(PointerRNA *ptr);
void Brush_falloff_angle_set(PointerRNA *ptr, float value);

PointerRNA Brush_curve_distance_falloff_get(PointerRNA *ptr);

enum {
	Brush_curve_distance_falloff_preset_CUSTOM = 0,
	Brush_curve_distance_falloff_preset_SMOOTH = 1,
	Brush_curve_distance_falloff_preset_SMOOTHER = 9,
	Brush_curve_distance_falloff_preset_SPHERE = 2,
	Brush_curve_distance_falloff_preset_ROOT = 3,
	Brush_curve_distance_falloff_preset_SHARP = 4,
	Brush_curve_distance_falloff_preset_LIN = 5,
	Brush_curve_distance_falloff_preset_POW4 = 6,
	Brush_curve_distance_falloff_preset_INVSQUARE = 7,
	Brush_curve_distance_falloff_preset_CONSTANT = 8,
};

int Brush_curve_distance_falloff_preset_get(PointerRNA *ptr);
void Brush_curve_distance_falloff_preset_set(PointerRNA *ptr, int value);

enum {
	Brush_falloff_shape_SPHERE = 0,
	Brush_falloff_shape_PROJECTED = 1,
};

int Brush_falloff_shape_get(PointerRNA *ptr);
void Brush_falloff_shape_set(PointerRNA *ptr, int value);

float Brush_fill_threshold_get(PointerRNA *ptr);
void Brush_fill_threshold_set(PointerRNA *ptr, float value);

float Brush_flow_get(PointerRNA *ptr);
void Brush_flow_set(PointerRNA *ptr, float value);

enum {
	Brush_cloth_force_falloff_type_RADIAL = 0,
	Brush_cloth_force_falloff_type_PLANE = 1,
};

int Brush_cloth_force_falloff_type_get(PointerRNA *ptr);
void Brush_cloth_force_falloff_type_set(PointerRNA *ptr, int value);

PointerRNA Brush_gpencil_settings_get(PointerRNA *ptr);

bool Brush_use_grab_active_vertex_get(PointerRNA *ptr);
void Brush_use_grab_active_vertex_set(PointerRNA *ptr, bool value);

bool Brush_use_grab_silhouette_get(PointerRNA *ptr);
void Brush_use_grab_silhouette_set(PointerRNA *ptr, bool value);

PointerRNA Brush_gradient_get(PointerRNA *ptr);

enum {
	Brush_gradient_fill_mode_LINEAR = 0,
	Brush_gradient_fill_mode_RADIAL = 1,
};

int Brush_gradient_fill_mode_get(PointerRNA *ptr);
void Brush_gradient_fill_mode_set(PointerRNA *ptr, int value);

int Brush_grad_spacing_get(PointerRNA *ptr);
void Brush_grad_spacing_set(PointerRNA *ptr, int value);

enum {
	Brush_gradient_stroke_mode_PRESSURE = 0,
	Brush_gradient_stroke_mode_SPACING_REPEAT = 1,
	Brush_gradient_stroke_mode_SPACING_CLAMP = 2,
};

int Brush_gradient_stroke_mode_get(PointerRNA *ptr);
void Brush_gradient_stroke_mode_set(PointerRNA *ptr, int value);

float Brush_hardness_get(PointerRNA *ptr);
void Brush_hardness_set(PointerRNA *ptr, float value);

bool Brush_has_unsaved_changes_get(PointerRNA *ptr);
void Brush_has_unsaved_changes_set(PointerRNA *ptr, bool value);

float Brush_plane_height_get(PointerRNA *ptr);
void Brush_plane_height_set(PointerRNA *ptr, float value);

float Brush_hue_jitter_get(PointerRNA *ptr);
void Brush_hue_jitter_set(PointerRNA *ptr, float value);

PointerRNA Brush_image_paint_capabilities_get(PointerRNA *ptr);

int Brush_input_samples_get(PointerRNA *ptr);
void Brush_input_samples_set(PointerRNA *ptr, int value);

bool Brush_use_inverse_smooth_pressure_get(PointerRNA *ptr);
void Brush_use_inverse_smooth_pressure_set(PointerRNA *ptr, bool value);

enum {
	Brush_plane_inversion_mode_INVERT_DISPLACEMENT = 0,
	Brush_plane_inversion_mode_SWAP_DEPTH_AND_HEIGHT = 1,
};

int Brush_plane_inversion_mode_get(PointerRNA *ptr);
void Brush_plane_inversion_mode_set(PointerRNA *ptr, int value);

bool Brush_invert_density_pressure_get(PointerRNA *ptr);
void Brush_invert_density_pressure_set(PointerRNA *ptr, bool value);

bool Brush_invert_flow_pressure_get(PointerRNA *ptr);
void Brush_invert_flow_pressure_set(PointerRNA *ptr, bool value);

bool Brush_invert_hardness_pressure_get(PointerRNA *ptr);
void Brush_invert_hardness_pressure_set(PointerRNA *ptr, bool value);

bool Brush_invert_wet_mix_pressure_get(PointerRNA *ptr);
void Brush_invert_wet_mix_pressure_set(PointerRNA *ptr, bool value);

bool Brush_invert_wet_persistence_pressure_get(PointerRNA *ptr);
void Brush_invert_wet_persistence_pressure_set(PointerRNA *ptr, bool value);

bool Brush_invert_to_scrape_fill_get(PointerRNA *ptr);
void Brush_invert_to_scrape_fill_set(PointerRNA *ptr, bool value);

bool Brush_use_automasking_cavity_inverted_get(PointerRNA *ptr);
void Brush_use_automasking_cavity_inverted_set(PointerRNA *ptr, bool value);

int Brush_surface_smooth_iterations_get(PointerRNA *ptr);
void Brush_surface_smooth_iterations_set(PointerRNA *ptr, int value);

float Brush_jitter_get(PointerRNA *ptr);
void Brush_jitter_set(PointerRNA *ptr, float value);

int Brush_jitter_absolute_get(PointerRNA *ptr);
void Brush_jitter_absolute_set(PointerRNA *ptr, int value);

bool Brush_use_pressure_jitter_get(PointerRNA *ptr);
void Brush_use_pressure_jitter_set(PointerRNA *ptr, bool value);

enum {
	Brush_jitter_unit_VIEW = 1073741824,
	Brush_jitter_unit_BRUSH = 0,
};

int Brush_jitter_unit_get(PointerRNA *ptr);
void Brush_jitter_unit_set(PointerRNA *ptr, int value);

bool Brush_use_pose_ik_anchored_get(PointerRNA *ptr);
void Brush_use_pose_ik_anchored_set(PointerRNA *ptr, bool value);

int Brush_blur_kernel_radius_get(PointerRNA *ptr);
void Brush_blur_kernel_radius_set(PointerRNA *ptr, int value);

bool Brush_use_line_get(PointerRNA *ptr);
void Brush_use_line_set(PointerRNA *ptr, bool value);

bool Brush_use_pose_lock_rotation_get(PointerRNA *ptr);
void Brush_use_pose_lock_rotation_set(PointerRNA *ptr, bool value);

enum {
	Brush_use_pressure_masking_NONE = 0,
	Brush_use_pressure_masking_RAMP = 2,
	Brush_use_pressure_masking_CUTOFF = 4,
};

int Brush_use_pressure_masking_get(PointerRNA *ptr);
void Brush_use_pressure_masking_set(PointerRNA *ptr, int value);

void Brush_mask_stencil_dimension_get(PointerRNA *ptr, float values[2]);
void Brush_mask_stencil_dimension_set(PointerRNA *ptr, const float values[2]);

void Brush_mask_stencil_pos_get(PointerRNA *ptr, float values[2]);
void Brush_mask_stencil_pos_set(PointerRNA *ptr, const float values[2]);

PointerRNA Brush_mask_texture_get(PointerRNA *ptr);

int Brush_mask_overlay_alpha_get(PointerRNA *ptr);
void Brush_mask_overlay_alpha_set(PointerRNA *ptr, int value);

int Brush_cursor_overlay_alpha_get(PointerRNA *ptr);
void Brush_cursor_overlay_alpha_set(PointerRNA *ptr, int value);

PointerRNA Brush_mask_texture_slot_get(PointerRNA *ptr);

enum {
	Brush_mask_tool_DRAW = 0,
	Brush_mask_tool_SMOOTH = 1,
};

int Brush_mask_tool_get(PointerRNA *ptr);
void Brush_mask_tool_set(PointerRNA *ptr, int value);

float Brush_disconnected_distance_max_get(PointerRNA *ptr);
void Brush_disconnected_distance_max_set(PointerRNA *ptr, float value);

bool Brush_use_automasking_boundary_edges_get(PointerRNA *ptr);
void Brush_use_automasking_boundary_edges_set(PointerRNA *ptr, bool value);

float Brush_normal_radius_factor_get(PointerRNA *ptr);
void Brush_normal_radius_factor_set(PointerRNA *ptr, float value);

float Brush_normal_weight_get(PointerRNA *ptr);
void Brush_normal_weight_set(PointerRNA *ptr, float value);

bool Brush_use_automasking_view_occlusion_get(PointerRNA *ptr);
void Brush_use_automasking_view_occlusion_set(PointerRNA *ptr, bool value);

bool Brush_use_original_normal_get(PointerRNA *ptr);
void Brush_use_original_normal_set(PointerRNA *ptr, bool value);

bool Brush_use_original_plane_get(PointerRNA *ptr);
void Brush_use_original_plane_set(PointerRNA *ptr, bool value);

bool Brush_use_cursor_overlay_override_get(PointerRNA *ptr);
void Brush_use_cursor_overlay_override_set(PointerRNA *ptr, bool value);

bool Brush_use_primary_overlay_override_get(PointerRNA *ptr);
void Brush_use_primary_overlay_override_set(PointerRNA *ptr, bool value);

bool Brush_use_secondary_overlay_override_get(PointerRNA *ptr);
void Brush_use_secondary_overlay_override_set(PointerRNA *ptr, bool value);

PointerRNA Brush_paint_curve_get(PointerRNA *ptr);

float Brush_surface_smooth_current_vertex_get(PointerRNA *ptr);
void Brush_surface_smooth_current_vertex_set(PointerRNA *ptr, float value);

bool Brush_use_persistent_get(PointerRNA *ptr);
void Brush_use_persistent_set(PointerRNA *ptr, bool value);

bool Brush_use_cloth_pin_simulation_boundary_get(PointerRNA *ptr);
void Brush_use_cloth_pin_simulation_boundary_set(PointerRNA *ptr, bool value);

float Brush_multiplane_scrape_angle_get(PointerRNA *ptr);
void Brush_multiplane_scrape_angle_set(PointerRNA *ptr, float value);

float Brush_plane_offset_get(PointerRNA *ptr);
void Brush_plane_offset_set(PointerRNA *ptr, float value);

bool Brush_use_offset_pressure_get(PointerRNA *ptr);
void Brush_use_offset_pressure_set(PointerRNA *ptr, bool value);

float Brush_plane_trim_get(PointerRNA *ptr);
void Brush_plane_trim_set(PointerRNA *ptr, float value);

int Brush_pose_ik_segments_get(PointerRNA *ptr);
void Brush_pose_ik_segments_set(PointerRNA *ptr, int value);

float Brush_pose_offset_get(PointerRNA *ptr);
void Brush_pose_offset_set(PointerRNA *ptr, float value);

PointerRNA Brush_curve_jitter_get(PointerRNA *ptr);

PointerRNA Brush_curve_size_get(PointerRNA *ptr);

PointerRNA Brush_curve_strength_get(PointerRNA *ptr);

int Brush_automasking_boundary_edges_propagation_steps_get(PointerRNA *ptr);
void Brush_automasking_boundary_edges_propagation_steps_set(PointerRNA *ptr, int value);

float Brush_rake_factor_get(PointerRNA *ptr);
void Brush_rake_factor_set(PointerRNA *ptr, float value);

PointerRNA Brush_curve_random_hue_get(PointerRNA *ptr);

PointerRNA Brush_curve_random_saturation_get(PointerRNA *ptr);

PointerRNA Brush_curve_random_value_get(PointerRNA *ptr);

float Brush_rate_get(PointerRNA *ptr);
void Brush_rate_set(PointerRNA *ptr, float value);

bool Brush_use_restore_mesh_get(PointerRNA *ptr);
void Brush_use_restore_mesh_set(PointerRNA *ptr, bool value);

enum {
	Brush_pose_origin_type_TOPOLOGY = 0,
	Brush_pose_origin_type_FACE_SETS = 1,
	Brush_pose_origin_type_FACE_SETS_FK = 2,
};

int Brush_pose_origin_type_get(PointerRNA *ptr);
void Brush_pose_origin_type_set(PointerRNA *ptr, int value);

float Brush_saturation_jitter_get(PointerRNA *ptr);
void Brush_saturation_jitter_set(PointerRNA *ptr, float value);

PointerRNA Brush_sculpt_capabilities_get(PointerRNA *ptr);

enum {
	Brush_sculpt_plane_AREA = 0,
	Brush_sculpt_plane_VIEW = 1,
	Brush_sculpt_plane_X = 2,
	Brush_sculpt_plane_Y = 3,
	Brush_sculpt_plane_Z = 4,
};

int Brush_sculpt_plane_get(PointerRNA *ptr);
void Brush_sculpt_plane_set(PointerRNA *ptr, int value);

void Brush_secondary_color_get(PointerRNA *ptr, float values[3]);
void Brush_secondary_color_set(PointerRNA *ptr, const float values[3]);

float Brush_surface_smooth_shape_preservation_get(PointerRNA *ptr);
void Brush_surface_smooth_shape_preservation_set(PointerRNA *ptr, float value);

float Brush_sharp_threshold_get(PointerRNA *ptr);
void Brush_sharp_threshold_set(PointerRNA *ptr, float value);

bool Brush_show_multiplane_scrape_planes_preview_get(PointerRNA *ptr);
void Brush_show_multiplane_scrape_planes_preview_set(PointerRNA *ptr, bool value);

enum {
	Brush_cloth_simulation_area_type_LOCAL = 0,
	Brush_cloth_simulation_area_type_GLOBAL = 1,
	Brush_cloth_simulation_area_type_DYNAMIC = 2,
};

int Brush_cloth_simulation_area_type_get(PointerRNA *ptr);
void Brush_cloth_simulation_area_type_set(PointerRNA *ptr, int value);

float Brush_cloth_sim_falloff_get(PointerRNA *ptr);
void Brush_cloth_sim_falloff_set(PointerRNA *ptr, float value);

float Brush_cloth_sim_limit_get(PointerRNA *ptr);
void Brush_cloth_sim_limit_set(PointerRNA *ptr, float value);

int Brush_size_get(PointerRNA *ptr);
void Brush_size_set(PointerRNA *ptr, int value);

bool Brush_use_pressure_size_get(PointerRNA *ptr);
void Brush_use_pressure_size_set(PointerRNA *ptr, bool value);

enum {
	Brush_use_locked_size_VIEW = 0,
	Brush_use_locked_size_SCENE = 1048576,
};

int Brush_use_locked_size_get(PointerRNA *ptr);
void Brush_use_locked_size_set(PointerRNA *ptr, int value);

int Brush_pose_smooth_iterations_get(PointerRNA *ptr);
void Brush_pose_smooth_iterations_set(PointerRNA *ptr, int value);

bool Brush_use_smooth_stroke_get(PointerRNA *ptr);
void Brush_use_smooth_stroke_set(PointerRNA *ptr, bool value);

float Brush_smooth_stroke_factor_get(PointerRNA *ptr);
void Brush_smooth_stroke_factor_set(PointerRNA *ptr, float value);

int Brush_smooth_stroke_radius_get(PointerRNA *ptr);
void Brush_smooth_stroke_radius_set(PointerRNA *ptr, int value);

float Brush_cloth_constraint_softbody_strength_get(PointerRNA *ptr);
void Brush_cloth_constraint_softbody_strength_set(PointerRNA *ptr, float value);

bool Brush_use_space_get(PointerRNA *ptr);
void Brush_use_space_set(PointerRNA *ptr, bool value);

int Brush_spacing_get(PointerRNA *ptr);
void Brush_spacing_set(PointerRNA *ptr, int value);

enum {
	Brush_use_scene_spacing_VIEW = 0,
	Brush_use_scene_spacing_SCENE = 131072,
};

int Brush_use_scene_spacing_get(PointerRNA *ptr);
void Brush_use_scene_spacing_set(PointerRNA *ptr, int value);

bool Brush_use_pressure_spacing_get(PointerRNA *ptr);
void Brush_use_pressure_spacing_set(PointerRNA *ptr, bool value);

float Brush_stabilize_normal_get(PointerRNA *ptr);
void Brush_stabilize_normal_set(PointerRNA *ptr, float value);

float Brush_stabilize_plane_get(PointerRNA *ptr);
void Brush_stabilize_plane_set(PointerRNA *ptr, float value);

void Brush_stencil_dimension_get(PointerRNA *ptr, float values[2]);
void Brush_stencil_dimension_set(PointerRNA *ptr, const float values[2]);

void Brush_stencil_pos_get(PointerRNA *ptr, float values[2]);
void Brush_stencil_pos_set(PointerRNA *ptr, const float values[2]);

float Brush_strength_get(PointerRNA *ptr);
void Brush_strength_set(PointerRNA *ptr, float value);

bool Brush_use_pressure_strength_get(PointerRNA *ptr);
void Brush_use_pressure_strength_set(PointerRNA *ptr, bool value);

enum {
	Brush_stroke_method_DOTS = 0,
	Brush_stroke_method_DRAG_DOT = 8388608,
	Brush_stroke_method_SPACE = 1024,
	Brush_stroke_method_AIRBRUSH = 1,
	Brush_stroke_method_ANCHORED = 256,
	Brush_stroke_method_LINE = 536870912,
	Brush_stroke_method_CURVE = -2147483648,
};

int Brush_stroke_method_get(PointerRNA *ptr);
void Brush_stroke_method_set(PointerRNA *ptr, int value);

bool Brush_use_stroke_random_hue_get(PointerRNA *ptr);
void Brush_use_stroke_random_hue_set(PointerRNA *ptr, bool value);

bool Brush_use_stroke_random_sat_get(PointerRNA *ptr);
void Brush_use_stroke_random_sat_set(PointerRNA *ptr, bool value);

bool Brush_use_stroke_random_val_get(PointerRNA *ptr);
void Brush_use_stroke_random_val_set(PointerRNA *ptr, bool value);

void Brush_cursor_color_subtract_get(PointerRNA *ptr, float values[4]);
void Brush_cursor_color_subtract_set(PointerRNA *ptr, const float values[4]);

PointerRNA Brush_texture_get(PointerRNA *ptr);

int Brush_texture_overlay_alpha_get(PointerRNA *ptr);
void Brush_texture_overlay_alpha_set(PointerRNA *ptr, int value);

float Brush_texture_sample_bias_get(PointerRNA *ptr);
void Brush_texture_sample_bias_set(PointerRNA *ptr, float value);

PointerRNA Brush_texture_slot_get(PointerRNA *ptr);

float Brush_tilt_strength_factor_get(PointerRNA *ptr);
void Brush_tilt_strength_factor_set(PointerRNA *ptr, float value);

float Brush_tip_roundness_get(PointerRNA *ptr);
void Brush_tip_roundness_set(PointerRNA *ptr, float value);

float Brush_tip_scale_x_get(PointerRNA *ptr);
void Brush_tip_scale_x_set(PointerRNA *ptr, float value);

bool Brush_use_automasking_topology_get(PointerRNA *ptr);
void Brush_use_automasking_topology_set(PointerRNA *ptr, bool value);

float Brush_topology_rake_factor_get(PointerRNA *ptr);
void Brush_topology_rake_factor_set(PointerRNA *ptr, float value);

float Brush_unprojected_size_get(PointerRNA *ptr);
void Brush_unprojected_size_set(PointerRNA *ptr, float value);

bool Brush_use_color_jitter_get(PointerRNA *ptr);
void Brush_use_color_jitter_set(PointerRNA *ptr, bool value);

bool Brush_use_cursor_overlay_get(PointerRNA *ptr);
void Brush_use_cursor_overlay_set(PointerRNA *ptr, bool value);

bool Brush_use_frontface_get(PointerRNA *ptr);
void Brush_use_frontface_set(PointerRNA *ptr, bool value);

bool Brush_use_frontface_falloff_get(PointerRNA *ptr);
void Brush_use_frontface_falloff_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_grease_pencil_get(PointerRNA *ptr);
void Brush_use_paint_grease_pencil_set(PointerRNA *ptr, bool value);

bool Brush_use_plane_trim_get(PointerRNA *ptr);
void Brush_use_plane_trim_set(PointerRNA *ptr, bool value);

bool Brush_use_random_press_hue_get(PointerRNA *ptr);
void Brush_use_random_press_hue_set(PointerRNA *ptr, bool value);

bool Brush_use_random_press_sat_get(PointerRNA *ptr);
void Brush_use_random_press_sat_set(PointerRNA *ptr, bool value);

bool Brush_use_random_press_val_get(PointerRNA *ptr);
void Brush_use_random_press_val_set(PointerRNA *ptr, bool value);

bool Brush_use_density_pressure_get(PointerRNA *ptr);
void Brush_use_density_pressure_set(PointerRNA *ptr, bool value);

bool Brush_use_flow_pressure_get(PointerRNA *ptr);
void Brush_use_flow_pressure_set(PointerRNA *ptr, bool value);

bool Brush_use_hardness_pressure_get(PointerRNA *ptr);
void Brush_use_hardness_pressure_set(PointerRNA *ptr, bool value);

bool Brush_use_wet_mix_pressure_get(PointerRNA *ptr);
void Brush_use_wet_mix_pressure_set(PointerRNA *ptr, bool value);

bool Brush_use_wet_persistence_pressure_get(PointerRNA *ptr);
void Brush_use_wet_persistence_pressure_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_sculpt_get(PointerRNA *ptr);
void Brush_use_paint_sculpt_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_sculpt_curves_get(PointerRNA *ptr);
void Brush_use_paint_sculpt_curves_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_image_get(PointerRNA *ptr);
void Brush_use_paint_image_set(PointerRNA *ptr, bool value);

bool Brush_use_primary_overlay_get(PointerRNA *ptr);
void Brush_use_primary_overlay_set(PointerRNA *ptr, bool value);

bool Brush_use_secondary_overlay_get(PointerRNA *ptr);
void Brush_use_secondary_overlay_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_uv_sculpt_get(PointerRNA *ptr);
void Brush_use_paint_uv_sculpt_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_vertex_get(PointerRNA *ptr);
void Brush_use_paint_vertex_set(PointerRNA *ptr, bool value);

bool Brush_use_vertex_grease_pencil_get(PointerRNA *ptr);
void Brush_use_vertex_grease_pencil_set(PointerRNA *ptr, bool value);

bool Brush_use_paint_weight_get(PointerRNA *ptr);
void Brush_use_paint_weight_set(PointerRNA *ptr, bool value);

float Brush_value_jitter_get(PointerRNA *ptr);
void Brush_value_jitter_set(PointerRNA *ptr, float value);

bool Brush_use_color_as_displacement_get(PointerRNA *ptr);
void Brush_use_color_as_displacement_set(PointerRNA *ptr, bool value);

PointerRNA Brush_vertex_paint_capabilities_get(PointerRNA *ptr);

bool Brush_use_automasking_view_normal_get(PointerRNA *ptr);
void Brush_use_automasking_view_normal_set(PointerRNA *ptr, bool value);

float Brush_automasking_view_normal_falloff_get(PointerRNA *ptr);
void Brush_automasking_view_normal_falloff_set(PointerRNA *ptr, float value);

float Brush_automasking_view_normal_limit_get(PointerRNA *ptr);
void Brush_automasking_view_normal_limit_set(PointerRNA *ptr, float value);

float Brush_elastic_deform_volume_preservation_get(PointerRNA *ptr);
void Brush_elastic_deform_volume_preservation_set(PointerRNA *ptr, float value);

float Brush_weight_get(PointerRNA *ptr);
void Brush_weight_set(PointerRNA *ptr, float value);

PointerRNA Brush_weight_paint_capabilities_get(PointerRNA *ptr);

float Brush_wet_mix_get(PointerRNA *ptr);
void Brush_wet_mix_set(PointerRNA *ptr, float value);

float Brush_wet_paint_radius_factor_get(PointerRNA *ptr);
void Brush_wet_paint_radius_factor_set(PointerRNA *ptr, float value);

float Brush_wet_persistence_get(PointerRNA *ptr);
void Brush_wet_persistence_set(PointerRNA *ptr, float value);

/**************** Brush Capabilities ****************/

extern StructRNA RNA_BrushCapabilities;

PointerRNA BrushCapabilities_rna_type_get(PointerRNA *ptr);

bool BrushCapabilities_has_overlay_get(PointerRNA *ptr);
void BrushCapabilities_has_overlay_set(PointerRNA *ptr, bool value);

bool BrushCapabilities_has_random_texture_angle_get(PointerRNA *ptr);
void BrushCapabilities_has_random_texture_angle_set(PointerRNA *ptr, bool value);

bool BrushCapabilities_has_smooth_stroke_get(PointerRNA *ptr);
void BrushCapabilities_has_smooth_stroke_set(PointerRNA *ptr, bool value);

bool BrushCapabilities_has_spacing_get(PointerRNA *ptr);
void BrushCapabilities_has_spacing_set(PointerRNA *ptr, bool value);

/**************** Image Paint Capabilities ****************/

extern StructRNA RNA_BrushCapabilitiesImagePaint;

PointerRNA BrushCapabilitiesImagePaint_rna_type_get(PointerRNA *ptr);

bool BrushCapabilitiesImagePaint_has_accumulate_get(PointerRNA *ptr);
void BrushCapabilitiesImagePaint_has_accumulate_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesImagePaint_has_color_get(PointerRNA *ptr);
void BrushCapabilitiesImagePaint_has_color_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesImagePaint_has_radius_get(PointerRNA *ptr);
void BrushCapabilitiesImagePaint_has_radius_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesImagePaint_has_space_attenuation_get(PointerRNA *ptr);
void BrushCapabilitiesImagePaint_has_space_attenuation_set(PointerRNA *ptr, bool value);

/**************** Sculpt Capabilities ****************/

extern StructRNA RNA_BrushCapabilitiesSculpt;

PointerRNA BrushCapabilitiesSculpt_rna_type_get(PointerRNA *ptr);

bool BrushCapabilitiesSculpt_has_accumulate_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_accumulate_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_auto_smooth_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_auto_smooth_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_auto_smooth_pressure_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_auto_smooth_pressure_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_color_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_color_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_normal_weight_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_normal_weight_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_direction_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_direction_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_dyntopo_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_dyntopo_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_gravity_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_gravity_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_hardness_pressure_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_hardness_pressure_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_height_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_height_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_jitter_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_jitter_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_persistence_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_persistence_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_pinch_factor_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_pinch_factor_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_plane_depth_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_plane_depth_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_plane_height_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_plane_height_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_plane_offset_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_plane_offset_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_rake_factor_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_rake_factor_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_random_texture_angle_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_random_texture_angle_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_sculpt_plane_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_sculpt_plane_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_secondary_color_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_secondary_color_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_size_pressure_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_size_pressure_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_smooth_stroke_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_smooth_stroke_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_space_attenuation_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_space_attenuation_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_strength_pressure_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_strength_pressure_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_tilt_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_tilt_set(PointerRNA *ptr, bool value);

bool BrushCapabilitiesSculpt_has_topology_rake_get(PointerRNA *ptr);
void BrushCapabilitiesSculpt_has_topology_rake_set(PointerRNA *ptr, bool value);

/**************** Vertex Paint Capabilities ****************/

extern StructRNA RNA_BrushCapabilitiesVertexPaint;

PointerRNA BrushCapabilitiesVertexPaint_rna_type_get(PointerRNA *ptr);

bool BrushCapabilitiesVertexPaint_has_color_get(PointerRNA *ptr);
void BrushCapabilitiesVertexPaint_has_color_set(PointerRNA *ptr, bool value);

/**************** Weight Paint Capabilities ****************/

extern StructRNA RNA_BrushCapabilitiesWeightPaint;

PointerRNA BrushCapabilitiesWeightPaint_rna_type_get(PointerRNA *ptr);

bool BrushCapabilitiesWeightPaint_has_weight_get(PointerRNA *ptr);
void BrushCapabilitiesWeightPaint_has_weight_set(PointerRNA *ptr, bool value);

/**************** Curves Sculpt Brush Settings ****************/

extern StructRNA RNA_BrushCurvesSculptSettings;

PointerRNA BrushCurvesSculptSettings_rna_type_get(PointerRNA *ptr);

int BrushCurvesSculptSettings_add_amount_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_add_amount_set(PointerRNA *ptr, int value);

float BrushCurvesSculptSettings_curve_length_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_curve_length_set(PointerRNA *ptr, float value);

PointerRNA BrushCurvesSculptSettings_curve_parameter_falloff_get(PointerRNA *ptr);

float BrushCurvesSculptSettings_curve_radius_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_curve_radius_set(PointerRNA *ptr, float value);

int BrushCurvesSculptSettings_density_add_attempts_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_density_add_attempts_set(PointerRNA *ptr, int value);

enum {
	BrushCurvesSculptSettings_density_mode_AUTO = 0,
	BrushCurvesSculptSettings_density_mode_ADD = 1,
	BrushCurvesSculptSettings_density_mode_REMOVE = 2,
};

int BrushCurvesSculptSettings_density_mode_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_density_mode_set(PointerRNA *ptr, int value);

bool BrushCurvesSculptSettings_use_length_interpolate_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_use_length_interpolate_set(PointerRNA *ptr, bool value);

bool BrushCurvesSculptSettings_use_point_count_interpolate_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_use_point_count_interpolate_set(PointerRNA *ptr, bool value);

bool BrushCurvesSculptSettings_use_radius_interpolate_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_use_radius_interpolate_set(PointerRNA *ptr, bool value);

bool BrushCurvesSculptSettings_use_shape_interpolate_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_use_shape_interpolate_set(PointerRNA *ptr, bool value);

float BrushCurvesSculptSettings_minimum_distance_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_minimum_distance_set(PointerRNA *ptr, float value);

float BrushCurvesSculptSettings_minimum_length_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_minimum_length_set(PointerRNA *ptr, float value);

int BrushCurvesSculptSettings_points_per_curve_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_points_per_curve_set(PointerRNA *ptr, int value);

bool BrushCurvesSculptSettings_use_uniform_scale_get(PointerRNA *ptr);
void BrushCurvesSculptSettings_use_uniform_scale_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Brush Settings ****************/

extern StructRNA RNA_BrushGpencilSettings;

PointerRNA BrushGpencilSettings_rna_type_get(PointerRNA *ptr);

bool BrushGpencilSettings_use_active_layer_only_get(PointerRNA *ptr);
void BrushGpencilSettings_use_active_layer_only_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_active_smooth_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_active_smooth_factor_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_edit_position_get(PointerRNA *ptr);
void BrushGpencilSettings_use_edit_position_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_edit_strength_get(PointerRNA *ptr);
void BrushGpencilSettings_use_edit_strength_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_eraser_strength_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_eraser_strength_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_eraser_thickness_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_eraser_thickness_factor_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_edit_thickness_get(PointerRNA *ptr);
void BrushGpencilSettings_use_edit_thickness_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_edit_uv_get(PointerRNA *ptr);
void BrushGpencilSettings_use_edit_uv_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_angle_get(PointerRNA *ptr);
void BrushGpencilSettings_angle_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_angle_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_angle_factor_set(PointerRNA *ptr, float value);

void BrushGpencilSettings_aspect_get(PointerRNA *ptr, float values[2]);
void BrushGpencilSettings_aspect_set(PointerRNA *ptr, const float values[2]);

bool BrushGpencilSettings_use_auto_remove_fill_guides_get(PointerRNA *ptr);
void BrushGpencilSettings_use_auto_remove_fill_guides_set(PointerRNA *ptr, bool value);

enum {
	BrushGpencilSettings_caps_type_ROUND = 0,
	BrushGpencilSettings_caps_type_FLAT = 1,
};

int BrushGpencilSettings_caps_type_get(PointerRNA *ptr);
void BrushGpencilSettings_caps_type_set(PointerRNA *ptr, int value);

enum {
	BrushGpencilSettings_fill_extend_mode_EXTEND = 0,
	BrushGpencilSettings_fill_extend_mode_RADIUS = 1,
};

int BrushGpencilSettings_fill_extend_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_extend_mode_set(PointerRNA *ptr, int value);

float BrushGpencilSettings_extend_stroke_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_extend_stroke_factor_set(PointerRNA *ptr, float value);

PointerRNA BrushGpencilSettings_curve_jitter_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_sensitivity_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_strength_get(PointerRNA *ptr);

int BrushGpencilSettings_dilate_get(PointerRNA *ptr);
void BrushGpencilSettings_dilate_set(PointerRNA *ptr, int value);

enum {
	BrushGpencilSettings_fill_direction_NORMAL = 0,
	BrushGpencilSettings_fill_direction_INVERT = 512,
};

int BrushGpencilSettings_fill_direction_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_direction_set(PointerRNA *ptr, int value);

float BrushGpencilSettings_hardness_get(PointerRNA *ptr);
void BrushGpencilSettings_hardness_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_random_hue_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_random_hue_factor_set(PointerRNA *ptr, float value);

int BrushGpencilSettings_input_samples_get(PointerRNA *ptr);
void BrushGpencilSettings_input_samples_set(PointerRNA *ptr, int value);

int BrushGpencilSettings_pen_smooth_steps_get(PointerRNA *ptr);
void BrushGpencilSettings_pen_smooth_steps_set(PointerRNA *ptr, int value);

float BrushGpencilSettings_pen_jitter_get(PointerRNA *ptr);
void BrushGpencilSettings_pen_jitter_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_keep_caps_eraser_get(PointerRNA *ptr);
void BrushGpencilSettings_use_keep_caps_eraser_set(PointerRNA *ptr, bool value);

enum {
	BrushGpencilSettings_fill_layer_mode_VISIBLE = 0,
	BrushGpencilSettings_fill_layer_mode_ACTIVE = 1,
	BrushGpencilSettings_fill_layer_mode_ABOVE = 4,
	BrushGpencilSettings_fill_layer_mode_BELOW = 5,
	BrushGpencilSettings_fill_layer_mode_ALL_ABOVE = 2,
	BrushGpencilSettings_fill_layer_mode_ALL_BELOW = 3,
};

int BrushGpencilSettings_fill_layer_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_layer_mode_set(PointerRNA *ptr, int value);

bool BrushGpencilSettings_use_fill_limit_get(PointerRNA *ptr);
void BrushGpencilSettings_use_fill_limit_set(PointerRNA *ptr, bool value);

PointerRNA BrushGpencilSettings_material_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_material_alt_get(PointerRNA *ptr);

enum {
	BrushGpencilSettings_eraser_mode_SOFT = 0,
	BrushGpencilSettings_eraser_mode_HARD = 1,
	BrushGpencilSettings_eraser_mode_STROKE = 2,
};

int BrushGpencilSettings_eraser_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_eraser_mode_set(PointerRNA *ptr, int value);

enum {
	BrushGpencilSettings_fill_draw_mode_BOTH = 0,
	BrushGpencilSettings_fill_draw_mode_STROKE = 1,
	BrushGpencilSettings_fill_draw_mode_CONTROL = 2,
};

int BrushGpencilSettings_fill_draw_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_draw_mode_set(PointerRNA *ptr, int value);

enum {
	BrushGpencilSettings_brush_draw_mode_ACTIVE = 0,
	BrushGpencilSettings_brush_draw_mode_MATERIAL = 1,
	BrushGpencilSettings_brush_draw_mode_VERTEXCOLOR = 2,
};

int BrushGpencilSettings_brush_draw_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_brush_draw_mode_set(PointerRNA *ptr, int value);

enum {
	BrushGpencilSettings_vertex_mode_STROKE = 0,
	BrushGpencilSettings_vertex_mode_FILL = 1,
	BrushGpencilSettings_vertex_mode_BOTH = 2,
};

int BrushGpencilSettings_vertex_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_vertex_mode_set(PointerRNA *ptr, int value);

bool BrushGpencilSettings_use_occlude_eraser_get(PointerRNA *ptr);
void BrushGpencilSettings_use_occlude_eraser_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_settings_outline_get(PointerRNA *ptr);
void BrushGpencilSettings_use_settings_outline_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_material_pin_get(PointerRNA *ptr);
void BrushGpencilSettings_use_material_pin_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_pin_draw_mode_get(PointerRNA *ptr);
void BrushGpencilSettings_pin_draw_mode_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_fill_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_random_pressure_get(PointerRNA *ptr);
void BrushGpencilSettings_random_pressure_set(PointerRNA *ptr, float value);

PointerRNA BrushGpencilSettings_curve_random_pressure_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_random_strength_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_random_uv_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_random_hue_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_random_saturation_get(PointerRNA *ptr);

PointerRNA BrushGpencilSettings_curve_random_value_get(PointerRNA *ptr);

bool BrushGpencilSettings_use_settings_random_get(PointerRNA *ptr);
void BrushGpencilSettings_use_settings_random_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_random_saturation_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_random_saturation_factor_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_show_fill_get(PointerRNA *ptr);
void BrushGpencilSettings_show_fill_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_show_lasso_get(PointerRNA *ptr);
void BrushGpencilSettings_show_lasso_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_show_fill_boundary_get(PointerRNA *ptr);
void BrushGpencilSettings_show_fill_boundary_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_simplify_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_simplify_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_simplify_pixel_threshold_get(PointerRNA *ptr);
void BrushGpencilSettings_simplify_pixel_threshold_set(PointerRNA *ptr, float value);

int BrushGpencilSettings_fill_simplify_level_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_simplify_level_set(PointerRNA *ptr, int value);

float BrushGpencilSettings_pen_smooth_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_pen_smooth_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_pen_strength_get(PointerRNA *ptr);
void BrushGpencilSettings_pen_strength_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_random_strength_get(PointerRNA *ptr);
void BrushGpencilSettings_random_strength_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_stroke_random_hue_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_hue_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_stroke_random_sat_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_sat_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_stroke_random_val_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_val_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_stroke_random_radius_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_radius_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_stroke_random_strength_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_strength_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_stroke_random_uv_get(PointerRNA *ptr);
void BrushGpencilSettings_use_stroke_random_uv_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_collide_strokes_get(PointerRNA *ptr);
void BrushGpencilSettings_use_collide_strokes_set(PointerRNA *ptr, bool value);

int BrushGpencilSettings_pen_subdivision_steps_get(PointerRNA *ptr);
void BrushGpencilSettings_pen_subdivision_steps_set(PointerRNA *ptr, int value);

float BrushGpencilSettings_outline_thickness_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_outline_thickness_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_fill_threshold_get(PointerRNA *ptr);
void BrushGpencilSettings_fill_threshold_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_trim_get(PointerRNA *ptr);
void BrushGpencilSettings_use_trim_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_uv_random_get(PointerRNA *ptr);
void BrushGpencilSettings_uv_random_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_use_settings_postprocess_get(PointerRNA *ptr);
void BrushGpencilSettings_use_settings_postprocess_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_pressure_get(PointerRNA *ptr);
void BrushGpencilSettings_use_pressure_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_hue_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_hue_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_sat_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_sat_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_val_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_val_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_radius_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_radius_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_strength_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_strength_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_random_press_uv_get(PointerRNA *ptr);
void BrushGpencilSettings_use_random_press_uv_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_jitter_pressure_get(PointerRNA *ptr);
void BrushGpencilSettings_use_jitter_pressure_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_strength_pressure_get(PointerRNA *ptr);
void BrushGpencilSettings_use_strength_pressure_set(PointerRNA *ptr, bool value);

bool BrushGpencilSettings_use_settings_stabilizer_get(PointerRNA *ptr);
void BrushGpencilSettings_use_settings_stabilizer_set(PointerRNA *ptr, bool value);

float BrushGpencilSettings_random_value_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_random_value_factor_set(PointerRNA *ptr, float value);

float BrushGpencilSettings_vertex_color_factor_get(PointerRNA *ptr);
void BrushGpencilSettings_vertex_color_factor_set(PointerRNA *ptr, float value);

bool BrushGpencilSettings_show_fill_extend_get(PointerRNA *ptr);
void BrushGpencilSettings_show_fill_extend_set(PointerRNA *ptr, bool value);

/**************** Brush Texture Slot ****************/

extern StructRNA RNA_BrushTextureSlot;
extern StructRNA RNA_TextureSlot;

float BrushTextureSlot_angle_get(PointerRNA *ptr);
void BrushTextureSlot_angle_set(PointerRNA *ptr, float value);

bool BrushTextureSlot_has_random_texture_angle_get(PointerRNA *ptr);
void BrushTextureSlot_has_random_texture_angle_set(PointerRNA *ptr, bool value);

bool BrushTextureSlot_has_texture_angle_source_get(PointerRNA *ptr);
void BrushTextureSlot_has_texture_angle_source_set(PointerRNA *ptr, bool value);

bool BrushTextureSlot_has_texture_angle_get(PointerRNA *ptr);
void BrushTextureSlot_has_texture_angle_set(PointerRNA *ptr, bool value);

enum {
	BrushTextureSlot_map_mode_VIEW_PLANE = 0,
	BrushTextureSlot_map_mode_AREA_PLANE = 3,
	BrushTextureSlot_map_mode_TILED = 1,
	BrushTextureSlot_map_mode_3D = 2,
	BrushTextureSlot_map_mode_RANDOM = 4,
	BrushTextureSlot_map_mode_STENCIL = 5,
};

int BrushTextureSlot_map_mode_get(PointerRNA *ptr);
void BrushTextureSlot_map_mode_set(PointerRNA *ptr, int value);

enum {
	BrushTextureSlot_mask_map_mode_VIEW_PLANE = 0,
	BrushTextureSlot_mask_map_mode_TILED = 1,
	BrushTextureSlot_mask_map_mode_RANDOM = 4,
	BrushTextureSlot_mask_map_mode_STENCIL = 5,
};

int BrushTextureSlot_mask_map_mode_get(PointerRNA *ptr);
void BrushTextureSlot_mask_map_mode_set(PointerRNA *ptr, int value);

bool BrushTextureSlot_use_rake_get(PointerRNA *ptr);
void BrushTextureSlot_use_rake_set(PointerRNA *ptr, bool value);

bool BrushTextureSlot_use_random_get(PointerRNA *ptr);
void BrushTextureSlot_use_random_set(PointerRNA *ptr, bool value);

float BrushTextureSlot_random_angle_get(PointerRNA *ptr);
void BrushTextureSlot_random_angle_set(PointerRNA *ptr, float value);

/**************** Build Modifier ****************/

extern StructRNA RNA_BuildModifier;
extern StructRNA RNA_Modifier;

float BuildModifier_frame_duration_get(PointerRNA *ptr);
void BuildModifier_frame_duration_set(PointerRNA *ptr, float value);

bool BuildModifier_use_random_order_get(PointerRNA *ptr);
void BuildModifier_use_random_order_set(PointerRNA *ptr, bool value);

bool BuildModifier_use_reverse_get(PointerRNA *ptr);
void BuildModifier_use_reverse_set(PointerRNA *ptr, bool value);

int BuildModifier_seed_get(PointerRNA *ptr);
void BuildModifier_seed_set(PointerRNA *ptr, int value);

float BuildModifier_frame_start_get(PointerRNA *ptr);
void BuildModifier_frame_start_set(PointerRNA *ptr, float value);

/**************** Byte Color Attribute ****************/

extern StructRNA RNA_ByteColorAttribute;
extern StructRNA RNA_Attribute;

void ByteColorAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ByteColorAttribute_data_next(CollectionPropertyIterator *iter);
void ByteColorAttribute_data_end(CollectionPropertyIterator *iter);
int ByteColorAttribute_data_length(PointerRNA *ptr);
bool ByteColorAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Byte Color Attribute Value ****************/

extern StructRNA RNA_ByteColorAttributeValue;

PointerRNA ByteColorAttributeValue_rna_type_get(PointerRNA *ptr);

void ByteColorAttributeValue_color_get(PointerRNA *ptr, float values[4]);
void ByteColorAttributeValue_color_set(PointerRNA *ptr, const float values[4]);

void ByteColorAttributeValue_color_srgb_get(PointerRNA *ptr, float values[4]);
void ByteColorAttributeValue_color_srgb_set(PointerRNA *ptr, const float values[4]);

/**************** 8-bit Integer Attribute ****************/

extern StructRNA RNA_ByteIntAttribute;
extern StructRNA RNA_Attribute;

void ByteIntAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ByteIntAttribute_data_next(CollectionPropertyIterator *iter);
void ByteIntAttribute_data_end(CollectionPropertyIterator *iter);
int ByteIntAttribute_data_length(PointerRNA *ptr);
bool ByteIntAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** 8-bit Integer Attribute Value ****************/

extern StructRNA RNA_ByteIntAttributeValue;

PointerRNA ByteIntAttributeValue_rna_type_get(PointerRNA *ptr);

int ByteIntAttributeValue_value_get(PointerRNA *ptr);
void ByteIntAttributeValue_value_set(PointerRNA *ptr, int value);

/**************** CacheFile ****************/

extern StructRNA RNA_CacheFile;
extern StructRNA RNA_ID;

PointerRNA CacheFile_animation_data_get(PointerRNA *ptr);

void CacheFile_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CacheFile_layers_next(CollectionPropertyIterator *iter);
void CacheFile_layers_end(CollectionPropertyIterator *iter);
bool CacheFile_layers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

#define CacheFile_filepath_MAX 1024

void CacheFile_filepath_get(PointerRNA *ptr, char *value);
int CacheFile_filepath_length(PointerRNA *ptr);
void CacheFile_filepath_set(PointerRNA *ptr, const char *value);

enum {
	CacheFile_forward_axis_POS_X = 0,
	CacheFile_forward_axis_POS_Y = 1,
	CacheFile_forward_axis_POS_Z = 2,
	CacheFile_forward_axis_NEG_X = 3,
	CacheFile_forward_axis_NEG_Y = 4,
	CacheFile_forward_axis_NEG_Z = 5,
};

int CacheFile_forward_axis_get(PointerRNA *ptr);
void CacheFile_forward_axis_set(PointerRNA *ptr, int value);

float CacheFile_frame_get(PointerRNA *ptr);
void CacheFile_frame_set(PointerRNA *ptr, float value);

float CacheFile_frame_offset_get(PointerRNA *ptr);
void CacheFile_frame_offset_set(PointerRNA *ptr, float value);

void CacheFile_object_paths_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CacheFile_object_paths_next(CollectionPropertyIterator *iter);
void CacheFile_object_paths_end(CollectionPropertyIterator *iter);
bool CacheFile_object_paths_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool CacheFile_object_paths_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool CacheFile_override_frame_get(PointerRNA *ptr);
void CacheFile_override_frame_set(PointerRNA *ptr, bool value);

float CacheFile_scale_get(PointerRNA *ptr);
void CacheFile_scale_set(PointerRNA *ptr, float value);

bool CacheFile_is_sequence_get(PointerRNA *ptr);
void CacheFile_is_sequence_set(PointerRNA *ptr, bool value);

enum {
	CacheFile_up_axis_POS_X = 0,
	CacheFile_up_axis_POS_Y = 1,
	CacheFile_up_axis_POS_Z = 2,
	CacheFile_up_axis_NEG_X = 3,
	CacheFile_up_axis_NEG_Y = 4,
	CacheFile_up_axis_NEG_Z = 5,
};

int CacheFile_up_axis_get(PointerRNA *ptr);
void CacheFile_up_axis_set(PointerRNA *ptr, int value);

#define CacheFile_velocity_name_MAX 64

void CacheFile_velocity_name_get(PointerRNA *ptr, char *value);
int CacheFile_velocity_name_length(PointerRNA *ptr);
void CacheFile_velocity_name_set(PointerRNA *ptr, const char *value);

enum {
	CacheFile_velocity_unit_SECOND = 1,
	CacheFile_velocity_unit_FRAME = 0,
};

int CacheFile_velocity_unit_get(PointerRNA *ptr);
void CacheFile_velocity_unit_set(PointerRNA *ptr, int value);

int CacheFile_active_index_get(PointerRNA *ptr);
void CacheFile_active_index_set(PointerRNA *ptr, int value);

/**************** Cache Layer ****************/

extern StructRNA RNA_CacheFileLayer;

PointerRNA CacheFileLayer_rna_type_get(PointerRNA *ptr);

#define CacheFileLayer_filepath_MAX 1024

void CacheFileLayer_filepath_get(PointerRNA *ptr, char *value);
int CacheFileLayer_filepath_length(PointerRNA *ptr);
void CacheFileLayer_filepath_set(PointerRNA *ptr, const char *value);

bool CacheFileLayer_hide_layer_get(PointerRNA *ptr);
void CacheFileLayer_hide_layer_set(PointerRNA *ptr, bool value);

/**************** Cache Layers ****************/

extern StructRNA RNA_CacheFileLayers;

PointerRNA CacheFileLayers_rna_type_get(PointerRNA *ptr);

PointerRNA CacheFileLayers_active_get(PointerRNA *ptr);

struct CacheFileLayer *CacheFileLayers_new_func(struct CacheFile *_self, bContext *C, ReportList *reports, const char * filepath);
void CacheFileLayers_remove_func(struct CacheFile *_self, bContext *C, struct PointerRNA *layer);
/**************** Object Path ****************/

extern StructRNA RNA_CacheObjectPath;

PointerRNA CacheObjectPath_rna_type_get(PointerRNA *ptr);

#define CacheObjectPath_path_MAX 4096

void CacheObjectPath_path_get(PointerRNA *ptr, char *value);
int CacheObjectPath_path_length(PointerRNA *ptr);
void CacheObjectPath_path_set(PointerRNA *ptr, const char *value);

/**************** Object Paths ****************/

extern StructRNA RNA_CacheObjectPaths;

PointerRNA CacheObjectPaths_rna_type_get(PointerRNA *ptr);

/**************** Camera ****************/

extern StructRNA RNA_Camera;
extern StructRNA RNA_ID;

PointerRNA Camera_animation_data_get(PointerRNA *ptr);

void Camera_background_images_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Camera_background_images_next(CollectionPropertyIterator *iter);
void Camera_background_images_end(CollectionPropertyIterator *iter);
bool Camera_background_images_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool Camera_show_composition_center_get(PointerRNA *ptr);
void Camera_show_composition_center_set(PointerRNA *ptr, bool value);

bool Camera_show_composition_center_diagonal_get(PointerRNA *ptr);
void Camera_show_composition_center_diagonal_set(PointerRNA *ptr, bool value);

float Camera_clip_end_get(PointerRNA *ptr);
void Camera_clip_end_set(PointerRNA *ptr, float value);

float Camera_clip_start_get(PointerRNA *ptr);
void Camera_clip_start_set(PointerRNA *ptr, float value);

void Camera_composition_guide_color_get(PointerRNA *ptr, float values[4]);
void Camera_composition_guide_color_set(PointerRNA *ptr, const float values[4]);

void Camera_custom_bytecode_get(PointerRNA *ptr, char *value);
int Camera_custom_bytecode_length(PointerRNA *ptr);
void Camera_custom_bytecode_set(PointerRNA *ptr, const char *value);

#define Camera_custom_bytecode_hash_MAX 64

void Camera_custom_bytecode_hash_get(PointerRNA *ptr, char *value);
int Camera_custom_bytecode_hash_length(PointerRNA *ptr);
void Camera_custom_bytecode_hash_set(PointerRNA *ptr, const char *value);

#define Camera_custom_filepath_MAX 1024

void Camera_custom_filepath_get(PointerRNA *ptr, char *value);
int Camera_custom_filepath_length(PointerRNA *ptr);
void Camera_custom_filepath_set(PointerRNA *ptr, const char *value);

PointerRNA Camera_custom_shader_get(PointerRNA *ptr);

enum {
	Camera_custom_mode_INTERNAL = 0,
	Camera_custom_mode_EXTERNAL = 1,
};

int Camera_custom_mode_get(PointerRNA *ptr);
void Camera_custom_mode_set(PointerRNA *ptr, int value);

float Camera_central_cylindrical_radius_get(PointerRNA *ptr);
void Camera_central_cylindrical_radius_set(PointerRNA *ptr, float value);

PointerRNA Camera_dof_get(PointerRNA *ptr);

bool Camera_show_background_images_get(PointerRNA *ptr);
void Camera_show_background_images_set(PointerRNA *ptr, bool value);

float Camera_display_size_get(PointerRNA *ptr);
void Camera_display_size_set(PointerRNA *ptr, float value);

float Camera_angle_get(PointerRNA *ptr);
void Camera_angle_set(PointerRNA *ptr, float value);

float Camera_fisheye_fov_get(PointerRNA *ptr);
void Camera_fisheye_fov_set(PointerRNA *ptr, float value);

float Camera_fisheye_lens_get(PointerRNA *ptr);
void Camera_fisheye_lens_set(PointerRNA *ptr, float value);

float Camera_fisheye_polynomial_k0_get(PointerRNA *ptr);
void Camera_fisheye_polynomial_k0_set(PointerRNA *ptr, float value);

float Camera_fisheye_polynomial_k1_get(PointerRNA *ptr);
void Camera_fisheye_polynomial_k1_set(PointerRNA *ptr, float value);

float Camera_fisheye_polynomial_k2_get(PointerRNA *ptr);
void Camera_fisheye_polynomial_k2_set(PointerRNA *ptr, float value);

float Camera_fisheye_polynomial_k3_get(PointerRNA *ptr);
void Camera_fisheye_polynomial_k3_set(PointerRNA *ptr, float value);

float Camera_fisheye_polynomial_k4_get(PointerRNA *ptr);
void Camera_fisheye_polynomial_k4_set(PointerRNA *ptr, float value);

float Camera_lens_get(PointerRNA *ptr);
void Camera_lens_set(PointerRNA *ptr, float value);

bool Camera_show_composition_golden_get(PointerRNA *ptr);
void Camera_show_composition_golden_set(PointerRNA *ptr, bool value);

bool Camera_show_composition_golden_tria_a_get(PointerRNA *ptr);
void Camera_show_composition_golden_tria_a_set(PointerRNA *ptr, bool value);

bool Camera_show_composition_golden_tria_b_get(PointerRNA *ptr);
void Camera_show_composition_golden_tria_b_set(PointerRNA *ptr, bool value);

bool Camera_show_composition_harmony_tri_a_get(PointerRNA *ptr);
void Camera_show_composition_harmony_tri_a_set(PointerRNA *ptr, bool value);

bool Camera_show_composition_harmony_tri_b_get(PointerRNA *ptr);
void Camera_show_composition_harmony_tri_b_set(PointerRNA *ptr, bool value);

float Camera_angle_x_get(PointerRNA *ptr);
void Camera_angle_x_set(PointerRNA *ptr, float value);

enum {
	Camera_lens_unit_MILLIMETERS = 0,
	Camera_lens_unit_FOV = 32,
};

int Camera_lens_unit_get(PointerRNA *ptr);
void Camera_lens_unit_set(PointerRNA *ptr, int value);

float Camera_central_cylindrical_range_v_max_get(PointerRNA *ptr);
void Camera_central_cylindrical_range_v_max_set(PointerRNA *ptr, float value);

float Camera_latitude_max_get(PointerRNA *ptr);
void Camera_latitude_max_set(PointerRNA *ptr, float value);

float Camera_longitude_max_get(PointerRNA *ptr);
void Camera_longitude_max_set(PointerRNA *ptr, float value);

float Camera_central_cylindrical_range_u_max_get(PointerRNA *ptr);
void Camera_central_cylindrical_range_u_max_set(PointerRNA *ptr, float value);

float Camera_central_cylindrical_range_v_min_get(PointerRNA *ptr);
void Camera_central_cylindrical_range_v_min_set(PointerRNA *ptr, float value);

float Camera_latitude_min_get(PointerRNA *ptr);
void Camera_latitude_min_set(PointerRNA *ptr, float value);

float Camera_longitude_min_get(PointerRNA *ptr);
void Camera_longitude_min_set(PointerRNA *ptr, float value);

float Camera_central_cylindrical_range_u_min_get(PointerRNA *ptr);
void Camera_central_cylindrical_range_u_min_set(PointerRNA *ptr, float value);

float Camera_ortho_scale_get(PointerRNA *ptr);
void Camera_ortho_scale_set(PointerRNA *ptr, float value);

enum {
	Camera_panorama_type_EQUIRECTANGULAR = 0,
	Camera_panorama_type_EQUIANGULAR_CUBEMAP_FACE = 5,
	Camera_panorama_type_MIRRORBALL = 3,
	Camera_panorama_type_FISHEYE_EQUIDISTANT = 1,
	Camera_panorama_type_FISHEYE_EQUISOLID = 2,
	Camera_panorama_type_FISHEYE_LENS_POLYNOMIAL = 4,
	Camera_panorama_type_CENTRAL_CYLINDRICAL = 6,
};

int Camera_panorama_type_get(PointerRNA *ptr);
void Camera_panorama_type_set(PointerRNA *ptr, int value);

float Camera_passepartout_alpha_get(PointerRNA *ptr);
void Camera_passepartout_alpha_set(PointerRNA *ptr, float value);

enum {
	Camera_sensor_fit_AUTO = 0,
	Camera_sensor_fit_HORIZONTAL = 1,
	Camera_sensor_fit_VERTICAL = 2,
};

int Camera_sensor_fit_get(PointerRNA *ptr);
void Camera_sensor_fit_set(PointerRNA *ptr, int value);

float Camera_sensor_height_get(PointerRNA *ptr);
void Camera_sensor_height_set(PointerRNA *ptr, float value);

float Camera_sensor_width_get(PointerRNA *ptr);
void Camera_sensor_width_set(PointerRNA *ptr, float value);

float Camera_shift_x_get(PointerRNA *ptr);
void Camera_shift_x_set(PointerRNA *ptr, float value);

float Camera_shift_y_get(PointerRNA *ptr);
void Camera_shift_y_set(PointerRNA *ptr, float value);

bool Camera_show_safe_center_get(PointerRNA *ptr);
void Camera_show_safe_center_set(PointerRNA *ptr, bool value);

bool Camera_show_limits_get(PointerRNA *ptr);
void Camera_show_limits_set(PointerRNA *ptr, bool value);

bool Camera_show_mist_get(PointerRNA *ptr);
void Camera_show_mist_set(PointerRNA *ptr, bool value);

bool Camera_show_name_get(PointerRNA *ptr);
void Camera_show_name_set(PointerRNA *ptr, bool value);

bool Camera_show_passepartout_get(PointerRNA *ptr);
void Camera_show_passepartout_set(PointerRNA *ptr, bool value);

bool Camera_show_safe_areas_get(PointerRNA *ptr);
void Camera_show_safe_areas_set(PointerRNA *ptr, bool value);

bool Camera_show_sensor_get(PointerRNA *ptr);
void Camera_show_sensor_set(PointerRNA *ptr, bool value);

PointerRNA Camera_stereo_get(PointerRNA *ptr);

bool Camera_show_composition_thirds_get(PointerRNA *ptr);
void Camera_show_composition_thirds_set(PointerRNA *ptr, bool value);

enum {
	Camera_type_PERSP = 0,
	Camera_type_ORTHO = 1,
	Camera_type_PANO = 2,
	Camera_type_CUSTOM = 3,
};

int Camera_type_get(PointerRNA *ptr);
void Camera_type_set(PointerRNA *ptr, int value);

float Camera_angle_y_get(PointerRNA *ptr);
void Camera_angle_y_set(PointerRNA *ptr, float value);

void Camera_view_frame_func(struct Camera *_self, struct Scene *scene, float result_1[3], float result_2[3], float result_3[3], float result_4[3]);
/**************** Background Image ****************/

extern StructRNA RNA_CameraBackgroundImage;

PointerRNA CameraBackgroundImage_rna_type_get(PointerRNA *ptr);

enum {
	CameraBackgroundImage_source_IMAGE = 0,
	CameraBackgroundImage_source_MOVIE_CLIP = 1,
};

int CameraBackgroundImage_source_get(PointerRNA *ptr);
void CameraBackgroundImage_source_set(PointerRNA *ptr, int value);

bool CameraBackgroundImage_use_camera_clip_get(PointerRNA *ptr);
void CameraBackgroundImage_use_camera_clip_set(PointerRNA *ptr, bool value);

PointerRNA CameraBackgroundImage_clip_user_get(PointerRNA *ptr);

enum {
	CameraBackgroundImage_display_depth_BACK = 0,
	CameraBackgroundImage_display_depth_FRONT = 16,
};

int CameraBackgroundImage_display_depth_get(PointerRNA *ptr);
void CameraBackgroundImage_display_depth_set(PointerRNA *ptr, int value);

bool CameraBackgroundImage_use_flip_x_get(PointerRNA *ptr);
void CameraBackgroundImage_use_flip_x_set(PointerRNA *ptr, bool value);

bool CameraBackgroundImage_use_flip_y_get(PointerRNA *ptr);
void CameraBackgroundImage_use_flip_y_set(PointerRNA *ptr, bool value);

enum {
	CameraBackgroundImage_frame_method_STRETCH = 0,
	CameraBackgroundImage_frame_method_FIT = 32,
	CameraBackgroundImage_frame_method_CROP = 96,
};

int CameraBackgroundImage_frame_method_get(PointerRNA *ptr);
void CameraBackgroundImage_frame_method_set(PointerRNA *ptr, int value);

PointerRNA CameraBackgroundImage_image_get(PointerRNA *ptr);

PointerRNA CameraBackgroundImage_image_user_get(PointerRNA *ptr);

PointerRNA CameraBackgroundImage_clip_get(PointerRNA *ptr);

void CameraBackgroundImage_offset_get(PointerRNA *ptr, float values[2]);
void CameraBackgroundImage_offset_set(PointerRNA *ptr, const float values[2]);

float CameraBackgroundImage_alpha_get(PointerRNA *ptr);
void CameraBackgroundImage_alpha_set(PointerRNA *ptr, float value);

bool CameraBackgroundImage_is_override_data_get(PointerRNA *ptr);
void CameraBackgroundImage_is_override_data_set(PointerRNA *ptr, bool value);

float CameraBackgroundImage_rotation_get(PointerRNA *ptr);
void CameraBackgroundImage_rotation_set(PointerRNA *ptr, float value);

float CameraBackgroundImage_scale_get(PointerRNA *ptr);
void CameraBackgroundImage_scale_set(PointerRNA *ptr, float value);

bool CameraBackgroundImage_show_background_image_get(PointerRNA *ptr);
void CameraBackgroundImage_show_background_image_set(PointerRNA *ptr, bool value);

bool CameraBackgroundImage_show_expanded_get(PointerRNA *ptr);
void CameraBackgroundImage_show_expanded_set(PointerRNA *ptr, bool value);

bool CameraBackgroundImage_show_on_foreground_get(PointerRNA *ptr);
void CameraBackgroundImage_show_on_foreground_set(PointerRNA *ptr, bool value);

/**************** Background Images ****************/

extern StructRNA RNA_CameraBackgroundImages;

PointerRNA CameraBackgroundImages_rna_type_get(PointerRNA *ptr);

struct CameraBGImage *CameraBackgroundImages_new_func(struct Camera *_self);
void CameraBackgroundImages_remove_func(struct Camera *_self, ReportList *reports, struct PointerRNA *image);
void CameraBackgroundImages_clear_func(struct Camera *_self);
/**************** Depth of Field ****************/

extern StructRNA RNA_CameraDOFSettings;

PointerRNA CameraDOFSettings_rna_type_get(PointerRNA *ptr);

int CameraDOFSettings_aperture_blades_get(PointerRNA *ptr);
void CameraDOFSettings_aperture_blades_set(PointerRNA *ptr, int value);

bool CameraDOFSettings_use_dof_get(PointerRNA *ptr);
void CameraDOFSettings_use_dof_set(PointerRNA *ptr, bool value);

float CameraDOFSettings_aperture_fstop_get(PointerRNA *ptr);
void CameraDOFSettings_aperture_fstop_set(PointerRNA *ptr, float value);

#define CameraDOFSettings_focus_subtarget_MAX 64

void CameraDOFSettings_focus_subtarget_get(PointerRNA *ptr, char *value);
int CameraDOFSettings_focus_subtarget_length(PointerRNA *ptr);
void CameraDOFSettings_focus_subtarget_set(PointerRNA *ptr, const char *value);

float CameraDOFSettings_focus_distance_get(PointerRNA *ptr);
void CameraDOFSettings_focus_distance_set(PointerRNA *ptr, float value);

PointerRNA CameraDOFSettings_focus_object_get(PointerRNA *ptr);

float CameraDOFSettings_aperture_ratio_get(PointerRNA *ptr);
void CameraDOFSettings_aperture_ratio_set(PointerRNA *ptr, float value);

float CameraDOFSettings_aperture_rotation_get(PointerRNA *ptr);
void CameraDOFSettings_aperture_rotation_set(PointerRNA *ptr, float value);

/**************** Camera Solver Constraint ****************/

extern StructRNA RNA_CameraSolverConstraint;
extern StructRNA RNA_Constraint;

bool CameraSolverConstraint_use_active_clip_get(PointerRNA *ptr);
void CameraSolverConstraint_use_active_clip_set(PointerRNA *ptr, bool value);

PointerRNA CameraSolverConstraint_clip_get(PointerRNA *ptr);

/**************** Stereo ****************/

extern StructRNA RNA_CameraStereoData;

PointerRNA CameraStereoData_rna_type_get(PointerRNA *ptr);

float CameraStereoData_convergence_distance_get(PointerRNA *ptr);
void CameraStereoData_convergence_distance_set(PointerRNA *ptr, float value);

float CameraStereoData_interocular_distance_get(PointerRNA *ptr);
void CameraStereoData_interocular_distance_set(PointerRNA *ptr, float value);

enum {
	CameraStereoData_convergence_mode_OFFAXIS = 0,
	CameraStereoData_convergence_mode_PARALLEL = 1,
	CameraStereoData_convergence_mode_TOE = 2,
};

int CameraStereoData_convergence_mode_get(PointerRNA *ptr);
void CameraStereoData_convergence_mode_set(PointerRNA *ptr, int value);

enum {
	CameraStereoData_pivot_LEFT = 0,
	CameraStereoData_pivot_RIGHT = 1,
	CameraStereoData_pivot_CENTER = 2,
};

int CameraStereoData_pivot_get(PointerRNA *ptr);
void CameraStereoData_pivot_set(PointerRNA *ptr, int value);

float CameraStereoData_pole_merge_angle_to_get(PointerRNA *ptr);
void CameraStereoData_pole_merge_angle_to_set(PointerRNA *ptr, float value);

float CameraStereoData_pole_merge_angle_from_get(PointerRNA *ptr);
void CameraStereoData_pole_merge_angle_from_set(PointerRNA *ptr, float value);

bool CameraStereoData_use_spherical_stereo_get(PointerRNA *ptr);
void CameraStereoData_use_spherical_stereo_set(PointerRNA *ptr, bool value);

bool CameraStereoData_use_pole_merge_get(PointerRNA *ptr);
void CameraStereoData_use_pole_merge_set(PointerRNA *ptr, bool value);

/**************** Cast Modifier ****************/

extern StructRNA RNA_CastModifier;
extern StructRNA RNA_Modifier;

float CastModifier_factor_get(PointerRNA *ptr);
void CastModifier_factor_set(PointerRNA *ptr, float value);

bool CastModifier_invert_vertex_group_get(PointerRNA *ptr);
void CastModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

PointerRNA CastModifier_object_get(PointerRNA *ptr);

float CastModifier_radius_get(PointerRNA *ptr);
void CastModifier_radius_set(PointerRNA *ptr, float value);

enum {
	CastModifier_cast_type_SPHERE = 0,
	CastModifier_cast_type_CYLINDER = 1,
	CastModifier_cast_type_CUBOID = 2,
};

int CastModifier_cast_type_get(PointerRNA *ptr);
void CastModifier_cast_type_set(PointerRNA *ptr, int value);

float CastModifier_size_get(PointerRNA *ptr);
void CastModifier_size_set(PointerRNA *ptr, float value);

bool CastModifier_use_radius_as_size_get(PointerRNA *ptr);
void CastModifier_use_radius_as_size_set(PointerRNA *ptr, bool value);

bool CastModifier_use_transform_get(PointerRNA *ptr);
void CastModifier_use_transform_set(PointerRNA *ptr, bool value);

#define CastModifier_vertex_group_MAX 64

void CastModifier_vertex_group_get(PointerRNA *ptr, char *value);
int CastModifier_vertex_group_length(PointerRNA *ptr);
void CastModifier_vertex_group_set(PointerRNA *ptr, const char *value);

bool CastModifier_use_x_get(PointerRNA *ptr);
void CastModifier_use_x_set(PointerRNA *ptr, bool value);

bool CastModifier_use_y_get(PointerRNA *ptr);
void CastModifier_use_y_set(PointerRNA *ptr, bool value);

bool CastModifier_use_z_get(PointerRNA *ptr);
void CastModifier_use_z_set(PointerRNA *ptr, bool value);

/**************** ChannelDriver Variables ****************/

extern StructRNA RNA_ChannelDriverVariables;

PointerRNA ChannelDriverVariables_rna_type_get(PointerRNA *ptr);

struct DriverVar *ChannelDriverVariables_new_func(struct ChannelDriver *_self);
void ChannelDriverVariables_remove_func(struct ChannelDriver *_self, ReportList *reports, struct PointerRNA *variable);
/**************** Child Of Constraint ****************/

extern StructRNA RNA_ChildOfConstraint;
extern StructRNA RNA_Constraint;

void ChildOfConstraint_inverse_matrix_get(PointerRNA *ptr, float values[16]);
void ChildOfConstraint_inverse_matrix_set(PointerRNA *ptr, const float values[16]);

bool ChildOfConstraint_use_location_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_x_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_location_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_y_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_location_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_location_z_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_rotation_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_x_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_rotation_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_y_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_rotation_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_rotation_z_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_scale_x_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_x_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_scale_y_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_y_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_use_scale_z_get(PointerRNA *ptr);
void ChildOfConstraint_use_scale_z_set(PointerRNA *ptr, bool value);

bool ChildOfConstraint_set_inverse_pending_get(PointerRNA *ptr);
void ChildOfConstraint_set_inverse_pending_set(PointerRNA *ptr, bool value);

#define ChildOfConstraint_subtarget_MAX 64

void ChildOfConstraint_subtarget_get(PointerRNA *ptr, char *value);
int ChildOfConstraint_subtarget_length(PointerRNA *ptr);
void ChildOfConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ChildOfConstraint_target_get(PointerRNA *ptr);

/**************** Child Particle ****************/

extern StructRNA RNA_ChildParticle;

PointerRNA ChildParticle_rna_type_get(PointerRNA *ptr);

/**************** Clamp To Constraint ****************/

extern StructRNA RNA_ClampToConstraint;
extern StructRNA RNA_Constraint;

bool ClampToConstraint_use_cyclic_get(PointerRNA *ptr);
void ClampToConstraint_use_cyclic_set(PointerRNA *ptr, bool value);

enum {
	ClampToConstraint_main_axis_CLAMPTO_AUTO = 0,
	ClampToConstraint_main_axis_CLAMPTO_X = 1,
	ClampToConstraint_main_axis_CLAMPTO_Y = 2,
	ClampToConstraint_main_axis_CLAMPTO_Z = 3,
};

int ClampToConstraint_main_axis_get(PointerRNA *ptr);
void ClampToConstraint_main_axis_set(PointerRNA *ptr, int value);

PointerRNA ClampToConstraint_target_get(PointerRNA *ptr);

/**************** Cloth Collision Settings ****************/

extern StructRNA RNA_ClothCollisionSettings;

PointerRNA ClothCollisionSettings_rna_type_get(PointerRNA *ptr);

PointerRNA ClothCollisionSettings_collection_get(PointerRNA *ptr);

int ClothCollisionSettings_collision_quality_get(PointerRNA *ptr);
void ClothCollisionSettings_collision_quality_set(PointerRNA *ptr, int value);

void ClothCollisionSettings_vertex_group_object_collisions_get(PointerRNA *ptr, char *value);
int ClothCollisionSettings_vertex_group_object_collisions_length(PointerRNA *ptr);
void ClothCollisionSettings_vertex_group_object_collisions_set(PointerRNA *ptr, const char *value);

bool ClothCollisionSettings_use_collision_get(PointerRNA *ptr);
void ClothCollisionSettings_use_collision_set(PointerRNA *ptr, bool value);

bool ClothCollisionSettings_use_self_collision_get(PointerRNA *ptr);
void ClothCollisionSettings_use_self_collision_set(PointerRNA *ptr, bool value);

float ClothCollisionSettings_friction_get(PointerRNA *ptr);
void ClothCollisionSettings_friction_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_impulse_clamp_get(PointerRNA *ptr);
void ClothCollisionSettings_impulse_clamp_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_self_impulse_clamp_get(PointerRNA *ptr);
void ClothCollisionSettings_self_impulse_clamp_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_distance_min_get(PointerRNA *ptr);
void ClothCollisionSettings_distance_min_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_damping_get(PointerRNA *ptr);
void ClothCollisionSettings_damping_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_self_friction_get(PointerRNA *ptr);
void ClothCollisionSettings_self_friction_set(PointerRNA *ptr, float value);

float ClothCollisionSettings_self_distance_min_get(PointerRNA *ptr);
void ClothCollisionSettings_self_distance_min_set(PointerRNA *ptr, float value);

void ClothCollisionSettings_vertex_group_self_collisions_get(PointerRNA *ptr, char *value);
int ClothCollisionSettings_vertex_group_self_collisions_length(PointerRNA *ptr);
void ClothCollisionSettings_vertex_group_self_collisions_set(PointerRNA *ptr, const char *value);

/**************** Cloth Modifier ****************/

extern StructRNA RNA_ClothModifier;
extern StructRNA RNA_Modifier;

PointerRNA ClothModifier_collision_settings_get(PointerRNA *ptr);

PointerRNA ClothModifier_settings_get(PointerRNA *ptr);

void ClothModifier_hair_grid_max_get(PointerRNA *ptr, float values[3]);
void ClothModifier_hair_grid_max_set(PointerRNA *ptr, const float values[3]);

void ClothModifier_hair_grid_min_get(PointerRNA *ptr, float values[3]);
void ClothModifier_hair_grid_min_set(PointerRNA *ptr, const float values[3]);

void ClothModifier_hair_grid_resolution_get(PointerRNA *ptr, int values[3]);
void ClothModifier_hair_grid_resolution_set(PointerRNA *ptr, const int values[3]);

PointerRNA ClothModifier_point_cache_get(PointerRNA *ptr);

PointerRNA ClothModifier_solver_result_get(PointerRNA *ptr);

/**************** Cloth Settings ****************/

extern StructRNA RNA_ClothSettings;

PointerRNA ClothSettings_rna_type_get(PointerRNA *ptr);

float ClothSettings_air_damping_get(PointerRNA *ptr);
void ClothSettings_air_damping_set(PointerRNA *ptr, float value);

enum {
	ClothSettings_bending_model_ANGULAR = 1,
	ClothSettings_bending_model_LINEAR = 0,
};

int ClothSettings_bending_model_get(PointerRNA *ptr);
void ClothSettings_bending_model_set(PointerRNA *ptr, int value);

float ClothSettings_bending_damping_get(PointerRNA *ptr);
void ClothSettings_bending_damping_set(PointerRNA *ptr, float value);

float ClothSettings_bending_stiffness_get(PointerRNA *ptr);
void ClothSettings_bending_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_bending_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_bending_stiffness_max_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_bending_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_bending_length(PointerRNA *ptr);
void ClothSettings_vertex_group_bending_set(PointerRNA *ptr, const char *value);

bool ClothSettings_internal_spring_normal_check_get(PointerRNA *ptr);
void ClothSettings_internal_spring_normal_check_set(PointerRNA *ptr, bool value);

float ClothSettings_collider_friction_get(PointerRNA *ptr);
void ClothSettings_collider_friction_set(PointerRNA *ptr, float value);

float ClothSettings_compression_damping_get(PointerRNA *ptr);
void ClothSettings_compression_damping_set(PointerRNA *ptr, float value);

float ClothSettings_compression_stiffness_get(PointerRNA *ptr);
void ClothSettings_compression_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_internal_compression_stiffness_get(PointerRNA *ptr);
void ClothSettings_internal_compression_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_compression_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_compression_stiffness_max_set(PointerRNA *ptr, float value);

float ClothSettings_internal_compression_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_internal_compression_stiffness_max_set(PointerRNA *ptr, float value);

bool ClothSettings_use_internal_springs_get(PointerRNA *ptr);
void ClothSettings_use_internal_springs_set(PointerRNA *ptr, bool value);

bool ClothSettings_use_dynamic_mesh_get(PointerRNA *ptr);
void ClothSettings_use_dynamic_mesh_set(PointerRNA *ptr, bool value);

PointerRNA ClothSettings_effector_weights_get(PointerRNA *ptr);

float ClothSettings_fluid_density_get(PointerRNA *ptr);
void ClothSettings_fluid_density_set(PointerRNA *ptr, float value);

float ClothSettings_goal_friction_get(PointerRNA *ptr);
void ClothSettings_goal_friction_set(PointerRNA *ptr, float value);

float ClothSettings_goal_default_get(PointerRNA *ptr);
void ClothSettings_goal_default_set(PointerRNA *ptr, float value);

float ClothSettings_goal_max_get(PointerRNA *ptr);
void ClothSettings_goal_max_set(PointerRNA *ptr, float value);

float ClothSettings_goal_min_get(PointerRNA *ptr);
void ClothSettings_goal_min_set(PointerRNA *ptr, float value);

float ClothSettings_goal_spring_get(PointerRNA *ptr);
void ClothSettings_goal_spring_set(PointerRNA *ptr, float value);

void ClothSettings_gravity_get(PointerRNA *ptr, float values[3]);
void ClothSettings_gravity_set(PointerRNA *ptr, const float values[3]);

float ClothSettings_internal_friction_get(PointerRNA *ptr);
void ClothSettings_internal_friction_set(PointerRNA *ptr, float value);

float ClothSettings_internal_spring_max_diversion_get(PointerRNA *ptr);
void ClothSettings_internal_spring_max_diversion_set(PointerRNA *ptr, float value);

float ClothSettings_internal_spring_max_length_get(PointerRNA *ptr);
void ClothSettings_internal_spring_max_length_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_intern_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_intern_length(PointerRNA *ptr);
void ClothSettings_vertex_group_intern_set(PointerRNA *ptr, const char *value);

float ClothSettings_pin_stiffness_get(PointerRNA *ptr);
void ClothSettings_pin_stiffness_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_mass_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_mass_length(PointerRNA *ptr);
void ClothSettings_vertex_group_mass_set(PointerRNA *ptr, const char *value);

float ClothSettings_uniform_pressure_force_get(PointerRNA *ptr);
void ClothSettings_uniform_pressure_force_set(PointerRNA *ptr, float value);

float ClothSettings_pressure_factor_get(PointerRNA *ptr);
void ClothSettings_pressure_factor_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_pressure_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_pressure_length(PointerRNA *ptr);
void ClothSettings_vertex_group_pressure_set(PointerRNA *ptr, const char *value);

int ClothSettings_quality_get(PointerRNA *ptr);
void ClothSettings_quality_set(PointerRNA *ptr, int value);

PointerRNA ClothSettings_rest_shape_key_get(PointerRNA *ptr);

bool ClothSettings_use_sewing_springs_get(PointerRNA *ptr);
void ClothSettings_use_sewing_springs_set(PointerRNA *ptr, bool value);

float ClothSettings_sewing_force_max_get(PointerRNA *ptr);
void ClothSettings_sewing_force_max_set(PointerRNA *ptr, float value);

float ClothSettings_shear_damping_get(PointerRNA *ptr);
void ClothSettings_shear_damping_set(PointerRNA *ptr, float value);

float ClothSettings_shear_stiffness_get(PointerRNA *ptr);
void ClothSettings_shear_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_shear_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_shear_stiffness_max_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_shear_stiffness_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_shear_stiffness_length(PointerRNA *ptr);
void ClothSettings_vertex_group_shear_stiffness_set(PointerRNA *ptr, const char *value);

float ClothSettings_shrink_min_get(PointerRNA *ptr);
void ClothSettings_shrink_min_set(PointerRNA *ptr, float value);

float ClothSettings_shrink_max_get(PointerRNA *ptr);
void ClothSettings_shrink_max_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_shrink_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_shrink_length(PointerRNA *ptr);
void ClothSettings_vertex_group_shrink_set(PointerRNA *ptr, const char *value);

float ClothSettings_time_scale_get(PointerRNA *ptr);
void ClothSettings_time_scale_set(PointerRNA *ptr, float value);

void ClothSettings_vertex_group_structural_stiffness_get(PointerRNA *ptr, char *value);
int ClothSettings_vertex_group_structural_stiffness_length(PointerRNA *ptr);
void ClothSettings_vertex_group_structural_stiffness_set(PointerRNA *ptr, const char *value);

float ClothSettings_density_target_get(PointerRNA *ptr);
void ClothSettings_density_target_set(PointerRNA *ptr, float value);

float ClothSettings_density_strength_get(PointerRNA *ptr);
void ClothSettings_density_strength_set(PointerRNA *ptr, float value);

float ClothSettings_target_volume_get(PointerRNA *ptr);
void ClothSettings_target_volume_set(PointerRNA *ptr, float value);

float ClothSettings_tension_damping_get(PointerRNA *ptr);
void ClothSettings_tension_damping_set(PointerRNA *ptr, float value);

float ClothSettings_tension_stiffness_get(PointerRNA *ptr);
void ClothSettings_tension_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_internal_tension_stiffness_get(PointerRNA *ptr);
void ClothSettings_internal_tension_stiffness_set(PointerRNA *ptr, float value);

float ClothSettings_tension_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_tension_stiffness_max_set(PointerRNA *ptr, float value);

float ClothSettings_internal_tension_stiffness_max_get(PointerRNA *ptr);
void ClothSettings_internal_tension_stiffness_max_set(PointerRNA *ptr, float value);

bool ClothSettings_use_pressure_volume_get(PointerRNA *ptr);
void ClothSettings_use_pressure_volume_set(PointerRNA *ptr, bool value);

bool ClothSettings_use_pressure_get(PointerRNA *ptr);
void ClothSettings_use_pressure_set(PointerRNA *ptr, bool value);

float ClothSettings_mass_get(PointerRNA *ptr);
void ClothSettings_mass_set(PointerRNA *ptr, float value);

float ClothSettings_voxel_cell_size_get(PointerRNA *ptr);
void ClothSettings_voxel_cell_size_set(PointerRNA *ptr, float value);

/**************** Solver Result ****************/

extern StructRNA RNA_ClothSolverResult;

PointerRNA ClothSolverResult_rna_type_get(PointerRNA *ptr);

float ClothSolverResult_avg_error_get(PointerRNA *ptr);
void ClothSolverResult_avg_error_set(PointerRNA *ptr, float value);

float ClothSolverResult_avg_iterations_get(PointerRNA *ptr);
void ClothSolverResult_avg_iterations_set(PointerRNA *ptr, float value);

float ClothSolverResult_max_error_get(PointerRNA *ptr);
void ClothSolverResult_max_error_set(PointerRNA *ptr, float value);

int ClothSolverResult_max_iterations_get(PointerRNA *ptr);
void ClothSolverResult_max_iterations_set(PointerRNA *ptr, int value);

float ClothSolverResult_min_error_get(PointerRNA *ptr);
void ClothSolverResult_min_error_set(PointerRNA *ptr, float value);

int ClothSolverResult_min_iterations_get(PointerRNA *ptr);
void ClothSolverResult_min_iterations_set(PointerRNA *ptr, int value);

enum {
	ClothSolverResult_status_SUCCESS = 1,
	ClothSolverResult_status_NUMERICAL_ISSUE = 2,
	ClothSolverResult_status_NO_CONVERGENCE = 4,
	ClothSolverResult_status_INVALID_INPUT = 8,
};

int ClothSolverResult_status_get(PointerRNA *ptr);
void ClothSolverResult_status_set(PointerRNA *ptr, int value);

/**************** Clouds Texture ****************/

extern StructRNA RNA_CloudsTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

enum {
	CloudsTexture_cloud_type_GRAYSCALE = 0,
	CloudsTexture_cloud_type_COLOR = 1,
};

int CloudsTexture_cloud_type_get(PointerRNA *ptr);
void CloudsTexture_cloud_type_set(PointerRNA *ptr, int value);

float CloudsTexture_nabla_get(PointerRNA *ptr);
void CloudsTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	CloudsTexture_noise_basis_BLENDER_ORIGINAL = 0,
	CloudsTexture_noise_basis_ORIGINAL_PERLIN = 1,
	CloudsTexture_noise_basis_IMPROVED_PERLIN = 2,
	CloudsTexture_noise_basis_VORONOI_F1 = 3,
	CloudsTexture_noise_basis_VORONOI_F2 = 4,
	CloudsTexture_noise_basis_VORONOI_F3 = 5,
	CloudsTexture_noise_basis_VORONOI_F4 = 6,
	CloudsTexture_noise_basis_VORONOI_F2_F1 = 7,
	CloudsTexture_noise_basis_VORONOI_CRACKLE = 8,
	CloudsTexture_noise_basis_CELL_NOISE = 14,
};

int CloudsTexture_noise_basis_get(PointerRNA *ptr);
void CloudsTexture_noise_basis_set(PointerRNA *ptr, int value);

int CloudsTexture_noise_depth_get(PointerRNA *ptr);
void CloudsTexture_noise_depth_set(PointerRNA *ptr, int value);

float CloudsTexture_noise_scale_get(PointerRNA *ptr);
void CloudsTexture_noise_scale_set(PointerRNA *ptr, float value);

enum {
	CloudsTexture_noise_type_SOFT_NOISE = 0,
	CloudsTexture_noise_type_HARD_NOISE = 1,
};

int CloudsTexture_noise_type_get(PointerRNA *ptr);
void CloudsTexture_noise_type_set(PointerRNA *ptr, int value);

/**************** Collection ****************/

extern StructRNA RNA_Collection;
extern StructRNA RNA_ID;

int Collection_active_exporter_index_get(PointerRNA *ptr);
void Collection_active_exporter_index_set(PointerRNA *ptr, int value);

void Collection_all_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_all_objects_next(CollectionPropertyIterator *iter);
void Collection_all_objects_end(CollectionPropertyIterator *iter);

void Collection_children_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_children_next(CollectionPropertyIterator *iter);
void Collection_children_end(CollectionPropertyIterator *iter);
bool Collection_children_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Collection_children_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Collection_collection_children_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_collection_children_next(CollectionPropertyIterator *iter);
void Collection_collection_children_end(CollectionPropertyIterator *iter);
bool Collection_collection_children_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	Collection_color_tag_NONE = -1,
	Collection_color_tag_COLOR_01 = 0,
	Collection_color_tag_COLOR_02 = 1,
	Collection_color_tag_COLOR_03 = 2,
	Collection_color_tag_COLOR_04 = 3,
	Collection_color_tag_COLOR_05 = 4,
	Collection_color_tag_COLOR_06 = 5,
	Collection_color_tag_COLOR_07 = 6,
	Collection_color_tag_COLOR_08 = 7,
};

int Collection_color_tag_get(PointerRNA *ptr);
void Collection_color_tag_set(PointerRNA *ptr, int value);

void Collection_exporters_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_exporters_next(CollectionPropertyIterator *iter);
void Collection_exporters_end(CollectionPropertyIterator *iter);
bool Collection_exporters_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Collection_exporters_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Collection_collection_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_collection_objects_next(CollectionPropertyIterator *iter);
void Collection_collection_objects_end(CollectionPropertyIterator *iter);
bool Collection_collection_objects_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool Collection_hide_select_get(PointerRNA *ptr);
void Collection_hide_select_set(PointerRNA *ptr, bool value);

bool Collection_hide_render_get(PointerRNA *ptr);
void Collection_hide_render_set(PointerRNA *ptr, bool value);

bool Collection_hide_viewport_get(PointerRNA *ptr);
void Collection_hide_viewport_set(PointerRNA *ptr, bool value);

void Collection_instance_offset_get(PointerRNA *ptr, float values[3]);
void Collection_instance_offset_set(PointerRNA *ptr, const float values[3]);

int Collection_lineart_intersection_priority_get(PointerRNA *ptr);
void Collection_lineart_intersection_priority_set(PointerRNA *ptr, int value);

void Collection_lineart_intersection_mask_get(PointerRNA *ptr, bool values[8]);
void Collection_lineart_intersection_mask_set(PointerRNA *ptr, const bool values[8]);

void Collection_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Collection_objects_next(CollectionPropertyIterator *iter);
void Collection_objects_end(CollectionPropertyIterator *iter);

enum {
	Collection_lineart_usage_INCLUDE = 0,
	Collection_lineart_usage_OCCLUSION_ONLY = 1,
	Collection_lineart_usage_EXCLUDE = 2,
	Collection_lineart_usage_INTERSECTION_ONLY = 4,
	Collection_lineart_usage_NO_INTERSECTION = 8,
	Collection_lineart_usage_FORCE_INTERSECTION = 16,
};

int Collection_lineart_usage_get(PointerRNA *ptr);
void Collection_lineart_usage_set(PointerRNA *ptr, int value);

bool Collection_lineart_use_intersection_mask_get(PointerRNA *ptr);
void Collection_lineart_use_intersection_mask_set(PointerRNA *ptr, bool value);

bool Collection_use_lineart_intersection_priority_get(PointerRNA *ptr);
void Collection_use_lineart_intersection_priority_set(PointerRNA *ptr, bool value);

/**************** Collection Child ****************/

extern StructRNA RNA_CollectionChild;

PointerRNA CollectionChild_rna_type_get(PointerRNA *ptr);

PointerRNA CollectionChild_light_linking_get(PointerRNA *ptr);

/**************** Collection Children ****************/

extern StructRNA RNA_CollectionChildren;

PointerRNA CollectionChildren_rna_type_get(PointerRNA *ptr);

void CollectionChildren_link_func(struct Collection *_self, Main *bmain, ReportList *reports, struct Collection *child);
void CollectionChildren_unlink_func(struct Collection *_self, Main *bmain, ReportList *reports, struct Collection *child);
/**************** Name ****************/

extern StructRNA RNA_CollectionExport;

PointerRNA CollectionExport_rna_type_get(PointerRNA *ptr);

#define CollectionExport_name_MAX 64

void CollectionExport_name_get(PointerRNA *ptr, char *value);
int CollectionExport_name_length(PointerRNA *ptr);
void CollectionExport_name_set(PointerRNA *ptr, const char *value);

PointerRNA CollectionExport_export_properties_get(PointerRNA *ptr);

#define CollectionExport_filepath_MAX 1024

void CollectionExport_filepath_get(PointerRNA *ptr, char *value);
int CollectionExport_filepath_length(PointerRNA *ptr);
void CollectionExport_filepath_set(PointerRNA *ptr, const char *value);

bool CollectionExport_is_open_get(PointerRNA *ptr);
void CollectionExport_is_open_set(PointerRNA *ptr, bool value);

/**************** Export Handlers ****************/

extern StructRNA RNA_CollectionExports;

PointerRNA CollectionExports_rna_type_get(PointerRNA *ptr);

struct CollectionExport *CollectionExports_new_func(struct Collection *_self, ReportList *reports, int type, const char * name);
void CollectionExports_remove_func(struct Collection *_self, struct CollectionExport *exporter);
void CollectionExports_move_func(struct Collection *_self, ReportList *reports, int from_index, int to_index);
/**************** Collection Light Linking ****************/

extern StructRNA RNA_CollectionLightLinking;

PointerRNA CollectionLightLinking_rna_type_get(PointerRNA *ptr);

enum {
	CollectionLightLinking_link_state_INCLUDE = 0,
	CollectionLightLinking_link_state_EXCLUDE = 1,
};

int CollectionLightLinking_link_state_get(PointerRNA *ptr);
void CollectionLightLinking_link_state_set(PointerRNA *ptr, int value);

/**************** Collection Object ****************/

extern StructRNA RNA_CollectionObject;

PointerRNA CollectionObject_rna_type_get(PointerRNA *ptr);

PointerRNA CollectionObject_light_linking_get(PointerRNA *ptr);

/**************** Collection Objects ****************/

extern StructRNA RNA_CollectionObjects;

PointerRNA CollectionObjects_rna_type_get(PointerRNA *ptr);

void CollectionObjects_link_func(struct Collection *_self, Main *bmain, ReportList *reports, struct Object *object);
void CollectionObjects_unlink_func(struct Collection *_self, Main *bmain, ReportList *reports, struct Object *object);
/**************** Collection Definition ****************/

extern StructRNA RNA_CollectionProperty;
extern StructRNA RNA_Property;

PointerRNA CollectionProperty_fixed_type_get(PointerRNA *ptr);

/**************** Collision Modifier ****************/

extern StructRNA RNA_CollisionModifier;
extern StructRNA RNA_Modifier;

PointerRNA CollisionModifier_settings_get(PointerRNA *ptr);

/**************** Collision Settings ****************/

extern StructRNA RNA_CollisionSettings;

PointerRNA CollisionSettings_rna_type_get(PointerRNA *ptr);

float CollisionSettings_absorption_get(PointerRNA *ptr);
void CollisionSettings_absorption_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_get(PointerRNA *ptr);
void CollisionSettings_damping_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_factor_get(PointerRNA *ptr);
void CollisionSettings_damping_factor_set(PointerRNA *ptr, float value);

bool CollisionSettings_use_get(PointerRNA *ptr);
void CollisionSettings_use_set(PointerRNA *ptr, bool value);

float CollisionSettings_cloth_friction_get(PointerRNA *ptr);
void CollisionSettings_cloth_friction_set(PointerRNA *ptr, float value);

float CollisionSettings_friction_factor_get(PointerRNA *ptr);
void CollisionSettings_friction_factor_set(PointerRNA *ptr, float value);

float CollisionSettings_thickness_inner_get(PointerRNA *ptr);
void CollisionSettings_thickness_inner_set(PointerRNA *ptr, float value);

bool CollisionSettings_use_particle_kill_get(PointerRNA *ptr);
void CollisionSettings_use_particle_kill_set(PointerRNA *ptr, bool value);

float CollisionSettings_thickness_outer_get(PointerRNA *ptr);
void CollisionSettings_thickness_outer_set(PointerRNA *ptr, float value);

bool CollisionSettings_use_normal_get(PointerRNA *ptr);
void CollisionSettings_use_normal_set(PointerRNA *ptr, bool value);

float CollisionSettings_permeability_get(PointerRNA *ptr);
void CollisionSettings_permeability_set(PointerRNA *ptr, float value);

float CollisionSettings_damping_random_get(PointerRNA *ptr);
void CollisionSettings_damping_random_set(PointerRNA *ptr, float value);

float CollisionSettings_friction_random_get(PointerRNA *ptr);
void CollisionSettings_friction_random_set(PointerRNA *ptr, float value);

bool CollisionSettings_use_culling_get(PointerRNA *ptr);
void CollisionSettings_use_culling_set(PointerRNA *ptr, bool value);

float CollisionSettings_stickiness_get(PointerRNA *ptr);
void CollisionSettings_stickiness_set(PointerRNA *ptr, float value);

/**************** ColorBalanceModifier ****************/

extern StructRNA RNA_ColorBalanceModifier;
extern StructRNA RNA_StripModifier;

float ColorBalanceModifier_color_multiply_get(PointerRNA *ptr);
void ColorBalanceModifier_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA ColorBalanceModifier_color_balance_get(PointerRNA *ptr);

bool ColorBalanceModifier_open_mask_input_panel_get(PointerRNA *ptr);
void ColorBalanceModifier_open_mask_input_panel_set(PointerRNA *ptr, bool value);

/**************** ColorManagedDisplaySettings ****************/

extern StructRNA RNA_ColorManagedDisplaySettings;

PointerRNA ColorManagedDisplaySettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedDisplaySettings_display_device_NONE = 0,
};

int ColorManagedDisplaySettings_display_device_get(PointerRNA *ptr);
void ColorManagedDisplaySettings_display_device_set(PointerRNA *ptr, int value);

enum {
	ColorManagedDisplaySettings_emulation_OFF = 1,
	ColorManagedDisplaySettings_emulation_AUTO = 0,
};

int ColorManagedDisplaySettings_emulation_get(PointerRNA *ptr);
void ColorManagedDisplaySettings_emulation_set(PointerRNA *ptr, int value);

/**************** ColorManagedInputColorspaceSettings ****************/

extern StructRNA RNA_ColorManagedInputColorspaceSettings;

PointerRNA ColorManagedInputColorspaceSettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedInputColorspaceSettings_name_NONE = 0,
};

int ColorManagedInputColorspaceSettings_name_get(PointerRNA *ptr);
void ColorManagedInputColorspaceSettings_name_set(PointerRNA *ptr, int value);

bool ColorManagedInputColorspaceSettings_is_data_get(PointerRNA *ptr);
void ColorManagedInputColorspaceSettings_is_data_set(PointerRNA *ptr, bool value);

/**************** ColorManagedSequencerColorspaceSettings ****************/

extern StructRNA RNA_ColorManagedSequencerColorspaceSettings;

PointerRNA ColorManagedSequencerColorspaceSettings_rna_type_get(PointerRNA *ptr);

enum {
	ColorManagedSequencerColorspaceSettings_name_NONE = 0,
};

int ColorManagedSequencerColorspaceSettings_name_get(PointerRNA *ptr);
void ColorManagedSequencerColorspaceSettings_name_set(PointerRNA *ptr, int value);

/**************** ColorManagedViewSettings ****************/

extern StructRNA RNA_ColorManagedViewSettings;

PointerRNA ColorManagedViewSettings_rna_type_get(PointerRNA *ptr);

PointerRNA ColorManagedViewSettings_curve_mapping_get(PointerRNA *ptr);

float ColorManagedViewSettings_exposure_get(PointerRNA *ptr);
void ColorManagedViewSettings_exposure_set(PointerRNA *ptr, float value);

float ColorManagedViewSettings_gamma_get(PointerRNA *ptr);
void ColorManagedViewSettings_gamma_set(PointerRNA *ptr, float value);

bool ColorManagedViewSettings_is_hdr_get(PointerRNA *ptr);
void ColorManagedViewSettings_is_hdr_set(PointerRNA *ptr, bool value);

enum {
	ColorManagedViewSettings_look_NONE = 0,
};

int ColorManagedViewSettings_look_get(PointerRNA *ptr);
void ColorManagedViewSettings_look_set(PointerRNA *ptr, int value);

bool ColorManagedViewSettings_support_emulation_get(PointerRNA *ptr);
void ColorManagedViewSettings_support_emulation_set(PointerRNA *ptr, bool value);

float ColorManagedViewSettings_white_balance_temperature_get(PointerRNA *ptr);
void ColorManagedViewSettings_white_balance_temperature_set(PointerRNA *ptr, float value);

float ColorManagedViewSettings_white_balance_tint_get(PointerRNA *ptr);
void ColorManagedViewSettings_white_balance_tint_set(PointerRNA *ptr, float value);

bool ColorManagedViewSettings_use_curve_mapping_get(PointerRNA *ptr);
void ColorManagedViewSettings_use_curve_mapping_set(PointerRNA *ptr, bool value);

bool ColorManagedViewSettings_use_white_balance_get(PointerRNA *ptr);
void ColorManagedViewSettings_use_white_balance_set(PointerRNA *ptr, bool value);

enum {
	ColorManagedViewSettings_view_transform_NONE = 0,
};

int ColorManagedViewSettings_view_transform_get(PointerRNA *ptr);
void ColorManagedViewSettings_view_transform_set(PointerRNA *ptr, int value);

void ColorManagedViewSettings_white_balance_whitepoint_get(PointerRNA *ptr, float values[3]);
void ColorManagedViewSettings_white_balance_whitepoint_set(PointerRNA *ptr, const float values[3]);

/**************** Color Mapping ****************/

extern StructRNA RNA_ColorMapping;

PointerRNA ColorMapping_rna_type_get(PointerRNA *ptr);

float ColorMapping_blend_factor_get(PointerRNA *ptr);
void ColorMapping_blend_factor_set(PointerRNA *ptr, float value);

enum {
	ColorMapping_blend_type_MIX = 0,
	ColorMapping_blend_type_DARKEN = 5,
	ColorMapping_blend_type_MULTIPLY = 1,
	ColorMapping_blend_type_LIGHTEN = 7,
	ColorMapping_blend_type_SCREEN = 8,
	ColorMapping_blend_type_ADD = 2,
	ColorMapping_blend_type_OVERLAY = 9,
	ColorMapping_blend_type_SOFT_LIGHT = 15,
	ColorMapping_blend_type_LINEAR_LIGHT = 16,
	ColorMapping_blend_type_DIFFERENCE = 6,
	ColorMapping_blend_type_SUBTRACT = 3,
	ColorMapping_blend_type_DIVIDE = 4,
	ColorMapping_blend_type_HUE = 10,
	ColorMapping_blend_type_SATURATION = 11,
	ColorMapping_blend_type_COLOR = 13,
	ColorMapping_blend_type_VALUE = 12,
};

int ColorMapping_blend_type_get(PointerRNA *ptr);
void ColorMapping_blend_type_set(PointerRNA *ptr, int value);

float ColorMapping_brightness_get(PointerRNA *ptr);
void ColorMapping_brightness_set(PointerRNA *ptr, float value);

void ColorMapping_blend_color_get(PointerRNA *ptr, float values[3]);
void ColorMapping_blend_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA ColorMapping_color_ramp_get(PointerRNA *ptr);

float ColorMapping_contrast_get(PointerRNA *ptr);
void ColorMapping_contrast_set(PointerRNA *ptr, float value);

float ColorMapping_saturation_get(PointerRNA *ptr);
void ColorMapping_saturation_set(PointerRNA *ptr, float value);

bool ColorMapping_use_color_ramp_get(PointerRNA *ptr);
void ColorMapping_use_color_ramp_set(PointerRNA *ptr, bool value);

/**************** Color Mix Strip ****************/

extern StructRNA RNA_ColorMixStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

float ColorMixStrip_factor_get(PointerRNA *ptr);
void ColorMixStrip_factor_set(PointerRNA *ptr, float value);

enum {
	ColorMixStrip_blend_effect_DARKEN = 46,
	ColorMixStrip_blend_effect_MULTIPLY = 14,
	ColorMixStrip_blend_effect_BURN = 47,
	ColorMixStrip_blend_effect_LINEAR_BURN = 48,
	ColorMixStrip_blend_effect_LIGHTEN = 44,
	ColorMixStrip_blend_effect_SCREEN = 43,
	ColorMixStrip_blend_effect_DODGE = 45,
	ColorMixStrip_blend_effect_ADD = 9,
	ColorMixStrip_blend_effect_OVERLAY = 49,
	ColorMixStrip_blend_effect_SOFT_LIGHT = 51,
	ColorMixStrip_blend_effect_HARD_LIGHT = 50,
	ColorMixStrip_blend_effect_VIVID_LIGHT = 54,
	ColorMixStrip_blend_effect_LINEAR_LIGHT = 53,
	ColorMixStrip_blend_effect_PIN_LIGHT = 52,
	ColorMixStrip_blend_effect_DIFFERENCE = 59,
	ColorMixStrip_blend_effect_EXCLUSION = 60,
	ColorMixStrip_blend_effect_SUBTRACT = 10,
	ColorMixStrip_blend_effect_HUE = 55,
	ColorMixStrip_blend_effect_SATURATION = 56,
	ColorMixStrip_blend_effect_COLOR = 58,
	ColorMixStrip_blend_effect_VALUE = 57,
};

int ColorMixStrip_blend_effect_get(PointerRNA *ptr);
void ColorMixStrip_blend_effect_set(PointerRNA *ptr, int value);

PointerRNA ColorMixStrip_input_1_get(PointerRNA *ptr);

PointerRNA ColorMixStrip_input_2_get(PointerRNA *ptr);

int ColorMixStrip_input_count_get(PointerRNA *ptr);
void ColorMixStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Color Ramp ****************/

extern StructRNA RNA_ColorRamp;

PointerRNA ColorRamp_rna_type_get(PointerRNA *ptr);

enum {
	ColorRamp_hue_interpolation_NEAR = 0,
	ColorRamp_hue_interpolation_FAR = 1,
	ColorRamp_hue_interpolation_CW = 2,
	ColorRamp_hue_interpolation_CCW = 3,
};

int ColorRamp_hue_interpolation_get(PointerRNA *ptr);
void ColorRamp_hue_interpolation_set(PointerRNA *ptr, int value);

enum {
	ColorRamp_color_mode_RGB = 0,
	ColorRamp_color_mode_HSV = 1,
	ColorRamp_color_mode_HSL = 2,
};

int ColorRamp_color_mode_get(PointerRNA *ptr);
void ColorRamp_color_mode_set(PointerRNA *ptr, int value);

void ColorRamp_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ColorRamp_elements_next(CollectionPropertyIterator *iter);
void ColorRamp_elements_end(CollectionPropertyIterator *iter);
int ColorRamp_elements_length(PointerRNA *ptr);
bool ColorRamp_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	ColorRamp_interpolation_EASE = 1,
	ColorRamp_interpolation_CARDINAL = 3,
	ColorRamp_interpolation_LINEAR = 0,
	ColorRamp_interpolation_B_SPLINE = 2,
	ColorRamp_interpolation_CONSTANT = 4,
};

int ColorRamp_interpolation_get(PointerRNA *ptr);
void ColorRamp_interpolation_set(PointerRNA *ptr, int value);

void ColorRamp_evaluate_func(struct ColorBand *_self, float position, float color[4]);
/**************** Color Ramp Element ****************/

extern StructRNA RNA_ColorRampElement;

PointerRNA ColorRampElement_rna_type_get(PointerRNA *ptr);

float ColorRampElement_alpha_get(PointerRNA *ptr);
void ColorRampElement_alpha_set(PointerRNA *ptr, float value);

void ColorRampElement_color_get(PointerRNA *ptr, float values[4]);
void ColorRampElement_color_set(PointerRNA *ptr, const float values[4]);

float ColorRampElement_position_get(PointerRNA *ptr);
void ColorRampElement_position_set(PointerRNA *ptr, float value);

/**************** Color Ramp Elements ****************/

extern StructRNA RNA_ColorRampElements;

PointerRNA ColorRampElements_rna_type_get(PointerRNA *ptr);

struct CBData *ColorRampElements_new_func(struct ColorBand *_self, ReportList *reports, float position);
void ColorRampElements_remove_func(struct ColorBand *_self, ReportList *reports, struct PointerRNA *element);
/**************** Color Strip ****************/

extern StructRNA RNA_ColorStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

void ColorStrip_color_get(PointerRNA *ptr, float values[3]);
void ColorStrip_color_set(PointerRNA *ptr, const float values[3]);

int ColorStrip_input_count_get(PointerRNA *ptr);
void ColorStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Compositor Node ****************/

extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNode_tag_need_exec_func(struct bNode *_self);
/**************** CompositorNodeAlphaOver ****************/

extern StructRNA RNA_CompositorNodeAlphaOver;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeAlphaOver_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeAlphaOver_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeAlphaOver_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeAntiAliasing ****************/

extern StructRNA RNA_CompositorNodeAntiAliasing;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeAntiAliasing_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeAntiAliasing_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeAntiAliasing_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBilateralblur ****************/

extern StructRNA RNA_CompositorNodeBilateralblur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBilateralblur_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBilateralblur_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBilateralblur_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBlur ****************/

extern StructRNA RNA_CompositorNodeBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBlur_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBlur_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBlur_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBokehBlur ****************/

extern StructRNA RNA_CompositorNodeBokehBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBokehBlur_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBokehBlur_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBokehBlur_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBokehImage ****************/

extern StructRNA RNA_CompositorNodeBokehImage;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBokehImage_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBokehImage_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBokehImage_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBoxMask ****************/

extern StructRNA RNA_CompositorNodeBoxMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBoxMask_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBoxMask_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBoxMask_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeBrightContrast ****************/

extern StructRNA RNA_CompositorNodeBrightContrast;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeBrightContrast_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeBrightContrast_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeBrightContrast_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeChannelMatte ****************/

extern StructRNA RNA_CompositorNodeChannelMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeChannelMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeChannelMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeChannelMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeChromaMatte ****************/

extern StructRNA RNA_CompositorNodeChromaMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeChromaMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeChromaMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeChromaMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeColorBalance ****************/

extern StructRNA RNA_CompositorNodeColorBalance;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNodeColorBalance_input_whitepoint_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_input_whitepoint_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeColorBalance_output_whitepoint_get(PointerRNA *ptr, float values[3]);
void CompositorNodeColorBalance_output_whitepoint_set(PointerRNA *ptr, const float values[3]);

bool CompositorNodeColorBalance_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorBalance_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorBalance_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeColorCorrection ****************/

extern StructRNA RNA_CompositorNodeColorCorrection;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeColorCorrection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorCorrection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorCorrection_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeColorMatte ****************/

extern StructRNA RNA_CompositorNodeColorMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeColorMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeColorSpill ****************/

extern StructRNA RNA_CompositorNodeColorSpill;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeColorSpill_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeColorSpill_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeColorSpill_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCombineColor ****************/

extern StructRNA RNA_CompositorNodeCombineColor;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeCombineColor_ycc_mode_ITUBT601 = 0,
	CompositorNodeCombineColor_ycc_mode_ITUBT709 = 1,
	CompositorNodeCombineColor_ycc_mode_JFIF = 2,
};

int CompositorNodeCombineColor_ycc_mode_get(PointerRNA *ptr);
void CompositorNodeCombineColor_ycc_mode_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeCombineColor_mode_RGB = 0,
	CompositorNodeCombineColor_mode_HSV = 1,
	CompositorNodeCombineColor_mode_HSL = 2,
	CompositorNodeCombineColor_mode_YCC = 3,
	CompositorNodeCombineColor_mode_YUV = 4,
};

int CompositorNodeCombineColor_mode_get(PointerRNA *ptr);
void CompositorNodeCombineColor_mode_set(PointerRNA *ptr, int value);

bool CompositorNodeCombineColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCombineColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCombineColor_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeConvertColorSpace ****************/

extern StructRNA RNA_CompositorNodeConvertColorSpace;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeConvertColorSpace_from_color_space_NONE = 0,
};

int CompositorNodeConvertColorSpace_from_color_space_get(PointerRNA *ptr);
void CompositorNodeConvertColorSpace_from_color_space_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeConvertColorSpace_to_color_space_NONE = 0,
};

int CompositorNodeConvertColorSpace_to_color_space_get(PointerRNA *ptr);
void CompositorNodeConvertColorSpace_to_color_space_set(PointerRNA *ptr, int value);

bool CompositorNodeConvertColorSpace_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeConvertColorSpace_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeConvertColorSpace_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeConvertToDisplay ****************/

extern StructRNA RNA_CompositorNodeConvertToDisplay;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeConvertToDisplay_display_settings_get(PointerRNA *ptr);

PointerRNA CompositorNodeConvertToDisplay_view_settings_get(PointerRNA *ptr);

bool CompositorNodeConvertToDisplay_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeConvertToDisplay_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeConvertToDisplay_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeConvolve ****************/

extern StructRNA RNA_CompositorNodeConvolve;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeConvolve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeConvolve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeConvolve_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCornerPin ****************/

extern StructRNA RNA_CompositorNodeCornerPin;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeCornerPin_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCornerPin_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCornerPin_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCrop ****************/

extern StructRNA RNA_CompositorNodeCrop;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeCrop_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCrop_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCrop_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCryptomatte ****************/

extern StructRNA RNA_CompositorNodeCryptomatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNodeCryptomatte_add_get(PointerRNA *ptr, float values[3]);
void CompositorNodeCryptomatte_add_set(PointerRNA *ptr, const float values[3]);

void CompositorNodeCryptomatte_matte_id_get(PointerRNA *ptr, char *value);
int CompositorNodeCryptomatte_matte_id_length(PointerRNA *ptr);
void CompositorNodeCryptomatte_matte_id_set(PointerRNA *ptr, const char *value);

void CompositorNodeCryptomatte_remove_get(PointerRNA *ptr, float values[3]);
void CompositorNodeCryptomatte_remove_set(PointerRNA *ptr, const float values[3]);

bool CompositorNodeCryptomatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCryptomatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCryptomatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCryptomatteV2 ****************/

extern StructRNA RNA_CompositorNodeCryptomatteV2;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void CompositorNodeCryptomatteV2_add_get(PointerRNA *ptr, float values[3]);
void CompositorNodeCryptomatteV2_add_set(PointerRNA *ptr, const float values[3]);

bool CompositorNodeCryptomatteV2_use_auto_refresh_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_use_auto_refresh_set(PointerRNA *ptr, bool value);

enum {
	CompositorNodeCryptomatteV2_layer_name_CryptoObject = 0,
	CompositorNodeCryptomatteV2_layer_name_CryptoMaterial = 1,
	CompositorNodeCryptomatteV2_layer_name_CryptoAsset = 2,
};

int CompositorNodeCryptomatteV2_layer_name_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_layer_name_set(PointerRNA *ptr, int value);

bool CompositorNodeCryptomatteV2_use_cyclic_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_use_cyclic_set(PointerRNA *ptr, bool value);

int CompositorNodeCryptomatteV2_frame_duration_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_frame_duration_set(PointerRNA *ptr, int value);

bool CompositorNodeCryptomatteV2_has_layers_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_has_layers_set(PointerRNA *ptr, bool value);

bool CompositorNodeCryptomatteV2_has_views_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_has_views_set(PointerRNA *ptr, bool value);

PointerRNA CompositorNodeCryptomatteV2_image_get(PointerRNA *ptr);

enum {
	CompositorNodeCryptomatteV2_layer_PLACEHOLDER = 0,
};

int CompositorNodeCryptomatteV2_layer_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_layer_set(PointerRNA *ptr, int value);

void CompositorNodeCryptomatteV2_matte_id_get(PointerRNA *ptr, char *value);
int CompositorNodeCryptomatteV2_matte_id_length(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_matte_id_set(PointerRNA *ptr, const char *value);

void CompositorNodeCryptomatteV2_entries_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CompositorNodeCryptomatteV2_entries_next(CollectionPropertyIterator *iter);
void CompositorNodeCryptomatteV2_entries_end(CollectionPropertyIterator *iter);
bool CompositorNodeCryptomatteV2_entries_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool CompositorNodeCryptomatteV2_entries_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int CompositorNodeCryptomatteV2_frame_offset_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_frame_offset_set(PointerRNA *ptr, int value);

void CompositorNodeCryptomatteV2_remove_get(PointerRNA *ptr, float values[3]);
void CompositorNodeCryptomatteV2_remove_set(PointerRNA *ptr, const float values[3]);

PointerRNA CompositorNodeCryptomatteV2_scene_get(PointerRNA *ptr);

enum {
	CompositorNodeCryptomatteV2_source_RENDER = 0,
	CompositorNodeCryptomatteV2_source_IMAGE = 1,
};

int CompositorNodeCryptomatteV2_source_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_source_set(PointerRNA *ptr, int value);

int CompositorNodeCryptomatteV2_frame_start_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_frame_start_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeCryptomatteV2_view_ALL = 0,
};

int CompositorNodeCryptomatteV2_view_get(PointerRNA *ptr);
void CompositorNodeCryptomatteV2_view_set(PointerRNA *ptr, int value);

bool CompositorNodeCryptomatteV2_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCryptomatteV2_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCryptomatteV2_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeCurveRGB ****************/

extern StructRNA RNA_CompositorNodeCurveRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeCurveRGB_mapping_get(PointerRNA *ptr);

bool CompositorNodeCurveRGB_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeCurveRGB_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeCurveRGB_output_template_func(struct StructRNA *_type, int index);
/**************** Compositor Custom Group ****************/

extern StructRNA RNA_CompositorNodeCustomGroup;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeCustomGroup_node_tree_get(PointerRNA *ptr);

/**************** CompositorNodeDBlur ****************/

extern StructRNA RNA_CompositorNodeDBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDBlur_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDBlur_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDBlur_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDefocus ****************/

extern StructRNA RNA_CompositorNodeDefocus;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

float CompositorNodeDefocus_angle_get(PointerRNA *ptr);
void CompositorNodeDefocus_angle_set(PointerRNA *ptr, float value);

enum {
	CompositorNodeDefocus_bokeh_OCTAGON = 8,
	CompositorNodeDefocus_bokeh_HEPTAGON = 7,
	CompositorNodeDefocus_bokeh_HEXAGON = 6,
	CompositorNodeDefocus_bokeh_PENTAGON = 5,
	CompositorNodeDefocus_bokeh_SQUARE = 4,
	CompositorNodeDefocus_bokeh_TRIANGLE = 3,
	CompositorNodeDefocus_bokeh_CIRCLE = 0,
};

int CompositorNodeDefocus_bokeh_get(PointerRNA *ptr);
void CompositorNodeDefocus_bokeh_set(PointerRNA *ptr, int value);

float CompositorNodeDefocus_f_stop_get(PointerRNA *ptr);
void CompositorNodeDefocus_f_stop_set(PointerRNA *ptr, float value);

float CompositorNodeDefocus_blur_max_get(PointerRNA *ptr);
void CompositorNodeDefocus_blur_max_set(PointerRNA *ptr, float value);

PointerRNA CompositorNodeDefocus_scene_get(PointerRNA *ptr);

bool CompositorNodeDefocus_use_zbuffer_get(PointerRNA *ptr);
void CompositorNodeDefocus_use_zbuffer_set(PointerRNA *ptr, bool value);

float CompositorNodeDefocus_z_scale_get(PointerRNA *ptr);
void CompositorNodeDefocus_z_scale_set(PointerRNA *ptr, float value);

bool CompositorNodeDefocus_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDefocus_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDefocus_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDenoise ****************/

extern StructRNA RNA_CompositorNodeDenoise;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDenoise_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDenoise_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDenoise_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDespeckle ****************/

extern StructRNA RNA_CompositorNodeDespeckle;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDespeckle_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDespeckle_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDespeckle_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDiffMatte ****************/

extern StructRNA RNA_CompositorNodeDiffMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDiffMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDiffMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDiffMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDilateErode ****************/

extern StructRNA RNA_CompositorNodeDilateErode;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDilateErode_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDilateErode_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDilateErode_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDisplace ****************/

extern StructRNA RNA_CompositorNodeDisplace;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDisplace_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDisplace_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDisplace_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDistanceMatte ****************/

extern StructRNA RNA_CompositorNodeDistanceMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDistanceMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDistanceMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDistanceMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeDoubleEdgeMask ****************/

extern StructRNA RNA_CompositorNodeDoubleEdgeMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeDoubleEdgeMask_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeDoubleEdgeMask_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeDoubleEdgeMask_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeEllipseMask ****************/

extern StructRNA RNA_CompositorNodeEllipseMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeEllipseMask_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeEllipseMask_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeEllipseMask_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeExposure ****************/

extern StructRNA RNA_CompositorNodeExposure;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeExposure_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeExposure_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeExposure_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeFilter ****************/

extern StructRNA RNA_CompositorNodeFilter;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeFilter_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeFilter_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeFilter_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeFlip ****************/

extern StructRNA RNA_CompositorNodeFlip;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeFlip_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeFlip_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeFlip_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeGamma ****************/

extern StructRNA RNA_CompositorNodeGamma;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeGamma_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeGamma_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGamma_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeGlare ****************/

extern StructRNA RNA_CompositorNodeGlare;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeGlare_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeGlare_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGlare_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeGroup ****************/

extern StructRNA RNA_CompositorNodeGroup;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeGroup_node_tree_get(PointerRNA *ptr);

bool CompositorNodeGroup_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeGroup_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeGroup_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeHueCorrect ****************/

extern StructRNA RNA_CompositorNodeHueCorrect;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeHueCorrect_mapping_get(PointerRNA *ptr);

bool CompositorNodeHueCorrect_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeHueCorrect_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeHueCorrect_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeHueSat ****************/

extern StructRNA RNA_CompositorNodeHueSat;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeHueSat_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeHueSat_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeHueSat_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeIDMask ****************/

extern StructRNA RNA_CompositorNodeIDMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeIDMask_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeIDMask_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeIDMask_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeImage ****************/

extern StructRNA RNA_CompositorNodeImage;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeImage_use_auto_refresh_get(PointerRNA *ptr);
void CompositorNodeImage_use_auto_refresh_set(PointerRNA *ptr, bool value);

bool CompositorNodeImage_use_cyclic_get(PointerRNA *ptr);
void CompositorNodeImage_use_cyclic_set(PointerRNA *ptr, bool value);

int CompositorNodeImage_frame_duration_get(PointerRNA *ptr);
void CompositorNodeImage_frame_duration_set(PointerRNA *ptr, int value);

bool CompositorNodeImage_has_layers_get(PointerRNA *ptr);
void CompositorNodeImage_has_layers_set(PointerRNA *ptr, bool value);

bool CompositorNodeImage_has_views_get(PointerRNA *ptr);
void CompositorNodeImage_has_views_set(PointerRNA *ptr, bool value);

PointerRNA CompositorNodeImage_image_get(PointerRNA *ptr);

enum {
	CompositorNodeImage_layer_PLACEHOLDER = 0,
};

int CompositorNodeImage_layer_get(PointerRNA *ptr);
void CompositorNodeImage_layer_set(PointerRNA *ptr, int value);

int CompositorNodeImage_frame_offset_get(PointerRNA *ptr);
void CompositorNodeImage_frame_offset_set(PointerRNA *ptr, int value);

int CompositorNodeImage_frame_start_get(PointerRNA *ptr);
void CompositorNodeImage_frame_start_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeImage_view_ALL = 0,
};

int CompositorNodeImage_view_get(PointerRNA *ptr);
void CompositorNodeImage_view_set(PointerRNA *ptr, int value);

bool CompositorNodeImage_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeImage_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeImage_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeImageCoordinates ****************/

extern StructRNA RNA_CompositorNodeImageCoordinates;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeImageCoordinates_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeImageCoordinates_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeImageCoordinates_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeImageInfo ****************/

extern StructRNA RNA_CompositorNodeImageInfo;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeImageInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeImageInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeImageInfo_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeInpaint ****************/

extern StructRNA RNA_CompositorNodeInpaint;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeInpaint_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeInpaint_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeInpaint_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeInvert ****************/

extern StructRNA RNA_CompositorNodeInvert;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeInvert_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeInvert_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeInvert_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeKeying ****************/

extern StructRNA RNA_CompositorNodeKeying;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeKeying_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeKeying_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeKeying_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeKeyingScreen ****************/

extern StructRNA RNA_CompositorNodeKeyingScreen;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeKeyingScreen_clip_get(PointerRNA *ptr);

#define CompositorNodeKeyingScreen_tracking_object_MAX 64

void CompositorNodeKeyingScreen_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodeKeyingScreen_tracking_object_length(PointerRNA *ptr);
void CompositorNodeKeyingScreen_tracking_object_set(PointerRNA *ptr, const char *value);

bool CompositorNodeKeyingScreen_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeKeyingScreen_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeKeyingScreen_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeKuwahara ****************/

extern StructRNA RNA_CompositorNodeKuwahara;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeKuwahara_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeKuwahara_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeKuwahara_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeLensdist ****************/

extern StructRNA RNA_CompositorNodeLensdist;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeLensdist_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeLensdist_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLensdist_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeLevels ****************/

extern StructRNA RNA_CompositorNodeLevels;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeLevels_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeLevels_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLevels_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeLumaMatte ****************/

extern StructRNA RNA_CompositorNodeLumaMatte;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeLumaMatte_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeLumaMatte_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeLumaMatte_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeMapUV ****************/

extern StructRNA RNA_CompositorNodeMapUV;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeMapUV_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeMapUV_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMapUV_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeMask ****************/

extern StructRNA RNA_CompositorNodeMask;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeMask_mask_get(PointerRNA *ptr);

bool CompositorNodeMask_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeMask_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMask_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeMovieClip ****************/

extern StructRNA RNA_CompositorNodeMovieClip;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeMovieClip_clip_get(PointerRNA *ptr);

bool CompositorNodeMovieClip_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeMovieClip_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMovieClip_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeMovieDistortion ****************/

extern StructRNA RNA_CompositorNodeMovieDistortion;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeMovieDistortion_clip_get(PointerRNA *ptr);

bool CompositorNodeMovieDistortion_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeMovieDistortion_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeMovieDistortion_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeNormal ****************/

extern StructRNA RNA_CompositorNodeNormal;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeNormal_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeNormal_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeNormal_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeNormalize ****************/

extern StructRNA RNA_CompositorNodeNormalize;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeNormalize_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeNormalize_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeNormalize_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeOutputFile ****************/

extern StructRNA RNA_CompositorNodeOutputFile;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeOutputFile_active_item_index_get(PointerRNA *ptr);
void CompositorNodeOutputFile_active_item_index_set(PointerRNA *ptr, int value);

#define CompositorNodeOutputFile_directory_MAX 1024

void CompositorNodeOutputFile_directory_get(PointerRNA *ptr, char *value);
int CompositorNodeOutputFile_directory_length(PointerRNA *ptr);
void CompositorNodeOutputFile_directory_set(PointerRNA *ptr, const char *value);

void CompositorNodeOutputFile_file_name_get(PointerRNA *ptr, char *value);
int CompositorNodeOutputFile_file_name_length(PointerRNA *ptr);
void CompositorNodeOutputFile_file_name_set(PointerRNA *ptr, const char *value);

void CompositorNodeOutputFile_file_output_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CompositorNodeOutputFile_file_output_items_next(CollectionPropertyIterator *iter);
void CompositorNodeOutputFile_file_output_items_end(CollectionPropertyIterator *iter);
int CompositorNodeOutputFile_file_output_items_length(PointerRNA *ptr);
bool CompositorNodeOutputFile_file_output_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool CompositorNodeOutputFile_file_output_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool CompositorNodeOutputFile_save_as_render_get(PointerRNA *ptr);
void CompositorNodeOutputFile_save_as_render_set(PointerRNA *ptr, bool value);

PointerRNA CompositorNodeOutputFile_format_get(PointerRNA *ptr);

bool CompositorNodeOutputFile_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeOutputFile_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeOutputFile_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodePixelate ****************/

extern StructRNA RNA_CompositorNodePixelate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodePixelate_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodePixelate_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePixelate_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodePlaneTrackDeform ****************/

extern StructRNA RNA_CompositorNodePlaneTrackDeform;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodePlaneTrackDeform_clip_get(PointerRNA *ptr);

#define CompositorNodePlaneTrackDeform_plane_track_name_MAX 64

void CompositorNodePlaneTrackDeform_plane_track_name_get(PointerRNA *ptr, char *value);
int CompositorNodePlaneTrackDeform_plane_track_name_length(PointerRNA *ptr);
void CompositorNodePlaneTrackDeform_plane_track_name_set(PointerRNA *ptr, const char *value);

#define CompositorNodePlaneTrackDeform_tracking_object_MAX 64

void CompositorNodePlaneTrackDeform_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodePlaneTrackDeform_tracking_object_length(PointerRNA *ptr);
void CompositorNodePlaneTrackDeform_tracking_object_set(PointerRNA *ptr, const char *value);

bool CompositorNodePlaneTrackDeform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodePlaneTrackDeform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePlaneTrackDeform_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodePosterize ****************/

extern StructRNA RNA_CompositorNodePosterize;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodePosterize_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodePosterize_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePosterize_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodePremulKey ****************/

extern StructRNA RNA_CompositorNodePremulKey;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodePremulKey_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodePremulKey_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodePremulKey_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeRGB ****************/

extern StructRNA RNA_CompositorNodeRGB;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeRGB_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeRGB_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRGB_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeRGBToBW ****************/

extern StructRNA RNA_CompositorNodeRGBToBW;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeRGBToBW_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeRGBToBW_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRGBToBW_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeRLayers ****************/

extern StructRNA RNA_CompositorNodeRLayers;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeRLayers_layer_PLACEHOLDER = 0,
};

int CompositorNodeRLayers_layer_get(PointerRNA *ptr);
void CompositorNodeRLayers_layer_set(PointerRNA *ptr, int value);

PointerRNA CompositorNodeRLayers_scene_get(PointerRNA *ptr);

bool CompositorNodeRLayers_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeRLayers_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRLayers_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeRelativeToPixel ****************/

extern StructRNA RNA_CompositorNodeRelativeToPixel;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeRelativeToPixel_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeRelativeToPixel_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRelativeToPixel_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeRotate ****************/

extern StructRNA RNA_CompositorNodeRotate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeRotate_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeRotate_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeRotate_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeScale ****************/

extern StructRNA RNA_CompositorNodeScale;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeScale_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeScale_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeScale_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSceneTime ****************/

extern StructRNA RNA_CompositorNodeSceneTime;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeSceneTime_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSceneTime_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSceneTime_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSeparateColor ****************/

extern StructRNA RNA_CompositorNodeSeparateColor;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	CompositorNodeSeparateColor_ycc_mode_ITUBT601 = 0,
	CompositorNodeSeparateColor_ycc_mode_ITUBT709 = 1,
	CompositorNodeSeparateColor_ycc_mode_JFIF = 2,
};

int CompositorNodeSeparateColor_ycc_mode_get(PointerRNA *ptr);
void CompositorNodeSeparateColor_ycc_mode_set(PointerRNA *ptr, int value);

enum {
	CompositorNodeSeparateColor_mode_RGB = 0,
	CompositorNodeSeparateColor_mode_HSV = 1,
	CompositorNodeSeparateColor_mode_HSL = 2,
	CompositorNodeSeparateColor_mode_YCC = 3,
	CompositorNodeSeparateColor_mode_YUV = 4,
};

int CompositorNodeSeparateColor_mode_get(PointerRNA *ptr);
void CompositorNodeSeparateColor_mode_set(PointerRNA *ptr, int value);

bool CompositorNodeSeparateColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSeparateColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSeparateColor_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSetAlpha ****************/

extern StructRNA RNA_CompositorNodeSetAlpha;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeSetAlpha_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSetAlpha_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSetAlpha_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSplit ****************/

extern StructRNA RNA_CompositorNodeSplit;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeSplit_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSplit_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSplit_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeStabilize ****************/

extern StructRNA RNA_CompositorNodeStabilize;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeStabilize_clip_get(PointerRNA *ptr);

bool CompositorNodeStabilize_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeStabilize_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeStabilize_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSwitch ****************/

extern StructRNA RNA_CompositorNodeSwitch;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeSwitch_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSwitch_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSwitch_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeSwitchView ****************/

extern StructRNA RNA_CompositorNodeSwitchView;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeSwitchView_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeSwitchView_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeSwitchView_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeTime ****************/

extern StructRNA RNA_CompositorNodeTime;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeTime_curve_get(PointerRNA *ptr);

bool CompositorNodeTime_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeTime_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTime_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeTonemap ****************/

extern StructRNA RNA_CompositorNodeTonemap;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeTonemap_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeTonemap_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTonemap_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeTrackPos ****************/

extern StructRNA RNA_CompositorNodeTrackPos;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA CompositorNodeTrackPos_clip_get(PointerRNA *ptr);

#define CompositorNodeTrackPos_track_name_MAX 64

void CompositorNodeTrackPos_track_name_get(PointerRNA *ptr, char *value);
int CompositorNodeTrackPos_track_name_length(PointerRNA *ptr);
void CompositorNodeTrackPos_track_name_set(PointerRNA *ptr, const char *value);

#define CompositorNodeTrackPos_tracking_object_MAX 64

void CompositorNodeTrackPos_tracking_object_get(PointerRNA *ptr, char *value);
int CompositorNodeTrackPos_tracking_object_length(PointerRNA *ptr);
void CompositorNodeTrackPos_tracking_object_set(PointerRNA *ptr, const char *value);

bool CompositorNodeTrackPos_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeTrackPos_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTrackPos_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeTransform ****************/

extern StructRNA RNA_CompositorNodeTransform;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTransform_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeTranslate ****************/

extern StructRNA RNA_CompositorNodeTranslate;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeTranslate_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeTranslate_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeTranslate_output_template_func(struct StructRNA *_type, int index);
/**************** Compositor Node Tree ****************/

extern StructRNA RNA_CompositorNodeTree;
extern StructRNA RNA_NodeTree;
extern StructRNA RNA_ID;

bool CompositorNodeTree_use_viewer_border_get(PointerRNA *ptr);
void CompositorNodeTree_use_viewer_border_set(PointerRNA *ptr, bool value);

/**************** CompositorNodeVecBlur ****************/

extern StructRNA RNA_CompositorNodeVecBlur;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeVecBlur_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeVecBlur_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeVecBlur_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeViewer ****************/

extern StructRNA RNA_CompositorNodeViewer;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int CompositorNodeViewer_ui_shortcut_get(PointerRNA *ptr);
void CompositorNodeViewer_ui_shortcut_set(PointerRNA *ptr, int value);

bool CompositorNodeViewer_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeViewer_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeViewer_output_template_func(struct StructRNA *_type, int index);
/**************** CompositorNodeZcombine ****************/

extern StructRNA RNA_CompositorNodeZcombine;
extern StructRNA RNA_CompositorNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool CompositorNodeZcombine_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA CompositorNodeZcombine_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA CompositorNodeZcombine_output_template_func(struct StructRNA *_type, int index);
/**************** Console Input ****************/

extern StructRNA RNA_ConsoleLine;

PointerRNA ConsoleLine_rna_type_get(PointerRNA *ptr);

void ConsoleLine_body_get(PointerRNA *ptr, char *value);
int ConsoleLine_body_length(PointerRNA *ptr);
void ConsoleLine_body_set(PointerRNA *ptr, const char *value);

enum {
	ConsoleLine_type_OUTPUT = 0,
	ConsoleLine_type_INPUT = 1,
	ConsoleLine_type_INFO = 2,
	ConsoleLine_type_ERROR = 3,
};

int ConsoleLine_type_get(PointerRNA *ptr);
void ConsoleLine_type_set(PointerRNA *ptr, int value);

int ConsoleLine_current_character_get(PointerRNA *ptr);
void ConsoleLine_current_character_set(PointerRNA *ptr, int value);

/**************** Constraint ****************/

extern StructRNA RNA_Constraint;

PointerRNA Constraint_rna_type_get(PointerRNA *ptr);

#define Constraint_name_MAX 64

void Constraint_name_get(PointerRNA *ptr, char *value);
int Constraint_name_length(PointerRNA *ptr);
void Constraint_name_set(PointerRNA *ptr, const char *value);

bool Constraint_active_get(PointerRNA *ptr);
void Constraint_active_set(PointerRNA *ptr, bool value);

bool Constraint_mute_get(PointerRNA *ptr);
void Constraint_mute_set(PointerRNA *ptr, bool value);

bool Constraint_enabled_get(PointerRNA *ptr);
void Constraint_enabled_set(PointerRNA *ptr, bool value);

bool Constraint_show_expanded_get(PointerRNA *ptr);
void Constraint_show_expanded_set(PointerRNA *ptr, bool value);

float Constraint_influence_get(PointerRNA *ptr);
void Constraint_influence_set(PointerRNA *ptr, float value);

float Constraint_error_location_get(PointerRNA *ptr);
void Constraint_error_location_set(PointerRNA *ptr, float value);

PointerRNA Constraint_space_object_get(PointerRNA *ptr);

bool Constraint_is_override_data_get(PointerRNA *ptr);
void Constraint_is_override_data_set(PointerRNA *ptr, bool value);

enum {
	Constraint_owner_space_WORLD = 0,
	Constraint_owner_space_CUSTOM = 5,
	Constraint_owner_space_POSE = 2,
	Constraint_owner_space_LOCAL_WITH_PARENT = 3,
	Constraint_owner_space_LOCAL = 1,
};

int Constraint_owner_space_get(PointerRNA *ptr);
void Constraint_owner_space_set(PointerRNA *ptr, int value);

float Constraint_error_rotation_get(PointerRNA *ptr);
void Constraint_error_rotation_set(PointerRNA *ptr, float value);

#define Constraint_space_subtarget_MAX 64

void Constraint_space_subtarget_get(PointerRNA *ptr, char *value);
int Constraint_space_subtarget_length(PointerRNA *ptr);
void Constraint_space_subtarget_set(PointerRNA *ptr, const char *value);

enum {
	Constraint_target_space_WORLD = 0,
	Constraint_target_space_CUSTOM = 5,
	Constraint_target_space_POSE = 2,
	Constraint_target_space_LOCAL_WITH_PARENT = 3,
	Constraint_target_space_LOCAL = 1,
	Constraint_target_space_LOCAL_OWNER_ORIENT = 6,
};

int Constraint_target_space_get(PointerRNA *ptr);
void Constraint_target_space_set(PointerRNA *ptr, int value);

enum {
	Constraint_type_CAMERA_SOLVER = 27,
	Constraint_type_FOLLOW_TRACK = 26,
	Constraint_type_OBJECT_SOLVER = 28,
	Constraint_type_COPY_LOCATION = 9,
	Constraint_type_COPY_ROTATION = 8,
	Constraint_type_COPY_SCALE = 10,
	Constraint_type_COPY_TRANSFORMS = 23,
	Constraint_type_LIMIT_DISTANCE = 14,
	Constraint_type_LIMIT_LOCATION = 6,
	Constraint_type_LIMIT_ROTATION = 5,
	Constraint_type_LIMIT_SCALE = 7,
	Constraint_type_MAINTAIN_VOLUME = 24,
	Constraint_type_TRANSFORM = 19,
	Constraint_type_TRANSFORM_CACHE = 29,
	Constraint_type_CLAMP_TO = 18,
	Constraint_type_DAMPED_TRACK = 21,
	Constraint_type_IK = 3,
	Constraint_type_LOCKED_TRACK = 13,
	Constraint_type_SPLINE_IK = 22,
	Constraint_type_STRETCH_TO = 15,
	Constraint_type_TRACK_TO = 2,
	Constraint_type_ACTION = 12,
	Constraint_type_ARMATURE = 30,
	Constraint_type_CHILD_OF = 1,
	Constraint_type_FLOOR = 16,
	Constraint_type_FOLLOW_PATH = 4,
	Constraint_type_GEOMETRY_ATTRIBUTE = 31,
	Constraint_type_PIVOT = 25,
	Constraint_type_SHRINKWRAP = 20,
};

int Constraint_type_get(PointerRNA *ptr);
void Constraint_type_set(PointerRNA *ptr, int value);

bool Constraint_is_valid_get(PointerRNA *ptr);
void Constraint_is_valid_set(PointerRNA *ptr, bool value);

/**************** Constraint Target ****************/

extern StructRNA RNA_ConstraintTarget;

PointerRNA ConstraintTarget_rna_type_get(PointerRNA *ptr);

#define ConstraintTarget_subtarget_MAX 64

void ConstraintTarget_subtarget_get(PointerRNA *ptr, char *value);
int ConstraintTarget_subtarget_length(PointerRNA *ptr);
void ConstraintTarget_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ConstraintTarget_target_get(PointerRNA *ptr);

/**************** Constraint Target Bone ****************/

extern StructRNA RNA_ConstraintTargetBone;

PointerRNA ConstraintTargetBone_rna_type_get(PointerRNA *ptr);

float ConstraintTargetBone_weight_get(PointerRNA *ptr);
void ConstraintTargetBone_weight_set(PointerRNA *ptr, float value);

#define ConstraintTargetBone_subtarget_MAX 64

void ConstraintTargetBone_subtarget_get(PointerRNA *ptr, char *value);
int ConstraintTargetBone_subtarget_length(PointerRNA *ptr);
void ConstraintTargetBone_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA ConstraintTargetBone_target_get(PointerRNA *ptr);

/**************** Context ****************/

extern StructRNA RNA_Context;

PointerRNA Context_rna_type_get(PointerRNA *ptr);

PointerRNA Context_space_data_get(PointerRNA *ptr);

PointerRNA Context_region_popup_get(PointerRNA *ptr);

PointerRNA Context_area_get(PointerRNA *ptr);

PointerRNA Context_asset_get(PointerRNA *ptr);

PointerRNA Context_blend_data_get(PointerRNA *ptr);

PointerRNA Context_collection_get(PointerRNA *ptr);

void Context_engine_get(PointerRNA *ptr, char *value);
int Context_engine_length(PointerRNA *ptr);
void Context_engine_set(PointerRNA *ptr, const char *value);

PointerRNA Context_gizmo_group_get(PointerRNA *ptr);

PointerRNA Context_layer_collection_get(PointerRNA *ptr);

enum {
	Context_mode_EDIT_MESH = 0,
	Context_mode_EDIT_CURVE = 1,
	Context_mode_EDIT_CURVES = 7,
	Context_mode_EDIT_SURFACE = 2,
	Context_mode_EDIT_TEXT = 3,
	Context_mode_EDIT_ARMATURE = 4,
	Context_mode_EDIT_METABALL = 5,
	Context_mode_EDIT_LATTICE = 6,
	Context_mode_EDIT_GREASE_PENCIL = 8,
	Context_mode_EDIT_POINTCLOUD = 9,
	Context_mode_POSE = 10,
	Context_mode_SCULPT = 11,
	Context_mode_PAINT_WEIGHT = 12,
	Context_mode_PAINT_VERTEX = 13,
	Context_mode_PAINT_TEXTURE = 14,
	Context_mode_PARTICLE = 15,
	Context_mode_OBJECT = 16,
	Context_mode_PAINT_GPENCIL = 17,
	Context_mode_EDIT_GPENCIL = 18,
	Context_mode_SCULPT_GPENCIL = 19,
	Context_mode_WEIGHT_GPENCIL = 20,
	Context_mode_VERTEX_GPENCIL = 21,
	Context_mode_SCULPT_CURVES = 22,
	Context_mode_PAINT_GREASE_PENCIL = 23,
	Context_mode_SCULPT_GREASE_PENCIL = 24,
	Context_mode_WEIGHT_GREASE_PENCIL = 25,
	Context_mode_VERTEX_GREASE_PENCIL = 26,
};

int Context_mode_get(PointerRNA *ptr);
void Context_mode_set(PointerRNA *ptr, int value);

PointerRNA Context_preferences_get(PointerRNA *ptr);

PointerRNA Context_region_get(PointerRNA *ptr);

PointerRNA Context_region_data_get(PointerRNA *ptr);

PointerRNA Context_scene_get(PointerRNA *ptr);

PointerRNA Context_screen_get(PointerRNA *ptr);

PointerRNA Context_tool_settings_get(PointerRNA *ptr);

PointerRNA Context_view_layer_get(PointerRNA *ptr);

PointerRNA Context_window_get(PointerRNA *ptr);

PointerRNA Context_window_manager_get(PointerRNA *ptr);

PointerRNA Context_workspace_get(PointerRNA *ptr);

struct Depsgraph *Context_evaluated_depsgraph_get_func(struct bContext *_self);
/**************** Copy Location Constraint ****************/

extern StructRNA RNA_CopyLocationConstraint;
extern StructRNA RNA_Constraint;

bool CopyLocationConstraint_use_x_get(PointerRNA *ptr);
void CopyLocationConstraint_use_x_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_use_y_get(PointerRNA *ptr);
void CopyLocationConstraint_use_y_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_use_z_get(PointerRNA *ptr);
void CopyLocationConstraint_use_z_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_use_bbone_shape_get(PointerRNA *ptr);
void CopyLocationConstraint_use_bbone_shape_set(PointerRNA *ptr, bool value);

float CopyLocationConstraint_head_tail_get(PointerRNA *ptr);
void CopyLocationConstraint_head_tail_set(PointerRNA *ptr, float value);

bool CopyLocationConstraint_invert_x_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_x_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_invert_y_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_y_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_invert_z_get(PointerRNA *ptr);
void CopyLocationConstraint_invert_z_set(PointerRNA *ptr, bool value);

bool CopyLocationConstraint_use_offset_get(PointerRNA *ptr);
void CopyLocationConstraint_use_offset_set(PointerRNA *ptr, bool value);

#define CopyLocationConstraint_subtarget_MAX 64

void CopyLocationConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyLocationConstraint_subtarget_length(PointerRNA *ptr);
void CopyLocationConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyLocationConstraint_target_get(PointerRNA *ptr);

/**************** Copy Rotation Constraint ****************/

extern StructRNA RNA_CopyRotationConstraint;
extern StructRNA RNA_Constraint;

bool CopyRotationConstraint_use_x_get(PointerRNA *ptr);
void CopyRotationConstraint_use_x_set(PointerRNA *ptr, bool value);

bool CopyRotationConstraint_use_y_get(PointerRNA *ptr);
void CopyRotationConstraint_use_y_set(PointerRNA *ptr, bool value);

bool CopyRotationConstraint_use_z_get(PointerRNA *ptr);
void CopyRotationConstraint_use_z_set(PointerRNA *ptr, bool value);

enum {
	CopyRotationConstraint_euler_order_AUTO = 0,
	CopyRotationConstraint_euler_order_XYZ = 1,
	CopyRotationConstraint_euler_order_XZY = 2,
	CopyRotationConstraint_euler_order_YXZ = 3,
	CopyRotationConstraint_euler_order_YZX = 4,
	CopyRotationConstraint_euler_order_ZXY = 5,
	CopyRotationConstraint_euler_order_ZYX = 6,
};

int CopyRotationConstraint_euler_order_get(PointerRNA *ptr);
void CopyRotationConstraint_euler_order_set(PointerRNA *ptr, int value);

bool CopyRotationConstraint_invert_x_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_x_set(PointerRNA *ptr, bool value);

bool CopyRotationConstraint_invert_y_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_y_set(PointerRNA *ptr, bool value);

bool CopyRotationConstraint_invert_z_get(PointerRNA *ptr);
void CopyRotationConstraint_invert_z_set(PointerRNA *ptr, bool value);

enum {
	CopyRotationConstraint_mix_mode_REPLACE = 0,
	CopyRotationConstraint_mix_mode_ADD = 2,
	CopyRotationConstraint_mix_mode_BEFORE = 3,
	CopyRotationConstraint_mix_mode_AFTER = 4,
	CopyRotationConstraint_mix_mode_OFFSET = 1,
};

int CopyRotationConstraint_mix_mode_get(PointerRNA *ptr);
void CopyRotationConstraint_mix_mode_set(PointerRNA *ptr, int value);

bool CopyRotationConstraint_use_offset_get(PointerRNA *ptr);
void CopyRotationConstraint_use_offset_set(PointerRNA *ptr, bool value);

#define CopyRotationConstraint_subtarget_MAX 64

void CopyRotationConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyRotationConstraint_subtarget_length(PointerRNA *ptr);
void CopyRotationConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyRotationConstraint_target_get(PointerRNA *ptr);

/**************** Copy Scale Constraint ****************/

extern StructRNA RNA_CopyScaleConstraint;
extern StructRNA RNA_Constraint;

bool CopyScaleConstraint_use_add_get(PointerRNA *ptr);
void CopyScaleConstraint_use_add_set(PointerRNA *ptr, bool value);

bool CopyScaleConstraint_use_x_get(PointerRNA *ptr);
void CopyScaleConstraint_use_x_set(PointerRNA *ptr, bool value);

bool CopyScaleConstraint_use_y_get(PointerRNA *ptr);
void CopyScaleConstraint_use_y_set(PointerRNA *ptr, bool value);

bool CopyScaleConstraint_use_z_get(PointerRNA *ptr);
void CopyScaleConstraint_use_z_set(PointerRNA *ptr, bool value);

bool CopyScaleConstraint_use_make_uniform_get(PointerRNA *ptr);
void CopyScaleConstraint_use_make_uniform_set(PointerRNA *ptr, bool value);

bool CopyScaleConstraint_use_offset_get(PointerRNA *ptr);
void CopyScaleConstraint_use_offset_set(PointerRNA *ptr, bool value);

float CopyScaleConstraint_power_get(PointerRNA *ptr);
void CopyScaleConstraint_power_set(PointerRNA *ptr, float value);

#define CopyScaleConstraint_subtarget_MAX 64

void CopyScaleConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyScaleConstraint_subtarget_length(PointerRNA *ptr);
void CopyScaleConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyScaleConstraint_target_get(PointerRNA *ptr);

/**************** Copy Transforms Constraint ****************/

extern StructRNA RNA_CopyTransformsConstraint;
extern StructRNA RNA_Constraint;

bool CopyTransformsConstraint_use_bbone_shape_get(PointerRNA *ptr);
void CopyTransformsConstraint_use_bbone_shape_set(PointerRNA *ptr, bool value);

float CopyTransformsConstraint_head_tail_get(PointerRNA *ptr);
void CopyTransformsConstraint_head_tail_set(PointerRNA *ptr, float value);

enum {
	CopyTransformsConstraint_mix_mode_REPLACE = 0,
	CopyTransformsConstraint_mix_mode_BEFORE_FULL = 5,
	CopyTransformsConstraint_mix_mode_BEFORE = 1,
	CopyTransformsConstraint_mix_mode_BEFORE_SPLIT = 3,
	CopyTransformsConstraint_mix_mode_AFTER_FULL = 6,
	CopyTransformsConstraint_mix_mode_AFTER = 2,
	CopyTransformsConstraint_mix_mode_AFTER_SPLIT = 4,
};

int CopyTransformsConstraint_mix_mode_get(PointerRNA *ptr);
void CopyTransformsConstraint_mix_mode_set(PointerRNA *ptr, int value);

bool CopyTransformsConstraint_remove_target_shear_get(PointerRNA *ptr);
void CopyTransformsConstraint_remove_target_shear_set(PointerRNA *ptr, bool value);

#define CopyTransformsConstraint_subtarget_MAX 64

void CopyTransformsConstraint_subtarget_get(PointerRNA *ptr, char *value);
int CopyTransformsConstraint_subtarget_length(PointerRNA *ptr);
void CopyTransformsConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA CopyTransformsConstraint_target_get(PointerRNA *ptr);

/**************** Corrective Smooth Modifier ****************/

extern StructRNA RNA_CorrectiveSmoothModifier;
extern StructRNA RNA_Modifier;

bool CorrectiveSmoothModifier_is_bind_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_is_bind_set(PointerRNA *ptr, bool value);

bool CorrectiveSmoothModifier_invert_vertex_group_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

float CorrectiveSmoothModifier_factor_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_factor_set(PointerRNA *ptr, float value);

bool CorrectiveSmoothModifier_use_only_smooth_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_use_only_smooth_set(PointerRNA *ptr, bool value);

bool CorrectiveSmoothModifier_use_pin_boundary_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_use_pin_boundary_set(PointerRNA *ptr, bool value);

int CorrectiveSmoothModifier_iterations_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_iterations_set(PointerRNA *ptr, int value);

enum {
	CorrectiveSmoothModifier_rest_source_ORCO = 0,
	CorrectiveSmoothModifier_rest_source_BIND = 1,
};

int CorrectiveSmoothModifier_rest_source_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_rest_source_set(PointerRNA *ptr, int value);

float CorrectiveSmoothModifier_scale_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_scale_set(PointerRNA *ptr, float value);

enum {
	CorrectiveSmoothModifier_smooth_type_SIMPLE = 0,
	CorrectiveSmoothModifier_smooth_type_LENGTH_WEIGHTED = 1,
};

int CorrectiveSmoothModifier_smooth_type_get(PointerRNA *ptr);
void CorrectiveSmoothModifier_smooth_type_set(PointerRNA *ptr, int value);

#define CorrectiveSmoothModifier_vertex_group_MAX 64

void CorrectiveSmoothModifier_vertex_group_get(PointerRNA *ptr, char *value);
int CorrectiveSmoothModifier_vertex_group_length(PointerRNA *ptr);
void CorrectiveSmoothModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Crossfade Strip ****************/

extern StructRNA RNA_CrossStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA CrossStrip_input_1_get(PointerRNA *ptr);

PointerRNA CrossStrip_input_2_get(PointerRNA *ptr);

int CrossStrip_input_count_get(PointerRNA *ptr);
void CrossStrip_input_count_set(PointerRNA *ptr, int value);

/**************** CryptomatteEntry ****************/

extern StructRNA RNA_CryptomatteEntry;

PointerRNA CryptomatteEntry_rna_type_get(PointerRNA *ptr);

#define CryptomatteEntry_name_MAX 64

void CryptomatteEntry_name_get(PointerRNA *ptr, char *value);
int CryptomatteEntry_name_length(PointerRNA *ptr);
void CryptomatteEntry_name_set(PointerRNA *ptr, const char *value);

float CryptomatteEntry_encoded_hash_get(PointerRNA *ptr);
void CryptomatteEntry_encoded_hash_set(PointerRNA *ptr, float value);

/**************** Curve ****************/

extern StructRNA RNA_Curve;
extern StructRNA RNA_ID;

PointerRNA Curve_animation_data_get(PointerRNA *ptr);

bool Curve_use_auto_texspace_get(PointerRNA *ptr);
void Curve_use_auto_texspace_set(PointerRNA *ptr, bool value);

float Curve_bevel_depth_get(PointerRNA *ptr);
void Curve_bevel_depth_set(PointerRNA *ptr, float value);

enum {
	Curve_bevel_mode_ROUND = 0,
	Curve_bevel_mode_OBJECT = 1,
	Curve_bevel_mode_PROFILE = 2,
};

int Curve_bevel_mode_get(PointerRNA *ptr);
void Curve_bevel_mode_set(PointerRNA *ptr, int value);

PointerRNA Curve_bevel_object_get(PointerRNA *ptr);

int Curve_bevel_resolution_get(PointerRNA *ptr);
void Curve_bevel_resolution_set(PointerRNA *ptr, int value);

bool Curve_use_deform_bounds_get(PointerRNA *ptr);
void Curve_use_deform_bounds_set(PointerRNA *ptr, bool value);

bool Curve_use_path_clamp_get(PointerRNA *ptr);
void Curve_use_path_clamp_set(PointerRNA *ptr, bool value);

PointerRNA Curve_bevel_profile_get(PointerRNA *ptr);

enum {
	Curve_dimensions_2D = 0,
	Curve_dimensions_3D = 1,
};

int Curve_dimensions_get(PointerRNA *ptr);
void Curve_dimensions_set(PointerRNA *ptr, int value);

enum {
	Curve_bevel_factor_mapping_end_RESOLUTION = 0,
	Curve_bevel_factor_mapping_end_SEGMENTS = 1,
	Curve_bevel_factor_mapping_end_SPLINE = 2,
};

int Curve_bevel_factor_mapping_end_get(PointerRNA *ptr);
void Curve_bevel_factor_mapping_end_set(PointerRNA *ptr, int value);

float Curve_eval_time_get(PointerRNA *ptr);
void Curve_eval_time_set(PointerRNA *ptr, float value);

float Curve_extrude_get(PointerRNA *ptr);
void Curve_extrude_set(PointerRNA *ptr, float value);

bool Curve_use_fill_caps_get(PointerRNA *ptr);
void Curve_use_fill_caps_set(PointerRNA *ptr, bool value);

enum {
	Curve_fill_mode_FULL = 0,
	Curve_fill_mode_BACK = 4,
	Curve_fill_mode_FRONT = 2,
	Curve_fill_mode_HALF = 6,
};

int Curve_fill_mode_get(PointerRNA *ptr);
void Curve_fill_mode_set(PointerRNA *ptr, int value);

bool Curve_use_path_follow_get(PointerRNA *ptr);
void Curve_use_path_follow_set(PointerRNA *ptr, bool value);

float Curve_bevel_factor_end_get(PointerRNA *ptr);
void Curve_bevel_factor_end_set(PointerRNA *ptr, float value);

float Curve_bevel_factor_start_get(PointerRNA *ptr);
void Curve_bevel_factor_start_set(PointerRNA *ptr, float value);

bool Curve_is_editmode_get(PointerRNA *ptr);
void Curve_is_editmode_set(PointerRNA *ptr, bool value);

bool Curve_use_map_taper_get(PointerRNA *ptr);
void Curve_use_map_taper_set(PointerRNA *ptr, bool value);

void Curve_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curve_materials_next(CollectionPropertyIterator *iter);
void Curve_materials_end(CollectionPropertyIterator *iter);
int Curve_materials_length(PointerRNA *ptr);
bool Curve_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Curve_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float Curve_offset_get(PointerRNA *ptr);
void Curve_offset_set(PointerRNA *ptr, float value);

bool Curve_use_path_get(PointerRNA *ptr);
void Curve_use_path_set(PointerRNA *ptr, bool value);

int Curve_path_duration_get(PointerRNA *ptr);
void Curve_path_duration_set(PointerRNA *ptr, int value);

bool Curve_use_radius_get(PointerRNA *ptr);
void Curve_use_radius_set(PointerRNA *ptr, bool value);

int Curve_render_resolution_u_get(PointerRNA *ptr);
void Curve_render_resolution_u_set(PointerRNA *ptr, int value);

int Curve_render_resolution_v_get(PointerRNA *ptr);
void Curve_render_resolution_v_set(PointerRNA *ptr, int value);

int Curve_resolution_u_get(PointerRNA *ptr);
void Curve_resolution_u_set(PointerRNA *ptr, int value);

int Curve_resolution_v_get(PointerRNA *ptr);
void Curve_resolution_v_set(PointerRNA *ptr, int value);

PointerRNA Curve_shape_keys_get(PointerRNA *ptr);

void Curve_splines_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curve_splines_next(CollectionPropertyIterator *iter);
void Curve_splines_end(CollectionPropertyIterator *iter);

enum {
	Curve_bevel_factor_mapping_start_RESOLUTION = 0,
	Curve_bevel_factor_mapping_start_SEGMENTS = 1,
	Curve_bevel_factor_mapping_start_SPLINE = 2,
};

int Curve_bevel_factor_mapping_start_get(PointerRNA *ptr);
void Curve_bevel_factor_mapping_start_set(PointerRNA *ptr, int value);

bool Curve_use_stretch_get(PointerRNA *ptr);
void Curve_use_stretch_set(PointerRNA *ptr, bool value);

PointerRNA Curve_taper_object_get(PointerRNA *ptr);

enum {
	Curve_taper_radius_mode_OVERRIDE = 0,
	Curve_taper_radius_mode_MULTIPLY = 1,
	Curve_taper_radius_mode_ADD = 2,
};

int Curve_taper_radius_mode_get(PointerRNA *ptr);
void Curve_taper_radius_mode_set(PointerRNA *ptr, int value);

void Curve_texspace_location_get(PointerRNA *ptr, float values[3]);
void Curve_texspace_location_set(PointerRNA *ptr, const float values[3]);

void Curve_texspace_size_get(PointerRNA *ptr, float values[3]);
void Curve_texspace_size_set(PointerRNA *ptr, const float values[3]);

enum {
	Curve_twist_mode_Z_UP = 0,
	Curve_twist_mode_MINIMUM = 3,
	Curve_twist_mode_TANGENT = 4,
};

int Curve_twist_mode_get(PointerRNA *ptr);
void Curve_twist_mode_set(PointerRNA *ptr, int value);

float Curve_twist_smooth_get(PointerRNA *ptr);
void Curve_twist_smooth_set(PointerRNA *ptr, float value);

void Curve_transform_func(struct Curve *_self, float matrix[16], bool shape_keys);
bool Curve_validate_material_indices_func(struct Curve *_self);
void Curve_update_gpu_tag_func(struct Curve *_self);
/**************** CurveMap ****************/

extern StructRNA RNA_CurveMap;

PointerRNA CurveMap_rna_type_get(PointerRNA *ptr);

void CurveMap_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveMap_points_next(CollectionPropertyIterator *iter);
void CurveMap_points_end(CollectionPropertyIterator *iter);
int CurveMap_points_length(PointerRNA *ptr);
bool CurveMap_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** CurveMapPoint ****************/

extern StructRNA RNA_CurveMapPoint;

PointerRNA CurveMapPoint_rna_type_get(PointerRNA *ptr);

enum {
	CurveMapPoint_handle_type_AUTO = 0,
	CurveMapPoint_handle_type_AUTO_CLAMPED = 4,
	CurveMapPoint_handle_type_VECTOR = 2,
};

int CurveMapPoint_handle_type_get(PointerRNA *ptr);
void CurveMapPoint_handle_type_set(PointerRNA *ptr, int value);

void CurveMapPoint_location_get(PointerRNA *ptr, float values[2]);
void CurveMapPoint_location_set(PointerRNA *ptr, const float values[2]);

bool CurveMapPoint_select_get(PointerRNA *ptr);
void CurveMapPoint_select_set(PointerRNA *ptr, bool value);

/**************** Curve Map Point ****************/

extern StructRNA RNA_CurveMapPoints;

PointerRNA CurveMapPoints_rna_type_get(PointerRNA *ptr);

struct CurveMapPoint *CurveMapPoints_new_func(struct CurveMap *_self, float position, float value);
void CurveMapPoints_remove_func(struct CurveMap *_self, ReportList *reports, struct PointerRNA *point);
/**************** CurveMapping ****************/

extern StructRNA RNA_CurveMapping;

PointerRNA CurveMapping_rna_type_get(PointerRNA *ptr);

void CurveMapping_black_level_get(PointerRNA *ptr, float values[3]);
void CurveMapping_black_level_set(PointerRNA *ptr, const float values[3]);

bool CurveMapping_use_clip_get(PointerRNA *ptr);
void CurveMapping_use_clip_set(PointerRNA *ptr, bool value);

float CurveMapping_clip_max_x_get(PointerRNA *ptr);
void CurveMapping_clip_max_x_set(PointerRNA *ptr, float value);

float CurveMapping_clip_max_y_get(PointerRNA *ptr);
void CurveMapping_clip_max_y_set(PointerRNA *ptr, float value);

float CurveMapping_clip_min_x_get(PointerRNA *ptr);
void CurveMapping_clip_min_x_set(PointerRNA *ptr, float value);

float CurveMapping_clip_min_y_get(PointerRNA *ptr);
void CurveMapping_clip_min_y_set(PointerRNA *ptr, float value);

void CurveMapping_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveMapping_curves_next(CollectionPropertyIterator *iter);
void CurveMapping_curves_end(CollectionPropertyIterator *iter);
int CurveMapping_curves_length(PointerRNA *ptr);

enum {
	CurveMapping_extend_HORIZONTAL = 0,
	CurveMapping_extend_EXTRAPOLATED = 16,
};

int CurveMapping_extend_get(PointerRNA *ptr);
void CurveMapping_extend_set(PointerRNA *ptr, int value);

enum {
	CurveMapping_tone_STANDARD = 0,
	CurveMapping_tone_FILMLIKE = 2,
};

int CurveMapping_tone_get(PointerRNA *ptr);
void CurveMapping_tone_set(PointerRNA *ptr, int value);

void CurveMapping_white_level_get(PointerRNA *ptr, float values[3]);
void CurveMapping_white_level_set(PointerRNA *ptr, const float values[3]);

void CurveMapping_update_func(struct CurveMapping *_self);
void CurveMapping_reset_view_func(struct CurveMapping *_self);
void CurveMapping_initialize_func(struct CurveMapping *_self);
float CurveMapping_evaluate_func(struct CurveMapping *_self, ReportList *reports, struct CurveMap *curve, float position);
/**************** Curve Modifier ****************/

extern StructRNA RNA_CurveModifier;
extern StructRNA RNA_Modifier;

enum {
	CurveModifier_deform_axis_POS_X = 1,
	CurveModifier_deform_axis_POS_Y = 2,
	CurveModifier_deform_axis_POS_Z = 3,
	CurveModifier_deform_axis_NEG_X = 4,
	CurveModifier_deform_axis_NEG_Y = 5,
	CurveModifier_deform_axis_NEG_Z = 6,
};

int CurveModifier_deform_axis_get(PointerRNA *ptr);
void CurveModifier_deform_axis_set(PointerRNA *ptr, int value);

bool CurveModifier_invert_vertex_group_get(PointerRNA *ptr);
void CurveModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

PointerRNA CurveModifier_object_get(PointerRNA *ptr);

#define CurveModifier_vertex_group_MAX 64

void CurveModifier_vertex_group_get(PointerRNA *ptr, char *value);
int CurveModifier_vertex_group_length(PointerRNA *ptr);
void CurveModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Curve Paint Settings ****************/

extern StructRNA RNA_CurvePaintSettings;

PointerRNA CurvePaintSettings_rna_type_get(PointerRNA *ptr);

bool CurvePaintSettings_use_offset_absolute_get(PointerRNA *ptr);
void CurvePaintSettings_use_offset_absolute_set(PointerRNA *ptr, bool value);

float CurvePaintSettings_corner_angle_get(PointerRNA *ptr);
void CurvePaintSettings_corner_angle_set(PointerRNA *ptr, float value);

enum {
	CurvePaintSettings_depth_mode_CURSOR = 0,
	CurvePaintSettings_depth_mode_SURFACE = 1,
};

int CurvePaintSettings_depth_mode_get(PointerRNA *ptr);
void CurvePaintSettings_depth_mode_set(PointerRNA *ptr, int value);

bool CurvePaintSettings_use_corners_detect_get(PointerRNA *ptr);
void CurvePaintSettings_use_corners_detect_set(PointerRNA *ptr, bool value);

enum {
	CurvePaintSettings_fit_method_REFIT = 0,
	CurvePaintSettings_fit_method_SPLIT = 1,
};

int CurvePaintSettings_fit_method_get(PointerRNA *ptr);
void CurvePaintSettings_fit_method_set(PointerRNA *ptr, int value);

float CurvePaintSettings_surface_offset_get(PointerRNA *ptr);
void CurvePaintSettings_surface_offset_set(PointerRNA *ptr, float value);

bool CurvePaintSettings_use_stroke_endpoints_get(PointerRNA *ptr);
void CurvePaintSettings_use_stroke_endpoints_set(PointerRNA *ptr, bool value);

enum {
	CurvePaintSettings_surface_plane_NORMAL_VIEW = 0,
	CurvePaintSettings_surface_plane_NORMAL_SURFACE = 1,
	CurvePaintSettings_surface_plane_VIEW = 2,
};

int CurvePaintSettings_surface_plane_get(PointerRNA *ptr);
void CurvePaintSettings_surface_plane_set(PointerRNA *ptr, int value);

bool CurvePaintSettings_use_project_only_selected_get(PointerRNA *ptr);
void CurvePaintSettings_use_project_only_selected_set(PointerRNA *ptr, bool value);

float CurvePaintSettings_radius_max_get(PointerRNA *ptr);
void CurvePaintSettings_radius_max_set(PointerRNA *ptr, float value);

float CurvePaintSettings_radius_taper_end_get(PointerRNA *ptr);
void CurvePaintSettings_radius_taper_end_set(PointerRNA *ptr, float value);

float CurvePaintSettings_radius_min_get(PointerRNA *ptr);
void CurvePaintSettings_radius_min_set(PointerRNA *ptr, float value);

float CurvePaintSettings_radius_taper_start_get(PointerRNA *ptr);
void CurvePaintSettings_radius_taper_start_set(PointerRNA *ptr, float value);

int CurvePaintSettings_error_threshold_get(PointerRNA *ptr);
void CurvePaintSettings_error_threshold_set(PointerRNA *ptr, int value);

enum {
	CurvePaintSettings_curve_type_POLY = 0,
	CurvePaintSettings_curve_type_BEZIER = 1,
};

int CurvePaintSettings_curve_type_get(PointerRNA *ptr);
void CurvePaintSettings_curve_type_set(PointerRNA *ptr, int value);

bool CurvePaintSettings_use_pressure_radius_get(PointerRNA *ptr);
void CurvePaintSettings_use_pressure_radius_set(PointerRNA *ptr, bool value);

/**************** Curve Point ****************/

extern StructRNA RNA_CurvePoint;

PointerRNA CurvePoint_rna_type_get(PointerRNA *ptr);

int CurvePoint_index_get(PointerRNA *ptr);
void CurvePoint_index_set(PointerRNA *ptr, int value);

void CurvePoint_position_get(PointerRNA *ptr, float values[3]);
void CurvePoint_position_set(PointerRNA *ptr, const float values[3]);

float CurvePoint_radius_get(PointerRNA *ptr);
void CurvePoint_radius_set(PointerRNA *ptr, float value);

/**************** CurveProfile ****************/

extern StructRNA RNA_CurveProfile;

PointerRNA CurveProfile_rna_type_get(PointerRNA *ptr);

bool CurveProfile_use_clip_get(PointerRNA *ptr);
void CurveProfile_use_clip_set(PointerRNA *ptr, bool value);

void CurveProfile_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveProfile_points_next(CollectionPropertyIterator *iter);
void CurveProfile_points_end(CollectionPropertyIterator *iter);
int CurveProfile_points_length(PointerRNA *ptr);
bool CurveProfile_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	CurveProfile_preset_LINE = 0,
	CurveProfile_preset_SUPPORTS = 1,
	CurveProfile_preset_CORNICE = 2,
	CurveProfile_preset_CROWN = 3,
	CurveProfile_preset_STEPS = 4,
};

int CurveProfile_preset_get(PointerRNA *ptr);
void CurveProfile_preset_set(PointerRNA *ptr, int value);

bool CurveProfile_use_sample_even_lengths_get(PointerRNA *ptr);
void CurveProfile_use_sample_even_lengths_set(PointerRNA *ptr, bool value);

bool CurveProfile_use_sample_straight_edges_get(PointerRNA *ptr);
void CurveProfile_use_sample_straight_edges_set(PointerRNA *ptr, bool value);

void CurveProfile_segments_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveProfile_segments_next(CollectionPropertyIterator *iter);
void CurveProfile_segments_end(CollectionPropertyIterator *iter);
int CurveProfile_segments_length(PointerRNA *ptr);
bool CurveProfile_segments_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void CurveProfile_update_func(struct CurveProfile *_self);
void CurveProfile_reset_view_func(struct CurveProfile *_self);
void CurveProfile_initialize_func(struct CurveProfile *_self, int totsegments);
void CurveProfile_evaluate_func(struct CurveProfile *_self, ReportList *reports, float length_portion, float location[2]);
/**************** CurveProfilePoint ****************/

extern StructRNA RNA_CurveProfilePoint;

PointerRNA CurveProfilePoint_rna_type_get(PointerRNA *ptr);

enum {
	CurveProfilePoint_handle_type_1_AUTO = 1,
	CurveProfilePoint_handle_type_1_VECTOR = 2,
	CurveProfilePoint_handle_type_1_FREE = 0,
	CurveProfilePoint_handle_type_1_ALIGN = 3,
};

int CurveProfilePoint_handle_type_1_get(PointerRNA *ptr);
void CurveProfilePoint_handle_type_1_set(PointerRNA *ptr, int value);

void CurveProfilePoint_location_get(PointerRNA *ptr, float values[2]);
void CurveProfilePoint_location_set(PointerRNA *ptr, const float values[2]);

enum {
	CurveProfilePoint_handle_type_2_AUTO = 1,
	CurveProfilePoint_handle_type_2_VECTOR = 2,
	CurveProfilePoint_handle_type_2_FREE = 0,
	CurveProfilePoint_handle_type_2_ALIGN = 3,
};

int CurveProfilePoint_handle_type_2_get(PointerRNA *ptr);
void CurveProfilePoint_handle_type_2_set(PointerRNA *ptr, int value);

bool CurveProfilePoint_select_get(PointerRNA *ptr);
void CurveProfilePoint_select_set(PointerRNA *ptr, bool value);

/**************** Profile Point ****************/

extern StructRNA RNA_CurveProfilePoints;

PointerRNA CurveProfilePoints_rna_type_get(PointerRNA *ptr);

struct CurveProfilePoint *CurveProfilePoints_add_func(struct CurveProfile *_self, float x, float y);
void CurveProfilePoints_remove_func(struct CurveProfile *_self, ReportList *reports, struct PointerRNA *point);
/**************** Curve Slice ****************/

extern StructRNA RNA_CurveSlice;

PointerRNA CurveSlice_rna_type_get(PointerRNA *ptr);

int CurveSlice_first_point_index_get(PointerRNA *ptr);
void CurveSlice_first_point_index_set(PointerRNA *ptr, int value);

int CurveSlice_index_get(PointerRNA *ptr);
void CurveSlice_index_set(PointerRNA *ptr, int value);

int CurveSlice_points_length_get(PointerRNA *ptr);
void CurveSlice_points_length_set(PointerRNA *ptr, int value);

void CurveSlice_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void CurveSlice_points_next(CollectionPropertyIterator *iter);
void CurveSlice_points_end(CollectionPropertyIterator *iter);
int CurveSlice_points_length(PointerRNA *ptr);

/**************** Curve Splines ****************/

extern StructRNA RNA_CurveSplines;

PointerRNA CurveSplines_rna_type_get(PointerRNA *ptr);

PointerRNA CurveSplines_active_get(PointerRNA *ptr);

struct Nurb *CurveSplines_new_func(struct Curve *_self, int type);
void CurveSplines_remove_func(struct Curve *_self, ReportList *reports, struct PointerRNA *spline);
void CurveSplines_clear_func(struct Curve *_self);
/**************** Hair Curves ****************/

extern StructRNA RNA_Curves;
extern StructRNA RNA_ID;

PointerRNA Curves_animation_data_get(PointerRNA *ptr);

void Curves_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_attributes_next(CollectionPropertyIterator *iter);
void Curves_attributes_end(CollectionPropertyIterator *iter);
int Curves_attributes_length(PointerRNA *ptr);
bool Curves_attributes_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float Curves_surface_collision_distance_get(PointerRNA *ptr);
void Curves_surface_collision_distance_set(PointerRNA *ptr, float value);

void Curves_color_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_color_attributes_next(CollectionPropertyIterator *iter);
void Curves_color_attributes_end(CollectionPropertyIterator *iter);
int Curves_color_attributes_length(PointerRNA *ptr);

void Curves_curves_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_curves_next(CollectionPropertyIterator *iter);
void Curves_curves_end(CollectionPropertyIterator *iter);
int Curves_curves_length(PointerRNA *ptr);
bool Curves_curves_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Curves_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_materials_next(CollectionPropertyIterator *iter);
void Curves_materials_end(CollectionPropertyIterator *iter);
int Curves_materials_length(PointerRNA *ptr);
bool Curves_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Curves_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Curves_normals_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_normals_next(CollectionPropertyIterator *iter);
void Curves_normals_end(CollectionPropertyIterator *iter);
int Curves_normals_length(PointerRNA *ptr);

void Curves_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_points_next(CollectionPropertyIterator *iter);
void Curves_points_end(CollectionPropertyIterator *iter);
int Curves_points_length(PointerRNA *ptr);
bool Curves_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	Curves_selection_domain_POINT = 0,
	Curves_selection_domain_CURVE = 4,
};

int Curves_selection_domain_get(PointerRNA *ptr);
void Curves_selection_domain_set(PointerRNA *ptr, int value);

PointerRNA Curves_surface_get(PointerRNA *ptr);

void Curves_surface_uv_map_get(PointerRNA *ptr, char *value);
int Curves_surface_uv_map_length(PointerRNA *ptr);
void Curves_surface_uv_map_set(PointerRNA *ptr, const char *value);

bool Curves_use_sculpt_collision_get(PointerRNA *ptr);
void Curves_use_sculpt_collision_set(PointerRNA *ptr, bool value);

bool Curves_use_mirror_x_get(PointerRNA *ptr);
void Curves_use_mirror_x_set(PointerRNA *ptr, bool value);

bool Curves_use_mirror_y_get(PointerRNA *ptr);
void Curves_use_mirror_y_set(PointerRNA *ptr, bool value);

bool Curves_use_mirror_z_get(PointerRNA *ptr);
void Curves_use_mirror_z_set(PointerRNA *ptr, bool value);

void Curves_curve_offset_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_curve_offset_data_next(CollectionPropertyIterator *iter);
void Curves_curve_offset_data_end(CollectionPropertyIterator *iter);
int Curves_curve_offset_data_length(PointerRNA *ptr);
bool Curves_curve_offset_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Curves_position_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Curves_position_data_next(CollectionPropertyIterator *iter);
void Curves_position_data_end(CollectionPropertyIterator *iter);
int Curves_position_data_length(PointerRNA *ptr);
bool Curves_position_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Curves_add_curves_func(struct Curves *_self, ReportList *reports, int sizes_num, int *sizes);
void Curves_remove_curves_func(struct Curves *_self, ReportList *reports, int indices_num, int *indices);
void Curves_resize_curves_func(struct Curves *_self, ReportList *reports, int sizes_num, int *sizes, int indices_num, int *indices);
void Curves_reorder_curves_func(struct Curves *_self, ReportList *reports, int new_indices_num, int *new_indices);
void Curves_set_types_func(struct Curves *_self, ReportList *reports, int type, int indices_num, int *indices);
const char * Curves_unit_test_compare_func(struct Curves *_self, struct Curves *curves, float threshold);
/**************** CurvesModifier ****************/

extern StructRNA RNA_CurvesModifier;
extern StructRNA RNA_StripModifier;

PointerRNA CurvesModifier_curve_mapping_get(PointerRNA *ptr);

bool CurvesModifier_open_mask_input_panel_get(PointerRNA *ptr);
void CurvesModifier_open_mask_input_panel_set(PointerRNA *ptr, bool value);

/**************** Curves Sculpt Paint ****************/

extern StructRNA RNA_CurvesSculpt;
extern StructRNA RNA_Paint;

/**************** Damped Track Constraint ****************/

extern StructRNA RNA_DampedTrackConstraint;
extern StructRNA RNA_Constraint;

bool DampedTrackConstraint_use_bbone_shape_get(PointerRNA *ptr);
void DampedTrackConstraint_use_bbone_shape_set(PointerRNA *ptr, bool value);

float DampedTrackConstraint_head_tail_get(PointerRNA *ptr);
void DampedTrackConstraint_head_tail_set(PointerRNA *ptr, float value);

#define DampedTrackConstraint_subtarget_MAX 64

void DampedTrackConstraint_subtarget_get(PointerRNA *ptr, char *value);
int DampedTrackConstraint_subtarget_length(PointerRNA *ptr);
void DampedTrackConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA DampedTrackConstraint_target_get(PointerRNA *ptr);

enum {
	DampedTrackConstraint_track_axis_TRACK_X = 0,
	DampedTrackConstraint_track_axis_TRACK_Y = 1,
	DampedTrackConstraint_track_axis_TRACK_Z = 2,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_X = 3,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_Y = 4,
	DampedTrackConstraint_track_axis_TRACK_NEGATIVE_Z = 5,
};

int DampedTrackConstraint_track_axis_get(PointerRNA *ptr);
void DampedTrackConstraint_track_axis_set(PointerRNA *ptr, int value);

/**************** Data Transfer Modifier ****************/

extern StructRNA RNA_DataTransferModifier;
extern StructRNA RNA_Modifier;

enum {
	DataTransferModifier_layers_vgroup_select_dst_ACTIVE = -1,
	DataTransferModifier_layers_vgroup_select_dst_NAME = -2,
	DataTransferModifier_layers_vgroup_select_dst_INDEX = -3,
};

int DataTransferModifier_layers_vgroup_select_dst_get(PointerRNA *ptr);
void DataTransferModifier_layers_vgroup_select_dst_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_vcol_vert_select_dst_ACTIVE = -1,
	DataTransferModifier_layers_vcol_vert_select_dst_NAME = -2,
	DataTransferModifier_layers_vcol_vert_select_dst_INDEX = -3,
};

int DataTransferModifier_layers_vcol_vert_select_dst_get(PointerRNA *ptr);
void DataTransferModifier_layers_vcol_vert_select_dst_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_vcol_loop_select_dst_ACTIVE = -1,
	DataTransferModifier_layers_vcol_loop_select_dst_NAME = -2,
	DataTransferModifier_layers_vcol_loop_select_dst_INDEX = -3,
};

int DataTransferModifier_layers_vcol_loop_select_dst_get(PointerRNA *ptr);
void DataTransferModifier_layers_vcol_loop_select_dst_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_uv_select_dst_ACTIVE = -1,
	DataTransferModifier_layers_uv_select_dst_NAME = -2,
	DataTransferModifier_layers_uv_select_dst_INDEX = -3,
};

int DataTransferModifier_layers_uv_select_dst_get(PointerRNA *ptr);
void DataTransferModifier_layers_uv_select_dst_set(PointerRNA *ptr, int value);

bool DataTransferModifier_use_edge_data_get(PointerRNA *ptr);
void DataTransferModifier_use_edge_data_set(PointerRNA *ptr, bool value);

enum {
	DataTransferModifier_data_types_edges_SHARP_EDGE = 256,
	DataTransferModifier_data_types_edges_SEAM = 512,
	DataTransferModifier_data_types_edges_CREASE = 1024,
	DataTransferModifier_data_types_edges_BEVEL_WEIGHT_EDGE = 2048,
	DataTransferModifier_data_types_edges_FREESTYLE_EDGE = 4096,
};

int DataTransferModifier_data_types_edges_get(PointerRNA *ptr);
void DataTransferModifier_data_types_edges_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_edge_mapping_TOPOLOGY = 251658240,
	DataTransferModifier_edge_mapping_VERT_NEAREST = 33554704,
	DataTransferModifier_edge_mapping_NEAREST = 33554720,
	DataTransferModifier_edge_mapping_POLY_NEAREST = 33554816,
	DataTransferModifier_edge_mapping_EDGEINTERP_VNORPROJ = 33555984,
};

int DataTransferModifier_edge_mapping_get(PointerRNA *ptr);
void DataTransferModifier_edge_mapping_set(PointerRNA *ptr, int value);

bool DataTransferModifier_use_loop_data_get(PointerRNA *ptr);
void DataTransferModifier_use_loop_data_set(PointerRNA *ptr, bool value);

enum {
	DataTransferModifier_data_types_loops_CUSTOM_NORMAL = 131072,
	DataTransferModifier_data_types_loops_COLOR_CORNER = 805306368,
	DataTransferModifier_data_types_loops_UV = 16777216,
};

int DataTransferModifier_data_types_loops_get(PointerRNA *ptr);
void DataTransferModifier_data_types_loops_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_loop_mapping_TOPOLOGY = 251658240,
	DataTransferModifier_loop_mapping_NEAREST_NORMAL = 67111248,
	DataTransferModifier_loop_mapping_NEAREST_POLYNOR = 67111312,
	DataTransferModifier_loop_mapping_NEAREST_POLY = 67109248,
	DataTransferModifier_loop_mapping_POLYINTERP_NEAREST = 67110272,
	DataTransferModifier_loop_mapping_POLYINTERP_LNORPROJ = 67110528,
};

int DataTransferModifier_loop_mapping_get(PointerRNA *ptr);
void DataTransferModifier_loop_mapping_set(PointerRNA *ptr, int value);

bool DataTransferModifier_use_poly_data_get(PointerRNA *ptr);
void DataTransferModifier_use_poly_data_set(PointerRNA *ptr, bool value);

enum {
	DataTransferModifier_poly_mapping_TOPOLOGY = 251658240,
	DataTransferModifier_poly_mapping_NEAREST = 134218112,
	DataTransferModifier_poly_mapping_NORMAL = 134219904,
	DataTransferModifier_poly_mapping_POLYINTERP_PNORPROJ = 134219392,
};

int DataTransferModifier_poly_mapping_get(PointerRNA *ptr);
void DataTransferModifier_poly_mapping_set(PointerRNA *ptr, int value);

bool DataTransferModifier_invert_vertex_group_get(PointerRNA *ptr);
void DataTransferModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

float DataTransferModifier_islands_precision_get(PointerRNA *ptr);
void DataTransferModifier_islands_precision_set(PointerRNA *ptr, float value);

float DataTransferModifier_max_distance_get(PointerRNA *ptr);
void DataTransferModifier_max_distance_set(PointerRNA *ptr, float value);

float DataTransferModifier_mix_factor_get(PointerRNA *ptr);
void DataTransferModifier_mix_factor_set(PointerRNA *ptr, float value);

enum {
	DataTransferModifier_mix_mode_REPLACE = 0,
	DataTransferModifier_mix_mode_ABOVE_THRESHOLD = 1,
	DataTransferModifier_mix_mode_BELOW_THRESHOLD = 2,
	DataTransferModifier_mix_mode_MIX = 16,
	DataTransferModifier_mix_mode_ADD = 17,
	DataTransferModifier_mix_mode_SUB = 18,
	DataTransferModifier_mix_mode_MUL = 19,
};

int DataTransferModifier_mix_mode_get(PointerRNA *ptr);
void DataTransferModifier_mix_mode_set(PointerRNA *ptr, int value);

bool DataTransferModifier_use_object_transform_get(PointerRNA *ptr);
void DataTransferModifier_use_object_transform_set(PointerRNA *ptr, bool value);

bool DataTransferModifier_use_max_distance_get(PointerRNA *ptr);
void DataTransferModifier_use_max_distance_set(PointerRNA *ptr, bool value);

enum {
	DataTransferModifier_data_types_polys_SMOOTH = 33554432,
	DataTransferModifier_data_types_polys_FREESTYLE_FACE = 67108864,
};

int DataTransferModifier_data_types_polys_get(PointerRNA *ptr);
void DataTransferModifier_data_types_polys_set(PointerRNA *ptr, int value);

float DataTransferModifier_ray_radius_get(PointerRNA *ptr);
void DataTransferModifier_ray_radius_set(PointerRNA *ptr, float value);

enum {
	DataTransferModifier_layers_vgroup_select_src_ACTIVE = -1,
	DataTransferModifier_layers_vgroup_select_src_ALL = -2,
	DataTransferModifier_layers_vgroup_select_src_BONE_SELECT = -257,
	DataTransferModifier_layers_vgroup_select_src_BONE_DEFORM = -258,
};

int DataTransferModifier_layers_vgroup_select_src_get(PointerRNA *ptr);
void DataTransferModifier_layers_vgroup_select_src_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_vcol_vert_select_src_ACTIVE = -1,
	DataTransferModifier_layers_vcol_vert_select_src_ALL = -2,
	DataTransferModifier_layers_vcol_vert_select_src_BONE_SELECT = -257,
	DataTransferModifier_layers_vcol_vert_select_src_BONE_DEFORM = -258,
};

int DataTransferModifier_layers_vcol_vert_select_src_get(PointerRNA *ptr);
void DataTransferModifier_layers_vcol_vert_select_src_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_vcol_loop_select_src_ACTIVE = -1,
	DataTransferModifier_layers_vcol_loop_select_src_ALL = -2,
	DataTransferModifier_layers_vcol_loop_select_src_BONE_SELECT = -257,
	DataTransferModifier_layers_vcol_loop_select_src_BONE_DEFORM = -258,
};

int DataTransferModifier_layers_vcol_loop_select_src_get(PointerRNA *ptr);
void DataTransferModifier_layers_vcol_loop_select_src_set(PointerRNA *ptr, int value);

enum {
	DataTransferModifier_layers_uv_select_src_ACTIVE = -1,
	DataTransferModifier_layers_uv_select_src_ALL = -2,
	DataTransferModifier_layers_uv_select_src_BONE_SELECT = -257,
	DataTransferModifier_layers_uv_select_src_BONE_DEFORM = -258,
};

int DataTransferModifier_layers_uv_select_src_get(PointerRNA *ptr);
void DataTransferModifier_layers_uv_select_src_set(PointerRNA *ptr, int value);

PointerRNA DataTransferModifier_object_get(PointerRNA *ptr);

bool DataTransferModifier_use_vert_data_get(PointerRNA *ptr);
void DataTransferModifier_use_vert_data_set(PointerRNA *ptr, bool value);

enum {
	DataTransferModifier_data_types_verts_VGROUP_WEIGHTS = 1,
	DataTransferModifier_data_types_verts_BEVEL_WEIGHT_VERT = 8,
	DataTransferModifier_data_types_verts_COLOR_VERTEX = 134283264,
};

int DataTransferModifier_data_types_verts_get(PointerRNA *ptr);
void DataTransferModifier_data_types_verts_set(PointerRNA *ptr, int value);

#define DataTransferModifier_vertex_group_MAX 64

void DataTransferModifier_vertex_group_get(PointerRNA *ptr, char *value);
int DataTransferModifier_vertex_group_length(PointerRNA *ptr);
void DataTransferModifier_vertex_group_set(PointerRNA *ptr, const char *value);

enum {
	DataTransferModifier_vert_mapping_TOPOLOGY = 251658240,
	DataTransferModifier_vert_mapping_NEAREST = 16777488,
	DataTransferModifier_vert_mapping_EDGE_NEAREST = 16777504,
	DataTransferModifier_vert_mapping_EDGEINTERP_NEAREST = 16778528,
	DataTransferModifier_vert_mapping_POLY_NEAREST = 16777600,
	DataTransferModifier_vert_mapping_POLYINTERP_NEAREST = 16778624,
	DataTransferModifier_vert_mapping_POLYINTERP_VNORPROJ = 16778880,
};

int DataTransferModifier_vert_mapping_get(PointerRNA *ptr);
void DataTransferModifier_vert_mapping_set(PointerRNA *ptr, int value);

/**************** Decimate Modifier ****************/

extern StructRNA RNA_DecimateModifier;
extern StructRNA RNA_Modifier;

bool DecimateModifier_use_dissolve_boundaries_get(PointerRNA *ptr);
void DecimateModifier_use_dissolve_boundaries_set(PointerRNA *ptr, bool value);

float DecimateModifier_angle_limit_get(PointerRNA *ptr);
void DecimateModifier_angle_limit_set(PointerRNA *ptr, float value);

enum {
	DecimateModifier_symmetry_axis_X = 0,
	DecimateModifier_symmetry_axis_Y = 1,
	DecimateModifier_symmetry_axis_Z = 2,
};

int DecimateModifier_symmetry_axis_get(PointerRNA *ptr);
void DecimateModifier_symmetry_axis_set(PointerRNA *ptr, int value);

enum {
	DecimateModifier_delimit_NORMAL = 1,
	DecimateModifier_delimit_MATERIAL = 2,
	DecimateModifier_delimit_SEAM = 4,
	DecimateModifier_delimit_SHARP = 8,
	DecimateModifier_delimit_UV = 16,
};

int DecimateModifier_delimit_get(PointerRNA *ptr);
void DecimateModifier_delimit_set(PointerRNA *ptr, int value);

int DecimateModifier_face_count_get(PointerRNA *ptr);
void DecimateModifier_face_count_set(PointerRNA *ptr, int value);

float DecimateModifier_vertex_group_factor_get(PointerRNA *ptr);
void DecimateModifier_vertex_group_factor_set(PointerRNA *ptr, float value);

bool DecimateModifier_invert_vertex_group_get(PointerRNA *ptr);
void DecimateModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

int DecimateModifier_iterations_get(PointerRNA *ptr);
void DecimateModifier_iterations_set(PointerRNA *ptr, int value);

enum {
	DecimateModifier_decimate_type_COLLAPSE = 0,
	DecimateModifier_decimate_type_UNSUBDIV = 1,
	DecimateModifier_decimate_type_DISSOLVE = 2,
};

int DecimateModifier_decimate_type_get(PointerRNA *ptr);
void DecimateModifier_decimate_type_set(PointerRNA *ptr, int value);

float DecimateModifier_ratio_get(PointerRNA *ptr);
void DecimateModifier_ratio_set(PointerRNA *ptr, float value);

bool DecimateModifier_use_symmetry_get(PointerRNA *ptr);
void DecimateModifier_use_symmetry_set(PointerRNA *ptr, bool value);

bool DecimateModifier_use_collapse_triangulate_get(PointerRNA *ptr);
void DecimateModifier_use_collapse_triangulate_set(PointerRNA *ptr, bool value);

#define DecimateModifier_vertex_group_MAX 64

void DecimateModifier_vertex_group_get(PointerRNA *ptr, char *value);
int DecimateModifier_vertex_group_length(PointerRNA *ptr);
void DecimateModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Dependency Graph ****************/

extern StructRNA RNA_Depsgraph;

PointerRNA Depsgraph_rna_type_get(PointerRNA *ptr);

void Depsgraph_ids_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Depsgraph_ids_next(CollectionPropertyIterator *iter);
void Depsgraph_ids_end(CollectionPropertyIterator *iter);

enum {
	Depsgraph_mode_VIEWPORT = 0,
	Depsgraph_mode_RENDER = 1,
};

int Depsgraph_mode_get(PointerRNA *ptr);
void Depsgraph_mode_set(PointerRNA *ptr, int value);

void Depsgraph_object_instances_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Depsgraph_object_instances_next(CollectionPropertyIterator *iter);
void Depsgraph_object_instances_end(CollectionPropertyIterator *iter);

void Depsgraph_objects_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Depsgraph_objects_next(CollectionPropertyIterator *iter);
void Depsgraph_objects_end(CollectionPropertyIterator *iter);

PointerRNA Depsgraph_scene_get(PointerRNA *ptr);

PointerRNA Depsgraph_scene_eval_get(PointerRNA *ptr);

void Depsgraph_updates_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Depsgraph_updates_next(CollectionPropertyIterator *iter);
void Depsgraph_updates_end(CollectionPropertyIterator *iter);

PointerRNA Depsgraph_view_layer_get(PointerRNA *ptr);

PointerRNA Depsgraph_view_layer_eval_get(PointerRNA *ptr);

void Depsgraph_debug_relations_graphviz_func(struct Depsgraph *_self, const char * filepath, int *dot_graph_num, const char * *dot_graph);
void Depsgraph_debug_stats_gnuplot_func(struct Depsgraph *_self, const char * filepath, const char * output_filepath);
void Depsgraph_debug_tag_update_func(struct Depsgraph *_self);
void Depsgraph_debug_stats_func(struct Depsgraph *_self, char * result);
void Depsgraph_update_func(struct Depsgraph *_self, Main *bmain, ReportList *reports);
struct ID *Depsgraph_id_eval_get_func(struct Depsgraph *_self, struct ID *id);
bool Depsgraph_id_type_updated_func(struct Depsgraph *_self, int id_type);
/**************** Dependency Graph Object Instance ****************/

extern StructRNA RNA_DepsgraphObjectInstance;

PointerRNA DepsgraphObjectInstance_rna_type_get(PointerRNA *ptr);

void DepsgraphObjectInstance_orco_get(PointerRNA *ptr, float values[3]);
void DepsgraphObjectInstance_orco_set(PointerRNA *ptr, const float values[3]);

void DepsgraphObjectInstance_matrix_world_get(PointerRNA *ptr, float values[16]);
void DepsgraphObjectInstance_matrix_world_set(PointerRNA *ptr, const float values[16]);

PointerRNA DepsgraphObjectInstance_instance_object_get(PointerRNA *ptr);

int DepsgraphObjectInstance_random_id_get(PointerRNA *ptr);
void DepsgraphObjectInstance_random_id_set(PointerRNA *ptr, int value);

bool DepsgraphObjectInstance_is_instance_get(PointerRNA *ptr);
void DepsgraphObjectInstance_is_instance_set(PointerRNA *ptr, bool value);

PointerRNA DepsgraphObjectInstance_object_get(PointerRNA *ptr);

PointerRNA DepsgraphObjectInstance_parent_get(PointerRNA *ptr);

PointerRNA DepsgraphObjectInstance_particle_system_get(PointerRNA *ptr);

void DepsgraphObjectInstance_persistent_id_get(PointerRNA *ptr, int values[8]);
void DepsgraphObjectInstance_persistent_id_set(PointerRNA *ptr, const int values[8]);

bool DepsgraphObjectInstance_show_particles_get(PointerRNA *ptr);
void DepsgraphObjectInstance_show_particles_set(PointerRNA *ptr, bool value);

bool DepsgraphObjectInstance_show_self_get(PointerRNA *ptr);
void DepsgraphObjectInstance_show_self_set(PointerRNA *ptr, bool value);

void DepsgraphObjectInstance_uv_get(PointerRNA *ptr, float values[2]);
void DepsgraphObjectInstance_uv_set(PointerRNA *ptr, const float values[2]);

/**************** Dependency Graph Update ****************/

extern StructRNA RNA_DepsgraphUpdate;

PointerRNA DepsgraphUpdate_rna_type_get(PointerRNA *ptr);

bool DepsgraphUpdate_is_updated_geometry_get(PointerRNA *ptr);
void DepsgraphUpdate_is_updated_geometry_set(PointerRNA *ptr, bool value);

PointerRNA DepsgraphUpdate_id_get(PointerRNA *ptr);

bool DepsgraphUpdate_is_updated_shading_get(PointerRNA *ptr);
void DepsgraphUpdate_is_updated_shading_set(PointerRNA *ptr, bool value);

bool DepsgraphUpdate_is_updated_transform_get(PointerRNA *ptr);
void DepsgraphUpdate_is_updated_transform_set(PointerRNA *ptr, bool value);

/**************** Displace Modifier ****************/

extern StructRNA RNA_DisplaceModifier;
extern StructRNA RNA_Modifier;

enum {
	DisplaceModifier_direction_X = 0,
	DisplaceModifier_direction_Y = 1,
	DisplaceModifier_direction_Z = 2,
	DisplaceModifier_direction_NORMAL = 3,
	DisplaceModifier_direction_CUSTOM_NORMAL = 5,
	DisplaceModifier_direction_RGB_TO_XYZ = 4,
};

int DisplaceModifier_direction_get(PointerRNA *ptr);
void DisplaceModifier_direction_set(PointerRNA *ptr, int value);

bool DisplaceModifier_invert_vertex_group_get(PointerRNA *ptr);
void DisplaceModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

float DisplaceModifier_mid_level_get(PointerRNA *ptr);
void DisplaceModifier_mid_level_set(PointerRNA *ptr, float value);

enum {
	DisplaceModifier_space_LOCAL = 0,
	DisplaceModifier_space_GLOBAL = 1,
};

int DisplaceModifier_space_get(PointerRNA *ptr);
void DisplaceModifier_space_set(PointerRNA *ptr, int value);

float DisplaceModifier_strength_get(PointerRNA *ptr);
void DisplaceModifier_strength_set(PointerRNA *ptr, float value);

PointerRNA DisplaceModifier_texture_get(PointerRNA *ptr);

#define DisplaceModifier_texture_coords_bone_MAX 64

void DisplaceModifier_texture_coords_bone_get(PointerRNA *ptr, char *value);
int DisplaceModifier_texture_coords_bone_length(PointerRNA *ptr);
void DisplaceModifier_texture_coords_bone_set(PointerRNA *ptr, const char *value);

PointerRNA DisplaceModifier_texture_coords_object_get(PointerRNA *ptr);

enum {
	DisplaceModifier_texture_coords_LOCAL = 0,
	DisplaceModifier_texture_coords_GLOBAL = 1,
	DisplaceModifier_texture_coords_OBJECT = 2,
	DisplaceModifier_texture_coords_UV = 3,
};

int DisplaceModifier_texture_coords_get(PointerRNA *ptr);
void DisplaceModifier_texture_coords_set(PointerRNA *ptr, int value);

#define DisplaceModifier_uv_layer_MAX 68

void DisplaceModifier_uv_layer_get(PointerRNA *ptr, char *value);
int DisplaceModifier_uv_layer_length(PointerRNA *ptr);
void DisplaceModifier_uv_layer_set(PointerRNA *ptr, const char *value);

#define DisplaceModifier_vertex_group_MAX 64

void DisplaceModifier_vertex_group_get(PointerRNA *ptr, char *value);
int DisplaceModifier_vertex_group_length(PointerRNA *ptr);
void DisplaceModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Safe Areas ****************/

extern StructRNA RNA_DisplaySafeAreas;

PointerRNA DisplaySafeAreas_rna_type_get(PointerRNA *ptr);

void DisplaySafeAreas_action_get(PointerRNA *ptr, float values[2]);
void DisplaySafeAreas_action_set(PointerRNA *ptr, const float values[2]);

void DisplaySafeAreas_action_center_get(PointerRNA *ptr, float values[2]);
void DisplaySafeAreas_action_center_set(PointerRNA *ptr, const float values[2]);

void DisplaySafeAreas_title_center_get(PointerRNA *ptr, float values[2]);
void DisplaySafeAreas_title_center_set(PointerRNA *ptr, const float values[2]);

void DisplaySafeAreas_title_get(PointerRNA *ptr, float values[2]);
void DisplaySafeAreas_title_set(PointerRNA *ptr, const float values[2]);

/**************** Distorted Noise ****************/

extern StructRNA RNA_DistortedNoiseTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

float DistortedNoiseTexture_distortion_get(PointerRNA *ptr);
void DistortedNoiseTexture_distortion_set(PointerRNA *ptr, float value);

float DistortedNoiseTexture_nabla_get(PointerRNA *ptr);
void DistortedNoiseTexture_nabla_set(PointerRNA *ptr, float value);

enum {
	DistortedNoiseTexture_noise_basis_BLENDER_ORIGINAL = 0,
	DistortedNoiseTexture_noise_basis_ORIGINAL_PERLIN = 1,
	DistortedNoiseTexture_noise_basis_IMPROVED_PERLIN = 2,
	DistortedNoiseTexture_noise_basis_VORONOI_F1 = 3,
	DistortedNoiseTexture_noise_basis_VORONOI_F2 = 4,
	DistortedNoiseTexture_noise_basis_VORONOI_F3 = 5,
	DistortedNoiseTexture_noise_basis_VORONOI_F4 = 6,
	DistortedNoiseTexture_noise_basis_VORONOI_F2_F1 = 7,
	DistortedNoiseTexture_noise_basis_VORONOI_CRACKLE = 8,
	DistortedNoiseTexture_noise_basis_CELL_NOISE = 14,
};

int DistortedNoiseTexture_noise_basis_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_basis_set(PointerRNA *ptr, int value);

enum {
	DistortedNoiseTexture_noise_distortion_BLENDER_ORIGINAL = 0,
	DistortedNoiseTexture_noise_distortion_ORIGINAL_PERLIN = 1,
	DistortedNoiseTexture_noise_distortion_IMPROVED_PERLIN = 2,
	DistortedNoiseTexture_noise_distortion_VORONOI_F1 = 3,
	DistortedNoiseTexture_noise_distortion_VORONOI_F2 = 4,
	DistortedNoiseTexture_noise_distortion_VORONOI_F3 = 5,
	DistortedNoiseTexture_noise_distortion_VORONOI_F4 = 6,
	DistortedNoiseTexture_noise_distortion_VORONOI_F2_F1 = 7,
	DistortedNoiseTexture_noise_distortion_VORONOI_CRACKLE = 8,
	DistortedNoiseTexture_noise_distortion_CELL_NOISE = 14,
};

int DistortedNoiseTexture_noise_distortion_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_distortion_set(PointerRNA *ptr, int value);

float DistortedNoiseTexture_noise_scale_get(PointerRNA *ptr);
void DistortedNoiseTexture_noise_scale_set(PointerRNA *ptr, float value);

/**************** Dope Sheet ****************/

extern StructRNA RNA_DopeSheet;

PointerRNA DopeSheet_rna_type_get(PointerRNA *ptr);

bool DopeSheet_show_expanded_summary_get(PointerRNA *ptr);
void DopeSheet_show_expanded_summary_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_armatures_get(PointerRNA *ptr);
void DopeSheet_show_armatures_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_cache_files_get(PointerRNA *ptr);
void DopeSheet_show_cache_files_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_cameras_get(PointerRNA *ptr);
void DopeSheet_show_cameras_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_curves_get(PointerRNA *ptr);
void DopeSheet_show_curves_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_gpencil_get(PointerRNA *ptr);
void DopeSheet_show_gpencil_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_hair_curves_get(PointerRNA *ptr);
void DopeSheet_show_hair_curves_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_lattices_get(PointerRNA *ptr);
void DopeSheet_show_lattices_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_lights_get(PointerRNA *ptr);
void DopeSheet_show_lights_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_lightprobes_get(PointerRNA *ptr);
void DopeSheet_show_lightprobes_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_linestyles_get(PointerRNA *ptr);
void DopeSheet_show_linestyles_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_materials_get(PointerRNA *ptr);
void DopeSheet_show_materials_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_meshes_get(PointerRNA *ptr);
void DopeSheet_show_meshes_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_metaballs_get(PointerRNA *ptr);
void DopeSheet_show_metaballs_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_modifiers_get(PointerRNA *ptr);
void DopeSheet_show_modifiers_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_movieclips_get(PointerRNA *ptr);
void DopeSheet_show_movieclips_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_nodes_get(PointerRNA *ptr);
void DopeSheet_show_nodes_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_particles_get(PointerRNA *ptr);
void DopeSheet_show_particles_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_pointclouds_get(PointerRNA *ptr);
void DopeSheet_show_pointclouds_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_scenes_get(PointerRNA *ptr);
void DopeSheet_show_scenes_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_shapekeys_get(PointerRNA *ptr);
void DopeSheet_show_shapekeys_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_speakers_get(PointerRNA *ptr);
void DopeSheet_show_speakers_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_summary_get(PointerRNA *ptr);
void DopeSheet_show_summary_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_textures_get(PointerRNA *ptr);
void DopeSheet_show_textures_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_transforms_get(PointerRNA *ptr);
void DopeSheet_show_transforms_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_volumes_get(PointerRNA *ptr);
void DopeSheet_show_volumes_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_worlds_get(PointerRNA *ptr);
void DopeSheet_show_worlds_set(PointerRNA *ptr, bool value);

#define DopeSheet_filter_fcurve_name_MAX 64

void DopeSheet_filter_fcurve_name_get(PointerRNA *ptr, char *value);
int DopeSheet_filter_fcurve_name_length(PointerRNA *ptr);
void DopeSheet_filter_fcurve_name_set(PointerRNA *ptr, const char *value);

PointerRNA DopeSheet_filter_collection_get(PointerRNA *ptr);

bool DopeSheet_show_missing_nla_get(PointerRNA *ptr);
void DopeSheet_show_missing_nla_set(PointerRNA *ptr, bool value);

bool DopeSheet_use_filter_invert_get(PointerRNA *ptr);
void DopeSheet_use_filter_invert_set(PointerRNA *ptr, bool value);

bool DopeSheet_use_multi_word_filter_get(PointerRNA *ptr);
void DopeSheet_use_multi_word_filter_set(PointerRNA *ptr, bool value);

#define DopeSheet_filter_text_MAX 64

void DopeSheet_filter_text_get(PointerRNA *ptr, char *value);
int DopeSheet_filter_text_length(PointerRNA *ptr);
void DopeSheet_filter_text_set(PointerRNA *ptr, const char *value);

bool DopeSheet_show_only_errors_get(PointerRNA *ptr);
void DopeSheet_show_only_errors_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_only_selected_get(PointerRNA *ptr);
void DopeSheet_show_only_selected_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_only_slot_of_active_object_get(PointerRNA *ptr);
void DopeSheet_show_only_slot_of_active_object_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_datablock_filters_get(PointerRNA *ptr);
void DopeSheet_show_datablock_filters_set(PointerRNA *ptr, bool value);

bool DopeSheet_show_hidden_get(PointerRNA *ptr);
void DopeSheet_show_hidden_set(PointerRNA *ptr, bool value);

bool DopeSheet_use_datablock_sort_get(PointerRNA *ptr);
void DopeSheet_use_datablock_sort_set(PointerRNA *ptr, bool value);

PointerRNA DopeSheet_source_get(PointerRNA *ptr);

bool DopeSheet_show_driver_fallback_as_error_get(PointerRNA *ptr);
void DopeSheet_show_driver_fallback_as_error_set(PointerRNA *ptr, bool value);

/**************** Driver ****************/

extern StructRNA RNA_Driver;

PointerRNA Driver_rna_type_get(PointerRNA *ptr);

#define Driver_expression_MAX 256

void Driver_expression_get(PointerRNA *ptr, char *value);
int Driver_expression_length(PointerRNA *ptr);
void Driver_expression_set(PointerRNA *ptr, const char *value);

bool Driver_is_valid_get(PointerRNA *ptr);
void Driver_is_valid_set(PointerRNA *ptr, bool value);

bool Driver_is_simple_expression_get(PointerRNA *ptr);
void Driver_is_simple_expression_set(PointerRNA *ptr, bool value);

enum {
	Driver_type_AVERAGE = 0,
	Driver_type_SUM = 2,
	Driver_type_SCRIPTED = 1,
	Driver_type_MIN = 3,
	Driver_type_MAX = 4,
};

int Driver_type_get(PointerRNA *ptr);
void Driver_type_set(PointerRNA *ptr, int value);

bool Driver_use_self_get(PointerRNA *ptr);
void Driver_use_self_set(PointerRNA *ptr, bool value);

void Driver_variables_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Driver_variables_next(CollectionPropertyIterator *iter);
void Driver_variables_end(CollectionPropertyIterator *iter);
bool Driver_variables_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Driver_variables_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

/**************** Driver Target ****************/

extern StructRNA RNA_DriverTarget;

PointerRNA DriverTarget_rna_type_get(PointerRNA *ptr);

#define DriverTarget_bone_target_MAX 64

void DriverTarget_bone_target_get(PointerRNA *ptr, char *value);
int DriverTarget_bone_target_length(PointerRNA *ptr);
void DriverTarget_bone_target_set(PointerRNA *ptr, const char *value);

enum {
	DriverTarget_context_property_ACTIVE_SCENE = 0,
	DriverTarget_context_property_ACTIVE_VIEW_LAYER = 1,
};

int DriverTarget_context_property_get(PointerRNA *ptr);
void DriverTarget_context_property_set(PointerRNA *ptr, int value);

void DriverTarget_data_path_get(PointerRNA *ptr, char *value);
int DriverTarget_data_path_length(PointerRNA *ptr);
void DriverTarget_data_path_set(PointerRNA *ptr, const char *value);

float DriverTarget_fallback_value_get(PointerRNA *ptr);
void DriverTarget_fallback_value_set(PointerRNA *ptr, float value);

PointerRNA DriverTarget_id_get(PointerRNA *ptr);

enum {
	DriverTarget_id_type_ACTION = 17217,
	DriverTarget_id_type_ARMATURE = 21057,
	DriverTarget_id_type_BRUSH = 21058,
	DriverTarget_id_type_CACHEFILE = 17987,
	DriverTarget_id_type_CAMERA = 16707,
	DriverTarget_id_type_COLLECTION = 21063,
	DriverTarget_id_type_CURVE = 21827,
	DriverTarget_id_type_CURVES = 22083,
	DriverTarget_id_type_FONT = 18006,
	DriverTarget_id_type_GREASEPENCIL = 17479,
	DriverTarget_id_type_GREASEPENCIL_V3 = 20551,
	DriverTarget_id_type_IMAGE = 19785,
	DriverTarget_id_type_KEY = 17739,
	DriverTarget_id_type_LATTICE = 21580,
	DriverTarget_id_type_LIBRARY = 18764,
	DriverTarget_id_type_LIGHT = 16716,
	DriverTarget_id_type_LIGHT_PROBE = 20556,
	DriverTarget_id_type_LINESTYLE = 21324,
	DriverTarget_id_type_MASK = 21325,
	DriverTarget_id_type_MATERIAL = 16717,
	DriverTarget_id_type_MESH = 17741,
	DriverTarget_id_type_META = 16973,
	DriverTarget_id_type_MOVIECLIP = 17229,
	DriverTarget_id_type_NODETREE = 21582,
	DriverTarget_id_type_OBJECT = 16975,
	DriverTarget_id_type_PAINTCURVE = 17232,
	DriverTarget_id_type_PALETTE = 19536,
	DriverTarget_id_type_PARTICLE = 16720,
	DriverTarget_id_type_POINTCLOUD = 21584,
	DriverTarget_id_type_SCENE = 17235,
	DriverTarget_id_type_SCREEN = 21075,
	DriverTarget_id_type_SOUND = 20307,
	DriverTarget_id_type_SPEAKER = 19283,
	DriverTarget_id_type_TEXT = 22612,
	DriverTarget_id_type_TEXTURE = 17748,
	DriverTarget_id_type_VOLUME = 20310,
	DriverTarget_id_type_WINDOWMANAGER = 19799,
	DriverTarget_id_type_WORKSPACE = 21335,
	DriverTarget_id_type_WORLD = 20311,
};

int DriverTarget_id_type_get(PointerRNA *ptr);
void DriverTarget_id_type_set(PointerRNA *ptr, int value);

bool DriverTarget_is_fallback_used_get(PointerRNA *ptr);
void DriverTarget_is_fallback_used_set(PointerRNA *ptr, bool value);

enum {
	DriverTarget_rotation_mode_AUTO = 0,
	DriverTarget_rotation_mode_XYZ = 1,
	DriverTarget_rotation_mode_XZY = 2,
	DriverTarget_rotation_mode_YXZ = 3,
	DriverTarget_rotation_mode_YZX = 4,
	DriverTarget_rotation_mode_ZXY = 5,
	DriverTarget_rotation_mode_ZYX = 6,
	DriverTarget_rotation_mode_QUATERNION = 7,
	DriverTarget_rotation_mode_SWING_TWIST_X = 8,
	DriverTarget_rotation_mode_SWING_TWIST_Y = 9,
	DriverTarget_rotation_mode_SWING_TWIST_Z = 10,
};

int DriverTarget_rotation_mode_get(PointerRNA *ptr);
void DriverTarget_rotation_mode_set(PointerRNA *ptr, int value);

enum {
	DriverTarget_transform_space_WORLD_SPACE = 0,
	DriverTarget_transform_space_TRANSFORM_SPACE = 4,
	DriverTarget_transform_space_LOCAL_SPACE = 12,
};

int DriverTarget_transform_space_get(PointerRNA *ptr);
void DriverTarget_transform_space_set(PointerRNA *ptr, int value);

enum {
	DriverTarget_transform_type_LOC_X = 0,
	DriverTarget_transform_type_LOC_Y = 1,
	DriverTarget_transform_type_LOC_Z = 2,
	DriverTarget_transform_type_ROT_X = 3,
	DriverTarget_transform_type_ROT_Y = 4,
	DriverTarget_transform_type_ROT_Z = 5,
	DriverTarget_transform_type_ROT_W = 10,
	DriverTarget_transform_type_SCALE_X = 6,
	DriverTarget_transform_type_SCALE_Y = 7,
	DriverTarget_transform_type_SCALE_Z = 8,
	DriverTarget_transform_type_SCALE_AVG = 9,
};

int DriverTarget_transform_type_get(PointerRNA *ptr);
void DriverTarget_transform_type_set(PointerRNA *ptr, int value);

bool DriverTarget_use_fallback_value_get(PointerRNA *ptr);
void DriverTarget_use_fallback_value_set(PointerRNA *ptr, bool value);

/**************** Driver Variable ****************/

extern StructRNA RNA_DriverVariable;

PointerRNA DriverVariable_rna_type_get(PointerRNA *ptr);

#define DriverVariable_name_MAX 64

void DriverVariable_name_get(PointerRNA *ptr, char *value);
int DriverVariable_name_length(PointerRNA *ptr);
void DriverVariable_name_set(PointerRNA *ptr, const char *value);

bool DriverVariable_is_name_valid_get(PointerRNA *ptr);
void DriverVariable_is_name_valid_set(PointerRNA *ptr, bool value);

void DriverVariable_targets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void DriverVariable_targets_next(CollectionPropertyIterator *iter);
void DriverVariable_targets_end(CollectionPropertyIterator *iter);
int DriverVariable_targets_length(PointerRNA *ptr);
bool DriverVariable_targets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	DriverVariable_type_SINGLE_PROP = 0,
	DriverVariable_type_TRANSFORMS = 3,
	DriverVariable_type_ROTATION_DIFF = 1,
	DriverVariable_type_LOC_DIFF = 2,
	DriverVariable_type_CONTEXT_PROP = 4,
};

int DriverVariable_type_get(PointerRNA *ptr);
void DriverVariable_type_set(PointerRNA *ptr, int value);

/**************** Brush Settings ****************/

extern StructRNA RNA_DynamicPaintBrushSettings;

PointerRNA DynamicPaintBrushSettings_rna_type_get(PointerRNA *ptr);

bool DynamicPaintBrushSettings_use_absolute_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_absolute_alpha_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_wave_clamp_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_clamp_set(PointerRNA *ptr, float value);

bool DynamicPaintBrushSettings_use_smudge_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_smudge_set(PointerRNA *ptr, bool value);

bool DynamicPaintBrushSettings_use_paint_erase_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_paint_erase_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_wave_factor_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_factor_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintBrushSettings_proximity_falloff_SMOOTH = 1,
	DynamicPaintBrushSettings_proximity_falloff_CONSTANT = 0,
	DynamicPaintBrushSettings_proximity_falloff_RAMP = 2,
};

int DynamicPaintBrushSettings_proximity_falloff_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_proximity_falloff_set(PointerRNA *ptr, int value);

bool DynamicPaintBrushSettings_invert_proximity_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_invert_proximity_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_velocity_max_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_velocity_max_set(PointerRNA *ptr, float value);

bool DynamicPaintBrushSettings_use_velocity_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_alpha_set(PointerRNA *ptr, bool value);

bool DynamicPaintBrushSettings_use_velocity_depth_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_depth_set(PointerRNA *ptr, bool value);

bool DynamicPaintBrushSettings_use_negative_volume_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_negative_volume_set(PointerRNA *ptr, bool value);

bool DynamicPaintBrushSettings_use_proximity_ramp_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_proximity_ramp_alpha_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_paint_alpha_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_alpha_set(PointerRNA *ptr, float value);

void DynamicPaintBrushSettings_paint_color_get(PointerRNA *ptr, float values[3]);
void DynamicPaintBrushSettings_paint_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA DynamicPaintBrushSettings_paint_ramp_get(PointerRNA *ptr);

enum {
	DynamicPaintBrushSettings_paint_source_PARTICLE_SYSTEM = 3,
	DynamicPaintBrushSettings_paint_source_POINT = 4,
	DynamicPaintBrushSettings_paint_source_DISTANCE = 1,
	DynamicPaintBrushSettings_paint_source_VOLUME_DISTANCE = 2,
	DynamicPaintBrushSettings_paint_source_VOLUME = 0,
};

int DynamicPaintBrushSettings_paint_source_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_source_set(PointerRNA *ptr, int value);

float DynamicPaintBrushSettings_paint_wetness_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_wetness_set(PointerRNA *ptr, float value);

PointerRNA DynamicPaintBrushSettings_particle_system_get(PointerRNA *ptr);

bool DynamicPaintBrushSettings_use_proximity_project_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_proximity_project_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_paint_distance_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_paint_distance_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintBrushSettings_ray_direction_CANVAS = 0,
	DynamicPaintBrushSettings_ray_direction_BRUSH = 1,
	DynamicPaintBrushSettings_ray_direction_Z_AXIS = 2,
};

int DynamicPaintBrushSettings_ray_direction_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_ray_direction_set(PointerRNA *ptr, int value);

bool DynamicPaintBrushSettings_use_velocity_color_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_velocity_color_set(PointerRNA *ptr, bool value);

float DynamicPaintBrushSettings_smooth_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_smooth_radius_set(PointerRNA *ptr, float value);

float DynamicPaintBrushSettings_smudge_strength_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_smudge_strength_set(PointerRNA *ptr, float value);

float DynamicPaintBrushSettings_solid_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_solid_radius_set(PointerRNA *ptr, float value);

bool DynamicPaintBrushSettings_use_particle_radius_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_use_particle_radius_set(PointerRNA *ptr, bool value);

PointerRNA DynamicPaintBrushSettings_velocity_ramp_get(PointerRNA *ptr);

enum {
	DynamicPaintBrushSettings_wave_type_CHANGE = 3,
	DynamicPaintBrushSettings_wave_type_DEPTH = 0,
	DynamicPaintBrushSettings_wave_type_FORCE = 1,
	DynamicPaintBrushSettings_wave_type_REFLECT = 2,
};

int DynamicPaintBrushSettings_wave_type_get(PointerRNA *ptr);
void DynamicPaintBrushSettings_wave_type_set(PointerRNA *ptr, int value);

/**************** Canvas Settings ****************/

extern StructRNA RNA_DynamicPaintCanvasSettings;

PointerRNA DynamicPaintCanvasSettings_rna_type_get(PointerRNA *ptr);

void DynamicPaintCanvasSettings_canvas_surfaces_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void DynamicPaintCanvasSettings_canvas_surfaces_next(CollectionPropertyIterator *iter);
void DynamicPaintCanvasSettings_canvas_surfaces_end(CollectionPropertyIterator *iter);

/**************** Dynamic Paint Modifier ****************/

extern StructRNA RNA_DynamicPaintModifier;
extern StructRNA RNA_Modifier;

PointerRNA DynamicPaintModifier_brush_settings_get(PointerRNA *ptr);

PointerRNA DynamicPaintModifier_canvas_settings_get(PointerRNA *ptr);

enum {
	DynamicPaintModifier_ui_type_CANVAS = 1,
	DynamicPaintModifier_ui_type_BRUSH = 2,
};

int DynamicPaintModifier_ui_type_get(PointerRNA *ptr);
void DynamicPaintModifier_ui_type_set(PointerRNA *ptr, int value);

/**************** Paint Surface ****************/

extern StructRNA RNA_DynamicPaintSurface;

PointerRNA DynamicPaintSurface_rna_type_get(PointerRNA *ptr);

#define DynamicPaintSurface_name_MAX 64

void DynamicPaintSurface_name_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_name_length(PointerRNA *ptr);
void DynamicPaintSurface_name_set(PointerRNA *ptr, const char *value);

float DynamicPaintSurface_drip_acceleration_get(PointerRNA *ptr);
void DynamicPaintSurface_drip_acceleration_set(PointerRNA *ptr, float value);

bool DynamicPaintSurface_use_antialiasing_get(PointerRNA *ptr);
void DynamicPaintSurface_use_antialiasing_set(PointerRNA *ptr, bool value);

PointerRNA DynamicPaintSurface_brush_collection_get(PointerRNA *ptr);

void DynamicPaintSurface_init_color_get(PointerRNA *ptr, float values[4]);
void DynamicPaintSurface_init_color_set(PointerRNA *ptr, const float values[4]);

float DynamicPaintSurface_color_dry_threshold_get(PointerRNA *ptr);
void DynamicPaintSurface_color_dry_threshold_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_color_spread_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_color_spread_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_damping_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_damping_set(PointerRNA *ptr, float value);

#define DynamicPaintSurface_init_layername_MAX 68

void DynamicPaintSurface_init_layername_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_init_layername_length(PointerRNA *ptr);
void DynamicPaintSurface_init_layername_set(PointerRNA *ptr, const char *value);

enum {
	DynamicPaintSurface_displace_type_DISPLACE = 0,
	DynamicPaintSurface_displace_type_DEPTH = 1,
};

int DynamicPaintSurface_displace_type_get(PointerRNA *ptr);
void DynamicPaintSurface_displace_type_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_displace_factor_get(PointerRNA *ptr);
void DynamicPaintSurface_displace_factor_set(PointerRNA *ptr, float value);

bool DynamicPaintSurface_use_dissolve_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dissolve_set(PointerRNA *ptr, bool value);

int DynamicPaintSurface_dissolve_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_dissolve_speed_set(PointerRNA *ptr, int value);

bool DynamicPaintSurface_use_drying_get(PointerRNA *ptr);
void DynamicPaintSurface_use_drying_set(PointerRNA *ptr, bool value);

int DynamicPaintSurface_dry_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_dry_speed_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_effect_ui_SPREAD = 1,
	DynamicPaintSurface_effect_ui_DRIP = 2,
	DynamicPaintSurface_effect_ui_SHRINK = 3,
};

int DynamicPaintSurface_effect_ui_get(PointerRNA *ptr);
void DynamicPaintSurface_effect_ui_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurface_effector_weights_get(PointerRNA *ptr);

int DynamicPaintSurface_frame_end_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_end_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_image_fileformat_PNG = 0,
	DynamicPaintSurface_image_fileformat_OPENEXR = 1,
};

int DynamicPaintSurface_image_fileformat_get(PointerRNA *ptr);
void DynamicPaintSurface_image_fileformat_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_surface_format_VERTEX = 1,
	DynamicPaintSurface_surface_format_IMAGE = 2,
};

int DynamicPaintSurface_surface_format_get(PointerRNA *ptr);
void DynamicPaintSurface_surface_format_set(PointerRNA *ptr, int value);

bool DynamicPaintSurface_use_incremental_displace_get(PointerRNA *ptr);
void DynamicPaintSurface_use_incremental_displace_set(PointerRNA *ptr, bool value);

float DynamicPaintSurface_brush_influence_scale_get(PointerRNA *ptr);
void DynamicPaintSurface_brush_influence_scale_set(PointerRNA *ptr, float value);

enum {
	DynamicPaintSurface_init_color_type_NONE = 0,
	DynamicPaintSurface_init_color_type_COLOR = 1,
	DynamicPaintSurface_init_color_type_TEXTURE = 2,
	DynamicPaintSurface_init_color_type_VERTEX_COLOR = 3,
};

int DynamicPaintSurface_init_color_type_get(PointerRNA *ptr);
void DynamicPaintSurface_init_color_type_set(PointerRNA *ptr, int value);

bool DynamicPaintSurface_is_active_get(PointerRNA *ptr);
void DynamicPaintSurface_is_active_set(PointerRNA *ptr, bool value);

float DynamicPaintSurface_depth_clamp_get(PointerRNA *ptr);
void DynamicPaintSurface_depth_clamp_set(PointerRNA *ptr, float value);

bool DynamicPaintSurface_use_wave_open_border_get(PointerRNA *ptr);
void DynamicPaintSurface_use_wave_open_border_set(PointerRNA *ptr, bool value);

#define DynamicPaintSurface_output_name_a_MAX 68

void DynamicPaintSurface_output_name_a_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_output_name_a_length(PointerRNA *ptr);
void DynamicPaintSurface_output_name_a_set(PointerRNA *ptr, const char *value);

#define DynamicPaintSurface_output_name_b_MAX 68

void DynamicPaintSurface_output_name_b_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_output_name_b_length(PointerRNA *ptr);
void DynamicPaintSurface_output_name_b_set(PointerRNA *ptr, const char *value);

#define DynamicPaintSurface_image_output_path_MAX 1024

void DynamicPaintSurface_image_output_path_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_image_output_path_length(PointerRNA *ptr);
void DynamicPaintSurface_image_output_path_set(PointerRNA *ptr, const char *value);

PointerRNA DynamicPaintSurface_point_cache_get(PointerRNA *ptr);

bool DynamicPaintSurface_use_premultiply_get(PointerRNA *ptr);
void DynamicPaintSurface_use_premultiply_set(PointerRNA *ptr, bool value);

float DynamicPaintSurface_brush_radius_scale_get(PointerRNA *ptr);
void DynamicPaintSurface_brush_radius_scale_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_image_resolution_get(PointerRNA *ptr);
void DynamicPaintSurface_image_resolution_set(PointerRNA *ptr, int value);

float DynamicPaintSurface_shrink_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_shrink_speed_set(PointerRNA *ptr, float value);

bool DynamicPaintSurface_use_dry_log_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dry_log_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_dissolve_log_get(PointerRNA *ptr);
void DynamicPaintSurface_use_dissolve_log_set(PointerRNA *ptr, bool value);

float DynamicPaintSurface_wave_smoothness_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_smoothness_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_spread_speed_get(PointerRNA *ptr);
void DynamicPaintSurface_spread_speed_set(PointerRNA *ptr, float value);

float DynamicPaintSurface_wave_spring_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_spring_set(PointerRNA *ptr, float value);

int DynamicPaintSurface_frame_start_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_start_set(PointerRNA *ptr, int value);

int DynamicPaintSurface_frame_substeps_get(PointerRNA *ptr);
void DynamicPaintSurface_frame_substeps_set(PointerRNA *ptr, int value);

enum {
	DynamicPaintSurface_surface_type_PAINT = 0,
};

int DynamicPaintSurface_surface_type_get(PointerRNA *ptr);
void DynamicPaintSurface_surface_type_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurface_init_texture_get(PointerRNA *ptr);

float DynamicPaintSurface_wave_timescale_get(PointerRNA *ptr);
void DynamicPaintSurface_wave_timescale_set(PointerRNA *ptr, float value);

#define DynamicPaintSurface_uv_layer_MAX 68

void DynamicPaintSurface_uv_layer_get(PointerRNA *ptr, char *value);
int DynamicPaintSurface_uv_layer_length(PointerRNA *ptr);
void DynamicPaintSurface_uv_layer_set(PointerRNA *ptr, const char *value);

bool DynamicPaintSurface_is_cache_user_get(PointerRNA *ptr);
void DynamicPaintSurface_is_cache_user_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_drip_get(PointerRNA *ptr);
void DynamicPaintSurface_use_drip_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_output_a_get(PointerRNA *ptr);
void DynamicPaintSurface_use_output_a_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_output_b_get(PointerRNA *ptr);
void DynamicPaintSurface_use_output_b_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_shrink_get(PointerRNA *ptr);
void DynamicPaintSurface_use_shrink_set(PointerRNA *ptr, bool value);

bool DynamicPaintSurface_use_spread_get(PointerRNA *ptr);
void DynamicPaintSurface_use_spread_set(PointerRNA *ptr, bool value);

float DynamicPaintSurface_drip_velocity_get(PointerRNA *ptr);
void DynamicPaintSurface_drip_velocity_set(PointerRNA *ptr, float value);

bool DynamicPaintSurface_output_exists_func(struct DynamicPaintSurface *_self, struct Object *object, int index);
/**************** Canvas Surfaces ****************/

extern StructRNA RNA_DynamicPaintSurfaces;

PointerRNA DynamicPaintSurfaces_rna_type_get(PointerRNA *ptr);

int DynamicPaintSurfaces_active_index_get(PointerRNA *ptr);
void DynamicPaintSurfaces_active_index_set(PointerRNA *ptr, int value);

PointerRNA DynamicPaintSurfaces_active_get(PointerRNA *ptr);

/**************** EQCurveMappingData ****************/

extern StructRNA RNA_EQCurveMappingData;

PointerRNA EQCurveMappingData_rna_type_get(PointerRNA *ptr);

PointerRNA EQCurveMappingData_curve_mapping_get(PointerRNA *ptr);

/**************** EdgeSplit Modifier ****************/

extern StructRNA RNA_EdgeSplitModifier;
extern StructRNA RNA_Modifier;

float EdgeSplitModifier_split_angle_get(PointerRNA *ptr);
void EdgeSplitModifier_split_angle_set(PointerRNA *ptr, float value);

bool EdgeSplitModifier_use_edge_angle_get(PointerRNA *ptr);
void EdgeSplitModifier_use_edge_angle_set(PointerRNA *ptr, bool value);

bool EdgeSplitModifier_use_edge_sharp_get(PointerRNA *ptr);
void EdgeSplitModifier_use_edge_sharp_set(PointerRNA *ptr, bool value);

/**************** Edit Bone ****************/

extern StructRNA RNA_EditBone;

PointerRNA EditBone_rna_type_get(PointerRNA *ptr);

void EditBone_name_get(PointerRNA *ptr, char *value);
int EditBone_name_length(PointerRNA *ptr);
void EditBone_name_set(PointerRNA *ptr, const char *value);

float EditBone_bbone_x_get(PointerRNA *ptr);
void EditBone_bbone_x_set(PointerRNA *ptr, float value);

float EditBone_bbone_z_get(PointerRNA *ptr);
void EditBone_bbone_z_set(PointerRNA *ptr, float value);

PointerRNA EditBone_bbone_custom_handle_end_get(PointerRNA *ptr);

enum {
	EditBone_bbone_handle_type_end_AUTO = 0,
	EditBone_bbone_handle_type_end_ABSOLUTE = 1,
	EditBone_bbone_handle_type_end_RELATIVE = 2,
	EditBone_bbone_handle_type_end_TANGENT = 3,
};

int EditBone_bbone_handle_type_end_get(PointerRNA *ptr);
void EditBone_bbone_handle_type_end_set(PointerRNA *ptr, int value);

int EditBone_bbone_segments_get(PointerRNA *ptr);
void EditBone_bbone_segments_set(PointerRNA *ptr, int value);

PointerRNA EditBone_bbone_custom_handle_start_get(PointerRNA *ptr);

enum {
	EditBone_bbone_handle_type_start_AUTO = 0,
	EditBone_bbone_handle_type_start_ABSOLUTE = 1,
	EditBone_bbone_handle_type_start_RELATIVE = 2,
	EditBone_bbone_handle_type_start_TANGENT = 3,
};

int EditBone_bbone_handle_type_start_get(PointerRNA *ptr);
void EditBone_bbone_handle_type_start_set(PointerRNA *ptr, int value);

enum {
	EditBone_bbone_mapping_mode_STRAIGHT = 0,
	EditBone_bbone_mapping_mode_CURVED = 1,
};

int EditBone_bbone_mapping_mode_get(PointerRNA *ptr);
void EditBone_bbone_mapping_mode_set(PointerRNA *ptr, int value);

void EditBone_collections_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void EditBone_collections_next(CollectionPropertyIterator *iter);
void EditBone_collections_end(CollectionPropertyIterator *iter);

bool EditBone_use_connect_get(PointerRNA *ptr);
void EditBone_use_connect_set(PointerRNA *ptr, bool value);

bool EditBone_use_cyclic_offset_get(PointerRNA *ptr);
void EditBone_use_cyclic_offset_set(PointerRNA *ptr, bool value);

bool EditBone_use_deform_get(PointerRNA *ptr);
void EditBone_use_deform_set(PointerRNA *ptr, bool value);

enum {
	EditBone_display_type_ARMATURE_DEFINED = -1,
	EditBone_display_type_OCTAHEDRAL = 0,
	EditBone_display_type_STICK = 1,
	EditBone_display_type_BBONE = 2,
	EditBone_display_type_ENVELOPE = 3,
	EditBone_display_type_WIRE = 4,
};

int EditBone_display_type_get(PointerRNA *ptr);
void EditBone_display_type_set(PointerRNA *ptr, int value);

bool EditBone_show_wire_get(PointerRNA *ptr);
void EditBone_show_wire_set(PointerRNA *ptr, bool value);

float EditBone_bbone_easein_get(PointerRNA *ptr);
void EditBone_bbone_easein_set(PointerRNA *ptr, float value);

float EditBone_bbone_easeout_get(PointerRNA *ptr);
void EditBone_bbone_easeout_set(PointerRNA *ptr, float value);

void EditBone_matrix_get(PointerRNA *ptr, float values[16]);
void EditBone_matrix_set(PointerRNA *ptr, const float values[16]);

bool EditBone_bbone_handle_use_ease_end_get(PointerRNA *ptr);
void EditBone_bbone_handle_use_ease_end_set(PointerRNA *ptr, bool value);

void EditBone_bbone_handle_use_scale_end_get(PointerRNA *ptr, bool values[3]);
void EditBone_bbone_handle_use_scale_end_set(PointerRNA *ptr, const bool values[3]);

float EditBone_envelope_distance_get(PointerRNA *ptr);
void EditBone_envelope_distance_set(PointerRNA *ptr, float value);

float EditBone_envelope_weight_get(PointerRNA *ptr);
void EditBone_envelope_weight_set(PointerRNA *ptr, float value);

float EditBone_head_radius_get(PointerRNA *ptr);
void EditBone_head_radius_set(PointerRNA *ptr, float value);

float EditBone_tail_radius_get(PointerRNA *ptr);
void EditBone_tail_radius_set(PointerRNA *ptr, float value);

void EditBone_head_get(PointerRNA *ptr, float values[3]);
void EditBone_head_set(PointerRNA *ptr, const float values[3]);

bool EditBone_select_head_get(PointerRNA *ptr);
void EditBone_select_head_set(PointerRNA *ptr, bool value);

bool EditBone_hide_get(PointerRNA *ptr);
void EditBone_hide_set(PointerRNA *ptr, bool value);

float EditBone_bbone_curveinx_get(PointerRNA *ptr);
void EditBone_bbone_curveinx_set(PointerRNA *ptr, float value);

float EditBone_bbone_curveinz_get(PointerRNA *ptr);
void EditBone_bbone_curveinz_set(PointerRNA *ptr, float value);

bool EditBone_use_endroll_as_inroll_get(PointerRNA *ptr);
void EditBone_use_endroll_as_inroll_set(PointerRNA *ptr, bool value);

bool EditBone_use_inherit_rotation_get(PointerRNA *ptr);
void EditBone_use_inherit_rotation_set(PointerRNA *ptr, bool value);

enum {
	EditBone_inherit_scale_FULL = 0,
	EditBone_inherit_scale_FIX_SHEAR = 1,
	EditBone_inherit_scale_ALIGNED = 5,
	EditBone_inherit_scale_AVERAGE = 2,
	EditBone_inherit_scale_NONE = 3,
	EditBone_inherit_scale_NONE_LEGACY = 4,
};

int EditBone_inherit_scale_get(PointerRNA *ptr);
void EditBone_inherit_scale_set(PointerRNA *ptr, int value);

float EditBone_length_get(PointerRNA *ptr);
void EditBone_length_set(PointerRNA *ptr, float value);

bool EditBone_use_local_location_get(PointerRNA *ptr);
void EditBone_use_local_location_set(PointerRNA *ptr, bool value);

bool EditBone_lock_get(PointerRNA *ptr);
void EditBone_lock_set(PointerRNA *ptr, bool value);

bool EditBone_use_envelope_multiply_get(PointerRNA *ptr);
void EditBone_use_envelope_multiply_set(PointerRNA *ptr, bool value);

float EditBone_bbone_curveoutx_get(PointerRNA *ptr);
void EditBone_bbone_curveoutx_set(PointerRNA *ptr, float value);

float EditBone_bbone_curveoutz_get(PointerRNA *ptr);
void EditBone_bbone_curveoutz_set(PointerRNA *ptr, float value);

PointerRNA EditBone_parent_get(PointerRNA *ptr);

bool EditBone_use_relative_parent_get(PointerRNA *ptr);
void EditBone_use_relative_parent_set(PointerRNA *ptr, bool value);

float EditBone_roll_get(PointerRNA *ptr);
void EditBone_roll_set(PointerRNA *ptr, float value);

float EditBone_bbone_rollin_get(PointerRNA *ptr);
void EditBone_bbone_rollin_set(PointerRNA *ptr, float value);

float EditBone_bbone_rollout_get(PointerRNA *ptr);
void EditBone_bbone_rollout_set(PointerRNA *ptr, float value);

bool EditBone_use_scale_easing_get(PointerRNA *ptr);
void EditBone_use_scale_easing_set(PointerRNA *ptr, bool value);

void EditBone_bbone_scalein_get(PointerRNA *ptr, float values[3]);
void EditBone_bbone_scalein_set(PointerRNA *ptr, const float values[3]);

void EditBone_bbone_scaleout_get(PointerRNA *ptr, float values[3]);
void EditBone_bbone_scaleout_set(PointerRNA *ptr, const float values[3]);

bool EditBone_select_get(PointerRNA *ptr);
void EditBone_select_set(PointerRNA *ptr, bool value);

bool EditBone_hide_select_get(PointerRNA *ptr);
void EditBone_hide_select_set(PointerRNA *ptr, bool value);

bool EditBone_bbone_handle_use_ease_start_get(PointerRNA *ptr);
void EditBone_bbone_handle_use_ease_start_set(PointerRNA *ptr, bool value);

void EditBone_bbone_handle_use_scale_start_get(PointerRNA *ptr, bool values[3]);
void EditBone_bbone_handle_use_scale_start_set(PointerRNA *ptr, const bool values[3]);

void EditBone_tail_get(PointerRNA *ptr, float values[3]);
void EditBone_tail_set(PointerRNA *ptr, const float values[3]);

bool EditBone_select_tail_get(PointerRNA *ptr);
void EditBone_select_tail_set(PointerRNA *ptr, bool value);

PointerRNA EditBone_color_get(PointerRNA *ptr);

struct IDPropertyGroup *EditBone_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
void EditBone_align_roll_func(struct EditBone *_self, float vector[3]);
/**************** Effect Strip ****************/

extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

enum {
	EffectStrip_alpha_mode_STRAIGHT = 0,
	EffectStrip_alpha_mode_PREMUL = 1,
};

int EffectStrip_alpha_mode_get(PointerRNA *ptr);
void EffectStrip_alpha_mode_set(PointerRNA *ptr, int value);

bool EffectStrip_use_float_get(PointerRNA *ptr);
void EffectStrip_use_float_set(PointerRNA *ptr, bool value);

PointerRNA EffectStrip_crop_get(PointerRNA *ptr);

bool EffectStrip_use_deinterlace_get(PointerRNA *ptr);
void EffectStrip_use_deinterlace_set(PointerRNA *ptr, bool value);

bool EffectStrip_use_flip_x_get(PointerRNA *ptr);
void EffectStrip_use_flip_x_set(PointerRNA *ptr, bool value);

bool EffectStrip_use_flip_y_get(PointerRNA *ptr);
void EffectStrip_use_flip_y_set(PointerRNA *ptr, bool value);

bool EffectStrip_multiply_alpha_get(PointerRNA *ptr);
void EffectStrip_multiply_alpha_set(PointerRNA *ptr, bool value);

float EffectStrip_color_multiply_get(PointerRNA *ptr);
void EffectStrip_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA EffectStrip_proxy_get(PointerRNA *ptr);

bool EffectStrip_use_reverse_frames_get(PointerRNA *ptr);
void EffectStrip_use_reverse_frames_set(PointerRNA *ptr, bool value);

float EffectStrip_color_saturation_get(PointerRNA *ptr);
void EffectStrip_color_saturation_set(PointerRNA *ptr, float value);

float EffectStrip_strobe_get(PointerRNA *ptr);
void EffectStrip_strobe_set(PointerRNA *ptr, float value);

PointerRNA EffectStrip_transform_get(PointerRNA *ptr);

bool EffectStrip_use_proxy_get(PointerRNA *ptr);
void EffectStrip_use_proxy_set(PointerRNA *ptr, bool value);

/**************** Effector Weights ****************/

extern StructRNA RNA_EffectorWeights;

PointerRNA EffectorWeights_rna_type_get(PointerRNA *ptr);

float EffectorWeights_all_get(PointerRNA *ptr);
void EffectorWeights_all_set(PointerRNA *ptr, float value);

float EffectorWeights_boid_get(PointerRNA *ptr);
void EffectorWeights_boid_set(PointerRNA *ptr, float value);

float EffectorWeights_charge_get(PointerRNA *ptr);
void EffectorWeights_charge_set(PointerRNA *ptr, float value);

float EffectorWeights_curve_guide_get(PointerRNA *ptr);
void EffectorWeights_curve_guide_set(PointerRNA *ptr, float value);

float EffectorWeights_drag_get(PointerRNA *ptr);
void EffectorWeights_drag_set(PointerRNA *ptr, float value);

PointerRNA EffectorWeights_collection_get(PointerRNA *ptr);

float EffectorWeights_smokeflow_get(PointerRNA *ptr);
void EffectorWeights_smokeflow_set(PointerRNA *ptr, float value);

float EffectorWeights_force_get(PointerRNA *ptr);
void EffectorWeights_force_set(PointerRNA *ptr, float value);

float EffectorWeights_gravity_get(PointerRNA *ptr);
void EffectorWeights_gravity_set(PointerRNA *ptr, float value);

float EffectorWeights_harmonic_get(PointerRNA *ptr);
void EffectorWeights_harmonic_set(PointerRNA *ptr, float value);

float EffectorWeights_lennardjones_get(PointerRNA *ptr);
void EffectorWeights_lennardjones_set(PointerRNA *ptr, float value);

float EffectorWeights_magnetic_get(PointerRNA *ptr);
void EffectorWeights_magnetic_set(PointerRNA *ptr, float value);

float EffectorWeights_texture_get(PointerRNA *ptr);
void EffectorWeights_texture_set(PointerRNA *ptr, float value);

float EffectorWeights_turbulence_get(PointerRNA *ptr);
void EffectorWeights_turbulence_set(PointerRNA *ptr, float value);

bool EffectorWeights_apply_to_hair_growing_get(PointerRNA *ptr);
void EffectorWeights_apply_to_hair_growing_set(PointerRNA *ptr, bool value);

float EffectorWeights_vortex_get(PointerRNA *ptr);
void EffectorWeights_vortex_set(PointerRNA *ptr, float value);

float EffectorWeights_wind_get(PointerRNA *ptr);
void EffectorWeights_wind_set(PointerRNA *ptr, float value);

/**************** Enum Definition ****************/

extern StructRNA RNA_EnumProperty;
extern StructRNA RNA_Property;

enum {
	EnumProperty_default_DEFAULT = 0,
};

int EnumProperty_default_value_get(PointerRNA *ptr);
void EnumProperty_default_value_set(PointerRNA *ptr, int value);

enum {
	EnumProperty_default_flag_DEFAULT = 0,
};

int EnumProperty_default_flag_get(PointerRNA *ptr);
void EnumProperty_default_flag_set(PointerRNA *ptr, int value);

void EnumProperty_enum_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void EnumProperty_enum_items_next(CollectionPropertyIterator *iter);
void EnumProperty_enum_items_end(CollectionPropertyIterator *iter);

void EnumProperty_enum_items_static_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void EnumProperty_enum_items_static_next(CollectionPropertyIterator *iter);
void EnumProperty_enum_items_static_end(CollectionPropertyIterator *iter);

void EnumProperty_enum_items_static_ui_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void EnumProperty_enum_items_static_ui_next(CollectionPropertyIterator *iter);
void EnumProperty_enum_items_static_ui_end(CollectionPropertyIterator *iter);

/**************** Enum Item Definition ****************/

extern StructRNA RNA_EnumPropertyItem;

PointerRNA EnumPropertyItem_rna_type_get(PointerRNA *ptr);

void EnumPropertyItem_name_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_name_length(PointerRNA *ptr);
void EnumPropertyItem_name_set(PointerRNA *ptr, const char *value);

void EnumPropertyItem_description_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_description_length(PointerRNA *ptr);
void EnumPropertyItem_description_set(PointerRNA *ptr, const char *value);

enum {
	EnumPropertyItem_icon_NONE = 0,
	EnumPropertyItem_icon_CHAR_NOTDEF = 1,
	EnumPropertyItem_icon_CHAR_REPLACEMENT = 2,
	EnumPropertyItem_icon_NOT_FOUND = 3,
	EnumPropertyItem_icon_BLANK1 = 4,
	EnumPropertyItem_icon_AUTOMERGE_OFF = 5,
	EnumPropertyItem_icon_AUTOMERGE_ON = 6,
	EnumPropertyItem_icon_CHECKBOX_DEHLT = 7,
	EnumPropertyItem_icon_CHECKBOX_HLT = 8,
	EnumPropertyItem_icon_CLIPUV_DEHLT = 9,
	EnumPropertyItem_icon_CLIPUV_HLT = 10,
	EnumPropertyItem_icon_DECORATE_UNLOCKED = 11,
	EnumPropertyItem_icon_DECORATE_LOCKED = 12,
	EnumPropertyItem_icon_FAKE_USER_OFF = 13,
	EnumPropertyItem_icon_FAKE_USER_ON = 14,
	EnumPropertyItem_icon_HIDE_ON = 15,
	EnumPropertyItem_icon_HIDE_OFF = 16,
	EnumPropertyItem_icon_INDIRECT_ONLY_OFF = 17,
	EnumPropertyItem_icon_INDIRECT_ONLY_ON = 18,
	EnumPropertyItem_icon_ONIONSKIN_OFF = 19,
	EnumPropertyItem_icon_ONIONSKIN_ON = 20,
	EnumPropertyItem_icon_UNPINNED = 21,
	EnumPropertyItem_icon_PINNED = 22,
	EnumPropertyItem_icon_RADIOBUT_OFF = 23,
	EnumPropertyItem_icon_RADIOBUT_ON = 24,
	EnumPropertyItem_icon_RECORD_OFF = 25,
	EnumPropertyItem_icon_RECORD_ON = 26,
	EnumPropertyItem_icon_RESTRICT_RENDER_ON = 27,
	EnumPropertyItem_icon_RESTRICT_RENDER_OFF = 28,
	EnumPropertyItem_icon_RESTRICT_SELECT_ON = 29,
	EnumPropertyItem_icon_RESTRICT_SELECT_OFF = 30,
	EnumPropertyItem_icon_RESTRICT_VIEW_ON = 31,
	EnumPropertyItem_icon_RESTRICT_VIEW_OFF = 32,
	EnumPropertyItem_icon_RIGHTARROW = 33,
	EnumPropertyItem_icon_DOWNARROW_HLT = 34,
	EnumPropertyItem_icon_SELECT_INTERSECT = 35,
	EnumPropertyItem_icon_SELECT_DIFFERENCE = 36,
	EnumPropertyItem_icon_SNAP_OFF = 37,
	EnumPropertyItem_icon_SNAP_ON = 38,
	EnumPropertyItem_icon_PLAYHEAD_SNAP_OFF = 39,
	EnumPropertyItem_icon_PLAYHEAD_SNAP_ON = 40,
	EnumPropertyItem_icon_UNLOCKED = 41,
	EnumPropertyItem_icon_LOCKED = 42,
	EnumPropertyItem_icon_VIS_SEL_11 = 43,
	EnumPropertyItem_icon_VIS_SEL_10 = 44,
	EnumPropertyItem_icon_VIS_SEL_01 = 45,
	EnumPropertyItem_icon_VIS_SEL_00 = 46,
	EnumPropertyItem_icon_CANCEL = 47,
	EnumPropertyItem_icon_ERROR = 48,
	EnumPropertyItem_icon_QUESTION = 49,
	EnumPropertyItem_icon_ADD = 50,
	EnumPropertyItem_icon_ARROW_LEFTRIGHT = 51,
	EnumPropertyItem_icon_AUTO = 52,
	EnumPropertyItem_icon_BLENDER = 53,
	EnumPropertyItem_icon_BORDERMOVE = 54,
	EnumPropertyItem_icon_BRUSHES_ALL = 55,
	EnumPropertyItem_icon_CHECKMARK = 56,
	EnumPropertyItem_icon_COLLAPSEMENU = 57,
	EnumPropertyItem_icon_COLLECTION_NEW = 58,
	EnumPropertyItem_icon_COLOR = 59,
	EnumPropertyItem_icon_COPY_ID = 60,
	EnumPropertyItem_icon_DISCLOSURE_TRI_DOWN = 61,
	EnumPropertyItem_icon_DISCLOSURE_TRI_RIGHT = 62,
	EnumPropertyItem_icon_DOT = 63,
	EnumPropertyItem_icon_DRIVER_DISTANCE = 64,
	EnumPropertyItem_icon_DRIVER_ROTATIONAL_DIFFERENCE = 65,
	EnumPropertyItem_icon_DRIVER_TRANSFORM = 66,
	EnumPropertyItem_icon_DUPLICATE = 67,
	EnumPropertyItem_icon_EYEDROPPER = 68,
	EnumPropertyItem_icon_FCURVE_SNAPSHOT = 69,
	EnumPropertyItem_icon_FILE_NEW = 70,
	EnumPropertyItem_icon_FILE_TICK = 71,
	EnumPropertyItem_icon_FREEZE = 72,
	EnumPropertyItem_icon_FULLSCREEN_ENTER = 73,
	EnumPropertyItem_icon_FULLSCREEN_EXIT = 74,
	EnumPropertyItem_icon_GHOST_DISABLED = 75,
	EnumPropertyItem_icon_GHOST_ENABLED = 76,
	EnumPropertyItem_icon_GRIP = 77,
	EnumPropertyItem_icon_GRIP_V = 78,
	EnumPropertyItem_icon_HAND = 79,
	EnumPropertyItem_icon_HELP = 80,
	EnumPropertyItem_icon_LINKED = 81,
	EnumPropertyItem_icon_MENU_PANEL = 82,
	EnumPropertyItem_icon_NODE_SEL = 83,
	EnumPropertyItem_icon_NODE = 84,
	EnumPropertyItem_icon_OBJECT_HIDDEN = 85,
	EnumPropertyItem_icon_OPTIONS = 86,
	EnumPropertyItem_icon_PANEL_CLOSE = 87,
	EnumPropertyItem_icon_PLUGIN = 88,
	EnumPropertyItem_icon_PLUS = 89,
	EnumPropertyItem_icon_PRESET_NEW = 90,
	EnumPropertyItem_icon_QUIT = 91,
	EnumPropertyItem_icon_RECOVER_LAST = 92,
	EnumPropertyItem_icon_REMOVE = 93,
	EnumPropertyItem_icon_RIGHTARROW_THIN = 94,
	EnumPropertyItem_icon_SCREEN_BACK = 95,
	EnumPropertyItem_icon_STATUSBAR = 96,
	EnumPropertyItem_icon_STYLUS_PRESSURE = 97,
	EnumPropertyItem_icon_THREE_DOTS = 98,
	EnumPropertyItem_icon_TOPBAR = 99,
	EnumPropertyItem_icon_TRASH = 100,
	EnumPropertyItem_icon_TRIA_DOWN = 101,
	EnumPropertyItem_icon_TRIA_LEFT = 102,
	EnumPropertyItem_icon_TRIA_RIGHT = 103,
	EnumPropertyItem_icon_TRIA_UP = 104,
	EnumPropertyItem_icon_UNLINKED = 105,
	EnumPropertyItem_icon_URL = 106,
	EnumPropertyItem_icon_VIEWZOOM = 107,
	EnumPropertyItem_icon_WINDOW = 108,
	EnumPropertyItem_icon_WORKSPACE = 109,
	EnumPropertyItem_icon_X = 110,
	EnumPropertyItem_icon_ZOOM_ALL = 111,
	EnumPropertyItem_icon_ZOOM_IN = 112,
	EnumPropertyItem_icon_ZOOM_OUT = 113,
	EnumPropertyItem_icon_ZOOM_PREVIOUS = 114,
	EnumPropertyItem_icon_ZOOM_SELECTED = 115,
	EnumPropertyItem_icon_MODIFIER = 116,
	EnumPropertyItem_icon_PARTICLES = 117,
	EnumPropertyItem_icon_PHYSICS = 118,
	EnumPropertyItem_icon_SHADERFX = 119,
	EnumPropertyItem_icon_SPEAKER = 120,
	EnumPropertyItem_icon_OUTPUT = 121,
	EnumPropertyItem_icon_SCENE = 122,
	EnumPropertyItem_icon_TOOL_SETTINGS = 123,
	EnumPropertyItem_icon_LIGHT = 124,
	EnumPropertyItem_icon_MATERIAL = 125,
	EnumPropertyItem_icon_TEXTURE = 126,
	EnumPropertyItem_icon_WORLD = 127,
	EnumPropertyItem_icon_ANIM = 128,
	EnumPropertyItem_icon_SCRIPT = 129,
	EnumPropertyItem_icon_GEOMETRY_NODES = 130,
	EnumPropertyItem_icon_TEXT = 131,
	EnumPropertyItem_icon_ACTION = 132,
	EnumPropertyItem_icon_ASSET_MANAGER = 133,
	EnumPropertyItem_icon_CONSOLE = 134,
	EnumPropertyItem_icon_FILEBROWSER = 135,
	EnumPropertyItem_icon_GEOMETRY_SET = 136,
	EnumPropertyItem_icon_GRAPH = 137,
	EnumPropertyItem_icon_IMAGE = 138,
	EnumPropertyItem_icon_INFO = 139,
	EnumPropertyItem_icon_NLA = 140,
	EnumPropertyItem_icon_NODE_COMPOSITING = 141,
	EnumPropertyItem_icon_NODE_MATERIAL = 142,
	EnumPropertyItem_icon_NODE_TEXTURE = 143,
	EnumPropertyItem_icon_NODETREE = 144,
	EnumPropertyItem_icon_OUTLINER = 145,
	EnumPropertyItem_icon_PREFERENCES = 146,
	EnumPropertyItem_icon_PROPERTIES = 147,
	EnumPropertyItem_icon_SEQUENCE = 148,
	EnumPropertyItem_icon_SOUND = 149,
	EnumPropertyItem_icon_SPREADSHEET = 150,
	EnumPropertyItem_icon_TIME = 151,
	EnumPropertyItem_icon_TRACKER = 152,
	EnumPropertyItem_icon_UV = 153,
	EnumPropertyItem_icon_VIEW3D = 154,
	EnumPropertyItem_icon_EDITMODE_HLT = 155,
	EnumPropertyItem_icon_OBJECT_DATAMODE = 156,
	EnumPropertyItem_icon_PARTICLEMODE = 157,
	EnumPropertyItem_icon_POSE_HLT = 158,
	EnumPropertyItem_icon_SCULPTMODE_HLT = 159,
	EnumPropertyItem_icon_TPAINT_HLT = 160,
	EnumPropertyItem_icon_UV_DATA = 161,
	EnumPropertyItem_icon_VPAINT_HLT = 162,
	EnumPropertyItem_icon_WPAINT_HLT = 163,
	EnumPropertyItem_icon_TRACKER_DATA = 164,
	EnumPropertyItem_icon_TRACKING_BACKWARDS_SINGLE = 165,
	EnumPropertyItem_icon_TRACKING_BACKWARDS = 166,
	EnumPropertyItem_icon_TRACKING_CLEAR_BACKWARDS = 167,
	EnumPropertyItem_icon_TRACKING_CLEAR_FORWARDS = 168,
	EnumPropertyItem_icon_TRACKING_FORWARDS_SINGLE = 169,
	EnumPropertyItem_icon_TRACKING_FORWARDS = 170,
	EnumPropertyItem_icon_TRACKING_REFINE_BACKWARDS = 171,
	EnumPropertyItem_icon_TRACKING_REFINE_FORWARDS = 172,
	EnumPropertyItem_icon_TRACKING = 173,
	EnumPropertyItem_icon_GROUP = 174,
	EnumPropertyItem_icon_CONSTRAINT_BONE = 175,
	EnumPropertyItem_icon_CONSTRAINT = 176,
	EnumPropertyItem_icon_ARMATURE_DATA = 177,
	EnumPropertyItem_icon_BONE_DATA = 178,
	EnumPropertyItem_icon_CAMERA_DATA = 179,
	EnumPropertyItem_icon_CURVE_DATA = 180,
	EnumPropertyItem_icon_EMPTY_DATA = 181,
	EnumPropertyItem_icon_FONT_DATA = 182,
	EnumPropertyItem_icon_LATTICE_DATA = 183,
	EnumPropertyItem_icon_LIGHT_DATA = 184,
	EnumPropertyItem_icon_MESH_DATA = 185,
	EnumPropertyItem_icon_META_DATA = 186,
	EnumPropertyItem_icon_PARTICLE_DATA = 187,
	EnumPropertyItem_icon_SHAPEKEY_DATA = 188,
	EnumPropertyItem_icon_SURFACE_DATA = 189,
	EnumPropertyItem_icon_OBJECT_DATA = 190,
	EnumPropertyItem_icon_RENDER_RESULT = 191,
	EnumPropertyItem_icon_RENDERLAYERS = 192,
	EnumPropertyItem_icon_SCENE_DATA = 193,
	EnumPropertyItem_icon_BRUSH_DATA = 194,
	EnumPropertyItem_icon_IMAGE_DATA = 195,
	EnumPropertyItem_icon_LINE_DATA = 196,
	EnumPropertyItem_icon_MATERIAL_DATA = 197,
	EnumPropertyItem_icon_TEXTURE_DATA = 198,
	EnumPropertyItem_icon_WORLD_DATA = 199,
	EnumPropertyItem_icon_ANIM_DATA = 200,
	EnumPropertyItem_icon_BOIDS = 201,
	EnumPropertyItem_icon_CAMERA_STEREO = 202,
	EnumPropertyItem_icon_COMMUNITY = 203,
	EnumPropertyItem_icon_FACE_MAPS = 204,
	EnumPropertyItem_icon_FCURVE = 205,
	EnumPropertyItem_icon_FILE = 206,
	EnumPropertyItem_icon_GREASEPENCIL = 207,
	EnumPropertyItem_icon_GREASEPENCIL_LAYER_GROUP = 208,
	EnumPropertyItem_icon_GROUP_BONE = 209,
	EnumPropertyItem_icon_GROUP_UVS = 210,
	EnumPropertyItem_icon_GROUP_VCOL = 211,
	EnumPropertyItem_icon_GROUP_VERTEX = 212,
	EnumPropertyItem_icon_LIBRARY_DATA_BROKEN = 213,
	EnumPropertyItem_icon_LIBRARY_DATA_DIRECT = 214,
	EnumPropertyItem_icon_LIBRARY_DATA_OVERRIDE = 215,
	EnumPropertyItem_icon_ORPHAN_DATA = 216,
	EnumPropertyItem_icon_PACKAGE = 217,
	EnumPropertyItem_icon_PRESET = 218,
	EnumPropertyItem_icon_RENDER_ANIMATION = 219,
	EnumPropertyItem_icon_RENDER_STILL = 220,
	EnumPropertyItem_icon_RNA = 221,
	EnumPropertyItem_icon_STRANDS = 222,
	EnumPropertyItem_icon_UGLYPACKAGE = 223,
	EnumPropertyItem_icon_MOUSE_LMB = 224,
	EnumPropertyItem_icon_MOUSE_MMB = 225,
	EnumPropertyItem_icon_MOUSE_RMB = 226,
	EnumPropertyItem_icon_MOUSE_MMB_SCROLL = 227,
	EnumPropertyItem_icon_MOUSE_LMB_2X = 228,
	EnumPropertyItem_icon_MOUSE_MOVE = 229,
	EnumPropertyItem_icon_MOUSE_LMB_DRAG = 230,
	EnumPropertyItem_icon_MOUSE_MMB_DRAG = 231,
	EnumPropertyItem_icon_MOUSE_RMB_DRAG = 232,
	EnumPropertyItem_icon_DECORATE_ANIMATE = 233,
	EnumPropertyItem_icon_DECORATE_DRIVER = 234,
	EnumPropertyItem_icon_DECORATE_KEYFRAME = 235,
	EnumPropertyItem_icon_DECORATE_LIBRARY_OVERRIDE = 236,
	EnumPropertyItem_icon_DECORATE_LINKED = 237,
	EnumPropertyItem_icon_DECORATE_OVERRIDE = 238,
	EnumPropertyItem_icon_DECORATE = 239,
	EnumPropertyItem_icon_OUTLINER_COLLECTION = 240,
	EnumPropertyItem_icon_COLLECTION_COLOR_01 = 241,
	EnumPropertyItem_icon_COLLECTION_COLOR_02 = 242,
	EnumPropertyItem_icon_COLLECTION_COLOR_03 = 243,
	EnumPropertyItem_icon_COLLECTION_COLOR_04 = 244,
	EnumPropertyItem_icon_COLLECTION_COLOR_05 = 245,
	EnumPropertyItem_icon_COLLECTION_COLOR_06 = 246,
	EnumPropertyItem_icon_COLLECTION_COLOR_07 = 247,
	EnumPropertyItem_icon_COLLECTION_COLOR_08 = 248,
	EnumPropertyItem_icon_CURVES_DATA = 249,
	EnumPropertyItem_icon_OUTLINER_DATA_ARMATURE = 250,
	EnumPropertyItem_icon_OUTLINER_DATA_CAMERA = 251,
	EnumPropertyItem_icon_OUTLINER_DATA_CURVE = 252,
	EnumPropertyItem_icon_OUTLINER_DATA_CURVES = 253,
	EnumPropertyItem_icon_OUTLINER_DATA_EMPTY = 254,
	EnumPropertyItem_icon_OUTLINER_DATA_FONT = 255,
	EnumPropertyItem_icon_OUTLINER_DATA_GP_LAYER = 256,
	EnumPropertyItem_icon_OUTLINER_DATA_GREASEPENCIL = 257,
	EnumPropertyItem_icon_OUTLINER_DATA_LATTICE = 258,
	EnumPropertyItem_icon_OUTLINER_DATA_LIGHT = 259,
	EnumPropertyItem_icon_OUTLINER_DATA_LIGHTPROBE = 260,
	EnumPropertyItem_icon_OUTLINER_DATA_MESH = 261,
	EnumPropertyItem_icon_OUTLINER_DATA_META = 262,
	EnumPropertyItem_icon_OUTLINER_DATA_POINTCLOUD = 263,
	EnumPropertyItem_icon_OUTLINER_DATA_SPEAKER = 264,
	EnumPropertyItem_icon_OUTLINER_DATA_SURFACE = 265,
	EnumPropertyItem_icon_OUTLINER_DATA_VOLUME = 266,
	EnumPropertyItem_icon_POINTCLOUD_DATA = 267,
	EnumPropertyItem_icon_POINTCLOUD_POINT = 268,
	EnumPropertyItem_icon_VOLUME_DATA = 269,
	EnumPropertyItem_icon_OUTLINER_OB_ARMATURE = 270,
	EnumPropertyItem_icon_OUTLINER_OB_CAMERA = 271,
	EnumPropertyItem_icon_OUTLINER_OB_CURVE = 272,
	EnumPropertyItem_icon_OUTLINER_OB_CURVES = 273,
	EnumPropertyItem_icon_OUTLINER_OB_EMPTY = 274,
	EnumPropertyItem_icon_OUTLINER_OB_FONT = 275,
	EnumPropertyItem_icon_OUTLINER_OB_FORCE_FIELD = 276,
	EnumPropertyItem_icon_OUTLINER_OB_GREASEPENCIL = 277,
	EnumPropertyItem_icon_OUTLINER_OB_GROUP_INSTANCE = 278,
	EnumPropertyItem_icon_OUTLINER_OB_IMAGE = 279,
	EnumPropertyItem_icon_OUTLINER_OB_LATTICE = 280,
	EnumPropertyItem_icon_OUTLINER_OB_LIGHT = 281,
	EnumPropertyItem_icon_OUTLINER_OB_LIGHTPROBE = 282,
	EnumPropertyItem_icon_OUTLINER_OB_MESH = 283,
	EnumPropertyItem_icon_OUTLINER_OB_META = 284,
	EnumPropertyItem_icon_OUTLINER_OB_POINTCLOUD = 285,
	EnumPropertyItem_icon_OUTLINER_OB_SPEAKER = 286,
	EnumPropertyItem_icon_OUTLINER_OB_SURFACE = 287,
	EnumPropertyItem_icon_OUTLINER_OB_VOLUME = 288,
	EnumPropertyItem_icon_GP_MULTIFRAME_EDITING = 289,
	EnumPropertyItem_icon_GP_ONLY_SELECTED = 290,
	EnumPropertyItem_icon_GP_SELECT_BETWEEN_STROKES = 291,
	EnumPropertyItem_icon_GP_SELECT_POINTS = 292,
	EnumPropertyItem_icon_GP_SELECT_STROKES = 293,
	EnumPropertyItem_icon_HOLDOUT_OFF = 294,
	EnumPropertyItem_icon_HOLDOUT_ON = 295,
	EnumPropertyItem_icon_MODIFIER_OFF = 296,
	EnumPropertyItem_icon_MODIFIER_ON = 297,
	EnumPropertyItem_icon_RESTRICT_COLOR_OFF = 298,
	EnumPropertyItem_icon_RESTRICT_COLOR_ON = 299,
	EnumPropertyItem_icon_RESTRICT_INSTANCED_OFF = 300,
	EnumPropertyItem_icon_RESTRICT_INSTANCED_ON = 301,
	EnumPropertyItem_icon_LIGHT_AREA = 302,
	EnumPropertyItem_icon_LIGHT_HEMI = 303,
	EnumPropertyItem_icon_LIGHT_POINT = 304,
	EnumPropertyItem_icon_LIGHT_SPOT = 305,
	EnumPropertyItem_icon_LIGHT_SUN = 306,
	EnumPropertyItem_icon_LIGHTPROBE_PLANE = 307,
	EnumPropertyItem_icon_LIGHTPROBE_SPHERE = 308,
	EnumPropertyItem_icon_LIGHTPROBE_VOLUME = 309,
	EnumPropertyItem_icon_COLOR_BLUE = 310,
	EnumPropertyItem_icon_COLOR_GREEN = 311,
	EnumPropertyItem_icon_COLOR_RED = 312,
	EnumPropertyItem_icon_CONE = 313,
	EnumPropertyItem_icon_CUBE = 314,
	EnumPropertyItem_icon_CURVE_BEZCIRCLE = 315,
	EnumPropertyItem_icon_CURVE_BEZCURVE = 316,
	EnumPropertyItem_icon_CURVE_NCIRCLE = 317,
	EnumPropertyItem_icon_CURVE_NCURVE = 318,
	EnumPropertyItem_icon_CURVE_PATH = 319,
	EnumPropertyItem_icon_CURVES = 320,
	EnumPropertyItem_icon_EMPTY_ARROWS = 321,
	EnumPropertyItem_icon_EMPTY_AXIS = 322,
	EnumPropertyItem_icon_EMPTY_SINGLE_ARROW = 323,
	EnumPropertyItem_icon_MESH_CAPSULE = 324,
	EnumPropertyItem_icon_MESH_CIRCLE = 325,
	EnumPropertyItem_icon_MESH_CONE = 326,
	EnumPropertyItem_icon_MESH_CUBE = 327,
	EnumPropertyItem_icon_MESH_CYLINDER = 328,
	EnumPropertyItem_icon_MESH_GRID = 329,
	EnumPropertyItem_icon_MESH_ICOSPHERE = 330,
	EnumPropertyItem_icon_MESH_MONKEY = 331,
	EnumPropertyItem_icon_MESH_PLANE = 332,
	EnumPropertyItem_icon_MESH_TORUS = 333,
	EnumPropertyItem_icon_MESH_UVSPHERE = 334,
	EnumPropertyItem_icon_META_BALL = 335,
	EnumPropertyItem_icon_META_CAPSULE = 336,
	EnumPropertyItem_icon_META_CUBE = 337,
	EnumPropertyItem_icon_META_ELLIPSOID = 338,
	EnumPropertyItem_icon_META_PLANE = 339,
	EnumPropertyItem_icon_MONKEY = 340,
	EnumPropertyItem_icon_SPHERE = 341,
	EnumPropertyItem_icon_STROKE = 342,
	EnumPropertyItem_icon_SURFACE_NCIRCLE = 343,
	EnumPropertyItem_icon_SURFACE_NCURVE = 344,
	EnumPropertyItem_icon_SURFACE_NCYLINDER = 345,
	EnumPropertyItem_icon_SURFACE_NSPHERE = 346,
	EnumPropertyItem_icon_SURFACE_NSURFACE = 347,
	EnumPropertyItem_icon_SURFACE_NTORUS = 348,
	EnumPropertyItem_icon_TRIA_DOWN_BAR = 349,
	EnumPropertyItem_icon_TRIA_LEFT_BAR = 350,
	EnumPropertyItem_icon_TRIA_RIGHT_BAR = 351,
	EnumPropertyItem_icon_TRIA_UP_BAR = 352,
	EnumPropertyItem_icon_AREA_DOCK = 353,
	EnumPropertyItem_icon_AREA_JOIN_DOWN = 354,
	EnumPropertyItem_icon_AREA_JOIN_LEFT = 355,
	EnumPropertyItem_icon_AREA_JOIN_UP = 356,
	EnumPropertyItem_icon_AREA_JOIN = 357,
	EnumPropertyItem_icon_AREA_SWAP = 358,
	EnumPropertyItem_icon_FORCE_BOID = 359,
	EnumPropertyItem_icon_FORCE_CHARGE = 360,
	EnumPropertyItem_icon_FORCE_CURVE = 361,
	EnumPropertyItem_icon_FORCE_DRAG = 362,
	EnumPropertyItem_icon_FORCE_FLUIDFLOW = 363,
	EnumPropertyItem_icon_FORCE_FORCE = 364,
	EnumPropertyItem_icon_FORCE_HARMONIC = 365,
	EnumPropertyItem_icon_FORCE_LENNARDJONES = 366,
	EnumPropertyItem_icon_FORCE_MAGNETIC = 367,
	EnumPropertyItem_icon_FORCE_TEXTURE = 368,
	EnumPropertyItem_icon_FORCE_TURBULENCE = 369,
	EnumPropertyItem_icon_FORCE_VORTEX = 370,
	EnumPropertyItem_icon_FORCE_WIND = 371,
	EnumPropertyItem_icon_IMAGE_BACKGROUND = 372,
	EnumPropertyItem_icon_IMAGE_PLANE = 373,
	EnumPropertyItem_icon_IMAGE_REFERENCE = 374,
	EnumPropertyItem_icon_RIGID_BODY_CONSTRAINT = 375,
	EnumPropertyItem_icon_RIGID_BODY = 376,
	EnumPropertyItem_icon_SPLIT_HORIZONTAL = 377,
	EnumPropertyItem_icon_SPLIT_VERTICAL = 378,
	EnumPropertyItem_icon_ANCHOR_BOTTOM = 379,
	EnumPropertyItem_icon_ANCHOR_CENTER = 380,
	EnumPropertyItem_icon_ANCHOR_LEFT = 381,
	EnumPropertyItem_icon_ANCHOR_RIGHT = 382,
	EnumPropertyItem_icon_ANCHOR_TOP = 383,
	EnumPropertyItem_icon_NODE_CORNER = 384,
	EnumPropertyItem_icon_NODE_INSERT_OFF = 385,
	EnumPropertyItem_icon_NODE_INSERT_ON = 386,
	EnumPropertyItem_icon_NODE_SIDE = 387,
	EnumPropertyItem_icon_NODE_TOP = 388,
	EnumPropertyItem_icon_SELECT_EXTEND = 389,
	EnumPropertyItem_icon_SELECT_SET = 390,
	EnumPropertyItem_icon_SELECT_SUBTRACT = 391,
	EnumPropertyItem_icon_ALIGN_BOTTOM = 392,
	EnumPropertyItem_icon_ALIGN_CENTER = 393,
	EnumPropertyItem_icon_ALIGN_FLUSH = 394,
	EnumPropertyItem_icon_ALIGN_JUSTIFY = 395,
	EnumPropertyItem_icon_ALIGN_LEFT = 396,
	EnumPropertyItem_icon_ALIGN_MIDDLE = 397,
	EnumPropertyItem_icon_ALIGN_RIGHT = 398,
	EnumPropertyItem_icon_ALIGN_TOP = 399,
	EnumPropertyItem_icon_BOLD = 400,
	EnumPropertyItem_icon_ITALIC = 401,
	EnumPropertyItem_icon_LINENUMBERS_OFF = 402,
	EnumPropertyItem_icon_LINENUMBERS_ON = 403,
	EnumPropertyItem_icon_SCRIPTPLUGINS = 404,
	EnumPropertyItem_icon_SMALL_CAPS = 405,
	EnumPropertyItem_icon_SYNTAX_OFF = 406,
	EnumPropertyItem_icon_SYNTAX_ON = 407,
	EnumPropertyItem_icon_UNDERLINE = 408,
	EnumPropertyItem_icon_WORDWRAP_OFF = 409,
	EnumPropertyItem_icon_WORDWRAP_ON = 410,
	EnumPropertyItem_icon_CON_ACTION = 411,
	EnumPropertyItem_icon_CON_ARMATURE = 412,
	EnumPropertyItem_icon_CON_GEOMETRYATTRIBUTE = 413,
	EnumPropertyItem_icon_CON_CAMERASOLVER = 414,
	EnumPropertyItem_icon_CON_CHILDOF = 415,
	EnumPropertyItem_icon_CON_CLAMPTO = 416,
	EnumPropertyItem_icon_CON_DISTLIMIT = 417,
	EnumPropertyItem_icon_CON_FLOOR = 418,
	EnumPropertyItem_icon_CON_FOLLOWPATH = 419,
	EnumPropertyItem_icon_CON_FOLLOWTRACK = 420,
	EnumPropertyItem_icon_CON_KINEMATIC = 421,
	EnumPropertyItem_icon_CON_LOCKTRACK = 422,
	EnumPropertyItem_icon_CON_LOCLIKE = 423,
	EnumPropertyItem_icon_CON_LOCLIMIT = 424,
	EnumPropertyItem_icon_CON_OBJECTSOLVER = 425,
	EnumPropertyItem_icon_CON_PIVOT = 426,
	EnumPropertyItem_icon_CON_ROTLIKE = 427,
	EnumPropertyItem_icon_CON_ROTLIMIT = 428,
	EnumPropertyItem_icon_CON_SAMEVOL = 429,
	EnumPropertyItem_icon_CON_SHRINKWRAP = 430,
	EnumPropertyItem_icon_CON_SIZELIKE = 431,
	EnumPropertyItem_icon_CON_SIZELIMIT = 432,
	EnumPropertyItem_icon_CON_SPLINEIK = 433,
	EnumPropertyItem_icon_CON_STRETCHTO = 434,
	EnumPropertyItem_icon_CON_TRACKTO = 435,
	EnumPropertyItem_icon_CON_TRANSFORM_CACHE = 436,
	EnumPropertyItem_icon_CON_TRANSFORM = 437,
	EnumPropertyItem_icon_CON_TRANSLIKE = 438,
	EnumPropertyItem_icon_HOOK = 439,
	EnumPropertyItem_icon_MOD_ARMATURE = 440,
	EnumPropertyItem_icon_MOD_ARRAY = 441,
	EnumPropertyItem_icon_MOD_BEVEL = 442,
	EnumPropertyItem_icon_MOD_BOOLEAN = 443,
	EnumPropertyItem_icon_MOD_BUILD = 444,
	EnumPropertyItem_icon_MOD_CAST = 445,
	EnumPropertyItem_icon_MOD_CLOTH = 446,
	EnumPropertyItem_icon_MOD_CURVE = 447,
	EnumPropertyItem_icon_MOD_CURVE_TO_TUBE = 448,
	EnumPropertyItem_icon_MOD_DASH = 449,
	EnumPropertyItem_icon_MOD_DATA_TRANSFER = 450,
	EnumPropertyItem_icon_MOD_DECIM = 451,
	EnumPropertyItem_icon_MOD_DISPLACE = 452,
	EnumPropertyItem_icon_MOD_DYNAMICPAINT = 453,
	EnumPropertyItem_icon_MOD_EDGESPLIT = 454,
	EnumPropertyItem_icon_MOD_ENVELOPE = 455,
	EnumPropertyItem_icon_MOD_EXPLODE = 456,
	EnumPropertyItem_icon_MOD_FLUID = 457,
	EnumPropertyItem_icon_MOD_FLUIDSIM = 458,
	EnumPropertyItem_icon_MOD_HUE_SATURATION = 459,
	EnumPropertyItem_icon_MOD_INSTANCE = 460,
	EnumPropertyItem_icon_MOD_LATTICE = 461,
	EnumPropertyItem_icon_MOD_LENGTH = 462,
	EnumPropertyItem_icon_MOD_LINEART = 463,
	EnumPropertyItem_icon_MOD_MASK = 464,
	EnumPropertyItem_icon_MOD_MESHDEFORM = 465,
	EnumPropertyItem_icon_MOD_MIRROR = 466,
	EnumPropertyItem_icon_MOD_MULTIRES = 467,
	EnumPropertyItem_icon_MOD_NOISE = 468,
	EnumPropertyItem_icon_MOD_NORMALEDIT = 469,
	EnumPropertyItem_icon_MOD_OCEAN = 470,
	EnumPropertyItem_icon_MOD_OFFSET = 471,
	EnumPropertyItem_icon_MOD_OPACITY = 472,
	EnumPropertyItem_icon_MOD_OUTLINE = 473,
	EnumPropertyItem_icon_MOD_PARTICLE_INSTANCE = 474,
	EnumPropertyItem_icon_MOD_PARTICLES = 475,
	EnumPropertyItem_icon_MOD_PHYSICS = 476,
	EnumPropertyItem_icon_MOD_REMESH = 477,
	EnumPropertyItem_icon_MOD_SCATTER_ON_SURFACE = 478,
	EnumPropertyItem_icon_MOD_SCREW = 479,
	EnumPropertyItem_icon_MOD_SHRINKWRAP = 480,
	EnumPropertyItem_icon_MOD_SIMPLEDEFORM = 481,
	EnumPropertyItem_icon_MOD_SIMPLIFY = 482,
	EnumPropertyItem_icon_MOD_SKIN = 483,
	EnumPropertyItem_icon_MOD_SMOOTH = 484,
	EnumPropertyItem_icon_MOD_SOFT = 485,
	EnumPropertyItem_icon_MOD_SOLIDIFY = 486,
	EnumPropertyItem_icon_MOD_SUBSURF = 487,
	EnumPropertyItem_icon_MOD_THICKNESS = 488,
	EnumPropertyItem_icon_MOD_TIME = 489,
	EnumPropertyItem_icon_MOD_TINT = 490,
	EnumPropertyItem_icon_MOD_TRIANGULATE = 491,
	EnumPropertyItem_icon_MOD_UVPROJECT = 492,
	EnumPropertyItem_icon_MOD_VERTEX_WEIGHT = 493,
	EnumPropertyItem_icon_MOD_WARP = 494,
	EnumPropertyItem_icon_MOD_WAVE = 495,
	EnumPropertyItem_icon_MOD_WIREFRAME = 496,
	EnumPropertyItem_icon_MODIFIER_DATA = 497,
	EnumPropertyItem_icon_ACTION_SLOT = 498,
	EnumPropertyItem_icon_ACTION_TWEAK = 499,
	EnumPropertyItem_icon_DRIVER = 500,
	EnumPropertyItem_icon_FF = 501,
	EnumPropertyItem_icon_FRAME_NEXT = 502,
	EnumPropertyItem_icon_FRAME_PREV = 503,
	EnumPropertyItem_icon_HANDLE_ALIGNED = 504,
	EnumPropertyItem_icon_HANDLE_AUTO = 505,
	EnumPropertyItem_icon_HANDLE_AUTOCLAMPED = 506,
	EnumPropertyItem_icon_HANDLE_FREE = 507,
	EnumPropertyItem_icon_HANDLE_VECTOR = 508,
	EnumPropertyItem_icon_IPO_BACK = 509,
	EnumPropertyItem_icon_IPO_BEZIER = 510,
	EnumPropertyItem_icon_IPO_BOUNCE = 511,
	EnumPropertyItem_icon_IPO_CIRC = 512,
	EnumPropertyItem_icon_IPO_CONSTANT = 513,
	EnumPropertyItem_icon_IPO_CUBIC = 514,
	EnumPropertyItem_icon_IPO_EASE_IN_OUT = 515,
	EnumPropertyItem_icon_IPO_EASE_IN = 516,
	EnumPropertyItem_icon_IPO_EASE_OUT = 517,
	EnumPropertyItem_icon_IPO_ELASTIC = 518,
	EnumPropertyItem_icon_IPO_EXPO = 519,
	EnumPropertyItem_icon_IPO_LINEAR = 520,
	EnumPropertyItem_icon_IPO_QUAD = 521,
	EnumPropertyItem_icon_IPO_QUART = 522,
	EnumPropertyItem_icon_IPO_QUINT = 523,
	EnumPropertyItem_icon_IPO_SINE = 524,
	EnumPropertyItem_icon_KEY_DEHLT = 525,
	EnumPropertyItem_icon_KEY_HLT = 526,
	EnumPropertyItem_icon_KEYFRAME_HLT = 527,
	EnumPropertyItem_icon_KEYFRAME = 528,
	EnumPropertyItem_icon_KEYINGSET = 529,
	EnumPropertyItem_icon_MARKER_HLT = 530,
	EnumPropertyItem_icon_MARKER = 531,
	EnumPropertyItem_icon_MUTE_IPO_OFF = 532,
	EnumPropertyItem_icon_MUTE_IPO_ON = 533,
	EnumPropertyItem_icon_NEXT_KEYFRAME = 534,
	EnumPropertyItem_icon_NLA_PUSHDOWN = 535,
	EnumPropertyItem_icon_NORMALIZE_FCURVES = 536,
	EnumPropertyItem_icon_ORIENTATION_PARENT = 537,
	EnumPropertyItem_icon_PAUSE = 538,
	EnumPropertyItem_icon_PLAY_REVERSE = 539,
	EnumPropertyItem_icon_PLAY_SOUND = 540,
	EnumPropertyItem_icon_PLAY = 541,
	EnumPropertyItem_icon_PMARKER_ACT = 542,
	EnumPropertyItem_icon_PMARKER_SEL = 543,
	EnumPropertyItem_icon_PMARKER = 544,
	EnumPropertyItem_icon_PREV_KEYFRAME = 545,
	EnumPropertyItem_icon_PREVIEW_RANGE = 546,
	EnumPropertyItem_icon_REC = 547,
	EnumPropertyItem_icon_REW = 548,
	EnumPropertyItem_icon_SOLO_OFF = 549,
	EnumPropertyItem_icon_SOLO_ON = 550,
	EnumPropertyItem_icon_CENTER_ONLY = 551,
	EnumPropertyItem_icon_CURSOR = 552,
	EnumPropertyItem_icon_EDGESEL = 553,
	EnumPropertyItem_icon_EDGE_BEVEL = 554,
	EnumPropertyItem_icon_EDGE_CREASE = 555,
	EnumPropertyItem_icon_EDGE_SEAM = 556,
	EnumPropertyItem_icon_EDGE_SHARP = 557,
	EnumPropertyItem_icon_FACE_CORNER = 558,
	EnumPropertyItem_icon_FACESEL = 559,
	EnumPropertyItem_icon_INVERSESQUARECURVE = 560,
	EnumPropertyItem_icon_LINCURVE = 561,
	EnumPropertyItem_icon_NOCURVE = 562,
	EnumPropertyItem_icon_PARTICLE_PATH = 563,
	EnumPropertyItem_icon_PARTICLE_POINT = 564,
	EnumPropertyItem_icon_PARTICLE_TIP = 565,
	EnumPropertyItem_icon_PIVOT_ACTIVE = 566,
	EnumPropertyItem_icon_PIVOT_BOUNDBOX = 567,
	EnumPropertyItem_icon_PIVOT_CURSOR = 568,
	EnumPropertyItem_icon_PIVOT_INDIVIDUAL = 569,
	EnumPropertyItem_icon_PIVOT_MEDIAN = 570,
	EnumPropertyItem_icon_PROP_CON = 571,
	EnumPropertyItem_icon_PROP_OFF = 572,
	EnumPropertyItem_icon_PROP_ON = 573,
	EnumPropertyItem_icon_PROP_PROJECTED = 574,
	EnumPropertyItem_icon_RNDCURVE = 575,
	EnumPropertyItem_icon_ROOTCURVE = 576,
	EnumPropertyItem_icon_SHARPCURVE = 577,
	EnumPropertyItem_icon_SMOOTHCURVE = 578,
	EnumPropertyItem_icon_SPHERECURVE = 579,
	EnumPropertyItem_icon_VERTEXSEL = 580,
	EnumPropertyItem_icon_VERTEX_CREASE = 581,
	EnumPropertyItem_icon_SNAP_EDGE = 582,
	EnumPropertyItem_icon_SNAP_FACE_CENTER = 583,
	EnumPropertyItem_icon_SNAP_FACE_NEAREST = 584,
	EnumPropertyItem_icon_SNAP_FACE = 585,
	EnumPropertyItem_icon_SNAP_GRID = 586,
	EnumPropertyItem_icon_SNAP_INCREMENT = 587,
	EnumPropertyItem_icon_SNAP_MIDPOINT = 588,
	EnumPropertyItem_icon_SNAP_NORMAL = 589,
	EnumPropertyItem_icon_SNAP_PEEL_OBJECT = 590,
	EnumPropertyItem_icon_SNAP_PERPENDICULAR = 591,
	EnumPropertyItem_icon_SNAP_VERTEX = 592,
	EnumPropertyItem_icon_SNAP_VOLUME = 593,
	EnumPropertyItem_icon_STICKY_UVS_DISABLE = 594,
	EnumPropertyItem_icon_STICKY_UVS_LOC = 595,
	EnumPropertyItem_icon_STICKY_UVS_VERT = 596,
	EnumPropertyItem_icon_ORIENTATION_GIMBAL = 597,
	EnumPropertyItem_icon_ORIENTATION_GLOBAL = 598,
	EnumPropertyItem_icon_ORIENTATION_LOCAL = 599,
	EnumPropertyItem_icon_ORIENTATION_NORMAL = 600,
	EnumPropertyItem_icon_ORIENTATION_VIEW = 601,
	EnumPropertyItem_icon_COPYDOWN = 602,
	EnumPropertyItem_icon_FIXED_SIZE = 603,
	EnumPropertyItem_icon_GIZMO = 604,
	EnumPropertyItem_icon_GP_CAPS_FLAT = 605,
	EnumPropertyItem_icon_GP_CAPS_ROUND = 606,
	EnumPropertyItem_icon_NORMALS_FACE = 607,
	EnumPropertyItem_icon_NORMALS_VERTEX_FACE = 608,
	EnumPropertyItem_icon_NORMALS_VERTEX = 609,
	EnumPropertyItem_icon_OBJECT_ORIGIN = 610,
	EnumPropertyItem_icon_ORIENTATION_CURSOR = 611,
	EnumPropertyItem_icon_PASTEDOWN = 612,
	EnumPropertyItem_icon_PASTEFLIPDOWN = 613,
	EnumPropertyItem_icon_PASTEFLIPUP = 614,
	EnumPropertyItem_icon_TRANSFORM_ORIGINS = 615,
	EnumPropertyItem_icon_UV_EDGESEL = 616,
	EnumPropertyItem_icon_UV_FACESEL = 617,
	EnumPropertyItem_icon_UV_ISLANDSEL = 618,
	EnumPropertyItem_icon_UV_SYNC_SELECT = 619,
	EnumPropertyItem_icon_UV_VERTEXSEL = 620,
	EnumPropertyItem_icon_AXIS_FRONT = 621,
	EnumPropertyItem_icon_AXIS_SIDE = 622,
	EnumPropertyItem_icon_AXIS_TOP = 623,
	EnumPropertyItem_icon_GRID = 624,
	EnumPropertyItem_icon_LAYER_ACTIVE = 625,
	EnumPropertyItem_icon_LAYER_USED = 626,
	EnumPropertyItem_icon_LOCKVIEW_OFF = 627,
	EnumPropertyItem_icon_LOCKVIEW_ON = 628,
	EnumPropertyItem_icon_OVERLAY = 629,
	EnumPropertyItem_icon_SHADING_BBOX = 630,
	EnumPropertyItem_icon_SHADING_RENDERED = 631,
	EnumPropertyItem_icon_SHADING_SOLID = 632,
	EnumPropertyItem_icon_SHADING_TEXTURE = 633,
	EnumPropertyItem_icon_SHADING_WIRE = 634,
	EnumPropertyItem_icon_XRAY = 635,
	EnumPropertyItem_icon_VIEW_CAMERA_UNSELECTED = 636,
	EnumPropertyItem_icon_VIEW_CAMERA = 637,
	EnumPropertyItem_icon_VIEW_LOCKED = 638,
	EnumPropertyItem_icon_VIEW_ORTHO = 639,
	EnumPropertyItem_icon_VIEW_PAN = 640,
	EnumPropertyItem_icon_VIEW_PERSPECTIVE = 641,
	EnumPropertyItem_icon_VIEW_UNLOCKED = 642,
	EnumPropertyItem_icon_VIEW_ZOOM = 643,
	EnumPropertyItem_icon_FILE_ALIAS = 644,
	EnumPropertyItem_icon_FILE_FOLDER = 645,
	EnumPropertyItem_icon_FOLDER_REDIRECT = 646,
	EnumPropertyItem_icon_APPEND_BLEND = 647,
	EnumPropertyItem_icon_BACK = 648,
	EnumPropertyItem_icon_BOOKMARKS = 649,
	EnumPropertyItem_icon_CURRENT_FILE = 650,
	EnumPropertyItem_icon_DESKTOP = 651,
	EnumPropertyItem_icon_DISC = 652,
	EnumPropertyItem_icon_DISK_DRIVE = 653,
	EnumPropertyItem_icon_DOCUMENTS = 654,
	EnumPropertyItem_icon_EXPORT = 655,
	EnumPropertyItem_icon_EXTERNAL_DRIVE = 656,
	EnumPropertyItem_icon_FILE_3D = 657,
	EnumPropertyItem_icon_FILE_ARCHIVE = 658,
	EnumPropertyItem_icon_FILE_BACKUP = 659,
	EnumPropertyItem_icon_FILE_BLANK = 660,
	EnumPropertyItem_icon_FILE_BLEND = 661,
	EnumPropertyItem_icon_FILE_CACHE = 662,
	EnumPropertyItem_icon_FILE_FONT = 663,
	EnumPropertyItem_icon_FILE_HIDDEN = 664,
	EnumPropertyItem_icon_FILE_IMAGE = 665,
	EnumPropertyItem_icon_FILE_MOVIE = 666,
	EnumPropertyItem_icon_FILE_PARENT = 667,
	EnumPropertyItem_icon_FILE_REFRESH = 668,
	EnumPropertyItem_icon_FILE_SCRIPT = 669,
	EnumPropertyItem_icon_FILE_SOUND = 670,
	EnumPropertyItem_icon_FILE_TEXT = 671,
	EnumPropertyItem_icon_FILE_VOLUME = 672,
	EnumPropertyItem_icon_FILTER = 673,
	EnumPropertyItem_icon_FONTPREVIEW = 674,
	EnumPropertyItem_icon_FORWARD = 675,
	EnumPropertyItem_icon_HOME = 676,
	EnumPropertyItem_icon_IMGDISPLAY = 677,
	EnumPropertyItem_icon_IMPORT = 678,
	EnumPropertyItem_icon_LINK_BLEND = 679,
	EnumPropertyItem_icon_LONGDISPLAY = 680,
	EnumPropertyItem_icon_LOOP_BACK = 681,
	EnumPropertyItem_icon_LOOP_FORWARDS = 682,
	EnumPropertyItem_icon_NETWORK_DRIVE = 683,
	EnumPropertyItem_icon_NEWFOLDER = 684,
	EnumPropertyItem_icon_PREVIEW_LOADING = 685,
	EnumPropertyItem_icon_SETTINGS = 686,
	EnumPropertyItem_icon_SHORTDISPLAY = 687,
	EnumPropertyItem_icon_SORT_ASC = 688,
	EnumPropertyItem_icon_SORT_DESC = 689,
	EnumPropertyItem_icon_SORTALPHA = 690,
	EnumPropertyItem_icon_SORTBYEXT = 691,
	EnumPropertyItem_icon_SORTSIZE = 692,
	EnumPropertyItem_icon_SORTTIME = 693,
	EnumPropertyItem_icon_SYSTEM = 694,
	EnumPropertyItem_icon_TAG = 695,
	EnumPropertyItem_icon_TEMP = 696,
	EnumPropertyItem_icon_ALIASED = 697,
	EnumPropertyItem_icon_ANTIALIASED = 698,
	EnumPropertyItem_icon_MAT_SPHERE_SKY = 699,
	EnumPropertyItem_icon_MATCLOTH = 700,
	EnumPropertyItem_icon_MATCUBE = 701,
	EnumPropertyItem_icon_MATFLUID = 702,
	EnumPropertyItem_icon_MATPLANE = 703,
	EnumPropertyItem_icon_MATSHADERBALL = 704,
	EnumPropertyItem_icon_MATSPHERE = 705,
	EnumPropertyItem_icon_SEQ_CHROMA_SCOPE = 706,
	EnumPropertyItem_icon_SEQ_HISTOGRAM = 707,
	EnumPropertyItem_icon_SEQ_LUMA_WAVEFORM = 708,
	EnumPropertyItem_icon_SEQ_PREVIEW = 709,
	EnumPropertyItem_icon_SEQ_SEQUENCER = 710,
	EnumPropertyItem_icon_SEQ_SPLITVIEW = 711,
	EnumPropertyItem_icon_SEQ_STRIP_DUPLICATE = 712,
	EnumPropertyItem_icon_SEQ_STRIP_META = 713,
	EnumPropertyItem_icon_SEQ_STRIP_MODIFIER = 714,
	EnumPropertyItem_icon_MOD_BRIGHTNESS_CONTRAST = 715,
	EnumPropertyItem_icon_MOD_COLOR_BALANCE = 716,
	EnumPropertyItem_icon_MOD_CURVES = 717,
	EnumPropertyItem_icon_MOD_HUE_CORRECT = 718,
	EnumPropertyItem_icon_MOD_TONEMAP = 719,
	EnumPropertyItem_icon_MOD_WHITE_BALANCE = 720,
	EnumPropertyItem_icon_IMAGE_ALPHA = 721,
	EnumPropertyItem_icon_IMAGE_RGB_ALPHA = 722,
	EnumPropertyItem_icon_IMAGE_RGB = 723,
	EnumPropertyItem_icon_IMAGE_ZDEPTH = 724,
	EnumPropertyItem_icon_BLENDER_LOGO_LARGE = 725,
	EnumPropertyItem_icon_CANCEL_LARGE = 726,
	EnumPropertyItem_icon_DISC_LARGE = 727,
	EnumPropertyItem_icon_DISK_DRIVE_LARGE = 728,
	EnumPropertyItem_icon_EXTERNAL_DRIVE_LARGE = 729,
	EnumPropertyItem_icon_FILE_FOLDER_LARGE = 730,
	EnumPropertyItem_icon_FILE_LARGE = 731,
	EnumPropertyItem_icon_FILE_PARENT_LARGE = 732,
	EnumPropertyItem_icon_INFO_LARGE = 733,
	EnumPropertyItem_icon_NETWORK_DRIVE_LARGE = 734,
	EnumPropertyItem_icon_QUESTION_LARGE = 735,
	EnumPropertyItem_icon_WARNING_LARGE = 736,
	EnumPropertyItem_icon_KEY_BACKSPACE_FILLED = 737,
	EnumPropertyItem_icon_KEY_BACKSPACE = 738,
	EnumPropertyItem_icon_KEY_COMMAND_FILLED = 739,
	EnumPropertyItem_icon_KEY_COMMAND = 740,
	EnumPropertyItem_icon_KEY_CONTROL_FILLED = 741,
	EnumPropertyItem_icon_KEY_CONTROL = 742,
	EnumPropertyItem_icon_KEY_EMPTY1_FILLED = 743,
	EnumPropertyItem_icon_KEY_EMPTY1 = 744,
	EnumPropertyItem_icon_KEY_EMPTY2_FILLED = 745,
	EnumPropertyItem_icon_KEY_EMPTY2 = 746,
	EnumPropertyItem_icon_KEY_EMPTY3_FILLED = 747,
	EnumPropertyItem_icon_KEY_EMPTY3 = 748,
	EnumPropertyItem_icon_KEY_MENU_FILLED = 749,
	EnumPropertyItem_icon_KEY_MENU = 750,
	EnumPropertyItem_icon_KEY_OPTION_FILLED = 751,
	EnumPropertyItem_icon_KEY_OPTION = 752,
	EnumPropertyItem_icon_KEY_RETURN_FILLED = 753,
	EnumPropertyItem_icon_KEY_RETURN = 754,
	EnumPropertyItem_icon_KEY_RING_FILLED = 755,
	EnumPropertyItem_icon_KEY_RING = 756,
	EnumPropertyItem_icon_KEY_SHIFT_FILLED = 757,
	EnumPropertyItem_icon_KEY_SHIFT = 758,
	EnumPropertyItem_icon_KEY_TAB_FILLED = 759,
	EnumPropertyItem_icon_KEY_TAB = 760,
	EnumPropertyItem_icon_KEY_WINDOWS_FILLED = 761,
	EnumPropertyItem_icon_KEY_WINDOWS = 762,
	EnumPropertyItem_icon_GESTURE_PAN = 763,
	EnumPropertyItem_icon_GESTURE_ROTATE = 764,
	EnumPropertyItem_icon_GESTURE_ZOOM = 765,
	EnumPropertyItem_icon_FUND = 766,
	EnumPropertyItem_icon_HEART = 767,
	EnumPropertyItem_icon_INTERNET_OFFLINE = 768,
	EnumPropertyItem_icon_INTERNET = 769,
	EnumPropertyItem_icon_USER = 770,
	EnumPropertyItem_icon_EXPERIMENTAL = 771,
	EnumPropertyItem_icon_MEMORY = 772,
	EnumPropertyItem_icon_RGB_RED = 774,
	EnumPropertyItem_icon_RGB_GREEN = 775,
	EnumPropertyItem_icon_RGB_BLUE = 776,
	EnumPropertyItem_icon_KEYTYPE_KEYFRAME_VEC = 777,
	EnumPropertyItem_icon_KEYTYPE_BREAKDOWN_VEC = 778,
	EnumPropertyItem_icon_KEYTYPE_EXTREME_VEC = 779,
	EnumPropertyItem_icon_KEYTYPE_JITTER_VEC = 780,
	EnumPropertyItem_icon_KEYTYPE_MOVING_HOLD_VEC = 781,
	EnumPropertyItem_icon_KEYTYPE_GENERATED_VEC = 782,
	EnumPropertyItem_icon_HANDLETYPE_FREE_VEC = 783,
	EnumPropertyItem_icon_HANDLETYPE_ALIGNED_VEC = 784,
	EnumPropertyItem_icon_HANDLETYPE_VECTOR_VEC = 785,
	EnumPropertyItem_icon_HANDLETYPE_AUTO_VEC = 786,
	EnumPropertyItem_icon_HANDLETYPE_AUTO_CLAMP_VEC = 787,
	EnumPropertyItem_icon_COLORSET_01_VEC = 788,
	EnumPropertyItem_icon_COLORSET_02_VEC = 789,
	EnumPropertyItem_icon_COLORSET_03_VEC = 790,
	EnumPropertyItem_icon_COLORSET_04_VEC = 791,
	EnumPropertyItem_icon_COLORSET_05_VEC = 792,
	EnumPropertyItem_icon_COLORSET_06_VEC = 793,
	EnumPropertyItem_icon_COLORSET_07_VEC = 794,
	EnumPropertyItem_icon_COLORSET_08_VEC = 795,
	EnumPropertyItem_icon_COLORSET_09_VEC = 796,
	EnumPropertyItem_icon_COLORSET_10_VEC = 797,
	EnumPropertyItem_icon_COLORSET_11_VEC = 798,
	EnumPropertyItem_icon_COLORSET_12_VEC = 799,
	EnumPropertyItem_icon_COLORSET_13_VEC = 800,
	EnumPropertyItem_icon_COLORSET_14_VEC = 801,
	EnumPropertyItem_icon_COLORSET_15_VEC = 802,
	EnumPropertyItem_icon_COLORSET_16_VEC = 803,
	EnumPropertyItem_icon_COLORSET_17_VEC = 804,
	EnumPropertyItem_icon_COLORSET_18_VEC = 805,
	EnumPropertyItem_icon_COLORSET_19_VEC = 806,
	EnumPropertyItem_icon_COLORSET_20_VEC = 807,
	EnumPropertyItem_icon_STRIP_COLOR_01 = 808,
	EnumPropertyItem_icon_STRIP_COLOR_02 = 809,
	EnumPropertyItem_icon_STRIP_COLOR_03 = 810,
	EnumPropertyItem_icon_STRIP_COLOR_04 = 811,
	EnumPropertyItem_icon_STRIP_COLOR_05 = 812,
	EnumPropertyItem_icon_STRIP_COLOR_06 = 813,
	EnumPropertyItem_icon_STRIP_COLOR_07 = 814,
	EnumPropertyItem_icon_STRIP_COLOR_08 = 815,
	EnumPropertyItem_icon_STRIP_COLOR_09 = 816,
	EnumPropertyItem_icon_LIBRARY_DATA_INDIRECT = 817,
	EnumPropertyItem_icon_LIBRARY_DATA_OVERRIDE_NONEDITABLE = 818,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_01 = 819,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_02 = 820,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_03 = 821,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_04 = 822,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_05 = 823,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_06 = 824,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_07 = 825,
	EnumPropertyItem_icon_LAYERGROUP_COLOR_08 = 826,
	EnumPropertyItem_icon_EVENT_A = 827,
	EnumPropertyItem_icon_EVENT_B = 828,
	EnumPropertyItem_icon_EVENT_C = 829,
	EnumPropertyItem_icon_EVENT_D = 830,
	EnumPropertyItem_icon_EVENT_E = 831,
	EnumPropertyItem_icon_EVENT_F = 832,
	EnumPropertyItem_icon_EVENT_G = 833,
	EnumPropertyItem_icon_EVENT_H = 834,
	EnumPropertyItem_icon_EVENT_I = 835,
	EnumPropertyItem_icon_EVENT_J = 836,
	EnumPropertyItem_icon_EVENT_K = 837,
	EnumPropertyItem_icon_EVENT_L = 838,
	EnumPropertyItem_icon_EVENT_M = 839,
	EnumPropertyItem_icon_EVENT_N = 840,
	EnumPropertyItem_icon_EVENT_O = 841,
	EnumPropertyItem_icon_EVENT_P = 842,
	EnumPropertyItem_icon_EVENT_Q = 843,
	EnumPropertyItem_icon_EVENT_R = 844,
	EnumPropertyItem_icon_EVENT_S = 845,
	EnumPropertyItem_icon_EVENT_T = 846,
	EnumPropertyItem_icon_EVENT_U = 847,
	EnumPropertyItem_icon_EVENT_V = 848,
	EnumPropertyItem_icon_EVENT_W = 849,
	EnumPropertyItem_icon_EVENT_X = 850,
	EnumPropertyItem_icon_EVENT_Y = 851,
	EnumPropertyItem_icon_EVENT_Z = 852,
	EnumPropertyItem_icon_EVENT_SHIFT = 853,
	EnumPropertyItem_icon_EVENT_CTRL = 854,
	EnumPropertyItem_icon_EVENT_ALT = 855,
	EnumPropertyItem_icon_EVENT_OS = 856,
	EnumPropertyItem_icon_EVENT_HYPER = 857,
	EnumPropertyItem_icon_EVENT_F1 = 858,
	EnumPropertyItem_icon_EVENT_F2 = 859,
	EnumPropertyItem_icon_EVENT_F3 = 860,
	EnumPropertyItem_icon_EVENT_F4 = 861,
	EnumPropertyItem_icon_EVENT_F5 = 862,
	EnumPropertyItem_icon_EVENT_F6 = 863,
	EnumPropertyItem_icon_EVENT_F7 = 864,
	EnumPropertyItem_icon_EVENT_F8 = 865,
	EnumPropertyItem_icon_EVENT_F9 = 866,
	EnumPropertyItem_icon_EVENT_F10 = 867,
	EnumPropertyItem_icon_EVENT_F11 = 868,
	EnumPropertyItem_icon_EVENT_F12 = 869,
	EnumPropertyItem_icon_EVENT_F13 = 870,
	EnumPropertyItem_icon_EVENT_F14 = 871,
	EnumPropertyItem_icon_EVENT_F15 = 872,
	EnumPropertyItem_icon_EVENT_F16 = 873,
	EnumPropertyItem_icon_EVENT_F17 = 874,
	EnumPropertyItem_icon_EVENT_F18 = 875,
	EnumPropertyItem_icon_EVENT_F19 = 876,
	EnumPropertyItem_icon_EVENT_F20 = 877,
	EnumPropertyItem_icon_EVENT_F21 = 878,
	EnumPropertyItem_icon_EVENT_F22 = 879,
	EnumPropertyItem_icon_EVENT_F23 = 880,
	EnumPropertyItem_icon_EVENT_F24 = 881,
	EnumPropertyItem_icon_EVENT_ESC = 882,
	EnumPropertyItem_icon_EVENT_TAB = 883,
	EnumPropertyItem_icon_EVENT_PAGEUP = 884,
	EnumPropertyItem_icon_EVENT_PAGEDOWN = 885,
	EnumPropertyItem_icon_EVENT_RETURN = 886,
	EnumPropertyItem_icon_EVENT_SPACEKEY = 887,
	EnumPropertyItem_icon_EVENT_ZEROKEY = 888,
	EnumPropertyItem_icon_EVENT_ONEKEY = 889,
	EnumPropertyItem_icon_EVENT_TWOKEY = 890,
	EnumPropertyItem_icon_EVENT_THREEKEY = 891,
	EnumPropertyItem_icon_EVENT_FOURKEY = 892,
	EnumPropertyItem_icon_EVENT_FIVEKEY = 893,
	EnumPropertyItem_icon_EVENT_SIXKEY = 894,
	EnumPropertyItem_icon_EVENT_SEVENKEY = 895,
	EnumPropertyItem_icon_EVENT_EIGHTKEY = 896,
	EnumPropertyItem_icon_EVENT_NINEKEY = 897,
	EnumPropertyItem_icon_EVENT_PAD0 = 898,
	EnumPropertyItem_icon_EVENT_PAD1 = 899,
	EnumPropertyItem_icon_EVENT_PAD2 = 900,
	EnumPropertyItem_icon_EVENT_PAD3 = 901,
	EnumPropertyItem_icon_EVENT_PAD4 = 902,
	EnumPropertyItem_icon_EVENT_PAD5 = 903,
	EnumPropertyItem_icon_EVENT_PAD6 = 904,
	EnumPropertyItem_icon_EVENT_PAD7 = 905,
	EnumPropertyItem_icon_EVENT_PAD8 = 906,
	EnumPropertyItem_icon_EVENT_PAD9 = 907,
	EnumPropertyItem_icon_EVENT_PADASTER = 908,
	EnumPropertyItem_icon_EVENT_PADSLASH = 909,
	EnumPropertyItem_icon_EVENT_PADMINUS = 910,
	EnumPropertyItem_icon_EVENT_PADENTER = 911,
	EnumPropertyItem_icon_EVENT_PADPLUS = 912,
	EnumPropertyItem_icon_EVENT_PADPERIOD = 913,
	EnumPropertyItem_icon_EVENT_MOUSE_4 = 914,
	EnumPropertyItem_icon_EVENT_MOUSE_5 = 915,
	EnumPropertyItem_icon_EVENT_MOUSE_6 = 916,
	EnumPropertyItem_icon_EVENT_MOUSE_7 = 917,
	EnumPropertyItem_icon_EVENT_TABLET_STYLUS = 918,
	EnumPropertyItem_icon_EVENT_TABLET_ERASER = 919,
	EnumPropertyItem_icon_EVENT_LEFT_ARROW = 920,
	EnumPropertyItem_icon_EVENT_DOWN_ARROW = 921,
	EnumPropertyItem_icon_EVENT_RIGHT_ARROW = 922,
	EnumPropertyItem_icon_EVENT_UP_ARROW = 923,
	EnumPropertyItem_icon_EVENT_PAUSE = 924,
	EnumPropertyItem_icon_EVENT_INSERT = 925,
	EnumPropertyItem_icon_EVENT_HOME = 926,
	EnumPropertyItem_icon_EVENT_END = 927,
	EnumPropertyItem_icon_EVENT_UNKNOWN = 928,
	EnumPropertyItem_icon_EVENT_GRLESS = 929,
	EnumPropertyItem_icon_EVENT_MEDIAPLAY = 930,
	EnumPropertyItem_icon_EVENT_MEDIASTOP = 931,
	EnumPropertyItem_icon_EVENT_MEDIAFIRST = 932,
	EnumPropertyItem_icon_EVENT_MEDIALAST = 933,
	EnumPropertyItem_icon_EVENT_APP = 934,
	EnumPropertyItem_icon_EVENT_CAPSLOCK = 935,
	EnumPropertyItem_icon_EVENT_BACKSPACE = 936,
	EnumPropertyItem_icon_EVENT_DEL = 937,
	EnumPropertyItem_icon_EVENT_SEMICOLON = 938,
	EnumPropertyItem_icon_EVENT_PERIOD = 939,
	EnumPropertyItem_icon_EVENT_COMMA = 940,
	EnumPropertyItem_icon_EVENT_QUOTE = 941,
	EnumPropertyItem_icon_EVENT_ACCENTGRAVE = 942,
	EnumPropertyItem_icon_EVENT_MINUS = 943,
	EnumPropertyItem_icon_EVENT_PLUS = 944,
	EnumPropertyItem_icon_EVENT_SLASH = 945,
	EnumPropertyItem_icon_EVENT_BACKSLASH = 946,
	EnumPropertyItem_icon_EVENT_EQUAL = 947,
	EnumPropertyItem_icon_EVENT_LEFTBRACKET = 948,
	EnumPropertyItem_icon_EVENT_RIGHTBRACKET = 949,
	EnumPropertyItem_icon_EVENT_PAD_PAN = 950,
	EnumPropertyItem_icon_EVENT_PAD_ROTATE = 951,
	EnumPropertyItem_icon_EVENT_PAD_ZOOM = 952,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_V1 = 953,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_V2 = 954,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_V3 = 955,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_SAVE_V1 = 956,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_SAVE_V2 = 957,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_SAVE_V3 = 958,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_1 = 959,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_2 = 960,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_3 = 961,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_4 = 962,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_5 = 963,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_6 = 964,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_7 = 965,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_8 = 966,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_9 = 967,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_10 = 968,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_11 = 969,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_12 = 970,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_MENU = 971,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_FIT = 972,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_TOP = 973,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_BOTTOM = 974,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_LEFT = 975,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_RIGHT = 976,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_FRONT = 977,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_BACK = 978,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_ISO1 = 979,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_ISO2 = 980,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_ROLL_CW = 981,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_ROLL_CCW = 982,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_SPIN_CW = 983,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_SPIN_CCW = 984,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_TILT_CW = 985,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_TILT_CCW = 986,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_ROTATE = 987,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_PANZOOM = 988,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_DOMINANT = 989,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_PLUS = 990,
	EnumPropertyItem_icon_EVENT_NDOF_BUTTON_MINUS = 991,
	EnumPropertyItem_icon_NODE_SOCKET_FLOAT = 992,
	EnumPropertyItem_icon_NODE_SOCKET_VECTOR = 993,
	EnumPropertyItem_icon_NODE_SOCKET_RGBA = 994,
	EnumPropertyItem_icon_NODE_SOCKET_SHADER = 995,
	EnumPropertyItem_icon_NODE_SOCKET_BOOLEAN = 996,
	EnumPropertyItem_icon_NODE_SOCKET_INT = 997,
	EnumPropertyItem_icon_NODE_SOCKET_STRING = 998,
	EnumPropertyItem_icon_NODE_SOCKET_OBJECT = 999,
	EnumPropertyItem_icon_NODE_SOCKET_IMAGE = 1000,
	EnumPropertyItem_icon_NODE_SOCKET_GEOMETRY = 1001,
	EnumPropertyItem_icon_NODE_SOCKET_COLLECTION = 1002,
	EnumPropertyItem_icon_NODE_SOCKET_TEXTURE = 1003,
	EnumPropertyItem_icon_NODE_SOCKET_MATERIAL = 1004,
	EnumPropertyItem_icon_NODE_SOCKET_ROTATION = 1005,
	EnumPropertyItem_icon_NODE_SOCKET_MENU = 1006,
	EnumPropertyItem_icon_NODE_SOCKET_MATRIX = 1007,
	EnumPropertyItem_icon_NODE_SOCKET_BUNDLE = 1008,
	EnumPropertyItem_icon_NODE_SOCKET_CLOSURE = 1009,
};

int EnumPropertyItem_icon_get(PointerRNA *ptr);
void EnumPropertyItem_icon_set(PointerRNA *ptr, int value);

void EnumPropertyItem_identifier_get(PointerRNA *ptr, char *value);
int EnumPropertyItem_identifier_length(PointerRNA *ptr);
void EnumPropertyItem_identifier_set(PointerRNA *ptr, const char *value);

int EnumPropertyItem_value_get(PointerRNA *ptr);
void EnumPropertyItem_value_set(PointerRNA *ptr, int value);

/**************** EvaluateClosureNodeViewerPathElem ****************/

extern StructRNA RNA_EvaluateClosureNodeViewerPathElem;
extern StructRNA RNA_ViewerPathElem;

int EvaluateClosureNodeViewerPathElem_source_output_node_id_get(PointerRNA *ptr);
void EvaluateClosureNodeViewerPathElem_source_output_node_id_set(PointerRNA *ptr, int value);

int EvaluateClosureNodeViewerPathElem_evaluate_node_id_get(PointerRNA *ptr);
void EvaluateClosureNodeViewerPathElem_evaluate_node_id_set(PointerRNA *ptr, int value);

PointerRNA EvaluateClosureNodeViewerPathElem_source_node_tree_get(PointerRNA *ptr);

/**************** Event ****************/

extern StructRNA RNA_Event;

PointerRNA Event_rna_type_get(PointerRNA *ptr);

void Event_ascii_get(PointerRNA *ptr, char *value);
int Event_ascii_length(PointerRNA *ptr);
void Event_ascii_set(PointerRNA *ptr, const char *value);

bool Event_is_mouse_absolute_get(PointerRNA *ptr);
void Event_is_mouse_absolute_set(PointerRNA *ptr, bool value);

bool Event_alt_get(PointerRNA *ptr);
void Event_alt_set(PointerRNA *ptr, bool value);

bool Event_ctrl_get(PointerRNA *ptr);
void Event_ctrl_set(PointerRNA *ptr, bool value);

enum {
	Event_direction_ANY = -1,
	Event_direction_NORTH = 1,
	Event_direction_NORTH_EAST = 2,
	Event_direction_EAST = 3,
	Event_direction_SOUTH_EAST = 4,
	Event_direction_SOUTH = 5,
	Event_direction_SOUTH_WEST = 6,
	Event_direction_WEST = 7,
	Event_direction_NORTH_WEST = 8,
};

int Event_direction_get(PointerRNA *ptr);
void Event_direction_set(PointerRNA *ptr, int value);

bool Event_hyper_get(PointerRNA *ptr);
void Event_hyper_set(PointerRNA *ptr, bool value);

bool Event_is_consecutive_get(PointerRNA *ptr);
void Event_is_consecutive_set(PointerRNA *ptr, bool value);

bool Event_is_repeat_get(PointerRNA *ptr);
void Event_is_repeat_set(PointerRNA *ptr, bool value);

bool Event_is_tablet_get(PointerRNA *ptr);
void Event_is_tablet_set(PointerRNA *ptr, bool value);

int Event_mouse_prev_x_get(PointerRNA *ptr);
void Event_mouse_prev_x_set(PointerRNA *ptr, int value);

int Event_mouse_prev_press_x_get(PointerRNA *ptr);
void Event_mouse_prev_press_x_set(PointerRNA *ptr, int value);

int Event_mouse_prev_y_get(PointerRNA *ptr);
void Event_mouse_prev_y_set(PointerRNA *ptr, int value);

int Event_mouse_prev_press_y_get(PointerRNA *ptr);
void Event_mouse_prev_press_y_set(PointerRNA *ptr, int value);

int Event_mouse_x_get(PointerRNA *ptr);
void Event_mouse_x_set(PointerRNA *ptr, int value);

int Event_mouse_region_x_get(PointerRNA *ptr);
void Event_mouse_region_x_set(PointerRNA *ptr, int value);

int Event_mouse_y_get(PointerRNA *ptr);
void Event_mouse_y_set(PointerRNA *ptr, int value);

int Event_mouse_region_y_get(PointerRNA *ptr);
void Event_mouse_region_y_set(PointerRNA *ptr, int value);

PointerRNA Event_ndof_motion_get(PointerRNA *ptr);

bool Event_oskey_get(PointerRNA *ptr);
void Event_oskey_set(PointerRNA *ptr, bool value);

enum {
	Event_type_prev_NONE = 0,
	Event_type_prev_LEFTMOUSE = 1,
	Event_type_prev_MIDDLEMOUSE = 2,
	Event_type_prev_RIGHTMOUSE = 3,
	Event_type_prev_BUTTON4MOUSE = 7,
	Event_type_prev_BUTTON5MOUSE = 8,
	Event_type_prev_BUTTON6MOUSE = 18,
	Event_type_prev_BUTTON7MOUSE = 19,
	Event_type_prev_PEN = 26,
	Event_type_prev_ERASER = 27,
	Event_type_prev_MOUSEMOVE = 4,
	Event_type_prev_INBETWEEN_MOUSEMOVE = 17,
	Event_type_prev_TRACKPADPAN = 14,
	Event_type_prev_TRACKPADZOOM = 15,
	Event_type_prev_MOUSEROTATE = 16,
	Event_type_prev_MOUSESMARTZOOM = 23,
	Event_type_prev_WHEELUPMOUSE = 10,
	Event_type_prev_WHEELDOWNMOUSE = 11,
	Event_type_prev_WHEELINMOUSE = 12,
	Event_type_prev_WHEELOUTMOUSE = 13,
	Event_type_prev_WHEELLEFTMOUSE = 20,
	Event_type_prev_WHEELRIGHTMOUSE = 21,
	Event_type_prev_A = 97,
	Event_type_prev_B = 98,
	Event_type_prev_C = 99,
	Event_type_prev_D = 100,
	Event_type_prev_E = 101,
	Event_type_prev_F = 102,
	Event_type_prev_G = 103,
	Event_type_prev_H = 104,
	Event_type_prev_I = 105,
	Event_type_prev_J = 106,
	Event_type_prev_K = 107,
	Event_type_prev_L = 108,
	Event_type_prev_M = 109,
	Event_type_prev_N = 110,
	Event_type_prev_O = 111,
	Event_type_prev_P = 112,
	Event_type_prev_Q = 113,
	Event_type_prev_R = 114,
	Event_type_prev_S = 115,
	Event_type_prev_T = 116,
	Event_type_prev_U = 117,
	Event_type_prev_V = 118,
	Event_type_prev_W = 119,
	Event_type_prev_X = 120,
	Event_type_prev_Y = 121,
	Event_type_prev_Z = 122,
	Event_type_prev_ZERO = 48,
	Event_type_prev_ONE = 49,
	Event_type_prev_TWO = 50,
	Event_type_prev_THREE = 51,
	Event_type_prev_FOUR = 52,
	Event_type_prev_FIVE = 53,
	Event_type_prev_SIX = 54,
	Event_type_prev_SEVEN = 55,
	Event_type_prev_EIGHT = 56,
	Event_type_prev_NINE = 57,
	Event_type_prev_LEFT_CTRL = 212,
	Event_type_prev_LEFT_ALT = 213,
	Event_type_prev_LEFT_SHIFT = 217,
	Event_type_prev_RIGHT_ALT = 214,
	Event_type_prev_RIGHT_CTRL = 215,
	Event_type_prev_RIGHT_SHIFT = 216,
	Event_type_prev_OSKEY = 172,
	Event_type_prev_HYPER = 179,
	Event_type_prev_APP = 178,
	Event_type_prev_GRLESS = 173,
	Event_type_prev_ESC = 218,
	Event_type_prev_TAB = 219,
	Event_type_prev_RET = 220,
	Event_type_prev_SPACE = 221,
	Event_type_prev_LINE_FEED = 222,
	Event_type_prev_BACK_SPACE = 223,
	Event_type_prev_DEL = 224,
	Event_type_prev_SEMI_COLON = 225,
	Event_type_prev_PERIOD = 226,
	Event_type_prev_COMMA = 227,
	Event_type_prev_QUOTE = 228,
	Event_type_prev_ACCENT_GRAVE = 229,
	Event_type_prev_MINUS = 230,
	Event_type_prev_PLUS = 231,
	Event_type_prev_SLASH = 232,
	Event_type_prev_BACK_SLASH = 233,
	Event_type_prev_EQUAL = 234,
	Event_type_prev_LEFT_BRACKET = 235,
	Event_type_prev_RIGHT_BRACKET = 236,
	Event_type_prev_LEFT_ARROW = 137,
	Event_type_prev_DOWN_ARROW = 138,
	Event_type_prev_RIGHT_ARROW = 139,
	Event_type_prev_UP_ARROW = 140,
	Event_type_prev_NUMPAD_2 = 152,
	Event_type_prev_NUMPAD_4 = 154,
	Event_type_prev_NUMPAD_6 = 156,
	Event_type_prev_NUMPAD_8 = 158,
	Event_type_prev_NUMPAD_1 = 151,
	Event_type_prev_NUMPAD_3 = 153,
	Event_type_prev_NUMPAD_5 = 155,
	Event_type_prev_NUMPAD_7 = 157,
	Event_type_prev_NUMPAD_9 = 159,
	Event_type_prev_NUMPAD_PERIOD = 199,
	Event_type_prev_NUMPAD_SLASH = 161,
	Event_type_prev_NUMPAD_ASTERIX = 160,
	Event_type_prev_NUMPAD_0 = 150,
	Event_type_prev_NUMPAD_MINUS = 162,
	Event_type_prev_NUMPAD_ENTER = 163,
	Event_type_prev_NUMPAD_PLUS = 164,
	Event_type_prev_F1 = 300,
	Event_type_prev_F2 = 301,
	Event_type_prev_F3 = 302,
	Event_type_prev_F4 = 303,
	Event_type_prev_F5 = 304,
	Event_type_prev_F6 = 305,
	Event_type_prev_F7 = 306,
	Event_type_prev_F8 = 307,
	Event_type_prev_F9 = 308,
	Event_type_prev_F10 = 309,
	Event_type_prev_F11 = 310,
	Event_type_prev_F12 = 311,
	Event_type_prev_F13 = 312,
	Event_type_prev_F14 = 313,
	Event_type_prev_F15 = 314,
	Event_type_prev_F16 = 315,
	Event_type_prev_F17 = 316,
	Event_type_prev_F18 = 317,
	Event_type_prev_F19 = 318,
	Event_type_prev_F20 = 319,
	Event_type_prev_F21 = 320,
	Event_type_prev_F22 = 321,
	Event_type_prev_F23 = 322,
	Event_type_prev_F24 = 323,
	Event_type_prev_PAUSE = 165,
	Event_type_prev_INSERT = 166,
	Event_type_prev_HOME = 167,
	Event_type_prev_PAGE_UP = 168,
	Event_type_prev_PAGE_DOWN = 169,
	Event_type_prev_END = 170,
	Event_type_prev_MEDIA_PLAY = 174,
	Event_type_prev_MEDIA_STOP = 175,
	Event_type_prev_MEDIA_FIRST = 176,
	Event_type_prev_MEDIA_LAST = 177,
	Event_type_prev_TEXTINPUT = -2,
	Event_type_prev_WINDOW_DEACTIVATE = 260,
	Event_type_prev_TIMER = 272,
	Event_type_prev_TIMER0 = 273,
	Event_type_prev_TIMER1 = 274,
	Event_type_prev_TIMER2 = 275,
	Event_type_prev_TIMER_JOBS = 276,
	Event_type_prev_TIMER_AUTOSAVE = 277,
	Event_type_prev_TIMER_REPORT = 278,
	Event_type_prev_TIMERREGION = 279,
	Event_type_prev_NDOF_MOTION = 400,
	Event_type_prev_NDOF_BUTTON_MENU = 401,
	Event_type_prev_NDOF_BUTTON_FIT = 402,
	Event_type_prev_NDOF_BUTTON_TOP = 403,
	Event_type_prev_NDOF_BUTTON_BOTTOM = 404,
	Event_type_prev_NDOF_BUTTON_LEFT = 405,
	Event_type_prev_NDOF_BUTTON_RIGHT = 406,
	Event_type_prev_NDOF_BUTTON_FRONT = 407,
	Event_type_prev_NDOF_BUTTON_BACK = 408,
	Event_type_prev_NDOF_BUTTON_ISO1 = 409,
	Event_type_prev_NDOF_BUTTON_ISO2 = 410,
	Event_type_prev_NDOF_BUTTON_ROLL_CW = 411,
	Event_type_prev_NDOF_BUTTON_ROLL_CCW = 412,
	Event_type_prev_NDOF_BUTTON_SPIN_CW = 413,
	Event_type_prev_NDOF_BUTTON_SPIN_CCW = 414,
	Event_type_prev_NDOF_BUTTON_TILT_CW = 415,
	Event_type_prev_NDOF_BUTTON_TILT_CCW = 416,
	Event_type_prev_NDOF_BUTTON_ROTATE = 417,
	Event_type_prev_NDOF_BUTTON_PANZOOM = 418,
	Event_type_prev_NDOF_BUTTON_DOMINANT = 419,
	Event_type_prev_NDOF_BUTTON_PLUS = 420,
	Event_type_prev_NDOF_BUTTON_MINUS = 421,
	Event_type_prev_NDOF_BUTTON_V1 = 422,
	Event_type_prev_NDOF_BUTTON_V2 = 423,
	Event_type_prev_NDOF_BUTTON_V3 = 424,
	Event_type_prev_NDOF_BUTTON_SAVE_V1 = 446,
	Event_type_prev_NDOF_BUTTON_SAVE_V2 = 447,
	Event_type_prev_NDOF_BUTTON_SAVE_V3 = 448,
	Event_type_prev_NDOF_BUTTON_1 = 426,
	Event_type_prev_NDOF_BUTTON_2 = 427,
	Event_type_prev_NDOF_BUTTON_3 = 428,
	Event_type_prev_NDOF_BUTTON_4 = 429,
	Event_type_prev_NDOF_BUTTON_5 = 430,
	Event_type_prev_NDOF_BUTTON_6 = 431,
	Event_type_prev_NDOF_BUTTON_7 = 432,
	Event_type_prev_NDOF_BUTTON_8 = 433,
	Event_type_prev_NDOF_BUTTON_9 = 434,
	Event_type_prev_NDOF_BUTTON_10 = 435,
	Event_type_prev_NDOF_BUTTON_11 = 436,
	Event_type_prev_NDOF_BUTTON_12 = 437,
	Event_type_prev_ACTIONZONE_AREA = 20480,
	Event_type_prev_ACTIONZONE_REGION = 20481,
	Event_type_prev_ACTIONZONE_FULLSCREEN = 20497,
	Event_type_prev_XR_ACTION = 20528,
};

int Event_type_prev_get(PointerRNA *ptr);
void Event_type_prev_set(PointerRNA *ptr, int value);

enum {
	Event_value_prev_ANY = -1,
	Event_value_prev_PRESS = 1,
	Event_value_prev_RELEASE = 2,
	Event_value_prev_CLICK = 3,
	Event_value_prev_DOUBLE_CLICK = 4,
	Event_value_prev_CLICK_DRAG = 5,
	Event_value_prev_NOTHING = 0,
};

int Event_value_prev_get(PointerRNA *ptr);
void Event_value_prev_set(PointerRNA *ptr, int value);

bool Event_shift_get(PointerRNA *ptr);
void Event_shift_set(PointerRNA *ptr, bool value);

float Event_pressure_get(PointerRNA *ptr);
void Event_pressure_set(PointerRNA *ptr, float value);

void Event_tilt_get(PointerRNA *ptr, float values[2]);
void Event_tilt_set(PointerRNA *ptr, const float values[2]);

enum {
	Event_type_NONE = 0,
	Event_type_LEFTMOUSE = 1,
	Event_type_MIDDLEMOUSE = 2,
	Event_type_RIGHTMOUSE = 3,
	Event_type_BUTTON4MOUSE = 7,
	Event_type_BUTTON5MOUSE = 8,
	Event_type_BUTTON6MOUSE = 18,
	Event_type_BUTTON7MOUSE = 19,
	Event_type_PEN = 26,
	Event_type_ERASER = 27,
	Event_type_MOUSEMOVE = 4,
	Event_type_INBETWEEN_MOUSEMOVE = 17,
	Event_type_TRACKPADPAN = 14,
	Event_type_TRACKPADZOOM = 15,
	Event_type_MOUSEROTATE = 16,
	Event_type_MOUSESMARTZOOM = 23,
	Event_type_WHEELUPMOUSE = 10,
	Event_type_WHEELDOWNMOUSE = 11,
	Event_type_WHEELINMOUSE = 12,
	Event_type_WHEELOUTMOUSE = 13,
	Event_type_WHEELLEFTMOUSE = 20,
	Event_type_WHEELRIGHTMOUSE = 21,
	Event_type_A = 97,
	Event_type_B = 98,
	Event_type_C = 99,
	Event_type_D = 100,
	Event_type_E = 101,
	Event_type_F = 102,
	Event_type_G = 103,
	Event_type_H = 104,
	Event_type_I = 105,
	Event_type_J = 106,
	Event_type_K = 107,
	Event_type_L = 108,
	Event_type_M = 109,
	Event_type_N = 110,
	Event_type_O = 111,
	Event_type_P = 112,
	Event_type_Q = 113,
	Event_type_R = 114,
	Event_type_S = 115,
	Event_type_T = 116,
	Event_type_U = 117,
	Event_type_V = 118,
	Event_type_W = 119,
	Event_type_X = 120,
	Event_type_Y = 121,
	Event_type_Z = 122,
	Event_type_ZERO = 48,
	Event_type_ONE = 49,
	Event_type_TWO = 50,
	Event_type_THREE = 51,
	Event_type_FOUR = 52,
	Event_type_FIVE = 53,
	Event_type_SIX = 54,
	Event_type_SEVEN = 55,
	Event_type_EIGHT = 56,
	Event_type_NINE = 57,
	Event_type_LEFT_CTRL = 212,
	Event_type_LEFT_ALT = 213,
	Event_type_LEFT_SHIFT = 217,
	Event_type_RIGHT_ALT = 214,
	Event_type_RIGHT_CTRL = 215,
	Event_type_RIGHT_SHIFT = 216,
	Event_type_OSKEY = 172,
	Event_type_HYPER = 179,
	Event_type_APP = 178,
	Event_type_GRLESS = 173,
	Event_type_ESC = 218,
	Event_type_TAB = 219,
	Event_type_RET = 220,
	Event_type_SPACE = 221,
	Event_type_LINE_FEED = 222,
	Event_type_BACK_SPACE = 223,
	Event_type_DEL = 224,
	Event_type_SEMI_COLON = 225,
	Event_type_PERIOD = 226,
	Event_type_COMMA = 227,
	Event_type_QUOTE = 228,
	Event_type_ACCENT_GRAVE = 229,
	Event_type_MINUS = 230,
	Event_type_PLUS = 231,
	Event_type_SLASH = 232,
	Event_type_BACK_SLASH = 233,
	Event_type_EQUAL = 234,
	Event_type_LEFT_BRACKET = 235,
	Event_type_RIGHT_BRACKET = 236,
	Event_type_LEFT_ARROW = 137,
	Event_type_DOWN_ARROW = 138,
	Event_type_RIGHT_ARROW = 139,
	Event_type_UP_ARROW = 140,
	Event_type_NUMPAD_2 = 152,
	Event_type_NUMPAD_4 = 154,
	Event_type_NUMPAD_6 = 156,
	Event_type_NUMPAD_8 = 158,
	Event_type_NUMPAD_1 = 151,
	Event_type_NUMPAD_3 = 153,
	Event_type_NUMPAD_5 = 155,
	Event_type_NUMPAD_7 = 157,
	Event_type_NUMPAD_9 = 159,
	Event_type_NUMPAD_PERIOD = 199,
	Event_type_NUMPAD_SLASH = 161,
	Event_type_NUMPAD_ASTERIX = 160,
	Event_type_NUMPAD_0 = 150,
	Event_type_NUMPAD_MINUS = 162,
	Event_type_NUMPAD_ENTER = 163,
	Event_type_NUMPAD_PLUS = 164,
	Event_type_F1 = 300,
	Event_type_F2 = 301,
	Event_type_F3 = 302,
	Event_type_F4 = 303,
	Event_type_F5 = 304,
	Event_type_F6 = 305,
	Event_type_F7 = 306,
	Event_type_F8 = 307,
	Event_type_F9 = 308,
	Event_type_F10 = 309,
	Event_type_F11 = 310,
	Event_type_F12 = 311,
	Event_type_F13 = 312,
	Event_type_F14 = 313,
	Event_type_F15 = 314,
	Event_type_F16 = 315,
	Event_type_F17 = 316,
	Event_type_F18 = 317,
	Event_type_F19 = 318,
	Event_type_F20 = 319,
	Event_type_F21 = 320,
	Event_type_F22 = 321,
	Event_type_F23 = 322,
	Event_type_F24 = 323,
	Event_type_PAUSE = 165,
	Event_type_INSERT = 166,
	Event_type_HOME = 167,
	Event_type_PAGE_UP = 168,
	Event_type_PAGE_DOWN = 169,
	Event_type_END = 170,
	Event_type_MEDIA_PLAY = 174,
	Event_type_MEDIA_STOP = 175,
	Event_type_MEDIA_FIRST = 176,
	Event_type_MEDIA_LAST = 177,
	Event_type_TEXTINPUT = -2,
	Event_type_WINDOW_DEACTIVATE = 260,
	Event_type_TIMER = 272,
	Event_type_TIMER0 = 273,
	Event_type_TIMER1 = 274,
	Event_type_TIMER2 = 275,
	Event_type_TIMER_JOBS = 276,
	Event_type_TIMER_AUTOSAVE = 277,
	Event_type_TIMER_REPORT = 278,
	Event_type_TIMERREGION = 279,
	Event_type_NDOF_MOTION = 400,
	Event_type_NDOF_BUTTON_MENU = 401,
	Event_type_NDOF_BUTTON_FIT = 402,
	Event_type_NDOF_BUTTON_TOP = 403,
	Event_type_NDOF_BUTTON_BOTTOM = 404,
	Event_type_NDOF_BUTTON_LEFT = 405,
	Event_type_NDOF_BUTTON_RIGHT = 406,
	Event_type_NDOF_BUTTON_FRONT = 407,
	Event_type_NDOF_BUTTON_BACK = 408,
	Event_type_NDOF_BUTTON_ISO1 = 409,
	Event_type_NDOF_BUTTON_ISO2 = 410,
	Event_type_NDOF_BUTTON_ROLL_CW = 411,
	Event_type_NDOF_BUTTON_ROLL_CCW = 412,
	Event_type_NDOF_BUTTON_SPIN_CW = 413,
	Event_type_NDOF_BUTTON_SPIN_CCW = 414,
	Event_type_NDOF_BUTTON_TILT_CW = 415,
	Event_type_NDOF_BUTTON_TILT_CCW = 416,
	Event_type_NDOF_BUTTON_ROTATE = 417,
	Event_type_NDOF_BUTTON_PANZOOM = 418,
	Event_type_NDOF_BUTTON_DOMINANT = 419,
	Event_type_NDOF_BUTTON_PLUS = 420,
	Event_type_NDOF_BUTTON_MINUS = 421,
	Event_type_NDOF_BUTTON_V1 = 422,
	Event_type_NDOF_BUTTON_V2 = 423,
	Event_type_NDOF_BUTTON_V3 = 424,
	Event_type_NDOF_BUTTON_SAVE_V1 = 446,
	Event_type_NDOF_BUTTON_SAVE_V2 = 447,
	Event_type_NDOF_BUTTON_SAVE_V3 = 448,
	Event_type_NDOF_BUTTON_1 = 426,
	Event_type_NDOF_BUTTON_2 = 427,
	Event_type_NDOF_BUTTON_3 = 428,
	Event_type_NDOF_BUTTON_4 = 429,
	Event_type_NDOF_BUTTON_5 = 430,
	Event_type_NDOF_BUTTON_6 = 431,
	Event_type_NDOF_BUTTON_7 = 432,
	Event_type_NDOF_BUTTON_8 = 433,
	Event_type_NDOF_BUTTON_9 = 434,
	Event_type_NDOF_BUTTON_10 = 435,
	Event_type_NDOF_BUTTON_11 = 436,
	Event_type_NDOF_BUTTON_12 = 437,
	Event_type_ACTIONZONE_AREA = 20480,
	Event_type_ACTIONZONE_REGION = 20481,
	Event_type_ACTIONZONE_FULLSCREEN = 20497,
	Event_type_XR_ACTION = 20528,
};

int Event_type_get(PointerRNA *ptr);
void Event_type_set(PointerRNA *ptr, int value);

void Event_unicode_get(PointerRNA *ptr, char *value);
int Event_unicode_length(PointerRNA *ptr);
void Event_unicode_set(PointerRNA *ptr, const char *value);

enum {
	Event_value_ANY = -1,
	Event_value_PRESS = 1,
	Event_value_RELEASE = 2,
	Event_value_CLICK = 3,
	Event_value_DOUBLE_CLICK = 4,
	Event_value_CLICK_DRAG = 5,
	Event_value_NOTHING = 0,
};

int Event_value_get(PointerRNA *ptr);
void Event_value_set(PointerRNA *ptr, int value);

PointerRNA Event_xr_get(PointerRNA *ptr);

/**************** Explode Modifier ****************/

extern StructRNA RNA_ExplodeModifier;
extern StructRNA RNA_Modifier;

bool ExplodeModifier_show_alive_get(PointerRNA *ptr);
void ExplodeModifier_show_alive_set(PointerRNA *ptr, bool value);

bool ExplodeModifier_use_edge_cut_get(PointerRNA *ptr);
void ExplodeModifier_use_edge_cut_set(PointerRNA *ptr, bool value);

bool ExplodeModifier_show_dead_get(PointerRNA *ptr);
void ExplodeModifier_show_dead_set(PointerRNA *ptr, bool value);

bool ExplodeModifier_invert_vertex_group_get(PointerRNA *ptr);
void ExplodeModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define ExplodeModifier_particle_uv_MAX 64

void ExplodeModifier_particle_uv_get(PointerRNA *ptr, char *value);
int ExplodeModifier_particle_uv_length(PointerRNA *ptr);
void ExplodeModifier_particle_uv_set(PointerRNA *ptr, const char *value);

float ExplodeModifier_protect_get(PointerRNA *ptr);
void ExplodeModifier_protect_set(PointerRNA *ptr, float value);

bool ExplodeModifier_use_size_get(PointerRNA *ptr);
void ExplodeModifier_use_size_set(PointerRNA *ptr, bool value);

bool ExplodeModifier_show_unborn_get(PointerRNA *ptr);
void ExplodeModifier_show_unborn_set(PointerRNA *ptr, bool value);

void ExplodeModifier_vertex_group_get(PointerRNA *ptr, char *value);
int ExplodeModifier_vertex_group_length(PointerRNA *ptr);
void ExplodeModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** F-Curve ****************/

extern StructRNA RNA_FCurve;

PointerRNA FCurve_rna_type_get(PointerRNA *ptr);

enum {
	FCurve_auto_smoothing_NONE = 0,
	FCurve_auto_smoothing_CONT_ACCEL = 1,
};

int FCurve_auto_smoothing_get(PointerRNA *ptr);
void FCurve_auto_smoothing_set(PointerRNA *ptr, int value);

void FCurve_color_get(PointerRNA *ptr, float values[3]);
void FCurve_color_set(PointerRNA *ptr, const float values[3]);

enum {
	FCurve_color_mode_AUTO_RAINBOW = 0,
	FCurve_color_mode_AUTO_RGB = 1,
	FCurve_color_mode_AUTO_YRGB = 3,
	FCurve_color_mode_CUSTOM = 2,
};

int FCurve_color_mode_get(PointerRNA *ptr);
void FCurve_color_mode_set(PointerRNA *ptr, int value);

void FCurve_data_path_get(PointerRNA *ptr, char *value);
int FCurve_data_path_length(PointerRNA *ptr);
void FCurve_data_path_set(PointerRNA *ptr, const char *value);

PointerRNA FCurve_driver_get(PointerRNA *ptr);

bool FCurve_is_empty_get(PointerRNA *ptr);
void FCurve_is_empty_set(PointerRNA *ptr, bool value);

enum {
	FCurve_extrapolation_CONSTANT = 0,
	FCurve_extrapolation_LINEAR = 1,
};

int FCurve_extrapolation_get(PointerRNA *ptr);
void FCurve_extrapolation_set(PointerRNA *ptr, int value);

PointerRNA FCurve_group_get(PointerRNA *ptr);

bool FCurve_hide_get(PointerRNA *ptr);
void FCurve_hide_set(PointerRNA *ptr, bool value);

void FCurve_keyframe_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_keyframe_points_next(CollectionPropertyIterator *iter);
void FCurve_keyframe_points_end(CollectionPropertyIterator *iter);
int FCurve_keyframe_points_length(PointerRNA *ptr);
bool FCurve_keyframe_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool FCurve_lock_get(PointerRNA *ptr);
void FCurve_lock_set(PointerRNA *ptr, bool value);

void FCurve_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_modifiers_next(CollectionPropertyIterator *iter);
void FCurve_modifiers_end(CollectionPropertyIterator *iter);
bool FCurve_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FCurve_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool FCurve_mute_get(PointerRNA *ptr);
void FCurve_mute_set(PointerRNA *ptr, bool value);

int FCurve_array_index_get(PointerRNA *ptr);
void FCurve_array_index_set(PointerRNA *ptr, int value);

void FCurve_sampled_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FCurve_sampled_points_next(CollectionPropertyIterator *iter);
void FCurve_sampled_points_end(CollectionPropertyIterator *iter);
int FCurve_sampled_points_length(PointerRNA *ptr);
bool FCurve_sampled_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool FCurve_select_get(PointerRNA *ptr);
void FCurve_select_set(PointerRNA *ptr, bool value);

bool FCurve_is_valid_get(PointerRNA *ptr);
void FCurve_is_valid_set(PointerRNA *ptr, bool value);

float FCurve_evaluate_func(struct FCurve *_self, float frame);
void FCurve_update_func(struct ID *_selfid, struct FCurve *_self, Main *bmain);
void FCurve_range_func(struct FCurve *_self, float range[2]);
void FCurve_update_autoflags_func(struct FCurve *_self, bContext *C, ReportList *reports, struct PointerRNA *data);
void FCurve_convert_to_samples_func(struct FCurve *_self, ReportList *reports, int start, int end);
void FCurve_convert_to_keyframes_func(struct FCurve *_self, ReportList *reports, int start, int end);
void FCurve_bake_func(struct FCurve *_self, ReportList *reports, int start, int end, float step, int remove);
/**************** Keyframe Points ****************/

extern StructRNA RNA_FCurveKeyframePoints;

PointerRNA FCurveKeyframePoints_rna_type_get(PointerRNA *ptr);

struct BezTriple *FCurveKeyframePoints_insert_func(struct ID *_selfid, struct FCurve *_self, Main *bmain, float frame, float value, int options, int keyframe_type);
void FCurveKeyframePoints_add_func(struct ID *_selfid, struct FCurve *_self, Main *bmain, int count);
void FCurveKeyframePoints_remove_func(struct ID *_selfid, struct FCurve *_self, Main *bmain, ReportList *reports, struct PointerRNA *keyframe, bool fast);
void FCurveKeyframePoints_clear_func(struct ID *_selfid, struct FCurve *_self, Main *bmain);
void FCurveKeyframePoints_sort_func(struct ID *_selfid, struct FCurve *_self, Main *bmain);
void FCurveKeyframePoints_deduplicate_func(struct ID *_selfid, struct FCurve *_self, Main *bmain);
void FCurveKeyframePoints_handles_recalc_func(struct ID *_selfid, struct FCurve *_self, Main *bmain);
/**************** F-Curve Modifiers ****************/

extern StructRNA RNA_FCurveModifiers;

PointerRNA FCurveModifiers_rna_type_get(PointerRNA *ptr);

PointerRNA FCurveModifiers_active_get(PointerRNA *ptr);

struct FModifier *FCurveModifiers_new_func(struct FCurve *_self, int type);
void FCurveModifiers_remove_func(struct FCurve *_self, ReportList *reports, struct PointerRNA *modifier);
/**************** F-Curve Sample ****************/

extern StructRNA RNA_FCurveSample;

PointerRNA FCurveSample_rna_type_get(PointerRNA *ptr);

void FCurveSample_co_get(PointerRNA *ptr, float values[2]);
void FCurveSample_co_set(PointerRNA *ptr, const float values[2]);

bool FCurveSample_select_get(PointerRNA *ptr);
void FCurveSample_select_set(PointerRNA *ptr, bool value);

/**************** FFmpeg Settings ****************/

extern StructRNA RNA_FFmpegSettings;

PointerRNA FFmpegSettings_rna_type_get(PointerRNA *ptr);

enum {
	FFmpegSettings_audio_channels_MONO = 1,
	FFmpegSettings_audio_channels_STEREO = 2,
	FFmpegSettings_audio_channels_SURROUND4 = 4,
	FFmpegSettings_audio_channels_SURROUND51 = 6,
	FFmpegSettings_audio_channels_SURROUND71 = 8,
};

int FFmpegSettings_audio_channels_get(PointerRNA *ptr);
void FFmpegSettings_audio_channels_set(PointerRNA *ptr, int value);

enum {
	FFmpegSettings_audio_codec_NONE = 0,
	FFmpegSettings_audio_codec_AAC = 86018,
	FFmpegSettings_audio_codec_AC3 = 86019,
	FFmpegSettings_audio_codec_FLAC = 86028,
	FFmpegSettings_audio_codec_MP2 = 86016,
	FFmpegSettings_audio_codec_MP3 = 86017,
	FFmpegSettings_audio_codec_OPUS = 86076,
	FFmpegSettings_audio_codec_PCM = 65536,
	FFmpegSettings_audio_codec_VORBIS = 86021,
};

int FFmpegSettings_audio_codec_get(PointerRNA *ptr);
void FFmpegSettings_audio_codec_set(PointerRNA *ptr, int value);

bool FFmpegSettings_use_autosplit_get(PointerRNA *ptr);
void FFmpegSettings_use_autosplit_set(PointerRNA *ptr, bool value);

int FFmpegSettings_video_bitrate_get(PointerRNA *ptr);
void FFmpegSettings_video_bitrate_set(PointerRNA *ptr, int value);

int FFmpegSettings_audio_bitrate_get(PointerRNA *ptr);
void FFmpegSettings_audio_bitrate_set(PointerRNA *ptr, int value);

int FFmpegSettings_buffersize_get(PointerRNA *ptr);
void FFmpegSettings_buffersize_set(PointerRNA *ptr, int value);

enum {
	FFmpegSettings_format_MPEG4 = 2,
	FFmpegSettings_format_MKV = 9,
	FFmpegSettings_format_WEBM = 12,
	FFmpegSettings_format_AVI = 3,
	FFmpegSettings_format_DV = 5,
	FFmpegSettings_format_FLASH = 8,
	FFmpegSettings_format_MPEG1 = 0,
	FFmpegSettings_format_MPEG2 = 1,
	FFmpegSettings_format_OGG = 10,
	FFmpegSettings_format_QUICKTIME = 4,
};

int FFmpegSettings_format_get(PointerRNA *ptr);
void FFmpegSettings_format_set(PointerRNA *ptr, int value);

enum {
	FFmpegSettings_ffmpeg_preset_BEST = 11,
	FFmpegSettings_ffmpeg_preset_GOOD = 10,
	FFmpegSettings_ffmpeg_preset_REALTIME = 12,
};

int FFmpegSettings_ffmpeg_preset_get(PointerRNA *ptr);
void FFmpegSettings_ffmpeg_preset_set(PointerRNA *ptr, int value);

int FFmpegSettings_gopsize_get(PointerRNA *ptr);
void FFmpegSettings_gopsize_set(PointerRNA *ptr, int value);

bool FFmpegSettings_use_lossless_output_get(PointerRNA *ptr);
void FFmpegSettings_use_lossless_output_set(PointerRNA *ptr, bool value);

int FFmpegSettings_max_b_frames_get(PointerRNA *ptr);
void FFmpegSettings_max_b_frames_set(PointerRNA *ptr, int value);

int FFmpegSettings_maxrate_get(PointerRNA *ptr);
void FFmpegSettings_maxrate_set(PointerRNA *ptr, int value);

int FFmpegSettings_minrate_get(PointerRNA *ptr);
void FFmpegSettings_minrate_set(PointerRNA *ptr, int value);

int FFmpegSettings_packetsize_get(PointerRNA *ptr);
void FFmpegSettings_packetsize_set(PointerRNA *ptr, int value);

int FFmpegSettings_muxrate_get(PointerRNA *ptr);
void FFmpegSettings_muxrate_set(PointerRNA *ptr, int value);

enum {
	FFmpegSettings_constant_rate_factor_NONE = -1,
	FFmpegSettings_constant_rate_factor_LOSSLESS = 0,
	FFmpegSettings_constant_rate_factor_PERC_LOSSLESS = 17,
	FFmpegSettings_constant_rate_factor_HIGH = 20,
	FFmpegSettings_constant_rate_factor_MEDIUM = 23,
	FFmpegSettings_constant_rate_factor_LOW = 26,
	FFmpegSettings_constant_rate_factor_VERYLOW = 29,
	FFmpegSettings_constant_rate_factor_LOWEST = 32,
};

int FFmpegSettings_constant_rate_factor_get(PointerRNA *ptr);
void FFmpegSettings_constant_rate_factor_set(PointerRNA *ptr, int value);

enum {
	FFmpegSettings_ffmpeg_prores_profile_422_PROXY = 0,
	FFmpegSettings_ffmpeg_prores_profile_422_LT = 1,
	FFmpegSettings_ffmpeg_prores_profile_422_STD = 2,
	FFmpegSettings_ffmpeg_prores_profile_422_HQ = 3,
	FFmpegSettings_ffmpeg_prores_profile_4444 = 4,
	FFmpegSettings_ffmpeg_prores_profile_4444_XQ = 5,
};

int FFmpegSettings_ffmpeg_prores_profile_get(PointerRNA *ptr);
void FFmpegSettings_ffmpeg_prores_profile_set(PointerRNA *ptr, int value);

int FFmpegSettings_audio_mixrate_get(PointerRNA *ptr);
void FFmpegSettings_audio_mixrate_set(PointerRNA *ptr, int value);

bool FFmpegSettings_use_max_b_frames_get(PointerRNA *ptr);
void FFmpegSettings_use_max_b_frames_set(PointerRNA *ptr, bool value);

enum {
	FFmpegSettings_codec_NONE = 0,
	FFmpegSettings_codec_AV1 = 226,
	FFmpegSettings_codec_H264 = 27,
	FFmpegSettings_codec_H265 = 173,
	FFmpegSettings_codec_WEBM = 167,
	FFmpegSettings_codec_DNXHD = 99,
	FFmpegSettings_codec_DV = 24,
	FFmpegSettings_codec_FFV1 = 33,
	FFmpegSettings_codec_FLASH = 21,
	FFmpegSettings_codec_HUFFYUV = 25,
	FFmpegSettings_codec_MPEG1 = 1,
	FFmpegSettings_codec_MPEG2 = 2,
	FFmpegSettings_codec_MPEG4 = 12,
	FFmpegSettings_codec_PNG = 61,
	FFmpegSettings_codec_PRORES = 147,
	FFmpegSettings_codec_QTRLE = 55,
	FFmpegSettings_codec_THEORA = 30,
};

int FFmpegSettings_codec_get(PointerRNA *ptr);
void FFmpegSettings_codec_set(PointerRNA *ptr, int value);

float FFmpegSettings_audio_volume_get(PointerRNA *ptr);
void FFmpegSettings_audio_volume_set(PointerRNA *ptr, float value);

/**************** F-Modifier ****************/

extern StructRNA RNA_FModifier;

PointerRNA FModifier_rna_type_get(PointerRNA *ptr);

#define FModifier_name_MAX 64

void FModifier_name_get(PointerRNA *ptr, char *value);
int FModifier_name_length(PointerRNA *ptr);
void FModifier_name_set(PointerRNA *ptr, const char *value);

bool FModifier_active_get(PointerRNA *ptr);
void FModifier_active_set(PointerRNA *ptr, bool value);

float FModifier_blend_in_get(PointerRNA *ptr);
void FModifier_blend_in_set(PointerRNA *ptr, float value);

float FModifier_blend_out_get(PointerRNA *ptr);
void FModifier_blend_out_set(PointerRNA *ptr, float value);

bool FModifier_is_valid_get(PointerRNA *ptr);
void FModifier_is_valid_set(PointerRNA *ptr, bool value);

bool FModifier_mute_get(PointerRNA *ptr);
void FModifier_mute_set(PointerRNA *ptr, bool value);

float FModifier_frame_end_get(PointerRNA *ptr);
void FModifier_frame_end_set(PointerRNA *ptr, float value);

bool FModifier_show_expanded_get(PointerRNA *ptr);
void FModifier_show_expanded_set(PointerRNA *ptr, bool value);

float FModifier_influence_get(PointerRNA *ptr);
void FModifier_influence_set(PointerRNA *ptr, float value);

bool FModifier_use_restricted_range_get(PointerRNA *ptr);
void FModifier_use_restricted_range_set(PointerRNA *ptr, bool value);

float FModifier_frame_start_get(PointerRNA *ptr);
void FModifier_frame_start_set(PointerRNA *ptr, float value);

enum {
	FModifier_type_NULL = 0,
	FModifier_type_GENERATOR = 1,
	FModifier_type_FNGENERATOR = 2,
	FModifier_type_ENVELOPE = 3,
	FModifier_type_CYCLES = 4,
	FModifier_type_NOISE = 5,
	FModifier_type_LIMITS = 8,
	FModifier_type_STEPPED = 9,
};

int FModifier_type_get(PointerRNA *ptr);
void FModifier_type_set(PointerRNA *ptr, int value);

bool FModifier_use_influence_get(PointerRNA *ptr);
void FModifier_use_influence_set(PointerRNA *ptr, bool value);

/**************** Cycles F-Modifier ****************/

extern StructRNA RNA_FModifierCycles;
extern StructRNA RNA_FModifier;

int FModifierCycles_cycles_after_get(PointerRNA *ptr);
void FModifierCycles_cycles_after_set(PointerRNA *ptr, int value);

enum {
	FModifierCycles_mode_after_NONE = 0,
	FModifierCycles_mode_after_REPEAT = 1,
	FModifierCycles_mode_after_REPEAT_OFFSET = 2,
	FModifierCycles_mode_after_MIRROR = 3,
};

int FModifierCycles_mode_after_get(PointerRNA *ptr);
void FModifierCycles_mode_after_set(PointerRNA *ptr, int value);

int FModifierCycles_cycles_before_get(PointerRNA *ptr);
void FModifierCycles_cycles_before_set(PointerRNA *ptr, int value);

enum {
	FModifierCycles_mode_before_NONE = 0,
	FModifierCycles_mode_before_REPEAT = 1,
	FModifierCycles_mode_before_REPEAT_OFFSET = 2,
	FModifierCycles_mode_before_MIRROR = 3,
};

int FModifierCycles_mode_before_get(PointerRNA *ptr);
void FModifierCycles_mode_before_set(PointerRNA *ptr, int value);

/**************** Envelope F-Modifier ****************/

extern StructRNA RNA_FModifierEnvelope;
extern StructRNA RNA_FModifier;

void FModifierEnvelope_control_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FModifierEnvelope_control_points_next(CollectionPropertyIterator *iter);
void FModifierEnvelope_control_points_end(CollectionPropertyIterator *iter);
int FModifierEnvelope_control_points_length(PointerRNA *ptr);
bool FModifierEnvelope_control_points_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

float FModifierEnvelope_default_max_get(PointerRNA *ptr);
void FModifierEnvelope_default_max_set(PointerRNA *ptr, float value);

float FModifierEnvelope_default_min_get(PointerRNA *ptr);
void FModifierEnvelope_default_min_set(PointerRNA *ptr, float value);

float FModifierEnvelope_reference_value_get(PointerRNA *ptr);
void FModifierEnvelope_reference_value_set(PointerRNA *ptr, float value);

/**************** Envelope Control Point ****************/

extern StructRNA RNA_FModifierEnvelopeControlPoint;

PointerRNA FModifierEnvelopeControlPoint_rna_type_get(PointerRNA *ptr);

float FModifierEnvelopeControlPoint_frame_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_frame_set(PointerRNA *ptr, float value);

float FModifierEnvelopeControlPoint_max_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_max_set(PointerRNA *ptr, float value);

float FModifierEnvelopeControlPoint_min_get(PointerRNA *ptr);
void FModifierEnvelopeControlPoint_min_set(PointerRNA *ptr, float value);

/**************** Control Points ****************/

extern StructRNA RNA_FModifierEnvelopeControlPoints;

PointerRNA FModifierEnvelopeControlPoints_rna_type_get(PointerRNA *ptr);

struct FCM_EnvelopeData *FModifierEnvelopeControlPoints_add_func(struct ID *_selfid, struct FModifier *_self, Main *bmain, ReportList *reports, float frame);
void FModifierEnvelopeControlPoints_remove_func(struct ID *_selfid, struct FModifier *_self, Main *bmain, ReportList *reports, struct PointerRNA *point);
/**************** Built-In Function F-Modifier ****************/

extern StructRNA RNA_FModifierFunctionGenerator;
extern StructRNA RNA_FModifier;

bool FModifierFunctionGenerator_use_additive_get(PointerRNA *ptr);
void FModifierFunctionGenerator_use_additive_set(PointerRNA *ptr, bool value);

float FModifierFunctionGenerator_amplitude_get(PointerRNA *ptr);
void FModifierFunctionGenerator_amplitude_set(PointerRNA *ptr, float value);

float FModifierFunctionGenerator_phase_multiplier_get(PointerRNA *ptr);
void FModifierFunctionGenerator_phase_multiplier_set(PointerRNA *ptr, float value);

float FModifierFunctionGenerator_phase_offset_get(PointerRNA *ptr);
void FModifierFunctionGenerator_phase_offset_set(PointerRNA *ptr, float value);

enum {
	FModifierFunctionGenerator_function_type_SIN = 0,
	FModifierFunctionGenerator_function_type_COS = 1,
	FModifierFunctionGenerator_function_type_TAN = 2,
	FModifierFunctionGenerator_function_type_SQRT = 3,
	FModifierFunctionGenerator_function_type_LN = 4,
	FModifierFunctionGenerator_function_type_SINC = 5,
};

int FModifierFunctionGenerator_function_type_get(PointerRNA *ptr);
void FModifierFunctionGenerator_function_type_set(PointerRNA *ptr, int value);

float FModifierFunctionGenerator_value_offset_get(PointerRNA *ptr);
void FModifierFunctionGenerator_value_offset_set(PointerRNA *ptr, float value);

/**************** Generator F-Modifier ****************/

extern StructRNA RNA_FModifierGenerator;
extern StructRNA RNA_FModifier;

bool FModifierGenerator_use_additive_get(PointerRNA *ptr);
void FModifierGenerator_use_additive_set(PointerRNA *ptr, bool value);

void FModifierGenerator_coefficients_get(PointerRNA *ptr, float values[]);
void FModifierGenerator_coefficients_set(PointerRNA *ptr, const float values[]);int FModifierGenerator_coefficients_get_length(PointerRNA *ptr, int *arraylen);

enum {
	FModifierGenerator_mode_POLYNOMIAL = 0,
	FModifierGenerator_mode_POLYNOMIAL_FACTORISED = 1,
};

int FModifierGenerator_mode_get(PointerRNA *ptr);
void FModifierGenerator_mode_set(PointerRNA *ptr, int value);

int FModifierGenerator_poly_order_get(PointerRNA *ptr);
void FModifierGenerator_poly_order_set(PointerRNA *ptr, int value);

/**************** Limit F-Modifier ****************/

extern StructRNA RNA_FModifierLimits;
extern StructRNA RNA_FModifier;

bool FModifierLimits_use_max_x_get(PointerRNA *ptr);
void FModifierLimits_use_max_x_set(PointerRNA *ptr, bool value);

float FModifierLimits_max_x_get(PointerRNA *ptr);
void FModifierLimits_max_x_set(PointerRNA *ptr, float value);

bool FModifierLimits_use_max_y_get(PointerRNA *ptr);
void FModifierLimits_use_max_y_set(PointerRNA *ptr, bool value);

float FModifierLimits_max_y_get(PointerRNA *ptr);
void FModifierLimits_max_y_set(PointerRNA *ptr, float value);

bool FModifierLimits_use_min_x_get(PointerRNA *ptr);
void FModifierLimits_use_min_x_set(PointerRNA *ptr, bool value);

float FModifierLimits_min_x_get(PointerRNA *ptr);
void FModifierLimits_min_x_set(PointerRNA *ptr, float value);

bool FModifierLimits_use_min_y_get(PointerRNA *ptr);
void FModifierLimits_use_min_y_set(PointerRNA *ptr, bool value);

float FModifierLimits_min_y_get(PointerRNA *ptr);
void FModifierLimits_min_y_set(PointerRNA *ptr, float value);

/**************** Noise F-Modifier ****************/

extern StructRNA RNA_FModifierNoise;
extern StructRNA RNA_FModifier;

enum {
	FModifierNoise_blend_type_REPLACE = 0,
	FModifierNoise_blend_type_ADD = 1,
	FModifierNoise_blend_type_SUBTRACT = 2,
	FModifierNoise_blend_type_MULTIPLY = 3,
};

int FModifierNoise_blend_type_get(PointerRNA *ptr);
void FModifierNoise_blend_type_set(PointerRNA *ptr, int value);

int FModifierNoise_depth_get(PointerRNA *ptr);
void FModifierNoise_depth_set(PointerRNA *ptr, int value);

float FModifierNoise_lacunarity_get(PointerRNA *ptr);
void FModifierNoise_lacunarity_set(PointerRNA *ptr, float value);

bool FModifierNoise_use_legacy_noise_get(PointerRNA *ptr);
void FModifierNoise_use_legacy_noise_set(PointerRNA *ptr, bool value);

float FModifierNoise_offset_get(PointerRNA *ptr);
void FModifierNoise_offset_set(PointerRNA *ptr, float value);

float FModifierNoise_phase_get(PointerRNA *ptr);
void FModifierNoise_phase_set(PointerRNA *ptr, float value);

float FModifierNoise_roughness_get(PointerRNA *ptr);
void FModifierNoise_roughness_set(PointerRNA *ptr, float value);

float FModifierNoise_scale_get(PointerRNA *ptr);
void FModifierNoise_scale_set(PointerRNA *ptr, float value);

float FModifierNoise_strength_get(PointerRNA *ptr);
void FModifierNoise_strength_set(PointerRNA *ptr, float value);

/**************** Stepped Interpolation F-Modifier ****************/

extern StructRNA RNA_FModifierStepped;
extern StructRNA RNA_FModifier;

float FModifierStepped_frame_end_get(PointerRNA *ptr);
void FModifierStepped_frame_end_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_offset_get(PointerRNA *ptr);
void FModifierStepped_frame_offset_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_start_get(PointerRNA *ptr);
void FModifierStepped_frame_start_set(PointerRNA *ptr, float value);

float FModifierStepped_frame_step_get(PointerRNA *ptr);
void FModifierStepped_frame_step_set(PointerRNA *ptr, float value);

bool FModifierStepped_use_frame_end_get(PointerRNA *ptr);
void FModifierStepped_use_frame_end_set(PointerRNA *ptr, bool value);

bool FModifierStepped_use_frame_start_get(PointerRNA *ptr);
void FModifierStepped_use_frame_start_set(PointerRNA *ptr, bool value);

/**************** Field Settings ****************/

extern StructRNA RNA_FieldSettings;

PointerRNA FieldSettings_rna_type_get(PointerRNA *ptr);

bool FieldSettings_use_2d_force_get(PointerRNA *ptr);
void FieldSettings_use_2d_force_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_absorption_get(PointerRNA *ptr);
void FieldSettings_use_absorption_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_guide_path_add_get(PointerRNA *ptr);
void FieldSettings_use_guide_path_add_set(PointerRNA *ptr, bool value);

float FieldSettings_guide_clump_amount_get(PointerRNA *ptr);
void FieldSettings_guide_clump_amount_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_amplitude_get(PointerRNA *ptr);
void FieldSettings_guide_kink_amplitude_set(PointerRNA *ptr, float value);

bool FieldSettings_use_smoke_density_get(PointerRNA *ptr);
void FieldSettings_use_smoke_density_set(PointerRNA *ptr, bool value);

enum {
	FieldSettings_guide_kink_axis_X = 0,
	FieldSettings_guide_kink_axis_Y = 1,
	FieldSettings_guide_kink_axis_Z = 2,
};

int FieldSettings_guide_kink_axis_get(PointerRNA *ptr);
void FieldSettings_guide_kink_axis_set(PointerRNA *ptr, int value);

PointerRNA FieldSettings_source_object_get(PointerRNA *ptr);

enum {
	FieldSettings_falloff_type_CONE = 2,
	FieldSettings_falloff_type_SPHERE = 0,
	FieldSettings_falloff_type_TUBE = 1,
};

int FieldSettings_falloff_type_get(PointerRNA *ptr);
void FieldSettings_falloff_type_set(PointerRNA *ptr, int value);

float FieldSettings_falloff_power_get(PointerRNA *ptr);
void FieldSettings_falloff_power_set(PointerRNA *ptr, float value);

float FieldSettings_flow_get(PointerRNA *ptr);
void FieldSettings_flow_set(PointerRNA *ptr, float value);

float FieldSettings_guide_free_get(PointerRNA *ptr);
void FieldSettings_guide_free_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_frequency_get(PointerRNA *ptr);
void FieldSettings_guide_kink_frequency_set(PointerRNA *ptr, float value);

bool FieldSettings_use_gravity_falloff_get(PointerRNA *ptr);
void FieldSettings_use_gravity_falloff_set(PointerRNA *ptr, bool value);

float FieldSettings_harmonic_damping_get(PointerRNA *ptr);
void FieldSettings_harmonic_damping_set(PointerRNA *ptr, float value);

float FieldSettings_inflow_get(PointerRNA *ptr);
void FieldSettings_inflow_set(PointerRNA *ptr, float value);

enum {
	FieldSettings_guide_kink_type_NONE = 0,
	FieldSettings_guide_kink_type_BRAID = 4,
	FieldSettings_guide_kink_type_CURL = 1,
	FieldSettings_guide_kink_type_RADIAL = 2,
	FieldSettings_guide_kink_type_ROLL = 6,
	FieldSettings_guide_kink_type_ROTATION = 5,
	FieldSettings_guide_kink_type_WAVE = 3,
};

int FieldSettings_guide_kink_type_get(PointerRNA *ptr);
void FieldSettings_guide_kink_type_set(PointerRNA *ptr, int value);

float FieldSettings_linear_drag_get(PointerRNA *ptr);
void FieldSettings_linear_drag_set(PointerRNA *ptr, float value);

bool FieldSettings_apply_to_location_get(PointerRNA *ptr);
void FieldSettings_apply_to_location_set(PointerRNA *ptr, bool value);

float FieldSettings_distance_max_get(PointerRNA *ptr);
void FieldSettings_distance_max_set(PointerRNA *ptr, float value);

float FieldSettings_radial_max_get(PointerRNA *ptr);
void FieldSettings_radial_max_set(PointerRNA *ptr, float value);

float FieldSettings_distance_min_get(PointerRNA *ptr);
void FieldSettings_distance_min_set(PointerRNA *ptr, float value);

float FieldSettings_guide_minimum_get(PointerRNA *ptr);
void FieldSettings_guide_minimum_set(PointerRNA *ptr, float value);

float FieldSettings_radial_min_get(PointerRNA *ptr);
void FieldSettings_radial_min_set(PointerRNA *ptr, float value);

bool FieldSettings_use_multiple_springs_get(PointerRNA *ptr);
void FieldSettings_use_multiple_springs_set(PointerRNA *ptr, bool value);

float FieldSettings_texture_nabla_get(PointerRNA *ptr);
void FieldSettings_texture_nabla_set(PointerRNA *ptr, float value);

float FieldSettings_noise_get(PointerRNA *ptr);
void FieldSettings_noise_set(PointerRNA *ptr, float value);

float FieldSettings_quadratic_drag_get(PointerRNA *ptr);
void FieldSettings_quadratic_drag_set(PointerRNA *ptr, float value);

float FieldSettings_radial_falloff_get(PointerRNA *ptr);
void FieldSettings_radial_falloff_set(PointerRNA *ptr, float value);

float FieldSettings_rest_length_get(PointerRNA *ptr);
void FieldSettings_rest_length_set(PointerRNA *ptr, float value);

bool FieldSettings_use_root_coords_get(PointerRNA *ptr);
void FieldSettings_use_root_coords_set(PointerRNA *ptr, bool value);

bool FieldSettings_apply_to_rotation_get(PointerRNA *ptr);
void FieldSettings_apply_to_rotation_set(PointerRNA *ptr, bool value);

int FieldSettings_seed_get(PointerRNA *ptr);
void FieldSettings_seed_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_shape_POINT = 0,
	FieldSettings_shape_LINE = 4,
	FieldSettings_shape_PLANE = 1,
	FieldSettings_shape_SURFACE = 2,
	FieldSettings_shape_POINTS = 3,
};

int FieldSettings_shape_get(PointerRNA *ptr);
void FieldSettings_shape_set(PointerRNA *ptr, int value);

float FieldSettings_guide_clump_shape_get(PointerRNA *ptr);
void FieldSettings_guide_clump_shape_set(PointerRNA *ptr, float value);

float FieldSettings_guide_kink_shape_get(PointerRNA *ptr);
void FieldSettings_guide_kink_shape_set(PointerRNA *ptr, float value);

float FieldSettings_size_get(PointerRNA *ptr);
void FieldSettings_size_set(PointerRNA *ptr, float value);

float FieldSettings_strength_get(PointerRNA *ptr);
void FieldSettings_strength_set(PointerRNA *ptr, float value);

PointerRNA FieldSettings_texture_get(PointerRNA *ptr);

enum {
	FieldSettings_texture_mode_CURL = 2,
	FieldSettings_texture_mode_GRADIENT = 1,
	FieldSettings_texture_mode_RGB = 0,
};

int FieldSettings_texture_mode_get(PointerRNA *ptr);
void FieldSettings_texture_mode_set(PointerRNA *ptr, int value);

enum {
	FieldSettings_type_NONE = 0,
	FieldSettings_type_BOID = 10,
	FieldSettings_type_CHARGE = 8,
	FieldSettings_type_GUIDE = 5,
	FieldSettings_type_DRAG = 12,
	FieldSettings_type_FLUID_FLOW = 13,
	FieldSettings_type_FORCE = 1,
	FieldSettings_type_HARMONIC = 7,
	FieldSettings_type_LENNARDJ = 9,
	FieldSettings_type_MAGNET = 3,
	FieldSettings_type_TEXTURE = 6,
	FieldSettings_type_TURBULENCE = 11,
	FieldSettings_type_VORTEX = 2,
	FieldSettings_type_WIND = 4,
};

int FieldSettings_type_get(PointerRNA *ptr);
void FieldSettings_type_set(PointerRNA *ptr, int value);

bool FieldSettings_use_object_coords_get(PointerRNA *ptr);
void FieldSettings_use_object_coords_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_global_coords_get(PointerRNA *ptr);
void FieldSettings_use_global_coords_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_max_distance_get(PointerRNA *ptr);
void FieldSettings_use_max_distance_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_radial_max_get(PointerRNA *ptr);
void FieldSettings_use_radial_max_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_min_distance_get(PointerRNA *ptr);
void FieldSettings_use_min_distance_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_radial_min_get(PointerRNA *ptr);
void FieldSettings_use_radial_min_set(PointerRNA *ptr, bool value);

bool FieldSettings_use_guide_path_weight_get(PointerRNA *ptr);
void FieldSettings_use_guide_path_weight_set(PointerRNA *ptr, bool value);

float FieldSettings_wind_factor_get(PointerRNA *ptr);
void FieldSettings_wind_factor_set(PointerRNA *ptr, float value);

enum {
	FieldSettings_z_direction_POSITIVE = 1,
	FieldSettings_z_direction_NEGATIVE = 2,
	FieldSettings_z_direction_BOTH = 0,
};

int FieldSettings_z_direction_get(PointerRNA *ptr);
void FieldSettings_z_direction_set(PointerRNA *ptr, int value);

/**************** File Select Asset Filter ****************/

extern StructRNA RNA_FileAssetSelectIDFilter;

PointerRNA FileAssetSelectIDFilter_rna_type_get(PointerRNA *ptr);

bool FileAssetSelectIDFilter_filter_action_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_action_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_annotations_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_annotations_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_armature_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_armature_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_brush_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_brush_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_cachefile_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_cachefile_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_camera_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_camera_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_group_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_group_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_curve_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_curve_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_font_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_font_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_linestyle_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_linestyle_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_grease_pencil_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_grease_pencil_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_curves_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_curves_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_image_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_image_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_lattice_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_lattice_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_light_probe_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_light_probe_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_light_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_light_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_mask_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_mask_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_material_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_material_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_mesh_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_mesh_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_metaball_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_metaball_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_movie_clip_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_movie_clip_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_node_tree_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_node_tree_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_object_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_object_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_paint_curve_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_paint_curve_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_palette_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_palette_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_particle_settings_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_particle_settings_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_pointcloud_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_pointcloud_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_scene_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_scene_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_sound_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_sound_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_speaker_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_speaker_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_text_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_text_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_texture_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_texture_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_volume_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_volume_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_experimental_filter_work_space_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_experimental_filter_work_space_set(PointerRNA *ptr, bool value);

bool FileAssetSelectIDFilter_filter_world_get(PointerRNA *ptr);
void FileAssetSelectIDFilter_filter_world_set(PointerRNA *ptr, bool value);

/**************** Asset Select Parameters ****************/

extern StructRNA RNA_FileAssetSelectParams;
extern StructRNA RNA_FileSelectParams;

enum {
	FileAssetSelectParams_asset_library_reference_ALL = 2,
	FileAssetSelectParams_asset_library_reference_LOCAL = 1,
	FileAssetSelectParams_asset_library_reference_ESSENTIALS = 3,
	FileAssetSelectParams_asset_library_reference_CUSTOM = 100,
};

int FileAssetSelectParams_asset_library_reference_get(PointerRNA *ptr);
void FileAssetSelectParams_asset_library_reference_set(PointerRNA *ptr, int value);

void FileAssetSelectParams_catalog_id_get(PointerRNA *ptr, char *value);
int FileAssetSelectParams_catalog_id_length(PointerRNA *ptr);
void FileAssetSelectParams_catalog_id_set(PointerRNA *ptr, const char *value);

PointerRNA FileAssetSelectParams_filter_asset_id_get(PointerRNA *ptr);

enum {
	FileAssetSelectParams_import_method_FOLLOW_PREFS = 3,
	FileAssetSelectParams_import_method_LINK = 0,
	FileAssetSelectParams_import_method_APPEND = 1,
	FileAssetSelectParams_import_method_APPEND_REUSE = 2,
	FileAssetSelectParams_import_method_PACK = 4,
};

int FileAssetSelectParams_import_method_get(PointerRNA *ptr);
void FileAssetSelectParams_import_method_set(PointerRNA *ptr, int value);

bool FileAssetSelectParams_instance_collections_on_append_get(PointerRNA *ptr);
void FileAssetSelectParams_instance_collections_on_append_set(PointerRNA *ptr, bool value);

bool FileAssetSelectParams_instance_collections_on_link_get(PointerRNA *ptr);
void FileAssetSelectParams_instance_collections_on_link_set(PointerRNA *ptr, bool value);

/**************** File Select Parameters ****************/

extern StructRNA RNA_FileBrowserFSMenuEntry;

PointerRNA FileBrowserFSMenuEntry_rna_type_get(PointerRNA *ptr);

void FileBrowserFSMenuEntry_name_get(PointerRNA *ptr, char *value);
int FileBrowserFSMenuEntry_name_length(PointerRNA *ptr);
void FileBrowserFSMenuEntry_name_set(PointerRNA *ptr, const char *value);

int FileBrowserFSMenuEntry_icon_get(PointerRNA *ptr);
void FileBrowserFSMenuEntry_icon_set(PointerRNA *ptr, int value);

void FileBrowserFSMenuEntry_path_get(PointerRNA *ptr, char *value);
int FileBrowserFSMenuEntry_path_length(PointerRNA *ptr);
void FileBrowserFSMenuEntry_path_set(PointerRNA *ptr, const char *value);

bool FileBrowserFSMenuEntry_use_save_get(PointerRNA *ptr);
void FileBrowserFSMenuEntry_use_save_set(PointerRNA *ptr, bool value);

/**************** File Handler Type ****************/

extern StructRNA RNA_FileHandler;

PointerRNA FileHandler_rna_type_get(PointerRNA *ptr);

void FileHandler_bl_file_extensions_get(PointerRNA *ptr, char *value);
int FileHandler_bl_file_extensions_length(PointerRNA *ptr);
void FileHandler_bl_file_extensions_set(PointerRNA *ptr, const char *value);

void FileHandler_bl_idname_get(PointerRNA *ptr, char *value);
int FileHandler_bl_idname_length(PointerRNA *ptr);
void FileHandler_bl_idname_set(PointerRNA *ptr, const char *value);

void FileHandler_bl_label_get(PointerRNA *ptr, char *value);
int FileHandler_bl_label_length(PointerRNA *ptr);
void FileHandler_bl_label_set(PointerRNA *ptr, const char *value);

void FileHandler_bl_import_operator_get(PointerRNA *ptr, char *value);
int FileHandler_bl_import_operator_length(PointerRNA *ptr);
void FileHandler_bl_import_operator_set(PointerRNA *ptr, const char *value);

void FileHandler_bl_export_operator_get(PointerRNA *ptr, char *value);
int FileHandler_bl_export_operator_length(PointerRNA *ptr);
void FileHandler_bl_export_operator_set(PointerRNA *ptr, const char *value);

bool FileHandler_poll_drop_func(struct bContext *context);
/**************** File Select Entry ****************/

extern StructRNA RNA_FileSelectEntry;

PointerRNA FileSelectEntry_rna_type_get(PointerRNA *ptr);

void FileSelectEntry_name_get(PointerRNA *ptr, char *value);
int FileSelectEntry_name_length(PointerRNA *ptr);
void FileSelectEntry_name_set(PointerRNA *ptr, const char *value);

PointerRNA FileSelectEntry_asset_data_get(PointerRNA *ptr);

int FileSelectEntry_preview_icon_id_get(PointerRNA *ptr);
void FileSelectEntry_preview_icon_id_set(PointerRNA *ptr, int value);

void FileSelectEntry_relative_path_get(PointerRNA *ptr, char *value);
int FileSelectEntry_relative_path_length(PointerRNA *ptr);
void FileSelectEntry_relative_path_set(PointerRNA *ptr, const char *value);

/**************** File Select ID Filter ****************/

extern StructRNA RNA_FileSelectIDFilter;

PointerRNA FileSelectIDFilter_rna_type_get(PointerRNA *ptr);

bool FileSelectIDFilter_filter_action_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_action_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_animation_get(PointerRNA *ptr);
void FileSelectIDFilter_category_animation_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_annotations_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_annotations_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_armature_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_armature_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_brush_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_brush_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_cachefile_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_cachefile_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_camera_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_camera_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_group_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_group_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_curve_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_curve_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_environment_get(PointerRNA *ptr);
void FileSelectIDFilter_category_environment_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_font_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_font_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_linestyle_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_linestyle_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_geometry_get(PointerRNA *ptr);
void FileSelectIDFilter_category_geometry_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_grease_pencil_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_grease_pencil_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_curves_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_curves_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_image_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_image_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_image_get(PointerRNA *ptr);
void FileSelectIDFilter_category_image_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_lattice_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_lattice_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_light_probe_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_light_probe_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_light_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_light_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_mask_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_mask_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_material_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_material_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_mesh_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_mesh_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_metaball_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_metaball_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_misc_get(PointerRNA *ptr);
void FileSelectIDFilter_category_misc_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_movie_clip_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_movie_clip_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_node_tree_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_node_tree_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_object_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_object_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_object_get(PointerRNA *ptr);
void FileSelectIDFilter_category_object_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_paint_curve_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_paint_curve_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_palette_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_palette_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_particle_settings_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_particle_settings_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_pointcloud_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_pointcloud_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_scene_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_scene_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_scene_get(PointerRNA *ptr);
void FileSelectIDFilter_category_scene_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_category_shading_get(PointerRNA *ptr);
void FileSelectIDFilter_category_shading_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_sound_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_sound_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_speaker_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_speaker_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_text_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_text_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_texture_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_texture_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_volume_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_volume_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_work_space_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_work_space_set(PointerRNA *ptr, bool value);

bool FileSelectIDFilter_filter_world_get(PointerRNA *ptr);
void FileSelectIDFilter_filter_world_set(PointerRNA *ptr, bool value);

/**************** File Select Parameters ****************/

extern StructRNA RNA_FileSelectParams;

PointerRNA FileSelectParams_rna_type_get(PointerRNA *ptr);

int FileSelectParams_list_column_size_get(PointerRNA *ptr);
void FileSelectParams_list_column_size_set(PointerRNA *ptr, int value);

#define FileSelectParams_directory_MAX 1282

void FileSelectParams_directory_get(PointerRNA *ptr, char *value);
int FileSelectParams_directory_length(PointerRNA *ptr);
void FileSelectParams_directory_set(PointerRNA *ptr, const char *value);

enum {
	FileSelectParams_display_type_LIST_VERTICAL = 1,
	FileSelectParams_display_type_LIST_HORIZONTAL = 2,
	FileSelectParams_display_type_THUMBNAIL = 3,
};

int FileSelectParams_display_type_get(PointerRNA *ptr);
void FileSelectParams_display_type_set(PointerRNA *ptr, int value);

int FileSelectParams_display_size_get(PointerRNA *ptr);
void FileSelectParams_display_size_set(PointerRNA *ptr, int value);

enum {
	FileSelectParams_display_size_discrete_TINY = 32,
	FileSelectParams_display_size_discrete_SMALL = 64,
	FileSelectParams_display_size_discrete_NORMAL = 96,
	FileSelectParams_display_size_discrete_BIG = 128,
	FileSelectParams_display_size_discrete_LARGE = 192,
};

int FileSelectParams_display_size_discrete_get(PointerRNA *ptr);
void FileSelectParams_display_size_discrete_set(PointerRNA *ptr, int value);

int FileSelectParams_list_display_size_get(PointerRNA *ptr);
void FileSelectParams_list_display_size_set(PointerRNA *ptr, int value);

#define FileSelectParams_filter_glob_MAX 256

void FileSelectParams_filter_glob_get(PointerRNA *ptr, char *value);
int FileSelectParams_filter_glob_length(PointerRNA *ptr);
void FileSelectParams_filter_glob_set(PointerRNA *ptr, const char *value);

bool FileSelectParams_show_details_datetime_get(PointerRNA *ptr);
void FileSelectParams_show_details_datetime_set(PointerRNA *ptr, bool value);

#define FileSelectParams_filename_MAX 256

void FileSelectParams_filename_get(PointerRNA *ptr, char *value);
int FileSelectParams_filename_length(PointerRNA *ptr);
void FileSelectParams_filename_set(PointerRNA *ptr, const char *value);

bool FileSelectParams_show_details_size_get(PointerRNA *ptr);
void FileSelectParams_show_details_size_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_blender_get(PointerRNA *ptr);
void FileSelectParams_use_filter_blender_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_backup_get(PointerRNA *ptr);
void FileSelectParams_use_filter_backup_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_blendid_get(PointerRNA *ptr);
void FileSelectParams_use_filter_blendid_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_get(PointerRNA *ptr);
void FileSelectParams_use_filter_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_folder_get(PointerRNA *ptr);
void FileSelectParams_use_filter_folder_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_font_get(PointerRNA *ptr);
void FileSelectParams_use_filter_font_set(PointerRNA *ptr, bool value);

PointerRNA FileSelectParams_filter_id_get(PointerRNA *ptr);

bool FileSelectParams_use_filter_image_get(PointerRNA *ptr);
void FileSelectParams_use_filter_image_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_movie_get(PointerRNA *ptr);
void FileSelectParams_use_filter_movie_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_script_get(PointerRNA *ptr);
void FileSelectParams_use_filter_script_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_sound_get(PointerRNA *ptr);
void FileSelectParams_use_filter_sound_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_text_get(PointerRNA *ptr);
void FileSelectParams_use_filter_text_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_filter_volume_get(PointerRNA *ptr);
void FileSelectParams_use_filter_volume_set(PointerRNA *ptr, bool value);

bool FileSelectParams_use_library_browsing_get(PointerRNA *ptr);
void FileSelectParams_use_library_browsing_set(PointerRNA *ptr, bool value);

#define FileSelectParams_filter_search_MAX 64

void FileSelectParams_filter_search_get(PointerRNA *ptr, char *value);
int FileSelectParams_filter_search_length(PointerRNA *ptr);
void FileSelectParams_filter_search_set(PointerRNA *ptr, const char *value);

bool FileSelectParams_use_filter_asset_only_get(PointerRNA *ptr);
void FileSelectParams_use_filter_asset_only_set(PointerRNA *ptr, bool value);

enum {
	FileSelectParams_recursion_level_NONE = 0,
	FileSelectParams_recursion_level_BLEND = 1,
	FileSelectParams_recursion_level_ALL_1 = 2,
	FileSelectParams_recursion_level_ALL_2 = 3,
	FileSelectParams_recursion_level_ALL_3 = 4,
};

int FileSelectParams_recursion_level_get(PointerRNA *ptr);
void FileSelectParams_recursion_level_set(PointerRNA *ptr, int value);

bool FileSelectParams_use_sort_invert_get(PointerRNA *ptr);
void FileSelectParams_use_sort_invert_set(PointerRNA *ptr, bool value);

bool FileSelectParams_show_hidden_get(PointerRNA *ptr);
void FileSelectParams_show_hidden_set(PointerRNA *ptr, bool value);

enum {
	FileSelectParams_sort_method_FILE_SORT_ALPHA = 1,
	FileSelectParams_sort_method_FILE_SORT_EXTENSION = 2,
	FileSelectParams_sort_method_FILE_SORT_TIME = 3,
	FileSelectParams_sort_method_FILE_SORT_SIZE = 4,
	FileSelectParams_sort_method_ASSET_CATALOG = 5,
};

int FileSelectParams_sort_method_get(PointerRNA *ptr);
void FileSelectParams_sort_method_set(PointerRNA *ptr, int value);

#define FileSelectParams_title_MAX 96

void FileSelectParams_title_get(PointerRNA *ptr, char *value);
int FileSelectParams_title_length(PointerRNA *ptr);
void FileSelectParams_title_set(PointerRNA *ptr, const char *value);

/**************** Float2 Attribute ****************/

extern StructRNA RNA_Float2Attribute;
extern StructRNA RNA_Attribute;

void Float2Attribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Float2Attribute_data_next(CollectionPropertyIterator *iter);
void Float2Attribute_data_end(CollectionPropertyIterator *iter);
int Float2Attribute_data_length(PointerRNA *ptr);
bool Float2Attribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Float2 Attribute Value ****************/

extern StructRNA RNA_Float2AttributeValue;

PointerRNA Float2AttributeValue_rna_type_get(PointerRNA *ptr);

void Float2AttributeValue_vector_get(PointerRNA *ptr, float values[2]);
void Float2AttributeValue_vector_set(PointerRNA *ptr, const float values[2]);

/**************** 4x4 Matrix Attribute ****************/

extern StructRNA RNA_Float4x4Attribute;
extern StructRNA RNA_Attribute;

void Float4x4Attribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Float4x4Attribute_data_next(CollectionPropertyIterator *iter);
void Float4x4Attribute_data_end(CollectionPropertyIterator *iter);
int Float4x4Attribute_data_length(PointerRNA *ptr);
bool Float4x4Attribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Matrix Attribute Value ****************/

extern StructRNA RNA_Float4x4AttributeValue;

PointerRNA Float4x4AttributeValue_rna_type_get(PointerRNA *ptr);

void Float4x4AttributeValue_value_get(PointerRNA *ptr, float values[16]);
void Float4x4AttributeValue_value_set(PointerRNA *ptr, const float values[16]);

/**************** Float Attribute ****************/

extern StructRNA RNA_FloatAttribute;
extern StructRNA RNA_Attribute;

void FloatAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FloatAttribute_data_next(CollectionPropertyIterator *iter);
void FloatAttribute_data_end(CollectionPropertyIterator *iter);
int FloatAttribute_data_length(PointerRNA *ptr);
bool FloatAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Float Attribute Value ****************/

extern StructRNA RNA_FloatAttributeValue;

PointerRNA FloatAttributeValue_rna_type_get(PointerRNA *ptr);

float FloatAttributeValue_value_get(PointerRNA *ptr);
void FloatAttributeValue_value_set(PointerRNA *ptr, float value);

/**************** Float Color Attribute ****************/

extern StructRNA RNA_FloatColorAttribute;
extern StructRNA RNA_Attribute;

void FloatColorAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FloatColorAttribute_data_next(CollectionPropertyIterator *iter);
void FloatColorAttribute_data_end(CollectionPropertyIterator *iter);
int FloatColorAttribute_data_length(PointerRNA *ptr);
bool FloatColorAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Float Color Attribute Value ****************/

extern StructRNA RNA_FloatColorAttributeValue;

PointerRNA FloatColorAttributeValue_rna_type_get(PointerRNA *ptr);

void FloatColorAttributeValue_color_get(PointerRNA *ptr, float values[4]);
void FloatColorAttributeValue_color_set(PointerRNA *ptr, const float values[4]);

void FloatColorAttributeValue_color_srgb_get(PointerRNA *ptr, float values[4]);
void FloatColorAttributeValue_color_srgb_set(PointerRNA *ptr, const float values[4]);

/**************** Float Definition ****************/

extern StructRNA RNA_FloatProperty;
extern StructRNA RNA_Property;

void FloatProperty_array_dimensions_get(PointerRNA *ptr, int values[3]);
void FloatProperty_array_dimensions_set(PointerRNA *ptr, const int values[3]);

int FloatProperty_array_length_get(PointerRNA *ptr);
void FloatProperty_array_length_set(PointerRNA *ptr, int value);

float FloatProperty_default_value_get(PointerRNA *ptr);
void FloatProperty_default_value_set(PointerRNA *ptr, float value);

void FloatProperty_default_array_get(PointerRNA *ptr, float values[]);
void FloatProperty_default_array_set(PointerRNA *ptr, const float values[]);int FloatProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

float FloatProperty_hard_max_get(PointerRNA *ptr);
void FloatProperty_hard_max_set(PointerRNA *ptr, float value);

float FloatProperty_hard_min_get(PointerRNA *ptr);
void FloatProperty_hard_min_set(PointerRNA *ptr, float value);

bool FloatProperty_is_array_get(PointerRNA *ptr);
void FloatProperty_is_array_set(PointerRNA *ptr, bool value);

int FloatProperty_precision_get(PointerRNA *ptr);
void FloatProperty_precision_set(PointerRNA *ptr, int value);

float FloatProperty_soft_max_get(PointerRNA *ptr);
void FloatProperty_soft_max_set(PointerRNA *ptr, float value);

float FloatProperty_soft_min_get(PointerRNA *ptr);
void FloatProperty_soft_min_set(PointerRNA *ptr, float value);

float FloatProperty_step_get(PointerRNA *ptr);
void FloatProperty_step_set(PointerRNA *ptr, float value);

/**************** Float Vector Attribute ****************/

extern StructRNA RNA_FloatVectorAttribute;
extern StructRNA RNA_Attribute;

void FloatVectorAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FloatVectorAttribute_data_next(CollectionPropertyIterator *iter);
void FloatVectorAttribute_data_end(CollectionPropertyIterator *iter);
int FloatVectorAttribute_data_length(PointerRNA *ptr);
bool FloatVectorAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Float Vector Attribute Value ****************/

extern StructRNA RNA_FloatVectorAttributeValue;

PointerRNA FloatVectorAttributeValue_rna_type_get(PointerRNA *ptr);

void FloatVectorAttributeValue_vector_get(PointerRNA *ptr, float values[3]);
void FloatVectorAttributeValue_vector_set(PointerRNA *ptr, const float values[3]);

/**************** Read-Only Vector ****************/

extern StructRNA RNA_FloatVectorValueReadOnly;

PointerRNA FloatVectorValueReadOnly_rna_type_get(PointerRNA *ptr);

void FloatVectorValueReadOnly_vector_get(PointerRNA *ptr, float values[3]);
void FloatVectorValueReadOnly_vector_set(PointerRNA *ptr, const float values[3]);

/**************** Floor Constraint ****************/

extern StructRNA RNA_FloorConstraint;
extern StructRNA RNA_Constraint;

enum {
	FloorConstraint_floor_location_FLOOR_X = 0,
	FloorConstraint_floor_location_FLOOR_Y = 1,
	FloorConstraint_floor_location_FLOOR_Z = 2,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_X = 3,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_Y = 4,
	FloorConstraint_floor_location_FLOOR_NEGATIVE_Z = 5,
};

int FloorConstraint_floor_location_get(PointerRNA *ptr);
void FloorConstraint_floor_location_set(PointerRNA *ptr, int value);

float FloorConstraint_offset_get(PointerRNA *ptr);
void FloorConstraint_offset_set(PointerRNA *ptr, float value);

#define FloorConstraint_subtarget_MAX 64

void FloorConstraint_subtarget_get(PointerRNA *ptr, char *value);
int FloorConstraint_subtarget_length(PointerRNA *ptr);
void FloorConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA FloorConstraint_target_get(PointerRNA *ptr);

bool FloorConstraint_use_rotation_get(PointerRNA *ptr);
void FloorConstraint_use_rotation_set(PointerRNA *ptr, bool value);

/**************** Domain Settings ****************/

extern StructRNA RNA_FluidDomainSettings;

PointerRNA FluidDomainSettings_rna_type_get(PointerRNA *ptr);

PointerRNA FluidDomainSettings_guide_parent_get(PointerRNA *ptr);

bool FluidDomainSettings_use_adaptive_domain_get(PointerRNA *ptr);
void FluidDomainSettings_use_adaptive_domain_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_adaptive_timesteps_get(PointerRNA *ptr);
void FluidDomainSettings_use_adaptive_timesteps_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_additional_res_get(PointerRNA *ptr);
void FluidDomainSettings_additional_res_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_slice_axis_AUTO = 0,
	FluidDomainSettings_slice_axis_X = 1,
	FluidDomainSettings_slice_axis_Y = 2,
	FluidDomainSettings_slice_axis_Z = 3,
};

int FluidDomainSettings_slice_axis_get(PointerRNA *ptr);
void FluidDomainSettings_slice_axis_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_use_collision_border_back_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_back_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_collision_border_bottom_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_bottom_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_bubble_particles_get(PointerRNA *ptr);
void FluidDomainSettings_use_bubble_particles_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_sndparticle_bubble_buoyancy_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_bubble_buoyancy_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_bubble_drag_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_bubble_drag_set(PointerRNA *ptr, float value);

float FluidDomainSettings_alpha_get(PointerRNA *ptr);
void FluidDomainSettings_alpha_set(PointerRNA *ptr, float value);

float FluidDomainSettings_beta_get(PointerRNA *ptr);
void FluidDomainSettings_beta_set(PointerRNA *ptr, float value);

float FluidDomainSettings_cfl_condition_get(PointerRNA *ptr);
void FluidDomainSettings_cfl_condition_set(PointerRNA *ptr, float value);

#define FluidDomainSettings_cache_directory_MAX 1024

void FluidDomainSettings_cache_directory_get(PointerRNA *ptr, char *value);
int FluidDomainSettings_cache_directory_length(PointerRNA *ptr);
void FluidDomainSettings_cache_directory_set(PointerRNA *ptr, const char *value);

enum {
	FluidDomainSettings_gridlines_cell_filter_NONE = 0,
	FluidDomainSettings_gridlines_cell_filter_FLUID = 1,
	FluidDomainSettings_gridlines_cell_filter_OBSTACLE = 2,
	FluidDomainSettings_gridlines_cell_filter_EMPTY = 4,
	FluidDomainSettings_gridlines_cell_filter_INFLOW = 8,
	FluidDomainSettings_gridlines_cell_filter_OUTFLOW = 16,
};

int FluidDomainSettings_gridlines_cell_filter_get(PointerRNA *ptr);
void FluidDomainSettings_gridlines_cell_filter_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_delete_in_obstacle_get(PointerRNA *ptr);
void FluidDomainSettings_delete_in_obstacle_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_clipping_get(PointerRNA *ptr);
void FluidDomainSettings_clipping_set(PointerRNA *ptr, float value);

void FluidDomainSettings_gridlines_range_color_get(PointerRNA *ptr, float values[4]);
void FluidDomainSettings_gridlines_range_color_set(PointerRNA *ptr, const float values[4]);

void FluidDomainSettings_color_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_color_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_color_grid_get_length(PointerRNA *ptr, int *arraylen);

enum {
	FluidDomainSettings_gridlines_color_field_NONE = 0,
	FluidDomainSettings_gridlines_color_field_FLAGS = 1,
	FluidDomainSettings_gridlines_color_field_RANGE = 2,
};

int FluidDomainSettings_gridlines_color_field_get(PointerRNA *ptr);
void FluidDomainSettings_gridlines_color_field_set(PointerRNA *ptr, int value);

PointerRNA FluidDomainSettings_color_ramp_get(PointerRNA *ptr);

enum {
	FluidDomainSettings_sndparticle_combined_export_OFF = 0,
	FluidDomainSettings_sndparticle_combined_export_SPRAY_FOAM = 1,
	FluidDomainSettings_sndparticle_combined_export_SPRAY_BUBBLES = 2,
	FluidDomainSettings_sndparticle_combined_export_FOAM_BUBBLES = 3,
	FluidDomainSettings_sndparticle_combined_export_SPRAY_FOAM_BUBBLES = 4,
};

int FluidDomainSettings_sndparticle_combined_export_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_combined_export_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_openvdb_cache_compress_type_ZIP = 1,
	FluidDomainSettings_openvdb_cache_compress_type_NONE = 2,
};

int FluidDomainSettings_openvdb_cache_compress_type_get(PointerRNA *ptr);
void FluidDomainSettings_openvdb_cache_compress_type_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_openvdb_data_depth_NONE = 0,
};

int FluidDomainSettings_openvdb_data_depth_get(PointerRNA *ptr);
void FluidDomainSettings_openvdb_data_depth_set(PointerRNA *ptr, int value);

void FluidDomainSettings_density_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_density_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_density_grid_get_length(PointerRNA *ptr, int *arraylen);

enum {
	FluidDomainSettings_vector_display_type_NEEDLE = 0,
	FluidDomainSettings_vector_display_type_STREAMLINE = 1,
	FluidDomainSettings_vector_display_type_MAC = 2,
};

int FluidDomainSettings_vector_display_type_get(PointerRNA *ptr);
void FluidDomainSettings_vector_display_type_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_use_dissolve_smoke_get(PointerRNA *ptr);
void FluidDomainSettings_use_dissolve_smoke_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_dissolve_speed_get(PointerRNA *ptr);
void FluidDomainSettings_dissolve_speed_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_domain_type_GAS = 0,
	FluidDomainSettings_domain_type_LIQUID = 1,
};

int FluidDomainSettings_domain_type_get(PointerRNA *ptr);
void FluidDomainSettings_domain_type_set(PointerRNA *ptr, int value);

PointerRNA FluidDomainSettings_effector_group_get(PointerRNA *ptr);

PointerRNA FluidDomainSettings_effector_weights_get(PointerRNA *ptr);

enum {
	FluidDomainSettings_highres_sampling_FULLSAMPLE = 2,
	FluidDomainSettings_highres_sampling_LINEAR = 1,
	FluidDomainSettings_highres_sampling_NEAREST = 0,
};

int FluidDomainSettings_highres_sampling_get(PointerRNA *ptr);
void FluidDomainSettings_highres_sampling_set(PointerRNA *ptr, int value);

int FluidDomainSettings_cache_frame_end_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_end_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_export_manta_script_get(PointerRNA *ptr);
void FluidDomainSettings_export_manta_script_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_flip_particles_get(PointerRNA *ptr);
void FluidDomainSettings_use_flip_particles_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_flip_ratio_get(PointerRNA *ptr);
void FluidDomainSettings_flip_ratio_set(PointerRNA *ptr, float value);

enum {
	FluidDomainSettings_vector_field_FLUID_VELOCITY = 0,
	FluidDomainSettings_vector_field_GUIDE_VELOCITY = 1,
	FluidDomainSettings_vector_field_FORCE = 2,
};

int FluidDomainSettings_vector_field_get(PointerRNA *ptr);
void FluidDomainSettings_vector_field_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_color_ramp_field_NONE = 0,
};

int FluidDomainSettings_color_ramp_field_get(PointerRNA *ptr);
void FluidDomainSettings_color_ramp_field_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_cache_mesh_format_UNI = 1,
	FluidDomainSettings_cache_mesh_format_OPENVDB = 2,
	FluidDomainSettings_cache_mesh_format_RAW = 4,
};

int FluidDomainSettings_cache_mesh_format_get(PointerRNA *ptr);
void FluidDomainSettings_cache_mesh_format_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_cache_data_format_UNI = 1,
	FluidDomainSettings_cache_data_format_OPENVDB = 2,
	FluidDomainSettings_cache_data_format_RAW = 4,
};

int FluidDomainSettings_cache_data_format_get(PointerRNA *ptr);
void FluidDomainSettings_cache_data_format_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_cache_particle_format_UNI = 1,
	FluidDomainSettings_cache_particle_format_OPENVDB = 2,
	FluidDomainSettings_cache_particle_format_RAW = 4,
};

int FluidDomainSettings_cache_particle_format_get(PointerRNA *ptr);
void FluidDomainSettings_cache_particle_format_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_cache_noise_format_UNI = 1,
	FluidDomainSettings_cache_noise_format_OPENVDB = 2,
	FluidDomainSettings_cache_noise_format_RAW = 4,
};

int FluidDomainSettings_cache_noise_format_get(PointerRNA *ptr);
void FluidDomainSettings_cache_noise_format_set(PointerRNA *ptr, int value);

void FluidDomainSettings_flame_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_flame_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_flame_grid_get_length(PointerRNA *ptr, int *arraylen);

PointerRNA FluidDomainSettings_fluid_group_get(PointerRNA *ptr);

bool FluidDomainSettings_use_foam_particles_get(PointerRNA *ptr);
void FluidDomainSettings_use_foam_particles_set(PointerRNA *ptr, bool value);

PointerRNA FluidDomainSettings_force_collection_get(PointerRNA *ptr);

bool FluidDomainSettings_use_fractions_get(PointerRNA *ptr);
void FluidDomainSettings_use_fractions_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_collision_border_front_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_front_set(PointerRNA *ptr, bool value);

void FluidDomainSettings_gravity_get(PointerRNA *ptr, float values[3]);
void FluidDomainSettings_gravity_set(PointerRNA *ptr, const float values[3]);

bool FluidDomainSettings_use_color_ramp_get(PointerRNA *ptr);
void FluidDomainSettings_use_color_ramp_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_show_gridlines_get(PointerRNA *ptr);
void FluidDomainSettings_show_gridlines_set(PointerRNA *ptr, bool value);

enum {
	FluidDomainSettings_guide_source_DOMAIN = 0,
	FluidDomainSettings_guide_source_EFFECTOR = 1,
};

int FluidDomainSettings_guide_source_get(PointerRNA *ptr);
void FluidDomainSettings_guide_source_set(PointerRNA *ptr, int value);

void FluidDomainSettings_heat_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_heat_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_heat_grid_get_length(PointerRNA *ptr, int *arraylen);

enum {
	FluidDomainSettings_display_interpolation_LINEAR = 0,
	FluidDomainSettings_display_interpolation_CUBIC = 1,
	FluidDomainSettings_display_interpolation_CLOSEST = 2,
};

int FluidDomainSettings_display_interpolation_get(PointerRNA *ptr);
void FluidDomainSettings_display_interpolation_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_use_collision_border_left_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_left_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_dissolve_smoke_log_get(PointerRNA *ptr);
void FluidDomainSettings_use_dissolve_smoke_log_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_gridlines_lower_bound_get(PointerRNA *ptr);
void FluidDomainSettings_gridlines_lower_bound_set(PointerRNA *ptr, float value);

float FluidDomainSettings_mesh_concave_lower_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_concave_lower_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_vector_scale_with_magnitude_get(PointerRNA *ptr);
void FluidDomainSettings_vector_scale_with_magnitude_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_adapt_margin_get(PointerRNA *ptr);
void FluidDomainSettings_adapt_margin_set(PointerRNA *ptr, int value);

float FluidDomainSettings_flame_max_temp_get(PointerRNA *ptr);
void FluidDomainSettings_flame_max_temp_set(PointerRNA *ptr, float value);

int FluidDomainSettings_particle_max_get(PointerRNA *ptr);
void FluidDomainSettings_particle_max_set(PointerRNA *ptr, int value);

int FluidDomainSettings_timesteps_max_get(PointerRNA *ptr);
void FluidDomainSettings_timesteps_max_set(PointerRNA *ptr, int value);

float FluidDomainSettings_sndparticle_potential_max_energy_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_max_energy_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_life_max_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_life_max_set(PointerRNA *ptr, float value);

int FluidDomainSettings_resolution_max_get(PointerRNA *ptr);
void FluidDomainSettings_resolution_max_set(PointerRNA *ptr, int value);

float FluidDomainSettings_sndparticle_potential_max_trappedair_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_max_trappedair_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_potential_max_wavecrest_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_max_wavecrest_set(PointerRNA *ptr, float value);

enum {
	FluidDomainSettings_mesh_generator_IMPROVED = 0,
	FluidDomainSettings_mesh_generator_UNION = 1,
};

int FluidDomainSettings_mesh_generator_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_generator_set(PointerRNA *ptr, int value);

int FluidDomainSettings_mesh_scale_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_scale_set(PointerRNA *ptr, int value);

float FluidDomainSettings_flame_ignition_get(PointerRNA *ptr);
void FluidDomainSettings_flame_ignition_set(PointerRNA *ptr, float value);

int FluidDomainSettings_particle_min_get(PointerRNA *ptr);
void FluidDomainSettings_particle_min_set(PointerRNA *ptr, int value);

int FluidDomainSettings_timesteps_min_get(PointerRNA *ptr);
void FluidDomainSettings_timesteps_min_set(PointerRNA *ptr, int value);

float FluidDomainSettings_sndparticle_potential_min_energy_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_min_energy_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_life_min_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_life_min_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_potential_min_trappedair_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_min_trappedair_set(PointerRNA *ptr, float value);

float FluidDomainSettings_sndparticle_potential_min_wavecrest_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_min_wavecrest_set(PointerRNA *ptr, float value);

int FluidDomainSettings_noise_scale_get(PointerRNA *ptr);
void FluidDomainSettings_noise_scale_set(PointerRNA *ptr, int value);

int FluidDomainSettings_particle_number_get(PointerRNA *ptr);
void FluidDomainSettings_particle_number_set(PointerRNA *ptr, int value);

float FluidDomainSettings_fractions_distance_get(PointerRNA *ptr);
void FluidDomainSettings_fractions_distance_set(PointerRNA *ptr, float value);

float FluidDomainSettings_fractions_threshold_get(PointerRNA *ptr);
void FluidDomainSettings_fractions_threshold_set(PointerRNA *ptr, float value);

int FluidDomainSettings_cache_frame_offset_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_offset_set(PointerRNA *ptr, int value);

int FluidDomainSettings_particle_scale_get(PointerRNA *ptr);
void FluidDomainSettings_particle_scale_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_sndparticle_boundary_DELETE = 0,
	FluidDomainSettings_sndparticle_boundary_PUSHOUT = 1,
};

int FluidDomainSettings_sndparticle_boundary_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_boundary_set(PointerRNA *ptr, int value);

float FluidDomainSettings_slice_depth_get(PointerRNA *ptr);
void FluidDomainSettings_slice_depth_set(PointerRNA *ptr, float value);

int FluidDomainSettings_sndparticle_potential_radius_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_potential_radius_set(PointerRNA *ptr, int value);

float FluidDomainSettings_particle_radius_get(PointerRNA *ptr);
void FluidDomainSettings_particle_radius_set(PointerRNA *ptr, float value);

float FluidDomainSettings_mesh_particle_radius_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_particle_radius_set(PointerRNA *ptr, float value);

float FluidDomainSettings_particle_randomness_get(PointerRNA *ptr);
void FluidDomainSettings_particle_randomness_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_cache_resumable_get(PointerRNA *ptr);
void FluidDomainSettings_cache_resumable_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_collision_border_right_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_right_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_noise_pos_scale_get(PointerRNA *ptr);
void FluidDomainSettings_noise_pos_scale_set(PointerRNA *ptr, float value);

float FluidDomainSettings_vector_scale_get(PointerRNA *ptr);
void FluidDomainSettings_vector_scale_set(PointerRNA *ptr, float value);

float FluidDomainSettings_color_ramp_field_scale_get(PointerRNA *ptr);
void FluidDomainSettings_color_ramp_field_scale_set(PointerRNA *ptr, float value);

enum {
	FluidDomainSettings_simulation_method_FLIP = 1,
	FluidDomainSettings_simulation_method_APIC = 2,
};

int FluidDomainSettings_simulation_method_get(PointerRNA *ptr);
void FluidDomainSettings_simulation_method_set(PointerRNA *ptr, int value);

int FluidDomainSettings_guide_beta_get(PointerRNA *ptr);
void FluidDomainSettings_guide_beta_set(PointerRNA *ptr, int value);

bool FluidDomainSettings_use_slice_get(PointerRNA *ptr);
void FluidDomainSettings_use_slice_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_slice_per_voxel_get(PointerRNA *ptr);
void FluidDomainSettings_slice_per_voxel_set(PointerRNA *ptr, float value);

float FluidDomainSettings_flame_smoke_get(PointerRNA *ptr);
void FluidDomainSettings_flame_smoke_set(PointerRNA *ptr, float value);

void FluidDomainSettings_flame_smoke_color_get(PointerRNA *ptr, float values[3]);
void FluidDomainSettings_flame_smoke_color_set(PointerRNA *ptr, const float values[3]);

int FluidDomainSettings_mesh_smoothen_neg_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_smoothen_neg_set(PointerRNA *ptr, int value);

int FluidDomainSettings_mesh_smoothen_pos_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_smoothen_pos_set(PointerRNA *ptr, int value);

float FluidDomainSettings_burning_rate_get(PointerRNA *ptr);
void FluidDomainSettings_burning_rate_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_use_speed_vectors_get(PointerRNA *ptr);
void FluidDomainSettings_use_speed_vectors_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_spray_particles_get(PointerRNA *ptr);
void FluidDomainSettings_use_spray_particles_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_cache_frame_start_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_start_set(PointerRNA *ptr, int value);

float FluidDomainSettings_noise_strength_get(PointerRNA *ptr);
void FluidDomainSettings_noise_strength_set(PointerRNA *ptr, float value);

float FluidDomainSettings_viscosity_value_get(PointerRNA *ptr);
void FluidDomainSettings_viscosity_value_set(PointerRNA *ptr, float value);

int FluidDomainSettings_sys_particle_maximum_get(PointerRNA *ptr);
void FluidDomainSettings_sys_particle_maximum_set(PointerRNA *ptr, int value);

void FluidDomainSettings_temperature_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_temperature_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_temperature_grid_get_length(PointerRNA *ptr, int *arraylen);

float FluidDomainSettings_surface_tension_get(PointerRNA *ptr);
void FluidDomainSettings_surface_tension_set(PointerRNA *ptr, float value);

float FluidDomainSettings_display_thickness_get(PointerRNA *ptr);
void FluidDomainSettings_display_thickness_set(PointerRNA *ptr, float value);

float FluidDomainSettings_adapt_threshold_get(PointerRNA *ptr);
void FluidDomainSettings_adapt_threshold_set(PointerRNA *ptr, float value);

float FluidDomainSettings_noise_time_anim_get(PointerRNA *ptr);
void FluidDomainSettings_noise_time_anim_set(PointerRNA *ptr, float value);

float FluidDomainSettings_time_scale_get(PointerRNA *ptr);
void FluidDomainSettings_time_scale_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_use_collision_border_top_get(PointerRNA *ptr);
void FluidDomainSettings_use_collision_border_top_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_tracer_particles_get(PointerRNA *ptr);
void FluidDomainSettings_use_tracer_particles_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_sndparticle_sampling_trappedair_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_sampling_trappedair_set(PointerRNA *ptr, int value);

enum {
	FluidDomainSettings_cache_type_REPLAY = 0,
	FluidDomainSettings_cache_type_MODULAR = 1,
	FluidDomainSettings_cache_type_ALL = 2,
};

int FluidDomainSettings_cache_type_get(PointerRNA *ptr);
void FluidDomainSettings_cache_type_set(PointerRNA *ptr, int value);

int FluidDomainSettings_sndparticle_update_radius_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_update_radius_set(PointerRNA *ptr, int value);

float FluidDomainSettings_gridlines_upper_bound_get(PointerRNA *ptr);
void FluidDomainSettings_gridlines_upper_bound_set(PointerRNA *ptr, float value);

float FluidDomainSettings_mesh_concave_upper_get(PointerRNA *ptr);
void FluidDomainSettings_mesh_concave_upper_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_use_diffusion_get(PointerRNA *ptr);
void FluidDomainSettings_use_diffusion_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_guide_get(PointerRNA *ptr);
void FluidDomainSettings_use_guide_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_mesh_get(PointerRNA *ptr);
void FluidDomainSettings_use_mesh_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_noise_get(PointerRNA *ptr);
void FluidDomainSettings_use_noise_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_use_viscosity_get(PointerRNA *ptr);
void FluidDomainSettings_use_viscosity_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_show_velocity_get(PointerRNA *ptr);
void FluidDomainSettings_show_velocity_set(PointerRNA *ptr, bool value);

float FluidDomainSettings_guide_vel_factor_get(PointerRNA *ptr);
void FluidDomainSettings_guide_vel_factor_set(PointerRNA *ptr, float value);

void FluidDomainSettings_velocity_grid_get(PointerRNA *ptr, float values[]);
void FluidDomainSettings_velocity_grid_set(PointerRNA *ptr, const float values[]);int FluidDomainSettings_velocity_grid_get_length(PointerRNA *ptr, int *arraylen);

float FluidDomainSettings_velocity_scale_get(PointerRNA *ptr);
void FluidDomainSettings_velocity_scale_set(PointerRNA *ptr, float value);

float FluidDomainSettings_viscosity_base_get(PointerRNA *ptr);
void FluidDomainSettings_viscosity_base_set(PointerRNA *ptr, float value);

int FluidDomainSettings_viscosity_exponent_get(PointerRNA *ptr);
void FluidDomainSettings_viscosity_exponent_set(PointerRNA *ptr, int value);

float FluidDomainSettings_vorticity_get(PointerRNA *ptr);
void FluidDomainSettings_vorticity_set(PointerRNA *ptr, float value);

float FluidDomainSettings_flame_vorticity_get(PointerRNA *ptr);
void FluidDomainSettings_flame_vorticity_set(PointerRNA *ptr, float value);

int FluidDomainSettings_sndparticle_sampling_wavecrest_get(PointerRNA *ptr);
void FluidDomainSettings_sndparticle_sampling_wavecrest_set(PointerRNA *ptr, int value);

float FluidDomainSettings_guide_alpha_get(PointerRNA *ptr);
void FluidDomainSettings_guide_alpha_set(PointerRNA *ptr, float value);

float FluidDomainSettings_particle_band_width_get(PointerRNA *ptr);
void FluidDomainSettings_particle_band_width_set(PointerRNA *ptr, float value);

bool FluidDomainSettings_vector_show_mac_x_get(PointerRNA *ptr);
void FluidDomainSettings_vector_show_mac_x_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_vector_show_mac_y_get(PointerRNA *ptr);
void FluidDomainSettings_vector_show_mac_y_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_vector_show_mac_z_get(PointerRNA *ptr);
void FluidDomainSettings_vector_show_mac_z_set(PointerRNA *ptr, bool value);

int FluidDomainSettings_cache_frame_pause_data_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_pause_data_set(PointerRNA *ptr, int value);

int FluidDomainSettings_cache_frame_pause_guide_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_pause_guide_set(PointerRNA *ptr, int value);

int FluidDomainSettings_cache_frame_pause_mesh_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_pause_mesh_set(PointerRNA *ptr, int value);

int FluidDomainSettings_cache_frame_pause_noise_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_pause_noise_set(PointerRNA *ptr, int value);

int FluidDomainSettings_cache_frame_pause_particles_get(PointerRNA *ptr);
void FluidDomainSettings_cache_frame_pause_particles_set(PointerRNA *ptr, int value);

void FluidDomainSettings_cell_size_get(PointerRNA *ptr, float values[3]);
void FluidDomainSettings_cell_size_set(PointerRNA *ptr, const float values[3]);

bool FluidDomainSettings_has_cache_baked_any_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_any_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_has_cache_baked_data_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_data_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_has_cache_baked_guide_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_guide_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_has_cache_baked_mesh_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_mesh_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_has_cache_baked_noise_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_noise_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_has_cache_baked_particles_get(PointerRNA *ptr);
void FluidDomainSettings_has_cache_baked_particles_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_any_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_any_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_data_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_data_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_guide_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_guide_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_mesh_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_mesh_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_noise_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_noise_set(PointerRNA *ptr, bool value);

bool FluidDomainSettings_is_cache_baking_particles_get(PointerRNA *ptr);
void FluidDomainSettings_is_cache_baking_particles_set(PointerRNA *ptr, bool value);

void FluidDomainSettings_start_point_get(PointerRNA *ptr, float values[3]);
void FluidDomainSettings_start_point_set(PointerRNA *ptr, const float values[3]);

void FluidDomainSettings_domain_resolution_get(PointerRNA *ptr, int values[3]);
void FluidDomainSettings_domain_resolution_set(PointerRNA *ptr, const int values[3]);

/**************** Effector Settings ****************/

extern StructRNA RNA_FluidEffectorSettings;

PointerRNA FluidEffectorSettings_rna_type_get(PointerRNA *ptr);

enum {
	FluidEffectorSettings_effector_type_COLLISION = 0,
	FluidEffectorSettings_effector_type_GUIDE = 1,
};

int FluidEffectorSettings_effector_type_get(PointerRNA *ptr);
void FluidEffectorSettings_effector_type_set(PointerRNA *ptr, int value);

bool FluidEffectorSettings_use_effector_get(PointerRNA *ptr);
void FluidEffectorSettings_use_effector_set(PointerRNA *ptr, bool value);

enum {
	FluidEffectorSettings_guide_mode_MAXIMUM = 0,
	FluidEffectorSettings_guide_mode_MINIMUM = 1,
	FluidEffectorSettings_guide_mode_OVERRIDE = 2,
	FluidEffectorSettings_guide_mode_AVERAGED = 3,
};

int FluidEffectorSettings_guide_mode_get(PointerRNA *ptr);
void FluidEffectorSettings_guide_mode_set(PointerRNA *ptr, int value);

bool FluidEffectorSettings_use_plane_init_get(PointerRNA *ptr);
void FluidEffectorSettings_use_plane_init_set(PointerRNA *ptr, bool value);

float FluidEffectorSettings_velocity_factor_get(PointerRNA *ptr);
void FluidEffectorSettings_velocity_factor_set(PointerRNA *ptr, float value);

int FluidEffectorSettings_subframes_get(PointerRNA *ptr);
void FluidEffectorSettings_subframes_set(PointerRNA *ptr, int value);

float FluidEffectorSettings_surface_distance_get(PointerRNA *ptr);
void FluidEffectorSettings_surface_distance_set(PointerRNA *ptr, float value);

/**************** Flow Settings ****************/

extern StructRNA RNA_FluidFlowSettings;

PointerRNA FluidFlowSettings_rna_type_get(PointerRNA *ptr);

bool FluidFlowSettings_use_absolute_get(PointerRNA *ptr);
void FluidFlowSettings_use_absolute_set(PointerRNA *ptr, bool value);

float FluidFlowSettings_density_get(PointerRNA *ptr);
void FluidFlowSettings_density_set(PointerRNA *ptr, float value);

float FluidFlowSettings_fuel_amount_get(PointerRNA *ptr);
void FluidFlowSettings_fuel_amount_set(PointerRNA *ptr, float value);

enum {
	FluidFlowSettings_flow_behavior_INFLOW = 0,
	FluidFlowSettings_flow_behavior_OUTFLOW = 1,
	FluidFlowSettings_flow_behavior_GEOMETRY = 2,
};

int FluidFlowSettings_flow_behavior_get(PointerRNA *ptr);
void FluidFlowSettings_flow_behavior_set(PointerRNA *ptr, int value);

enum {
	FluidFlowSettings_flow_type_SMOKE = 1,
	FluidFlowSettings_flow_type_BOTH = 3,
	FluidFlowSettings_flow_type_FIRE = 2,
	FluidFlowSettings_flow_type_LIQUID = 4,
};

int FluidFlowSettings_flow_type_get(PointerRNA *ptr);
void FluidFlowSettings_flow_type_set(PointerRNA *ptr, int value);

void FluidFlowSettings_velocity_coord_get(PointerRNA *ptr, float values[3]);
void FluidFlowSettings_velocity_coord_set(PointerRNA *ptr, const float values[3]);

bool FluidFlowSettings_use_initial_velocity_get(PointerRNA *ptr);
void FluidFlowSettings_use_initial_velocity_set(PointerRNA *ptr, bool value);

bool FluidFlowSettings_use_plane_init_get(PointerRNA *ptr);
void FluidFlowSettings_use_plane_init_set(PointerRNA *ptr, bool value);

enum {
	FluidFlowSettings_texture_map_type_AUTO = 0,
	FluidFlowSettings_texture_map_type_UV = 1,
};

int FluidFlowSettings_texture_map_type_get(PointerRNA *ptr);
void FluidFlowSettings_texture_map_type_set(PointerRNA *ptr, int value);

float FluidFlowSettings_velocity_normal_get(PointerRNA *ptr);
void FluidFlowSettings_velocity_normal_set(PointerRNA *ptr, float value);

float FluidFlowSettings_texture_offset_get(PointerRNA *ptr);
void FluidFlowSettings_texture_offset_set(PointerRNA *ptr, float value);

PointerRNA FluidFlowSettings_particle_system_get(PointerRNA *ptr);

float FluidFlowSettings_velocity_random_get(PointerRNA *ptr);
void FluidFlowSettings_velocity_random_set(PointerRNA *ptr, float value);

bool FluidFlowSettings_use_particle_size_get(PointerRNA *ptr);
void FluidFlowSettings_use_particle_size_set(PointerRNA *ptr, bool value);

float FluidFlowSettings_particle_size_get(PointerRNA *ptr);
void FluidFlowSettings_particle_size_set(PointerRNA *ptr, float value);

float FluidFlowSettings_texture_size_get(PointerRNA *ptr);
void FluidFlowSettings_texture_size_set(PointerRNA *ptr, float value);

void FluidFlowSettings_smoke_color_get(PointerRNA *ptr, float values[3]);
void FluidFlowSettings_smoke_color_set(PointerRNA *ptr, const float values[3]);

enum {
	FluidFlowSettings_flow_source_NONE = 0,
};

int FluidFlowSettings_flow_source_get(PointerRNA *ptr);
void FluidFlowSettings_flow_source_set(PointerRNA *ptr, int value);

float FluidFlowSettings_velocity_factor_get(PointerRNA *ptr);
void FluidFlowSettings_velocity_factor_set(PointerRNA *ptr, float value);

int FluidFlowSettings_subframes_get(PointerRNA *ptr);
void FluidFlowSettings_subframes_set(PointerRNA *ptr, int value);

float FluidFlowSettings_surface_distance_get(PointerRNA *ptr);
void FluidFlowSettings_surface_distance_set(PointerRNA *ptr, float value);

float FluidFlowSettings_temperature_get(PointerRNA *ptr);
void FluidFlowSettings_temperature_set(PointerRNA *ptr, float value);

PointerRNA FluidFlowSettings_noise_texture_get(PointerRNA *ptr);

#define FluidFlowSettings_uv_layer_MAX 68

void FluidFlowSettings_uv_layer_get(PointerRNA *ptr, char *value);
int FluidFlowSettings_uv_layer_length(PointerRNA *ptr);
void FluidFlowSettings_uv_layer_set(PointerRNA *ptr, const char *value);

bool FluidFlowSettings_use_inflow_get(PointerRNA *ptr);
void FluidFlowSettings_use_inflow_set(PointerRNA *ptr, bool value);

bool FluidFlowSettings_use_texture_get(PointerRNA *ptr);
void FluidFlowSettings_use_texture_set(PointerRNA *ptr, bool value);

void FluidFlowSettings_density_vertex_group_get(PointerRNA *ptr, char *value);
int FluidFlowSettings_density_vertex_group_length(PointerRNA *ptr);
void FluidFlowSettings_density_vertex_group_set(PointerRNA *ptr, const char *value);

float FluidFlowSettings_volume_density_get(PointerRNA *ptr);
void FluidFlowSettings_volume_density_set(PointerRNA *ptr, float value);

/**************** Fluid Modifier ****************/

extern StructRNA RNA_FluidModifier;
extern StructRNA RNA_Modifier;

PointerRNA FluidModifier_domain_settings_get(PointerRNA *ptr);

PointerRNA FluidModifier_effector_settings_get(PointerRNA *ptr);

PointerRNA FluidModifier_flow_settings_get(PointerRNA *ptr);

enum {
	FluidModifier_fluid_type_NONE = 0,
	FluidModifier_fluid_type_DOMAIN = 1,
	FluidModifier_fluid_type_FLOW = 2,
	FluidModifier_fluid_type_EFFECTOR = 4,
};

int FluidModifier_fluid_type_get(PointerRNA *ptr);
void FluidModifier_fluid_type_set(PointerRNA *ptr, int value);

/**************** Follow Path Constraint ****************/

extern StructRNA RNA_FollowPathConstraint;
extern StructRNA RNA_Constraint;

bool FollowPathConstraint_use_curve_radius_get(PointerRNA *ptr);
void FollowPathConstraint_use_curve_radius_set(PointerRNA *ptr, bool value);

bool FollowPathConstraint_use_fixed_location_get(PointerRNA *ptr);
void FollowPathConstraint_use_fixed_location_set(PointerRNA *ptr, bool value);

bool FollowPathConstraint_use_curve_follow_get(PointerRNA *ptr);
void FollowPathConstraint_use_curve_follow_set(PointerRNA *ptr, bool value);

enum {
	FollowPathConstraint_forward_axis_FORWARD_X = 0,
	FollowPathConstraint_forward_axis_FORWARD_Y = 1,
	FollowPathConstraint_forward_axis_FORWARD_Z = 2,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_X = 3,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_Y = 4,
	FollowPathConstraint_forward_axis_TRACK_NEGATIVE_Z = 5,
};

int FollowPathConstraint_forward_axis_get(PointerRNA *ptr);
void FollowPathConstraint_forward_axis_set(PointerRNA *ptr, int value);

float FollowPathConstraint_offset_get(PointerRNA *ptr);
void FollowPathConstraint_offset_set(PointerRNA *ptr, float value);

float FollowPathConstraint_offset_factor_get(PointerRNA *ptr);
void FollowPathConstraint_offset_factor_set(PointerRNA *ptr, float value);

PointerRNA FollowPathConstraint_target_get(PointerRNA *ptr);

enum {
	FollowPathConstraint_up_axis_UP_X = 0,
	FollowPathConstraint_up_axis_UP_Y = 1,
	FollowPathConstraint_up_axis_UP_Z = 2,
};

int FollowPathConstraint_up_axis_get(PointerRNA *ptr);
void FollowPathConstraint_up_axis_set(PointerRNA *ptr, int value);

/**************** Follow Track Constraint ****************/

extern StructRNA RNA_FollowTrackConstraint;
extern StructRNA RNA_Constraint;

bool FollowTrackConstraint_use_3d_position_get(PointerRNA *ptr);
void FollowTrackConstraint_use_3d_position_set(PointerRNA *ptr, bool value);

bool FollowTrackConstraint_use_active_clip_get(PointerRNA *ptr);
void FollowTrackConstraint_use_active_clip_set(PointerRNA *ptr, bool value);

PointerRNA FollowTrackConstraint_camera_get(PointerRNA *ptr);

PointerRNA FollowTrackConstraint_depth_object_get(PointerRNA *ptr);

enum {
	FollowTrackConstraint_frame_method_STRETCH = 0,
	FollowTrackConstraint_frame_method_FIT = 1,
	FollowTrackConstraint_frame_method_CROP = 2,
};

int FollowTrackConstraint_frame_method_get(PointerRNA *ptr);
void FollowTrackConstraint_frame_method_set(PointerRNA *ptr, int value);

PointerRNA FollowTrackConstraint_clip_get(PointerRNA *ptr);

#define FollowTrackConstraint_object_MAX 64

void FollowTrackConstraint_object_get(PointerRNA *ptr, char *value);
int FollowTrackConstraint_object_length(PointerRNA *ptr);
void FollowTrackConstraint_object_set(PointerRNA *ptr, const char *value);

#define FollowTrackConstraint_track_MAX 64

void FollowTrackConstraint_track_get(PointerRNA *ptr, char *value);
int FollowTrackConstraint_track_length(PointerRNA *ptr);
void FollowTrackConstraint_track_set(PointerRNA *ptr, const char *value);

bool FollowTrackConstraint_use_undistorted_position_get(PointerRNA *ptr);
void FollowTrackConstraint_use_undistorted_position_set(PointerRNA *ptr, bool value);

/**************** For Each Geometry Element Item ****************/

extern StructRNA RNA_ForeachGeometryElementGenerationItem;

PointerRNA ForeachGeometryElementGenerationItem_rna_type_get(PointerRNA *ptr);

void ForeachGeometryElementGenerationItem_name_get(PointerRNA *ptr, char *value);
int ForeachGeometryElementGenerationItem_name_length(PointerRNA *ptr);
void ForeachGeometryElementGenerationItem_name_set(PointerRNA *ptr, const char *value);

void ForeachGeometryElementGenerationItem_color_get(PointerRNA *ptr, float values[4]);
void ForeachGeometryElementGenerationItem_color_set(PointerRNA *ptr, const float values[4]);

enum {
	ForeachGeometryElementGenerationItem_domain_POINT = 0,
	ForeachGeometryElementGenerationItem_domain_EDGE = 1,
	ForeachGeometryElementGenerationItem_domain_FACE = 2,
	ForeachGeometryElementGenerationItem_domain_CORNER = 3,
	ForeachGeometryElementGenerationItem_domain_CURVE = 4,
	ForeachGeometryElementGenerationItem_domain_INSTANCE = 5,
	ForeachGeometryElementGenerationItem_domain_LAYER = 6,
};

int ForeachGeometryElementGenerationItem_domain_get(PointerRNA *ptr);
void ForeachGeometryElementGenerationItem_domain_set(PointerRNA *ptr, int value);

enum {
	ForeachGeometryElementGenerationItem_socket_type_FLOAT = 0,
	ForeachGeometryElementGenerationItem_socket_type_INT = 6,
	ForeachGeometryElementGenerationItem_socket_type_BOOLEAN = 4,
	ForeachGeometryElementGenerationItem_socket_type_VECTOR = 1,
	ForeachGeometryElementGenerationItem_socket_type_RGBA = 2,
	ForeachGeometryElementGenerationItem_socket_type_ROTATION = 14,
	ForeachGeometryElementGenerationItem_socket_type_MATRIX = 16,
	ForeachGeometryElementGenerationItem_socket_type_STRING = 7,
	ForeachGeometryElementGenerationItem_socket_type_MENU = 15,
	ForeachGeometryElementGenerationItem_socket_type_SHADER = 3,
	ForeachGeometryElementGenerationItem_socket_type_OBJECT = 8,
	ForeachGeometryElementGenerationItem_socket_type_IMAGE = 9,
	ForeachGeometryElementGenerationItem_socket_type_GEOMETRY = 10,
	ForeachGeometryElementGenerationItem_socket_type_COLLECTION = 11,
	ForeachGeometryElementGenerationItem_socket_type_TEXTURE = 12,
	ForeachGeometryElementGenerationItem_socket_type_MATERIAL = 13,
	ForeachGeometryElementGenerationItem_socket_type_BUNDLE = 17,
	ForeachGeometryElementGenerationItem_socket_type_CLOSURE = 18,
};

int ForeachGeometryElementGenerationItem_socket_type_get(PointerRNA *ptr);
void ForeachGeometryElementGenerationItem_socket_type_set(PointerRNA *ptr, int value);

/**************** For Each Geometry Element Item ****************/

extern StructRNA RNA_ForeachGeometryElementInputItem;

PointerRNA ForeachGeometryElementInputItem_rna_type_get(PointerRNA *ptr);

void ForeachGeometryElementInputItem_name_get(PointerRNA *ptr, char *value);
int ForeachGeometryElementInputItem_name_length(PointerRNA *ptr);
void ForeachGeometryElementInputItem_name_set(PointerRNA *ptr, const char *value);

void ForeachGeometryElementInputItem_color_get(PointerRNA *ptr, float values[4]);
void ForeachGeometryElementInputItem_color_set(PointerRNA *ptr, const float values[4]);

enum {
	ForeachGeometryElementInputItem_socket_type_FLOAT = 0,
	ForeachGeometryElementInputItem_socket_type_INT = 6,
	ForeachGeometryElementInputItem_socket_type_BOOLEAN = 4,
	ForeachGeometryElementInputItem_socket_type_VECTOR = 1,
	ForeachGeometryElementInputItem_socket_type_RGBA = 2,
	ForeachGeometryElementInputItem_socket_type_ROTATION = 14,
	ForeachGeometryElementInputItem_socket_type_MATRIX = 16,
	ForeachGeometryElementInputItem_socket_type_STRING = 7,
	ForeachGeometryElementInputItem_socket_type_MENU = 15,
	ForeachGeometryElementInputItem_socket_type_SHADER = 3,
	ForeachGeometryElementInputItem_socket_type_OBJECT = 8,
	ForeachGeometryElementInputItem_socket_type_IMAGE = 9,
	ForeachGeometryElementInputItem_socket_type_GEOMETRY = 10,
	ForeachGeometryElementInputItem_socket_type_COLLECTION = 11,
	ForeachGeometryElementInputItem_socket_type_TEXTURE = 12,
	ForeachGeometryElementInputItem_socket_type_MATERIAL = 13,
	ForeachGeometryElementInputItem_socket_type_BUNDLE = 17,
	ForeachGeometryElementInputItem_socket_type_CLOSURE = 18,
};

int ForeachGeometryElementInputItem_socket_type_get(PointerRNA *ptr);
void ForeachGeometryElementInputItem_socket_type_set(PointerRNA *ptr, int value);

/**************** For Each Geometry Element Item ****************/

extern StructRNA RNA_ForeachGeometryElementMainItem;

PointerRNA ForeachGeometryElementMainItem_rna_type_get(PointerRNA *ptr);

void ForeachGeometryElementMainItem_name_get(PointerRNA *ptr, char *value);
int ForeachGeometryElementMainItem_name_length(PointerRNA *ptr);
void ForeachGeometryElementMainItem_name_set(PointerRNA *ptr, const char *value);

void ForeachGeometryElementMainItem_color_get(PointerRNA *ptr, float values[4]);
void ForeachGeometryElementMainItem_color_set(PointerRNA *ptr, const float values[4]);

enum {
	ForeachGeometryElementMainItem_socket_type_FLOAT = 0,
	ForeachGeometryElementMainItem_socket_type_INT = 6,
	ForeachGeometryElementMainItem_socket_type_BOOLEAN = 4,
	ForeachGeometryElementMainItem_socket_type_VECTOR = 1,
	ForeachGeometryElementMainItem_socket_type_RGBA = 2,
	ForeachGeometryElementMainItem_socket_type_ROTATION = 14,
	ForeachGeometryElementMainItem_socket_type_MATRIX = 16,
	ForeachGeometryElementMainItem_socket_type_STRING = 7,
	ForeachGeometryElementMainItem_socket_type_MENU = 15,
	ForeachGeometryElementMainItem_socket_type_SHADER = 3,
	ForeachGeometryElementMainItem_socket_type_OBJECT = 8,
	ForeachGeometryElementMainItem_socket_type_IMAGE = 9,
	ForeachGeometryElementMainItem_socket_type_GEOMETRY = 10,
	ForeachGeometryElementMainItem_socket_type_COLLECTION = 11,
	ForeachGeometryElementMainItem_socket_type_TEXTURE = 12,
	ForeachGeometryElementMainItem_socket_type_MATERIAL = 13,
	ForeachGeometryElementMainItem_socket_type_BUNDLE = 17,
	ForeachGeometryElementMainItem_socket_type_CLOSURE = 18,
};

int ForeachGeometryElementMainItem_socket_type_get(PointerRNA *ptr);
void ForeachGeometryElementMainItem_socket_type_set(PointerRNA *ptr, int value);

/**************** ForeachGeometryElementZoneViewerPathElem ****************/

extern StructRNA RNA_ForeachGeometryElementZoneViewerPathElem;
extern StructRNA RNA_ViewerPathElem;

int ForeachGeometryElementZoneViewerPathElem_zone_output_node_id_get(PointerRNA *ptr);
void ForeachGeometryElementZoneViewerPathElem_zone_output_node_id_set(PointerRNA *ptr, int value);

/**************** Freestyle Line Set ****************/

extern StructRNA RNA_FreestyleLineSet;

PointerRNA FreestyleLineSet_rna_type_get(PointerRNA *ptr);

#define FreestyleLineSet_name_MAX 64

void FreestyleLineSet_name_get(PointerRNA *ptr, char *value);
int FreestyleLineSet_name_length(PointerRNA *ptr);
void FreestyleLineSet_name_set(PointerRNA *ptr, const char *value);

bool FreestyleLineSet_select_border_get(PointerRNA *ptr);
void FreestyleLineSet_select_border_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_border_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_border_set(PointerRNA *ptr, bool value);

PointerRNA FreestyleLineSet_collection_get(PointerRNA *ptr);

enum {
	FreestyleLineSet_collection_negation_INCLUSIVE = 0,
	FreestyleLineSet_collection_negation_EXCLUSIVE = 16,
};

int FreestyleLineSet_collection_negation_get(PointerRNA *ptr);
void FreestyleLineSet_collection_negation_set(PointerRNA *ptr, int value);

bool FreestyleLineSet_select_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_contour_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_contour_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_crease_get(PointerRNA *ptr);
void FreestyleLineSet_select_crease_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_crease_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_crease_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_edge_mark_get(PointerRNA *ptr);
void FreestyleLineSet_select_edge_mark_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_edge_mark_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_edge_mark_set(PointerRNA *ptr, bool value);

enum {
	FreestyleLineSet_edge_type_combination_OR = 0,
	FreestyleLineSet_edge_type_combination_AND = 8,
};

int FreestyleLineSet_edge_type_combination_get(PointerRNA *ptr);
void FreestyleLineSet_edge_type_combination_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_edge_type_negation_INCLUSIVE = 0,
	FreestyleLineSet_edge_type_negation_EXCLUSIVE = 4,
};

int FreestyleLineSet_edge_type_negation_get(PointerRNA *ptr);
void FreestyleLineSet_edge_type_negation_set(PointerRNA *ptr, int value);

int FreestyleLineSet_qi_end_get(PointerRNA *ptr);
void FreestyleLineSet_qi_end_set(PointerRNA *ptr, int value);

bool FreestyleLineSet_select_external_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_external_contour_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_external_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_external_contour_set(PointerRNA *ptr, bool value);

enum {
	FreestyleLineSet_face_mark_condition_ONE = 0,
	FreestyleLineSet_face_mark_condition_BOTH = 64,
};

int FreestyleLineSet_face_mark_condition_get(PointerRNA *ptr);
void FreestyleLineSet_face_mark_condition_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineSet_face_mark_negation_INCLUSIVE = 0,
	FreestyleLineSet_face_mark_negation_EXCLUSIVE = 32,
};

int FreestyleLineSet_face_mark_negation_get(PointerRNA *ptr);
void FreestyleLineSet_face_mark_negation_set(PointerRNA *ptr, int value);

PointerRNA FreestyleLineSet_linestyle_get(PointerRNA *ptr);

bool FreestyleLineSet_select_material_boundary_get(PointerRNA *ptr);
void FreestyleLineSet_select_material_boundary_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_material_boundary_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_material_boundary_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_show_render_get(PointerRNA *ptr);
void FreestyleLineSet_show_render_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_ridge_valley_get(PointerRNA *ptr);
void FreestyleLineSet_select_ridge_valley_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_ridge_valley_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_ridge_valley_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_by_collection_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_collection_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_by_edge_types_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_edge_types_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_by_face_marks_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_face_marks_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_by_image_border_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_image_border_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_by_visibility_get(PointerRNA *ptr);
void FreestyleLineSet_select_by_visibility_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_select_silhouette_get(PointerRNA *ptr);
void FreestyleLineSet_select_silhouette_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_silhouette_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_silhouette_set(PointerRNA *ptr, bool value);

int FreestyleLineSet_qi_start_get(PointerRNA *ptr);
void FreestyleLineSet_qi_start_set(PointerRNA *ptr, int value);

bool FreestyleLineSet_select_suggestive_contour_get(PointerRNA *ptr);
void FreestyleLineSet_select_suggestive_contour_set(PointerRNA *ptr, bool value);

bool FreestyleLineSet_exclude_suggestive_contour_get(PointerRNA *ptr);
void FreestyleLineSet_exclude_suggestive_contour_set(PointerRNA *ptr, bool value);

enum {
	FreestyleLineSet_visibility_VISIBLE = 1,
	FreestyleLineSet_visibility_HIDDEN = 2,
	FreestyleLineSet_visibility_RANGE = 3,
};

int FreestyleLineSet_visibility_get(PointerRNA *ptr);
void FreestyleLineSet_visibility_set(PointerRNA *ptr, int value);

/**************** Freestyle Line Style ****************/

extern StructRNA RNA_FreestyleLineStyle;
extern StructRNA RNA_ID;

PointerRNA FreestyleLineStyle_active_texture_get(PointerRNA *ptr);

int FreestyleLineStyle_active_texture_index_get(PointerRNA *ptr);
void FreestyleLineStyle_active_texture_index_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_alpha_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_alpha_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_alpha_modifiers_end(CollectionPropertyIterator *iter);
bool FreestyleLineStyle_alpha_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FreestyleLineStyle_alpha_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float FreestyleLineStyle_alpha_get(PointerRNA *ptr);
void FreestyleLineStyle_alpha_set(PointerRNA *ptr, float value);

PointerRNA FreestyleLineStyle_animation_data_get(PointerRNA *ptr);

enum {
	FreestyleLineStyle_caps_BUTT = 1,
	FreestyleLineStyle_caps_ROUND = 2,
	FreestyleLineStyle_caps_SQUARE = 3,
};

int FreestyleLineStyle_caps_get(PointerRNA *ptr);
void FreestyleLineStyle_caps_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_chain_count_get(PointerRNA *ptr);
void FreestyleLineStyle_chain_count_set(PointerRNA *ptr, int value);

bool FreestyleLineStyle_use_chaining_get(PointerRNA *ptr);
void FreestyleLineStyle_use_chaining_set(PointerRNA *ptr, bool value);

enum {
	FreestyleLineStyle_chaining_PLAIN = 1,
	FreestyleLineStyle_chaining_SKETCHY = 2,
};

int FreestyleLineStyle_chaining_get(PointerRNA *ptr);
void FreestyleLineStyle_chaining_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_color_get(PointerRNA *ptr, float values[3]);
void FreestyleLineStyle_color_set(PointerRNA *ptr, const float values[3]);

void FreestyleLineStyle_color_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_color_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_color_modifiers_end(CollectionPropertyIterator *iter);
bool FreestyleLineStyle_color_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FreestyleLineStyle_color_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int FreestyleLineStyle_dash1_get(PointerRNA *ptr);
void FreestyleLineStyle_dash1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_dash2_get(PointerRNA *ptr);
void FreestyleLineStyle_dash2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_dash3_get(PointerRNA *ptr);
void FreestyleLineStyle_dash3_set(PointerRNA *ptr, int value);

bool FreestyleLineStyle_use_dashed_line_get(PointerRNA *ptr);
void FreestyleLineStyle_use_dashed_line_set(PointerRNA *ptr, bool value);

int FreestyleLineStyle_gap1_get(PointerRNA *ptr);
void FreestyleLineStyle_gap1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_gap2_get(PointerRNA *ptr);
void FreestyleLineStyle_gap2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_gap3_get(PointerRNA *ptr);
void FreestyleLineStyle_gap3_set(PointerRNA *ptr, int value);

void FreestyleLineStyle_geometry_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_geometry_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_geometry_modifiers_end(CollectionPropertyIterator *iter);
bool FreestyleLineStyle_geometry_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FreestyleLineStyle_geometry_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	FreestyleLineStyle_integration_type_MEAN = 1,
	FreestyleLineStyle_integration_type_MIN = 2,
	FreestyleLineStyle_integration_type_MAX = 3,
	FreestyleLineStyle_integration_type_FIRST = 4,
	FreestyleLineStyle_integration_type_LAST = 5,
};

int FreestyleLineStyle_integration_type_get(PointerRNA *ptr);
void FreestyleLineStyle_integration_type_set(PointerRNA *ptr, int value);

bool FreestyleLineStyle_material_boundary_get(PointerRNA *ptr);
void FreestyleLineStyle_material_boundary_set(PointerRNA *ptr, bool value);

float FreestyleLineStyle_angle_max_get(PointerRNA *ptr);
void FreestyleLineStyle_angle_max_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_length_max_get(PointerRNA *ptr);
void FreestyleLineStyle_length_max_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_angle_min_get(PointerRNA *ptr);
void FreestyleLineStyle_angle_min_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_length_min_get(PointerRNA *ptr);
void FreestyleLineStyle_length_min_set(PointerRNA *ptr, float value);

PointerRNA FreestyleLineStyle_node_tree_get(PointerRNA *ptr);

enum {
	FreestyleLineStyle_panel_STROKES = 1,
	FreestyleLineStyle_panel_COLOR = 2,
	FreestyleLineStyle_panel_ALPHA = 3,
	FreestyleLineStyle_panel_THICKNESS = 4,
	FreestyleLineStyle_panel_GEOMETRY = 5,
	FreestyleLineStyle_panel_TEXTURE = 6,
};

int FreestyleLineStyle_panel_get(PointerRNA *ptr);
void FreestyleLineStyle_panel_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_rounds_get(PointerRNA *ptr);
void FreestyleLineStyle_rounds_set(PointerRNA *ptr, int value);

bool FreestyleLineStyle_use_same_object_get(PointerRNA *ptr);
void FreestyleLineStyle_use_same_object_set(PointerRNA *ptr, bool value);

enum {
	FreestyleLineStyle_sort_key_DISTANCE_FROM_CAMERA = 1,
	FreestyleLineStyle_sort_key_2D_LENGTH = 2,
	FreestyleLineStyle_sort_key_PROJECTED_X = 3,
	FreestyleLineStyle_sort_key_PROJECTED_Y = 4,
};

int FreestyleLineStyle_sort_key_get(PointerRNA *ptr);
void FreestyleLineStyle_sort_key_set(PointerRNA *ptr, int value);

enum {
	FreestyleLineStyle_sort_order_DEFAULT = 0,
	FreestyleLineStyle_sort_order_REVERSE = 4096,
};

int FreestyleLineStyle_sort_order_get(PointerRNA *ptr);
void FreestyleLineStyle_sort_order_set(PointerRNA *ptr, int value);

bool FreestyleLineStyle_use_sorting_get(PointerRNA *ptr);
void FreestyleLineStyle_use_sorting_set(PointerRNA *ptr, bool value);

int FreestyleLineStyle_split_dash1_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_dash2_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_dash3_get(PointerRNA *ptr);
void FreestyleLineStyle_split_dash3_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap1_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap1_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap2_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap2_set(PointerRNA *ptr, int value);

int FreestyleLineStyle_split_gap3_get(PointerRNA *ptr);
void FreestyleLineStyle_split_gap3_set(PointerRNA *ptr, int value);

float FreestyleLineStyle_split_length_get(PointerRNA *ptr);
void FreestyleLineStyle_split_length_set(PointerRNA *ptr, float value);

float FreestyleLineStyle_texture_spacing_get(PointerRNA *ptr);
void FreestyleLineStyle_texture_spacing_set(PointerRNA *ptr, float value);

void FreestyleLineStyle_texture_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_texture_slots_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_texture_slots_end(CollectionPropertyIterator *iter);

float FreestyleLineStyle_thickness_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_set(PointerRNA *ptr, float value);

void FreestyleLineStyle_thickness_modifiers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleLineStyle_thickness_modifiers_next(CollectionPropertyIterator *iter);
void FreestyleLineStyle_thickness_modifiers_end(CollectionPropertyIterator *iter);
bool FreestyleLineStyle_thickness_modifiers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FreestyleLineStyle_thickness_modifiers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	FreestyleLineStyle_thickness_position_CENTER = 1,
	FreestyleLineStyle_thickness_position_INSIDE = 2,
	FreestyleLineStyle_thickness_position_OUTSIDE = 3,
	FreestyleLineStyle_thickness_position_RELATIVE = 4,
};

int FreestyleLineStyle_thickness_position_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_position_set(PointerRNA *ptr, int value);

float FreestyleLineStyle_thickness_ratio_get(PointerRNA *ptr);
void FreestyleLineStyle_thickness_ratio_set(PointerRNA *ptr, float value);

bool FreestyleLineStyle_use_chain_count_get(PointerRNA *ptr);
void FreestyleLineStyle_use_chain_count_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_angle_max_get(PointerRNA *ptr);
void FreestyleLineStyle_use_angle_max_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_length_max_get(PointerRNA *ptr);
void FreestyleLineStyle_use_length_max_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_angle_min_get(PointerRNA *ptr);
void FreestyleLineStyle_use_angle_min_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_length_min_get(PointerRNA *ptr);
void FreestyleLineStyle_use_length_min_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_nodes_get(PointerRNA *ptr);
void FreestyleLineStyle_use_nodes_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_split_length_get(PointerRNA *ptr);
void FreestyleLineStyle_use_split_length_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_split_pattern_get(PointerRNA *ptr);
void FreestyleLineStyle_use_split_pattern_set(PointerRNA *ptr, bool value);

bool FreestyleLineStyle_use_texture_get(PointerRNA *ptr);
void FreestyleLineStyle_use_texture_set(PointerRNA *ptr, bool value);

/**************** Freestyle Module ****************/

extern StructRNA RNA_FreestyleModuleSettings;

PointerRNA FreestyleModuleSettings_rna_type_get(PointerRNA *ptr);

PointerRNA FreestyleModuleSettings_script_get(PointerRNA *ptr);

bool FreestyleModuleSettings_use_get(PointerRNA *ptr);
void FreestyleModuleSettings_use_set(PointerRNA *ptr, bool value);

/**************** Style Modules ****************/

extern StructRNA RNA_FreestyleModules;

PointerRNA FreestyleModules_rna_type_get(PointerRNA *ptr);

struct FreestyleModuleConfig *FreestyleModules_new_func(struct ID *_selfid, struct FreestyleSettings *_self);
void FreestyleModules_remove_func(struct ID *_selfid, struct FreestyleSettings *_self, ReportList *reports, struct PointerRNA *module);
/**************** Freestyle Settings ****************/

extern StructRNA RNA_FreestyleSettings;

PointerRNA FreestyleSettings_rna_type_get(PointerRNA *ptr);

bool FreestyleSettings_as_render_pass_get(PointerRNA *ptr);
void FreestyleSettings_as_render_pass_set(PointerRNA *ptr, bool value);

enum {
	FreestyleSettings_mode_SCRIPT = 1,
	FreestyleSettings_mode_EDITOR = 2,
};

int FreestyleSettings_mode_get(PointerRNA *ptr);
void FreestyleSettings_mode_set(PointerRNA *ptr, int value);

float FreestyleSettings_crease_angle_get(PointerRNA *ptr);
void FreestyleSettings_crease_angle_set(PointerRNA *ptr, float value);

bool FreestyleSettings_use_culling_get(PointerRNA *ptr);
void FreestyleSettings_use_culling_set(PointerRNA *ptr, bool value);

bool FreestyleSettings_use_smoothness_get(PointerRNA *ptr);
void FreestyleSettings_use_smoothness_set(PointerRNA *ptr, bool value);

float FreestyleSettings_kr_derivative_epsilon_get(PointerRNA *ptr);
void FreestyleSettings_kr_derivative_epsilon_set(PointerRNA *ptr, float value);

void FreestyleSettings_linesets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleSettings_linesets_next(CollectionPropertyIterator *iter);
void FreestyleSettings_linesets_end(CollectionPropertyIterator *iter);
bool FreestyleSettings_linesets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FreestyleSettings_linesets_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool FreestyleSettings_use_material_boundaries_get(PointerRNA *ptr);
void FreestyleSettings_use_material_boundaries_set(PointerRNA *ptr, bool value);

bool FreestyleSettings_use_ridges_and_valleys_get(PointerRNA *ptr);
void FreestyleSettings_use_ridges_and_valleys_set(PointerRNA *ptr, bool value);

float FreestyleSettings_sphere_radius_get(PointerRNA *ptr);
void FreestyleSettings_sphere_radius_set(PointerRNA *ptr, float value);

void FreestyleSettings_modules_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FreestyleSettings_modules_next(CollectionPropertyIterator *iter);
void FreestyleSettings_modules_end(CollectionPropertyIterator *iter);
bool FreestyleSettings_modules_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool FreestyleSettings_use_suggestive_contours_get(PointerRNA *ptr);
void FreestyleSettings_use_suggestive_contours_set(PointerRNA *ptr, bool value);

bool FreestyleSettings_use_view_map_cache_get(PointerRNA *ptr);
void FreestyleSettings_use_view_map_cache_set(PointerRNA *ptr, bool value);

/**************** Function Definition ****************/

extern StructRNA RNA_Function;

PointerRNA Function_rna_type_get(PointerRNA *ptr);

void Function_description_get(PointerRNA *ptr, char *value);
int Function_description_length(PointerRNA *ptr);
void Function_description_set(PointerRNA *ptr, const char *value);

void Function_identifier_get(PointerRNA *ptr, char *value);
int Function_identifier_length(PointerRNA *ptr);
void Function_identifier_set(PointerRNA *ptr, const char *value);

bool Function_use_self_get(PointerRNA *ptr);
void Function_use_self_set(PointerRNA *ptr, bool value);

void Function_parameters_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Function_parameters_next(CollectionPropertyIterator *iter);
void Function_parameters_end(CollectionPropertyIterator *iter);

bool Function_is_registered_get(PointerRNA *ptr);
void Function_is_registered_set(PointerRNA *ptr, bool value);

bool Function_is_registered_optional_get(PointerRNA *ptr);
void Function_is_registered_optional_set(PointerRNA *ptr, bool value);

bool Function_use_self_type_get(PointerRNA *ptr);
void Function_use_self_type_set(PointerRNA *ptr, bool value);

/**************** Function Node ****************/

extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

/**************** FunctionNodeAlignEulerToVector ****************/

extern StructRNA RNA_FunctionNodeAlignEulerToVector;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeAlignEulerToVector_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeAlignEulerToVector_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeAlignEulerToVector_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeAlignRotationToVector ****************/

extern StructRNA RNA_FunctionNodeAlignRotationToVector;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeAlignRotationToVector_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeAlignRotationToVector_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeAlignRotationToVector_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeAxesToRotation ****************/

extern StructRNA RNA_FunctionNodeAxesToRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeAxesToRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeAxesToRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeAxesToRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeAxisAngleToRotation ****************/

extern StructRNA RNA_FunctionNodeAxisAngleToRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeAxisAngleToRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeAxisAngleToRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeAxisAngleToRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeBitMath ****************/

extern StructRNA RNA_FunctionNodeBitMath;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeBitMath_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeBitMath_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeBitMath_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeBooleanMath ****************/

extern StructRNA RNA_FunctionNodeBooleanMath;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeBooleanMath_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeBooleanMath_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeBooleanMath_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeCombineColor ****************/

extern StructRNA RNA_FunctionNodeCombineColor;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeCombineColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeCombineColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeCombineColor_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeCombineMatrix ****************/

extern StructRNA RNA_FunctionNodeCombineMatrix;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeCombineMatrix_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeCombineMatrix_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeCombineMatrix_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeCombineTransform ****************/

extern StructRNA RNA_FunctionNodeCombineTransform;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeCombineTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeCombineTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeCombineTransform_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeCompare ****************/

extern StructRNA RNA_FunctionNodeCompare;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeCompare_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeCompare_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeCompare_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeEulerToRotation ****************/

extern StructRNA RNA_FunctionNodeEulerToRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeEulerToRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeEulerToRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeEulerToRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeFindInString ****************/

extern StructRNA RNA_FunctionNodeFindInString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeFindInString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeFindInString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeFindInString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeFloatToInt ****************/

extern StructRNA RNA_FunctionNodeFloatToInt;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	FunctionNodeFloatToInt_rounding_mode_ROUND = 0,
	FunctionNodeFloatToInt_rounding_mode_FLOOR = 1,
	FunctionNodeFloatToInt_rounding_mode_CEILING = 2,
	FunctionNodeFloatToInt_rounding_mode_TRUNCATE = 3,
};

int FunctionNodeFloatToInt_rounding_mode_get(PointerRNA *ptr);
void FunctionNodeFloatToInt_rounding_mode_set(PointerRNA *ptr, int value);

bool FunctionNodeFloatToInt_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeFloatToInt_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeFloatToInt_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeFormatString ****************/

extern StructRNA RNA_FunctionNodeFormatString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int FunctionNodeFormatString_active_index_get(PointerRNA *ptr);
void FunctionNodeFormatString_active_index_set(PointerRNA *ptr, int value);

void FunctionNodeFormatString_format_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void FunctionNodeFormatString_format_items_next(CollectionPropertyIterator *iter);
void FunctionNodeFormatString_format_items_end(CollectionPropertyIterator *iter);
int FunctionNodeFormatString_format_items_length(PointerRNA *ptr);
bool FunctionNodeFormatString_format_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool FunctionNodeFormatString_format_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool FunctionNodeFormatString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeFormatString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeFormatString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeHashValue ****************/

extern StructRNA RNA_FunctionNodeHashValue;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeHashValue_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeHashValue_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeHashValue_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputBool ****************/

extern StructRNA RNA_FunctionNodeInputBool;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeInputBool_boolean_get(PointerRNA *ptr);
void FunctionNodeInputBool_boolean_set(PointerRNA *ptr, bool value);

bool FunctionNodeInputBool_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputBool_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputBool_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputColor ****************/

extern StructRNA RNA_FunctionNodeInputColor;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void FunctionNodeInputColor_value_get(PointerRNA *ptr, float values[4]);
void FunctionNodeInputColor_value_set(PointerRNA *ptr, const float values[4]);

bool FunctionNodeInputColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputColor_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputInt ****************/

extern StructRNA RNA_FunctionNodeInputInt;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int FunctionNodeInputInt_integer_get(PointerRNA *ptr);
void FunctionNodeInputInt_integer_set(PointerRNA *ptr, int value);

bool FunctionNodeInputInt_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputInt_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputInt_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputRotation ****************/

extern StructRNA RNA_FunctionNodeInputRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void FunctionNodeInputRotation_rotation_euler_get(PointerRNA *ptr, float values[3]);
void FunctionNodeInputRotation_rotation_euler_set(PointerRNA *ptr, const float values[3]);

bool FunctionNodeInputRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputSpecialCharacters ****************/

extern StructRNA RNA_FunctionNodeInputSpecialCharacters;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeInputSpecialCharacters_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputSpecialCharacters_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputSpecialCharacters_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputString ****************/

extern StructRNA RNA_FunctionNodeInputString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void FunctionNodeInputString_string_get(PointerRNA *ptr, char *value);
int FunctionNodeInputString_string_length(PointerRNA *ptr);
void FunctionNodeInputString_string_set(PointerRNA *ptr, const char *value);

bool FunctionNodeInputString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInputVector ****************/

extern StructRNA RNA_FunctionNodeInputVector;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void FunctionNodeInputVector_vector_get(PointerRNA *ptr, float values[3]);
void FunctionNodeInputVector_vector_set(PointerRNA *ptr, const float values[3]);

bool FunctionNodeInputVector_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInputVector_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInputVector_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeIntegerMath ****************/

extern StructRNA RNA_FunctionNodeIntegerMath;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeIntegerMath_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeIntegerMath_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeIntegerMath_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInvertMatrix ****************/

extern StructRNA RNA_FunctionNodeInvertMatrix;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeInvertMatrix_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInvertMatrix_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInvertMatrix_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeInvertRotation ****************/

extern StructRNA RNA_FunctionNodeInvertRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeInvertRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeInvertRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeInvertRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeMatchString ****************/

extern StructRNA RNA_FunctionNodeMatchString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeMatchString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeMatchString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeMatchString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeMatrixDeterminant ****************/

extern StructRNA RNA_FunctionNodeMatrixDeterminant;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeMatrixDeterminant_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeMatrixDeterminant_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeMatrixDeterminant_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeMatrixMultiply ****************/

extern StructRNA RNA_FunctionNodeMatrixMultiply;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeMatrixMultiply_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeMatrixMultiply_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeMatrixMultiply_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeProjectPoint ****************/

extern StructRNA RNA_FunctionNodeProjectPoint;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeProjectPoint_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeProjectPoint_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeProjectPoint_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeQuaternionToRotation ****************/

extern StructRNA RNA_FunctionNodeQuaternionToRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeQuaternionToRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeQuaternionToRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeQuaternionToRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRandomValue ****************/

extern StructRNA RNA_FunctionNodeRandomValue;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	FunctionNodeRandomValue_data_type_FLOAT = 10,
	FunctionNodeRandomValue_data_type_INT = 11,
	FunctionNodeRandomValue_data_type_BOOLEAN = 50,
	FunctionNodeRandomValue_data_type_FLOAT_VECTOR = 48,
	FunctionNodeRandomValue_data_type_FLOAT_COLOR = 47,
	FunctionNodeRandomValue_data_type_QUATERNION = 52,
	FunctionNodeRandomValue_data_type_FLOAT4X4 = 20,
	FunctionNodeRandomValue_data_type_STRING = 12,
	FunctionNodeRandomValue_data_type_INT8 = 45,
	FunctionNodeRandomValue_data_type_INT16_2D = 22,
	FunctionNodeRandomValue_data_type_INT32_2D = 46,
	FunctionNodeRandomValue_data_type_FLOAT2 = 49,
	FunctionNodeRandomValue_data_type_BYTE_COLOR = 17,
};

int FunctionNodeRandomValue_data_type_get(PointerRNA *ptr);
void FunctionNodeRandomValue_data_type_set(PointerRNA *ptr, int value);

bool FunctionNodeRandomValue_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRandomValue_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRandomValue_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeReplaceString ****************/

extern StructRNA RNA_FunctionNodeReplaceString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeReplaceString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeReplaceString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeReplaceString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotateEuler ****************/

extern StructRNA RNA_FunctionNodeRotateEuler;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	FunctionNodeRotateEuler_space_OBJECT = 0,
	FunctionNodeRotateEuler_space_LOCAL = 1,
};

int FunctionNodeRotateEuler_space_get(PointerRNA *ptr);
void FunctionNodeRotateEuler_space_set(PointerRNA *ptr, int value);

enum {
	FunctionNodeRotateEuler_rotation_type_AXIS_ANGLE = 1,
	FunctionNodeRotateEuler_rotation_type_EULER = 0,
};

int FunctionNodeRotateEuler_rotation_type_get(PointerRNA *ptr);
void FunctionNodeRotateEuler_rotation_type_set(PointerRNA *ptr, int value);

bool FunctionNodeRotateEuler_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotateEuler_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotateEuler_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotateRotation ****************/

extern StructRNA RNA_FunctionNodeRotateRotation;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeRotateRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotateRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotateRotation_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotateVector ****************/

extern StructRNA RNA_FunctionNodeRotateVector;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeRotateVector_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotateVector_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotateVector_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotationToAxisAngle ****************/

extern StructRNA RNA_FunctionNodeRotationToAxisAngle;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeRotationToAxisAngle_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotationToAxisAngle_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotationToAxisAngle_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotationToEuler ****************/

extern StructRNA RNA_FunctionNodeRotationToEuler;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeRotationToEuler_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotationToEuler_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotationToEuler_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeRotationToQuaternion ****************/

extern StructRNA RNA_FunctionNodeRotationToQuaternion;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeRotationToQuaternion_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeRotationToQuaternion_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeRotationToQuaternion_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeSeparateColor ****************/

extern StructRNA RNA_FunctionNodeSeparateColor;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeSeparateColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeSeparateColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeSeparateColor_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeSeparateMatrix ****************/

extern StructRNA RNA_FunctionNodeSeparateMatrix;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeSeparateMatrix_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeSeparateMatrix_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeSeparateMatrix_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeSeparateTransform ****************/

extern StructRNA RNA_FunctionNodeSeparateTransform;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeSeparateTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeSeparateTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeSeparateTransform_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeSliceString ****************/

extern StructRNA RNA_FunctionNodeSliceString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeSliceString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeSliceString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeSliceString_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeStringLength ****************/

extern StructRNA RNA_FunctionNodeStringLength;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeStringLength_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeStringLength_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeStringLength_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeStringToValue ****************/

extern StructRNA RNA_FunctionNodeStringToValue;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeStringToValue_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeStringToValue_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeStringToValue_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeTransformDirection ****************/

extern StructRNA RNA_FunctionNodeTransformDirection;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeTransformDirection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeTransformDirection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeTransformDirection_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeTransformPoint ****************/

extern StructRNA RNA_FunctionNodeTransformPoint;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeTransformPoint_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeTransformPoint_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeTransformPoint_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeTransposeMatrix ****************/

extern StructRNA RNA_FunctionNodeTransposeMatrix;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeTransposeMatrix_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeTransposeMatrix_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeTransposeMatrix_output_template_func(struct StructRNA *_type, int index);
/**************** FunctionNodeValueToString ****************/

extern StructRNA RNA_FunctionNodeValueToString;
extern StructRNA RNA_FunctionNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool FunctionNodeValueToString_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA FunctionNodeValueToString_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA FunctionNodeValueToString_output_template_func(struct StructRNA *_type, int index);
/**************** Grease Pencil Interpolate Settings ****************/

extern StructRNA RNA_GPencilInterpolateSettings;

PointerRNA GPencilInterpolateSettings_rna_type_get(PointerRNA *ptr);

PointerRNA GPencilInterpolateSettings_interpolation_curve_get(PointerRNA *ptr);

/**************** Grease Pencil Sculpt Guide ****************/

extern StructRNA RNA_GPencilSculptGuide;

PointerRNA GPencilSculptGuide_rna_type_get(PointerRNA *ptr);

float GPencilSculptGuide_angle_get(PointerRNA *ptr);
void GPencilSculptGuide_angle_set(PointerRNA *ptr, float value);

float GPencilSculptGuide_angle_snap_get(PointerRNA *ptr);
void GPencilSculptGuide_angle_snap_set(PointerRNA *ptr, float value);

void GPencilSculptGuide_location_get(PointerRNA *ptr, float values[3]);
void GPencilSculptGuide_location_set(PointerRNA *ptr, const float values[3]);

PointerRNA GPencilSculptGuide_reference_object_get(PointerRNA *ptr);

float GPencilSculptGuide_spacing_get(PointerRNA *ptr);
void GPencilSculptGuide_spacing_set(PointerRNA *ptr, float value);

enum {
	GPencilSculptGuide_reference_point_CURSOR = 0,
	GPencilSculptGuide_reference_point_CUSTOM = 1,
	GPencilSculptGuide_reference_point_OBJECT = 2,
};

int GPencilSculptGuide_reference_point_get(PointerRNA *ptr);
void GPencilSculptGuide_reference_point_set(PointerRNA *ptr, int value);

enum {
	GPencilSculptGuide_type_CIRCULAR = 0,
	GPencilSculptGuide_type_RADIAL = 1,
	GPencilSculptGuide_type_PARALLEL = 2,
	GPencilSculptGuide_type_GRID = 3,
	GPencilSculptGuide_type_ISO = 4,
};

int GPencilSculptGuide_type_get(PointerRNA *ptr);
void GPencilSculptGuide_type_set(PointerRNA *ptr, int value);

bool GPencilSculptGuide_use_guide_get(PointerRNA *ptr);
void GPencilSculptGuide_use_guide_set(PointerRNA *ptr, bool value);

bool GPencilSculptGuide_use_snapping_get(PointerRNA *ptr);
void GPencilSculptGuide_use_snapping_set(PointerRNA *ptr, bool value);

/**************** GPencil Sculpt Settings ****************/

extern StructRNA RNA_GPencilSculptSettings;

PointerRNA GPencilSculptSettings_rna_type_get(PointerRNA *ptr);

bool GPencilSculptSettings_use_automasking_layer_stroke_get(PointerRNA *ptr);
void GPencilSculptSettings_use_automasking_layer_stroke_set(PointerRNA *ptr, bool value);

bool GPencilSculptSettings_use_automasking_layer_active_get(PointerRNA *ptr);
void GPencilSculptSettings_use_automasking_layer_active_set(PointerRNA *ptr, bool value);

bool GPencilSculptSettings_use_automasking_material_stroke_get(PointerRNA *ptr);
void GPencilSculptSettings_use_automasking_material_stroke_set(PointerRNA *ptr, bool value);

bool GPencilSculptSettings_use_automasking_material_active_get(PointerRNA *ptr);
void GPencilSculptSettings_use_automasking_material_active_set(PointerRNA *ptr, bool value);

bool GPencilSculptSettings_use_automasking_stroke_get(PointerRNA *ptr);
void GPencilSculptSettings_use_automasking_stroke_set(PointerRNA *ptr, bool value);

PointerRNA GPencilSculptSettings_multiframe_falloff_curve_get(PointerRNA *ptr);

PointerRNA GPencilSculptSettings_thickness_primitive_curve_get(PointerRNA *ptr);

PointerRNA GPencilSculptSettings_guide_get(PointerRNA *ptr);

enum {
	GPencilSculptSettings_lock_axis_VIEW = 0,
	GPencilSculptSettings_lock_axis_AXIS_Y = 2,
	GPencilSculptSettings_lock_axis_AXIS_X = 1,
	GPencilSculptSettings_lock_axis_AXIS_Z = 3,
	GPencilSculptSettings_lock_axis_CURSOR = 4,
};

int GPencilSculptSettings_lock_axis_get(PointerRNA *ptr);
void GPencilSculptSettings_lock_axis_set(PointerRNA *ptr, int value);

bool GPencilSculptSettings_use_scale_thickness_get(PointerRNA *ptr);
void GPencilSculptSettings_use_scale_thickness_set(PointerRNA *ptr, bool value);

float GPencilSculptSettings_intersection_threshold_get(PointerRNA *ptr);
void GPencilSculptSettings_intersection_threshold_set(PointerRNA *ptr, float value);

bool GPencilSculptSettings_use_thickness_curve_get(PointerRNA *ptr);
void GPencilSculptSettings_use_thickness_curve_set(PointerRNA *ptr, bool value);

bool GPencilSculptSettings_use_multiframe_falloff_get(PointerRNA *ptr);
void GPencilSculptSettings_use_multiframe_falloff_set(PointerRNA *ptr, bool value);

/**************** Gamma Crossfade Strip ****************/

extern StructRNA RNA_GammaCrossStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA GammaCrossStrip_input_1_get(PointerRNA *ptr);

PointerRNA GammaCrossStrip_input_2_get(PointerRNA *ptr);

int GammaCrossStrip_input_count_get(PointerRNA *ptr);
void GammaCrossStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Gaussian Blur Strip ****************/

extern StructRNA RNA_GaussianBlurStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

PointerRNA GaussianBlurStrip_input_1_get(PointerRNA *ptr);

float GaussianBlurStrip_size_x_get(PointerRNA *ptr);
void GaussianBlurStrip_size_x_set(PointerRNA *ptr, float value);

float GaussianBlurStrip_size_y_get(PointerRNA *ptr);
void GaussianBlurStrip_size_y_set(PointerRNA *ptr, float value);

int GaussianBlurStrip_input_count_get(PointerRNA *ptr);
void GaussianBlurStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Geometry Attribute Constraint ****************/

extern StructRNA RNA_GeometryAttributeConstraint;
extern StructRNA RNA_Constraint;

void GeometryAttributeConstraint_attribute_name_get(PointerRNA *ptr, char *value);
int GeometryAttributeConstraint_attribute_name_length(PointerRNA *ptr);
void GeometryAttributeConstraint_attribute_name_set(PointerRNA *ptr, const char *value);

enum {
	GeometryAttributeConstraint_data_type_VECTOR = 0,
	GeometryAttributeConstraint_data_type_QUATERNION = 1,
	GeometryAttributeConstraint_data_type_FLOAT4X4 = 2,
};

int GeometryAttributeConstraint_data_type_get(PointerRNA *ptr);
void GeometryAttributeConstraint_data_type_set(PointerRNA *ptr, int value);

enum {
	GeometryAttributeConstraint_domain_POINT = 0,
	GeometryAttributeConstraint_domain_EDGE = 1,
	GeometryAttributeConstraint_domain_FACE = 2,
	GeometryAttributeConstraint_domain_FACE_CORNER = 3,
	GeometryAttributeConstraint_domain_CURVE = 4,
	GeometryAttributeConstraint_domain_INSTANCE = 5,
};

int GeometryAttributeConstraint_domain_get(PointerRNA *ptr);
void GeometryAttributeConstraint_domain_set(PointerRNA *ptr, int value);

bool GeometryAttributeConstraint_mix_loc_get(PointerRNA *ptr);
void GeometryAttributeConstraint_mix_loc_set(PointerRNA *ptr, bool value);

enum {
	GeometryAttributeConstraint_mix_mode_REPLACE = 0,
	GeometryAttributeConstraint_mix_mode_BEFORE_FULL = 3,
	GeometryAttributeConstraint_mix_mode_BEFORE_SPLIT = 1,
	GeometryAttributeConstraint_mix_mode_AFTER_FULL = 4,
	GeometryAttributeConstraint_mix_mode_AFTER_SPLIT = 2,
};

int GeometryAttributeConstraint_mix_mode_get(PointerRNA *ptr);
void GeometryAttributeConstraint_mix_mode_set(PointerRNA *ptr, int value);

bool GeometryAttributeConstraint_mix_rot_get(PointerRNA *ptr);
void GeometryAttributeConstraint_mix_rot_set(PointerRNA *ptr, bool value);

bool GeometryAttributeConstraint_mix_scl_get(PointerRNA *ptr);
void GeometryAttributeConstraint_mix_scl_set(PointerRNA *ptr, bool value);

int GeometryAttributeConstraint_sample_index_get(PointerRNA *ptr);
void GeometryAttributeConstraint_sample_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryAttributeConstraint_target_get(PointerRNA *ptr);

bool GeometryAttributeConstraint_apply_target_transform_get(PointerRNA *ptr);
void GeometryAttributeConstraint_apply_target_transform_set(PointerRNA *ptr, bool value);

/**************** Geometry Node ****************/

extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

/**************** GeometryNodeAccumulateField ****************/

extern StructRNA RNA_GeometryNodeAccumulateField;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeAccumulateField_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeAccumulateField_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeAccumulateField_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeAttributeDomainSize ****************/

extern StructRNA RNA_GeometryNodeAttributeDomainSize;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeAttributeDomainSize_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeAttributeDomainSize_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeAttributeDomainSize_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeAttributeStatistic ****************/

extern StructRNA RNA_GeometryNodeAttributeStatistic;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeAttributeStatistic_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeAttributeStatistic_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeAttributeStatistic_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeBake ****************/

extern StructRNA RNA_GeometryNodeBake;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeBake_active_index_get(PointerRNA *ptr);
void GeometryNodeBake_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeBake_active_item_get(PointerRNA *ptr);

void GeometryNodeBake_bake_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeBake_bake_items_next(CollectionPropertyIterator *iter);
void GeometryNodeBake_bake_items_end(CollectionPropertyIterator *iter);
int GeometryNodeBake_bake_items_length(PointerRNA *ptr);
bool GeometryNodeBake_bake_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeBake_bake_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeBake_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeBake_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeBake_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeBlurAttribute ****************/

extern StructRNA RNA_GeometryNodeBlurAttribute;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeBlurAttribute_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeBlurAttribute_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeBlurAttribute_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeBoundBox ****************/

extern StructRNA RNA_GeometryNodeBoundBox;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeBoundBox_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeBoundBox_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeBoundBox_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCameraInfo ****************/

extern StructRNA RNA_GeometryNodeCameraInfo;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCameraInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCameraInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCameraInfo_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCaptureAttribute ****************/

extern StructRNA RNA_GeometryNodeCaptureAttribute;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeCaptureAttribute_active_index_get(PointerRNA *ptr);
void GeometryNodeCaptureAttribute_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeCaptureAttribute_active_item_get(PointerRNA *ptr);

enum {
	GeometryNodeCaptureAttribute_domain_POINT = 0,
	GeometryNodeCaptureAttribute_domain_EDGE = 1,
	GeometryNodeCaptureAttribute_domain_FACE = 2,
	GeometryNodeCaptureAttribute_domain_CORNER = 3,
	GeometryNodeCaptureAttribute_domain_CURVE = 4,
	GeometryNodeCaptureAttribute_domain_INSTANCE = 5,
	GeometryNodeCaptureAttribute_domain_LAYER = 6,
};

int GeometryNodeCaptureAttribute_domain_get(PointerRNA *ptr);
void GeometryNodeCaptureAttribute_domain_set(PointerRNA *ptr, int value);

void GeometryNodeCaptureAttribute_capture_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeCaptureAttribute_capture_items_next(CollectionPropertyIterator *iter);
void GeometryNodeCaptureAttribute_capture_items_end(CollectionPropertyIterator *iter);
int GeometryNodeCaptureAttribute_capture_items_length(PointerRNA *ptr);
bool GeometryNodeCaptureAttribute_capture_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeCaptureAttribute_capture_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeCaptureAttribute_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCaptureAttribute_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCaptureAttribute_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCollectionInfo ****************/

extern StructRNA RNA_GeometryNodeCollectionInfo;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCollectionInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCollectionInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCollectionInfo_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeConvexHull ****************/

extern StructRNA RNA_GeometryNodeConvexHull;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeConvexHull_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeConvexHull_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeConvexHull_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCornersOfEdge ****************/

extern StructRNA RNA_GeometryNodeCornersOfEdge;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCornersOfEdge_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCornersOfEdge_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCornersOfEdge_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCornersOfFace ****************/

extern StructRNA RNA_GeometryNodeCornersOfFace;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCornersOfFace_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCornersOfFace_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCornersOfFace_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCornersOfVertex ****************/

extern StructRNA RNA_GeometryNodeCornersOfVertex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCornersOfVertex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCornersOfVertex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCornersOfVertex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveArc ****************/

extern StructRNA RNA_GeometryNodeCurveArc;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveArc_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveArc_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveArc_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveEndpointSelection ****************/

extern StructRNA RNA_GeometryNodeCurveEndpointSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveEndpointSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveEndpointSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveEndpointSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveHandleTypeSelection ****************/

extern StructRNA RNA_GeometryNodeCurveHandleTypeSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	GeometryNodeCurveHandleTypeSelection_handle_type_FREE = 0,
	GeometryNodeCurveHandleTypeSelection_handle_type_AUTO = 1,
	GeometryNodeCurveHandleTypeSelection_handle_type_VECTOR = 2,
	GeometryNodeCurveHandleTypeSelection_handle_type_ALIGN = 3,
};

int GeometryNodeCurveHandleTypeSelection_handle_type_get(PointerRNA *ptr);
void GeometryNodeCurveHandleTypeSelection_handle_type_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeCurveHandleTypeSelection_mode_LEFT = 1,
	GeometryNodeCurveHandleTypeSelection_mode_RIGHT = 2,
};

int GeometryNodeCurveHandleTypeSelection_mode_get(PointerRNA *ptr);
void GeometryNodeCurveHandleTypeSelection_mode_set(PointerRNA *ptr, int value);

bool GeometryNodeCurveHandleTypeSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveHandleTypeSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveHandleTypeSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveLength ****************/

extern StructRNA RNA_GeometryNodeCurveLength;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveLength_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveLength_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveLength_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveOfPoint ****************/

extern StructRNA RNA_GeometryNodeCurveOfPoint;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveOfPoint_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveOfPoint_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveOfPoint_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurvePrimitiveBezierSegment ****************/

extern StructRNA RNA_GeometryNodeCurvePrimitiveBezierSegment;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurvePrimitiveBezierSegment_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurvePrimitiveBezierSegment_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurvePrimitiveBezierSegment_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurvePrimitiveCircle ****************/

extern StructRNA RNA_GeometryNodeCurvePrimitiveCircle;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurvePrimitiveCircle_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurvePrimitiveCircle_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurvePrimitiveCircle_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurvePrimitiveLine ****************/

extern StructRNA RNA_GeometryNodeCurvePrimitiveLine;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurvePrimitiveLine_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurvePrimitiveLine_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurvePrimitiveLine_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurvePrimitiveQuadrilateral ****************/

extern StructRNA RNA_GeometryNodeCurvePrimitiveQuadrilateral;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurvePrimitiveQuadrilateral_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurvePrimitiveQuadrilateral_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurvePrimitiveQuadrilateral_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveQuadraticBezier ****************/

extern StructRNA RNA_GeometryNodeCurveQuadraticBezier;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveQuadraticBezier_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveQuadraticBezier_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveQuadraticBezier_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveSetHandles ****************/

extern StructRNA RNA_GeometryNodeCurveSetHandles;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	GeometryNodeCurveSetHandles_handle_type_FREE = 0,
	GeometryNodeCurveSetHandles_handle_type_AUTO = 1,
	GeometryNodeCurveSetHandles_handle_type_VECTOR = 2,
	GeometryNodeCurveSetHandles_handle_type_ALIGN = 3,
};

int GeometryNodeCurveSetHandles_handle_type_get(PointerRNA *ptr);
void GeometryNodeCurveSetHandles_handle_type_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeCurveSetHandles_mode_LEFT = 1,
	GeometryNodeCurveSetHandles_mode_RIGHT = 2,
};

int GeometryNodeCurveSetHandles_mode_get(PointerRNA *ptr);
void GeometryNodeCurveSetHandles_mode_set(PointerRNA *ptr, int value);

bool GeometryNodeCurveSetHandles_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveSetHandles_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveSetHandles_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveSpiral ****************/

extern StructRNA RNA_GeometryNodeCurveSpiral;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveSpiral_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveSpiral_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveSpiral_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveSplineType ****************/

extern StructRNA RNA_GeometryNodeCurveSplineType;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveSplineType_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveSplineType_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveSplineType_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveStar ****************/

extern StructRNA RNA_GeometryNodeCurveStar;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveStar_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveStar_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveStar_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveToMesh ****************/

extern StructRNA RNA_GeometryNodeCurveToMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveToMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveToMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveToMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurveToPoints ****************/

extern StructRNA RNA_GeometryNodeCurveToPoints;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurveToPoints_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurveToPoints_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurveToPoints_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeCurvesToGreasePencil ****************/

extern StructRNA RNA_GeometryNodeCurvesToGreasePencil;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeCurvesToGreasePencil_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeCurvesToGreasePencil_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeCurvesToGreasePencil_output_template_func(struct StructRNA *_type, int index);
/**************** Geometry Custom Group ****************/

extern StructRNA RNA_GeometryNodeCustomGroup;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeCustomGroup_node_tree_get(PointerRNA *ptr);

/**************** GeometryNodeDeformCurvesOnSurface ****************/

extern StructRNA RNA_GeometryNodeDeformCurvesOnSurface;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDeformCurvesOnSurface_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDeformCurvesOnSurface_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDeformCurvesOnSurface_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDeleteGeometry ****************/

extern StructRNA RNA_GeometryNodeDeleteGeometry;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDeleteGeometry_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDeleteGeometry_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDeleteGeometry_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDistributePointsInGrid ****************/

extern StructRNA RNA_GeometryNodeDistributePointsInGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDistributePointsInGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDistributePointsInGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDistributePointsInGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDistributePointsInVolume ****************/

extern StructRNA RNA_GeometryNodeDistributePointsInVolume;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDistributePointsInVolume_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDistributePointsInVolume_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDistributePointsInVolume_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDistributePointsOnFaces ****************/

extern StructRNA RNA_GeometryNodeDistributePointsOnFaces;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	GeometryNodeDistributePointsOnFaces_distribute_method_RANDOM = 0,
	GeometryNodeDistributePointsOnFaces_distribute_method_POISSON = 1,
};

int GeometryNodeDistributePointsOnFaces_distribute_method_get(PointerRNA *ptr);
void GeometryNodeDistributePointsOnFaces_distribute_method_set(PointerRNA *ptr, int value);

bool GeometryNodeDistributePointsOnFaces_use_legacy_normal_get(PointerRNA *ptr);
void GeometryNodeDistributePointsOnFaces_use_legacy_normal_set(PointerRNA *ptr, bool value);

bool GeometryNodeDistributePointsOnFaces_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDistributePointsOnFaces_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDistributePointsOnFaces_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDualMesh ****************/

extern StructRNA RNA_GeometryNodeDualMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDualMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDualMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDualMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeDuplicateElements ****************/

extern StructRNA RNA_GeometryNodeDuplicateElements;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeDuplicateElements_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeDuplicateElements_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeDuplicateElements_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeEdgePathsToCurves ****************/

extern StructRNA RNA_GeometryNodeEdgePathsToCurves;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeEdgePathsToCurves_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeEdgePathsToCurves_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeEdgePathsToCurves_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeEdgePathsToSelection ****************/

extern StructRNA RNA_GeometryNodeEdgePathsToSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeEdgePathsToSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeEdgePathsToSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeEdgePathsToSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeEdgesOfCorner ****************/

extern StructRNA RNA_GeometryNodeEdgesOfCorner;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeEdgesOfCorner_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeEdgesOfCorner_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeEdgesOfCorner_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeEdgesOfVertex ****************/

extern StructRNA RNA_GeometryNodeEdgesOfVertex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeEdgesOfVertex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeEdgesOfVertex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeEdgesOfVertex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeEdgesToFaceGroups ****************/

extern StructRNA RNA_GeometryNodeEdgesToFaceGroups;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeEdgesToFaceGroups_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeEdgesToFaceGroups_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeEdgesToFaceGroups_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeExtrudeMesh ****************/

extern StructRNA RNA_GeometryNodeExtrudeMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeExtrudeMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeExtrudeMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeExtrudeMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFaceOfCorner ****************/

extern StructRNA RNA_GeometryNodeFaceOfCorner;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFaceOfCorner_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFaceOfCorner_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFaceOfCorner_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFieldAtIndex ****************/

extern StructRNA RNA_GeometryNodeFieldAtIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFieldAtIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldAtIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldAtIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFieldAverage ****************/

extern StructRNA RNA_GeometryNodeFieldAverage;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFieldAverage_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldAverage_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldAverage_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFieldMinAndMax ****************/

extern StructRNA RNA_GeometryNodeFieldMinAndMax;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFieldMinAndMax_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldMinAndMax_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldMinAndMax_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFieldOnDomain ****************/

extern StructRNA RNA_GeometryNodeFieldOnDomain;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFieldOnDomain_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldOnDomain_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldOnDomain_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFieldToGrid ****************/

extern StructRNA RNA_GeometryNodeFieldToGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeFieldToGrid_active_index_get(PointerRNA *ptr);
void GeometryNodeFieldToGrid_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeFieldToGrid_active_item_get(PointerRNA *ptr);

enum {
	GeometryNodeFieldToGrid_data_type_FLOAT = 0,
	GeometryNodeFieldToGrid_data_type_INT = 6,
	GeometryNodeFieldToGrid_data_type_BOOLEAN = 4,
	GeometryNodeFieldToGrid_data_type_VECTOR = 1,
	GeometryNodeFieldToGrid_data_type_RGBA = 2,
	GeometryNodeFieldToGrid_data_type_ROTATION = 14,
	GeometryNodeFieldToGrid_data_type_MATRIX = 16,
	GeometryNodeFieldToGrid_data_type_STRING = 7,
	GeometryNodeFieldToGrid_data_type_MENU = 15,
	GeometryNodeFieldToGrid_data_type_SHADER = 3,
	GeometryNodeFieldToGrid_data_type_OBJECT = 8,
	GeometryNodeFieldToGrid_data_type_IMAGE = 9,
	GeometryNodeFieldToGrid_data_type_GEOMETRY = 10,
	GeometryNodeFieldToGrid_data_type_COLLECTION = 11,
	GeometryNodeFieldToGrid_data_type_TEXTURE = 12,
	GeometryNodeFieldToGrid_data_type_MATERIAL = 13,
	GeometryNodeFieldToGrid_data_type_BUNDLE = 17,
	GeometryNodeFieldToGrid_data_type_CLOSURE = 18,
};

int GeometryNodeFieldToGrid_data_type_get(PointerRNA *ptr);
void GeometryNodeFieldToGrid_data_type_set(PointerRNA *ptr, int value);

void GeometryNodeFieldToGrid_grid_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeFieldToGrid_grid_items_next(CollectionPropertyIterator *iter);
void GeometryNodeFieldToGrid_grid_items_end(CollectionPropertyIterator *iter);
int GeometryNodeFieldToGrid_grid_items_length(PointerRNA *ptr);
bool GeometryNodeFieldToGrid_grid_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeFieldToGrid_grid_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeFieldToGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldToGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldToGrid_output_template_func(struct StructRNA *_type, int index);
/**************** Field to Grid Item ****************/

extern StructRNA RNA_GeometryNodeFieldToGridItem;

PointerRNA GeometryNodeFieldToGridItem_rna_type_get(PointerRNA *ptr);

void GeometryNodeFieldToGridItem_name_get(PointerRNA *ptr, char *value);
int GeometryNodeFieldToGridItem_name_length(PointerRNA *ptr);
void GeometryNodeFieldToGridItem_name_set(PointerRNA *ptr, const char *value);

void GeometryNodeFieldToGridItem_color_get(PointerRNA *ptr, float values[4]);
void GeometryNodeFieldToGridItem_color_set(PointerRNA *ptr, const float values[4]);

enum {
	GeometryNodeFieldToGridItem_data_type_FLOAT = 0,
	GeometryNodeFieldToGridItem_data_type_INT = 6,
	GeometryNodeFieldToGridItem_data_type_BOOLEAN = 4,
	GeometryNodeFieldToGridItem_data_type_VECTOR = 1,
	GeometryNodeFieldToGridItem_data_type_RGBA = 2,
	GeometryNodeFieldToGridItem_data_type_ROTATION = 14,
	GeometryNodeFieldToGridItem_data_type_MATRIX = 16,
	GeometryNodeFieldToGridItem_data_type_STRING = 7,
	GeometryNodeFieldToGridItem_data_type_MENU = 15,
	GeometryNodeFieldToGridItem_data_type_SHADER = 3,
	GeometryNodeFieldToGridItem_data_type_OBJECT = 8,
	GeometryNodeFieldToGridItem_data_type_IMAGE = 9,
	GeometryNodeFieldToGridItem_data_type_GEOMETRY = 10,
	GeometryNodeFieldToGridItem_data_type_COLLECTION = 11,
	GeometryNodeFieldToGridItem_data_type_TEXTURE = 12,
	GeometryNodeFieldToGridItem_data_type_MATERIAL = 13,
	GeometryNodeFieldToGridItem_data_type_BUNDLE = 17,
	GeometryNodeFieldToGridItem_data_type_CLOSURE = 18,
};

int GeometryNodeFieldToGridItem_data_type_get(PointerRNA *ptr);
void GeometryNodeFieldToGridItem_data_type_set(PointerRNA *ptr, int value);

int GeometryNodeFieldToGridItem_identifier_get(PointerRNA *ptr);
void GeometryNodeFieldToGridItem_identifier_set(PointerRNA *ptr, int value);

/**************** Items ****************/

extern StructRNA RNA_GeometryNodeFieldToGridItems;

PointerRNA GeometryNodeFieldToGridItems_rna_type_get(PointerRNA *ptr);

struct GeometryNodeFieldToGridItem *GeometryNodeFieldToGridItems_new_func(struct ID *_selfid, struct bNode *_self, Main *bmain, ReportList *reports, int socket_type, const char * name);
void GeometryNodeFieldToGridItems_remove_func(struct ID *_selfid, struct bNode *_self, Main *bmain, ReportList *reports, struct GeometryNodeFieldToGridItem *item);
void GeometryNodeFieldToGridItems_clear_func(struct ID *_selfid, struct bNode *_self, Main *bmain);
void GeometryNodeFieldToGridItems_move_func(struct ID *_selfid, struct bNode *_self, Main *bmain, int from_index, int to_index);
/**************** GeometryNodeFieldVariance ****************/

extern StructRNA RNA_GeometryNodeFieldVariance;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFieldVariance_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFieldVariance_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFieldVariance_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFillCurve ****************/

extern StructRNA RNA_GeometryNodeFillCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFillCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFillCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFillCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFilletCurve ****************/

extern StructRNA RNA_GeometryNodeFilletCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFilletCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFilletCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFilletCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeFlipFaces ****************/

extern StructRNA RNA_GeometryNodeFlipFaces;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeFlipFaces_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeFlipFaces_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeFlipFaces_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeForeachGeometryElementInput ****************/

extern StructRNA RNA_GeometryNodeForeachGeometryElementInput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeForeachGeometryElementInput_paired_output_get(PointerRNA *ptr);

bool GeometryNodeForeachGeometryElementInput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeForeachGeometryElementInput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeForeachGeometryElementInput_output_template_func(struct StructRNA *_type, int index);
bool GeometryNodeForeachGeometryElementInput_pair_with_output_func(struct ID *_selfid, struct bNode *_self, bContext *C, ReportList *reports, struct bNode *output_node);
/**************** GeometryNodeForeachGeometryElementOutput ****************/

extern StructRNA RNA_GeometryNodeForeachGeometryElementOutput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeForeachGeometryElementOutput_active_input_index_get(PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_active_input_index_set(PointerRNA *ptr, int value);

int GeometryNodeForeachGeometryElementOutput_active_generation_index_get(PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_active_generation_index_set(PointerRNA *ptr, int value);

int GeometryNodeForeachGeometryElementOutput_active_main_index_get(PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_active_main_index_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeForeachGeometryElementOutput_domain_POINT = 0,
	GeometryNodeForeachGeometryElementOutput_domain_EDGE = 1,
	GeometryNodeForeachGeometryElementOutput_domain_FACE = 2,
	GeometryNodeForeachGeometryElementOutput_domain_CORNER = 3,
	GeometryNodeForeachGeometryElementOutput_domain_CURVE = 4,
	GeometryNodeForeachGeometryElementOutput_domain_INSTANCE = 5,
	GeometryNodeForeachGeometryElementOutput_domain_LAYER = 6,
};

int GeometryNodeForeachGeometryElementOutput_domain_get(PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_domain_set(PointerRNA *ptr, int value);

int GeometryNodeForeachGeometryElementOutput_inspection_index_get(PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_inspection_index_set(PointerRNA *ptr, int value);

void GeometryNodeForeachGeometryElementOutput_generation_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_generation_items_next(CollectionPropertyIterator *iter);
void GeometryNodeForeachGeometryElementOutput_generation_items_end(CollectionPropertyIterator *iter);
int GeometryNodeForeachGeometryElementOutput_generation_items_length(PointerRNA *ptr);
bool GeometryNodeForeachGeometryElementOutput_generation_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeForeachGeometryElementOutput_generation_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void GeometryNodeForeachGeometryElementOutput_input_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_input_items_next(CollectionPropertyIterator *iter);
void GeometryNodeForeachGeometryElementOutput_input_items_end(CollectionPropertyIterator *iter);
int GeometryNodeForeachGeometryElementOutput_input_items_length(PointerRNA *ptr);
bool GeometryNodeForeachGeometryElementOutput_input_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeForeachGeometryElementOutput_input_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void GeometryNodeForeachGeometryElementOutput_main_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeForeachGeometryElementOutput_main_items_next(CollectionPropertyIterator *iter);
void GeometryNodeForeachGeometryElementOutput_main_items_end(CollectionPropertyIterator *iter);
int GeometryNodeForeachGeometryElementOutput_main_items_length(PointerRNA *ptr);
bool GeometryNodeForeachGeometryElementOutput_main_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeForeachGeometryElementOutput_main_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeForeachGeometryElementOutput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeForeachGeometryElementOutput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeForeachGeometryElementOutput_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGeometryToInstance ****************/

extern StructRNA RNA_GeometryNodeGeometryToInstance;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGeometryToInstance_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGeometryToInstance_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGeometryToInstance_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGetNamedGrid ****************/

extern StructRNA RNA_GeometryNodeGetNamedGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGetNamedGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGetNamedGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGetNamedGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGizmoDial ****************/

extern StructRNA RNA_GeometryNodeGizmoDial;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGizmoDial_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGizmoDial_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGizmoDial_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGizmoLinear ****************/

extern StructRNA RNA_GeometryNodeGizmoLinear;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGizmoLinear_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGizmoLinear_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGizmoLinear_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGizmoTransform ****************/

extern StructRNA RNA_GeometryNodeGizmoTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGizmoTransform_use_rotation_x_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_rotation_x_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_rotation_y_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_rotation_y_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_rotation_z_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_rotation_z_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_scale_x_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_scale_x_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_scale_y_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_scale_y_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_scale_z_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_scale_z_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_translation_x_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_translation_x_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_translation_y_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_translation_y_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_use_translation_z_get(PointerRNA *ptr);
void GeometryNodeGizmoTransform_use_translation_z_set(PointerRNA *ptr, bool value);

bool GeometryNodeGizmoTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGizmoTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGizmoTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGreasePencilToCurves ****************/

extern StructRNA RNA_GeometryNodeGreasePencilToCurves;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGreasePencilToCurves_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGreasePencilToCurves_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGreasePencilToCurves_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridAdvect ****************/

extern StructRNA RNA_GeometryNodeGridAdvect;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridAdvect_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridAdvect_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridAdvect_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridCurl ****************/

extern StructRNA RNA_GeometryNodeGridCurl;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridCurl_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridCurl_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridCurl_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridDivergence ****************/

extern StructRNA RNA_GeometryNodeGridDivergence;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridDivergence_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridDivergence_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridDivergence_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridGradient ****************/

extern StructRNA RNA_GeometryNodeGridGradient;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridGradient_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridGradient_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridGradient_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridInfo ****************/

extern StructRNA RNA_GeometryNodeGridInfo;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridInfo_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridLaplacian ****************/

extern StructRNA RNA_GeometryNodeGridLaplacian;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridLaplacian_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridLaplacian_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridLaplacian_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridPrune ****************/

extern StructRNA RNA_GeometryNodeGridPrune;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridPrune_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridPrune_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridPrune_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridToMesh ****************/

extern StructRNA RNA_GeometryNodeGridToMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridToMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridToMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridToMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGridVoxelize ****************/

extern StructRNA RNA_GeometryNodeGridVoxelize;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeGridVoxelize_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGridVoxelize_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGridVoxelize_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeGroup ****************/

extern StructRNA RNA_GeometryNodeGroup;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeGroup_node_tree_get(PointerRNA *ptr);

bool GeometryNodeGroup_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeGroup_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeGroup_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImageInfo ****************/

extern StructRNA RNA_GeometryNodeImageInfo;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImageInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImageInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImageInfo_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImageTexture ****************/

extern StructRNA RNA_GeometryNodeImageTexture;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

enum {
	GeometryNodeImageTexture_extension_REPEAT = 0,
	GeometryNodeImageTexture_extension_EXTEND = 1,
	GeometryNodeImageTexture_extension_CLIP = 2,
	GeometryNodeImageTexture_extension_MIRROR = 3,
};

int GeometryNodeImageTexture_extension_get(PointerRNA *ptr);
void GeometryNodeImageTexture_extension_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeImageTexture_interpolation_Linear = 0,
	GeometryNodeImageTexture_interpolation_Closest = 1,
	GeometryNodeImageTexture_interpolation_Cubic = 2,
};

int GeometryNodeImageTexture_interpolation_get(PointerRNA *ptr);
void GeometryNodeImageTexture_interpolation_set(PointerRNA *ptr, int value);

bool GeometryNodeImageTexture_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImageTexture_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImageTexture_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportCSV ****************/

extern StructRNA RNA_GeometryNodeImportCSV;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportCSV_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportCSV_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportCSV_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportOBJ ****************/

extern StructRNA RNA_GeometryNodeImportOBJ;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportOBJ_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportOBJ_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportOBJ_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportPLY ****************/

extern StructRNA RNA_GeometryNodeImportPLY;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportPLY_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportPLY_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportPLY_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportSTL ****************/

extern StructRNA RNA_GeometryNodeImportSTL;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportSTL_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportSTL_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportSTL_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportText ****************/

extern StructRNA RNA_GeometryNodeImportText;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportText_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportText_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportText_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeImportVDB ****************/

extern StructRNA RNA_GeometryNodeImportVDB;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeImportVDB_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeImportVDB_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeImportVDB_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeIndexOfNearest ****************/

extern StructRNA RNA_GeometryNodeIndexOfNearest;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeIndexOfNearest_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeIndexOfNearest_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeIndexOfNearest_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeIndexSwitch ****************/

extern StructRNA RNA_GeometryNodeIndexSwitch;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

void GeometryNodeIndexSwitch_index_switch_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeIndexSwitch_index_switch_items_next(CollectionPropertyIterator *iter);
void GeometryNodeIndexSwitch_index_switch_items_end(CollectionPropertyIterator *iter);
int GeometryNodeIndexSwitch_index_switch_items_length(PointerRNA *ptr);
bool GeometryNodeIndexSwitch_index_switch_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool GeometryNodeIndexSwitch_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeIndexSwitch_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeIndexSwitch_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputActiveCamera ****************/

extern StructRNA RNA_GeometryNodeInputActiveCamera;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputActiveCamera_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputActiveCamera_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputActiveCamera_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputCollection ****************/

extern StructRNA RNA_GeometryNodeInputCollection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeInputCollection_collection_get(PointerRNA *ptr);

bool GeometryNodeInputCollection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputCollection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputCollection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputCurveHandlePositions ****************/

extern StructRNA RNA_GeometryNodeInputCurveHandlePositions;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputCurveHandlePositions_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputCurveHandlePositions_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputCurveHandlePositions_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputCurveTilt ****************/

extern StructRNA RNA_GeometryNodeInputCurveTilt;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputCurveTilt_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputCurveTilt_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputCurveTilt_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputEdgeSmooth ****************/

extern StructRNA RNA_GeometryNodeInputEdgeSmooth;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputEdgeSmooth_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputEdgeSmooth_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputEdgeSmooth_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputID ****************/

extern StructRNA RNA_GeometryNodeInputID;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputID_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputID_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputID_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputImage ****************/

extern StructRNA RNA_GeometryNodeInputImage;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeInputImage_image_get(PointerRNA *ptr);

bool GeometryNodeInputImage_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputImage_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputImage_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputIndex ****************/

extern StructRNA RNA_GeometryNodeInputIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputInstanceBounds ****************/

extern StructRNA RNA_GeometryNodeInputInstanceBounds;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputInstanceBounds_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputInstanceBounds_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputInstanceBounds_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputInstanceRotation ****************/

extern StructRNA RNA_GeometryNodeInputInstanceRotation;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputInstanceRotation_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputInstanceRotation_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputInstanceRotation_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputInstanceScale ****************/

extern StructRNA RNA_GeometryNodeInputInstanceScale;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputInstanceScale_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputInstanceScale_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputInstanceScale_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMaterial ****************/

extern StructRNA RNA_GeometryNodeInputMaterial;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeInputMaterial_material_get(PointerRNA *ptr);

bool GeometryNodeInputMaterial_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMaterial_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMaterial_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMaterialIndex ****************/

extern StructRNA RNA_GeometryNodeInputMaterialIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMaterialIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMaterialIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMaterialIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshEdgeAngle ****************/

extern StructRNA RNA_GeometryNodeInputMeshEdgeAngle;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshEdgeAngle_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshEdgeAngle_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshEdgeAngle_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshEdgeNeighbors ****************/

extern StructRNA RNA_GeometryNodeInputMeshEdgeNeighbors;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshEdgeNeighbors_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshEdgeNeighbors_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshEdgeNeighbors_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshEdgeVertices ****************/

extern StructRNA RNA_GeometryNodeInputMeshEdgeVertices;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshEdgeVertices_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshEdgeVertices_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshEdgeVertices_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshFaceArea ****************/

extern StructRNA RNA_GeometryNodeInputMeshFaceArea;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshFaceArea_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshFaceArea_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshFaceArea_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshFaceIsPlanar ****************/

extern StructRNA RNA_GeometryNodeInputMeshFaceIsPlanar;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshFaceIsPlanar_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshFaceIsPlanar_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshFaceIsPlanar_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshFaceNeighbors ****************/

extern StructRNA RNA_GeometryNodeInputMeshFaceNeighbors;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshFaceNeighbors_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshFaceNeighbors_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshFaceNeighbors_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshIsland ****************/

extern StructRNA RNA_GeometryNodeInputMeshIsland;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshIsland_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshIsland_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshIsland_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputMeshVertexNeighbors ****************/

extern StructRNA RNA_GeometryNodeInputMeshVertexNeighbors;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputMeshVertexNeighbors_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputMeshVertexNeighbors_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputMeshVertexNeighbors_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputNamedAttribute ****************/

extern StructRNA RNA_GeometryNodeInputNamedAttribute;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputNamedAttribute_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputNamedAttribute_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputNamedAttribute_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputNamedLayerSelection ****************/

extern StructRNA RNA_GeometryNodeInputNamedLayerSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputNamedLayerSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputNamedLayerSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputNamedLayerSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputNormal ****************/

extern StructRNA RNA_GeometryNodeInputNormal;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputNormal_legacy_corner_normals_get(PointerRNA *ptr);
void GeometryNodeInputNormal_legacy_corner_normals_set(PointerRNA *ptr, bool value);

bool GeometryNodeInputNormal_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputNormal_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputNormal_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputObject ****************/

extern StructRNA RNA_GeometryNodeInputObject;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeInputObject_object_get(PointerRNA *ptr);

bool GeometryNodeInputObject_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputObject_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputObject_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputPosition ****************/

extern StructRNA RNA_GeometryNodeInputPosition;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputPosition_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputPosition_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputPosition_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputRadius ****************/

extern StructRNA RNA_GeometryNodeInputRadius;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputRadius_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputRadius_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputRadius_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputSceneTime ****************/

extern StructRNA RNA_GeometryNodeInputSceneTime;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputSceneTime_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputSceneTime_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputSceneTime_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputShadeSmooth ****************/

extern StructRNA RNA_GeometryNodeInputShadeSmooth;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputShadeSmooth_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputShadeSmooth_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputShadeSmooth_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputShortestEdgePaths ****************/

extern StructRNA RNA_GeometryNodeInputShortestEdgePaths;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputShortestEdgePaths_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputShortestEdgePaths_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputShortestEdgePaths_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputSplineCyclic ****************/

extern StructRNA RNA_GeometryNodeInputSplineCyclic;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputSplineCyclic_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputSplineCyclic_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputSplineCyclic_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputSplineResolution ****************/

extern StructRNA RNA_GeometryNodeInputSplineResolution;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputSplineResolution_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputSplineResolution_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputSplineResolution_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputTangent ****************/

extern StructRNA RNA_GeometryNodeInputTangent;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputTangent_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputTangent_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputTangent_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInputVoxelIndex ****************/

extern StructRNA RNA_GeometryNodeInputVoxelIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInputVoxelIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInputVoxelIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInputVoxelIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInstanceOnPoints ****************/

extern StructRNA RNA_GeometryNodeInstanceOnPoints;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInstanceOnPoints_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInstanceOnPoints_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInstanceOnPoints_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInstanceTransform ****************/

extern StructRNA RNA_GeometryNodeInstanceTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInstanceTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInstanceTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInstanceTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInstancesToPoints ****************/

extern StructRNA RNA_GeometryNodeInstancesToPoints;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInstancesToPoints_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInstancesToPoints_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInstancesToPoints_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeInterpolateCurves ****************/

extern StructRNA RNA_GeometryNodeInterpolateCurves;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeInterpolateCurves_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeInterpolateCurves_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeInterpolateCurves_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeIsViewport ****************/

extern StructRNA RNA_GeometryNodeIsViewport;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeIsViewport_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeIsViewport_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeIsViewport_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeJoinGeometry ****************/

extern StructRNA RNA_GeometryNodeJoinGeometry;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeJoinGeometry_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeJoinGeometry_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeJoinGeometry_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeList ****************/

extern StructRNA RNA_GeometryNodeList;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeList_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeList_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeList_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeListGetItem ****************/

extern StructRNA RNA_GeometryNodeListGetItem;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeListGetItem_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeListGetItem_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeListGetItem_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeListLength ****************/

extern StructRNA RNA_GeometryNodeListLength;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeListLength_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeListLength_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeListLength_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMaterialSelection ****************/

extern StructRNA RNA_GeometryNodeMaterialSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMaterialSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMaterialSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMaterialSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMenuSwitch ****************/

extern StructRNA RNA_GeometryNodeMenuSwitch;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeMenuSwitch_active_item_get(PointerRNA *ptr);

int GeometryNodeMenuSwitch_active_index_get(PointerRNA *ptr);
void GeometryNodeMenuSwitch_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeMenuSwitch_enum_definition_get(PointerRNA *ptr);

void GeometryNodeMenuSwitch_enum_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeMenuSwitch_enum_items_next(CollectionPropertyIterator *iter);
void GeometryNodeMenuSwitch_enum_items_end(CollectionPropertyIterator *iter);
int GeometryNodeMenuSwitch_enum_items_length(PointerRNA *ptr);
bool GeometryNodeMenuSwitch_enum_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeMenuSwitch_enum_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeMenuSwitch_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMenuSwitch_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMenuSwitch_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMergeByDistance ****************/

extern StructRNA RNA_GeometryNodeMergeByDistance;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMergeByDistance_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMergeByDistance_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMergeByDistance_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMergeLayers ****************/

extern StructRNA RNA_GeometryNodeMergeLayers;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMergeLayers_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMergeLayers_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMergeLayers_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshBoolean ****************/

extern StructRNA RNA_GeometryNodeMeshBoolean;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshBoolean_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshBoolean_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshBoolean_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshCircle ****************/

extern StructRNA RNA_GeometryNodeMeshCircle;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshCircle_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshCircle_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshCircle_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshCone ****************/

extern StructRNA RNA_GeometryNodeMeshCone;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshCone_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshCone_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshCone_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshCube ****************/

extern StructRNA RNA_GeometryNodeMeshCube;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshCube_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshCube_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshCube_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshCylinder ****************/

extern StructRNA RNA_GeometryNodeMeshCylinder;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshCylinder_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshCylinder_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshCylinder_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshFaceSetBoundaries ****************/

extern StructRNA RNA_GeometryNodeMeshFaceSetBoundaries;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshFaceSetBoundaries_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshFaceSetBoundaries_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshFaceSetBoundaries_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshGrid ****************/

extern StructRNA RNA_GeometryNodeMeshGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshIcoSphere ****************/

extern StructRNA RNA_GeometryNodeMeshIcoSphere;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshIcoSphere_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshIcoSphere_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshIcoSphere_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshLine ****************/

extern StructRNA RNA_GeometryNodeMeshLine;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshLine_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshLine_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshLine_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshToCurve ****************/

extern StructRNA RNA_GeometryNodeMeshToCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshToCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshToCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshToCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshToDensityGrid ****************/

extern StructRNA RNA_GeometryNodeMeshToDensityGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshToDensityGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshToDensityGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshToDensityGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshToPoints ****************/

extern StructRNA RNA_GeometryNodeMeshToPoints;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshToPoints_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshToPoints_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshToPoints_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshToSDFGrid ****************/

extern StructRNA RNA_GeometryNodeMeshToSDFGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshToSDFGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshToSDFGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshToSDFGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshToVolume ****************/

extern StructRNA RNA_GeometryNodeMeshToVolume;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshToVolume_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshToVolume_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshToVolume_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeMeshUVSphere ****************/

extern StructRNA RNA_GeometryNodeMeshUVSphere;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeMeshUVSphere_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeMeshUVSphere_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeMeshUVSphere_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeObjectInfo ****************/

extern StructRNA RNA_GeometryNodeObjectInfo;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeObjectInfo_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeObjectInfo_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeObjectInfo_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeOffsetCornerInFace ****************/

extern StructRNA RNA_GeometryNodeOffsetCornerInFace;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeOffsetCornerInFace_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeOffsetCornerInFace_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeOffsetCornerInFace_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeOffsetPointInCurve ****************/

extern StructRNA RNA_GeometryNodeOffsetPointInCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeOffsetPointInCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeOffsetPointInCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeOffsetPointInCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePoints ****************/

extern StructRNA RNA_GeometryNodePoints;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePoints_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePoints_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePoints_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePointsOfCurve ****************/

extern StructRNA RNA_GeometryNodePointsOfCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePointsOfCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePointsOfCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePointsOfCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePointsToCurves ****************/

extern StructRNA RNA_GeometryNodePointsToCurves;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePointsToCurves_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePointsToCurves_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePointsToCurves_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePointsToSDFGrid ****************/

extern StructRNA RNA_GeometryNodePointsToSDFGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePointsToSDFGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePointsToSDFGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePointsToSDFGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePointsToVertices ****************/

extern StructRNA RNA_GeometryNodePointsToVertices;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePointsToVertices_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePointsToVertices_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePointsToVertices_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodePointsToVolume ****************/

extern StructRNA RNA_GeometryNodePointsToVolume;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodePointsToVolume_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodePointsToVolume_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodePointsToVolume_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeProximity ****************/

extern StructRNA RNA_GeometryNodeProximity;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeProximity_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeProximity_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeProximity_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeRaycast ****************/

extern StructRNA RNA_GeometryNodeRaycast;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeRaycast_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRaycast_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRaycast_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeRealizeInstances ****************/

extern StructRNA RNA_GeometryNodeRealizeInstances;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeRealizeInstances_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRealizeInstances_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRealizeInstances_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeRemoveAttribute ****************/

extern StructRNA RNA_GeometryNodeRemoveAttribute;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeRemoveAttribute_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRemoveAttribute_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRemoveAttribute_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeRepeatInput ****************/

extern StructRNA RNA_GeometryNodeRepeatInput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeRepeatInput_paired_output_get(PointerRNA *ptr);

bool GeometryNodeRepeatInput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRepeatInput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRepeatInput_output_template_func(struct StructRNA *_type, int index);
bool GeometryNodeRepeatInput_pair_with_output_func(struct ID *_selfid, struct bNode *_self, bContext *C, ReportList *reports, struct bNode *output_node);
/**************** GeometryNodeRepeatOutput ****************/

extern StructRNA RNA_GeometryNodeRepeatOutput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeRepeatOutput_active_index_get(PointerRNA *ptr);
void GeometryNodeRepeatOutput_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeRepeatOutput_active_item_get(PointerRNA *ptr);

int GeometryNodeRepeatOutput_inspection_index_get(PointerRNA *ptr);
void GeometryNodeRepeatOutput_inspection_index_set(PointerRNA *ptr, int value);

void GeometryNodeRepeatOutput_repeat_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeRepeatOutput_repeat_items_next(CollectionPropertyIterator *iter);
void GeometryNodeRepeatOutput_repeat_items_end(CollectionPropertyIterator *iter);
int GeometryNodeRepeatOutput_repeat_items_length(PointerRNA *ptr);
bool GeometryNodeRepeatOutput_repeat_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeRepeatOutput_repeat_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeRepeatOutput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRepeatOutput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRepeatOutput_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeReplaceMaterial ****************/

extern StructRNA RNA_GeometryNodeReplaceMaterial;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeReplaceMaterial_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeReplaceMaterial_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeReplaceMaterial_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeResampleCurve ****************/

extern StructRNA RNA_GeometryNodeResampleCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeResampleCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeResampleCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeResampleCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeReverseCurve ****************/

extern StructRNA RNA_GeometryNodeReverseCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeReverseCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeReverseCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeReverseCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeRotateInstances ****************/

extern StructRNA RNA_GeometryNodeRotateInstances;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeRotateInstances_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeRotateInstances_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeRotateInstances_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridBoolean ****************/

extern StructRNA RNA_GeometryNodeSDFGridBoolean;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridBoolean_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridBoolean_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridBoolean_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridFillet ****************/

extern StructRNA RNA_GeometryNodeSDFGridFillet;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridFillet_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridFillet_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridFillet_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridLaplacian ****************/

extern StructRNA RNA_GeometryNodeSDFGridLaplacian;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridLaplacian_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridLaplacian_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridLaplacian_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridMean ****************/

extern StructRNA RNA_GeometryNodeSDFGridMean;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridMean_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridMean_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridMean_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridMeanCurvature ****************/

extern StructRNA RNA_GeometryNodeSDFGridMeanCurvature;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridMeanCurvature_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridMeanCurvature_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridMeanCurvature_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridMedian ****************/

extern StructRNA RNA_GeometryNodeSDFGridMedian;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridMedian_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridMedian_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridMedian_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSDFGridOffset ****************/

extern StructRNA RNA_GeometryNodeSDFGridOffset;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSDFGridOffset_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSDFGridOffset_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSDFGridOffset_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleCurve ****************/

extern StructRNA RNA_GeometryNodeSampleCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleCurve_use_all_curves_get(PointerRNA *ptr);
void GeometryNodeSampleCurve_use_all_curves_set(PointerRNA *ptr, bool value);

enum {
	GeometryNodeSampleCurve_data_type_FLOAT = 10,
	GeometryNodeSampleCurve_data_type_INT = 11,
	GeometryNodeSampleCurve_data_type_BOOLEAN = 50,
	GeometryNodeSampleCurve_data_type_FLOAT_VECTOR = 48,
	GeometryNodeSampleCurve_data_type_FLOAT_COLOR = 47,
	GeometryNodeSampleCurve_data_type_QUATERNION = 52,
	GeometryNodeSampleCurve_data_type_FLOAT4X4 = 20,
	GeometryNodeSampleCurve_data_type_STRING = 12,
	GeometryNodeSampleCurve_data_type_INT8 = 45,
	GeometryNodeSampleCurve_data_type_INT16_2D = 22,
	GeometryNodeSampleCurve_data_type_INT32_2D = 46,
	GeometryNodeSampleCurve_data_type_FLOAT2 = 49,
	GeometryNodeSampleCurve_data_type_BYTE_COLOR = 17,
};

int GeometryNodeSampleCurve_data_type_get(PointerRNA *ptr);
void GeometryNodeSampleCurve_data_type_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeSampleCurve_mode_FACTOR = 0,
	GeometryNodeSampleCurve_mode_LENGTH = 1,
};

int GeometryNodeSampleCurve_mode_get(PointerRNA *ptr);
void GeometryNodeSampleCurve_mode_set(PointerRNA *ptr, int value);

bool GeometryNodeSampleCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleGrid ****************/

extern StructRNA RNA_GeometryNodeSampleGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleGridIndex ****************/

extern StructRNA RNA_GeometryNodeSampleGridIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleGridIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleGridIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleGridIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleIndex ****************/

extern StructRNA RNA_GeometryNodeSampleIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleIndex_clamp_get(PointerRNA *ptr);
void GeometryNodeSampleIndex_clamp_set(PointerRNA *ptr, bool value);

enum {
	GeometryNodeSampleIndex_data_type_FLOAT = 10,
	GeometryNodeSampleIndex_data_type_INT = 11,
	GeometryNodeSampleIndex_data_type_BOOLEAN = 50,
	GeometryNodeSampleIndex_data_type_FLOAT_VECTOR = 48,
	GeometryNodeSampleIndex_data_type_FLOAT_COLOR = 47,
	GeometryNodeSampleIndex_data_type_QUATERNION = 52,
	GeometryNodeSampleIndex_data_type_FLOAT4X4 = 20,
	GeometryNodeSampleIndex_data_type_STRING = 12,
	GeometryNodeSampleIndex_data_type_INT8 = 45,
	GeometryNodeSampleIndex_data_type_INT16_2D = 22,
	GeometryNodeSampleIndex_data_type_INT32_2D = 46,
	GeometryNodeSampleIndex_data_type_FLOAT2 = 49,
	GeometryNodeSampleIndex_data_type_BYTE_COLOR = 17,
};

int GeometryNodeSampleIndex_data_type_get(PointerRNA *ptr);
void GeometryNodeSampleIndex_data_type_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeSampleIndex_domain_POINT = 0,
	GeometryNodeSampleIndex_domain_EDGE = 1,
	GeometryNodeSampleIndex_domain_FACE = 2,
	GeometryNodeSampleIndex_domain_CORNER = 3,
	GeometryNodeSampleIndex_domain_CURVE = 4,
	GeometryNodeSampleIndex_domain_INSTANCE = 5,
	GeometryNodeSampleIndex_domain_LAYER = 6,
};

int GeometryNodeSampleIndex_domain_get(PointerRNA *ptr);
void GeometryNodeSampleIndex_domain_set(PointerRNA *ptr, int value);

bool GeometryNodeSampleIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleNearest ****************/

extern StructRNA RNA_GeometryNodeSampleNearest;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleNearest_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleNearest_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleNearest_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleNearestSurface ****************/

extern StructRNA RNA_GeometryNodeSampleNearestSurface;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleNearestSurface_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleNearestSurface_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleNearestSurface_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSampleUVSurface ****************/

extern StructRNA RNA_GeometryNodeSampleUVSurface;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSampleUVSurface_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSampleUVSurface_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSampleUVSurface_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeScaleElements ****************/

extern StructRNA RNA_GeometryNodeScaleElements;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeScaleElements_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeScaleElements_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeScaleElements_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeScaleInstances ****************/

extern StructRNA RNA_GeometryNodeScaleInstances;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeScaleInstances_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeScaleInstances_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeScaleInstances_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSelfObject ****************/

extern StructRNA RNA_GeometryNodeSelfObject;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSelfObject_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSelfObject_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSelfObject_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSeparateComponents ****************/

extern StructRNA RNA_GeometryNodeSeparateComponents;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSeparateComponents_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSeparateComponents_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSeparateComponents_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSeparateGeometry ****************/

extern StructRNA RNA_GeometryNodeSeparateGeometry;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSeparateGeometry_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSeparateGeometry_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSeparateGeometry_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetCurveHandlePositions ****************/

extern StructRNA RNA_GeometryNodeSetCurveHandlePositions;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetCurveHandlePositions_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetCurveHandlePositions_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetCurveHandlePositions_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetCurveNormal ****************/

extern StructRNA RNA_GeometryNodeSetCurveNormal;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetCurveNormal_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetCurveNormal_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetCurveNormal_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetCurveRadius ****************/

extern StructRNA RNA_GeometryNodeSetCurveRadius;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetCurveRadius_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetCurveRadius_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetCurveRadius_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetCurveTilt ****************/

extern StructRNA RNA_GeometryNodeSetCurveTilt;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetCurveTilt_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetCurveTilt_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetCurveTilt_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGeometryName ****************/

extern StructRNA RNA_GeometryNodeSetGeometryName;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGeometryName_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGeometryName_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGeometryName_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGreasePencilColor ****************/

extern StructRNA RNA_GeometryNodeSetGreasePencilColor;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGreasePencilColor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGreasePencilColor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGreasePencilColor_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGreasePencilDepth ****************/

extern StructRNA RNA_GeometryNodeSetGreasePencilDepth;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGreasePencilDepth_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGreasePencilDepth_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGreasePencilDepth_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGreasePencilSoftness ****************/

extern StructRNA RNA_GeometryNodeSetGreasePencilSoftness;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGreasePencilSoftness_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGreasePencilSoftness_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGreasePencilSoftness_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGridBackground ****************/

extern StructRNA RNA_GeometryNodeSetGridBackground;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGridBackground_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGridBackground_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGridBackground_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetGridTransform ****************/

extern StructRNA RNA_GeometryNodeSetGridTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetGridTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetGridTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetGridTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetID ****************/

extern StructRNA RNA_GeometryNodeSetID;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetID_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetID_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetID_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetInstanceTransform ****************/

extern StructRNA RNA_GeometryNodeSetInstanceTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetInstanceTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetInstanceTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetInstanceTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetMaterial ****************/

extern StructRNA RNA_GeometryNodeSetMaterial;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetMaterial_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetMaterial_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetMaterial_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetMaterialIndex ****************/

extern StructRNA RNA_GeometryNodeSetMaterialIndex;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetMaterialIndex_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetMaterialIndex_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetMaterialIndex_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetMeshNormal ****************/

extern StructRNA RNA_GeometryNodeSetMeshNormal;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetMeshNormal_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetMeshNormal_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetMeshNormal_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetPointRadius ****************/

extern StructRNA RNA_GeometryNodeSetPointRadius;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetPointRadius_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetPointRadius_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetPointRadius_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetPosition ****************/

extern StructRNA RNA_GeometryNodeSetPosition;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetPosition_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetPosition_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetPosition_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetShadeSmooth ****************/

extern StructRNA RNA_GeometryNodeSetShadeSmooth;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetShadeSmooth_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetShadeSmooth_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetShadeSmooth_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetSplineCyclic ****************/

extern StructRNA RNA_GeometryNodeSetSplineCyclic;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetSplineCyclic_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetSplineCyclic_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetSplineCyclic_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSetSplineResolution ****************/

extern StructRNA RNA_GeometryNodeSetSplineResolution;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSetSplineResolution_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSetSplineResolution_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSetSplineResolution_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSimulationInput ****************/

extern StructRNA RNA_GeometryNodeSimulationInput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeSimulationInput_paired_output_get(PointerRNA *ptr);

bool GeometryNodeSimulationInput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSimulationInput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSimulationInput_output_template_func(struct StructRNA *_type, int index);
bool GeometryNodeSimulationInput_pair_with_output_func(struct ID *_selfid, struct bNode *_self, bContext *C, ReportList *reports, struct bNode *output_node);
/**************** GeometryNodeSimulationOutput ****************/

extern StructRNA RNA_GeometryNodeSimulationOutput;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

int GeometryNodeSimulationOutput_active_index_get(PointerRNA *ptr);
void GeometryNodeSimulationOutput_active_index_set(PointerRNA *ptr, int value);

PointerRNA GeometryNodeSimulationOutput_active_item_get(PointerRNA *ptr);

void GeometryNodeSimulationOutput_state_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeSimulationOutput_state_items_next(CollectionPropertyIterator *iter);
void GeometryNodeSimulationOutput_state_items_end(CollectionPropertyIterator *iter);
int GeometryNodeSimulationOutput_state_items_length(PointerRNA *ptr);
bool GeometryNodeSimulationOutput_state_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeSimulationOutput_state_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GeometryNodeSimulationOutput_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSimulationOutput_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSimulationOutput_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSortElements ****************/

extern StructRNA RNA_GeometryNodeSortElements;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSortElements_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSortElements_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSortElements_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSplineLength ****************/

extern StructRNA RNA_GeometryNodeSplineLength;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSplineLength_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSplineLength_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSplineLength_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSplineParameter ****************/

extern StructRNA RNA_GeometryNodeSplineParameter;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSplineParameter_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSplineParameter_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSplineParameter_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSplitEdges ****************/

extern StructRNA RNA_GeometryNodeSplitEdges;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSplitEdges_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSplitEdges_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSplitEdges_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSplitToInstances ****************/

extern StructRNA RNA_GeometryNodeSplitToInstances;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSplitToInstances_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSplitToInstances_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSplitToInstances_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeStoreNamedAttribute ****************/

extern StructRNA RNA_GeometryNodeStoreNamedAttribute;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeStoreNamedAttribute_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeStoreNamedAttribute_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeStoreNamedAttribute_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeStoreNamedGrid ****************/

extern StructRNA RNA_GeometryNodeStoreNamedGrid;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeStoreNamedGrid_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeStoreNamedGrid_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeStoreNamedGrid_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeStringJoin ****************/

extern StructRNA RNA_GeometryNodeStringJoin;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeStringJoin_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeStringJoin_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeStringJoin_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeStringToCurves ****************/

extern StructRNA RNA_GeometryNodeStringToCurves;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeStringToCurves_font_get(PointerRNA *ptr);

enum {
	GeometryNodeStringToCurves_align_x_LEFT = 0,
	GeometryNodeStringToCurves_align_x_CENTER = 1,
	GeometryNodeStringToCurves_align_x_RIGHT = 2,
	GeometryNodeStringToCurves_align_x_JUSTIFY = 3,
	GeometryNodeStringToCurves_align_x_FLUSH = 4,
};

int GeometryNodeStringToCurves_align_x_get(PointerRNA *ptr);
void GeometryNodeStringToCurves_align_x_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeStringToCurves_pivot_mode_MIDPOINT = 0,
	GeometryNodeStringToCurves_pivot_mode_TOP_LEFT = 1,
	GeometryNodeStringToCurves_pivot_mode_TOP_CENTER = 2,
	GeometryNodeStringToCurves_pivot_mode_TOP_RIGHT = 3,
	GeometryNodeStringToCurves_pivot_mode_BOTTOM_LEFT = 4,
	GeometryNodeStringToCurves_pivot_mode_BOTTOM_CENTER = 5,
	GeometryNodeStringToCurves_pivot_mode_BOTTOM_RIGHT = 6,
};

int GeometryNodeStringToCurves_pivot_mode_get(PointerRNA *ptr);
void GeometryNodeStringToCurves_pivot_mode_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeStringToCurves_overflow_OVERFLOW = 0,
	GeometryNodeStringToCurves_overflow_SCALE_TO_FIT = 1,
	GeometryNodeStringToCurves_overflow_TRUNCATE = 2,
};

int GeometryNodeStringToCurves_overflow_get(PointerRNA *ptr);
void GeometryNodeStringToCurves_overflow_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeStringToCurves_align_y_TOP = 1,
	GeometryNodeStringToCurves_align_y_TOP_BASELINE = 0,
	GeometryNodeStringToCurves_align_y_MIDDLE = 2,
	GeometryNodeStringToCurves_align_y_BOTTOM_BASELINE = 3,
	GeometryNodeStringToCurves_align_y_BOTTOM = 4,
};

int GeometryNodeStringToCurves_align_y_get(PointerRNA *ptr);
void GeometryNodeStringToCurves_align_y_set(PointerRNA *ptr, int value);

bool GeometryNodeStringToCurves_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeStringToCurves_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeStringToCurves_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSubdivideCurve ****************/

extern StructRNA RNA_GeometryNodeSubdivideCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSubdivideCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSubdivideCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSubdivideCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSubdivideMesh ****************/

extern StructRNA RNA_GeometryNodeSubdivideMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSubdivideMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSubdivideMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSubdivideMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSubdivisionSurface ****************/

extern StructRNA RNA_GeometryNodeSubdivisionSurface;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSubdivisionSurface_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSubdivisionSurface_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSubdivisionSurface_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeSwitch ****************/

extern StructRNA RNA_GeometryNodeSwitch;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeSwitch_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeSwitch_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeSwitch_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeTool3DCursor ****************/

extern StructRNA RNA_GeometryNodeTool3DCursor;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeTool3DCursor_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeTool3DCursor_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeTool3DCursor_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolActiveElement ****************/

extern StructRNA RNA_GeometryNodeToolActiveElement;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolActiveElement_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolActiveElement_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolActiveElement_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolFaceSet ****************/

extern StructRNA RNA_GeometryNodeToolFaceSet;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolFaceSet_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolFaceSet_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolFaceSet_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolMousePosition ****************/

extern StructRNA RNA_GeometryNodeToolMousePosition;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolMousePosition_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolMousePosition_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolMousePosition_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolSelection ****************/

extern StructRNA RNA_GeometryNodeToolSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolSetFaceSet ****************/

extern StructRNA RNA_GeometryNodeToolSetFaceSet;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolSetFaceSet_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolSetFaceSet_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolSetFaceSet_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeToolSetSelection ****************/

extern StructRNA RNA_GeometryNodeToolSetSelection;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeToolSetSelection_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeToolSetSelection_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeToolSetSelection_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeTransform ****************/

extern StructRNA RNA_GeometryNodeTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeTranslateInstances ****************/

extern StructRNA RNA_GeometryNodeTranslateInstances;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeTranslateInstances_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeTranslateInstances_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeTranslateInstances_output_template_func(struct StructRNA *_type, int index);
/**************** Geometry Node Tree ****************/

extern StructRNA RNA_GeometryNodeTree;
extern StructRNA RNA_NodeTree;
extern StructRNA RNA_ID;

bool GeometryNodeTree_is_type_curve_get(PointerRNA *ptr);
void GeometryNodeTree_is_type_curve_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_mode_object_get(PointerRNA *ptr);
void GeometryNodeTree_is_mode_object_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_mode_edit_get(PointerRNA *ptr);
void GeometryNodeTree_is_mode_edit_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_type_grease_pencil_get(PointerRNA *ptr);
void GeometryNodeTree_is_type_grease_pencil_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_type_mesh_get(PointerRNA *ptr);
void GeometryNodeTree_is_type_mesh_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_modifier_get(PointerRNA *ptr);
void GeometryNodeTree_is_modifier_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_mode_paint_get(PointerRNA *ptr);
void GeometryNodeTree_is_mode_paint_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_type_pointcloud_get(PointerRNA *ptr);
void GeometryNodeTree_is_type_pointcloud_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_mode_sculpt_get(PointerRNA *ptr);
void GeometryNodeTree_is_mode_sculpt_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_show_modifier_manage_panel_get(PointerRNA *ptr);
void GeometryNodeTree_show_modifier_manage_panel_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_is_tool_get(PointerRNA *ptr);
void GeometryNodeTree_is_tool_set(PointerRNA *ptr, bool value);

bool GeometryNodeTree_use_wait_for_click_get(PointerRNA *ptr);
void GeometryNodeTree_use_wait_for_click_set(PointerRNA *ptr, bool value);

/**************** GeometryNodeTriangulate ****************/

extern StructRNA RNA_GeometryNodeTriangulate;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeTriangulate_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeTriangulate_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeTriangulate_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeTrimCurve ****************/

extern StructRNA RNA_GeometryNodeTrimCurve;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeTrimCurve_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeTrimCurve_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeTrimCurve_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeUVPackIslands ****************/

extern StructRNA RNA_GeometryNodeUVPackIslands;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeUVPackIslands_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeUVPackIslands_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeUVPackIslands_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeUVTangent ****************/

extern StructRNA RNA_GeometryNodeUVTangent;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeUVTangent_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeUVTangent_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeUVTangent_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeUVUnwrap ****************/

extern StructRNA RNA_GeometryNodeUVUnwrap;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeUVUnwrap_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeUVUnwrap_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeUVUnwrap_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeVertexOfCorner ****************/

extern StructRNA RNA_GeometryNodeVertexOfCorner;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeVertexOfCorner_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeVertexOfCorner_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeVertexOfCorner_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeViewer ****************/

extern StructRNA RNA_GeometryNodeViewer;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

PointerRNA GeometryNodeViewer_active_item_get(PointerRNA *ptr);

int GeometryNodeViewer_active_index_get(PointerRNA *ptr);
void GeometryNodeViewer_active_index_set(PointerRNA *ptr, int value);

enum {
	GeometryNodeViewer_domain_AUTO = -1,
	GeometryNodeViewer_domain_POINT = 0,
	GeometryNodeViewer_domain_EDGE = 1,
	GeometryNodeViewer_domain_FACE = 2,
	GeometryNodeViewer_domain_CORNER = 3,
	GeometryNodeViewer_domain_CURVE = 4,
	GeometryNodeViewer_domain_INSTANCE = 5,
	GeometryNodeViewer_domain_LAYER = 6,
};

int GeometryNodeViewer_domain_get(PointerRNA *ptr);
void GeometryNodeViewer_domain_set(PointerRNA *ptr, int value);

void GeometryNodeViewer_viewer_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GeometryNodeViewer_viewer_items_next(CollectionPropertyIterator *iter);
void GeometryNodeViewer_viewer_items_end(CollectionPropertyIterator *iter);
int GeometryNodeViewer_viewer_items_length(PointerRNA *ptr);
bool GeometryNodeViewer_viewer_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GeometryNodeViewer_viewer_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GeometryNodeViewer_ui_shortcut_get(PointerRNA *ptr);
void GeometryNodeViewer_ui_shortcut_set(PointerRNA *ptr, int value);

bool GeometryNodeViewer_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeViewer_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeViewer_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeViewportTransform ****************/

extern StructRNA RNA_GeometryNodeViewportTransform;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeViewportTransform_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeViewportTransform_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeViewportTransform_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeVolumeCube ****************/

extern StructRNA RNA_GeometryNodeVolumeCube;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeVolumeCube_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeVolumeCube_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeVolumeCube_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeVolumeToMesh ****************/

extern StructRNA RNA_GeometryNodeVolumeToMesh;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeVolumeToMesh_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeVolumeToMesh_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeVolumeToMesh_output_template_func(struct StructRNA *_type, int index);
/**************** GeometryNodeWarning ****************/

extern StructRNA RNA_GeometryNodeWarning;
extern StructRNA RNA_GeometryNode;
extern StructRNA RNA_NodeInternal;
extern StructRNA RNA_Node;

bool GeometryNodeWarning_is_registered_node_type_func(struct StructRNA *_type);
struct PointerRNA GeometryNodeWarning_input_template_func(struct StructRNA *_type, int index);
struct PointerRNA GeometryNodeWarning_output_template_func(struct StructRNA *_type, int index);
/**************** Gizmo ****************/

extern StructRNA RNA_Gizmo;

PointerRNA Gizmo_rna_type_get(PointerRNA *ptr);

PointerRNA Gizmo_group_get(PointerRNA *ptr);

float Gizmo_alpha_get(PointerRNA *ptr);
void Gizmo_alpha_set(PointerRNA *ptr, float value);

float Gizmo_alpha_highlight_get(PointerRNA *ptr);
void Gizmo_alpha_highlight_set(PointerRNA *ptr, float value);

void Gizmo_matrix_basis_get(PointerRNA *ptr, float values[16]);
void Gizmo_matrix_basis_set(PointerRNA *ptr, const float values[16]);

void Gizmo_matrix_world_get(PointerRNA *ptr, float values[16]);
void Gizmo_matrix_world_set(PointerRNA *ptr, const float values[16]);

bool Gizmo_use_grab_cursor_get(PointerRNA *ptr);
void Gizmo_use_grab_cursor_set(PointerRNA *ptr, bool value);

bool Gizmo_use_event_handle_all_get(PointerRNA *ptr);
void Gizmo_use_event_handle_all_set(PointerRNA *ptr, bool value);

bool Gizmo_hide_get(PointerRNA *ptr);
void Gizmo_hide_set(PointerRNA *ptr, bool value);

bool Gizmo_hide_keymap_get(PointerRNA *ptr);
void Gizmo_hide_keymap_set(PointerRNA *ptr, bool value);

bool Gizmo_hide_select_get(PointerRNA *ptr);
void Gizmo_hide_select_set(PointerRNA *ptr, bool value);

bool Gizmo_is_highlight_get(PointerRNA *ptr);
void Gizmo_is_highlight_set(PointerRNA *ptr, bool value);

bool Gizmo_is_modal_get(PointerRNA *ptr);
void Gizmo_is_modal_set(PointerRNA *ptr, bool value);

float Gizmo_line_width_get(PointerRNA *ptr);
void Gizmo_line_width_set(PointerRNA *ptr, float value);

void Gizmo_matrix_offset_get(PointerRNA *ptr, float values[16]);
void Gizmo_matrix_offset_set(PointerRNA *ptr, const float values[16]);

PointerRNA Gizmo_properties_get(PointerRNA *ptr);

bool Gizmo_use_draw_scale_get(PointerRNA *ptr);
void Gizmo_use_draw_scale_set(PointerRNA *ptr, bool value);

float Gizmo_scale_basis_get(PointerRNA *ptr);
void Gizmo_scale_basis_set(PointerRNA *ptr, float value);

bool Gizmo_use_draw_offset_scale_get(PointerRNA *ptr);
void Gizmo_use_draw_offset_scale_set(PointerRNA *ptr, bool value);

bool Gizmo_select_get(PointerRNA *ptr);
void Gizmo_select_set(PointerRNA *ptr, bool value);

bool Gizmo_use_select_background_get(PointerRNA *ptr);
void Gizmo_use_select_background_set(PointerRNA *ptr, bool value);

float Gizmo_select_bias_get(PointerRNA *ptr);
void Gizmo_select_bias_set(PointerRNA *ptr, float value);

bool Gizmo_use_draw_modal_get(PointerRNA *ptr);
void Gizmo_use_draw_modal_set(PointerRNA *ptr, bool value);

bool Gizmo_use_draw_hover_get(PointerRNA *ptr);
void Gizmo_use_draw_hover_set(PointerRNA *ptr, bool value);

bool Gizmo_use_draw_value_get(PointerRNA *ptr);
void Gizmo_use_draw_value_set(PointerRNA *ptr, bool value);

void Gizmo_matrix_space_get(PointerRNA *ptr, float values[16]);
void Gizmo_matrix_space_set(PointerRNA *ptr, const float values[16]);

bool Gizmo_use_operator_tool_properties_get(PointerRNA *ptr);
void Gizmo_use_operator_tool_properties_set(PointerRNA *ptr, bool value);

bool Gizmo_use_tooltip_get(PointerRNA *ptr);
void Gizmo_use_tooltip_set(PointerRNA *ptr, bool value);

#define Gizmo_bl_idname_MAX 64

void Gizmo_bl_idname_get(PointerRNA *ptr, char *value);
int Gizmo_bl_idname_length(PointerRNA *ptr);
void Gizmo_bl_idname_set(PointerRNA *ptr, const char *value);

void Gizmo_color_get(PointerRNA *ptr, float values[3]);
void Gizmo_color_set(PointerRNA *ptr, const float values[3]);

void Gizmo_color_highlight_get(PointerRNA *ptr, float values[3]);
void Gizmo_color_highlight_set(PointerRNA *ptr, const float values[3]);

void Gizmo_draw_func(struct wmGizmo *_self, struct bContext *context);
void Gizmo_draw_select_func(struct wmGizmo *_self, struct bContext *context, int select_id);
int Gizmo_test_select_func(struct wmGizmo *_self, struct bContext *context, int location[2]);
int Gizmo_modal_func(struct wmGizmo *_self, struct bContext *context, struct wmEvent *event, int tweak);
void Gizmo_setup_func(struct wmGizmo *_self);
int Gizmo_invoke_func(struct wmGizmo *_self, struct bContext *context, struct wmEvent *event);
void Gizmo_exit_func(struct wmGizmo *_self, struct bContext *context, bool cancel);
void Gizmo_select_refresh_func(struct wmGizmo *_self);
void Gizmo_draw_preset_box_func(struct wmGizmo *_self, float matrix[16], int select_id);
void Gizmo_draw_preset_arrow_func(struct wmGizmo *_self, float matrix[16], int axis, int select_id);
void Gizmo_draw_preset_circle_func(struct wmGizmo *_self, float matrix[16], int axis, int select_id);
void Gizmo_target_set_prop_func(struct wmGizmo *_self, ReportList *reports, const char * target, struct PointerRNA *data, const char * property, int index);
struct PointerRNA Gizmo_target_set_operator_func(struct wmGizmo *_self, ReportList *reports, const char * operator_value, int index);
bool Gizmo_target_is_valid_func(struct wmGizmo *_self, ReportList *reports, const char * property);
/**************** GizmoGroup ****************/

extern StructRNA RNA_GizmoGroup;

PointerRNA GizmoGroup_rna_type_get(PointerRNA *ptr);

void GizmoGroup_name_get(PointerRNA *ptr, char *value);
int GizmoGroup_name_length(PointerRNA *ptr);
void GizmoGroup_name_set(PointerRNA *ptr, const char *value);

void GizmoGroup_gizmos_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GizmoGroup_gizmos_next(CollectionPropertyIterator *iter);
void GizmoGroup_gizmos_end(CollectionPropertyIterator *iter);
bool GizmoGroup_gizmos_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	GizmoGroup_bl_options_3D = 1,
	GizmoGroup_bl_options_SCALE = 2,
	GizmoGroup_bl_options_DEPTH_3D = 4,
	GizmoGroup_bl_options_SELECT = 8,
	GizmoGroup_bl_options_PERSISTENT = 16,
	GizmoGroup_bl_options_SHOW_MODAL_ALL = 32,
	GizmoGroup_bl_options_EXCLUDE_MODAL = 64,
	GizmoGroup_bl_options_TOOL_INIT = 128,
	GizmoGroup_bl_options_TOOL_FALLBACK_KEYMAP = 256,
	GizmoGroup_bl_options_VR_REDRAWS = 1024,
};

int GizmoGroup_bl_options_get(PointerRNA *ptr);
void GizmoGroup_bl_options_set(PointerRNA *ptr, int value);

enum {
	GizmoGroup_bl_region_type_WINDOW = 0,
	GizmoGroup_bl_region_type_HEADER = 1,
	GizmoGroup_bl_region_type_CHANNELS = 2,
	GizmoGroup_bl_region_type_TEMPORARY = 3,
	GizmoGroup_bl_region_type_UI = 4,
	GizmoGroup_bl_region_type_TOOLS = 5,
	GizmoGroup_bl_region_type_TOOL_PROPS = 6,
	GizmoGroup_bl_region_type_ASSET_SHELF = 14,
	GizmoGroup_bl_region_type_ASSET_SHELF_HEADER = 15,
	GizmoGroup_bl_region_type_PREVIEW = 7,
	GizmoGroup_bl_region_type_HUD = 8,
	GizmoGroup_bl_region_type_NAVIGATION_BAR = 9,
	GizmoGroup_bl_region_type_EXECUTE = 10,
	GizmoGroup_bl_region_type_FOOTER = 11,
	GizmoGroup_bl_region_type_TOOL_HEADER = 12,
	GizmoGroup_bl_region_type_XR = 13,
};

int GizmoGroup_bl_region_type_get(PointerRNA *ptr);
void GizmoGroup_bl_region_type_set(PointerRNA *ptr, int value);

enum {
	GizmoGroup_bl_space_type_EMPTY = 0,
	GizmoGroup_bl_space_type_VIEW_3D = 1,
	GizmoGroup_bl_space_type_IMAGE_EDITOR = 6,
	GizmoGroup_bl_space_type_NODE_EDITOR = 16,
	GizmoGroup_bl_space_type_SEQUENCE_EDITOR = 8,
	GizmoGroup_bl_space_type_CLIP_EDITOR = 20,
	GizmoGroup_bl_space_type_DOPESHEET_EDITOR = 12,
	GizmoGroup_bl_space_type_GRAPH_EDITOR = 2,
	GizmoGroup_bl_space_type_NLA_EDITOR = 13,
	GizmoGroup_bl_space_type_TEXT_EDITOR = 9,
	GizmoGroup_bl_space_type_CONSOLE = 18,
	GizmoGroup_bl_space_type_INFO = 7,
	GizmoGroup_bl_space_type_TOPBAR = 21,
	GizmoGroup_bl_space_type_STATUSBAR = 22,
	GizmoGroup_bl_space_type_OUTLINER = 3,
	GizmoGroup_bl_space_type_PROPERTIES = 4,
	GizmoGroup_bl_space_type_FILE_BROWSER = 5,
	GizmoGroup_bl_space_type_SPREADSHEET = 23,
	GizmoGroup_bl_space_type_PREFERENCES = 19,
};

int GizmoGroup_bl_space_type_get(PointerRNA *ptr);
void GizmoGroup_bl_space_type_set(PointerRNA *ptr, int value);

#define GizmoGroup_bl_idname_MAX 64

void GizmoGroup_bl_idname_get(PointerRNA *ptr, char *value);
int GizmoGroup_bl_idname_length(PointerRNA *ptr);
void GizmoGroup_bl_idname_set(PointerRNA *ptr, const char *value);

#define GizmoGroup_bl_label_MAX 64

void GizmoGroup_bl_label_get(PointerRNA *ptr, char *value);
int GizmoGroup_bl_label_length(PointerRNA *ptr);
void GizmoGroup_bl_label_set(PointerRNA *ptr, const char *value);

void GizmoGroup_bl_owner_id_get(PointerRNA *ptr, char *value);
int GizmoGroup_bl_owner_id_length(PointerRNA *ptr);
void GizmoGroup_bl_owner_id_set(PointerRNA *ptr, const char *value);

bool GizmoGroup_poll_func(struct bContext *context);
struct wmKeyMap *GizmoGroup_setup_keymap_func(struct wmKeyConfig *keyconfig);
void GizmoGroup_setup_func(struct wmGizmoGroup *_self, struct bContext *context);
void GizmoGroup_refresh_func(struct wmGizmoGroup *_self, struct bContext *context);
void GizmoGroup_draw_prepare_func(struct wmGizmoGroup *_self, struct bContext *context);
void GizmoGroup_invoke_prepare_func(struct wmGizmoGroup *_self, struct bContext *context, struct wmGizmo *gizmo);
/**************** Gizmo Group Properties ****************/

extern StructRNA RNA_GizmoGroupProperties;

PointerRNA GizmoGroupProperties_rna_type_get(PointerRNA *ptr);

struct IDPropertyGroup *GizmoGroupProperties_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
/**************** Gizmo Properties ****************/

extern StructRNA RNA_GizmoProperties;

PointerRNA GizmoProperties_rna_type_get(PointerRNA *ptr);

struct IDPropertyGroup *GizmoProperties_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
/**************** Gizmos ****************/

extern StructRNA RNA_Gizmos;

PointerRNA Gizmos_rna_type_get(PointerRNA *ptr);

struct wmGizmo *Gizmos_new_func(struct wmGizmoGroup *_self, ReportList *reports, const char * type);
void Gizmos_remove_func(struct wmGizmoGroup *_self, bContext *C, struct wmGizmo *gizmo);
void Gizmos_clear_func(struct wmGizmoGroup *_self, bContext *C);
/**************** Glow Strip ****************/

extern StructRNA RNA_GlowStrip;
extern StructRNA RNA_EffectStrip;
extern StructRNA RNA_Strip;

float GlowStrip_blur_radius_get(PointerRNA *ptr);
void GlowStrip_blur_radius_set(PointerRNA *ptr, float value);

float GlowStrip_boost_factor_get(PointerRNA *ptr);
void GlowStrip_boost_factor_set(PointerRNA *ptr, float value);

float GlowStrip_clamp_get(PointerRNA *ptr);
void GlowStrip_clamp_set(PointerRNA *ptr, float value);

PointerRNA GlowStrip_input_1_get(PointerRNA *ptr);

bool GlowStrip_use_only_boost_get(PointerRNA *ptr);
void GlowStrip_use_only_boost_set(PointerRNA *ptr, bool value);

int GlowStrip_quality_get(PointerRNA *ptr);
void GlowStrip_quality_set(PointerRNA *ptr, int value);

float GlowStrip_threshold_get(PointerRNA *ptr);
void GlowStrip_threshold_set(PointerRNA *ptr, float value);

int GlowStrip_input_count_get(PointerRNA *ptr);
void GlowStrip_input_count_set(PointerRNA *ptr, int value);

/**************** Grease Pencil Paint ****************/

extern StructRNA RNA_GpPaint;
extern StructRNA RNA_Paint;

enum {
	GpPaint_color_mode_MATERIAL = 0,
	GpPaint_color_mode_VERTEXCOLOR = 1,
};

int GpPaint_color_mode_get(PointerRNA *ptr);
void GpPaint_color_mode_set(PointerRNA *ptr, int value);

/**************** Grease Pencil Sculpt Paint ****************/

extern StructRNA RNA_GpSculptPaint;
extern StructRNA RNA_Paint;

/**************** Grease Pencil Vertex Paint ****************/

extern StructRNA RNA_GpVertexPaint;
extern StructRNA RNA_Paint;

/**************** Grease Pencil Weight Paint ****************/

extern StructRNA RNA_GpWeightPaint;
extern StructRNA RNA_Paint;

/**************** Grease Pencil ****************/

extern StructRNA RNA_GreasePencil;
extern StructRNA RNA_ID;

void GreasePencil_after_color_get(PointerRNA *ptr, float values[3]);
void GreasePencil_after_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA GreasePencil_animation_data_get(PointerRNA *ptr);

void GreasePencil_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_attributes_next(CollectionPropertyIterator *iter);
void GreasePencil_attributes_end(CollectionPropertyIterator *iter);
int GreasePencil_attributes_length(PointerRNA *ptr);
bool GreasePencil_attributes_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GreasePencil_use_autolock_layers_get(PointerRNA *ptr);
void GreasePencil_use_autolock_layers_set(PointerRNA *ptr, bool value);

void GreasePencil_before_color_get(PointerRNA *ptr, float values[3]);
void GreasePencil_before_color_set(PointerRNA *ptr, const float values[3]);

void GreasePencil_color_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_color_attributes_next(CollectionPropertyIterator *iter);
void GreasePencil_color_attributes_end(CollectionPropertyIterator *iter);
int GreasePencil_color_attributes_length(PointerRNA *ptr);

bool GreasePencil_use_onion_fade_get(PointerRNA *ptr);
void GreasePencil_use_onion_fade_set(PointerRNA *ptr, bool value);

enum {
	GreasePencil_onion_keyframe_type_ALL = 31,
	GreasePencil_onion_keyframe_type_KEYFRAME = 1,
	GreasePencil_onion_keyframe_type_BREAKDOWN = 4,
	GreasePencil_onion_keyframe_type_MOVING_HOLD = 16,
	GreasePencil_onion_keyframe_type_EXTREME = 2,
	GreasePencil_onion_keyframe_type_JITTER = 8,
	GreasePencil_onion_keyframe_type_GENERATED = 5,
};

int GreasePencil_onion_keyframe_type_get(PointerRNA *ptr);
void GreasePencil_onion_keyframe_type_set(PointerRNA *ptr, int value);

int GreasePencil_ghost_after_range_get(PointerRNA *ptr);
void GreasePencil_ghost_after_range_set(PointerRNA *ptr, int value);

int GreasePencil_ghost_before_range_get(PointerRNA *ptr);
void GreasePencil_ghost_before_range_set(PointerRNA *ptr, int value);

void GreasePencil_layer_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_layer_groups_next(CollectionPropertyIterator *iter);
void GreasePencil_layer_groups_end(CollectionPropertyIterator *iter);
int GreasePencil_layer_groups_length(PointerRNA *ptr);

void GreasePencil_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_layers_next(CollectionPropertyIterator *iter);
void GreasePencil_layers_end(CollectionPropertyIterator *iter);
int GreasePencil_layers_length(PointerRNA *ptr);

void GreasePencil_materials_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencil_materials_next(CollectionPropertyIterator *iter);
void GreasePencil_materials_end(CollectionPropertyIterator *iter);
int GreasePencil_materials_length(PointerRNA *ptr);
bool GreasePencil_materials_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GreasePencil_materials_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

enum {
	GreasePencil_onion_mode_ABSOLUTE = 0,
	GreasePencil_onion_mode_RELATIVE = 1,
	GreasePencil_onion_mode_SELECTED = 2,
};

int GreasePencil_onion_mode_get(PointerRNA *ptr);
void GreasePencil_onion_mode_set(PointerRNA *ptr, int value);

float GreasePencil_onion_factor_get(PointerRNA *ptr);
void GreasePencil_onion_factor_set(PointerRNA *ptr, float value);

bool GreasePencil_use_onion_loop_get(PointerRNA *ptr);
void GreasePencil_use_onion_loop_set(PointerRNA *ptr, bool value);

enum {
	GreasePencil_stroke_depth_order_2D = 0,
	GreasePencil_stroke_depth_order_3D = 4,
};

int GreasePencil_stroke_depth_order_get(PointerRNA *ptr);
void GreasePencil_stroke_depth_order_set(PointerRNA *ptr, int value);

bool GreasePencil_use_ghost_custom_colors_get(PointerRNA *ptr);
void GreasePencil_use_ghost_custom_colors_set(PointerRNA *ptr, bool value);

/**************** Armature Modifier ****************/

extern StructRNA RNA_GreasePencilArmatureModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilArmatureModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilArmatureModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilArmatureModifier_object_get(PointerRNA *ptr);

bool GreasePencilArmatureModifier_use_deform_preserve_volume_get(PointerRNA *ptr);
void GreasePencilArmatureModifier_use_deform_preserve_volume_set(PointerRNA *ptr, bool value);

bool GreasePencilArmatureModifier_use_bone_envelopes_get(PointerRNA *ptr);
void GreasePencilArmatureModifier_use_bone_envelopes_set(PointerRNA *ptr, bool value);

bool GreasePencilArmatureModifier_use_vertex_groups_get(PointerRNA *ptr);
void GreasePencilArmatureModifier_use_vertex_groups_set(PointerRNA *ptr, bool value);

#define GreasePencilArmatureModifier_vertex_group_name_MAX 64

void GreasePencilArmatureModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilArmatureModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilArmatureModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilArmatureModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilArmatureModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Instance Modifier ****************/

extern StructRNA RNA_GreasePencilArrayModifier;
extern StructRNA RNA_Modifier;

void GreasePencilArrayModifier_constant_offset_get(PointerRNA *ptr, float values[3]);
void GreasePencilArrayModifier_constant_offset_set(PointerRNA *ptr, const float values[3]);

int GreasePencilArrayModifier_count_get(PointerRNA *ptr);
void GreasePencilArrayModifier_count_set(PointerRNA *ptr, int value);

bool GreasePencilArrayModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilArrayModifier_tree_node_filter_MAX 64

void GreasePencilArrayModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilArrayModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilArrayModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilArrayModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilArrayModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilArrayModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilArrayModifier_replace_material_get(PointerRNA *ptr);
void GreasePencilArrayModifier_replace_material_set(PointerRNA *ptr, int value);

int GreasePencilArrayModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_material_pass_filter_set(PointerRNA *ptr, int value);

bool GreasePencilArrayModifier_use_constant_offset_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_constant_offset_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilArrayModifier_offset_object_get(PointerRNA *ptr);

void GreasePencilArrayModifier_random_offset_get(PointerRNA *ptr, float values[3]);
void GreasePencilArrayModifier_random_offset_set(PointerRNA *ptr, const float values[3]);

void GreasePencilArrayModifier_random_rotation_get(PointerRNA *ptr, float values[3]);
void GreasePencilArrayModifier_random_rotation_set(PointerRNA *ptr, const float values[3]);

void GreasePencilArrayModifier_relative_offset_get(PointerRNA *ptr, float values[3]);
void GreasePencilArrayModifier_relative_offset_set(PointerRNA *ptr, const float values[3]);

void GreasePencilArrayModifier_random_scale_get(PointerRNA *ptr, float values[3]);
void GreasePencilArrayModifier_random_scale_set(PointerRNA *ptr, const float values[3]);

int GreasePencilArrayModifier_seed_get(PointerRNA *ptr);
void GreasePencilArrayModifier_seed_set(PointerRNA *ptr, int value);

bool GreasePencilArrayModifier_use_relative_offset_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_relative_offset_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_use_uniform_random_scale_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_uniform_random_scale_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_use_object_offset_get(PointerRNA *ptr);
void GreasePencilArrayModifier_use_object_offset_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_open_constant_offset_panel_get(PointerRNA *ptr);
void GreasePencilArrayModifier_open_constant_offset_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilArrayModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_open_object_offset_panel_get(PointerRNA *ptr);
void GreasePencilArrayModifier_open_object_offset_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_open_randomize_panel_get(PointerRNA *ptr);
void GreasePencilArrayModifier_open_randomize_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilArrayModifier_open_relative_offset_panel_get(PointerRNA *ptr);
void GreasePencilArrayModifier_open_relative_offset_panel_set(PointerRNA *ptr, bool value);

/**************** Build Modifier ****************/

extern StructRNA RNA_GreasePencilBuildModifier;
extern StructRNA RNA_Modifier;

float GreasePencilBuildModifier_start_delay_get(PointerRNA *ptr);
void GreasePencilBuildModifier_start_delay_set(PointerRNA *ptr, float value);

float GreasePencilBuildModifier_frame_end_get(PointerRNA *ptr);
void GreasePencilBuildModifier_frame_end_set(PointerRNA *ptr, float value);

float GreasePencilBuildModifier_percentage_factor_get(PointerRNA *ptr);
void GreasePencilBuildModifier_percentage_factor_set(PointerRNA *ptr, float value);

float GreasePencilBuildModifier_fade_factor_get(PointerRNA *ptr);
void GreasePencilBuildModifier_fade_factor_set(PointerRNA *ptr, float value);

bool GreasePencilBuildModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilBuildModifier_tree_node_filter_MAX 64

void GreasePencilBuildModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilBuildModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilBuildModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilBuildModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilBuildModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilBuildModifier_length_get(PointerRNA *ptr);
void GreasePencilBuildModifier_length_set(PointerRNA *ptr, float value);

PointerRNA GreasePencilBuildModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilBuildModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_material_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilBuildModifier_speed_maxgap_get(PointerRNA *ptr);
void GreasePencilBuildModifier_speed_maxgap_set(PointerRNA *ptr, float value);

enum {
	GreasePencilBuildModifier_mode_SEQUENTIAL = 0,
	GreasePencilBuildModifier_mode_CONCURRENT = 1,
	GreasePencilBuildModifier_mode_ADDITIVE = 2,
};

int GreasePencilBuildModifier_mode_get(PointerRNA *ptr);
void GreasePencilBuildModifier_mode_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilBuildModifier_object_get(PointerRNA *ptr);

float GreasePencilBuildModifier_fade_opacity_strength_get(PointerRNA *ptr);
void GreasePencilBuildModifier_fade_opacity_strength_set(PointerRNA *ptr, float value);

bool GreasePencilBuildModifier_use_restrict_frame_range_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_restrict_frame_range_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_use_percentage_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_percentage_set(PointerRNA *ptr, bool value);

float GreasePencilBuildModifier_speed_factor_get(PointerRNA *ptr);
void GreasePencilBuildModifier_speed_factor_set(PointerRNA *ptr, float value);

float GreasePencilBuildModifier_frame_start_get(PointerRNA *ptr);
void GreasePencilBuildModifier_frame_start_set(PointerRNA *ptr, float value);

float GreasePencilBuildModifier_fade_thickness_strength_get(PointerRNA *ptr);
void GreasePencilBuildModifier_fade_thickness_strength_set(PointerRNA *ptr, float value);

enum {
	GreasePencilBuildModifier_concurrent_time_alignment_START = 0,
	GreasePencilBuildModifier_concurrent_time_alignment_END = 1,
};

int GreasePencilBuildModifier_concurrent_time_alignment_get(PointerRNA *ptr);
void GreasePencilBuildModifier_concurrent_time_alignment_set(PointerRNA *ptr, int value);

enum {
	GreasePencilBuildModifier_time_mode_DRAWSPEED = 2,
	GreasePencilBuildModifier_time_mode_FRAMES = 0,
	GreasePencilBuildModifier_time_mode_PERCENTAGE = 1,
};

int GreasePencilBuildModifier_time_mode_get(PointerRNA *ptr);
void GreasePencilBuildModifier_time_mode_set(PointerRNA *ptr, int value);

enum {
	GreasePencilBuildModifier_transition_GROW = 0,
	GreasePencilBuildModifier_transition_SHRINK = 1,
	GreasePencilBuildModifier_transition_FADE = 2,
};

int GreasePencilBuildModifier_transition_get(PointerRNA *ptr);
void GreasePencilBuildModifier_transition_set(PointerRNA *ptr, int value);

bool GreasePencilBuildModifier_use_fading_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_fading_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilBuildModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilBuildModifier_target_vertex_group_MAX 64

void GreasePencilBuildModifier_target_vertex_group_get(PointerRNA *ptr, char *value);
int GreasePencilBuildModifier_target_vertex_group_length(PointerRNA *ptr);
void GreasePencilBuildModifier_target_vertex_group_set(PointerRNA *ptr, const char *value);

bool GreasePencilBuildModifier_open_fading_panel_get(PointerRNA *ptr);
void GreasePencilBuildModifier_open_fading_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_open_frame_range_panel_get(PointerRNA *ptr);
void GreasePencilBuildModifier_open_frame_range_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilBuildModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilBuildModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Color Modifier ****************/

extern StructRNA RNA_GreasePencilColorModifier;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilColorModifier_custom_curve_get(PointerRNA *ptr);

float GreasePencilColorModifier_hue_get(PointerRNA *ptr);
void GreasePencilColorModifier_hue_set(PointerRNA *ptr, float value);

bool GreasePencilColorModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilColorModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilColorModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilColorModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilColorModifier_tree_node_filter_MAX 64

void GreasePencilColorModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilColorModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilColorModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilColorModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilColorModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilColorModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilColorModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilColorModifier_color_mode_BOTH = 2,
	GreasePencilColorModifier_color_mode_STROKE = 0,
	GreasePencilColorModifier_color_mode_FILL = 1,
};

int GreasePencilColorModifier_color_mode_get(PointerRNA *ptr);
void GreasePencilColorModifier_color_mode_set(PointerRNA *ptr, int value);

float GreasePencilColorModifier_saturation_get(PointerRNA *ptr);
void GreasePencilColorModifier_saturation_set(PointerRNA *ptr, float value);

bool GreasePencilColorModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilColorModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilColorModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilColorModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilColorModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

float GreasePencilColorModifier_value_get(PointerRNA *ptr);
void GreasePencilColorModifier_value_set(PointerRNA *ptr, float value);

bool GreasePencilColorModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilColorModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Dash Modifier ****************/

extern StructRNA RNA_GreasePencilDashModifierData;
extern StructRNA RNA_Modifier;

int GreasePencilDashModifierData_segment_active_index_get(PointerRNA *ptr);
void GreasePencilDashModifierData_segment_active_index_set(PointerRNA *ptr, int value);

bool GreasePencilDashModifierData_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilDashModifierData_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilDashModifierData_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilDashModifierData_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilDashModifierData_tree_node_filter_MAX 64

void GreasePencilDashModifierData_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilDashModifierData_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilDashModifierData_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilDashModifierData_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilDashModifierData_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilDashModifierData_material_filter_get(PointerRNA *ptr);

int GreasePencilDashModifierData_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_material_pass_filter_set(PointerRNA *ptr, int value);

int GreasePencilDashModifierData_dash_offset_get(PointerRNA *ptr);
void GreasePencilDashModifierData_dash_offset_set(PointerRNA *ptr, int value);

void GreasePencilDashModifierData_segments_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilDashModifierData_segments_next(CollectionPropertyIterator *iter);
void GreasePencilDashModifierData_segments_end(CollectionPropertyIterator *iter);
bool GreasePencilDashModifierData_segments_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GreasePencilDashModifierData_segments_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool GreasePencilDashModifierData_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilDashModifierData_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilDashModifierData_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilDashModifierData_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilDashModifierData_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Dash Modifier Segment ****************/

extern StructRNA RNA_GreasePencilDashModifierSegment;

PointerRNA GreasePencilDashModifierSegment_rna_type_get(PointerRNA *ptr);

#define GreasePencilDashModifierSegment_name_MAX 64

void GreasePencilDashModifierSegment_name_get(PointerRNA *ptr, char *value);
int GreasePencilDashModifierSegment_name_length(PointerRNA *ptr);
void GreasePencilDashModifierSegment_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilDashModifierSegment_use_cyclic_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_use_cyclic_set(PointerRNA *ptr, bool value);

int GreasePencilDashModifierSegment_dash_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_dash_set(PointerRNA *ptr, int value);

int GreasePencilDashModifierSegment_gap_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_gap_set(PointerRNA *ptr, int value);

int GreasePencilDashModifierSegment_material_index_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_material_index_set(PointerRNA *ptr, int value);

float GreasePencilDashModifierSegment_opacity_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_opacity_set(PointerRNA *ptr, float value);

float GreasePencilDashModifierSegment_radius_get(PointerRNA *ptr);
void GreasePencilDashModifierSegment_radius_set(PointerRNA *ptr, float value);

/**************** Grease Pencil Drawing ****************/

extern StructRNA RNA_GreasePencilDrawing;

PointerRNA GreasePencilDrawing_rna_type_get(PointerRNA *ptr);

void GreasePencilDrawing_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilDrawing_attributes_next(CollectionPropertyIterator *iter);
void GreasePencilDrawing_attributes_end(CollectionPropertyIterator *iter);
int GreasePencilDrawing_attributes_length(PointerRNA *ptr);
bool GreasePencilDrawing_attributes_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void GreasePencilDrawing_color_attributes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilDrawing_color_attributes_next(CollectionPropertyIterator *iter);
void GreasePencilDrawing_color_attributes_end(CollectionPropertyIterator *iter);
int GreasePencilDrawing_color_attributes_length(PointerRNA *ptr);

void GreasePencilDrawing_curve_offsets_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilDrawing_curve_offsets_next(CollectionPropertyIterator *iter);
void GreasePencilDrawing_curve_offsets_end(CollectionPropertyIterator *iter);
int GreasePencilDrawing_curve_offsets_length(PointerRNA *ptr);
bool GreasePencilDrawing_curve_offsets_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

enum {
	GreasePencilDrawing_type_DRAWING = 0,
	GreasePencilDrawing_type_REFERENCE = 1,
};

int GreasePencilDrawing_type_get(PointerRNA *ptr);
void GreasePencilDrawing_type_set(PointerRNA *ptr, int value);

int GreasePencilDrawing_user_count_get(PointerRNA *ptr);
void GreasePencilDrawing_user_count_set(PointerRNA *ptr, int value);

void GreasePencilDrawing_add_strokes_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, int sizes_num, int *sizes);
void GreasePencilDrawing_remove_strokes_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, int indices_num, int *indices);
void GreasePencilDrawing_resize_strokes_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, int sizes_num, int *sizes, int indices_num, int *indices);
void GreasePencilDrawing_reorder_strokes_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, int new_indices_num, int *new_indices);
void GreasePencilDrawing_set_types_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, int type, int indices_num, int *indices);
void GreasePencilDrawing_tag_positions_changed_func(struct GreasePencilDrawing *_self);
void GreasePencilDrawing_vertex_group_assign_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, const char * vgroup_name, int indices_ptr_num, int *indices_ptr, float weight);
void GreasePencilDrawing_vertex_group_remove_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, const char * vgroup_name, int indices_ptr_num, int *indices_ptr);
void GreasePencilDrawing_set_vertex_weights_func(struct ID *_selfid, struct GreasePencilDrawing *_self, ReportList *reports, const char * vertex_group_name, int indices_num, int *indices, int weights_num, float *weights, int assign_mode);
/**************** Grease Pencil Envelope Modifier ****************/

extern StructRNA RNA_GreasePencilEnvelopeModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilEnvelopeModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilEnvelopeModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilEnvelopeModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilEnvelopeModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilEnvelopeModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilEnvelopeModifier_tree_node_filter_MAX 64

void GreasePencilEnvelopeModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilEnvelopeModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilEnvelopeModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilEnvelopeModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilEnvelopeModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilEnvelopeModifier_mat_nr_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_mat_nr_set(PointerRNA *ptr, int value);

int GreasePencilEnvelopeModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilEnvelopeModifier_mode_DEFORM = 0,
	GreasePencilEnvelopeModifier_mode_SEGMENTS = 1,
	GreasePencilEnvelopeModifier_mode_FILLS = 2,
};

int GreasePencilEnvelopeModifier_mode_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_mode_set(PointerRNA *ptr, int value);

int GreasePencilEnvelopeModifier_skip_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_skip_set(PointerRNA *ptr, int value);

int GreasePencilEnvelopeModifier_spread_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_spread_set(PointerRNA *ptr, int value);

float GreasePencilEnvelopeModifier_strength_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_strength_set(PointerRNA *ptr, float value);

float GreasePencilEnvelopeModifier_thickness_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_thickness_set(PointerRNA *ptr, float value);

bool GreasePencilEnvelopeModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilEnvelopeModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilEnvelopeModifier_vertex_group_name_MAX 64

void GreasePencilEnvelopeModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilEnvelopeModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilEnvelopeModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilEnvelopeModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Frame ****************/

extern StructRNA RNA_GreasePencilFrame;

PointerRNA GreasePencilFrame_rna_type_get(PointerRNA *ptr);

PointerRNA GreasePencilFrame_drawing_get(PointerRNA *ptr);

int GreasePencilFrame_frame_number_get(PointerRNA *ptr);
void GreasePencilFrame_frame_number_set(PointerRNA *ptr, int value);

enum {
	GreasePencilFrame_keyframe_type_KEYFRAME = 0,
	GreasePencilFrame_keyframe_type_BREAKDOWN = 2,
	GreasePencilFrame_keyframe_type_MOVING_HOLD = 4,
	GreasePencilFrame_keyframe_type_EXTREME = 1,
	GreasePencilFrame_keyframe_type_JITTER = 3,
	GreasePencilFrame_keyframe_type_GENERATED = 5,
};

int GreasePencilFrame_keyframe_type_get(PointerRNA *ptr);
void GreasePencilFrame_keyframe_type_set(PointerRNA *ptr, int value);

bool GreasePencilFrame_select_get(PointerRNA *ptr);
void GreasePencilFrame_select_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Frames ****************/

extern StructRNA RNA_GreasePencilFrames;

PointerRNA GreasePencilFrames_rna_type_get(PointerRNA *ptr);

struct GreasePencilFrame *GreasePencilFrames_new_func(struct ID *_selfid, struct GreasePencilLayer *_self, ReportList *reports, int frame_number);
void GreasePencilFrames_remove_func(struct ID *_selfid, struct GreasePencilLayer *_self, ReportList *reports, int frame_number);
struct GreasePencilFrame *GreasePencilFrames_copy_func(struct ID *_selfid, struct GreasePencilLayer *_self, ReportList *reports, int from_frame_number, int to_frame_number, bool instance_drawing);
struct GreasePencilFrame *GreasePencilFrames_move_func(struct ID *_selfid, struct GreasePencilLayer *_self, ReportList *reports, int from_frame_number, int to_frame_number);
/**************** Hook Modifier ****************/

extern StructRNA RNA_GreasePencilHookModifier;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilHookModifier_custom_curve_get(PointerRNA *ptr);

enum {
	GreasePencilHookModifier_falloff_type_NONE = 0,
	GreasePencilHookModifier_falloff_type_CURVE = 1,
	GreasePencilHookModifier_falloff_type_SMOOTH = 3,
	GreasePencilHookModifier_falloff_type_SPHERE = 7,
	GreasePencilHookModifier_falloff_type_ROOT = 4,
	GreasePencilHookModifier_falloff_type_INVERSE_SQUARE = 8,
	GreasePencilHookModifier_falloff_type_SHARP = 2,
	GreasePencilHookModifier_falloff_type_LINEAR = 5,
	GreasePencilHookModifier_falloff_type_CONSTANT = 6,
};

int GreasePencilHookModifier_falloff_type_get(PointerRNA *ptr);
void GreasePencilHookModifier_falloff_type_set(PointerRNA *ptr, int value);

void GreasePencilHookModifier_center_get(PointerRNA *ptr, float values[3]);
void GreasePencilHookModifier_center_set(PointerRNA *ptr, const float values[3]);

bool GreasePencilHookModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilHookModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilHookModifier_tree_node_filter_MAX 64

void GreasePencilHookModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilHookModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilHookModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilHookModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilHookModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilHookModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilHookModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_material_pass_filter_set(PointerRNA *ptr, int value);

void GreasePencilHookModifier_matrix_inverse_get(PointerRNA *ptr, float values[16]);
void GreasePencilHookModifier_matrix_inverse_set(PointerRNA *ptr, const float values[16]);

PointerRNA GreasePencilHookModifier_object_get(PointerRNA *ptr);

float GreasePencilHookModifier_falloff_radius_get(PointerRNA *ptr);
void GreasePencilHookModifier_falloff_radius_set(PointerRNA *ptr, float value);

float GreasePencilHookModifier_strength_get(PointerRNA *ptr);
void GreasePencilHookModifier_strength_set(PointerRNA *ptr, float value);

#define GreasePencilHookModifier_subtarget_MAX 64

void GreasePencilHookModifier_subtarget_get(PointerRNA *ptr, char *value);
int GreasePencilHookModifier_subtarget_length(PointerRNA *ptr);
void GreasePencilHookModifier_subtarget_set(PointerRNA *ptr, const char *value);

bool GreasePencilHookModifier_use_falloff_uniform_get(PointerRNA *ptr);
void GreasePencilHookModifier_use_falloff_uniform_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilHookModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilHookModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilHookModifier_vertex_group_name_MAX 64

void GreasePencilHookModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilHookModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilHookModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilHookModifier_open_falloff_panel_get(PointerRNA *ptr);
void GreasePencilHookModifier_open_falloff_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilHookModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilHookModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Lattice Modifier ****************/

extern StructRNA RNA_GreasePencilLatticeModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilLatticeModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLatticeModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLatticeModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLatticeModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLatticeModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilLatticeModifier_tree_node_filter_MAX 64

void GreasePencilLatticeModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilLatticeModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilLatticeModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilLatticeModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilLatticeModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilLatticeModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilLatticeModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_material_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilLatticeModifier_object_get(PointerRNA *ptr);

float GreasePencilLatticeModifier_strength_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_strength_set(PointerRNA *ptr, float value);

bool GreasePencilLatticeModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLatticeModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilLatticeModifier_vertex_group_name_MAX 64

void GreasePencilLatticeModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilLatticeModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilLatticeModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilLatticeModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilLatticeModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Layer ****************/

extern StructRNA RNA_GreasePencilLayer;
extern StructRNA RNA_GreasePencilTreeNode;

enum {
	GreasePencilLayer_blend_mode_REGULAR = 0,
	GreasePencilLayer_blend_mode_HARDLIGHT = 1,
	GreasePencilLayer_blend_mode_ADD = 2,
	GreasePencilLayer_blend_mode_SUBTRACT = 3,
	GreasePencilLayer_blend_mode_MULTIPLY = 4,
	GreasePencilLayer_blend_mode_DIVIDE = 5,
};

int GreasePencilLayer_blend_mode_get(PointerRNA *ptr);
void GreasePencilLayer_blend_mode_set(PointerRNA *ptr, int value);

bool GreasePencilLayer_lock_frame_get(PointerRNA *ptr);
void GreasePencilLayer_lock_frame_set(PointerRNA *ptr, bool value);

void GreasePencilLayer_frames_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilLayer_frames_next(CollectionPropertyIterator *iter);
void GreasePencilLayer_frames_end(CollectionPropertyIterator *iter);
int GreasePencilLayer_frames_length(PointerRNA *ptr);
bool GreasePencilLayer_frames_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool GreasePencilLayer_ignore_locked_materials_get(PointerRNA *ptr);
void GreasePencilLayer_ignore_locked_materials_set(PointerRNA *ptr, bool value);

void GreasePencilLayer_matrix_parent_inverse_get(PointerRNA *ptr, float values[16]);
void GreasePencilLayer_matrix_parent_inverse_set(PointerRNA *ptr, const float values[16]);

void GreasePencilLayer_matrix_local_get(PointerRNA *ptr, float values[16]);
void GreasePencilLayer_matrix_local_set(PointerRNA *ptr, const float values[16]);

void GreasePencilLayer_mask_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilLayer_mask_layers_next(CollectionPropertyIterator *iter);
void GreasePencilLayer_mask_layers_end(CollectionPropertyIterator *iter);
bool GreasePencilLayer_mask_layers_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GreasePencilLayer_mask_layers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

float GreasePencilLayer_opacity_get(PointerRNA *ptr);
void GreasePencilLayer_opacity_set(PointerRNA *ptr, float value);

PointerRNA GreasePencilLayer_parent_get(PointerRNA *ptr);

void GreasePencilLayer_parent_bone_get(PointerRNA *ptr, char *value);
int GreasePencilLayer_parent_bone_length(PointerRNA *ptr);
void GreasePencilLayer_parent_bone_set(PointerRNA *ptr, const char *value);

int GreasePencilLayer_pass_index_get(PointerRNA *ptr);
void GreasePencilLayer_pass_index_set(PointerRNA *ptr, int value);

float GreasePencilLayer_radius_offset_get(PointerRNA *ptr);
void GreasePencilLayer_radius_offset_set(PointerRNA *ptr, float value);

void GreasePencilLayer_rotation_get(PointerRNA *ptr, float values[3]);
void GreasePencilLayer_rotation_set(PointerRNA *ptr, const float values[3]);

void GreasePencilLayer_scale_get(PointerRNA *ptr, float values[3]);
void GreasePencilLayer_scale_set(PointerRNA *ptr, const float values[3]);

void GreasePencilLayer_tint_color_get(PointerRNA *ptr, float values[3]);
void GreasePencilLayer_tint_color_set(PointerRNA *ptr, const float values[3]);

float GreasePencilLayer_tint_factor_get(PointerRNA *ptr);
void GreasePencilLayer_tint_factor_set(PointerRNA *ptr, float value);

void GreasePencilLayer_translation_get(PointerRNA *ptr, float values[3]);
void GreasePencilLayer_translation_set(PointerRNA *ptr, const float values[3]);

bool GreasePencilLayer_use_lights_get(PointerRNA *ptr);
void GreasePencilLayer_use_lights_set(PointerRNA *ptr, bool value);

bool GreasePencilLayer_use_viewlayer_masks_get(PointerRNA *ptr);
void GreasePencilLayer_use_viewlayer_masks_set(PointerRNA *ptr, bool value);

void GreasePencilLayer_viewlayer_render_get(PointerRNA *ptr, char *value);
int GreasePencilLayer_viewlayer_render_length(PointerRNA *ptr);
void GreasePencilLayer_viewlayer_render_set(PointerRNA *ptr, const char *value);

struct GreasePencilFrame *GreasePencilLayer_get_frame_at_func(struct GreasePencilLayer *_self, int frame_number);
struct GreasePencilFrame *GreasePencilLayer_current_frame_func(struct GreasePencilLayer *_self, bContext *C);
/**************** Grease Pencil Layer Group ****************/

extern StructRNA RNA_GreasePencilLayerGroup;
extern StructRNA RNA_GreasePencilTreeNode;

bool GreasePencilLayerGroup_is_expanded_get(PointerRNA *ptr);
void GreasePencilLayerGroup_is_expanded_set(PointerRNA *ptr, bool value);

enum {
	GreasePencilLayerGroup_color_tag_NONE = -1,
	GreasePencilLayerGroup_color_tag_COLOR1 = 0,
	GreasePencilLayerGroup_color_tag_COLOR2 = 1,
	GreasePencilLayerGroup_color_tag_COLOR3 = 2,
	GreasePencilLayerGroup_color_tag_COLOR4 = 3,
	GreasePencilLayerGroup_color_tag_COLOR5 = 4,
	GreasePencilLayerGroup_color_tag_COLOR6 = 5,
	GreasePencilLayerGroup_color_tag_COLOR7 = 6,
	GreasePencilLayerGroup_color_tag_COLOR8 = 7,
};

int GreasePencilLayerGroup_color_tag_get(PointerRNA *ptr);
void GreasePencilLayerGroup_color_tag_set(PointerRNA *ptr, int value);

/**************** Grease Pencil Masking Layers ****************/

extern StructRNA RNA_GreasePencilLayerMask;

PointerRNA GreasePencilLayerMask_rna_type_get(PointerRNA *ptr);

void GreasePencilLayerMask_name_get(PointerRNA *ptr, char *value);
int GreasePencilLayerMask_name_length(PointerRNA *ptr);
void GreasePencilLayerMask_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilLayerMask_hide_get(PointerRNA *ptr);
void GreasePencilLayerMask_hide_set(PointerRNA *ptr, bool value);

bool GreasePencilLayerMask_invert_get(PointerRNA *ptr);
void GreasePencilLayerMask_invert_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Mask Layers ****************/

extern StructRNA RNA_GreasePencilLayerMasks;

PointerRNA GreasePencilLayerMasks_rna_type_get(PointerRNA *ptr);

int GreasePencilLayerMasks_active_mask_index_get(PointerRNA *ptr);
void GreasePencilLayerMasks_active_mask_index_set(PointerRNA *ptr, int value);

/**************** Length Modifier ****************/

extern StructRNA RNA_GreasePencilLengthModifier;
extern StructRNA RNA_Modifier;

float GreasePencilLengthModifier_end_factor_get(PointerRNA *ptr);
void GreasePencilLengthModifier_end_factor_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_end_length_get(PointerRNA *ptr);
void GreasePencilLengthModifier_end_length_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_max_angle_get(PointerRNA *ptr);
void GreasePencilLengthModifier_max_angle_set(PointerRNA *ptr, float value);

bool GreasePencilLengthModifier_invert_curvature_get(PointerRNA *ptr);
void GreasePencilLengthModifier_invert_curvature_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilLengthModifier_tree_node_filter_MAX 64

void GreasePencilLengthModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilLengthModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilLengthModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilLengthModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilLengthModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilLengthModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilLengthModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilLengthModifier_mode_RELATIVE = 0,
	GreasePencilLengthModifier_mode_ABSOLUTE = 1,
};

int GreasePencilLengthModifier_mode_get(PointerRNA *ptr);
void GreasePencilLengthModifier_mode_set(PointerRNA *ptr, int value);

float GreasePencilLengthModifier_point_density_get(PointerRNA *ptr);
void GreasePencilLengthModifier_point_density_set(PointerRNA *ptr, float value);

bool GreasePencilLengthModifier_use_random_get(PointerRNA *ptr);
void GreasePencilLengthModifier_use_random_set(PointerRNA *ptr, bool value);

float GreasePencilLengthModifier_random_end_factor_get(PointerRNA *ptr);
void GreasePencilLengthModifier_random_end_factor_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_random_offset_get(PointerRNA *ptr);
void GreasePencilLengthModifier_random_offset_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_random_start_factor_get(PointerRNA *ptr);
void GreasePencilLengthModifier_random_start_factor_set(PointerRNA *ptr, float value);

int GreasePencilLengthModifier_seed_get(PointerRNA *ptr);
void GreasePencilLengthModifier_seed_set(PointerRNA *ptr, int value);

float GreasePencilLengthModifier_segment_influence_get(PointerRNA *ptr);
void GreasePencilLengthModifier_segment_influence_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_start_factor_get(PointerRNA *ptr);
void GreasePencilLengthModifier_start_factor_set(PointerRNA *ptr, float value);

float GreasePencilLengthModifier_start_length_get(PointerRNA *ptr);
void GreasePencilLengthModifier_start_length_set(PointerRNA *ptr, float value);

int GreasePencilLengthModifier_step_get(PointerRNA *ptr);
void GreasePencilLengthModifier_step_set(PointerRNA *ptr, int value);

bool GreasePencilLengthModifier_use_curvature_get(PointerRNA *ptr);
void GreasePencilLengthModifier_use_curvature_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilLengthModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

float GreasePencilLengthModifier_overshoot_factor_get(PointerRNA *ptr);
void GreasePencilLengthModifier_overshoot_factor_set(PointerRNA *ptr, float value);

bool GreasePencilLengthModifier_open_curvature_panel_get(PointerRNA *ptr);
void GreasePencilLengthModifier_open_curvature_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilLengthModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilLengthModifier_open_random_panel_get(PointerRNA *ptr);
void GreasePencilLengthModifier_open_random_panel_set(PointerRNA *ptr, bool value);

/**************** Line Art Modifier ****************/

extern StructRNA RNA_GreasePencilLineartModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilLineartModifier_use_fuzzy_all_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_fuzzy_all_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_split_angle_get(PointerRNA *ptr);
void GreasePencilLineartModifier_split_angle_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_back_face_culling_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_back_face_culling_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_face_mark_boundaries_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_face_mark_boundaries_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilLineartModifier_source_camera_get(PointerRNA *ptr);

bool GreasePencilLineartModifier_use_loose_edge_chain_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_loose_edge_chain_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_clip_plane_boundaries_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_clip_plane_boundaries_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilLineartModifier_source_collection_get(PointerRNA *ptr);

bool GreasePencilLineartModifier_use_crease_on_sharp_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_crease_on_sharp_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_crease_on_smooth_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_crease_on_smooth_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_crease_threshold_get(PointerRNA *ptr);
void GreasePencilLineartModifier_crease_threshold_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_face_mark_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_face_mark_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_edge_overlap_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_edge_overlap_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_image_boundary_trimming_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_image_boundary_trimming_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_chaining_image_threshold_get(PointerRNA *ptr);
void GreasePencilLineartModifier_chaining_image_threshold_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_object_instances_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_object_instances_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_fuzzy_intersections_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_fuzzy_intersections_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_face_mark_invert_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_face_mark_invert_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_invert_collection_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_invert_collection_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_invert_silhouette_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_invert_silhouette_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_invert_source_vertex_group_get(PointerRNA *ptr);
void GreasePencilLineartModifier_invert_source_vertex_group_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_is_baked_get(PointerRNA *ptr);
void GreasePencilLineartModifier_is_baked_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_face_mark_keep_contour_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_face_mark_keep_contour_set(PointerRNA *ptr, bool value);

#define GreasePencilLineartModifier_target_layer_MAX 64

void GreasePencilLineartModifier_target_layer_get(PointerRNA *ptr, char *value);
int GreasePencilLineartModifier_target_layer_length(PointerRNA *ptr);
void GreasePencilLineartModifier_target_layer_set(PointerRNA *ptr, const char *value);

int GreasePencilLineartModifier_level_end_get(PointerRNA *ptr);
void GreasePencilLineartModifier_level_end_set(PointerRNA *ptr, int value);

int GreasePencilLineartModifier_level_start_get(PointerRNA *ptr);
void GreasePencilLineartModifier_level_start_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilLineartModifier_light_contour_object_get(PointerRNA *ptr);

bool GreasePencilLineartModifier_use_loose_as_contour_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_loose_as_contour_set(PointerRNA *ptr, bool value);

void GreasePencilLineartModifier_use_material_mask_bits_get(PointerRNA *ptr, bool values[8]);
void GreasePencilLineartModifier_use_material_mask_bits_set(PointerRNA *ptr, const bool values[8]);

void GreasePencilLineartModifier_use_intersection_mask_get(PointerRNA *ptr, bool values[8]);
void GreasePencilLineartModifier_use_intersection_mask_set(PointerRNA *ptr, const bool values[8]);

bool GreasePencilLineartModifier_use_intersection_match_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_intersection_match_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_material_mask_match_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_material_mask_match_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_output_vertex_group_match_by_name_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_output_vertex_group_match_by_name_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilLineartModifier_target_material_get(PointerRNA *ptr);

PointerRNA GreasePencilLineartModifier_source_object_get(PointerRNA *ptr);

bool GreasePencilLineartModifier_use_offset_towards_custom_camera_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_offset_towards_custom_camera_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_opacity_get(PointerRNA *ptr);
void GreasePencilLineartModifier_opacity_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_overlap_edge_type_support_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_overlap_edge_type_support_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_overscan_get(PointerRNA *ptr);
void GreasePencilLineartModifier_overscan_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_detail_preserve_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_detail_preserve_set(PointerRNA *ptr, bool value);

float GreasePencilLineartModifier_radius_get(PointerRNA *ptr);
void GreasePencilLineartModifier_radius_set(PointerRNA *ptr, float value);

float GreasePencilLineartModifier_shadow_camera_far_get(PointerRNA *ptr);
void GreasePencilLineartModifier_shadow_camera_far_set(PointerRNA *ptr, float value);

float GreasePencilLineartModifier_shadow_camera_near_get(PointerRNA *ptr);
void GreasePencilLineartModifier_shadow_camera_near_set(PointerRNA *ptr, float value);

float GreasePencilLineartModifier_shadow_camera_size_get(PointerRNA *ptr);
void GreasePencilLineartModifier_shadow_camera_size_set(PointerRNA *ptr, float value);

enum {
	GreasePencilLineartModifier_shadow_region_filtering_NONE = 0,
	GreasePencilLineartModifier_shadow_region_filtering_ILLUMINATED = 1,
	GreasePencilLineartModifier_shadow_region_filtering_SHADED = 2,
	GreasePencilLineartModifier_shadow_region_filtering_ILLUMINATED_ENCLOSED = 3,
};

int GreasePencilLineartModifier_shadow_region_filtering_get(PointerRNA *ptr);
void GreasePencilLineartModifier_shadow_region_filtering_set(PointerRNA *ptr, int value);

enum {
	GreasePencilLineartModifier_silhouette_filtering_NONE = 0,
	GreasePencilLineartModifier_silhouette_filtering_GROUP = 1,
	GreasePencilLineartModifier_silhouette_filtering_INDIVIDUAL = 2,
};

int GreasePencilLineartModifier_silhouette_filtering_get(PointerRNA *ptr);
void GreasePencilLineartModifier_silhouette_filtering_set(PointerRNA *ptr, int value);

float GreasePencilLineartModifier_smooth_tolerance_get(PointerRNA *ptr);
void GreasePencilLineartModifier_smooth_tolerance_set(PointerRNA *ptr, float value);

enum {
	GreasePencilLineartModifier_source_type_COLLECTION = 0,
	GreasePencilLineartModifier_source_type_OBJECT = 1,
	GreasePencilLineartModifier_source_type_SCENE = 2,
};

int GreasePencilLineartModifier_source_type_get(PointerRNA *ptr);
void GreasePencilLineartModifier_source_type_set(PointerRNA *ptr, int value);

#define GreasePencilLineartModifier_source_vertex_group_MAX 64

void GreasePencilLineartModifier_source_vertex_group_get(PointerRNA *ptr, char *value);
int GreasePencilLineartModifier_source_vertex_group_length(PointerRNA *ptr);
void GreasePencilLineartModifier_source_vertex_group_set(PointerRNA *ptr, const char *value);

float GreasePencilLineartModifier_stroke_depth_offset_get(PointerRNA *ptr);
void GreasePencilLineartModifier_stroke_depth_offset_set(PointerRNA *ptr, float value);

bool GreasePencilLineartModifier_use_cache_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_cache_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_contour_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_contour_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_crease_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_crease_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_custom_camera_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_custom_camera_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_edge_mark_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_edge_mark_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_geometry_space_chain_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_geometry_space_chain_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_intersection_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_intersection_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_light_contour_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_light_contour_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_loose_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_loose_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_material_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_material_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_material_mask_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_material_mask_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_multiple_levels_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_multiple_levels_set(PointerRNA *ptr, bool value);

bool GreasePencilLineartModifier_use_shadow_get(PointerRNA *ptr);
void GreasePencilLineartModifier_use_shadow_set(PointerRNA *ptr, bool value);

#define GreasePencilLineartModifier_vertex_group_MAX 64

void GreasePencilLineartModifier_vertex_group_get(PointerRNA *ptr, char *value);
int GreasePencilLineartModifier_vertex_group_length(PointerRNA *ptr);
void GreasePencilLineartModifier_vertex_group_set(PointerRNA *ptr, const char *value);

/**************** Grease Pencil Mirror Modifier ****************/

extern StructRNA RNA_GreasePencilMirrorModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilMirrorModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilMirrorModifier_tree_node_filter_MAX 64

void GreasePencilMirrorModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilMirrorModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilMirrorModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilMirrorModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilMirrorModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilMirrorModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilMirrorModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_material_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilMirrorModifier_object_get(PointerRNA *ptr);

bool GreasePencilMirrorModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_use_axis_x_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_axis_x_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_use_axis_y_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_axis_y_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_use_axis_z_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_use_axis_z_set(PointerRNA *ptr, bool value);

bool GreasePencilMirrorModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilMirrorModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Multiply Modifier ****************/

extern StructRNA RNA_GreasePencilMultiplyModifier;
extern StructRNA RNA_Modifier;

float GreasePencilMultiplyModifier_fading_center_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_fading_center_set(PointerRNA *ptr, float value);

float GreasePencilMultiplyModifier_distance_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_distance_set(PointerRNA *ptr, float value);

int GreasePencilMultiplyModifier_duplicates_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_duplicates_set(PointerRNA *ptr, int value);

bool GreasePencilMultiplyModifier_use_fade_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_use_fade_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilMultiplyModifier_tree_node_filter_MAX 64

void GreasePencilMultiplyModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilMultiplyModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilMultiplyModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilMultiplyModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilMultiplyModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilMultiplyModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilMultiplyModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_material_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilMultiplyModifier_offset_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_offset_set(PointerRNA *ptr, float value);

float GreasePencilMultiplyModifier_fading_opacity_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_fading_opacity_set(PointerRNA *ptr, float value);

float GreasePencilMultiplyModifier_fading_thickness_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_fading_thickness_set(PointerRNA *ptr, float value);

bool GreasePencilMultiplyModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_open_fading_panel_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_open_fading_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilMultiplyModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilMultiplyModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Noise Modifier ****************/

extern StructRNA RNA_GreasePencilNoiseModifier;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilNoiseModifier_custom_curve_get(PointerRNA *ptr);

bool GreasePencilNoiseModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilNoiseModifier_tree_node_filter_MAX 64

void GreasePencilNoiseModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilNoiseModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilNoiseModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilNoiseModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilNoiseModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilNoiseModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilNoiseModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilNoiseModifier_random_mode_STEP = 0,
	GreasePencilNoiseModifier_random_mode_KEYFRAME = 1,
};

int GreasePencilNoiseModifier_random_mode_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_random_mode_set(PointerRNA *ptr, int value);

float GreasePencilNoiseModifier_noise_offset_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_noise_offset_set(PointerRNA *ptr, float value);

float GreasePencilNoiseModifier_noise_scale_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_noise_scale_set(PointerRNA *ptr, float value);

int GreasePencilNoiseModifier_seed_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_seed_set(PointerRNA *ptr, int value);

float GreasePencilNoiseModifier_factor_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_factor_set(PointerRNA *ptr, float value);

bool GreasePencilNoiseModifier_use_random_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_use_random_set(PointerRNA *ptr, bool value);

int GreasePencilNoiseModifier_step_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_step_set(PointerRNA *ptr, int value);

float GreasePencilNoiseModifier_factor_strength_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_factor_strength_set(PointerRNA *ptr, float value);

float GreasePencilNoiseModifier_factor_thickness_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_factor_thickness_set(PointerRNA *ptr, float value);

float GreasePencilNoiseModifier_factor_uvs_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_factor_uvs_set(PointerRNA *ptr, float value);

bool GreasePencilNoiseModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilNoiseModifier_vertex_group_name_MAX 64

void GreasePencilNoiseModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilNoiseModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilNoiseModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilNoiseModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilNoiseModifier_open_random_panel_get(PointerRNA *ptr);
void GreasePencilNoiseModifier_open_random_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Offset Modifier ****************/

extern StructRNA RNA_GreasePencilOffsetModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilOffsetModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilOffsetModifier_tree_node_filter_MAX 64

void GreasePencilOffsetModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilOffsetModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilOffsetModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilOffsetModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilOffsetModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

void GreasePencilOffsetModifier_location_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_location_set(PointerRNA *ptr, const float values[3]);

PointerRNA GreasePencilOffsetModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilOffsetModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilOffsetModifier_offset_mode_RANDOM = 0,
	GreasePencilOffsetModifier_offset_mode_LAYER = 1,
	GreasePencilOffsetModifier_offset_mode_STROKE = 3,
	GreasePencilOffsetModifier_offset_mode_MATERIAL = 2,
};

int GreasePencilOffsetModifier_offset_mode_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_offset_mode_set(PointerRNA *ptr, int value);

void GreasePencilOffsetModifier_stroke_location_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_stroke_location_set(PointerRNA *ptr, const float values[3]);

void GreasePencilOffsetModifier_stroke_rotation_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_stroke_rotation_set(PointerRNA *ptr, const float values[3]);

void GreasePencilOffsetModifier_rotation_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_rotation_set(PointerRNA *ptr, const float values[3]);

void GreasePencilOffsetModifier_scale_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_scale_set(PointerRNA *ptr, const float values[3]);

void GreasePencilOffsetModifier_stroke_scale_get(PointerRNA *ptr, float values[3]);
void GreasePencilOffsetModifier_stroke_scale_set(PointerRNA *ptr, const float values[3]);

int GreasePencilOffsetModifier_seed_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_seed_set(PointerRNA *ptr, int value);

int GreasePencilOffsetModifier_stroke_start_offset_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_stroke_start_offset_set(PointerRNA *ptr, int value);

int GreasePencilOffsetModifier_stroke_step_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_stroke_step_set(PointerRNA *ptr, int value);

bool GreasePencilOffsetModifier_use_uniform_random_scale_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_use_uniform_random_scale_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilOffsetModifier_vertex_group_name_MAX 64

void GreasePencilOffsetModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilOffsetModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilOffsetModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilOffsetModifier_open_general_panel_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_open_general_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilOffsetModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilOffsetModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Opacity Modifier ****************/

extern StructRNA RNA_GreasePencilOpacityModifier;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilOpacityModifier_custom_curve_get(PointerRNA *ptr);

float GreasePencilOpacityModifier_hardness_factor_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_hardness_factor_set(PointerRNA *ptr, float value);

bool GreasePencilOpacityModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilOpacityModifier_tree_node_filter_MAX 64

void GreasePencilOpacityModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilOpacityModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilOpacityModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilOpacityModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilOpacityModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilOpacityModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilOpacityModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilOpacityModifier_color_mode_BOTH = 2,
	GreasePencilOpacityModifier_color_mode_STROKE = 0,
	GreasePencilOpacityModifier_color_mode_FILL = 1,
	GreasePencilOpacityModifier_color_mode_HARDNESS = 3,
};

int GreasePencilOpacityModifier_color_mode_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_color_mode_set(PointerRNA *ptr, int value);

float GreasePencilOpacityModifier_color_factor_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_color_factor_set(PointerRNA *ptr, float value);

bool GreasePencilOpacityModifier_use_uniform_opacity_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_uniform_opacity_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOpacityModifier_use_weight_as_factor_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_use_weight_as_factor_set(PointerRNA *ptr, bool value);

#define GreasePencilOpacityModifier_vertex_group_name_MAX 64

void GreasePencilOpacityModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilOpacityModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilOpacityModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilOpacityModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilOpacityModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Outline Modifier ****************/

extern StructRNA RNA_GreasePencilOutlineModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilOutlineModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_use_keep_shape_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_use_keep_shape_set(PointerRNA *ptr, bool value);

#define GreasePencilOutlineModifier_tree_node_filter_MAX 64

void GreasePencilOutlineModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilOutlineModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilOutlineModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilOutlineModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilOutlineModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilOutlineModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilOutlineModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_material_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilOutlineModifier_outline_material_get(PointerRNA *ptr);

float GreasePencilOutlineModifier_sample_length_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_sample_length_set(PointerRNA *ptr, float value);

int GreasePencilOutlineModifier_subdivision_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_subdivision_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilOutlineModifier_object_get(PointerRNA *ptr);

int GreasePencilOutlineModifier_thickness_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_thickness_set(PointerRNA *ptr, int value);

bool GreasePencilOutlineModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilOutlineModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilOutlineModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Shrinkwrap Modifier ****************/

extern StructRNA RNA_GreasePencilShrinkwrapModifier;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilShrinkwrapModifier_auxiliary_target_get(PointerRNA *ptr);

enum {
	GreasePencilShrinkwrapModifier_cull_face_OFF = 0,
	GreasePencilShrinkwrapModifier_cull_face_FRONT = 8,
	GreasePencilShrinkwrapModifier_cull_face_BACK = 16,
};

int GreasePencilShrinkwrapModifier_cull_face_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_cull_face_set(PointerRNA *ptr, int value);

bool GreasePencilShrinkwrapModifier_use_invert_cull_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_invert_cull_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilShrinkwrapModifier_tree_node_filter_MAX 64

void GreasePencilShrinkwrapModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilShrinkwrapModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilShrinkwrapModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilShrinkwrapModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilShrinkwrapModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilShrinkwrapModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_material_pass_filter_set(PointerRNA *ptr, int value);

bool GreasePencilShrinkwrapModifier_use_negative_direction_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_negative_direction_set(PointerRNA *ptr, bool value);

float GreasePencilShrinkwrapModifier_offset_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_offset_set(PointerRNA *ptr, float value);

bool GreasePencilShrinkwrapModifier_use_positive_direction_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_positive_direction_set(PointerRNA *ptr, bool value);

float GreasePencilShrinkwrapModifier_project_limit_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_project_limit_set(PointerRNA *ptr, float value);

float GreasePencilShrinkwrapModifier_smooth_factor_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_smooth_factor_set(PointerRNA *ptr, float value);

enum {
	GreasePencilShrinkwrapModifier_wrap_mode_ON_SURFACE = 0,
	GreasePencilShrinkwrapModifier_wrap_mode_INSIDE = 1,
	GreasePencilShrinkwrapModifier_wrap_mode_OUTSIDE = 2,
	GreasePencilShrinkwrapModifier_wrap_mode_OUTSIDE_SURFACE = 3,
	GreasePencilShrinkwrapModifier_wrap_mode_ABOVE_SURFACE = 4,
};

int GreasePencilShrinkwrapModifier_wrap_mode_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_wrap_mode_set(PointerRNA *ptr, int value);

int GreasePencilShrinkwrapModifier_smooth_step_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_smooth_step_set(PointerRNA *ptr, int value);

int GreasePencilShrinkwrapModifier_subsurf_levels_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_subsurf_levels_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilShrinkwrapModifier_target_get(PointerRNA *ptr);

bool GreasePencilShrinkwrapModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilShrinkwrapModifier_vertex_group_name_MAX 64

void GreasePencilShrinkwrapModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilShrinkwrapModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

enum {
	GreasePencilShrinkwrapModifier_wrap_method_NEAREST_SURFACEPOINT = 0,
	GreasePencilShrinkwrapModifier_wrap_method_PROJECT = 1,
	GreasePencilShrinkwrapModifier_wrap_method_NEAREST_VERTEX = 2,
	GreasePencilShrinkwrapModifier_wrap_method_TARGET_PROJECT = 3,
};

int GreasePencilShrinkwrapModifier_wrap_method_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_wrap_method_set(PointerRNA *ptr, int value);

bool GreasePencilShrinkwrapModifier_use_project_x_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_project_x_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_use_project_y_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_project_y_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_use_project_z_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_use_project_z_set(PointerRNA *ptr, bool value);

bool GreasePencilShrinkwrapModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilShrinkwrapModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Simplify Modifier ****************/

extern StructRNA RNA_GreasePencilSimplifyModifier;
extern StructRNA RNA_Modifier;

float GreasePencilSimplifyModifier_distance_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_distance_set(PointerRNA *ptr, float value);

float GreasePencilSimplifyModifier_factor_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_factor_set(PointerRNA *ptr, float value);

bool GreasePencilSimplifyModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSimplifyModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSimplifyModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSimplifyModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSimplifyModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

int GreasePencilSimplifyModifier_step_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_step_set(PointerRNA *ptr, int value);

#define GreasePencilSimplifyModifier_tree_node_filter_MAX 64

void GreasePencilSimplifyModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilSimplifyModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilSimplifyModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilSimplifyModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilSimplifyModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilSimplifyModifier_length_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_length_set(PointerRNA *ptr, float value);

PointerRNA GreasePencilSimplifyModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilSimplifyModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilSimplifyModifier_mode_FIXED = 0,
	GreasePencilSimplifyModifier_mode_ADAPTIVE = 1,
	GreasePencilSimplifyModifier_mode_SAMPLE = 2,
	GreasePencilSimplifyModifier_mode_MERGE = 3,
};

int GreasePencilSimplifyModifier_mode_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_mode_set(PointerRNA *ptr, int value);

float GreasePencilSimplifyModifier_sharp_threshold_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_sharp_threshold_set(PointerRNA *ptr, float value);

bool GreasePencilSimplifyModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSimplifyModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilSimplifyModifier_vertex_group_name_MAX 64

void GreasePencilSimplifyModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilSimplifyModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilSimplifyModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilSimplifyModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilSimplifyModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Smooth Modifier ****************/

extern StructRNA RNA_GreasePencilSmoothModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilSmoothModifier_use_edit_position_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_edit_position_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_edit_strength_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_edit_strength_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_edit_thickness_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_edit_thickness_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_edit_uv_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_edit_uv_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilSmoothModifier_custom_curve_get(PointerRNA *ptr);

float GreasePencilSmoothModifier_factor_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_factor_set(PointerRNA *ptr, float value);

bool GreasePencilSmoothModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_keep_shape_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_keep_shape_set(PointerRNA *ptr, bool value);

#define GreasePencilSmoothModifier_tree_node_filter_MAX 64

void GreasePencilSmoothModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilSmoothModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilSmoothModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilSmoothModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilSmoothModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilSmoothModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilSmoothModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_material_pass_filter_set(PointerRNA *ptr, int value);

bool GreasePencilSmoothModifier_use_smooth_ends_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_smooth_ends_set(PointerRNA *ptr, bool value);

int GreasePencilSmoothModifier_step_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_step_set(PointerRNA *ptr, int value);

bool GreasePencilSmoothModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSmoothModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilSmoothModifier_vertex_group_name_MAX 64

void GreasePencilSmoothModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilSmoothModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilSmoothModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilSmoothModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilSmoothModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Subdivision Modifier ****************/

extern StructRNA RNA_GreasePencilSubdivModifier;
extern StructRNA RNA_Modifier;

bool GreasePencilSubdivModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSubdivModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSubdivModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSubdivModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilSubdivModifier_tree_node_filter_MAX 64

void GreasePencilSubdivModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilSubdivModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilSubdivModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilSubdivModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilSubdivModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

int GreasePencilSubdivModifier_level_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_level_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilSubdivModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilSubdivModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilSubdivModifier_subdivision_type_CATMULL_CLARK = 0,
	GreasePencilSubdivModifier_subdivision_type_SIMPLE = 1,
};

int GreasePencilSubdivModifier_subdivision_type_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_subdivision_type_set(PointerRNA *ptr, int value);

bool GreasePencilSubdivModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSubdivModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilSubdivModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilSubdivModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Texture Modifier ****************/

extern StructRNA RNA_GreasePencilTextureModifier;
extern StructRNA RNA_Modifier;

void GreasePencilTextureModifier_fill_offset_get(PointerRNA *ptr, float values[2]);
void GreasePencilTextureModifier_fill_offset_set(PointerRNA *ptr, const float values[2]);

float GreasePencilTextureModifier_fill_rotation_get(PointerRNA *ptr);
void GreasePencilTextureModifier_fill_rotation_set(PointerRNA *ptr, float value);

float GreasePencilTextureModifier_fill_scale_get(PointerRNA *ptr);
void GreasePencilTextureModifier_fill_scale_set(PointerRNA *ptr, float value);

enum {
	GreasePencilTextureModifier_fit_method_CONSTANT_LENGTH = 1,
	GreasePencilTextureModifier_fit_method_FIT_STROKE = 0,
};

int GreasePencilTextureModifier_fit_method_get(PointerRNA *ptr);
void GreasePencilTextureModifier_fit_method_set(PointerRNA *ptr, int value);

bool GreasePencilTextureModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTextureModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTextureModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTextureModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilTextureModifier_tree_node_filter_MAX 64

void GreasePencilTextureModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilTextureModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilTextureModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilTextureModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilTextureModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilTextureModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilTextureModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilTextureModifier_mode_STROKE = 0,
	GreasePencilTextureModifier_mode_FILL = 1,
	GreasePencilTextureModifier_mode_STROKE_AND_FILL = 2,
};

int GreasePencilTextureModifier_mode_get(PointerRNA *ptr);
void GreasePencilTextureModifier_mode_set(PointerRNA *ptr, int value);

float GreasePencilTextureModifier_alignment_rotation_get(PointerRNA *ptr);
void GreasePencilTextureModifier_alignment_rotation_set(PointerRNA *ptr, float value);

float GreasePencilTextureModifier_uv_offset_get(PointerRNA *ptr);
void GreasePencilTextureModifier_uv_offset_set(PointerRNA *ptr, float value);

float GreasePencilTextureModifier_uv_scale_get(PointerRNA *ptr);
void GreasePencilTextureModifier_uv_scale_set(PointerRNA *ptr, float value);

bool GreasePencilTextureModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTextureModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTextureModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTextureModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilTextureModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Thickness Modifier ****************/

extern StructRNA RNA_GreasePencilThickModifierData;
extern StructRNA RNA_Modifier;

PointerRNA GreasePencilThickModifierData_custom_curve_get(PointerRNA *ptr);

bool GreasePencilThickModifierData_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilThickModifierData_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilThickModifierData_tree_node_filter_MAX 64

void GreasePencilThickModifierData_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilThickModifierData_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilThickModifierData_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilThickModifierData_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilThickModifierData_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilThickModifierData_material_filter_get(PointerRNA *ptr);

int GreasePencilThickModifierData_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_material_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilThickModifierData_thickness_get(PointerRNA *ptr);
void GreasePencilThickModifierData_thickness_set(PointerRNA *ptr, float value);

float GreasePencilThickModifierData_thickness_factor_get(PointerRNA *ptr);
void GreasePencilThickModifierData_thickness_factor_set(PointerRNA *ptr, float value);

bool GreasePencilThickModifierData_use_uniform_thickness_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_uniform_thickness_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilThickModifierData_vertex_group_name_MAX 64

void GreasePencilThickModifierData_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilThickModifierData_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilThickModifierData_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilThickModifierData_use_weight_factor_get(PointerRNA *ptr);
void GreasePencilThickModifierData_use_weight_factor_set(PointerRNA *ptr, bool value);

bool GreasePencilThickModifierData_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilThickModifierData_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Time Modifier ****************/

extern StructRNA RNA_GreasePencilTimeModifier;
extern StructRNA RNA_Modifier;

int GreasePencilTimeModifier_segment_active_index_get(PointerRNA *ptr);
void GreasePencilTimeModifier_segment_active_index_set(PointerRNA *ptr, int value);

bool GreasePencilTimeModifier_use_custom_frame_range_get(PointerRNA *ptr);
void GreasePencilTimeModifier_use_custom_frame_range_set(PointerRNA *ptr, bool value);

int GreasePencilTimeModifier_frame_end_get(PointerRNA *ptr);
void GreasePencilTimeModifier_frame_end_set(PointerRNA *ptr, int value);

int GreasePencilTimeModifier_offset_get(PointerRNA *ptr);
void GreasePencilTimeModifier_offset_set(PointerRNA *ptr, int value);

float GreasePencilTimeModifier_frame_scale_get(PointerRNA *ptr);
void GreasePencilTimeModifier_frame_scale_set(PointerRNA *ptr, float value);

bool GreasePencilTimeModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilTimeModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTimeModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTimeModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTimeModifier_use_keep_loop_get(PointerRNA *ptr);
void GreasePencilTimeModifier_use_keep_loop_set(PointerRNA *ptr, bool value);

#define GreasePencilTimeModifier_tree_node_filter_MAX 64

void GreasePencilTimeModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilTimeModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilTimeModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilTimeModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilTimeModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilTimeModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTimeModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilTimeModifier_mode_NORMAL = 0,
	GreasePencilTimeModifier_mode_REVERSE = 1,
	GreasePencilTimeModifier_mode_FIX = 2,
	GreasePencilTimeModifier_mode_PINGPONG = 3,
	GreasePencilTimeModifier_mode_CHAIN = 4,
};

int GreasePencilTimeModifier_mode_get(PointerRNA *ptr);
void GreasePencilTimeModifier_mode_set(PointerRNA *ptr, int value);

void GreasePencilTimeModifier_segments_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void GreasePencilTimeModifier_segments_next(CollectionPropertyIterator *iter);
void GreasePencilTimeModifier_segments_end(CollectionPropertyIterator *iter);
bool GreasePencilTimeModifier_segments_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool GreasePencilTimeModifier_segments_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

int GreasePencilTimeModifier_frame_start_get(PointerRNA *ptr);
void GreasePencilTimeModifier_frame_start_set(PointerRNA *ptr, int value);

bool GreasePencilTimeModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTimeModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTimeModifier_open_custom_range_panel_get(PointerRNA *ptr);
void GreasePencilTimeModifier_open_custom_range_panel_set(PointerRNA *ptr, bool value);

bool GreasePencilTimeModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilTimeModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Time Modifier Segment ****************/

extern StructRNA RNA_GreasePencilTimeModifierSegment;

PointerRNA GreasePencilTimeModifierSegment_rna_type_get(PointerRNA *ptr);

#define GreasePencilTimeModifierSegment_name_MAX 64

void GreasePencilTimeModifierSegment_name_get(PointerRNA *ptr, char *value);
int GreasePencilTimeModifierSegment_name_length(PointerRNA *ptr);
void GreasePencilTimeModifierSegment_name_set(PointerRNA *ptr, const char *value);

int GreasePencilTimeModifierSegment_segment_end_get(PointerRNA *ptr);
void GreasePencilTimeModifierSegment_segment_end_set(PointerRNA *ptr, int value);

int GreasePencilTimeModifierSegment_segment_start_get(PointerRNA *ptr);
void GreasePencilTimeModifierSegment_segment_start_set(PointerRNA *ptr, int value);

enum {
	GreasePencilTimeModifierSegment_segment_mode_NORMAL = 0,
	GreasePencilTimeModifierSegment_segment_mode_REVERSE = 1,
	GreasePencilTimeModifierSegment_segment_mode_PINGPONG = 2,
};

int GreasePencilTimeModifierSegment_segment_mode_get(PointerRNA *ptr);
void GreasePencilTimeModifierSegment_segment_mode_set(PointerRNA *ptr, int value);

int GreasePencilTimeModifierSegment_segment_repeat_get(PointerRNA *ptr);
void GreasePencilTimeModifierSegment_segment_repeat_set(PointerRNA *ptr, int value);

/**************** Grease Pencil Tint Modifier ****************/

extern StructRNA RNA_GreasePencilTintModifier;
extern StructRNA RNA_Modifier;

void GreasePencilTintModifier_color_get(PointerRNA *ptr, float values[3]);
void GreasePencilTintModifier_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA GreasePencilTintModifier_color_ramp_get(PointerRNA *ptr);

PointerRNA GreasePencilTintModifier_custom_curve_get(PointerRNA *ptr);

float GreasePencilTintModifier_factor_get(PointerRNA *ptr);
void GreasePencilTintModifier_factor_set(PointerRNA *ptr, float value);

bool GreasePencilTintModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilTintModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilTintModifier_tree_node_filter_MAX 64

void GreasePencilTintModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilTintModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilTintModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilTintModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilTintModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilTintModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilTintModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_material_pass_filter_set(PointerRNA *ptr, int value);

enum {
	GreasePencilTintModifier_color_mode_BOTH = 2,
	GreasePencilTintModifier_color_mode_STROKE = 0,
	GreasePencilTintModifier_color_mode_FILL = 1,
};

int GreasePencilTintModifier_color_mode_get(PointerRNA *ptr);
void GreasePencilTintModifier_color_mode_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilTintModifier_object_get(PointerRNA *ptr);

float GreasePencilTintModifier_radius_get(PointerRNA *ptr);
void GreasePencilTintModifier_radius_set(PointerRNA *ptr, float value);

enum {
	GreasePencilTintModifier_tint_mode_UNIFORM = 0,
	GreasePencilTintModifier_tint_mode_GRADIENT = 1,
};

int GreasePencilTintModifier_tint_mode_get(PointerRNA *ptr);
void GreasePencilTintModifier_tint_mode_set(PointerRNA *ptr, int value);

bool GreasePencilTintModifier_use_custom_curve_get(PointerRNA *ptr);
void GreasePencilTintModifier_use_custom_curve_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilTintModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilTintModifier_use_weight_as_factor_get(PointerRNA *ptr);
void GreasePencilTintModifier_use_weight_as_factor_set(PointerRNA *ptr, bool value);

#define GreasePencilTintModifier_vertex_group_name_MAX 64

void GreasePencilTintModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilTintModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilTintModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

bool GreasePencilTintModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilTintModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Tree Node ****************/

extern StructRNA RNA_GreasePencilTreeNode;

PointerRNA GreasePencilTreeNode_rna_type_get(PointerRNA *ptr);

void GreasePencilTreeNode_name_get(PointerRNA *ptr, char *value);
int GreasePencilTreeNode_name_length(PointerRNA *ptr);
void GreasePencilTreeNode_name_set(PointerRNA *ptr, const char *value);

void GreasePencilTreeNode_channel_color_get(PointerRNA *ptr, float values[3]);
void GreasePencilTreeNode_channel_color_set(PointerRNA *ptr, const float values[3]);

bool GreasePencilTreeNode_hide_get(PointerRNA *ptr);
void GreasePencilTreeNode_hide_set(PointerRNA *ptr, bool value);

bool GreasePencilTreeNode_lock_get(PointerRNA *ptr);
void GreasePencilTreeNode_lock_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilTreeNode_next_node_get(PointerRNA *ptr);

bool GreasePencilTreeNode_use_onion_skinning_get(PointerRNA *ptr);
void GreasePencilTreeNode_use_onion_skinning_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilTreeNode_parent_group_get(PointerRNA *ptr);

PointerRNA GreasePencilTreeNode_prev_node_get(PointerRNA *ptr);

bool GreasePencilTreeNode_select_get(PointerRNA *ptr);
void GreasePencilTreeNode_select_set(PointerRNA *ptr, bool value);

bool GreasePencilTreeNode_use_masks_get(PointerRNA *ptr);
void GreasePencilTreeNode_use_masks_set(PointerRNA *ptr, bool value);

/**************** Weight Modifier Angle ****************/

extern StructRNA RNA_GreasePencilWeightAngleModifier;
extern StructRNA RNA_Modifier;

float GreasePencilWeightAngleModifier_angle_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_angle_set(PointerRNA *ptr, float value);

enum {
	GreasePencilWeightAngleModifier_axis_X = 0,
	GreasePencilWeightAngleModifier_axis_Y = 1,
	GreasePencilWeightAngleModifier_axis_Z = 2,
};

int GreasePencilWeightAngleModifier_axis_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_axis_set(PointerRNA *ptr, int value);

bool GreasePencilWeightAngleModifier_use_invert_output_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_use_invert_output_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilWeightAngleModifier_tree_node_filter_MAX 64

void GreasePencilWeightAngleModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilWeightAngleModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilWeightAngleModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilWeightAngleModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

PointerRNA GreasePencilWeightAngleModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilWeightAngleModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_material_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilWeightAngleModifier_minimum_weight_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_minimum_weight_set(PointerRNA *ptr, float value);

bool GreasePencilWeightAngleModifier_use_multiply_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_use_multiply_set(PointerRNA *ptr, bool value);

enum {
	GreasePencilWeightAngleModifier_space_LOCAL = 0,
	GreasePencilWeightAngleModifier_space_WORLD = 1,
};

int GreasePencilWeightAngleModifier_space_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_space_set(PointerRNA *ptr, int value);

bool GreasePencilWeightAngleModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightAngleModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilWeightAngleModifier_vertex_group_name_MAX 64

void GreasePencilWeightAngleModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilWeightAngleModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

#define GreasePencilWeightAngleModifier_target_vertex_group_MAX 64

void GreasePencilWeightAngleModifier_target_vertex_group_get(PointerRNA *ptr, char *value);
int GreasePencilWeightAngleModifier_target_vertex_group_length(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_target_vertex_group_set(PointerRNA *ptr, const char *value);

bool GreasePencilWeightAngleModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilWeightAngleModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Weight Modifier Proximity ****************/

extern StructRNA RNA_GreasePencilWeightProximityModifier;
extern StructRNA RNA_Modifier;

float GreasePencilWeightProximityModifier_distance_end_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_distance_end_set(PointerRNA *ptr, float value);

bool GreasePencilWeightProximityModifier_use_invert_output_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_use_invert_output_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_invert_layer_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_invert_layer_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_invert_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_invert_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_invert_material_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_invert_material_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_invert_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_invert_material_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_invert_vertex_group_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

#define GreasePencilWeightProximityModifier_tree_node_filter_MAX 64

void GreasePencilWeightProximityModifier_tree_node_filter_get(PointerRNA *ptr, char *value);
int GreasePencilWeightProximityModifier_tree_node_filter_length(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_tree_node_filter_set(PointerRNA *ptr, const char *value);

bool GreasePencilWeightProximityModifier_use_layer_group_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_use_layer_group_filter_set(PointerRNA *ptr, bool value);

int GreasePencilWeightProximityModifier_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_layer_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilWeightProximityModifier_distance_start_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_distance_start_set(PointerRNA *ptr, float value);

PointerRNA GreasePencilWeightProximityModifier_material_filter_get(PointerRNA *ptr);

int GreasePencilWeightProximityModifier_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_material_pass_filter_set(PointerRNA *ptr, int value);

float GreasePencilWeightProximityModifier_minimum_weight_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_minimum_weight_set(PointerRNA *ptr, float value);

bool GreasePencilWeightProximityModifier_use_multiply_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_use_multiply_set(PointerRNA *ptr, bool value);

PointerRNA GreasePencilWeightProximityModifier_object_get(PointerRNA *ptr);

bool GreasePencilWeightProximityModifier_use_layer_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_use_layer_pass_filter_set(PointerRNA *ptr, bool value);

bool GreasePencilWeightProximityModifier_use_material_pass_filter_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_use_material_pass_filter_set(PointerRNA *ptr, bool value);

#define GreasePencilWeightProximityModifier_vertex_group_name_MAX 64

void GreasePencilWeightProximityModifier_vertex_group_name_get(PointerRNA *ptr, char *value);
int GreasePencilWeightProximityModifier_vertex_group_name_length(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_vertex_group_name_set(PointerRNA *ptr, const char *value);

#define GreasePencilWeightProximityModifier_target_vertex_group_MAX 64

void GreasePencilWeightProximityModifier_target_vertex_group_get(PointerRNA *ptr, char *value);
int GreasePencilWeightProximityModifier_target_vertex_group_length(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_target_vertex_group_set(PointerRNA *ptr, const char *value);

bool GreasePencilWeightProximityModifier_open_influence_panel_get(PointerRNA *ptr);
void GreasePencilWeightProximityModifier_open_influence_panel_set(PointerRNA *ptr, bool value);

/**************** Grease Pencil Group ****************/

extern StructRNA RNA_GreasePencilv3LayerGroup;

PointerRNA GreasePencilv3LayerGroup_rna_type_get(PointerRNA *ptr);

PointerRNA GreasePencilv3LayerGroup_active_get(PointerRNA *ptr);

struct PointerRNA GreasePencilv3LayerGroup_new_func(struct GreasePencil *_self, const char * name, struct PointerRNA *parent_group);
void GreasePencilv3LayerGroup_remove_func(struct GreasePencil *_self, struct PointerRNA *layer_group, bool keep_children);
void GreasePencilv3LayerGroup_move_func(struct GreasePencil *_self, struct PointerRNA *layer_group, int type);
void GreasePencilv3LayerGroup_move_top_func(struct GreasePencil *_self, struct PointerRNA *layer_group);
void GreasePencilv3LayerGroup_move_bottom_func(struct GreasePencil *_self, struct PointerRNA *layer_group);
void GreasePencilv3LayerGroup_move_to_layer_group_func(struct GreasePencil *_self, struct PointerRNA *layer_group, struct PointerRNA *parent_group);
/**************** Grease Pencil Layers ****************/

extern StructRNA RNA_GreasePencilv3Layers;

PointerRNA GreasePencilv3Layers_rna_type_get(PointerRNA *ptr);

PointerRNA GreasePencilv3Layers_active_get(PointerRNA *ptr);

struct GreasePencilLayer *GreasePencilv3Layers_new_func(struct GreasePencil *_self, const char * name, bool set_active, struct PointerRNA *layer_group);
void GreasePencilv3Layers_remove_func(struct GreasePencil *_self, struct PointerRNA *layer);
void GreasePencilv3Layers_move_func(struct GreasePencil *_self, struct PointerRNA *layer, int type);
void GreasePencilv3Layers_move_top_func(struct GreasePencil *_self, struct PointerRNA *layer);
void GreasePencilv3Layers_move_bottom_func(struct GreasePencil *_self, struct PointerRNA *layer);
void GreasePencilv3Layers_move_to_layer_group_func(struct GreasePencil *_self, struct PointerRNA *layer, struct PointerRNA *layer_group);
/**************** GroupNodeViewerPathElem ****************/

extern StructRNA RNA_GroupNodeViewerPathElem;
extern StructRNA RNA_ViewerPathElem;

int GroupNodeViewerPathElem_node_id_get(PointerRNA *ptr);
void GroupNodeViewerPathElem_node_id_set(PointerRNA *ptr, int value);

/**************** Header ****************/

extern StructRNA RNA_Header;

PointerRNA Header_rna_type_get(PointerRNA *ptr);

void Header_bl_idname_get(PointerRNA *ptr, char *value);
int Header_bl_idname_length(PointerRNA *ptr);
void Header_bl_idname_set(PointerRNA *ptr, const char *value);

PointerRNA Header_layout_get(PointerRNA *ptr);

enum {
	Header_bl_region_type_WINDOW = 0,
	Header_bl_region_type_HEADER = 1,
	Header_bl_region_type_CHANNELS = 2,
	Header_bl_region_type_TEMPORARY = 3,
	Header_bl_region_type_UI = 4,
	Header_bl_region_type_TOOLS = 5,
	Header_bl_region_type_TOOL_PROPS = 6,
	Header_bl_region_type_ASSET_SHELF = 14,
	Header_bl_region_type_ASSET_SHELF_HEADER = 15,
	Header_bl_region_type_PREVIEW = 7,
	Header_bl_region_type_HUD = 8,
	Header_bl_region_type_NAVIGATION_BAR = 9,
	Header_bl_region_type_EXECUTE = 10,
	Header_bl_region_type_FOOTER = 11,
	Header_bl_region_type_TOOL_HEADER = 12,
	Header_bl_region_type_XR = 13,
};

int Header_bl_region_type_get(PointerRNA *ptr);
void Header_bl_region_type_set(PointerRNA *ptr, int value);

enum {
	Header_bl_space_type_EMPTY = 0,
	Header_bl_space_type_VIEW_3D = 1,
	Header_bl_space_type_IMAGE_EDITOR = 6,
	Header_bl_space_type_NODE_EDITOR = 16,
	Header_bl_space_type_SEQUENCE_EDITOR = 8,
	Header_bl_space_type_CLIP_EDITOR = 20,
	Header_bl_space_type_DOPESHEET_EDITOR = 12,
	Header_bl_space_type_GRAPH_EDITOR = 2,
	Header_bl_space_type_NLA_EDITOR = 13,
	Header_bl_space_type_TEXT_EDITOR = 9,
	Header_bl_space_type_CONSOLE = 18,
	Header_bl_space_type_INFO = 7,
	Header_bl_space_type_TOPBAR = 21,
	Header_bl_space_type_STATUSBAR = 22,
	Header_bl_space_type_OUTLINER = 3,
	Header_bl_space_type_PROPERTIES = 4,
	Header_bl_space_type_FILE_BROWSER = 5,
	Header_bl_space_type_SPREADSHEET = 23,
	Header_bl_space_type_PREFERENCES = 19,
};

int Header_bl_space_type_get(PointerRNA *ptr);
void Header_bl_space_type_set(PointerRNA *ptr, int value);

void Header_draw_func(struct Header *_self, struct bContext *context);
/**************** Histogram ****************/

extern StructRNA RNA_Histogram;

PointerRNA Histogram_rna_type_get(PointerRNA *ptr);

enum {
	Histogram_mode_LUMA = 0,
	Histogram_mode_RGB = 1,
	Histogram_mode_R = 2,
	Histogram_mode_G = 3,
	Histogram_mode_B = 4,
	Histogram_mode_A = 5,
};

int Histogram_mode_get(PointerRNA *ptr);
void Histogram_mode_set(PointerRNA *ptr, int value);

bool Histogram_show_line_get(PointerRNA *ptr);
void Histogram_show_line_set(PointerRNA *ptr, bool value);

/**************** Hook Modifier ****************/

extern StructRNA RNA_HookModifier;
extern StructRNA RNA_Modifier;

PointerRNA HookModifier_falloff_curve_get(PointerRNA *ptr);

enum {
	HookModifier_falloff_type_NONE = 0,
	HookModifier_falloff_type_CURVE = 1,
	HookModifier_falloff_type_SMOOTH = 3,
	HookModifier_falloff_type_SPHERE = 7,
	HookModifier_falloff_type_ROOT = 4,
	HookModifier_falloff_type_INVERSE_SQUARE = 8,
	HookModifier_falloff_type_SHARP = 2,
	HookModifier_falloff_type_LINEAR = 5,
	HookModifier_falloff_type_CONSTANT = 6,
};

int HookModifier_falloff_type_get(PointerRNA *ptr);
void HookModifier_falloff_type_set(PointerRNA *ptr, int value);

void HookModifier_center_get(PointerRNA *ptr, float values[3]);
void HookModifier_center_set(PointerRNA *ptr, const float values[3]);

bool HookModifier_invert_vertex_group_get(PointerRNA *ptr);
void HookModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

void HookModifier_matrix_inverse_get(PointerRNA *ptr, float values[16]);
void HookModifier_matrix_inverse_set(PointerRNA *ptr, const float values[16]);

PointerRNA HookModifier_object_get(PointerRNA *ptr);

float HookModifier_falloff_radius_get(PointerRNA *ptr);
void HookModifier_falloff_radius_set(PointerRNA *ptr, float value);

float HookModifier_strength_get(PointerRNA *ptr);
void HookModifier_strength_set(PointerRNA *ptr, float value);

#define HookModifier_subtarget_MAX 64

void HookModifier_subtarget_get(PointerRNA *ptr, char *value);
int HookModifier_subtarget_length(PointerRNA *ptr);
void HookModifier_subtarget_set(PointerRNA *ptr, const char *value);

bool HookModifier_use_falloff_uniform_get(PointerRNA *ptr);
void HookModifier_use_falloff_uniform_set(PointerRNA *ptr, bool value);

#define HookModifier_vertex_group_MAX 64

void HookModifier_vertex_group_get(PointerRNA *ptr, char *value);
int HookModifier_vertex_group_length(PointerRNA *ptr);
void HookModifier_vertex_group_set(PointerRNA *ptr, const char *value);

void HookModifier_vertex_indices_get(PointerRNA *ptr, int values[]);
void HookModifier_vertex_indices_set(PointerRNA *ptr, const int values[]);
int HookModifier_vertex_indices_get_length(PointerRNA *ptr, int *arraylen);

void HookModifier_vertex_indices_set_func(struct HookModifierData *_self, ReportList *reports, int indices_num, int *indices);
/**************** HueCorrectModifier ****************/

extern StructRNA RNA_HueCorrectModifier;
extern StructRNA RNA_StripModifier;

PointerRNA HueCorrectModifier_curve_mapping_get(PointerRNA *ptr);

bool HueCorrectModifier_open_mask_input_panel_get(PointerRNA *ptr);
void HueCorrectModifier_open_mask_input_panel_set(PointerRNA *ptr, bool value);

/**************** Hydra Render Engine ****************/

extern StructRNA RNA_HydraRenderEngine;
extern StructRNA RNA_RenderEngine;

/**************** ID ****************/

extern StructRNA RNA_ID;

PointerRNA ID_rna_type_get(PointerRNA *ptr);

#define ID_name_MAX 256

void ID_name_get(PointerRNA *ptr, char *value);
int ID_name_length(PointerRNA *ptr);
void ID_name_set(PointerRNA *ptr, const char *value);

PointerRNA ID_asset_data_get(PointerRNA *ptr);

bool ID_is_editable_get(PointerRNA *ptr);
void ID_is_editable_set(PointerRNA *ptr, bool value);

bool ID_is_embedded_data_get(PointerRNA *ptr);
void ID_is_embedded_data_set(PointerRNA *ptr, bool value);

bool ID_use_extra_user_get(PointerRNA *ptr);
void ID_use_extra_user_set(PointerRNA *ptr, bool value);

bool ID_use_fake_user_get(PointerRNA *ptr);
void ID_use_fake_user_set(PointerRNA *ptr, bool value);

#define ID_name_full_MAX 516

void ID_name_full_get(PointerRNA *ptr, char *value);
int ID_name_full_length(PointerRNA *ptr);
void ID_name_full_set(PointerRNA *ptr, const char *value);

bool ID_is_evaluated_get(PointerRNA *ptr);
void ID_is_evaluated_set(PointerRNA *ptr, bool value);

bool ID_is_library_indirect_get(PointerRNA *ptr);
void ID_is_library_indirect_set(PointerRNA *ptr, bool value);

PointerRNA ID_library_get(PointerRNA *ptr);

PointerRNA ID_override_library_get(PointerRNA *ptr);

PointerRNA ID_library_weak_reference_get(PointerRNA *ptr);

bool ID_is_linked_packed_get(PointerRNA *ptr);
void ID_is_linked_packed_set(PointerRNA *ptr, bool value);

bool ID_is_missing_get(PointerRNA *ptr);
void ID_is_missing_set(PointerRNA *ptr, bool value);

PointerRNA ID_original_get(PointerRNA *ptr);

PointerRNA ID_preview_get(PointerRNA *ptr);

bool ID_is_runtime_data_get(PointerRNA *ptr);
void ID_is_runtime_data_set(PointerRNA *ptr, bool value);

int ID_session_uid_get(PointerRNA *ptr);
void ID_session_uid_set(PointerRNA *ptr, int value);

bool ID_tag_get(PointerRNA *ptr);
void ID_tag_set(PointerRNA *ptr, bool value);

enum {
	ID_id_type_ACTION = 17217,
	ID_id_type_ARMATURE = 21057,
	ID_id_type_BRUSH = 21058,
	ID_id_type_CACHEFILE = 17987,
	ID_id_type_CAMERA = 16707,
	ID_id_type_COLLECTION = 21063,
	ID_id_type_CURVE = 21827,
	ID_id_type_CURVES = 22083,
	ID_id_type_FONT = 18006,
	ID_id_type_GREASEPENCIL = 17479,
	ID_id_type_GREASEPENCIL_V3 = 20551,
	ID_id_type_IMAGE = 19785,
	ID_id_type_KEY = 17739,
	ID_id_type_LATTICE = 21580,
	ID_id_type_LIBRARY = 18764,
	ID_id_type_LIGHT = 16716,
	ID_id_type_LIGHT_PROBE = 20556,
	ID_id_type_LINESTYLE = 21324,
	ID_id_type_MASK = 21325,
	ID_id_type_MATERIAL = 16717,
	ID_id_type_MESH = 17741,
	ID_id_type_META = 16973,
	ID_id_type_MOVIECLIP = 17229,
	ID_id_type_NODETREE = 21582,
	ID_id_type_OBJECT = 16975,
	ID_id_type_PAINTCURVE = 17232,
	ID_id_type_PALETTE = 19536,
	ID_id_type_PARTICLE = 16720,
	ID_id_type_POINTCLOUD = 21584,
	ID_id_type_SCENE = 17235,
	ID_id_type_SCREEN = 21075,
	ID_id_type_SOUND = 20307,
	ID_id_type_SPEAKER = 19283,
	ID_id_type_TEXT = 22612,
	ID_id_type_TEXTURE = 17748,
	ID_id_type_VOLUME = 20310,
	ID_id_type_WINDOWMANAGER = 19799,
	ID_id_type_WORKSPACE = 21335,
	ID_id_type_WORLD = 20311,
};

int ID_id_type_get(PointerRNA *ptr);
void ID_id_type_set(PointerRNA *ptr, int value);

int ID_users_get(PointerRNA *ptr);
void ID_users_set(PointerRNA *ptr, int value);

struct IDPropertyGroup *ID_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
int ID_rename_func(struct ID *_self, Main *bmain, const char * name, int mode);
struct ID *ID_evaluated_get_func(struct ID *_self, struct Depsgraph *depsgraph);
struct ID *ID_copy_func(struct ID *_self, Main *bmain);
void ID_asset_mark_func(struct ID *_self);
void ID_asset_clear_func(struct ID *_self);
void ID_asset_generate_preview_func(struct ID *_self, bContext *C);
struct ID *ID_override_create_func(struct ID *_self, Main *bmain, bool remap_local_usages);
struct ID *ID_override_hierarchy_create_func(struct ID *_self, Main *bmain, struct Scene *scene, struct ViewLayer *view_layer, struct ID *reference, bool do_fully_editable);
void ID_user_clear_func(struct ID *_self);
void ID_user_remap_func(struct ID *_self, Main *bmain, struct ID *new_id);
struct ID *ID_make_local_func(struct ID *_self, Main *bmain, bool clear_proxy, bool clear_liboverride, bool clear_asset_data);
int ID_user_of_id_func(struct ID *_self, struct ID *id);
struct AnimData *ID_animation_data_create_func(struct ID *_self, Main *bmain);
void ID_animation_data_clear_func(struct ID *_self, Main *bmain);
void ID_update_tag_func(struct ID *_self, Main *bmain, ReportList *reports, int refresh);
struct PreviewImage *ID_preview_ensure_func(struct ID *_self);
/**************** ID Materials ****************/

extern StructRNA RNA_IDMaterials;

PointerRNA IDMaterials_rna_type_get(PointerRNA *ptr);

void IDMaterials_append_func(struct ID *_self, Main *bmain, struct Material *material);
struct Material *IDMaterials_pop_func(struct ID *_self, Main *bmain, ReportList *reports, int index);
void IDMaterials_clear_func(struct ID *_self, Main *bmain);
/**************** ID Library Override ****************/

extern StructRNA RNA_IDOverrideLibrary;

PointerRNA IDOverrideLibrary_rna_type_get(PointerRNA *ptr);

PointerRNA IDOverrideLibrary_hierarchy_root_get(PointerRNA *ptr);

bool IDOverrideLibrary_is_in_hierarchy_get(PointerRNA *ptr);
void IDOverrideLibrary_is_in_hierarchy_set(PointerRNA *ptr, bool value);

bool IDOverrideLibrary_is_system_override_get(PointerRNA *ptr);
void IDOverrideLibrary_is_system_override_set(PointerRNA *ptr, bool value);

void IDOverrideLibrary_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void IDOverrideLibrary_properties_next(CollectionPropertyIterator *iter);
void IDOverrideLibrary_properties_end(CollectionPropertyIterator *iter);
bool IDOverrideLibrary_properties_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

PointerRNA IDOverrideLibrary_reference_get(PointerRNA *ptr);

void IDOverrideLibrary_operations_update_func(struct ID *_selfid, struct IDOverrideLibrary *_self, Main *bmain, ReportList *reports);
void IDOverrideLibrary_reset_func(struct ID *_selfid, struct IDOverrideLibrary *_self, Main *bmain, ReportList *reports, bool do_hierarchy, bool set_system_override);
void IDOverrideLibrary_destroy_func(struct ID *_selfid, struct IDOverrideLibrary *_self, Main *bmain, ReportList *reports, bool do_hierarchy);
bool IDOverrideLibrary_resync_func(struct ID *_selfid, struct IDOverrideLibrary *_self, Main *bmain, ReportList *reports, struct Scene *scene, struct ViewLayer *view_layer, struct Collection *residual_storage, bool do_hierarchy_enforce, bool do_whole_hierarchy);
/**************** Override Properties ****************/

extern StructRNA RNA_IDOverrideLibraryProperties;

PointerRNA IDOverrideLibraryProperties_rna_type_get(PointerRNA *ptr);

struct IDOverrideLibraryProperty *IDOverrideLibraryProperties_add_func(struct IDOverrideLibrary *_self, ReportList *reports, const char * rna_path);
void IDOverrideLibraryProperties_remove_func(struct IDOverrideLibrary *_self, ReportList *reports, struct IDOverrideLibraryProperty *property);
/**************** ID Library Override Property ****************/

extern StructRNA RNA_IDOverrideLibraryProperty;

PointerRNA IDOverrideLibraryProperty_rna_type_get(PointerRNA *ptr);

void IDOverrideLibraryProperty_operations_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void IDOverrideLibraryProperty_operations_next(CollectionPropertyIterator *iter);
void IDOverrideLibraryProperty_operations_end(CollectionPropertyIterator *iter);
bool IDOverrideLibraryProperty_operations_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

#define IDOverrideLibraryProperty_rna_path_MAX 2147483647

void IDOverrideLibraryProperty_rna_path_get(PointerRNA *ptr, char *value);
int IDOverrideLibraryProperty_rna_path_length(PointerRNA *ptr);
void IDOverrideLibraryProperty_rna_path_set(PointerRNA *ptr, const char *value);

/**************** ID Library Override Property Operation ****************/

extern StructRNA RNA_IDOverrideLibraryPropertyOperation;

PointerRNA IDOverrideLibraryPropertyOperation_rna_type_get(PointerRNA *ptr);

enum {
	IDOverrideLibraryPropertyOperation_flag_MANDATORY = 1,
	IDOverrideLibraryPropertyOperation_flag_LOCKED = 2,
	IDOverrideLibraryPropertyOperation_flag_IDPOINTER_MATCH_REFERENCE = 256,
	IDOverrideLibraryPropertyOperation_flag_IDPOINTER_ITEM_USE_ID = 512,
};

int IDOverrideLibraryPropertyOperation_flag_get(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_flag_set(PointerRNA *ptr, int value);

enum {
	IDOverrideLibraryPropertyOperation_operation_NOOP = 0,
	IDOverrideLibraryPropertyOperation_operation_REPLACE = 1,
	IDOverrideLibraryPropertyOperation_operation_DIFF_ADD = 101,
	IDOverrideLibraryPropertyOperation_operation_DIFF_SUB = 102,
	IDOverrideLibraryPropertyOperation_operation_FACT_MULTIPLY = 103,
	IDOverrideLibraryPropertyOperation_operation_INSERT_AFTER = 201,
	IDOverrideLibraryPropertyOperation_operation_INSERT_BEFORE = 202,
};

int IDOverrideLibraryPropertyOperation_operation_get(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_operation_set(PointerRNA *ptr, int value);

PointerRNA IDOverrideLibraryPropertyOperation_subitem_local_id_get(PointerRNA *ptr);

int IDOverrideLibraryPropertyOperation_subitem_local_index_get(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_subitem_local_index_set(PointerRNA *ptr, int value);

#define IDOverrideLibraryPropertyOperation_subitem_local_name_MAX 2147483647

void IDOverrideLibraryPropertyOperation_subitem_local_name_get(PointerRNA *ptr, char *value);
int IDOverrideLibraryPropertyOperation_subitem_local_name_length(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_subitem_local_name_set(PointerRNA *ptr, const char *value);

PointerRNA IDOverrideLibraryPropertyOperation_subitem_reference_id_get(PointerRNA *ptr);

int IDOverrideLibraryPropertyOperation_subitem_reference_index_get(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_subitem_reference_index_set(PointerRNA *ptr, int value);

#define IDOverrideLibraryPropertyOperation_subitem_reference_name_MAX 2147483647

void IDOverrideLibraryPropertyOperation_subitem_reference_name_get(PointerRNA *ptr, char *value);
int IDOverrideLibraryPropertyOperation_subitem_reference_name_length(PointerRNA *ptr);
void IDOverrideLibraryPropertyOperation_subitem_reference_name_set(PointerRNA *ptr, const char *value);

/**************** Override Operations ****************/

extern StructRNA RNA_IDOverrideLibraryPropertyOperations;

PointerRNA IDOverrideLibraryPropertyOperations_rna_type_get(PointerRNA *ptr);

struct IDOverrideLibraryPropertyOperation *IDOverrideLibraryPropertyOperations_add_func(struct IDOverrideLibraryProperty *_self, ReportList *reports, int operation, bool use_id, const char * subitem_reference_name, const char * subitem_local_name, struct ID *subitem_reference_id, struct ID *subitem_local_id, int subitem_reference_index, int subitem_local_index);
void IDOverrideLibraryPropertyOperations_remove_func(struct IDOverrideLibraryProperty *_self, ReportList *reports, struct IDOverrideLibraryPropertyOperation *operation);
/**************** IDPropertyWrapPtr ****************/

extern StructRNA RNA_IDPropertyWrapPtr;

PointerRNA IDPropertyWrapPtr_rna_type_get(PointerRNA *ptr);

struct IDPropertyGroup *IDPropertyWrapPtr_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
/**************** IDViewerPathElem ****************/

extern StructRNA RNA_IDViewerPathElem;
extern StructRNA RNA_ViewerPathElem;

PointerRNA IDViewerPathElem_id_get(PointerRNA *ptr);

/**************** IKParam ****************/

extern StructRNA RNA_IKParam;

PointerRNA IKParam_rna_type_get(PointerRNA *ptr);

enum {
	IKParam_ik_solver_LEGACY = 0,
	IKParam_ik_solver_ITASC = 1,
};

int IKParam_ik_solver_get(PointerRNA *ptr);
void IKParam_ik_solver_set(PointerRNA *ptr, int value);

/**************** Image ****************/

extern StructRNA RNA_Image;
extern StructRNA RNA_ID;

enum {
	Image_alpha_mode_STRAIGHT = 0,
	Image_alpha_mode_PREMUL = 1,
	Image_alpha_mode_CHANNEL_PACKED = 2,
	Image_alpha_mode_NONE = 3,
};

int Image_alpha_mode_get(PointerRNA *ptr);
void Image_alpha_mode_set(PointerRNA *ptr, int value);

int Image_channels_get(PointerRNA *ptr);
void Image_channels_set(PointerRNA *ptr, int value);

void Image_generated_color_get(PointerRNA *ptr, float values[4]);
void Image_generated_color_set(PointerRNA *ptr, const float values[4]);

PointerRNA Image_colorspace_settings_get(PointerRNA *ptr);

bool Image_use_deinterlace_get(PointerRNA *ptr);
void Image_use_deinterlace_set(PointerRNA *ptr, bool value);

int Image_depth_get(PointerRNA *ptr);
void Image_depth_set(PointerRNA *ptr, int value);

bool Image_is_dirty_get(PointerRNA *ptr);
void Image_is_dirty_set(PointerRNA *ptr, bool value);

void Image_display_aspect_get(PointerRNA *ptr, float values[2]);
void Image_display_aspect_set(PointerRNA *ptr, const float values[2]);

int Image_frame_duration_get(PointerRNA *ptr);
void Image_frame_duration_set(PointerRNA *ptr, int value);

enum {
	Image_file_format_JPEG = 4,
	Image_file_format_OPEN_EXR = 23,
	Image_file_format_PNG = 17,
	Image_file_format_WEBP = 35,
	Image_file_format_BMP = 20,
	Image_file_format_CINEON = 26,
	Image_file_format_DPX = 27,
	Image_file_format_IRIS = 1,
	Image_file_format_JPEG2000 = 30,
	Image_file_format_HDR = 21,
	Image_file_format_TARGA = 0,
	Image_file_format_TARGA_RAW = 14,
	Image_file_format_TIFF = 22,
	Image_file_format_OPEN_EXR_MULTILAYER = 28,
	Image_file_format_FFMPEG = 24,
};

int Image_file_format_get(PointerRNA *ptr);
void Image_file_format_set(PointerRNA *ptr, int value);

#define Image_filepath_MAX 1024

void Image_filepath_get(PointerRNA *ptr, char *value);
int Image_filepath_length(PointerRNA *ptr);
void Image_filepath_set(PointerRNA *ptr, const char *value);

#define Image_filepath_raw_MAX 1024

void Image_filepath_raw_get(PointerRNA *ptr, char *value);
int Image_filepath_raw_length(PointerRNA *ptr);
void Image_filepath_raw_set(PointerRNA *ptr, const char *value);

bool Image_use_generated_float_get(PointerRNA *ptr);
void Image_use_generated_float_set(PointerRNA *ptr, bool value);

int Image_generated_height_get(PointerRNA *ptr);
void Image_generated_height_set(PointerRNA *ptr, int value);

enum {
	Image_generated_type_BLANK = 0,
	Image_generated_type_UV_GRID = 1,
	Image_generated_type_COLOR_GRID = 2,
};

int Image_generated_type_get(PointerRNA *ptr);
void Image_generated_type_set(PointerRNA *ptr, int value);

int Image_generated_width_get(PointerRNA *ptr);
void Image_generated_width_set(PointerRNA *ptr, int value);

bool Image_use_half_precision_get(PointerRNA *ptr);
void Image_use_half_precision_set(PointerRNA *ptr, bool value);

bool Image_has_data_get(PointerRNA *ptr);
void Image_has_data_set(PointerRNA *ptr, bool value);

void Image_tiles_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Image_tiles_next(CollectionPropertyIterator *iter);
void Image_tiles_end(CollectionPropertyIterator *iter);
bool Image_tiles_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool Image_is_float_get(PointerRNA *ptr);
void Image_is_float_set(PointerRNA *ptr, bool value);

bool Image_is_multiview_get(PointerRNA *ptr);
void Image_is_multiview_set(PointerRNA *ptr, bool value);

PointerRNA Image_packed_file_get(PointerRNA *ptr);

void Image_packed_files_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Image_packed_files_next(CollectionPropertyIterator *iter);
void Image_packed_files_end(CollectionPropertyIterator *iter);
bool Image_packed_files_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Image_packed_files_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

void Image_pixels_get(PointerRNA *ptr, float values[]);
void Image_pixels_set(PointerRNA *ptr, const float values[]);int Image_pixels_get_length(PointerRNA *ptr, int *arraylen);

void Image_render_slots_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Image_render_slots_next(CollectionPropertyIterator *iter);
void Image_render_slots_end(CollectionPropertyIterator *iter);
bool Image_render_slots_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

void Image_resolution_get(PointerRNA *ptr, float values[2]);
void Image_resolution_set(PointerRNA *ptr, const float values[2]);

int Image_seam_margin_get(PointerRNA *ptr);
void Image_seam_margin_set(PointerRNA *ptr, int value);

void Image_size_get(PointerRNA *ptr, int values[2]);
void Image_size_set(PointerRNA *ptr, const int values[2]);

enum {
	Image_source_FILE = 1,
	Image_source_SEQUENCE = 2,
	Image_source_MOVIE = 3,
	Image_source_GENERATED = 4,
	Image_source_VIEWER = 5,
	Image_source_TILED = 6,
};

int Image_source_get(PointerRNA *ptr);
void Image_source_set(PointerRNA *ptr, int value);

bool Image_is_stereo_3d_get(PointerRNA *ptr);
void Image_is_stereo_3d_set(PointerRNA *ptr, bool value);

PointerRNA Image_stereo_3d_format_get(PointerRNA *ptr);

enum {
	Image_type_IMAGE = 0,
	Image_type_MULTILAYER = 1,
	Image_type_UV_TEST = 2,
	Image_type_RENDER_RESULT = 4,
	Image_type_COMPOSITING = 5,
};

int Image_type_get(PointerRNA *ptr);
void Image_type_set(PointerRNA *ptr, int value);

bool Image_use_multiview_get(PointerRNA *ptr);
void Image_use_multiview_set(PointerRNA *ptr, bool value);

bool Image_use_view_as_render_get(PointerRNA *ptr);
void Image_use_view_as_render_set(PointerRNA *ptr, bool value);

enum {
	Image_views_format_INDIVIDUAL = 0,
	Image_views_format_STEREO_3D = 1,
};

int Image_views_format_get(PointerRNA *ptr);
void Image_views_format_set(PointerRNA *ptr, int value);

void Image_save_render_func(struct Image *_self, bContext *C, ReportList *reports, const char * filepath, struct Scene *scene, int quality);
void Image_save_func(struct Image *_self, Main *bmain, bContext *C, ReportList *reports, const char * filepath, int quality, bool save_copy);
void Image_pack_func(struct Image *_self, Main *bmain, bContext *C, ReportList *reports, const char * data, int data_len);
void Image_unpack_func(struct Image *_self, Main *bmain, ReportList *reports, int method);
void Image_reload_func(struct Image *_self, Main *bmain);
void Image_update_func(struct Image *_self, ReportList *reports);
void Image_scale_func(struct Image *_self, ReportList *reports, int width, int height, int frame, int tile_index);
int Image_gl_touch_func(struct Image *_self, ReportList *reports, int frame, int layer_index, int pass_index);
int Image_gl_load_func(struct Image *_self, ReportList *reports, int frame, int layer_index, int pass_index);
void Image_gl_free_func(struct Image *_self);
void Image_filepath_from_user_func(struct Image *_self, struct ImageUser *image_user, char * filepath);
void Image_buffers_free_func(struct Image *_self);
/**************** Image Format ****************/

extern StructRNA RNA_ImageFormatSettings;

PointerRNA ImageFormatSettings_rna_type_get(PointerRNA *ptr);

int ImageFormatSettings_cineon_black_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_black_set(PointerRNA *ptr, int value);

bool ImageFormatSettings_use_jpeg2k_cinema_preset_get(PointerRNA *ptr);
void ImageFormatSettings_use_jpeg2k_cinema_preset_set(PointerRNA *ptr, bool value);

bool ImageFormatSettings_use_jpeg2k_cinema_48_get(PointerRNA *ptr);
void ImageFormatSettings_use_jpeg2k_cinema_48_set(PointerRNA *ptr, bool value);

enum {
	ImageFormatSettings_exr_codec_NONE = 0,
	ImageFormatSettings_exr_codec_ZIP = 2,
	ImageFormatSettings_exr_codec_PIZ = 3,
	ImageFormatSettings_exr_codec_DWAA = 8,
	ImageFormatSettings_exr_codec_DWAB = 9,
	ImageFormatSettings_exr_codec_ZIPS = 5,
	ImageFormatSettings_exr_codec_RLE = 4,
	ImageFormatSettings_exr_codec_PXR24 = 1,
	ImageFormatSettings_exr_codec_B44 = 6,
	ImageFormatSettings_exr_codec_B44A = 7,
};

int ImageFormatSettings_exr_codec_get(PointerRNA *ptr);
void ImageFormatSettings_exr_codec_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_jpeg2k_codec_JP2 = 0,
	ImageFormatSettings_jpeg2k_codec_J2K = 1,
};

int ImageFormatSettings_jpeg2k_codec_get(PointerRNA *ptr);
void ImageFormatSettings_jpeg2k_codec_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_color_depth_8 = 2,
	ImageFormatSettings_color_depth_10 = 4,
	ImageFormatSettings_color_depth_12 = 8,
	ImageFormatSettings_color_depth_16 = 16,
	ImageFormatSettings_color_depth_32 = 64,
};

int ImageFormatSettings_color_depth_get(PointerRNA *ptr);
void ImageFormatSettings_color_depth_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_color_management_FOLLOW_SCENE = 0,
	ImageFormatSettings_color_management_OVERRIDE = 1,
};

int ImageFormatSettings_color_management_get(PointerRNA *ptr);
void ImageFormatSettings_color_management_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_color_mode_BW = 8,
	ImageFormatSettings_color_mode_RGB = 24,
	ImageFormatSettings_color_mode_RGBA = 32,
};

int ImageFormatSettings_color_mode_get(PointerRNA *ptr);
void ImageFormatSettings_color_mode_set(PointerRNA *ptr, int value);

PointerRNA ImageFormatSettings_linear_colorspace_settings_get(PointerRNA *ptr);

int ImageFormatSettings_compression_get(PointerRNA *ptr);
void ImageFormatSettings_compression_set(PointerRNA *ptr, int value);

enum {
	ImageFormatSettings_tiff_codec_NONE = 3,
	ImageFormatSettings_tiff_codec_DEFLATE = 0,
	ImageFormatSettings_tiff_codec_LZW = 1,
	ImageFormatSettings_tiff_codec_PACKBITS = 2,
};

int ImageFormatSettings_tiff_codec_get(PointerRNA *ptr);
void ImageFormatSettings_tiff_codec_set(PointerRNA *ptr, int value);

PointerRNA ImageFormatSettings_display_settings_get(PointerRNA *ptr);

enum {
	ImageFormatSettings_file_format_JPEG = 4,
	ImageFormatSettings_file_format_OPEN_EXR = 23,
	ImageFormatSettings_file_format_PNG = 17,
	ImageFormatSettings_file_format_WEBP = 35,
	ImageFormatSettings_file_format_BMP = 20,
	ImageFormatSettings_file_format_CINEON = 26,
	ImageFormatSettings_file_format_DPX = 27,
	ImageFormatSettings_file_format_IRIS = 1,
	ImageFormatSettings_file_format_JPEG2000 = 30,
	ImageFormatSettings_file_format_HDR = 21,
	ImageFormatSettings_file_format_TARGA = 0,
	ImageFormatSettings_file_format_TARGA_RAW = 14,
	ImageFormatSettings_file_format_TIFF = 22,
	ImageFormatSettings_file_format_OPEN_EXR_MULTILAYER = 28,
	ImageFormatSettings_file_format_FFMPEG = 24,
};

int ImageFormatSettings_file_format_get(PointerRNA *ptr);
void ImageFormatSettings_file_format_set(PointerRNA *ptr, int value);

float ImageFormatSettings_cineon_gamma_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_gamma_set(PointerRNA *ptr, float value);

bool ImageFormatSettings_has_linear_colorspace_get(PointerRNA *ptr);
void ImageFormatSettings_has_linear_colorspace_set(PointerRNA *ptr, bool value);

bool ImageFormatSettings_use_exr_interleave_get(PointerRNA *ptr);
void ImageFormatSettings_use_exr_interleave_set(PointerRNA *ptr, bool value);

bool ImageFormatSettings_use_cineon_log_get(PointerRNA *ptr);
void ImageFormatSettings_use_cineon_log_set(PointerRNA *ptr, bool value);

enum {
	ImageFormatSettings_media_type_IMAGE = 0,
	ImageFormatSettings_media_type_MULTI_LAYER_IMAGE = 1,
	ImageFormatSettings_media_type_VIDEO = 2,
};

int ImageFormatSettings_media_type_get(PointerRNA *ptr);
void ImageFormatSettings_media_type_set(PointerRNA *ptr, int value);

bool ImageFormatSettings_use_preview_get(PointerRNA *ptr);
void ImageFormatSettings_use_preview_set(PointerRNA *ptr, bool value);

int ImageFormatSettings_quality_get(PointerRNA *ptr);
void ImageFormatSettings_quality_set(PointerRNA *ptr, int value);

PointerRNA ImageFormatSettings_stereo_3d_format_get(PointerRNA *ptr);

PointerRNA ImageFormatSettings_view_settings_get(PointerRNA *ptr);

enum {
	ImageFormatSettings_views_format_INDIVIDUAL = 0,
	ImageFormatSettings_views_format_STEREO_3D = 1,
	ImageFormatSettings_views_format_MULTIVIEW = 2,
};

int ImageFormatSettings_views_format_get(PointerRNA *ptr);
void ImageFormatSettings_views_format_set(PointerRNA *ptr, int value);

int ImageFormatSettings_cineon_white_get(PointerRNA *ptr);
void ImageFormatSettings_cineon_white_set(PointerRNA *ptr, int value);

bool ImageFormatSettings_use_jpeg2k_ycc_get(PointerRNA *ptr);
void ImageFormatSettings_use_jpeg2k_ycc_set(PointerRNA *ptr, bool value);

/**************** ImagePackedFile ****************/

extern StructRNA RNA_ImagePackedFile;

PointerRNA ImagePackedFile_rna_type_get(PointerRNA *ptr);

PointerRNA ImagePackedFile_packed_file_get(PointerRNA *ptr);

int ImagePackedFile_tile_number_get(PointerRNA *ptr);
void ImagePackedFile_tile_number_set(PointerRNA *ptr, int value);

int ImagePackedFile_view_get(PointerRNA *ptr);
void ImagePackedFile_view_set(PointerRNA *ptr, int value);

#define ImagePackedFile_filepath_MAX 1024

void ImagePackedFile_filepath_get(PointerRNA *ptr, char *value);
int ImagePackedFile_filepath_length(PointerRNA *ptr);
void ImagePackedFile_filepath_set(PointerRNA *ptr, const char *value);

void ImagePackedFile_save_func(struct ImagePackedFile *_self, Main *bmain, ReportList *reports);
/**************** Image Paint ****************/

extern StructRNA RNA_ImagePaint;
extern StructRNA RNA_Paint;

int ImagePaint_normal_angle_get(PointerRNA *ptr);
void ImagePaint_normal_angle_set(PointerRNA *ptr, int value);

int ImagePaint_seam_bleed_get(PointerRNA *ptr);
void ImagePaint_seam_bleed_set(PointerRNA *ptr, int value);

PointerRNA ImagePaint_canvas_get(PointerRNA *ptr);

float ImagePaint_clone_alpha_get(PointerRNA *ptr);
void ImagePaint_clone_alpha_set(PointerRNA *ptr, float value);

PointerRNA ImagePaint_clone_image_get(PointerRNA *ptr);

bool ImagePaint_use_clone_layer_get(PointerRNA *ptr);
void ImagePaint_use_clone_layer_set(PointerRNA *ptr, bool value);

void ImagePaint_clone_offset_get(PointerRNA *ptr, float values[2]);
void ImagePaint_clone_offset_set(PointerRNA *ptr, const float values[2]);

bool ImagePaint_use_backface_culling_get(PointerRNA *ptr);
void ImagePaint_use_backface_culling_set(PointerRNA *ptr, bool value);

float ImagePaint_dither_get(PointerRNA *ptr);
void ImagePaint_dither_set(PointerRNA *ptr, float value);

enum {
	ImagePaint_interpolation_LINEAR = 0,
	ImagePaint_interpolation_CLOSEST = 1,
};

int ImagePaint_interpolation_get(PointerRNA *ptr);
void ImagePaint_interpolation_set(PointerRNA *ptr, int value);

bool ImagePaint_invert_stencil_get(PointerRNA *ptr);
void ImagePaint_invert_stencil_set(PointerRNA *ptr, bool value);

bool ImagePaint_missing_materials_get(PointerRNA *ptr);
void ImagePaint_missing_materials_set(PointerRNA *ptr, bool value);

bool ImagePaint_missing_stencil_get(PointerRNA *ptr);
void ImagePaint_missing_stencil_set(PointerRNA *ptr, bool value);

bool ImagePaint_missing_texture_get(PointerRNA *ptr);
void ImagePaint_missing_texture_set(PointerRNA *ptr, bool value);

bool ImagePaint_missing_uvs_get(PointerRNA *ptr);
void ImagePaint_missing_uvs_set(PointerRNA *ptr, bool value);

enum {
	ImagePaint_mode_MATERIAL = 0,
	ImagePaint_mode_IMAGE = 1,
};

int ImagePaint_mode_get(PointerRNA *ptr);
void ImagePaint_mode_set(PointerRNA *ptr, int value);

bool ImagePaint_use_normal_falloff_get(PointerRNA *ptr);
void ImagePaint_use_normal_falloff_set(PointerRNA *ptr, bool value);

bool ImagePaint_use_occlude_get(PointerRNA *ptr);
void ImagePaint_use_occlude_set(PointerRNA *ptr, bool value);

void ImagePaint_screen_grab_size_get(PointerRNA *ptr, int values[2]);
void ImagePaint_screen_grab_size_set(PointerRNA *ptr, const int values[2]);

void ImagePaint_stencil_color_get(PointerRNA *ptr, float values[3]);
void ImagePaint_stencil_color_set(PointerRNA *ptr, const float values[3]);

PointerRNA ImagePaint_stencil_image_get(PointerRNA *ptr);

bool ImagePaint_use_stencil_layer_get(PointerRNA *ptr);
void ImagePaint_use_stencil_layer_set(PointerRNA *ptr, bool value);

bool ImagePaint_detect_data_func(struct ImagePaintSettings *_self);
/**************** Image Preview ****************/

extern StructRNA RNA_ImagePreview;

PointerRNA ImagePreview_rna_type_get(PointerRNA *ptr);

bool ImagePreview_is_icon_custom_get(PointerRNA *ptr);
void ImagePreview_is_icon_custom_set(PointerRNA *ptr, bool value);

bool ImagePreview_is_image_custom_get(PointerRNA *ptr);
void ImagePreview_is_image_custom_set(PointerRNA *ptr, bool value);

void ImagePreview_icon_pixels_float_get(PointerRNA *ptr, float values[]);
void ImagePreview_icon_pixels_float_set(PointerRNA *ptr, const float values[]);int ImagePreview_icon_pixels_float_get_length(PointerRNA *ptr, int *arraylen);

void ImagePreview_image_pixels_float_get(PointerRNA *ptr, float values[]);
void ImagePreview_image_pixels_float_set(PointerRNA *ptr, const float values[]);int ImagePreview_image_pixels_float_get_length(PointerRNA *ptr, int *arraylen);

int ImagePreview_icon_id_get(PointerRNA *ptr);
void ImagePreview_icon_id_set(PointerRNA *ptr, int value);

void ImagePreview_icon_pixels_get(PointerRNA *ptr, int values[]);
void ImagePreview_icon_pixels_set(PointerRNA *ptr, const int values[]);
int ImagePreview_icon_pixels_get_length(PointerRNA *ptr, int *arraylen);

void ImagePreview_icon_size_get(PointerRNA *ptr, int values[2]);
void ImagePreview_icon_size_set(PointerRNA *ptr, const int values[2]);

void ImagePreview_image_pixels_get(PointerRNA *ptr, int values[]);
void ImagePreview_image_pixels_set(PointerRNA *ptr, const int values[]);
int ImagePreview_image_pixels_get_length(PointerRNA *ptr, int *arraylen);

void ImagePreview_image_size_get(PointerRNA *ptr, int values[2]);
void ImagePreview_image_size_set(PointerRNA *ptr, const int values[2]);

void ImagePreview_reload_func(struct PreviewImage *_self);
/**************** Image Strip ****************/

extern StructRNA RNA_ImageStrip;
extern StructRNA RNA_Strip;

enum {
	ImageStrip_alpha_mode_STRAIGHT = 0,
	ImageStrip_alpha_mode_PREMUL = 1,
};

int ImageStrip_alpha_mode_get(PointerRNA *ptr);
void ImageStrip_alpha_mode_set(PointerRNA *ptr, int value);

int ImageStrip_animation_offset_end_get(PointerRNA *ptr);
void ImageStrip_animation_offset_end_set(PointerRNA *ptr, int value);

int ImageStrip_animation_offset_start_get(PointerRNA *ptr);
void ImageStrip_animation_offset_start_set(PointerRNA *ptr, int value);

PointerRNA ImageStrip_colorspace_settings_get(PointerRNA *ptr);

bool ImageStrip_use_float_get(PointerRNA *ptr);
void ImageStrip_use_float_set(PointerRNA *ptr, bool value);

PointerRNA ImageStrip_crop_get(PointerRNA *ptr);

bool ImageStrip_use_deinterlace_get(PointerRNA *ptr);
void ImageStrip_use_deinterlace_set(PointerRNA *ptr, bool value);

#define ImageStrip_directory_MAX 768

void ImageStrip_directory_get(PointerRNA *ptr, char *value);
int ImageStrip_directory_length(PointerRNA *ptr);
void ImageStrip_directory_set(PointerRNA *ptr, const char *value);

void ImageStrip_elements_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ImageStrip_elements_next(CollectionPropertyIterator *iter);
void ImageStrip_elements_end(CollectionPropertyIterator *iter);
int ImageStrip_elements_length(PointerRNA *ptr);
bool ImageStrip_elements_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool ImageStrip_use_flip_x_get(PointerRNA *ptr);
void ImageStrip_use_flip_x_set(PointerRNA *ptr, bool value);

bool ImageStrip_use_flip_y_get(PointerRNA *ptr);
void ImageStrip_use_flip_y_set(PointerRNA *ptr, bool value);

bool ImageStrip_multiply_alpha_get(PointerRNA *ptr);
void ImageStrip_multiply_alpha_set(PointerRNA *ptr, bool value);

float ImageStrip_color_multiply_get(PointerRNA *ptr);
void ImageStrip_color_multiply_set(PointerRNA *ptr, float value);

PointerRNA ImageStrip_proxy_get(PointerRNA *ptr);

void ImageStrip_retiming_keys_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void ImageStrip_retiming_keys_next(CollectionPropertyIterator *iter);
void ImageStrip_retiming_keys_end(CollectionPropertyIterator *iter);
int ImageStrip_retiming_keys_length(PointerRNA *ptr);
bool ImageStrip_retiming_keys_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

bool ImageStrip_use_reverse_frames_get(PointerRNA *ptr);
void ImageStrip_use_reverse_frames_set(PointerRNA *ptr, bool value);

float ImageStrip_color_saturation_get(PointerRNA *ptr);
void ImageStrip_color_saturation_set(PointerRNA *ptr, float value);

PointerRNA ImageStrip_stereo_3d_format_get(PointerRNA *ptr);

float ImageStrip_strobe_get(PointerRNA *ptr);
void ImageStrip_strobe_set(PointerRNA *ptr, float value);

PointerRNA ImageStrip_transform_get(PointerRNA *ptr);

bool ImageStrip_use_multiview_get(PointerRNA *ptr);
void ImageStrip_use_multiview_set(PointerRNA *ptr, bool value);

bool ImageStrip_use_proxy_get(PointerRNA *ptr);
void ImageStrip_use_proxy_set(PointerRNA *ptr, bool value);

enum {
	ImageStrip_views_format_INDIVIDUAL = 0,
	ImageStrip_views_format_STEREO_3D = 1,
};

int ImageStrip_views_format_get(PointerRNA *ptr);
void ImageStrip_views_format_set(PointerRNA *ptr, int value);

/**************** Image Texture ****************/

extern StructRNA RNA_ImageTexture;
extern StructRNA RNA_Texture;
extern StructRNA RNA_ID;

bool ImageTexture_use_calculate_alpha_get(PointerRNA *ptr);
void ImageTexture_use_calculate_alpha_set(PointerRNA *ptr, bool value);

float ImageTexture_checker_distance_get(PointerRNA *ptr);
void ImageTexture_checker_distance_set(PointerRNA *ptr, float value);

bool ImageTexture_use_checker_even_get(PointerRNA *ptr);
void ImageTexture_use_checker_even_set(PointerRNA *ptr, bool value);

bool ImageTexture_use_checker_odd_get(PointerRNA *ptr);
void ImageTexture_use_checker_odd_set(PointerRNA *ptr, bool value);

float ImageTexture_crop_max_x_get(PointerRNA *ptr);
void ImageTexture_crop_max_x_set(PointerRNA *ptr, float value);

float ImageTexture_crop_max_y_get(PointerRNA *ptr);
void ImageTexture_crop_max_y_set(PointerRNA *ptr, float value);

float ImageTexture_crop_min_x_get(PointerRNA *ptr);
void ImageTexture_crop_min_x_set(PointerRNA *ptr, float value);

float ImageTexture_crop_min_y_get(PointerRNA *ptr);
void ImageTexture_crop_min_y_set(PointerRNA *ptr, float value);

enum {
	ImageTexture_extension_EXTEND = 1,
	ImageTexture_extension_CLIP = 2,
	ImageTexture_extension_CLIP_CUBE = 4,
	ImageTexture_extension_REPEAT = 3,
	ImageTexture_extension_CHECKER = 5,
};

int ImageTexture_extension_get(PointerRNA *ptr);
void ImageTexture_extension_set(PointerRNA *ptr, int value);

float ImageTexture_filter_size_get(PointerRNA *ptr);
void ImageTexture_filter_size_set(PointerRNA *ptr, float value);

bool ImageTexture_use_flip_axis_get(PointerRNA *ptr);
void ImageTexture_use_flip_axis_set(PointerRNA *ptr, bool value);

PointerRNA ImageTexture_image_get(PointerRNA *ptr);

PointerRNA ImageTexture_image_user_get(PointerRNA *ptr);

bool ImageTexture_use_interpolation_get(PointerRNA *ptr);
void ImageTexture_use_interpolation_set(PointerRNA *ptr, bool value);

bool ImageTexture_invert_alpha_get(PointerRNA *ptr);
void ImageTexture_invert_alpha_set(PointerRNA *ptr, bool value);

bool ImageTexture_use_mirror_x_get(PointerRNA *ptr);
void ImageTexture_use_mirror_x_set(PointerRNA *ptr, bool value);

bool ImageTexture_use_mirror_y_get(PointerRNA *ptr);
void ImageTexture_use_mirror_y_set(PointerRNA *ptr, bool value);

bool ImageTexture_use_normal_map_get(PointerRNA *ptr);
void ImageTexture_use_normal_map_set(PointerRNA *ptr, bool value);

int ImageTexture_repeat_x_get(PointerRNA *ptr);
void ImageTexture_repeat_x_set(PointerRNA *ptr, int value);

int ImageTexture_repeat_y_get(PointerRNA *ptr);
void ImageTexture_repeat_y_set(PointerRNA *ptr, int value);

bool ImageTexture_use_alpha_get(PointerRNA *ptr);
void ImageTexture_use_alpha_set(PointerRNA *ptr, bool value);

/**************** Image User ****************/

extern StructRNA RNA_ImageUser;

PointerRNA ImageUser_rna_type_get(PointerRNA *ptr);

bool ImageUser_use_auto_refresh_get(PointerRNA *ptr);
void ImageUser_use_auto_refresh_set(PointerRNA *ptr, bool value);

int ImageUser_frame_current_get(PointerRNA *ptr);
void ImageUser_frame_current_set(PointerRNA *ptr, int value);

bool ImageUser_use_cyclic_get(PointerRNA *ptr);
void ImageUser_use_cyclic_set(PointerRNA *ptr, bool value);

int ImageUser_frame_duration_get(PointerRNA *ptr);
void ImageUser_frame_duration_set(PointerRNA *ptr, int value);

int ImageUser_multilayer_layer_get(PointerRNA *ptr);
void ImageUser_multilayer_layer_set(PointerRNA *ptr, int value);

int ImageUser_frame_offset_get(PointerRNA *ptr);
void ImageUser_frame_offset_set(PointerRNA *ptr, int value);

int ImageUser_multilayer_pass_get(PointerRNA *ptr);
void ImageUser_multilayer_pass_set(PointerRNA *ptr, int value);

int ImageUser_frame_start_get(PointerRNA *ptr);
void ImageUser_frame_start_set(PointerRNA *ptr, int value);

int ImageUser_tile_get(PointerRNA *ptr);
void ImageUser_tile_set(PointerRNA *ptr, int value);

int ImageUser_multilayer_view_get(PointerRNA *ptr);
void ImageUser_multilayer_view_set(PointerRNA *ptr, int value);

/**************** Index Switch Item ****************/

extern StructRNA RNA_IndexSwitchItem;

PointerRNA IndexSwitchItem_rna_type_get(PointerRNA *ptr);

int IndexSwitchItem_identifier_get(PointerRNA *ptr);
void IndexSwitchItem_identifier_set(PointerRNA *ptr, int value);

/**************** 2D Integer Vector Attribute ****************/

extern StructRNA RNA_Int2Attribute;
extern StructRNA RNA_Attribute;

void Int2Attribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Int2Attribute_data_next(CollectionPropertyIterator *iter);
void Int2Attribute_data_end(CollectionPropertyIterator *iter);
int Int2Attribute_data_length(PointerRNA *ptr);
bool Int2Attribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** 2D Integer Vector Attribute Value ****************/

extern StructRNA RNA_Int2AttributeValue;

PointerRNA Int2AttributeValue_rna_type_get(PointerRNA *ptr);

void Int2AttributeValue_value_get(PointerRNA *ptr, int values[2]);
void Int2AttributeValue_value_set(PointerRNA *ptr, const int values[2]);

/**************** Integer Attribute ****************/

extern StructRNA RNA_IntAttribute;
extern StructRNA RNA_Attribute;

void IntAttribute_data_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void IntAttribute_data_next(CollectionPropertyIterator *iter);
void IntAttribute_data_end(CollectionPropertyIterator *iter);
int IntAttribute_data_length(PointerRNA *ptr);
bool IntAttribute_data_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);

/**************** Integer Attribute Value ****************/

extern StructRNA RNA_IntAttributeValue;

PointerRNA IntAttributeValue_rna_type_get(PointerRNA *ptr);

int IntAttributeValue_value_get(PointerRNA *ptr);
void IntAttributeValue_value_set(PointerRNA *ptr, int value);

/**************** Int Definition ****************/

extern StructRNA RNA_IntProperty;
extern StructRNA RNA_Property;

void IntProperty_array_dimensions_get(PointerRNA *ptr, int values[3]);
void IntProperty_array_dimensions_set(PointerRNA *ptr, const int values[3]);

int IntProperty_array_length_get(PointerRNA *ptr);
void IntProperty_array_length_set(PointerRNA *ptr, int value);

int IntProperty_default_value_get(PointerRNA *ptr);
void IntProperty_default_value_set(PointerRNA *ptr, int value);

void IntProperty_default_array_get(PointerRNA *ptr, int values[]);
void IntProperty_default_array_set(PointerRNA *ptr, const int values[]);
int IntProperty_default_array_get_length(PointerRNA *ptr, int *arraylen);

int IntProperty_hard_max_get(PointerRNA *ptr);
void IntProperty_hard_max_set(PointerRNA *ptr, int value);

int IntProperty_hard_min_get(PointerRNA *ptr);
void IntProperty_hard_min_set(PointerRNA *ptr, int value);

bool IntProperty_is_array_get(PointerRNA *ptr);
void IntProperty_is_array_set(PointerRNA *ptr, bool value);

int IntProperty_soft_max_get(PointerRNA *ptr);
void IntProperty_soft_max_set(PointerRNA *ptr, int value);

int IntProperty_soft_min_get(PointerRNA *ptr);
void IntProperty_soft_min_set(PointerRNA *ptr, int value);

int IntProperty_step_get(PointerRNA *ptr);
void IntProperty_step_set(PointerRNA *ptr, int value);

/**************** bItasc ****************/

extern StructRNA RNA_Itasc;
extern StructRNA RNA_IKParam;

bool Itasc_use_auto_step_get(PointerRNA *ptr);
void Itasc_use_auto_step_set(PointerRNA *ptr, bool value);

float Itasc_damping_max_get(PointerRNA *ptr);
void Itasc_damping_max_set(PointerRNA *ptr, float value);

float Itasc_damping_epsilon_get(PointerRNA *ptr);
void Itasc_damping_epsilon_set(PointerRNA *ptr, float value);

float Itasc_feedback_get(PointerRNA *ptr);
void Itasc_feedback_set(PointerRNA *ptr, float value);

int Itasc_iterations_get(PointerRNA *ptr);
void Itasc_iterations_set(PointerRNA *ptr, int value);

float Itasc_step_max_get(PointerRNA *ptr);
void Itasc_step_max_set(PointerRNA *ptr, float value);

float Itasc_velocity_max_get(PointerRNA *ptr);
void Itasc_velocity_max_set(PointerRNA *ptr, float value);

float Itasc_step_min_get(PointerRNA *ptr);
void Itasc_step_min_set(PointerRNA *ptr, float value);

enum {
	Itasc_mode_ANIMATION = 0,
	Itasc_mode_SIMULATION = 8,
};

int Itasc_mode_get(PointerRNA *ptr);
void Itasc_mode_set(PointerRNA *ptr, int value);

int Itasc_step_count_get(PointerRNA *ptr);
void Itasc_step_count_set(PointerRNA *ptr, int value);

float Itasc_precision_get(PointerRNA *ptr);
void Itasc_precision_set(PointerRNA *ptr, float value);

enum {
	Itasc_reiteration_method_NEVER = 0,
	Itasc_reiteration_method_INITIAL = 2,
	Itasc_reiteration_method_ALWAYS = 6,
};

int Itasc_reiteration_method_get(PointerRNA *ptr);
void Itasc_reiteration_method_set(PointerRNA *ptr, int value);

enum {
	Itasc_solver_SDLS = 0,
	Itasc_solver_DLS = 1,
};

int Itasc_solver_get(PointerRNA *ptr);
void Itasc_solver_set(PointerRNA *ptr, int value);

bool Itasc_translate_root_bones_get(PointerRNA *ptr);
void Itasc_translate_root_bones_set(PointerRNA *ptr, bool value);

/**************** Key ****************/

extern StructRNA RNA_Key;
extern StructRNA RNA_ID;

PointerRNA Key_animation_data_get(PointerRNA *ptr);

float Key_eval_time_get(PointerRNA *ptr);
void Key_eval_time_set(PointerRNA *ptr, float value);

void Key_key_blocks_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void Key_key_blocks_next(CollectionPropertyIterator *iter);
void Key_key_blocks_end(CollectionPropertyIterator *iter);
bool Key_key_blocks_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool Key_key_blocks_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA Key_reference_key_get(PointerRNA *ptr);

bool Key_use_relative_get(PointerRNA *ptr);
void Key_use_relative_set(PointerRNA *ptr, bool value);

PointerRNA Key_user_get(PointerRNA *ptr);

/**************** Key Configuration ****************/

extern StructRNA RNA_KeyConfig;

PointerRNA KeyConfig_rna_type_get(PointerRNA *ptr);

#define KeyConfig_name_MAX 64

void KeyConfig_name_get(PointerRNA *ptr, char *value);
int KeyConfig_name_length(PointerRNA *ptr);
void KeyConfig_name_set(PointerRNA *ptr, const char *value);

void KeyConfig_keymaps_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyConfig_keymaps_next(CollectionPropertyIterator *iter);
void KeyConfig_keymaps_end(CollectionPropertyIterator *iter);
bool KeyConfig_keymaps_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool KeyConfig_keymaps_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool KeyConfig_is_user_defined_get(PointerRNA *ptr);
void KeyConfig_is_user_defined_set(PointerRNA *ptr, bool value);

PointerRNA KeyConfig_preferences_get(PointerRNA *ptr);

/**************** Key-Config Preferences ****************/

extern StructRNA RNA_KeyConfigPreferences;

PointerRNA KeyConfigPreferences_rna_type_get(PointerRNA *ptr);

#define KeyConfigPreferences_bl_idname_MAX 64

void KeyConfigPreferences_bl_idname_get(PointerRNA *ptr, char *value);
int KeyConfigPreferences_bl_idname_length(PointerRNA *ptr);
void KeyConfigPreferences_bl_idname_set(PointerRNA *ptr, const char *value);

struct IDPropertyGroup *KeyConfigPreferences_bl_system_properties_get_func(struct PointerRNA _self, bool do_create);
/**************** KeyConfigs ****************/

extern StructRNA RNA_KeyConfigurations;

PointerRNA KeyConfigurations_rna_type_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_active_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_addon_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_default_value_get(PointerRNA *ptr);

PointerRNA KeyConfigurations_user_get(PointerRNA *ptr);

struct wmKeyConfig *KeyConfigurations_new_func(struct wmWindowManager *_self, const char * name);
void KeyConfigurations_remove_func(struct wmWindowManager *_self, ReportList *reports, struct PointerRNA *keyconfig);
struct PointerRNA KeyConfigurations_find_item_from_operator_func(struct wmWindowManager *_self, bContext *C, const char * idname, int context, struct PointerRNA *properties, int include, int exclude, struct PointerRNA *keymap);
void KeyConfigurations_update_func(struct wmWindowManager *_self, bool keep_properties);
/**************** Key Map ****************/

extern StructRNA RNA_KeyMap;

PointerRNA KeyMap_rna_type_get(PointerRNA *ptr);

#define KeyMap_name_MAX 64

void KeyMap_name_get(PointerRNA *ptr, char *value);
int KeyMap_name_length(PointerRNA *ptr);
void KeyMap_name_set(PointerRNA *ptr, const char *value);

bool KeyMap_show_expanded_children_get(PointerRNA *ptr);
void KeyMap_show_expanded_children_set(PointerRNA *ptr, bool value);

void KeyMap_keymap_items_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyMap_keymap_items_next(CollectionPropertyIterator *iter);
void KeyMap_keymap_items_end(CollectionPropertyIterator *iter);
bool KeyMap_keymap_items_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool KeyMap_keymap_items_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

bool KeyMap_show_expanded_items_get(PointerRNA *ptr);
void KeyMap_show_expanded_items_set(PointerRNA *ptr, bool value);

void KeyMap_modal_event_values_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyMap_modal_event_values_next(CollectionPropertyIterator *iter);
void KeyMap_modal_event_values_end(CollectionPropertyIterator *iter);

bool KeyMap_is_modal_get(PointerRNA *ptr);
void KeyMap_is_modal_set(PointerRNA *ptr, bool value);

#define KeyMap_bl_owner_id_MAX 128

void KeyMap_bl_owner_id_get(PointerRNA *ptr, char *value);
int KeyMap_bl_owner_id_length(PointerRNA *ptr);
void KeyMap_bl_owner_id_set(PointerRNA *ptr, const char *value);

enum {
	KeyMap_region_type_WINDOW = 0,
	KeyMap_region_type_HEADER = 1,
	KeyMap_region_type_CHANNELS = 2,
	KeyMap_region_type_TEMPORARY = 3,
	KeyMap_region_type_UI = 4,
	KeyMap_region_type_TOOLS = 5,
	KeyMap_region_type_TOOL_PROPS = 6,
	KeyMap_region_type_ASSET_SHELF = 14,
	KeyMap_region_type_ASSET_SHELF_HEADER = 15,
	KeyMap_region_type_PREVIEW = 7,
	KeyMap_region_type_HUD = 8,
	KeyMap_region_type_NAVIGATION_BAR = 9,
	KeyMap_region_type_EXECUTE = 10,
	KeyMap_region_type_FOOTER = 11,
	KeyMap_region_type_TOOL_HEADER = 12,
	KeyMap_region_type_XR = 13,
};

int KeyMap_region_type_get(PointerRNA *ptr);
void KeyMap_region_type_set(PointerRNA *ptr, int value);

enum {
	KeyMap_space_type_EMPTY = 0,
	KeyMap_space_type_VIEW_3D = 1,
	KeyMap_space_type_IMAGE_EDITOR = 6,
	KeyMap_space_type_NODE_EDITOR = 16,
	KeyMap_space_type_SEQUENCE_EDITOR = 8,
	KeyMap_space_type_CLIP_EDITOR = 20,
	KeyMap_space_type_DOPESHEET_EDITOR = 12,
	KeyMap_space_type_GRAPH_EDITOR = 2,
	KeyMap_space_type_NLA_EDITOR = 13,
	KeyMap_space_type_TEXT_EDITOR = 9,
	KeyMap_space_type_CONSOLE = 18,
	KeyMap_space_type_INFO = 7,
	KeyMap_space_type_TOPBAR = 21,
	KeyMap_space_type_STATUSBAR = 22,
	KeyMap_space_type_OUTLINER = 3,
	KeyMap_space_type_PROPERTIES = 4,
	KeyMap_space_type_FILE_BROWSER = 5,
	KeyMap_space_type_SPREADSHEET = 23,
	KeyMap_space_type_PREFERENCES = 19,
};

int KeyMap_space_type_get(PointerRNA *ptr);
void KeyMap_space_type_set(PointerRNA *ptr, int value);

bool KeyMap_is_user_modified_get(PointerRNA *ptr);
void KeyMap_is_user_modified_set(PointerRNA *ptr, bool value);

struct wmKeyMap *KeyMap_active_func(struct wmKeyMap *_self, bContext *C);
void KeyMap_restore_to_default_func(struct wmKeyMap *_self, bContext *C);
void KeyMap_restore_item_to_default_func(struct wmKeyMap *_self, bContext *C, struct wmKeyMapItem *item);
/**************** Key Map Item ****************/

extern StructRNA RNA_KeyMapItem;

PointerRNA KeyMapItem_rna_type_get(PointerRNA *ptr);

void KeyMapItem_name_get(PointerRNA *ptr, char *value);
int KeyMapItem_name_length(PointerRNA *ptr);
void KeyMapItem_name_set(PointerRNA *ptr, const char *value);

bool KeyMapItem_active_get(PointerRNA *ptr);
void KeyMapItem_active_set(PointerRNA *ptr, bool value);

int KeyMapItem_alt_get(PointerRNA *ptr);
void KeyMapItem_alt_set(PointerRNA *ptr, int value);

bool KeyMapItem_alt_ui_get(PointerRNA *ptr);
void KeyMapItem_alt_ui_set(PointerRNA *ptr, bool value);

bool KeyMapItem_any_get(PointerRNA *ptr);
void KeyMapItem_any_set(PointerRNA *ptr, bool value);

int KeyMapItem_ctrl_get(PointerRNA *ptr);
void KeyMapItem_ctrl_set(PointerRNA *ptr, int value);

bool KeyMapItem_ctrl_ui_get(PointerRNA *ptr);
void KeyMapItem_ctrl_ui_set(PointerRNA *ptr, bool value);

enum {
	KeyMapItem_direction_ANY = -1,
	KeyMapItem_direction_NORTH = 1,
	KeyMapItem_direction_NORTH_EAST = 2,
	KeyMapItem_direction_EAST = 3,
	KeyMapItem_direction_SOUTH_EAST = 4,
	KeyMapItem_direction_SOUTH = 5,
	KeyMapItem_direction_SOUTH_WEST = 6,
	KeyMapItem_direction_WEST = 7,
	KeyMapItem_direction_NORTH_WEST = 8,
};

int KeyMapItem_direction_get(PointerRNA *ptr);
void KeyMapItem_direction_set(PointerRNA *ptr, int value);

bool KeyMapItem_show_expanded_get(PointerRNA *ptr);
void KeyMapItem_show_expanded_set(PointerRNA *ptr, bool value);

int KeyMapItem_hyper_get(PointerRNA *ptr);
void KeyMapItem_hyper_set(PointerRNA *ptr, int value);

bool KeyMapItem_hyper_ui_get(PointerRNA *ptr);
void KeyMapItem_hyper_ui_set(PointerRNA *ptr, bool value);

int KeyMapItem_id_get(PointerRNA *ptr);
void KeyMapItem_id_set(PointerRNA *ptr, int value);

#define KeyMapItem_idname_MAX 64

void KeyMapItem_idname_get(PointerRNA *ptr, char *value);
int KeyMapItem_idname_length(PointerRNA *ptr);
void KeyMapItem_idname_set(PointerRNA *ptr, const char *value);

enum {
	KeyMapItem_key_modifier_NONE = 0,
	KeyMapItem_key_modifier_LEFTMOUSE = 1,
	KeyMapItem_key_modifier_MIDDLEMOUSE = 2,
	KeyMapItem_key_modifier_RIGHTMOUSE = 3,
	KeyMapItem_key_modifier_BUTTON4MOUSE = 7,
	KeyMapItem_key_modifier_BUTTON5MOUSE = 8,
	KeyMapItem_key_modifier_BUTTON6MOUSE = 18,
	KeyMapItem_key_modifier_BUTTON7MOUSE = 19,
	KeyMapItem_key_modifier_PEN = 26,
	KeyMapItem_key_modifier_ERASER = 27,
	KeyMapItem_key_modifier_MOUSEMOVE = 4,
	KeyMapItem_key_modifier_INBETWEEN_MOUSEMOVE = 17,
	KeyMapItem_key_modifier_TRACKPADPAN = 14,
	KeyMapItem_key_modifier_TRACKPADZOOM = 15,
	KeyMapItem_key_modifier_MOUSEROTATE = 16,
	KeyMapItem_key_modifier_MOUSESMARTZOOM = 23,
	KeyMapItem_key_modifier_WHEELUPMOUSE = 10,
	KeyMapItem_key_modifier_WHEELDOWNMOUSE = 11,
	KeyMapItem_key_modifier_WHEELINMOUSE = 12,
	KeyMapItem_key_modifier_WHEELOUTMOUSE = 13,
	KeyMapItem_key_modifier_WHEELLEFTMOUSE = 20,
	KeyMapItem_key_modifier_WHEELRIGHTMOUSE = 21,
	KeyMapItem_key_modifier_A = 97,
	KeyMapItem_key_modifier_B = 98,
	KeyMapItem_key_modifier_C = 99,
	KeyMapItem_key_modifier_D = 100,
	KeyMapItem_key_modifier_E = 101,
	KeyMapItem_key_modifier_F = 102,
	KeyMapItem_key_modifier_G = 103,
	KeyMapItem_key_modifier_H = 104,
	KeyMapItem_key_modifier_I = 105,
	KeyMapItem_key_modifier_J = 106,
	KeyMapItem_key_modifier_K = 107,
	KeyMapItem_key_modifier_L = 108,
	KeyMapItem_key_modifier_M = 109,
	KeyMapItem_key_modifier_N = 110,
	KeyMapItem_key_modifier_O = 111,
	KeyMapItem_key_modifier_P = 112,
	KeyMapItem_key_modifier_Q = 113,
	KeyMapItem_key_modifier_R = 114,
	KeyMapItem_key_modifier_S = 115,
	KeyMapItem_key_modifier_T = 116,
	KeyMapItem_key_modifier_U = 117,
	KeyMapItem_key_modifier_V = 118,
	KeyMapItem_key_modifier_W = 119,
	KeyMapItem_key_modifier_X = 120,
	KeyMapItem_key_modifier_Y = 121,
	KeyMapItem_key_modifier_Z = 122,
	KeyMapItem_key_modifier_ZERO = 48,
	KeyMapItem_key_modifier_ONE = 49,
	KeyMapItem_key_modifier_TWO = 50,
	KeyMapItem_key_modifier_THREE = 51,
	KeyMapItem_key_modifier_FOUR = 52,
	KeyMapItem_key_modifier_FIVE = 53,
	KeyMapItem_key_modifier_SIX = 54,
	KeyMapItem_key_modifier_SEVEN = 55,
	KeyMapItem_key_modifier_EIGHT = 56,
	KeyMapItem_key_modifier_NINE = 57,
	KeyMapItem_key_modifier_LEFT_CTRL = 212,
	KeyMapItem_key_modifier_LEFT_ALT = 213,
	KeyMapItem_key_modifier_LEFT_SHIFT = 217,
	KeyMapItem_key_modifier_RIGHT_ALT = 214,
	KeyMapItem_key_modifier_RIGHT_CTRL = 215,
	KeyMapItem_key_modifier_RIGHT_SHIFT = 216,
	KeyMapItem_key_modifier_OSKEY = 172,
	KeyMapItem_key_modifier_HYPER = 179,
	KeyMapItem_key_modifier_APP = 178,
	KeyMapItem_key_modifier_GRLESS = 173,
	KeyMapItem_key_modifier_ESC = 218,
	KeyMapItem_key_modifier_TAB = 219,
	KeyMapItem_key_modifier_RET = 220,
	KeyMapItem_key_modifier_SPACE = 221,
	KeyMapItem_key_modifier_LINE_FEED = 222,
	KeyMapItem_key_modifier_BACK_SPACE = 223,
	KeyMapItem_key_modifier_DEL = 224,
	KeyMapItem_key_modifier_SEMI_COLON = 225,
	KeyMapItem_key_modifier_PERIOD = 226,
	KeyMapItem_key_modifier_COMMA = 227,
	KeyMapItem_key_modifier_QUOTE = 228,
	KeyMapItem_key_modifier_ACCENT_GRAVE = 229,
	KeyMapItem_key_modifier_MINUS = 230,
	KeyMapItem_key_modifier_PLUS = 231,
	KeyMapItem_key_modifier_SLASH = 232,
	KeyMapItem_key_modifier_BACK_SLASH = 233,
	KeyMapItem_key_modifier_EQUAL = 234,
	KeyMapItem_key_modifier_LEFT_BRACKET = 235,
	KeyMapItem_key_modifier_RIGHT_BRACKET = 236,
	KeyMapItem_key_modifier_LEFT_ARROW = 137,
	KeyMapItem_key_modifier_DOWN_ARROW = 138,
	KeyMapItem_key_modifier_RIGHT_ARROW = 139,
	KeyMapItem_key_modifier_UP_ARROW = 140,
	KeyMapItem_key_modifier_NUMPAD_2 = 152,
	KeyMapItem_key_modifier_NUMPAD_4 = 154,
	KeyMapItem_key_modifier_NUMPAD_6 = 156,
	KeyMapItem_key_modifier_NUMPAD_8 = 158,
	KeyMapItem_key_modifier_NUMPAD_1 = 151,
	KeyMapItem_key_modifier_NUMPAD_3 = 153,
	KeyMapItem_key_modifier_NUMPAD_5 = 155,
	KeyMapItem_key_modifier_NUMPAD_7 = 157,
	KeyMapItem_key_modifier_NUMPAD_9 = 159,
	KeyMapItem_key_modifier_NUMPAD_PERIOD = 199,
	KeyMapItem_key_modifier_NUMPAD_SLASH = 161,
	KeyMapItem_key_modifier_NUMPAD_ASTERIX = 160,
	KeyMapItem_key_modifier_NUMPAD_0 = 150,
	KeyMapItem_key_modifier_NUMPAD_MINUS = 162,
	KeyMapItem_key_modifier_NUMPAD_ENTER = 163,
	KeyMapItem_key_modifier_NUMPAD_PLUS = 164,
	KeyMapItem_key_modifier_F1 = 300,
	KeyMapItem_key_modifier_F2 = 301,
	KeyMapItem_key_modifier_F3 = 302,
	KeyMapItem_key_modifier_F4 = 303,
	KeyMapItem_key_modifier_F5 = 304,
	KeyMapItem_key_modifier_F6 = 305,
	KeyMapItem_key_modifier_F7 = 306,
	KeyMapItem_key_modifier_F8 = 307,
	KeyMapItem_key_modifier_F9 = 308,
	KeyMapItem_key_modifier_F10 = 309,
	KeyMapItem_key_modifier_F11 = 310,
	KeyMapItem_key_modifier_F12 = 311,
	KeyMapItem_key_modifier_F13 = 312,
	KeyMapItem_key_modifier_F14 = 313,
	KeyMapItem_key_modifier_F15 = 314,
	KeyMapItem_key_modifier_F16 = 315,
	KeyMapItem_key_modifier_F17 = 316,
	KeyMapItem_key_modifier_F18 = 317,
	KeyMapItem_key_modifier_F19 = 318,
	KeyMapItem_key_modifier_F20 = 319,
	KeyMapItem_key_modifier_F21 = 320,
	KeyMapItem_key_modifier_F22 = 321,
	KeyMapItem_key_modifier_F23 = 322,
	KeyMapItem_key_modifier_F24 = 323,
	KeyMapItem_key_modifier_PAUSE = 165,
	KeyMapItem_key_modifier_INSERT = 166,
	KeyMapItem_key_modifier_HOME = 167,
	KeyMapItem_key_modifier_PAGE_UP = 168,
	KeyMapItem_key_modifier_PAGE_DOWN = 169,
	KeyMapItem_key_modifier_END = 170,
	KeyMapItem_key_modifier_MEDIA_PLAY = 174,
	KeyMapItem_key_modifier_MEDIA_STOP = 175,
	KeyMapItem_key_modifier_MEDIA_FIRST = 176,
	KeyMapItem_key_modifier_MEDIA_LAST = 177,
	KeyMapItem_key_modifier_TEXTINPUT = -2,
	KeyMapItem_key_modifier_WINDOW_DEACTIVATE = 260,
	KeyMapItem_key_modifier_TIMER = 272,
	KeyMapItem_key_modifier_TIMER0 = 273,
	KeyMapItem_key_modifier_TIMER1 = 274,
	KeyMapItem_key_modifier_TIMER2 = 275,
	KeyMapItem_key_modifier_TIMER_JOBS = 276,
	KeyMapItem_key_modifier_TIMER_AUTOSAVE = 277,
	KeyMapItem_key_modifier_TIMER_REPORT = 278,
	KeyMapItem_key_modifier_TIMERREGION = 279,
	KeyMapItem_key_modifier_NDOF_MOTION = 400,
	KeyMapItem_key_modifier_NDOF_BUTTON_MENU = 401,
	KeyMapItem_key_modifier_NDOF_BUTTON_FIT = 402,
	KeyMapItem_key_modifier_NDOF_BUTTON_TOP = 403,
	KeyMapItem_key_modifier_NDOF_BUTTON_BOTTOM = 404,
	KeyMapItem_key_modifier_NDOF_BUTTON_LEFT = 405,
	KeyMapItem_key_modifier_NDOF_BUTTON_RIGHT = 406,
	KeyMapItem_key_modifier_NDOF_BUTTON_FRONT = 407,
	KeyMapItem_key_modifier_NDOF_BUTTON_BACK = 408,
	KeyMapItem_key_modifier_NDOF_BUTTON_ISO1 = 409,
	KeyMapItem_key_modifier_NDOF_BUTTON_ISO2 = 410,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROLL_CW = 411,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROLL_CCW = 412,
	KeyMapItem_key_modifier_NDOF_BUTTON_SPIN_CW = 413,
	KeyMapItem_key_modifier_NDOF_BUTTON_SPIN_CCW = 414,
	KeyMapItem_key_modifier_NDOF_BUTTON_TILT_CW = 415,
	KeyMapItem_key_modifier_NDOF_BUTTON_TILT_CCW = 416,
	KeyMapItem_key_modifier_NDOF_BUTTON_ROTATE = 417,
	KeyMapItem_key_modifier_NDOF_BUTTON_PANZOOM = 418,
	KeyMapItem_key_modifier_NDOF_BUTTON_DOMINANT = 419,
	KeyMapItem_key_modifier_NDOF_BUTTON_PLUS = 420,
	KeyMapItem_key_modifier_NDOF_BUTTON_MINUS = 421,
	KeyMapItem_key_modifier_NDOF_BUTTON_V1 = 422,
	KeyMapItem_key_modifier_NDOF_BUTTON_V2 = 423,
	KeyMapItem_key_modifier_NDOF_BUTTON_V3 = 424,
	KeyMapItem_key_modifier_NDOF_BUTTON_SAVE_V1 = 446,
	KeyMapItem_key_modifier_NDOF_BUTTON_SAVE_V2 = 447,
	KeyMapItem_key_modifier_NDOF_BUTTON_SAVE_V3 = 448,
	KeyMapItem_key_modifier_NDOF_BUTTON_1 = 426,
	KeyMapItem_key_modifier_NDOF_BUTTON_2 = 427,
	KeyMapItem_key_modifier_NDOF_BUTTON_3 = 428,
	KeyMapItem_key_modifier_NDOF_BUTTON_4 = 429,
	KeyMapItem_key_modifier_NDOF_BUTTON_5 = 430,
	KeyMapItem_key_modifier_NDOF_BUTTON_6 = 431,
	KeyMapItem_key_modifier_NDOF_BUTTON_7 = 432,
	KeyMapItem_key_modifier_NDOF_BUTTON_8 = 433,
	KeyMapItem_key_modifier_NDOF_BUTTON_9 = 434,
	KeyMapItem_key_modifier_NDOF_BUTTON_10 = 435,
	KeyMapItem_key_modifier_NDOF_BUTTON_11 = 436,
	KeyMapItem_key_modifier_NDOF_BUTTON_12 = 437,
	KeyMapItem_key_modifier_ACTIONZONE_AREA = 20480,
	KeyMapItem_key_modifier_ACTIONZONE_REGION = 20481,
	KeyMapItem_key_modifier_ACTIONZONE_FULLSCREEN = 20497,
	KeyMapItem_key_modifier_XR_ACTION = 20528,
};

int KeyMapItem_key_modifier_get(PointerRNA *ptr);
void KeyMapItem_key_modifier_set(PointerRNA *ptr, int value);

enum {
	KeyMapItem_map_type_KEYBOARD = 0,
	KeyMapItem_map_type_MOUSE = 1,
	KeyMapItem_map_type_NDOF = 5,
	KeyMapItem_map_type_TEXTINPUT = 3,
	KeyMapItem_map_type_TIMER = 4,
};

int KeyMapItem_map_type_get(PointerRNA *ptr);
void KeyMapItem_map_type_set(PointerRNA *ptr, int value);

int KeyMapItem_oskey_get(PointerRNA *ptr);
void KeyMapItem_oskey_set(PointerRNA *ptr, int value);

bool KeyMapItem_oskey_ui_get(PointerRNA *ptr);
void KeyMapItem_oskey_ui_set(PointerRNA *ptr, bool value);

PointerRNA KeyMapItem_properties_get(PointerRNA *ptr);

enum {
	KeyMapItem_propvalue_NONE = 0,
};

int KeyMapItem_propvalue_get(PointerRNA *ptr);
void KeyMapItem_propvalue_set(PointerRNA *ptr, int value);

bool KeyMapItem_repeat_get(PointerRNA *ptr);
void KeyMapItem_repeat_set(PointerRNA *ptr, bool value);

int KeyMapItem_shift_get(PointerRNA *ptr);
void KeyMapItem_shift_set(PointerRNA *ptr, int value);

bool KeyMapItem_shift_ui_get(PointerRNA *ptr);
void KeyMapItem_shift_ui_set(PointerRNA *ptr, bool value);

enum {
	KeyMapItem_type_NONE = 0,
	KeyMapItem_type_LEFTMOUSE = 1,
	KeyMapItem_type_MIDDLEMOUSE = 2,
	KeyMapItem_type_RIGHTMOUSE = 3,
	KeyMapItem_type_BUTTON4MOUSE = 7,
	KeyMapItem_type_BUTTON5MOUSE = 8,
	KeyMapItem_type_BUTTON6MOUSE = 18,
	KeyMapItem_type_BUTTON7MOUSE = 19,
	KeyMapItem_type_PEN = 26,
	KeyMapItem_type_ERASER = 27,
	KeyMapItem_type_MOUSEMOVE = 4,
	KeyMapItem_type_INBETWEEN_MOUSEMOVE = 17,
	KeyMapItem_type_TRACKPADPAN = 14,
	KeyMapItem_type_TRACKPADZOOM = 15,
	KeyMapItem_type_MOUSEROTATE = 16,
	KeyMapItem_type_MOUSESMARTZOOM = 23,
	KeyMapItem_type_WHEELUPMOUSE = 10,
	KeyMapItem_type_WHEELDOWNMOUSE = 11,
	KeyMapItem_type_WHEELINMOUSE = 12,
	KeyMapItem_type_WHEELOUTMOUSE = 13,
	KeyMapItem_type_WHEELLEFTMOUSE = 20,
	KeyMapItem_type_WHEELRIGHTMOUSE = 21,
	KeyMapItem_type_A = 97,
	KeyMapItem_type_B = 98,
	KeyMapItem_type_C = 99,
	KeyMapItem_type_D = 100,
	KeyMapItem_type_E = 101,
	KeyMapItem_type_F = 102,
	KeyMapItem_type_G = 103,
	KeyMapItem_type_H = 104,
	KeyMapItem_type_I = 105,
	KeyMapItem_type_J = 106,
	KeyMapItem_type_K = 107,
	KeyMapItem_type_L = 108,
	KeyMapItem_type_M = 109,
	KeyMapItem_type_N = 110,
	KeyMapItem_type_O = 111,
	KeyMapItem_type_P = 112,
	KeyMapItem_type_Q = 113,
	KeyMapItem_type_R = 114,
	KeyMapItem_type_S = 115,
	KeyMapItem_type_T = 116,
	KeyMapItem_type_U = 117,
	KeyMapItem_type_V = 118,
	KeyMapItem_type_W = 119,
	KeyMapItem_type_X = 120,
	KeyMapItem_type_Y = 121,
	KeyMapItem_type_Z = 122,
	KeyMapItem_type_ZERO = 48,
	KeyMapItem_type_ONE = 49,
	KeyMapItem_type_TWO = 50,
	KeyMapItem_type_THREE = 51,
	KeyMapItem_type_FOUR = 52,
	KeyMapItem_type_FIVE = 53,
	KeyMapItem_type_SIX = 54,
	KeyMapItem_type_SEVEN = 55,
	KeyMapItem_type_EIGHT = 56,
	KeyMapItem_type_NINE = 57,
	KeyMapItem_type_LEFT_CTRL = 212,
	KeyMapItem_type_LEFT_ALT = 213,
	KeyMapItem_type_LEFT_SHIFT = 217,
	KeyMapItem_type_RIGHT_ALT = 214,
	KeyMapItem_type_RIGHT_CTRL = 215,
	KeyMapItem_type_RIGHT_SHIFT = 216,
	KeyMapItem_type_OSKEY = 172,
	KeyMapItem_type_HYPER = 179,
	KeyMapItem_type_APP = 178,
	KeyMapItem_type_GRLESS = 173,
	KeyMapItem_type_ESC = 218,
	KeyMapItem_type_TAB = 219,
	KeyMapItem_type_RET = 220,
	KeyMapItem_type_SPACE = 221,
	KeyMapItem_type_LINE_FEED = 222,
	KeyMapItem_type_BACK_SPACE = 223,
	KeyMapItem_type_DEL = 224,
	KeyMapItem_type_SEMI_COLON = 225,
	KeyMapItem_type_PERIOD = 226,
	KeyMapItem_type_COMMA = 227,
	KeyMapItem_type_QUOTE = 228,
	KeyMapItem_type_ACCENT_GRAVE = 229,
	KeyMapItem_type_MINUS = 230,
	KeyMapItem_type_PLUS = 231,
	KeyMapItem_type_SLASH = 232,
	KeyMapItem_type_BACK_SLASH = 233,
	KeyMapItem_type_EQUAL = 234,
	KeyMapItem_type_LEFT_BRACKET = 235,
	KeyMapItem_type_RIGHT_BRACKET = 236,
	KeyMapItem_type_LEFT_ARROW = 137,
	KeyMapItem_type_DOWN_ARROW = 138,
	KeyMapItem_type_RIGHT_ARROW = 139,
	KeyMapItem_type_UP_ARROW = 140,
	KeyMapItem_type_NUMPAD_2 = 152,
	KeyMapItem_type_NUMPAD_4 = 154,
	KeyMapItem_type_NUMPAD_6 = 156,
	KeyMapItem_type_NUMPAD_8 = 158,
	KeyMapItem_type_NUMPAD_1 = 151,
	KeyMapItem_type_NUMPAD_3 = 153,
	KeyMapItem_type_NUMPAD_5 = 155,
	KeyMapItem_type_NUMPAD_7 = 157,
	KeyMapItem_type_NUMPAD_9 = 159,
	KeyMapItem_type_NUMPAD_PERIOD = 199,
	KeyMapItem_type_NUMPAD_SLASH = 161,
	KeyMapItem_type_NUMPAD_ASTERIX = 160,
	KeyMapItem_type_NUMPAD_0 = 150,
	KeyMapItem_type_NUMPAD_MINUS = 162,
	KeyMapItem_type_NUMPAD_ENTER = 163,
	KeyMapItem_type_NUMPAD_PLUS = 164,
	KeyMapItem_type_F1 = 300,
	KeyMapItem_type_F2 = 301,
	KeyMapItem_type_F3 = 302,
	KeyMapItem_type_F4 = 303,
	KeyMapItem_type_F5 = 304,
	KeyMapItem_type_F6 = 305,
	KeyMapItem_type_F7 = 306,
	KeyMapItem_type_F8 = 307,
	KeyMapItem_type_F9 = 308,
	KeyMapItem_type_F10 = 309,
	KeyMapItem_type_F11 = 310,
	KeyMapItem_type_F12 = 311,
	KeyMapItem_type_F13 = 312,
	KeyMapItem_type_F14 = 313,
	KeyMapItem_type_F15 = 314,
	KeyMapItem_type_F16 = 315,
	KeyMapItem_type_F17 = 316,
	KeyMapItem_type_F18 = 317,
	KeyMapItem_type_F19 = 318,
	KeyMapItem_type_F20 = 319,
	KeyMapItem_type_F21 = 320,
	KeyMapItem_type_F22 = 321,
	KeyMapItem_type_F23 = 322,
	KeyMapItem_type_F24 = 323,
	KeyMapItem_type_PAUSE = 165,
	KeyMapItem_type_INSERT = 166,
	KeyMapItem_type_HOME = 167,
	KeyMapItem_type_PAGE_UP = 168,
	KeyMapItem_type_PAGE_DOWN = 169,
	KeyMapItem_type_END = 170,
	KeyMapItem_type_MEDIA_PLAY = 174,
	KeyMapItem_type_MEDIA_STOP = 175,
	KeyMapItem_type_MEDIA_FIRST = 176,
	KeyMapItem_type_MEDIA_LAST = 177,
	KeyMapItem_type_TEXTINPUT = -2,
	KeyMapItem_type_WINDOW_DEACTIVATE = 260,
	KeyMapItem_type_TIMER = 272,
	KeyMapItem_type_TIMER0 = 273,
	KeyMapItem_type_TIMER1 = 274,
	KeyMapItem_type_TIMER2 = 275,
	KeyMapItem_type_TIMER_JOBS = 276,
	KeyMapItem_type_TIMER_AUTOSAVE = 277,
	KeyMapItem_type_TIMER_REPORT = 278,
	KeyMapItem_type_TIMERREGION = 279,
	KeyMapItem_type_NDOF_MOTION = 400,
	KeyMapItem_type_NDOF_BUTTON_MENU = 401,
	KeyMapItem_type_NDOF_BUTTON_FIT = 402,
	KeyMapItem_type_NDOF_BUTTON_TOP = 403,
	KeyMapItem_type_NDOF_BUTTON_BOTTOM = 404,
	KeyMapItem_type_NDOF_BUTTON_LEFT = 405,
	KeyMapItem_type_NDOF_BUTTON_RIGHT = 406,
	KeyMapItem_type_NDOF_BUTTON_FRONT = 407,
	KeyMapItem_type_NDOF_BUTTON_BACK = 408,
	KeyMapItem_type_NDOF_BUTTON_ISO1 = 409,
	KeyMapItem_type_NDOF_BUTTON_ISO2 = 410,
	KeyMapItem_type_NDOF_BUTTON_ROLL_CW = 411,
	KeyMapItem_type_NDOF_BUTTON_ROLL_CCW = 412,
	KeyMapItem_type_NDOF_BUTTON_SPIN_CW = 413,
	KeyMapItem_type_NDOF_BUTTON_SPIN_CCW = 414,
	KeyMapItem_type_NDOF_BUTTON_TILT_CW = 415,
	KeyMapItem_type_NDOF_BUTTON_TILT_CCW = 416,
	KeyMapItem_type_NDOF_BUTTON_ROTATE = 417,
	KeyMapItem_type_NDOF_BUTTON_PANZOOM = 418,
	KeyMapItem_type_NDOF_BUTTON_DOMINANT = 419,
	KeyMapItem_type_NDOF_BUTTON_PLUS = 420,
	KeyMapItem_type_NDOF_BUTTON_MINUS = 421,
	KeyMapItem_type_NDOF_BUTTON_V1 = 422,
	KeyMapItem_type_NDOF_BUTTON_V2 = 423,
	KeyMapItem_type_NDOF_BUTTON_V3 = 424,
	KeyMapItem_type_NDOF_BUTTON_SAVE_V1 = 446,
	KeyMapItem_type_NDOF_BUTTON_SAVE_V2 = 447,
	KeyMapItem_type_NDOF_BUTTON_SAVE_V3 = 448,
	KeyMapItem_type_NDOF_BUTTON_1 = 426,
	KeyMapItem_type_NDOF_BUTTON_2 = 427,
	KeyMapItem_type_NDOF_BUTTON_3 = 428,
	KeyMapItem_type_NDOF_BUTTON_4 = 429,
	KeyMapItem_type_NDOF_BUTTON_5 = 430,
	KeyMapItem_type_NDOF_BUTTON_6 = 431,
	KeyMapItem_type_NDOF_BUTTON_7 = 432,
	KeyMapItem_type_NDOF_BUTTON_8 = 433,
	KeyMapItem_type_NDOF_BUTTON_9 = 434,
	KeyMapItem_type_NDOF_BUTTON_10 = 435,
	KeyMapItem_type_NDOF_BUTTON_11 = 436,
	KeyMapItem_type_NDOF_BUTTON_12 = 437,
	KeyMapItem_type_ACTIONZONE_AREA = 20480,
	KeyMapItem_type_ACTIONZONE_REGION = 20481,
	KeyMapItem_type_ACTIONZONE_FULLSCREEN = 20497,
	KeyMapItem_type_XR_ACTION = 20528,
};

int KeyMapItem_type_get(PointerRNA *ptr);
void KeyMapItem_type_set(PointerRNA *ptr, int value);

bool KeyMapItem_is_user_defined_get(PointerRNA *ptr);
void KeyMapItem_is_user_defined_set(PointerRNA *ptr, bool value);

bool KeyMapItem_is_user_modified_get(PointerRNA *ptr);
void KeyMapItem_is_user_modified_set(PointerRNA *ptr, bool value);

enum {
	KeyMapItem_value_ANY = -1,
	KeyMapItem_value_PRESS = 1,
	KeyMapItem_value_RELEASE = 2,
	KeyMapItem_value_CLICK = 3,
	KeyMapItem_value_DOUBLE_CLICK = 4,
	KeyMapItem_value_CLICK_DRAG = 5,
	KeyMapItem_value_NOTHING = 0,
};

int KeyMapItem_value_get(PointerRNA *ptr);
void KeyMapItem_value_set(PointerRNA *ptr, int value);

bool KeyMapItem_compare_func(struct wmKeyMapItem *_self, struct wmKeyMapItem *item);
void KeyMapItem_to_string_func(struct wmKeyMapItem *_self, bool compact, char * result);
/**************** KeyMap Items ****************/

extern StructRNA RNA_KeyMapItems;

PointerRNA KeyMapItems_rna_type_get(PointerRNA *ptr);

struct wmKeyMapItem *KeyMapItems_new_func(struct wmKeyMap *_self, ReportList *reports, const char * idname, int type, int value, bool any, int shift, int ctrl, int alt, int oskey, int hyper, int key_modifier, int direction, bool repeat, bool head);
struct wmKeyMapItem *KeyMapItems_new_modal_func(struct wmKeyMap *_self, ReportList *reports, const char * propvalue, int type, int value, bool any, int shift, int ctrl, int alt, int oskey, int hyper, int key_modifier, int direction, bool repeat);
struct wmKeyMapItem *KeyMapItems_new_from_item_func(struct wmKeyMap *_self, ReportList *reports, struct wmKeyMapItem *item, bool head);
void KeyMapItems_remove_func(struct wmKeyMap *_self, ReportList *reports, struct PointerRNA *item);
struct wmKeyMapItem *KeyMapItems_from_id_func(struct wmKeyMap *_self, int id);
struct PointerRNA KeyMapItems_find_from_operator_func(struct ID *_selfid, struct wmKeyMap *_self, const char * idname, struct PointerRNA *properties, int include, int exclude);
struct PointerRNA KeyMapItems_find_match_func(struct ID *_selfid, struct wmKeyMap *_self, ReportList *reports, struct wmKeyMap *keymap, struct wmKeyMapItem *item);
struct PointerRNA KeyMapItems_match_event_func(struct ID *_selfid, struct wmKeyMap *_self, bContext *C, struct wmEvent *event);
/**************** Key Maps ****************/

extern StructRNA RNA_KeyMaps;

PointerRNA KeyMaps_rna_type_get(PointerRNA *ptr);

struct wmKeyMap *KeyMaps_new_func(struct wmKeyConfig *_self, ReportList *reports, const char * name, int space_type, int region_type, bool modal, bool tool);
void KeyMaps_remove_func(struct wmKeyConfig *_self, ReportList *reports, struct PointerRNA *keymap);
void KeyMaps_clear_func(struct wmKeyConfig *_self);
struct wmKeyMap *KeyMaps_find_func(struct wmKeyConfig *_self, const char * name, int space_type, int region_type);
struct wmKeyMap *KeyMaps_find_match_func(struct wmKeyConfig *_self, struct wmKeyMap *keymap);
struct wmKeyMap *KeyMaps_find_modal_func(struct wmKeyConfig *_self, const char * name);
/**************** Keyframe ****************/

extern StructRNA RNA_Keyframe;

PointerRNA Keyframe_rna_type_get(PointerRNA *ptr);

float Keyframe_amplitude_get(PointerRNA *ptr);
void Keyframe_amplitude_set(PointerRNA *ptr, float value);

float Keyframe_back_get(PointerRNA *ptr);
void Keyframe_back_set(PointerRNA *ptr, float value);

void Keyframe_co_get(PointerRNA *ptr, float values[2]);
void Keyframe_co_set(PointerRNA *ptr, const float values[2]);

void Keyframe_co_ui_get(PointerRNA *ptr, float values[2]);
void Keyframe_co_ui_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_easing_AUTO = 0,
	Keyframe_easing_EASE_IN = 1,
	Keyframe_easing_EASE_OUT = 2,
	Keyframe_easing_EASE_IN_OUT = 3,
};

int Keyframe_easing_get(PointerRNA *ptr);
void Keyframe_easing_set(PointerRNA *ptr, int value);

bool Keyframe_select_left_handle_get(PointerRNA *ptr);
void Keyframe_select_left_handle_set(PointerRNA *ptr, bool value);

bool Keyframe_select_right_handle_get(PointerRNA *ptr);
void Keyframe_select_right_handle_set(PointerRNA *ptr, bool value);

enum {
	Keyframe_interpolation_CONSTANT = 0,
	Keyframe_interpolation_LINEAR = 1,
	Keyframe_interpolation_BEZIER = 2,
	Keyframe_interpolation_SINE = 12,
	Keyframe_interpolation_QUAD = 9,
	Keyframe_interpolation_CUBIC = 6,
	Keyframe_interpolation_QUART = 10,
	Keyframe_interpolation_QUINT = 11,
	Keyframe_interpolation_EXPO = 8,
	Keyframe_interpolation_CIRC = 5,
	Keyframe_interpolation_BACK = 3,
	Keyframe_interpolation_BOUNCE = 4,
	Keyframe_interpolation_ELASTIC = 7,
};

int Keyframe_interpolation_get(PointerRNA *ptr);
void Keyframe_interpolation_set(PointerRNA *ptr, int value);

void Keyframe_handle_left_get(PointerRNA *ptr, float values[2]);
void Keyframe_handle_left_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_handle_left_type_FREE = 0,
	Keyframe_handle_left_type_ALIGNED = 3,
	Keyframe_handle_left_type_VECTOR = 2,
	Keyframe_handle_left_type_AUTO = 1,
	Keyframe_handle_left_type_AUTO_CLAMPED = 4,
};

int Keyframe_handle_left_type_get(PointerRNA *ptr);
void Keyframe_handle_left_type_set(PointerRNA *ptr, int value);

float Keyframe_period_get(PointerRNA *ptr);
void Keyframe_period_set(PointerRNA *ptr, float value);

void Keyframe_handle_right_get(PointerRNA *ptr, float values[2]);
void Keyframe_handle_right_set(PointerRNA *ptr, const float values[2]);

enum {
	Keyframe_handle_right_type_FREE = 0,
	Keyframe_handle_right_type_ALIGNED = 3,
	Keyframe_handle_right_type_VECTOR = 2,
	Keyframe_handle_right_type_AUTO = 1,
	Keyframe_handle_right_type_AUTO_CLAMPED = 4,
};

int Keyframe_handle_right_type_get(PointerRNA *ptr);
void Keyframe_handle_right_type_set(PointerRNA *ptr, int value);

bool Keyframe_select_control_point_get(PointerRNA *ptr);
void Keyframe_select_control_point_set(PointerRNA *ptr, bool value);

enum {
	Keyframe_type_KEYFRAME = 0,
	Keyframe_type_BREAKDOWN = 2,
	Keyframe_type_MOVING_HOLD = 4,
	Keyframe_type_EXTREME = 1,
	Keyframe_type_JITTER = 3,
	Keyframe_type_GENERATED = 5,
};

int Keyframe_type_get(PointerRNA *ptr);
void Keyframe_type_set(PointerRNA *ptr, int value);

/**************** Keying Set ****************/

extern StructRNA RNA_KeyingSet;

PointerRNA KeyingSet_rna_type_get(PointerRNA *ptr);

bool KeyingSet_is_path_absolute_get(PointerRNA *ptr);
void KeyingSet_is_path_absolute_set(PointerRNA *ptr, bool value);

#define KeyingSet_bl_description_MAX 1024

void KeyingSet_bl_description_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_description_length(PointerRNA *ptr);
void KeyingSet_bl_description_set(PointerRNA *ptr, const char *value);

#define KeyingSet_bl_idname_MAX 64

void KeyingSet_bl_idname_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_idname_length(PointerRNA *ptr);
void KeyingSet_bl_idname_set(PointerRNA *ptr, const char *value);

bool KeyingSet_use_insertkey_needed_get(PointerRNA *ptr);
void KeyingSet_use_insertkey_needed_set(PointerRNA *ptr, bool value);

bool KeyingSet_use_insertkey_visual_get(PointerRNA *ptr);
void KeyingSet_use_insertkey_visual_set(PointerRNA *ptr, bool value);

bool KeyingSet_use_insertkey_override_visual_get(PointerRNA *ptr);
void KeyingSet_use_insertkey_override_visual_set(PointerRNA *ptr, bool value);

bool KeyingSet_use_insertkey_override_needed_get(PointerRNA *ptr);
void KeyingSet_use_insertkey_override_needed_set(PointerRNA *ptr, bool value);

void KeyingSet_paths_begin(CollectionPropertyIterator *iter, PointerRNA *ptr);
void KeyingSet_paths_next(CollectionPropertyIterator *iter);
void KeyingSet_paths_end(CollectionPropertyIterator *iter);
bool KeyingSet_paths_lookup_int(PointerRNA *ptr, int key, PointerRNA *r_ptr);
bool KeyingSet_paths_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

PointerRNA KeyingSet_type_info_get(PointerRNA *ptr);

#define KeyingSet_bl_label_MAX 64

void KeyingSet_bl_label_get(PointerRNA *ptr, char *value);
int KeyingSet_bl_label_length(PointerRNA *ptr);
void KeyingSet_bl_label_set(PointerRNA *ptr, const char *value);

void KeyingSet_refresh_func(struct KeyingSet *_self, bContext *C, ReportList *reports);
/**************** Keying Set Info ****************/

extern StructRNA RNA_KeyingSetInfo;

PointerRNA KeyingSetInfo_rna_type_get(PointerRNA *ptr);

#define KeyingSetInfo_bl_description_MAX 1024

void KeyingSetInfo_bl_description_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_description_length(PointerRNA *ptr);
void KeyingSetInfo_bl_description_set(PointerRNA *ptr, const char *value);

void KeyingSetInfo_bl_idname_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_idname_length(PointerRNA *ptr);
void KeyingSetInfo_bl_idname_set(PointerRNA *ptr, const char *value);

enum {
	KeyingSetInfo_bl_options_INSERTKEY_NEEDED = 1,
	KeyingSetInfo_bl_options_INSERTKEY_VISUAL = 2,
};

int KeyingSetInfo_bl_options_get(PointerRNA *ptr);
void KeyingSetInfo_bl_options_set(PointerRNA *ptr, int value);

void KeyingSetInfo_bl_label_get(PointerRNA *ptr, char *value);
int KeyingSetInfo_bl_label_length(PointerRNA *ptr);
void KeyingSetInfo_bl_label_set(PointerRNA *ptr, const char *value);

bool KeyingSetInfo_poll_func(struct KeyingSetInfo *_self, struct bContext *context);
void KeyingSetInfo_iterator_func(struct KeyingSetInfo *_self, struct bContext *context, struct KeyingSet *ks);
void KeyingSetInfo_generate_func(struct KeyingSetInfo *_self, struct bContext *context, struct KeyingSet *ks, struct PointerRNA *data);
/**************** Keying Set Path ****************/

extern StructRNA RNA_KeyingSetPath;

PointerRNA KeyingSetPath_rna_type_get(PointerRNA *ptr);

void KeyingSetPath_data_path_get(PointerRNA *ptr, char *value);
int KeyingSetPath_data_path_length(PointerRNA *ptr);
void KeyingSetPath_data_path_set(PointerRNA *ptr, const char *value);

bool KeyingSetPath_use_entire_array_get(PointerRNA *ptr);
void KeyingSetPath_use_entire_array_set(PointerRNA *ptr, bool value);

#define KeyingSetPath_group_MAX 64

void KeyingSetPath_group_get(PointerRNA *ptr, char *value);
int KeyingSetPath_group_length(PointerRNA *ptr);
void KeyingSetPath_group_set(PointerRNA *ptr, const char *value);

enum {
	KeyingSetPath_group_method_NAMED = 0,
	KeyingSetPath_group_method_NONE = 1,
	KeyingSetPath_group_method_KEYINGSET = 2,
};

int KeyingSetPath_group_method_get(PointerRNA *ptr);
void KeyingSetPath_group_method_set(PointerRNA *ptr, int value);

enum {
	KeyingSetPath_id_type_ACTION = 17217,
	KeyingSetPath_id_type_ARMATURE = 21057,
	KeyingSetPath_id_type_BRUSH = 21058,
	KeyingSetPath_id_type_CACHEFILE = 17987,
	KeyingSetPath_id_type_CAMERA = 16707,
	KeyingSetPath_id_type_COLLECTION = 21063,
	KeyingSetPath_id_type_CURVE = 21827,
	KeyingSetPath_id_type_CURVES = 22083,
	KeyingSetPath_id_type_FONT = 18006,
	KeyingSetPath_id_type_GREASEPENCIL = 17479,
	KeyingSetPath_id_type_GREASEPENCIL_V3 = 20551,
	KeyingSetPath_id_type_IMAGE = 19785,
	KeyingSetPath_id_type_KEY = 17739,
	KeyingSetPath_id_type_LATTICE = 21580,
	KeyingSetPath_id_type_LIBRARY = 18764,
	KeyingSetPath_id_type_LIGHT = 16716,
	KeyingSetPath_id_type_LIGHT_PROBE = 20556,
	KeyingSetPath_id_type_LINESTYLE = 21324,
	KeyingSetPath_id_type_MASK = 21325,
	KeyingSetPath_id_type_MATERIAL = 16717,
	KeyingSetPath_id_type_MESH = 17741,
	KeyingSetPath_id_type_META = 16973,
	KeyingSetPath_id_type_MOVIECLIP = 17229,
	KeyingSetPath_id_type_NODETREE = 21582,
	KeyingSetPath_id_type_OBJECT = 16975,
	KeyingSetPath_id_type_PAINTCURVE = 17232,
	KeyingSetPath_id_type_PALETTE = 19536,
	KeyingSetPath_id_type_PARTICLE = 16720,
	KeyingSetPath_id_type_POINTCLOUD = 21584,
	KeyingSetPath_id_type_SCENE = 17235,
	KeyingSetPath_id_type_SCREEN = 21075,
	KeyingSetPath_id_type_SOUND = 20307,
	KeyingSetPath_id_type_SPEAKER = 19283,
	KeyingSetPath_id_type_TEXT = 22612,
	KeyingSetPath_id_type_TEXTURE = 17748,
	KeyingSetPath_id_type_VOLUME = 20310,
	KeyingSetPath_id_type_WINDOWMANAGER = 19799,
	KeyingSetPath_id_type_WORKSPACE = 21335,
	KeyingSetPath_id_type_WORLD = 20311,
};

int KeyingSetPath_id_type_get(PointerRNA *ptr);
void KeyingSetPath_id_type_set(PointerRNA *ptr, int value);

PointerRNA KeyingSetPath_id_get(PointerRNA *ptr);

bool KeyingSetPath_use_insertkey_needed_get(PointerRNA *ptr);
void KeyingSetPath_use_insertkey_needed_set(PointerRNA *ptr, bool value);

bool KeyingSetPath_use_insertkey_visual_get(PointerRNA *ptr);
void KeyingSetPath_use_insertkey_visual_set(PointerRNA *ptr, bool value);

bool KeyingSetPath_use_insertkey_override_visual_get(PointerRNA *ptr);
void KeyingSetPath_use_insertkey_override_visual_set(PointerRNA *ptr, bool value);

bool KeyingSetPath_use_insertkey_override_needed_get(PointerRNA *ptr);
void KeyingSetPath_use_insertkey_override_needed_set(PointerRNA *ptr, bool value);

int KeyingSetPath_array_index_get(PointerRNA *ptr);
void KeyingSetPath_array_index_set(PointerRNA *ptr, int value);

/**************** Keying set paths ****************/

extern StructRNA RNA_KeyingSetPaths;

PointerRNA KeyingSetPaths_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSetPaths_active_get(PointerRNA *ptr);

int KeyingSetPaths_active_index_get(PointerRNA *ptr);
void KeyingSetPaths_active_index_set(PointerRNA *ptr, int value);

struct KS_Path *KeyingSetPaths_add_func(struct KeyingSet *_self, ReportList *reports, struct ID *target_id, const char * data_path, int index, int group_method, const char * group_name);
void KeyingSetPaths_remove_func(struct KeyingSet *_self, ReportList *reports, struct PointerRNA *path);
void KeyingSetPaths_clear_func(struct KeyingSet *_self, ReportList *reports);
/**************** Keying Sets ****************/

extern StructRNA RNA_KeyingSets;

PointerRNA KeyingSets_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSets_active_get(PointerRNA *ptr);

int KeyingSets_active_index_get(PointerRNA *ptr);
void KeyingSets_active_index_set(PointerRNA *ptr, int value);

struct KeyingSet *KeyingSets_new_func(struct Scene *_self, ReportList *reports, const char * idname, const char * name);
/**************** Keying Sets All ****************/

extern StructRNA RNA_KeyingSetsAll;

PointerRNA KeyingSetsAll_rna_type_get(PointerRNA *ptr);

PointerRNA KeyingSetsAll_active_get(PointerRNA *ptr);

int KeyingSetsAll_active_index_get(PointerRNA *ptr);
void KeyingSetsAll_active_index_set(PointerRNA *ptr, int value);

/**************** Kinematic Constraint ****************/

extern StructRNA RNA_KinematicConstraint;
extern StructRNA RNA_Constraint;

enum {
	KinematicConstraint_reference_axis_BONE = 0,
	KinematicConstraint_reference_axis_TARGET = 16384,
};

int KinematicConstraint_reference_axis_get(PointerRNA *ptr);
void KinematicConstraint_reference_axis_set(PointerRNA *ptr, int value);

int KinematicConstraint_chain_count_get(PointerRNA *ptr);
void KinematicConstraint_chain_count_set(PointerRNA *ptr, int value);

float KinematicConstraint_distance_get(PointerRNA *ptr);
void KinematicConstraint_distance_set(PointerRNA *ptr, float value);

enum {
	KinematicConstraint_ik_type_COPY_POSE = 0,
	KinematicConstraint_ik_type_DISTANCE = 1,
};

int KinematicConstraint_ik_type_get(PointerRNA *ptr);
void KinematicConstraint_ik_type_set(PointerRNA *ptr, int value);

int KinematicConstraint_iterations_get(PointerRNA *ptr);
void KinematicConstraint_iterations_set(PointerRNA *ptr, int value);

enum {
	KinematicConstraint_limit_mode_LIMITDIST_INSIDE = 0,
	KinematicConstraint_limit_mode_LIMITDIST_OUTSIDE = 1,
	KinematicConstraint_limit_mode_LIMITDIST_ONSURFACE = 2,
};

int KinematicConstraint_limit_mode_get(PointerRNA *ptr);
void KinematicConstraint_limit_mode_set(PointerRNA *ptr, int value);

bool KinematicConstraint_lock_location_x_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_x_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_lock_rotation_x_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_x_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_lock_location_y_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_y_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_lock_rotation_y_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_y_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_lock_location_z_get(PointerRNA *ptr);
void KinematicConstraint_lock_location_z_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_lock_rotation_z_get(PointerRNA *ptr);
void KinematicConstraint_lock_rotation_z_set(PointerRNA *ptr, bool value);

float KinematicConstraint_orient_weight_get(PointerRNA *ptr);
void KinematicConstraint_orient_weight_set(PointerRNA *ptr, float value);

float KinematicConstraint_pole_angle_get(PointerRNA *ptr);
void KinematicConstraint_pole_angle_set(PointerRNA *ptr, float value);

#define KinematicConstraint_pole_subtarget_MAX 64

void KinematicConstraint_pole_subtarget_get(PointerRNA *ptr, char *value);
int KinematicConstraint_pole_subtarget_length(PointerRNA *ptr);
void KinematicConstraint_pole_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA KinematicConstraint_pole_target_get(PointerRNA *ptr);

bool KinematicConstraint_use_location_get(PointerRNA *ptr);
void KinematicConstraint_use_location_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_use_rotation_get(PointerRNA *ptr);
void KinematicConstraint_use_rotation_set(PointerRNA *ptr, bool value);

bool KinematicConstraint_use_stretch_get(PointerRNA *ptr);
void KinematicConstraint_use_stretch_set(PointerRNA *ptr, bool value);

#define KinematicConstraint_subtarget_MAX 64

void KinematicConstraint_subtarget_get(PointerRNA *ptr, char *value);
int KinematicConstraint_subtarget_length(PointerRNA *ptr);
void KinematicConstraint_subtarget_set(PointerRNA *ptr, const char *value);

PointerRNA KinematicConstraint_target_get(PointerRNA *ptr);

bool KinematicConstraint_use_tail_get(PointerRNA *ptr);
void KinematicConstraint_use_tail_set(PointerRNA *ptr, bool value);

float KinematicConstraint_weight_get(PointerRNA *ptr);
void KinematicConstraint_weight_set(PointerRNA *ptr, float value);

/**************** Laplacian Deform Modifier ****************/

extern StructRNA RNA_LaplacianDeformModifier;
extern StructRNA RNA_Modifier;

#define LaplacianDeformModifier_vertex_group_MAX 64

void LaplacianDeformModifier_vertex_group_get(PointerRNA *ptr, char *value);
int LaplacianDeformModifier_vertex_group_length(PointerRNA *ptr);
void LaplacianDeformModifier_vertex_group_set(PointerRNA *ptr, const char *value);

bool LaplacianDeformModifier_is_bind_get(PointerRNA *ptr);
void LaplacianDeformModifier_is_bind_set(PointerRNA *ptr, bool value);

bool LaplacianDeformModifier_invert_vertex_group_get(PointerRNA *ptr);
void LaplacianDeformModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

int LaplacianDeformModifier_iterations_get(PointerRNA *ptr);
void LaplacianDeformModifier_iterations_set(PointerRNA *ptr, int value);

/**************** Laplacian Smooth Modifier ****************/

extern StructRNA RNA_LaplacianSmoothModifier;
extern StructRNA RNA_Modifier;

bool LaplacianSmoothModifier_invert_vertex_group_get(PointerRNA *ptr);
void LaplacianSmoothModifier_invert_vertex_group_set(PointerRNA *ptr, bool value);

float LaplacianSmoothModifier_lambda_border_get(PointerRNA *ptr);
void LaplacianSmoothModifier_lambda_border_set(PointerRNA *ptr, float value);

float LaplacianSmoothModifier_lambda_factor_get(PointerRNA *ptr);
void LaplacianSmoothModifier_lambda_factor_set(PointerRNA *ptr, float value);

bool LaplacianSmoothModifier_use_normalized_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_normalized_set(PointerRNA *ptr, bool value);

bool LaplacianSmoothModifier_use_volume_preserve_get(PointerRNA *ptr);
void LaplacianSmoothModifier_use_volume_preserve_set(PointerRNA *ptr, bool value);

int LaplacianSmoothModifier_iterations_get(PointerRNA *ptr);
void LaplacianSmoothModifier_iterations_set(PointerRNA *ptr, int value);

#defin