/* SPDX-FileCopyrightText: 2008 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

/** \file
 * \ingroup edmeta
 */

#include "RNA_access.hh"

#include "WM_api.hh"
#include "WM_types.hh"

#include "ED_mball.hh"
#include "ED_screen.hh"

#include "mball_intern.hh"

void ED_operatortypes_metaball()
{
  WM_operatortype_append(MBALL_OT_delete_metaelems);
  WM_operatortype_append(MBALL_OT_duplicate_metaelems);

  WM_operatortype_append(MBALL_OT_hide_metaelems);
  WM_operatortype_append(MBALL_OT_reveal_metaelems);

  WM_operatortype_append(MBALL_OT_select_all);
  WM_operatortype_append(MBALL_OT_select_similar);
  WM_operatortype_append(MBALL_OT_select_random_metaelems);
}

void ED_operatormacros_metaball()
{
  wmOperatorType *ot;
  wmOperatorTypeMacro *otmacro;

  ot = WM_operatortype_append_macro("MBALL_OT_duplicate_move",
                                    "Duplicate",
                                    "Make copies of the selected metaball elements and move them",
                                    OPTYPE_UNDO | OPTYPE_REGISTER);
  WM_operatortype_macro_define(ot, "MBALL_OT_duplicate_metaelems");
  otmacro = WM_operatortype_macro_define(ot, "TRANSFORM_OT_translate");
  RNA_boolean_set(otmacro->ptr, "use_proportional_edit", false);
}

void ED_keymap_metaball(wmKeyConfig *keyconf)
{
  wmKeyMap *keymap = WM_keymap_ensure(keyconf, "Metaball", SPACE_EMPTY, RGN_TYPE_WINDOW);
  keymap->poll = ED_operator_editmball;
}
