const char *mesh_fs =
  "#version 400\n"
  "precision highp float;\n"
  "\n"
  "in vec3 fnormal;\n"
  "in vec4 outColor;\n"
  "\n"
  "out vec4 colorOut;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  vec3 N = normalize(fnormal);\n"
  "  vec3 L = normalize(vec3(0, 1, 1));\n"
  "  vec3 E = vec3(0, 0, 1);\n"
  "  vec3 H = normalize(L + E);\n"
  "  float df = max(0.0, dot(N, -L));\n"
  "  float sf = max(0.0, dot(N, -H));\n"
  "  sf = pow(sf, 40.0);\n"
  "  vec4 ambient = outColor / 2.2;\n"
  "  vec4 diffuse = outColor * 1.1;\n"
  "  vec4 specular = outColor * 5.0;\n"
  "  colorOut = ambient + df * diffuse + sf * specular;\n"
  "  colorOut.a = outColor.a;\n"
  "}\n"
  "\n";
