// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/OffsetProperty.h>

// clang-format on

class QuickStyle;

/*!
 * \qmltype OffsetPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of OffsetProperty to QML.
 */
class OffsetPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit OffsetPropertyGroup(QuickStyle *style);

    void update(Union::Properties::OffsetProperty *newState);
    Q_SIGNAL void updated();

    void refreshColors();

    /*!
     * \qmlproperty qreal OffsetPropertyGroup::horizontal
     *
     * Exposes OffsetProperty::horizontal to QML.
     */
    Q_PROPERTY(QJSValue horizontal READ horizontal NOTIFY horizontalChanged)
    QJSValue horizontal() const;
    Q_SIGNAL void horizontalChanged();

    /*!
     * \qmlproperty qreal OffsetPropertyGroup::vertical
     *
     * Exposes OffsetProperty::vertical to QML.
     */
    Q_PROPERTY(QJSValue vertical READ vertical NOTIFY verticalChanged)
    QJSValue vertical() const;
    Q_SIGNAL void verticalChanged();

private:
    QuickStyle *m_style = nullptr;

    Union::Properties::OffsetProperty *m_state = nullptr;
};