/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;

public class TransactionIndex
implements Closeable {
    private final long startOffset;
    private volatile File file;
    private Optional<FileChannel> maybeChannel = Optional.empty();
    private OptionalLong lastOffset = OptionalLong.empty();

    public TransactionIndex(long startOffset, File file) throws IOException {
        this.startOffset = startOffset;
        this.file = file;
        if (file.exists()) {
            this.openChannel();
        }
    }

    public File file() {
        return this.file;
    }

    public void updateParentDir(File parentDir) {
        this.file = new File(parentDir, this.file.getName());
    }

    public void append(AbortedTxn abortedTxn) throws IOException {
        this.lastOffset.ifPresent(offset -> {
            if (offset >= abortedTxn.lastOffset()) {
                throw new IllegalArgumentException("The last offset of appended transactions must increase sequentially, but " + abortedTxn.lastOffset() + " is not greater than current last offset " + offset + " of index " + this.file.getAbsolutePath());
            }
        });
        this.lastOffset = OptionalLong.of(abortedTxn.lastOffset());
        Utils.writeFully((FileChannel)this.channel(), (ByteBuffer)abortedTxn.buffer.duplicate());
    }

    public void flush() throws IOException {
        FileChannel channel = this.channelOrNull();
        if (channel != null) {
            channel.force(true);
        }
    }

    public void reset() throws IOException {
        FileChannel channel = this.channelOrNull();
        if (channel != null) {
            channel.truncate(0L);
        }
        this.lastOffset = OptionalLong.empty();
    }

    @Override
    public void close() throws IOException {
        FileChannel channel = this.channelOrNull();
        if (channel != null && channel.isOpen()) {
            channel.close();
        }
        this.maybeChannel = Optional.empty();
    }

    public boolean deleteIfExists() throws IOException {
        this.close();
        return Files.deleteIfExists(this.file.toPath());
    }

    public void renameTo(File f) throws IOException {
        try {
            if (this.file.exists()) {
                Utils.atomicMoveWithFallback((Path)this.file.toPath(), (Path)f.toPath(), (boolean)false);
            }
        }
        finally {
            this.file = f;
        }
    }

    public void truncateTo(long offset) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(34);
        OptionalLong newLastOffset = OptionalLong.empty();
        for (AbortedTxnWithPosition txnWithPosition : this.iterable(() -> buffer)) {
            AbortedTxn abortedTxn = txnWithPosition.txn;
            long position = txnWithPosition.position;
            if (abortedTxn.lastOffset() >= offset) {
                this.channel().truncate(position);
                this.lastOffset = newLastOffset;
                return;
            }
            newLastOffset = OptionalLong.of(abortedTxn.lastOffset());
        }
    }

    public List<AbortedTxn> allAbortedTxns() {
        ArrayList<AbortedTxn> result = new ArrayList<AbortedTxn>();
        for (AbortedTxnWithPosition txnWithPosition : this.iterable()) {
            result.add(txnWithPosition.txn);
        }
        return result;
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        ArrayList<AbortedTxn> abortedTransactions = new ArrayList<AbortedTxn>();
        for (AbortedTxnWithPosition txnWithPosition : this.iterable()) {
            AbortedTxn abortedTxn = txnWithPosition.txn;
            if (abortedTxn.lastOffset() >= fetchOffset && abortedTxn.firstOffset() < upperBoundOffset) {
                abortedTransactions.add(abortedTxn);
            }
            if (abortedTxn.lastStableOffset() < upperBoundOffset) continue;
            return new TxnIndexSearchResult(abortedTransactions, true);
        }
        return new TxnIndexSearchResult(abortedTransactions, false);
    }

    public void sanityCheck() {
        ByteBuffer buffer = ByteBuffer.allocate(34);
        for (AbortedTxnWithPosition txnWithPosition : this.iterable(() -> buffer)) {
            AbortedTxn abortedTxn = txnWithPosition.txn;
            if (abortedTxn.lastOffset() >= this.startOffset) continue;
            throw new CorruptIndexException("Last offset of aborted transaction " + String.valueOf(abortedTxn) + " in index " + this.file.getAbsolutePath() + " is less than start offset " + this.startOffset);
        }
    }

    public boolean isEmpty() {
        return !this.iterable().iterator().hasNext();
    }

    private FileChannel openChannel() throws IOException {
        FileChannel channel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.maybeChannel = Optional.of(channel);
        channel.position(channel.size());
        return channel;
    }

    private FileChannel channel() throws IOException {
        FileChannel channel = this.channelOrNull();
        if (channel == null) {
            return this.openChannel();
        }
        return channel;
    }

    private FileChannel channelOrNull() {
        return this.maybeChannel.orElse(null);
    }

    private Iterable<AbortedTxnWithPosition> iterable() {
        return this.iterable(() -> ByteBuffer.allocate(34));
    }

    private Iterable<AbortedTxnWithPosition> iterable(final Supplier<ByteBuffer> allocate) {
        final FileChannel channel = this.channelOrNull();
        if (channel == null) {
            return List.of();
        }
        final PrimitiveRef.IntRef position = PrimitiveRef.ofInt((int)0);
        return () -> new Iterator<AbortedTxnWithPosition>(){

            @Override
            public boolean hasNext() {
                try {
                    return channel.position() - (long)position.value >= 34L;
                }
                catch (IOException e) {
                    throw new KafkaException("Failed read position from the transaction index " + TransactionIndex.this.file.getAbsolutePath(), (Throwable)e);
                }
            }

            @Override
            public AbortedTxnWithPosition next() {
                try {
                    ByteBuffer buffer = (ByteBuffer)allocate.get();
                    Utils.readFully((FileChannel)channel, (ByteBuffer)buffer, (long)position.value);
                    buffer.flip();
                    AbortedTxn abortedTxn = new AbortedTxn(buffer);
                    if (abortedTxn.version() > 0) {
                        throw new KafkaException("Unexpected aborted transaction version " + abortedTxn.version() + " in transaction index " + TransactionIndex.this.file.getAbsolutePath() + ", current version is 0");
                    }
                    AbortedTxnWithPosition nextEntry = new AbortedTxnWithPosition(abortedTxn, position.value);
                    position.value += 34;
                    return nextEntry;
                }
                catch (IOException e) {
                    throw new KafkaException("Failed to read from the transaction index " + TransactionIndex.this.file.getAbsolutePath(), (Throwable)e);
                }
            }
        };
    }

    private record AbortedTxnWithPosition(AbortedTxn txn, int position) {
    }
}

