/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsCommand.class);

    public static void main(String ... args) {
        Exit.exit((int)GroupsCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            GroupsCommand.execute(args);
            return 0;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        GroupsCommandOptions opts = new GroupsCommandOptions(args);
        Properties config = opts.commandConfig();
        config.put("bootstrap.servers", opts.bootstrapServer());
        int exitCode = 0;
        try (GroupsService service = new GroupsService(config);){
            if (opts.hasListOption()) {
                service.listGroups(opts);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            GroupsCommand.printException(Objects.requireNonNullElse(cause, e));
            exitCode = 1;
        }
        catch (Throwable t) {
            GroupsCommand.printException(t);
            exitCode = 1;
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    private static void printException(Throwable e) {
        System.out.println("Error while executing groups command : " + e.getMessage());
        LOG.error(Utils.stackTrace((Throwable)e));
    }

    public static final class GroupsCommandOptions
    extends CommandDefaultOptions {
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt;
        private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
        private final OptionSpecBuilder listOpt;
        private final ArgumentAcceptingOptionSpec<String> groupTypeOpt;
        private final ArgumentAcceptingOptionSpec<String> protocolOpt;
        private final OptionSpecBuilder consumerOpt;
        private final OptionSpecBuilder shareOpt;
        private final OptionSpecBuilder streamsOpt;

        public GroupsCommandOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The Kafka server to connect to.").withRequiredArg().describedAs("server to connect to").required().ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("command config property file").ofType(String.class);
            this.listOpt = this.parser.accepts("list", "List the groups.");
            this.groupTypeOpt = this.parser.accepts("group-type", "Filter the groups based on group type. Valid types are: 'classic', 'consumer', 'share' and 'streams'.").withRequiredArg().describedAs("type").ofType(String.class);
            this.protocolOpt = this.parser.accepts("protocol", "Filter the groups based on protocol type.").withRequiredArg().describedAs("protocol").ofType(String.class);
            this.consumerOpt = this.parser.accepts("consumer", "Filter the groups to show all kinds of consumer groups, including classic and simple consumer groups. This matches group type 'consumer', and group type 'classic' where the protocol type is 'consumer' or empty.");
            this.shareOpt = this.parser.accepts("share", "Filter the groups to show share groups.");
            this.streamsOpt = this.parser.accepts("streams", "Filter the groups to show streams groups.");
            try {
                this.options = this.parser.parse(args);
            }
            catch (OptionException oe) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)oe.getMessage());
            }
            this.checkArgs();
        }

        public boolean has(OptionSpec<?> builder) {
            return this.options.has(builder);
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option) {
            return this.valueAsOption(option, Optional.empty());
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option, Optional<A> defaultValue) {
            if (this.has(option)) {
                return Optional.of(this.options.valueOf(option));
            }
            return defaultValue;
        }

        public String bootstrapServer() {
            return (String)this.options.valueOf(this.bootstrapServerOpt);
        }

        public Properties commandConfig() throws IOException {
            if (this.has((OptionSpec<?>)this.commandConfigOpt)) {
                return Utils.loadProps((String)((String)this.options.valueOf(this.commandConfigOpt)));
            }
            return new Properties();
        }

        public Optional<GroupType> groupType() {
            return this.valueAsOption((OptionSpec)this.groupTypeOpt).map(GroupType::parse).filter(gt -> gt != GroupType.UNKNOWN);
        }

        public Optional<String> protocol() {
            return this.valueAsOption((OptionSpec)this.protocolOpt);
        }

        public boolean hasConsumerOption() {
            return this.has((OptionSpec<?>)this.consumerOpt);
        }

        public boolean hasListOption() {
            return this.has((OptionSpec<?>)this.listOpt);
        }

        public boolean hasShareOption() {
            return this.has((OptionSpec<?>)this.shareOpt);
        }

        public boolean hasStreamsOption() {
            return this.has((OptionSpec<?>)this.streamsOpt);
        }

        public void checkArgs() {
            if (this.args.length == 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"This tool helps to list groups of all types.");
            }
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list groups of all types.");
            long actions = Stream.of(this.listOpt).filter(arg_0 -> ((OptionSet)this.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Command must include exactly one action: --list.");
            }
            if (this.has((OptionSpec<?>)this.groupTypeOpt) && this.groupType().isEmpty()) {
                throw new IllegalArgumentException("--group-type must be a valid group type.");
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.consumerOpt, (OptionSpec[])new OptionSpec[]{this.groupTypeOpt, this.protocolOpt, this.shareOpt, this.streamsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.shareOpt, (OptionSpec[])new OptionSpec[]{this.consumerOpt, this.groupTypeOpt, this.protocolOpt, this.streamsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.streamsOpt, (OptionSpec[])new OptionSpec[]{this.consumerOpt, this.groupTypeOpt, this.protocolOpt, this.shareOpt});
        }
    }

    public static class GroupsService
    implements AutoCloseable {
        private final Admin adminClient;

        public GroupsService(Properties config) {
            this.adminClient = Admin.create((Properties)config);
        }

        GroupsService(Admin adminClient) {
            this.adminClient = adminClient;
        }

        public void listGroups(GroupsCommandOptions opts) throws Exception {
            Collection resources = (Collection)this.adminClient.listGroups().all().get(30L, TimeUnit.SECONDS);
            this.printGroupDetails(resources, opts.groupType(), opts.protocol(), opts.hasConsumerOption(), opts.hasShareOption(), opts.hasStreamsOption());
        }

        private void printGroupDetails(Collection<GroupListing> groups, Optional<GroupType> groupTypeFilter, Optional<String> protocolFilter, boolean consumerGroupFilter, boolean shareGroupFilter, boolean streamsGroupFilter) {
            ArrayList lineItems = new ArrayList();
            int maxLen = 20;
            for (GroupListing group : groups) {
                if (!this.combinedFilter(group, groupTypeFilter, protocolFilter, consumerGroupFilter, shareGroupFilter, streamsGroupFilter)) continue;
                ArrayList<String> lineItem = new ArrayList<String>();
                lineItem.add(group.groupId());
                lineItem.add(group.type().map(GroupType::toString).orElse(""));
                lineItem.add(group.protocol());
                for (String item : lineItem) {
                    if (item == null) continue;
                    maxLen = Math.max(maxLen, item.length());
                }
                lineItems.add(lineItem);
            }
            String fmt = "%" + -maxLen + "s";
            String header = fmt + " " + fmt + " " + fmt;
            System.out.printf(header, "GROUP", "TYPE", "PROTOCOL");
            System.out.println();
            for (List list : lineItems) {
                for (String atom : list) {
                    System.out.printf(fmt + " ", atom);
                }
                System.out.println();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean combinedFilter(GroupListing group, Optional<GroupType> groupTypeFilter, Optional<String> protocolFilter, boolean consumerGroupFilter, boolean shareGroupFilter, boolean streamsGroupFilter) {
            boolean pass = true;
            Optional groupType = group.type();
            String protocol = group.protocol();
            if (groupTypeFilter.isPresent()) {
                if (!groupType.filter(gt -> gt == groupTypeFilter.get()).isPresent()) return false;
                if (protocolFilter.map(protocol::equals).orElse(true) == false) return false;
                return true;
            }
            if (protocolFilter.isPresent()) {
                return protocol.equals(protocolFilter.get());
            }
            if (consumerGroupFilter) {
                if (protocol.equals("consumer")) return true;
                if (protocol.isEmpty()) return true;
                if (!groupType.filter(gt -> gt == GroupType.CONSUMER).isPresent()) return false;
                return true;
            }
            if (shareGroupFilter) {
                return groupType.filter(gt -> gt == GroupType.SHARE).isPresent();
            }
            if (!streamsGroupFilter) return pass;
            return groupType.filter(gt -> gt == GroupType.STREAMS).isPresent();
        }

        @Override
        public void close() throws Exception {
            this.adminClient.close();
        }
    }
}

