/* composer-embed.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from composer-embed.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#define COMPOSER_EMBED_MIN_EDITOR_HEIGHT 200
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPOSER_EMBED_0_PROPERTY,
	COMPOSER_EMBED_REFERRED_PROPERTY,
	COMPOSER_EMBED_NUM_PROPERTIES
};
static GParamSpec* composer_embed_properties[COMPOSER_EMBED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	COMPOSER_EMBED_VANISHED_SIGNAL,
	COMPOSER_EMBED_NUM_SIGNALS
};
static guint composer_embed_signals[COMPOSER_EMBED_NUM_SIGNALS] = {0};

struct _ComposerEmbedPrivate {
	GearyEmail* _referred;
	ComposerWidget* _composer;
	GtkScrolledWindow* outer_scroller;
};

static gint ComposerEmbed_private_offset;
static gpointer composer_embed_parent_class = NULL;
static ComposerContainerIface * composer_embed_composer_container_parent_iface = NULL;

static void composer_embed_set_referred (ComposerEmbed* self,
                                  GearyEmail* value);
VALA_EXTERN void composer_container_set_composer (ComposerContainer* self,
                                      ComposerWidget* value);
VALA_EXTERN ComposerWidget* composer_container_get_composer (ComposerContainer* self);
VALA_EXTERN void composer_widget_embed_header (ComposerWidget* self);
VALA_EXTERN gboolean composer_widget_get_has_multiple_from_addresses (ComposerWidget* self);
VALA_EXTERN void composer_widget_set_mode (ComposerWidget* self,
                               ComposerWidgetPresentationMode new_mode);
static void composer_embed_on_realize (ComposerEmbed* self);
static void _composer_embed_on_realize_gtk_widget_realize (GtkWidget* _sender,
                                                    gpointer self);
static void composer_embed_real_close (ComposerContainer* base);
static void composer_embed_disable_scroll_reroute (ComposerEmbed* self,
                                            GtkWidget* widget);
VALA_EXTERN void composer_widget_free_header (ComposerWidget* self);
static void composer_embed_reroute_scroll_handling (ComposerEmbed* self,
                                             GtkWidget* widget);
static gboolean composer_embed_on_inner_scroll_event (ComposerEmbed* self,
                                               GdkEventScroll* event);
static gboolean _composer_embed_on_inner_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                        GdkEventScroll* event,
                                                                        gpointer self);
static void composer_embed_finalize (GObject * obj);
static GType composer_embed_get_type_once (void);
static void _vala_composer_embed_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_composer_embed_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
composer_embed_get_instance_private (ComposerEmbed* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerEmbed_private_offset);
}

static GtkApplicationWindow*
composer_embed_real_get_top_window (ComposerContainer* base)
{
	GtkApplicationWindow* result;
	ComposerEmbed* self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_EMBED, ComposerEmbed);
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp0_) : NULL;
	return result;
}

GearyEmail*
composer_embed_get_referred (ComposerEmbed* self)
{
	GearyEmail* result;
	GearyEmail* _tmp0_;
	g_return_val_if_fail (COMPOSER_IS_EMBED (self), NULL);
	_tmp0_ = self->priv->_referred;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
composer_embed_set_referred (ComposerEmbed* self,
                             GearyEmail* value)
{
	GearyEmail* old_value;
	g_return_if_fail (COMPOSER_IS_EMBED (self));
	old_value = composer_embed_get_referred (self);
	if (old_value != value) {
		GearyEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_referred);
		self->priv->_referred = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, composer_embed_properties[COMPOSER_EMBED_REFERRED_PROPERTY]);
	}
}

static ComposerWidget*
composer_embed_real_get_composer (ComposerContainer* base)
{
	ComposerWidget* result;
	ComposerEmbed* self;
	ComposerWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_EMBED, ComposerEmbed);
	_tmp0_ = self->priv->_composer;
	result = _tmp0_;
	return result;
}

static void
composer_embed_real_set_composer (ComposerContainer* base,
                                  ComposerWidget* value)
{
	ComposerEmbed* self;
	ComposerWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_EMBED, ComposerEmbed);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_composer);
	self->priv->_composer = _tmp0_;
}

static void
_composer_embed_on_realize_gtk_widget_realize (GtkWidget* _sender,
                                               gpointer self)
{
	composer_embed_on_realize ((ComposerEmbed*) self);
}

ComposerEmbed*
composer_embed_construct (GType object_type,
                          GearyEmail* referred,
                          ComposerWidget* composer,
                          GtkScrolledWindow* outer_scroller)
{
	ComposerEmbed * self = NULL;
	ComposerWidget* _tmp0_;
	ComposerWidget* _tmp1_;
	ComposerWidgetPresentationMode mode = 0;
	gboolean _tmp2_ = FALSE;
	ComposerWidgetContextType _tmp3_;
	ComposerWidgetContextType _tmp4_;
	GtkScrolledWindow* _tmp7_;
	GtkStyleContext* _tmp8_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (referred, GEARY_TYPE_EMAIL), NULL);
	g_return_val_if_fail (COMPOSER_IS_WIDGET (composer), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (outer_scroller, gtk_scrolled_window_get_type ()), NULL);
	self = (ComposerEmbed*) g_object_new (object_type, NULL);
	composer_embed_set_referred (self, referred);
	composer_container_set_composer (G_TYPE_CHECK_INSTANCE_CAST (self, COMPOSER_TYPE_CONTAINER, ComposerContainer), composer);
	_tmp0_ = composer_container_get_composer (G_TYPE_CHECK_INSTANCE_CAST (self, COMPOSER_TYPE_CONTAINER, ComposerContainer));
	_tmp1_ = _tmp0_;
	composer_widget_embed_header (_tmp1_);
	mode = COMPOSER_WIDGET_PRESENTATION_MODE_INLINE_COMPACT;
	_tmp3_ = composer_widget_get_context_type (composer);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == COMPOSER_WIDGET_CONTEXT_TYPE_FORWARD) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = composer_widget_get_has_multiple_from_addresses (composer);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		mode = COMPOSER_WIDGET_PRESENTATION_MODE_INLINE;
	}
	composer_widget_set_mode (composer, mode);
	_tmp7_ = _g_object_ref0 (outer_scroller);
	_g_object_unref0 (self->priv->outer_scroller);
	self->priv->outer_scroller = _tmp7_;
	_tmp8_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp8_, "geary-composer-embed");
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_widget_set_vexpand_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (composer, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) _composer_embed_on_realize_gtk_widget_realize, self, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	return self;
}

ComposerEmbed*
composer_embed_new (GearyEmail* referred,
                    ComposerWidget* composer,
                    GtkScrolledWindow* outer_scroller)
{
	return composer_embed_construct (COMPOSER_TYPE_EMBED, referred, composer, outer_scroller);
}

/** {@inheritDoc} */
static void
composer_embed_real_close (ComposerContainer* base)
{
	ComposerEmbed * self;
	ComposerWidget* _tmp0_;
	ComposerWidget* _tmp1_;
	ComposerWidget* _tmp2_;
	ComposerWidget* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPOSER_TYPE_EMBED, ComposerEmbed);
	composer_embed_disable_scroll_reroute (self, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_signal_emit (self, composer_embed_signals[COMPOSER_EMBED_VANISHED_SIGNAL], 0);
	_tmp0_ = composer_container_get_composer (G_TYPE_CHECK_INSTANCE_CAST (self, COMPOSER_TYPE_CONTAINER, ComposerContainer));
	_tmp1_ = _tmp0_;
	composer_widget_free_header (_tmp1_);
	_tmp2_ = composer_container_get_composer (G_TYPE_CHECK_INSTANCE_CAST (self, COMPOSER_TYPE_CONTAINER, ComposerContainer));
	_tmp3_ = _tmp2_;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
composer_embed_on_realize (ComposerEmbed* self)
{
	g_return_if_fail (COMPOSER_IS_EMBED (self));
	composer_embed_reroute_scroll_handling (self, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static gboolean
_composer_embed_on_inner_scroll_event_gtk_widget_scroll_event (GtkWidget* _sender,
                                                               GdkEventScroll* event,
                                                               gpointer self)
{
	gboolean result;
	result = composer_embed_on_inner_scroll_event ((ComposerEmbed*) self, event);
	return result;
}

static void
composer_embed_reroute_scroll_handling (ComposerEmbed* self,
                                        GtkWidget* widget)
{
	GtkContainer* container = NULL;
	GtkContainer* _tmp0_;
	GtkContainer* _tmp1_;
	g_return_if_fail (COMPOSER_IS_EMBED (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	gtk_widget_add_events (widget, (gint) (GDK_SCROLL_MASK | GDK_SMOOTH_SCROLL_MASK));
	g_signal_connect_object (widget, "scroll-event", (GCallback) _composer_embed_on_inner_scroll_event_gtk_widget_scroll_event, self, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_container_get_type ()) ? ((GtkContainer*) widget) : NULL);
	container = _tmp0_;
	_tmp1_ = container;
	if (_tmp1_ != NULL) {
		GtkContainer* _tmp2_;
		GList* _tmp3_;
		_tmp2_ = container;
		_tmp3_ = gtk_container_get_children (_tmp2_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp3_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp4_;
				GtkWidget* child = NULL;
				_tmp4_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp4_;
				{
					GtkWidget* _tmp5_;
					_tmp5_ = child;
					composer_embed_reroute_scroll_handling (self, _tmp5_);
					_g_object_unref0 (child);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
	_g_object_unref0 (container);
}

static void
composer_embed_disable_scroll_reroute (ComposerEmbed* self,
                                       GtkWidget* widget)
{
	guint _tmp0_;
	GtkContainer* container = NULL;
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	g_return_if_fail (COMPOSER_IS_EMBED (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	g_signal_parse_name ("scroll-event", gtk_widget_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _composer_embed_on_inner_scroll_event_gtk_widget_scroll_event, self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_container_get_type ()) ? ((GtkContainer*) widget) : NULL);
	container = _tmp1_;
	_tmp2_ = container;
	if (_tmp2_ != NULL) {
		GtkContainer* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = container;
		_tmp4_ = gtk_container_get_children (_tmp3_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp4_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp5_;
				GtkWidget* child = NULL;
				_tmp5_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp5_;
				{
					GtkWidget* _tmp6_;
					_tmp6_ = child;
					composer_embed_disable_scroll_reroute (self, _tmp6_);
					_g_object_unref0 (child);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
	_g_object_unref0 (container);
}

static gboolean
composer_embed_on_inner_scroll_event (ComposerEmbed* self,
                                      GdkEventScroll* event)
{
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_EMBED (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	ret = GDK_EVENT_STOP;
	if (event->direction == GDK_SCROLL_SMOOTH) {
		_tmp0_ = event->delta_y != 0.0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkAdjustment* adj = NULL;
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GtkAllocation alloc = {0};
		GtkAllocation _tmp5_ = {0};
		gdouble scroll_unit = 0.0;
		GtkAdjustment* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble scroll_delta = 0.0;
		gdouble initial_value = 0.0;
		GtkAdjustment* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp1_ = self->priv->outer_scroller;
		_tmp2_ = gtk_scrolled_window_get_vadjustment (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		adj = _tmp4_;
		gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp5_);
		alloc = _tmp5_;
		_tmp6_ = adj;
		_tmp7_ = gtk_adjustment_get_page_size (_tmp6_);
		_tmp8_ = _tmp7_;
		scroll_unit = pow (_tmp8_, 2.0 / 3.0);
		scroll_delta = event->delta_y * scroll_unit;
		_tmp9_ = adj;
		_tmp10_ = gtk_adjustment_get_value (_tmp9_);
		_tmp11_ = _tmp10_;
		initial_value = _tmp11_;
		if (event->delta_y > 0.0) {
			GtkAllocation _tmp12_;
			GtkAdjustment* _tmp13_;
			gdouble _tmp14_;
			gdouble _tmp15_;
			gdouble remainder_delta = 0.0;
			GtkAdjustment* _tmp22_;
			gdouble _tmp23_;
			gdouble _tmp24_;
			_tmp12_ = alloc;
			_tmp13_ = adj;
			_tmp14_ = gtk_adjustment_get_value (_tmp13_);
			_tmp15_ = _tmp14_;
			if (((gdouble) _tmp12_.y) > _tmp15_) {
				GtkAllocation _tmp16_;
				GtkAdjustment* _tmp17_;
				gdouble _tmp18_;
				gdouble _tmp19_;
				GtkScrolledWindow* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp16_ = alloc;
				_tmp17_ = adj;
				_tmp18_ = gtk_adjustment_get_value (_tmp17_);
				_tmp19_ = _tmp18_;
				event->delta_y = fmin (scroll_delta, _tmp16_.y - _tmp19_) / scroll_unit;
				_tmp20_ = self->priv->outer_scroller;
				g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), "scroll-event", event, &_tmp21_);
			}
			_tmp22_ = adj;
			_tmp23_ = gtk_adjustment_get_value (_tmp22_);
			_tmp24_ = _tmp23_;
			remainder_delta = scroll_delta - (_tmp24_ - initial_value);
			if (remainder_delta > 0.0001) {
				ComposerWebView* body = NULL;
				ComposerWidget* _tmp25_;
				ComposerWidget* _tmp26_;
				ComposerEditor* _tmp27_;
				ComposerEditor* _tmp28_;
				ComposerWebView* _tmp29_;
				ComposerWebView* _tmp30_;
				ComposerWebView* _tmp31_;
				gint editor_height = 0;
				ComposerWebView* _tmp32_;
				gint editor_preferred = 0;
				ComposerWebView* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint scrolled_height = 0;
				ComposerWebView* _tmp36_;
				gboolean _tmp37_ = FALSE;
				GtkAllocation _tmp38_;
				_tmp25_ = composer_container_get_composer (G_TYPE_CHECK_INSTANCE_CAST (self, COMPOSER_TYPE_CONTAINER, ComposerContainer));
				_tmp26_ = _tmp25_;
				_tmp27_ = composer_widget_get_editor (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = composer_editor_get_body (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				body = _tmp31_;
				_tmp32_ = body;
				editor_height = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
				_tmp33_ = body;
				_tmp34_ = components_web_view_get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
				_tmp35_ = _tmp34_;
				editor_preferred = _tmp35_;
				_tmp36_ = body;
				scrolled_height = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
				_tmp38_ = alloc;
				if (_tmp38_.height < scrolled_height) {
					_tmp37_ = editor_height < editor_preferred;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					gint editor_delta = 0;
					GtkAllocation _tmp39_;
					editor_delta = (gint) round (remainder_delta);
					_tmp39_ = alloc;
					if ((editor_delta + _tmp39_.height) > scrolled_height) {
						GtkAllocation _tmp40_;
						_tmp40_ = alloc;
						editor_delta = scrolled_height - _tmp40_.height;
					}
					if ((editor_delta + editor_height) > editor_preferred) {
						editor_delta = editor_preferred - editor_height;
					}
					remainder_delta -= (gdouble) editor_delta;
					gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), -1, gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) + editor_delta);
				} else {
					event->delta_y = remainder_delta / scroll_unit;
					ret = GDK_EVENT_PROPAGATE;
				}
				_g_object_unref0 (body);
			}
		} else {
			if (event->delta_y < 0.0) {
				gdouble alloc_bottom = 0.0;
				GtkAllocation _tmp41_;
				GtkAllocation _tmp42_;
				gdouble adj_bottom = 0.0;
				GtkAdjustment* _tmp43_;
				gdouble _tmp44_;
				gdouble _tmp45_;
				GtkAdjustment* _tmp46_;
				gdouble _tmp47_;
				gdouble _tmp48_;
				_tmp41_ = alloc;
				_tmp42_ = alloc;
				alloc_bottom = (gdouble) (_tmp41_.y + _tmp42_.height);
				_tmp43_ = adj;
				_tmp44_ = gtk_adjustment_get_value (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = adj;
				_tmp47_ = gtk_adjustment_get_page_size (_tmp46_);
				_tmp48_ = _tmp47_;
				adj_bottom = _tmp45_ + _tmp48_;
				if (alloc_bottom < adj_bottom) {
					GtkScrolledWindow* _tmp49_;
					gboolean _tmp50_ = FALSE;
					gdouble remainder_delta = 0.0;
					GtkAdjustment* _tmp51_;
					gdouble _tmp52_;
					gdouble _tmp53_;
					event->delta_y = fmax (scroll_delta, alloc_bottom - adj_bottom) / scroll_unit;
					_tmp49_ = self->priv->outer_scroller;
					g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget), "scroll-event", event, &_tmp50_);
					_tmp51_ = adj;
					_tmp52_ = gtk_adjustment_get_value (_tmp51_);
					_tmp53_ = _tmp52_;
					remainder_delta = scroll_delta - (_tmp53_ - initial_value);
					if (fabs (remainder_delta) > 0.0001) {
						event->delta_y = remainder_delta / scroll_unit;
						ret = GDK_EVENT_PROPAGATE;
					}
				} else {
					ret = GDK_EVENT_PROPAGATE;
				}
			}
		}
		_g_object_unref0 (adj);
	}
	result = ret;
	return result;
}

static void
composer_embed_class_init (ComposerEmbedClass * klass,
                           gpointer klass_data)
{
	composer_embed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerEmbed_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_embed_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_composer_embed_set_property;
	G_OBJECT_CLASS (klass)->finalize = composer_embed_finalize;
	/** The email this composer was originally a reply to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_EMBED_REFERRED_PROPERTY, composer_embed_properties[COMPOSER_EMBED_REFERRED_PROPERTY] = g_param_spec_object ("referred", "referred", "referred", GEARY_TYPE_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when the container is closed. */
	composer_embed_signals[COMPOSER_EMBED_VANISHED_SIGNAL] = g_signal_new ("vanished", COMPOSER_TYPE_EMBED, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "geary-composer-embed");
}

static void
composer_embed_composer_container_interface_init (ComposerContainerIface * iface,
                                                  gpointer iface_data)
{
	composer_embed_composer_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->close = (void (*) (ComposerContainer*)) composer_embed_real_close;
	iface->get_top_window = composer_embed_real_get_top_window;
	iface->get_composer = composer_embed_real_get_composer;
	iface->set_composer = composer_embed_real_set_composer;
}

static void
composer_embed_instance_init (ComposerEmbed * self,
                              gpointer klass)
{
	self->priv = composer_embed_get_instance_private (self);
}

static void
composer_embed_finalize (GObject * obj)
{
	ComposerEmbed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_TYPE_EMBED, ComposerEmbed);
	_g_object_unref0 (self->priv->_referred);
	_g_object_unref0 (self->priv->_composer);
	_g_object_unref0 (self->priv->outer_scroller);
	G_OBJECT_CLASS (composer_embed_parent_class)->finalize (obj);
}

/**
 * A container for full-height paned composers in the main window.
 *
 * Adding a composer to this container places it in {@link
 * Widget.PresentationMode.INLINE} or {@link
 * Widget.PresentationMode.INLINE_COMPACT} mode.
 */
static GType
composer_embed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerEmbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_embed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerEmbed), 0, (GInstanceInitFunc) composer_embed_instance_init, NULL };
	static const GInterfaceInfo composer_container_info = { (GInterfaceInitFunc) composer_embed_composer_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType composer_embed_type_id;
	composer_embed_type_id = g_type_register_static (gtk_event_box_get_type (), "ComposerEmbed", &g_define_type_info, 0);
	g_type_add_interface_static (composer_embed_type_id, COMPOSER_TYPE_CONTAINER, &composer_container_info);
	ComposerEmbed_private_offset = g_type_add_instance_private (composer_embed_type_id, sizeof (ComposerEmbedPrivate));
	return composer_embed_type_id;
}

GType
composer_embed_get_type (void)
{
	static volatile gsize composer_embed_type_id__once = 0;
	if (g_once_init_enter (&composer_embed_type_id__once)) {
		GType composer_embed_type_id;
		composer_embed_type_id = composer_embed_get_type_once ();
		g_once_init_leave (&composer_embed_type_id__once, composer_embed_type_id);
	}
	return composer_embed_type_id__once;
}

static void
_vala_composer_embed_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ComposerEmbed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EMBED, ComposerEmbed);
	switch (property_id) {
		case COMPOSER_EMBED_REFERRED_PROPERTY:
		g_value_set_object (value, composer_embed_get_referred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_composer_embed_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ComposerEmbed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_EMBED, ComposerEmbed);
	switch (property_id) {
		case COMPOSER_EMBED_REFERRED_PROPERTY:
		composer_embed_set_referred (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

