/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterConfig;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.SecuredRemoteAddressRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapperFactory;
import org.apache.wicket.util.lang.Generics;

public class FilterFactoryManager
implements Iterable<AbstractRequestWrapperFactory> {
    private List<AbstractRequestWrapperFactory> filters;

    public final FilterFactoryManager add(AbstractRequestWrapperFactory wrapperFactory) {
        if (wrapperFactory != null) {
            if (this.filters == null) {
                this.filters = Generics.newArrayList(2);
            }
            this.filters.add(wrapperFactory);
        }
        return this;
    }

    public final FilterFactoryManager addXForwardedRequestWrapperFactory(FilterConfig config) {
        if (config == null) {
            config = WebApplication.get().getWicketFilter().getFilterConfig();
        }
        XForwardedRequestWrapperFactory factory = new XForwardedRequestWrapperFactory();
        factory.init(config);
        return this.add(factory);
    }

    public final FilterFactoryManager addSecuredRemoteAddressRequestWrapperFactory(FilterConfig config) {
        if (config == null) {
            config = WebApplication.get().getWicketFilter().getFilterConfig();
        }
        SecuredRemoteAddressRequestWrapperFactory factory = new SecuredRemoteAddressRequestWrapperFactory();
        factory.init(config);
        return this.add(factory);
    }

    @Override
    public Iterator<AbstractRequestWrapperFactory> iterator() {
        return this.filters.iterator();
    }
}

