/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.util.tester;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.WebSocketPushBroadcaster;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.protocol.ws.util.tester.TestWebSocketProcessor;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.tester.WicketTester;

public class WebSocketTester {
    private final IWebSocketProcessor socketProcessor;

    public WebSocketTester(WicketTester wicketTester, Page page) {
        Args.notNull((Object)wicketTester, (String)"wicketTester");
        Args.notNull((Object)page, (String)"page");
        WebApplication webApplication = wicketTester.getApplication();
        if (webApplication.getWicketFilter().getFilterPath() == null) {
            webApplication.getWicketFilter().setFilterPath("");
        }
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get((Application)webApplication);
        webSocketSettings.setWebSocketPushMessageExecutor(new WebSocketSettings.SameThreadExecutor());
        this.socketProcessor = new TestWebSocketProcessor(wicketTester, page){

            @Override
            protected void onOutMessage(String message) {
                WebSocketTester.this.onOutMessage(message);
            }

            @Override
            protected void onOutMessage(byte[] message, int offset, int length) {
                WebSocketTester.this.onOutMessage(message, offset, length);
            }
        };
        this.socketProcessor.onOpen(null);
    }

    public WebSocketTester(WicketTester wicketTester, String resourceName) {
        Args.notNull((Object)wicketTester, (String)"wicketTester");
        Args.notNull((Object)resourceName, (String)"resourceName");
        WebApplication webApplication = wicketTester.getApplication();
        if (webApplication.getWicketFilter().getFilterPath() == null) {
            webApplication.getWicketFilter().setFilterPath("");
        }
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get((Application)webApplication);
        webSocketSettings.setWebSocketPushMessageExecutor(new WebSocketSettings.SameThreadExecutor());
        this.socketProcessor = new TestWebSocketProcessor(wicketTester, resourceName){

            @Override
            protected void onOutMessage(String message) {
                WebSocketTester.this.onOutMessage(message);
            }

            @Override
            protected void onOutMessage(byte[] message, int offset, int length) {
                WebSocketTester.this.onOutMessage(message, offset, length);
            }
        };
        this.socketProcessor.onOpen(null);
    }

    public void sendMessage(String message) {
        this.socketProcessor.onMessage(message);
    }

    public void sendMessage(byte[] message, int offset, int length) {
        this.socketProcessor.onMessage(message, offset, length);
    }

    public void broadcast(Application application, String sessionId, IKey key, IWebSocketPushMessage message) {
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(application);
        WebSocketPushBroadcaster broadcaster = new WebSocketPushBroadcaster(webSocketSettings.getConnectionRegistry());
        ConnectedMessage wsMessage = new ConnectedMessage(application, sessionId, key);
        broadcaster.broadcast(wsMessage, message);
    }

    public void broadcastAll(Application application, IWebSocketPushMessage message) {
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get(application);
        WebSocketPushBroadcaster broadcaster = new WebSocketPushBroadcaster(webSocketSettings.getConnectionRegistry());
        broadcaster.broadcastAll(application, message);
    }

    public void destroy() {
        this.socketProcessor.onClose(0, "Closed by WebSocketTester");
    }

    protected void onOutMessage(String message) {
    }

    protected void onOutMessage(byte[] message, int offset, int length) {
    }
}

