/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.proxy.IProxyFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.bytebuddy.ByteBuddyProxyFactory;
import org.apache.wicket.proxy.jdk.JdkProxyFactory;
import org.apache.wicket.util.io.IClusterable;

public class LazyInitProxyFactory {
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Boolean.TYPE, Boolean.class);
    private static final IProxyFactory JDK_PROXY_FACTORY = new JdkProxyFactory();
    private static final IProxyFactory CLASS_PROXY_FACTORY = new ByteBuddyProxyFactory();

    public static <T> T createProxy(Class<T> type, IProxyTargetLocator locator) {
        if (PRIMITIVES.contains(type) || Enum.class.isAssignableFrom(type)) {
            return locator.locateProxyTarget();
        }
        if (type.isInterface()) {
            return JDK_PROXY_FACTORY.createProxy(type, locator);
        }
        return CLASS_PROXY_FACTORY.createProxy(type, locator);
    }

    public static boolean isEqualsMethod(Method method) {
        return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && method.getName().equals("equals");
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0 && method.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(Method method) {
        return method.getReturnType() == String.class && method.getParameterTypes().length == 0 && method.getName().equals("toString");
    }

    public static boolean isFinalizeMethod(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && method.getName().equals("finalize");
    }

    public static boolean isWriteReplaceMethod(Method method) {
        return method.getReturnType() == Object.class && method.getParameterTypes().length == 0 && method.getName().equals("writeReplace");
    }

    public static final class ProxyReplacement
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String type;

        public ProxyReplacement(String type, IProxyTargetLocator locator) {
            this.type = type;
            this.locator = locator;
        }

        private Object readResolve() throws ObjectStreamException {
            Class<?> clazz = WicketObjects.resolveClass((String)this.type);
            if (clazz == null) {
                try {
                    clazz = Class.forName(this.type, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ignored1) {
                    try {
                        clazz = Class.forName(this.type, false, LazyInitProxyFactory.class.getClassLoader());
                    }
                    catch (ClassNotFoundException ignored2) {
                        ClassNotFoundException cause = new ClassNotFoundException("Could not resolve type [" + this.type + "] with the currently configured org.apache.wicket.application.IClassResolver");
                        throw new WicketRuntimeException((Throwable)cause);
                    }
                }
            }
            return LazyInitProxyFactory.createProxy(clazz, this.locator);
        }
    }

    public static interface IWriteReplace {
        public Object writeReplace() throws ObjectStreamException;
    }
}

