/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DateDistanceFeatureQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.DistanceFeatureQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDistanceFeatureQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.UntypedDistanceFeatureQuery;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DistanceFeatureQuery
implements TaggedUnion<Kind, DistanceFeatureQueryVariant>,
QueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final DistanceFeatureQueryVariant _value;
    public static final JsonpDeserializer<DistanceFeatureQuery> _DESERIALIZER = JsonpDeserializer.lazy(DistanceFeatureQuery::buildDistanceFeatureQueryDeserializer);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.DistanceFeature;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final DistanceFeatureQueryVariant _get() {
        return this._value;
    }

    public DistanceFeatureQuery(DistanceFeatureQueryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._distanceFeatureQueryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private DistanceFeatureQuery(Kind kind, DistanceFeatureQueryVariant value) {
        this._kind = kind;
        this._value = value;
    }

    private DistanceFeatureQuery(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DistanceFeatureQuery of(Function<Builder, ObjectBuilder<DistanceFeatureQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public DateDistanceFeatureQuery date() {
        return (DateDistanceFeatureQuery)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isGeo() {
        return this._kind == Kind.Geo;
    }

    public GeoDistanceFeatureQuery geo() {
        return (GeoDistanceFeatureQuery)TaggedUnionUtils.get(this, Kind.Geo);
    }

    public boolean isUntyped() {
        return this._kind == Kind.Untyped;
    }

    public UntypedDistanceFeatureQuery untyped() {
        return (UntypedDistanceFeatureQuery)TaggedUnionUtils.get(this, Kind.Untyped);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize((Object)this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<DistanceFeatureQuery> buildDistanceFeatureQueryDeserializer() {
        return new UnionDeserializer.Builder(DistanceFeatureQuery::new, false).addMember((Object)Kind.Untyped, UntypedDistanceFeatureQuery._DESERIALIZER).build();
    }

    public static enum Kind implements JsonEnum
    {
        Date("date"),
        Geo("geo"),
        Untyped("untyped");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DistanceFeatureQuery> {
        private Kind _kind;
        private DistanceFeatureQueryVariant _value;

        public ObjectBuilder<DistanceFeatureQuery> date(DateDistanceFeatureQuery v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DistanceFeatureQuery> date(Function<DateDistanceFeatureQuery.Builder, ObjectBuilder<DateDistanceFeatureQuery>> fn) {
            return this.date(fn.apply(new DateDistanceFeatureQuery.Builder()).build());
        }

        public ObjectBuilder<DistanceFeatureQuery> geo(GeoDistanceFeatureQuery v) {
            this._kind = Kind.Geo;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DistanceFeatureQuery> geo(Function<GeoDistanceFeatureQuery.Builder, ObjectBuilder<GeoDistanceFeatureQuery>> fn) {
            return this.geo(fn.apply(new GeoDistanceFeatureQuery.Builder()).build());
        }

        public ObjectBuilder<DistanceFeatureQuery> untyped(UntypedDistanceFeatureQuery v) {
            this._kind = Kind.Untyped;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DistanceFeatureQuery> untyped(Function<UntypedDistanceFeatureQuery.Builder, ObjectBuilder<UntypedDistanceFeatureQuery>> fn) {
            return this.untyped(fn.apply(new UntypedDistanceFeatureQuery.Builder()).build());
        }

        @Override
        public DistanceFeatureQuery build() {
            this._checkSingleUse();
            return new DistanceFeatureQuery(this);
        }
    }
}

