/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SearchTransform
implements TransformVariant,
JsonpSerializable {
    private final SearchInputRequestDefinition request;
    private final Time timeout;
    public static final JsonpDeserializer<SearchTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchTransform::setupSearchTransformDeserializer);

    private SearchTransform(Builder builder) {
        this.request = ApiTypeHelper.requireNonNull(builder.request, this, "request");
        this.timeout = ApiTypeHelper.requireNonNull(builder.timeout, this, "timeout");
    }

    public static SearchTransform of(Function<Builder, ObjectBuilder<SearchTransform>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Transform.Kind _transformKind() {
        return Transform.Kind.Search;
    }

    public final SearchInputRequestDefinition request() {
        return this.request;
    }

    public final Time timeout() {
        return this.timeout;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        generator.writeKey("timeout");
        this.timeout.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupSearchTransformDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::request, SearchInputRequestDefinition._DESERIALIZER, "request");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchTransform> {
        private SearchInputRequestDefinition request;
        private Time timeout;

        public final Builder request(SearchInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<SearchInputRequestDefinition.Builder, ObjectBuilder<SearchInputRequestDefinition>> fn) {
            return this.request(fn.apply(new SearchInputRequestDefinition.Builder()).build());
        }

        public final Builder timeout(Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchTransform build() {
            this._checkSingleUse();
            return new SearchTransform(this);
        }
    }
}

