/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldSortNumericType;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldSort
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final SortMode mode;
    @Nullable
    private final NestedSortValue nested;
    @Nullable
    private final SortOrder order;
    @Nullable
    private final FieldType unmappedType;
    @Nullable
    private final FieldSortNumericType numericType;
    @Nullable
    private final String format;
    public static final JsonpDeserializer<FieldSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSort::setupFieldSortDeserializer);

    private FieldSort(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.missing = builder.missing;
        this.mode = builder.mode;
        this.nested = builder.nested;
        this.order = builder.order;
        this.unmappedType = builder.unmappedType;
        this.numericType = builder.numericType;
        this.format = builder.format;
    }

    public static FieldSort of(Function<Builder, ObjectBuilder<FieldSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Nullable
    public final NestedSortValue nested() {
        return this.nested;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nullable
    public final FieldType unmappedType() {
        return this.unmappedType;
    }

    @Nullable
    public final FieldSortNumericType numericType() {
        return this.numericType;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.nested != null) {
            generator.writeKey("nested");
            this.nested.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.unmappedType != null) {
            generator.writeKey("unmapped_type");
            this.unmappedType.serialize(generator, mapper);
        }
        if (this.numericType != null) {
            generator.writeKey("numeric_type");
            this.numericType.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupFieldSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
        op.add(Builder::nested, NestedSortValue._DESERIALIZER, "nested");
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::unmappedType, (JsonpDeserializer)FieldType._DESERIALIZER, "unmapped_type");
        op.add(Builder::numericType, FieldSortNumericType._DESERIALIZER, "numeric_type");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("order");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldSort> {
        private String field;
        @Nullable
        private FieldValue missing;
        @Nullable
        private SortMode mode;
        @Nullable
        private NestedSortValue nested;
        @Nullable
        private SortOrder order;
        @Nullable
        private FieldType unmappedType;
        @Nullable
        private FieldSortNumericType numericType;
        @Nullable
        private String format;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missing(String value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(long value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(double value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(boolean value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        public final Builder nested(@Nullable NestedSortValue value) {
            this.nested = value;
            return this;
        }

        public final Builder nested(Function<NestedSortValue.Builder, ObjectBuilder<NestedSortValue>> fn) {
            return this.nested(fn.apply(new NestedSortValue.Builder()).build());
        }

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder unmappedType(@Nullable FieldType value) {
            this.unmappedType = value;
            return this;
        }

        public final Builder numericType(@Nullable FieldSortNumericType value) {
            this.numericType = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldSort build() {
            this._checkSingleUse();
            return new FieldSort(this);
        }
    }
}

