/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal.converter;

import org.apache.felix.webconsole.plugins.event.internal.EventInfo;
import org.osgi.framework.BundleEvent;

public class BundleEventConverter {
    public static final String TOPIC = BundleEvent.class.getName().replace('.', '/');

    public static EventInfo getInfo(BundleEvent event) {
        if (event == null) {
            return null;
        }
        StringBuffer topic = new StringBuffer(TOPIC);
        topic.append('/');
        StringBuffer buffer = new StringBuffer("Bundle ");
        buffer.append(event.getBundle().getSymbolicName());
        buffer.append(' ');
        switch (event.getType()) {
            case 1: {
                buffer.append("installed");
                topic.append("INSTALLED");
                break;
            }
            case 32: {
                buffer.append("resolved");
                topic.append("RESOLVED");
                break;
            }
            case 2: {
                buffer.append("started");
                topic.append("STARTED");
                break;
            }
            case 128: {
                buffer.append("starting");
                topic.append("STARTED");
                break;
            }
            case 4: {
                buffer.append("stopped");
                topic.append("STOPPED");
                break;
            }
            case 256: {
                buffer.append("stopping");
                topic.append("STOPPING");
                break;
            }
            case 16: {
                buffer.append("uninstalled");
                topic.append("UNINSTALLED");
                break;
            }
            case 64: {
                buffer.append("unresolved");
                topic.append("UNRESOLVED");
                break;
            }
            case 8: {
                buffer.append("updated");
                topic.append("UPDATED");
                break;
            }
            default: {
                return null;
            }
        }
        return new EventInfo(topic.toString(), buffer.toString(), "bundle");
    }
}

