/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class DataTable {
    List<Row> rows = new ArrayList<Row>();
    int maxColumns = 0;
    public static final EmptyCell EMPTY_CELL = new EmptyCell();

    public List<Row> getRows() {
        return this.rows;
    }

    public void addRow(Comparable ... rowData) {
        if (rowData == null) {
            return;
        }
        if (rowData.length > this.maxColumns) {
            this.maxColumns = rowData.length;
        }
        Row row = new Row();
        for (Comparable dataObject : rowData) {
            row.addData(dataObject);
        }
        this.rows.add(row);
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void sort(final SortCriteria ... sortCriterias) {
        this.rows.sort(new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                for (int i = 0; i < sortCriterias.length; ++i) {
                    Comparable row1Data = row1.getData(sortCriterias[i].columnIndex);
                    Comparable row2Data = row2.getData(sortCriterias[i].columnIndex);
                    if (row1Data == EMPTY_CELL && row2Data != EMPTY_CELL) {
                        if (sortCriterias[i].sortOrder == SortOrder.ASCENDING) {
                            return -1;
                        }
                        return 1;
                    }
                    if (row2Data == EMPTY_CELL && row1Data != EMPTY_CELL) {
                        if (sortCriterias[i].sortOrder == SortOrder.ASCENDING) {
                            return 1;
                        }
                        return -1;
                    }
                    int rowComparison = row1Data.compareTo(row2Data);
                    if (rowComparison == 0) {
                        if (i < sortCriterias.length) {
                            continue;
                        }
                        return 0;
                    }
                    if (sortCriterias[i].sortOrder == SortOrder.ASCENDING) {
                        return rowComparison;
                    }
                    return -rowComparison;
                }
                return 0;
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.rows);
        sb.append(']');
        return sb.toString();
    }

    public String toCSV(String ... headers) {
        StringBuilder stringBuilder = new StringBuilder();
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        if (headers != null && headers.length > 0) {
            csvFormat = CSVFormat.DEFAULT.withHeader(headers);
        }
        try {
            CSVPrinter printer = csvFormat.print((Appendable)stringBuilder);
            for (Row row : this.rows) {
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < this.maxColumns; ++i) {
                    values.add(row.getData(i).toString());
                }
                printer.printRecord((Object[])values.toArray(new String[values.size()]));
            }
            printer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public class Row {
        List<Comparable> rowData = new ArrayList<Comparable>();

        public void addData(Comparable data) {
            this.rowData.add(data);
        }

        public Comparable getData(int index) {
            if (index >= DataTable.this.maxColumns) {
                throw new ArrayIndexOutOfBoundsException("Index on row data (" + index + ") is larger than max columns (" + DataTable.this.maxColumns + ")");
            }
            if (index >= this.rowData.size()) {
                return EMPTY_CELL;
            }
            return this.rowData.get(index);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.rowData);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class SortCriteria {
        Integer columnIndex;
        SortOrder sortOrder;

        public SortCriteria(Integer columnIndex, SortOrder sortOrder) {
            this.columnIndex = columnIndex;
            this.sortOrder = sortOrder;
        }
    }

    public static class EmptyCell
    implements Comparable {
        public int compareTo(Object o) {
            if (o instanceof EmptyCell) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "";
        }
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

