/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.MutableRecordBatch;

class ByteBufferLogInputStream
implements LogInputStream<MutableRecordBatch> {
    private final ByteBuffer buffer;
    private final int maxMessageSize;

    ByteBufferLogInputStream(ByteBuffer buffer, int maxMessageSize) {
        this.buffer = buffer;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public MutableRecordBatch nextBatch() throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining < 12) {
            return null;
        }
        int recordSize = this.buffer.getInt(this.buffer.position() + 8);
        if (recordSize < 14) {
            throw new CorruptRecordException(String.format("Record size is less than the minimum record overhead (%d)", 14));
        }
        if (recordSize > this.maxMessageSize) {
            throw new CorruptRecordException(String.format("Record size exceeds the largest allowable message size (%d).", this.maxMessageSize));
        }
        int batchSize = recordSize + 12;
        if (remaining < batchSize) {
            return null;
        }
        byte magic = this.buffer.get(this.buffer.position() + 16);
        ByteBuffer batchSlice = this.buffer.slice();
        batchSlice.limit(batchSize);
        this.buffer.position(this.buffer.position() + batchSize);
        if (magic < 0 || magic > 2) {
            throw new CorruptRecordException("Invalid magic found in record: " + magic);
        }
        if (magic > 1) {
            return new DefaultRecordBatch(batchSlice);
        }
        return new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(batchSlice);
    }
}

