/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.util.EnumSet;
import java.util.Locale;

public enum OperationMode {
    STOPPED{

        @Override
        public boolean isValidChange(OperationMode nextMode) {
            return nextMode == RUNNING;
        }
    }
    ,
    STOPPING{

        @Override
        public boolean isValidChange(OperationMode nextMode) {
            return nextMode == RUNNING || nextMode == STOPPED;
        }
    }
    ,
    RUNNING{

        @Override
        public boolean isValidChange(OperationMode nextMode) {
            return nextMode == STOPPING;
        }
    };


    public abstract boolean isValidChange(OperationMode var1);

    static OperationMode fromString(String string) {
        return EnumSet.allOf(OperationMode.class).stream().filter(e -> string.equalsIgnoreCase(e.name())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(Locale.ROOT, "%s is not a valid operation_mode", string)));
    }
}

